/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_freq_sink_c = R"doc(A graphical sink to display multiple signals in frequency.

This is a QT-based graphical sink the takes set of a complex streams and plots the PSD. Each signal is plotted with a different color, and the  and  functions can be used to change the label and color for a given input number.


The sink supports plotting streaming complex data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Complex Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of complex 32 values (pmt::is_c32vector) or PDUs where the data is a uniform vector of complex 32 values.


Message Ports:

Constructor Specific Documentation:

Build a complex PSD sink.

Args:
    fftsize : size of the FFT to compute and display. If using the PDU message port to plot samples, the length of each PDU must be a multiple of the FFT size.
    wintype : type of window to apply (see gr::fft::window::win_type). By setting bit 16 to one, this block will normalize the window before applying it. This allows switching between windows without sacrificing signal power due to tapering, but it will also amplify some samples. See also set_fft_window_normalized().
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals to be connected to the sink. The PDU message port is always available for a connection, and this value must be set to 0 if only the PDU message port is being used.
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_freq_sink_c_freq_sink_c_0 = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_freq_sink_c_1 = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_make = R"doc(A graphical sink to display multiple signals in frequency.

This is a QT-based graphical sink the takes set of a complex streams and plots the PSD. Each signal is plotted with a different color, and the  and  functions can be used to change the label and color for a given input number.


The sink supports plotting streaming complex data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Complex Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of complex 32 values (pmt::is_c32vector) or PDUs where the data is a uniform vector of complex 32 values.


Message Ports:

Constructor Specific Documentation:

Build a complex PSD sink.

Args:
    fftsize : size of the FFT to compute and display. If using the PDU message port to plot samples, the length of each PDU must be a multiple of the FFT size.
    wintype : type of window to apply (see gr::fft::window::win_type). By setting bit 16 to one, this block will normalize the window before applying it. This allows switching between windows without sacrificing signal power due to tapering, but it will also amplify some samples. See also set_fft_window_normalized().
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    nconnections : number of signals to be connected to the sink. The PDU message port is always available for a connection, and this value must be set to 0 if only the PDU message port is being used.
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_freq_sink_c_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_fft_average = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_fft_average = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_fft_window = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_fft_window = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_fft_window_normalized = R"doc(If true, normalize window to unit power.)doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_frequency_range = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_title = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_y_label = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_trigger_mode = R"doc(Set up a trigger for the sink to know when to start plotting. Useful to isolate events and avoid noise.


The trigger modes are Free, Auto, Normal, and Tag (see gr::qtgui::trigger_mode). The first three are like a normal trigger function. Free means free running with no trigger, auto will trigger if the trigger event is seen, but will still plot otherwise, and normal will hold until the trigger event is observed. The Tag trigger mode allows us to trigger off a specific stream tag. The tag trigger is based only on the name of the tag, so when a tag of the given name is seen, the trigger is activated.


In auto and normal mode, we look to see if the magnitude of the any FFT point is over the set level.)doc";


static const char* __doc_gr_qtgui_freq_sink_c_title = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_control_panel = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_max_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_min_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_clear_max_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_clear_min_hold = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_reset = R"doc()doc";


static const char* __doc_gr_qtgui_freq_sink_c_enable_axis_labels = R"doc()doc";
