/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_fir_filter = R"doc(RFNoC FIR Filter Block

Constructor Specific Documentation:



Args:
    graph : Reference to the rfnoc_graph object this block is attached to
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";


static const char* __doc_gr_uhd_rfnoc_fir_filter_make = R"doc(RFNoC FIR Filter Block

Constructor Specific Documentation:



Args:
    graph : Reference to the rfnoc_graph object this block is attached to
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";


static const char* __doc_gr_uhd_rfnoc_fir_filter_set_coefficients = R"doc(Set the FIR Filter coefficients)doc";


static const char* __doc_gr_uhd_rfnoc_fir_filter_get_max_num_coefficients = R"doc(Get the number of FIR Filter coefficients)doc";


static const char* __doc_gr_uhd_rfnoc_fir_filter_get_coefficients = R"doc(Returns a vector of FIR Filter coefficients)doc";
