/*
 * Copyright 2021 Marcus Müller
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_rx_streamer = R"doc(RFNoC Rx Streamer: Block to handle data flow from an RFNoC flow graph into a GNU Radio flow graph.


Use this block for ingress into a GNU Radio flow graph. \"Rx\" is from the viewpoint of the GNU Radio flow graph. For example, if the GNU Radio flow graph is receiving samples from a radio, use this block to transport the samples into GNU Radio.


Note: The input ports of this block can only connect to other RFNoC blocks.

Constructor Specific Documentation:



Args:
    graph : Reference to the graph this block is connected to
    num_chans : Number of input- and output ports
    stream_args : These will be passed on to rfnoc_graph::create_rx_streamer, see that for details. The cpu_format and otw_format parts of these args will be used to determine the in- and output signatures of this block.
    vlen : Vector length
    issue_stream_cmd_on_start : If true, the streamer sends a stream command upstream.
    start_time_set : If true, set start time spec to the stream command
    start_time : The time spec for the stream command if start_time_set is true)doc";


static const char* __doc_gr_uhd_rfnoc_rx_streamer_rfnoc_rx_streamer_0 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_rx_streamer_rfnoc_rx_streamer_1 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_rx_streamer_make = R"doc(RFNoC Rx Streamer: Block to handle data flow from an RFNoC flow graph into a GNU Radio flow graph.


Use this block for ingress into a GNU Radio flow graph. \"Rx\" is from the viewpoint of the GNU Radio flow graph. For example, if the GNU Radio flow graph is receiving samples from a radio, use this block to transport the samples into GNU Radio.


Note: The input ports of this block can only connect to other RFNoC blocks.

Constructor Specific Documentation:



Args:
    graph : Reference to the graph this block is connected to
    num_chans : Number of input- and output ports
    stream_args : These will be passed on to rfnoc_graph::create_rx_streamer, see that for details. The cpu_format and otw_format parts of these args will be used to determine the in- and output signatures of this block.
    vlen : Vector length
    issue_stream_cmd_on_start : If true, the streamer sends a stream command upstream.
    start_time_set : If true, set start time spec to the stream command
    start_time : The time spec for the stream command if start_time_set is true)doc";


static const char* __doc_gr_uhd_rfnoc_rx_streamer_get_unique_id = R"doc(Return the unique ID associated with the underlying RFNoC streamer.)doc";
