/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 27 "/build/gpm/src/gpm/src/prog/gpm-root.y"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/syslog.h>
#include <signal.h>         /* sigaction() */
#include <pwd.h>            /* pwd entries */
#include <grp.h>            /* initgroups() */
#include <sys/kd.h>         /* KDGETMODE */
#include <sys/stat.h>       /* fstat() */
#include <sys/utsname.h>    /* uname() */
#include <termios.h>        /* winsize */
#include <linux/vt.h>       /* VT_ACTIVATE */
#include <linux/keyboard.h> /* K_SHIFT */
#include <utmp.h>         
#include <endian.h>

#ifdef HAVE_SYS_SYSMACROS_H
#include <sys/sysmacros.h>
#else
#define major(dev) (((unsigned) (dev))>>8)
#define minor(dev) ((dev)&0xff)
#endif


#define GPM_NULL_DEV "/dev/null"

#ifdef HAVE_LINUX_MAJOR_H
#include <linux/major.h>
#else
#define VCS_MAJOR	7
#endif

#define MAX_NR_USER_CONSOLES 63 /* <linux/tty.h> needs __KERNEL__ */

#include "headers/message.h"
#include "headers/gpm.h"

#ifdef DEBUG
#define YYDEBUG 1
#else
#undef YYDEBUG
#endif

#define USER_CFG   ".gpm-root"
#define SYSTEM_CFG SYSCONFDIR "/gpm-root.conf"

#define DEFAULT_FORE 7
#define DEFAULT_BACK 0
#define DEFAULT_BORD 7
#define DEFAULT_HEAD 7

/* These macros are useful to avoid curses. The program is unportable anyway */
#define GOTOXY(f,x,y)   fprintf(f,"\x1B[%03i;%03iH",y,x)
#define FORECOLOR(f,c)  fprintf(f,"\x1B[%i;3%cm",(c)&8?1:22,colLut[(c)&7]+'0') 
#define BACKCOLOR(f,c)  fprintf(f,"\x1B[4%cm",colLut[(c)&7]+'0') 

/* These defines are ugly hacks but work */
#define ULCORNER 0xc9
#define URCORNER 0xbb
#define LLCORNER 0xc8 
#define LRCORNER 0xbc
#define HORLINE  0xcd
#define VERLINE  0xba

int colLut[]={0,4,2,6,1,5,3,7};

char *prgname;
char *consolename;
int run_status  = GPM_RUN_STARTUP;
struct winsize win;
int disallocFlag=0;
struct node {char *name; int flag;};

struct node  tableMod[]= {
   {"shift",    1<<KG_SHIFT},
   {"anyAlt",   1<<KG_ALT | 1<<KG_ALTGR},
   {"leftAlt",  1<<KG_ALT},
   {"rightAlt", 1<<KG_ALTGR},
   {"control",  1<<KG_CTRL},
   {NULL,0}
};

   /* provide defaults */
int opt_mod     =  4;           /* control */
int opt_buf     =  0;           /* ask the kernel about it */
int opt_user    =  1;           /* allow user cfg files */



typedef struct DrawItem {
   short type;
   short pad;
   char *name;
   char *arg;   /* a cmd string */
   void *clientdata;  /* a (Draw *) for menus or whatever   */
   int (*fun)();
   struct DrawItem *next;
} DrawItem;

typedef struct Draw {
   short width;               /* length of longest item */
   short height;              /* the number of items */
   short uid;                 /* owner */
   short buttons;             /* which button */
   short fore,back,bord,head; /* colors */
   char *title;               /* name */
   time_t mtime;              /* timestamp of source file */
   DrawItem *menu;            /* the list of items */
   struct Draw *next;         /* chain */
} Draw;

typedef struct Posted {
   short x,y,X,Y;
   Draw *draw;
   unsigned char *dump;
   short colorcell;
   struct Posted *prev;
} Posted;

Draw *drawList=NULL;

/* support functions and vars */
int yyerror(char *s);
int yylex(void);

DrawItem *cfg_cat(DrawItem *, DrawItem *);
DrawItem *cfg_makeitem(int mode, char *msg, int(*fun)(), void *detail);


/*===================================================================*
 * This part of the source is devoted to reading the cfg file
 */

char cfgname[256];
FILE *cfgfile=NULL;
int cfglineno=0;
Draw *cfgcurrent, *cfgall;

Draw *cfg_alloc(void);

/* prototypes for predefined functions */

enum F_call {F_CREATE, F_POST, F_INVOKE, F_DONE};
int f_debug(int mode, DrawItem *self, int uid);
int f_bgcmd(int mode, DrawItem *self, int uid);
int f_fgcmd(int mode, DrawItem *self, int uid);
int f_jptty(int mode, DrawItem *self, int uid);
int f_mktty(int mode, DrawItem *self, int uid);
int f_menu(int mode, DrawItem *self, int uid);
int f_lock(int mode, DrawItem *self, int uid);
int f_load(int mode, DrawItem *self, int uid);
int f_free(int mode, DrawItem *self, int uid);
int f_time(int mode, DrawItem *self, int uid);
int f_pipe(int mode, DrawItem *self, int uid);


#line 237 "y.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    T_STRING = 258,                /* T_STRING  */
    T_BACK = 259,                  /* T_BACK  */
    T_FORE = 260,                  /* T_FORE  */
    T_BORD = 261,                  /* T_BORD  */
    T_HEAD = 262,                  /* T_HEAD  */
    T_BRIGHT = 263,                /* T_BRIGHT  */
    T_COLOR = 264,                 /* T_COLOR  */
    T_NAME = 265,                  /* T_NAME  */
    T_BUTTON = 266,                /* T_BUTTON  */
    T_FUNC = 267,                  /* T_FUNC  */
    T_FUN2 = 268                   /* T_FUN2  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define T_STRING 258
#define T_BACK 259
#define T_FORE 260
#define T_BORD 261
#define T_HEAD 262
#define T_BRIGHT 263
#define T_COLOR 264
#define T_NAME 265
#define T_BUTTON 266
#define T_FUNC 267
#define T_FUN2 268

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 193 "/build/gpm/src/gpm/src/prog/gpm-root.y"

      int silly;
      char *string;
      Draw *draw;
      DrawItem *item;
      int (*fun)();
      

#line 322 "y.tab.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_STRING = 3,                   /* T_STRING  */
  YYSYMBOL_T_BACK = 4,                     /* T_BACK  */
  YYSYMBOL_T_FORE = 5,                     /* T_FORE  */
  YYSYMBOL_T_BORD = 6,                     /* T_BORD  */
  YYSYMBOL_T_HEAD = 7,                     /* T_HEAD  */
  YYSYMBOL_T_BRIGHT = 8,                   /* T_BRIGHT  */
  YYSYMBOL_T_COLOR = 9,                    /* T_COLOR  */
  YYSYMBOL_T_NAME = 10,                    /* T_NAME  */
  YYSYMBOL_T_BUTTON = 11,                  /* T_BUTTON  */
  YYSYMBOL_T_FUNC = 12,                    /* T_FUNC  */
  YYSYMBOL_T_FUN2 = 13,                    /* T_FUN2  */
  YYSYMBOL_14_1_ = 14,                     /* '1'  */
  YYSYMBOL_15_2_ = 15,                     /* '2'  */
  YYSYMBOL_16_3_ = 16,                     /* '3'  */
  YYSYMBOL_17_ = 17,                       /* '{'  */
  YYSYMBOL_18_ = 18,                       /* '}'  */
  YYSYMBOL_YYACCEPT = 19,                  /* $accept  */
  YYSYMBOL_file = 20,                      /* file  */
  YYSYMBOL_button = 21,                    /* button  */
  YYSYMBOL_menu = 22,                      /* menu  */
  YYSYMBOL_23_1 = 23,                      /* @1  */
  YYSYMBOL_configs = 24,                   /* configs  */
  YYSYMBOL_cfgpair = 25,                   /* cfgpair  */
  YYSYMBOL_bright = 26,                    /* bright  */
  YYSYMBOL_itemlist = 27,                  /* itemlist  */
  YYSYMBOL_items = 28,                     /* items  */
  YYSYMBOL_item = 29                       /* item  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   29

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  19
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  11
/* YYNRULES -- Number of rules.  */
#define YYNRULES  23
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  37

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   268


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    14,
      15,    16,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    17,     2,    18,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint8 yyrline[] =
{
       0,   212,   212,   213,   216,   217,   218,   221,   221,   225,
     225,   227,   228,   229,   230,   231,   234,   234,   236,   238,
     239,   242,   243,   244
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "T_STRING", "T_BACK",
  "T_FORE", "T_BORD", "T_HEAD", "T_BRIGHT", "T_COLOR", "T_NAME",
  "T_BUTTON", "T_FUNC", "T_FUN2", "'1'", "'2'", "'3'", "'{'", "'}'",
  "$accept", "file", "button", "menu", "@1", "configs", "cfgpair",
  "bright", "itemlist", "items", "item", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-10)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
     -10,     0,   -10,     1,    -5,   -10,   -10,   -10,   -10,   -10,
     -10,    -2,    -3,     4,    10,    10,    10,    16,   -10,     2,
     -10,   -10,    18,   -10,   -10,   -10,    13,    14,    15,   -10,
     -10,    22,   -10,   -10,   -10,   -10,   -10
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     1,     0,     0,     4,     5,     6,     7,     3,
       9,     0,     0,     0,    16,    16,    16,     0,    10,     0,
      19,    21,     0,    23,    12,    17,     0,     0,     0,    11,
       8,    18,    22,    13,    14,    15,    20
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -10,   -10,   -10,    17,   -10,   -10,   -10,    -9,   -10,   -10,
      -4
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     1,     4,     9,    10,    11,    18,    26,    19,    31,
      20
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
       2,    12,    13,    14,    15,    16,    27,    28,    17,    21,
      22,     3,     8,    24,     8,     5,     6,     7,    25,    29,
      30,    32,    33,    34,    35,    12,     0,    36,     0,    23
};

static const yytype_int8 yycheck[] =
{
       0,     3,     4,     5,     6,     7,    15,    16,    10,    12,
      13,    11,    17,     9,    17,    14,    15,    16,     8,     3,
      18,     3,     9,     9,     9,     3,    -1,    31,    -1,    12
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    20,     0,    11,    21,    14,    15,    16,    17,    22,
      23,    24,     3,     4,     5,     6,     7,    10,    25,    27,
      29,    12,    13,    22,     9,     8,    26,    26,    26,     3,
      18,    28,     3,     9,     9,     9,    29
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    19,    20,    20,    21,    21,    21,    23,    22,    24,
      24,    25,    25,    25,    25,    25,    26,    26,    27,    28,
      28,    29,    29,    29
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     3,     2,     2,     2,     0,     5,     0,
       2,     2,     2,     3,     3,     3,     0,     1,     2,     0,
       2,     2,     3,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* file: %empty  */
#line 212 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                {(yyval.draw)=cfgall=NULL;}
#line 1341 "y.tab.c"
    break;

  case 3: /* file: file button menu  */
#line 213 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                              {(yyvsp[0].draw)->buttons=(yyvsp[-1].silly); (yyvsp[0].draw)->next=(yyvsp[-2].draw); (yyval.draw)=cfgall=(yyvsp[0].draw);}
#line 1347 "y.tab.c"
    break;

  case 4: /* button: T_BUTTON '1'  */
#line 216 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                     {(yyval.silly)=GPM_B_LEFT;}
#line 1353 "y.tab.c"
    break;

  case 5: /* button: T_BUTTON '2'  */
#line 217 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                        {(yyval.silly)=GPM_B_MIDDLE;}
#line 1359 "y.tab.c"
    break;

  case 6: /* button: T_BUTTON '3'  */
#line 218 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                        {(yyval.silly)=GPM_B_RIGHT;}
#line 1365 "y.tab.c"
    break;

  case 7: /* @1: %empty  */
#line 221 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                {(yyval.draw)=cfgcurrent=cfg_alloc();}
#line 1371 "y.tab.c"
    break;

  case 8: /* menu: '{' @1 configs itemlist '}'  */
#line 222 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                {(yyval.draw)=(yyvsp[-3].draw); (yyval.draw)->menu=(yyvsp[-1].item);}
#line 1377 "y.tab.c"
    break;

  case 11: /* cfgpair: T_NAME T_STRING  */
#line 227 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                 {cfgcurrent->title=(yyvsp[0].string);}
#line 1383 "y.tab.c"
    break;

  case 12: /* cfgpair: T_BACK T_COLOR  */
#line 228 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                 {cfgcurrent->back=(yyvsp[0].silly);}
#line 1389 "y.tab.c"
    break;

  case 13: /* cfgpair: T_FORE bright T_COLOR  */
#line 229 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                 {cfgcurrent->fore=(yyvsp[0].silly)|(yyvsp[-1].silly);}
#line 1395 "y.tab.c"
    break;

  case 14: /* cfgpair: T_BORD bright T_COLOR  */
#line 230 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                 {cfgcurrent->bord=(yyvsp[0].silly)|(yyvsp[-1].silly);}
#line 1401 "y.tab.c"
    break;

  case 15: /* cfgpair: T_HEAD bright T_COLOR  */
#line 231 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                 {cfgcurrent->head=(yyvsp[0].silly)|(yyvsp[-1].silly);}
#line 1407 "y.tab.c"
    break;

  case 16: /* bright: %empty  */
#line 234 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                    {(yyval.silly)=0;}
#line 1413 "y.tab.c"
    break;

  case 17: /* bright: T_BRIGHT  */
#line 234 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                       {(yyval.silly)=8;}
#line 1419 "y.tab.c"
    break;

  case 18: /* itemlist: item items  */
#line 236 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                      {(yyval.item)=cfg_cat((yyvsp[-1].item),(yyvsp[0].item));}
#line 1425 "y.tab.c"
    break;

  case 19: /* items: %empty  */
#line 238 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                   {(yyval.item)=NULL;}
#line 1431 "y.tab.c"
    break;

  case 20: /* items: items item  */
#line 239 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                   {(yyval.item)= (yyvsp[-1].item) ? cfg_cat((yyvsp[-1].item),(yyvsp[0].item)) : (yyvsp[0].item);}
#line 1437 "y.tab.c"
    break;

  case 21: /* item: T_STRING T_FUNC  */
#line 242 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                  {(yyval.item)=cfg_makeitem('F',(yyvsp[-1].string),(yyvsp[0].fun), NULL);}
#line 1443 "y.tab.c"
    break;

  case 22: /* item: T_STRING T_FUN2 T_STRING  */
#line 243 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                    {(yyval.item)=cfg_makeitem('2',(yyvsp[-2].string),(yyvsp[-1].fun), (yyvsp[0].string));}
#line 1449 "y.tab.c"
    break;

  case 23: /* item: T_STRING menu  */
#line 244 "/build/gpm/src/gpm/src/prog/gpm-root.y"
                                    {(yyval.item)=cfg_makeitem('M',(yyvsp[-1].string),NULL,(yyvsp[0].draw));}
#line 1455 "y.tab.c"
    break;


#line 1459 "y.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 247 "/build/gpm/src/gpm/src/prog/gpm-root.y"
 /* end grammar ###########################################################*/

int yyerror(char *s)
{
   fprintf(stderr,"%s:%s(%i): %s\n",prgname,cfgname,cfglineno,s);
   return 1;
}

int yywrap()
{
   return 1;
}

struct tokenName {
   char *name;
   int token;
   int value;
   };
struct tokenName tokenList[] = {
   {"foreground",T_FORE,0},
   {"background",T_BACK,0},
   {"border",    T_BORD,0},
   {"head",      T_HEAD,0},
   {"name",      T_NAME,0},
   {"button",    T_BUTTON,0},
   {"black",     T_COLOR,0},
   {"blue",      T_COLOR,1},
   {"green",     T_COLOR,2},
   {"cyan",      T_COLOR,3},
   {"red",       T_COLOR,4},
   {"magenta",   T_COLOR,5},
   {"yellow",    T_COLOR,6},
   {"white",     T_COLOR,7},
   {"bright",    T_BRIGHT,0},
   {NULL,0,0}
   };

struct funcName {
   char *name;
   int token;
   int (*fun)();
   };
struct funcName funcList[] = {
   {"f.debug",T_FUNC,f_debug},
   {"f.fgcmd",T_FUN2,f_fgcmd},
   {"f.bgcmd",T_FUN2,f_bgcmd},
   {"f.jptty",T_FUN2,f_jptty},
   {"f.mktty",T_FUNC,f_mktty},
   {"f.menu",T_FUNC,f_menu},
   {"f.lock",T_FUN2,f_lock}, /* "lock one", "lock all" */
   {"f.load",T_FUNC,f_load},
   {"f.free",T_FUNC,f_free},
   {"f.time",T_FUNC,f_time},
   {"f.pipe",T_FUN2,f_pipe},
   {"f.nop",T_FUNC,NULL},
   {NULL,0,NULL}
};

/*---------------------------------------------------------------------*/
int yylex(void)
{
   int c,i;
   char s[80];
   struct tokenName *tn;
   struct funcName *fn;

   while(1) {
      i=0;
      switch(c=getc(cfgfile)) {
         case EOF: fclose(cfgfile); return 0;
         case '\"':
            do {
               s[i]=getc(cfgfile);
               if ((s[i])=='\n') {
                  yyerror("unterminated string");
                  cfglineno++;
               }
               if (s[i]=='\\') s[i]=getc(cfgfile);
            } /* get '"' as '\"' */ while (s[i++]!='\"' && s[i-2] !='\\') ;
            s[i-1]=0;
            yylval.string=(char *)strdup(s);
            return T_STRING;

         case '#': while ( (c=getc(cfgfile)!='\n') && c!=EOF) ;
         case '\n': cfglineno++;
         case ' ': /* fall through */
         case '\t': continue;
         default: if (!isalpha(c)) return(c);
      }
      /* get a single word and convert it */
      do {
         s[i++]=c;
      } while (isalnum(c=getc(cfgfile)) || c=='.');
      ungetc(c,cfgfile);
      s[i]=0;
      for (tn=tokenList; tn->name; tn++)
         if (tn->name[0]==s[0] && !strcmp(tn->name,s)) {
            yylval.silly=tn->value; 
            return tn->token;
         }
      for (fn=funcList; fn->name; fn++)
         if (fn->name[0]==s[0] && !strcmp(fn->name,s)) {
            yylval.fun=fn->fun; 
            return fn->token;
         }
      yylval.string=(char *)strdup(s); return T_STRING;
   }
} 

/*---------------------------------------------------------------------*/
void cfg_free(Draw *what)
{
   Draw *ptr;
   DrawItem *item;

   for (ptr=what; ptr; ptr=ptr->next) {
      if (ptr->title) free(ptr->title);
      for (item=ptr->menu; item; item=item->next) {
         if (item->name) free(item->name);
         if (item->arg) free(item->arg);
         if (item->type=='M' && item->clientdata) {
            ((Draw *)(item->clientdata))->next=NULL; /* redundant */
            cfg_free(item->clientdata);
         }
         if (item->clientdata) free(item->clientdata);
      }
   }
}

/*---------------------------------------------------------------------*/
/* malloc an empty Draw */
Draw *cfg_alloc(void)
{
   Draw *new=calloc(1,sizeof(Draw));

   if (!new) return NULL;
   new->back=DEFAULT_BACK;
   new->fore=DEFAULT_FORE;
   new->bord=DEFAULT_BORD;
   new->head=DEFAULT_HEAD;

   return new;
}

/*---------------------------------------------------------------------*/
/* malloc an empty DrawItem and fill it */
DrawItem *cfg_makeitem(int mode, char *msg, int(*fun)(), void *detail)
{
   DrawItem *new=calloc(1,sizeof(DrawItem));

   if (!new) return NULL;

   new->name=(char *)strdup(msg);
   new->type=mode;
   switch(mode) {
      case '2': /* a function with one arg */
         new->arg=(char *)strdup(detail);
         /* fall through */

      case 'F': /* a function without args */
         new->fun=fun;
         if (fun) fun(F_CREATE,new);
         break;

      case 'M':
         new->clientdata=detail;
         new->fun=f_menu;
         break;

      default: fprintf(stderr,"%s: unknown item type (can't happen)\n",prgname);
   }

   return new;
}

/*---------------------------------------------------------------------*/
/* concatenate two item lists */
DrawItem *cfg_cat(DrawItem *d1, DrawItem *d2)
{
   DrawItem *tmp;

   for (tmp=d1; tmp->next; tmp=tmp->next) ;
   tmp->next=d2;
   return d1;
}

/*====================================================================*/
void f__fix(struct passwd *pass)
{
   if (setgid(pass->pw_gid) < 0 ||
       initgroups(pass->pw_name, pass->pw_gid) < 0 ||
       setuid(pass->pw_uid) < 0)
   exit(1);
   setenv("HOME",    pass->pw_dir, 1);
   setenv("LOGNAME", pass->pw_name,1);
   setenv("USER",    pass->pw_name,1);
}

/*---------------------------------------------------------------------*/
#if 0
static int f_debug_one(FILE *f, Draw *draw)
{
   DrawItem *ip;
   static int tc=0;
   int i;

#define LINE(args) for(i=0;i<tc;i++) putc('\t',f); fprintf args

   LINE((f,"BUTT %i - %ix%i\n",draw->buttons,draw->width,draw->height));
   LINE((f,"UID %i\n",draw->uid));
   LINE((f,"fore %i - back %i\n",draw->fore,draw->back));
   LINE((f,"bord %i - head %i\n",draw->bord,draw->head));
   LINE((f,"---> \"%s\" %li\n",draw->title,(long)(draw->mtime)));
   for (ip=draw->menu; ip; ip=ip->next) {
      LINE((f,"    %i \"%s\" (%p)\n",ip->type,ip->name,ip->fun));
      if (ip->fun == f_menu) {
         tc++; f_debug_one(f,(Draw *)ip->clientdata); tc--;
      }
   }
#undef LINE
   return 0;
}
#endif

int f_debug(int mode, DrawItem *self, int uid)
{
#if 0 /* Disabled on account of security concerns; the way 
       * "/tmp/root-debug" is used is gratuitously
       * open to symlink abuse */

   FILE *f;
   Draw *dp;

   switch (mode) {
      case F_POST:
         if (!(f=fopen("/tmp/root-debug","a"))) return 1;
         for(dp=drawList; dp; dp=dp->next)
	         f_debug_one(f,dp);
         fprintf(f,"\n\n");
         fclose(f);

      case F_CREATE:
      case F_INVOKE:
         break;
      }
#endif /* 0 */
   return 0;
}


/*---------------------------------------------------------------------*/
int f_fgcmd(int mode, DrawItem *self, int uid)
{
   switch (mode) {
      case F_CREATE:
      case F_POST: break;
      case F_INVOKE: ; /* MISS */
   }
   return 0;
}

/*---------------------------------------------------------------------*/
int f_bgcmd(int mode, DrawItem *self, int uid)
{
   int i;
   struct passwd *pass;

   switch (mode) {
      case F_CREATE:
      case F_POST: break;
      case F_INVOKE:
         switch(fork()) {
	         case -1:
               gpm_report(GPM_PR_ERR, "fork(): %s", strerror(errno));
               return 1;
	         case 0:
	            pass=getpwuid(uid);
	            if (!pass) exit(1);
	            f__fix(pass); /* setgid(), setuid(), setenv(), ... */
	            close(0); close(1); close(2);
	            open("/dev/null",O_RDONLY); /* stdin  */
	            open(consolename,O_WRONLY); /* stdout */
	            dup(1);                     /* stderr */  
		    int open_max = sysconf(_SC_OPEN_MAX);
		    if (open_max == -1) open_max = 1024;
	            for (i=3;i<open_max; i++) close(i);
	            execl("/bin/sh","sh","-c",self->arg,(char *)NULL);
	            exit(1); /* shouldn't happen */
	         default: return 0;

	      }
   }
   return 0;
}
/*---------------------------------------------------------------------*/
int f_jptty(int mode, DrawItem *self, int uid)
{
   int i,fd;

   switch (mode) {
      case F_CREATE:
      case F_POST: break;
      case F_INVOKE:
         i=atoi(self->arg);
         fd=open(consolename,O_RDWR);
         if (fd<0) {
            gpm_report(GPM_PR_ERR, "%s: %s",consolename, strerror(errno));
            return 1;
         } /*if*/
         if (ioctl(fd, VT_ACTIVATE, i)<0) {
            gpm_report(GPM_PR_ERR, "%s: %s", consolename,strerror(errno));
            return 1;
         } /*if*/
         if (ioctl(fd, VT_WAITACTIVE, i)<0) {
            gpm_report(GPM_PR_ERR, "%s: %s", consolename,strerror(errno));
            return 1;
         }
      default: return 0;
   }
   return 0; /* silly gcc -Wall */
}

/*---------------------------------------------------------------------*/
/* This array registers spawned consoles */
static int consolepids[1+MAX_NR_USER_CONSOLES];

int f_mktty(int mode, DrawItem *self, int uid)
{
   int fd, pid;
   int vc;
   char name[10];
   switch (mode) {
      case F_CREATE: self->arg=malloc(8);
      case F_POST: break;
      case F_INVOKE:
         fd=open(consolename,O_RDWR);
         if (fd<0) {
            gpm_report(GPM_PR_ERR,"%s: %s",consolename, strerror(errno));
            return 1;
         } /*if*/
         if (ioctl(fd, VT_OPENQRY, &vc)<0) {
            gpm_report(GPM_PR_ERR, "%s: %s",consolename, strerror(errno));
            return 1;
         } /*if*/
         switch(pid=fork()) {
	         case -1:
               gpm_report(GPM_PR_ERR, "fork(): %s", strerror(errno));
               return 1;
	         case 0: /* child: exec getty */
	            sprintf(name,"tty%i",vc);
	            execl("/sbin/mingetty","mingetty",name,(char *)NULL);
	            exit(1); /* shouldn't happen */
            default: /* father: jump to the tty */
               gpm_report(GPM_PR_INFO,"Registering child %i on console %i"
                                                                      ,pid,vc);
	            consolepids[vc]=pid;
	            sprintf(self->arg,"%i",vc);
	            return f_jptty(mode,self,uid);
	      }
      default: return 0;
   }
   return 0;
}

/*---------------------------------------------------------------------*/
int f_menu(int mode, DrawItem *self, int uid)
{
   return 0; /* just a placeholder, recursion is performed in main() */  
}

/*---------------------------------------------------------------------*/
int f_lock(int mode, DrawItem *self, int uid)
{
#if 0 /* some kind of interesting ...: if never */
   int all;
   static DrawItem msg = {
      0,
      10,
      "Enter your password to unlock",
      NULL, NULL, NULL, NULL
   };
   static Draw


   switch (mode) {
      case F_CREATE: /* either "one" or anything else */
         if (strcmp(self->arg,"one")) self->arg[0]='a';
      case F_POST: break;
      case F_INVOKE: /* the biggest of all... */
   }

#endif
   return 0;
}

/*---------------------------------------------------------------------*/
int f_load(int mode, DrawItem *self, int uid)
{
   FILE *f;
   double l1,l2,l3;

   l1=l2=l3=0.0;

   switch (mode) {
      case F_CREATE: /* modify name, just to fake its length */
         self->clientdata=malloc(strlen(self->name)+20);
         self->name=realloc(self->name,strlen(self->name)+20);
         strcpy(self->clientdata,self->name);
         strcat(self->clientdata," %5.2f %5.2f %5.2f");
         sprintf(self->name,self->clientdata,l1,l2,l3);
         break;

      case F_POST:
         if (!(f=fopen("/proc/loadavg","r"))) return 1;
         fscanf(f,"%lf %lf %lf",&l1,&l2,&l3);
         sprintf(self->name,self->clientdata,l1,l2,l3);
         fclose(f);

      case F_INVOKE: break;
   }
   return 0;
}

/*---------------------------------------------------------------------*/
int f_free(int mode, DrawItem *self, int uid)
{
   FILE *f;
   long l1,l2;
   char s[80];

   l1=l2=0;
   switch (mode) {
      case F_CREATE: /* modify name, just to fake its length */
         self->clientdata=malloc(strlen(self->name)+30);
         self->name=realloc(self->name,strlen(self->name)+30);
         strcpy(self->clientdata,self->name);
         strcat(self->clientdata," %5.2fM mem + %5.2fM swap");
         sprintf(self->name,self->clientdata,(double)l1,(double)l2);
         break;

      case F_POST:
         if (!(f=fopen("/proc/meminfo","r"))) return 1;
         fgets(s,80,f);
         fgets(s,80,f); sscanf(s,"%*s %*s %*s %li",&l1);
         fgets(s,80,f); sscanf(s,"%*s %*s %*s %li",&l2);
         sprintf(self->name,self->clientdata,
	      (double)l1/1024/1024,(double)l2/1024/1024);
         fclose(f);

      case F_INVOKE: break;
   }
   return 0;
}

/*---------------------------------------------------------------------*/
int f_time(int mode, DrawItem *self, int uid) {
   char s[128];
   struct tm *broken;
   time_t t;

   time(&t); broken=localtime(&t);
   switch (mode) {
      case F_CREATE: /* modify name, just to fake its length */
         self->clientdata=self->name;
         strftime(s,110,self->clientdata,broken);
         strcat(s,"1234567890"); /* names can change length */       
         self->name=(char *)strdup(s);
         /* rewrite the right string */
         strftime(self->name,110,self->clientdata,broken);
         break;

      case F_POST: strftime(self->name,120,self->clientdata,broken);
      case F_INVOKE: break;
   }
   return 0;
}

/*---------------------------------------------------------------------*/
int f_pipe(int mode, DrawItem *self, int uid)
{
   return 0;
}

/*====================================================================*/
int fixone(Draw *ptr, int uid)
{
   int hei,wid;
   DrawItem *item;

   ptr->uid=uid;
   hei=0; wid= ptr->title? strlen(ptr->title)+2 : 0;

   /* calculate width and height */
   for (item=ptr->menu; item; item=item->next) {
      hei++;
      wid= wid > strlen(item->name) ? wid : strlen(item->name);
   }
   ptr->height=hei+2;
   ptr->width=wid+2;

   /* fix paddings and recurse */
   for (item=ptr->menu; item; item=item->next) {
      item->pad=(ptr->width-strlen(item->name ? item->name : ""))/2;
      if (item->fun==f_menu) fixone((Draw *)item->clientdata,uid);
   }
   return 0;
}


/* read menus from a file, and return a list or NULL */
Draw *cfg_read(int uid)
{
   Draw *ptr;

   if (!(cfgfile=fopen(cfgname,"r"))) {
         gpm_report(GPM_PR_ERR, "%s: %s", cfgname, strerror(errno));
         return NULL;
   }
   gpm_report(GPM_PR_INFO,"Reading file %s",cfgname);
   cfglineno=1;
   if (yyparse()) {
         cfg_free(cfgall);
         cfgall=NULL;
         return NULL;
   }

   /* handle recursion */
   for (ptr=cfgall; ptr; ptr=ptr->next) {
      fixone(ptr,uid);
   }

   return cfgall;
}


/*---------------------------------------------------------------------*/
/* the return value tells whether it has been newly loaded or not */
int getdraw(int uid, int buttons, time_t mtime1, time_t mtime2)
{
   struct passwd *pass;
   struct stat buf;
   Draw *new, *np, *op, *pp;
   int retval=0;
   time_t mtime;

   gpm_report(GPM_PR_DEBUG,"getdraw: %i %i %li %li",uid,buttons,mtime1,mtime2);
   pass=getpwuid(uid);

   /* deny personal cfg to root for security reasons */
   if (pass==NULL || !uid || !opt_user) {
      mtime=mtime2; uid=-1;
      strcpy(cfgname,SYSTEM_CFG);
   } else {
      mtime=mtime1;
      strcpy(cfgname,pass->pw_dir);
      strcat(cfgname,"/" USER_CFG);
   }

   if (stat(cfgname,&buf)==-1) {
      gpm_report(GPM_PR_DEBUG,"stat (%s) failed",cfgname);
      /* try the system wide */
      mtime=mtime2; uid = -1;
      strcpy(cfgname,SYSTEM_CFG);
      if (stat(cfgname,&buf)==-1) {
         gpm_report(GPM_PR_ERR,"stat (%s) failed",cfgname);
         return 0;
      }
   }

   if (buf.st_mtime <= mtime) return 0;
  
   /* else, read the new drawing tree */
   new=cfg_read(uid);
   if (!new) return 0;

   /* scan old data to remove duplicates */
   for (np=pp=new; np; pp=np, np=np->next) {
      np->mtime=buf.st_mtime;
      if (np->buttons==buttons) retval++;
      for (op=drawList; op; op=op->next)
         if (op->uid==np->uid && op->buttons==np->buttons)
            op->buttons=0; /* mark for deletion */
      }

   /* chain in */
   pp->next=drawList; drawList=new;

   /* actually remove fake entries */
   for (np=drawList; np; pp=np, np=np->next)
      if (!np->buttons) {
         pp->next=np->next;
         np->next=NULL;
         cfg_free(np);
         np=pp;
      }
   return retval; /* found or not */
}


/*---------------------------------------------------------------------*/
Draw *retrievedraw(int uid, int buttons)
{
   Draw *drawPtr, *genericPtr=NULL;

   /* retrieve a drawing by scanning the list */
   do {
      for (drawPtr=drawList; drawPtr; drawPtr=drawPtr->next) {
         if (drawPtr->uid==uid && drawPtr->buttons==buttons) break;
         if (drawPtr->uid==-1 && drawPtr->buttons==buttons) genericPtr=drawPtr;
      }
   } while (getdraw(uid,buttons,
		 drawPtr ? drawPtr->mtime : 0,
		 genericPtr ? genericPtr->mtime :0));


   return drawPtr ? drawPtr : genericPtr;
}


/*=====================================================================*/
int usage(void)
{
   printf( GPM_MESS_VERSION "\n"
         "Usage: %s [options]\n",prgname);
   printf("  Valid options are\n"
         "    -m <number-or-name>   modifier to use\n"
         "    -u                    inhibit user configuration files\n"
         "    -D                    don't auto-background and run as daemon\n"
         "    -V <verbosity-delta>  increase amount of logged messages\n"
         );

   return 1;
}

/*------------*/
int getmask(char *arg, struct node *table)
{
   int last=0, value=0;
   char *cur;
   struct node *n;

   if (isdigit(arg[0])) return atoi(arg);

   while (1) {
      while (*arg && !isalnum(*arg)) arg++; /* skip delimiters */
      cur=arg;
      while(isalnum(*cur)) cur++; /* scan the word */
      if (!*cur) last++;
      *cur=0;

      for (n=table;n->name;n++)
         if (!strcmp(n->name,arg)) {
            value |= n->flag;
            break;
         }
         if(!n->name) fprintf(stderr,"%s: Incorrect flag \"%s\"\n",prgname,arg);
         if (last) break;
         cur++; arg=cur;
      }

   return value;
}

/*------------*/
int cmdline(int argc, char **argv)
{
   int opt;
  
   run_status = GPM_RUN_STARTUP;
   while ((opt = getopt(argc, argv,"m:uDV::")) != -1) {
         switch (opt) {
            case 'm':  opt_mod=getmask(optarg, tableMod); break;
            case 'u':  opt_user=0; break;
            case 'D':  run_status = GPM_RUN_DEBUG; break;
            case 'V':
               /*gpm_debug_level += (0==optarg ? 1 : strtol(optarg,0,0)); */
               break;
            default:   return 1;
         }

   }
   return 0;
}



/*------------*
 * This buffer is passed to set_selection, and the only meaningful value
 * is the last one, which is the mode: 4 means "clear_selection".
 * however, the byte just before the 1th short must be 2 which denotes
 * the selection-related stuff in ioctl(TIOCLINUX).
 */

static unsigned short clear_sel_args[6]={0, 0,0, 0,0, 4};
static unsigned char *clear_sel_arg= (unsigned char *)clear_sel_args+1;

/*------------*/
static inline void scr_dump(int fd, FILE *f, unsigned char *buffer, int vc)
{
   int dumpfd;
   char dumpname[20];

   sprintf(dumpname,"/dev/vcsa%i",vc);
   dumpfd=open(dumpname,O_RDONLY);
   if (dumpfd<0) {
      gpm_report(GPM_PR_ERR,"%s: %s", dumpname, strerror(errno));
      return;
   } /*if*/
   clear_sel_arg[0]=2;  /* clear_selection */
   ioctl(fd,TIOCLINUX,clear_sel_arg);
   read(dumpfd,buffer,4);
   read(dumpfd,buffer+4,2*buffer[0]*buffer[1]);
   close(dumpfd);
}

/*------------*/
static inline void scr_restore(int fd, FILE *f, unsigned char *buffer, int vc)
{
   int dumpfd;
   char dumpname[20];
   
   /* WILL NOT WORK WITH DEVFS! FIXME! */
   sprintf(dumpname,"/dev/vcsa%i",vc);
   dumpfd=open(dumpname,O_WRONLY);
   if (dumpfd<0) {
      gpm_report(GPM_PR_ERR,"%s: %s", dumpname, strerror(errno));
      return;
   } /*if*/
   clear_sel_arg[0]=2;  /* clear_selection */
   ioctl(fd,TIOCLINUX,clear_sel_arg);
   write(dumpfd,buffer,4+2*buffer[0]*buffer[1]);
   close(dumpfd);
}

/*===================================================================*/
/* post and unpost menus from the screen */
static int postcount;
static Posted *activemenu;

#if __BYTE_ORDER == __BIG_ENDIAN
#define bigendian 1
#else
#define bigendian 0
#endif

Posted *postmenu(int fd, FILE *f, Draw *draw, int x, int y, int console)
{
   Posted *new;
   DrawItem *item;
   unsigned char *dump;
   unsigned char *curr, *curr2;
   int i;
   short lines,columns;

   new=calloc(1,sizeof(Posted));
   if (!new) return NULL;
   new->draw=draw;
   new->dump=dump=malloc(opt_buf);
   scr_dump(fd,f,dump,console);
   lines=dump[0]; columns=dump[1];
   i=(columns*dump[3]+dump[2])*2+1; /* where to get it */
   if (i<0) i=1;
   new->colorcell=dump[4+i-bigendian];
   gpm_report(GPM_PR_DEBUG,"Colorcell=%02x (at %i,%i = %i)",
                new->colorcell,dump[2],dump[3],i-bigendian);

   /* place the box relative to the mouse */
   if (!postcount) x -= draw->width/2; else x+=2;
   y++;

   /* fit inside the screen */
   if (x<1) x=1;
   if (x+draw->width >= columns) x=columns-1-draw->width;
   if (y+draw->height > lines+1) y=lines+1-draw->height;
   new->x=x; new->X=x+draw->width-1;
   new->y=y; new->Y=y+draw->height-1;

   /* these definitions are dirty hacks, but they help in writing to the screen */
#if __BYTE_ORDER == __BIG_ENDIAN
#define PUTC(c,f,b)   (*(curr++)=((b)<<4)+(f),*(curr++)=(c))
#else
#define PUTC(c,f,b)   (*(curr++)=(c),*(curr++)=((b)<<4)+(f))
#endif
#define PUTS(s,f,b)   for(curr2=s;*curr2;PUTC(*(curr2++),f,b))
#define GOTO(x,y)     (curr=dump+4+2*((y)*columns+(x)))

   x--; y--; /* /dev/vcs is zero based */
   ioctl(fd,TCXONC,TCOOFF); /* inhibit further prints */
   dump=malloc(opt_buf);
   memcpy(dump,new->dump,opt_buf); /* dup the buffer */
   /* top border */
   GOTO(x,y);
   PUTC(ULCORNER,draw->bord,draw->back);
   for (i=0; i<draw->width; i++) PUTC(HORLINE,draw->bord,draw->back);
   PUTC(URCORNER,draw->bord,draw->back);
   if (draw->title) {
         GOTO(x+(draw->width-strlen(draw->title))/2,y);
         PUTC(' ',draw->head,draw->back);
         PUTS(draw->title,draw->head,draw->back);
         PUTC(' ',draw->head,draw->back);
   }
   /* sides and items */
   for (item=draw->menu; y++, item; item=item->next) {
         if (item->fun) (*(item->fun))(F_POST,item);
         GOTO(x,y); PUTC(VERLINE,draw->bord,draw->back);
         for (i=0;i<item->pad;i++) PUTC(' ',draw->fore,draw->back);
         PUTS(item->name,draw->fore,draw->back); i+=strlen(item->name);
         while (i++<draw->width) PUTC(' ',draw->fore,draw->back);
         PUTC(VERLINE,draw->bord,draw->back);
   }
   /* bottom border */
   GOTO(x,y);
   PUTC(LLCORNER,draw->bord,draw->back);
   for (i=0; i<draw->width; i++) PUTC(HORLINE,draw->bord,draw->back);
   PUTC(LRCORNER,draw->bord,draw->back);

   scr_restore(fd,f,dump,console);
   free(dump);

#undef PUTC
#undef PUTS
#undef GOTO

   new->prev=activemenu;
   activemenu=new;
   postcount++;
   return new;
}

Posted *unpostmenu(int fd, FILE *f, Posted *which, int vc)
{
   Posted *prev=which->prev;

   scr_restore(fd,f,which->dump, vc);
   ioctl(fd,TCXONC,TCOON); /* activate the console */  
   free(which->dump);
   free(which);
   activemenu=prev;
   postcount--;
   return prev;
}


void reap_children(int signo)
{
   int i, pid;
   pid=wait(&i);
   gpm_report(GPM_PR_INFO,"pid %i exited %i",pid,i);

   if (disallocFlag)
      gpm_report(GPM_PR_INFO,"Warning, overriding logout from %i",disallocFlag);
   for (i=1;i<=MAX_NR_USER_CONSOLES; i++)
      if (consolepids[i]==pid) {
         disallocFlag=i;
         consolepids[i]=0;
         gpm_report(GPM_PR_INFO,"Registering disallocation of console %i",i);
         break;
      }
}


void get_winsize(void)
{
   int fd;

   if ((fd=open(consolename,O_RDONLY))<0) {
         fprintf(stderr,"%s: ",prgname); perror(consolename);
         exit(1);
   }
   ioctl(fd, TIOCGWINSZ, &win);
   opt_buf=win.ws_col*win.ws_row;
   close(fd);

   opt_buf +=4; /* 2:size, 1:terminator, 1:alignment */
   opt_buf*=2; /* the new scrdump and /dev/vcsa returns color info as well */
}


/*===================================================================*/
static int do_resize=0;
#if defined(__GLIBC__)
__sighandler_t winchHandler(int errno);
#else /* __GLIBC__ */
void winchHandler(int errno);
#endif /* __GLIBC__ */

int main(int argc, char **argv)
{
   Gpm_Connect conn;
   Gpm_Event ev;
   int vc, fd=-1 ,uid=-1;
   FILE *f=NULL;
   struct stat stbuf;
   Draw *draw=NULL;
   DrawItem *item;
   char s[80];
   int posty = 0, postx, postX;
   struct sigaction childaction;
   int evflag;
   int recursenow=0; /* not on first iteration */

   prgname=argv[0];
   consolename = Gpm_get_console();
   setuid(0); /* if we're setuid, force it */

   if (getuid()) {
         fprintf(stderr,"%s: Must be root\n", prgname);
         exit(1);
   }

   /*
   * Now, first of all we need to check that /dev/vcs is there.
   * But only if the kernel is new enough. vcs appeared in 1.1.82.
   * If an actual open fails, a message on syslog will be issued.
   */
   {
      struct utsname linux_info;
      int v1,v2,v3;
      struct stat sbuf;

      if (uname(&linux_info)) {
         fprintf(stderr,"%s: uname(): %s\n",prgname,strerror(errno));
         exit(1);
      }
      sscanf(linux_info.release,"%d.%d.%d",&v1,&v2,&v3);
      if (v1*1000000 + v2*1000 +v3 < 1001082) {
         fprintf(stderr,"%s: can't run with linux < 1.1.82\n",prgname);
         exit(1);
      }
      
      /* problems with devfs! FIXME! */
      if (stat("/dev/vcs0",&sbuf)<0 && stat("/dev/vcs",&sbuf)<0) {
         fprintf(stderr,"%s: /dev/vcs0: %s\n",prgname,strerror(errno));
         fprintf(stderr,"%s: do you have vcs devices? Refer to the manpage\n",
                prgname);
         exit(1);
      } else if (!S_ISCHR(sbuf.st_mode) ||
             VCS_MAJOR != major(sbuf.st_rdev) ||
             0 != minor(sbuf.st_rdev)) {
         fprintf(stderr,"Your /dev/vcs device looks funny\n");
         fprintf(stderr,"Refer to the manpage and possibly run the"
                        "create_vcs script in gpm source directory\n");
         exit(1);
      }
   }

   if (cmdline(argc,argv)) exit(usage());

   openlog(prgname, LOG_PID|LOG_CONS, run_status == GPM_RUN_DAEMON ?
                                                        LOG_DAEMON : LOG_USER);
   /* reap your zombies */
   childaction.sa_handler=reap_children;
   sigemptyset(&childaction.sa_mask);
   childaction.sa_flags=0;
   sigaction(SIGCHLD,&childaction,NULL);

   /*....................................... Connect and get your buffer */

   conn.eventMask=GPM_DOWN;
   conn.defaultMask=GPM_MOVE; /* only ctrl-move gets the default */
   conn.maxMod=conn.minMod=opt_mod;

   gpm_zerobased=1;

   for (vc=4; vc-->0;)
      {
         extern int gpm_tried; /* liblow.c */
         gpm_tried=0; /* to enable retryings */
         if (Gpm_Open(&conn,-1)!=-1)
            break;
         if (vc)
            sleep(2);
      }
   if (!vc)
      {
         gpm_report(GPM_PR_OOPS,"can't open mouse connection");
      }

   conn.eventMask=~0; /* grab everything away form selection */
   conn.defaultMask=GPM_MOVE & GPM_HARD;
   conn.minMod=0;
   conn.maxMod=~0;

   chdir("/");


   get_winsize();

   /*....................................... Go to background */

   if (run_status != GPM_RUN_DEBUG) {
      switch(fork()) {
         case -1: gpm_report(GPM_PR_OOPS,"fork()");                  /* error  */
         case  0: run_status = GPM_RUN_DAEMON; break; /* child  */
         default: _exit(0);                           /* parent */
      }

      /* redirect stderr to /dev/console -- avoided now. 
         we should really cleans this more up! */
      fclose(stdin); fclose(stdout);
      if (!freopen(GPM_NULL_DEV,"w",stderr)) {
            gpm_report(GPM_PR_OOPS,"freopen(stderr)");
      }
      if (setsid()<0)
            gpm_report(GPM_PR_OOPS,"setsid()");

   } /*if*/

   /*....................................... Loop */

   while((evflag=Gpm_GetEvent(&ev))!=0)
      {
         if (do_resize) {get_winsize(); do_resize--;}

         if (disallocFlag)
            {
          struct utmp *uu;
          struct utmp u;
          char s[8];
          int i=0;
          
          gpm_report(GPM_PR_INFO,"Disallocating %i",disallocFlag);
          ioctl(fileno(stdin),VT_DISALLOCATE,&i); /* all of them */
          
          sprintf(s,"tty%i",disallocFlag);
          setutent();
          strncpy(u.ut_line, s, sizeof(u.ut_line));
          if ((uu = getutline(&u)) != 0)
            {
              uu->ut_type = DEAD_PROCESS ;
              pututline(uu);
            }
          disallocFlag=0;
            }

         if (evflag==-1) continue; /* no real event */

         /* get rid of spurious events */
         if (ev.type&GPM_MOVE) continue; 

         vc=ev.vc;
         gpm_report(GPM_PR_DEBUG,"%s: event on console %i at %i, %i",
                    prgname,ev.vc,ev.x,ev.y);

         if (!recursenow) /* don't open on recursion */
            {
          sprintf(s,"/dev/tty%i",ev.vc);
          if (stat(s,&stbuf)==-1) continue;
          uid = stbuf.st_uid;
          gpm_report(GPM_PR_DEBUG,"uid = %i",uid);

          draw=retrievedraw(uid,ev.buttons);
          if (!draw) continue;

          if (stat(s,&stbuf)==-1 || !(f=fopen(s,"r+"))) /* used to draw */
            {
              gpm_report(GPM_PR_ERR, "%s: %s", s, strerror(errno));
              continue;
            }
          
          if ((fd=open(s,O_RDWR))<0) /* will O_RDONLY be enough? */
            {
              gpm_report(GPM_PR_ERR, "%s: %s", s, strerror(errno));
              exit(1);
            }

          /* now change your connection information and manage the console */
          Gpm_Open(&conn,-1);
          uid=stbuf.st_uid;
            }

         /* the task now is drawing the box from user data */
         if (!draw)
            {
          /* itz Thu Jul  2 00:02:53 PDT 1998 this cannot happen, see
             continue statement above?!? */
          gpm_report(GPM_PR_ERR,"NULL menu ptr while drawing");
          continue;
            }
         postmenu(fd,f,draw,ev.x,ev.y,vc);

         while(Gpm_GetEvent(&ev)>0 && ev.vc==vc)
            {
          Gpm_FitEvent(&ev);
          if (ev.type&GPM_DOWN)
            break; /* we're done */
          Gpm_DrawPointer(ev.x,ev.y,fd);
            }
         gpm_report(GPM_PR_DEBUG,"%i - %i",posty,ev.y);

         /* ok, redraw, close and return waiting */
         gpm_report(GPM_PR_DEBUG,"Active is %p",activemenu->draw);
         posty=activemenu->y;
         postx=activemenu->x;
         postX=activemenu->X;

         recursenow=0; item=NULL; /* by default */
         posty=ev.y-posty;
         if (postx<=ev.x && ev.x<=postX) /* look for it */
            {
          for (item=draw->menu; posty-- && item; item=item->next)
            gpm_report(GPM_PR_DEBUG,"item %s (%p)",item->name, item->fun);
          if (item && item->fun && item->fun==f_menu)
            {
              recursenow++;
              draw=item->clientdata;
              continue;
            }
            }

         /* unpost them all */
         while (unpostmenu(fd,f,activemenu,vc))
            ;
         close(fd);
         fclose(f);
         Gpm_Close();
         recursenow=0; /* just in case... */

         /* invoke the item */
         if (item && item->fun)
            (*(item->fun))(F_INVOKE,item,uid);
      }

   /*....................................... Done */

   while (Gpm_Close()) ; /* close all the stack */ 
   exit(0);
}

/* developers chat:
 * author1 (possibly alessandro):
   "This is because Linus uses 4-wide tabstops, forcing me to use the same
   default to manage kernel sources"
  * ian zimmermann (alias itz) on Wed Jul  1 23:28:13 PDT 1998:
   "I don't mind what anybody's physical tab size is, but when I load it into
   the editor I don't want any wrapping lines."
  * nico schottelius (january 2002): 
   "Although Linux document /usr/src/linux/Documentation/CodingStyle is mostly
   correct, I agree with itz to avoid wrapping lines. Merging 4(alessandro)
   /2(itz) spaces makes 3 which is the current standard."
  */ 

/* Local Variables: */
/* tab-width:3      */
/* c-indent-level: 3 */
/* End:             */
