{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This structure represents a single  text selection within a document. This
-- selection is defined by two points in the content, where each one is defined
-- by an AtkObject supporting the AtkText interface and a character offset
-- relative to it.
-- 
-- The end object must appear after the start object in the accessibility tree,
-- i.e. the end object must be reachable from the start object by navigating
-- forward (next, first child etc).
-- 
-- This struct also contains a /@startIsActive@/ boolean, to communicate if the
-- start of the selection is the active point or not.
-- 
-- The active point corresponds to the user\'s focus or point of interest. The
-- user moves the active point to expand or collapse the range. The anchor
-- point is the other point of the range and typically remains constant. In
-- most cases, anchor is the start of the range and active is the end. However,
-- when selecting backwards (e.g. pressing shift+left arrow in a text field),
-- the start of the range is the active point, as the user moves this to
-- manipulate the selection.
-- 
-- /Since: 2.52/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.TextSelection
    ( 

-- * Exported types
    TextSelection(..)                       ,
    newZeroTextSelection                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTextSelectionMethod              ,
#endif



 -- * Properties


-- ** endObject #attr:endObject#
-- | the AtkText containing the end of the selection.

    clearTextSelectionEndObject             ,
    getTextSelectionEndObject               ,
    setTextSelectionEndObject               ,
#if defined(ENABLE_OVERLOADING)
    textSelection_endObject                 ,
#endif


-- ** endOffset #attr:endOffset#
-- | the text offset of the end of the selection within /@endObject@/.

    getTextSelectionEndOffset               ,
    setTextSelectionEndOffset               ,
#if defined(ENABLE_OVERLOADING)
    textSelection_endOffset                 ,
#endif


-- ** startIsActive #attr:startIsActive#
-- | a gboolean indicating whether the start of the selection
--                  is the active point.

    getTextSelectionStartIsActive           ,
    setTextSelectionStartIsActive           ,
#if defined(ENABLE_OVERLOADING)
    textSelection_startIsActive             ,
#endif


-- ** startObject #attr:startObject#
-- | the AtkText containing the start of the selection.

    clearTextSelectionStartObject           ,
    getTextSelectionStartObject             ,
    setTextSelectionStartObject             ,
#if defined(ENABLE_OVERLOADING)
    textSelection_startObject               ,
#endif


-- ** startOffset #attr:startOffset#
-- | the text offset of the beginning of the selection within
--                /@startObject@/.

    getTextSelectionStartOffset             ,
    setTextSelectionStartOffset             ,
#if defined(ENABLE_OVERLOADING)
    textSelection_startOffset               ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object

#endif

-- | Memory-managed wrapper type.
newtype TextSelection = TextSelection (SP.ManagedPtr TextSelection)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextSelection where
    toManagedPtr (TextSelection p) = p

instance BoxedPtr TextSelection where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr TextSelection)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TextSelection where
    boxedPtrCalloc = callocBytes 32


-- | Construct a t'TextSelection' struct initialized to zero.
newZeroTextSelection :: MonadIO m => m TextSelection
newZeroTextSelection = liftIO $ boxedPtrCalloc >>= wrapPtr TextSelection

instance tag ~ 'AttrSet => Constructible TextSelection tag where
    new _ attrs = do
        o <- newZeroTextSelection
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@start_object@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textSelection #startObject
-- @
getTextSelectionStartObject :: MonadIO m => TextSelection -> m (Maybe Atk.Object.Object)
getTextSelectionStartObject s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Atk.Object.Object)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Atk.Object.Object) val'
        return val''
    return result

-- | Set the value of the “@start_object@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textSelection [ #startObject 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextSelectionStartObject :: MonadIO m => TextSelection -> Ptr Atk.Object.Object -> m ()
setTextSelectionStartObject s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Atk.Object.Object)

-- | Set the value of the “@start_object@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #startObject
-- @
clearTextSelectionStartObject :: MonadIO m => TextSelection -> m ()
clearTextSelectionStartObject s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Atk.Object.Object)

#if defined(ENABLE_OVERLOADING)
data TextSelectionStartObjectFieldInfo
instance AttrInfo TextSelectionStartObjectFieldInfo where
    type AttrBaseTypeConstraint TextSelectionStartObjectFieldInfo = (~) TextSelection
    type AttrAllowedOps TextSelectionStartObjectFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TextSelectionStartObjectFieldInfo = (~) (Ptr Atk.Object.Object)
    type AttrTransferTypeConstraint TextSelectionStartObjectFieldInfo = (~)(Ptr Atk.Object.Object)
    type AttrTransferType TextSelectionStartObjectFieldInfo = (Ptr Atk.Object.Object)
    type AttrGetType TextSelectionStartObjectFieldInfo = Maybe Atk.Object.Object
    type AttrLabel TextSelectionStartObjectFieldInfo = "start_object"
    type AttrOrigin TextSelectionStartObjectFieldInfo = TextSelection
    attrGet = getTextSelectionStartObject
    attrSet = setTextSelectionStartObject
    attrConstruct = undefined
    attrClear = clearTextSelectionStartObject
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextSelection.startObject"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextSelection.html#g:attr:startObject"
        })

textSelection_startObject :: AttrLabelProxy "startObject"
textSelection_startObject = AttrLabelProxy

#endif


-- | Get the value of the “@start_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textSelection #startOffset
-- @
getTextSelectionStartOffset :: MonadIO m => TextSelection -> m Int32
getTextSelectionStartOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@start_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textSelection [ #startOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextSelectionStartOffset :: MonadIO m => TextSelection -> Int32 -> m ()
setTextSelectionStartOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextSelectionStartOffsetFieldInfo
instance AttrInfo TextSelectionStartOffsetFieldInfo where
    type AttrBaseTypeConstraint TextSelectionStartOffsetFieldInfo = (~) TextSelection
    type AttrAllowedOps TextSelectionStartOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextSelectionStartOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextSelectionStartOffsetFieldInfo = (~)Int32
    type AttrTransferType TextSelectionStartOffsetFieldInfo = Int32
    type AttrGetType TextSelectionStartOffsetFieldInfo = Int32
    type AttrLabel TextSelectionStartOffsetFieldInfo = "start_offset"
    type AttrOrigin TextSelectionStartOffsetFieldInfo = TextSelection
    attrGet = getTextSelectionStartOffset
    attrSet = setTextSelectionStartOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextSelection.startOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextSelection.html#g:attr:startOffset"
        })

textSelection_startOffset :: AttrLabelProxy "startOffset"
textSelection_startOffset = AttrLabelProxy

#endif


-- | Get the value of the “@end_object@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textSelection #endObject
-- @
getTextSelectionEndObject :: MonadIO m => TextSelection -> m (Maybe Atk.Object.Object)
getTextSelectionEndObject s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr Atk.Object.Object)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Atk.Object.Object) val'
        return val''
    return result

-- | Set the value of the “@end_object@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textSelection [ #endObject 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextSelectionEndObject :: MonadIO m => TextSelection -> Ptr Atk.Object.Object -> m ()
setTextSelectionEndObject s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr Atk.Object.Object)

-- | Set the value of the “@end_object@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #endObject
-- @
clearTextSelectionEndObject :: MonadIO m => TextSelection -> m ()
clearTextSelectionEndObject s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr Atk.Object.Object)

#if defined(ENABLE_OVERLOADING)
data TextSelectionEndObjectFieldInfo
instance AttrInfo TextSelectionEndObjectFieldInfo where
    type AttrBaseTypeConstraint TextSelectionEndObjectFieldInfo = (~) TextSelection
    type AttrAllowedOps TextSelectionEndObjectFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TextSelectionEndObjectFieldInfo = (~) (Ptr Atk.Object.Object)
    type AttrTransferTypeConstraint TextSelectionEndObjectFieldInfo = (~)(Ptr Atk.Object.Object)
    type AttrTransferType TextSelectionEndObjectFieldInfo = (Ptr Atk.Object.Object)
    type AttrGetType TextSelectionEndObjectFieldInfo = Maybe Atk.Object.Object
    type AttrLabel TextSelectionEndObjectFieldInfo = "end_object"
    type AttrOrigin TextSelectionEndObjectFieldInfo = TextSelection
    attrGet = getTextSelectionEndObject
    attrSet = setTextSelectionEndObject
    attrConstruct = undefined
    attrClear = clearTextSelectionEndObject
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextSelection.endObject"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextSelection.html#g:attr:endObject"
        })

textSelection_endObject :: AttrLabelProxy "endObject"
textSelection_endObject = AttrLabelProxy

#endif


-- | Get the value of the “@end_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textSelection #endOffset
-- @
getTextSelectionEndOffset :: MonadIO m => TextSelection -> m Int32
getTextSelectionEndOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Int32
    return val

-- | Set the value of the “@end_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textSelection [ #endOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextSelectionEndOffset :: MonadIO m => TextSelection -> Int32 -> m ()
setTextSelectionEndOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextSelectionEndOffsetFieldInfo
instance AttrInfo TextSelectionEndOffsetFieldInfo where
    type AttrBaseTypeConstraint TextSelectionEndOffsetFieldInfo = (~) TextSelection
    type AttrAllowedOps TextSelectionEndOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextSelectionEndOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextSelectionEndOffsetFieldInfo = (~)Int32
    type AttrTransferType TextSelectionEndOffsetFieldInfo = Int32
    type AttrGetType TextSelectionEndOffsetFieldInfo = Int32
    type AttrLabel TextSelectionEndOffsetFieldInfo = "end_offset"
    type AttrOrigin TextSelectionEndOffsetFieldInfo = TextSelection
    attrGet = getTextSelectionEndOffset
    attrSet = setTextSelectionEndOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextSelection.endOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextSelection.html#g:attr:endOffset"
        })

textSelection_endOffset :: AttrLabelProxy "endOffset"
textSelection_endOffset = AttrLabelProxy

#endif


-- | Get the value of the “@start_is_active@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textSelection #startIsActive
-- @
getTextSelectionStartIsActive :: MonadIO m => TextSelection -> m Bool
getTextSelectionStartIsActive s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@start_is_active@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textSelection [ #startIsActive 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextSelectionStartIsActive :: MonadIO m => TextSelection -> Bool -> m ()
setTextSelectionStartIsActive s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 28) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TextSelectionStartIsActiveFieldInfo
instance AttrInfo TextSelectionStartIsActiveFieldInfo where
    type AttrBaseTypeConstraint TextSelectionStartIsActiveFieldInfo = (~) TextSelection
    type AttrAllowedOps TextSelectionStartIsActiveFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextSelectionStartIsActiveFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TextSelectionStartIsActiveFieldInfo = (~)Bool
    type AttrTransferType TextSelectionStartIsActiveFieldInfo = Bool
    type AttrGetType TextSelectionStartIsActiveFieldInfo = Bool
    type AttrLabel TextSelectionStartIsActiveFieldInfo = "start_is_active"
    type AttrOrigin TextSelectionStartIsActiveFieldInfo = TextSelection
    attrGet = getTextSelectionStartIsActive
    attrSet = setTextSelectionStartIsActive
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextSelection.startIsActive"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextSelection.html#g:attr:startIsActive"
        })

textSelection_startIsActive :: AttrLabelProxy "startIsActive"
textSelection_startIsActive = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TextSelection
type instance O.AttributeList TextSelection = TextSelectionAttributeList
type TextSelectionAttributeList = ('[ '("startObject", TextSelectionStartObjectFieldInfo), '("startOffset", TextSelectionStartOffsetFieldInfo), '("endObject", TextSelectionEndObjectFieldInfo), '("endOffset", TextSelectionEndOffsetFieldInfo), '("startIsActive", TextSelectionStartIsActiveFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTextSelectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextSelectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextSelectionMethod t TextSelection, O.OverloadedMethod info TextSelection p) => OL.IsLabel t (TextSelection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextSelectionMethod t TextSelection, O.OverloadedMethod info TextSelection p, R.HasField t TextSelection p) => R.HasField t TextSelection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextSelectionMethod t TextSelection, O.OverloadedMethodInfo info TextSelection) => OL.IsLabel t (O.MethodProxy info TextSelection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


