

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Enums
    ( 

 -- * Enumerations


-- ** AxisUse #enum:AxisUse#

    AxisUse(..)                             ,


-- ** CicpRange #enum:CicpRange#

    CicpRange(..)                           ,


-- ** CrossingMode #enum:CrossingMode#

    CrossingMode(..)                        ,


-- ** DevicePadFeature #enum:DevicePadFeature#

    DevicePadFeature(..)                    ,


-- ** DeviceToolType #enum:DeviceToolType#

    DeviceToolType(..)                      ,


-- ** DmabufError #enum:DmabufError#

    DmabufError(..)                         ,
    catchDmabufError                        ,
    handleDmabufError                       ,


-- ** DragCancelReason #enum:DragCancelReason#

    DragCancelReason(..)                    ,


-- ** EventType #enum:EventType#

    EventType(..)                           ,


-- ** FullscreenMode #enum:FullscreenMode#

    FullscreenMode(..)                      ,


-- ** GLError #enum:GLError#

    GLError(..)                             ,
    catchGLError                            ,
    handleGLError                           ,


-- ** Gravity #enum:Gravity#

    Gravity(..)                             ,


-- ** InputSource #enum:InputSource#

    InputSource(..)                         ,


-- ** KeyMatch #enum:KeyMatch#

    KeyMatch(..)                            ,


-- ** MemoryFormat #enum:MemoryFormat#

    MemoryFormat(..)                        ,


-- ** NotifyType #enum:NotifyType#

    NotifyType(..)                          ,


-- ** ScrollDirection #enum:ScrollDirection#

    ScrollDirection(..)                     ,


-- ** ScrollRelativeDirection #enum:ScrollRelativeDirection#

    ScrollRelativeDirection(..)             ,


-- ** ScrollUnit #enum:ScrollUnit#

    ScrollUnit(..)                          ,


-- ** SubpixelLayout #enum:SubpixelLayout#

    SubpixelLayout(..)                      ,


-- ** SurfaceEdge #enum:SurfaceEdge#

    SurfaceEdge(..)                         ,


-- ** TextureError #enum:TextureError#

    TextureError(..)                        ,
    catchTextureError                       ,
    handleTextureError                      ,


-- ** TitlebarGesture #enum:TitlebarGesture#

    TitlebarGesture(..)                     ,


-- ** TouchpadGesturePhase #enum:TouchpadGesturePhase#

    TouchpadGesturePhase(..)                ,


-- ** VulkanError #enum:VulkanError#

    VulkanError(..)                         ,
    catchVulkanError                        ,
    handleVulkanError                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum VulkanError
-- | Error enumeration for @GdkVulkanContext@.
data VulkanError = 
      VulkanErrorUnsupported
    -- ^ Vulkan is not supported on this backend or has not been
    --   compiled in.
    | VulkanErrorNotAvailable
    -- ^ Vulkan support is not available on this Surface
    | AnotherVulkanError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum VulkanError where
    fromEnum VulkanErrorUnsupported = 0
    fromEnum VulkanErrorNotAvailable = 1
    fromEnum (AnotherVulkanError k) = k

    toEnum 0 = VulkanErrorUnsupported
    toEnum 1 = VulkanErrorNotAvailable
    toEnum k = AnotherVulkanError k

instance P.Ord VulkanError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass VulkanError where
    gerrorClassDomain _ = "gdk-vulkan-error-quark"

-- | Catch exceptions of type `VulkanError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchVulkanError ::
    IO a ->
    (VulkanError -> GErrorMessage -> IO a) ->
    IO a
catchVulkanError = catchGErrorJustDomain

-- | Handle exceptions of type `VulkanError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleVulkanError ::
    (VulkanError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleVulkanError = handleGErrorJustDomain

type instance O.ParentTypes VulkanError = '[]
instance O.HasParentTypes VulkanError

foreign import ccall "gdk_vulkan_error_get_type" c_gdk_vulkan_error_get_type :: 
    IO GType

instance B.Types.TypedObject VulkanError where
    glibType = c_gdk_vulkan_error_get_type

instance B.Types.BoxedEnum VulkanError

-- Enum TouchpadGesturePhase
-- | Specifies the current state of a touchpad gesture.
-- 
-- All gestures are guaranteed to begin with an event with phase
-- 'GI.Gdk.Enums.TouchpadGesturePhaseBegin', followed by 0 or several events
-- with phase 'GI.Gdk.Enums.TouchpadGesturePhaseUpdate'.
-- 
-- A finished gesture may have 2 possible outcomes, an event with phase
-- 'GI.Gdk.Enums.TouchpadGesturePhaseEnd' will be emitted when the gesture is
-- considered successful, this should be used as the hint to perform any
-- permanent changes.
-- 
-- Cancelled gestures may be so for a variety of reasons, due to hardware
-- or the compositor, or due to the gesture recognition layers hinting the
-- gesture did not finish resolutely (eg. a 3rd finger being added during
-- a pinch gesture). In these cases, the last event will report the phase
-- 'GI.Gdk.Enums.TouchpadGesturePhaseCancel', this should be used as a hint
-- to undo any visible\/permanent changes that were done throughout the
-- progress of the gesture.
data TouchpadGesturePhase = 
      TouchpadGesturePhaseBegin
    -- ^ The gesture has begun.
    | TouchpadGesturePhaseUpdate
    -- ^ The gesture has been updated.
    | TouchpadGesturePhaseEnd
    -- ^ The gesture was finished, changes
    --   should be permanently applied.
    | TouchpadGesturePhaseCancel
    -- ^ The gesture was cancelled, all
    --   changes should be undone.
    | AnotherTouchpadGesturePhase Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TouchpadGesturePhase where
    fromEnum TouchpadGesturePhaseBegin = 0
    fromEnum TouchpadGesturePhaseUpdate = 1
    fromEnum TouchpadGesturePhaseEnd = 2
    fromEnum TouchpadGesturePhaseCancel = 3
    fromEnum (AnotherTouchpadGesturePhase k) = k

    toEnum 0 = TouchpadGesturePhaseBegin
    toEnum 1 = TouchpadGesturePhaseUpdate
    toEnum 2 = TouchpadGesturePhaseEnd
    toEnum 3 = TouchpadGesturePhaseCancel
    toEnum k = AnotherTouchpadGesturePhase k

instance P.Ord TouchpadGesturePhase where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TouchpadGesturePhase = '[]
instance O.HasParentTypes TouchpadGesturePhase

foreign import ccall "gdk_touchpad_gesture_phase_get_type" c_gdk_touchpad_gesture_phase_get_type :: 
    IO GType

instance B.Types.TypedObject TouchpadGesturePhase where
    glibType = c_gdk_touchpad_gesture_phase_get_type

instance B.Types.BoxedEnum TouchpadGesturePhase

-- Enum TitlebarGesture
-- | The kind of title bar gesture to emit with
-- 'GI.Gdk.Interfaces.Toplevel.toplevelTitlebarGesture'.
-- 
-- /Since: 4.4/
data TitlebarGesture = 
      TitlebarGestureDoubleClick
    -- ^ double click gesture
    | TitlebarGestureRightClick
    -- ^ right click gesture
    | TitlebarGestureMiddleClick
    -- ^ middle click gesture
    | AnotherTitlebarGesture Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TitlebarGesture where
    fromEnum TitlebarGestureDoubleClick = 1
    fromEnum TitlebarGestureRightClick = 2
    fromEnum TitlebarGestureMiddleClick = 3
    fromEnum (AnotherTitlebarGesture k) = k

    toEnum 1 = TitlebarGestureDoubleClick
    toEnum 2 = TitlebarGestureRightClick
    toEnum 3 = TitlebarGestureMiddleClick
    toEnum k = AnotherTitlebarGesture k

instance P.Ord TitlebarGesture where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TitlebarGesture = '[]
instance O.HasParentTypes TitlebarGesture

foreign import ccall "gdk_titlebar_gesture_get_type" c_gdk_titlebar_gesture_get_type :: 
    IO GType

instance B.Types.TypedObject TitlebarGesture where
    glibType = c_gdk_titlebar_gesture_get_type

instance B.Types.BoxedEnum TitlebarGesture

-- Enum TextureError
-- | Possible errors that can be returned by @GdkTexture@ constructors.
-- 
-- /Since: 4.6/
data TextureError = 
      TextureErrorTooLarge
    -- ^ Not enough memory to handle this image
    | TextureErrorCorruptImage
    -- ^ The image data appears corrupted
    | TextureErrorUnsupportedContent
    -- ^ The image contains features
    --   that cannot be loaded
    | TextureErrorUnsupportedFormat
    -- ^ The image format is not supported
    | AnotherTextureError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextureError where
    fromEnum TextureErrorTooLarge = 0
    fromEnum TextureErrorCorruptImage = 1
    fromEnum TextureErrorUnsupportedContent = 2
    fromEnum TextureErrorUnsupportedFormat = 3
    fromEnum (AnotherTextureError k) = k

    toEnum 0 = TextureErrorTooLarge
    toEnum 1 = TextureErrorCorruptImage
    toEnum 2 = TextureErrorUnsupportedContent
    toEnum 3 = TextureErrorUnsupportedFormat
    toEnum k = AnotherTextureError k

instance P.Ord TextureError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass TextureError where
    gerrorClassDomain _ = "gdk-texture-error-quark"

-- | Catch exceptions of type `TextureError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchTextureError ::
    IO a ->
    (TextureError -> GErrorMessage -> IO a) ->
    IO a
catchTextureError = catchGErrorJustDomain

-- | Handle exceptions of type `TextureError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleTextureError ::
    (TextureError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleTextureError = handleGErrorJustDomain

type instance O.ParentTypes TextureError = '[]
instance O.HasParentTypes TextureError

foreign import ccall "gdk_texture_error_get_type" c_gdk_texture_error_get_type :: 
    IO GType

instance B.Types.TypedObject TextureError where
    glibType = c_gdk_texture_error_get_type

instance B.Types.BoxedEnum TextureError

-- Enum SurfaceEdge
-- | Determines a surface edge or corner.
data SurfaceEdge = 
      SurfaceEdgeNorthWest
    -- ^ the top left corner.
    | SurfaceEdgeNorth
    -- ^ the top edge.
    | SurfaceEdgeNorthEast
    -- ^ the top right corner.
    | SurfaceEdgeWest
    -- ^ the left edge.
    | SurfaceEdgeEast
    -- ^ the right edge.
    | SurfaceEdgeSouthWest
    -- ^ the lower left corner.
    | SurfaceEdgeSouth
    -- ^ the lower edge.
    | SurfaceEdgeSouthEast
    -- ^ the lower right corner.
    | AnotherSurfaceEdge Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SurfaceEdge where
    fromEnum SurfaceEdgeNorthWest = 0
    fromEnum SurfaceEdgeNorth = 1
    fromEnum SurfaceEdgeNorthEast = 2
    fromEnum SurfaceEdgeWest = 3
    fromEnum SurfaceEdgeEast = 4
    fromEnum SurfaceEdgeSouthWest = 5
    fromEnum SurfaceEdgeSouth = 6
    fromEnum SurfaceEdgeSouthEast = 7
    fromEnum (AnotherSurfaceEdge k) = k

    toEnum 0 = SurfaceEdgeNorthWest
    toEnum 1 = SurfaceEdgeNorth
    toEnum 2 = SurfaceEdgeNorthEast
    toEnum 3 = SurfaceEdgeWest
    toEnum 4 = SurfaceEdgeEast
    toEnum 5 = SurfaceEdgeSouthWest
    toEnum 6 = SurfaceEdgeSouth
    toEnum 7 = SurfaceEdgeSouthEast
    toEnum k = AnotherSurfaceEdge k

instance P.Ord SurfaceEdge where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SurfaceEdge = '[]
instance O.HasParentTypes SurfaceEdge

foreign import ccall "gdk_surface_edge_get_type" c_gdk_surface_edge_get_type :: 
    IO GType

instance B.Types.TypedObject SurfaceEdge where
    glibType = c_gdk_surface_edge_get_type

instance B.Types.BoxedEnum SurfaceEdge

-- Enum SubpixelLayout
-- | This enumeration describes how the red, green and blue components
-- of physical pixels on an output device are laid out.
data SubpixelLayout = 
      SubpixelLayoutUnknown
    -- ^ The layout is not known
    | SubpixelLayoutNone
    -- ^ Not organized in this way
    | SubpixelLayoutHorizontalRgb
    -- ^ The layout is horizontal, the order is RGB
    | SubpixelLayoutHorizontalBgr
    -- ^ The layout is horizontal, the order is BGR
    | SubpixelLayoutVerticalRgb
    -- ^ The layout is vertical, the order is RGB
    | SubpixelLayoutVerticalBgr
    -- ^ The layout is vertical, the order is BGR
    | AnotherSubpixelLayout Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SubpixelLayout where
    fromEnum SubpixelLayoutUnknown = 0
    fromEnum SubpixelLayoutNone = 1
    fromEnum SubpixelLayoutHorizontalRgb = 2
    fromEnum SubpixelLayoutHorizontalBgr = 3
    fromEnum SubpixelLayoutVerticalRgb = 4
    fromEnum SubpixelLayoutVerticalBgr = 5
    fromEnum (AnotherSubpixelLayout k) = k

    toEnum 0 = SubpixelLayoutUnknown
    toEnum 1 = SubpixelLayoutNone
    toEnum 2 = SubpixelLayoutHorizontalRgb
    toEnum 3 = SubpixelLayoutHorizontalBgr
    toEnum 4 = SubpixelLayoutVerticalRgb
    toEnum 5 = SubpixelLayoutVerticalBgr
    toEnum k = AnotherSubpixelLayout k

instance P.Ord SubpixelLayout where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SubpixelLayout = '[]
instance O.HasParentTypes SubpixelLayout

foreign import ccall "gdk_subpixel_layout_get_type" c_gdk_subpixel_layout_get_type :: 
    IO GType

instance B.Types.TypedObject SubpixelLayout where
    glibType = c_gdk_subpixel_layout_get_type

instance B.Types.BoxedEnum SubpixelLayout

-- Enum ScrollUnit
-- | Specifies the unit of scroll deltas.
-- 
-- When you get 'GI.Gdk.Enums.ScrollUnitWheel', a delta of 1.0 means 1 wheel detent
-- click in the south direction, 2.0 means 2 wheel detent clicks in the south
-- direction... This is the same logic for negative values but in the north
-- direction.
-- 
-- If you get 'GI.Gdk.Enums.ScrollUnitSurface', are managing a scrollable view and get a
-- value of 123, you have to scroll 123 surface logical pixels right if it\'s
-- /@deltaX@/ or down if it\'s /@deltaY@/. This is the same logic for negative values
-- but you have to scroll left instead of right if it\'s /@deltaX@/ and up instead
-- of down if it\'s /@deltaY@/.
-- 
-- 1 surface logical pixel is equal to 1 real screen pixel multiplied by the
-- final scale factor of your graphical interface (the product of the desktop
-- scale factor and eventually a custom scale factor in your app).
-- 
-- /Since: 4.8/
data ScrollUnit = 
      ScrollUnitWheel
    -- ^ The delta is in number of wheel clicks.
    | ScrollUnitSurface
    -- ^ The delta is in surface pixels to scroll directly
    --   on screen.
    | AnotherScrollUnit Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollUnit where
    fromEnum ScrollUnitWheel = 0
    fromEnum ScrollUnitSurface = 1
    fromEnum (AnotherScrollUnit k) = k

    toEnum 0 = ScrollUnitWheel
    toEnum 1 = ScrollUnitSurface
    toEnum k = AnotherScrollUnit k

instance P.Ord ScrollUnit where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollUnit = '[]
instance O.HasParentTypes ScrollUnit

foreign import ccall "gdk_scroll_unit_get_type" c_gdk_scroll_unit_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollUnit where
    glibType = c_gdk_scroll_unit_get_type

instance B.Types.BoxedEnum ScrollUnit

-- Enum ScrollRelativeDirection
-- | Used in scroll events, to announce the direction relative
-- to physical motion.
-- 
-- /Since: 4.20/
data ScrollRelativeDirection = 
      ScrollRelativeDirectionIdentical
    -- ^ Physical motion and event motion are the same
    | ScrollRelativeDirectionInverted
    -- ^ Physical motion is inverted relative to event motion
    | ScrollRelativeDirectionUnknown
    -- ^ Relative motion is unknown on this device or backend
    | AnotherScrollRelativeDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollRelativeDirection where
    fromEnum ScrollRelativeDirectionIdentical = 0
    fromEnum ScrollRelativeDirectionInverted = 1
    fromEnum ScrollRelativeDirectionUnknown = 2
    fromEnum (AnotherScrollRelativeDirection k) = k

    toEnum 0 = ScrollRelativeDirectionIdentical
    toEnum 1 = ScrollRelativeDirectionInverted
    toEnum 2 = ScrollRelativeDirectionUnknown
    toEnum k = AnotherScrollRelativeDirection k

instance P.Ord ScrollRelativeDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollRelativeDirection = '[]
instance O.HasParentTypes ScrollRelativeDirection

foreign import ccall "gdk_scroll_relative_direction_get_type" c_gdk_scroll_relative_direction_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollRelativeDirection where
    glibType = c_gdk_scroll_relative_direction_get_type

instance B.Types.BoxedEnum ScrollRelativeDirection

-- Enum ScrollDirection
-- | Specifies the direction for scroll events.
data ScrollDirection = 
      ScrollDirectionUp
    -- ^ the surface is scrolled up.
    | ScrollDirectionDown
    -- ^ the surface is scrolled down.
    | ScrollDirectionLeft
    -- ^ the surface is scrolled to the left.
    | ScrollDirectionRight
    -- ^ the surface is scrolled to the right.
    | ScrollDirectionSmooth
    -- ^ the scrolling is determined by the delta values
    --   in scroll events. See 'GI.Gdk.Objects.ScrollEvent.scrollEventGetDeltas'
    | AnotherScrollDirection Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollDirection where
    fromEnum ScrollDirectionUp = 0
    fromEnum ScrollDirectionDown = 1
    fromEnum ScrollDirectionLeft = 2
    fromEnum ScrollDirectionRight = 3
    fromEnum ScrollDirectionSmooth = 4
    fromEnum (AnotherScrollDirection k) = k

    toEnum 0 = ScrollDirectionUp
    toEnum 1 = ScrollDirectionDown
    toEnum 2 = ScrollDirectionLeft
    toEnum 3 = ScrollDirectionRight
    toEnum 4 = ScrollDirectionSmooth
    toEnum k = AnotherScrollDirection k

instance P.Ord ScrollDirection where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollDirection = '[]
instance O.HasParentTypes ScrollDirection

foreign import ccall "gdk_scroll_direction_get_type" c_gdk_scroll_direction_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollDirection where
    glibType = c_gdk_scroll_direction_get_type

instance B.Types.BoxedEnum ScrollDirection

-- Enum NotifyType
-- | Specifies the kind of crossing for enter and leave events.
-- 
-- See the X11 protocol specification of LeaveNotify for
-- full details of crossing event generation.
data NotifyType = 
      NotifyTypeAncestor
    -- ^ the surface is entered from an ancestor or
    --   left towards an ancestor.
    | NotifyTypeVirtual
    -- ^ the pointer moves between an ancestor and an
    --   inferior of the surface.
    | NotifyTypeInferior
    -- ^ the surface is entered from an inferior or
    --   left towards an inferior.
    | NotifyTypeNonlinear
    -- ^ the surface is entered from or left towards
    --   a surface which is neither an ancestor nor an inferior.
    | NotifyTypeNonlinearVirtual
    -- ^ the pointer moves between two surfaces
    --   which are not ancestors of each other and the surface is part of
    --   the ancestor chain between one of these surfaces and their least
    --   common ancestor.
    | NotifyTypeUnknown
    -- ^ an unknown type of enter\/leave event occurred.
    | AnotherNotifyType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NotifyType where
    fromEnum NotifyTypeAncestor = 0
    fromEnum NotifyTypeVirtual = 1
    fromEnum NotifyTypeInferior = 2
    fromEnum NotifyTypeNonlinear = 3
    fromEnum NotifyTypeNonlinearVirtual = 4
    fromEnum NotifyTypeUnknown = 5
    fromEnum (AnotherNotifyType k) = k

    toEnum 0 = NotifyTypeAncestor
    toEnum 1 = NotifyTypeVirtual
    toEnum 2 = NotifyTypeInferior
    toEnum 3 = NotifyTypeNonlinear
    toEnum 4 = NotifyTypeNonlinearVirtual
    toEnum 5 = NotifyTypeUnknown
    toEnum k = AnotherNotifyType k

instance P.Ord NotifyType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NotifyType = '[]
instance O.HasParentTypes NotifyType

foreign import ccall "gdk_notify_type_get_type" c_gdk_notify_type_get_type :: 
    IO GType

instance B.Types.TypedObject NotifyType where
    glibType = c_gdk_notify_type_get_type

instance B.Types.BoxedEnum NotifyType

-- Enum MemoryFormat
-- | Describes formats that image data can have in memory.
-- 
-- It describes formats by listing the contents of the memory passed to it.
-- So @GDK_MEMORY_A8R8G8B8@ will be 1 byte (8 bits) of alpha, followed by a
-- byte each of red, green and blue. It is not endian-dependent, so
-- @CAIRO_FORMAT_ARGB32@ is represented by different @GdkMemoryFormats@
-- on architectures with different endiannesses.
-- 
-- Its naming is modelled after
-- <https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.html#VkFormat VkFormat>
-- for details).
data MemoryFormat = 
      MemoryFormatB8g8r8a8Premultiplied
    -- ^ 4 bytes; for blue, green, red, alpha.
    --   The color values are premultiplied with the alpha value.
    | MemoryFormatA8r8g8b8Premultiplied
    -- ^ 4 bytes; for alpha, red, green, blue.
    --   The color values are premultiplied with the alpha value.
    | MemoryFormatR8g8b8a8Premultiplied
    -- ^ 4 bytes; for red, green, blue, alpha
    --   The color values are premultiplied with the alpha value.
    | MemoryFormatB8g8r8a8
    -- ^ 4 bytes; for blue, green, red, alpha.
    | MemoryFormatA8r8g8b8
    -- ^ 4 bytes; for alpha, red, green, blue.
    | MemoryFormatR8g8b8a8
    -- ^ 4 bytes; for red, green, blue, alpha.
    | MemoryFormatA8b8g8r8
    -- ^ 4 bytes; for alpha, blue, green, red.
    | MemoryFormatR8g8b8
    -- ^ 3 bytes; for red, green, blue. The data is opaque.
    | MemoryFormatB8g8r8
    -- ^ 3 bytes; for blue, green, red. The data is opaque.
    | MemoryFormatR16g16b16
    -- ^ 3 guint16 values; for red, green, blue.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR16g16b16a16Premultiplied
    -- ^ 4 guint16 values; for red, green, blue, alpha. The color values are
    -- premultiplied with the alpha value.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR16g16b16a16
    -- ^ 4 guint16 values; for red, green, blue, alpha.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR16g16b16Float
    -- ^ 3 half-float values; for red, green, blue. The data is opaque.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR16g16b16a16FloatPremultiplied
    -- ^ 4 half-float values; for red, green, blue and alpha. The color values are
    -- premultiplied with the alpha value.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR16g16b16a16Float
    -- ^ 4 half-float values; for red, green, blue and alpha.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR32g32b32Float
    -- ^ 3 float values; for red, green, blue.
    | MemoryFormatR32g32b32a32FloatPremultiplied
    -- ^ 4 float values; for red, green, blue and alpha. The color values are
    -- premultiplied with the alpha value.
    -- 
    -- /Since: 4.6/
    | MemoryFormatR32g32b32a32Float
    -- ^ 4 float values; for red, green, blue and alpha.
    -- 
    -- /Since: 4.6/
    | MemoryFormatG8a8Premultiplied
    -- ^ 2 bytes; for grayscale, alpha. The color values are premultiplied with the
    -- alpha value.
    -- 
    -- /Since: 4.12/
    | MemoryFormatG8a8
    -- ^ 2 bytes; for grayscale, alpha.
    -- 
    -- /Since: 4.12/
    | MemoryFormatG8
    -- ^ One byte; for grayscale. The data is opaque.
    -- 
    -- /Since: 4.12/
    | MemoryFormatG16a16Premultiplied
    -- ^ 2 guint16 values; for grayscale, alpha. The color values are premultiplied
    -- with the alpha value.
    -- 
    -- /Since: 4.12/
    | MemoryFormatG16a16
    -- ^ 2 guint16 values; for grayscale, alpha.
    -- 
    -- /Since: 4.12/
    | MemoryFormatG16
    -- ^ One guint16 value; for grayscale. The data is opaque.
    -- 
    -- /Since: 4.12/
    | MemoryFormatA8
    -- ^ One byte; for alpha.
    -- 
    -- /Since: 4.12/
    | MemoryFormatA16
    -- ^ One guint16 value; for alpha.
    -- 
    -- /Since: 4.12/
    | MemoryFormatA16Float
    -- ^ One half-float value; for alpha.
    -- 
    -- /Since: 4.12/
    | MemoryFormatA32Float
    -- ^ One float value; for alpha.
    -- 
    -- /Since: 4.12/
    | MemoryFormatA8b8g8r8Premultiplied
    -- ^ 4 bytes; for alpha, blue, green, red, The color values are premultiplied with
    -- the alpha value.
    -- 
    -- /Since: 4.14/
    | MemoryFormatB8g8r8x8
    -- ^ 4 bytes; for blue, green, red, unused.
    -- 
    -- /Since: 4.14/
    | MemoryFormatX8r8g8b8
    -- ^ 4 bytes; for unused, red, green, blue.
    -- 
    -- /Since: 4.14/
    | MemoryFormatR8g8b8x8
    -- ^ 4 bytes; for red, green, blue, unused.
    -- 
    -- /Since: 4.14/
    | MemoryFormatX8b8g8r8
    -- ^ 4 bytes; for unused, blue, green, red.
    -- 
    -- /Since: 4.14/
    | MemoryFormatG8B8r8420
    -- ^ Multiplane format with 2 planes.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cb followed by Cr.
    -- Subsampled in both the X and Y direction.
    -- 
    -- Commonly known by the fourcc \"NV12\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8b8420
    -- ^ Multiplane format with 2 planes.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cr followed by Cb.
    -- Subsampled in both the X and Y direction.
    -- 
    -- Commonly known by the fourcc \"NV21\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8r8422
    -- ^ Multiplane format with 2 planes.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cb followed by Cr.
    -- Subsampled in the X direction.
    -- 
    -- Commonly known by the fourcc \"NV16\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8b8422
    -- ^ Multiplane format with 2 planes.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cr followed by Cb.
    -- Subsampled in the X direction.
    -- 
    -- Commonly known by the fourcc \"NV61\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8r8444
    -- ^ Multiplane format with 2 planes.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cb followed by Cr.
    -- This format is not subsampled.
    -- 
    -- Commonly known by the fourcc \"NV24\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8b8444
    -- ^ Multiplane format with 2 planes.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cr followed by Cb.
    -- This format is not subsampled.
    -- 
    -- Commonly known by the fourcc \"NV42\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG10x6B10x6r10x6420
    -- ^ Multiplane format with 2 planes.
    -- 
    -- Each channel is a 16 bit integer, but only the highest 10 bits are used.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cr followed by Cb.
    -- This format is not subsampled.
    -- 
    -- Commonly known by the fourcc \"P010\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG12x4B12x4r12x4420
    -- ^ Multiplane format with 2 planes.
    -- 
    -- Each channel is a 16 bit integer, but only the highest 10 bits are used.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cr followed by Cb.
    -- This format is not subsampled.
    -- 
    -- Commonly known by the fourcc \"P012\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG16B16r16420
    -- ^ Multiplane format with 2 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- The first plane contains the first channel, usually containing
    -- luma values.
    -- The second plane with interleaved chroma values, Cr followed by Cb.
    -- This format is not subsampled.
    -- 
    -- Commonly known by the fourcc \"P016\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8R8410
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in both the X and Y direction with 4:1 ratio. It is
    -- mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in both the X and Y direction with 4:1 ratio. It is
    -- mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"YUV410\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8B8410
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the second chroma chanel.
    -- Subsampled in both the X and Y direction with 4:1 ratio. It is
    -- mapped into the 1st channel.
    -- 
    -- The third plane usually contains the first chroma channel.
    -- Subsampled in both the X and Y direction with 4:1 ratio. It is
    -- mapped into the 3rd channel.
    -- 
    -- Commonly known by the fourcc \"YVU410\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8R8411
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in the X direction with 4:1 ratio. It is
    -- mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in the X direction with 4:1 ratio. It is
    -- mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"YUV411\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8B8411
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the second chroma chanel.
    -- Subsampled in the X direction with 4:1 ratio. It is
    -- mapped into the 1st channel.
    -- 
    -- The third plane usually contains the first chroma channel.
    -- Subsampled in the X direction with 4:1 ratio. It is
    -- mapped into the 3rd channel.
    -- 
    -- Commonly known by the fourcc \"YVU411\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8R8420
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 1st channel.
    -- 
    -- Commonly known by the fourcc \"YUV420\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8B8420
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the second chroma chanel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 1st channel.
    -- 
    -- The third plane usually contains the first chroma channel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 3rd channel.
    -- 
    -- Commonly known by the fourcc \"YVU420\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8R8422
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in the X direction. It is mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in the X direction. It is mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"YUV422\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8B8422
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the second chroma chanel.
    -- Subsampled in the X direction. It is mapped into the 1st channel.
    -- 
    -- The third plane usually contains the first chroma channel.
    -- Subsampled in the X direction. It is mapped into the 3rd channel.
    -- 
    -- Commonly known by the fourcc \"YVU422\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8B8R8444
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel. It is
    -- mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel. It is
    -- mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"YUV444\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8R8B8444
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 8 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the second chroma chanel.
    -- Subsampled in the X direction. It is mapped into the 1st channel.
    -- 
    -- The third plane usually contains the first chroma channel.
    -- Subsampled in the X direction. It is mapped into the 3rd channel.
    -- 
    -- Commonly known by the fourcc \"YVU444\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8b8g8r8422
    -- ^ Packed format with subsampled channels.
    -- 
    -- Each channel is a 8 bit integer. The red and blue\/chroma channels
    -- are subsampled and interleaved with the green\/luma channel.
    -- 
    -- Each block contains 2 pixels, so the width must be a multiple of
    -- 2.
    -- 
    -- Commonly known by the fourcc \"YUYV\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG8r8g8b8422
    -- ^ Packed format with subsampled channels.
    -- 
    -- Each channel is a 8 bit integer. The red and blue\/chroma channels
    -- are subsampled and interleaved with the green\/luma channel.
    -- 
    -- Each block contains 2 pixels, so the width must be a multiple of
    -- 2.
    -- 
    -- Commonly known by the fourcc \"YVYU\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatR8g8b8g8422
    -- ^ Packed format with subsampled channels.
    -- 
    -- Each channel is a 8 bit integer. The red and blue\/chroma channels
    -- are subsampled and interleaved with the green\/luma channel.
    -- 
    -- Each block contains 2 pixels, so the width must be a multiple of
    -- 2.
    -- 
    -- Commonly known by the fourcc \"VYUY\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatB8g8r8g8422
    -- ^ Packed format with subsampled channels.
    -- 
    -- Each channel is a 8 bit integer. The red and blue\/chroma channels
    -- are subsampled and interleaved with the green\/luma channel.
    -- 
    -- Each block contains 2 pixels, so the width must be a multiple of
    -- 2.
    -- 
    -- Commonly known by the fourcc \"UYVY\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatX6g10X6b10X6r10420
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- Only the 10 lower bits are used. The remaining ones must be set to 0 by the
    -- producer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 1st channel.
    -- 
    -- Commonly known by the fourcc \"S010\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatX6g10X6b10X6r10422
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- Only the 10 lower bits are used. The remaining ones must be set to 0 by the
    -- producer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in the X direction. It is mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in the X direction. It is mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"S210\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatX6g10X6b10X6r10444
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- Only the 10 lower bits are used. The remaining ones must be set to 0 by the
    -- producer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel. It is
    -- mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel. It is
    -- mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"S410\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatX4g12X4b12X4r12420
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- Only the 12 lower bits are used. The remaining ones must be set to 0 by the
    -- producer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 1st channel.
    -- 
    -- Commonly known by the fourcc \"S012\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatX4g12X4b12X4r12422
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- Only the 12 lower bits are used. The remaining ones must be set to 0 by the
    -- producer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in the X direction. It is mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in the X direction. It is mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"S212\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatX4g12X4b12X4r12444
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- Only the 12 lower bits are used. The remaining ones must be set to 0 by the
    -- producer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel. It is
    -- mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel. It is
    -- mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"S412\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG16B16R16420
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in both the X and Y direction. It is mapped into the
    -- 1st channel.
    -- 
    -- Commonly known by the fourcc \"S016\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG16B16R16422
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel.
    -- Subsampled in the X direction. It is mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel.
    -- Subsampled in the X direction. It is mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"S216\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatG16B16R16444
    -- ^ Multiplane format with 3 planes.
    -- 
    -- Each channel is a 16 bit integer.
    -- 
    -- The first plane usually contains the luma channel. It is mapped
    -- into the 2nd channel.
    -- 
    -- The second plane usually contains the first chroma chanel. It is
    -- mapped into the 3rd channel.
    -- 
    -- The third plane usually contains the second chroma channel. It is
    -- mapped into the 1st channel.
    -- 
    -- Commonly known by the fourcc \"S416\".
    -- 
    -- /Since: 4.20/
    | MemoryFormatNFormats
    -- ^ The number of formats. This value will change as
    --   more formats get added, so do not rely on its concrete integer.
    | AnotherMemoryFormat Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MemoryFormat where
    fromEnum MemoryFormatB8g8r8a8Premultiplied = 0
    fromEnum MemoryFormatA8r8g8b8Premultiplied = 1
    fromEnum MemoryFormatR8g8b8a8Premultiplied = 2
    fromEnum MemoryFormatB8g8r8a8 = 3
    fromEnum MemoryFormatA8r8g8b8 = 4
    fromEnum MemoryFormatR8g8b8a8 = 5
    fromEnum MemoryFormatA8b8g8r8 = 6
    fromEnum MemoryFormatR8g8b8 = 7
    fromEnum MemoryFormatB8g8r8 = 8
    fromEnum MemoryFormatR16g16b16 = 9
    fromEnum MemoryFormatR16g16b16a16Premultiplied = 10
    fromEnum MemoryFormatR16g16b16a16 = 11
    fromEnum MemoryFormatR16g16b16Float = 12
    fromEnum MemoryFormatR16g16b16a16FloatPremultiplied = 13
    fromEnum MemoryFormatR16g16b16a16Float = 14
    fromEnum MemoryFormatR32g32b32Float = 15
    fromEnum MemoryFormatR32g32b32a32FloatPremultiplied = 16
    fromEnum MemoryFormatR32g32b32a32Float = 17
    fromEnum MemoryFormatG8a8Premultiplied = 18
    fromEnum MemoryFormatG8a8 = 19
    fromEnum MemoryFormatG8 = 20
    fromEnum MemoryFormatG16a16Premultiplied = 21
    fromEnum MemoryFormatG16a16 = 22
    fromEnum MemoryFormatG16 = 23
    fromEnum MemoryFormatA8 = 24
    fromEnum MemoryFormatA16 = 25
    fromEnum MemoryFormatA16Float = 26
    fromEnum MemoryFormatA32Float = 27
    fromEnum MemoryFormatA8b8g8r8Premultiplied = 28
    fromEnum MemoryFormatB8g8r8x8 = 29
    fromEnum MemoryFormatX8r8g8b8 = 30
    fromEnum MemoryFormatR8g8b8x8 = 31
    fromEnum MemoryFormatX8b8g8r8 = 32
    fromEnum MemoryFormatG8B8r8420 = 33
    fromEnum MemoryFormatG8R8b8420 = 34
    fromEnum MemoryFormatG8B8r8422 = 35
    fromEnum MemoryFormatG8R8b8422 = 36
    fromEnum MemoryFormatG8B8r8444 = 37
    fromEnum MemoryFormatG8R8b8444 = 38
    fromEnum MemoryFormatG10x6B10x6r10x6420 = 39
    fromEnum MemoryFormatG12x4B12x4r12x4420 = 40
    fromEnum MemoryFormatG16B16r16420 = 41
    fromEnum MemoryFormatG8B8R8410 = 42
    fromEnum MemoryFormatG8R8B8410 = 43
    fromEnum MemoryFormatG8B8R8411 = 44
    fromEnum MemoryFormatG8R8B8411 = 45
    fromEnum MemoryFormatG8B8R8420 = 46
    fromEnum MemoryFormatG8R8B8420 = 47
    fromEnum MemoryFormatG8B8R8422 = 48
    fromEnum MemoryFormatG8R8B8422 = 49
    fromEnum MemoryFormatG8B8R8444 = 50
    fromEnum MemoryFormatG8R8B8444 = 51
    fromEnum MemoryFormatG8b8g8r8422 = 52
    fromEnum MemoryFormatG8r8g8b8422 = 53
    fromEnum MemoryFormatR8g8b8g8422 = 54
    fromEnum MemoryFormatB8g8r8g8422 = 55
    fromEnum MemoryFormatX6g10X6b10X6r10420 = 56
    fromEnum MemoryFormatX6g10X6b10X6r10422 = 57
    fromEnum MemoryFormatX6g10X6b10X6r10444 = 58
    fromEnum MemoryFormatX4g12X4b12X4r12420 = 59
    fromEnum MemoryFormatX4g12X4b12X4r12422 = 60
    fromEnum MemoryFormatX4g12X4b12X4r12444 = 61
    fromEnum MemoryFormatG16B16R16420 = 62
    fromEnum MemoryFormatG16B16R16422 = 63
    fromEnum MemoryFormatG16B16R16444 = 64
    fromEnum MemoryFormatNFormats = 65
    fromEnum (AnotherMemoryFormat k) = k

    toEnum 0 = MemoryFormatB8g8r8a8Premultiplied
    toEnum 1 = MemoryFormatA8r8g8b8Premultiplied
    toEnum 2 = MemoryFormatR8g8b8a8Premultiplied
    toEnum 3 = MemoryFormatB8g8r8a8
    toEnum 4 = MemoryFormatA8r8g8b8
    toEnum 5 = MemoryFormatR8g8b8a8
    toEnum 6 = MemoryFormatA8b8g8r8
    toEnum 7 = MemoryFormatR8g8b8
    toEnum 8 = MemoryFormatB8g8r8
    toEnum 9 = MemoryFormatR16g16b16
    toEnum 10 = MemoryFormatR16g16b16a16Premultiplied
    toEnum 11 = MemoryFormatR16g16b16a16
    toEnum 12 = MemoryFormatR16g16b16Float
    toEnum 13 = MemoryFormatR16g16b16a16FloatPremultiplied
    toEnum 14 = MemoryFormatR16g16b16a16Float
    toEnum 15 = MemoryFormatR32g32b32Float
    toEnum 16 = MemoryFormatR32g32b32a32FloatPremultiplied
    toEnum 17 = MemoryFormatR32g32b32a32Float
    toEnum 18 = MemoryFormatG8a8Premultiplied
    toEnum 19 = MemoryFormatG8a8
    toEnum 20 = MemoryFormatG8
    toEnum 21 = MemoryFormatG16a16Premultiplied
    toEnum 22 = MemoryFormatG16a16
    toEnum 23 = MemoryFormatG16
    toEnum 24 = MemoryFormatA8
    toEnum 25 = MemoryFormatA16
    toEnum 26 = MemoryFormatA16Float
    toEnum 27 = MemoryFormatA32Float
    toEnum 28 = MemoryFormatA8b8g8r8Premultiplied
    toEnum 29 = MemoryFormatB8g8r8x8
    toEnum 30 = MemoryFormatX8r8g8b8
    toEnum 31 = MemoryFormatR8g8b8x8
    toEnum 32 = MemoryFormatX8b8g8r8
    toEnum 33 = MemoryFormatG8B8r8420
    toEnum 34 = MemoryFormatG8R8b8420
    toEnum 35 = MemoryFormatG8B8r8422
    toEnum 36 = MemoryFormatG8R8b8422
    toEnum 37 = MemoryFormatG8B8r8444
    toEnum 38 = MemoryFormatG8R8b8444
    toEnum 39 = MemoryFormatG10x6B10x6r10x6420
    toEnum 40 = MemoryFormatG12x4B12x4r12x4420
    toEnum 41 = MemoryFormatG16B16r16420
    toEnum 42 = MemoryFormatG8B8R8410
    toEnum 43 = MemoryFormatG8R8B8410
    toEnum 44 = MemoryFormatG8B8R8411
    toEnum 45 = MemoryFormatG8R8B8411
    toEnum 46 = MemoryFormatG8B8R8420
    toEnum 47 = MemoryFormatG8R8B8420
    toEnum 48 = MemoryFormatG8B8R8422
    toEnum 49 = MemoryFormatG8R8B8422
    toEnum 50 = MemoryFormatG8B8R8444
    toEnum 51 = MemoryFormatG8R8B8444
    toEnum 52 = MemoryFormatG8b8g8r8422
    toEnum 53 = MemoryFormatG8r8g8b8422
    toEnum 54 = MemoryFormatR8g8b8g8422
    toEnum 55 = MemoryFormatB8g8r8g8422
    toEnum 56 = MemoryFormatX6g10X6b10X6r10420
    toEnum 57 = MemoryFormatX6g10X6b10X6r10422
    toEnum 58 = MemoryFormatX6g10X6b10X6r10444
    toEnum 59 = MemoryFormatX4g12X4b12X4r12420
    toEnum 60 = MemoryFormatX4g12X4b12X4r12422
    toEnum 61 = MemoryFormatX4g12X4b12X4r12444
    toEnum 62 = MemoryFormatG16B16R16420
    toEnum 63 = MemoryFormatG16B16R16422
    toEnum 64 = MemoryFormatG16B16R16444
    toEnum 65 = MemoryFormatNFormats
    toEnum k = AnotherMemoryFormat k

instance P.Ord MemoryFormat where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MemoryFormat = '[]
instance O.HasParentTypes MemoryFormat

foreign import ccall "gdk_memory_format_get_type" c_gdk_memory_format_get_type :: 
    IO GType

instance B.Types.TypedObject MemoryFormat where
    glibType = c_gdk_memory_format_get_type

instance B.Types.BoxedEnum MemoryFormat

-- Enum KeyMatch
-- | Describes how well an event matches a given keyval and modifiers.
-- 
-- @GdkKeyMatch@ values are returned by 'GI.Gdk.Objects.KeyEvent.keyEventMatches'.
data KeyMatch = 
      KeyMatchNone
    -- ^ The key event does not match
    | KeyMatchPartial
    -- ^ The key event matches if keyboard state
    --   (specifically, the currently active group) is ignored
    | KeyMatchExact
    -- ^ The key event matches
    | AnotherKeyMatch Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum KeyMatch where
    fromEnum KeyMatchNone = 0
    fromEnum KeyMatchPartial = 1
    fromEnum KeyMatchExact = 2
    fromEnum (AnotherKeyMatch k) = k

    toEnum 0 = KeyMatchNone
    toEnum 1 = KeyMatchPartial
    toEnum 2 = KeyMatchExact
    toEnum k = AnotherKeyMatch k

instance P.Ord KeyMatch where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes KeyMatch = '[]
instance O.HasParentTypes KeyMatch

foreign import ccall "gdk_key_match_get_type" c_gdk_key_match_get_type :: 
    IO GType

instance B.Types.TypedObject KeyMatch where
    glibType = c_gdk_key_match_get_type

instance B.Types.BoxedEnum KeyMatch

-- Enum InputSource
-- | An enumeration describing the type of an input device in general terms.
data InputSource = 
      InputSourceMouse
    -- ^ the device is a mouse. (This will be reported for the core
    --   pointer, even if it is something else, such as a trackball.)
    | InputSourcePen
    -- ^ the device is a stylus of a graphics tablet or similar device.
    | InputSourceKeyboard
    -- ^ the device is a keyboard.
    | InputSourceTouchscreen
    -- ^ the device is a direct-input touch device, such
    --   as a touchscreen or tablet
    | InputSourceTouchpad
    -- ^ the device is an indirect touch device, such
    --   as a touchpad
    | InputSourceTrackpoint
    -- ^ the device is a trackpoint
    | InputSourceTabletPad
    -- ^ the device is a \"pad\", a collection of buttons,
    --   rings and strips found in drawing tablets
    | AnotherInputSource Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum InputSource where
    fromEnum InputSourceMouse = 0
    fromEnum InputSourcePen = 1
    fromEnum InputSourceKeyboard = 2
    fromEnum InputSourceTouchscreen = 3
    fromEnum InputSourceTouchpad = 4
    fromEnum InputSourceTrackpoint = 5
    fromEnum InputSourceTabletPad = 6
    fromEnum (AnotherInputSource k) = k

    toEnum 0 = InputSourceMouse
    toEnum 1 = InputSourcePen
    toEnum 2 = InputSourceKeyboard
    toEnum 3 = InputSourceTouchscreen
    toEnum 4 = InputSourceTouchpad
    toEnum 5 = InputSourceTrackpoint
    toEnum 6 = InputSourceTabletPad
    toEnum k = AnotherInputSource k

instance P.Ord InputSource where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes InputSource = '[]
instance O.HasParentTypes InputSource

foreign import ccall "gdk_input_source_get_type" c_gdk_input_source_get_type :: 
    IO GType

instance B.Types.TypedObject InputSource where
    glibType = c_gdk_input_source_get_type

instance B.Types.BoxedEnum InputSource

-- Enum Gravity
-- | Defines the reference point of a surface and is used in @GdkPopupLayout@.
data Gravity = 
      GravityNorthWest
    -- ^ the reference point is at the top left corner.
    | GravityNorth
    -- ^ the reference point is in the middle of the top edge.
    | GravityNorthEast
    -- ^ the reference point is at the top right corner.
    | GravityWest
    -- ^ the reference point is at the middle of the left edge.
    | GravityCenter
    -- ^ the reference point is at the center of the surface.
    | GravityEast
    -- ^ the reference point is at the middle of the right edge.
    | GravitySouthWest
    -- ^ the reference point is at the lower left corner.
    | GravitySouth
    -- ^ the reference point is at the middle of the lower edge.
    | GravitySouthEast
    -- ^ the reference point is at the lower right corner.
    | GravityStatic
    -- ^ the reference point is at the top left corner of the
    --  surface itself, ignoring window manager decorations.
    | AnotherGravity Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Gravity where
    fromEnum GravityNorthWest = 1
    fromEnum GravityNorth = 2
    fromEnum GravityNorthEast = 3
    fromEnum GravityWest = 4
    fromEnum GravityCenter = 5
    fromEnum GravityEast = 6
    fromEnum GravitySouthWest = 7
    fromEnum GravitySouth = 8
    fromEnum GravitySouthEast = 9
    fromEnum GravityStatic = 10
    fromEnum (AnotherGravity k) = k

    toEnum 1 = GravityNorthWest
    toEnum 2 = GravityNorth
    toEnum 3 = GravityNorthEast
    toEnum 4 = GravityWest
    toEnum 5 = GravityCenter
    toEnum 6 = GravityEast
    toEnum 7 = GravitySouthWest
    toEnum 8 = GravitySouth
    toEnum 9 = GravitySouthEast
    toEnum 10 = GravityStatic
    toEnum k = AnotherGravity k

instance P.Ord Gravity where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Gravity = '[]
instance O.HasParentTypes Gravity

foreign import ccall "gdk_gravity_get_type" c_gdk_gravity_get_type :: 
    IO GType

instance B.Types.TypedObject Gravity where
    glibType = c_gdk_gravity_get_type

instance B.Types.BoxedEnum Gravity

-- Enum GLError
-- | Error enumeration for @GdkGLContext@.
data GLError = 
      GLErrorNotAvailable
    -- ^ OpenGL support is not available
    | GLErrorUnsupportedFormat
    -- ^ The requested visual format is not supported
    | GLErrorUnsupportedProfile
    -- ^ The requested profile is not supported
    | GLErrorCompilationFailed
    -- ^ The shader compilation failed
    | GLErrorLinkFailed
    -- ^ The shader linking failed
    | AnotherGLError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GLError where
    fromEnum GLErrorNotAvailable = 0
    fromEnum GLErrorUnsupportedFormat = 1
    fromEnum GLErrorUnsupportedProfile = 2
    fromEnum GLErrorCompilationFailed = 3
    fromEnum GLErrorLinkFailed = 4
    fromEnum (AnotherGLError k) = k

    toEnum 0 = GLErrorNotAvailable
    toEnum 1 = GLErrorUnsupportedFormat
    toEnum 2 = GLErrorUnsupportedProfile
    toEnum 3 = GLErrorCompilationFailed
    toEnum 4 = GLErrorLinkFailed
    toEnum k = AnotherGLError k

instance P.Ord GLError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass GLError where
    gerrorClassDomain _ = "gdk-gl-error-quark"

-- | Catch exceptions of type `GLError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchGLError ::
    IO a ->
    (GLError -> GErrorMessage -> IO a) ->
    IO a
catchGLError = catchGErrorJustDomain

-- | Handle exceptions of type `GLError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleGLError ::
    (GLError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleGLError = handleGErrorJustDomain

type instance O.ParentTypes GLError = '[]
instance O.HasParentTypes GLError

foreign import ccall "gdk_gl_error_get_type" c_gdk_gl_error_get_type :: 
    IO GType

instance B.Types.TypedObject GLError where
    glibType = c_gdk_gl_error_get_type

instance B.Types.BoxedEnum GLError

-- Enum FullscreenMode
-- | Indicates which monitor a surface should span over when in fullscreen mode.
data FullscreenMode = 
      FullscreenModeCurrentMonitor
    -- ^ Fullscreen on current monitor only.
    | FullscreenModeAllMonitors
    -- ^ Span across all monitors when fullscreen.
    | AnotherFullscreenMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FullscreenMode where
    fromEnum FullscreenModeCurrentMonitor = 0
    fromEnum FullscreenModeAllMonitors = 1
    fromEnum (AnotherFullscreenMode k) = k

    toEnum 0 = FullscreenModeCurrentMonitor
    toEnum 1 = FullscreenModeAllMonitors
    toEnum k = AnotherFullscreenMode k

instance P.Ord FullscreenMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FullscreenMode = '[]
instance O.HasParentTypes FullscreenMode

foreign import ccall "gdk_fullscreen_mode_get_type" c_gdk_fullscreen_mode_get_type :: 
    IO GType

instance B.Types.TypedObject FullscreenMode where
    glibType = c_gdk_fullscreen_mode_get_type

instance B.Types.BoxedEnum FullscreenMode

-- Enum EventType
-- | Specifies the type of the event.
data EventType = 
      EventTypeDelete
    -- ^ the window manager has requested that the toplevel surface be
    --   hidden or destroyed, usually when the user clicks on a special icon in the
    --   title bar.
    | EventTypeMotionNotify
    -- ^ the pointer (usually a mouse) has moved.
    | EventTypeButtonPress
    -- ^ a mouse button has been pressed.
    | EventTypeButtonRelease
    -- ^ a mouse button has been released.
    | EventTypeKeyPress
    -- ^ a key has been pressed.
    | EventTypeKeyRelease
    -- ^ a key has been released.
    | EventTypeEnterNotify
    -- ^ the pointer has entered the surface.
    | EventTypeLeaveNotify
    -- ^ the pointer has left the surface.
    | EventTypeFocusChange
    -- ^ the keyboard focus has entered or left the surface.
    | EventTypeProximityIn
    -- ^ an input device has moved into contact with a sensing
    --   surface (e.g. a touchscreen or graphics tablet).
    | EventTypeProximityOut
    -- ^ an input device has moved out of contact with a sensing
    --   surface.
    | EventTypeDragEnter
    -- ^ the mouse has entered the surface while a drag is in progress.
    | EventTypeDragLeave
    -- ^ the mouse has left the surface while a drag is in progress.
    | EventTypeDragMotion
    -- ^ the mouse has moved in the surface while a drag is in
    --   progress.
    | EventTypeDropStart
    -- ^ a drop operation onto the surface has started.
    | EventTypeScroll
    -- ^ the scroll wheel was turned
    | EventTypeGrabBroken
    -- ^ a pointer or keyboard grab was broken.
    | EventTypeTouchBegin
    -- ^ A new touch event sequence has just started.
    | EventTypeTouchUpdate
    -- ^ A touch event sequence has been updated.
    | EventTypeTouchEnd
    -- ^ A touch event sequence has finished.
    | EventTypeTouchCancel
    -- ^ A touch event sequence has been canceled.
    | EventTypeTouchpadSwipe
    -- ^ A touchpad swipe gesture event, the current state
    --   is determined by its phase field.
    | EventTypeTouchpadPinch
    -- ^ A touchpad pinch gesture event, the current state
    --   is determined by its phase field.
    | EventTypePadButtonPress
    -- ^ A tablet pad button press event.
    | EventTypePadButtonRelease
    -- ^ A tablet pad button release event.
    | EventTypePadRing
    -- ^ A tablet pad axis event from a \"ring\".
    | EventTypePadStrip
    -- ^ A tablet pad axis event from a \"strip\".
    | EventTypePadGroupMode
    -- ^ A tablet pad group mode change.
    | EventTypeTouchpadHold
    -- ^ A touchpad hold gesture event, the current state is determined by its phase
    -- field.
    -- 
    -- /Since: 4.6/
    | EventTypePadDial
    -- ^ A tablet pad axis event from a \"dial\".
    | EventTypeEventLast
    -- ^ marks the end of the GdkEventType enumeration.
    | AnotherEventType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EventType where
    fromEnum EventTypeDelete = 0
    fromEnum EventTypeMotionNotify = 1
    fromEnum EventTypeButtonPress = 2
    fromEnum EventTypeButtonRelease = 3
    fromEnum EventTypeKeyPress = 4
    fromEnum EventTypeKeyRelease = 5
    fromEnum EventTypeEnterNotify = 6
    fromEnum EventTypeLeaveNotify = 7
    fromEnum EventTypeFocusChange = 8
    fromEnum EventTypeProximityIn = 9
    fromEnum EventTypeProximityOut = 10
    fromEnum EventTypeDragEnter = 11
    fromEnum EventTypeDragLeave = 12
    fromEnum EventTypeDragMotion = 13
    fromEnum EventTypeDropStart = 14
    fromEnum EventTypeScroll = 15
    fromEnum EventTypeGrabBroken = 16
    fromEnum EventTypeTouchBegin = 17
    fromEnum EventTypeTouchUpdate = 18
    fromEnum EventTypeTouchEnd = 19
    fromEnum EventTypeTouchCancel = 20
    fromEnum EventTypeTouchpadSwipe = 21
    fromEnum EventTypeTouchpadPinch = 22
    fromEnum EventTypePadButtonPress = 23
    fromEnum EventTypePadButtonRelease = 24
    fromEnum EventTypePadRing = 25
    fromEnum EventTypePadStrip = 26
    fromEnum EventTypePadGroupMode = 27
    fromEnum EventTypeTouchpadHold = 28
    fromEnum EventTypePadDial = 29
    fromEnum EventTypeEventLast = 30
    fromEnum (AnotherEventType k) = k

    toEnum 0 = EventTypeDelete
    toEnum 1 = EventTypeMotionNotify
    toEnum 2 = EventTypeButtonPress
    toEnum 3 = EventTypeButtonRelease
    toEnum 4 = EventTypeKeyPress
    toEnum 5 = EventTypeKeyRelease
    toEnum 6 = EventTypeEnterNotify
    toEnum 7 = EventTypeLeaveNotify
    toEnum 8 = EventTypeFocusChange
    toEnum 9 = EventTypeProximityIn
    toEnum 10 = EventTypeProximityOut
    toEnum 11 = EventTypeDragEnter
    toEnum 12 = EventTypeDragLeave
    toEnum 13 = EventTypeDragMotion
    toEnum 14 = EventTypeDropStart
    toEnum 15 = EventTypeScroll
    toEnum 16 = EventTypeGrabBroken
    toEnum 17 = EventTypeTouchBegin
    toEnum 18 = EventTypeTouchUpdate
    toEnum 19 = EventTypeTouchEnd
    toEnum 20 = EventTypeTouchCancel
    toEnum 21 = EventTypeTouchpadSwipe
    toEnum 22 = EventTypeTouchpadPinch
    toEnum 23 = EventTypePadButtonPress
    toEnum 24 = EventTypePadButtonRelease
    toEnum 25 = EventTypePadRing
    toEnum 26 = EventTypePadStrip
    toEnum 27 = EventTypePadGroupMode
    toEnum 28 = EventTypeTouchpadHold
    toEnum 29 = EventTypePadDial
    toEnum 30 = EventTypeEventLast
    toEnum k = AnotherEventType k

instance P.Ord EventType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EventType = '[]
instance O.HasParentTypes EventType

foreign import ccall "gdk_event_type_get_type" c_gdk_event_type_get_type :: 
    IO GType

instance B.Types.TypedObject EventType where
    glibType = c_gdk_event_type_get_type

instance B.Types.BoxedEnum EventType

-- Enum DragCancelReason
-- | Used in @GdkDrag@ to the reason of a cancelled DND operation.
data DragCancelReason = 
      DragCancelReasonNoTarget
    -- ^ There is no suitable drop target.
    | DragCancelReasonUserCancelled
    -- ^ Drag cancelled by the user
    | DragCancelReasonError
    -- ^ Unspecified error.
    | AnotherDragCancelReason Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DragCancelReason where
    fromEnum DragCancelReasonNoTarget = 0
    fromEnum DragCancelReasonUserCancelled = 1
    fromEnum DragCancelReasonError = 2
    fromEnum (AnotherDragCancelReason k) = k

    toEnum 0 = DragCancelReasonNoTarget
    toEnum 1 = DragCancelReasonUserCancelled
    toEnum 2 = DragCancelReasonError
    toEnum k = AnotherDragCancelReason k

instance P.Ord DragCancelReason where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DragCancelReason = '[]
instance O.HasParentTypes DragCancelReason

foreign import ccall "gdk_drag_cancel_reason_get_type" c_gdk_drag_cancel_reason_get_type :: 
    IO GType

instance B.Types.TypedObject DragCancelReason where
    glibType = c_gdk_drag_cancel_reason_get_type

instance B.Types.BoxedEnum DragCancelReason

-- Enum DmabufError
-- | Error enumeration for @GdkDmabufTexture@.
-- 
-- /Since: 4.14/
data DmabufError = 
      DmabufErrorNotAvailable
    -- ^ Dmabuf support is not available, because the OS
    --   is not Linux, or it was explicitly disabled at compile- or runtime
    | DmabufErrorUnsupportedFormat
    -- ^ The requested format is not supported
    | DmabufErrorCreationFailed
    -- ^ GTK failed to create the resource for other
    --   reasons
    | AnotherDmabufError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DmabufError where
    fromEnum DmabufErrorNotAvailable = 0
    fromEnum DmabufErrorUnsupportedFormat = 1
    fromEnum DmabufErrorCreationFailed = 2
    fromEnum (AnotherDmabufError k) = k

    toEnum 0 = DmabufErrorNotAvailable
    toEnum 1 = DmabufErrorUnsupportedFormat
    toEnum 2 = DmabufErrorCreationFailed
    toEnum k = AnotherDmabufError k

instance P.Ord DmabufError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass DmabufError where
    gerrorClassDomain _ = "gdk-dmabuf-error-quark"

-- | Catch exceptions of type `DmabufError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchDmabufError ::
    IO a ->
    (DmabufError -> GErrorMessage -> IO a) ->
    IO a
catchDmabufError = catchGErrorJustDomain

-- | Handle exceptions of type `DmabufError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleDmabufError ::
    (DmabufError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleDmabufError = handleGErrorJustDomain

type instance O.ParentTypes DmabufError = '[]
instance O.HasParentTypes DmabufError

foreign import ccall "gdk_dmabuf_error_get_type" c_gdk_dmabuf_error_get_type :: 
    IO GType

instance B.Types.TypedObject DmabufError where
    glibType = c_gdk_dmabuf_error_get_type

instance B.Types.BoxedEnum DmabufError

-- Enum DeviceToolType
-- | Indicates the specific type of tool being used being a tablet. Such as an
-- airbrush, pencil, etc.
data DeviceToolType = 
      DeviceToolTypeUnknown
    -- ^ Tool is of an unknown type.
    | DeviceToolTypePen
    -- ^ Tool is a standard tablet stylus.
    | DeviceToolTypeEraser
    -- ^ Tool is standard tablet eraser.
    | DeviceToolTypeBrush
    -- ^ Tool is a brush stylus.
    | DeviceToolTypePencil
    -- ^ Tool is a pencil stylus.
    | DeviceToolTypeAirbrush
    -- ^ Tool is an airbrush stylus.
    | DeviceToolTypeMouse
    -- ^ Tool is a mouse.
    | DeviceToolTypeLens
    -- ^ Tool is a lens cursor.
    | AnotherDeviceToolType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DeviceToolType where
    fromEnum DeviceToolTypeUnknown = 0
    fromEnum DeviceToolTypePen = 1
    fromEnum DeviceToolTypeEraser = 2
    fromEnum DeviceToolTypeBrush = 3
    fromEnum DeviceToolTypePencil = 4
    fromEnum DeviceToolTypeAirbrush = 5
    fromEnum DeviceToolTypeMouse = 6
    fromEnum DeviceToolTypeLens = 7
    fromEnum (AnotherDeviceToolType k) = k

    toEnum 0 = DeviceToolTypeUnknown
    toEnum 1 = DeviceToolTypePen
    toEnum 2 = DeviceToolTypeEraser
    toEnum 3 = DeviceToolTypeBrush
    toEnum 4 = DeviceToolTypePencil
    toEnum 5 = DeviceToolTypeAirbrush
    toEnum 6 = DeviceToolTypeMouse
    toEnum 7 = DeviceToolTypeLens
    toEnum k = AnotherDeviceToolType k

instance P.Ord DeviceToolType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DeviceToolType = '[]
instance O.HasParentTypes DeviceToolType

foreign import ccall "gdk_device_tool_type_get_type" c_gdk_device_tool_type_get_type :: 
    IO GType

instance B.Types.TypedObject DeviceToolType where
    glibType = c_gdk_device_tool_type_get_type

instance B.Types.BoxedEnum DeviceToolType

-- Enum DevicePadFeature
-- | A pad feature.
data DevicePadFeature = 
      DevicePadFeatureButton
    -- ^ a button
    | DevicePadFeatureRing
    -- ^ a ring-shaped interactive area
    | DevicePadFeatureStrip
    -- ^ a straight interactive area
    | AnotherDevicePadFeature Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DevicePadFeature where
    fromEnum DevicePadFeatureButton = 0
    fromEnum DevicePadFeatureRing = 1
    fromEnum DevicePadFeatureStrip = 2
    fromEnum (AnotherDevicePadFeature k) = k

    toEnum 0 = DevicePadFeatureButton
    toEnum 1 = DevicePadFeatureRing
    toEnum 2 = DevicePadFeatureStrip
    toEnum k = AnotherDevicePadFeature k

instance P.Ord DevicePadFeature where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DevicePadFeature = '[]
instance O.HasParentTypes DevicePadFeature

foreign import ccall "gdk_device_pad_feature_get_type" c_gdk_device_pad_feature_get_type :: 
    IO GType

instance B.Types.TypedObject DevicePadFeature where
    glibType = c_gdk_device_pad_feature_get_type

instance B.Types.BoxedEnum DevicePadFeature

-- Enum CrossingMode
-- | Specifies the crossing mode for enter and leave events.
data CrossingMode = 
      CrossingModeNormal
    -- ^ crossing because of pointer motion.
    | CrossingModeGrab
    -- ^ crossing because a grab is activated.
    | CrossingModeUngrab
    -- ^ crossing because a grab is deactivated.
    | CrossingModeGtkGrab
    -- ^ crossing because a GTK grab is activated.
    | CrossingModeGtkUngrab
    -- ^ crossing because a GTK grab is deactivated.
    | CrossingModeStateChanged
    -- ^ crossing because a GTK widget changed
    --   state (e.g. sensitivity).
    | CrossingModeTouchBegin
    -- ^ crossing because a touch sequence has begun,
    --   this event is synthetic as the pointer might have not left the surface.
    | CrossingModeTouchEnd
    -- ^ crossing because a touch sequence has ended,
    --   this event is synthetic as the pointer might have not left the surface.
    | CrossingModeDeviceSwitch
    -- ^ crossing because of a device switch (i.e.
    --   a mouse taking control of the pointer after a touch device), this event
    --   is synthetic as the pointer didn’t leave the surface.
    | AnotherCrossingMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CrossingMode where
    fromEnum CrossingModeNormal = 0
    fromEnum CrossingModeGrab = 1
    fromEnum CrossingModeUngrab = 2
    fromEnum CrossingModeGtkGrab = 3
    fromEnum CrossingModeGtkUngrab = 4
    fromEnum CrossingModeStateChanged = 5
    fromEnum CrossingModeTouchBegin = 6
    fromEnum CrossingModeTouchEnd = 7
    fromEnum CrossingModeDeviceSwitch = 8
    fromEnum (AnotherCrossingMode k) = k

    toEnum 0 = CrossingModeNormal
    toEnum 1 = CrossingModeGrab
    toEnum 2 = CrossingModeUngrab
    toEnum 3 = CrossingModeGtkGrab
    toEnum 4 = CrossingModeGtkUngrab
    toEnum 5 = CrossingModeStateChanged
    toEnum 6 = CrossingModeTouchBegin
    toEnum 7 = CrossingModeTouchEnd
    toEnum 8 = CrossingModeDeviceSwitch
    toEnum k = AnotherCrossingMode k

instance P.Ord CrossingMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CrossingMode = '[]
instance O.HasParentTypes CrossingMode

foreign import ccall "gdk_crossing_mode_get_type" c_gdk_crossing_mode_get_type :: 
    IO GType

instance B.Types.TypedObject CrossingMode where
    glibType = c_gdk_crossing_mode_get_type

instance B.Types.BoxedEnum CrossingMode

-- Enum CicpRange
-- | The values of this enumeration describe whether image data uses
-- the full range of 8-bit values.
-- 
-- In digital broadcasting, it is common to reserve the lowest and
-- highest values. Typically the allowed values for the narrow range
-- are 16-235 for Y and 16-240 for u,v (when dealing with YUV data).
-- 
-- /Since: 4.16/
data CicpRange = 
      CicpRangeNarrow
    -- ^ The values use the range of 16-235 (for Y) and 16-240 for u and v.
    | CicpRangeFull
    -- ^ The values use the full range.
    | AnotherCicpRange Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CicpRange where
    fromEnum CicpRangeNarrow = 0
    fromEnum CicpRangeFull = 1
    fromEnum (AnotherCicpRange k) = k

    toEnum 0 = CicpRangeNarrow
    toEnum 1 = CicpRangeFull
    toEnum k = AnotherCicpRange k

instance P.Ord CicpRange where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CicpRange = '[]
instance O.HasParentTypes CicpRange

foreign import ccall "gdk_cicp_range_get_type" c_gdk_cicp_range_get_type :: 
    IO GType

instance B.Types.TypedObject CicpRange where
    glibType = c_gdk_cicp_range_get_type

instance B.Types.BoxedEnum CicpRange

-- Enum AxisUse
-- | Defines how device axes are interpreted by GTK.
-- 
-- Note that the X and Y axes are not really needed; pointer devices
-- report their location via the x\/y members of events regardless. Whether
-- X and Y are present as axes depends on the GDK backend.
data AxisUse = 
      AxisUseIgnore
    -- ^ the axis is ignored.
    | AxisUseX
    -- ^ the axis is used as the x axis.
    | AxisUseY
    -- ^ the axis is used as the y axis.
    | AxisUseDeltaX
    -- ^ the axis is used as the scroll x delta
    | AxisUseDeltaY
    -- ^ the axis is used as the scroll y delta
    | AxisUsePressure
    -- ^ the axis is used for pressure information.
    | AxisUseXtilt
    -- ^ the axis is used for x tilt information.
    | AxisUseYtilt
    -- ^ the axis is used for y tilt information.
    | AxisUseWheel
    -- ^ the axis is used for wheel information.
    | AxisUseDistance
    -- ^ the axis is used for pen\/tablet distance information
    | AxisUseRotation
    -- ^ the axis is used for pen rotation information
    | AxisUseSlider
    -- ^ the axis is used for pen slider information
    | AxisUseLast
    -- ^ a constant equal to the numerically highest axis value.
    | AnotherAxisUse Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AxisUse where
    fromEnum AxisUseIgnore = 0
    fromEnum AxisUseX = 1
    fromEnum AxisUseY = 2
    fromEnum AxisUseDeltaX = 3
    fromEnum AxisUseDeltaY = 4
    fromEnum AxisUsePressure = 5
    fromEnum AxisUseXtilt = 6
    fromEnum AxisUseYtilt = 7
    fromEnum AxisUseWheel = 8
    fromEnum AxisUseDistance = 9
    fromEnum AxisUseRotation = 10
    fromEnum AxisUseSlider = 11
    fromEnum AxisUseLast = 12
    fromEnum (AnotherAxisUse k) = k

    toEnum 0 = AxisUseIgnore
    toEnum 1 = AxisUseX
    toEnum 2 = AxisUseY
    toEnum 3 = AxisUseDeltaX
    toEnum 4 = AxisUseDeltaY
    toEnum 5 = AxisUsePressure
    toEnum 6 = AxisUseXtilt
    toEnum 7 = AxisUseYtilt
    toEnum 8 = AxisUseWheel
    toEnum 9 = AxisUseDistance
    toEnum 10 = AxisUseRotation
    toEnum 11 = AxisUseSlider
    toEnum 12 = AxisUseLast
    toEnum k = AnotherAxisUse k

instance P.Ord AxisUse where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AxisUse = '[]
instance O.HasParentTypes AxisUse

foreign import ccall "gdk_axis_use_get_type" c_gdk_axis_use_get_type :: 
    IO GType

instance B.Types.TypedObject AxisUse where
    glibType = c_gdk_axis_use_get_type

instance B.Types.BoxedEnum AxisUse


