// Copyright Istio Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: dns/proto/nds.proto

package istio_networking_nds_v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Table of hostnames and their IPs to br used for DNS resolution at the agent
// Sent by istiod to istio agents via xds
type NameTable struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Map of hostname to resolution attributes.
	Table         map[string]*NameTable_NameInfo `protobuf:"bytes,1,rep,name=table,proto3" json:"table,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NameTable) Reset() {
	*x = NameTable{}
	mi := &file_dns_proto_nds_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NameTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NameTable) ProtoMessage() {}

func (x *NameTable) ProtoReflect() protoreflect.Message {
	mi := &file_dns_proto_nds_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NameTable.ProtoReflect.Descriptor instead.
func (*NameTable) Descriptor() ([]byte, []int) {
	return file_dns_proto_nds_proto_rawDescGZIP(), []int{0}
}

func (x *NameTable) GetTable() map[string]*NameTable_NameInfo {
	if x != nil {
		return x.Table
	}
	return nil
}

type NameTable_NameInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of IPs for the host.
	Ips []string `protobuf:"bytes,1,rep,name=ips,proto3" json:"ips,omitempty"`
	// The name of the service registry containing the service (e.g. 'Kubernetes').
	Registry string `protobuf:"bytes,2,opt,name=registry,proto3" json:"registry,omitempty"`
	// The k8s service name. Only applies when registry=`Kubernetes`
	Shortname string `protobuf:"bytes,3,opt,name=shortname,proto3" json:"shortname,omitempty"`
	// The k8s namespace for the service. Only applies when registry=`Kubernetes`
	Namespace string `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Deprecated. Was added for experimentation only.
	//
	// Deprecated: Marked as deprecated in dns/proto/nds.proto.
	AltHosts      []string `protobuf:"bytes,5,rep,name=alt_hosts,json=altHosts,proto3" json:"alt_hosts,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NameTable_NameInfo) Reset() {
	*x = NameTable_NameInfo{}
	mi := &file_dns_proto_nds_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NameTable_NameInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NameTable_NameInfo) ProtoMessage() {}

func (x *NameTable_NameInfo) ProtoReflect() protoreflect.Message {
	mi := &file_dns_proto_nds_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NameTable_NameInfo.ProtoReflect.Descriptor instead.
func (*NameTable_NameInfo) Descriptor() ([]byte, []int) {
	return file_dns_proto_nds_proto_rawDescGZIP(), []int{0, 0}
}

func (x *NameTable_NameInfo) GetIps() []string {
	if x != nil {
		return x.Ips
	}
	return nil
}

func (x *NameTable_NameInfo) GetRegistry() string {
	if x != nil {
		return x.Registry
	}
	return ""
}

func (x *NameTable_NameInfo) GetShortname() string {
	if x != nil {
		return x.Shortname
	}
	return ""
}

func (x *NameTable_NameInfo) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// Deprecated: Marked as deprecated in dns/proto/nds.proto.
func (x *NameTable_NameInfo) GetAltHosts() []string {
	if x != nil {
		return x.AltHosts
	}
	return nil
}

var File_dns_proto_nds_proto protoreflect.FileDescriptor

const file_dns_proto_nds_proto_rawDesc = "" +
	"\n" +
	"\x13dns/proto/nds.proto\x12\x17istio.networking.nds.v1\"\xcf\x02\n" +
	"\tNameTable\x12C\n" +
	"\x05table\x18\x01 \x03(\v2-.istio.networking.nds.v1.NameTable.TableEntryR\x05table\x1a\x95\x01\n" +
	"\bNameInfo\x12\x10\n" +
	"\x03ips\x18\x01 \x03(\tR\x03ips\x12\x1a\n" +
	"\bregistry\x18\x02 \x01(\tR\bregistry\x12\x1c\n" +
	"\tshortname\x18\x03 \x01(\tR\tshortname\x12\x1c\n" +
	"\tnamespace\x18\x04 \x01(\tR\tnamespace\x12\x1f\n" +
	"\talt_hosts\x18\x05 \x03(\tB\x02\x18\x01R\baltHosts\x1ae\n" +
	"\n" +
	"TableEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12A\n" +
	"\x05value\x18\x02 \x01(\v2+.istio.networking.nds.v1.NameTable.NameInfoR\x05value:\x028\x01B6Z4istio.io/istio/pkg/dns/proto/istio_networking_nds_v1b\x06proto3"

var (
	file_dns_proto_nds_proto_rawDescOnce sync.Once
	file_dns_proto_nds_proto_rawDescData []byte
)

func file_dns_proto_nds_proto_rawDescGZIP() []byte {
	file_dns_proto_nds_proto_rawDescOnce.Do(func() {
		file_dns_proto_nds_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_dns_proto_nds_proto_rawDesc), len(file_dns_proto_nds_proto_rawDesc)))
	})
	return file_dns_proto_nds_proto_rawDescData
}

var file_dns_proto_nds_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_dns_proto_nds_proto_goTypes = []any{
	(*NameTable)(nil),          // 0: istio.networking.nds.v1.NameTable
	(*NameTable_NameInfo)(nil), // 1: istio.networking.nds.v1.NameTable.NameInfo
	nil,                        // 2: istio.networking.nds.v1.NameTable.TableEntry
}
var file_dns_proto_nds_proto_depIdxs = []int32{
	2, // 0: istio.networking.nds.v1.NameTable.table:type_name -> istio.networking.nds.v1.NameTable.TableEntry
	1, // 1: istio.networking.nds.v1.NameTable.TableEntry.value:type_name -> istio.networking.nds.v1.NameTable.NameInfo
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_dns_proto_nds_proto_init() }
func file_dns_proto_nds_proto_init() {
	if File_dns_proto_nds_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_dns_proto_nds_proto_rawDesc), len(file_dns_proto_nds_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_dns_proto_nds_proto_goTypes,
		DependencyIndexes: file_dns_proto_nds_proto_depIdxs,
		MessageInfos:      file_dns_proto_nds_proto_msgTypes,
	}.Build()
	File_dns_proto_nds_proto = out.File
	file_dns_proto_nds_proto_goTypes = nil
	file_dns_proto_nds_proto_depIdxs = nil
}
