/* Generated by wayland-scanner 1.24.0 */

#ifndef KEYSTATE_SERVER_PROTOCOL_H
#define KEYSTATE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_keystate The keystate protocol
 * @section page_ifaces_keystate Interfaces
 * - @subpage page_iface_org_kde_kwin_keystate - Key States
 * @section page_copyright_keystate Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2019 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_keystate;

#ifndef ORG_KDE_KWIN_KEYSTATE_INTERFACE
#define ORG_KDE_KWIN_KEYSTATE_INTERFACE
/**
 * @page page_iface_org_kde_kwin_keystate org_kde_kwin_keystate
 * @section page_iface_org_kde_kwin_keystate_desc Description
 *
 * Keeps track of the states of the different keys that have a state attached to it.
 * @section page_iface_org_kde_kwin_keystate_api API
 * See @ref iface_org_kde_kwin_keystate.
 */
/**
 * @defgroup iface_org_kde_kwin_keystate The org_kde_kwin_keystate interface
 *
 * Keeps track of the states of the different keys that have a state attached to it.
 */
extern const struct wl_interface org_kde_kwin_keystate_interface;
#endif

#ifndef ORG_KDE_KWIN_KEYSTATE_KEY_ENUM
#define ORG_KDE_KWIN_KEYSTATE_KEY_ENUM
enum org_kde_kwin_keystate_key {
	ORG_KDE_KWIN_KEYSTATE_KEY_CAPSLOCK = 0,
	ORG_KDE_KWIN_KEYSTATE_KEY_NUMLOCK = 1,
	ORG_KDE_KWIN_KEYSTATE_KEY_SCROLLLOCK = 2,
	/**
	 * @since 5
	 */
	ORG_KDE_KWIN_KEYSTATE_KEY_ALT = 3,
	/**
	 * @since 5
	 */
	ORG_KDE_KWIN_KEYSTATE_KEY_CONTROL = 4,
	/**
	 * @since 5
	 */
	ORG_KDE_KWIN_KEYSTATE_KEY_SHIFT = 5,
	/**
	 * @since 5
	 */
	ORG_KDE_KWIN_KEYSTATE_KEY_META = 6,
	/**
	 * @since 5
	 */
	ORG_KDE_KWIN_KEYSTATE_KEY_ALTGR = 7,
};
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_KEY_ALT_SINCE_VERSION 5
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_KEY_CONTROL_SINCE_VERSION 5
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_KEY_SHIFT_SINCE_VERSION 5
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_KEY_META_SINCE_VERSION 5
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_KEY_ALTGR_SINCE_VERSION 5
#endif /* ORG_KDE_KWIN_KEYSTATE_KEY_ENUM */

#ifndef ORG_KDE_KWIN_KEYSTATE_KEY_ENUM_IS_VALID
#define ORG_KDE_KWIN_KEYSTATE_KEY_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_kwin_keystate
 * Validate a org_kde_kwin_keystate key value.
 *
 * @return true on success, false on error.
 * @ref org_kde_kwin_keystate_key
 */
static inline bool
org_kde_kwin_keystate_key_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_KWIN_KEYSTATE_KEY_CAPSLOCK:
		return version >= 1;
	case ORG_KDE_KWIN_KEYSTATE_KEY_NUMLOCK:
		return version >= 1;
	case ORG_KDE_KWIN_KEYSTATE_KEY_SCROLLLOCK:
		return version >= 1;
	case ORG_KDE_KWIN_KEYSTATE_KEY_ALT:
		return version >= 5;
	case ORG_KDE_KWIN_KEYSTATE_KEY_CONTROL:
		return version >= 5;
	case ORG_KDE_KWIN_KEYSTATE_KEY_SHIFT:
		return version >= 5;
	case ORG_KDE_KWIN_KEYSTATE_KEY_META:
		return version >= 5;
	case ORG_KDE_KWIN_KEYSTATE_KEY_ALTGR:
		return version >= 5;
	default:
		return false;
	}
}
#endif /* ORG_KDE_KWIN_KEYSTATE_KEY_ENUM_IS_VALID */

#ifndef ORG_KDE_KWIN_KEYSTATE_STATE_ENUM
#define ORG_KDE_KWIN_KEYSTATE_STATE_ENUM
enum org_kde_kwin_keystate_state {
	ORG_KDE_KWIN_KEYSTATE_STATE_UNLOCKED = 0,
	ORG_KDE_KWIN_KEYSTATE_STATE_LATCHED = 1,
	ORG_KDE_KWIN_KEYSTATE_STATE_LOCKED = 2,
	/**
	 * @since 5
	 */
	ORG_KDE_KWIN_KEYSTATE_STATE_PRESSED = 3,
};
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_STATE_PRESSED_SINCE_VERSION 5
#endif /* ORG_KDE_KWIN_KEYSTATE_STATE_ENUM */

#ifndef ORG_KDE_KWIN_KEYSTATE_STATE_ENUM_IS_VALID
#define ORG_KDE_KWIN_KEYSTATE_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_kwin_keystate
 * Validate a org_kde_kwin_keystate state value.
 *
 * @return true on success, false on error.
 * @ref org_kde_kwin_keystate_state
 */
static inline bool
org_kde_kwin_keystate_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_KWIN_KEYSTATE_STATE_UNLOCKED:
		return version >= 1;
	case ORG_KDE_KWIN_KEYSTATE_STATE_LATCHED:
		return version >= 1;
	case ORG_KDE_KWIN_KEYSTATE_STATE_LOCKED:
		return version >= 1;
	case ORG_KDE_KWIN_KEYSTATE_STATE_PRESSED:
		return version >= 5;
	default:
		return false;
	}
}
#endif /* ORG_KDE_KWIN_KEYSTATE_STATE_ENUM_IS_VALID */

/**
 * @ingroup iface_org_kde_kwin_keystate
 * @struct org_kde_kwin_keystate_interface
 */
struct org_kde_kwin_keystate_interface {
	/**
	 */
	void (*fetchStates)(struct wl_client *client,
			    struct wl_resource *resource);
	/**
	 * @since 4
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ORG_KDE_KWIN_KEYSTATE_STATECHANGED 0

/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_STATECHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_FETCHSTATES_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_DESTROY_SINCE_VERSION 4

/**
 * @ingroup iface_org_kde_kwin_keystate
 * Sends an stateChanged event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_keystate_send_stateChanged(struct wl_resource *resource_, uint32_t key, uint32_t state)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_KEYSTATE_STATECHANGED, key, state);
}

#ifdef  __cplusplus
}
#endif

#endif
