/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Interface Declarations                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace rock {
/// Interface to abstract away gemm-wrapping operators in the rock dialect,
///     which mainly include convolutions that can be transformed to matrix
///     multiplications.
/// 
///     This should include functions to get common attributes.
class RockGemmWrapperInterface;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Interface to abstract away gemm-wrapping operators in the rock dialect,
///     which mainly include convolutions that can be transformed to matrix
///     multiplications.
/// 
///     This should include functions to get common attributes.
namespace detail {
struct RockGemmWrapperInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    ::mlir::rock::KernelType (*getKernelType)(const Concept *impl, ::mlir::Operation *);
    OpOperand *(*getOutArgument)(const Concept *impl, ::mlir::Operation *);
    ::mlir::rock::GemmSize (*getGemmSize)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getAType)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getBType)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getCType)(const Concept *impl, ::mlir::Operation *);
    std::optional<::mlir::rock::GemmFeatures> (*getGemmFeatures)(const Concept *impl, ::mlir::Operation *);
    ::mlir::rock::GemmFeaturesAttr (*getGemmFeaturesAttr)(const Concept *impl, ::mlir::Operation *);
    void (*setDerivedBlockSizeAttr)(const Concept *impl, ::mlir::Operation *, ::mlir::IntegerAttr);
    void (*setGridSizeAttr)(const Concept *impl, ::mlir::Operation *, ::mlir::IntegerAttr);
    void (*setGemmParamsAttr)(const Concept *impl, ::mlir::Operation *, ::mlir::Attribute);
    std::optional<RockTuningParamAttrInterface> (*getGemmParams)(const Concept *impl, ::mlir::Operation *);
    std::optional<uint32_t> (*getDerivedBlockSize)(const Concept *impl, ::mlir::Operation *);
    uint32_t (*getBlockSize)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::rock::RockGemmWrapperInterface;
    Model() : Concept{getKernelType, getOutArgument, getGemmSize, getAType, getBType, getCType, getGemmFeatures, getGemmFeaturesAttr, setDerivedBlockSizeAttr, setGridSizeAttr, setGemmParamsAttr, getGemmParams, getDerivedBlockSize, getBlockSize} {}

    static inline ::mlir::rock::KernelType getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline OpOperand *getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmSize getGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<::mlir::rock::GemmFeatures> getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setDerivedBlockSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr blockSize);
    static inline void setGridSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr gridSize);
    static inline void setGemmParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params);
    static inline std::optional<RockTuningParamAttrInterface> getGemmParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<uint32_t> getDerivedBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline uint32_t getBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::rock::RockGemmWrapperInterface;
    FallbackModel() : Concept{getKernelType, getOutArgument, getGemmSize, getAType, getBType, getCType, getGemmFeatures, getGemmFeaturesAttr, setDerivedBlockSizeAttr, setGridSizeAttr, setGemmParamsAttr, getGemmParams, getDerivedBlockSize, getBlockSize} {}

    static inline ::mlir::rock::KernelType getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline OpOperand *getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmSize getGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<::mlir::rock::GemmFeatures> getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setDerivedBlockSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr blockSize);
    static inline void setGridSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr gridSize);
    static inline void setGemmParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params);
    static inline std::optional<RockTuningParamAttrInterface> getGemmParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<uint32_t> getDerivedBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline uint32_t getBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    std::optional<::mlir::rock::GemmFeatures> getGemmFeatures(::mlir::Operation *tablegen_opaque_val) const;
    ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr(::mlir::Operation *tablegen_opaque_val) const;
    void setDerivedBlockSizeAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr blockSize) const;
    void setGridSizeAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr gridSize) const;
    void setGemmParamsAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) const;
    std::optional<RockTuningParamAttrInterface> getGemmParams(::mlir::Operation *tablegen_opaque_val) const;
    uint32_t getBlockSize(::mlir::Operation *tablegen_opaque_val) const;
  };
};
template <typename ConcreteOp>
struct RockGemmWrapperInterfaceTrait;

} // namespace detail
class RockGemmWrapperInterface : public ::mlir::OpInterface<RockGemmWrapperInterface, detail::RockGemmWrapperInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<RockGemmWrapperInterface, detail::RockGemmWrapperInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::RockGemmWrapperInterfaceTrait<ConcreteOp> {};

  /// Return the KernelType of this op
  ::mlir::rock::KernelType getKernelType();

  /// Return the OpOperand that corresponds to the operand argument
  /// that corresponds to the output result of the operation.
  OpOperand *getOutArgument();

  /// Return the size of the matrix multiplication that this op will eventually
  /// perform.
  ::mlir::rock::GemmSize getGemmSize();

  /// Return the element type of [what will become] matrix A for this operation.
  ::mlir::Type getAType();

  /// Return the element type of [what will become] matrix B for this operation.
  ::mlir::Type getBType();

  /// Return the element type of [what will become] matrix C for this operation.
  ::mlir::Type getCType();

  /// Return the optional features attribute of this op.
  std::optional<::mlir::rock::GemmFeatures> getGemmFeatures();

  /// Return the features attribute of this op.
  ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr();

  /// Set the block size attribute of this operation
  /// 
  /// This is needed for --affix-tuning-params to work and can go away if it does
  void setDerivedBlockSizeAttr(::mlir::IntegerAttr blockSize);

  /// Set the grid size attribute of this operation
  /// 
  /// This is needed for --affix-tuning-params to work and can go away if it does
  void setGridSizeAttr(::mlir::IntegerAttr gridSize);

  /// Set the tuning parameters attribute of this operation
  /// 
  /// This is needed for --affix-tuning-params to work and can go away if it does
  void setGemmParamsAttr(::mlir::Attribute params);

  /// Get the tuning parameters attribute of this operation
  std::optional<RockTuningParamAttrInterface> getGemmParams();

  /// Get the value of the derived block size attribute if it is set.
  std::optional<uint32_t> getDerivedBlockSize();

  /// Return the block size this operation will execute with if it has been selected
  /// or None otherwise. Prioritizes the block size defined in tuning parameters
  uint32_t getBlockSize();
};
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
namespace detail {
  template <typename ConcreteOp>
  struct RockGemmWrapperInterfaceTrait : public ::mlir::OpInterface<RockGemmWrapperInterface, detail::RockGemmWrapperInterfaceInterfaceTraits>::Trait<ConcreteOp> {

    /// Return the optional features attribute of this op.
    std::optional<::mlir::rock::GemmFeatures> getGemmFeatures() {
      return (*static_cast<ConcreteOp *>(this)).getFeatures();
    }

    /// Return the features attribute of this op.
    ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr() {
      return (*static_cast<ConcreteOp *>(this)).getFeaturesAttr();
    }

    /// Set the block size attribute of this operation
    /// 
    /// This is needed for --affix-tuning-params to work and can go away if it does
    void setDerivedBlockSizeAttr(::mlir::IntegerAttr blockSize) {
      (*static_cast<ConcreteOp *>(this))->setAttr((*static_cast<ConcreteOp *>(this)).getDerivedBlockSizeAttrName(), blockSize);
    }

    /// Set the grid size attribute of this operation
    /// 
    /// This is needed for --affix-tuning-params to work and can go away if it does
    void setGridSizeAttr(::mlir::IntegerAttr gridSize) {
      (*static_cast<ConcreteOp *>(this))->setAttr((*static_cast<ConcreteOp *>(this)).getGridSizeAttrName(), gridSize);
    }

    /// Set the tuning parameters attribute of this operation
    /// 
    /// This is needed for --affix-tuning-params to work and can go away if it does
    void setGemmParamsAttr(::mlir::Attribute params) {
      (*static_cast<ConcreteOp *>(this))->setAttr((*static_cast<ConcreteOp *>(this)).getParamsAttrName(), params);
    }

    /// Get the tuning parameters attribute of this operation
    std::optional<RockTuningParamAttrInterface> getGemmParams() {
      return (*static_cast<ConcreteOp *>(this)).getParams();
    }

    /// Return the block size this operation will execute with if it has been selected
    /// or None otherwise. Prioritizes the block size defined in tuning parameters
    uint32_t getBlockSize() {
      if (auto generalParams = dyn_cast_or_null<GeneralGemmParamsAttr>((*static_cast<ConcreteOp *>(this)).getParamsAttr())) {
            return generalParams.getBlockSize();
          }
          return (*static_cast<ConcreteOp *>(this)).getDerivedBlockSize().value_or(0);
    }
    static ::llvm::LogicalResult verifyTrait(::mlir::Operation *op) {
      auto concreteOp = ::mlir::cast<ConcreteOp>(op);
    if (op->getNumResults() == 1) {
      if (op->getResult(0).getType() !=
          concreteOp.getOutArgument()->get().getType()) {
        return op->emitOpError("result type must match output argument type");
      }
    }
    return ::mlir::success();
    }
  };
}// namespace detail
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
template<typename ConcreteOp>
::mlir::rock::KernelType detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getKernelType();
}
template<typename ConcreteOp>
OpOperand *detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getOutArgument();
}
template<typename ConcreteOp>
::mlir::rock::GemmSize detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmSize();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getAType();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getBType();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getCType();
}
template<typename ConcreteOp>
std::optional<::mlir::rock::GemmFeatures> detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmFeatures();
}
template<typename ConcreteOp>
::mlir::rock::GemmFeaturesAttr detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmFeaturesAttr();
}
template<typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setDerivedBlockSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr blockSize) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setDerivedBlockSizeAttr(blockSize);
}
template<typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setGridSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr gridSize) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setGridSizeAttr(gridSize);
}
template<typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setGemmParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setGemmParamsAttr(params);
}
template<typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmParams();
}
template<typename ConcreteOp>
std::optional<uint32_t> detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getDerivedBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDerivedBlockSize();
}
template<typename ConcreteOp>
uint32_t detail::RockGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getBlockSize();
}
template<typename ConcreteOp>
::mlir::rock::KernelType detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getKernelType(tablegen_opaque_val);
}
template<typename ConcreteOp>
OpOperand *detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getOutArgument(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::rock::GemmSize detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmSize(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getAType(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getBType(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getCType(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::optional<::mlir::rock::GemmFeatures> detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmFeatures(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::rock::GemmFeaturesAttr detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmFeaturesAttr(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setDerivedBlockSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr blockSize) {
  return static_cast<const ConcreteOp *>(impl)->setDerivedBlockSizeAttr(tablegen_opaque_val, blockSize);
}
template<typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setGridSizeAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr gridSize) {
  return static_cast<const ConcreteOp *>(impl)->setGridSizeAttr(tablegen_opaque_val, gridSize);
}
template<typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setGemmParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) {
  return static_cast<const ConcreteOp *>(impl)->setGemmParamsAttr(tablegen_opaque_val, params);
}
template<typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmParams(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::optional<uint32_t> detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getDerivedBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getDerivedBlockSize(tablegen_opaque_val);
}
template<typename ConcreteOp>
uint32_t detail::RockGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getBlockSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getBlockSize(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
std::optional<::mlir::rock::GemmFeatures> detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemmFeatures(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFeatures();
}
template<typename ConcreteModel, typename ConcreteOp>
::mlir::rock::GemmFeaturesAttr detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemmFeaturesAttr(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFeaturesAttr();
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setDerivedBlockSizeAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr blockSize) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDerivedBlockSizeAttrName(), blockSize);
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setGridSizeAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::IntegerAttr gridSize) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGridSizeAttrName(), gridSize);
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setGemmParamsAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParamsAttrName(), params);
}
template<typename ConcreteModel, typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemmParams(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParams();
}
template<typename ConcreteModel, typename ConcreteOp>
uint32_t detail::RockGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getBlockSize(::mlir::Operation *tablegen_opaque_val) const {
if (auto generalParams = dyn_cast_or_null<GeneralGemmParamsAttr>((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParamsAttr())) {
            return generalParams.getBlockSize();
          }
          return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getDerivedBlockSize().value_or(0);
}
} // namespace rock
} // namespace mlir
