/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         SQL_STYPE
/* Substitute the variable and function names.  */
#define yyparse         sql_parse
#define yylex           sql_lex
#define yyerror         sql_error
#define yydebug         sql_debug
#define yynerrs         sql_nerrs

/* First part of user prologue.  */
#line 1 "../msitools/libmsi/sql-parser.y"


/*
 * Implementation of the Microsoft Installer (msi.dll)
 *
 * Copyright 2002-2004 Mike McCormack for CodeWeavers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */


#include "config.h"

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "query.h"
#include "list.h"
#include "debug.h"

#define YYLEX_PARAM info
#define YYPARSE_PARAM info

static int sql_error(void *info, const char *str);


typedef struct _LibmsiSQLInput
{
    LibmsiDatabase *db;
    const char *command;
    unsigned n, len;
    unsigned r;
    LibmsiView **view;  /* View structure for the resulting query.  This value
                      * tracks the view currently being created so we can free
                      * this view on syntax error.
                      */
    struct list *mem;
} SQL_input;

static unsigned sql_unescape_string( void *info, const struct sql_str *strdata, char **str );
static int sql_atoi( void *info );
static int sql_lex( void *SQL_lval, SQL_input *info );

static char *parser_add_table( void *info, const char *list, const char *table );
static void *parser_alloc( void *info, unsigned int sz );
static column_info *parser_alloc_column( void *info, const char *table, const char *column );

static bool sql_mark_primary_keys( column_info **cols, column_info *keys);

static struct expr * build_expr_complex( void *info, struct expr *l, unsigned op, struct expr *r );
static struct expr * build_expr_unary( void *info, struct expr *l, unsigned op );
static struct expr * build_expr_column( void *info, const column_info *column );
static struct expr * build_expr_ival( void *info, int val );
static struct expr * build_expr_sval( void *info, const struct sql_str *str );
static struct expr * build_expr_wildcard( void *info );

#define PARSER_BUBBLE_UP_VIEW( sql, result, current_view ) \
    *sql->view = current_view; \
    result = current_view


#line 152 "libmsi/sql-parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "sql-parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TK_ALTER = 3,                   /* TK_ALTER  */
  YYSYMBOL_TK_AND = 4,                     /* TK_AND  */
  YYSYMBOL_TK_BY = 5,                      /* TK_BY  */
  YYSYMBOL_TK_CHAR = 6,                    /* TK_CHAR  */
  YYSYMBOL_TK_COMMA = 7,                   /* TK_COMMA  */
  YYSYMBOL_TK_CREATE = 8,                  /* TK_CREATE  */
  YYSYMBOL_TK_DELETE = 9,                  /* TK_DELETE  */
  YYSYMBOL_TK_DROP = 10,                   /* TK_DROP  */
  YYSYMBOL_TK_DISTINCT = 11,               /* TK_DISTINCT  */
  YYSYMBOL_TK_DOT = 12,                    /* TK_DOT  */
  YYSYMBOL_TK_EQ = 13,                     /* TK_EQ  */
  YYSYMBOL_TK_FREE = 14,                   /* TK_FREE  */
  YYSYMBOL_TK_FROM = 15,                   /* TK_FROM  */
  YYSYMBOL_TK_GE = 16,                     /* TK_GE  */
  YYSYMBOL_TK_GT = 17,                     /* TK_GT  */
  YYSYMBOL_TK_HOLD = 18,                   /* TK_HOLD  */
  YYSYMBOL_TK_ADD = 19,                    /* TK_ADD  */
  YYSYMBOL_TK_ID = 20,                     /* TK_ID  */
  YYSYMBOL_TK_ILLEGAL = 21,                /* TK_ILLEGAL  */
  YYSYMBOL_TK_INSERT = 22,                 /* TK_INSERT  */
  YYSYMBOL_TK_INT = 23,                    /* TK_INT  */
  YYSYMBOL_TK_INTEGER = 24,                /* TK_INTEGER  */
  YYSYMBOL_TK_INTO = 25,                   /* TK_INTO  */
  YYSYMBOL_TK_IS = 26,                     /* TK_IS  */
  YYSYMBOL_TK_KEY = 27,                    /* TK_KEY  */
  YYSYMBOL_TK_LE = 28,                     /* TK_LE  */
  YYSYMBOL_TK_LONG = 29,                   /* TK_LONG  */
  YYSYMBOL_TK_LONGCHAR = 30,               /* TK_LONGCHAR  */
  YYSYMBOL_TK_LP = 31,                     /* TK_LP  */
  YYSYMBOL_TK_LT = 32,                     /* TK_LT  */
  YYSYMBOL_TK_LOCALIZABLE = 33,            /* TK_LOCALIZABLE  */
  YYSYMBOL_TK_MINUS = 34,                  /* TK_MINUS  */
  YYSYMBOL_TK_NE = 35,                     /* TK_NE  */
  YYSYMBOL_TK_NOT = 36,                    /* TK_NOT  */
  YYSYMBOL_TK_NULL = 37,                   /* TK_NULL  */
  YYSYMBOL_TK_OBJECT = 38,                 /* TK_OBJECT  */
  YYSYMBOL_TK_OR = 39,                     /* TK_OR  */
  YYSYMBOL_TK_ORDER = 40,                  /* TK_ORDER  */
  YYSYMBOL_TK_PRIMARY = 41,                /* TK_PRIMARY  */
  YYSYMBOL_TK_RP = 42,                     /* TK_RP  */
  YYSYMBOL_TK_SELECT = 43,                 /* TK_SELECT  */
  YYSYMBOL_TK_SET = 44,                    /* TK_SET  */
  YYSYMBOL_TK_SHORT = 45,                  /* TK_SHORT  */
  YYSYMBOL_TK_SPACE = 46,                  /* TK_SPACE  */
  YYSYMBOL_TK_STAR = 47,                   /* TK_STAR  */
  YYSYMBOL_TK_STRING = 48,                 /* TK_STRING  */
  YYSYMBOL_TK_TABLE = 49,                  /* TK_TABLE  */
  YYSYMBOL_TK_TEMPORARY = 50,              /* TK_TEMPORARY  */
  YYSYMBOL_TK_UPDATE = 51,                 /* TK_UPDATE  */
  YYSYMBOL_TK_VALUES = 52,                 /* TK_VALUES  */
  YYSYMBOL_TK_WHERE = 53,                  /* TK_WHERE  */
  YYSYMBOL_TK_WILDCARD = 54,               /* TK_WILDCARD  */
  YYSYMBOL_END_OF_FILE = 55,               /* END_OF_FILE  */
  YYSYMBOL_ILLEGAL = 56,                   /* ILLEGAL  */
  YYSYMBOL_SPACE = 57,                     /* SPACE  */
  YYSYMBOL_UNCLOSED_STRING = 58,           /* UNCLOSED_STRING  */
  YYSYMBOL_COMMENT = 59,                   /* COMMENT  */
  YYSYMBOL_FUNCTION = 60,                  /* FUNCTION  */
  YYSYMBOL_COLUMN = 61,                    /* COLUMN  */
  YYSYMBOL_62_AGG_FUNCTION_ = 62,          /* AGG_FUNCTION.  */
  YYSYMBOL_TK_LIKE = 63,                   /* TK_LIKE  */
  YYSYMBOL_TK_NEGATION = 64,               /* TK_NEGATION  */
  YYSYMBOL_YYACCEPT = 65,                  /* $accept  */
  YYSYMBOL_query = 66,                     /* query  */
  YYSYMBOL_onequery = 67,                  /* onequery  */
  YYSYMBOL_oneinsert = 68,                 /* oneinsert  */
  YYSYMBOL_onecreate = 69,                 /* onecreate  */
  YYSYMBOL_oneupdate = 70,                 /* oneupdate  */
  YYSYMBOL_onedelete = 71,                 /* onedelete  */
  YYSYMBOL_onealter = 72,                  /* onealter  */
  YYSYMBOL_alterop = 73,                   /* alterop  */
  YYSYMBOL_onedrop = 74,                   /* onedrop  */
  YYSYMBOL_table_def = 75,                 /* table_def  */
  YYSYMBOL_column_def = 76,                /* column_def  */
  YYSYMBOL_column_and_type = 77,           /* column_and_type  */
  YYSYMBOL_column_type = 78,               /* column_type  */
  YYSYMBOL_data_type_l = 79,               /* data_type_l  */
  YYSYMBOL_data_type = 80,                 /* data_type  */
  YYSYMBOL_data_count = 81,                /* data_count  */
  YYSYMBOL_oneselect = 82,                 /* oneselect  */
  YYSYMBOL_selectfrom = 83,                /* selectfrom  */
  YYSYMBOL_selcollist = 84,                /* selcollist  */
  YYSYMBOL_collist = 85,                   /* collist  */
  YYSYMBOL_from = 86,                      /* from  */
  YYSYMBOL_unorderdfrom = 87,              /* unorderdfrom  */
  YYSYMBOL_tablelist = 88,                 /* tablelist  */
  YYSYMBOL_expr = 89,                      /* expr  */
  YYSYMBOL_val = 90,                       /* val  */
  YYSYMBOL_constlist = 91,                 /* constlist  */
  YYSYMBOL_update_assign_list = 92,        /* update_assign_list  */
  YYSYMBOL_column_assignment = 93,         /* column_assignment  */
  YYSYMBOL_const_val = 94,                 /* const_val  */
  YYSYMBOL_column_val = 95,                /* column_val  */
  YYSYMBOL_column = 96,                    /* column  */
  YYSYMBOL_selcolumn = 97,                 /* selcolumn  */
  YYSYMBOL_table = 98,                     /* table  */
  YYSYMBOL_id = 99,                        /* id  */
  YYSYMBOL_string = 100,                   /* string  */
  YYSYMBOL_number = 101                    /* number  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined SQL_STYPE_IS_TRIVIAL && SQL_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  36
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   156

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  65
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  37
/* YYNRULES -- Number of rules.  */
#define YYNRULES  87
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  154

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   319


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64
};

#if SQL_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   131,   131,   139,   140,   141,   142,   143,   144,   145,
     149,   160,   174,   191,   207,   218,   232,   246,   257,   268,
     282,   286,   293,   308,   318,   328,   335,   344,   348,   352,
     359,   363,   370,   374,   378,   382,   386,   390,   394,   401,
     410,   414,   429,   449,   450,   454,   461,   462,   466,   473,
     485,   498,   502,   514,   529,   533,   542,   548,   554,   560,
     566,   572,   578,   584,   590,   596,   602,   611,   612,   616,
     623,   634,   635,   643,   651,   657,   663,   669,   678,   687,
     693,   702,   708,   714,   723,   730,   738,   746
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if SQL_DEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TK_ALTER", "TK_AND",
  "TK_BY", "TK_CHAR", "TK_COMMA", "TK_CREATE", "TK_DELETE", "TK_DROP",
  "TK_DISTINCT", "TK_DOT", "TK_EQ", "TK_FREE", "TK_FROM", "TK_GE", "TK_GT",
  "TK_HOLD", "TK_ADD", "TK_ID", "TK_ILLEGAL", "TK_INSERT", "TK_INT",
  "TK_INTEGER", "TK_INTO", "TK_IS", "TK_KEY", "TK_LE", "TK_LONG",
  "TK_LONGCHAR", "TK_LP", "TK_LT", "TK_LOCALIZABLE", "TK_MINUS", "TK_NE",
  "TK_NOT", "TK_NULL", "TK_OBJECT", "TK_OR", "TK_ORDER", "TK_PRIMARY",
  "TK_RP", "TK_SELECT", "TK_SET", "TK_SHORT", "TK_SPACE", "TK_STAR",
  "TK_STRING", "TK_TABLE", "TK_TEMPORARY", "TK_UPDATE", "TK_VALUES",
  "TK_WHERE", "TK_WILDCARD", "END_OF_FILE", "ILLEGAL", "SPACE",
  "UNCLOSED_STRING", "COMMENT", "FUNCTION", "COLUMN", "AGG_FUNCTION.",
  "TK_LIKE", "TK_NEGATION", "$accept", "query", "onequery", "oneinsert",
  "onecreate", "oneupdate", "onedelete", "onealter", "alterop", "onedrop",
  "table_def", "column_def", "column_and_type", "column_type",
  "data_type_l", "data_type", "data_count", "oneselect", "selectfrom",
  "selcollist", "collist", "from", "unorderdfrom", "tablelist", "expr",
  "val", "constlist", "update_assign_list", "column_assignment",
  "const_val", "column_val", "column", "selcolumn", "table", "id",
  "string", "number", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-80)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-85)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      36,   -44,   -39,    -1,   -26,     9,    50,    37,    56,   -80,
     -80,   -80,   -80,   -80,   -80,   -80,   -80,    37,    37,    37,
     -80,    25,    37,    37,   -18,   -80,   -80,   -80,   -80,    -1,
      78,    47,    76,   -80,    57,   -80,   -80,   105,    72,    51,
      55,   100,   -80,    81,   -80,   -80,   -18,    37,    37,   -80,
     -80,    37,   -80,    37,    62,    37,   -12,   -12,   -80,   -80,
      63,   102,   108,   101,    76,    97,    45,    83,     2,   -80,
      62,     3,    94,   -80,   -80,   126,   -80,   -80,   127,    93,
      62,    37,    52,    37,   -80,   106,   -80,   -80,   -80,   -80,
     -80,   -80,    31,   103,   118,    37,   111,    11,    62,    62,
      60,    60,    60,   -11,    60,    60,    60,   -12,    88,     3,
     -80,   -80,   117,   -80,   -80,   -80,   -80,   -80,   117,   -80,
     -80,   107,   -80,   -80,   -12,   -80,   -80,   138,   -80,   -80,
     -80,   -80,   -80,   109,   -80,   -80,   -80,   -80,   -80,   112,
     -80,   110,   -80,   -80,   -80,   -80,    52,   -80,   113,   140,
      95,    52,   -80,   -80
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     2,
       5,     4,     6,     7,     8,     9,     3,     0,     0,     0,
      16,    51,     0,     0,     0,    85,    45,    86,    40,     0,
      43,     0,    82,    83,     0,    84,     1,     0,     0,    52,
      54,     0,    22,     0,    41,    42,     0,     0,     0,    21,
      20,     0,    17,     0,     0,     0,     0,     0,    44,    81,
      15,    71,     0,     0,    80,    18,     0,     0,     0,    25,
       0,    53,     0,    78,    55,    54,    48,    50,    46,     0,
       0,     0,     0,     0,    19,    32,    36,    37,    34,    38,
      35,    26,    27,    30,    12,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    14,
      72,    87,     0,    76,    77,    73,    74,    79,     0,    28,
      29,     0,    13,    24,     0,    56,    57,    58,    59,    68,
      67,    63,    60,     0,    65,    62,    61,    64,    47,     0,
      75,     0,    39,    31,    23,    66,     0,    33,     0,    69,
      10,     0,    11,    70
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,   -80,
     -80,   -80,   -47,   -80,   -80,   -80,   -80,   -80,   124,   104,
     -53,   120,   -80,    96,    19,    26,     5,    73,   -80,   -79,
      -7,   -29,   -80,    14,    -6,   -80,   -16
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     8,     9,    10,    11,    12,    13,    14,    52,    15,
      67,    68,    65,    91,    92,    93,   141,    16,    28,    29,
      77,    20,    21,    39,    71,   128,   148,    60,    61,   129,
     130,    73,    30,    63,    64,    33,   116
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      32,    35,    25,   115,    79,    17,    69,    98,    25,    95,
      18,    35,    35,    35,    19,    98,    35,    35,    32,    62,
      31,    34,    66,    22,    66,   133,   134,    78,    78,    26,
      27,    37,    38,    40,    23,    76,    42,    43,    31,     1,
      32,    59,    99,    96,     2,     3,     4,    72,   123,    35,
      99,    85,    62,   125,   138,   -49,    36,    25,     5,    47,
      31,    24,    55,    72,   119,    41,    66,   149,    86,    75,
      25,   144,   149,    72,    87,    88,   111,   117,    78,     6,
      25,   120,    25,    89,   111,    46,   112,     7,   -84,    97,
      90,    72,    72,    70,   112,    78,   140,    26,    27,   109,
     113,    48,   142,    53,    54,    56,   114,   100,   113,    81,
     101,   102,    57,    83,   114,    84,    80,   126,   127,    49,
     103,    82,   104,    50,    51,    94,   105,   131,   132,   106,
     135,   136,   137,    55,   107,   108,   122,   118,   124,   121,
     139,   111,    98,   146,   143,   152,   145,   151,    44,    45,
      58,    74,   147,     0,   110,   150,   153
};

static const yytype_int16 yycheck[] =
{
       6,     7,    20,    82,    57,    49,    53,     4,    20,     7,
      49,    17,    18,    19,    15,     4,    22,    23,    24,    48,
       6,     7,    51,    49,    53,    36,    37,    56,    57,    47,
      48,    17,    18,    19,    25,    47,    22,    23,    24,     3,
      46,    47,    39,    41,     8,     9,    10,    54,    95,    55,
      39,     6,    81,    42,   107,     0,     0,    20,    22,    12,
      46,    11,     7,    70,    33,    40,    95,   146,    23,    55,
      20,   124,   151,    80,    29,    30,    24,    83,   107,    43,
      20,    50,    20,    38,    24,     7,    34,    51,    12,    70,
      45,    98,    99,    31,    34,   124,   112,    47,    48,    80,
      48,    44,   118,    31,    53,     5,    54,    13,    48,     7,
      16,    17,    31,    12,    54,    18,    53,    98,    99,    14,
      26,    13,    28,    18,    19,    42,    32,   101,   102,    35,
     104,   105,   106,     7,     7,    42,    18,    31,    27,    36,
      52,    24,     4,    31,    37,    50,    37,     7,    24,    29,
      46,    55,    42,    -1,    81,    42,   151
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     8,     9,    10,    22,    43,    51,    66,    67,
      68,    69,    70,    71,    72,    74,    82,    49,    49,    15,
      86,    87,    49,    25,    11,    20,    47,    48,    83,    84,
      97,    98,    99,   100,    98,    99,     0,    98,    98,    88,
      98,    40,    98,    98,    83,    86,     7,    12,    44,    14,
      18,    19,    73,    31,    53,     7,     5,    31,    84,    99,
      92,    93,    96,    98,    99,    77,    96,    75,    76,    77,
      31,    89,    95,    96,    88,    98,    47,    85,    96,    85,
      53,     7,    13,    12,    18,     6,    23,    29,    30,    38,
      45,    78,    79,    80,    42,     7,    41,    89,     4,    39,
      13,    16,    17,    26,    28,    32,    35,     7,    42,    89,
      92,    24,    34,    48,    54,    94,   101,    99,    31,    33,
      50,    36,    18,    77,    27,    42,    89,    89,    90,    94,
      95,    90,    90,    36,    37,    90,    90,    90,    85,    52,
     101,    81,   101,    37,    85,    37,    31,    42,    91,    94,
      42,     7,    50,    91
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    65,    66,    67,    67,    67,    67,    67,    67,    67,
      68,    68,    69,    69,    70,    70,    71,    72,    72,    72,
      73,    73,    74,    75,    76,    76,    77,    78,    78,    78,
      79,    79,    80,    80,    80,    80,    80,    80,    80,    81,
      82,    82,    83,    84,    84,    84,    85,    85,    85,    86,
      86,    86,    87,    87,    88,    88,    89,    89,    89,    89,
      89,    89,    89,    89,    89,    89,    89,    90,    90,    91,
      91,    92,    92,    93,    94,    94,    94,    94,    95,    96,
      96,    97,    97,    97,    98,    99,   100,   101
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
      10,    11,     6,     7,     6,     4,     2,     4,     5,     6,
       1,     1,     3,     4,     3,     1,     2,     1,     2,     2,
       1,     3,     1,     4,     1,     1,     1,     1,     1,     1,
       2,     3,     2,     1,     3,     1,     1,     3,     1,     2,
       4,     1,     2,     4,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     1,     1,     1,
       3,     1,     3,     3,     1,     2,     1,     1,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = SQL_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == SQL_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (info, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use SQL_error or SQL_UNDEF. */
#define YYERRCODE SQL_UNDEF


/* Enable debugging if requested.  */
#if SQL_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, info); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *info)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (info);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *info)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, info);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, void *info)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], info);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, info); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !SQL_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !SQL_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, void *info)
{
  YY_USE (yyvaluep);
  YY_USE (info);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void *info)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = SQL_EMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == SQL_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, info);
    }

  if (yychar <= SQL_EOF)
    {
      yychar = SQL_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == SQL_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = SQL_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = SQL_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* query: onequery  */
#line 132 "../msitools/libmsi/sql-parser.y"
    {
        SQL_input* sql = (SQL_input*) info;
        *sql->view = (yyvsp[0].query);
    }
#line 1365 "libmsi/sql-parser.c"
    break;

  case 10: /* oneinsert: TK_INSERT TK_INTO table TK_LP collist TK_RP TK_VALUES TK_LP constlist TK_RP  */
#line 150 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input *sql = (SQL_input*) info;
            LibmsiView *insert = NULL;

            insert_view_create( sql->db, &insert, (yyvsp[-7].string), (yyvsp[-5].column_list), (yyvsp[-1].column_list), false );
            if( !insert )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query),  insert );
        }
#line 1380 "libmsi/sql-parser.c"
    break;

  case 11: /* oneinsert: TK_INSERT TK_INTO table TK_LP collist TK_RP TK_VALUES TK_LP constlist TK_RP TK_TEMPORARY  */
#line 161 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input *sql = (SQL_input*) info;
            LibmsiView *insert = NULL;

            insert_view_create( sql->db, &insert, (yyvsp[-8].string), (yyvsp[-6].column_list), (yyvsp[-2].column_list), true );
            if( !insert )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query),  insert );
        }
#line 1395 "libmsi/sql-parser.c"
    break;

  case 12: /* onecreate: TK_CREATE TK_TABLE table TK_LP table_def TK_RP  */
#line 175 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView *create = NULL;
            unsigned r;

            if( !(yyvsp[-1].column_list) )
                YYABORT;
            r = create_view_create( sql->db, &create, (yyvsp[-3].string), (yyvsp[-1].column_list), false );
            if( !create )
            {
                sql->r = r;
                YYABORT;
            }

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query),  create );
        }
#line 1416 "libmsi/sql-parser.c"
    break;

  case 13: /* onecreate: TK_CREATE TK_TABLE table TK_LP table_def TK_RP TK_HOLD  */
#line 192 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView *create = NULL;

            if( !(yyvsp[-2].column_list) )
                YYABORT;
            create_view_create( sql->db, &create, (yyvsp[-4].string), (yyvsp[-2].column_list), true );
            if( !create )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query),  create );
        }
#line 1433 "libmsi/sql-parser.c"
    break;

  case 14: /* oneupdate: TK_UPDATE table TK_SET update_assign_list TK_WHERE expr  */
#line 208 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView *update = NULL;

            update_view_create( sql->db, &update, (yyvsp[-4].string), (yyvsp[-2].column_list), (yyvsp[0].expr) );
            if( !update )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query),  update );
        }
#line 1448 "libmsi/sql-parser.c"
    break;

  case 15: /* oneupdate: TK_UPDATE table TK_SET update_assign_list  */
#line 219 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView *update = NULL;

            update_view_create( sql->db, &update, (yyvsp[-2].string), (yyvsp[0].column_list), NULL );
            if( !update )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query),  update );
        }
#line 1463 "libmsi/sql-parser.c"
    break;

  case 16: /* onedelete: TK_DELETE from  */
#line 233 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView *delete = NULL;

            delete_view_create( sql->db, &delete, (yyvsp[0].query) );
            if( !delete )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), delete );
        }
#line 1478 "libmsi/sql-parser.c"
    break;

  case 17: /* onealter: TK_ALTER TK_TABLE table alterop  */
#line 247 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView *alter = NULL;

            alter_view_create( sql->db, &alter, (yyvsp[-1].string), NULL, (yyvsp[0].integer) );
            if( !alter )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), alter );
        }
#line 1493 "libmsi/sql-parser.c"
    break;

  case 18: /* onealter: TK_ALTER TK_TABLE table TK_ADD column_and_type  */
#line 258 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input *sql = (SQL_input *)info;
            LibmsiView *alter = NULL;

            alter_view_create( sql->db, &alter, (yyvsp[-2].string), (yyvsp[0].column_list), 0 );
            if (!alter)
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), alter );
        }
#line 1508 "libmsi/sql-parser.c"
    break;

  case 19: /* onealter: TK_ALTER TK_TABLE table TK_ADD column_and_type TK_HOLD  */
#line 269 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input *sql = (SQL_input *)info;
            LibmsiView *alter = NULL;

            alter_view_create( sql->db, &alter, (yyvsp[-3].string), (yyvsp[-1].column_list), 1 );
            if (!alter)
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), alter );
        }
#line 1523 "libmsi/sql-parser.c"
    break;

  case 20: /* alterop: TK_HOLD  */
#line 283 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.integer) = 1;
        }
#line 1531 "libmsi/sql-parser.c"
    break;

  case 21: /* alterop: TK_FREE  */
#line 287 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.integer) = -1;
        }
#line 1539 "libmsi/sql-parser.c"
    break;

  case 22: /* onedrop: TK_DROP TK_TABLE table  */
#line 294 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView* drop = NULL;
            unsigned r;

            r = drop_view_create( sql->db, &drop, (yyvsp[0].string) );
            if( r != LIBMSI_RESULT_SUCCESS || !(yyval.query) )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), drop );
        }
#line 1555 "libmsi/sql-parser.c"
    break;

  case 23: /* table_def: column_def TK_PRIMARY TK_KEY collist  */
#line 309 "../msitools/libmsi/sql-parser.y"
        {
            if( sql_mark_primary_keys( &(yyvsp[-3].column_list), (yyvsp[0].column_list) ) )
                (yyval.column_list) = (yyvsp[-3].column_list);
            else
                (yyval.column_list) = NULL;
        }
#line 1566 "libmsi/sql-parser.c"
    break;

  case 24: /* column_def: column_def TK_COMMA column_and_type  */
#line 319 "../msitools/libmsi/sql-parser.y"
        {
            column_info *ci;

            for( ci = (yyvsp[-2].column_list); ci->next; ci = ci->next )
                ;

            ci->next = (yyvsp[0].column_list);
            (yyval.column_list) = (yyvsp[-2].column_list);
        }
#line 1580 "libmsi/sql-parser.c"
    break;

  case 25: /* column_def: column_and_type  */
#line 329 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = (yyvsp[0].column_list);
        }
#line 1588 "libmsi/sql-parser.c"
    break;

  case 26: /* column_and_type: column column_type  */
#line 336 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = (yyvsp[-1].column_list);
            (yyval.column_list)->type = ((yyvsp[0].column_type) | MSITYPE_VALID);
            (yyval.column_list)->temporary = (yyvsp[0].column_type) & MSITYPE_TEMPORARY ? true : false;
        }
#line 1598 "libmsi/sql-parser.c"
    break;

  case 27: /* column_type: data_type_l  */
#line 345 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = (yyvsp[0].column_type);
        }
#line 1606 "libmsi/sql-parser.c"
    break;

  case 28: /* column_type: data_type_l TK_LOCALIZABLE  */
#line 349 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = (yyvsp[-1].column_type) | MSITYPE_LOCALIZABLE;
        }
#line 1614 "libmsi/sql-parser.c"
    break;

  case 29: /* column_type: data_type_l TK_TEMPORARY  */
#line 353 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = (yyvsp[-1].column_type) | MSITYPE_TEMPORARY;
        }
#line 1622 "libmsi/sql-parser.c"
    break;

  case 30: /* data_type_l: data_type  */
#line 360 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) |= MSITYPE_NULLABLE;
        }
#line 1630 "libmsi/sql-parser.c"
    break;

  case 31: /* data_type_l: data_type TK_NOT TK_NULL  */
#line 364 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = (yyvsp[-2].column_type);
        }
#line 1638 "libmsi/sql-parser.c"
    break;

  case 32: /* data_type: TK_CHAR  */
#line 371 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = MSITYPE_STRING | 1;
        }
#line 1646 "libmsi/sql-parser.c"
    break;

  case 33: /* data_type: TK_CHAR TK_LP data_count TK_RP  */
#line 375 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = MSITYPE_STRING | 0x400 | (yyvsp[-1].column_type);
        }
#line 1654 "libmsi/sql-parser.c"
    break;

  case 34: /* data_type: TK_LONGCHAR  */
#line 379 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = MSITYPE_STRING | 0x400;
        }
#line 1662 "libmsi/sql-parser.c"
    break;

  case 35: /* data_type: TK_SHORT  */
#line 383 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = 2 | 0x400;
        }
#line 1670 "libmsi/sql-parser.c"
    break;

  case 36: /* data_type: TK_INT  */
#line 387 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = 2 | 0x400;
        }
#line 1678 "libmsi/sql-parser.c"
    break;

  case 37: /* data_type: TK_LONG  */
#line 391 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = 4;
        }
#line 1686 "libmsi/sql-parser.c"
    break;

  case 38: /* data_type: TK_OBJECT  */
#line 395 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_type) = MSITYPE_STRING | MSITYPE_VALID;
        }
#line 1694 "libmsi/sql-parser.c"
    break;

  case 39: /* data_count: number  */
#line 402 "../msitools/libmsi/sql-parser.y"
        {
            if( ( (yyvsp[0].integer) > 255 ) || ( (yyvsp[0].integer) < 0 ) )
                YYABORT;
            (yyval.column_type) = (yyvsp[0].integer);
        }
#line 1704 "libmsi/sql-parser.c"
    break;

  case 40: /* oneselect: TK_SELECT selectfrom  */
#line 411 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.query) = (yyvsp[0].query);
        }
#line 1712 "libmsi/sql-parser.c"
    break;

  case 41: /* oneselect: TK_SELECT TK_DISTINCT selectfrom  */
#line 415 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView* distinct = NULL;
            unsigned r;

            r = distinct_view_create( sql->db, &distinct, (yyvsp[0].query) );
            if (r != LIBMSI_RESULT_SUCCESS)
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), distinct );
        }
#line 1728 "libmsi/sql-parser.c"
    break;

  case 42: /* selectfrom: selcollist from  */
#line 430 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView* select = NULL;
            unsigned r;

            if( (yyvsp[-1].column_list) )
            {
                r = select_view_create( sql->db, &select, (yyvsp[0].query), (yyvsp[-1].column_list) );
                if (r != LIBMSI_RESULT_SUCCESS)
                    YYABORT;

                PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), select );
            }
            else
                (yyval.query) = (yyvsp[0].query);
        }
#line 1749 "libmsi/sql-parser.c"
    break;

  case 44: /* selcollist: selcolumn TK_COMMA selcollist  */
#line 451 "../msitools/libmsi/sql-parser.y"
        {
            (yyvsp[-2].column_list)->next = (yyvsp[0].column_list);
        }
#line 1757 "libmsi/sql-parser.c"
    break;

  case 45: /* selcollist: TK_STAR  */
#line 455 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = NULL;
        }
#line 1765 "libmsi/sql-parser.c"
    break;

  case 47: /* collist: column TK_COMMA collist  */
#line 463 "../msitools/libmsi/sql-parser.y"
        {
            (yyvsp[-2].column_list)->next = (yyvsp[0].column_list);
        }
#line 1773 "libmsi/sql-parser.c"
    break;

  case 48: /* collist: TK_STAR  */
#line 467 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = NULL;
        }
#line 1781 "libmsi/sql-parser.c"
    break;

  case 49: /* from: TK_FROM table  */
#line 474 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView* table = NULL;
            unsigned r;

            r = table_view_create( sql->db, (yyvsp[0].string), &table );
            if( r != LIBMSI_RESULT_SUCCESS || !(yyval.query) )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), table );
        }
#line 1797 "libmsi/sql-parser.c"
    break;

  case 50: /* from: unorderdfrom TK_ORDER TK_BY collist  */
#line 486 "../msitools/libmsi/sql-parser.y"
        {
            unsigned r;

            if( (yyvsp[0].column_list) )
            {
                r = (yyvsp[-3].query)->ops->sort( (yyvsp[-3].query), (yyvsp[0].column_list) );
                if ( r != LIBMSI_RESULT_SUCCESS)
                    YYABORT;
            }

            (yyval.query) = (yyvsp[-3].query);
        }
#line 1814 "libmsi/sql-parser.c"
    break;

  case 52: /* unorderdfrom: TK_FROM tablelist  */
#line 503 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView* where = NULL;
            unsigned r;

            r = where_view_create( sql->db, &where, (yyvsp[0].string), NULL );
            if( r != LIBMSI_RESULT_SUCCESS )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), where );
        }
#line 1830 "libmsi/sql-parser.c"
    break;

  case 53: /* unorderdfrom: TK_FROM tablelist TK_WHERE expr  */
#line 515 "../msitools/libmsi/sql-parser.y"
        {
            SQL_input* sql = (SQL_input*) info;
            LibmsiView* where = NULL;
            unsigned r;

            r = where_view_create( sql->db, &where, (yyvsp[-2].string), (yyvsp[0].expr) );
            if( r != LIBMSI_RESULT_SUCCESS )
                YYABORT;

            PARSER_BUBBLE_UP_VIEW( sql, (yyval.query), where );
        }
#line 1846 "libmsi/sql-parser.c"
    break;

  case 54: /* tablelist: table  */
#line 530 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.string) = (yyvsp[0].string);
        }
#line 1854 "libmsi/sql-parser.c"
    break;

  case 55: /* tablelist: table TK_COMMA tablelist  */
#line 534 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.string) = parser_add_table( info, (yyvsp[0].string), (yyvsp[-2].string) );
            if (!(yyval.string))
                YYABORT;
        }
#line 1864 "libmsi/sql-parser.c"
    break;

  case 56: /* expr: TK_LP expr TK_RP  */
#line 543 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = (yyvsp[-1].expr);
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1874 "libmsi/sql-parser.c"
    break;

  case 57: /* expr: expr TK_AND expr  */
#line 549 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_AND, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1884 "libmsi/sql-parser.c"
    break;

  case 58: /* expr: expr TK_OR expr  */
#line 555 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_OR, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1894 "libmsi/sql-parser.c"
    break;

  case 59: /* expr: column_val TK_EQ val  */
#line 561 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_EQ, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1904 "libmsi/sql-parser.c"
    break;

  case 60: /* expr: column_val TK_GT val  */
#line 567 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_GT, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1914 "libmsi/sql-parser.c"
    break;

  case 61: /* expr: column_val TK_LT val  */
#line 573 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_LT, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1924 "libmsi/sql-parser.c"
    break;

  case 62: /* expr: column_val TK_LE val  */
#line 579 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_LE, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1934 "libmsi/sql-parser.c"
    break;

  case 63: /* expr: column_val TK_GE val  */
#line 585 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_GE, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1944 "libmsi/sql-parser.c"
    break;

  case 64: /* expr: column_val TK_NE val  */
#line 591 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_complex( info, (yyvsp[-2].expr), OP_NE, (yyvsp[0].expr) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1954 "libmsi/sql-parser.c"
    break;

  case 65: /* expr: column_val TK_IS TK_NULL  */
#line 597 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_unary( info, (yyvsp[-2].expr), OP_ISNULL );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1964 "libmsi/sql-parser.c"
    break;

  case 66: /* expr: column_val TK_IS TK_NOT TK_NULL  */
#line 603 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_unary( info, (yyvsp[-3].expr), OP_NOTNULL );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 1974 "libmsi/sql-parser.c"
    break;

  case 69: /* constlist: const_val  */
#line 617 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, NULL, NULL );
            if( !(yyval.column_list) )
                YYABORT;
            (yyval.column_list)->val = (yyvsp[0].expr);
        }
#line 1985 "libmsi/sql-parser.c"
    break;

  case 70: /* constlist: const_val TK_COMMA constlist  */
#line 624 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, NULL, NULL );
            if( !(yyval.column_list) )
                YYABORT;
            (yyval.column_list)->val = (yyvsp[-2].expr);
            (yyval.column_list)->next = (yyvsp[0].column_list);
        }
#line 1997 "libmsi/sql-parser.c"
    break;

  case 72: /* update_assign_list: column_assignment TK_COMMA update_assign_list  */
#line 636 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = (yyvsp[-2].column_list);
            (yyval.column_list)->next = (yyvsp[0].column_list);
        }
#line 2006 "libmsi/sql-parser.c"
    break;

  case 73: /* column_assignment: column TK_EQ const_val  */
#line 644 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = (yyvsp[-2].column_list);
            (yyval.column_list)->val = (yyvsp[0].expr);
        }
#line 2015 "libmsi/sql-parser.c"
    break;

  case 74: /* const_val: number  */
#line 652 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_ival( info, (yyvsp[0].integer) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 2025 "libmsi/sql-parser.c"
    break;

  case 75: /* const_val: TK_MINUS number  */
#line 658 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_ival( info, -(yyvsp[0].integer) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 2035 "libmsi/sql-parser.c"
    break;

  case 76: /* const_val: TK_STRING  */
#line 664 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_sval( info, &(yyvsp[0].str) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 2045 "libmsi/sql-parser.c"
    break;

  case 77: /* const_val: TK_WILDCARD  */
#line 670 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_wildcard( info );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 2055 "libmsi/sql-parser.c"
    break;

  case 78: /* column_val: column  */
#line 679 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.expr) = build_expr_column( info, (yyvsp[0].column_list) );
            if( !(yyval.expr) )
                YYABORT;
        }
#line 2065 "libmsi/sql-parser.c"
    break;

  case 79: /* column: table TK_DOT id  */
#line 688 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, (yyvsp[-2].string), (yyvsp[0].string) );
            if( !(yyval.column_list) )
                YYABORT;
        }
#line 2075 "libmsi/sql-parser.c"
    break;

  case 80: /* column: id  */
#line 694 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, NULL, (yyvsp[0].string) );
            if( !(yyval.column_list) )
                YYABORT;
        }
#line 2085 "libmsi/sql-parser.c"
    break;

  case 81: /* selcolumn: table TK_DOT id  */
#line 703 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, (yyvsp[-2].string), (yyvsp[0].string) );
            if( !(yyval.column_list) )
                YYABORT;
        }
#line 2095 "libmsi/sql-parser.c"
    break;

  case 82: /* selcolumn: id  */
#line 709 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, NULL, (yyvsp[0].string) );
            if( !(yyval.column_list) )
                YYABORT;
        }
#line 2105 "libmsi/sql-parser.c"
    break;

  case 83: /* selcolumn: string  */
#line 715 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.column_list) = parser_alloc_column( info, NULL, (yyvsp[0].string) );
            if( !(yyval.column_list) )
                YYABORT;
        }
#line 2115 "libmsi/sql-parser.c"
    break;

  case 84: /* table: id  */
#line 724 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.string) = (yyvsp[0].string);
        }
#line 2123 "libmsi/sql-parser.c"
    break;

  case 85: /* id: TK_ID  */
#line 731 "../msitools/libmsi/sql-parser.y"
        {
            if ( sql_unescape_string( info, &(yyvsp[0].str), &(yyval.string) ) != LIBMSI_RESULT_SUCCESS || !(yyval.string) )
                YYABORT;
        }
#line 2132 "libmsi/sql-parser.c"
    break;

  case 86: /* string: TK_STRING  */
#line 739 "../msitools/libmsi/sql-parser.y"
        {
            if ( sql_unescape_string( info, &(yyvsp[0].str), &(yyval.string) ) != LIBMSI_RESULT_SUCCESS || !(yyval.string) )
                YYABORT;
        }
#line 2141 "libmsi/sql-parser.c"
    break;

  case 87: /* number: TK_INTEGER  */
#line 747 "../msitools/libmsi/sql-parser.y"
        {
            (yyval.integer) = sql_atoi( info );
        }
#line 2149 "libmsi/sql-parser.c"
    break;


#line 2153 "libmsi/sql-parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == SQL_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (info, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= SQL_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == SQL_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, info);
          yychar = SQL_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, info);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (info, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != SQL_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, info);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, info);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 752 "../msitools/libmsi/sql-parser.y"


static char *parser_add_table( void *info, const char *list, const char *table )
{
    static const char space[] = {' ',0};
    unsigned len = strlen( list ) + strlen( table ) + 2;
    char *ret;

    ret = parser_alloc( info, len * sizeof(char) );
    if( ret )
    {
        strcpy( ret, list );
        strcat( ret, space );
        strcat( ret, table );
    }
    return ret;
}

static void *parser_alloc( void *info, unsigned int sz )
{
    SQL_input* sql = (SQL_input*) info;
    struct list *mem;

    mem = msi_alloc( sizeof (struct list) + sz );
    list_add_tail( sql->mem, mem );
    return &mem[1];
}

static column_info *parser_alloc_column( void *info, const char *table, const char *column )
{
    column_info *col;

    col = parser_alloc( info, sizeof (*col) );
    if( col )
    {
        col->table = table;
        col->column = column;
        col->val = NULL;
        col->type = 0;
        col->next = NULL;
    }

    return col;
}

static int sql_lex( void *SQL_lval, SQL_input *sql )
{
    int token, skip;
    struct sql_str * str = SQL_lval;

    do
    {
        sql->n += sql->len;
        if( ! sql->command[sql->n] )
            return 0;  /* end of input */

        /* TRACE("string : %s\n", debugstr_a(&sql->command[sql->n])); */
        sql->len = sql_get_token( &sql->command[sql->n], &token, &skip );
        if( sql->len==0 )
            break;
        str->data = &sql->command[sql->n];
        str->len = sql->len;
        sql->n += skip;
    }
    while( token == TK_SPACE );

    /* TRACE("token : %d (%s)\n", token, debugstr_an(&sql->command[sql->n], sql->len)); */

    return token;
}

unsigned sql_unescape_string( void *info, const struct sql_str *strdata, char **str )
{
    const char *p = strdata->data;
    unsigned len = strdata->len;

    /* match quotes */
    if( ( (p[0]=='`') && (p[len-1]!='`') ) ||
        ( (p[0]=='\'') && (p[len-1]!='\'') ) )
        return LIBMSI_RESULT_FUNCTION_FAILED;

    /* if there's quotes, remove them */
    if( ( (p[0]=='`') && (p[len-1]=='`') ) ||
        ( (p[0]=='\'') && (p[len-1]=='\'') ) )
    {
        p++;
        len -= 2;
    }
    *str = parser_alloc( info, (len + 1)*sizeof(char) );
    if( !*str )
        return LIBMSI_RESULT_OUTOFMEMORY;
    memcpy( *str, p, len*sizeof(char) );
    (*str)[len]=0;

    return LIBMSI_RESULT_SUCCESS;
}

int sql_atoi( void *info )
{
    SQL_input* sql = (SQL_input*) info;
    const char *p = &sql->command[sql->n];
    int i, r = 0;

    for( i=0; i<sql->len; i++ )
    {
        if( '0' > p[i] || '9' < p[i] )
        {
            g_critical("should only be numbers here!\n");
            break;
        }
        r = (p[i]-'0') + r*10;
    }

    return r;
}

static int sql_error(void *info, const char *str )
{
    return 0;
}

static struct expr * build_expr_wildcard( void *info )
{
    struct expr *e = parser_alloc( info, sizeof *e );
    if( e )
    {
        e->type = EXPR_WILDCARD;
    }
    return e;
}

static struct expr * build_expr_complex( void *info, struct expr *l, unsigned op, struct expr *r )
{
    struct expr *e = parser_alloc( info, sizeof *e );
    if( e )
    {
        e->type = EXPR_COMPLEX;
        e->u.expr.left = l;
        e->u.expr.op = op;
        e->u.expr.right = r;
    }
    return e;
}

static struct expr * build_expr_unary( void *info, struct expr *l, unsigned op )
{
    struct expr *e = parser_alloc( info, sizeof *e );
    if( e )
    {
        e->type = EXPR_UNARY;
        e->u.expr.left = l;
        e->u.expr.op = op;
        e->u.expr.right = NULL;
    }
    return e;
}

static struct expr * build_expr_column( void *info, const column_info *column )
{
    struct expr *e = parser_alloc( info, sizeof *e );
    if( e )
    {
        e->type = EXPR_COLUMN;
        e->u.column.unparsed.column = column->column;
        e->u.column.unparsed.table = column->table;
    }
    return e;
}

static struct expr * build_expr_ival( void *info, int val )
{
    struct expr *e = parser_alloc( info, sizeof *e );
    if( e )
    {
        e->type = EXPR_IVAL;
        e->u.ival = val;
    }
    return e;
}

static struct expr * build_expr_sval( void *info, const struct sql_str *str )
{
    struct expr *e = parser_alloc( info, sizeof *e );
    if( e )
    {
        e->type = EXPR_SVAL;
        if( sql_unescape_string( info, str, (char **)&e->u.sval ) != LIBMSI_RESULT_SUCCESS )
            return NULL; /* e will be freed by query destructor */
    }
    return e;
}

static void swap_columns( column_info **cols, column_info *A, int idx )
{
    column_info *preA = NULL, *preB = NULL, *B, *ptr;
    int i = 0;

    B = NULL;
    ptr = *cols;
    while( ptr )
    {
        if( i++ == idx )
            B = ptr;
        else if( !B )
            preB = ptr;

        if( ptr->next == A )
            preA = ptr;

        ptr = ptr->next;
    }

    if( preB ) preB->next = A;
    if( preA ) preA->next = B;
    ptr = A->next;
    A->next = B->next;
    B->next = ptr;
    if( idx == 0 )
      *cols = A;
}

static bool sql_mark_primary_keys( column_info **cols,
                                 column_info *keys )
{
    column_info *k;
    bool found = true;
    int count;

    for( k = keys, count = 0; k && found; k = k->next, count++ )
    {
        column_info *c;
        int idx;

        found = false;
        for( c = *cols, idx = 0; c && !found; c = c->next, idx++ )
        {
            if( strcmp( k->column, c->column ) )
                continue;
            c->type |= MSITYPE_KEY;
            found = true;
            if (idx != count)
                swap_columns( cols, c, count );
        }
    }

    return found;
}

unsigned _libmsi_parse_sql( LibmsiDatabase *db, const char *command, LibmsiView **phview,
                   struct list *mem )
{
    SQL_input sql;
    int r;

    *phview = NULL;

    sql.db = db;
    sql.command = command;
    sql.n = 0;
    sql.len = 0;
    sql.r = LIBMSI_RESULT_BAD_QUERY_SYNTAX;
    sql.view = phview;
    sql.mem = mem;

    r = sql_parse(&sql);

    TRACE("Parse returned %d\n", r);
    if( r )
    {
        if (*sql.view)
        {
            (*sql.view)->ops->delete(*sql.view);
            *sql.view = NULL;
        }
        return sql.r;
    }

    return LIBMSI_RESULT_SUCCESS;
}
