/* Generated by wayland-scanner 1.23.1 */

#ifndef WL_EGLSTREAM_CONTROLLER_SERVER_PROTOCOL_H
#define WL_EGLSTREAM_CONTROLLER_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wl_eglstream_controller The wl_eglstream_controller protocol
 * @section page_ifaces_wl_eglstream_controller Interfaces
 * - @subpage page_iface_wl_eglstream_controller - 
 * @section page_copyright_wl_eglstream_controller Copyright
 * <pre>
 *
 * Copyright (c) 2017-2018, NVIDIA CORPORATION. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wl_eglstream_controller;
struct wl_surface;

#ifndef WL_EGLSTREAM_CONTROLLER_INTERFACE
#define WL_EGLSTREAM_CONTROLLER_INTERFACE
/**
 * @page page_iface_wl_eglstream_controller wl_eglstream_controller
 * @section page_iface_wl_eglstream_controller_api API
 * See @ref iface_wl_eglstream_controller.
 */
/**
 * @defgroup iface_wl_eglstream_controller The wl_eglstream_controller interface
 */
extern const struct wl_interface wl_eglstream_controller_interface;
#endif

#ifndef WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_ENUM
#define WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_ENUM
/**
 * @ingroup iface_wl_eglstream_controller
 * Stream present mode
 *
 * - dont_care: Using this enum will tell the server to make its own
 * decisions regarding present mode.
 *
 * - fifo:      Tells the server to use a fifo present mode. The decision to
 * use fifo synchronous is left up to the server.
 *
 * - mailbox:   Tells the server to use a mailbox present mode.
 */
enum wl_eglstream_controller_present_mode {
	/**
	 * Let the Server decide present mode
	 */
	WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_DONT_CARE = 0,
	/**
	 * Use a fifo present mode
	 */
	WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_FIFO = 1,
	/**
	 * Use a mailbox mode
	 */
	WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_MAILBOX = 2,
};
/**
 * @ingroup iface_wl_eglstream_controller
 * Validate a wl_eglstream_controller present_mode value.
 *
 * @return true on success, false on error.
 * @ref wl_eglstream_controller_present_mode
 */
static inline bool
wl_eglstream_controller_present_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_DONT_CARE:
		return version >= 1;
	case WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_FIFO:
		return version >= 1;
	case WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_MAILBOX:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_ENUM */

#ifndef WL_EGLSTREAM_CONTROLLER_ATTRIB_ENUM
#define WL_EGLSTREAM_CONTROLLER_ATTRIB_ENUM
/**
 * @ingroup iface_wl_eglstream_controller
 * Stream consumer attachment attributes
 *
 * - present_mode: Must be one of wl_eglstream_controller_present_mode. Tells the
 * server the desired present mode that should be used.
 *
 * - fifo_length:  Only valid when the present_mode attrib is provided and its
 * value is specified as fifo. Tells the server the desired fifo
 * length to be used when the desired present_mode is fifo.
 */
enum wl_eglstream_controller_attrib {
	/**
	 * Tells the server the desired present mode
	 */
	WL_EGLSTREAM_CONTROLLER_ATTRIB_PRESENT_MODE = 0,
	/**
	 * Tells the server the desired fifo length when the desired presenation_mode is fifo.
	 */
	WL_EGLSTREAM_CONTROLLER_ATTRIB_FIFO_LENGTH = 1,
};
/**
 * @ingroup iface_wl_eglstream_controller
 * Validate a wl_eglstream_controller attrib value.
 *
 * @return true on success, false on error.
 * @ref wl_eglstream_controller_attrib
 */
static inline bool
wl_eglstream_controller_attrib_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WL_EGLSTREAM_CONTROLLER_ATTRIB_PRESENT_MODE:
		return version >= 1;
	case WL_EGLSTREAM_CONTROLLER_ATTRIB_FIFO_LENGTH:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WL_EGLSTREAM_CONTROLLER_ATTRIB_ENUM */

/**
 * @ingroup iface_wl_eglstream_controller
 * @struct wl_eglstream_controller_interface
 */
struct wl_eglstream_controller_interface {
	/**
	 * Create server stream and attach consumer
	 *
	 * Creates the corresponding server side EGLStream from the given
	 * wl_buffer and attaches a consumer to it.
	 * @param wl_surface wl_surface corresponds to the client surface associated with         newly created eglstream
	 * @param wl_resource wl_resource corresponding to an EGLStream
	 */
	void (*attach_eglstream_consumer)(struct wl_client *client,
					  struct wl_resource *resource,
					  struct wl_resource *wl_surface,
					  struct wl_resource *wl_resource);
	/**
	 * List of attributes with consumer attachment data
	 *
	 * It contains key-value pairs compatible with intptr_t type. A
	 * key must be one of wl_eglstream_controller_attrib enumeration
	 * values. What a value represents is attribute-specific.
	 * @param wl_surface wl_surface corresponds to the client surface associated with         newly created eglstream
	 * @param wl_resource wl_resource corresponding to an EGLStream
	 * @param attribs Stream consumer attachment attribs
	 * @since 2
	 */
	void (*attach_eglstream_consumer_attribs)(struct wl_client *client,
						  struct wl_resource *resource,
						  struct wl_resource *wl_surface,
						  struct wl_resource *wl_resource,
						  struct wl_array *attribs);
};


/**
 * @ingroup iface_wl_eglstream_controller
 */
#define WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER_SINCE_VERSION 1
/**
 * @ingroup iface_wl_eglstream_controller
 */
#define WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER_ATTRIBS_SINCE_VERSION 2

#ifdef  __cplusplus
}
#endif

#endif
