/* FlatpakBundleFile.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FlatpakBundleFile.vala, do not modify */

/*
* Copyright 2021-2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <flatpak.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDELOAD_TYPE_FLATPAK_FILE (sideload_flatpak_file_get_type ())
#define SIDELOAD_FLATPAK_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFile))
#define SIDELOAD_FLATPAK_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFileClass))
#define SIDELOAD_IS_FLATPAK_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_FLATPAK_FILE))
#define SIDELOAD_IS_FLATPAK_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_FLATPAK_FILE))
#define SIDELOAD_FLATPAK_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_FLATPAK_FILE, SideloadFlatpakFileClass))

typedef struct _SideloadFlatpakFile SideloadFlatpakFile;
typedef struct _SideloadFlatpakFileClass SideloadFlatpakFileClass;
typedef struct _SideloadFlatpakFilePrivate SideloadFlatpakFilePrivate;

#define SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE (sideload_flatpak_bundle_file_get_type ())
#define SIDELOAD_FLATPAK_BUNDLE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile))
#define SIDELOAD_FLATPAK_BUNDLE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFileClass))
#define SIDELOAD_IS_FLATPAK_BUNDLE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE))
#define SIDELOAD_IS_FLATPAK_BUNDLE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE))
#define SIDELOAD_FLATPAK_BUNDLE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFileClass))

typedef struct _SideloadFlatpakBundleFile SideloadFlatpakBundleFile;
typedef struct _SideloadFlatpakBundleFileClass SideloadFlatpakBundleFileClass;
typedef struct _SideloadFlatpakBundleFilePrivate SideloadFlatpakBundleFilePrivate;
enum  {
	SIDELOAD_FLATPAK_BUNDLE_FILE_0_PROPERTY,
	SIDELOAD_FLATPAK_BUNDLE_FILE_HAS_REMOTE_PROPERTY,
	SIDELOAD_FLATPAK_BUNDLE_FILE_NUM_PROPERTIES
};
static GParamSpec* sideload_flatpak_bundle_file_properties[SIDELOAD_FLATPAK_BUNDLE_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SideloadFlatpakBundleFileGetIdData SideloadFlatpakBundleFileGetIdData;
typedef struct _SideloadFlatpakBundleFileGetNameData SideloadFlatpakBundleFileGetNameData;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _SideloadFlatpakBundleFileDryRunData SideloadFlatpakBundleFileDryRunData;
typedef struct _SideloadFlatpakBundleFileGetDetailsData SideloadFlatpakBundleFileGetDetailsData;
typedef struct _SideloadFlatpakBundleFileInstallData SideloadFlatpakBundleFileInstallData;
typedef struct _SideloadFlatpakBundleFileLaunchData SideloadFlatpakBundleFileLaunchData;

struct _SideloadFlatpakFile {
	GObject parent_instance;
	SideloadFlatpakFilePrivate * priv;
	gchar* appdata_name;
	gint error_code;
	gchar* error_message;
};

struct _SideloadFlatpakFileClass {
	GObjectClass parent_class;
	void (*get_id) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_id_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*get_name) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*get_name_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*get_details) (SideloadFlatpakFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_details_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
	void (*install) (SideloadFlatpakFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_, GError** error);
	void (*launch) (SideloadFlatpakFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*launch_finish) (SideloadFlatpakFile* self, GAsyncResult* _res_);
};

struct _SideloadFlatpakBundleFile {
	SideloadFlatpakFile parent_instance;
	SideloadFlatpakBundleFilePrivate * priv;
};

struct _SideloadFlatpakBundleFileClass {
	SideloadFlatpakFileClass parent_class;
};

struct _SideloadFlatpakBundleFilePrivate {
	gboolean _has_remote;
	FlatpakBundleRef* bundle;
};

struct _SideloadFlatpakBundleFileGetIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakBundleFile* self;
	gchar* result;
	FlatpakBundleRef* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
};

struct _SideloadFlatpakBundleFileGetNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakBundleFile* self;
	gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FlatpakBundleRef* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
};

struct _Block11Data {
	int _ref_count_;
	SideloadFlatpakBundleFile* self;
	GeeArrayList* added_remotes;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	FlatpakTransaction* transaction;
	GError* transaction_error;
};

struct _SideloadFlatpakBundleFileDryRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakBundleFile* self;
	GCancellable* cancellable;
	Block11Data* _data11_;
	FlatpakInstallation* _tmp0_;
	GError* _tmp1_;
	GeeArrayList* _tmp2_;
	Block12Data* _data12_;
	gchar* flatpak_id;
	FlatpakBundleRef* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* appstream_file;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFileOutputStream* stream;
	GFile* _tmp14_;
	GFileOutputStream* _tmp15_;
	GFileOutputStream* _tmp16_;
	FlatpakBundleRef* _tmp17_;
	GBytes* _tmp18_;
	GBytes* _tmp19_;
	GFile* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error1_;
	GFile* _tmp28_;
	FlatpakInstallation* _tmp29_;
	FlatpakBundleRef* _tmp30_;
	FlatpakRefKind _tmp31_;
	FlatpakRefKind _tmp32_;
	const gchar* _tmp33_;
	FlatpakBundleRef* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	FlatpakInstalledRef* _tmp37_;
	FlatpakInstalledRef* _tmp38_;
	FlatpakInstallation* _tmp39_;
	FlatpakTransaction* _tmp40_;
	FlatpakTransaction* _tmp41_;
	FlatpakTransaction* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	FlatpakTransaction* _tmp45_;
	FlatpakTransaction* _tmp46_;
	GThread* _tmp47_;
	GThread* _tmp48_;
	GPtrArray* _tmp49_;
	FlatpakInstallation* _tmp50_;
	GPtrArray* _tmp51_;
	GError* _tmp52_;
	GError* _tmp53_;
	GError* _tmp54_;
	GError* _vala1_e;
	GError* _tmp55_;
	GError* _tmp56_;
	GError* _inner_error0_;
};

struct _SideloadFlatpakBundleFileGetDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakBundleFile* self;
	GCancellable* cancellable;
	GError* e;
	GError* _tmp0_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _SideloadFlatpakBundleFileInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakBundleFile* self;
	GCancellable* cancellable;
	FlatpakInstallation* _tmp0_;
	GError* _tmp1_;
	FlatpakTransaction* transaction;
	FlatpakInstallation* _tmp2_;
	FlatpakTransaction* _tmp3_;
	FlatpakTransaction* _tmp4_;
	FlatpakTransaction* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	FlatpakTransaction* _tmp8_;
	FlatpakTransaction* _tmp9_;
	FlatpakTransaction* _tmp10_;
	FlatpakTransaction* _tmp11_;
	FlatpakTransaction* _tmp12_;
	GError* e;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _SideloadFlatpakBundleFileLaunchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SideloadFlatpakBundleFile* self;
	FlatpakInstallation* _tmp0_;
	FlatpakBundleRef* _tmp1_;
	const gchar* _tmp2_;
	FlatpakBundleRef* _tmp3_;
	const gchar* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

static gint SideloadFlatpakBundleFile_private_offset;
static gpointer sideload_flatpak_bundle_file_parent_class = NULL;
VALA_EXTERN FlatpakInstallation* sideload_flatpak_file_installation;

VALA_EXTERN GType sideload_flatpak_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadFlatpakFile, g_object_unref)
VALA_EXTERN GType sideload_flatpak_bundle_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadFlatpakBundleFile, g_object_unref)
VALA_EXTERN void sideload_flatpak_file_get_id (SideloadFlatpakFile* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gchar* sideload_flatpak_file_get_id_finish (SideloadFlatpakFile* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_get_name (SideloadFlatpakFile* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN gchar* sideload_flatpak_file_get_name_finish (SideloadFlatpakFile* self,
                                              GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_get_details (SideloadFlatpakFile* self,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_get_details_finish (SideloadFlatpakFile* self,
                                               GAsyncResult* _res_);
VALA_EXTERN void sideload_flatpak_file_install (SideloadFlatpakFile* self,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_install_finish (SideloadFlatpakFile* self,
                                           GAsyncResult* _res_,
                                           GError** error);
VALA_EXTERN void sideload_flatpak_file_launch (SideloadFlatpakFile* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_launch_finish (SideloadFlatpakFile* self,
                                          GAsyncResult* _res_);
VALA_EXTERN SideloadFlatpakBundleFile* sideload_flatpak_bundle_file_new (GFile* file);
VALA_EXTERN SideloadFlatpakBundleFile* sideload_flatpak_bundle_file_construct (GType object_type,
                                                                   GFile* file);
static void sideload_flatpak_bundle_file_real_get_id_data_free (gpointer _data);
static void sideload_flatpak_bundle_file_real_get_id (SideloadFlatpakFile* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean sideload_flatpak_bundle_file_real_get_id_co (SideloadFlatpakBundleFileGetIdData* _data_);
static void sideload_flatpak_bundle_file_real_get_name_data_free (gpointer _data);
static void sideload_flatpak_bundle_file_real_get_name (SideloadFlatpakFile* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean sideload_flatpak_bundle_file_real_get_name_co (SideloadFlatpakBundleFileGetNameData* _data_);
static void sideload_flatpak_bundle_file_dry_run_data_free (gpointer _data);
static void sideload_flatpak_bundle_file_dry_run (SideloadFlatpakBundleFile* self,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void sideload_flatpak_bundle_file_dry_run_finish (SideloadFlatpakBundleFile* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static gboolean sideload_flatpak_bundle_file_dry_run_co (SideloadFlatpakBundleFileDryRunData* _data_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN GFile* sideload_flatpak_file_get_file (SideloadFlatpakFile* self);
static void sideload_flatpak_bundle_file_dry_run_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN gboolean sideload_flatpak_file_parse_xml (SideloadFlatpakFile* self,
                                          GFile* appstream_file,
                                          const gchar* id);
VALA_EXTERN void sideload_flatpak_file_set_already_installed (SideloadFlatpakFile* self,
                                                  gboolean value);
static gboolean ___lambda22_ (Block12Data* _data12_,
                       FlatpakTransactionRemoteReason reason,
                       const gchar* from_id,
                       const gchar* remote_name,
                       const gchar* url);
VALA_EXTERN void sideload_flatpak_file_set_extra_remotes_needed (SideloadFlatpakFile* self,
                                                     gboolean value);
static gboolean ____lambda22__flatpak_transaction_add_new_remote (FlatpakTransaction* _sender,
                                                           FlatpakTransactionRemoteReason reason,
                                                           const gchar* from_id,
                                                           const gchar* remote_name,
                                                           const gchar* url,
                                                           gpointer self);
static gboolean ___lambda23_ (SideloadFlatpakBundleFile* self);
static gboolean ____lambda23__flatpak_transaction_ready (FlatpakTransaction* _sender,
                                                  gpointer self);
static void* ___lambda24_ (Block12Data* _data12_);
static gboolean _sideload_flatpak_bundle_file_dry_run_co_gsource_func (gpointer self);
static gpointer ____lambda24__gthread_func (gpointer self);
static void ___lambda25_ (Block12Data* _data12_,
                   FlatpakRemote* remote);
static void ____lambda25__gfunc (gconstpointer data,
                          gpointer self);
static void sideload_flatpak_bundle_file_real_get_details_data_free (gpointer _data);
static void sideload_flatpak_bundle_file_real_get_details (SideloadFlatpakFile* base,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean sideload_flatpak_bundle_file_real_get_details_co (SideloadFlatpakBundleFileGetDetailsData* _data_);
static void sideload_flatpak_bundle_file_get_details_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void sideload_flatpak_bundle_file_real_install_data_free (gpointer _data);
static void sideload_flatpak_bundle_file_real_install (SideloadFlatpakFile* base,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean sideload_flatpak_bundle_file_real_install_co (SideloadFlatpakBundleFileInstallData* _data_);
static gboolean ___lambda26_ (SideloadFlatpakBundleFile* self,
                       FlatpakTransactionRemoteReason reason,
                       const gchar* from,
                       const gchar* name,
                       const gchar* url);
static gboolean ____lambda26__flatpak_transaction_add_new_remote (FlatpakTransaction* _sender,
                                                           FlatpakTransactionRemoteReason reason,
                                                           const gchar* from_id,
                                                           const gchar* remote_name,
                                                           const gchar* url,
                                                           gpointer self);
VALA_EXTERN gboolean sideload_flatpak_file_on_operation_error (SideloadFlatpakFile* self,
                                                   FlatpakTransactionOperation* op,
                                                   GError* e,
                                                   FlatpakTransactionErrorDetails details);
static gboolean _sideload_flatpak_file_on_operation_error_flatpak_transaction_operation_error (FlatpakTransaction* _sender,
                                                                                        FlatpakTransactionOperation* operation,
                                                                                        GError* _error_,
                                                                                        FlatpakTransactionErrorDetails detail,
                                                                                        gpointer self);
static gint ___lambda27_ (SideloadFlatpakBundleFile* self,
                   const gchar* ref,
                   const gchar* runtime_ref,
                   gchar** remotes);
static gint ____lambda27__flatpak_transaction_choose_remote_for_ref (FlatpakTransaction* _sender,
                                                              const gchar* for_ref,
                                                              const gchar* runtime_ref,
                                                              gchar** remotes,
                                                              gpointer self);
static gboolean ___lambda28_ (SideloadFlatpakBundleFile* self);
static gboolean ____lambda28__flatpak_transaction_ready (FlatpakTransaction* _sender,
                                                  gpointer self);
VALA_EXTERN void sideload_flatpak_file_run_transaction_async (SideloadFlatpakFile* self,
                                                  FlatpakTransaction* transaction,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void sideload_flatpak_file_run_transaction_finish (SideloadFlatpakFile* self,
                                                   GAsyncResult* _res_);
static void sideload_flatpak_bundle_file_install_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void sideload_flatpak_bundle_file_real_launch_data_free (gpointer _data);
static void sideload_flatpak_bundle_file_real_launch (SideloadFlatpakFile* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean sideload_flatpak_bundle_file_real_launch_co (SideloadFlatpakBundleFileLaunchData* _data_);
VALA_EXTERN gboolean sideload_flatpak_bundle_file_get_has_remote (SideloadFlatpakBundleFile* self);
static void sideload_flatpak_bundle_file_set_has_remote (SideloadFlatpakBundleFile* self,
                                                  gboolean value);
static GObject * sideload_flatpak_bundle_file_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
VALA_EXTERN void sideload_flatpak_file_set_size (SideloadFlatpakFile* self,
                                     const gchar* value);
static void sideload_flatpak_bundle_file_finalize (GObject * obj);
static GType sideload_flatpak_bundle_file_get_type_once (void);
static void _vala_sideload_flatpak_bundle_file_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_sideload_flatpak_bundle_file_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
sideload_flatpak_bundle_file_get_instance_private (SideloadFlatpakBundleFile* self)
{
	return G_STRUCT_MEMBER_P (self, SideloadFlatpakBundleFile_private_offset);
}

SideloadFlatpakBundleFile*
sideload_flatpak_bundle_file_construct (GType object_type,
                                        GFile* file)
{
	SideloadFlatpakBundleFile * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (SideloadFlatpakBundleFile*) g_object_new (object_type, "file", file, NULL);
	return self;
}

SideloadFlatpakBundleFile*
sideload_flatpak_bundle_file_new (GFile* file)
{
	return sideload_flatpak_bundle_file_construct (SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, file);
}

static void
sideload_flatpak_bundle_file_real_get_id_data_free (gpointer _data)
{
	SideloadFlatpakBundleFileGetIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakBundleFileGetIdData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sideload_flatpak_bundle_file_real_get_id (SideloadFlatpakFile* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SideloadFlatpakBundleFile * self;
	SideloadFlatpakBundleFileGetIdData* _data_;
	SideloadFlatpakBundleFile* _tmp0_;
	self = (SideloadFlatpakBundleFile*) base;
	_data_ = g_slice_new0 (SideloadFlatpakBundleFileGetIdData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_bundle_file_real_get_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sideload_flatpak_bundle_file_real_get_id_co (_data_);
}

static gchar*
sideload_flatpak_bundle_file_get_id_finish (SideloadFlatpakFile* base,
                                            GAsyncResult* _res_)
{
	gchar* result;
	SideloadFlatpakBundleFileGetIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
sideload_flatpak_bundle_file_real_get_id_co (SideloadFlatpakBundleFileGetIdData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->bundle;
	_data_->_tmp1_ = flatpak_ref_get_name ((FlatpakRef*) _data_->_tmp0_);
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->result = _data_->_tmp2_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sideload_flatpak_bundle_file_real_get_name_data_free (gpointer _data)
{
	SideloadFlatpakBundleFileGetNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakBundleFileGetNameData, _data_);
}

static void
sideload_flatpak_bundle_file_real_get_name (SideloadFlatpakFile* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SideloadFlatpakBundleFile * self;
	SideloadFlatpakBundleFileGetNameData* _data_;
	SideloadFlatpakBundleFile* _tmp0_;
	self = (SideloadFlatpakBundleFile*) base;
	_data_ = g_slice_new0 (SideloadFlatpakBundleFileGetNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_bundle_file_real_get_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sideload_flatpak_bundle_file_real_get_name_co (_data_);
}

static gchar*
sideload_flatpak_bundle_file_get_name_finish (SideloadFlatpakFile* base,
                                              GAsyncResult* _res_)
{
	gchar* result;
	SideloadFlatpakBundleFileGetNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
sideload_flatpak_bundle_file_real_get_name_co (SideloadFlatpakBundleFileGetNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((SideloadFlatpakFile*) _data_->self)->appdata_name;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = ((SideloadFlatpakFile*) _data_->self)->appdata_name;
		_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
		_data_->result = _data_->_tmp2_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->bundle;
	_data_->_tmp4_ = flatpak_ref_get_name ((FlatpakRef*) _data_->_tmp3_);
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_data_->result = _data_->_tmp5_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sideload_flatpak_bundle_file_dry_run_data_free (gpointer _data)
{
	SideloadFlatpakBundleFileDryRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakBundleFileDryRunData, _data_);
}

static void
sideload_flatpak_bundle_file_dry_run (SideloadFlatpakBundleFile* self,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SideloadFlatpakBundleFileDryRunData* _data_;
	SideloadFlatpakBundleFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SideloadFlatpakBundleFileDryRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_bundle_file_dry_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	sideload_flatpak_bundle_file_dry_run_co (_data_);
}

static void
sideload_flatpak_bundle_file_dry_run_finish (SideloadFlatpakBundleFile* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	SideloadFlatpakBundleFileDryRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SideloadFlatpakBundleFile* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->added_remotes);
		_g_object_unref0 (_data11_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SideloadFlatpakBundleFile* self;
		self = _data12_->_data11_->self;
		_g_error_free0 (_data12_->transaction_error);
		_g_object_unref0 (_data12_->transaction);
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static void
sideload_flatpak_bundle_file_dry_run_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	SideloadFlatpakBundleFileDryRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sideload_flatpak_bundle_file_dry_run_co (_data_);
}

static gboolean
___lambda22_ (Block12Data* _data12_,
              FlatpakTransactionRemoteReason reason,
              const gchar* from_id,
              const gchar* remote_name,
              const gchar* url)
{
	Block11Data* _data11_;
	SideloadFlatpakBundleFile* self;
	gboolean result;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	g_return_val_if_fail (from_id != NULL, FALSE);
	g_return_val_if_fail (remote_name != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	if (reason == FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _data11_->added_remotes;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, url);
		sideload_flatpak_file_set_extra_remotes_needed ((SideloadFlatpakFile*) self, TRUE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda22__flatpak_transaction_add_new_remote (FlatpakTransaction* _sender,
                                                  FlatpakTransactionRemoteReason reason,
                                                  const gchar* from_id,
                                                  const gchar* remote_name,
                                                  const gchar* url,
                                                  gpointer self)
{
	gboolean result;
	result = ___lambda22_ (self, reason, from_id, remote_name, url);
	return result;
}

static gboolean
___lambda23_ (SideloadFlatpakBundleFile* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

static gboolean
____lambda23__flatpak_transaction_ready (FlatpakTransaction* _sender,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda23_ ((SideloadFlatpakBundleFile*) self);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
_sideload_flatpak_bundle_file_dry_run_co_gsource_func (gpointer self)
{
	gboolean result;
	result = sideload_flatpak_bundle_file_dry_run_co (self);
	return result;
}

static void*
___lambda24_ (Block12Data* _data12_)
{
	Block11Data* _data11_;
	SideloadFlatpakBundleFile* self;
	GError* _inner_error0_ = NULL;
	void* result;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	{
		FlatpakTransaction* _tmp0_;
		_tmp0_ = _data12_->transaction;
		flatpak_transaction_run (_tmp0_, _data11_->cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		GError* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_g_error_free0 (_data12_->transaction_error);
		_data12_->transaction_error = _tmp2_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _sideload_flatpak_bundle_file_dry_run_co_gsource_func, _data11_->_async_data_, NULL);
	result = NULL;
	return result;
}

static gpointer
____lambda24__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda24_ (self);
	block12_data_unref (self);
	return result;
}

static void
___lambda25_ (Block12Data* _data12_,
              FlatpakRemote* remote)
{
	Block11Data* _data11_;
	SideloadFlatpakBundleFile* self;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	g_return_if_fail (remote != NULL);
	_tmp0_ = _data11_->added_remotes;
	_tmp1_ = flatpak_remote_get_url (remote);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		{
			FlatpakInstallation* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = sideload_flatpak_file_installation;
			_tmp5_ = flatpak_remote_get_name (remote);
			flatpak_installation_remove_remote (_tmp4_, _tmp5_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("FlatpakBundleFile.vala:132: Error while removing dry run remote: %s", _tmp7_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
____lambda25__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda25_ (self, (FlatpakRemote*) data);
}

static gboolean
sideload_flatpak_bundle_file_dry_run_co (SideloadFlatpakBundleFileDryRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data11_ = g_slice_new0 (Block11Data);
	_data_->_data11_->_ref_count_ = 1;
	_data_->_data11_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data11_->cancellable);
	_data_->_data11_->cancellable = _data_->cancellable;
	_data_->_data11_->_async_data_ = _data_;
	_data_->_tmp0_ = sideload_flatpak_file_installation;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _ ("Did not find suitable Flatpak installation."));
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block11_data_unref (_data_->_data11_);
		_data_->_data11_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data_->_data11_->added_remotes = _data_->_tmp2_;
	{
		_data_->_data12_ = g_slice_new0 (Block12Data);
		_data_->_data12_->_ref_count_ = 1;
		_data_->_data12_->_data11_ = block11_data_ref (_data_->_data11_);
		_data_->_tmp3_ = _data_->self->priv->bundle;
		_data_->_tmp4_ = flatpak_ref_get_name ((FlatpakRef*) _data_->_tmp3_);
		_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
		_data_->flatpak_id = _data_->_tmp5_;
		_data_->_tmp6_ = sideload_flatpak_file_get_file ((SideloadFlatpakFile*) _data_->self);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = g_file_get_path (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_strconcat (_data_->_tmp9_, ".appstream", NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_file_new_for_path (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_g_free0 (_data_->_tmp11_);
		_g_free0 (_data_->_tmp9_);
		_data_->appstream_file = _data_->_tmp13_;
		{
			_data_->_tmp14_ = _data_->appstream_file;
			_data_->_tmp15_ = g_file_create (_data_->_tmp14_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error0_);
			_data_->stream = _data_->_tmp15_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp16_ = _data_->stream;
			_data_->_tmp17_ = _data_->self->priv->bundle;
			_data_->_tmp18_ = flatpak_bundle_ref_get_appstream (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_state_ = 1;
			g_output_stream_write_bytes_async ((GOutputStream*) _data_->_tmp16_, _data_->_tmp19_, G_PRIORITY_DEFAULT, NULL, sideload_flatpak_bundle_file_dry_run_ready, _data_);
			return FALSE;
			_state_1:
			g_output_stream_write_bytes_finish ((GOutputStream*) _data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
			_g_bytes_unref0 (_data_->_tmp19_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->stream);
				goto __catch1_g_error;
			}
			_data_->_tmp20_ = _data_->appstream_file;
			_data_->_tmp21_ = _data_->flatpak_id;
			if (!sideload_flatpak_file_parse_xml ((SideloadFlatpakFile*) _data_->self, _data_->_tmp20_, _data_->_tmp21_)) {
				_data_->_tmp22_ = _data_->appstream_file;
				_data_->_tmp23_ = _data_->flatpak_id;
				_data_->_tmp24_ = g_strconcat (_data_->_tmp23_, ".desktop", NULL);
				_data_->_tmp25_ = _data_->_tmp24_;
				sideload_flatpak_file_parse_xml ((SideloadFlatpakFile*) _data_->self, _data_->_tmp22_, _data_->_tmp25_);
				_g_free0 (_data_->_tmp25_);
			}
			_g_object_unref0 (_data_->stream);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp26_ = _data_->e;
			_data_->_tmp27_ = _data_->_tmp26_->message;
			g_warning ("FlatpakBundleFile.vala:79: Error while trying to get the bundle appstr" \
"eam file: %s", _data_->_tmp27_);
			_g_error_free0 (_data_->e);
		}
		__finally1:
		{
			_data_->_tmp28_ = _data_->appstream_file;
			g_file_trash_async (_data_->_tmp28_, G_PRIORITY_DEFAULT, NULL, NULL, NULL);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->appstream_file);
			_g_free0 (_data_->flatpak_id);
			block12_data_unref (_data_->_data12_);
			_data_->_data12_ = NULL;
			goto __catch0_g_error;
		}
		{
			_data_->_tmp29_ = sideload_flatpak_file_installation;
			_data_->_tmp30_ = _data_->self->priv->bundle;
			_data_->_tmp31_ = flatpak_ref_get_kind ((FlatpakRef*) _data_->_tmp30_);
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = _data_->flatpak_id;
			_data_->_tmp34_ = _data_->self->priv->bundle;
			_data_->_tmp35_ = flatpak_ref_get_branch ((FlatpakRef*) _data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = flatpak_installation_get_installed_ref (_data_->_tmp29_, _data_->_tmp32_, _data_->_tmp33_, NULL, _data_->_tmp36_, NULL, &_data_->_inner_error0_);
			_data_->_tmp38_ = _data_->_tmp37_;
			_g_object_unref0 (_data_->_tmp38_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			sideload_flatpak_file_set_already_installed ((SideloadFlatpakFile*) _data_->self, TRUE);
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			sideload_flatpak_file_set_already_installed ((SideloadFlatpakFile*) _data_->self, FALSE);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->appstream_file);
			_g_free0 (_data_->flatpak_id);
			block12_data_unref (_data_->_data12_);
			_data_->_data12_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp39_ = sideload_flatpak_file_installation;
		_data_->_tmp40_ = flatpak_transaction_new_for_installation (_data_->_tmp39_, _data_->_data11_->cancellable, &_data_->_inner_error0_);
		_data_->_data12_->transaction = _data_->_tmp40_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->appstream_file);
			_g_free0 (_data_->flatpak_id);
			block12_data_unref (_data_->_data12_);
			_data_->_data12_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp41_ = _data_->_data12_->transaction;
		flatpak_transaction_add_default_dependency_sources (_data_->_tmp41_);
		_data_->_tmp42_ = _data_->_data12_->transaction;
		_data_->_tmp43_ = sideload_flatpak_file_get_file ((SideloadFlatpakFile*) _data_->self);
		_data_->_tmp44_ = _data_->_tmp43_;
		flatpak_transaction_add_install_bundle (_data_->_tmp42_, _data_->_tmp44_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->appstream_file);
			_g_free0 (_data_->flatpak_id);
			block12_data_unref (_data_->_data12_);
			_data_->_data12_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp45_ = _data_->_data12_->transaction;
		g_signal_connect_data (_data_->_tmp45_, "add-new-remote", (GCallback) ____lambda22__flatpak_transaction_add_new_remote, block12_data_ref (_data_->_data12_), (GClosureNotify) block12_data_unref, 0);
		_data_->_tmp46_ = _data_->_data12_->transaction;
		g_signal_connect_object (_data_->_tmp46_, "ready", (GCallback) ____lambda23__flatpak_transaction_ready, _data_->self, 0);
		_data_->_data12_->transaction_error = NULL;
		_data_->_tmp47_ = g_thread_new ("install-bundle", ____lambda24__gthread_func, block12_data_ref (_data_->_data12_));
		_data_->_tmp48_ = _data_->_tmp47_;
		_g_thread_unref0 (_data_->_tmp48_);
		_data_->_state_ = 2;
		return FALSE;
		_state_2:
		;
		_data_->_tmp50_ = sideload_flatpak_file_installation;
		_data_->_tmp51_ = flatpak_installation_list_remotes (_data_->_tmp50_, NULL, &_data_->_inner_error0_);
		_data_->_tmp49_ = _data_->_tmp51_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->appstream_file);
			_g_free0 (_data_->flatpak_id);
			block12_data_unref (_data_->_data12_);
			_data_->_data12_ = NULL;
			goto __catch0_g_error;
		}
		g_ptr_array_foreach (_data_->_tmp49_, ____lambda25__gfunc, _data_->_data12_);
		_data_->_tmp52_ = _data_->_data12_->transaction_error;
		if (_data_->_tmp52_ != NULL) {
			_data_->_tmp53_ = _data_->_data12_->transaction_error;
			_data_->_tmp54_ = _g_error_copy0 (_data_->_tmp53_);
			_data_->_inner_error0_ = _data_->_tmp54_;
			_g_ptr_array_unref0 (_data_->_tmp49_);
			_g_object_unref0 (_data_->appstream_file);
			_g_free0 (_data_->flatpak_id);
			block12_data_unref (_data_->_data12_);
			_data_->_data12_ = NULL;
			goto __catch0_g_error;
		}
		_g_ptr_array_unref0 (_data_->_tmp49_);
		_g_object_unref0 (_data_->appstream_file);
		_g_free0 (_data_->flatpak_id);
		block12_data_unref (_data_->_data12_);
		_data_->_data12_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp55_ = _data_->_vala1_e;
		_data_->_tmp56_ = _g_error_copy0 (_data_->_tmp55_);
		_data_->_inner_error0_ = _data_->_tmp56_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block11_data_unref (_data_->_data11_);
		_data_->_data11_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block11_data_unref (_data_->_data11_);
	_data_->_data11_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sideload_flatpak_bundle_file_real_get_details_data_free (gpointer _data)
{
	SideloadFlatpakBundleFileGetDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakBundleFileGetDetailsData, _data_);
}

static void
sideload_flatpak_bundle_file_real_get_details (SideloadFlatpakFile* base,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SideloadFlatpakBundleFile * self;
	SideloadFlatpakBundleFileGetDetailsData* _data_;
	SideloadFlatpakBundleFile* _tmp0_;
	GCancellable* _tmp1_;
	self = (SideloadFlatpakBundleFile*) base;
	_data_ = g_slice_new0 (SideloadFlatpakBundleFileGetDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_bundle_file_real_get_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	sideload_flatpak_bundle_file_real_get_details_co (_data_);
}

static void
sideload_flatpak_bundle_file_get_details_finish (SideloadFlatpakFile* base,
                                                 GAsyncResult* _res_)
{
	SideloadFlatpakBundleFileGetDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
sideload_flatpak_bundle_file_get_details_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SideloadFlatpakBundleFileGetDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sideload_flatpak_bundle_file_real_get_details_co (_data_);
}

static gboolean
sideload_flatpak_bundle_file_real_get_details_co (SideloadFlatpakBundleFileGetDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		sideload_flatpak_bundle_file_dry_run (_data_->self, _data_->cancellable, sideload_flatpak_bundle_file_get_details_ready, _data_);
		return FALSE;
		_state_1:
		sideload_flatpak_bundle_file_dry_run_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->e;
		if (!g_error_matches (_data_->_tmp0_, FLATPAK_ERROR, FLATPAK_ERROR_ABORTED)) {
			_data_->_tmp1_ = _data_->e;
			_data_->_tmp2_ = _data_->_tmp1_->message;
			g_warning ("FlatpakBundleFile.vala:150: Error during dry run: %s", _data_->_tmp2_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	{
		g_signal_emit_by_name ((SideloadFlatpakFile*) _data_->self, "details-ready");
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sideload_flatpak_bundle_file_real_install_data_free (gpointer _data)
{
	SideloadFlatpakBundleFileInstallData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakBundleFileInstallData, _data_);
}

static void
sideload_flatpak_bundle_file_real_install (SideloadFlatpakFile* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	SideloadFlatpakBundleFile * self;
	SideloadFlatpakBundleFileInstallData* _data_;
	SideloadFlatpakBundleFile* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (cancellable != NULL);
	self = (SideloadFlatpakBundleFile*) base;
	_data_ = g_slice_new0 (SideloadFlatpakBundleFileInstallData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_bundle_file_real_install_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	sideload_flatpak_bundle_file_real_install_co (_data_);
}

static void
sideload_flatpak_bundle_file_install_finish (SideloadFlatpakFile* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	SideloadFlatpakBundleFileInstallData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
___lambda26_ (SideloadFlatpakBundleFile* self,
              FlatpakTransactionRemoteReason reason,
              const gchar* from,
              const gchar* name,
              const gchar* url)
{
	gboolean result;
	g_return_val_if_fail (from != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	if (reason == FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda26__flatpak_transaction_add_new_remote (FlatpakTransaction* _sender,
                                                  FlatpakTransactionRemoteReason reason,
                                                  const gchar* from_id,
                                                  const gchar* remote_name,
                                                  const gchar* url,
                                                  gpointer self)
{
	gboolean result;
	result = ___lambda26_ ((SideloadFlatpakBundleFile*) self, reason, from_id, remote_name, url);
	return result;
}

static gboolean
_sideload_flatpak_file_on_operation_error_flatpak_transaction_operation_error (FlatpakTransaction* _sender,
                                                                               FlatpakTransactionOperation* operation,
                                                                               GError* _error_,
                                                                               FlatpakTransactionErrorDetails detail,
                                                                               gpointer self)
{
	gboolean result;
	result = sideload_flatpak_file_on_operation_error ((SideloadFlatpakFile*) self, operation, _error_, detail);
	return result;
}

static gint
___lambda27_ (SideloadFlatpakBundleFile* self,
              const gchar* ref,
              const gchar* runtime_ref,
              gchar** remotes)
{
	gint result;
	g_return_val_if_fail (ref != NULL, 0);
	g_return_val_if_fail (runtime_ref != NULL, 0);
	if (_vala_array_length (remotes) > 0) {
		result = 0;
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint
____lambda27__flatpak_transaction_choose_remote_for_ref (FlatpakTransaction* _sender,
                                                         const gchar* for_ref,
                                                         const gchar* runtime_ref,
                                                         gchar** remotes,
                                                         gpointer self)
{
	gint result;
	result = ___lambda27_ ((SideloadFlatpakBundleFile*) self, for_ref, runtime_ref, remotes);
	return result;
}

static gboolean
___lambda28_ (SideloadFlatpakBundleFile* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
____lambda28__flatpak_transaction_ready (FlatpakTransaction* _sender,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda28_ ((SideloadFlatpakBundleFile*) self);
	return result;
}

static void
sideload_flatpak_bundle_file_install_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	SideloadFlatpakBundleFileInstallData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sideload_flatpak_bundle_file_real_install_co (_data_);
}

static gboolean
sideload_flatpak_bundle_file_real_install_co (SideloadFlatpakBundleFileInstallData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sideload_flatpak_file_installation;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _ ("Did not find suitable Flatpak installation."));
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = sideload_flatpak_file_installation;
		_data_->_tmp3_ = flatpak_transaction_new_for_installation (_data_->_tmp2_, _data_->cancellable, &_data_->_inner_error0_);
		_data_->transaction = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->transaction;
		flatpak_transaction_add_default_dependency_sources (_data_->_tmp4_);
		_data_->_tmp5_ = _data_->transaction;
		_data_->_tmp6_ = sideload_flatpak_file_get_file ((SideloadFlatpakFile*) _data_->self);
		_data_->_tmp7_ = _data_->_tmp6_;
		flatpak_transaction_add_install_bundle (_data_->_tmp5_, _data_->_tmp7_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->transaction);
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->transaction;
		g_signal_connect_object (_data_->_tmp8_, "add-new-remote", (GCallback) ____lambda26__flatpak_transaction_add_new_remote, _data_->self, 0);
		_data_->_tmp9_ = _data_->transaction;
		g_signal_connect_object (_data_->_tmp9_, "operation-error", (GCallback) _sideload_flatpak_file_on_operation_error_flatpak_transaction_operation_error, (SideloadFlatpakFile*) _data_->self, 0);
		_data_->_tmp10_ = _data_->transaction;
		g_signal_connect_object (_data_->_tmp10_, "choose-remote-for-ref", (GCallback) ____lambda27__flatpak_transaction_choose_remote_for_ref, _data_->self, 0);
		_data_->_tmp11_ = _data_->transaction;
		g_signal_connect_object (_data_->_tmp11_, "ready", (GCallback) ____lambda28__flatpak_transaction_ready, _data_->self, 0);
		_data_->_tmp12_ = _data_->transaction;
		_data_->_state_ = 1;
		sideload_flatpak_file_run_transaction_async ((SideloadFlatpakFile*) _data_->self, _data_->_tmp12_, _data_->cancellable, sideload_flatpak_bundle_file_install_ready, _data_);
		return FALSE;
		_state_1:
		sideload_flatpak_file_run_transaction_finish ((SideloadFlatpakFile*) _data_->self, _data_->_res_);
		_g_object_unref0 (_data_->transaction);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
		_data_->_inner_error0_ = _data_->_tmp14_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sideload_flatpak_bundle_file_real_launch_data_free (gpointer _data)
{
	SideloadFlatpakBundleFileLaunchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SideloadFlatpakBundleFileLaunchData, _data_);
}

static void
sideload_flatpak_bundle_file_real_launch (SideloadFlatpakFile* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SideloadFlatpakBundleFile * self;
	SideloadFlatpakBundleFileLaunchData* _data_;
	SideloadFlatpakBundleFile* _tmp0_;
	self = (SideloadFlatpakBundleFile*) base;
	_data_ = g_slice_new0 (SideloadFlatpakBundleFileLaunchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sideload_flatpak_bundle_file_real_launch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	sideload_flatpak_bundle_file_real_launch_co (_data_);
}

static void
sideload_flatpak_bundle_file_launch_finish (SideloadFlatpakFile* base,
                                            GAsyncResult* _res_)
{
	SideloadFlatpakBundleFileLaunchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
sideload_flatpak_bundle_file_real_launch_co (SideloadFlatpakBundleFileLaunchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = sideload_flatpak_file_installation;
		_data_->_tmp1_ = _data_->self->priv->bundle;
		_data_->_tmp2_ = flatpak_ref_get_name ((FlatpakRef*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->self->priv->bundle;
		_data_->_tmp4_ = flatpak_ref_get_branch ((FlatpakRef*) _data_->_tmp3_);
		flatpak_installation_launch (_data_->_tmp0_, _data_->_tmp2_, NULL, _data_->_tmp4_, NULL, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("FlatpakBundleFile.vala:202: Error launching app: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
sideload_flatpak_bundle_file_get_has_remote (SideloadFlatpakBundleFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_remote;
	return result;
}

static void
sideload_flatpak_bundle_file_set_has_remote (SideloadFlatpakBundleFile* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sideload_flatpak_bundle_file_get_has_remote (self);
	if (old_value != value) {
		self->priv->_has_remote = value;
		g_object_notify_by_pspec ((GObject *) self, sideload_flatpak_bundle_file_properties[SIDELOAD_FLATPAK_BUNDLE_FILE_HAS_REMOTE_PROPERTY]);
	}
}

static GObject *
sideload_flatpak_bundle_file_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SideloadFlatpakBundleFile * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (sideload_flatpak_bundle_file_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile);
	{
		FlatpakBundleRef* _tmp0_ = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		FlatpakBundleRef* _tmp3_;
		FlatpakBundleRef* _tmp4_;
		FlatpakBundleRef* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		FlatpakBundleRef* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp1_ = sideload_flatpak_file_get_file ((SideloadFlatpakFile*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = flatpak_bundle_ref_new (_tmp2_, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->bundle);
		self->priv->bundle = _tmp4_;
		_tmp5_ = self->priv->bundle;
		_tmp6_ = g_format_size_full (flatpak_bundle_ref_get_installed_size (_tmp5_), G_FORMAT_SIZE_DEFAULT);
		_tmp7_ = _tmp6_;
		sideload_flatpak_file_set_size ((SideloadFlatpakFile*) self, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = self->priv->bundle;
		_tmp9_ = flatpak_bundle_ref_get_origin (_tmp8_);
		_tmp10_ = _tmp9_;
		sideload_flatpak_bundle_file_set_has_remote (self, _tmp10_ != NULL);
		_g_free0 (_tmp10_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		sideload_flatpak_file_set_size ((SideloadFlatpakFile*) self, "0");
		((SideloadFlatpakFile*) self)->error_code = FLATPAK_ERROR_INVALID_REF;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strdup_printf (_ ("Error constructing Flatpak bundle: %s"), _tmp12_);
		_g_free0 (((SideloadFlatpakFile*) self)->error_message);
		((SideloadFlatpakFile*) self)->error_message = _tmp13_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
sideload_flatpak_bundle_file_class_init (SideloadFlatpakBundleFileClass * klass,
                                         gpointer klass_data)
{
	sideload_flatpak_bundle_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SideloadFlatpakBundleFile_private_offset);
	((SideloadFlatpakFileClass *) klass)->get_id = (void (*) (SideloadFlatpakFile*, GAsyncReadyCallback, gpointer)) sideload_flatpak_bundle_file_real_get_id;
	((SideloadFlatpakFileClass *) klass)->get_id_finish = (gchar* (*) (SideloadFlatpakFile*, GAsyncResult*)) sideload_flatpak_bundle_file_get_id_finish;
	((SideloadFlatpakFileClass *) klass)->get_name = (void (*) (SideloadFlatpakFile*, GAsyncReadyCallback, gpointer)) sideload_flatpak_bundle_file_real_get_name;
	((SideloadFlatpakFileClass *) klass)->get_name_finish = (gchar* (*) (SideloadFlatpakFile*, GAsyncResult*)) sideload_flatpak_bundle_file_get_name_finish;
	((SideloadFlatpakFileClass *) klass)->get_details = (void (*) (SideloadFlatpakFile*, GCancellable*, GAsyncReadyCallback, gpointer)) sideload_flatpak_bundle_file_real_get_details;
	((SideloadFlatpakFileClass *) klass)->get_details_finish = (void (*) (SideloadFlatpakFile*, GAsyncResult*)) sideload_flatpak_bundle_file_get_details_finish;
	((SideloadFlatpakFileClass *) klass)->install = (void (*) (SideloadFlatpakFile*, GCancellable*, GAsyncReadyCallback, gpointer)) sideload_flatpak_bundle_file_real_install;
	((SideloadFlatpakFileClass *) klass)->install_finish = (void (*) (SideloadFlatpakFile*, GAsyncResult*, GError**)) sideload_flatpak_bundle_file_install_finish;
	((SideloadFlatpakFileClass *) klass)->launch = (void (*) (SideloadFlatpakFile*, GAsyncReadyCallback, gpointer)) sideload_flatpak_bundle_file_real_launch;
	((SideloadFlatpakFileClass *) klass)->launch_finish = (void (*) (SideloadFlatpakFile*, GAsyncResult*)) sideload_flatpak_bundle_file_launch_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_sideload_flatpak_bundle_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sideload_flatpak_bundle_file_set_property;
	G_OBJECT_CLASS (klass)->constructor = sideload_flatpak_bundle_file_constructor;
	G_OBJECT_CLASS (klass)->finalize = sideload_flatpak_bundle_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_FLATPAK_BUNDLE_FILE_HAS_REMOTE_PROPERTY, sideload_flatpak_bundle_file_properties[SIDELOAD_FLATPAK_BUNDLE_FILE_HAS_REMOTE_PROPERTY] = g_param_spec_boolean ("has-remote", "has-remote", "has-remote", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
sideload_flatpak_bundle_file_instance_init (SideloadFlatpakBundleFile * self,
                                            gpointer klass)
{
	self->priv = sideload_flatpak_bundle_file_get_instance_private (self);
	self->priv->_has_remote = FALSE;
	self->priv->bundle = NULL;
}

static void
sideload_flatpak_bundle_file_finalize (GObject * obj)
{
	SideloadFlatpakBundleFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile);
	_g_object_unref0 (self->priv->bundle);
	G_OBJECT_CLASS (sideload_flatpak_bundle_file_parent_class)->finalize (obj);
}

static GType
sideload_flatpak_bundle_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SideloadFlatpakBundleFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sideload_flatpak_bundle_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SideloadFlatpakBundleFile), 0, (GInstanceInitFunc) sideload_flatpak_bundle_file_instance_init, NULL };
	GType sideload_flatpak_bundle_file_type_id;
	sideload_flatpak_bundle_file_type_id = g_type_register_static (SIDELOAD_TYPE_FLATPAK_FILE, "SideloadFlatpakBundleFile", &g_define_type_info, 0);
	SideloadFlatpakBundleFile_private_offset = g_type_add_instance_private (sideload_flatpak_bundle_file_type_id, sizeof (SideloadFlatpakBundleFilePrivate));
	return sideload_flatpak_bundle_file_type_id;
}

GType
sideload_flatpak_bundle_file_get_type (void)
{
	static volatile gsize sideload_flatpak_bundle_file_type_id__once = 0;
	if (g_once_init_enter (&sideload_flatpak_bundle_file_type_id__once)) {
		GType sideload_flatpak_bundle_file_type_id;
		sideload_flatpak_bundle_file_type_id = sideload_flatpak_bundle_file_get_type_once ();
		g_once_init_leave (&sideload_flatpak_bundle_file_type_id__once, sideload_flatpak_bundle_file_type_id);
	}
	return sideload_flatpak_bundle_file_type_id__once;
}

static void
_vala_sideload_flatpak_bundle_file_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SideloadFlatpakBundleFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile);
	switch (property_id) {
		case SIDELOAD_FLATPAK_BUNDLE_FILE_HAS_REMOTE_PROPERTY:
		g_value_set_boolean (value, sideload_flatpak_bundle_file_get_has_remote (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sideload_flatpak_bundle_file_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SideloadFlatpakBundleFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_FLATPAK_BUNDLE_FILE, SideloadFlatpakBundleFile);
	switch (property_id) {
		case SIDELOAD_FLATPAK_BUNDLE_FILE_HAS_REMOTE_PROPERTY:
		sideload_flatpak_bundle_file_set_has_remote (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

