/* DockController.c generated by valac 0.56.17, the Vala compiler
 * generated from DockController.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "plank-internal.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_CONTROLLER_0_PROPERTY,
	PLANK_DOCK_CONTROLLER_NAME_PROPERTY,
	PLANK_DOCK_CONTROLLER_CONFIG_FOLDER_PROPERTY,
	PLANK_DOCK_CONTROLLER_LAUNCHERS_FOLDER_PROPERTY,
	PLANK_DOCK_CONTROLLER_PREFS_PROPERTY,
	PLANK_DOCK_CONTROLLER_DRAG_MANAGER_PROPERTY,
	PLANK_DOCK_CONTROLLER_HIDE_MANAGER_PROPERTY,
	PLANK_DOCK_CONTROLLER_POSITION_MANAGER_PROPERTY,
	PLANK_DOCK_CONTROLLER_RENDERER_PROPERTY,
	PLANK_DOCK_CONTROLLER_WINDOW_PROPERTY,
	PLANK_DOCK_CONTROLLER_HOVER_PROPERTY,
	PLANK_DOCK_CONTROLLER_DEFAULT_PROVIDER_PROPERTY,
	PLANK_DOCK_CONTROLLER_ITEMS_PROPERTY,
	PLANK_DOCK_CONTROLLER_VISIBLE_ITEMS_PROPERTY,
	PLANK_DOCK_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PlankDockControllerPrivate {
	gchar* _name;
	GFile* _config_folder;
	GFile* _launchers_folder;
	PlankDockPreferences* _prefs;
	PlankDragManager* _drag_manager;
	PlankHideManager* _hide_manager;
	PlankPositionManager* _position_manager;
	PlankDockRenderer* _renderer;
	PlankDockWindow* _window;
	PlankHoverWindow* _hover;
	PlankDockItemProvider* _default_provider;
	PlankDBusManager* dbus_manager;
	GeeArrayList* visible_items;
	GeeArrayList* items;
	PlankDockItem* dock_itself_item;
	guint serialize_item_positions_timer_id;
};

static gint PlankDockController_private_offset;
static gpointer plank_dock_controller_parent_class = NULL;

static void _plank_dock_container_update_visible_elements_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void plank_dock_controller_update_show_dock_item (PlankDockController* self);
static void _plank_dock_controller_update_show_dock_item_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void plank_dock_controller_handle_positions_changed (PlankDockController* self,
                                                     PlankDockContainer* container,
                                                     GeeList* moved_items);
static void _plank_dock_controller_handle_positions_changed_plank_dock_container_positions_changed (PlankDockContainer* _sender,
                                                                                             GeeList* elements,
                                                                                             gpointer self);
static void plank_dock_controller_handle_states_changed (PlankDockController* self,
                                                  PlankDockContainer* container);
static void _plank_dock_controller_handle_states_changed_plank_dock_container_states_changed (PlankDockContainer* _sender,
                                                                                       gpointer self);
static void plank_dock_controller_handle_elements_changed (PlankDockController* self,
                                                    PlankDockContainer* container,
                                                    GeeList* added,
                                                    GeeList* removed);
static void _plank_dock_controller_handle_elements_changed_plank_dock_container_elements_changed (PlankDockContainer* _sender,
                                                                                           GeeList* added,
                                                                                           GeeList* removed,
                                                                                           gpointer self);
static gboolean plank_dock_controller_serialize_item_positions (PlankDockController* self);
static void plank_dock_controller_update_items (PlankDockController* self);
static PlankDockItemProvider* plank_dock_controller_create_default_provider (PlankDockController* self);
static void plank_dock_controller_set_default_provider (PlankDockController* self,
                                                 PlankDockItemProvider* value);
static void plank_dock_controller_schedule_serialize_item_positions (PlankDockController* self);
static void plank_dock_controller_real_connect_element (PlankDockContainer* base,
                                                 PlankDockElement* element);
static void _plank_dock_window_update_icon_region_plank_application_dock_item_provider_item_window_added (PlankApplicationDockItemProvider* _sender,
                                                                                                   PlankApplicationDockItem* item,
                                                                                                   gpointer self);
static void plank_dock_controller_real_disconnect_element (PlankDockContainer* base,
                                                    PlankDockElement* element);
static void plank_dock_controller_real_update_visible_elements (PlankDockContainer* base);
static void plank_dock_controller_update_visible_items_recursive (PlankDockController* self,
                                                           PlankDockContainer* container,
                                                           gint* current_position);
static inline void plank_dock_controller_update_visible_items_add_from_iterator (PlankDockController* self,
                                                                   GeeIterator* iterator,
                                                                   gint* current_position);
static void plank_dock_controller_set_launchers_folder (PlankDockController* self,
                                                 GFile* value);
static GObject * plank_dock_controller_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void plank_dock_controller_finalize (GObject * obj);
static GType plank_dock_controller_get_type_once (void);
static void _vala_plank_dock_controller_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_plank_dock_controller_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
plank_dock_controller_get_instance_private (PlankDockController* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockController_private_offset);
}

static void
_plank_dock_container_update_visible_elements_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
}

static void
_plank_dock_controller_update_show_dock_item_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	plank_dock_controller_update_show_dock_item ((PlankDockController*) self);
}

static void
_plank_dock_controller_handle_positions_changed_plank_dock_container_positions_changed (PlankDockContainer* _sender,
                                                                                        GeeList* elements,
                                                                                        gpointer self)
{
	plank_dock_controller_handle_positions_changed ((PlankDockController*) self, _sender, elements);
}

static void
_plank_dock_controller_handle_states_changed_plank_dock_container_states_changed (PlankDockContainer* _sender,
                                                                                  gpointer self)
{
	plank_dock_controller_handle_states_changed ((PlankDockController*) self, _sender);
}

static void
_plank_dock_controller_handle_elements_changed_plank_dock_container_elements_changed (PlankDockContainer* _sender,
                                                                                      GeeList* added,
                                                                                      GeeList* removed,
                                                                                      gpointer self)
{
	plank_dock_controller_handle_elements_changed ((PlankDockController*) self, _sender, added, removed);
}

/**
 * Create a new DockController which manages a single dock
 *
 * @param config_folder the base-folder to load settings from and save them to
 */
PlankDockController*
plank_dock_controller_construct (GType object_type,
                                 const gchar* dock_name,
                                 GFile* config_folder)
{
	PlankDockController * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockPreferences* _tmp3_;
	g_return_val_if_fail (dock_name != NULL, NULL);
	g_return_val_if_fail (config_folder != NULL, NULL);
	plank_paths_ensure_directory_exists (config_folder);
	_tmp0_ = g_file_get_path (config_folder);
	_tmp1_ = _tmp0_;
	g_debug ("DockController.vala:80: Create dock '%s' (config_folder = %s)", dock_name, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = plank_dock_preferences_new (dock_name);
	_tmp3_ = _tmp2_;
	self = (PlankDockController*) g_object_new (object_type, "name", dock_name, "config-folder", config_folder, "prefs", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	return self;
}

PlankDockController*
plank_dock_controller_new (const gchar* dock_name,
                           GFile* config_folder)
{
	return plank_dock_controller_construct (PLANK_TYPE_DOCK_CONTROLLER, dock_name, config_folder);
}

/**
 * Initialize this controller.
 * Call this when added at least one DockItemProvider otherwise the
 * {@link Plank.DefaultApplicationDockItemProvider} will be added by default.
 */
void
plank_dock_controller_initialize (PlankDockController* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PlankPositionManager* _tmp3_;
	PlankDragManager* _tmp4_;
	PlankHideManager* _tmp5_;
	PlankDockRenderer* _tmp6_;
	PlankDockWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((PlankDockContainer*) self)->internal_elements;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 0) {
		plank_dock_controller_add_default_provider (self);
	}
	plank_dock_controller_update_show_dock_item (self);
	plank_dock_controller_update_items (self);
	plank_dock_element_set_AddTime ((PlankDockElement*) self, g_get_monotonic_time ());
	g_signal_connect_object ((PlankDockContainer*) self, "positions-changed", (GCallback) _plank_dock_controller_handle_positions_changed_plank_dock_container_positions_changed, self, 0);
	g_signal_connect_object ((PlankDockContainer*) self, "states-changed", (GCallback) _plank_dock_controller_handle_states_changed_plank_dock_container_states_changed, self, 0);
	g_signal_connect_object ((PlankDockContainer*) self, "elements-changed", (GCallback) _plank_dock_controller_handle_elements_changed_plank_dock_container_elements_changed, self, 0);
	_tmp3_ = self->priv->_position_manager;
	plank_position_manager_initialize (_tmp3_);
	_tmp4_ = self->priv->_drag_manager;
	plank_drag_manager_initialize (_tmp4_);
	_tmp5_ = self->priv->_hide_manager;
	plank_hide_manager_initialize (_tmp5_);
	_tmp6_ = self->priv->_renderer;
	plank_dock_renderer_initialize (_tmp6_);
	_tmp7_ = self->priv->_window;
	gtk_widget_show_all ((GtkWidget*) _tmp7_);
}

/**
 * Add the default provider which is an instance of
 * {@link Plank.DefaultApplicationDockItemProvider}
 */
void
plank_dock_controller_add_default_provider (PlankDockController* self)
{
	PlankDockItemProvider* _tmp0_;
	PlankDockItemProvider* _tmp1_;
	PlankDockItemProvider* _tmp2_;
	GeeArrayList* elements = NULL;
	PlankItemFactory* _tmp3_;
	GFile* _tmp4_;
	PlankDockPreferences* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeArrayList* _tmp9_;
	gboolean has_default_provider = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_default_provider;
	if (_tmp0_ != NULL) {
		return;
	}
	plank_logger_verbose ("DockController.add_default_provider ()", NULL);
	_tmp1_ = plank_dock_controller_create_default_provider (self);
	_tmp2_ = _tmp1_;
	plank_dock_controller_set_default_provider (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = plank_factory_item_factory;
	_tmp4_ = self->priv->_launchers_folder;
	_tmp5_ = self->priv->_prefs;
	_tmp6_ = plank_dock_preferences_get_DockItems (_tmp5_, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	_tmp9_ = plank_item_factory_load_elements (_tmp3_, _tmp4_, _tmp8_, (gint) _tmp8__length1);
	elements = _tmp9_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp10_;
		gint _element_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _element_index = 0;
		_tmp10_ = elements;
		_element_list = _tmp10_;
		_tmp11_ = _element_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_element_size = _tmp13_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			PlankDockElement* _tmp18_;
			_element_index = _element_index + 1;
			_tmp14_ = _element_index;
			_tmp15_ = _element_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _element_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _element_index);
			element = (PlankDockElement*) _tmp17_;
			_tmp18_ = element;
			if (PLANK_IS_DOCK_ITEM (_tmp18_)) {
				PlankDockItemProvider* _tmp19_;
				PlankDockElement* _tmp20_;
				_tmp19_ = self->priv->_default_provider;
				_tmp20_ = element;
				plank_dock_container_add ((PlankDockContainer*) _tmp19_, _tmp20_, NULL);
			}
			_g_object_unref0 (element);
		}
	}
	has_default_provider = FALSE;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp21_;
		gint _element_size = 0;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _element_index = 0;
		_tmp21_ = elements;
		_element_list = _tmp21_;
		_tmp22_ = _element_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_element_size = _tmp24_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp27_;
			gpointer _tmp28_;
			gboolean _tmp29_ = FALSE;
			_element_index = _element_index + 1;
			_tmp25_ = _element_index;
			_tmp26_ = _element_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _element_list;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _element_index);
			element = (PlankDockElement*) _tmp28_;
			if (!has_default_provider) {
				PlankDockElement* _tmp30_;
				_tmp30_ = element;
				_tmp29_ = PLANK_IS_DOCK_ITEM (_tmp30_);
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				PlankDockItemProvider* _tmp31_;
				_tmp31_ = self->priv->_default_provider;
				plank_dock_container_add ((PlankDockContainer*) self, (PlankDockElement*) _tmp31_, NULL);
				has_default_provider = TRUE;
			} else {
				PlankDockElement* _tmp32_;
				_tmp32_ = element;
				if (PLANK_IS_DOCK_ITEM_PROVIDER (_tmp32_)) {
					PlankDockElement* _tmp33_;
					_tmp33_ = element;
					plank_dock_container_add ((PlankDockContainer*) self, _tmp33_, NULL);
				}
			}
			_g_object_unref0 (element);
		}
	}
	if (!has_default_provider) {
		PlankDockItemProvider* _tmp34_;
		_tmp34_ = self->priv->_default_provider;
		plank_dock_container_add ((PlankDockContainer*) self, (PlankDockElement*) _tmp34_, NULL);
	}
	plank_dock_controller_schedule_serialize_item_positions (self);
	_g_object_unref0 (elements);
}

static PlankDockItemProvider*
plank_dock_controller_create_default_provider (PlankDockController* self)
{
	PlankDockItemProvider* provider = NULL;
	GFile* _tmp0_;
	PlankDockPreferences* _tmp2_;
	GFile* _tmp3_;
	PlankDefaultApplicationDockItemProvider* _tmp4_;
	PlankDockItemProvider* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_launchers_folder;
	if (plank_paths_ensure_directory_exists (_tmp0_)) {
		PlankItemFactory* _tmp1_;
		g_debug ("DockController.vala:190: Adding default dock items...");
		_tmp1_ = plank_factory_item_factory;
		plank_item_factory_make_default_items (_tmp1_);
		g_debug ("DockController.vala:192: done.");
	}
	_tmp2_ = self->priv->_prefs;
	_tmp3_ = self->priv->_launchers_folder;
	_tmp4_ = plank_default_application_dock_item_provider_new (_tmp2_, _tmp3_);
	_g_object_unref0 (provider);
	provider = (PlankDockItemProvider*) _tmp4_;
	result = provider;
	return result;
}

static void
plank_dock_controller_update_show_dock_item (PlankDockController* self)
{
	PlankDockPreferences* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_prefs;
	_tmp1_ = plank_dock_preferences_get_ShowDockItem (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PlankDockItem* _tmp3_;
		GeeArrayList* _tmp6_;
		PlankDockItem* _tmp7_;
		_tmp3_ = self->priv->dock_itself_item;
		if (_tmp3_ == NULL) {
			PlankItemFactory* _tmp4_;
			PlankDockItem* _tmp5_;
			_tmp4_ = plank_factory_item_factory;
			_tmp5_ = plank_item_factory_get_item_for_dock (_tmp4_);
			_g_object_unref0 (self->priv->dock_itself_item);
			self->priv->dock_itself_item = _tmp5_;
		}
		_tmp6_ = ((PlankDockContainer*) self)->internal_elements;
		_tmp7_ = self->priv->dock_itself_item;
		if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp6_, (PlankDockElement*) _tmp7_)) {
			PlankDockItem* _tmp8_;
			_tmp8_ = self->priv->dock_itself_item;
			plank_dock_container_prepend ((PlankDockContainer*) self, (PlankDockElement*) _tmp8_);
		}
	} else {
		PlankDockItem* _tmp9_;
		_tmp9_ = self->priv->dock_itself_item;
		if (_tmp9_ != NULL) {
			GeeArrayList* _tmp10_;
			PlankDockItem* _tmp11_;
			_tmp10_ = ((PlankDockContainer*) self)->internal_elements;
			_tmp11_ = self->priv->dock_itself_item;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp10_, (PlankDockElement*) _tmp11_)) {
				PlankDockItem* _tmp12_;
				_tmp12_ = self->priv->dock_itself_item;
				plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) _tmp12_);
			}
			_g_object_unref0 (self->priv->dock_itself_item);
			self->priv->dock_itself_item = NULL;
		}
	}
}

static void
_plank_dock_window_update_icon_region_plank_application_dock_item_provider_item_window_added (PlankApplicationDockItemProvider* _sender,
                                                                                              PlankApplicationDockItem* item,
                                                                                              gpointer self)
{
	plank_dock_window_update_icon_region ((PlankDockWindow*) self, item);
}

static void
plank_dock_controller_real_connect_element (PlankDockContainer* base,
                                            PlankDockElement* element)
{
	PlankDockController * self;
	PlankDockItemProvider* provider = NULL;
	PlankDockItemProvider* _tmp0_;
	PlankDockItemProvider* _tmp1_;
	PlankDockItemProvider* _tmp2_;
	PlankDockItemProvider* _tmp3_;
	PlankApplicationDockItemProvider* app_provider = NULL;
	PlankDockItemProvider* _tmp4_;
	PlankApplicationDockItemProvider* _tmp5_;
	self = (PlankDockController*) base;
	g_return_if_fail (element != NULL);
	provider = PLANK_IS_DOCK_ITEM_PROVIDER (element) ? ((PlankDockItemProvider*) element) : NULL;
	_tmp0_ = provider;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = provider;
	g_signal_connect_object ((PlankDockContainer*) _tmp1_, "positions-changed", (GCallback) _plank_dock_controller_handle_positions_changed_plank_dock_container_positions_changed, self, 0);
	_tmp2_ = provider;
	g_signal_connect_object ((PlankDockContainer*) _tmp2_, "states-changed", (GCallback) _plank_dock_controller_handle_states_changed_plank_dock_container_states_changed, self, 0);
	_tmp3_ = provider;
	g_signal_connect_object ((PlankDockContainer*) _tmp3_, "elements-changed", (GCallback) _plank_dock_controller_handle_elements_changed_plank_dock_container_elements_changed, self, 0);
	_tmp4_ = provider;
	app_provider = PLANK_IS_APPLICATION_DOCK_ITEM_PROVIDER (_tmp4_) ? ((PlankApplicationDockItemProvider*) _tmp4_) : NULL;
	_tmp5_ = app_provider;
	if (_tmp5_ != NULL) {
		PlankApplicationDockItemProvider* _tmp6_;
		PlankDockWindow* _tmp7_;
		PlankUnity* _tmp8_;
		PlankApplicationDockItemProvider* _tmp9_;
		_tmp6_ = app_provider;
		_tmp7_ = self->priv->_window;
		g_signal_connect_object (_tmp6_, "item-window-added", (GCallback) _plank_dock_window_update_icon_region_plank_application_dock_item_provider_item_window_added, _tmp7_, 0);
		_tmp8_ = plank_unity_get_default ();
		_tmp9_ = app_provider;
		plank_unity_add_client (_tmp8_, (PlankUnityClient*) _tmp9_);
	}
}

static void
plank_dock_controller_real_disconnect_element (PlankDockContainer* base,
                                               PlankDockElement* element)
{
	PlankDockController * self;
	PlankDockItemProvider* provider = NULL;
	PlankDockItemProvider* _tmp0_;
	PlankDockItemProvider* _tmp1_;
	guint _tmp2_;
	PlankDockItemProvider* _tmp3_;
	guint _tmp4_;
	PlankDockItemProvider* _tmp5_;
	guint _tmp6_;
	PlankApplicationDockItemProvider* app_provider = NULL;
	PlankDockItemProvider* _tmp7_;
	PlankApplicationDockItemProvider* _tmp8_;
	self = (PlankDockController*) base;
	g_return_if_fail (element != NULL);
	provider = PLANK_IS_DOCK_ITEM_PROVIDER (element) ? ((PlankDockItemProvider*) element) : NULL;
	_tmp0_ = provider;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = provider;
	g_signal_parse_name ("positions-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_dock_controller_handle_positions_changed_plank_dock_container_positions_changed, self);
	_tmp3_ = provider;
	g_signal_parse_name ("states-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _plank_dock_controller_handle_states_changed_plank_dock_container_states_changed, self);
	_tmp5_ = provider;
	g_signal_parse_name ("elements-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_dock_controller_handle_elements_changed_plank_dock_container_elements_changed, self);
	_tmp7_ = provider;
	app_provider = PLANK_IS_APPLICATION_DOCK_ITEM_PROVIDER (_tmp7_) ? ((PlankApplicationDockItemProvider*) _tmp7_) : NULL;
	_tmp8_ = app_provider;
	if (_tmp8_ != NULL) {
		PlankApplicationDockItemProvider* _tmp9_;
		PlankDockWindow* _tmp10_;
		guint _tmp11_;
		PlankUnity* _tmp12_;
		PlankApplicationDockItemProvider* _tmp13_;
		_tmp9_ = app_provider;
		_tmp10_ = self->priv->_window;
		g_signal_parse_name ("item-window-added", PLANK_TYPE_APPLICATION_DOCK_ITEM_PROVIDER, &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _plank_dock_window_update_icon_region_plank_application_dock_item_provider_item_window_added, _tmp10_);
		_tmp12_ = plank_unity_get_default ();
		_tmp13_ = app_provider;
		plank_unity_remove_client (_tmp12_, (PlankUnityClient*) _tmp13_);
	}
}

static void
plank_dock_controller_real_update_visible_elements (PlankDockContainer* base)
{
	PlankDockController * self;
	GeeArrayList* _tmp0_;
	gint current_position = 0;
	self = (PlankDockController*) base;
	PLANK_DOCK_CONTAINER_CLASS (plank_dock_controller_parent_class)->update_visible_elements (G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_DOCK_CONTAINER, PlankDockContainer));
	plank_logger_verbose ("DockController.update_visible_items ()", NULL);
	_tmp0_ = self->priv->visible_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	current_position = 0;
	plank_dock_controller_update_visible_items_recursive (self, (PlankDockContainer*) self, &current_position);
}

static void
plank_dock_controller_update_visible_items_recursive (PlankDockController* self,
                                                      PlankDockContainer* container,
                                                      gint* current_position)
{
	GeeBidirListIterator* iterator = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeBidirListIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = plank_dock_container_get_VisibleElements (container);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_bidir_list_bidir_list_iterator ((GeeAbstractBidirList*) _tmp1_);
	iterator = _tmp2_;
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		PlankDockPreferences* _tmp4_;
		_tmp4_ = self->priv->_prefs;
		_tmp3_ = plank_dock_preferences_is_horizontal_dock (_tmp4_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GeeBidirListIterator* _tmp5_;
		_tmp5_ = iterator;
		gee_bidir_iterator_last ((GeeBidirIterator*) _tmp5_);
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GeeBidirListIterator* _tmp8_;
				if (!_tmp6_) {
					GeeBidirListIterator* _tmp7_;
					_tmp7_ = iterator;
					if (!gee_bidir_iterator_previous ((GeeBidirIterator*) _tmp7_)) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp8_ = iterator;
				plank_dock_controller_update_visible_items_add_from_iterator (self, (GeeIterator*) _tmp8_, current_position);
			}
		}
	} else {
		GeeBidirListIterator* _tmp9_;
		_tmp9_ = iterator;
		gee_bidir_iterator_first ((GeeBidirIterator*) _tmp9_);
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				GeeBidirListIterator* _tmp12_;
				if (!_tmp10_) {
					GeeBidirListIterator* _tmp11_;
					_tmp11_ = iterator;
					if (!gee_iterator_next ((GeeIterator*) _tmp11_)) {
						break;
					}
				}
				_tmp10_ = FALSE;
				_tmp12_ = iterator;
				plank_dock_controller_update_visible_items_add_from_iterator (self, (GeeIterator*) _tmp12_, current_position);
			}
		}
	}
	_g_object_unref0 (iterator);
}

static inline void
plank_dock_controller_update_visible_items_add_from_iterator (PlankDockController* self,
                                                              GeeIterator* iterator,
                                                              gint* current_position)
{
	PlankDockElement* element = NULL;
	gpointer _tmp0_;
	PlankDockItem* item = NULL;
	PlankDockContainer* container = NULL;
	PlankDockElement* _tmp1_;
	PlankDockContainer* _tmp2_;
	PlankDockElement* _tmp4_;
	PlankDockItem* _tmp5_;
	PlankDockItem* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp10_;
	GeeArrayList* _tmp11_;
	PlankDockItem* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iterator != NULL);
	_tmp0_ = gee_iterator_get (iterator);
	element = (PlankDockElement*) _tmp0_;
	item = NULL;
	container = NULL;
	_tmp1_ = element;
	container = PLANK_IS_DOCK_CONTAINER (_tmp1_) ? ((PlankDockContainer*) _tmp1_) : NULL;
	_tmp2_ = container;
	if (_tmp2_ != NULL) {
		PlankDockContainer* _tmp3_;
		_tmp3_ = container;
		plank_dock_controller_update_visible_items_recursive (self, _tmp3_, current_position);
		_g_object_unref0 (element);
		return;
	}
	_tmp4_ = element;
	item = PLANK_IS_DOCK_ITEM (_tmp4_) ? ((PlankDockItem*) _tmp4_) : NULL;
	_tmp5_ = item;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (element);
		return;
	}
	_tmp6_ = item;
	_tmp7_ = plank_dock_item_get_Position (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != (*current_position)) {
		PlankDockItem* _tmp9_;
		_tmp9_ = item;
		plank_dock_item_set_Position (_tmp9_, *current_position);
	}
	_tmp10_ = *current_position;
	*current_position = _tmp10_ + 1;
	_tmp11_ = self->priv->visible_items;
	_tmp12_ = item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
	_g_object_unref0 (element);
}

static void
plank_dock_controller_update_items (PlankDockController* self)
{
	GeeArrayList* _tmp0_;
	PlankDockItem* item = NULL;
	PlankDockContainer* container = NULL;
	g_return_if_fail (self != NULL);
	plank_logger_verbose ("DockController.update_items ()", NULL);
	_tmp0_ = self->priv->items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	item = NULL;
	container = NULL;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			PlankDockElement* _tmp9_;
			PlankDockItem* _tmp10_;
			PlankDockElement* _tmp13_;
			PlankDockContainer* _tmp14_;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (PlankDockElement*) _tmp8_;
			_tmp9_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp9_) ? ((PlankDockItem*) _tmp9_) : NULL;
			_tmp10_ = item;
			if (_tmp10_ != NULL) {
				GeeArrayList* _tmp11_;
				PlankDockItem* _tmp12_;
				_tmp11_ = self->priv->items;
				_tmp12_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				_g_object_unref0 (element);
				continue;
			}
			_tmp13_ = element;
			container = PLANK_IS_DOCK_CONTAINER (_tmp13_) ? ((PlankDockContainer*) _tmp13_) : NULL;
			_tmp14_ = container;
			if (_tmp14_ == NULL) {
				_g_object_unref0 (element);
				continue;
			}
			{
				GeeArrayList* _element2_list = NULL;
				PlankDockContainer* _tmp15_;
				GeeArrayList* _tmp16_;
				GeeArrayList* _tmp17_;
				gint _element2_size = 0;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _element2_index = 0;
				_tmp15_ = container;
				_tmp16_ = plank_dock_container_get_Elements (_tmp15_);
				_tmp17_ = _tmp16_;
				_element2_list = _tmp17_;
				_tmp18_ = _element2_list;
				_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_element2_size = _tmp20_;
				_element2_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					PlankDockElement* element2 = NULL;
					GeeArrayList* _tmp23_;
					gpointer _tmp24_;
					PlankDockElement* _tmp25_;
					PlankDockItem* _tmp26_;
					GeeArrayList* _tmp27_;
					PlankDockItem* _tmp28_;
					_element2_index = _element2_index + 1;
					_tmp21_ = _element2_index;
					_tmp22_ = _element2_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					_tmp23_ = _element2_list;
					_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _element2_index);
					element2 = (PlankDockElement*) _tmp24_;
					_tmp25_ = element2;
					item = PLANK_IS_DOCK_ITEM (_tmp25_) ? ((PlankDockItem*) _tmp25_) : NULL;
					_tmp26_ = item;
					if (_tmp26_ == NULL) {
						_g_object_unref0 (element2);
						continue;
					}
					_tmp27_ = self->priv->items;
					_tmp28_ = item;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
					_g_object_unref0 (element2);
				}
			}
			_g_object_unref0 (element);
		}
	}
}

static void
plank_dock_controller_handle_elements_changed (PlankDockController* self,
                                               PlankDockContainer* container,
                                               GeeList* added,
                                               GeeList* removed)
{
	PlankDockRenderer* _tmp0_;
	PlankDockRenderer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	PlankDockWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = self->priv->_renderer;
	plank_dock_renderer_animate_items (_tmp0_, added);
	_tmp1_ = self->priv->_renderer;
	plank_dock_renderer_animate_items (_tmp1_, removed);
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
	plank_dock_controller_update_items (self);
	_tmp2_ = gee_collection_get_size ((GeeCollection*) added);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) removed);
	_tmp5_ = _tmp4_;
	if (_tmp3_ != _tmp5_) {
		PlankPositionManager* _tmp6_;
		PlankDockRenderer* _tmp7_;
		PlankDockTheme* _tmp8_;
		PlankDockTheme* _tmp9_;
		_tmp6_ = self->priv->_position_manager;
		_tmp7_ = self->priv->_renderer;
		_tmp8_ = plank_dock_renderer_get_theme (_tmp7_);
		_tmp9_ = _tmp8_;
		plank_position_manager_update (_tmp6_, _tmp9_);
	}
	_tmp10_ = self->priv->_window;
	plank_dock_window_update_icon_regions (_tmp10_);
	plank_dock_controller_schedule_serialize_item_positions (self);
	if (container != G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_DOCK_CONTAINER, PlankDockContainer)) {
		GeeArrayList* empty = NULL;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		_tmp11_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		empty = _tmp11_;
		_tmp12_ = empty;
		_tmp13_ = empty;
		g_signal_emit_by_name ((PlankDockContainer*) self, "elements-changed", (GeeList*) _tmp12_, (GeeList*) _tmp13_);
		_g_object_unref0 (empty);
	}
}

static void
plank_dock_controller_handle_positions_changed (PlankDockController* self,
                                                PlankDockContainer* container,
                                                GeeList* moved_items)
{
	PlankDockRenderer* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (moved_items != NULL);
	plank_dock_container_update_visible_elements ((PlankDockContainer*) self);
	{
		GeeList* _item_list = NULL;
		gint _item_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _item_index = 0;
		_item_list = moved_items;
		_tmp0_ = _item_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_item_size = _tmp2_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			PlankDockElement* item = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			PlankApplicationDockItem* app_item = NULL;
			PlankDockElement* _tmp7_;
			PlankApplicationDockItem* _tmp8_;
			_item_index = _item_index + 1;
			_tmp3_ = _item_index;
			_tmp4_ = _item_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _item_list;
			_tmp6_ = gee_list_get (_tmp5_, _item_index);
			item = (PlankDockElement*) _tmp6_;
			_tmp7_ = item;
			app_item = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp7_) ? ((PlankApplicationDockItem*) _tmp7_) : NULL;
			_tmp8_ = app_item;
			if (_tmp8_ != NULL) {
				PlankDockWindow* _tmp9_;
				PlankApplicationDockItem* _tmp10_;
				_tmp9_ = self->priv->_window;
				_tmp10_ = app_item;
				plank_dock_window_update_icon_region (_tmp9_, _tmp10_);
			}
		}
	}
	_tmp11_ = self->priv->_renderer;
	plank_renderer_animated_draw ((PlankRenderer*) _tmp11_);
	plank_dock_controller_schedule_serialize_item_positions (self);
}

static void
plank_dock_controller_handle_states_changed (PlankDockController* self,
                                             PlankDockContainer* container)
{
	PlankDockRenderer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = self->priv->_renderer;
	plank_renderer_animated_draw ((PlankRenderer*) _tmp0_);
}

static void
plank_dock_controller_schedule_serialize_item_positions (PlankDockController* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->serialize_item_positions_timer_id > 0U) {
		return;
	}
	self->priv->serialize_item_positions_timer_id = gdk_threads_add_timeout (PLANK_ITEM_SERIALIZATION_DELAY, (GSourceFunc) plank_dock_controller_serialize_item_positions, self);
}

static gboolean
plank_dock_controller_serialize_item_positions (PlankDockController* self)
{
	GeeArrayList* item_list = NULL;
	GeeArrayList* _tmp0_;
	PlankDockPreferences* _tmp24_;
	GeeArrayList* _tmp25_;
	gint _tmp26_ = 0;
	gpointer* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->serialize_item_positions_timer_id = 0U;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	item_list = _tmp0_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp9_;
			PlankDockItem* _tmp10_;
			PlankDockItemProvider* provider = NULL;
			PlankDockElement* _tmp16_;
			PlankDockItemProvider* _tmp17_;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (PlankDockElement*) _tmp8_;
			_tmp9_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp9_) ? ((PlankDockItem*) _tmp9_) : NULL;
			_tmp10_ = item;
			if (_tmp10_ != NULL) {
				GeeArrayList* _tmp11_;
				PlankDockItem* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = item_list;
				_tmp12_ = item;
				_tmp13_ = plank_dock_item_get_DockItemFilename (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp15_);
				_g_free0 (_tmp15_);
				_g_object_unref0 (element);
				continue;
			}
			_tmp16_ = element;
			provider = PLANK_IS_DOCK_ITEM_PROVIDER (_tmp16_) ? ((PlankDockItemProvider*) _tmp16_) : NULL;
			_tmp17_ = provider;
			if (_tmp17_ != NULL) {
				gchar** list = NULL;
				PlankDockItemProvider* _tmp18_;
				gint _tmp19_ = 0;
				gchar** _tmp20_;
				gint list_length1;
				gint _list_size_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp18_ = provider;
				_tmp20_ = plank_dock_item_provider_get_dockitem_filenames (_tmp18_, &_tmp19_);
				list = _tmp20_;
				list_length1 = _tmp19_;
				_list_size_ = list_length1;
				_tmp21_ = list;
				_tmp21__length1 = list_length1;
				{
					gchar** s_collection = NULL;
					gint s_collection_length1 = 0;
					gint _s_collection_size_ = 0;
					gint s_it = 0;
					s_collection = _tmp21_;
					s_collection_length1 = _tmp21__length1;
					for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
						const gchar* s = NULL;
						s = s_collection[s_it];
						{
							GeeArrayList* _tmp22_;
							const gchar* _tmp23_;
							_tmp22_ = item_list;
							_tmp23_ = s;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
						}
					}
				}
				list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (element);
				continue;
			}
			_g_object_unref0 (element);
		}
	}
	_tmp24_ = self->priv->_prefs;
	_tmp25_ = item_list;
	_tmp27_ = gee_collection_to_array ((GeeCollection*) _tmp25_, &_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp28__length1 = _tmp26_;
	plank_dock_preferences_set_DockItems (_tmp24_, _tmp28_, _tmp26_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	result = FALSE;
	_g_object_unref0 (item_list);
	return result;
}

const gchar*
plank_dock_controller_get_name (PlankDockController* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
plank_dock_controller_set_name (PlankDockController* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_NAME_PROPERTY]);
	}
}

GFile*
plank_dock_controller_get_config_folder (PlankDockController* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config_folder;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_dock_controller_set_config_folder (PlankDockController* self,
                                         GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_config_folder (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_config_folder);
		self->priv->_config_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_CONFIG_FOLDER_PROPERTY]);
	}
}

GFile*
plank_dock_controller_get_launchers_folder (PlankDockController* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_launchers_folder;
	result = _tmp0_;
	return result;
}

static void
plank_dock_controller_set_launchers_folder (PlankDockController* self,
                                            GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_launchers_folder (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_launchers_folder);
		self->priv->_launchers_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_LAUNCHERS_FOLDER_PROPERTY]);
	}
}

PlankDockPreferences*
plank_dock_controller_get_prefs (PlankDockController* self)
{
	PlankDockPreferences* result;
	PlankDockPreferences* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefs;
	result = _tmp0_;
	return result;
}

static void
plank_dock_controller_set_prefs (PlankDockController* self,
                                 PlankDockPreferences* value)
{
	PlankDockPreferences* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_prefs (self);
	if (old_value != value) {
		PlankDockPreferences* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_prefs);
		self->priv->_prefs = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_PREFS_PROPERTY]);
	}
}

PlankDragManager*
plank_dock_controller_get_drag_manager (PlankDockController* self)
{
	PlankDragManager* result;
	PlankDragManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drag_manager;
	result = _tmp0_;
	return result;
}

void
plank_dock_controller_set_drag_manager (PlankDockController* self,
                                        PlankDragManager* value)
{
	PlankDragManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_drag_manager (self);
	if (old_value != value) {
		PlankDragManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_drag_manager);
		self->priv->_drag_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_DRAG_MANAGER_PROPERTY]);
	}
}

PlankHideManager*
plank_dock_controller_get_hide_manager (PlankDockController* self)
{
	PlankHideManager* result;
	PlankHideManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide_manager;
	result = _tmp0_;
	return result;
}

void
plank_dock_controller_set_hide_manager (PlankDockController* self,
                                        PlankHideManager* value)
{
	PlankHideManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_hide_manager (self);
	if (old_value != value) {
		PlankHideManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_hide_manager);
		self->priv->_hide_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_HIDE_MANAGER_PROPERTY]);
	}
}

PlankPositionManager*
plank_dock_controller_get_position_manager (PlankDockController* self)
{
	PlankPositionManager* result;
	PlankPositionManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_position_manager;
	result = _tmp0_;
	return result;
}

void
plank_dock_controller_set_position_manager (PlankDockController* self,
                                            PlankPositionManager* value)
{
	PlankPositionManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_position_manager (self);
	if (old_value != value) {
		PlankPositionManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_position_manager);
		self->priv->_position_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_POSITION_MANAGER_PROPERTY]);
	}
}

PlankDockRenderer*
plank_dock_controller_get_renderer (PlankDockController* self)
{
	PlankDockRenderer* result;
	PlankDockRenderer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_renderer;
	result = _tmp0_;
	return result;
}

void
plank_dock_controller_set_renderer (PlankDockController* self,
                                    PlankDockRenderer* value)
{
	PlankDockRenderer* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_renderer (self);
	if (old_value != value) {
		PlankDockRenderer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_renderer);
		self->priv->_renderer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_RENDERER_PROPERTY]);
	}
}

PlankDockWindow*
plank_dock_controller_get_window (PlankDockController* self)
{
	PlankDockWindow* result;
	PlankDockWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

void
plank_dock_controller_set_window (PlankDockController* self,
                                  PlankDockWindow* value)
{
	PlankDockWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_window (self);
	if (old_value != value) {
		PlankDockWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_WINDOW_PROPERTY]);
	}
}

PlankHoverWindow*
plank_dock_controller_get_hover (PlankDockController* self)
{
	PlankHoverWindow* result;
	PlankHoverWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hover;
	result = _tmp0_;
	return result;
}

void
plank_dock_controller_set_hover (PlankDockController* self,
                                 PlankHoverWindow* value)
{
	PlankHoverWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_hover (self);
	if (old_value != value) {
		PlankHoverWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_hover);
		self->priv->_hover = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_HOVER_PROPERTY]);
	}
}

PlankDockItemProvider*
plank_dock_controller_get_default_provider (PlankDockController* self)
{
	PlankDockItemProvider* result;
	PlankDockItemProvider* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_provider;
	result = _tmp0_;
	return result;
}

static void
plank_dock_controller_set_default_provider (PlankDockController* self,
                                            PlankDockItemProvider* value)
{
	PlankDockItemProvider* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_controller_get_default_provider (self);
	if (old_value != value) {
		PlankDockItemProvider* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_provider);
		self->priv->_default_provider = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_DEFAULT_PROVIDER_PROPERTY]);
	}
}

GeeArrayList*
plank_dock_controller_get_Items (PlankDockController* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->items;
	result = _tmp0_;
	return result;
}

GeeArrayList*
plank_dock_controller_get_VisibleItems (PlankDockController* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->visible_items;
	result = _tmp0_;
	return result;
}

static GObject *
plank_dock_controller_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDockController * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	PlankItemFactory* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	PlankDockPreferences* _tmp8_;
	PlankDockPreferences* _tmp9_;
	PlankDBusManager* _tmp10_;
	PlankPositionManager* _tmp11_;
	PlankPositionManager* _tmp12_;
	PlankDragManager* _tmp13_;
	PlankDragManager* _tmp14_;
	PlankHideManager* _tmp15_;
	PlankHideManager* _tmp16_;
	PlankDockWindow* _tmp17_;
	PlankDockWindow* _tmp18_;
	PlankHoverWindow* _tmp19_;
	PlankHoverWindow* _tmp20_;
	PlankDockWindow* _tmp21_;
	PlankDockRenderer* _tmp22_;
	PlankDockRenderer* _tmp23_;
	parent_class = G_OBJECT_CLASS (plank_dock_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_CONTROLLER, PlankDockController);
	_tmp0_ = self->priv->_config_folder;
	_tmp1_ = g_file_get_child (_tmp0_, "launchers");
	_tmp2_ = _tmp1_;
	plank_dock_controller_set_launchers_folder (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = plank_factory_item_factory;
	_tmp4_ = self->priv->_launchers_folder;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp3_->launchers_dir);
	_tmp3_->launchers_dir = _tmp5_;
	_tmp6_ = gee_array_list_new (PLANK_TYPE_DOCK_ITEM, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp6_;
	_tmp7_ = gee_array_list_new (PLANK_TYPE_DOCK_ITEM, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->visible_items);
	self->priv->visible_items = _tmp7_;
	_tmp8_ = self->priv->_prefs;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::Position", (GCallback) _plank_dock_container_update_visible_elements_g_object_notify, (PlankDockContainer*) self, 0);
	_tmp9_ = self->priv->_prefs;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::ShowDockItem", (GCallback) _plank_dock_controller_update_show_dock_item_g_object_notify, self, 0);
	_tmp10_ = plank_dbus_manager_new (self);
	_g_object_unref0 (self->priv->dbus_manager);
	self->priv->dbus_manager = _tmp10_;
	_tmp11_ = plank_position_manager_new (self);
	_tmp12_ = _tmp11_;
	plank_dock_controller_set_position_manager (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = plank_drag_manager_new (self);
	_tmp14_ = _tmp13_;
	plank_dock_controller_set_drag_manager (self, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = plank_hide_manager_new (self);
	_tmp16_ = _tmp15_;
	plank_dock_controller_set_hide_manager (self, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = plank_dock_window_new (self);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	plank_dock_controller_set_window (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = plank_hover_window_new ();
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	plank_dock_controller_set_hover (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->_window;
	_tmp22_ = plank_dock_renderer_new (self, (GtkWindow*) _tmp21_);
	_tmp23_ = _tmp22_;
	plank_dock_controller_set_renderer (self, _tmp23_);
	_g_object_unref0 (_tmp23_);
	return obj;
}

static void
plank_dock_controller_class_init (PlankDockControllerClass * klass,
                                  gpointer klass_data)
{
	plank_dock_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockController_private_offset);
	((PlankDockContainerClass *) klass)->connect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_dock_controller_real_connect_element;
	((PlankDockContainerClass *) klass)->disconnect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_dock_controller_real_disconnect_element;
	((PlankDockContainerClass *) klass)->update_visible_elements = (void (*) (PlankDockContainer*)) plank_dock_controller_real_update_visible_elements;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dock_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_NAME_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_CONFIG_FOLDER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_CONFIG_FOLDER_PROPERTY] = g_param_spec_object ("config-folder", "config-folder", "config-folder", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_LAUNCHERS_FOLDER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_LAUNCHERS_FOLDER_PROPERTY] = g_param_spec_object ("launchers-folder", "launchers-folder", "launchers-folder", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_PREFS_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_PREFS_PROPERTY] = g_param_spec_object ("prefs", "prefs", "prefs", PLANK_TYPE_DOCK_PREFERENCES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_DRAG_MANAGER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_DRAG_MANAGER_PROPERTY] = g_param_spec_object ("drag-manager", "drag-manager", "drag-manager", PLANK_TYPE_DRAG_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_HIDE_MANAGER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_HIDE_MANAGER_PROPERTY] = g_param_spec_object ("hide-manager", "hide-manager", "hide-manager", PLANK_TYPE_HIDE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_POSITION_MANAGER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_POSITION_MANAGER_PROPERTY] = g_param_spec_object ("position-manager", "position-manager", "position-manager", PLANK_TYPE_POSITION_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_RENDERER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_RENDERER_PROPERTY] = g_param_spec_object ("renderer", "renderer", "renderer", PLANK_TYPE_DOCK_RENDERER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_WINDOW_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", PLANK_TYPE_DOCK_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_HOVER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_HOVER_PROPERTY] = g_param_spec_object ("hover", "hover", "hover", PLANK_TYPE_HOVER_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_DEFAULT_PROVIDER_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_DEFAULT_PROVIDER_PROPERTY] = g_param_spec_object ("default-provider", "default-provider", "default-provider", PLANK_TYPE_DOCK_ITEM_PROVIDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * List of all items on this dock
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_ITEMS_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_ITEMS_PROPERTY] = g_param_spec_object ("Items", "Items", "Items", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Ordered list of all visible items on this dock
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTROLLER_VISIBLE_ITEMS_PROPERTY, plank_dock_controller_properties[PLANK_DOCK_CONTROLLER_VISIBLE_ITEMS_PROPERTY] = g_param_spec_object ("VisibleItems", "VisibleItems", "VisibleItems", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plank_dock_controller_instance_init (PlankDockController * self,
                                     gpointer klass)
{
	self->priv = plank_dock_controller_get_instance_private (self);
	self->priv->serialize_item_positions_timer_id = 0U;
}

static void
plank_dock_controller_finalize (GObject * obj)
{
	PlankDockController * self;
	PlankDockPreferences* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	PlankDockPreferences* _tmp3_;
	guint _tmp4_;
	GQuark _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_CONTROLLER, PlankDockController);
	_tmp0_ = self->priv->_prefs;
	g_signal_parse_name ("notify::Position", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _plank_dock_container_update_visible_elements_g_object_notify, (PlankDockContainer*) self);
	_tmp3_ = self->priv->_prefs;
	g_signal_parse_name ("notify::ShowDockItem", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _plank_dock_controller_update_show_dock_item_g_object_notify, self);
	g_signal_parse_name ("positions-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_dock_controller_handle_positions_changed_plank_dock_container_positions_changed, self);
	g_signal_parse_name ("states-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _plank_dock_controller_handle_states_changed_plank_dock_container_states_changed, self);
	g_signal_parse_name ("elements-changed", PLANK_TYPE_DOCK_CONTAINER, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockContainer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _plank_dock_controller_handle_elements_changed_plank_dock_container_elements_changed, self);
	if (self->priv->serialize_item_positions_timer_id > 0U) {
		g_source_remove (self->priv->serialize_item_positions_timer_id);
	}
	plank_dock_controller_serialize_item_positions (self);
	_tmp9_ = self->priv->items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp9_);
	_tmp10_ = self->priv->visible_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_config_folder);
	_g_object_unref0 (self->priv->_launchers_folder);
	_g_object_unref0 (self->priv->_prefs);
	_g_object_unref0 (self->priv->_drag_manager);
	_g_object_unref0 (self->priv->_hide_manager);
	_g_object_unref0 (self->priv->_position_manager);
	_g_object_unref0 (self->priv->_renderer);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_hover);
	_g_object_unref0 (self->priv->_default_provider);
	_g_object_unref0 (self->priv->dbus_manager);
	_g_object_unref0 (self->priv->visible_items);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->dock_itself_item);
	G_OBJECT_CLASS (plank_dock_controller_parent_class)->finalize (obj);
}

/**
 * A controller class for managing a single dock.
 *
 * All needed controlling parts will be created and initialized.
 */
static GType
plank_dock_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockController), 0, (GInstanceInitFunc) plank_dock_controller_instance_init, NULL };
	GType plank_dock_controller_type_id;
	plank_dock_controller_type_id = g_type_register_static (PLANK_TYPE_DOCK_CONTAINER, "PlankDockController", &g_define_type_info, 0);
	PlankDockController_private_offset = g_type_add_instance_private (plank_dock_controller_type_id, sizeof (PlankDockControllerPrivate));
	return plank_dock_controller_type_id;
}

GType
plank_dock_controller_get_type (void)
{
	static volatile gsize plank_dock_controller_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_controller_type_id__once)) {
		GType plank_dock_controller_type_id;
		plank_dock_controller_type_id = plank_dock_controller_get_type_once ();
		g_once_init_leave (&plank_dock_controller_type_id__once, plank_dock_controller_type_id);
	}
	return plank_dock_controller_type_id__once;
}

static void
_vala_plank_dock_controller_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PlankDockController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_CONTROLLER, PlankDockController);
	switch (property_id) {
		case PLANK_DOCK_CONTROLLER_NAME_PROPERTY:
		g_value_set_string (value, plank_dock_controller_get_name (self));
		break;
		case PLANK_DOCK_CONTROLLER_CONFIG_FOLDER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_config_folder (self));
		break;
		case PLANK_DOCK_CONTROLLER_LAUNCHERS_FOLDER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_launchers_folder (self));
		break;
		case PLANK_DOCK_CONTROLLER_PREFS_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_prefs (self));
		break;
		case PLANK_DOCK_CONTROLLER_DRAG_MANAGER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_drag_manager (self));
		break;
		case PLANK_DOCK_CONTROLLER_HIDE_MANAGER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_hide_manager (self));
		break;
		case PLANK_DOCK_CONTROLLER_POSITION_MANAGER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_position_manager (self));
		break;
		case PLANK_DOCK_CONTROLLER_RENDERER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_renderer (self));
		break;
		case PLANK_DOCK_CONTROLLER_WINDOW_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_window (self));
		break;
		case PLANK_DOCK_CONTROLLER_HOVER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_hover (self));
		break;
		case PLANK_DOCK_CONTROLLER_DEFAULT_PROVIDER_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_default_provider (self));
		break;
		case PLANK_DOCK_CONTROLLER_ITEMS_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_Items (self));
		break;
		case PLANK_DOCK_CONTROLLER_VISIBLE_ITEMS_PROPERTY:
		g_value_set_object (value, plank_dock_controller_get_VisibleItems (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_controller_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PlankDockController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_CONTROLLER, PlankDockController);
	switch (property_id) {
		case PLANK_DOCK_CONTROLLER_NAME_PROPERTY:
		plank_dock_controller_set_name (self, g_value_get_string (value));
		break;
		case PLANK_DOCK_CONTROLLER_CONFIG_FOLDER_PROPERTY:
		plank_dock_controller_set_config_folder (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_LAUNCHERS_FOLDER_PROPERTY:
		plank_dock_controller_set_launchers_folder (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_PREFS_PROPERTY:
		plank_dock_controller_set_prefs (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_DRAG_MANAGER_PROPERTY:
		plank_dock_controller_set_drag_manager (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_HIDE_MANAGER_PROPERTY:
		plank_dock_controller_set_hide_manager (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_POSITION_MANAGER_PROPERTY:
		plank_dock_controller_set_position_manager (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_RENDERER_PROPERTY:
		plank_dock_controller_set_renderer (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_WINDOW_PROPERTY:
		plank_dock_controller_set_window (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_HOVER_PROPERTY:
		plank_dock_controller_set_hover (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_CONTROLLER_DEFAULT_PROVIDER_PROPERTY:
		plank_dock_controller_set_default_provider (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

