/* DockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from DockItem.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "plank-internal.h"
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_ITEM_0_PROPERTY,
	PLANK_DOCK_ITEM_ICON_PROPERTY,
	PLANK_DOCK_ITEM_FORCE_PIXBUF_PROPERTY,
	PLANK_DOCK_ITEM_COUNT_PROPERTY,
	PLANK_DOCK_ITEM_COUNT_VISIBLE_PROPERTY,
	PLANK_DOCK_ITEM_PROGRESS_PROPERTY,
	PLANK_DOCK_ITEM_PROGRESS_VISIBLE_PROPERTY,
	PLANK_DOCK_ITEM_POSITION_PROPERTY,
	PLANK_DOCK_ITEM_LAST_POSITION_PROPERTY,
	PLANK_DOCK_ITEM_STATE_PROPERTY,
	PLANK_DOCK_ITEM_INDICATOR_PROPERTY,
	PLANK_DOCK_ITEM_AVERAGE_ICON_COLOR_PROPERTY,
	PLANK_DOCK_ITEM_DOCK_ITEM_FILENAME_PROPERTY,
	PLANK_DOCK_ITEM_LAUNCHER_PROPERTY,
	PLANK_DOCK_ITEM_PREFS_PROPERTY,
	PLANK_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* plank_dock_item_properties[PLANK_DOCK_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
enum  {
	PLANK_DOCK_ITEM_DELETED_SIGNAL,
	PLANK_DOCK_ITEM_NUM_SIGNALS
};
static guint plank_dock_item_signals[PLANK_DOCK_ITEM_NUM_SIGNALS] = {0};

struct _PlankDockItemPrivate {
	gchar* _Icon;
	GdkPixbuf* _ForcePixbuf;
	gint64 _Count;
	gboolean _CountVisible;
	gdouble _Progress;
	gboolean _ProgressVisible;
	gint position;
	gint _LastPosition;
	PlankItemState _State;
	PlankIndicatorState _Indicator;
	PlankColor _AverageIconColor;
	PlankDockItemPreferences* _Prefs;
	PlankSurfaceCache* buffer;
	PlankSurfaceCache* background_buffer;
	PlankSurface* foreground_surface;
	GFileMonitor* launcher_file_monitor;
	GFileMonitor* icon_file_monitor;
	gboolean launcher_exists;
	guint removal_timer_id;
};

static gint PlankDockItem_private_offset;
static gpointer plank_dock_item_parent_class = NULL;

static void plank_dock_item_handle_deleted (PlankDockItem* self);
static void _plank_dock_item_handle_deleted_plank_preferences_deleted (PlankPreferences* _sender,
                                                                gpointer self);
static void plank_dock_item_handle_launcher_changed (PlankDockItem* self);
static void _plank_dock_item_handle_launcher_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void plank_dock_item_icon_theme_changed (PlankDockItem* self);
static void _plank_dock_item_icon_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                                 gpointer self);
static void plank_dock_item_icon_changed (PlankDockItem* self);
static void _plank_dock_item_icon_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void plank_dock_item_reset_foreground_buffer (PlankDockItem* self);
static void _plank_dock_item_reset_foreground_buffer_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void plank_dock_item_launcher_file_monitor_stop (PlankDockItem* self);
static void plank_dock_item_icon_file_monitor_stop (PlankDockItem* self);
static gboolean plank_dock_item_stop_removal (PlankDockItem* self);
static void plank_dock_item_real_load_from_launcher (PlankDockItem* self);
static void plank_dock_item_launcher_file_monitor_start (PlankDockItem* self);
static void plank_dock_item_real_reset_buffers (PlankDockElement* base);
static gboolean __lambda10_ (PlankDockItem* self);
static gboolean ___lambda10__gsource_func (gpointer self);
static void plank_dock_item_icon_file_monitor_start (PlankDockItem* self);
static void plank_dock_item_icon_file_changed (GFile* f,
                                        GFile* other,
                                        GFileMonitorEvent event,
                                        PlankDockItem* self);
static void _plank_dock_item_icon_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                GFile* file,
                                                                GFile* other_file,
                                                                GFileMonitorEvent event_type,
                                                                gpointer self);
static void plank_dock_item_launcher_file_changed (GFile* f,
                                            GFile* other,
                                            GFileMonitorEvent event,
                                            PlankDockItem* self);
static void plank_dock_item_replace_launcher (PlankDockItem* self,
                                       const gchar* launcher);
static gboolean plank_dock_item_schedule_removal_if_needed (PlankDockItem* self);
static void _plank_dock_item_launcher_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                    GFile* file,
                                                                    GFile* other_file,
                                                                    GFileMonitorEvent event_type,
                                                                    gpointer self);
static gboolean __lambda9_ (PlankDockItem* self);
static gboolean ___lambda9__gsource_func (gpointer self);
static PlankSurface* plank_dock_item_internal_get_surface (gint width,
                                                    gint height,
                                                    PlankSurface* model,
                                                    PlankDrawDataFunc draw_data_func,
                                                    gpointer draw_data_func_target,
                                                    PlankDockItem* self);
static PlankSurface* plank_dock_item_internal_get_background_surface (gint width,
                                                               gint height,
                                                               PlankSurface* model,
                                                               PlankDrawDataFunc draw_data_func,
                                                               gpointer draw_data_func_target,
                                                               PlankDockItem* self);
static void plank_dock_item_real_draw_icon (PlankDockItem* self,
                                     PlankSurface* surface);
static void plank_dock_item_real_draw_icon_fast (PlankDockItem* self,
                                          PlankSurface* surface);
static gboolean plank_dock_item_real_is_valid (PlankDockItem* self);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static GObject * plank_dock_item_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void plank_dock_item_finalize (GObject * obj);
static GType plank_dock_item_get_type_once (void);
static void _vala_plank_dock_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_plank_dock_item_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
plank_dock_item_get_instance_private (PlankDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockItem_private_offset);
}

static void
_plank_dock_item_handle_deleted_plank_preferences_deleted (PlankPreferences* _sender,
                                                           gpointer self)
{
	plank_dock_item_handle_deleted ((PlankDockItem*) self);
}

static void
_plank_dock_item_handle_launcher_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	plank_dock_item_handle_launcher_changed ((PlankDockItem*) self);
}

static void
_plank_dock_item_icon_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender,
                                                            gpointer self)
{
	plank_dock_item_icon_theme_changed ((PlankDockItem*) self);
}

static void
_plank_dock_item_icon_changed_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	plank_dock_item_icon_changed ((PlankDockItem*) self);
}

static void
_plank_dock_item_reset_foreground_buffer_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	plank_dock_item_reset_foreground_buffer ((PlankDockItem*) self);
}

/**
 * Creates a new dock item.
 */
PlankDockItem*
plank_dock_item_construct (GType object_type)
{
	PlankDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	_tmp0_ = plank_dock_item_preferences_new ();
	_tmp1_ = _tmp0_;
	self = (PlankDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

/**
 * Signal handler called when the underlying preferences file is deleted.
 */
static void
plank_dock_item_handle_deleted (PlankDockItem* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, plank_dock_item_signals[PLANK_DOCK_ITEM_DELETED_SIGNAL], 0);
}

/**
 * Parses the associated launcher and e.g. sets the icon and text from it.
 */
static void
plank_dock_item_real_load_from_launcher (PlankDockItem* self)
{
}

void
plank_dock_item_load_from_launcher (PlankDockItem* self)
{
	PlankDockItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_ITEM_GET_CLASS (self);
	if (_klass_->load_from_launcher) {
		_klass_->load_from_launcher (self);
	}
}

static void
plank_dock_item_handle_launcher_changed (PlankDockItem* self)
{
	g_return_if_fail (self != NULL);
	plank_dock_item_launcher_file_monitor_stop (self);
	plank_dock_item_load_from_launcher (self);
	plank_dock_item_launcher_file_monitor_start (self);
}

/**
 * Deletes the underlying preferences file.
 */
void
plank_dock_item_delete (PlankDockItem* self)
{
	PlankDockItemPreferences* _tmp0_;
	g_return_if_fail (self != NULL);
	plank_dock_item_launcher_file_monitor_stop (self);
	_tmp0_ = self->priv->_Prefs;
	plank_preferences_delete ((PlankPreferences*) _tmp0_);
}

/**
 * Resets the buffer for this item's icon and requests a redraw.
 */
void
plank_dock_item_reset_icon_buffer (PlankDockItem* self)
{
	PlankSurfaceCache* _tmp0_;
	PlankSurfaceCache* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->buffer;
	plank_surface_cache_clear (_tmp0_);
	_tmp1_ = self->priv->background_buffer;
	plank_surface_cache_clear (_tmp1_);
	_g_object_unref0 (self->priv->foreground_surface);
	self->priv->foreground_surface = NULL;
	g_signal_emit_by_name ((PlankDockElement*) self, "needs-redraw");
}

/**
 * Resets the buffers for this item's icon.
 */
static void
plank_dock_item_real_reset_buffers (PlankDockElement* base)
{
	PlankDockItem * self;
	PlankSurfaceCache* _tmp0_;
	self = (PlankDockItem*) base;
	_tmp0_ = self->priv->background_buffer;
	plank_surface_cache_clear (_tmp0_);
	_g_object_unref0 (self->priv->foreground_surface);
	self->priv->foreground_surface = NULL;
}

void
plank_dock_item_unset_move_state (PlankDockItem* self)
{
	PlankItemState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_State;
	plank_dock_item_set_State (self, _tmp0_ & (~PLANK_ITEM_STATE_MOVE));
}

static void
plank_dock_item_reset_foreground_buffer (PlankDockItem* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->foreground_surface);
	self->priv->foreground_surface = NULL;
	g_signal_emit_by_name ((PlankDockElement*) self, "needs-redraw");
}

static gboolean
__lambda10_ (PlankDockItem* self)
{
	gboolean result;
	plank_dock_item_reset_icon_buffer (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ ((PlankDockItem*) self);
	return result;
}

static void
plank_dock_item_icon_theme_changed (PlankDockItem* self)
{
	g_return_if_fail (self != NULL);
	gdk_threads_add_idle_full (G_PRIORITY_LOW, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
}

static void
plank_dock_item_icon_changed (PlankDockItem* self)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	plank_dock_item_icon_file_monitor_stop (self);
	_tmp0_ = self->priv->_ForcePixbuf;
	if (_tmp0_ == NULL) {
		plank_dock_item_icon_file_monitor_start (self);
	}
	plank_dock_item_reset_icon_buffer (self);
}

static void
plank_dock_item_icon_file_changed (GFile* f,
                                   GFile* other,
                                   GFileMonitorEvent event,
                                   PlankDockItem* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			plank_dock_item_reset_icon_buffer (self);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
_plank_dock_item_icon_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                           GFile* file,
                                                           GFile* other_file,
                                                           GFileMonitorEvent event_type,
                                                           gpointer self)
{
	plank_dock_item_icon_file_changed (file, other_file, event_type, (PlankDockItem*) self);
}

static void
plank_dock_item_icon_file_monitor_start (PlankDockItem* self)
{
	GFile* icon_file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_Icon;
	_tmp1_ = plank_drawing_service_try_get_icon_file (_tmp0_);
	icon_file = _tmp1_;
	_tmp3_ = icon_file;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = icon_file;
		_tmp5_ = g_file_get_uri_scheme (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = g_strcmp0 (_tmp6_, "file") != 0;
		_g_free0 (_tmp6_);
	}
	if (_tmp2_) {
		_g_object_unref0 (icon_file);
		return;
	}
	{
		GFileMonitor* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileMonitor* _tmp9_;
		GFileMonitor* _tmp10_;
		GFileMonitor* _tmp11_;
		_tmp8_ = icon_file;
		_tmp9_ = g_file_monitor_file (_tmp8_, 0, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->priv->icon_file_monitor);
		self->priv->icon_file_monitor = _tmp10_;
		_tmp11_ = self->priv->icon_file_monitor;
		g_signal_connect_object (_tmp11_, "changed", (GCallback) _plank_dock_item_icon_file_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp12_ = NULL;
		GFile* _tmp13_;
		gchar* _tmp14_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = icon_file;
		_tmp14_ = g_file_get_path (_tmp13_);
		_tmp12_ = _tmp14_;
		if (_tmp12_ == NULL) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			_g_free0 (_tmp12_);
			_tmp12_ = _tmp15_;
		}
		g_critical ("DockItem.vala:297: Unable to watch the icon file '%s'", _tmp12_);
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("DockItem.vala:298: %s", _tmp17_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (icon_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (icon_file);
}

static void
plank_dock_item_icon_file_monitor_stop (PlankDockItem* self)
{
	GFileMonitor* _tmp0_;
	GFileMonitor* _tmp1_;
	guint _tmp2_;
	GFileMonitor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_file_monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->icon_file_monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_dock_item_icon_file_changed_g_file_monitor_changed, self);
	_tmp3_ = self->priv->icon_file_monitor;
	g_file_monitor_cancel (_tmp3_);
	_g_object_unref0 (self->priv->icon_file_monitor);
	self->priv->icon_file_monitor = NULL;
}

static void
plank_dock_item_launcher_file_changed (GFile* f,
                                       GFile* other,
                                       GFileMonitorEvent event,
                                       PlankDockItem* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = g_file_get_uri (f);
			_tmp1_ = _tmp0_;
			plank_logger_verbose ("Launcher file '%s' changed, reloading", _tmp1_, NULL);
			_g_free0 (_tmp1_);
			plank_dock_item_load_from_launcher (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_MOVED:
		{
			gchar* launcher = NULL;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			if (other == NULL) {
				break;
			}
			_tmp2_ = g_file_get_uri (other);
			launcher = _tmp2_;
			_tmp3_ = g_file_get_uri (f);
			_tmp4_ = _tmp3_;
			_tmp5_ = launcher;
			plank_logger_verbose ("Launcher file '%s' moved to '%s'", _tmp4_, _tmp5_, NULL);
			_g_free0 (_tmp4_);
			_tmp6_ = launcher;
			plank_dock_item_replace_launcher (self, _tmp6_);
			plank_dock_item_load_from_launcher (self);
			_g_free0 (launcher);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			PlankItemState _tmp9_;
			_tmp7_ = g_file_get_uri (f);
			_tmp8_ = _tmp7_;
			g_debug ("DockItem.vala:332: Launcher file '%s' deleted, item is invalid now", _tmp8_);
			_g_free0 (_tmp8_);
			self->priv->launcher_exists = FALSE;
			plank_dock_element_set_LastValid ((PlankDockElement*) self, g_get_monotonic_time ());
			_tmp9_ = self->priv->_State;
			plank_dock_item_set_State (self, _tmp9_ | PLANK_ITEM_STATE_INVALID);
			plank_dock_item_schedule_removal_if_needed (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			gchar* _tmp10_;
			gchar* _tmp11_;
			PlankItemState _tmp12_;
			_tmp10_ = g_file_get_uri (f);
			_tmp11_ = _tmp10_;
			g_debug ("DockItem.vala:341: Launcher file '%s' created, item is valid again", _tmp11_);
			_g_free0 (_tmp11_);
			self->priv->launcher_exists = TRUE;
			_tmp12_ = self->priv->_State;
			plank_dock_item_set_State (self, _tmp12_ & (~PLANK_ITEM_STATE_INVALID));
			plank_dock_item_stop_removal (self);
			break;
		}
		default:
		{
			break;
		}
	}
	g_signal_emit_by_name ((PlankDockElement*) self, "needs-redraw");
}

static void
_plank_dock_item_launcher_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                               GFile* file,
                                                               GFile* other_file,
                                                               GFileMonitorEvent event_type,
                                                               gpointer self)
{
	plank_dock_item_launcher_file_changed (file, other_file, event_type, (PlankDockItem*) self);
}

static void
plank_dock_item_launcher_file_monitor_start (PlankDockItem* self)
{
	GFileMonitor* _tmp0_;
	const gchar* launcher = NULL;
	PlankDockItemPreferences* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->launcher_file_monitor;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->_Prefs;
	_tmp2_ = plank_dock_item_preferences_get_Launcher (_tmp1_);
	_tmp3_ = _tmp2_;
	launcher = _tmp3_;
	_tmp5_ = launcher;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = launcher;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp4_) {
		PlankItemState _tmp7_;
		_tmp7_ = self->priv->_State;
		plank_dock_item_set_State (self, _tmp7_ & (~PLANK_ITEM_STATE_INVALID));
		return;
	}
	{
		GFile* launcher_file = NULL;
		const gchar* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFileMonitor* _tmp11_ = NULL;
		GFile* _tmp12_;
		GFileMonitor* _tmp13_;
		GFileMonitor* _tmp14_;
		GFileMonitor* _tmp15_;
		_tmp8_ = launcher;
		_tmp9_ = g_file_new_for_uri (_tmp8_);
		launcher_file = _tmp9_;
		_tmp10_ = launcher_file;
		self->priv->launcher_exists = g_file_query_exists (_tmp10_, NULL);
		_tmp12_ = launcher_file;
		_tmp13_ = g_file_monitor_file (_tmp12_, G_FILE_MONITOR_SEND_MOVED, NULL, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (launcher_file);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (self->priv->launcher_file_monitor);
		self->priv->launcher_file_monitor = _tmp14_;
		_tmp15_ = self->priv->launcher_file_monitor;
		g_signal_connect_object (_tmp15_, "changed", (GCallback) _plank_dock_item_launcher_file_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (launcher_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp16_;
		g_clear_error (&_inner_error0_);
		_tmp16_ = launcher;
		g_warning ("DockItem.vala:372: Unable to watch the launcher file '%s'", _tmp16_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
plank_dock_item_launcher_file_monitor_stop (PlankDockItem* self)
{
	GFileMonitor* _tmp0_;
	GFileMonitor* _tmp1_;
	guint _tmp2_;
	GFileMonitor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->launcher_file_monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->launcher_file_monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_dock_item_launcher_file_changed_g_file_monitor_changed, self);
	_tmp3_ = self->priv->launcher_file_monitor;
	g_file_monitor_cancel (_tmp3_);
	_g_object_unref0 (self->priv->launcher_file_monitor);
	self->priv->launcher_file_monitor = NULL;
}

static void
plank_dock_item_replace_launcher (PlankDockItem* self,
                                  const gchar* launcher)
{
	PlankDockItemPreferences* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	PlankDockItemPreferences* _tmp3_;
	guint _tmp4_;
	GQuark _tmp5_;
	PlankDockItemPreferences* _tmp6_;
	PlankDockItemPreferences* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (launcher != NULL);
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_dock_item_preferences_get_Launcher (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (launcher, _tmp2_) == 0) {
		return;
	}
	plank_dock_item_launcher_file_monitor_stop (self);
	_tmp3_ = self->priv->_Prefs;
	g_signal_parse_name ("notify::Launcher", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _plank_dock_item_handle_launcher_changed_g_object_notify, self);
	_tmp6_ = self->priv->_Prefs;
	plank_dock_item_preferences_set_Launcher (_tmp6_, launcher);
	_tmp7_ = self->priv->_Prefs;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::Launcher", (GCallback) _plank_dock_item_handle_launcher_changed_g_object_notify, self, 0);
	plank_dock_item_launcher_file_monitor_start (self);
}

static gboolean
__lambda9_ (PlankDockItem* self)
{
	gboolean result;
	self->priv->removal_timer_id = 0U;
	if (!plank_dock_item_is_valid (self)) {
		plank_dock_item_delete (self);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ ((PlankDockItem*) self);
	return result;
}

static gboolean
plank_dock_item_schedule_removal_if_needed (PlankDockItem* self)
{
	gboolean _tmp0_ = FALSE;
	GFileMonitor* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->removal_timer_id > 0U) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->launcher_file_monitor;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = plank_dock_item_is_valid (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->removal_timer_id = gdk_threads_add_timeout (PLANK_ITEM_INVALID_DURATION, ___lambda9__gsource_func, self);
	result = TRUE;
	return result;
}

static gboolean
plank_dock_item_stop_removal (PlankDockItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->removal_timer_id == 0U) {
		result = FALSE;
		return result;
	}
	g_source_remove (self->priv->removal_timer_id);
	self->priv->removal_timer_id = 0U;
	result = TRUE;
	return result;
}

/**
 * Returns the surface for this item.
 *
 * It might trigger an internal redraw if the requested size
 * isn't cached yet.
 *
 * @param width width of the icon surface
 * @param height height of the icon surface
 * @param model existing surface to use as basis of new surface
 * @return the surface for this item which may not be changed
 */
PlankSurface*
plank_dock_item_get_surface (PlankDockItem* self,
                             gint width,
                             gint height,
                             PlankSurface* model)
{
	PlankSurfaceCache* _tmp0_;
	PlankSurface* _tmp1_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = plank_surface_cache_get_surface (_tmp0_, PLANK_TYPE_DOCK_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, width, height, model, (PlankDrawFunc) plank_dock_item_internal_get_surface, self, NULL, NULL);
	result = _tmp1_;
	return result;
}

static PlankSurface*
plank_dock_item_internal_get_surface (gint width,
                                      gint height,
                                      PlankSurface* model,
                                      PlankDrawDataFunc draw_data_func,
                                      gpointer draw_data_func_target,
                                      PlankDockItem* self)
{
	PlankSurface* surface = NULL;
	PlankSurface* _tmp0_;
	PlankColor _tmp1_ = {0};
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	_tmp0_ = plank_surface_new_with_surface (width, height, model);
	surface = _tmp0_;
	plank_logger_verbose ("DockItem.draw_icon (width = %i, height = %i)", width, height, NULL);
	plank_dock_item_draw_icon (self, surface);
	plank_surface_average_color (surface, &_tmp1_);
	plank_dock_item_set_AverageIconColor (self, &_tmp1_);
	result = surface;
	return result;
}

/**
 * Returns the background surface for this item.
 *
 * The draw_func may pass through the given previously computed surface
 * or change it as needed. This surface will be buffered internally.
 *
 * Passing null as draw_func will destroy the internal background buffer.
 *
 * @param draw_data_func function which creates/changes the background surface
 * @return the background surface of this item which may not be changed
 */
PlankSurface*
plank_dock_item_get_background_surface (PlankDockItem* self,
                                        gint width,
                                        gint height,
                                        PlankSurface* model,
                                        PlankDrawDataFunc draw_data_func,
                                        gpointer draw_data_func_target)
{
	PlankSurfaceCache* _tmp0_;
	PlankSurface* _tmp1_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	_tmp0_ = self->priv->background_buffer;
	_tmp1_ = plank_surface_cache_get_surface (_tmp0_, PLANK_TYPE_DOCK_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, width, height, model, (PlankDrawFunc) plank_dock_item_internal_get_background_surface, self, (PlankDrawDataFunc) draw_data_func, draw_data_func_target);
	result = _tmp1_;
	return result;
}

static PlankSurface*
plank_dock_item_internal_get_background_surface (gint width,
                                                 gint height,
                                                 PlankSurface* model,
                                                 PlankDrawDataFunc draw_data_func,
                                                 gpointer draw_data_func_target,
                                                 PlankDockItem* self)
{
	PlankSurface* _tmp0_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	if (draw_data_func == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = draw_data_func (width, height, model, self, draw_data_func_target);
	result = _tmp0_;
	return result;
}

/**
 * Returns the foreground surface for this item.
 *
 * The draw_func may pass through the given previously computed surface
 * or change it as needed. This surface will be buffered internally.
 *
 * Passing null as draw_func will destroy the internal foreground buffer.
 *
 * @param draw_data_func function which creates/changes the foreground surface
 * @return the background surface of this item which may not be changed
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PlankSurface*
plank_dock_item_get_foreground_surface (PlankDockItem* self,
                                        gint width,
                                        gint height,
                                        PlankSurface* model,
                                        PlankDrawDataFunc draw_data_func,
                                        gpointer draw_data_func_target)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	PlankSurface* _tmp2_;
	PlankSurface* _tmp11_;
	PlankSurface* _tmp12_;
	PlankSurface* _tmp13_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	if (draw_data_func == NULL) {
		_g_object_unref0 (self->priv->foreground_surface);
		self->priv->foreground_surface = NULL;
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->foreground_surface;
	if (_tmp2_ != NULL) {
		PlankSurface* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->foreground_surface;
		_tmp4_ = plank_surface_get_Width (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == width;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PlankSurface* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->foreground_surface;
		_tmp7_ = plank_surface_get_Height (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PlankSurface* _tmp9_;
		PlankSurface* _tmp10_;
		_tmp9_ = self->priv->foreground_surface;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = draw_data_func (width, height, model, self, draw_data_func_target);
	_g_object_unref0 (self->priv->foreground_surface);
	self->priv->foreground_surface = _tmp11_;
	_tmp12_ = self->priv->foreground_surface;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	result = _tmp13_;
	return result;
}

/**
 * Returns a copy of the surface for this item.
 *
 * It will trigger an internal redraw if the requested size
 * isn't matching the cache.
 *
 * @param width width of the icon surface
 * @param height height of the icon surface
 * @param model existing surface to use as basis of new surface
 * @return the copied surface for this item
 */
PlankSurface*
plank_dock_item_get_surface_copy (PlankDockItem* self,
                                  gint width,
                                  gint height,
                                  PlankSurface* model)
{
	PlankSurface* _tmp0_;
	PlankSurface* _tmp1_;
	PlankSurface* _tmp2_;
	PlankSurface* _tmp3_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	_tmp0_ = plank_dock_item_get_surface (self, width, height, model);
	_tmp1_ = _tmp0_;
	_tmp2_ = plank_surface_copy (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
 * Draws the item's icon onto a surface.
 *
 * @param surface the surface to draw on
 */
static void
plank_dock_item_real_draw_icon (PlankDockItem* self,
                                PlankSurface* surface)
{
	cairo_surface_t* icon = NULL;
	GdkPixbuf* pbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	cairo_t* cr = NULL;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	GdkPixbuf* _tmp23_;
	g_return_if_fail (surface != NULL);
	icon = NULL;
	_tmp0_ = self->priv->_ForcePixbuf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	pbuf = _tmp1_;
	_tmp2_ = pbuf;
	if (_tmp2_ == NULL) {
		gdouble x_scale = 0.0;
		gdouble y_scale = 0.0;
		cairo_surface_t* _tmp3_;
		cairo_surface_t* _tmp4_;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		cairo_surface_t* _tmp12_;
		cairo_surface_t* _tmp13_;
		x_scale = 1.0;
		y_scale = 1.0;
		_tmp3_ = plank_surface_get_Internal (surface);
		_tmp4_ = _tmp3_;
		cairo_surface_get_device_scale (_tmp4_, &_tmp5_, &_tmp6_);
		x_scale = _tmp5_;
		y_scale = _tmp6_;
		_tmp7_ = self->priv->_Icon;
		_tmp8_ = plank_surface_get_Width (surface);
		_tmp9_ = _tmp8_;
		_tmp10_ = plank_surface_get_Height (surface);
		_tmp11_ = _tmp10_;
		_tmp12_ = plank_drawing_service_load_icon_for_scale (_tmp7_, _tmp9_, _tmp11_, (gint) MAX (x_scale, y_scale));
		_cairo_surface_destroy0 (icon);
		icon = _tmp12_;
		_tmp13_ = icon;
		if (_tmp13_ != NULL) {
			cairo_surface_t* _tmp14_;
			_tmp14_ = icon;
			cairo_surface_set_device_scale (_tmp14_, 1.0, 1.0);
		}
	} else {
		GdkPixbuf* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GdkPixbuf* _tmp20_;
		_tmp15_ = pbuf;
		_tmp16_ = plank_surface_get_Width (surface);
		_tmp17_ = _tmp16_;
		_tmp18_ = plank_surface_get_Height (surface);
		_tmp19_ = _tmp18_;
		_tmp20_ = plank_drawing_service_ar_scale (_tmp15_, _tmp17_, _tmp19_);
		_g_object_unref0 (pbuf);
		pbuf = _tmp20_;
	}
	_tmp21_ = plank_surface_get_Context (surface);
	_tmp22_ = _tmp21_;
	cr = _tmp22_;
	_tmp23_ = pbuf;
	if (_tmp23_ != NULL) {
		cairo_t* _tmp24_;
		GdkPixbuf* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		GdkPixbuf* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		GdkPixbuf* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		cairo_t* _tmp36_;
		_tmp24_ = cr;
		_tmp25_ = pbuf;
		_tmp26_ = plank_surface_get_Width (surface);
		_tmp27_ = _tmp26_;
		_tmp28_ = pbuf;
		_tmp29_ = gdk_pixbuf_get_width (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = plank_surface_get_Height (surface);
		_tmp32_ = _tmp31_;
		_tmp33_ = pbuf;
		_tmp34_ = gdk_pixbuf_get_height (_tmp33_);
		_tmp35_ = _tmp34_;
		gdk_cairo_set_source_pixbuf (_tmp24_, _tmp25_, (gdouble) ((_tmp27_ - _tmp30_) / 2), (gdouble) ((_tmp32_ - _tmp35_) / 2));
		_tmp36_ = cr;
		cairo_paint (_tmp36_);
	} else {
		cairo_surface_t* _tmp37_;
		_tmp37_ = icon;
		if (_tmp37_ != NULL) {
			cairo_t* _tmp38_;
			cairo_surface_t* _tmp39_;
			cairo_t* _tmp40_;
			_tmp38_ = cr;
			_tmp39_ = icon;
			cairo_set_source_surface (_tmp38_, _tmp39_, (gdouble) 0, (gdouble) 0);
			_tmp40_ = cr;
			cairo_paint (_tmp40_);
		} else {
			g_warn_if_reached ();
		}
	}
	_g_object_unref0 (pbuf);
	_cairo_surface_destroy0 (icon);
}

void
plank_dock_item_draw_icon (PlankDockItem* self,
                           PlankSurface* surface)
{
	PlankDockItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_ITEM_GET_CLASS (self);
	if (_klass_->draw_icon) {
		_klass_->draw_icon (self, surface);
	}
}

/**
 * Draws a placeholder icon onto a surface.
 * This method should be considered time-critical!
 * Make sure to only use simple drawing routines, and do not rely on external resources!
 *
 * @param surface the surface to draw on
 */
static void
plank_dock_item_real_draw_icon_fast (PlankDockItem* self,
                                     PlankSurface* surface)
{
	cairo_t* cr = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint width = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint height = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint radius = 0;
	gint line_width_half = 0;
	cairo_pattern_t* rg = NULL;
	cairo_pattern_t* _tmp6_;
	g_return_if_fail (surface != NULL);
	_tmp0_ = plank_surface_get_Context (surface);
	_tmp1_ = _tmp0_;
	cr = _tmp1_;
	_tmp2_ = plank_surface_get_Width (surface);
	_tmp3_ = _tmp2_;
	width = _tmp3_;
	_tmp4_ = plank_surface_get_Height (surface);
	_tmp5_ = _tmp4_;
	height = _tmp5_;
	radius = (width / 2) - 1;
	line_width_half = 1;
	cairo_move_to (cr, (gdouble) radius, (gdouble) line_width_half);
	cairo_arc (cr, (gdouble) (radius + line_width_half), (gdouble) (radius + line_width_half), (gdouble) radius, (gdouble) 0, 2 * G_PI);
	cairo_close_path (cr);
	cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.2);
	cairo_set_line_width (cr, (gdouble) (2 * line_width_half));
	cairo_stroke_preserve (cr);
	_tmp6_ = cairo_pattern_create_radial ((gdouble) (width / 2), (gdouble) height, (gdouble) (height / 8), (gdouble) (width / 2), (gdouble) height, (gdouble) height);
	rg = _tmp6_;
	cairo_pattern_add_color_stop_rgba (rg, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.6);
	cairo_pattern_add_color_stop_rgba (rg, (gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.3);
	cairo_set_source (cr, rg);
	cairo_fill (cr);
	_cairo_pattern_destroy0 (rg);
}

void
plank_dock_item_draw_icon_fast (PlankDockItem* self,
                                PlankSurface* surface)
{
	PlankDockItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_ITEM_GET_CLASS (self);
	if (_klass_->draw_icon_fast) {
		_klass_->draw_icon_fast (self, surface);
	}
}

/**
 * Check the validity of this item.
 *
 * @return Whether or not this item is valid for the .dockitem given
 */
static gboolean
plank_dock_item_real_is_valid (PlankDockItem* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (self->priv->launcher_exists) {
		_tmp0_ = TRUE;
	} else {
		PlankDockItemPreferences* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->_Prefs;
		_tmp2_ = plank_dock_item_preferences_get_Launcher (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = g_strcmp0 (_tmp3_, "") == 0;
	}
	result = _tmp0_;
	return result;
}

gboolean
plank_dock_item_is_valid (PlankDockItem* self)
{
	PlankDockItemClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_ITEM_GET_CLASS (self);
	if (_klass_->is_valid) {
		return _klass_->is_valid (self);
	}
	return FALSE;
}

/**
 * Copy all property value of this dockitem instance to target instance.
 *
 * @param target the dockitem to copy the values to
 */
void
plank_dock_item_copy_values_to (PlankDockItem* self,
                                PlankDockItem* target)
{
	GParamSpec** properties = NULL;
	GObjectClass* _tmp0_;
	guint _tmp1_ = 0;
	GParamSpec** _tmp2_;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	_tmp0_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp2_ = g_object_class_list_properties (_tmp0_, &_tmp1_);
	properties = _tmp2_;
	properties_length1 = _tmp1_;
	_properties_size_ = properties_length1;
	_tmp3_ = properties;
	_tmp3__length1 = properties_length1;
	{
		GParamSpec** prop_collection = NULL;
		gint prop_collection_length1 = 0;
		gint _prop_collection_size_ = 0;
		gint prop_it = 0;
		prop_collection = _tmp3_;
		prop_collection_length1 = _tmp3__length1;
		for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
			GParamSpec* prop = NULL;
			prop = prop_collection[prop_it];
			{
				gboolean _tmp4_ = FALSE;
				GParamSpec* _tmp5_;
				const gchar* name = NULL;
				GParamSpec* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GType type = 0UL;
				GParamSpec* _tmp10_;
				GValue val = {0};
				GValue _tmp11_ = {0};
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GValue _tmp14_;
				_tmp5_ = prop;
				if ((_tmp5_->flags & G_PARAM_WRITABLE) == 0) {
					_tmp4_ = TRUE;
				} else {
					GParamSpec* _tmp6_;
					_tmp6_ = prop;
					_tmp4_ = (_tmp6_->flags & G_PARAM_CONSTRUCT_ONLY) != 0;
				}
				if (_tmp4_) {
					continue;
				}
				_tmp7_ = prop;
				_tmp8_ = g_param_spec_get_name (_tmp7_);
				name = _tmp8_;
				_tmp9_ = name;
				if (g_strcmp0 (_tmp9_, "Container") == 0) {
					continue;
				}
				_tmp10_ = prop;
				type = _tmp10_->value_type;
				g_value_init (&_tmp11_, type);
				val = _tmp11_;
				_tmp12_ = name;
				g_object_get_property ((GObject*) self, _tmp12_, &val);
				_tmp13_ = name;
				_tmp14_ = val;
				g_object_set_property ((GObject*) target, _tmp13_, &_tmp14_);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			}
		}
	}
	properties = (g_free (properties), NULL);
}

const gchar*
plank_dock_item_get_Icon (PlankDockItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Icon;
	result = _tmp0_;
	return result;
}

void
plank_dock_item_set_Icon (PlankDockItem* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_Icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_Icon);
		self->priv->_Icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_ICON_PROPERTY]);
	}
}

GdkPixbuf*
plank_dock_item_get_ForcePixbuf (PlankDockItem* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ForcePixbuf;
	result = _tmp0_;
	return result;
}

void
plank_dock_item_set_ForcePixbuf (PlankDockItem* self,
                                 GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_ForcePixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_ForcePixbuf);
		self->priv->_ForcePixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_FORCE_PIXBUF_PROPERTY]);
	}
}

gint64
plank_dock_item_get_Count (PlankDockItem* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_Count;
	return result;
}

void
plank_dock_item_set_Count (PlankDockItem* self,
                           gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_Count (self);
	if (old_value != value) {
		self->priv->_Count = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_COUNT_PROPERTY]);
	}
}

gboolean
plank_dock_item_get_CountVisible (PlankDockItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_CountVisible;
	return result;
}

void
plank_dock_item_set_CountVisible (PlankDockItem* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_CountVisible (self);
	if (old_value != value) {
		self->priv->_CountVisible = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_COUNT_VISIBLE_PROPERTY]);
	}
}

gdouble
plank_dock_item_get_Progress (PlankDockItem* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_Progress;
	return result;
}

void
plank_dock_item_set_Progress (PlankDockItem* self,
                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_Progress (self);
	if (old_value != value) {
		self->priv->_Progress = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_PROGRESS_PROPERTY]);
	}
}

gboolean
plank_dock_item_get_ProgressVisible (PlankDockItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ProgressVisible;
	return result;
}

void
plank_dock_item_set_ProgressVisible (PlankDockItem* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_ProgressVisible (self);
	if (old_value != value) {
		self->priv->_ProgressVisible = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_PROGRESS_VISIBLE_PROPERTY]);
	}
}

gint
plank_dock_item_get_Position (PlankDockItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->position;
	return result;
}

void
plank_dock_item_set_Position (PlankDockItem* self,
                              gint value)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->position == value) {
		return;
	}
	_tmp0_ = self->priv->_LastPosition;
	if (_tmp0_ != self->priv->position) {
		plank_dock_item_set_LastPosition (self, self->priv->position);
	}
	self->priv->position = value;
	_tmp1_ = self->priv->_LastPosition;
	if (_tmp1_ > -1) {
		PlankItemState _tmp2_;
		plank_dock_element_set_LastMove ((PlankDockElement*) self, g_get_monotonic_time ());
		_tmp2_ = self->priv->_State;
		plank_dock_item_set_State (self, _tmp2_ | PLANK_ITEM_STATE_MOVE);
	}
	g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_POSITION_PROPERTY]);
}

gint
plank_dock_item_get_LastPosition (PlankDockItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_LastPosition;
	return result;
}

void
plank_dock_item_set_LastPosition (PlankDockItem* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_LastPosition (self);
	if (old_value != value) {
		self->priv->_LastPosition = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_LAST_POSITION_PROPERTY]);
	}
}

PlankItemState
plank_dock_item_get_State (PlankDockItem* self)
{
	PlankItemState result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_State;
	return result;
}

void
plank_dock_item_set_State (PlankDockItem* self,
                           PlankItemState value)
{
	PlankItemState old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_State (self);
	if (old_value != value) {
		self->priv->_State = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_STATE_PROPERTY]);
	}
}

PlankIndicatorState
plank_dock_item_get_Indicator (PlankDockItem* self)
{
	PlankIndicatorState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Indicator;
	return result;
}

void
plank_dock_item_set_Indicator (PlankDockItem* self,
                               PlankIndicatorState value)
{
	PlankIndicatorState old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_Indicator (self);
	if (old_value != value) {
		self->priv->_Indicator = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_INDICATOR_PROPERTY]);
	}
}

void
plank_dock_item_get_AverageIconColor (PlankDockItem* self,
                                      PlankColor * result)
{
	PlankColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_AverageIconColor;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
plank_dock_item_set_AverageIconColor (PlankDockItem* self,
                                      PlankColor * value)
{
	PlankColor old_value;
	g_return_if_fail (self != NULL);
	plank_dock_item_get_AverageIconColor (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		PlankColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_AverageIconColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_AVERAGE_ICON_COLOR_PROPERTY]);
	}
}

gchar*
plank_dock_item_get_DockItemFilename (PlankDockItem* self)
{
	gchar* result;
	PlankDockItemPreferences* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_preferences_get_filename ((PlankPreferences*) _tmp0_);
	result = _tmp1_;
	return result;
}

const gchar*
plank_dock_item_get_Launcher (PlankDockItem* self)
{
	const gchar* result;
	PlankDockItemPreferences* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Prefs;
	_tmp1_ = plank_dock_item_preferences_get_Launcher (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

PlankDockItemPreferences*
plank_dock_item_get_Prefs (PlankDockItem* self)
{
	PlankDockItemPreferences* result;
	PlankDockItemPreferences* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Prefs;
	result = _tmp0_;
	return result;
}

static void
plank_dock_item_set_Prefs (PlankDockItem* self,
                           PlankDockItemPreferences* value)
{
	PlankDockItemPreferences* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_item_get_Prefs (self);
	if (old_value != value) {
		PlankDockItemPreferences* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_Prefs);
		self->priv->_Prefs = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_item_properties[PLANK_DOCK_ITEM_PREFS_PROPERTY]);
	}
}

static GObject *
plank_dock_item_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDockItem * self;
	PlankSurfaceCache* _tmp0_;
	PlankSurfaceCache* _tmp1_;
	PlankDockItemPreferences* _tmp2_;
	PlankDockItemPreferences* _tmp3_;
	GtkIconTheme* _tmp4_;
	GdkPixbuf* _tmp5_;
	parent_class = G_OBJECT_CLASS (plank_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_ITEM, PlankDockItem);
	_tmp0_ = plank_surface_cache_new (PLANK_TYPE_DOCK_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PLANK_SURFACE_CACHE_FLAGS_NONE);
	_g_object_unref0 (self->priv->buffer);
	self->priv->buffer = _tmp0_;
	_tmp1_ = plank_surface_cache_new (PLANK_TYPE_DOCK_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PLANK_SURFACE_CACHE_FLAGS_ALLOW_SCALE);
	_g_object_unref0 (self->priv->background_buffer);
	self->priv->background_buffer = _tmp1_;
	_tmp2_ = self->priv->_Prefs;
	g_signal_connect_object ((PlankPreferences*) _tmp2_, "deleted", (GCallback) _plank_dock_item_handle_deleted_plank_preferences_deleted, self, 0);
	_tmp3_ = self->priv->_Prefs;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::Launcher", (GCallback) _plank_dock_item_handle_launcher_changed_g_object_notify, self, 0);
	_tmp4_ = plank_drawing_service_get_icon_theme ();
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _plank_dock_item_icon_theme_changed_gtk_icon_theme_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::Icon", (GCallback) _plank_dock_item_icon_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::ForcePixbuf", (GCallback) _plank_dock_item_icon_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::Count", (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::CountVisible", (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::Progress", (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::ProgressVisible", (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self, 0);
	plank_dock_item_launcher_file_monitor_start (self);
	_tmp5_ = self->priv->_ForcePixbuf;
	if (_tmp5_ == NULL) {
		plank_dock_item_icon_file_monitor_start (self);
	}
	return obj;
}

static void
plank_dock_item_class_init (PlankDockItemClass * klass,
                            gpointer klass_data)
{
	plank_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockItem_private_offset);
	((PlankDockItemClass *) klass)->load_from_launcher = (void (*) (PlankDockItem*)) plank_dock_item_real_load_from_launcher;
	((PlankDockElementClass *) klass)->reset_buffers = (void (*) (PlankDockElement*)) plank_dock_item_real_reset_buffers;
	((PlankDockItemClass *) klass)->draw_icon = (void (*) (PlankDockItem*, PlankSurface*)) plank_dock_item_real_draw_icon;
	((PlankDockItemClass *) klass)->draw_icon_fast = (void (*) (PlankDockItem*, PlankSurface*)) plank_dock_item_real_draw_icon_fast;
	((PlankDockItemClass *) klass)->is_valid = (gboolean (*) (PlankDockItem*)) plank_dock_item_real_is_valid;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_item_finalize;
	/**
	 * The dock item's icon.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_ICON_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_ICON_PROPERTY] = g_param_spec_string ("Icon", "Icon", "Icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_FORCE_PIXBUF_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_FORCE_PIXBUF_PROPERTY] = g_param_spec_object ("ForcePixbuf", "ForcePixbuf", "ForcePixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The count for the dock item.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_COUNT_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_COUNT_PROPERTY] = g_param_spec_int64 ("Count", "Count", "Count", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Show the item's count or not.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_COUNT_VISIBLE_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_COUNT_VISIBLE_PROPERTY] = g_param_spec_boolean ("CountVisible", "CountVisible", "CountVisible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The progress for this dock item.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_PROGRESS_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_PROGRESS_PROPERTY] = g_param_spec_double ("Progress", "Progress", "Progress", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Show the item's progress or not.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_PROGRESS_VISIBLE_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_PROGRESS_VISIBLE_PROPERTY] = g_param_spec_boolean ("ProgressVisible", "ProgressVisible", "ProgressVisible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The dock item's position on the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_POSITION_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_POSITION_PROPERTY] = g_param_spec_int ("Position", "Position", "Position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The dock item's last position on the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_LAST_POSITION_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_LAST_POSITION_PROPERTY] = g_param_spec_int ("LastPosition", "LastPosition", "LastPosition", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The item's current state.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_STATE_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_STATE_PROPERTY] = g_param_spec_flags ("State", "State", "State", PLANK_TYPE_ITEM_STATE, PLANK_ITEM_STATE_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The indicator shown for the item.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_INDICATOR_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_INDICATOR_PROPERTY] = g_param_spec_enum ("Indicator", "Indicator", "Indicator", PLANK_TYPE_INDICATOR_STATE, PLANK_INDICATOR_STATE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The average color of this item's icon.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_AVERAGE_ICON_COLOR_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_AVERAGE_ICON_COLOR_PROPERTY] = g_param_spec_boxed ("AverageIconColor", "AverageIconColor", "AverageIconColor", PLANK_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The filename of the preferences backing file.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_DOCK_ITEM_FILENAME_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_DOCK_ITEM_FILENAME_PROPERTY] = g_param_spec_string ("DockItemFilename", "DockItemFilename", "DockItemFilename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The launcher associated with this item.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_LAUNCHER_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_LAUNCHER_PROPERTY] = g_param_spec_string ("Launcher", "Launcher", "Launcher", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The underlying preferences for this item.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_ITEM_PREFS_PROPERTY, plank_dock_item_properties[PLANK_DOCK_ITEM_PREFS_PROPERTY] = g_param_spec_object ("Prefs", "Prefs", "Prefs", PLANK_TYPE_DOCK_ITEM_PREFERENCES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Signal fired when the .dockitem for this item was deleted.
	 */
	plank_dock_item_signals[PLANK_DOCK_ITEM_DELETED_SIGNAL] = g_signal_new ("deleted", PLANK_TYPE_DOCK_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
plank_dock_item_instance_init (PlankDockItem * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	PlankColor _tmp1_ = {0};
	self->priv = plank_dock_item_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_Icon = _tmp0_;
	self->priv->_ForcePixbuf = NULL;
	self->priv->_Count = (gint64) 0;
	self->priv->_CountVisible = FALSE;
	self->priv->_Progress = (gdouble) 0;
	self->priv->_ProgressVisible = FALSE;
	self->priv->position = -1;
	self->priv->_LastPosition = -1;
	self->priv->_State = PLANK_ITEM_STATE_NORMAL;
	self->priv->_Indicator = PLANK_INDICATOR_STATE_NONE;
	memset (&_tmp1_, 0, sizeof (PlankColor));
	_tmp1_.red = 0.0;
	_tmp1_.green = 0.0;
	_tmp1_.blue = 0.0;
	_tmp1_.alpha = 0.0;
	self->priv->_AverageIconColor = _tmp1_;
	self->priv->foreground_surface = NULL;
	self->priv->launcher_file_monitor = NULL;
	self->priv->icon_file_monitor = NULL;
	self->priv->launcher_exists = FALSE;
	self->priv->removal_timer_id = 0U;
}

static void
plank_dock_item_finalize (GObject * obj)
{
	PlankDockItem * self;
	PlankSurfaceCache* _tmp0_;
	PlankSurfaceCache* _tmp1_;
	PlankDockItemPreferences* _tmp2_;
	guint _tmp3_;
	PlankDockItemPreferences* _tmp4_;
	guint _tmp5_;
	GQuark _tmp6_;
	GtkIconTheme* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	guint _tmp11_;
	GQuark _tmp12_;
	guint _tmp13_;
	GQuark _tmp14_;
	guint _tmp15_;
	GQuark _tmp16_;
	guint _tmp17_;
	GQuark _tmp18_;
	guint _tmp19_;
	GQuark _tmp20_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_ITEM, PlankDockItem);
	_tmp0_ = self->priv->buffer;
	plank_surface_cache_clear (_tmp0_);
	_tmp1_ = self->priv->background_buffer;
	plank_surface_cache_clear (_tmp1_);
	_tmp2_ = self->priv->_Prefs;
	g_signal_parse_name ("deleted", PLANK_TYPE_PREFERENCES, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankPreferences*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_dock_item_handle_deleted_plank_preferences_deleted, self);
	_tmp4_ = self->priv->_Prefs;
	g_signal_parse_name ("notify::Launcher", G_TYPE_OBJECT, &_tmp5_, &_tmp6_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) _plank_dock_item_handle_launcher_changed_g_object_notify, self);
	_tmp7_ = plank_drawing_service_get_icon_theme ();
	g_signal_parse_name ("changed", gtk_icon_theme_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _plank_dock_item_icon_theme_changed_gtk_icon_theme_changed, self);
	g_signal_parse_name ("notify::Icon", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _plank_dock_item_icon_changed_g_object_notify, self);
	g_signal_parse_name ("notify::ForcePixbuf", G_TYPE_OBJECT, &_tmp11_, &_tmp12_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, _tmp12_, NULL, (GCallback) _plank_dock_item_icon_changed_g_object_notify, self);
	g_signal_parse_name ("notify::Count", G_TYPE_OBJECT, &_tmp13_, &_tmp14_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, _tmp14_, NULL, (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self);
	g_signal_parse_name ("notify::CountVisible", G_TYPE_OBJECT, &_tmp15_, &_tmp16_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, _tmp16_, NULL, (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self);
	g_signal_parse_name ("notify::Progress", G_TYPE_OBJECT, &_tmp17_, &_tmp18_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, _tmp18_, NULL, (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self);
	g_signal_parse_name ("notify::ProgressVisible", G_TYPE_OBJECT, &_tmp19_, &_tmp20_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, _tmp20_, NULL, (GCallback) _plank_dock_item_reset_foreground_buffer_g_object_notify, self);
	plank_dock_item_launcher_file_monitor_stop (self);
	plank_dock_item_icon_file_monitor_stop (self);
	if (plank_dock_item_stop_removal (self)) {
		plank_dock_item_delete (self);
	}
	_g_free0 (self->priv->_Icon);
	_g_object_unref0 (self->priv->_ForcePixbuf);
	_g_object_unref0 (self->priv->_Prefs);
	_g_object_unref0 (self->priv->buffer);
	_g_object_unref0 (self->priv->background_buffer);
	_g_object_unref0 (self->priv->foreground_surface);
	_g_object_unref0 (self->priv->launcher_file_monitor);
	_g_object_unref0 (self->priv->icon_file_monitor);
	G_OBJECT_CLASS (plank_dock_item_parent_class)->finalize (obj);
}

/**
 * The base class for all dock items.
 */
static GType
plank_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockItem), 0, (GInstanceInitFunc) plank_dock_item_instance_init, NULL };
	GType plank_dock_item_type_id;
	plank_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCK_ELEMENT, "PlankDockItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankDockItem_private_offset = g_type_add_instance_private (plank_dock_item_type_id, sizeof (PlankDockItemPrivate));
	return plank_dock_item_type_id;
}

GType
plank_dock_item_get_type (void)
{
	static volatile gsize plank_dock_item_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_item_type_id__once)) {
		GType plank_dock_item_type_id;
		plank_dock_item_type_id = plank_dock_item_get_type_once ();
		g_once_init_leave (&plank_dock_item_type_id__once, plank_dock_item_type_id);
	}
	return plank_dock_item_type_id__once;
}

static void
_vala_plank_dock_item_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PlankDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_ITEM, PlankDockItem);
	switch (property_id) {
		case PLANK_DOCK_ITEM_ICON_PROPERTY:
		g_value_set_string (value, plank_dock_item_get_Icon (self));
		break;
		case PLANK_DOCK_ITEM_FORCE_PIXBUF_PROPERTY:
		g_value_set_object (value, plank_dock_item_get_ForcePixbuf (self));
		break;
		case PLANK_DOCK_ITEM_COUNT_PROPERTY:
		g_value_set_int64 (value, plank_dock_item_get_Count (self));
		break;
		case PLANK_DOCK_ITEM_COUNT_VISIBLE_PROPERTY:
		g_value_set_boolean (value, plank_dock_item_get_CountVisible (self));
		break;
		case PLANK_DOCK_ITEM_PROGRESS_PROPERTY:
		g_value_set_double (value, plank_dock_item_get_Progress (self));
		break;
		case PLANK_DOCK_ITEM_PROGRESS_VISIBLE_PROPERTY:
		g_value_set_boolean (value, plank_dock_item_get_ProgressVisible (self));
		break;
		case PLANK_DOCK_ITEM_POSITION_PROPERTY:
		g_value_set_int (value, plank_dock_item_get_Position (self));
		break;
		case PLANK_DOCK_ITEM_LAST_POSITION_PROPERTY:
		g_value_set_int (value, plank_dock_item_get_LastPosition (self));
		break;
		case PLANK_DOCK_ITEM_STATE_PROPERTY:
		g_value_set_flags (value, plank_dock_item_get_State (self));
		break;
		case PLANK_DOCK_ITEM_INDICATOR_PROPERTY:
		g_value_set_enum (value, plank_dock_item_get_Indicator (self));
		break;
		case PLANK_DOCK_ITEM_AVERAGE_ICON_COLOR_PROPERTY:
		{
			PlankColor boxed;
			plank_dock_item_get_AverageIconColor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case PLANK_DOCK_ITEM_DOCK_ITEM_FILENAME_PROPERTY:
		g_value_take_string (value, plank_dock_item_get_DockItemFilename (self));
		break;
		case PLANK_DOCK_ITEM_LAUNCHER_PROPERTY:
		g_value_set_string (value, plank_dock_item_get_Launcher (self));
		break;
		case PLANK_DOCK_ITEM_PREFS_PROPERTY:
		g_value_set_object (value, plank_dock_item_get_Prefs (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_item_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PlankDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_ITEM, PlankDockItem);
	switch (property_id) {
		case PLANK_DOCK_ITEM_ICON_PROPERTY:
		plank_dock_item_set_Icon (self, g_value_get_string (value));
		break;
		case PLANK_DOCK_ITEM_FORCE_PIXBUF_PROPERTY:
		plank_dock_item_set_ForcePixbuf (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_ITEM_COUNT_PROPERTY:
		plank_dock_item_set_Count (self, g_value_get_int64 (value));
		break;
		case PLANK_DOCK_ITEM_COUNT_VISIBLE_PROPERTY:
		plank_dock_item_set_CountVisible (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_ITEM_PROGRESS_PROPERTY:
		plank_dock_item_set_Progress (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_ITEM_PROGRESS_VISIBLE_PROPERTY:
		plank_dock_item_set_ProgressVisible (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_ITEM_POSITION_PROPERTY:
		plank_dock_item_set_Position (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_ITEM_LAST_POSITION_PROPERTY:
		plank_dock_item_set_LastPosition (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_ITEM_STATE_PROPERTY:
		plank_dock_item_set_State (self, g_value_get_flags (value));
		break;
		case PLANK_DOCK_ITEM_INDICATOR_PROPERTY:
		plank_dock_item_set_Indicator (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_ITEM_AVERAGE_ICON_COLOR_PROPERTY:
		plank_dock_item_set_AverageIconColor (self, g_value_get_boxed (value));
		break;
		case PLANK_DOCK_ITEM_PREFS_PROPERTY:
		plank_dock_item_set_Prefs (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

