/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AMDGPUPreLegalizerCombinerImpl Combiner Match Table                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct AMDGPUPreLegalizerCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 9:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "opy_prop", 8) != 0)
        break;
      return 13;	 // "copy_prop"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ors", 7) != 0)
          break;
        return 195;	 // "match_ors"
      case 'u':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "lo_by_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case '0':	 // 1 string to match.
          return 144;	 // "mulo_by_0"
        case '2':	 // 1 string to match.
          return 143;	 // "mulo_by_2"
        }
        break;
      }
      break;
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "neg_zext", 8) != 0)
        break;
      return 200;	 // "nneg_zext"
    }
    break;
  case 10:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2p_to_p2i", 9) != 0)
        break;
      return 89;	 // "i2p_to_p2i"
    case 'm':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ands", 8) != 0)
          break;
        return 194;	 // "match_ands"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_to_shl", 8) != 0)
          break;
        return 14;	 // "mul_to_shl"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2i_to_i2p", 9) != 0)
        break;
      return 88;	 // "p2i_to_i2p"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_trunc", 8) != 0)
          break;
        return 198;	 // "sext_trunc"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_to_add", 8) != 0)
          break;
        return 15;	 // "sub_to_add"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc", 9) != 0)
        break;
      return 199;	 // "zext_trunc"
    }
    break;
  case 11:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_sub_reg", 10) != 0)
        break;
      return 94;	 // "add_sub_reg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_addos", 10) != 0)
        break;
      return 214;	 // "match_addos"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ub_add_reg", 10) != 0)
        break;
      return 189;	 // "sub_add_reg"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_shift", 10) != 0)
        break;
      return 131;	 // "trunc_shift"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_cst", 10) != 0)
        break;
      return 208;	 // "unmerge_cst"
    }
    break;
  case 12:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinusB", 11) != 0)
        break;
      return 2;	 // "APlusBMinusB"
    case 'B':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusAPlusA", 11) != 0)
        break;
      return 3;	 // "BMinusAPlusA"
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dde_to_addo", 11) != 0)
        break;
      return 145;	 // "adde_to_addo"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "sub_to_fneg", 11) != 0)
        break;
      return 191;	 // "fsub_to_fneg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ulh_to_lshr", 11) != 0)
        break;
      return 171;	 // "mulh_to_lshr"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ot_cmp_fold", 11) != 0)
        break;
      return 132;	 // "not_cmp_fold"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_or", 11) != 0)
        break;
      return 127;	 // "redundant_or"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_pow2", 10) != 0)
          break;
        return 186;	 // "sdiv_by_pow2"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_of_sext", 10) != 0)
          break;
        return 48;	 // "sext_of_sext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "div_by_pow2", 11) != 0)
        break;
      return 185;	 // "udiv_by_pow2"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_zext", 11) != 0)
        break;
      return 46;	 // "zext_of_zext"
    }
    break;
  case 13:	 // 16 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_of_vscale", 12) != 0)
        break;
      return 37;	 // "add_of_vscale"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_shift", 12) != 0)
        break;
      return 161;	 // "commute_shift"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oldable_fneg", 12) != 0)
        break;
      return 218;	 // "foldable_fneg"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_and_mask", 12) != 0)
        break;
      return 69;	 // "load_and_mask"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_selects", 11) != 0)
          break;
        return 124;	 // "match_selects"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "rge_unmerge", 11) != 0)
          break;
        return 207;	 // "merge_unmerge"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 38;	 // "mul_of_vscale"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_and", 12) != 0)
        break;
      return 125;	 // "redundant_and"
    case 's':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 188;	 // "sdiv_by_const"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 39;	 // "shl_of_vscale"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 184;	 // "srem_by_const"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_of_vscale", 11) != 0)
          break;
        return 40;	 // "sub_of_vscale"
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 187;	 // "udiv_by_const"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "merge_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case 'm':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "erge", 4) != 0)
            break;
          return 206;	 // "unmerge_merge"
        case 'u':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "ndef", 4) != 0)
            break;
          return 209;	 // "unmerge_undef"
        }
        break;
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 183;	 // "urem_by_const"
      }
      break;
    }
    break;
  case 14:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1PlusC2", 12) != 0)
          break;
        return 12;	 // "AMinusC1PlusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusC1MinusC2", 12) != 0)
          break;
        return 8;	 // "APlusC1MinusC2"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2MinusAPlusC1", 13) != 0)
        break;
      return 9;	 // "C2MinusAPlusC1"
    case 'a':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_", 9) != 0)
        break;
      switch (RuleIdentifier[10]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 52;	 // "anyext_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 51;	 // "anyext_of_zext"
      }
      break;
    case 'b':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'i')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "op_same_val", 11) != 0)
          break;
        return 85;	 // "binop_same_val"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "reverse_shl", 11) != 0)
          break;
        return 159;	 // "bitreverse_shl"
      }
      break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "bs_fneg_fold", 12) != 0)
          break;
        return 170;	 // "fabs_fneg_fold"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "eg_fneg_fold", 12) != 0)
          break;
        return 91;	 // "fneg_fneg_fold"
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ul_by_neg_one", 13) != 0)
        break;
      return 17;	 // "mul_by_neg_one"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eassoc_ptradd", 13) != 0)
        break;
      return 106;	 // "reassoc_ptradd"
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 2 strings to match.
        switch (RuleIdentifier[2]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "ect_of_zext", 11) != 0)
            break;
          return 54;	 // "select_of_zext"
        case 'x':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "t_of_anyext", 11) != 0)
            break;
          return 49;	 // "sext_of_anyext"
        }
        break;
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ifts_too_big", 12) != 0)
          break;
        return 105;	 // "shifts_too_big"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_anyext", 13) != 0)
        break;
      return 47;	 // "zext_of_anyext"
    }
    break;
  case 15:	 // 12 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1MinusC2", 13) != 0)
          break;
        return 10;	 // "AMinusC1MinusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusZeroMinusB", 13) != 0)
          break;
        return 1;	 // "APlusZeroMinusB"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "1Minus2MinusC2", 14) != 0)
        break;
      return 11;	 // "C1Minus2MinusC2"
    case 'Z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eroMinusAPlusB", 14) != 0)
        break;
      return 0;	 // "ZeroMinusAPlusB"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itreverse_lshr", 14) != 0)
        break;
      return 160;	 // "bitreverse_lshr"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtending_loads", 14) != 0)
        break;
      return 68;	 // "extending_loads"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dempotent_prop", 14) != 0)
        break;
      return 18;	 // "idempotent_prop"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_or_combine", 14) != 0)
        break;
      return 152;	 // "load_or_combine"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_or", 14) != 0)
        break;
      return 62;	 // "narrow_binop_or"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "verlapping_and", 14) != 0)
        break;
      return 142;	 // "overlapping_and"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_same_val", 14) != 0)
        break;
      return 83;	 // "select_same_val"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc_fold", 14) != 0)
        break;
      return 129;	 // "zext_trunc_fold"
    }
    break;
  case 16:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_anyext", 15) != 0)
        break;
      return 50;	 // "anyext_of_anyext"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "lamp_i64_to_i16", 15) != 0)
        break;
      return 217;	 // "clamp_i64_to_i16"
    case 'n':	 // 5 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_", 12) != 0)
        break;
      switch (RuleIdentifier[13]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (RuleIdentifier[14]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 58;	 // "narrow_binop_add"
        case 'n':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 61;	 // "narrow_binop_and"
        }
        break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ul", 2) != 0)
          break;
        return 60;	 // "narrow_binop_mul"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ub", 2) != 0)
          break;
        return 59;	 // "narrow_binop_sub"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "or", 2) != 0)
          break;
        return 63;	 // "narrow_binop_xor"
      }
      break;
    case 's':	 // 3 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_", 6) != 0)
        break;
      switch (RuleIdentifier[7]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "f_anyext", 8) != 0)
          break;
        return 55;	 // "select_of_anyext"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "o_minmax", 8) != 0)
          break;
        return 190;	 // "select_to_minmax"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "ndef_cmp", 8) != 0)
          break;
        return 121;	 // "select_undef_cmp"
      }
      break;
    case 't':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_", 11) != 0)
        break;
      switch (RuleIdentifier[12]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 44;	 // "truncate_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 43;	 // "truncate_of_zext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ndef_to_fp_zero", 15) != 0)
        break;
      return 71;	 // "undef_to_fp_zero"
    }
    break;
  case 17:	 // 14 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'A':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "plusC", 5) != 0)
          break;
        return 6;	 // "APlusBMinusAplusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "PlusA", 5) != 0)
          break;
        return 7;	 // "APlusBMinusCPlusA"
      }
      break;
    case 'a':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "d_p2i_to_ptradd", 15) != 0)
          break;
        return 16;	 // "add_p2i_to_ptradd"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "yext_trunc_fold", 15) != 0)
          break;
        return 90;	 // "anyext_trunc_fold"
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nonicalize_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 110;	 // "canonicalize_fcmp"
        case 'i':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 109;	 // "canonicalize_icmp"
        }
        break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "nstant_fold_fma", 15) != 0)
          break;
        return 168;	 // "constant_fold_fma"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "iv_rem_to_divrem", 16) != 0)
        break;
      return 153;	 // "div_rem_to_divrem"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "rase_undef_store", 16) != 0)
        break;
      return 81;	 // "erase_undef_store"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_with_zero", 16) != 0)
        break;
      return 149;	 // "ptr_add_with_zero"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_to_iminmax", 15) != 0)
          break;
        return 123;	 // "select_to_iminmax"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ift_immed_chain", 15) != 0)
          break;
        return 150;	 // "shift_immed_chain"
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "def_to_int_zero", 15) != 0)
          break;
        return 72;	 // "undef_to_int_zero"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_pow2_to_mask", 15) != 0)
          break;
        return 128;	 // "urem_pow2_to_mask"
      }
      break;
    }
    break;
  case 18:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusBPlus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'B':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusC", 6) != 0)
          break;
        return 5;	 // "AMinusBPlusBMinusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusA", 6) != 0)
          break;
        return 4;	 // "AMinusBPlusCMinusA"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_to_zero", 17) != 0)
        break;
      return 86;	 // "binop_left_to_zero"
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_minmax_nan", 15) != 0)
          break;
        return 146;	 // "combine_minmax_nan"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_f", 12) != 0)
          break;
        switch (RuleIdentifier[15]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "bs", 2) != 0)
            break;
          return 135;	 // "constant_fold_fabs"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "eg", 2) != 0)
            break;
          return 134;	 // "constant_fold_fneg"
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xpand_const_fpowi", 17) != 0)
        break;
      return 147;	 // "expand_const_fpowi"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ptrunc_fpext_fold", 17) != 0)
        break;
      return 99;	 // "fptrunc_fpext_fold"
    case 's':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'e')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ect_of_truncate", 15) != 0)
          break;
        return 56;	 // "select_of_truncate"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "t_inreg_of_load", 15) != 0)
          break;
        return 118;	 // "sext_inreg_of_load"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_anyext", 17) != 0)
        break;
      return 45;	 // "truncate_of_anyext"
    }
    break;
  case 19:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_to_zero", 18) != 0)
        break;
      return 87;	 // "binop_right_to_zero"
    case 'c':	 // 4 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "onst", 4) != 0)
        break;
      switch (RuleIdentifier[5]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+6, "ptradd_to_i2p", 13) != 0)
          break;
        return 141;	 // "const_ptradd_to_i2p"
      case 'a':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+6, "nt_fold_", 8) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "inop", 4) != 0)
            break;
          return 166;	 // "constant_fold_binop"
        case 'f':	 // 2 strings to match.
          switch (RuleIdentifier[15]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "og2", 3) != 0)
              break;
            return 137;	 // "constant_fold_flog2"
          case 's':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "qrt", 3) != 0)
              break;
            return 136;	 // "constant_fold_fsqrt"
          }
          break;
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtend_through_phis", 18) != 0)
        break;
      return 102;	 // "extend_through_phis"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nteger_of_truncate", 18) != 0)
        break;
      return 64;	 // "integer_of_truncate"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_zero", 18) != 0)
        break;
      return 213;	 // "merge_of_x_and_zero"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_immed_chain", 18) != 0)
        break;
      return 108;	 // "ptr_add_immed_chain"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "assoc_comm_binops", 17) != 0)
          break;
        return 107;	 // "reassoc_comm_binops"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_zero", 17) != 0)
          break;
        return 84;	 // "right_identity_zero"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_constant_cmp", 17) != 0)
          break;
        return 122;	 // "select_constant_cmp"
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "mplify_", 7) != 0)
          break;
        switch (RuleIdentifier[9]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "dd_to_sub", 9) != 0)
            break;
          return 103;	 // "simplify_add_to_sub"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "eg_minmax", 9) != 0)
            break;
          return 196;	 // "simplify_neg_minmax"
        }
        break;
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nary_undef_to_zero", 18) != 0)
        break;
      return 76;	 // "unary_undef_to_zero"
    }
    break;
  case 20:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nd_or_disjoint_mask", 19) != 0)
        break;
      return 173;	 // "and_or_disjoint_mask"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itcast_bitcast_fold", 19) != 0)
        break;
      return 98;	 // "bitcast_bitcast_fold"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_undef", 19) != 0)
        break;
      return 212;	 // "merge_of_x_and_undef"
    case 'r':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "edu", 3) != 0)
        break;
      switch (RuleIdentifier[4]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "e_shl_of_extend", 15) != 0)
          break;
        return 119;	 // "reduce_shl_of_extend"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "dant_sext_inreg", 15) != 0)
          break;
        return 126;	 // "redundant_sext_inreg"
      }
      break;
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ry_undef_to_undef", 17) != 0)
          break;
        return 77;	 // "unary_undef_to_undef"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_zext_to_zext", 17) != 0)
          break;
        return 211;	 // "unmerge_zext_to_zext"
      }
      break;
    }
    break;
  case 21:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_concat_vector", 18) != 0)
          break;
        return 197;	 // "combine_concat_vector"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_", 11) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ast_op", 6) != 0)
            break;
          return 169;	 // "constant_fold_cast_op"
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ptrunc", 6) != 0)
            break;
          return 138;	 // "constant_fold_fptrunc"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_vector_elt_oob", 20) != 0)
        break;
      return 24;	 // "insert_vector_elt_oob"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_fp", 20) != 0)
        break;
      return 93;	 // "right_identity_one_fp"
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ef_to_negative_one", 18) != 0)
          break;
        return 73;	 // "undef_to_negative_one"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_dead_to_trunc", 18) != 0)
          break;
        return 210;	 // "unmerge_dead_to_trunc"
      }
      break;
    }
    break;
  case 22:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_shuffle_concat", 19) != 0)
          break;
        return 201;	 // "combine_shuffle_concat"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_fp_binop", 19) != 0)
          break;
        return 167;	 // "constant_fold_fp_binop"
      }
      break;
    case 'f':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ld_binop_into_select", 20) != 0)
          break;
        return 182;	 // "fold_binop_into_select"
      case 'u':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nnel_shift_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "eft_zero", 8) != 0)
            break;
          return 157;	 // "funnel_shift_left_zero"
        case 'o':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "vershift", 8) != 0)
            break;
          return 158;	 // "funnel_shift_overshift"
        case 't':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "o_rotate", 8) != 0)
            break;
          return 155;	 // "funnel_shift_to_rotate"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_lhs_known_bits", 21) != 0)
        break;
      return 112;	 // "icmp_to_lhs_known_bits"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_subo_no_overflow", 21) != 0)
        break;
      return 215;	 // "match_subo_no_overflow"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_any_op", 21) != 0)
        break;
      return 78;	 // "propagate_undef_any_op"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "dundant_neg_operands", 20) != 0)
          break;
        return 172;	 // "redundant_neg_operands"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_one_int", 20) != 0)
          break;
        return 92;	 // "right_identity_one_int"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hl_ashr_to_sext_inreg", 21) != 0)
        break;
      return 116;	 // "shl_ashr_to_sext_inreg"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_buildvector_fold", 21) != 0)
        break;
      return 96;	 // "trunc_buildvector_fold"
    }
    break;
  case 23:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "uildvector_of_truncate", 22) != 0)
        break;
      return 57;	 // "buildvector_of_truncate"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_right_zero", 22) != 0)
        break;
      return 156;	 // "funnel_shift_right_zero"
    case 'i':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "tof_const_zero_fold_", 20) != 0)
        break;
      switch (RuleIdentifier[21]) {
      default: break;
      case 's':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 139;	 // "itof_const_zero_fold_si"
      case 'u':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 140;	 // "itof_const_zero_fold_ui"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_all_ops", 22) != 0)
        break;
      return 79;	 // "propagate_undef_all_ops"
    }
    break;
  case 24:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_undef_to_zero", 23) != 0)
        break;
      return 74;	 // "binop_left_undef_to_zero"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element", 23) != 0)
        break;
      return 23;	 // "match_extract_of_element"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_feeding_and", 23) != 0)
        break;
      return 120;	 // "narrow_binop_feeding_and"
    case 's':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_inreg_", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "f_sext_inreg", 12) != 0)
          break;
        return 53;	 // "sext_inreg_of_sext_inreg"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "o_zext_inreg", 12) != 0)
          break;
        return 130;	 // "sext_inreg_to_zext_inreg"
      }
      break;
    case 'x':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "or_of_and_with_same_reg", 23) != 0)
        break;
      return 148;	 // "xor_of_and_with_same_reg"
    }
    break;
  case 25:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "tfield_extract_from_", 20) != 0)
          break;
        switch (RuleIdentifier[22]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "nd", 2) != 0)
            break;
          return 163;	 // "bitfield_extract_from_and"
        case 's':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "hr", 2) != 0)
            break;
          return 164;	 // "bitfield_extract_from_shr"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ildvector_identity_fold", 23) != 0)
          break;
        return 95;	 // "buildvector_identity_fold"
      }
      break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_shuffle_undef_rhs", 24) != 0)
        break;
      return 202;	 // "combine_shuffle_undef_rhs"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vec_elt_build_vec", 24) != 0)
        break;
      return 66;	 // "extract_vec_elt_build_vec"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eg_and_one_to_sext_inreg", 24) != 0)
        break;
      return 117;	 // "neg_and_one_to_sext_inreg"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_one_fp", 24) != 0)
        break;
      return 101;	 // "right_identity_neg_one_fp"
    }
    break;
  case 26:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_undef_to_undef", 25) != 0)
        break;
      return 75;	 // "binop_right_undef_to_undef"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_fp_constant_to_rhs", 25) != 0)
        break;
      return 193;	 // "commute_fp_constant_to_rhs"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_from_or_shift", 25) != 0)
        break;
      return 154;	 // "funnel_shift_from_or_shift"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp", 25) != 0)
        break;
      return 100;	 // "right_identity_neg_zero_fp"
    }
    break;
  case 27:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "om", 2) != 0)
        break;
      switch (RuleIdentifier[3]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ine_use_vector_truncate", 23) != 0)
          break;
        return 204;	 // "combine_use_vector_truncate"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ute_int_constant_to_rhs", 23) != 0)
          break;
        return 192;	 // "commute_int_constant_to_rhs"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_or_combine", 26) != 0)
        break;
      return 114;	 // "double_icmp_zero_or_combine"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_binop_in_equality", 26) != 0)
        break;
      return 115;	 // "redundant_binop_in_equality"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_lshr_buildvector_fold", 26) != 0)
        break;
      return 97;	 // "trunc_lshr_buildvector_fold"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_anyext_build_vector", 26) != 0)
        break;
      return 205;	 // "unmerge_anyext_build_vector"
    }
    break;
  case 28:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_and_combine", 27) != 0)
        break;
      return 113;	 // "double_icmp_zero_and_combine"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "pt_brcond_by_inverting_cond", 27) != 0)
        break;
      return 133;	 // "opt_brcond_by_inverting_cond"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_shuffle_mask", 27) != 0)
        break;
      return 80;	 // "propagate_undef_shuffle_mask"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hift_of_shifted_logic_chain", 27) != 0)
        break;
      return 151;	 // "shift_of_shifted_logic_chain"
    }
    break;
  case 29:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_shr_and", 28) != 0)
        break;
      return 165;	 // "bitfield_extract_from_shr_and"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "xtracted_vector_load", 20) != 0)
          break;
        return 70;	 // "combine_extracted_vector_load"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "huffle_disjoint_mask", 20) != 0)
          break;
        return 203;	 // "combine_shuffle_disjoint_mask"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_true_false_known_bits", 28) != 0)
        break;
      return 111;	 // "icmp_to_true_false_known_bits"
    }
    break;
  case 30:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "freeze_of_non_undef_non_poison", 30) != 0)
      break;
    return 41;	 // "freeze_of_non_undef_non_poison"
  case 31:	 // 2 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_", 22) != 0)
      break;
    switch (RuleIdentifier[22]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "lt_undef", 8) != 0)
        break;
      return 22;	 // "insert_vector_element_elt_undef"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "dx_undef", 8) != 0)
        break;
      return 21;	 // "insert_vector_element_idx_undef"
    }
    break;
  case 32:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_sext_inreg", 31) != 0)
        break;
      return 162;	 // "bitfield_extract_from_sext_inreg"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_f", 8) != 0)
        break;
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 174;	 // "combine_fadd_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 178;	 // "combine_fsub_fmul_to_fmad_or_fma"
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_not_const", 31) != 0)
        break;
      return 25;	 // "extract_vector_element_not_const"
    }
    break;
  case 34:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fmul_with_select_to_fldexp", 33) != 0)
        break;
      return 216;	 // "combine_fmul_with_select_to_fldexp"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_all_elts_from_build_vector", 33) != 0)
        break;
      return 67;	 // "extract_all_elts_from_build_vector"
    }
    break;
  case 35:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_build_vector", 35) != 0)
      break;
    return 27;	 // "extract_vector_element_build_vector"
  case 36:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'f':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "add_fma_fmul_to_fmad_or_fma", 27) != 0)
          break;
        return 176;	 // "combine_fadd_fma_fmul_to_fmad_or_fma"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "nsert_vec_elts_build_vector", 27) != 0)
          break;
        return 65;	 // "combine_insert_vec_elts_build_vector"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_extract_vec_elt_out_of_bounds", 35) != 0)
        break;
      return 82;	 // "insert_extract_vec_elt_out_of_bounds"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_index", 35) != 0)
        break;
      return 20;	 // "match_extract_of_element_undef_index"
    }
    break;
  case 37:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fsub_fneg_fmul_to_fmad_or_fma", 36) != 0)
        break;
      return 179;	 // "combine_fsub_fneg_fmul_to_fmad_or_fma"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_shuffle_vector", 36) != 0)
        break;
      return 35;	 // "extract_vector_element_shuffle_vector"
    case 'h':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oist_logic_op_with_same_opcode_hands", 36) != 0)
        break;
      return 104;	 // "hoist_logic_op_with_same_opcode_hands"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_vector", 36) != 0)
        break;
      return 19;	 // "match_extract_of_element_undef_vector"
    }
    break;
  case 38:	 // 3 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "combine_", 8) != 0)
      break;
    switch (RuleIdentifier[8]) {
    default: break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fpext_fmul_to_fmad_or_fma", 28) != 0)
          break;
        return 175;	 // "combine_fadd_fpext_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fpext_fmul_to_fmad_or_fma", 28) != 0)
          break;
        return 180;	 // "combine_fsub_fpext_fmul_to_fmad_or_fma"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+9, "huffle_vector_to_build_vector", 29) != 0)
        break;
      return 219;	 // "combine_shuffle_vector_to_build_vector"
    }
    break;
  case 40:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_different_indices", 40) != 0)
      break;
    return 26;	 // "extract_vector_element_different_indices"
  case 42:	 // 8 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fadd_fpext_fma_fmul_to_fmad_or_fma", 41) != 0)
        break;
      return 177;	 // "combine_fadd_fpext_fma_fmul_to_fmad_or_fma"
    case 'e':	 // 7 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_build_vector_trunc", 40) != 0)
        break;
      switch (RuleIdentifier[41]) {
      default: break;
      case '2':	 // 1 string to match.
        return 28;	 // "extract_vector_element_build_vector_trunc2"
      case '3':	 // 1 string to match.
        return 29;	 // "extract_vector_element_build_vector_trunc3"
      case '4':	 // 1 string to match.
        return 30;	 // "extract_vector_element_build_vector_trunc4"
      case '5':	 // 1 string to match.
        return 31;	 // "extract_vector_element_build_vector_trunc5"
      case '6':	 // 1 string to match.
        return 32;	 // "extract_vector_element_build_vector_trunc6"
      case '7':	 // 1 string to match.
        return 33;	 // "extract_vector_element_build_vector_trunc7"
      case '8':	 // 1 string to match.
        return 34;	 // "extract_vector_element_build_vector_trunc8"
      }
      break;
    }
    break;
  case 43:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "combine_fsub_fpext_fneg_fmul_to_fmad_or_fma", 43) != 0)
      break;
    return 181;	 // "combine_fsub_fpext_fneg_fmul_to_fmad_or_fma"
  case 44:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_extract_vector_element", 44) != 0)
      break;
    return 36;	 // "insert_vector_element_extract_vector_element"
  case 46:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "push_freeze_to_prevent_poison_from_propagating", 46) != 0)
      break;
    return 42;	 // "push_freeze_to_prevent_poison_from_propagating"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 220}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool AMDGPUPreLegalizerCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool AMDGPUPreLegalizerCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> AMDGPUPreLegalizerCombinerOption;
static cl::list<std::string> AMDGPUPreLegalizerCombinerDisableOption(
    "amdgpuprelegalizercombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the AMDGPUPreLegalizerCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      AMDGPUPreLegalizerCombinerOption.push_back(Str);
    }));
static cl::list<std::string> AMDGPUPreLegalizerCombinerOnlyEnableOption(
    "amdgpuprelegalizercombiner-only-enable-rule",
    cl::desc("Disable all rules in the AMDGPUPreLegalizerCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      AMDGPUPreLegalizerCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        AMDGPUPreLegalizerCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool AMDGPUPreLegalizerCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool AMDGPUPreLegalizerCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : AMDGPUPreLegalizerCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUPreLegalizerCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUPreLegalizerCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUPreLegalizerCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUPreLegalizerCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s1,
};
const static size_t NumTypeObjects = 1;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset AMDGPUPreLegalizerCombinerImpl::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void AMDGPUPreLegalizerCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUPreLegalizerCombinerImpl::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

AMDGPUPreLegalizerCombinerImpl::ComplexMatcherMemFn
AMDGPUPreLegalizerCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
  GICXXPred_MI_Predicate_GICombiner3,
  GICXXPred_MI_Predicate_GICombiner4,
  GICXXPred_MI_Predicate_GICombiner5,
  GICXXPred_MI_Predicate_GICombiner6,
  GICXXPred_MI_Predicate_GICombiner7,
  GICXXPred_MI_Predicate_GICombiner8,
  GICXXPred_MI_Predicate_GICombiner9,
};
bool AMDGPUPreLegalizerCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return isGuaranteedNotToBeUndefOrPoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner3: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner4: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner5: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_EQ &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner6: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_NE &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner7: {
    return MRI.hasOneNonDBGUse(State.MIs[0]->getOperand(2).getReg()) &&
                    Helper.isLegalOrBeforeLegalizer(
                      {TargetOpcode::G_SEXT_INREG, {MRI.getType(State.MIs[1]->getOperand(1).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner8: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_LSHR,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner9: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_SHL,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
  GICXXPred_Simple_IsRule24Enabled,
  GICXXPred_Simple_IsRule25Enabled,
  GICXXPred_Simple_IsRule26Enabled,
  GICXXPred_Simple_IsRule27Enabled,
  GICXXPred_Simple_IsRule28Enabled,
  GICXXPred_Simple_IsRule29Enabled,
  GICXXPred_Simple_IsRule30Enabled,
  GICXXPred_Simple_IsRule31Enabled,
  GICXXPred_Simple_IsRule32Enabled,
  GICXXPred_Simple_IsRule33Enabled,
  GICXXPred_Simple_IsRule34Enabled,
  GICXXPred_Simple_IsRule35Enabled,
  GICXXPred_Simple_IsRule36Enabled,
  GICXXPred_Simple_IsRule37Enabled,
  GICXXPred_Simple_IsRule38Enabled,
  GICXXPred_Simple_IsRule39Enabled,
  GICXXPred_Simple_IsRule40Enabled,
  GICXXPred_Simple_IsRule41Enabled,
  GICXXPred_Simple_IsRule42Enabled,
  GICXXPred_Simple_IsRule43Enabled,
  GICXXPred_Simple_IsRule44Enabled,
  GICXXPred_Simple_IsRule45Enabled,
  GICXXPred_Simple_IsRule46Enabled,
  GICXXPred_Simple_IsRule47Enabled,
  GICXXPred_Simple_IsRule48Enabled,
  GICXXPred_Simple_IsRule49Enabled,
  GICXXPred_Simple_IsRule50Enabled,
  GICXXPred_Simple_IsRule51Enabled,
  GICXXPred_Simple_IsRule52Enabled,
  GICXXPred_Simple_IsRule53Enabled,
  GICXXPred_Simple_IsRule54Enabled,
  GICXXPred_Simple_IsRule55Enabled,
  GICXXPred_Simple_IsRule56Enabled,
  GICXXPred_Simple_IsRule57Enabled,
  GICXXPred_Simple_IsRule58Enabled,
  GICXXPred_Simple_IsRule59Enabled,
  GICXXPred_Simple_IsRule60Enabled,
  GICXXPred_Simple_IsRule61Enabled,
  GICXXPred_Simple_IsRule62Enabled,
  GICXXPred_Simple_IsRule63Enabled,
  GICXXPred_Simple_IsRule64Enabled,
  GICXXPred_Simple_IsRule65Enabled,
  GICXXPred_Simple_IsRule66Enabled,
  GICXXPred_Simple_IsRule67Enabled,
  GICXXPred_Simple_IsRule68Enabled,
  GICXXPred_Simple_IsRule69Enabled,
  GICXXPred_Simple_IsRule70Enabled,
  GICXXPred_Simple_IsRule71Enabled,
  GICXXPred_Simple_IsRule72Enabled,
  GICXXPred_Simple_IsRule73Enabled,
  GICXXPred_Simple_IsRule74Enabled,
  GICXXPred_Simple_IsRule75Enabled,
  GICXXPred_Simple_IsRule76Enabled,
  GICXXPred_Simple_IsRule77Enabled,
  GICXXPred_Simple_IsRule78Enabled,
  GICXXPred_Simple_IsRule79Enabled,
  GICXXPred_Simple_IsRule80Enabled,
  GICXXPred_Simple_IsRule81Enabled,
  GICXXPred_Simple_IsRule82Enabled,
  GICXXPred_Simple_IsRule83Enabled,
  GICXXPred_Simple_IsRule84Enabled,
  GICXXPred_Simple_IsRule85Enabled,
  GICXXPred_Simple_IsRule86Enabled,
  GICXXPred_Simple_IsRule87Enabled,
  GICXXPred_Simple_IsRule88Enabled,
  GICXXPred_Simple_IsRule89Enabled,
  GICXXPred_Simple_IsRule90Enabled,
  GICXXPred_Simple_IsRule91Enabled,
  GICXXPred_Simple_IsRule92Enabled,
  GICXXPred_Simple_IsRule93Enabled,
  GICXXPred_Simple_IsRule94Enabled,
  GICXXPred_Simple_IsRule95Enabled,
  GICXXPred_Simple_IsRule96Enabled,
  GICXXPred_Simple_IsRule97Enabled,
  GICXXPred_Simple_IsRule98Enabled,
  GICXXPred_Simple_IsRule99Enabled,
  GICXXPred_Simple_IsRule100Enabled,
  GICXXPred_Simple_IsRule101Enabled,
  GICXXPred_Simple_IsRule102Enabled,
  GICXXPred_Simple_IsRule103Enabled,
  GICXXPred_Simple_IsRule104Enabled,
  GICXXPred_Simple_IsRule105Enabled,
  GICXXPred_Simple_IsRule106Enabled,
  GICXXPred_Simple_IsRule107Enabled,
  GICXXPred_Simple_IsRule108Enabled,
  GICXXPred_Simple_IsRule109Enabled,
  GICXXPred_Simple_IsRule110Enabled,
  GICXXPred_Simple_IsRule111Enabled,
  GICXXPred_Simple_IsRule112Enabled,
  GICXXPred_Simple_IsRule113Enabled,
  GICXXPred_Simple_IsRule114Enabled,
  GICXXPred_Simple_IsRule115Enabled,
  GICXXPred_Simple_IsRule116Enabled,
  GICXXPred_Simple_IsRule117Enabled,
  GICXXPred_Simple_IsRule118Enabled,
  GICXXPred_Simple_IsRule119Enabled,
  GICXXPred_Simple_IsRule120Enabled,
  GICXXPred_Simple_IsRule121Enabled,
  GICXXPred_Simple_IsRule122Enabled,
  GICXXPred_Simple_IsRule123Enabled,
  GICXXPred_Simple_IsRule124Enabled,
  GICXXPred_Simple_IsRule125Enabled,
  GICXXPred_Simple_IsRule126Enabled,
  GICXXPred_Simple_IsRule127Enabled,
  GICXXPred_Simple_IsRule128Enabled,
  GICXXPred_Simple_IsRule129Enabled,
  GICXXPred_Simple_IsRule130Enabled,
  GICXXPred_Simple_IsRule131Enabled,
  GICXXPred_Simple_IsRule132Enabled,
  GICXXPred_Simple_IsRule133Enabled,
  GICXXPred_Simple_IsRule134Enabled,
  GICXXPred_Simple_IsRule135Enabled,
  GICXXPred_Simple_IsRule136Enabled,
  GICXXPred_Simple_IsRule137Enabled,
  GICXXPred_Simple_IsRule138Enabled,
  GICXXPred_Simple_IsRule139Enabled,
  GICXXPred_Simple_IsRule140Enabled,
  GICXXPred_Simple_IsRule141Enabled,
  GICXXPred_Simple_IsRule142Enabled,
  GICXXPred_Simple_IsRule143Enabled,
  GICXXPred_Simple_IsRule144Enabled,
  GICXXPred_Simple_IsRule145Enabled,
  GICXXPred_Simple_IsRule146Enabled,
  GICXXPred_Simple_IsRule147Enabled,
  GICXXPred_Simple_IsRule148Enabled,
  GICXXPred_Simple_IsRule149Enabled,
  GICXXPred_Simple_IsRule150Enabled,
  GICXXPred_Simple_IsRule151Enabled,
  GICXXPred_Simple_IsRule152Enabled,
  GICXXPred_Simple_IsRule153Enabled,
  GICXXPred_Simple_IsRule154Enabled,
  GICXXPred_Simple_IsRule155Enabled,
  GICXXPred_Simple_IsRule156Enabled,
  GICXXPred_Simple_IsRule157Enabled,
  GICXXPred_Simple_IsRule158Enabled,
  GICXXPred_Simple_IsRule159Enabled,
  GICXXPred_Simple_IsRule160Enabled,
  GICXXPred_Simple_IsRule161Enabled,
  GICXXPred_Simple_IsRule162Enabled,
  GICXXPred_Simple_IsRule163Enabled,
  GICXXPred_Simple_IsRule164Enabled,
  GICXXPred_Simple_IsRule165Enabled,
  GICXXPred_Simple_IsRule166Enabled,
  GICXXPred_Simple_IsRule167Enabled,
  GICXXPred_Simple_IsRule168Enabled,
  GICXXPred_Simple_IsRule169Enabled,
  GICXXPred_Simple_IsRule170Enabled,
  GICXXPred_Simple_IsRule171Enabled,
  GICXXPred_Simple_IsRule172Enabled,
  GICXXPred_Simple_IsRule173Enabled,
  GICXXPred_Simple_IsRule174Enabled,
  GICXXPred_Simple_IsRule175Enabled,
  GICXXPred_Simple_IsRule176Enabled,
  GICXXPred_Simple_IsRule177Enabled,
  GICXXPred_Simple_IsRule178Enabled,
  GICXXPred_Simple_IsRule179Enabled,
  GICXXPred_Simple_IsRule180Enabled,
  GICXXPred_Simple_IsRule181Enabled,
  GICXXPred_Simple_IsRule182Enabled,
  GICXXPred_Simple_IsRule183Enabled,
  GICXXPred_Simple_IsRule184Enabled,
  GICXXPred_Simple_IsRule185Enabled,
  GICXXPred_Simple_IsRule186Enabled,
  GICXXPred_Simple_IsRule187Enabled,
  GICXXPred_Simple_IsRule188Enabled,
  GICXXPred_Simple_IsRule189Enabled,
  GICXXPred_Simple_IsRule190Enabled,
  GICXXPred_Simple_IsRule191Enabled,
  GICXXPred_Simple_IsRule192Enabled,
  GICXXPred_Simple_IsRule193Enabled,
  GICXXPred_Simple_IsRule194Enabled,
  GICXXPred_Simple_IsRule195Enabled,
  GICXXPred_Simple_IsRule196Enabled,
  GICXXPred_Simple_IsRule197Enabled,
  GICXXPred_Simple_IsRule198Enabled,
  GICXXPred_Simple_IsRule199Enabled,
  GICXXPred_Simple_IsRule200Enabled,
  GICXXPred_Simple_IsRule201Enabled,
  GICXXPred_Simple_IsRule202Enabled,
  GICXXPred_Simple_IsRule203Enabled,
  GICXXPred_Simple_IsRule204Enabled,
  GICXXPred_Simple_IsRule205Enabled,
  GICXXPred_Simple_IsRule206Enabled,
  GICXXPred_Simple_IsRule207Enabled,
  GICXXPred_Simple_IsRule208Enabled,
  GICXXPred_Simple_IsRule209Enabled,
  GICXXPred_Simple_IsRule210Enabled,
  GICXXPred_Simple_IsRule211Enabled,
  GICXXPred_Simple_IsRule212Enabled,
  GICXXPred_Simple_IsRule213Enabled,
  GICXXPred_Simple_IsRule214Enabled,
  GICXXPred_Simple_IsRule215Enabled,
  GICXXPred_Simple_IsRule216Enabled,
  GICXXPred_Simple_IsRule217Enabled,
  GICXXPred_Simple_IsRule218Enabled,
  GICXXPred_Simple_IsRule219Enabled,
};

bool AMDGPUPreLegalizerCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
AMDGPUPreLegalizerCombinerImpl::CustomRendererFn
AMDGPUPreLegalizerCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool AMDGPUPreLegalizerCombinerImpl::tryCombineAllImpl(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
  GICXXCustomAction_GICombiner17,
  GICXXCustomAction_GICombiner18,
  GICXXCustomAction_GICombiner19,
  GICXXCustomAction_GICombiner20,
  GICXXCustomAction_GICombiner21,
  GICXXCustomAction_GICombiner22,
  GICXXCustomAction_GICombiner23,
  GICXXCustomAction_GICombiner24,
  GICXXCustomAction_GICombiner25,
  GICXXCustomAction_GICombiner26,
  GICXXCustomAction_GICombiner27,
  GICXXCustomAction_GICombiner28,
  GICXXCustomAction_GICombiner29,
  GICXXCustomAction_GICombiner30,
  GICXXCustomAction_GICombiner31,
  GICXXCustomAction_GICombiner32,
  GICXXCustomAction_GICombiner33,
  GICXXCustomAction_GICombiner34,
  GICXXCustomAction_GICombiner35,
  GICXXCustomAction_GICombiner36,
  GICXXCustomAction_GICombiner37,
  GICXXCustomAction_GICombiner38,
  GICXXCustomAction_GICombiner39,
  GICXXCustomAction_GICombiner40,
  GICXXCustomAction_GICombiner41,
  GICXXCustomAction_GICombiner42,
  GICXXCustomAction_GICombiner43,
  GICXXCustomAction_GICombiner44,
  GICXXCustomAction_GICombiner45,
  GICXXCustomAction_GICombiner46,
  GICXXCustomAction_GICombiner47,
  GICXXCustomAction_GICombiner48,
  GICXXCustomAction_GICombiner49,
  GICXXCustomAction_GICombiner50,
  GICXXCustomAction_GICombiner51,
  GICXXCustomAction_GICombiner52,
  GICXXCustomAction_GICombiner53,
  GICXXCustomAction_GICombiner54,
  GICXXCustomAction_GICombiner55,
  GICXXCustomAction_GICombiner56,
  GICXXCustomAction_GICombiner57,
  GICXXCustomAction_GICombiner58,
  GICXXCustomAction_GICombiner59,
  GICXXCustomAction_GICombiner60,
  GICXXCustomAction_GICombiner61,
  GICXXCustomAction_GICombiner62,
  GICXXCustomAction_GICombiner63,
  GICXXCustomAction_GICombiner64,
  GICXXCustomAction_GICombiner65,
  GICXXCustomAction_GICombiner66,
  GICXXCustomAction_GICombiner67,
  GICXXCustomAction_GICombiner68,
  GICXXCustomAction_GICombiner69,
  GICXXCustomAction_GICombiner70,
  GICXXCustomAction_GICombiner71,
  GICXXCustomAction_GICombiner72,
  GICXXCustomAction_GICombiner73,
  GICXXCustomAction_GICombiner74,
  GICXXCustomAction_GICombiner75,
  GICXXCustomAction_GICombiner76,
  GICXXCustomAction_GICombiner77,
  GICXXCustomAction_GICombiner78,
  GICXXCustomAction_GICombiner79,
  GICXXCustomAction_GICombiner80,
  GICXXCustomAction_GICombiner81,
  GICXXCustomAction_GICombiner82,
  GICXXCustomAction_GICombiner83,
  GICXXCustomAction_GICombiner84,
  GICXXCustomAction_GICombiner85,
  GICXXCustomAction_GICombiner86,
  GICXXCustomAction_GICombiner87,
  GICXXCustomAction_GICombiner88,
  GICXXCustomAction_GICombiner89,
  GICXXCustomAction_GICombiner90,
  GICXXCustomAction_GICombiner91,
  GICXXCustomAction_GICombiner92,
  GICXXCustomAction_GICombiner93,
  GICXXCustomAction_GICombiner94,
  GICXXCustomAction_GICombiner95,
  GICXXCustomAction_GICombiner96,
  GICXXCustomAction_GICombiner97,
  GICXXCustomAction_GICombiner98,
  GICXXCustomAction_GICombiner99,
  GICXXCustomAction_GICombiner100,
  GICXXCustomAction_GICombiner101,
  GICXXCustomAction_GICombiner102,
  GICXXCustomAction_GICombiner103,
  GICXXCustomAction_GICombiner104,
  GICXXCustomAction_GICombiner105,
  GICXXCustomAction_GICombiner106,
  GICXXCustomAction_GICombiner107,
  GICXXCustomAction_GICombiner108,
  GICXXCustomAction_GICombiner109,
  GICXXCustomAction_GICombiner110,
  GICXXCustomAction_GICombiner111,
  GICXXCustomAction_GICombiner112,
  GICXXCustomAction_GICombiner113,
  GICXXCustomAction_GICombiner114,
  GICXXCustomAction_GICombiner115,
  GICXXCustomAction_GICombiner116,
  GICXXCustomAction_GICombiner117,
  GICXXCustomAction_GICombiner118,
  GICXXCustomAction_GICombiner119,
  GICXXCustomAction_GICombiner120,
  GICXXCustomAction_GICombiner121,
  GICXXCustomAction_GICombiner122,
  GICXXCustomAction_GICombiner123,
  GICXXCustomAction_GICombiner124,
  GICXXCustomAction_GICombiner125,
  GICXXCustomAction_GICombiner126,
  GICXXCustomAction_GICombiner127,
  GICXXCustomAction_GICombiner128,
  GICXXCustomAction_GICombiner129,
  GICXXCustomAction_GICombiner130,
  GICXXCustomAction_GICombiner131,
  GICXXCustomAction_GICombiner132,
  GICXXCustomAction_GICombiner133,
  GICXXCustomAction_GICombiner134,
  GICXXCustomAction_GICombiner135,
  GICXXCustomAction_GICombiner136,
  GICXXCustomAction_GICombiner137,
  GICXXCustomAction_GICombiner138,
  GICXXCustomAction_GICombiner139,
  GICXXCustomAction_GICombiner140,
  GICXXCustomAction_GICombiner141,
  GICXXCustomAction_GICombiner142,
  GICXXCustomAction_GICombiner143,
  GICXXCustomAction_GICombiner144,
  GICXXCustomAction_GICombiner145,
  GICXXCustomAction_GICombiner146,
  GICXXCustomAction_GICombiner147,
  GICXXCustomAction_GICombiner148,
  GICXXCustomAction_GICombiner149,
  GICXXCustomAction_GICombiner150,
  GICXXCustomAction_GICombiner151,
  GICXXCustomAction_GICombiner152,
  GICXXCustomAction_GICombiner153,
  GICXXCustomAction_GICombiner154,
};
bool AMDGPUPreLegalizerCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAPlusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC2MinusAPlusC1(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC1Minus2MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1PlusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    // Match Patterns
    if(![&](){return Helper.matchCombineCopy(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineCopy(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineSubToAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    std::pair<Register, bool> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElement(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchInsertVectorElementOOB(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithDifferentIndices(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVectorTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithShuffleVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner17:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShlOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner18:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner19:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return !isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI) && Helper.matchFreezeOfSingleMaybePoisonOperand(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner20:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncateOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner21:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner22:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantSextInReg(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner23:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfSelect(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner24:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfBuildVector(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner25:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinop(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner26:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfInteger(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner27:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineInsertVecElts(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineInsertVecElts(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner28:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner29:{
    SmallVector<std::pair<Register, MachineInstr*>> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner30:{
    PreferredTuple GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner31:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineLoadWithAndMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner32:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtractedVectorLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner33:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner34:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner35:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], -1);
    return true;
  }
  case GICXXCustomAction_GICombiner36:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner37:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner38:{
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]->getOperand(0).getParent());
    return true;
  }
  case GICXXCustomAction_GICombiner39:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner40:{
    // Match Patterns
    if(![&](){return Helper.matchAllExplicitUsesAreUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner41:{
    // Match Patterns
    if(![&](){return Helper.matchUndefShuffleVectorMask(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner42:{
    // Match Patterns
    if(![&](){return Helper.matchUndefStore(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.eraseInst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner43:{
    // Match Patterns
    if(![&](){return Helper.matchInsertExtractVecEltOutOfBounds(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner44:{
    // Match Patterns
    if(![&](){return Helper.matchSelectSameVal(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 2);
    return true;
  }
  case GICXXCustomAction_GICombiner45:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsZero(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner46:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineI2PToP2I(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineI2PToP2I(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner47:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){GIMatchData_info = State.MIs[1]->getOperand(1).getReg(); return true;}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineP2IToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner48:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineAnyExtTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner49:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchBuildVectorIdentityFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner50:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner51:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncLshrBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner52:{
    // Match Patterns
    if(![&](){return MRI.getType(State.MIs[1]->getOperand(1).getReg()) == MRI.getType(State.MIs[0]->getOperand(0).getReg());}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], State.MIs[1]->getOperand(1).getReg());
    return true;
  }
  case GICXXCustomAction_GICombiner53:{
    MachineInstr* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner54:{
    std::tuple<Register, Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyAddToSub(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyAddToSub(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner55:{
    InstructionStepsMatchInfo GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchHoistLogicOpWithSameOpcodeHands(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildInstructionSteps(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner56:{
    std::optional<int64_t> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftsTooBig(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    if (GIMatchData_matchinfo) {
              Helper.replaceInstWithConstant(*State.MIs[0], *GIMatchData_matchinfo);
            } else {
              Helper.replaceInstWithUndef(*State.MIs[0]);
            }
    return true;
  }
  case GICXXCustomAction_GICombiner57:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocPtrAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner58:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocCommBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner59:{
    PtrAddChain GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner60:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeICmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner61:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeFCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner62:{
    int64_t GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchICmpToTrueFalseKnownBits(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner63:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchICmpToLHSKnownBits(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner64:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchRedundantBinOpInEquality(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner65:{
    std::tuple<Register, int64_t> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAshrShlToSextInreg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyAshShlToSextInreg(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner66:{
    std::tuple<Register, unsigned> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner67:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner68:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinopFeedingAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner69:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantSelectCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner70:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSelectIMinMax(State.MIs[0]->getOperand(0), GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner71:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSelect(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner72:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner73:{
    // Match Patterns
    if(![&](){return Helper.matchRedundantSExtInReg(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner74:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner75:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsKnownToBeAPowerOfTwo(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyURemByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner76:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineZextTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner77:{
    // Match Patterns
    if(![&](){unsigned BitWidth = MRI.getType(State.MIs[0]->getOperand(1).getReg()).getScalarSizeInBits();
                return Helper.getValueTracking()->maskedValueIsZero(State.MIs[0]->getOperand(1).getReg(),
                         APInt::getOneBitSet(BitWidth, State.MIs[0]->getOperand(2).getImm() - 1));}()) {
      return false;
    }
    // Apply Patterns
    Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
              Helper.getBuilder().buildZExtInReg(State.MIs[0]->getOperand(0), State.MIs[0]->getOperand(1), State.MIs[0]->getOperand(2).getImm());
              State.MIs[0]->eraseFromParent();
    return true;
  }
  case GICXXCustomAction_GICombiner78:{
    std::pair<MachineInstr*, LLT> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner79:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchNotCmp(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyNotCmp(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner80:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner81:{
    // Apply Patterns
    Helper.applyCombineConstantFoldFpUnary(*State.MIs[0], State.MIs[1]->getOperand(1).getFPImm());
    return true;
  }
  case GICXXCustomAction_GICombiner82:{
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0]->getOperand(0).getParent(), 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner83:{
    APInt GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner84:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOverlappingAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner85:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner86:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy0(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner87:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddEToAddO(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner88:{
    unsigned GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFMinMaxNaN(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner89:{
    // Match Patterns
    if(![&](){return Helper.matchFPowIExpansion(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExpandFPowI(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());
    return true;
  }
  case GICXXCustomAction_GICombiner90:{
    std::pair<Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner91:{
    // Match Patterns
    if(![&](){return Helper.matchPtrAddZero(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddZero(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner92:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner93:{
    ShiftOfShiftedLogic GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner94:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchLoadOrCombine(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner95:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner96:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOrShiftToFunnelShift(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner97:{
    // Match Patterns
    if(![&](){return Helper.matchFunnelShiftToRotate(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftToRotate(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner98:{
    // Match Patterns
    if(![&](){return Helper.matchConstantLargerBitWidth(*State.MIs[0], 3);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftConstantModulo(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner99:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCommuteShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner100:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromSExtInReg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner101:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner102:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShr(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner103:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShrAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner104:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner105:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFPBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner106:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFMA(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner107:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldCastOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner108:{
    // Match Patterns
    if(![&](){return Helper.matchUMulHToLShr(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUMulHToLShr(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner109:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantNegOperands(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner110:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAndOrDisjointMask(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner111:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner112:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner113:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMAFMulToFMadOrFMA(*State.MIs[0],
                                                                     GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner114:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMAAggressive(
                                                          *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner115:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner116:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFNegFMulToFMadOrFMA(*State.MIs[0],
                                                                      GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner117:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner118:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFNegFMulToFMadOrFMA(
                                                    *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner119:{
    unsigned GIMatchData_select_op_no;
    // Match Patterns
    if(![&](){return Helper.matchFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);
    return true;
  }
  case GICXXCustomAction_GICombiner120:{
    // Match Patterns
    if(![&](){return Helper.matchUDivOrURemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivOrURemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner121:{
    // Match Patterns
    if(![&](){return Helper.matchSDivOrSRemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivOrSRemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner122:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/false);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner123:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/true);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner124:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubAddSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner125:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifySelectToMinMax(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner126:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner127:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner128:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteFPConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner129:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner130:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner131:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyNegMinMax(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner132:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner133:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner134:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchZextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner135:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNonNegZext(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner136:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner137:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleUndefRHS(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner138:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleDisjointMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner139:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner140:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUnmergeValuesAnyExtBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner141:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner142:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMergeUnmerge(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner143:{
    SmallVector<APInt, 8> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner144:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeUndef(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner145:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner146:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeZExtToZExt(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeZExtToZExt(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner147:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndUndef(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner148:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndZero(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner149:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOverflow(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner150:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSuboCarryOut(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner151:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineFmulWithSelectToFldexp(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner152:{
    ClampI64ToI16MatchInfo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchClampI64ToI16(*State.MIs[0], MRI, MF, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyClampI64ToI16(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner153:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldableFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldableFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner154:{
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleToBuildVector(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleToBuildVector(*State.MIs[0]);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUPreLegalizerCombinerImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(20), GIMT_Encode2(268), /*)*//*default:*//*Label 95*/ GIMT_Encode4(7111),
     /*   10 */ /*TargetOpcode::COPY*//*Label 0*/ GIMT_Encode4(1002), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  142 */ /*TargetOpcode::G_ADD*//*Label 1*/ GIMT_Encode4(1014),
     /*  146 */ /*TargetOpcode::G_SUB*//*Label 2*/ GIMT_Encode4(1571),
     /*  150 */ /*TargetOpcode::G_MUL*//*Label 3*/ GIMT_Encode4(1889),
     /*  154 */ /*TargetOpcode::G_SDIV*//*Label 4*/ GIMT_Encode4(2055),
     /*  158 */ /*TargetOpcode::G_UDIV*//*Label 5*/ GIMT_Encode4(2128),
     /*  162 */ /*TargetOpcode::G_SREM*//*Label 6*/ GIMT_Encode4(2212),
     /*  166 */ /*TargetOpcode::G_UREM*//*Label 7*/ GIMT_Encode4(2268), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  178 */ /*TargetOpcode::G_AND*//*Label 8*/ GIMT_Encode4(2346),
     /*  182 */ /*TargetOpcode::G_OR*//*Label 9*/ GIMT_Encode4(2627),
     /*  186 */ /*TargetOpcode::G_XOR*//*Label 10*/ GIMT_Encode4(2872), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  202 */ /*TargetOpcode::G_PHI*//*Label 11*/ GIMT_Encode4(2973), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  226 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 12*/ GIMT_Encode4(2985), GIMT_Encode4(0),
     /*  234 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 13*/ GIMT_Encode4(3052),
     /*  238 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 14*/ GIMT_Encode4(3126),
     /*  242 */ /*TargetOpcode::G_BUILD_VECTOR_TRUNC*//*Label 15*/ GIMT_Encode4(3174),
     /*  246 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 16*/ GIMT_Encode4(3186),
     /*  250 */ /*TargetOpcode::G_PTRTOINT*//*Label 17*/ GIMT_Encode4(3198),
     /*  254 */ /*TargetOpcode::G_INTTOPTR*//*Label 18*/ GIMT_Encode4(3241),
     /*  258 */ /*TargetOpcode::G_BITCAST*//*Label 19*/ GIMT_Encode4(3274),
     /*  262 */ /*TargetOpcode::G_FREEZE*//*Label 20*/ GIMT_Encode4(3317), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  302 */ /*TargetOpcode::G_LOAD*//*Label 21*/ GIMT_Encode4(3381),
     /*  306 */ /*TargetOpcode::G_SEXTLOAD*//*Label 22*/ GIMT_Encode4(3393),
     /*  310 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 23*/ GIMT_Encode4(3405), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  326 */ /*TargetOpcode::G_STORE*//*Label 24*/ GIMT_Encode4(3417), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  462 */ /*TargetOpcode::G_ANYEXT*//*Label 25*/ GIMT_Encode4(3429),
     /*  466 */ /*TargetOpcode::G_TRUNC*//*Label 26*/ GIMT_Encode4(3557), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  498 */ /*TargetOpcode::G_SEXT*//*Label 27*/ GIMT_Encode4(3926),
     /*  502 */ /*TargetOpcode::G_SEXT_INREG*//*Label 28*/ GIMT_Encode4(4001),
     /*  506 */ /*TargetOpcode::G_ZEXT*//*Label 29*/ GIMT_Encode4(4067),
     /*  510 */ /*TargetOpcode::G_SHL*//*Label 30*/ GIMT_Encode4(4197),
     /*  514 */ /*TargetOpcode::G_LSHR*//*Label 31*/ GIMT_Encode4(4366),
     /*  518 */ /*TargetOpcode::G_ASHR*//*Label 32*/ GIMT_Encode4(4489),
     /*  522 */ /*TargetOpcode::G_FSHL*//*Label 33*/ GIMT_Encode4(4623),
     /*  526 */ /*TargetOpcode::G_FSHR*//*Label 34*/ GIMT_Encode4(4666),
     /*  530 */ /*TargetOpcode::G_ROTR*//*Label 35*/ GIMT_Encode4(4709),
     /*  534 */ /*TargetOpcode::G_ROTL*//*Label 36*/ GIMT_Encode4(4733),
     /*  538 */ /*TargetOpcode::G_ICMP*//*Label 37*/ GIMT_Encode4(4757),
     /*  542 */ /*TargetOpcode::G_FCMP*//*Label 38*/ GIMT_Encode4(4802), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  554 */ /*TargetOpcode::G_SELECT*//*Label 39*/ GIMT_Encode4(4814),
     /*  558 */ /*TargetOpcode::G_UADDO*//*Label 40*/ GIMT_Encode4(4909),
     /*  562 */ /*TargetOpcode::G_UADDE*//*Label 41*/ GIMT_Encode4(4932),
     /*  566 */ /*TargetOpcode::G_USUBO*//*Label 42*/ GIMT_Encode4(4944),
     /*  570 */ /*TargetOpcode::G_USUBE*//*Label 43*/ GIMT_Encode4(4956),
     /*  574 */ /*TargetOpcode::G_SADDO*//*Label 44*/ GIMT_Encode4(4968),
     /*  578 */ /*TargetOpcode::G_SADDE*//*Label 45*/ GIMT_Encode4(4991),
     /*  582 */ /*TargetOpcode::G_SSUBO*//*Label 46*/ GIMT_Encode4(5003),
     /*  586 */ /*TargetOpcode::G_SSUBE*//*Label 47*/ GIMT_Encode4(5015),
     /*  590 */ /*TargetOpcode::G_UMULO*//*Label 48*/ GIMT_Encode4(5027),
     /*  594 */ /*TargetOpcode::G_SMULO*//*Label 49*/ GIMT_Encode4(5061),
     /*  598 */ /*TargetOpcode::G_UMULH*//*Label 50*/ GIMT_Encode4(5095),
     /*  602 */ /*TargetOpcode::G_SMULH*//*Label 51*/ GIMT_Encode4(5118),
     /*  606 */ /*TargetOpcode::G_UADDSAT*//*Label 52*/ GIMT_Encode4(5130),
     /*  610 */ /*TargetOpcode::G_SADDSAT*//*Label 53*/ GIMT_Encode4(5142), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  622 */ /*TargetOpcode::G_USHLSAT*//*Label 54*/ GIMT_Encode4(5154),
     /*  626 */ /*TargetOpcode::G_SSHLSAT*//*Label 55*/ GIMT_Encode4(5177),
     /*  630 */ /*TargetOpcode::G_SMULFIX*//*Label 56*/ GIMT_Encode4(5200),
     /*  634 */ /*TargetOpcode::G_UMULFIX*//*Label 57*/ GIMT_Encode4(5212),
     /*  638 */ /*TargetOpcode::G_SMULFIXSAT*//*Label 58*/ GIMT_Encode4(5224),
     /*  642 */ /*TargetOpcode::G_UMULFIXSAT*//*Label 59*/ GIMT_Encode4(5236), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  662 */ /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(5248),
     /*  666 */ /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(5360),
     /*  670 */ /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(5449),
     /*  674 */ /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(5558),
     /*  678 */ /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(5581),
     /*  682 */ /*TargetOpcode::G_FDIV*//*Label 65*/ GIMT_Encode4(5604),
     /*  686 */ /*TargetOpcode::G_FREM*//*Label 66*/ GIMT_Encode4(5638), GIMT_Encode4(0),
     /*  694 */ /*TargetOpcode::G_FPOWI*//*Label 67*/ GIMT_Encode4(5650), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  714 */ /*TargetOpcode::G_FLOG2*//*Label 68*/ GIMT_Encode4(5672), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  730 */ /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(5694), GIMT_Encode4(0),
     /*  738 */ /*TargetOpcode::G_FPTRUNC*//*Label 70*/ GIMT_Encode4(5756),
     /*  742 */ /*TargetOpcode::G_FPTOSI*//*Label 71*/ GIMT_Encode4(5799),
     /*  746 */ /*TargetOpcode::G_FPTOUI*//*Label 72*/ GIMT_Encode4(5821),
     /*  750 */ /*TargetOpcode::G_SITOFP*//*Label 73*/ GIMT_Encode4(5843),
     /*  754 */ /*TargetOpcode::G_UITOFP*//*Label 74*/ GIMT_Encode4(5870), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  766 */ /*TargetOpcode::G_FABS*//*Label 75*/ GIMT_Encode4(5897), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  778 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 76*/ GIMT_Encode4(5976),
     /*  782 */ /*TargetOpcode::G_FMINNUM*//*Label 77*/ GIMT_Encode4(6006),
     /*  786 */ /*TargetOpcode::G_FMAXNUM*//*Label 78*/ GIMT_Encode4(6040),
     /*  790 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 79*/ GIMT_Encode4(6074),
     /*  794 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 80*/ GIMT_Encode4(6086),
     /*  798 */ /*TargetOpcode::G_FMINIMUM*//*Label 81*/ GIMT_Encode4(6098),
     /*  802 */ /*TargetOpcode::G_FMAXIMUM*//*Label 82*/ GIMT_Encode4(6132), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  842 */ /*TargetOpcode::G_PTR_ADD*//*Label 83*/ GIMT_Encode4(6166), GIMT_Encode4(0),
     /*  850 */ /*TargetOpcode::G_SMIN*//*Label 84*/ GIMT_Encode4(6256),
     /*  854 */ /*TargetOpcode::G_SMAX*//*Label 85*/ GIMT_Encode4(6290),
     /*  858 */ /*TargetOpcode::G_UMIN*//*Label 86*/ GIMT_Encode4(6324),
     /*  862 */ /*TargetOpcode::G_UMAX*//*Label 87*/ GIMT_Encode4(6358),
     /*  866 */ /*TargetOpcode::G_ABS*//*Label 88*/ GIMT_Encode4(6392), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  878 */ /*TargetOpcode::G_BR*//*Label 89*/ GIMT_Encode4(6404), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  898 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 90*/ GIMT_Encode4(6416),
     /*  902 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 91*/ GIMT_Encode4(6546),
     /*  906 */ /*TargetOpcode::G_SHUFFLE_VECTOR*//*Label 92*/ GIMT_Encode4(6923), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  946 */ /*TargetOpcode::G_BITREVERSE*//*Label 93*/ GIMT_Encode4(7000), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  998 */ /*TargetOpcode::G_FSQRT*//*Label 94*/ GIMT_Encode4(7089),
     /* 1002 */ // Label 0: @1002
     /* 1002 */ GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1013), // Rule ID 13 //
     /* 1007 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /* 1010 */   // MIs[0] d
     /* 1010 */   // No operand predicates
     /* 1010 */   // MIs[0] s
     /* 1010 */   // No operand predicates
     /* 1010 */   // Combiner Rule #13: copy_prop
     /* 1010 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1013 */ // Label 96: @1013
     /* 1013 */ GIM_Reject,
     /* 1014 */ // Label 1: @1014
     /* 1014 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1025), // Rule ID 16 //
     /* 1019 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1022 */   // Combiner Rule #16: add_p2i_to_ptradd; wip_match_opcode 'G_ADD'
     /* 1022 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1025 */ // Label 97: @1025
     /* 1025 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1036), // Rule ID 94 //
     /* 1030 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1033 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_ADD'
     /* 1033 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1036 */ // Label 98: @1036
     /* 1036 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1047), // Rule ID 141 //
     /* 1041 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule103Enabled),
     /* 1044 */   // Combiner Rule #103: simplify_add_to_sub; wip_match_opcode 'G_ADD'
     /* 1044 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner54),
     /* 1047 */ // Label 99: @1047
     /* 1047 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1058), // Rule ID 231 //
     /* 1052 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 1055 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_ADD'
     /* 1055 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1058 */ // Label 100: @1058
     /* 1058 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1069), // Rule ID 275 //
     /* 1063 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 1066 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_ADD'
     /* 1066 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1069 */ // Label 101: @1069
     /* 1069 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1080), // Rule ID 310 //
     /* 1074 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 1077 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_ADD'
     /* 1077 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1080 */ // Label 102: @1080
     /* 1080 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1114), // Rule ID 0 //
     /* 1085 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /* 1088 */   // MIs[0] root
     /* 1088 */   // No operand predicates
     /* 1088 */   // MIs[0] sub
     /* 1088 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1092 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1096 */   // MIs[1] Operand 1
     /* 1096 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1100 */   // MIs[1] A
     /* 1100 */   // No operand predicates
     /* 1100 */   // MIs[0] B
     /* 1100 */   // No operand predicates
     /* 1100 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1102 */   // Combiner Rule #0: ZeroMinusAPlusB
     /* 1102 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1105 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1107 */   GIR_RootToRootCopy, /*OpIdx*/2, // B
     /* 1109 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // A
     /* 1113 */   GIR_EraseRootFromParent_Done,
     /* 1114 */ // Label 103: @1114
     /* 1114 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1151), // Rule ID 12 //
     /* 1119 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /* 1122 */   // MIs[0] root
     /* 1122 */   // No operand predicates
     /* 1122 */   // MIs[0] sub
     /* 1122 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1126 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1130 */   // MIs[1] A
     /* 1130 */   // No operand predicates
     /* 1130 */   // MIs[1] c1
     /* 1130 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1134 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1138 */   // MIs[2] imm1
     /* 1138 */   // No operand predicates
     /* 1138 */   // MIs[0] c2
     /* 1138 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1142 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1146 */   // MIs[3] imm2
     /* 1146 */   // No operand predicates
     /* 1146 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1148 */   // Combiner Rule #12: AMinusC1PlusC2
     /* 1148 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 1151 */ // Label 104: @1151
     /* 1151 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1185), // Rule ID 3 //
     /* 1156 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 1159 */   // MIs[0] root
     /* 1159 */   // No operand predicates
     /* 1159 */   // MIs[0] sub
     /* 1159 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1163 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1167 */   // MIs[1] B
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[1] A
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[0] A
     /* 1167 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1172 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1177 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1179 */   // Combiner Rule #3: BMinusAPlusA
     /* 1179 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1184 */   GIR_EraseRootFromParent_Done,
     /* 1185 */ // Label 105: @1185
     /* 1185 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1219), // Rule ID 131 //
     /* 1190 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1193 */   // MIs[0] dst
     /* 1193 */   // No operand predicates
     /* 1193 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1193 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1197 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1201 */   // MIs[1] src
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1201 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1206 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1211 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1213 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[1]]
     /* 1213 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1218 */   GIR_EraseRootFromParent_Done,
     /* 1219 */ // Label 106: @1219
     /* 1219 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1264), // Rule ID 5 //
     /* 1224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1227 */   // MIs[0] root
     /* 1227 */   // No operand predicates
     /* 1227 */   // MIs[0] sub1
     /* 1227 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1231 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1235 */   // MIs[1] A
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[1] B
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[0] sub2
     /* 1235 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1239 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1243 */   // MIs[2] B
     /* 1243 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1248 */   // MIs[2] C
     /* 1248 */   // No operand predicates
     /* 1248 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1250 */   // Combiner Rule #5: AMinusBPlusBMinusC
     /* 1250 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1253 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1255 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // A
     /* 1259 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1263 */   GIR_EraseRootFromParent_Done,
     /* 1264 */ // Label 107: @1264
     /* 1264 */ GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1309), // Rule ID 4 //
     /* 1269 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 1272 */   // MIs[0] root
     /* 1272 */   // No operand predicates
     /* 1272 */   // MIs[0] sub1
     /* 1272 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1276 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1280 */   // MIs[1] A
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[1] B
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[0] sub2
     /* 1280 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1284 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1288 */   // MIs[2] C
     /* 1288 */   // No operand predicates
     /* 1288 */   // MIs[2] A
     /* 1288 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 1293 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1295 */   // Combiner Rule #4: AMinusBPlusCMinusA
     /* 1295 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1298 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1300 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1304 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1308 */   GIR_EraseRootFromParent_Done,
     /* 1309 */ // Label 108: @1309
     /* 1309 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1344), // Rule ID 39 //
     /* 1314 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule37Enabled),
     /* 1317 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1323 */   // MIs[0] root
     /* 1323 */   // No operand predicates
     /* 1323 */   // MIs[0] left
     /* 1323 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1327 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1331 */   // MIs[1] imm1
     /* 1331 */   // No operand predicates
     /* 1331 */   // MIs[0] right
     /* 1331 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1335 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1339 */   // MIs[2] imm2
     /* 1339 */   // No operand predicates
     /* 1339 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1341 */   // Combiner Rule #37: add_of_vscale
     /* 1341 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1344 */ // Label 109: @1344
     /* 1344 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1378), // Rule ID 1 //
     /* 1349 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1352 */   // MIs[0] root
     /* 1352 */   // No operand predicates
     /* 1352 */   // MIs[0] A
     /* 1352 */   // No operand predicates
     /* 1352 */   // MIs[0] sub
     /* 1352 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1356 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1360 */   // MIs[1] Operand 1
     /* 1360 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1364 */   // MIs[1] B
     /* 1364 */   // No operand predicates
     /* 1364 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1366 */   // Combiner Rule #1: APlusZeroMinusB
     /* 1366 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1369 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1371 */   GIR_RootToRootCopy, /*OpIdx*/1, // A
     /* 1373 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1377 */   GIR_EraseRootFromParent_Done,
     /* 1378 */ // Label 110: @1378
     /* 1378 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1412), // Rule ID 2 //
     /* 1383 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 1386 */   // MIs[0] root
     /* 1386 */   // No operand predicates
     /* 1386 */   // MIs[0] A
     /* 1386 */   // No operand predicates
     /* 1386 */   // MIs[0] sub
     /* 1386 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1390 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1394 */   // MIs[1] B
     /* 1394 */   // No operand predicates
     /* 1394 */   // MIs[1] A
     /* 1394 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1399 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1404 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1406 */   // Combiner Rule #2: APlusBMinusB
     /* 1406 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1411 */   GIR_EraseRootFromParent_Done,
     /* 1412 */ // Label 111: @1412
     /* 1412 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1446), // Rule ID 130 //
     /* 1417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1420 */   // MIs[0] dst
     /* 1420 */   // No operand predicates
     /* 1420 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1420 */   // No operand predicates
     /* 1420 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1420 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1424 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1428 */   // MIs[1] src
     /* 1428 */   // No operand predicates
     /* 1428 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1428 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1433 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1438 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1440 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[0]]
     /* 1440 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1445 */   GIR_EraseRootFromParent_Done,
     /* 1446 */ // Label 112: @1446
     /* 1446 */ GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1491), // Rule ID 6 //
     /* 1451 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1454 */   // MIs[0] root
     /* 1454 */   // No operand predicates
     /* 1454 */   // MIs[0] A
     /* 1454 */   // No operand predicates
     /* 1454 */   // MIs[0] sub1
     /* 1454 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1458 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1462 */   // MIs[1] B
     /* 1462 */   // No operand predicates
     /* 1462 */   // MIs[1] add1
     /* 1462 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1466 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1470 */   // MIs[2] A
     /* 1470 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1475 */   // MIs[2] C
     /* 1475 */   // No operand predicates
     /* 1475 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1477 */   // Combiner Rule #6: APlusBMinusAplusC
     /* 1477 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1480 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1482 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1486 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1490 */   GIR_EraseRootFromParent_Done,
     /* 1491 */ // Label 113: @1491
     /* 1491 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1536), // Rule ID 7 //
     /* 1496 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1499 */   // MIs[0] root
     /* 1499 */   // No operand predicates
     /* 1499 */   // MIs[0] A
     /* 1499 */   // No operand predicates
     /* 1499 */   // MIs[0] sub1
     /* 1499 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1503 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1507 */   // MIs[1] B
     /* 1507 */   // No operand predicates
     /* 1507 */   // MIs[1] add1
     /* 1507 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1511 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1515 */   // MIs[2] C
     /* 1515 */   // No operand predicates
     /* 1515 */   // MIs[2] A
     /* 1515 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1520 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1522 */   // Combiner Rule #7: APlusBMinusCPlusA
     /* 1522 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1525 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1527 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1531 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1535 */   GIR_EraseRootFromParent_Done,
     /* 1536 */ // Label 114: @1536
     /* 1536 */ GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1559), // Rule ID 105 //
     /* 1541 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1544 */   // MIs[0] dst
     /* 1544 */   // No operand predicates
     /* 1544 */   // MIs[0] lhs
     /* 1544 */   // No operand predicates
     /* 1544 */   // MIs[0] Operand 2
     /* 1544 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1548 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1553 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[1]]
     /* 1553 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1558 */   GIR_EraseRootFromParent_Done,
     /* 1559 */ // Label 115: @1559
     /* 1559 */ GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1570), // Rule ID 149 //
     /* 1564 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule107Enabled),
     /* 1567 */   // MIs[0] root
     /* 1567 */   // No operand predicates
     /* 1567 */   // MIs[0] src1
     /* 1567 */   // No operand predicates
     /* 1567 */   // MIs[0] src2
     /* 1567 */   // No operand predicates
     /* 1567 */   // Combiner Rule #107: reassoc_comm_binops
     /* 1567 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1570 */ // Label 116: @1570
     /* 1570 */ GIM_Reject,
     /* 1571 */ // Label 2: @1571
     /* 1571 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1582), // Rule ID 95 //
     /* 1576 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1579 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_SUB'
     /* 1579 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1582 */ // Label 117: @1582
     /* 1582 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1593), // Rule ID 239 //
     /* 1587 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 1590 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SUB'
     /* 1590 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1593 */ // Label 118: @1593
     /* 1593 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1604), // Rule ID 276 //
     /* 1598 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 1601 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SUB'
     /* 1601 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1604 */ // Label 119: @1604
     /* 1604 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1615), // Rule ID 307 //
     /* 1609 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule189Enabled),
     /* 1612 */   // Combiner Rule #189: sub_add_reg; wip_match_opcode 'G_SUB'
     /* 1612 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner124),
     /* 1615 */ // Label 120: @1615
     /* 1615 */ GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1626), // Rule ID 341 //
     /* 1620 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 1623 */   // Combiner Rule #196: simplify_neg_minmax; wip_match_opcode 'G_SUB'
     /* 1623 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner131),
     /* 1626 */ // Label 121: @1626
     /* 1626 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1663), // Rule ID 8 //
     /* 1631 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /* 1634 */   // MIs[0] root
     /* 1634 */   // No operand predicates
     /* 1634 */   // MIs[0] add
     /* 1634 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1638 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1642 */   // MIs[1] A
     /* 1642 */   // No operand predicates
     /* 1642 */   // MIs[1] c1
     /* 1642 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1646 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1650 */   // MIs[2] imm1
     /* 1650 */   // No operand predicates
     /* 1650 */   // MIs[0] c2
     /* 1650 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1654 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1658 */   // MIs[3] imm2
     /* 1658 */   // No operand predicates
     /* 1658 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1660 */   // Combiner Rule #8: APlusC1MinusC2
     /* 1660 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /* 1663 */ // Label 122: @1663
     /* 1663 */ GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1700), // Rule ID 11 //
     /* 1668 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 1671 */   // MIs[0] root
     /* 1671 */   // No operand predicates
     /* 1671 */   // MIs[0] sub1
     /* 1671 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1675 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1679 */   // MIs[1] c1
     /* 1679 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 1683 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1687 */   // MIs[2] imm1
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[1] A
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[0] c2
     /* 1687 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1691 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1695 */   // MIs[3] imm2
     /* 1695 */   // No operand predicates
     /* 1695 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1697 */   // Combiner Rule #11: C1Minus2MinusC2
     /* 1697 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 1700 */ // Label 123: @1700
     /* 1700 */ GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1737), // Rule ID 10 //
     /* 1705 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 1708 */   // MIs[0] root
     /* 1708 */   // No operand predicates
     /* 1708 */   // MIs[0] sub1
     /* 1708 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1712 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1716 */   // MIs[1] A
     /* 1716 */   // No operand predicates
     /* 1716 */   // MIs[1] c1
     /* 1716 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1720 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1724 */   // MIs[2] imm1
     /* 1724 */   // No operand predicates
     /* 1724 */   // MIs[0] c2
     /* 1724 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1728 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1732 */   // MIs[3] imm2
     /* 1732 */   // No operand predicates
     /* 1732 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1734 */   // Combiner Rule #10: AMinusC1MinusC2
     /* 1734 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 1737 */ // Label 124: @1737
     /* 1737 */ GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1780), // Rule ID 159 //
     /* 1742 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule117Enabled),
     /* 1745 */   // MIs[0] dst
     /* 1745 */   // No operand predicates
     /* 1745 */   // MIs[0] Operand 1
     /* 1745 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 1749 */   // MIs[0] and
     /* 1749 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1753 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 1757 */   // MIs[1] x
     /* 1757 */   // No operand predicates
     /* 1757 */   // MIs[1] Operand 2
     /* 1757 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /* 1761 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner7),
     /* 1765 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1767 */   // Combiner Rule #117: neg_and_one_to_sext_inreg
     /* 1767 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 1770 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1772 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 1776 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /* 1779 */   GIR_EraseRootFromParent_Done,
     /* 1780 */ // Label 125: @1780
     /* 1780 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1817), // Rule ID 9 //
     /* 1785 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1788 */   // MIs[0] root
     /* 1788 */   // No operand predicates
     /* 1788 */   // MIs[0] c2
     /* 1788 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1792 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1796 */   // MIs[1] imm2
     /* 1796 */   // No operand predicates
     /* 1796 */   // MIs[0] add
     /* 1796 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1800 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1804 */   // MIs[2] A
     /* 1804 */   // No operand predicates
     /* 1804 */   // MIs[2] c1
     /* 1804 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 1808 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1812 */   // MIs[3] imm1
     /* 1812 */   // No operand predicates
     /* 1812 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1814 */   // Combiner Rule #9: C2MinusAPlusC1
     /* 1814 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1817 */ // Label 126: @1817
     /* 1817 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1844), // Rule ID 42 //
     /* 1822 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule40Enabled),
     /* 1825 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1831 */   // MIs[0] root
     /* 1831 */   // No operand predicates
     /* 1831 */   // MIs[0] x
     /* 1831 */   // No operand predicates
     /* 1831 */   // MIs[0] right
     /* 1831 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1835 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1839 */   // MIs[1] imm
     /* 1839 */   // No operand predicates
     /* 1839 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1841 */   // Combiner Rule #40: sub_of_vscale
     /* 1841 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner18),
     /* 1844 */ // Label 127: @1844
     /* 1844 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1867), // Rule ID 104 //
     /* 1849 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1852 */   // MIs[0] dst
     /* 1852 */   // No operand predicates
     /* 1852 */   // MIs[0] lhs
     /* 1852 */   // No operand predicates
     /* 1852 */   // MIs[0] Operand 2
     /* 1852 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1856 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1861 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[0]]
     /* 1861 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1866 */   GIR_EraseRootFromParent_Done,
     /* 1867 */ // Label 128: @1867
     /* 1867 */ GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1888), // Rule ID 15 //
     /* 1872 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 1875 */   // MIs[0] d
     /* 1875 */   // No operand predicates
     /* 1875 */   // MIs[0] op1
     /* 1875 */   // No operand predicates
     /* 1875 */   // MIs[0] c
     /* 1875 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1879 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1883 */   // MIs[1] imm
     /* 1883 */   // No operand predicates
     /* 1883 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1885 */   // Combiner Rule #15: sub_to_add
     /* 1885 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 1888 */ // Label 129: @1888
     /* 1888 */ GIM_Reject,
     /* 1889 */ // Label 3: @1889
     /* 1889 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1900), // Rule ID 78 //
     /* 1894 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 1897 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_MUL'
     /* 1897 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 1900 */ // Label 130: @1900
     /* 1900 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1911), // Rule ID 236 //
     /* 1905 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 1908 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_MUL'
     /* 1908 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1911 */ // Label 131: @1911
     /* 1911 */ GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1922), // Rule ID 311 //
     /* 1916 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 1919 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_MUL'
     /* 1919 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1922 */ // Label 132: @1922
     /* 1922 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1962), // Rule ID 17 //
     /* 1927 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 1930 */   // MIs[0] dst
     /* 1930 */   GIM_RecordRegType, /*MI*/0, /*Op*/0, /*TempTypeIdx*/255,
     /* 1934 */   // MIs[0] x
     /* 1934 */   // No operand predicates
     /* 1934 */   // MIs[0] Operand 2
     /* 1934 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /* 1938 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 1941 */   GIR_BuildConstant, /*TempRegID*/0, /*Val*/GIMT_Encode8(0),
     /* 1951 */   // Combiner Rule #17: mul_by_neg_one
     /* 1951 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1954 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1956 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1959 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 1961 */   GIR_EraseRootFromParent_Done,
     /* 1962 */ // Label 133: @1962
     /* 1962 */ GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1997), // Rule ID 40 //
     /* 1967 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule38Enabled),
     /* 1970 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1976 */   // MIs[0] root
     /* 1976 */   // No operand predicates
     /* 1976 */   // MIs[0] left
     /* 1976 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1980 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1984 */   // MIs[1] scale
     /* 1984 */   // No operand predicates
     /* 1984 */   // MIs[0] x
     /* 1984 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1988 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1992 */   // MIs[2] imm1
     /* 1992 */   // No operand predicates
     /* 1992 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1994 */   // Combiner Rule #38: mul_of_vscale
     /* 1994 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /* 1997 */ // Label 134: @1997
     /* 1997 */ GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2020), // Rule ID 123 //
     /* 2002 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2005 */   // MIs[0] dst
     /* 2005 */   // No operand predicates
     /* 2005 */   // MIs[0] lhs
     /* 2005 */   // No operand predicates
     /* 2005 */   // MIs[0] zero
     /* 2005 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2009 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2014 */   // Combiner Rule #87: binop_right_to_zero
     /* 2014 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2019 */   GIR_EraseRootFromParent_Done,
     /* 2020 */ // Label 135: @2020
     /* 2020 */ GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2043), // Rule ID 128 //
     /* 2025 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule92Enabled),
     /* 2028 */   // MIs[0] dst
     /* 2028 */   // No operand predicates
     /* 2028 */   // MIs[0] x
     /* 2028 */   // No operand predicates
     /* 2028 */   // MIs[0] Operand 2
     /* 2028 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /* 2032 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2037 */   // Combiner Rule #92: right_identity_one_int
     /* 2037 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2042 */   GIR_EraseRootFromParent_Done,
     /* 2043 */ // Label 136: @2043
     /* 2043 */ GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2054), // Rule ID 14 //
     /* 2048 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 2051 */   // MIs[0] d
     /* 2051 */   // No operand predicates
     /* 2051 */   // MIs[0] op1
     /* 2051 */   // No operand predicates
     /* 2051 */   // MIs[0] op2
     /* 2051 */   // No operand predicates
     /* 2051 */   // Combiner Rule #14: mul_to_shl
     /* 2051 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 2054 */ // Label 137: @2054
     /* 2054 */ GIM_Reject,
     /* 2055 */ // Label 4: @2055
     /* 2055 */ GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2066), // Rule ID 119 //
     /* 2060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2063 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SDIV'
     /* 2063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2066 */ // Label 138: @2066
     /* 2066 */ GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2077), // Rule ID 211 //
     /* 2071 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2074 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_SDIV'
     /* 2074 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2077 */ // Label 139: @2077
     /* 2077 */ GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2088), // Rule ID 242 //
     /* 2082 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2085 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SDIV'
     /* 2085 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2088 */ // Label 140: @2088
     /* 2088 */ GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2099), // Rule ID 281 //
     /* 2093 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2096 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SDIV'
     /* 2096 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2099 */ // Label 141: @2099
     /* 2099 */ GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2116), // Rule ID 304 //
     /* 2104 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule186Enabled),
     /* 2107 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2113 */   // MIs[0] dst
     /* 2113 */   // No operand predicates
     /* 2113 */   // MIs[0] x
     /* 2113 */   // No operand predicates
     /* 2113 */   // MIs[0] y
     /* 2113 */   // No operand predicates
     /* 2113 */   // Combiner Rule #186: sdiv_by_pow2
     /* 2113 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner123),
     /* 2116 */ // Label 142: @2116
     /* 2116 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2127), // Rule ID 306 //
     /* 2121 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule188Enabled),
     /* 2124 */   // MIs[0] dst
     /* 2124 */   // No operand predicates
     /* 2124 */   // MIs[0] x
     /* 2124 */   // No operand predicates
     /* 2124 */   // MIs[0] y
     /* 2124 */   // No operand predicates
     /* 2124 */   // Combiner Rule #188: sdiv_by_const
     /* 2124 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2127 */ // Label 143: @2127
     /* 2127 */ GIM_Reject,
     /* 2128 */ // Label 5: @2128
     /* 2128 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2139), // Rule ID 81 //
     /* 2133 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2136 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UDIV'
     /* 2136 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2139 */ // Label 144: @2139
     /* 2139 */ GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2150), // Rule ID 120 //
     /* 2144 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2147 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UDIV'
     /* 2147 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2150 */ // Label 145: @2150
     /* 2150 */ GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2161), // Rule ID 212 //
     /* 2155 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2158 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_UDIV'
     /* 2158 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2161 */ // Label 146: @2161
     /* 2161 */ GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2172), // Rule ID 241 //
     /* 2166 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2169 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UDIV'
     /* 2169 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2172 */ // Label 147: @2172
     /* 2172 */ GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2183), // Rule ID 283 //
     /* 2177 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2180 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UDIV'
     /* 2180 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2183 */ // Label 148: @2183
     /* 2183 */ GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2200), // Rule ID 303 //
     /* 2188 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2191 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2197 */   // MIs[0] dst
     /* 2197 */   // No operand predicates
     /* 2197 */   // MIs[0] x
     /* 2197 */   // No operand predicates
     /* 2197 */   // MIs[0] y
     /* 2197 */   // No operand predicates
     /* 2197 */   // Combiner Rule #185: udiv_by_pow2
     /* 2197 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner122),
     /* 2200 */ // Label 149: @2200
     /* 2200 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2211), // Rule ID 305 //
     /* 2205 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule187Enabled),
     /* 2208 */   // MIs[0] dst
     /* 2208 */   // No operand predicates
     /* 2208 */   // MIs[0] x
     /* 2208 */   // No operand predicates
     /* 2208 */   // MIs[0] y
     /* 2208 */   // No operand predicates
     /* 2208 */   // Combiner Rule #187: udiv_by_const
     /* 2208 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2211 */ // Label 150: @2211
     /* 2211 */ GIM_Reject,
     /* 2212 */ // Label 6: @2212
     /* 2212 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2223), // Rule ID 121 //
     /* 2217 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2220 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SREM'
     /* 2220 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2223 */ // Label 151: @2223
     /* 2223 */ GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2234), // Rule ID 213 //
     /* 2228 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2231 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_SREM'
     /* 2231 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2234 */ // Label 152: @2234
     /* 2234 */ GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2245), // Rule ID 244 //
     /* 2239 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2242 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SREM'
     /* 2242 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2245 */ // Label 153: @2245
     /* 2245 */ GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2256), // Rule ID 282 //
     /* 2250 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2253 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SREM'
     /* 2253 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2256 */ // Label 154: @2256
     /* 2256 */ GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2267), // Rule ID 302 //
     /* 2261 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule184Enabled),
     /* 2264 */   // MIs[0] dst
     /* 2264 */   // No operand predicates
     /* 2264 */   // MIs[0] x
     /* 2264 */   // No operand predicates
     /* 2264 */   // MIs[0] y
     /* 2264 */   // No operand predicates
     /* 2264 */   // Combiner Rule #184: srem_by_const
     /* 2264 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2267 */ // Label 155: @2267
     /* 2267 */ GIM_Reject,
     /* 2268 */ // Label 7: @2268
     /* 2268 */ GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(2279), // Rule ID 82 //
     /* 2273 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2276 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UREM'
     /* 2276 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2279 */ // Label 156: @2279
     /* 2279 */ GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(2290), // Rule ID 122 //
     /* 2284 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2287 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UREM'
     /* 2287 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2290 */ // Label 157: @2290
     /* 2290 */ GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2301), // Rule ID 170 //
     /* 2295 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule128Enabled),
     /* 2298 */   // Combiner Rule #128: urem_pow2_to_mask; wip_match_opcode 'G_UREM'
     /* 2298 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner75),
     /* 2301 */ // Label 158: @2301
     /* 2301 */ GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2312), // Rule ID 214 //
     /* 2306 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2309 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_UREM'
     /* 2309 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2312 */ // Label 159: @2312
     /* 2312 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2323), // Rule ID 243 //
     /* 2317 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2320 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UREM'
     /* 2320 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2323 */ // Label 160: @2323
     /* 2323 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2334), // Rule ID 284 //
     /* 2328 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2331 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UREM'
     /* 2331 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2334 */ // Label 161: @2334
     /* 2334 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2345), // Rule ID 301 //
     /* 2339 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule183Enabled),
     /* 2342 */   // MIs[0] dst
     /* 2342 */   // No operand predicates
     /* 2342 */   // MIs[0] x
     /* 2342 */   // No operand predicates
     /* 2342 */   // MIs[0] y
     /* 2342 */   // No operand predicates
     /* 2342 */   // Combiner Rule #183: urem_by_const
     /* 2342 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2345 */ // Label 162: @2345
     /* 2345 */ GIM_Reject,
     /* 2346 */ // Label 8: @2346
     /* 2346 */ GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2357), // Rule ID 73 //
     /* 2351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule69Enabled),
     /* 2354 */   // Combiner Rule #69: load_and_mask; wip_match_opcode 'G_AND'
     /* 2354 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner31),
     /* 2357 */ // Label 163: @2357
     /* 2357 */ GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2368), // Rule ID 77 //
     /* 2362 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 2365 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_AND'
     /* 2365 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 2368 */ // Label 164: @2368
     /* 2368 */ GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2379), // Rule ID 142 //
     /* 2373 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 2376 */   // Combiner Rule #104: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_AND'
     /* 2376 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2379 */ // Label 165: @2379
     /* 2379 */ GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2390), // Rule ID 162 //
     /* 2384 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule120Enabled),
     /* 2387 */   // Combiner Rule #120: narrow_binop_feeding_and; wip_match_opcode 'G_AND'
     /* 2387 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 2390 */ // Label 166: @2390
     /* 2390 */ GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2401), // Rule ID 167 //
     /* 2395 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule125Enabled),
     /* 2398 */   // Combiner Rule #125: redundant_and; wip_match_opcode 'G_AND'
     /* 2398 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner72),
     /* 2401 */ // Label 167: @2401
     /* 2401 */ GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2412), // Rule ID 184 //
     /* 2406 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule142Enabled),
     /* 2409 */   // Combiner Rule #142: overlapping_and; wip_match_opcode 'G_AND'
     /* 2409 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner84),
     /* 2412 */ // Label 168: @2412
     /* 2412 */ GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2423), // Rule ID 233 //
     /* 2417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2420 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_AND'
     /* 2420 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2423 */ // Label 169: @2423
     /* 2423 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2434), // Rule ID 266 //
     /* 2428 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule173Enabled),
     /* 2431 */   // Combiner Rule #173: and_or_disjoint_mask; wip_match_opcode 'G_AND'
     /* 2431 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner110),
     /* 2434 */ // Label 170: @2434
     /* 2434 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2445), // Rule ID 278 //
     /* 2439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2442 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_AND'
     /* 2442 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2445 */ // Label 171: @2445
     /* 2445 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2456), // Rule ID 312 //
     /* 2450 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 2453 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_AND'
     /* 2453 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2456 */ // Label 172: @2456
     /* 2456 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2467), // Rule ID 339 //
     /* 2461 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule194Enabled),
     /* 2464 */   // Combiner Rule #194: match_ands; wip_match_opcode 'G_AND'
     /* 2464 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner129),
     /* 2467 */ // Label 173: @2467
     /* 2467 */ GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2565), // Rule ID 155 //
     /* 2472 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule113Enabled),
     /* 2475 */   // MIs[0] root
     /* 2475 */   // No operand predicates
     /* 2475 */   // MIs[0] d1
     /* 2475 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2479 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2483 */   // MIs[1] p
     /* 2483 */   // No operand predicates
     /* 2483 */   // MIs[1] s1
     /* 2483 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/255,
     /* 2487 */   // MIs[1] Operand 3
     /* 2487 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2491 */   // MIs[0] d2
     /* 2491 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2495 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2499 */   // MIs[2] p
     /* 2499 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2504 */   // MIs[2] s2
     /* 2504 */   // No operand predicates
     /* 2504 */   // MIs[2] Operand 3
     /* 2504 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2508 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner5),
     /* 2512 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2514 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/255,
     /* 2517 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2527 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 2530 */   // Combiner Rule #113: double_icmp_zero_and_combine
     /* 2530 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 2533 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2538 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 2542 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 2546 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2550 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 2554 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 2558 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 2561 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 2564 */   GIR_EraseRootFromParent_Done,
     /* 2565 */ // Label 174: @2565
     /* 2565 */ GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2602), // Rule ID 226 //
     /* 2570 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule163Enabled),
     /* 2573 */   // MIs[0] root
     /* 2573 */   // No operand predicates
     /* 2573 */   // MIs[0] shift
     /* 2573 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2577 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2581 */   // MIs[1] x
     /* 2581 */   // No operand predicates
     /* 2581 */   // MIs[1] lsb
     /* 2581 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 2585 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2589 */   // MIs[2] imm1
     /* 2589 */   // No operand predicates
     /* 2589 */   // MIs[0] mask
     /* 2589 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 2593 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2597 */   // MIs[3] imm2
     /* 2597 */   // No operand predicates
     /* 2597 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 2599 */   // Combiner Rule #163: bitfield_extract_from_and
     /* 2599 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner101),
     /* 2602 */ // Label 175: @2602
     /* 2602 */ GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2626), // Rule ID 114 //
     /* 2607 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 2610 */   // MIs[0] dst
     /* 2610 */   // No operand predicates
     /* 2610 */   // MIs[0] src
     /* 2610 */   // No operand predicates
     /* 2610 */   // MIs[0] src
     /* 2610 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 2615 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2620 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[0]]
     /* 2620 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2625 */   GIR_EraseRootFromParent_Done,
     /* 2626 */ // Label 176: @2626
     /* 2626 */ GIM_Reject,
     /* 2627 */ // Label 9: @2627
     /* 2627 */ GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2638), // Rule ID 79 //
     /* 2632 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule73Enabled),
     /* 2635 */   // Combiner Rule #73: undef_to_negative_one; wip_match_opcode 'G_OR'
     /* 2635 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner35),
     /* 2638 */ // Label 177: @2638
     /* 2638 */ GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2649), // Rule ID 143 //
     /* 2643 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 2646 */   // Combiner Rule #104: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_OR'
     /* 2646 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2649 */ // Label 178: @2649
     /* 2649 */ GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2660), // Rule ID 169 //
     /* 2654 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule127Enabled),
     /* 2657 */   // Combiner Rule #127: redundant_or; wip_match_opcode 'G_OR'
     /* 2657 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner74),
     /* 2660 */ // Label 179: @2660
     /* 2660 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2671), // Rule ID 210 //
     /* 2665 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 2668 */   // Combiner Rule #152: load_or_combine; wip_match_opcode 'G_OR'
     /* 2668 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner94),
     /* 2671 */ // Label 180: @2671
     /* 2671 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2682), // Rule ID 215 //
     /* 2676 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2679 */   // Combiner Rule #154: funnel_shift_from_or_shift; wip_match_opcode 'G_OR'
     /* 2679 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner96),
     /* 2682 */ // Label 181: @2682
     /* 2682 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2693), // Rule ID 237 //
     /* 2687 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2690 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_OR'
     /* 2690 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2693 */ // Label 182: @2693
     /* 2693 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2704), // Rule ID 279 //
     /* 2698 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2701 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_OR'
     /* 2701 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2704 */ // Label 183: @2704
     /* 2704 */ GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2715), // Rule ID 313 //
     /* 2709 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 2712 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_OR'
     /* 2712 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2715 */ // Label 184: @2715
     /* 2715 */ GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(2726), // Rule ID 340 //
     /* 2720 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 2723 */   // Combiner Rule #195: match_ors; wip_match_opcode 'G_OR'
     /* 2723 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner130),
     /* 2726 */ // Label 185: @2726
     /* 2726 */ GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(2824), // Rule ID 156 //
     /* 2731 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule114Enabled),
     /* 2734 */   // MIs[0] root
     /* 2734 */   // No operand predicates
     /* 2734 */   // MIs[0] d1
     /* 2734 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2738 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2742 */   // MIs[1] p
     /* 2742 */   // No operand predicates
     /* 2742 */   // MIs[1] s1
     /* 2742 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/255,
     /* 2746 */   // MIs[1] Operand 3
     /* 2746 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2750 */   // MIs[0] d2
     /* 2750 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2754 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2758 */   // MIs[2] p
     /* 2758 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2763 */   // MIs[2] s2
     /* 2763 */   // No operand predicates
     /* 2763 */   // MIs[2] Operand 3
     /* 2763 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2767 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner6),
     /* 2771 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2773 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/255,
     /* 2776 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2786 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 2789 */   // Combiner Rule #114: double_icmp_zero_or_combine
     /* 2789 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 2792 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2797 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 2801 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 2805 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2809 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 2813 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 2817 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 2820 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 2823 */   GIR_EraseRootFromParent_Done,
     /* 2824 */ // Label 186: @2824
     /* 2824 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2848), // Rule ID 115 //
     /* 2829 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 2832 */   // MIs[0] dst
     /* 2832 */   // No operand predicates
     /* 2832 */   // MIs[0] src
     /* 2832 */   // No operand predicates
     /* 2832 */   // MIs[0] src
     /* 2832 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 2837 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2842 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[1]]
     /* 2842 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2847 */   GIR_EraseRootFromParent_Done,
     /* 2848 */ // Label 187: @2848
     /* 2848 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(2871), // Rule ID 106 //
     /* 2853 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 2856 */   // MIs[0] dst
     /* 2856 */   // No operand predicates
     /* 2856 */   // MIs[0] lhs
     /* 2856 */   // No operand predicates
     /* 2856 */   // MIs[0] Operand 2
     /* 2856 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2860 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2865 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[2]]
     /* 2865 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2870 */   GIR_EraseRootFromParent_Done,
     /* 2871 */ // Label 188: @2871
     /* 2871 */ GIM_Reject,
     /* 2872 */ // Label 10: @2872
     /* 2872 */ GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(2883), // Rule ID 96 //
     /* 2877 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 2880 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_XOR'
     /* 2880 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 2883 */ // Label 189: @2883
     /* 2883 */ GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(2894), // Rule ID 144 //
     /* 2888 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 2891 */   // Combiner Rule #104: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_XOR'
     /* 2891 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2894 */ // Label 190: @2894
     /* 2894 */ GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(2905), // Rule ID 174 //
     /* 2899 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule132Enabled),
     /* 2902 */   // Combiner Rule #132: not_cmp_fold; wip_match_opcode 'G_XOR'
     /* 2902 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner79),
     /* 2905 */ // Label 191: @2905
     /* 2905 */ GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(2916), // Rule ID 198 //
     /* 2910 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule148Enabled),
     /* 2913 */   // Combiner Rule #148: xor_of_and_with_same_reg; wip_match_opcode 'G_XOR'
     /* 2913 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner90),
     /* 2916 */ // Label 192: @2916
     /* 2916 */ GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(2927), // Rule ID 240 //
     /* 2921 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2924 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_XOR'
     /* 2924 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2927 */ // Label 193: @2927
     /* 2927 */ GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(2938), // Rule ID 280 //
     /* 2932 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2935 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_XOR'
     /* 2935 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2938 */ // Label 194: @2938
     /* 2938 */ GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(2949), // Rule ID 314 //
     /* 2943 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 2946 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_XOR'
     /* 2946 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2949 */ // Label 195: @2949
     /* 2949 */ GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(2972), // Rule ID 107 //
     /* 2954 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 2957 */   // MIs[0] dst
     /* 2957 */   // No operand predicates
     /* 2957 */   // MIs[0] lhs
     /* 2957 */   // No operand predicates
     /* 2957 */   // MIs[0] Operand 2
     /* 2957 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2961 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2966 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[3]]
     /* 2966 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2971 */   GIR_EraseRootFromParent_Done,
     /* 2972 */ // Label 196: @2972
     /* 2972 */ GIM_Reject,
     /* 2973 */ // Label 11: @2973
     /* 2973 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(2984), // Rule ID 140 //
     /* 2978 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule102Enabled),
     /* 2981 */   // Combiner Rule #102: extend_through_phis; wip_match_opcode 'G_PHI'
     /* 2981 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner53),
     /* 2984 */ // Label 197: @2984
     /* 2984 */ GIM_Reject,
     /* 2985 */ // Label 12: @2985
     /* 2985 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(2996), // Rule ID 350 //
     /* 2990 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule205Enabled),
     /* 2993 */   // Combiner Rule #205: unmerge_anyext_build_vector; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 2993 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner140),
     /* 2996 */ // Label 198: @2996
     /* 2996 */ GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3007), // Rule ID 351 //
     /* 3001 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule206Enabled),
     /* 3004 */   // Combiner Rule #206: unmerge_merge; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3004 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner141),
     /* 3007 */ // Label 199: @3007
     /* 3007 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3018), // Rule ID 353 //
     /* 3012 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule208Enabled),
     /* 3015 */   // Combiner Rule #208: unmerge_cst; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3015 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner143),
     /* 3018 */ // Label 200: @3018
     /* 3018 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3029), // Rule ID 354 //
     /* 3023 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule209Enabled),
     /* 3026 */   // Combiner Rule #209: unmerge_undef; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3026 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner144),
     /* 3029 */ // Label 201: @3029
     /* 3029 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3040), // Rule ID 355 //
     /* 3034 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule210Enabled),
     /* 3037 */   // Combiner Rule #210: unmerge_dead_to_trunc; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3037 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner145),
     /* 3040 */ // Label 202: @3040
     /* 3040 */ GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3051), // Rule ID 356 //
     /* 3045 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule211Enabled),
     /* 3048 */   // Combiner Rule #211: unmerge_zext_to_zext; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3048 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner146),
     /* 3051 */ // Label 203: @3051
     /* 3051 */ GIM_Reject,
     /* 3052 */ // Label 13: @3052
     /* 3052 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3063), // Rule ID 352 //
     /* 3057 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule207Enabled),
     /* 3060 */   // Combiner Rule #207: merge_unmerge; wip_match_opcode 'G_MERGE_VALUES'
     /* 3060 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner142),
     /* 3063 */ // Label 204: @3063
     /* 3063 */ GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(3125),
     /* 3068 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /* 3071 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(3092), // Rule ID 357 //
     /* 3076 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule212Enabled),
     /* 3079 */     // MIs[0] root
     /* 3079 */     // No operand predicates
     /* 3079 */     // MIs[0] x
     /* 3079 */     // No operand predicates
     /* 3079 */     // MIs[0] undef
     /* 3079 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3083 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3087 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3089 */     // Combiner Rule #212: merge_of_x_and_undef
     /* 3089 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner147),
     /* 3092 */   // Label 206: @3092
     /* 3092 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(3124), // Rule ID 358 //
     /* 3097 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule213Enabled),
     /* 3100 */     // MIs[0] root
     /* 3100 */     // No operand predicates
     /* 3100 */     // MIs[0] x
     /* 3100 */     // No operand predicates
     /* 3100 */     // MIs[0] zero
     /* 3100 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3104 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3108 */     // MIs[1] Operand 1
     /* 3108 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/1, GIMT_Encode8(0),
     /* 3119 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3121 */     // Combiner Rule #213: merge_of_x_and_zero
     /* 3121 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner148),
     /* 3124 */   // Label 207: @3124
     /* 3124 */   GIM_Reject,
     /* 3125 */ // Label 205: @3125
     /* 3125 */ GIM_Reject,
     /* 3126 */ // Label 14: @3126
     /* 3126 */ GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(3137), // Rule ID 69 //
     /* 3131 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule67Enabled),
     /* 3134 */   // Combiner Rule #67: extract_all_elts_from_build_vector; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3134 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner29),
     /* 3137 */ // Label 208: @3137
     /* 3137 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3148), // Rule ID 98 //
     /* 3142 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 3145 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3145 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3148 */ // Label 209: @3148
     /* 3148 */ GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3159), // Rule ID 133 //
     /* 3153 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3156 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3156 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3159 */ // Label 210: @3159
     /* 3159 */ GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3173), // Rule ID 349 //
     /* 3164 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule204Enabled),
     /* 3167 */   GIM_CheckNumOperandsGE, /*MI*/0, /*Expected*/2,
     /* 3170 */   // MIs[0] dst
     /* 3170 */   // No operand predicates
     /* 3170 */   // MIs[0] unused
     /* 3170 */   // No operand predicates
     /* 3170 */   // Combiner Rule #204: combine_use_vector_truncate
     /* 3170 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner139),
     /* 3173 */ // Label 211: @3173
     /* 3173 */ GIM_Reject,
     /* 3174 */ // Label 15: @3174
     /* 3174 */ GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3185), // Rule ID 132 //
     /* 3179 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3182 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR_TRUNC'
     /* 3182 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3185 */ // Label 212: @3185
     /* 3185 */ GIM_Reject,
     /* 3186 */ // Label 16: @3186
     /* 3186 */ GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(3197), // Rule ID 342 //
     /* 3191 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule197Enabled),
     /* 3194 */   // Combiner Rule #197: combine_concat_vector; wip_match_opcode 'G_CONCAT_VECTORS'
     /* 3194 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner132),
     /* 3197 */ // Label 213: @3197
     /* 3197 */ GIM_Reject,
     /* 3198 */ // Label 17: @3198
     /* 3198 */ GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3219), // Rule ID 125 //
     /* 3203 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule89Enabled),
     /* 3206 */   // MIs[0] dst
     /* 3206 */   // No operand predicates
     /* 3206 */   // MIs[0] t
     /* 3206 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3210 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTTOPTR),
     /* 3214 */   // MIs[1] ptr
     /* 3214 */   // No operand predicates
     /* 3214 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3216 */   // Combiner Rule #89: i2p_to_p2i
     /* 3216 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner47),
     /* 3219 */ // Label 214: @3219
     /* 3219 */ GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3240), // Rule ID 90 //
     /* 3224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3227 */   // MIs[0] dst
     /* 3227 */   // No operand predicates
     /* 3227 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3227 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3231 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3235 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3237 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[3]]
     /* 3237 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3240 */ // Label 215: @3240
     /* 3240 */ GIM_Reject,
     /* 3241 */ // Label 18: @3241
     /* 3241 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(3252), // Rule ID 124 //
     /* 3246 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3249 */   // Combiner Rule #88: p2i_to_i2p; wip_match_opcode 'G_INTTOPTR'
     /* 3249 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner46),
     /* 3252 */ // Label 216: @3252
     /* 3252 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3273), // Rule ID 91 //
     /* 3257 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3260 */   // MIs[0] dst
     /* 3260 */   // No operand predicates
     /* 3260 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3260 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3264 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3268 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3270 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[4]]
     /* 3270 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3273 */ // Label 217: @3273
     /* 3273 */ GIM_Reject,
     /* 3274 */ // Label 19: @3274
     /* 3274 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3295), // Rule ID 136 //
     /* 3279 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule98Enabled),
     /* 3282 */   // MIs[0] dst
     /* 3282 */   // No operand predicates
     /* 3282 */   // MIs[0] src1
     /* 3282 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3286 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /* 3290 */   // MIs[1] src0
     /* 3290 */   // No operand predicates
     /* 3290 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3292 */   // Combiner Rule #98: bitcast_bitcast_fold
     /* 3292 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 3295 */ // Label 218: @3295
     /* 3295 */ GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3316), // Rule ID 88 //
     /* 3300 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3303 */   // MIs[0] dst
     /* 3303 */   // No operand predicates
     /* 3303 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3303 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3307 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3311 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3313 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[1]]
     /* 3313 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3316 */ // Label 219: @3316
     /* 3316 */ GIM_Reject,
     /* 3317 */ // Label 20: @3317
     /* 3317 */ GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3346), // Rule ID 18 //
     /* 3322 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 3325 */   // MIs[0] dst
     /* 3325 */   // No operand predicates
     /* 3325 */   // MIs[0] src
     /* 3325 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3329 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREEZE),
     /* 3333 */   // MIs[1] __idempotent_prop_match_0.x
     /* 3333 */   // No operand predicates
     /* 3333 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3338 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3340 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[0]]
     /* 3340 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3345 */   GIR_EraseRootFromParent_Done,
     /* 3346 */ // Label 220: @3346
     /* 3346 */ GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3369), // Rule ID 43 //
     /* 3351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule41Enabled),
     /* 3354 */   // MIs[0] root
     /* 3354 */   // No operand predicates
     /* 3354 */   // MIs[0] src
     /* 3354 */   // No operand predicates
     /* 3354 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner1),
     /* 3358 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3363 */   // Combiner Rule #41: freeze_of_non_undef_non_poison
     /* 3363 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3368 */   GIR_EraseRootFromParent_Done,
     /* 3369 */ // Label 221: @3369
     /* 3369 */ GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3380), // Rule ID 44 //
     /* 3374 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule42Enabled),
     /* 3377 */   // MIs[0] dst
     /* 3377 */   // No operand predicates
     /* 3377 */   // MIs[0] src
     /* 3377 */   // No operand predicates
     /* 3377 */   // Combiner Rule #42: push_freeze_to_prevent_poison_from_propagating
     /* 3377 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner19),
     /* 3380 */ // Label 222: @3380
     /* 3380 */ GIM_Reject,
     /* 3381 */ // Label 21: @3381
     /* 3381 */ GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3392), // Rule ID 70 //
     /* 3386 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3389 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_LOAD'
     /* 3389 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3392 */ // Label 223: @3392
     /* 3392 */ GIM_Reject,
     /* 3393 */ // Label 22: @3393
     /* 3393 */ GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3404), // Rule ID 71 //
     /* 3398 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3401 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_SEXTLOAD'
     /* 3401 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3404 */ // Label 224: @3404
     /* 3404 */ GIM_Reject,
     /* 3405 */ // Label 23: @3405
     /* 3405 */ GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3416), // Rule ID 72 //
     /* 3410 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3413 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_ZEXTLOAD'
     /* 3413 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3416 */ // Label 225: @3416
     /* 3416 */ GIM_Reject,
     /* 3417 */ // Label 24: @3417
     /* 3417 */ GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3428), // Rule ID 100 //
     /* 3422 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule81Enabled),
     /* 3425 */   // Combiner Rule #81: erase_undef_store; wip_match_opcode 'G_STORE'
     /* 3425 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 3428 */ // Label 226: @3428
     /* 3428 */ GIM_Reject,
     /* 3429 */ // Label 25: @3429
     /* 3429 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3440), // Rule ID 126 //
     /* 3434 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule90Enabled),
     /* 3437 */   // Combiner Rule #90: anyext_trunc_fold; wip_match_opcode 'G_ANYEXT'
     /* 3437 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner48),
     /* 3440 */ // Label 227: @3440
     /* 3440 */ GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3451), // Rule ID 257 //
     /* 3445 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 3448 */   // Combiner Rule #169: constant_fold_cast_op; wip_match_opcode 'G_ANYEXT'
     /* 3448 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 3451 */ // Label 228: @3451
     /* 3451 */ GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(3472), // Rule ID 57 //
     /* 3456 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule55Enabled),
     /* 3459 */   // MIs[0] root
     /* 3459 */   // No operand predicates
     /* 3459 */   // MIs[0] select
     /* 3459 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3463 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 3467 */   // MIs[1] cond
     /* 3467 */   // No operand predicates
     /* 3467 */   // MIs[1] true
     /* 3467 */   // No operand predicates
     /* 3467 */   // MIs[1] false
     /* 3467 */   // No operand predicates
     /* 3467 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3469 */   // Combiner Rule #55: select_of_anyext
     /* 3469 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 3472 */ // Label 229: @3472
     /* 3472 */ GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3493), // Rule ID 52 //
     /* 3477 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule50Enabled),
     /* 3480 */   // MIs[0] root
     /* 3480 */   // No operand predicates
     /* 3480 */   // MIs[0] second
     /* 3480 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3484 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3488 */   // MIs[1] src
     /* 3488 */   // No operand predicates
     /* 3488 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3490 */   // Combiner Rule #50: anyext_of_anyext
     /* 3490 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3493 */ // Label 230: @3493
     /* 3493 */ GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(3514), // Rule ID 54 //
     /* 3498 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule52Enabled),
     /* 3501 */   // MIs[0] root
     /* 3501 */   // No operand predicates
     /* 3501 */   // MIs[0] second
     /* 3501 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3505 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3509 */   // MIs[1] src
     /* 3509 */   // No operand predicates
     /* 3509 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3511 */   // Combiner Rule #52: anyext_of_sext
     /* 3511 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3514 */ // Label 231: @3514
     /* 3514 */ GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(3535), // Rule ID 53 //
     /* 3519 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 3522 */   // MIs[0] root
     /* 3522 */   // No operand predicates
     /* 3522 */   // MIs[0] second
     /* 3522 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3526 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 3530 */   // MIs[1] src
     /* 3530 */   // No operand predicates
     /* 3530 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3532 */   // Combiner Rule #51: anyext_of_zext
     /* 3532 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3535 */ // Label 232: @3535
     /* 3535 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(3556), // Rule ID 89 //
     /* 3540 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3543 */   // MIs[0] dst
     /* 3543 */   // No operand predicates
     /* 3543 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3543 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3547 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3551 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3553 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[2]]
     /* 3553 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3556 */ // Label 233: @3556
     /* 3556 */ GIM_Reject,
     /* 3557 */ // Label 26: @3557
     /* 3557 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(3568), // Rule ID 134 //
     /* 3562 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule96Enabled),
     /* 3565 */   // Combiner Rule #96: trunc_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3565 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner50),
     /* 3568 */ // Label 234: @3568
     /* 3568 */ GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(3579), // Rule ID 135 //
     /* 3573 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule97Enabled),
     /* 3576 */   // Combiner Rule #97: trunc_lshr_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3576 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner51),
     /* 3579 */ // Label 235: @3579
     /* 3579 */ GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(3590), // Rule ID 173 //
     /* 3584 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule131Enabled),
     /* 3587 */   // Combiner Rule #131: trunc_shift; wip_match_opcode 'G_TRUNC'
     /* 3587 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner78),
     /* 3590 */ // Label 236: @3590
     /* 3590 */ GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(3601), // Rule ID 364 //
     /* 3595 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule217Enabled),
     /* 3598 */   // Combiner Rule #217: clamp_i64_to_i16; wip_match_opcode 'G_TRUNC'
     /* 3598 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner152),
     /* 3601 */ // Label 237: @3601
     /* 3601 */ GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(3622), // Rule ID 58 //
     /* 3606 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule56Enabled),
     /* 3609 */   // MIs[0] root
     /* 3609 */   // No operand predicates
     /* 3609 */   // MIs[0] select
     /* 3609 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3613 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 3617 */   // MIs[1] cond
     /* 3617 */   // No operand predicates
     /* 3617 */   // MIs[1] true
     /* 3617 */   // No operand predicates
     /* 3617 */   // MIs[1] false
     /* 3617 */   // No operand predicates
     /* 3617 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3619 */   // Combiner Rule #56: select_of_truncate
     /* 3619 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 3622 */ // Label 238: @3622
     /* 3622 */ GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(3651), // Rule ID 60 //
     /* 3627 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule58Enabled),
     /* 3630 */   // MIs[0] root
     /* 3630 */   // No operand predicates
     /* 3630 */   // MIs[0] binop
     /* 3630 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3634 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 3638 */   // MIs[1] x
     /* 3638 */   // No operand predicates
     /* 3638 */   // MIs[1] const
     /* 3638 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3642 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3646 */   // MIs[2] imm
     /* 3646 */   // No operand predicates
     /* 3646 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3648 */   // Combiner Rule #58: narrow_binop_add
     /* 3648 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3651 */ // Label 239: @3651
     /* 3651 */ GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(3680), // Rule ID 63 //
     /* 3656 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule61Enabled),
     /* 3659 */   // MIs[0] root
     /* 3659 */   // No operand predicates
     /* 3659 */   // MIs[0] binop
     /* 3659 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3663 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 3667 */   // MIs[1] x
     /* 3667 */   // No operand predicates
     /* 3667 */   // MIs[1] const
     /* 3667 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3671 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3675 */   // MIs[2] imm
     /* 3675 */   // No operand predicates
     /* 3675 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3677 */   // Combiner Rule #61: narrow_binop_and
     /* 3677 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3680 */ // Label 240: @3680
     /* 3680 */ GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(3709), // Rule ID 62 //
     /* 3685 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule60Enabled),
     /* 3688 */   // MIs[0] root
     /* 3688 */   // No operand predicates
     /* 3688 */   // MIs[0] binop
     /* 3688 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3692 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /* 3696 */   // MIs[1] x
     /* 3696 */   // No operand predicates
     /* 3696 */   // MIs[1] const
     /* 3696 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3700 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3704 */   // MIs[2] imm
     /* 3704 */   // No operand predicates
     /* 3704 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3706 */   // Combiner Rule #60: narrow_binop_mul
     /* 3706 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3709 */ // Label 241: @3709
     /* 3709 */ GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(3738), // Rule ID 64 //
     /* 3714 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule62Enabled),
     /* 3717 */   // MIs[0] root
     /* 3717 */   // No operand predicates
     /* 3717 */   // MIs[0] binop
     /* 3717 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3721 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /* 3725 */   // MIs[1] x
     /* 3725 */   // No operand predicates
     /* 3725 */   // MIs[1] const
     /* 3725 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3729 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3733 */   // MIs[2] imm
     /* 3733 */   // No operand predicates
     /* 3733 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3735 */   // Combiner Rule #62: narrow_binop_or
     /* 3735 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3738 */ // Label 242: @3738
     /* 3738 */ GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(3767), // Rule ID 61 //
     /* 3743 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule59Enabled),
     /* 3746 */   // MIs[0] root
     /* 3746 */   // No operand predicates
     /* 3746 */   // MIs[0] binop
     /* 3746 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3750 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 3754 */   // MIs[1] x
     /* 3754 */   // No operand predicates
     /* 3754 */   // MIs[1] const
     /* 3754 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3758 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3762 */   // MIs[2] imm
     /* 3762 */   // No operand predicates
     /* 3762 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3764 */   // Combiner Rule #59: narrow_binop_sub
     /* 3764 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3767 */ // Label 243: @3767
     /* 3767 */ GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(3796), // Rule ID 65 //
     /* 3772 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule63Enabled),
     /* 3775 */   // MIs[0] root
     /* 3775 */   // No operand predicates
     /* 3775 */   // MIs[0] binop
     /* 3775 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3779 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /* 3783 */   // MIs[1] x
     /* 3783 */   // No operand predicates
     /* 3783 */   // MIs[1] const
     /* 3783 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3787 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3791 */   // MIs[2] imm
     /* 3791 */   // No operand predicates
     /* 3791 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3793 */   // Combiner Rule #63: narrow_binop_xor
     /* 3793 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3796 */ // Label 244: @3796
     /* 3796 */ GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(3817), // Rule ID 47 //
     /* 3801 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule45Enabled),
     /* 3804 */   // MIs[0] root
     /* 3804 */   // No operand predicates
     /* 3804 */   // MIs[0] ext
     /* 3804 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3808 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3812 */   // MIs[1] src
     /* 3812 */   // No operand predicates
     /* 3812 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3814 */   // Combiner Rule #45: truncate_of_anyext
     /* 3814 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 3817 */ // Label 245: @3817
     /* 3817 */ GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(3841), // Rule ID 59 //
     /* 3822 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule57Enabled),
     /* 3825 */   // MIs[0] root
     /* 3825 */   // No operand predicates
     /* 3825 */   // MIs[0] bv
     /* 3825 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3829 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 3833 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 3836 */   // MIs[1] unused
     /* 3836 */   // No operand predicates
     /* 3836 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3838 */   // Combiner Rule #57: buildvector_of_truncate
     /* 3838 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner24),
     /* 3841 */ // Label 246: @3841
     /* 3841 */ GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(3862), // Rule ID 46 //
     /* 3846 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule44Enabled),
     /* 3849 */   // MIs[0] root
     /* 3849 */   // No operand predicates
     /* 3849 */   // MIs[0] ext
     /* 3849 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3853 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3857 */   // MIs[1] src
     /* 3857 */   // No operand predicates
     /* 3857 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3859 */   // Combiner Rule #44: truncate_of_sext
     /* 3859 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 3862 */ // Label 247: @3862
     /* 3862 */ GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(3883), // Rule ID 45 //
     /* 3867 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule43Enabled),
     /* 3870 */   // MIs[0] root
     /* 3870 */   // No operand predicates
     /* 3870 */   // MIs[0] ext
     /* 3870 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3874 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 3878 */   // MIs[1] src
     /* 3878 */   // No operand predicates
     /* 3878 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3880 */   // Combiner Rule #43: truncate_of_zext
     /* 3880 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 3883 */ // Label 248: @3883
     /* 3883 */ GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(3904), // Rule ID 87 //
     /* 3888 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3891 */   // MIs[0] dst
     /* 3891 */   // No operand predicates
     /* 3891 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3891 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3895 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3899 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3901 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[0]]
     /* 3901 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3904 */ // Label 249: @3904
     /* 3904 */ GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(3925), // Rule ID 66 //
     /* 3909 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule64Enabled),
     /* 3912 */   // MIs[0] root
     /* 3912 */   // No operand predicates
     /* 3912 */   // MIs[0] int
     /* 3912 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3916 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3920 */   // MIs[1] imm
     /* 3920 */   // No operand predicates
     /* 3920 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3922 */   // Combiner Rule #64: integer_of_truncate
     /* 3922 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner26),
     /* 3925 */ // Label 250: @3925
     /* 3925 */ GIM_Reject,
     /* 3926 */ // Label 27: @3926
     /* 3926 */ GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(3937), // Rule ID 256 //
     /* 3931 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 3934 */   // Combiner Rule #169: constant_fold_cast_op; wip_match_opcode 'G_SEXT'
     /* 3934 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 3937 */ // Label 251: @3937
     /* 3937 */ GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(3958), // Rule ID 51 //
     /* 3942 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 3945 */   // MIs[0] root
     /* 3945 */   // No operand predicates
     /* 3945 */   // MIs[0] second
     /* 3945 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3949 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3953 */   // MIs[1] src
     /* 3953 */   // No operand predicates
     /* 3953 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3955 */   // Combiner Rule #49: sext_of_anyext
     /* 3955 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3958 */ // Label 252: @3958
     /* 3958 */ GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(3979), // Rule ID 50 //
     /* 3963 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3966 */   // MIs[0] root
     /* 3966 */   // No operand predicates
     /* 3966 */   // MIs[0] second
     /* 3966 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3970 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3974 */   // MIs[1] src
     /* 3974 */   // No operand predicates
     /* 3974 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3976 */   // Combiner Rule #48: sext_of_sext
     /* 3976 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3979 */ // Label 253: @3979
     /* 3979 */ GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4000), // Rule ID 343 //
     /* 3984 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule198Enabled),
     /* 3987 */   // MIs[0] root
     /* 3987 */   // No operand predicates
     /* 3987 */   // MIs[0] src
     /* 3987 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3991 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 3995 */   // MIs[1] x
     /* 3995 */   // No operand predicates
     /* 3995 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3997 */   // Combiner Rule #198: sext_trunc
     /* 3997 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner133),
     /* 4000 */ // Label 254: @4000
     /* 4000 */ GIM_Reject,
     /* 4001 */ // Label 28: @4001
     /* 4001 */ GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(4012), // Rule ID 160 //
     /* 4006 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule118Enabled),
     /* 4009 */   // Combiner Rule #118: sext_inreg_of_load; wip_match_opcode 'G_SEXT_INREG'
     /* 4009 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner66),
     /* 4012 */ // Label 255: @4012
     /* 4012 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(4023), // Rule ID 168 //
     /* 4017 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule126Enabled),
     /* 4020 */   // Combiner Rule #126: redundant_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4020 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner73),
     /* 4023 */ // Label 256: @4023
     /* 4023 */ GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(4034), // Rule ID 225 //
     /* 4028 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule162Enabled),
     /* 4031 */   // Combiner Rule #162: bitfield_extract_from_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4031 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner100),
     /* 4034 */ // Label 257: @4034
     /* 4034 */ GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(4055), // Rule ID 55 //
     /* 4039 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 4042 */   // MIs[0] dst
     /* 4042 */   // No operand predicates
     /* 4042 */   // MIs[0] x
     /* 4042 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4046 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 4050 */   // MIs[1] src
     /* 4050 */   // No operand predicates
     /* 4050 */   // MIs[1] a
     /* 4050 */   // No operand predicates
     /* 4050 */   // MIs[0] b
     /* 4050 */   // No operand predicates
     /* 4050 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4052 */   // Combiner Rule #53: sext_inreg_of_sext_inreg
     /* 4052 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner22),
     /* 4055 */ // Label 258: @4055
     /* 4055 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(4066), // Rule ID 172 //
     /* 4060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule130Enabled),
     /* 4063 */   // MIs[0] dst
     /* 4063 */   // No operand predicates
     /* 4063 */   // MIs[0] src
     /* 4063 */   // No operand predicates
     /* 4063 */   // MIs[0] imm
     /* 4063 */   // No operand predicates
     /* 4063 */   // Combiner Rule #130: sext_inreg_to_zext_inreg
     /* 4063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner77),
     /* 4066 */ // Label 259: @4066
     /* 4066 */ GIM_Reject,
     /* 4067 */ // Label 29: @4067
     /* 4067 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(4078), // Rule ID 171 //
     /* 4072 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule129Enabled),
     /* 4075 */   // Combiner Rule #129: zext_trunc_fold; wip_match_opcode 'G_ZEXT'
     /* 4075 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner76),
     /* 4078 */ // Label 260: @4078
     /* 4078 */ GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(4089), // Rule ID 255 //
     /* 4083 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 4086 */   // Combiner Rule #169: constant_fold_cast_op; wip_match_opcode 'G_ZEXT'
     /* 4086 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 4089 */ // Label 261: @4089
     /* 4089 */ GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(4110), // Rule ID 56 //
     /* 4094 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule54Enabled),
     /* 4097 */   // MIs[0] root
     /* 4097 */   // No operand predicates
     /* 4097 */   // MIs[0] select
     /* 4097 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4101 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 4105 */   // MIs[1] cond
     /* 4105 */   // No operand predicates
     /* 4105 */   // MIs[1] true
     /* 4105 */   // No operand predicates
     /* 4105 */   // MIs[1] false
     /* 4105 */   // No operand predicates
     /* 4105 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4107 */   // Combiner Rule #54: select_of_zext
     /* 4107 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 4110 */ // Label 262: @4110
     /* 4110 */ GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(4131), // Rule ID 49 //
     /* 4115 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule47Enabled),
     /* 4118 */   // MIs[0] root
     /* 4118 */   // No operand predicates
     /* 4118 */   // MIs[0] second
     /* 4118 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4122 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4126 */   // MIs[1] src
     /* 4126 */   // No operand predicates
     /* 4126 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4128 */   // Combiner Rule #47: zext_of_anyext
     /* 4128 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4131 */ // Label 263: @4131
     /* 4131 */ GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(4158), // Rule ID 344 //
     /* 4136 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule199Enabled),
     /* 4139 */   // MIs[0] root
     /* 4139 */   // No operand predicates
     /* 4139 */   // MIs[0] src
     /* 4139 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4143 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4147 */   GIM_MIFlags, /*MI*/1, GIMT_Encode4(MachineInstr::NoUWrap),
     /* 4153 */   // MIs[1] x
     /* 4153 */   // No operand predicates
     /* 4153 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4155 */   // Combiner Rule #199: zext_trunc
     /* 4155 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner134),
     /* 4158 */ // Label 264: @4158
     /* 4158 */ GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(4179), // Rule ID 48 //
     /* 4163 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule46Enabled),
     /* 4166 */   // MIs[0] root
     /* 4166 */   // No operand predicates
     /* 4166 */   // MIs[0] second
     /* 4166 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4170 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 4174 */   // MIs[1] src
     /* 4174 */   // No operand predicates
     /* 4174 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4176 */   // Combiner Rule #46: zext_of_zext
     /* 4176 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4179 */ // Label 265: @4179
     /* 4179 */ GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(4196), // Rule ID 345 //
     /* 4184 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule200Enabled),
     /* 4187 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NonNeg),
     /* 4193 */   // MIs[0] root
     /* 4193 */   // No operand predicates
     /* 4193 */   // MIs[0] x
     /* 4193 */   // No operand predicates
     /* 4193 */   // Combiner Rule #200: nneg_zext
     /* 4193 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner135),
     /* 4196 */ // Label 266: @4196
     /* 4196 */ GIM_Reject,
     /* 4197 */ // Label 30: @4197
     /* 4197 */ GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(4208), // Rule ID 80 //
     /* 4202 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 4205 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_SHL'
     /* 4205 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 4208 */ // Label 267: @4208
     /* 4208 */ GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(4219), // Rule ID 83 //
     /* 4213 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4216 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_SHL'
     /* 4216 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4219 */ // Label 268: @4219
     /* 4219 */ GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(4230), // Rule ID 116 //
     /* 4224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4227 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SHL'
     /* 4227 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4230 */ // Label 269: @4230
     /* 4230 */ GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(4241), // Rule ID 200 //
     /* 4235 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 4238 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_SHL'
     /* 4238 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4241 */ // Label 270: @4241
     /* 4241 */ GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(4252), // Rule ID 205 //
     /* 4246 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4249 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_SHL'
     /* 4249 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4252 */ // Label 271: @4252
     /* 4252 */ GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(4263), // Rule ID 224 //
     /* 4257 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule161Enabled),
     /* 4260 */   // Combiner Rule #161: commute_shift; wip_match_opcode 'G_SHL'
     /* 4260 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner99),
     /* 4263 */ // Label 272: @4263
     /* 4263 */ GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(4274), // Rule ID 238 //
     /* 4268 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 4271 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SHL'
     /* 4271 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4274 */ // Label 273: @4274
     /* 4274 */ GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(4285), // Rule ID 287 //
     /* 4279 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 4282 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SHL'
     /* 4282 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4285 */ // Label 274: @4285
     /* 4285 */ GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(4320), // Rule ID 41 //
     /* 4290 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule39Enabled),
     /* 4293 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 4299 */   // MIs[0] root
     /* 4299 */   // No operand predicates
     /* 4299 */   // MIs[0] left
     /* 4299 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4303 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 4307 */   // MIs[1] imm
     /* 4307 */   // No operand predicates
     /* 4307 */   // MIs[0] x
     /* 4307 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 4311 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4315 */   // MIs[2] imm1
     /* 4315 */   // No operand predicates
     /* 4315 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4317 */   // Combiner Rule #39: shl_of_vscale
     /* 4317 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner17),
     /* 4320 */ // Label 275: @4320
     /* 4320 */ GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(4343), // Rule ID 108 //
     /* 4325 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4328 */   // MIs[0] dst
     /* 4328 */   // No operand predicates
     /* 4328 */   // MIs[0] lhs
     /* 4328 */   // No operand predicates
     /* 4328 */   // MIs[0] Operand 2
     /* 4328 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4332 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4337 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[4]]
     /* 4337 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4342 */   GIR_EraseRootFromParent_Done,
     /* 4343 */ // Label 276: @4343
     /* 4343 */ GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(4354), // Rule ID 145 //
     /* 4348 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 4351 */   // MIs[0] root
     /* 4351 */   // No operand predicates
     /* 4351 */   // MIs[0] mi.shifted
     /* 4351 */   // No operand predicates
     /* 4351 */   // MIs[0] mi.amt
     /* 4351 */   // No operand predicates
     /* 4351 */   // Combiner Rule #105: shifts_too_big @ [mi[0]]
     /* 4351 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4354 */ // Label 277: @4354
     /* 4354 */ GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(4365), // Rule ID 161 //
     /* 4359 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule119Enabled),
     /* 4362 */   // MIs[0] dst
     /* 4362 */   // No operand predicates
     /* 4362 */   // MIs[0] src0
     /* 4362 */   // No operand predicates
     /* 4362 */   // MIs[0] src1
     /* 4362 */   // No operand predicates
     /* 4362 */   // Combiner Rule #119: reduce_shl_of_extend
     /* 4362 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 4365 */ // Label 278: @4365
     /* 4365 */ GIM_Reject,
     /* 4366 */ // Label 31: @4366
     /* 4366 */ GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(4377), // Rule ID 85 //
     /* 4371 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4374 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_LSHR'
     /* 4374 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4377 */ // Label 279: @4377
     /* 4377 */ GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(4388), // Rule ID 117 //
     /* 4382 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4385 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_LSHR'
     /* 4385 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4388 */ // Label 280: @4388
     /* 4388 */ GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(4399), // Rule ID 202 //
     /* 4393 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 4396 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_LSHR'
     /* 4396 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4399 */ // Label 281: @4399
     /* 4399 */ GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(4410), // Rule ID 207 //
     /* 4404 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4407 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_LSHR'
     /* 4407 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4410 */ // Label 282: @4410
     /* 4410 */ GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(4421), // Rule ID 228 //
     /* 4415 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule164Enabled),
     /* 4418 */   // Combiner Rule #164: bitfield_extract_from_shr; wip_match_opcode 'G_LSHR'
     /* 4418 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 4421 */ // Label 283: @4421
     /* 4421 */ GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(4432), // Rule ID 230 //
     /* 4426 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule165Enabled),
     /* 4429 */   // Combiner Rule #165: bitfield_extract_from_shr_and; wip_match_opcode 'G_LSHR'
     /* 4429 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 4432 */ // Label 284: @4432
     /* 4432 */ GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(4443), // Rule ID 235 //
     /* 4437 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 4440 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_LSHR'
     /* 4440 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4443 */ // Label 285: @4443
     /* 4443 */ GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(4454), // Rule ID 285 //
     /* 4448 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 4451 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_LSHR'
     /* 4451 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4454 */ // Label 286: @4454
     /* 4454 */ GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(4477), // Rule ID 110 //
     /* 4459 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4462 */   // MIs[0] dst
     /* 4462 */   // No operand predicates
     /* 4462 */   // MIs[0] lhs
     /* 4462 */   // No operand predicates
     /* 4462 */   // MIs[0] Operand 2
     /* 4462 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4466 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4471 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[6]]
     /* 4471 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4476 */   GIR_EraseRootFromParent_Done,
     /* 4477 */ // Label 287: @4477
     /* 4477 */ GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(4488), // Rule ID 147 //
     /* 4482 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 4485 */   // MIs[0] root
     /* 4485 */   // No operand predicates
     /* 4485 */   // MIs[0] mi.shifted
     /* 4485 */   // No operand predicates
     /* 4485 */   // MIs[0] mi.amt
     /* 4485 */   // No operand predicates
     /* 4485 */   // Combiner Rule #105: shifts_too_big @ [mi[2]]
     /* 4485 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4488 */ // Label 288: @4488
     /* 4488 */ GIM_Reject,
     /* 4489 */ // Label 32: @4489
     /* 4489 */ GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(4500), // Rule ID 84 //
     /* 4494 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4497 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_ASHR'
     /* 4497 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4500 */ // Label 289: @4500
     /* 4500 */ GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(4511), // Rule ID 118 //
     /* 4505 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4508 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_ASHR'
     /* 4508 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4511 */ // Label 290: @4511
     /* 4511 */ GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(4522), // Rule ID 158 //
     /* 4516 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule116Enabled),
     /* 4519 */   // Combiner Rule #116: shl_ashr_to_sext_inreg; wip_match_opcode 'G_ASHR'
     /* 4519 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner65),
     /* 4522 */ // Label 291: @4522
     /* 4522 */ GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(4533), // Rule ID 201 //
     /* 4527 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 4530 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_ASHR'
     /* 4530 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4533 */ // Label 292: @4533
     /* 4533 */ GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(4544), // Rule ID 206 //
     /* 4538 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4541 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_ASHR'
     /* 4541 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4544 */ // Label 293: @4544
     /* 4544 */ GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(4555), // Rule ID 227 //
     /* 4549 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule164Enabled),
     /* 4552 */   // Combiner Rule #164: bitfield_extract_from_shr; wip_match_opcode 'G_ASHR'
     /* 4552 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 4555 */ // Label 294: @4555
     /* 4555 */ GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(4566), // Rule ID 229 //
     /* 4560 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule165Enabled),
     /* 4563 */   // Combiner Rule #165: bitfield_extract_from_shr_and; wip_match_opcode 'G_ASHR'
     /* 4563 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 4566 */ // Label 295: @4566
     /* 4566 */ GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(4577), // Rule ID 234 //
     /* 4571 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 4574 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_ASHR'
     /* 4574 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4577 */ // Label 296: @4577
     /* 4577 */ GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(4588), // Rule ID 286 //
     /* 4582 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 4585 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_ASHR'
     /* 4585 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4588 */ // Label 297: @4588
     /* 4588 */ GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(4611), // Rule ID 109 //
     /* 4593 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4596 */   // MIs[0] dst
     /* 4596 */   // No operand predicates
     /* 4596 */   // MIs[0] lhs
     /* 4596 */   // No operand predicates
     /* 4596 */   // MIs[0] Operand 2
     /* 4596 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4600 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4605 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[5]]
     /* 4605 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4610 */   GIR_EraseRootFromParent_Done,
     /* 4611 */ // Label 298: @4611
     /* 4611 */ GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(4622), // Rule ID 146 //
     /* 4616 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 4619 */   // MIs[0] root
     /* 4619 */   // No operand predicates
     /* 4619 */   // MIs[0] mi.shifted
     /* 4619 */   // No operand predicates
     /* 4619 */   // MIs[0] mi.amt
     /* 4619 */   // No operand predicates
     /* 4619 */   // Combiner Rule #105: shifts_too_big @ [mi[1]]
     /* 4619 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4622 */ // Label 299: @4622
     /* 4622 */ GIM_Reject,
     /* 4623 */ // Label 33: @4623
     /* 4623 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(4634), // Rule ID 216 //
     /* 4628 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule155Enabled),
     /* 4631 */   // Combiner Rule #155: funnel_shift_to_rotate; wip_match_opcode 'G_FSHL'
     /* 4631 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 4634 */ // Label 300: @4634
     /* 4634 */ GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(4645), // Rule ID 220 //
     /* 4639 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule158Enabled),
     /* 4642 */   // Combiner Rule #158: funnel_shift_overshift; wip_match_opcode 'G_FSHL'
     /* 4642 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 4645 */ // Label 301: @4645
     /* 4645 */ GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(4665), // Rule ID 219 //
     /* 4650 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule157Enabled),
     /* 4653 */   // MIs[0] x
     /* 4653 */   // No operand predicates
     /* 4653 */   // MIs[0] y
     /* 4653 */   // No operand predicates
     /* 4653 */   // MIs[0] z
     /* 4653 */   // No operand predicates
     /* 4653 */   // MIs[0] Operand 3
     /* 4653 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 4657 */   // Combiner Rule #157: funnel_shift_left_zero
     /* 4657 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 4660 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 4662 */   GIR_RootToRootCopy, /*OpIdx*/1, // y
     /* 4664 */   GIR_EraseRootFromParent_Done,
     /* 4665 */ // Label 302: @4665
     /* 4665 */ GIM_Reject,
     /* 4666 */ // Label 34: @4666
     /* 4666 */ GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(4677), // Rule ID 217 //
     /* 4671 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule155Enabled),
     /* 4674 */   // Combiner Rule #155: funnel_shift_to_rotate; wip_match_opcode 'G_FSHR'
     /* 4674 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 4677 */ // Label 303: @4677
     /* 4677 */ GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(4688), // Rule ID 221 //
     /* 4682 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule158Enabled),
     /* 4685 */   // Combiner Rule #158: funnel_shift_overshift; wip_match_opcode 'G_FSHR'
     /* 4685 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 4688 */ // Label 304: @4688
     /* 4688 */ GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(4708), // Rule ID 218 //
     /* 4693 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule156Enabled),
     /* 4696 */   // MIs[0] x
     /* 4696 */   // No operand predicates
     /* 4696 */   // MIs[0] y
     /* 4696 */   // No operand predicates
     /* 4696 */   // MIs[0] z
     /* 4696 */   // No operand predicates
     /* 4696 */   // MIs[0] Operand 3
     /* 4696 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 4700 */   // Combiner Rule #156: funnel_shift_right_zero
     /* 4700 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 4703 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 4705 */   GIR_RootToRootCopy, /*OpIdx*/2, // z
     /* 4707 */   GIR_EraseRootFromParent_Done,
     /* 4708 */ // Label 305: @4708
     /* 4708 */ GIM_Reject,
     /* 4709 */ // Label 35: @4709
     /* 4709 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(4732), // Rule ID 113 //
     /* 4714 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4717 */   // MIs[0] dst
     /* 4717 */   // No operand predicates
     /* 4717 */   // MIs[0] lhs
     /* 4717 */   // No operand predicates
     /* 4717 */   // MIs[0] Operand 2
     /* 4717 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4721 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4726 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[9]]
     /* 4726 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4731 */   GIR_EraseRootFromParent_Done,
     /* 4732 */ // Label 306: @4732
     /* 4732 */ GIM_Reject,
     /* 4733 */ // Label 36: @4733
     /* 4733 */ GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(4756), // Rule ID 112 //
     /* 4738 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4741 */   // MIs[0] dst
     /* 4741 */   // No operand predicates
     /* 4741 */   // MIs[0] lhs
     /* 4741 */   // No operand predicates
     /* 4741 */   // MIs[0] Operand 2
     /* 4741 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4745 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4750 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[8]]
     /* 4750 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4755 */   GIR_EraseRootFromParent_Done,
     /* 4756 */ // Label 307: @4756
     /* 4756 */ GIM_Reject,
     /* 4757 */ // Label 37: @4757
     /* 4757 */ GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(4768), // Rule ID 153 //
     /* 4762 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule111Enabled),
     /* 4765 */   // Combiner Rule #111: icmp_to_true_false_known_bits; wip_match_opcode 'G_ICMP'
     /* 4765 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner62),
     /* 4768 */ // Label 308: @4768
     /* 4768 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(4779), // Rule ID 154 //
     /* 4773 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule112Enabled),
     /* 4776 */   // Combiner Rule #112: icmp_to_lhs_known_bits; wip_match_opcode 'G_ICMP'
     /* 4776 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner63),
     /* 4779 */ // Label 309: @4779
     /* 4779 */ GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(4790), // Rule ID 157 //
     /* 4784 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule115Enabled),
     /* 4787 */   // Combiner Rule #115: redundant_binop_in_equality; wip_match_opcode 'G_ICMP'
     /* 4787 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner64),
     /* 4790 */ // Label 310: @4790
     /* 4790 */ GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(4801), // Rule ID 151 //
     /* 4795 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule109Enabled),
     /* 4798 */   // MIs[0] root
     /* 4798 */   // No operand predicates
     /* 4798 */   // MIs[0] pred
     /* 4798 */   // No operand predicates
     /* 4798 */   // MIs[0] lhs
     /* 4798 */   // No operand predicates
     /* 4798 */   // MIs[0] rhs
     /* 4798 */   // No operand predicates
     /* 4798 */   // Combiner Rule #109: canonicalize_icmp
     /* 4798 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner60),
     /* 4801 */ // Label 311: @4801
     /* 4801 */ GIM_Reject,
     /* 4802 */ // Label 38: @4802
     /* 4802 */ GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(4813), // Rule ID 152 //
     /* 4807 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule110Enabled),
     /* 4810 */   // MIs[0] root
     /* 4810 */   // No operand predicates
     /* 4810 */   // MIs[0] pred
     /* 4810 */   // No operand predicates
     /* 4810 */   // MIs[0] lhs
     /* 4810 */   // No operand predicates
     /* 4810 */   // MIs[0] rhs
     /* 4810 */   // No operand predicates
     /* 4810 */   // Combiner Rule #110: canonicalize_fcmp
     /* 4810 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner61),
     /* 4813 */ // Label 312: @4813
     /* 4813 */ GIM_Reject,
     /* 4814 */ // Label 39: @4814
     /* 4814 */ GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(4825), // Rule ID 103 //
     /* 4819 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule83Enabled),
     /* 4822 */   // Combiner Rule #83: select_same_val; wip_match_opcode 'G_SELECT'
     /* 4822 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner44),
     /* 4825 */ // Label 313: @4825
     /* 4825 */ GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(4836), // Rule ID 164 //
     /* 4830 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule122Enabled),
     /* 4833 */   // Combiner Rule #122: select_constant_cmp; wip_match_opcode 'G_SELECT'
     /* 4833 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner69),
     /* 4836 */ // Label 314: @4836
     /* 4836 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(4847), // Rule ID 166 //
     /* 4841 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule124Enabled),
     /* 4844 */   // Combiner Rule #124: match_selects; wip_match_opcode 'G_SELECT'
     /* 4844 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner71),
     /* 4847 */ // Label 315: @4847
     /* 4847 */ GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(4858), // Rule ID 308 //
     /* 4852 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule190Enabled),
     /* 4855 */   // Combiner Rule #190: select_to_minmax; wip_match_opcode 'G_SELECT'
     /* 4855 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner125),
     /* 4858 */ // Label 316: @4858
     /* 4858 */ GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(4879), // Rule ID 165 //
     /* 4863 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule123Enabled),
     /* 4866 */   // MIs[0] root
     /* 4866 */   // No operand predicates
     /* 4866 */   // MIs[0] tst
     /* 4866 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4870 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 4874 */   // MIs[1] tst1
     /* 4874 */   // No operand predicates
     /* 4874 */   // MIs[1] a
     /* 4874 */   // No operand predicates
     /* 4874 */   // MIs[1] b
     /* 4874 */   // No operand predicates
     /* 4874 */   // MIs[0] x
     /* 4874 */   // No operand predicates
     /* 4874 */   // MIs[0] y
     /* 4874 */   // No operand predicates
     /* 4874 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4876 */   // Combiner Rule #123: select_to_iminmax
     /* 4876 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner70),
     /* 4879 */ // Label 317: @4879
     /* 4879 */ GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(4908), // Rule ID 163 //
     /* 4884 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule121Enabled),
     /* 4887 */   // MIs[0] dst
     /* 4887 */   // No operand predicates
     /* 4887 */   // MIs[0] undef
     /* 4887 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4891 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 4895 */   // MIs[0] x
     /* 4895 */   // No operand predicates
     /* 4895 */   // MIs[0] y
     /* 4895 */   // No operand predicates
     /* 4895 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 4900 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4902 */   // Combiner Rule #121: select_undef_cmp
     /* 4902 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 4907 */   GIR_EraseRootFromParent_Done,
     /* 4908 */ // Label 318: @4908
     /* 4908 */ GIM_Reject,
     /* 4909 */ // Label 40: @4909
     /* 4909 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(4920), // Rule ID 319 //
     /* 4914 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 4917 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDO'
     /* 4917 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 4920 */ // Label 319: @4920
     /* 4920 */ GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(4931), // Rule ID 360 //
     /* 4925 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule214Enabled),
     /* 4928 */   // Combiner Rule #214: match_addos; wip_match_opcode 'G_UADDO'
     /* 4928 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 4931 */ // Label 320: @4931
     /* 4931 */ GIM_Reject,
     /* 4932 */ // Label 41: @4932
     /* 4932 */ GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(4943), // Rule ID 189 //
     /* 4937 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 4940 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_UADDE'
     /* 4940 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 4943 */ // Label 321: @4943
     /* 4943 */ GIM_Reject,
     /* 4944 */ // Label 42: @4944
     /* 4944 */ GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(4955), // Rule ID 362 //
     /* 4949 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule215Enabled),
     /* 4952 */   // Combiner Rule #215: match_subo_no_overflow; wip_match_opcode 'G_USUBO'
     /* 4952 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 4955 */ // Label 322: @4955
     /* 4955 */ GIM_Reject,
     /* 4956 */ // Label 43: @4956
     /* 4956 */ GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(4967), // Rule ID 191 //
     /* 4961 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 4964 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_USUBE'
     /* 4964 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 4967 */ // Label 323: @4967
     /* 4967 */ GIM_Reject,
     /* 4968 */ // Label 44: @4968
     /* 4968 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(4979), // Rule ID 320 //
     /* 4973 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 4976 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDO'
     /* 4976 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 4979 */ // Label 324: @4979
     /* 4979 */ GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(4990), // Rule ID 359 //
     /* 4984 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule214Enabled),
     /* 4987 */   // Combiner Rule #214: match_addos; wip_match_opcode 'G_SADDO'
     /* 4987 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 4990 */ // Label 325: @4990
     /* 4990 */ GIM_Reject,
     /* 4991 */ // Label 45: @4991
     /* 4991 */ GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(5002), // Rule ID 190 //
     /* 4996 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 4999 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_SADDE'
     /* 4999 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5002 */ // Label 326: @5002
     /* 5002 */ GIM_Reject,
     /* 5003 */ // Label 46: @5003
     /* 5003 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(5014), // Rule ID 361 //
     /* 5008 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule215Enabled),
     /* 5011 */   // Combiner Rule #215: match_subo_no_overflow; wip_match_opcode 'G_SSUBO'
     /* 5011 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 5014 */ // Label 327: @5014
     /* 5014 */ GIM_Reject,
     /* 5015 */ // Label 47: @5015
     /* 5015 */ GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(5026), // Rule ID 192 //
     /* 5020 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 5023 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_SSUBE'
     /* 5023 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5026 */ // Label 328: @5026
     /* 5026 */ GIM_Reject,
     /* 5027 */ // Label 48: @5027
     /* 5027 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(5038), // Rule ID 185 //
     /* 5032 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule143Enabled),
     /* 5035 */   // Combiner Rule #143: mulo_by_2; wip_match_opcode 'G_UMULO'
     /* 5035 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5038 */ // Label 329: @5038
     /* 5038 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(5049), // Rule ID 187 //
     /* 5043 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5046 */   // Combiner Rule #144: mulo_by_0; wip_match_opcode 'G_UMULO'
     /* 5046 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5049 */ // Label 330: @5049
     /* 5049 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(5060), // Rule ID 321 //
     /* 5054 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5057 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULO'
     /* 5057 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5060 */ // Label 331: @5060
     /* 5060 */ GIM_Reject,
     /* 5061 */ // Label 49: @5061
     /* 5061 */ GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(5072), // Rule ID 186 //
     /* 5066 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule143Enabled),
     /* 5069 */   // Combiner Rule #143: mulo_by_2; wip_match_opcode 'G_SMULO'
     /* 5069 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5072 */ // Label 332: @5072
     /* 5072 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(5083), // Rule ID 188 //
     /* 5077 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5080 */   // Combiner Rule #144: mulo_by_0; wip_match_opcode 'G_SMULO'
     /* 5080 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5083 */ // Label 333: @5083
     /* 5083 */ GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(5094), // Rule ID 322 //
     /* 5088 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5091 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULO'
     /* 5091 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5094 */ // Label 334: @5094
     /* 5094 */ GIM_Reject,
     /* 5095 */ // Label 50: @5095
     /* 5095 */ GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(5106), // Rule ID 259 //
     /* 5100 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule171Enabled),
     /* 5103 */   // Combiner Rule #171: mulh_to_lshr; wip_match_opcode 'G_UMULH'
     /* 5103 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner108),
     /* 5106 */ // Label 335: @5106
     /* 5106 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(5117), // Rule ID 323 //
     /* 5111 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5114 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULH'
     /* 5114 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5117 */ // Label 336: @5117
     /* 5117 */ GIM_Reject,
     /* 5118 */ // Label 51: @5118
     /* 5118 */ GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(5129), // Rule ID 324 //
     /* 5123 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5126 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULH'
     /* 5126 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5129 */ // Label 337: @5129
     /* 5129 */ GIM_Reject,
     /* 5130 */ // Label 52: @5130
     /* 5130 */ GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(5141), // Rule ID 325 //
     /* 5135 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5138 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDSAT'
     /* 5138 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5141 */ // Label 338: @5141
     /* 5141 */ GIM_Reject,
     /* 5142 */ // Label 53: @5142
     /* 5142 */ GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(5153), // Rule ID 326 //
     /* 5147 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5150 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDSAT'
     /* 5150 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5153 */ // Label 339: @5153
     /* 5153 */ GIM_Reject,
     /* 5154 */ // Label 54: @5154
     /* 5154 */ GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(5165), // Rule ID 204 //
     /* 5159 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 5162 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_USHLSAT'
     /* 5162 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5165 */ // Label 340: @5165
     /* 5165 */ GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(5176), // Rule ID 208 //
     /* 5170 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5173 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_USHLSAT'
     /* 5173 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5176 */ // Label 341: @5176
     /* 5176 */ GIM_Reject,
     /* 5177 */ // Label 55: @5177
     /* 5177 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(5188), // Rule ID 203 //
     /* 5182 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 5185 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5185 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5188 */ // Label 342: @5188
     /* 5188 */ GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(5199), // Rule ID 209 //
     /* 5193 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5196 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5196 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5199 */ // Label 343: @5199
     /* 5199 */ GIM_Reject,
     /* 5200 */ // Label 56: @5200
     /* 5200 */ GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(5211), // Rule ID 327 //
     /* 5205 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5208 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIX'
     /* 5208 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5211 */ // Label 344: @5211
     /* 5211 */ GIM_Reject,
     /* 5212 */ // Label 57: @5212
     /* 5212 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(5223), // Rule ID 328 //
     /* 5217 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5220 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIX'
     /* 5220 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5223 */ // Label 345: @5223
     /* 5223 */ GIM_Reject,
     /* 5224 */ // Label 58: @5224
     /* 5224 */ GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(5235), // Rule ID 329 //
     /* 5229 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5232 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIXSAT'
     /* 5232 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5235 */ // Label 346: @5235
     /* 5235 */ GIM_Reject,
     /* 5236 */ // Label 59: @5236
     /* 5236 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(5247), // Rule ID 330 //
     /* 5241 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5244 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIXSAT'
     /* 5244 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5247 */ // Label 347: @5247
     /* 5247 */ GIM_Reject,
     /* 5248 */ // Label 60: @5248
     /* 5248 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(5259), // Rule ID 249 //
     /* 5253 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5256 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FADD'
     /* 5256 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5259 */ // Label 348: @5259
     /* 5259 */ GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(5270), // Rule ID 260 //
     /* 5264 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5267 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FADD'
     /* 5267 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5270 */ // Label 349: @5270
     /* 5270 */ GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(5281), // Rule ID 267 //
     /* 5275 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule174Enabled),
     /* 5278 */   // Combiner Rule #174: combine_fadd_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5278 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner111),
     /* 5281 */ // Label 350: @5281
     /* 5281 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(5292), // Rule ID 268 //
     /* 5286 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 5289 */   // Combiner Rule #175: combine_fadd_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5289 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner112),
     /* 5292 */ // Label 351: @5292
     /* 5292 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(5303), // Rule ID 269 //
     /* 5297 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule176Enabled),
     /* 5300 */   // Combiner Rule #176: combine_fadd_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5300 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner113),
     /* 5303 */ // Label 352: @5303
     /* 5303 */ GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(5314), // Rule ID 270 //
     /* 5308 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule177Enabled),
     /* 5311 */   // Combiner Rule #177: combine_fadd_fpext_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5311 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner114),
     /* 5314 */ // Label 353: @5314
     /* 5314 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(5325), // Rule ID 293 //
     /* 5319 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5322 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FADD'
     /* 5322 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5325 */ // Label 354: @5325
     /* 5325 */ GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(5336), // Rule ID 331 //
     /* 5330 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 5333 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FADD'
     /* 5333 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5336 */ // Label 355: @5336
     /* 5336 */ GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(5359), // Rule ID 138 //
     /* 5341 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule100Enabled),
     /* 5344 */   // MIs[0] dst
     /* 5344 */   // No operand predicates
     /* 5344 */   // MIs[0] x
     /* 5344 */   // No operand predicates
     /* 5344 */   // MIs[0] y
     /* 5344 */   // No operand predicates
     /* 5344 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner3),
     /* 5348 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5353 */   // Combiner Rule #100: right_identity_neg_zero_fp
     /* 5353 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5358 */   GIR_EraseRootFromParent_Done,
     /* 5359 */ // Label 356: @5359
     /* 5359 */ GIM_Reject,
     /* 5360 */ // Label 61: @5360
     /* 5360 */ GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(5371), // Rule ID 250 //
     /* 5365 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5368 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FSUB'
     /* 5368 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5371 */ // Label 357: @5371
     /* 5371 */ GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(5382), // Rule ID 261 //
     /* 5376 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5379 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FSUB'
     /* 5379 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5382 */ // Label 358: @5382
     /* 5382 */ GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(5393), // Rule ID 271 //
     /* 5387 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule178Enabled),
     /* 5390 */   // Combiner Rule #178: combine_fsub_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5390 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner115),
     /* 5393 */ // Label 359: @5393
     /* 5393 */ GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(5404), // Rule ID 272 //
     /* 5398 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule179Enabled),
     /* 5401 */   // Combiner Rule #179: combine_fsub_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5401 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner116),
     /* 5404 */ // Label 360: @5404
     /* 5404 */ GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(5415), // Rule ID 273 //
     /* 5409 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule180Enabled),
     /* 5412 */   // Combiner Rule #180: combine_fsub_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5412 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner117),
     /* 5415 */ // Label 361: @5415
     /* 5415 */ GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(5426), // Rule ID 274 //
     /* 5420 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule181Enabled),
     /* 5423 */   // Combiner Rule #181: combine_fsub_fpext_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5423 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner118),
     /* 5426 */ // Label 362: @5426
     /* 5426 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(5437), // Rule ID 294 //
     /* 5431 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5434 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FSUB'
     /* 5434 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5437 */ // Label 363: @5437
     /* 5437 */ GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(5448), // Rule ID 309 //
     /* 5442 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5445 */   // Combiner Rule #191: fsub_to_fneg; wip_match_opcode 'G_FSUB'
     /* 5445 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner126),
     /* 5448 */ // Label 364: @5448
     /* 5448 */ GIM_Reject,
     /* 5449 */ // Label 62: @5449
     /* 5449 */ GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(5460), // Rule ID 251 //
     /* 5454 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5457 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FMUL'
     /* 5457 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5460 */ // Label 365: @5460
     /* 5460 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(5471), // Rule ID 262 //
     /* 5465 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5468 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FMUL'
     /* 5468 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5471 */ // Label 366: @5471
     /* 5471 */ GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(5482), // Rule ID 292 //
     /* 5476 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5479 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMUL'
     /* 5479 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5482 */ // Label 367: @5482
     /* 5482 */ GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(5493), // Rule ID 332 //
     /* 5487 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 5490 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMUL'
     /* 5490 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5493 */ // Label 368: @5493
     /* 5493 */ GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(5514), // Rule ID 363 //
     /* 5498 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule216Enabled),
     /* 5501 */   // MIs[0] dst
     /* 5501 */   // No operand predicates
     /* 5501 */   // MIs[0] x
     /* 5501 */   // No operand predicates
     /* 5501 */   // MIs[0] select
     /* 5501 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 5505 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 5509 */   // MIs[1] y
     /* 5509 */   // No operand predicates
     /* 5509 */   // MIs[1] A
     /* 5509 */   // No operand predicates
     /* 5509 */   // MIs[1] B
     /* 5509 */   // No operand predicates
     /* 5509 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5511 */   // Combiner Rule #216: combine_fmul_with_select_to_fldexp
     /* 5511 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner151),
     /* 5514 */ // Label 369: @5514
     /* 5514 */ GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(5537), // Rule ID 129 //
     /* 5519 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule93Enabled),
     /* 5522 */   // MIs[0] dst
     /* 5522 */   // No operand predicates
     /* 5522 */   // MIs[0] x
     /* 5522 */   // No operand predicates
     /* 5522 */   // MIs[0] y
     /* 5522 */   // No operand predicates
     /* 5522 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner2),
     /* 5526 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5531 */   // Combiner Rule #93: right_identity_one_fp
     /* 5531 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5536 */   GIR_EraseRootFromParent_Done,
     /* 5537 */ // Label 370: @5537
     /* 5537 */ GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(5557), // Rule ID 139 //
     /* 5542 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule101Enabled),
     /* 5545 */   // MIs[0] dst
     /* 5545 */   // No operand predicates
     /* 5545 */   // MIs[0] x
     /* 5545 */   // No operand predicates
     /* 5545 */   // MIs[0] y
     /* 5545 */   // No operand predicates
     /* 5545 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner4),
     /* 5549 */   // Combiner Rule #101: right_identity_neg_one_fp
     /* 5549 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 5552 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 5554 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 5556 */   GIR_EraseRootFromParent_Done,
     /* 5557 */ // Label 371: @5557
     /* 5557 */ GIM_Reject,
     /* 5558 */ // Label 63: @5558
     /* 5558 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(5569), // Rule ID 254 //
     /* 5563 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 5566 */   // Combiner Rule #168: constant_fold_fma; wip_match_opcode 'G_FMA'
     /* 5566 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 5569 */ // Label 372: @5569
     /* 5569 */ GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(5580), // Rule ID 265 //
     /* 5574 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5577 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FMA'
     /* 5577 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5580 */ // Label 373: @5580
     /* 5580 */ GIM_Reject,
     /* 5581 */ // Label 64: @5581
     /* 5581 */ GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(5592), // Rule ID 253 //
     /* 5586 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 5589 */   // Combiner Rule #168: constant_fold_fma; wip_match_opcode 'G_FMAD'
     /* 5589 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 5592 */ // Label 374: @5592
     /* 5592 */ GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(5603), // Rule ID 264 //
     /* 5597 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5600 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FMAD'
     /* 5600 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5603 */ // Label 375: @5603
     /* 5603 */ GIM_Reject,
     /* 5604 */ // Label 65: @5604
     /* 5604 */ GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(5615), // Rule ID 252 //
     /* 5609 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5612 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FDIV'
     /* 5612 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5615 */ // Label 376: @5615
     /* 5615 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(5626), // Rule ID 263 //
     /* 5620 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5623 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FDIV'
     /* 5623 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5626 */ // Label 377: @5626
     /* 5626 */ GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(5637), // Rule ID 295 //
     /* 5631 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5634 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FDIV'
     /* 5634 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5637 */ // Label 378: @5637
     /* 5637 */ GIM_Reject,
     /* 5638 */ // Label 66: @5638
     /* 5638 */ GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(5649), // Rule ID 296 //
     /* 5643 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5646 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FREM'
     /* 5646 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5649 */ // Label 379: @5649
     /* 5649 */ GIM_Reject,
     /* 5650 */ // Label 67: @5650
     /* 5650 */ GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(5671), // Rule ID 197 //
     /* 5655 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 5658 */   // MIs[0] dst
     /* 5658 */   // No operand predicates
     /* 5658 */   // MIs[0] float
     /* 5658 */   // No operand predicates
     /* 5658 */   // MIs[0] int
     /* 5658 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 5662 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 5666 */   // MIs[1] imm
     /* 5666 */   // No operand predicates
     /* 5666 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5668 */   // Combiner Rule #147: expand_const_fpowi
     /* 5668 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner89),
     /* 5671 */ // Label 380: @5671
     /* 5671 */ GIM_Reject,
     /* 5672 */ // Label 68: @5672
     /* 5672 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(5693), // Rule ID 179 //
     /* 5677 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule137Enabled),
     /* 5680 */   // MIs[0] dst
     /* 5680 */   // No operand predicates
     /* 5680 */   // MIs[0] src0
     /* 5680 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5684 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5688 */   // MIs[1] cst
     /* 5688 */   // No operand predicates
     /* 5688 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5690 */   // Combiner Rule #137: constant_fold_flog2
     /* 5690 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5693 */ // Label 381: @5693
     /* 5693 */ GIM_Reject,
     /* 5694 */ // Label 69: @5694
     /* 5694 */ GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(5705), // Rule ID 365 //
     /* 5699 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule218Enabled),
     /* 5702 */   // Combiner Rule #218: foldable_fneg; wip_match_opcode 'G_FNEG'
     /* 5702 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner153),
     /* 5705 */ // Label 382: @5705
     /* 5705 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(5726), // Rule ID 176 //
     /* 5710 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule134Enabled),
     /* 5713 */   // MIs[0] dst
     /* 5713 */   // No operand predicates
     /* 5713 */   // MIs[0] src0
     /* 5713 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5717 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5721 */   // MIs[1] cst
     /* 5721 */   // No operand predicates
     /* 5721 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5723 */   // Combiner Rule #134: constant_fold_fneg
     /* 5723 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5726 */ // Label 383: @5726
     /* 5726 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(5755), // Rule ID 127 //
     /* 5731 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule91Enabled),
     /* 5734 */   // MIs[0] dst
     /* 5734 */   // No operand predicates
     /* 5734 */   // MIs[0] t
     /* 5734 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5738 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 5742 */   // MIs[1] src
     /* 5742 */   // No operand predicates
     /* 5742 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 5747 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5749 */   // Combiner Rule #91: fneg_fneg_fold
     /* 5749 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 5754 */   GIR_EraseRootFromParent_Done,
     /* 5755 */ // Label 384: @5755
     /* 5755 */ GIM_Reject,
     /* 5756 */ // Label 70: @5756
     /* 5756 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(5777), // Rule ID 180 //
     /* 5761 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule138Enabled),
     /* 5764 */   // MIs[0] dst
     /* 5764 */   // No operand predicates
     /* 5764 */   // MIs[0] src0
     /* 5764 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5768 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5772 */   // MIs[1] cst
     /* 5772 */   // No operand predicates
     /* 5772 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5774 */   // Combiner Rule #138: constant_fold_fptrunc
     /* 5774 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5777 */ // Label 385: @5777
     /* 5777 */ GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(5798), // Rule ID 137 //
     /* 5782 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule99Enabled),
     /* 5785 */   // MIs[0] dst
     /* 5785 */   // No operand predicates
     /* 5785 */   // MIs[0] src1
     /* 5785 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5789 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPEXT),
     /* 5793 */   // MIs[1] src0
     /* 5793 */   // No operand predicates
     /* 5793 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5795 */   // Combiner Rule #99: fptrunc_fpext_fold
     /* 5795 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 5798 */ // Label 386: @5798
     /* 5798 */ GIM_Reject,
     /* 5799 */ // Label 71: @5799
     /* 5799 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(5820), // Rule ID 92 //
     /* 5804 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 5807 */   // MIs[0] dst
     /* 5807 */   // No operand predicates
     /* 5807 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 5807 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5811 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 5815 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5817 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[5]]
     /* 5817 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 5820 */ // Label 387: @5820
     /* 5820 */ GIM_Reject,
     /* 5821 */ // Label 72: @5821
     /* 5821 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(5842), // Rule ID 93 //
     /* 5826 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 5829 */   // MIs[0] dst
     /* 5829 */   // No operand predicates
     /* 5829 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 5829 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5833 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 5837 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5839 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[6]]
     /* 5839 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 5842 */ // Label 388: @5842
     /* 5842 */ GIM_Reject,
     /* 5843 */ // Label 73: @5843
     /* 5843 */ GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(5854), // Rule ID 76 //
     /* 5848 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 5851 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_SITOFP'
     /* 5851 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 5854 */ // Label 389: @5854
     /* 5854 */ GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(5869), // Rule ID 181 //
     /* 5859 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule139Enabled),
     /* 5862 */   // MIs[0] dst
     /* 5862 */   // No operand predicates
     /* 5862 */   // MIs[0] Operand 1
     /* 5862 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 5866 */   // Combiner Rule #139: itof_const_zero_fold_si
     /* 5866 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 5869 */ // Label 390: @5869
     /* 5869 */ GIM_Reject,
     /* 5870 */ // Label 74: @5870
     /* 5870 */ GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(5881), // Rule ID 75 //
     /* 5875 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 5878 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_UITOFP'
     /* 5878 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 5881 */ // Label 391: @5881
     /* 5881 */ GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(5896), // Rule ID 182 //
     /* 5886 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule140Enabled),
     /* 5889 */   // MIs[0] dst
     /* 5889 */   // No operand predicates
     /* 5889 */   // MIs[0] Operand 1
     /* 5889 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 5893 */   // Combiner Rule #140: itof_const_zero_fold_ui
     /* 5893 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 5896 */ // Label 392: @5896
     /* 5896 */ GIM_Reject,
     /* 5897 */ // Label 75: @5897
     /* 5897 */ GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(5926), // Rule ID 19 //
     /* 5902 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 5905 */   // MIs[0] dst
     /* 5905 */   // No operand predicates
     /* 5905 */   // MIs[0] src
     /* 5905 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5909 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FABS),
     /* 5913 */   // MIs[1] __idempotent_prop_match_0.x
     /* 5913 */   // No operand predicates
     /* 5913 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5918 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5920 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[1]]
     /* 5920 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5925 */   GIR_EraseRootFromParent_Done,
     /* 5926 */ // Label 393: @5926
     /* 5926 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(5947), // Rule ID 177 //
     /* 5931 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule135Enabled),
     /* 5934 */   // MIs[0] dst
     /* 5934 */   // No operand predicates
     /* 5934 */   // MIs[0] src0
     /* 5934 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5938 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5942 */   // MIs[1] cst
     /* 5942 */   // No operand predicates
     /* 5942 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5944 */   // Combiner Rule #135: constant_fold_fabs
     /* 5944 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5947 */ // Label 394: @5947
     /* 5947 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(5975), // Rule ID 258 //
     /* 5952 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 5955 */   // MIs[0] dst
     /* 5955 */   // No operand predicates
     /* 5955 */   // MIs[0] tmp
     /* 5955 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5959 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 5963 */   // MIs[1] x
     /* 5963 */   // No operand predicates
     /* 5963 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5965 */   // Combiner Rule #170: fabs_fneg_fold
     /* 5965 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FABS),
     /* 5968 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 5970 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 5974 */   GIR_EraseRootFromParent_Done,
     /* 5975 */ // Label 395: @5975
     /* 5975 */ GIM_Reject,
     /* 5976 */ // Label 76: @5976
     /* 5976 */ GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(6005), // Rule ID 20 //
     /* 5981 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 5984 */   // MIs[0] dst
     /* 5984 */   // No operand predicates
     /* 5984 */   // MIs[0] src
     /* 5984 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5988 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCANONICALIZE),
     /* 5992 */   // MIs[1] __idempotent_prop_match_0.x
     /* 5992 */   // No operand predicates
     /* 5992 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5997 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5999 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[2]]
     /* 5999 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6004 */   GIR_EraseRootFromParent_Done,
     /* 6005 */ // Label 396: @6005
     /* 6005 */ GIM_Reject,
     /* 6006 */ // Label 77: @6006
     /* 6006 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(6017), // Rule ID 193 //
     /* 6011 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 6014 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMINNUM'
     /* 6014 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6017 */ // Label 397: @6017
     /* 6017 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(6028), // Rule ID 297 //
     /* 6022 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6025 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMINNUM'
     /* 6025 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6028 */ // Label 398: @6028
     /* 6028 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(6039), // Rule ID 333 //
     /* 6033 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 6036 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM'
     /* 6036 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6039 */ // Label 399: @6039
     /* 6039 */ GIM_Reject,
     /* 6040 */ // Label 78: @6040
     /* 6040 */ GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(6051), // Rule ID 194 //
     /* 6045 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 6048 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMAXNUM'
     /* 6048 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6051 */ // Label 400: @6051
     /* 6051 */ GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(6062), // Rule ID 298 //
     /* 6056 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6059 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMAXNUM'
     /* 6059 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6062 */ // Label 401: @6062
     /* 6062 */ GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(6073), // Rule ID 334 //
     /* 6067 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 6070 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM'
     /* 6070 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6073 */ // Label 402: @6073
     /* 6073 */ GIM_Reject,
     /* 6074 */ // Label 79: @6074
     /* 6074 */ GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(6085), // Rule ID 335 //
     /* 6079 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 6082 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM_IEEE'
     /* 6082 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6085 */ // Label 403: @6085
     /* 6085 */ GIM_Reject,
     /* 6086 */ // Label 80: @6086
     /* 6086 */ GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(6097), // Rule ID 336 //
     /* 6091 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 6094 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM_IEEE'
     /* 6094 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6097 */ // Label 404: @6097
     /* 6097 */ GIM_Reject,
     /* 6098 */ // Label 81: @6098
     /* 6098 */ GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(6109), // Rule ID 195 //
     /* 6103 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 6106 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMINIMUM'
     /* 6106 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6109 */ // Label 405: @6109
     /* 6109 */ GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(6120), // Rule ID 299 //
     /* 6114 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6117 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMINIMUM'
     /* 6117 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6120 */ // Label 406: @6120
     /* 6120 */ GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(6131), // Rule ID 337 //
     /* 6125 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 6128 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINIMUM'
     /* 6128 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6131 */ // Label 407: @6131
     /* 6131 */ GIM_Reject,
     /* 6132 */ // Label 82: @6132
     /* 6132 */ GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(6143), // Rule ID 196 //
     /* 6137 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 6140 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMAXIMUM'
     /* 6140 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6143 */ // Label 408: @6143
     /* 6143 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(6154), // Rule ID 300 //
     /* 6148 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6151 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMAXIMUM'
     /* 6151 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6154 */ // Label 409: @6154
     /* 6154 */ GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(6165), // Rule ID 338 //
     /* 6159 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 6162 */   // Combiner Rule #193: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXIMUM'
     /* 6162 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6165 */ // Label 410: @6165
     /* 6165 */ GIM_Reject,
     /* 6166 */ // Label 83: @6166
     /* 6166 */ GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(6177), // Rule ID 148 //
     /* 6171 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 6174 */   // Combiner Rule #106: reassoc_ptradd; wip_match_opcode 'G_PTR_ADD'
     /* 6174 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 6177 */ // Label 411: @6177
     /* 6177 */ GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(6188), // Rule ID 150 //
     /* 6182 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule108Enabled),
     /* 6185 */   // Combiner Rule #108: ptr_add_immed_chain; wip_match_opcode 'G_PTR_ADD'
     /* 6185 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /* 6188 */ // Label 412: @6188
     /* 6188 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(6199), // Rule ID 183 //
     /* 6193 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule141Enabled),
     /* 6196 */   // Combiner Rule #141: const_ptradd_to_i2p; wip_match_opcode 'G_PTR_ADD'
     /* 6196 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner83),
     /* 6199 */ // Label 413: @6199
     /* 6199 */ GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(6210), // Rule ID 199 //
     /* 6204 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule149Enabled),
     /* 6207 */   // Combiner Rule #149: ptr_add_with_zero; wip_match_opcode 'G_PTR_ADD'
     /* 6207 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner91),
     /* 6210 */ // Label 414: @6210
     /* 6210 */ GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(6221), // Rule ID 232 //
     /* 6215 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6218 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_PTR_ADD'
     /* 6218 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6221 */ // Label 415: @6221
     /* 6221 */ GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(6232), // Rule ID 277 //
     /* 6226 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6229 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_PTR_ADD'
     /* 6229 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6232 */ // Label 416: @6232
     /* 6232 */ GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(6255), // Rule ID 111 //
     /* 6237 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 6240 */   // MIs[0] dst
     /* 6240 */   // No operand predicates
     /* 6240 */   // MIs[0] lhs
     /* 6240 */   // No operand predicates
     /* 6240 */   // MIs[0] Operand 2
     /* 6240 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 6244 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6249 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[7]]
     /* 6249 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6254 */   GIR_EraseRootFromParent_Done,
     /* 6255 */ // Label 417: @6255
     /* 6255 */ GIM_Reject,
     /* 6256 */ // Label 84: @6256
     /* 6256 */ GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(6267), // Rule ID 245 //
     /* 6261 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6264 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SMIN'
     /* 6264 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6267 */ // Label 418: @6267
     /* 6267 */ GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(6278), // Rule ID 288 //
     /* 6272 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6275 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SMIN'
     /* 6275 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6278 */ // Label 419: @6278
     /* 6278 */ GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(6289), // Rule ID 315 //
     /* 6283 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6286 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SMIN'
     /* 6286 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6289 */ // Label 420: @6289
     /* 6289 */ GIM_Reject,
     /* 6290 */ // Label 85: @6290
     /* 6290 */ GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(6301), // Rule ID 246 //
     /* 6295 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6298 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SMAX'
     /* 6298 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6301 */ // Label 421: @6301
     /* 6301 */ GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(6312), // Rule ID 289 //
     /* 6306 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6309 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SMAX'
     /* 6309 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6312 */ // Label 422: @6312
     /* 6312 */ GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(6323), // Rule ID 316 //
     /* 6317 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6320 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_SMAX'
     /* 6320 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6323 */ // Label 423: @6323
     /* 6323 */ GIM_Reject,
     /* 6324 */ // Label 86: @6324
     /* 6324 */ GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(6335), // Rule ID 247 //
     /* 6329 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6332 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UMIN'
     /* 6332 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6335 */ // Label 424: @6335
     /* 6335 */ GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(6346), // Rule ID 290 //
     /* 6340 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6343 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UMIN'
     /* 6343 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6346 */ // Label 425: @6346
     /* 6346 */ GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(6357), // Rule ID 317 //
     /* 6351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6354 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UMIN'
     /* 6354 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6357 */ // Label 426: @6357
     /* 6357 */ GIM_Reject,
     /* 6358 */ // Label 87: @6358
     /* 6358 */ GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(6369), // Rule ID 248 //
     /* 6363 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6366 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UMAX'
     /* 6366 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6369 */ // Label 427: @6369
     /* 6369 */ GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(6380), // Rule ID 291 //
     /* 6374 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6377 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UMAX'
     /* 6377 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6380 */ // Label 428: @6380
     /* 6380 */ GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(6391), // Rule ID 318 //
     /* 6385 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6388 */   // Combiner Rule #192: commute_int_constant_to_rhs; wip_match_opcode 'G_UMAX'
     /* 6388 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6391 */ // Label 429: @6391
     /* 6391 */ GIM_Reject,
     /* 6392 */ // Label 88: @6392
     /* 6392 */ GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(6403), // Rule ID 86 //
     /* 6397 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 6400 */   // Combiner Rule #76: unary_undef_to_zero; wip_match_opcode 'G_ABS'
     /* 6400 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 6403 */ // Label 430: @6403
     /* 6403 */ GIM_Reject,
     /* 6404 */ // Label 89: @6404
     /* 6404 */ GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(6415), // Rule ID 175 //
     /* 6409 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule133Enabled),
     /* 6412 */   // Combiner Rule #133: opt_brcond_by_inverting_cond; wip_match_opcode 'G_BR'
     /* 6412 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner80),
     /* 6415 */ // Label 431: @6415
     /* 6415 */ GIM_Reject,
     /* 6416 */ // Label 90: @6416
     /* 6416 */ GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(6427), // Rule ID 26 //
     /* 6421 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 6424 */   // Combiner Rule #24: insert_vector_elt_oob; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6424 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 6427 */ // Label 432: @6427
     /* 6427 */ GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(6438), // Rule ID 67 //
     /* 6432 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule65Enabled),
     /* 6435 */   // Combiner Rule #65: combine_insert_vec_elts_build_vector; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6435 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner27),
     /* 6438 */ // Label 433: @6438
     /* 6438 */ GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(6449), // Rule ID 101 //
     /* 6443 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 6446 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6446 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 6449 */ // Label 434: @6449
     /* 6449 */ GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(6488), // Rule ID 38 //
     /* 6454 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule36Enabled),
     /* 6457 */   // MIs[0] root
     /* 6457 */   // No operand predicates
     /* 6457 */   // MIs[0] src
     /* 6457 */   // No operand predicates
     /* 6457 */   // MIs[0] elt
     /* 6457 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6461 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /* 6465 */   // MIs[1] src
     /* 6465 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 6470 */   // MIs[1] idx
     /* 6470 */   // No operand predicates
     /* 6470 */   // MIs[0] idx
     /* 6470 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 6475 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6480 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6482 */   // Combiner Rule #36: insert_vector_element_extract_vector_element
     /* 6482 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6487 */   GIR_EraseRootFromParent_Done,
     /* 6488 */ // Label 435: @6488
     /* 6488 */ GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(6521), // Rule ID 24 //
     /* 6493 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /* 6496 */   // MIs[0] root
     /* 6496 */   // No operand predicates
     /* 6496 */   // MIs[0] src
     /* 6496 */   // No operand predicates
     /* 6496 */   // MIs[0] elt
     /* 6496 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6500 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6504 */   // MIs[0] idx
     /* 6504 */   // No operand predicates
     /* 6504 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /* 6508 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6513 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6515 */   // Combiner Rule #22: insert_vector_element_elt_undef
     /* 6515 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6520 */   GIR_EraseRootFromParent_Done,
     /* 6521 */ // Label 436: @6521
     /* 6521 */ GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(6545), // Rule ID 23 //
     /* 6526 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /* 6529 */   // MIs[0] root
     /* 6529 */   // No operand predicates
     /* 6529 */   // MIs[0] src
     /* 6529 */   // No operand predicates
     /* 6529 */   // MIs[0] elt
     /* 6529 */   // No operand predicates
     /* 6529 */   // MIs[0] idx
     /* 6529 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 6533 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6537 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6539 */   // Combiner Rule #21: insert_vector_element_idx_undef
     /* 6539 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6542 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 6544 */   GIR_EraseRootFromParent_Done,
     /* 6545 */ // Label 437: @6545
     /* 6545 */ GIM_Reject,
     /* 6546 */ // Label 91: @6546
     /* 6546 */ GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(6557), // Rule ID 25 //
     /* 6551 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 6554 */   // Combiner Rule #23: match_extract_of_element; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6554 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 6557 */ // Label 438: @6557
     /* 6557 */ GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(6568), // Rule ID 68 //
     /* 6562 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule66Enabled),
     /* 6565 */   // Combiner Rule #66: extract_vec_elt_build_vec; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6565 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner28),
     /* 6568 */ // Label 439: @6568
     /* 6568 */ GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(6579), // Rule ID 74 //
     /* 6573 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule70Enabled),
     /* 6576 */   // Combiner Rule #70: combine_extracted_vector_load; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6576 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner32),
     /* 6579 */ // Label 440: @6579
     /* 6579 */ GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(6590), // Rule ID 102 //
     /* 6584 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 6587 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6587 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 6590 */ // Label 441: @6590
     /* 6590 */ GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(6614), // Rule ID 36 //
     /* 6595 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule34Enabled),
     /* 6598 */   // MIs[0] root
     /* 6598 */   // No operand predicates
     /* 6598 */   // MIs[0] src
     /* 6598 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6602 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6606 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/9,
     /* 6609 */   // MIs[1] x
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] y
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] z
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] a
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] b
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] c
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] d
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[1] e
     /* 6609 */   // No operand predicates
     /* 6609 */   // MIs[0] idx
     /* 6609 */   // No operand predicates
     /* 6609 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6611 */   // Combiner Rule #34: extract_vector_element_build_vector_trunc8
     /* 6611 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6614 */ // Label 442: @6614
     /* 6614 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(6638), // Rule ID 35 //
     /* 6619 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule33Enabled),
     /* 6622 */   // MIs[0] root
     /* 6622 */   // No operand predicates
     /* 6622 */   // MIs[0] src
     /* 6622 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6626 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6630 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/8,
     /* 6633 */   // MIs[1] x
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[1] y
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[1] z
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[1] a
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[1] b
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[1] c
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[1] d
     /* 6633 */   // No operand predicates
     /* 6633 */   // MIs[0] idx
     /* 6633 */   // No operand predicates
     /* 6633 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6635 */   // Combiner Rule #33: extract_vector_element_build_vector_trunc7
     /* 6635 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6638 */ // Label 443: @6638
     /* 6638 */ GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(6662), // Rule ID 34 //
     /* 6643 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule32Enabled),
     /* 6646 */   // MIs[0] root
     /* 6646 */   // No operand predicates
     /* 6646 */   // MIs[0] src
     /* 6646 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6650 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6654 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/7,
     /* 6657 */   // MIs[1] x
     /* 6657 */   // No operand predicates
     /* 6657 */   // MIs[1] y
     /* 6657 */   // No operand predicates
     /* 6657 */   // MIs[1] z
     /* 6657 */   // No operand predicates
     /* 6657 */   // MIs[1] a
     /* 6657 */   // No operand predicates
     /* 6657 */   // MIs[1] b
     /* 6657 */   // No operand predicates
     /* 6657 */   // MIs[1] c
     /* 6657 */   // No operand predicates
     /* 6657 */   // MIs[0] idx
     /* 6657 */   // No operand predicates
     /* 6657 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6659 */   // Combiner Rule #32: extract_vector_element_build_vector_trunc6
     /* 6659 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6662 */ // Label 444: @6662
     /* 6662 */ GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(6686), // Rule ID 33 //
     /* 6667 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule31Enabled),
     /* 6670 */   // MIs[0] root
     /* 6670 */   // No operand predicates
     /* 6670 */   // MIs[0] src
     /* 6670 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6674 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6678 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/6,
     /* 6681 */   // MIs[1] x
     /* 6681 */   // No operand predicates
     /* 6681 */   // MIs[1] y
     /* 6681 */   // No operand predicates
     /* 6681 */   // MIs[1] z
     /* 6681 */   // No operand predicates
     /* 6681 */   // MIs[1] a
     /* 6681 */   // No operand predicates
     /* 6681 */   // MIs[1] b
     /* 6681 */   // No operand predicates
     /* 6681 */   // MIs[0] idx
     /* 6681 */   // No operand predicates
     /* 6681 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6683 */   // Combiner Rule #31: extract_vector_element_build_vector_trunc5
     /* 6683 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6686 */ // Label 445: @6686
     /* 6686 */ GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(6710), // Rule ID 32 //
     /* 6691 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule30Enabled),
     /* 6694 */   // MIs[0] root
     /* 6694 */   // No operand predicates
     /* 6694 */   // MIs[0] src
     /* 6694 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6698 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6702 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/5,
     /* 6705 */   // MIs[1] x
     /* 6705 */   // No operand predicates
     /* 6705 */   // MIs[1] y
     /* 6705 */   // No operand predicates
     /* 6705 */   // MIs[1] z
     /* 6705 */   // No operand predicates
     /* 6705 */   // MIs[1] a
     /* 6705 */   // No operand predicates
     /* 6705 */   // MIs[0] idx
     /* 6705 */   // No operand predicates
     /* 6705 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6707 */   // Combiner Rule #30: extract_vector_element_build_vector_trunc4
     /* 6707 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6710 */ // Label 446: @6710
     /* 6710 */ GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(6734), // Rule ID 31 //
     /* 6715 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule29Enabled),
     /* 6718 */   // MIs[0] root
     /* 6718 */   // No operand predicates
     /* 6718 */   // MIs[0] src
     /* 6718 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6722 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6726 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /* 6729 */   // MIs[1] x
     /* 6729 */   // No operand predicates
     /* 6729 */   // MIs[1] y
     /* 6729 */   // No operand predicates
     /* 6729 */   // MIs[1] z
     /* 6729 */   // No operand predicates
     /* 6729 */   // MIs[0] idx
     /* 6729 */   // No operand predicates
     /* 6729 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6731 */   // Combiner Rule #29: extract_vector_element_build_vector_trunc3
     /* 6731 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6734 */ // Label 447: @6734
     /* 6734 */ GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(6768), // Rule ID 27 //
     /* 6739 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 6742 */   // MIs[0] root
     /* 6742 */   // No operand predicates
     /* 6742 */   // MIs[0] src
     /* 6742 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6746 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 6750 */   // MIs[1] x
     /* 6750 */   // No operand predicates
     /* 6750 */   // MIs[1] value
     /* 6750 */   // No operand predicates
     /* 6750 */   // MIs[1] idx
     /* 6750 */   // No operand predicates
     /* 6750 */   // MIs[0] idx
     /* 6750 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 6755 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 6760 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6762 */   // Combiner Rule #25: extract_vector_element_not_const
     /* 6762 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 6767 */   GIR_EraseRootFromParent_Done,
     /* 6768 */ // Label 448: @6768
     /* 6768 */ GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(6789), // Rule ID 28 //
     /* 6773 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule26Enabled),
     /* 6776 */   // MIs[0] root
     /* 6776 */   // No operand predicates
     /* 6776 */   // MIs[0] src
     /* 6776 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6780 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 6784 */   // MIs[1] x
     /* 6784 */   // No operand predicates
     /* 6784 */   // MIs[1] value
     /* 6784 */   // No operand predicates
     /* 6784 */   // MIs[1] idx2
     /* 6784 */   // No operand predicates
     /* 6784 */   // MIs[0] idx1
     /* 6784 */   // No operand predicates
     /* 6784 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6786 */   // Combiner Rule #26: extract_vector_element_different_indices
     /* 6786 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 6789 */ // Label 449: @6789
     /* 6789 */ GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(6818), // Rule ID 37 //
     /* 6794 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule35Enabled),
     /* 6797 */   // MIs[0] root
     /* 6797 */   // No operand predicates
     /* 6797 */   // MIs[0] src
     /* 6797 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6801 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHUFFLE_VECTOR),
     /* 6805 */   // MIs[1] src1
     /* 6805 */   // No operand predicates
     /* 6805 */   // MIs[1] src2
     /* 6805 */   // No operand predicates
     /* 6805 */   // MIs[1] mask
     /* 6805 */   // No operand predicates
     /* 6805 */   // MIs[0] idx
     /* 6805 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 6809 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 6813 */   // MIs[2] imm
     /* 6813 */   // No operand predicates
     /* 6813 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 6815 */   // Combiner Rule #35: extract_vector_element_shuffle_vector
     /* 6815 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 6818 */ // Label 450: @6818
     /* 6818 */ GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(6842), // Rule ID 30 //
     /* 6823 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule28Enabled),
     /* 6826 */   // MIs[0] root
     /* 6826 */   // No operand predicates
     /* 6826 */   // MIs[0] src
     /* 6826 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6830 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6834 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /* 6837 */   // MIs[1] x
     /* 6837 */   // No operand predicates
     /* 6837 */   // MIs[1] y
     /* 6837 */   // No operand predicates
     /* 6837 */   // MIs[0] idx
     /* 6837 */   // No operand predicates
     /* 6837 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6839 */   // Combiner Rule #28: extract_vector_element_build_vector_trunc2
     /* 6839 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6842 */ // Label 451: @6842
     /* 6842 */ GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(6874), // Rule ID 29 //
     /* 6847 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule27Enabled),
     /* 6850 */   // MIs[0] root
     /* 6850 */   // No operand predicates
     /* 6850 */   // MIs[0] src
     /* 6850 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6854 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 6858 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 6861 */   // MIs[1] unused
     /* 6861 */   // No operand predicates
     /* 6861 */   // MIs[0] idx
     /* 6861 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 6865 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 6869 */   // MIs[2] imm
     /* 6869 */   // No operand predicates
     /* 6869 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 6871 */   // Combiner Rule #27: extract_vector_element_build_vector
     /* 6871 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 6874 */ // Label 452: @6874
     /* 6874 */ GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(6898), // Rule ID 21 //
     /* 6879 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 6882 */   // MIs[0] root
     /* 6882 */   // No operand predicates
     /* 6882 */   // MIs[0] vector
     /* 6882 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6886 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6890 */   // MIs[0] idx
     /* 6890 */   // No operand predicates
     /* 6890 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6892 */   // Combiner Rule #19: match_extract_of_element_undef_vector
     /* 6892 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6895 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 6897 */   GIR_EraseRootFromParent_Done,
     /* 6898 */ // Label 453: @6898
     /* 6898 */ GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(6922), // Rule ID 22 //
     /* 6903 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 6906 */   // MIs[0] root
     /* 6906 */   // No operand predicates
     /* 6906 */   // MIs[0] vector
     /* 6906 */   // No operand predicates
     /* 6906 */   // MIs[0] idx
     /* 6906 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6910 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6914 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6916 */   // Combiner Rule #20: match_extract_of_element_undef_index
     /* 6916 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6919 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 6921 */   GIR_EraseRootFromParent_Done,
     /* 6922 */ // Label 454: @6922
     /* 6922 */ GIM_Reject,
     /* 6923 */ // Label 92: @6923
     /* 6923 */ GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(6934), // Rule ID 97 //
     /* 6928 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 6931 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6931 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 6934 */ // Label 455: @6934
     /* 6934 */ GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(6945), // Rule ID 99 //
     /* 6939 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule80Enabled),
     /* 6942 */   // Combiner Rule #80: propagate_undef_shuffle_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6942 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner41),
     /* 6945 */ // Label 456: @6945
     /* 6945 */ GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(6956), // Rule ID 346 //
     /* 6950 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule201Enabled),
     /* 6953 */   // Combiner Rule #201: combine_shuffle_concat; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6953 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner136),
     /* 6956 */ // Label 457: @6956
     /* 6956 */ GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(6967), // Rule ID 348 //
     /* 6961 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule203Enabled),
     /* 6964 */   // Combiner Rule #203: combine_shuffle_disjoint_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6964 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner138),
     /* 6967 */ // Label 458: @6967
     /* 6967 */ GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(6988), // Rule ID 347 //
     /* 6972 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule202Enabled),
     /* 6975 */   // MIs[0] root
     /* 6975 */   // No operand predicates
     /* 6975 */   // MIs[0] src1
     /* 6975 */   // No operand predicates
     /* 6975 */   // MIs[0] undef
     /* 6975 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6979 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6983 */   // MIs[0] mask
     /* 6983 */   // No operand predicates
     /* 6983 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6985 */   // Combiner Rule #202: combine_shuffle_undef_rhs
     /* 6985 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner137),
     /* 6988 */ // Label 459: @6988
     /* 6988 */ GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(6999), // Rule ID 366 //
     /* 6993 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule219Enabled),
     /* 6996 */   // MIs[0] dst
     /* 6996 */   // No operand predicates
     /* 6996 */   // MIs[0] src1
     /* 6996 */   // No operand predicates
     /* 6996 */   // MIs[0] src2
     /* 6996 */   // No operand predicates
     /* 6996 */   // MIs[0] mask
     /* 6996 */   // No operand predicates
     /* 6996 */   // Combiner Rule #219: combine_shuffle_vector_to_build_vector
     /* 6996 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner154),
     /* 6999 */ // Label 460: @6999
     /* 6999 */ GIM_Reject,
     /* 7000 */ // Label 93: @7000
     /* 7000 */ GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(7044), // Rule ID 223 //
     /* 7005 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule160Enabled),
     /* 7008 */   // MIs[0] d
     /* 7008 */   // No operand predicates
     /* 7008 */   // MIs[0] src
     /* 7008 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7012 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7016 */   // MIs[1] rev
     /* 7016 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 7020 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7024 */   // MIs[2] val
     /* 7024 */   // No operand predicates
     /* 7024 */   // MIs[1] amt
     /* 7024 */   // No operand predicates
     /* 7024 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner9),
     /* 7028 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7030 */   // Combiner Rule #160: bitreverse_lshr
     /* 7030 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SHL),
     /* 7033 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7035 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7039 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7043 */   GIR_EraseRootFromParent_Done,
     /* 7044 */ // Label 461: @7044
     /* 7044 */ GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(7088), // Rule ID 222 //
     /* 7049 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule159Enabled),
     /* 7052 */   // MIs[0] d
     /* 7052 */   // No operand predicates
     /* 7052 */   // MIs[0] src
     /* 7052 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7056 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 7060 */   // MIs[1] rev
     /* 7060 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 7064 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7068 */   // MIs[2] val
     /* 7068 */   // No operand predicates
     /* 7068 */   // MIs[1] amt
     /* 7068 */   // No operand predicates
     /* 7068 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner8),
     /* 7072 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7074 */   // Combiner Rule #159: bitreverse_shl
     /* 7074 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7077 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7079 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7083 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7087 */   GIR_EraseRootFromParent_Done,
     /* 7088 */ // Label 462: @7088
     /* 7088 */ GIM_Reject,
     /* 7089 */ // Label 94: @7089
     /* 7089 */ GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(7110), // Rule ID 178 //
     /* 7094 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule136Enabled),
     /* 7097 */   // MIs[0] dst
     /* 7097 */   // No operand predicates
     /* 7097 */   // MIs[0] src0
     /* 7097 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7101 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 7105 */   // MIs[1] cst
     /* 7105 */   // No operand predicates
     /* 7105 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7107 */   // Combiner Rule #136: constant_fold_fsqrt
     /* 7107 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 7110 */ // Label 463: @7110
     /* 7110 */ GIM_Reject,
     /* 7111 */ // Label 95: @7111
     /* 7111 */ GIM_Reject,
     /* 7112 */ }; // Size: 7112 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

