
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_messaging.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/server_id.h"
static PyTypeObject messaging_rec_Type;
static PyTypeObject messaging_reclog_Type;

static PyTypeObject *server_id_Type;
static PyTypeObject *BaseObject_Type;

static PyObject *py_messaging_rec_get_prev(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_prev;
	if (object->prev == NULL) {
		Py_RETURN_NONE;
	}
	if (object->prev == NULL) {
		py_prev = Py_None;
		Py_INCREF(py_prev);
	} else {
		py_prev = pytalloc_reference_ex(&messaging_rec_Type, object->prev, object->prev);
	}
	return py_prev;
}

static int py_messaging_rec_set_prev(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->prev));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->prev");
		return -1;
	}
	if (value == Py_None) {
		object->prev = NULL;
	} else {
		object->prev = NULL;
		PY_CHECK_TYPE(&messaging_rec_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->prev = (struct messaging_rec *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_messaging_rec_get_next(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	if (object->next == NULL) {
		Py_RETURN_NONE;
	}
	if (object->next == NULL) {
		py_next = Py_None;
		Py_INCREF(py_next);
	} else {
		py_next = pytalloc_reference_ex(&messaging_rec_Type, object->next, object->next);
	}
	return py_next;
}

static int py_messaging_rec_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->next));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next");
		return -1;
	}
	if (value == Py_None) {
		object->next = NULL;
	} else {
		object->next = NULL;
		PY_CHECK_TYPE(&messaging_rec_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next = (struct messaging_rec *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_messaging_rec_get_msg_version(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_msg_version;
	py_msg_version = PyLong_FromUnsignedLongLong((uint32_t)(object->msg_version));
	return py_msg_version;
}

static int py_messaging_rec_set_msg_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->msg_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->msg_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->msg_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_messaging_rec_get_msg_type(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_msg_type;
	py_msg_type = PyLong_FromUnsignedLongLong((uint32_t)(object->msg_type));
	return py_msg_type;
}

static int py_messaging_rec_set_msg_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->msg_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->msg_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->msg_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_messaging_rec_get_dest(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_dest;
	py_dest = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->dest);
	return py_dest;
}

static int py_messaging_rec_set_dest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dest");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dest = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_messaging_rec_get_src(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_src;
	py_src = pytalloc_reference_ex(server_id_Type, pytalloc_get_mem_ctx(obj), &object->src);
	return py_src;
}

static int py_messaging_rec_set_src(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->src");
		return -1;
	}
	PY_CHECK_TYPE(server_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->src = *(struct server_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_messaging_rec_get_buf(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_buf;
	py_buf = PyBytes_FromStringAndSize((char *)(object->buf).data, (object->buf).length);
	return py_buf;
}

static int py_messaging_rec_set_buf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buf");
		return -1;
	}
	object->buf = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_messaging_rec_get_num_fds(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_num_fds;
	py_num_fds = PyLong_FromLong((uint16_t)(object->num_fds));
	return py_num_fds;
}

static int py_messaging_rec_set_num_fds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_fds");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_fds));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_fds = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_messaging_rec_get_fds(PyObject *obj, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_fds;
	py_fds = PyList_New(object->num_fds);
	if (py_fds == NULL) {
		return NULL;
	}
	{
		int fds_cntr_0;
		for (fds_cntr_0 = 0; fds_cntr_0 < (object->num_fds); fds_cntr_0++) {
			PyObject *py_fds_0;
			py_fds_0 = PyLong_FromLongLong((object->fds)[fds_cntr_0]);
			PyList_SetItem(py_fds, fds_cntr_0, py_fds_0);
		}
	}
	return py_fds;
}

static int py_messaging_rec_set_fds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fds");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fds_cntr_0;
		object->fds = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->fds, PyList_GET_SIZE(value));
		if (!object->fds) { return -1; }
		talloc_set_name_const(object->fds, "ARRAY: object->fds");
		for (fds_cntr_0 = 0; fds_cntr_0 < PyList_GET_SIZE(value); fds_cntr_0++) {
			if (PyList_GET_ITEM(value, fds_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->fds)[fds_cntr_0]");
				return -1;
			}
			{
				const long long int_max = ndr_sizeof2intmax(sizeof((object->fds)[fds_cntr_0]));
				const long long int_min = -int_max - 1;
				if (PyLong_Check(PyList_GET_ITEM(value, fds_cntr_0))) {
					long long test_var;
					test_var = PyLong_AsLongLong(PyList_GET_ITEM(value, fds_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var < int_min || test_var > int_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
						  PyLong_Type.tp_name, int_min, int_max, test_var);
						return -1;
					}
					(object->fds)[fds_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_messaging_rec_getsetters[] = {
	{
		.name = discard_const_p(char, "prev"),
		.get = py_messaging_rec_get_prev,
		.set = py_messaging_rec_set_prev,
		.doc = discard_const_p(char, "PIDL-generated element of base type messaging_rec")
	},
	{
		.name = discard_const_p(char, "next"),
		.get = py_messaging_rec_get_next,
		.set = py_messaging_rec_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type messaging_rec")
	},
	{
		.name = discard_const_p(char, "msg_version"),
		.get = py_messaging_rec_get_msg_version,
		.set = py_messaging_rec_set_msg_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "msg_type"),
		.get = py_messaging_rec_get_msg_type,
		.set = py_messaging_rec_set_msg_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type messaging_type")
	},
	{
		.name = discard_const_p(char, "dest"),
		.get = py_messaging_rec_get_dest,
		.set = py_messaging_rec_set_dest,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "src"),
		.get = py_messaging_rec_get_src,
		.set = py_messaging_rec_set_src,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{
		.name = discard_const_p(char, "buf"),
		.get = py_messaging_rec_get_buf,
		.set = py_messaging_rec_set_buf,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "num_fds"),
		.get = py_messaging_rec_get_num_fds,
		.set = py_messaging_rec_set_num_fds,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "fds"),
		.get = py_messaging_rec_get_fds,
		.set = py_messaging_rec_set_fds,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{ .name = NULL }
};

static PyObject *py_messaging_rec_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct messaging_rec, type);
}

static PyObject *py_messaging_rec_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_messaging_rec);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_messaging_rec_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_messaging_rec);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_messaging_rec);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_messaging_rec_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct messaging_rec *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_messaging_rec, "messaging_rec", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_messaging_rec, "messaging_rec", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_messaging_rec_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_messaging_rec_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_messaging_rec_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_messaging_rec_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject messaging_rec_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "messaging.rec",
	.tp_getset = py_messaging_rec_getsetters,
	.tp_methods = py_messaging_rec_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_messaging_rec_new,
};


static PyObject *py_messaging_reclog_get_rec_index(PyObject *obj, void *closure)
{
	struct messaging_reclog *object = pytalloc_get_ptr(obj);
	PyObject *py_rec_index;
	py_rec_index = PyLong_FromUnsignedLongLong(object->rec_index);
	return py_rec_index;
}

static int py_messaging_reclog_set_rec_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_reclog *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rec_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rec_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rec_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_messaging_reclog_get_num_recs(PyObject *obj, void *closure)
{
	struct messaging_reclog *object = pytalloc_get_ptr(obj);
	PyObject *py_num_recs;
	py_num_recs = PyLong_FromUnsignedLongLong((uint32_t)(object->num_recs));
	return py_num_recs;
}

static int py_messaging_reclog_set_num_recs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_reclog *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_recs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_recs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_recs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_messaging_reclog_get_recs(PyObject *obj, void *closure)
{
	struct messaging_reclog *object = pytalloc_get_ptr(obj);
	PyObject *py_recs;
	py_recs = PyList_New(object->num_recs);
	if (py_recs == NULL) {
		return NULL;
	}
	{
		int recs_cntr_0;
		for (recs_cntr_0 = 0; recs_cntr_0 < (object->num_recs); recs_cntr_0++) {
			PyObject *py_recs_0;
			if ((object->recs)[recs_cntr_0] == NULL) {
				py_recs_0 = Py_None;
				Py_INCREF(py_recs_0);
			} else {
				py_recs_0 = pytalloc_reference_ex(&messaging_rec_Type, (object->recs)[recs_cntr_0], (object->recs)[recs_cntr_0]);
			}
			PyList_SetItem(py_recs, recs_cntr_0, py_recs_0);
		}
	}
	return py_recs;
}

static int py_messaging_reclog_set_recs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct messaging_reclog *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->recs");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int recs_cntr_0;
		object->recs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->recs, PyList_GET_SIZE(value));
		if (!object->recs) { return -1; }
		talloc_set_name_const(object->recs, "ARRAY: object->recs");
		for (recs_cntr_0 = 0; recs_cntr_0 < PyList_GET_SIZE(value); recs_cntr_0++) {
			if (PyList_GET_ITEM(value, recs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->recs)[recs_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, recs_cntr_0) == Py_None) {
				(object->recs)[recs_cntr_0] = NULL;
			} else {
				(object->recs)[recs_cntr_0] = NULL;
				PY_CHECK_TYPE(&messaging_rec_Type, PyList_GET_ITEM(value, recs_cntr_0), return -1;);
				if (talloc_reference(object->recs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, recs_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->recs)[recs_cntr_0] = (struct messaging_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, recs_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_messaging_reclog_getsetters[] = {
	{
		.name = discard_const_p(char, "rec_index"),
		.get = py_messaging_reclog_get_rec_index,
		.set = py_messaging_reclog_set_rec_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "num_recs"),
		.get = py_messaging_reclog_get_num_recs,
		.set = py_messaging_reclog_set_num_recs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "recs"),
		.get = py_messaging_reclog_get_recs,
		.set = py_messaging_reclog_set_recs,
		.doc = discard_const_p(char, "PIDL-generated element of base type messaging_rec")
	},
	{ .name = NULL }
};

static PyObject *py_messaging_reclog_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct messaging_reclog, type);
}

static PyObject *py_messaging_reclog_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct messaging_reclog *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_messaging_reclog);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_messaging_reclog_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct messaging_reclog *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_messaging_reclog);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_messaging_reclog);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_messaging_reclog_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct messaging_reclog *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_messaging_reclog, "messaging_reclog", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_messaging_reclog, "messaging_reclog", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_messaging_reclog_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_messaging_reclog_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_messaging_reclog_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_messaging_reclog_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject messaging_reclog_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "messaging.reclog",
	.tp_getset = py_messaging_reclog_getsetters,
	.tp_methods = py_messaging_reclog_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_messaging_reclog_new,
};

static PyMethodDef messaging_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "messaging",
	.m_doc = "messaging DCE/RPC",
	.m_size = -1,
	.m_methods = messaging_methods,
};
MODULE_INIT_FUNC(messaging)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_server_id = NULL;
	PyObject *dep_talloc = NULL;

	dep_samba_dcerpc_server_id = PyImport_ImportModule("samba.dcerpc.server_id");
	if (dep_samba_dcerpc_server_id == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	server_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_server_id, "server_id");
	if (server_id_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	messaging_rec_Type.tp_base = BaseObject_Type;
	messaging_rec_Type.tp_basicsize = pytalloc_BaseObject_size();

	messaging_reclog_Type.tp_base = BaseObject_Type;
	messaging_reclog_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&messaging_rec_Type) < 0)
		goto out;
	if (PyType_Ready(&messaging_reclog_Type) < 0)
		goto out;
#ifdef PY_REC_PATCH
	PY_REC_PATCH(&messaging_rec_Type);
#endif
#ifdef PY_RECLOG_PATCH
	PY_RECLOG_PATCH(&messaging_reclog_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "MSG_TYPE_MASK", PyLong_FromUnsignedLongLong(0xFFFF));
	PyModule_AddObject(m, "AUTH_EVENT_NAME", PyUnicode_FromString("auth_event"));
	PyModule_AddObject(m, "DSDB_EVENT_NAME", PyUnicode_FromString("dsdb_event"));
	PyModule_AddObject(m, "DSDB_PWD_EVENT_NAME", PyUnicode_FromString("dsdb_password_event"));
	PyModule_AddObject(m, "DSDB_GROUP_EVENT_NAME", PyUnicode_FromString("dsdb_group_event"));
	PyModule_AddObject(m, "MSG_DEBUG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DEBUG)));
	PyModule_AddObject(m, "MSG_PING", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PING)));
	PyModule_AddObject(m, "MSG_PONG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PONG)));
	PyModule_AddObject(m, "MSG_PROFILE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PROFILE)));
	PyModule_AddObject(m, "MSG_REQ_DEBUGLEVEL", PyLong_FromUnsignedLongLong((uint32_t)(MSG_REQ_DEBUGLEVEL)));
	PyModule_AddObject(m, "MSG_DEBUGLEVEL", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DEBUGLEVEL)));
	PyModule_AddObject(m, "MSG_REQ_PROFILELEVEL", PyLong_FromUnsignedLongLong((uint32_t)(MSG_REQ_PROFILELEVEL)));
	PyModule_AddObject(m, "MSG_PROFILELEVEL", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PROFILELEVEL)));
	PyModule_AddObject(m, "MSG_REQ_POOL_USAGE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_REQ_POOL_USAGE)));
	PyModule_AddObject(m, "MSG_POOL_USAGE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_POOL_USAGE)));
	PyModule_AddObject(m, "MSG_REQ_DMALLOC_MARK", PyLong_FromUnsignedLongLong((uint32_t)(MSG_REQ_DMALLOC_MARK)));
	PyModule_AddObject(m, "MSG_REQ_DMALLOC_LOG_CHANGED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_REQ_DMALLOC_LOG_CHANGED)));
	PyModule_AddObject(m, "MSG_SHUTDOWN", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SHUTDOWN)));
	PyModule_AddObject(m, "ID_CACHE_DELETE", PyLong_FromUnsignedLongLong((uint32_t)(ID_CACHE_DELETE)));
	PyModule_AddObject(m, "ID_CACHE_KILL", PyLong_FromUnsignedLongLong((uint32_t)(ID_CACHE_KILL)));
	PyModule_AddObject(m, "MSG_SMB_CONF_UPDATED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_CONF_UPDATED)));
	PyModule_AddObject(m, "MSG_RELOAD_TLS_CERTIFICATES", PyLong_FromUnsignedLongLong((uint32_t)(MSG_RELOAD_TLS_CERTIFICATES)));
	PyModule_AddObject(m, "MSG_PREFORK_CHILD_EVENT", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PREFORK_CHILD_EVENT)));
	PyModule_AddObject(m, "MSG_PREFORK_PARENT_EVENT", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PREFORK_PARENT_EVENT)));
	PyModule_AddObject(m, "MSG_REQ_RINGBUF_LOG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_REQ_RINGBUF_LOG)));
	PyModule_AddObject(m, "MSG_RINGBUF_LOG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_RINGBUF_LOG)));
	PyModule_AddObject(m, "MSG_DAEMON_READY_FD", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DAEMON_READY_FD)));
	PyModule_AddObject(m, "MSG_FORCE_ELECTION", PyLong_FromUnsignedLongLong((uint32_t)(MSG_FORCE_ELECTION)));
	PyModule_AddObject(m, "MSG_WINS_NEW_ENTRY", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINS_NEW_ENTRY)));
	PyModule_AddObject(m, "MSG_SEND_PACKET", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SEND_PACKET)));
	PyModule_AddObject(m, "MSG_PRINTER_NOTIFY2", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PRINTER_NOTIFY2)));
	PyModule_AddObject(m, "MSG_PRINTER_DRVUPGRADE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PRINTER_DRVUPGRADE)));
	PyModule_AddObject(m, "MSG_PRINTERDATA_INIT_RESET", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PRINTERDATA_INIT_RESET)));
	PyModule_AddObject(m, "MSG_PRINTER_UPDATE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PRINTER_UPDATE)));
	PyModule_AddObject(m, "MSG_PRINTER_MOD", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PRINTER_MOD)));
	PyModule_AddObject(m, "MSG_PRINTER_PCAP", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PRINTER_PCAP)));
	PyModule_AddObject(m, "MSG_SMB_FORCE_TDIS", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_FORCE_TDIS)));
	PyModule_AddObject(m, "MSG_SMB_BREAK_REQUEST", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_BREAK_REQUEST)));
	PyModule_AddObject(m, "MSG_SMB_KERNEL_BREAK", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_KERNEL_BREAK)));
	PyModule_AddObject(m, "MSG_SMB_FILE_RENAME", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_FILE_RENAME)));
	PyModule_AddObject(m, "MSG_SMB_INJECT_FAULT", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_INJECT_FAULT)));
	PyModule_AddObject(m, "MSG_SMB_BLOCKING_LOCK_CANCEL", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_BLOCKING_LOCK_CANCEL)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY)));
	PyModule_AddObject(m, "MSG_PVFS_NOTIFY", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PVFS_NOTIFY)));
	PyModule_AddObject(m, "MSG_SMB_CLOSE_FILE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_CLOSE_FILE)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_CLEANUP", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_CLEANUP)));
	PyModule_AddObject(m, "MSG_SMB_SCAVENGER", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_SCAVENGER)));
	PyModule_AddObject(m, "MSG_SMB_KILL_CLIENT_IP", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_KILL_CLIENT_IP)));
	PyModule_AddObject(m, "MSG_SMB_TELL_NUM_CHILDREN", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_TELL_NUM_CHILDREN)));
	PyModule_AddObject(m, "MSG_SMB_NUM_CHILDREN", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NUM_CHILDREN)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_CANCEL_DELETED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_CANCEL_DELETED)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_REC_CHANGE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_REC_CHANGE)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_TRIGGER", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_TRIGGER)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_GET_DB", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_GET_DB)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_DB", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_DB)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_REC_CHANGES", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_REC_CHANGES)));
	PyModule_AddObject(m, "MSG_SMB_NOTIFY_STARTED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_NOTIFY_STARTED)));
	PyModule_AddObject(m, "MSG_SMB_SLEEP", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_SLEEP)));
	PyModule_AddObject(m, "MSG_SMB_FORCE_TDIS_DENIED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_FORCE_TDIS_DENIED)));
	PyModule_AddObject(m, "MSG_SMB_IP_DROPPED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMB_IP_DROPPED)));
	PyModule_AddObject(m, "MSG_WINBIND_FINISHED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_FINISHED)));
	PyModule_AddObject(m, "MSG_WINBIND_FORGET_STATE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_FORGET_STATE)));
	PyModule_AddObject(m, "MSG_WINBIND_ONLINE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_ONLINE)));
	PyModule_AddObject(m, "MSG_WINBIND_OFFLINE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_OFFLINE)));
	PyModule_AddObject(m, "MSG_WINBIND_ONLINESTATUS", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_ONLINESTATUS)));
	PyModule_AddObject(m, "MSG_WINBIND_VALIDATE_CACHE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_VALIDATE_CACHE)));
	PyModule_AddObject(m, "MSG_WINBIND_DUMP_DOMAIN_LIST", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_DUMP_DOMAIN_LIST)));
	PyModule_AddObject(m, "MSG_WINBIND_IP_DROPPED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_IP_DROPPED)));
	PyModule_AddObject(m, "MSG_WINBIND_DOMAIN_ONLINE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_DOMAIN_ONLINE)));
	PyModule_AddObject(m, "MSG_WINBIND_DOMAIN_OFFLINE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_DOMAIN_OFFLINE)));
	PyModule_AddObject(m, "MSG_WINBIND_RELOAD_TRUSTED_DOMAINS", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_RELOAD_TRUSTED_DOMAINS)));
	PyModule_AddObject(m, "MSG_WINBIND_DISCONNECT_DC", PyLong_FromUnsignedLongLong((uint32_t)(MSG_WINBIND_DISCONNECT_DC)));
	PyModule_AddObject(m, "MSG_SMBXSRV_SESSION_CLOSE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMBXSRV_SESSION_CLOSE)));
	PyModule_AddObject(m, "MSG_SMBXSRV_CONNECTION_PASS", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMBXSRV_CONNECTION_PASS)));
	PyModule_AddObject(m, "MSG_SMBXSRV_CONNECTION_PASSED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMBXSRV_CONNECTION_PASSED)));
	PyModule_AddObject(m, "MSG_SMBXSRV_CONNECTION_DROP", PyLong_FromUnsignedLongLong((uint32_t)(MSG_SMBXSRV_CONNECTION_DROP)));
	PyModule_AddObject(m, "MSG_RPCD_WITNESS_REGISTRATION_UPDATE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_RPCD_WITNESS_REGISTRATION_UPDATE)));
	PyModule_AddObject(m, "MSG_BRL_RETRY", PyLong_FromUnsignedLongLong((uint32_t)(MSG_BRL_RETRY)));
	PyModule_AddObject(m, "MSG_PVFS_RETRY_OPEN", PyLong_FromUnsignedLongLong((uint32_t)(MSG_PVFS_RETRY_OPEN)));
	PyModule_AddObject(m, "MSG_IRPC", PyLong_FromUnsignedLongLong((uint32_t)(MSG_IRPC)));
	PyModule_AddObject(m, "MSG_NTVFS_OPLOCK_BREAK", PyLong_FromUnsignedLongLong((uint32_t)(MSG_NTVFS_OPLOCK_BREAK)));
	PyModule_AddObject(m, "MSG_DREPL_ALLOCATE_RID", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DREPL_ALLOCATE_RID)));
	PyModule_AddObject(m, "MSG_AUTH_LOG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_AUTH_LOG)));
	PyModule_AddObject(m, "MSG_DSDB_LOG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DSDB_LOG)));
	PyModule_AddObject(m, "MSG_DSDB_PWD_LOG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DSDB_PWD_LOG)));
	PyModule_AddObject(m, "MSG_GROUP_LOG", PyLong_FromUnsignedLongLong((uint32_t)(MSG_GROUP_LOG)));
	PyModule_AddObject(m, "MSG_DBWRAP_MODIFIED", PyLong_FromUnsignedLongLong((uint32_t)(MSG_DBWRAP_MODIFIED)));
	PyModule_AddObject(m, "MSG_RPC_HOST_NEW_CLIENT", PyLong_FromUnsignedLongLong((uint32_t)(MSG_RPC_HOST_NEW_CLIENT)));
	PyModule_AddObject(m, "MSG_RPC_WORKER_STATUS", PyLong_FromUnsignedLongLong((uint32_t)(MSG_RPC_WORKER_STATUS)));
	PyModule_AddObject(m, "MSG_RPC_DUMP_STATUS", PyLong_FromUnsignedLongLong((uint32_t)(MSG_RPC_DUMP_STATUS)));
	PyModule_AddObject(m, "MSG_TMP_BASE", PyLong_FromUnsignedLongLong((uint32_t)(MSG_TMP_BASE)));
	Py_INCREF((PyObject *)(void *)&messaging_rec_Type);
	PyModule_AddObject(m, "rec", (PyObject *)(void *)&messaging_rec_Type);
	Py_INCREF((PyObject *)(void *)&messaging_reclog_Type);
	PyModule_AddObject(m, "reclog", (PyObject *)(void *)&messaging_reclog_Type);
#ifdef PY_MOD_MESSAGING_PATCH
	PY_MOD_MESSAGING_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_server_id);
	Py_XDECREF(dep_talloc);
	return m;

}
