/* OperatingSystemView.c generated by valac 0.56.18, the Vala compiler
 * generated from OperatingSystemView.vala, do not modify */

/*
* Copyright 2020–2021 elementary, Inc. (https://elementary.io)
*           2015 Ivo Nunes, Akshay Shekher
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "system.h"
#include <glib.h>
#include <gio/gio.h>
#include <adwaita.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <packagekit-glib2/packagekit.h>
#include <libsoup/soup.h>
#include <json-glib/json-glib.h>
#include <sys/utsname.h>
#include <pango/pango.h>
#include <gio/gdesktopappinfo.h>

#define ABOUT_GETTEXT_PACKAGE "io.elementary.settings.system"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW (about_operating_system_view_sponsor_us_row_get_type ())
#define ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRow))
#define ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRowClass))
#define ABOUT_OPERATING_SYSTEM_VIEW_IS_SPONSOR_US_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW))
#define ABOUT_OPERATING_SYSTEM_VIEW_IS_SPONSOR_US_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW))
#define ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRowClass))

typedef struct _AboutOperatingSystemViewSponsorUsRow AboutOperatingSystemViewSponsorUsRow;
typedef struct _AboutOperatingSystemViewSponsorUsRowClass AboutOperatingSystemViewSponsorUsRowClass;
enum  {
	ABOUT_OPERATING_SYSTEM_VIEW_0_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_operating_system_view_properties[ABOUT_OPERATING_SYSTEM_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _system_update_current_state_free0(var) ((var == NULL) ? NULL : (var = (system_update_current_state_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AboutOperatingSystemViewLoadLogoData AboutOperatingSystemViewLoadLogoData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AboutOperatingSystemViewGetUpstreamReleaseData AboutOperatingSystemViewGetUpstreamReleaseData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _AboutOperatingSystemViewUpdateStateData AboutOperatingSystemViewUpdateStateData;
typedef struct _AboutOperatingSystemViewRefreshClickedData AboutOperatingSystemViewRefreshClickedData;
typedef struct _Block11Data Block11Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

#define ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW (about_operating_system_view_link_row_get_type ())
#define ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRow))
#define ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRowClass))
#define ABOUT_OPERATING_SYSTEM_VIEW_IS_LINK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW))
#define ABOUT_OPERATING_SYSTEM_VIEW_IS_LINK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW))
#define ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRowClass))

typedef struct _AboutOperatingSystemViewLinkRow AboutOperatingSystemViewLinkRow;
typedef struct _AboutOperatingSystemViewLinkRowClass AboutOperatingSystemViewLinkRowClass;
typedef struct _AboutOperatingSystemViewLinkRowPrivate AboutOperatingSystemViewLinkRowPrivate;
enum  {
	ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_0_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_URI_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_ICON_NAME_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_LABEL_STRING_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_COLOR_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_NUM_PROPERTIES
};
static GParamSpec* about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_NUM_PROPERTIES];
typedef struct _AboutOperatingSystemViewSponsorUsRowPrivate AboutOperatingSystemViewSponsorUsRowPrivate;
enum  {
	ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_0_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_URI_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_WAS_LOADED_PROPERTY,
	ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_NUM_PROPERTIES
};
static GParamSpec* about_operating_system_view_sponsor_us_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_NUM_PROPERTIES];
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _AboutOperatingSystemViewPrivate {
	guint64 download_size_remaining;
	guint64 download_size_max;
	GFile* logo_file;
	AdwAvatar* logo;
	GtkStringList* packages;
	SystemUpdate* update_proxy;
	SystemUpdateCurrentState* current_state;
	GtkGrid* software_grid;
	GtkImage* updates_image;
	GtkLabel* updates_title;
	GtkProgressBar* update_progress_bar;
	GtkRevealer* update_progress_revealer;
	GtkLabel* updates_description;
	GtkRevealer* details_button_revealer;
	GtkStack* button_stack;
	AboutOperatingSystemViewSponsorUsRow* sponsor_us_row;
};

struct _AboutOperatingSystemViewLoadLogoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutOperatingSystemView* self;
	gboolean _tmp0_;
	AdwAvatar* _tmp1_;
	GFile* _tmp2_;
	GBytes* bytes;
	GFile* _tmp3_;
	GBytes* _tmp4_;
	GdkTexture* _tmp5_;
	GBytes* _tmp6_;
	GdkTexture* _tmp7_;
	AdwAvatar* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _AboutOperatingSystemViewGetUpstreamReleaseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutOperatingSystemView* self;
	GFile* file;
	GFile* _tmp0_;
	gchar* upstream_release;
	GFileInputStream* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis;
	GDataInputStream* _tmp4_;
	gchar* line;
	gchar* _tmp5_;
	GDataInputStream* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar** distrib_component;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint distrib_component_length1;
	gint _distrib_component_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GtkLabel* based_off;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkGrid* _tmp35_;
	GtkLabel* _tmp36_;
	GError* _inner_error0_;
};

struct _AboutOperatingSystemViewUpdateStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutOperatingSystemView* self;
	SystemUpdate* _tmp0_;
	SystemUpdateCurrentState _tmp1_;
	SystemUpdate* _tmp2_;
	SystemUpdateCurrentState _tmp3_;
	SystemUpdateCurrentState _tmp4_;
	SystemUpdateCurrentState _tmp5_;
	SystemUpdateCurrentState* _tmp6_;
	GError* e;
	GtkImage* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkStack* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GtkRevealer* _tmp13_;
	gboolean _tmp14_;
	SystemUpdateCurrentState* _tmp15_;
	SystemUpdateCurrentState* _tmp16_;
	GtkRevealer* _tmp17_;
	SystemUpdateCurrentState* _tmp18_;
	GtkImage* _tmp19_;
	GtkLabel* _tmp20_;
	gint64 last_refresh_time;
	SystemUpdate* _tmp21_;
	GtkLabel* _tmp22_;
	GDateTime* _tmp23_;
	GDateTime* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _vala1_e;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GtkLabel* _tmp31_;
	GtkStack* _tmp32_;
	GtkImage* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	SystemUpdateCurrentState* _tmp36_;
	const gchar* _tmp37_;
	GtkStack* _tmp38_;
	GtkImage* _tmp39_;
	GtkLabel* _tmp40_;
	GtkStack* _tmp41_;
	SystemUpdateUpdateDetails details;
	SystemUpdate* _tmp42_;
	SystemUpdateUpdateDetails _tmp43_;
	GtkLabel* _tmp44_;
	SystemUpdateUpdateDetails _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	SystemUpdateUpdateDetails _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	SystemUpdateUpdateDetails _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	SystemUpdateUpdateDetails _tmp54_;
	PkInfoEnum* _tmp55_;
	gint _tmp55__length1;
	GtkImage* _tmp56_;
	GtkStringList* _tmp57_;
	GtkStringList* _tmp58_;
	SystemUpdateUpdateDetails _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	GError* _vala2_e;
	GtkLabel* _tmp61_;
	GError* _tmp62_;
	const gchar* _tmp63_;
	GtkRevealer* _tmp64_;
	SystemUpdateCurrentState* _tmp65_;
	GtkProgressBar* _tmp66_;
	SystemUpdateCurrentState* _tmp67_;
	SystemUpdateCurrentState* _tmp68_;
	GtkImage* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	SystemUpdateCurrentState* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GtkStack* _tmp78_;
	GtkImage* _tmp79_;
	GtkLabel* _tmp80_;
	GtkLabel* _tmp81_;
	GtkStack* _tmp82_;
	GtkImage* _tmp83_;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkStack* _tmp86_;
	GError* _inner_error0_;
};

struct _AboutOperatingSystemViewRefreshClickedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutOperatingSystemView* self;
	SystemUpdate* _tmp0_;
	SystemUpdate* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _Block11Data {
	int _ref_count_;
	AboutOperatingSystemView* self;
	GraniteMessageDialog* dialog;
};

struct _AboutOperatingSystemViewLinkRow {
	GtkListBoxRow parent_instance;
	AboutOperatingSystemViewLinkRowPrivate * priv;
};

struct _AboutOperatingSystemViewLinkRowClass {
	GtkListBoxRowClass parent_class;
};

struct _AboutOperatingSystemViewLinkRowPrivate {
	gchar* _uri;
	gchar* _icon_name;
	gchar* _label_string;
	gchar* _color;
};

struct _AboutOperatingSystemViewSponsorUsRow {
	GtkListBoxRow parent_instance;
	AboutOperatingSystemViewSponsorUsRowPrivate * priv;
};

struct _AboutOperatingSystemViewSponsorUsRowClass {
	GtkListBoxRowClass parent_class;
};

struct _AboutOperatingSystemViewSponsorUsRowPrivate {
	gchar* _uri;
	GtkLabel* target_label;
	GtkLevelBar* levelbar;
	GtkRevealer* details_revealer;
};

struct _Block12Data {
	int _ref_count_;
	AboutOperatingSystemViewSponsorUsRow* self;
	SoupSession* session;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	gdouble target_value;
};

static gint AboutOperatingSystemView_private_offset;
static gpointer about_operating_system_view_parent_class = NULL;
static gchar* about_operating_system_view__bug_url;
static gchar* about_operating_system_view__bug_url = NULL;
static gchar* about_operating_system_view__documentation_url;
static gchar* about_operating_system_view__documentation_url = NULL;
static gchar* about_operating_system_view__website_url;
static gchar* about_operating_system_view__website_url = NULL;
static gchar* about_operating_system_view__support_url;
static gchar* about_operating_system_view__support_url = NULL;
static gint AboutOperatingSystemViewLinkRow_private_offset;
static gpointer about_operating_system_view_link_row_parent_class = NULL;
static gint AboutOperatingSystemViewSponsorUsRow_private_offset;
static gpointer about_operating_system_view_sponsor_us_row_parent_class = NULL;

static GType about_operating_system_view_sponsor_us_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void about_operating_system_view_load_logo_data_free (gpointer _data);
static gboolean about_operating_system_view_load_logo_co (AboutOperatingSystemViewLoadLogoData* _data_);
static void about_operating_system_view_load_logo_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static gboolean about_operating_system_view_sponsor_us_row_get_was_loaded (AboutOperatingSystemViewSponsorUsRow* self);
static void about_operating_system_view_sponsor_us_row_get_goal_progress (AboutOperatingSystemViewSponsorUsRow* self,
                                                                   GCancellable* cancellable);
static void about_operating_system_view_get_upstream_release_data_free (gpointer _data);
static void about_operating_system_view_get_upstream_release (AboutOperatingSystemView* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void about_operating_system_view_get_upstream_release_finish (AboutOperatingSystemView* self,
                                                              GAsyncResult* _res_);
static gboolean about_operating_system_view_get_upstream_release_co (AboutOperatingSystemViewGetUpstreamReleaseData* _data_);
static void about_operating_system_view_get_upstream_release_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void about_operating_system_view_update_state_data_free (gpointer _data);
static void about_operating_system_view_update_state (AboutOperatingSystemView* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void about_operating_system_view_update_state_finish (AboutOperatingSystemView* self,
                                                      GAsyncResult* _res_);
static gboolean about_operating_system_view_update_state_co (AboutOperatingSystemViewUpdateStateData* _data_);
static void about_operating_system_view_update_state_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static gboolean _vala_pk_info_array_contains (PkInfoEnum * stack,
                                       gssize stack_length,
                                       const PkInfoEnum needle);
static gchar* about_operating_system_view_to_progress_text (AboutOperatingSystemView* self,
                                                     guint64 remain_size,
                                                     guint64 total_size);
static void about_operating_system_view_details_clicked (AboutOperatingSystemView* self);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void about_operating_system_view_refresh_clicked_data_free (gpointer _data);
static void about_operating_system_view_refresh_clicked (AboutOperatingSystemView* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void about_operating_system_view_refresh_clicked_finish (AboutOperatingSystemView* self,
                                                         GAsyncResult* _res_);
static gboolean about_operating_system_view_refresh_clicked_co (AboutOperatingSystemViewRefreshClickedData* _data_);
static void about_operating_system_view_refresh_clicked_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void about_operating_system_view_launch_uri (AboutOperatingSystemView* self,
                                             const gchar* uri);
static void about_operating_system_view_settings_restore_clicked (AboutOperatingSystemView* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda8_ (Block11Data* _data11_,
                 gint response);
static gchar** about_operating_system_view_get_pantheon_schemas (gint* result_length1);
static void about_operating_system_view_reset_recursively (const gchar* schema);
static void ___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static void about_operating_system_view_reset_all_keys (GSettings* settings);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static const gchar* about_operating_system_view_get_bug_url (void);
static const gchar* about_operating_system_view_get_documentation_url (void);
static const gchar* about_operating_system_view_get_website_url (void);
static const gchar* about_operating_system_view_get_support_url (void);
static GType about_operating_system_view_link_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static AboutOperatingSystemViewLinkRow* about_operating_system_view_link_row_new (const gchar* uri,
                                                                           const gchar* label_string,
                                                                           const gchar* icon_name,
                                                                           const gchar* color);
static AboutOperatingSystemViewLinkRow* about_operating_system_view_link_row_construct (GType object_type,
                                                                                 const gchar* uri,
                                                                                 const gchar* label_string,
                                                                                 const gchar* icon_name,
                                                                                 const gchar* color);
static const gchar* about_operating_system_view_link_row_get_uri (AboutOperatingSystemViewLinkRow* self);
static void about_operating_system_view_link_row_set_uri (AboutOperatingSystemViewLinkRow* self,
                                                   const gchar* value);
static const gchar* about_operating_system_view_link_row_get_icon_name (AboutOperatingSystemViewLinkRow* self);
static void about_operating_system_view_link_row_set_icon_name (AboutOperatingSystemViewLinkRow* self,
                                                         const gchar* value);
static const gchar* about_operating_system_view_link_row_get_label_string (AboutOperatingSystemViewLinkRow* self);
static void about_operating_system_view_link_row_set_label_string (AboutOperatingSystemViewLinkRow* self,
                                                            const gchar* value);
static const gchar* about_operating_system_view_link_row_get_color (AboutOperatingSystemViewLinkRow* self);
static void about_operating_system_view_link_row_set_color (AboutOperatingSystemViewLinkRow* self,
                                                     const gchar* value);
static GObject * about_operating_system_view_link_row_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void about_operating_system_view_link_row_finalize (GObject * obj);
static GType about_operating_system_view_link_row_get_type_once (void);
static void _vala_about_operating_system_view_link_row_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_about_operating_system_view_link_row_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static AboutOperatingSystemViewSponsorUsRow* about_operating_system_view_sponsor_us_row_new (const gchar* uri);
static AboutOperatingSystemViewSponsorUsRow* about_operating_system_view_sponsor_us_row_construct (GType object_type,
                                                                                            const gchar* uri);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda4_ (Block12Data* _data12_,
                 GObject* obj,
                 GAsyncResult* res);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda5_ (Block13Data* _data13_,
                  gdouble val);
static void ____lambda5__adw_animation_target_func (gdouble value,
                                             gpointer self);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static const gchar* about_operating_system_view_sponsor_us_row_get_uri (AboutOperatingSystemViewSponsorUsRow* self);
static void about_operating_system_view_sponsor_us_row_set_uri (AboutOperatingSystemViewSponsorUsRow* self,
                                                         const gchar* value);
static GObject * about_operating_system_view_sponsor_us_row_constructor (GType type,
                                                                  guint n_construct_properties,
                                                                  GObjectConstructParam * construct_properties);
static void about_operating_system_view_sponsor_us_row_finalize (GObject * obj);
static GType about_operating_system_view_sponsor_us_row_get_type_once (void);
static void _vala_about_operating_system_view_sponsor_us_row_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_about_operating_system_view_sponsor_us_row_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);
static GObject * about_operating_system_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _about_operating_system_view_settings_restore_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void _about_operating_system_view___lambda9_ (AboutOperatingSystemView* self);
static void __about_operating_system_view___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void _about_operating_system_view___lambda10_ (AboutOperatingSystemView* self,
                                               GtkListBoxRow* row);
static void __about_operating_system_view___lambda10__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                           GtkListBoxRow* row,
                                                                           gpointer self);
static void _about_operating_system_view___lambda11_ (AboutOperatingSystemView* self,
                                               GtkListBoxRow* row);
static void __about_operating_system_view___lambda11__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                           GtkListBoxRow* row,
                                                                           gpointer self);
static void _about_operating_system_view___lambda12_ (AboutOperatingSystemView* self,
                                               GObject* obj,
                                               GAsyncResult* res);
static void _about_operating_system_view_update_state_system_update_state_changed (SystemUpdate* _sender,
                                                                            gpointer self);
static void __about_operating_system_view___lambda12__gasync_ready_callback (GObject* source_object,
                                                                      GAsyncResult* res,
                                                                      gpointer self);
static void _about_operating_system_view___lambda13_ (AboutOperatingSystemView* self);
static void ___lambda14_ (AboutOperatingSystemView* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda14__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __about_operating_system_view___lambda13__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _about_operating_system_view___lambda15_ (AboutOperatingSystemView* self);
static void ___lambda16_ (AboutOperatingSystemView* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda16__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __about_operating_system_view___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _about_operating_system_view_refresh_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _about_operating_system_view_details_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void about_operating_system_view_finalize (GObject * obj);
static GType about_operating_system_view_get_type_once (void);
static void _vala_about_operating_system_view_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
about_operating_system_view_get_instance_private (AboutOperatingSystemView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutOperatingSystemView_private_offset);
}

static void
about_operating_system_view_load_logo_data_free (gpointer _data)
{
	AboutOperatingSystemViewLoadLogoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutOperatingSystemViewLoadLogoData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
about_operating_system_view_load_logo (AboutOperatingSystemView* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	AboutOperatingSystemViewLoadLogoData* _data_;
	AboutOperatingSystemView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutOperatingSystemViewLoadLogoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_operating_system_view_load_logo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_operating_system_view_load_logo_co (_data_);
}

void
about_operating_system_view_load_logo_finish (AboutOperatingSystemView* self,
                                              GAsyncResult* _res_)
{
	AboutOperatingSystemViewLoadLogoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_operating_system_view_load_logo_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	AboutOperatingSystemViewLoadLogoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_operating_system_view_load_logo_co (_data_);
}

static gboolean
about_operating_system_view_load_logo_co (AboutOperatingSystemViewLoadLogoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->logo;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->logo_file;
		_data_->_tmp0_ = _data_->_tmp2_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp3_ = _data_->self->priv->logo_file;
		_data_->_state_ = 1;
		g_file_load_bytes_async (_data_->_tmp3_, NULL, about_operating_system_view_load_logo_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = g_file_load_bytes_finish (_data_->_tmp3_, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->bytes = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->bytes;
		_data_->_tmp7_ = gdk_texture_new_from_bytes (_data_->_tmp6_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_bytes_unref0 (_data_->bytes);
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->self->priv->logo;
		adw_avatar_set_custom_image (_data_->_tmp8_, (GdkPaintable*) _data_->_tmp5_);
		_g_object_unref0 (_data_->self->priv->logo_file);
		_data_->self->priv->logo_file = NULL;
		_g_object_unref0 (_data_->_tmp5_);
		_g_bytes_unref0 (_data_->bytes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("OperatingSystemView.vala:455: Failed to load logo file: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
about_operating_system_view_load_sponsors_goal (AboutOperatingSystemView* self,
                                                GCancellable* cancellable)
{
	AboutOperatingSystemViewSponsorUsRow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	AboutOperatingSystemViewSponsorUsRow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = self->priv->sponsor_us_row;
	_tmp1_ = about_operating_system_view_sponsor_us_row_get_was_loaded (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->sponsor_us_row;
	about_operating_system_view_sponsor_us_row_get_goal_progress (_tmp3_, cancellable);
}

static void
about_operating_system_view_get_upstream_release_data_free (gpointer _data)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutOperatingSystemViewGetUpstreamReleaseData, _data_);
}

static void
about_operating_system_view_get_upstream_release (AboutOperatingSystemView* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	AboutOperatingSystemView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutOperatingSystemViewGetUpstreamReleaseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_operating_system_view_get_upstream_release_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_operating_system_view_get_upstream_release_co (_data_);
}

static void
about_operating_system_view_get_upstream_release_finish (AboutOperatingSystemView* self,
                                                         GAsyncResult* _res_)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_operating_system_view_get_upstream_release_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	AboutOperatingSystemViewGetUpstreamReleaseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_operating_system_view_get_upstream_release_co (_data_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
about_operating_system_view_get_upstream_release_co (AboutOperatingSystemViewGetUpstreamReleaseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path ("/usr/lib/upstream-os-release");
	_data_->file = _data_->_tmp0_;
	_data_->upstream_release = NULL;
	{
		_data_->_tmp2_ = _data_->file;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, about_operating_system_view_get_upstream_release_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_read_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp1_);
		_data_->dis = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->dis;
			_data_->_state_ = 2;
			g_data_input_stream_read_line_async (_data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, about_operating_system_view_get_upstream_release_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp7_ = g_data_input_stream_read_line_finish (_data_->_tmp6_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->_tmp1_);
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->line;
			if (!(_data_->_tmp9_ != NULL)) {
				_g_free0 (_data_->_tmp5_);
				break;
			}
			_data_->_tmp10_ = _data_->line;
			if (g_str_has_prefix (_data_->_tmp10_, "PRETTY_NAME")) {
				_data_->_tmp11_ = _data_->line;
				_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, "=", 2);
				_data_->distrib_component = _data_->_tmp13_;
				_data_->distrib_component_length1 = _vala_array_length (_data_->_tmp12_);
				_data_->_distrib_component_size_ = _data_->distrib_component_length1;
				_data_->_tmp14_ = _data_->distrib_component;
				_data_->_tmp14__length1 = _data_->distrib_component_length1;
				if (_data_->_tmp14__length1 == 2) {
					_data_->_tmp15_ = _data_->distrib_component;
					_data_->_tmp15__length1 = _data_->distrib_component_length1;
					_data_->_tmp16_ = _data_->_tmp15_[1];
					_data_->_tmp15_[1] = NULL;
					_g_free0 (_data_->upstream_release);
					_data_->upstream_release = _data_->_tmp16_;
					_data_->_tmp18_ = _data_->upstream_release;
					if (g_str_has_prefix (_data_->_tmp18_, "\"")) {
						_data_->_tmp19_ = _data_->upstream_release;
						_data_->_tmp17_ = g_str_has_suffix (_data_->_tmp19_, "\"");
					} else {
						_data_->_tmp17_ = FALSE;
					}
					if (_data_->_tmp17_) {
						_data_->_tmp20_ = _data_->upstream_release;
						_data_->_tmp21_ = _data_->upstream_release;
						_data_->_tmp22_ = strlen (_data_->_tmp21_);
						_data_->_tmp23_ = _data_->_tmp22_;
						_data_->_tmp24_ = string_substring (_data_->_tmp20_, (glong) 1, (glong) (_data_->_tmp23_ - 2));
						_g_free0 (_data_->upstream_release);
						_data_->upstream_release = _data_->_tmp24_;
					}
					_data_->distrib_component = (_vala_array_free (_data_->distrib_component, _data_->distrib_component_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->_tmp5_);
					break;
				}
				_data_->distrib_component = (_vala_array_free (_data_->distrib_component, _data_->distrib_component_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (_data_->_tmp5_);
		}
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_warning ("OperatingSystemView.vala:491: Couldn't read upstream lsb-release file," \
" assuming none");
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_debug ("OperatingSystemView.vala:492: Error was: %s", _data_->_tmp26_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->upstream_release);
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->upstream_release;
	if (_data_->_tmp27_ != NULL) {
		_data_->_tmp28_ = _data_->upstream_release;
		_data_->_tmp29_ = g_strdup_printf (_ ("Built on %s"), _data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = (GtkLabel*) gtk_label_new (_data_->_tmp30_);
		gtk_label_set_selectable (_data_->_tmp31_, TRUE);
		gtk_label_set_xalign (_data_->_tmp31_, (gfloat) 0);
		gtk_widget_set_hexpand ((GtkWidget*) _data_->_tmp31_, TRUE);
		g_object_ref_sink (_data_->_tmp31_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_g_free0 (_data_->_tmp30_);
		_data_->based_off = _data_->_tmp32_;
		_data_->_tmp33_ = _data_->based_off;
		gtk_widget_add_css_class ((GtkWidget*) _data_->_tmp33_, GRANITE_STYLE_CLASS_SMALL_LABEL);
		_data_->_tmp34_ = _data_->based_off;
		gtk_widget_add_css_class ((GtkWidget*) _data_->_tmp34_, GRANITE_STYLE_CLASS_DIM_LABEL);
		_data_->_tmp35_ = _data_->self->priv->software_grid;
		_data_->_tmp36_ = _data_->based_off;
		gtk_grid_attach (_data_->_tmp35_, (GtkWidget*) _data_->_tmp36_, 1, 1, 3, 1);
		_g_object_unref0 (_data_->based_off);
	}
	_g_free0 (_data_->upstream_release);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_operating_system_view_update_state_data_free (gpointer _data)
{
	AboutOperatingSystemViewUpdateStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutOperatingSystemViewUpdateStateData, _data_);
}

static void
about_operating_system_view_update_state (AboutOperatingSystemView* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	AboutOperatingSystemViewUpdateStateData* _data_;
	AboutOperatingSystemView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutOperatingSystemViewUpdateStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_operating_system_view_update_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_operating_system_view_update_state_co (_data_);
}

static void
about_operating_system_view_update_state_finish (AboutOperatingSystemView* self,
                                                 GAsyncResult* _res_)
{
	AboutOperatingSystemViewUpdateStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_operating_system_view_update_state_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	AboutOperatingSystemViewUpdateStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_operating_system_view_update_state_co (_data_);
}

static gpointer
_system_update_current_state_dup0 (gpointer self)
{
	return self ? system_update_current_state_dup (self) : NULL;
}

static gboolean
_vala_pk_info_array_contains (PkInfoEnum * stack,
                              gssize stack_length,
                              const PkInfoEnum needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
about_operating_system_view_update_state_co (AboutOperatingSystemViewUpdateStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->update_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = _data_->self->priv->update_proxy;
		memset (&_data_->_tmp3_, 0, sizeof (SystemUpdateCurrentState));
		_data_->_state_ = 1;
		system_update_get_current_state (_data_->_tmp2_, about_operating_system_view_update_state_ready, _data_);
		return FALSE;
		_state_1:
		system_update_get_current_state_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		memset (&_data_->_tmp1_, 0, sizeof (SystemUpdateCurrentState));
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _system_update_current_state_dup0 (&_data_->_tmp5_);
		_system_update_current_state_free0 (_data_->self->priv->current_state);
		_data_->self->priv->current_state = _data_->_tmp6_;
		system_update_current_state_destroy (&_data_->_tmp5_);
		system_update_current_state_destroy (&_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->updates_image;
		g_object_set (_data_->_tmp7_, "icon-name", "dialog-error", NULL);
		_data_->_tmp8_ = _data_->self->priv->updates_title;
		gtk_label_set_label (_data_->_tmp8_, _ ("System updates not available"));
		_data_->_tmp9_ = _data_->self->priv->updates_description;
		gtk_label_set_label (_data_->_tmp9_, _ ("Couldn't connect to the backend. Try logging out to resolve the issue."));
		_data_->_tmp10_ = _data_->self->priv->button_stack;
		gtk_stack_set_visible_child_name (_data_->_tmp10_, "blank");
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("OperatingSystemView.vala:520: Failed to get current state from Updates" \
" Backend: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->self->priv->update_progress_revealer;
	gtk_revealer_set_reveal_child (_data_->_tmp13_, FALSE);
	_data_->_tmp15_ = _data_->self->priv->current_state;
	if ((*_data_->_tmp15_).state == SYSTEM_UPDATE_STATE_AVAILABLE) {
		_data_->_tmp14_ = TRUE;
	} else {
		_data_->_tmp16_ = _data_->self->priv->current_state;
		_data_->_tmp14_ = (*_data_->_tmp16_).state == SYSTEM_UPDATE_STATE_ERROR;
	}
	_data_->_tmp17_ = _data_->self->priv->details_button_revealer;
	gtk_revealer_set_reveal_child (_data_->_tmp17_, _data_->_tmp14_);
	_data_->_tmp18_ = _data_->self->priv->current_state;
	switch ((*_data_->_tmp18_).state) {
		case SYSTEM_UPDATE_STATE_UP_TO_DATE:
		{
			_data_->_tmp19_ = _data_->self->priv->updates_image;
			g_object_set (_data_->_tmp19_, "icon-name", "process-completed", NULL);
			_data_->_tmp20_ = _data_->self->priv->updates_title;
			gtk_label_set_label (_data_->_tmp20_, _ ("Up To Date"));
			{
				_data_->_tmp21_ = _data_->self->priv->update_proxy;
				_data_->_state_ = 2;
				system_update_get_last_refresh_time (_data_->_tmp21_, about_operating_system_view_update_state_ready, _data_);
				return FALSE;
				_state_2:
				_data_->last_refresh_time = system_update_get_last_refresh_time_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_data_->_tmp22_ = _data_->self->priv->updates_description;
				_data_->_tmp23_ = g_date_time_new_from_unix_utc (_data_->last_refresh_time);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = granite_date_time_get_relative_datetime (_data_->_tmp24_);
				_data_->_tmp26_ = _data_->_tmp25_;
				_data_->_tmp27_ = g_strdup_printf (_ ("Last checked %s"), _data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				gtk_label_set_label (_data_->_tmp22_, _data_->_tmp28_);
				_g_free0 (_data_->_tmp28_);
				_g_free0 (_data_->_tmp26_);
				_g_date_time_unref0 (_data_->_tmp24_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp29_ = _data_->_vala1_e;
				_data_->_tmp30_ = _data_->_tmp29_->message;
				g_critical ("OperatingSystemView.vala:540: Failed to get last refresh time from Upd" \
"ates Backend: %s", _data_->_tmp30_);
				_data_->_tmp31_ = _data_->self->priv->updates_description;
				gtk_label_set_label (_data_->_tmp31_, _ ("Last checked unknown"));
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp32_ = _data_->self->priv->button_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp32_, "refresh");
			break;
		}
		case SYSTEM_UPDATE_STATE_CHECKING:
		{
			_data_->_tmp33_ = _data_->self->priv->updates_image;
			g_object_set (_data_->_tmp33_, "icon-name", "emblem-synchronized", NULL);
			_data_->_tmp34_ = _data_->self->priv->updates_title;
			gtk_label_set_label (_data_->_tmp34_, _ ("Checking for Updates"));
			_data_->_tmp35_ = _data_->self->priv->updates_description;
			_data_->_tmp36_ = _data_->self->priv->current_state;
			_data_->_tmp37_ = (*_data_->_tmp36_).message;
			gtk_label_set_label (_data_->_tmp35_, _data_->_tmp37_);
			_data_->_tmp38_ = _data_->self->priv->button_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp38_, "blank");
			break;
		}
		case SYSTEM_UPDATE_STATE_AVAILABLE:
		{
			_data_->_tmp39_ = _data_->self->priv->updates_image;
			g_object_set (_data_->_tmp39_, "icon-name", "software-update-available", NULL);
			_data_->_tmp40_ = _data_->self->priv->updates_title;
			gtk_label_set_label (_data_->_tmp40_, _ ("Updates Available"));
			_data_->_tmp41_ = _data_->self->priv->button_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp41_, "update");
			{
				_data_->_tmp42_ = _data_->self->priv->update_proxy;
				memset (&_data_->_tmp43_, 0, sizeof (SystemUpdateUpdateDetails));
				_data_->_state_ = 3;
				system_update_get_update_details (_data_->_tmp42_, about_operating_system_view_update_state_ready, _data_);
				return FALSE;
				_state_3:
				system_update_get_update_details_finish (_data_->_tmp42_, _data_->_res_, &_data_->_tmp43_, &_data_->_inner_error0_);
				_data_->details = _data_->_tmp43_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				_data_->_tmp44_ = _data_->self->priv->updates_description;
				_data_->_tmp45_ = _data_->details;
				_data_->_tmp46_ = _data_->_tmp45_.packages;
				_data_->_tmp46__length1 = _data_->_tmp45_.packages_length1;
				_data_->_tmp47_ = _data_->details;
				_data_->_tmp48_ = _data_->_tmp47_.packages;
				_data_->_tmp48__length1 = _data_->_tmp47_.packages_length1;
				_data_->_tmp49_ = _data_->details;
				_data_->_tmp50_ = g_format_size_full (_data_->_tmp49_.size, G_FORMAT_SIZE_DEFAULT);
				_data_->_tmp51_ = _data_->_tmp50_;
				_data_->_tmp52_ = g_strdup_printf (g_dngettext (ABOUT_GETTEXT_PACKAGE, "%i update available (%s)", "%i updates available (%s)", (gulong) _data_->_tmp46__length1), _data_->_tmp48__length1, _data_->_tmp51_);
				_data_->_tmp53_ = _data_->_tmp52_;
				gtk_label_set_label (_data_->_tmp44_, _data_->_tmp53_);
				_g_free0 (_data_->_tmp53_);
				_g_free0 (_data_->_tmp51_);
				_data_->_tmp54_ = _data_->details;
				_data_->_tmp55_ = _data_->_tmp54_.info;
				_data_->_tmp55__length1 = _data_->_tmp54_.info_length1;
				if (_vala_pk_info_array_contains (_data_->_tmp55_, _data_->_tmp55__length1, PK_INFO_ENUM_SECURITY)) {
					_data_->_tmp56_ = _data_->self->priv->updates_image;
					g_object_set (_data_->_tmp56_, "icon-name", "software-update-urgent", NULL);
				}
				_data_->_tmp57_ = _data_->self->priv->packages;
				_data_->_tmp58_ = _data_->self->priv->packages;
				_data_->_tmp59_ = _data_->details;
				_data_->_tmp60_ = _data_->_tmp59_.packages;
				_data_->_tmp60__length1 = _data_->_tmp59_.packages_length1;
				gtk_string_list_splice (_data_->_tmp57_, (guint) 0, g_list_model_get_n_items ((GListModel*) _data_->_tmp58_), _data_->_tmp60_);
				system_update_update_details_destroy (&_data_->details);
			}
			goto __finally2;
			__catch2_g_error:
			{
				_data_->_vala2_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp61_ = _data_->self->priv->updates_description;
				gtk_label_set_label (_data_->_tmp61_, _ ("Unable to determine number of updates"));
				_data_->_tmp62_ = _data_->_vala2_e;
				_data_->_tmp63_ = _data_->_tmp62_->message;
				g_warning ("OperatingSystemView.vala:573: Failed to get updates list from backend:" \
" %s", _data_->_tmp63_);
				_g_error_free0 (_data_->_vala2_e);
			}
			__finally2:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case SYSTEM_UPDATE_STATE_DOWNLOADING:
		{
			_data_->_tmp64_ = _data_->self->priv->update_progress_revealer;
			_data_->_tmp65_ = _data_->self->priv->current_state;
			gtk_revealer_set_reveal_child (_data_->_tmp64_, (*_data_->_tmp65_).percentage > ((guint) 0));
			_data_->_tmp66_ = _data_->self->priv->update_progress_bar;
			_data_->_tmp67_ = _data_->self->priv->current_state;
			gtk_progress_bar_set_fraction (_data_->_tmp66_, (*_data_->_tmp67_).percentage / 100.0);
			_data_->_tmp68_ = _data_->self->priv->current_state;
			_data_->self->priv->download_size_remaining = (*_data_->_tmp68_).download_size_remaining;
			if (_data_->self->priv->download_size_remaining > _data_->self->priv->download_size_max) {
				_data_->self->priv->download_size_max = _data_->self->priv->download_size_remaining;
			}
			_data_->_tmp69_ = _data_->self->priv->updates_image;
			g_object_set (_data_->_tmp69_, "icon-name", "browser-download", NULL);
			_data_->_tmp70_ = _data_->self->priv->updates_title;
			gtk_label_set_label (_data_->_tmp70_, _ ("Downloading Updates"));
			_data_->_tmp71_ = _data_->self->priv->updates_description;
			_data_->_tmp72_ = _data_->self->priv->current_state;
			_data_->_tmp73_ = (*_data_->_tmp72_).message;
			_data_->_tmp74_ = about_operating_system_view_to_progress_text (_data_->self, _data_->self->priv->download_size_remaining, _data_->self->priv->download_size_max);
			_data_->_tmp75_ = _data_->_tmp74_;
			_data_->_tmp76_ = g_strdup_printf ("%s <span font-features='tnum'>%s</span>", _data_->_tmp73_, _data_->_tmp75_);
			_data_->_tmp77_ = _data_->_tmp76_;
			gtk_label_set_label (_data_->_tmp71_, _data_->_tmp77_);
			_g_free0 (_data_->_tmp77_);
			_g_free0 (_data_->_tmp75_);
			_data_->_tmp78_ = _data_->self->priv->button_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp78_, "cancel");
			break;
		}
		case SYSTEM_UPDATE_STATE_RESTART_REQUIRED:
		{
			_data_->_tmp79_ = _data_->self->priv->updates_image;
			g_object_set (_data_->_tmp79_, "icon-name", "system-reboot", NULL);
			_data_->_tmp80_ = _data_->self->priv->updates_title;
			gtk_label_set_label (_data_->_tmp80_, _ ("Restart to install pending updates"));
			_data_->_tmp81_ = _data_->self->priv->updates_description;
			gtk_label_set_label (_data_->_tmp81_, _ ("Updates have been downloaded. A restart is required to finish installi" \
"ng them."));
			_data_->_tmp82_ = _data_->self->priv->button_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp82_, "blank");
			break;
		}
		case SYSTEM_UPDATE_STATE_ERROR:
		{
			_data_->_tmp83_ = _data_->self->priv->updates_image;
			g_object_set (_data_->_tmp83_, "icon-name", "dialog-error", NULL);
			_data_->_tmp84_ = _data_->self->priv->updates_title;
			gtk_label_set_label (_data_->_tmp84_, _ ("Failed to download updates"));
			_data_->_tmp85_ = _data_->self->priv->updates_description;
			gtk_label_set_label (_data_->_tmp85_, _ ("Manually refreshing updates may resolve the issue"));
			_data_->_tmp86_ = _data_->self->priv->button_stack;
			gtk_stack_set_visible_child_name (_data_->_tmp86_, "refresh");
			break;
		}
		default:
		break;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
about_operating_system_view_to_progress_text (AboutOperatingSystemView* self,
                                              guint64 remain_size,
                                              guint64 total_size)
{
	guint64 current_size = 0ULL;
	gchar* current_size_str = NULL;
	gchar* _tmp1_;
	gchar* total_size_str = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (total_size == ((guint64) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	current_size = total_size - remain_size;
	_tmp1_ = g_format_size_full (current_size, G_FORMAT_SIZE_DEFAULT);
	current_size_str = _tmp1_;
	_tmp2_ = g_format_size_full (total_size, G_FORMAT_SIZE_DEFAULT);
	total_size_str = _tmp2_;
	_tmp3_ = current_size_str;
	_tmp4_ = total_size_str;
	_tmp5_ = g_strdup_printf (_ ("%s of %s"), _tmp3_, _tmp4_);
	result = _tmp5_;
	_g_free0 (total_size_str);
	_g_free0 (current_size_str);
	return result;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
about_operating_system_view_details_clicked (AboutOperatingSystemView* self)
{
	SystemUpdateCurrentState* _tmp0_;
	SystemUpdateCurrentState* _tmp1_;
	AboutUpdateDetailsDialog* details_dialog = NULL;
	GtkStringList* _tmp14_;
	GtkRoot* _tmp15_;
	GtkWindow* _tmp16_;
	AboutUpdateDetailsDialog* _tmp17_ = NULL;
	AboutUpdateDetailsDialog* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_state;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->current_state;
	if ((*_tmp1_).state == SYSTEM_UPDATE_STATE_ERROR) {
		GraniteMessageDialog* message_dialog = NULL;
		GThemedIcon* _tmp2_;
		GThemedIcon* _tmp3_;
		GtkRoot* _tmp4_;
		GtkWindow* _tmp5_;
		GraniteMessageDialog* _tmp6_ = NULL;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		SystemUpdateCurrentState* _tmp9_;
		const gchar* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GraniteMessageDialog* _tmp13_;
		_tmp2_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_tmp6_ = granite_message_dialog_new (_ ("Failed to download updates"), _ ("This may have been caused by sideloaded or manually compiled software," \
" a third-party software source, or a package manager error. Manually r" \
"efreshing updates may resolve the issue."), (GIcon*) _tmp3_, GTK_BUTTONS_CLOSE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp5_);
		_g_object_unref0 (_tmp5_);
		gtk_window_set_modal ((GtkWindow*) _tmp6_, TRUE);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp3_);
		message_dialog = _tmp7_;
		_tmp8_ = message_dialog;
		_tmp9_ = self->priv->current_state;
		_tmp10_ = (*_tmp9_).message;
		granite_message_dialog_show_error_details (_tmp8_, _tmp10_);
		_tmp11_ = message_dialog;
		_tmp12_ = message_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp11_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp12_, 0);
		_tmp13_ = message_dialog;
		gtk_window_present ((GtkWindow*) _tmp13_);
		_g_object_unref0 (message_dialog);
		return;
	}
	_tmp14_ = self->priv->packages;
	_tmp15_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow));
	_tmp17_ = about_update_details_dialog_new (_tmp14_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp17_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	g_object_ref_sink (_tmp17_);
	details_dialog = _tmp17_;
	_tmp18_ = details_dialog;
	gtk_window_present ((GtkWindow*) _tmp18_);
	_g_object_unref0 (details_dialog);
}

static void
about_operating_system_view_refresh_clicked_data_free (gpointer _data)
{
	AboutOperatingSystemViewRefreshClickedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutOperatingSystemViewRefreshClickedData, _data_);
}

static void
about_operating_system_view_refresh_clicked (AboutOperatingSystemView* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	AboutOperatingSystemViewRefreshClickedData* _data_;
	AboutOperatingSystemView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AboutOperatingSystemViewRefreshClickedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_operating_system_view_refresh_clicked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	about_operating_system_view_refresh_clicked_co (_data_);
}

static void
about_operating_system_view_refresh_clicked_finish (AboutOperatingSystemView* self,
                                                    GAsyncResult* _res_)
{
	AboutOperatingSystemViewRefreshClickedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
about_operating_system_view_refresh_clicked_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	AboutOperatingSystemViewRefreshClickedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	about_operating_system_view_refresh_clicked_co (_data_);
}

static gboolean
about_operating_system_view_refresh_clicked_co (AboutOperatingSystemViewRefreshClickedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->update_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->update_proxy;
		_data_->_state_ = 1;
		system_update_check_for_updates (_data_->_tmp1_, TRUE, FALSE, about_operating_system_view_refresh_clicked_ready, _data_);
		return FALSE;
		_state_1:
		system_update_check_for_updates_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_critical ("OperatingSystemView.vala:656: Failed to check for updates: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_operating_system_view_launch_uri (AboutOperatingSystemView* self,
                                        const gchar* uri)
{
	GtkUriLauncher* uri_launcher = NULL;
	GtkUriLauncher* _tmp0_;
	GApplication* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = gtk_uri_launcher_new (uri);
	uri_launcher = _tmp0_;
	_tmp1_ = g_application_get_default ();
	_tmp2_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_application_get_type (), GtkApplication));
	_tmp3_ = _tmp2_;
	gtk_uri_launcher_launch (uri_launcher, _tmp3_, NULL, NULL, NULL);
	_g_object_unref0 (uri_launcher);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		AboutOperatingSystemView* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda8_ (Block11Data* _data11_,
            gint response)
{
	AboutOperatingSystemView* self;
	self = _data11_->self;
	gtk_window_destroy ((GtkWindow*) _data11_->dialog);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar** all_schemas = NULL;
		gint _tmp0_ = 0;
		gchar** _tmp1_;
		gint all_schemas_length1;
		gint _all_schemas_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = about_operating_system_view_get_pantheon_schemas (&_tmp0_);
		all_schemas = _tmp1_;
		all_schemas_length1 = _tmp0_;
		_all_schemas_size_ = all_schemas_length1;
		_tmp2_ = all_schemas;
		_tmp2__length1 = all_schemas_length1;
		{
			gchar** schema_collection = NULL;
			gint schema_collection_length1 = 0;
			gint _schema_collection_size_ = 0;
			gint schema_it = 0;
			schema_collection = _tmp2_;
			schema_collection_length1 = _tmp2__length1;
			for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
				gchar* _tmp3_;
				gchar* schema = NULL;
				_tmp3_ = g_strdup (schema_collection[schema_it]);
				schema = _tmp3_;
				{
					const gchar* _tmp4_;
					_tmp4_ = schema;
					about_operating_system_view_reset_recursively (_tmp4_);
					_g_free0 (schema);
				}
			}
		}
		all_schemas = (_vala_array_free (all_schemas, all_schemas_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda8_ (self, response_id);
}

static void
about_operating_system_view_settings_restore_clicked (AboutOperatingSystemView* self)
{
	Block11Data* _data11_;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GtkRoot* _tmp3_;
	GtkWindow* _tmp4_;
	GraniteMessageDialog* _tmp5_ = NULL;
	GraniteMessageDialog* _tmp6_;
	GtkWidget* continue_button = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-system");
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("edit-clear");
	_tmp3_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = granite_message_dialog_new (_ ("System Settings Will Be Restored to The Factory Defaults"), _ ("All system settings and data will be reset to the default values. Pers" \
"onal data, such as music and pictures, will be unaffected."), (GIcon*) _tmp1_, GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp5_, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	_data11_->dialog = _tmp6_;
	_tmp7_ = granite_dialog_add_button ((GraniteDialog*) _data11_->dialog, _ ("Restore Settings"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	continue_button = _tmp8_;
	gtk_widget_add_css_class (continue_button, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	g_signal_connect_data ((GtkDialog*) _data11_->dialog, "response", (GCallback) ___lambda8__gtk_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data11_->dialog);
	_g_object_unref0 (continue_button);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
about_operating_system_view_reset_all_keys (GSettings* settings)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSettingsSchema* _tmp4_;
	GSettingsSchema* _tmp5_;
	GSettingsSchema* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	g_return_if_fail (settings != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	g_object_get (settings, "schema-id", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_schema_source_lookup (_tmp0_, _tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	schema = _tmp5_;
	_tmp6_ = schema;
	_tmp8_ = _tmp7_ = g_settings_schema_list_keys (_tmp6_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp8_;
		key_collection_length1 = _vala_array_length (_tmp7_);
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp9_;
			gchar* key = NULL;
			_tmp9_ = g_strdup (key_collection[key_it]);
			key = _tmp9_;
			{
				const gchar* _tmp10_;
				_tmp10_ = key;
				g_settings_reset (settings, _tmp10_);
				_g_free0 (key);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_settings_schema_unref0 (schema);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
about_operating_system_view_get_pantheon_schemas (gint* result_length1)
{
	gchar** schemas = NULL;
	gchar** _tmp0_;
	gint schemas_length1;
	gint _schemas_size_;
	gchar** pantheon_schemas = NULL;
	gchar** _tmp1_;
	gint pantheon_schemas_length1;
	gint _pantheon_schemas_size_;
	gchar** prefixes = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint prefixes_length1;
	gint _prefixes_size_;
	GSettingsSchemaSource* sss = NULL;
	GSettingsSchemaSource* _tmp12_;
	GSettingsSchemaSource* _tmp13_;
	GSettingsSchemaSource* _tmp14_;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	schemas = _tmp0_;
	schemas_length1 = 0;
	_schemas_size_ = schemas_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	pantheon_schemas = _tmp1_;
	pantheon_schemas_length1 = 0;
	_pantheon_schemas_size_ = pantheon_schemas_length1;
	_tmp2_ = g_strdup ("io.elementary.desktop");
	_tmp3_ = g_strdup ("io.elementary.dock");
	_tmp4_ = g_strdup ("io.elementary.onboarding");
	_tmp5_ = g_strdup ("io.elementary.settings");
	_tmp6_ = g_strdup ("io.elementary.settings-daemon");
	_tmp7_ = g_strdup ("io.elementary.wingpanel");
	_tmp8_ = g_strdup ("org.gnome.desktop");
	_tmp9_ = g_strdup ("org.gnome.settings-daemon");
	_tmp10_ = g_strdup ("org.pantheon.desktop");
	_tmp11_ = g_new0 (gchar*, 9 + 1);
	_tmp11_[0] = _tmp2_;
	_tmp11_[1] = _tmp3_;
	_tmp11_[2] = _tmp4_;
	_tmp11_[3] = _tmp5_;
	_tmp11_[4] = _tmp6_;
	_tmp11_[5] = _tmp7_;
	_tmp11_[6] = _tmp8_;
	_tmp11_[7] = _tmp9_;
	_tmp11_[8] = _tmp10_;
	prefixes = _tmp11_;
	prefixes_length1 = 9;
	_prefixes_size_ = prefixes_length1;
	_tmp12_ = g_settings_schema_source_get_default ();
	_tmp13_ = _g_settings_schema_source_ref0 (_tmp12_);
	sss = _tmp13_;
	_tmp14_ = sss;
	g_settings_schema_source_list_schemas (_tmp14_, TRUE, &_tmp15_, NULL);
	schemas = (_vala_array_free (schemas, schemas_length1, (GDestroyNotify) g_free), NULL);
	schemas = _tmp15_;
	schemas_length1 = -1;
	_schemas_size_ = schemas_length1;
	schemas_length1 = _vala_array_length (schemas);
	_tmp16_ = schemas;
	_tmp16__length1 = schemas_length1;
	{
		gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = _tmp16_;
		schema_collection_length1 = _tmp16__length1;
		for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
			gchar* _tmp17_;
			gchar* schema = NULL;
			_tmp17_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp17_;
			{
				gchar** _tmp18_;
				gint _tmp18__length1;
				_tmp18_ = prefixes;
				_tmp18__length1 = prefixes_length1;
				{
					gchar** prefix_collection = NULL;
					gint prefix_collection_length1 = 0;
					gint _prefix_collection_size_ = 0;
					gint prefix_it = 0;
					prefix_collection = _tmp18_;
					prefix_collection_length1 = _tmp18__length1;
					for (prefix_it = 0; prefix_it < prefix_collection_length1; prefix_it = prefix_it + 1) {
						gchar* _tmp19_;
						gchar* prefix = NULL;
						_tmp19_ = g_strdup (prefix_collection[prefix_it]);
						prefix = _tmp19_;
						{
							const gchar* _tmp20_;
							const gchar* _tmp21_;
							_tmp20_ = schema;
							_tmp21_ = prefix;
							if (g_str_has_prefix (_tmp20_, _tmp21_)) {
								const gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp22_ = schema;
								_tmp23_ = g_strdup (_tmp22_);
								_vala_array_add1 (&pantheon_schemas, &pantheon_schemas_length1, &_pantheon_schemas_size_, _tmp23_);
							}
							_g_free0 (prefix);
						}
					}
				}
				_g_free0 (schema);
			}
		}
	}
	_tmp24_ = pantheon_schemas;
	_tmp24__length1 = pantheon_schemas_length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	_g_settings_schema_source_unref0 (sss);
	prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
	schemas = (_vala_array_free (schemas, schemas_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
about_operating_system_view_reset_recursively (const gchar* schema)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	GSettings* _tmp11_;
	g_return_if_fail (schema != NULL);
	_tmp0_ = g_settings_new (schema);
	settings = _tmp0_;
	_tmp1_ = settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = settings;
	about_operating_system_view_reset_all_keys (_tmp2_);
	_tmp3_ = settings;
	_tmp5_ = _tmp4_ = g_settings_list_children (_tmp3_);
	{
		gchar** child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp5_;
		child_collection_length1 = _vala_array_length (_tmp4_);
		for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
			gchar* _tmp6_;
			gchar* child = NULL;
			_tmp6_ = g_strdup (child_collection[child_it]);
			child = _tmp6_;
			{
				GSettings* child_settings = NULL;
				GSettings* _tmp7_;
				const gchar* _tmp8_;
				GSettings* _tmp9_;
				GSettings* _tmp10_;
				_tmp7_ = settings;
				_tmp8_ = child;
				_tmp9_ = g_settings_get_child (_tmp7_, _tmp8_);
				child_settings = _tmp9_;
				_tmp10_ = child_settings;
				about_operating_system_view_reset_all_keys (_tmp10_);
				_g_object_unref0 (child_settings);
				_g_free0 (child);
			}
		}
		child_collection = (_vala_array_free (child_collection, child_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = settings;
	g_settings_apply (_tmp11_);
	g_settings_sync ();
	_g_object_unref0 (settings);
}

AboutOperatingSystemView*
about_operating_system_view_construct (GType object_type)
{
	AboutOperatingSystemView * self = NULL;
	self = (AboutOperatingSystemView*) g_object_new (object_type, NULL);
	return self;
}

AboutOperatingSystemView*
about_operating_system_view_new (void)
{
	return about_operating_system_view_construct (ABOUT_TYPE_OPERATING_SYSTEM_VIEW);
}

static const gchar*
about_operating_system_view_get_bug_url (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = about_operating_system_view__bug_url;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_BUG_REPORT_URL);
		_g_free0 (about_operating_system_view__bug_url);
		about_operating_system_view__bug_url = _tmp1_;
		_tmp2_ = about_operating_system_view__bug_url;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("https://docs.elementary.io/contributor-guide/feedback/reporting-issues");
			_g_free0 (about_operating_system_view__bug_url);
			about_operating_system_view__bug_url = _tmp3_;
		}
	}
	_tmp4_ = about_operating_system_view__bug_url;
	result = _tmp4_;
	return result;
}

static const gchar*
about_operating_system_view_get_documentation_url (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = about_operating_system_view__documentation_url;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_DOCUMENTATION_URL);
		_g_free0 (about_operating_system_view__documentation_url);
		about_operating_system_view__documentation_url = _tmp1_;
		_tmp2_ = about_operating_system_view__documentation_url;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("https://elementary.io/docs/learning-the-basics");
			_g_free0 (about_operating_system_view__documentation_url);
			about_operating_system_view__documentation_url = _tmp3_;
		}
	}
	_tmp4_ = about_operating_system_view__documentation_url;
	result = _tmp4_;
	return result;
}

static const gchar*
about_operating_system_view_get_website_url (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = about_operating_system_view__website_url;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_HOME_URL);
		_g_free0 (about_operating_system_view__website_url);
		about_operating_system_view__website_url = _tmp1_;
		_tmp2_ = about_operating_system_view__website_url;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("https://elementary.io");
			_g_free0 (about_operating_system_view__website_url);
			about_operating_system_view__website_url = _tmp3_;
		}
	}
	_tmp4_ = about_operating_system_view__website_url;
	result = _tmp4_;
	return result;
}

static const gchar*
about_operating_system_view_get_support_url (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	_tmp0_ = about_operating_system_view__support_url;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_get_os_info (G_OS_INFO_KEY_SUPPORT_URL);
		_g_free0 (about_operating_system_view__support_url);
		about_operating_system_view__support_url = _tmp1_;
		_tmp2_ = about_operating_system_view__support_url;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("https://elementary.io/support");
			_g_free0 (about_operating_system_view__support_url);
			about_operating_system_view__support_url = _tmp3_;
		}
	}
	_tmp4_ = about_operating_system_view__support_url;
	result = _tmp4_;
	return result;
}

static inline gpointer
about_operating_system_view_link_row_get_instance_private (AboutOperatingSystemViewLinkRow* self)
{
	return G_STRUCT_MEMBER_P (self, AboutOperatingSystemViewLinkRow_private_offset);
}

static AboutOperatingSystemViewLinkRow*
about_operating_system_view_link_row_construct (GType object_type,
                                                const gchar* uri,
                                                const gchar* label_string,
                                                const gchar* icon_name,
                                                const gchar* color)
{
	AboutOperatingSystemViewLinkRow * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (label_string != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	self = (AboutOperatingSystemViewLinkRow*) g_object_new (object_type, "uri", uri, "label-string", label_string, "icon-name", icon_name, "color", color, NULL);
	return self;
}

static AboutOperatingSystemViewLinkRow*
about_operating_system_view_link_row_new (const gchar* uri,
                                          const gchar* label_string,
                                          const gchar* icon_name,
                                          const gchar* color)
{
	return about_operating_system_view_link_row_construct (ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, uri, label_string, icon_name, color);
}

static const gchar*
about_operating_system_view_link_row_get_uri (AboutOperatingSystemViewLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
about_operating_system_view_link_row_set_uri (AboutOperatingSystemViewLinkRow* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = about_operating_system_view_link_row_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_URI_PROPERTY]);
	}
}

static const gchar*
about_operating_system_view_link_row_get_icon_name (AboutOperatingSystemViewLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
about_operating_system_view_link_row_set_icon_name (AboutOperatingSystemViewLinkRow* self,
                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = about_operating_system_view_link_row_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_ICON_NAME_PROPERTY]);
	}
}

static const gchar*
about_operating_system_view_link_row_get_label_string (AboutOperatingSystemViewLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_string;
	result = _tmp0_;
	return result;
}

static void
about_operating_system_view_link_row_set_label_string (AboutOperatingSystemViewLinkRow* self,
                                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = about_operating_system_view_link_row_get_label_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_string);
		self->priv->_label_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_LABEL_STRING_PROPERTY]);
	}
}

static const gchar*
about_operating_system_view_link_row_get_color (AboutOperatingSystemViewLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_color;
	result = _tmp0_;
	return result;
}

static void
about_operating_system_view_link_row_set_color (AboutOperatingSystemViewLinkRow* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = about_operating_system_view_link_row_get_color (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_color);
		self->priv->_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_COLOR_PROPERTY]);
	}
}

static GObject *
about_operating_system_view_link_row_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutOperatingSystemViewLinkRow * self;
	GtkImage* image = NULL;
	const gchar* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* left_label = NULL;
	const gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkImage* link_image = NULL;
	GtkImage* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkImage* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkImage* _tmp14_;
	GtkBox* _tmp15_;
	parent_class = G_OBJECT_CLASS (about_operating_system_view_link_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRow);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_);
	gtk_image_set_pixel_size (_tmp1_, 16);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp3_ = image;
	_tmp4_ = self->priv->_color;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->_label_string;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	g_object_ref_sink (_tmp6_);
	left_label = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("adw-external-link-symbolic");
	g_object_ref_sink (_tmp7_);
	link_image = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	_tmp9_ = box;
	_tmp10_ = image;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = box;
	_tmp12_ = left_label;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	_tmp14_ = link_image;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp15_);
	gtk_widget_add_css_class ((GtkWidget*) self, "link");
	_g_object_unref0 (box);
	_g_object_unref0 (link_image);
	_g_object_unref0 (left_label);
	_g_object_unref0 (image);
	return obj;
}

static void
about_operating_system_view_link_row_base_init (AboutOperatingSystemViewLinkRowClass * klass)
{
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), GTK_ACCESSIBLE_ROLE_LINK);
}

static void
about_operating_system_view_link_row_class_init (AboutOperatingSystemViewLinkRowClass * klass,
                                                 gpointer klass_data)
{
	about_operating_system_view_link_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutOperatingSystemViewLinkRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_about_operating_system_view_link_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_about_operating_system_view_link_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = about_operating_system_view_link_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_operating_system_view_link_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_URI_PROPERTY, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_ICON_NAME_PROPERTY, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_LABEL_STRING_PROPERTY, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_LABEL_STRING_PROPERTY] = g_param_spec_string ("label-string", "label-string", "label-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_COLOR_PROPERTY, about_operating_system_view_link_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_COLOR_PROPERTY] = g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
about_operating_system_view_link_row_instance_init (AboutOperatingSystemViewLinkRow * self,
                                                    gpointer klass)
{
	self->priv = about_operating_system_view_link_row_get_instance_private (self);
}

static void
about_operating_system_view_link_row_finalize (GObject * obj)
{
	AboutOperatingSystemViewLinkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRow);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_label_string);
	_g_free0 (self->priv->_color);
	G_OBJECT_CLASS (about_operating_system_view_link_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_operating_system_view_link_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutOperatingSystemViewLinkRowClass), (GBaseInitFunc) about_operating_system_view_link_row_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_operating_system_view_link_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutOperatingSystemViewLinkRow), 0, (GInstanceInitFunc) about_operating_system_view_link_row_instance_init, NULL };
	GType about_operating_system_view_link_row_type_id;
	about_operating_system_view_link_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "AboutOperatingSystemViewLinkRow", &g_define_type_info, 0);
	AboutOperatingSystemViewLinkRow_private_offset = g_type_add_instance_private (about_operating_system_view_link_row_type_id, sizeof (AboutOperatingSystemViewLinkRowPrivate));
	return about_operating_system_view_link_row_type_id;
}

static GType
about_operating_system_view_link_row_get_type (void)
{
	static volatile gsize about_operating_system_view_link_row_type_id__once = 0;
	if (g_once_init_enter (&about_operating_system_view_link_row_type_id__once)) {
		GType about_operating_system_view_link_row_type_id;
		about_operating_system_view_link_row_type_id = about_operating_system_view_link_row_get_type_once ();
		g_once_init_leave (&about_operating_system_view_link_row_type_id__once, about_operating_system_view_link_row_type_id);
	}
	return about_operating_system_view_link_row_type_id__once;
}

static void
_vala_about_operating_system_view_link_row_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	AboutOperatingSystemViewLinkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRow);
	switch (property_id) {
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_URI_PROPERTY:
		g_value_set_string (value, about_operating_system_view_link_row_get_uri (self));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_ICON_NAME_PROPERTY:
		g_value_set_string (value, about_operating_system_view_link_row_get_icon_name (self));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_LABEL_STRING_PROPERTY:
		g_value_set_string (value, about_operating_system_view_link_row_get_label_string (self));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_COLOR_PROPERTY:
		g_value_set_string (value, about_operating_system_view_link_row_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_about_operating_system_view_link_row_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	AboutOperatingSystemViewLinkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRow);
	switch (property_id) {
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_URI_PROPERTY:
		about_operating_system_view_link_row_set_uri (self, g_value_get_string (value));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_ICON_NAME_PROPERTY:
		about_operating_system_view_link_row_set_icon_name (self, g_value_get_string (value));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_LABEL_STRING_PROPERTY:
		about_operating_system_view_link_row_set_label_string (self, g_value_get_string (value));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_LINK_ROW_COLOR_PROPERTY:
		about_operating_system_view_link_row_set_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
about_operating_system_view_sponsor_us_row_get_instance_private (AboutOperatingSystemViewSponsorUsRow* self)
{
	return G_STRUCT_MEMBER_P (self, AboutOperatingSystemViewSponsorUsRow_private_offset);
}

static AboutOperatingSystemViewSponsorUsRow*
about_operating_system_view_sponsor_us_row_construct (GType object_type,
                                                      const gchar* uri)
{
	AboutOperatingSystemViewSponsorUsRow * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (AboutOperatingSystemViewSponsorUsRow*) g_object_new (object_type, "uri", uri, NULL);
	return self;
}

static AboutOperatingSystemViewSponsorUsRow*
about_operating_system_view_sponsor_us_row_new (const gchar* uri)
{
	return about_operating_system_view_sponsor_us_row_construct (ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, uri);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		AboutOperatingSystemViewSponsorUsRow* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->session);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		AboutOperatingSystemViewSponsorUsRow* self;
		self = _data13_->_data12_->self;
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
___lambda5_ (Block13Data* _data13_,
             gdouble val)
{
	Block12Data* _data12_;
	AboutOperatingSystemViewSponsorUsRow* self;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLevelBar* _tmp3_;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	_tmp0_ = self->priv->target_label;
	_tmp1_ = g_strdup_printf (_ ("%.0f%% towards $%'5.0f per month goal"), round (val), _data13_->target_value);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->levelbar;
	gtk_level_bar_set_value (_tmp3_, val / 100.0);
}

static void
____lambda5__adw_animation_target_func (gdouble value,
                                        gpointer self)
{
	___lambda5_ (self, value);
}

static void
__lambda4_ (Block12Data* _data12_,
            GObject* obj,
            GAsyncResult* res)
{
	AboutOperatingSystemViewSponsorUsRow* self;
	GError* _inner_error0_ = NULL;
	self = _data12_->self;
	g_return_if_fail (res != NULL);
	{
		Block13Data* _data13_;
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gchar* output = NULL;
		GBytes* _tmp1_;
		gsize _tmp2_ = 0;
		guint8* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		JsonParser* parser = NULL;
		JsonParser* _tmp6_;
		JsonParser* _tmp7_;
		const gchar* _tmp8_;
		JsonNode* root = NULL;
		JsonParser* _tmp9_;
		JsonNode* _tmp10_;
		JsonNode* _tmp11_;
		JsonNode* _tmp12_;
		gint64 percent_complete = 0LL;
		JsonNode* _tmp13_;
		JsonObject* _tmp14_;
		JsonNode* _tmp15_;
		JsonObject* _tmp16_;
		AdwCallbackAnimationTarget* animation_target = NULL;
		AdwCallbackAnimationTarget* _tmp17_;
		AdwTimedAnimation* animation = NULL;
		AdwCallbackAnimationTarget* _tmp18_;
		AdwAnimationTarget* _tmp19_;
		AdwTimedAnimation* _tmp20_ = NULL;
		GtkRevealer* _tmp21_;
		AdwTimedAnimation* _tmp22_;
		_data13_ = g_slice_new0 (Block13Data);
		_data13_->_ref_count_ = 1;
		_data13_->_data12_ = block12_data_ref (_data12_);
		_tmp0_ = soup_session_send_and_read_finish (_data12_->session, res, &_inner_error0_);
		bytes = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block13_data_unref (_data13_);
			_data13_ = NULL;
			goto __catch0_g_error;
		}
		_tmp1_ = bytes;
		_tmp3_ = g_bytes_get_data (_tmp1_, &_tmp2_);
		_tmp4_ = g_strdup ((const gchar*) _tmp3_);
		output = _tmp4_;
		_tmp5_ = output;
		if (_tmp5_ == NULL) {
			_g_free0 (output);
			_g_bytes_unref0 (bytes);
			block13_data_unref (_data13_);
			_data13_ = NULL;
			return;
		}
		_tmp6_ = json_parser_new ();
		parser = _tmp6_;
		_tmp7_ = parser;
		_tmp8_ = output;
		json_parser_load_from_data (_tmp7_, _tmp8_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			_g_free0 (output);
			_g_bytes_unref0 (bytes);
			block13_data_unref (_data13_);
			_data13_ = NULL;
			goto __catch0_g_error;
		}
		_tmp9_ = parser;
		_tmp10_ = json_parser_get_root (_tmp9_);
		_tmp11_ = __vala_JsonNode_copy0 (_tmp10_);
		root = _tmp11_;
		_tmp12_ = root;
		if (json_node_get_node_type (_tmp12_) != JSON_NODE_OBJECT) {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (output);
			_g_bytes_unref0 (bytes);
			block13_data_unref (_data13_);
			_data13_ = NULL;
			return;
		}
		_tmp13_ = root;
		_tmp14_ = json_node_get_object (_tmp13_);
		percent_complete = json_object_get_int_member (_tmp14_, "percent");
		_tmp15_ = root;
		_tmp16_ = json_node_get_object (_tmp15_);
		_data13_->target_value = json_object_get_double_member (_tmp16_, "target");
		_tmp17_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (____lambda5__adw_animation_target_func, block13_data_ref (_data13_), block13_data_unref);
		animation_target = _tmp17_;
		_tmp18_ = animation_target;
		_tmp19_ = _g_object_ref0 ((AdwAnimationTarget*) _tmp18_);
		_tmp20_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, (gdouble) 0, (gdouble) percent_complete, (guint) 1000, _tmp19_);
		adw_timed_animation_set_easing (_tmp20_, ADW_EASE_IN_OUT_QUAD);
		animation = _tmp20_;
		_tmp21_ = self->priv->details_revealer;
		gtk_revealer_set_reveal_child (_tmp21_, TRUE);
		_tmp22_ = animation;
		adw_animation_play ((AdwAnimation*) _tmp22_);
		_g_object_unref0 (animation);
		_g_object_unref0 (animation_target);
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (parser);
		_g_free0 (output);
		_g_bytes_unref0 (bytes);
		block13_data_unref (_data13_);
		_data13_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_critical ("OperatingSystemView.vala:905: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block12_data_unref (self);
}

static void
about_operating_system_view_sponsor_us_row_get_goal_progress (AboutOperatingSystemViewSponsorUsRow* self,
                                                              GCancellable* cancellable)
{
	Block12Data* _data12_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	SoupSession* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = soup_message_new ("GET", "https://elementary.io/api/sponsors_goal");
	message = _tmp0_;
	_tmp1_ = soup_session_new ();
	_data12_->session = _tmp1_;
	soup_session_send_and_read_async (_data12_->session, message, G_PRIORITY_DEFAULT, cancellable, ___lambda4__gasync_ready_callback, block12_data_ref (_data12_));
	_g_object_unref0 (message);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static const gchar*
about_operating_system_view_sponsor_us_row_get_uri (AboutOperatingSystemViewSponsorUsRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
about_operating_system_view_sponsor_us_row_set_uri (AboutOperatingSystemViewSponsorUsRow* self,
                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = about_operating_system_view_sponsor_us_row_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, about_operating_system_view_sponsor_us_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_URI_PROPERTY]);
	}
}

static gboolean
about_operating_system_view_sponsor_us_row_get_was_loaded (AboutOperatingSystemViewSponsorUsRow* self)
{
	gboolean result;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->details_revealer;
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GObject *
about_operating_system_view_sponsor_us_row_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutOperatingSystemViewSponsorUsRow * self;
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkLabel* main_label = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLevelBar* _tmp7_;
	GtkLevelBar* _tmp8_;
	GtkLevelBar* _tmp9_;
	GtkBox* details_box = NULL;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkLevelBar* _tmp14_;
	GtkBox* _tmp15_;
	GtkWidget* _tmp16_;
	GtkRevealer* _tmp17_ = NULL;
	GtkImage* link_image = NULL;
	GtkImage* _tmp18_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp19_ = NULL;
	GtkGrid* _tmp20_;
	GtkImage* _tmp21_;
	GtkGrid* _tmp22_;
	GtkLabel* _tmp23_;
	GtkGrid* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkGrid* _tmp26_;
	GtkImage* _tmp27_;
	GtkGrid* _tmp28_;
	parent_class = G_OBJECT_CLASS (about_operating_system_view_sponsor_us_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRow);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("face-heart-symbolic");
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp2_ = image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "pink");
	_tmp3_ = (GtkLabel*) gtk_label_new (_ ("Sponsor Us"));
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	main_label = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->target_label);
	self->priv->target_label = _tmp4_;
	_tmp5_ = self->priv->target_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp6_ = self->priv->target_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp7_ = (GtkLevelBar*) gtk_level_bar_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->levelbar);
	self->priv->levelbar = _tmp7_;
	_tmp8_ = self->priv->levelbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, GRANITE_STYLE_CLASS_FLAT);
	_tmp9_ = self->priv->levelbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "pink");
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp10_);
	details_box = _tmp10_;
	_tmp11_ = details_box;
	_tmp12_ = self->priv->target_label;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = details_box;
	_tmp14_ = self->priv->levelbar;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = details_box;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	_tmp17_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp17_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	gtk_revealer_set_reveal_child (_tmp17_, FALSE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->details_revealer);
	self->priv->details_revealer = _tmp17_;
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("adw-external-link-symbolic");
	g_object_ref_sink (_tmp18_);
	link_image = _tmp18_;
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp19_);
	grid = _tmp19_;
	_tmp20_ = grid;
	_tmp21_ = image;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 0, 1, 2);
	_tmp22_ = grid;
	_tmp23_ = main_label;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 0, 1, 1);
	_tmp24_ = grid;
	_tmp25_ = self->priv->details_revealer;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 1, 1, 1, 1);
	_tmp26_ = grid;
	_tmp27_ = link_image;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 2, 0, 2, 2);
	_tmp28_ = grid;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp28_);
	gtk_widget_add_css_class ((GtkWidget*) self, "link");
	_g_object_unref0 (grid);
	_g_object_unref0 (link_image);
	_g_object_unref0 (details_box);
	_g_object_unref0 (main_label);
	_g_object_unref0 (image);
	return obj;
}

static void
about_operating_system_view_sponsor_us_row_base_init (AboutOperatingSystemViewSponsorUsRowClass * klass)
{
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), GTK_ACCESSIBLE_ROLE_LINK);
}

static void
about_operating_system_view_sponsor_us_row_class_init (AboutOperatingSystemViewSponsorUsRowClass * klass,
                                                       gpointer klass_data)
{
	about_operating_system_view_sponsor_us_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutOperatingSystemViewSponsorUsRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_about_operating_system_view_sponsor_us_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_about_operating_system_view_sponsor_us_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = about_operating_system_view_sponsor_us_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_operating_system_view_sponsor_us_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_URI_PROPERTY, about_operating_system_view_sponsor_us_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_WAS_LOADED_PROPERTY, about_operating_system_view_sponsor_us_row_properties[ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_WAS_LOADED_PROPERTY] = g_param_spec_boolean ("was-loaded", "was-loaded", "was-loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
about_operating_system_view_sponsor_us_row_instance_init (AboutOperatingSystemViewSponsorUsRow * self,
                                                          gpointer klass)
{
	self->priv = about_operating_system_view_sponsor_us_row_get_instance_private (self);
}

static void
about_operating_system_view_sponsor_us_row_finalize (GObject * obj)
{
	AboutOperatingSystemViewSponsorUsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRow);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->target_label);
	_g_object_unref0 (self->priv->levelbar);
	_g_object_unref0 (self->priv->details_revealer);
	G_OBJECT_CLASS (about_operating_system_view_sponsor_us_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_operating_system_view_sponsor_us_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutOperatingSystemViewSponsorUsRowClass), (GBaseInitFunc) about_operating_system_view_sponsor_us_row_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_operating_system_view_sponsor_us_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutOperatingSystemViewSponsorUsRow), 0, (GInstanceInitFunc) about_operating_system_view_sponsor_us_row_instance_init, NULL };
	GType about_operating_system_view_sponsor_us_row_type_id;
	about_operating_system_view_sponsor_us_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "AboutOperatingSystemViewSponsorUsRow", &g_define_type_info, 0);
	AboutOperatingSystemViewSponsorUsRow_private_offset = g_type_add_instance_private (about_operating_system_view_sponsor_us_row_type_id, sizeof (AboutOperatingSystemViewSponsorUsRowPrivate));
	return about_operating_system_view_sponsor_us_row_type_id;
}

static GType
about_operating_system_view_sponsor_us_row_get_type (void)
{
	static volatile gsize about_operating_system_view_sponsor_us_row_type_id__once = 0;
	if (g_once_init_enter (&about_operating_system_view_sponsor_us_row_type_id__once)) {
		GType about_operating_system_view_sponsor_us_row_type_id;
		about_operating_system_view_sponsor_us_row_type_id = about_operating_system_view_sponsor_us_row_get_type_once ();
		g_once_init_leave (&about_operating_system_view_sponsor_us_row_type_id__once, about_operating_system_view_sponsor_us_row_type_id);
	}
	return about_operating_system_view_sponsor_us_row_type_id__once;
}

static void
_vala_about_operating_system_view_sponsor_us_row_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	AboutOperatingSystemViewSponsorUsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRow);
	switch (property_id) {
		case ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_URI_PROPERTY:
		g_value_set_string (value, about_operating_system_view_sponsor_us_row_get_uri (self));
		break;
		case ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_WAS_LOADED_PROPERTY:
		g_value_set_boolean (value, about_operating_system_view_sponsor_us_row_get_was_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_about_operating_system_view_sponsor_us_row_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	AboutOperatingSystemViewSponsorUsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRow);
	switch (property_id) {
		case ABOUT_OPERATING_SYSTEM_VIEW_SPONSOR_US_ROW_URI_PROPERTY:
		about_operating_system_view_sponsor_us_row_set_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_about_operating_system_view_settings_restore_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	about_operating_system_view_settings_restore_clicked ((AboutOperatingSystemView*) self);
}

static void
_about_operating_system_view___lambda9_ (AboutOperatingSystemView* self)
{
	GDesktopAppInfo* appinfo = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_desktop_app_info_new ("io.elementary.feedback.desktop");
	appinfo = _tmp0_;
	_tmp1_ = appinfo;
	if (_tmp1_ != NULL) {
		{
			GDesktopAppInfo* _tmp2_;
			_tmp2_ = appinfo;
			g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_critical ("OperatingSystemView.vala:387: %s", _tmp4_);
			_tmp5_ = about_operating_system_view_get_bug_url ();
			_tmp6_ = _tmp5_;
			about_operating_system_view_launch_uri (self, _tmp6_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = about_operating_system_view_get_bug_url ();
		_tmp8_ = _tmp7_;
		about_operating_system_view_launch_uri (self, _tmp8_);
	}
	_g_object_unref0 (appinfo);
}

static void
__about_operating_system_view___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	_about_operating_system_view___lambda9_ ((AboutOperatingSystemView*) self);
}

static void
_about_operating_system_view___lambda10_ (AboutOperatingSystemView* self,
                                          GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (row != NULL);
	_tmp0_ = about_operating_system_view_sponsor_us_row_get_uri (G_TYPE_CHECK_INSTANCE_CAST (row, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_SPONSOR_US_ROW, AboutOperatingSystemViewSponsorUsRow));
	_tmp1_ = _tmp0_;
	about_operating_system_view_launch_uri (self, _tmp1_);
}

static void
__about_operating_system_view___lambda10__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self)
{
	_about_operating_system_view___lambda10_ ((AboutOperatingSystemView*) self, row);
}

static void
_about_operating_system_view___lambda11_ (AboutOperatingSystemView* self,
                                          GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (row != NULL);
	_tmp0_ = about_operating_system_view_link_row_get_uri (G_TYPE_CHECK_INSTANCE_CAST (row, ABOUT_OPERATING_SYSTEM_VIEW_TYPE_LINK_ROW, AboutOperatingSystemViewLinkRow));
	_tmp1_ = _tmp0_;
	about_operating_system_view_launch_uri (self, _tmp1_);
}

static void
__about_operating_system_view___lambda11__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self)
{
	_about_operating_system_view___lambda11_ ((AboutOperatingSystemView*) self, row);
}

static void
_about_operating_system_view_update_state_system_update_state_changed (SystemUpdate* _sender,
                                                                       gpointer self)
{
	about_operating_system_view_update_state ((AboutOperatingSystemView*) self, NULL, NULL);
}

static void
_about_operating_system_view___lambda12_ (AboutOperatingSystemView* self,
                                          GObject* obj,
                                          GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SystemUpdate* _tmp0_ = NULL;
		SystemUpdate* _tmp1_;
		SystemUpdate* _tmp2_;
		SystemUpdate* _tmp3_;
		SystemUpdate* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (SystemUpdate*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (SystemUpdate*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->update_proxy);
		self->priv->update_proxy = _tmp3_;
		_tmp4_ = self->priv->update_proxy;
		g_signal_connect_object (_tmp4_, "state-changed", (GCallback) _about_operating_system_view_update_state_system_update_state_changed, self, 0);
		about_operating_system_view_update_state (self, NULL, NULL);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_critical ("OperatingSystemView.vala:412: Failed to get updates proxy");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__about_operating_system_view___lambda12__gasync_ready_callback (GObject* source_object,
                                                                 GAsyncResult* res,
                                                                 gpointer self)
{
	_about_operating_system_view___lambda12_ ((AboutOperatingSystemView*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda14_ (AboutOperatingSystemView* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SystemUpdate* _tmp0_;
		_tmp0_ = self->priv->update_proxy;
		system_update_update_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("OperatingSystemView.vala:422: Failed to update: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda14__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda14_ ((AboutOperatingSystemView*) self, source_object, res);
	g_object_unref (self);
}

static void
_about_operating_system_view___lambda13_ (AboutOperatingSystemView* self)
{
	SystemUpdate* _tmp0_;
	_tmp0_ = self->priv->update_proxy;
	if (_tmp0_ != NULL) {
		SystemUpdate* _tmp1_;
		_tmp1_ = self->priv->update_proxy;
		system_update_update (_tmp1_, ____lambda14__gasync_ready_callback, g_object_ref (self));
	}
}

static void
__about_operating_system_view___lambda13__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_about_operating_system_view___lambda13_ ((AboutOperatingSystemView*) self);
}

static void
___lambda16_ (AboutOperatingSystemView* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SystemUpdate* _tmp0_;
		_tmp0_ = self->priv->update_proxy;
		system_update_cancel_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("OperatingSystemView.vala:434: Failed to cancel update: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda16__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda16_ ((AboutOperatingSystemView*) self, source_object, res);
	g_object_unref (self);
}

static void
_about_operating_system_view___lambda15_ (AboutOperatingSystemView* self)
{
	SystemUpdate* _tmp0_;
	_tmp0_ = self->priv->update_proxy;
	if (_tmp0_ != NULL) {
		SystemUpdate* _tmp1_;
		_tmp1_ = self->priv->update_proxy;
		system_update_cancel (_tmp1_, ____lambda16__gasync_ready_callback, g_object_ref (self));
	}
}

static void
__about_operating_system_view___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_about_operating_system_view___lambda15_ ((AboutOperatingSystemView*) self);
}

static void
_about_operating_system_view_refresh_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	about_operating_system_view_refresh_clicked ((AboutOperatingSystemView*) self, NULL, NULL);
}

static void
_about_operating_system_view_details_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	about_operating_system_view_details_clicked ((AboutOperatingSystemView*) self);
}

static GObject *
about_operating_system_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutOperatingSystemView * self;
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkDisplay* _tmp2_;
	GtkCssProvider* _tmp3_;
	struct utsname uts_name = {0};
	gchar* logo_icon_name = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	GtkImage* icon = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GtkImage* _tmp11_ = NULL;
	GtkOverlay* logo_overlay = NULL;
	GtkOverlay* _tmp12_ = NULL;
	GdkDisplay* _tmp13_;
	GtkIconTheme* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	GtkImage* _tmp37_;
	GtkWidget* _tmp38_;
	GtkWidget* _tmp39_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gchar* pretty_name = NULL;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GtkLabel* title = NULL;
	const gchar* _tmp50_;
	GtkLabel* _tmp51_ = NULL;
	GtkLabel* _tmp52_;
	GtkLabel* kernel_version_label = NULL;
	struct utsname _tmp53_;
	const gchar* _tmp54_;
	struct utsname _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	GtkLabel* _tmp59_ = NULL;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkStringList* _tmp63_;
	GtkImage* _tmp64_ = NULL;
	GtkLabel* _tmp65_ = NULL;
	GtkProgressBar* _tmp66_ = NULL;
	GtkProgressBar* _tmp67_;
	GtkWidget* _tmp68_;
	GtkRevealer* _tmp69_ = NULL;
	GtkLabel* _tmp70_ = NULL;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkBox* progress_description_box = NULL;
	GtkBox* _tmp73_;
	GtkBox* _tmp74_;
	GtkRevealer* _tmp75_;
	GtkBox* _tmp76_;
	GtkLabel* _tmp77_;
	GtkButton* update_button = NULL;
	GtkButton* _tmp78_;
	GtkButton* _tmp79_;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp80_;
	GtkButton* refresh_button = NULL;
	GtkButton* _tmp81_;
	GtkStack* _tmp82_ = NULL;
	GtkStack* _tmp83_;
	GtkGrid* _tmp84_;
	GtkGrid* _tmp85_;
	GtkStack* _tmp86_;
	GtkButton* _tmp87_;
	GtkStack* _tmp88_;
	GtkButton* _tmp89_;
	GtkStack* _tmp90_;
	GtkButton* _tmp91_;
	GtkButton* details_button = NULL;
	GtkButton* _tmp92_ = NULL;
	GtkButton* _tmp93_;
	GtkButton* _tmp94_;
	GtkButton* _tmp95_;
	GtkWidget* _tmp96_;
	GtkRevealer* _tmp97_ = NULL;
	GraniteSwitchModelButton* automatic_updates_button = NULL;
	gchar* _tmp98_;
	GraniteSwitchModelButton* _tmp99_ = NULL;
	GtkGrid* updates_grid = NULL;
	GtkGrid* _tmp100_ = NULL;
	GtkGrid* _tmp101_;
	GtkImage* _tmp102_;
	GtkGrid* _tmp103_;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkBox* _tmp106_;
	GtkGrid* _tmp107_;
	GtkStack* _tmp108_;
	GtkGrid* _tmp109_;
	GtkRevealer* _tmp110_;
	GtkListBox* updates_list = NULL;
	GtkListBox* _tmp111_ = NULL;
	GtkListBox* _tmp112_;
	GtkListBox* _tmp113_;
	GtkListBox* _tmp114_;
	GtkGrid* _tmp115_;
	GtkListBox* _tmp116_;
	GraniteSwitchModelButton* _tmp117_;
	GtkListBox* _tmp118_;
	GtkWidget* _tmp119_;
	GtkListBox* _tmp120_;
	GtkWidget* _tmp121_;
	AboutOperatingSystemViewSponsorUsRow* _tmp122_;
	GtkListBox* sponsor_list = NULL;
	GtkListBox* _tmp123_ = NULL;
	GtkListBox* _tmp124_;
	GtkListBox* _tmp125_;
	GtkListBox* _tmp126_;
	AboutOperatingSystemViewSponsorUsRow* _tmp127_;
	AboutOperatingSystemViewLinkRow* thebasics_link = NULL;
	const gchar* _tmp128_;
	const gchar* _tmp129_;
	AboutOperatingSystemViewLinkRow* _tmp130_;
	AboutOperatingSystemViewLinkRow* support_link = NULL;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	AboutOperatingSystemViewLinkRow* _tmp133_;
	AboutOperatingSystemViewLinkRow* website_link = NULL;
	const gchar* _tmp134_;
	const gchar* _tmp135_;
	AboutOperatingSystemViewLinkRow* _tmp136_;
	AboutOperatingSystemViewLinkRow* getinvolved_link = NULL;
	AboutOperatingSystemViewLinkRow* _tmp137_;
	GtkListBox* links_list = NULL;
	GtkListBox* _tmp138_ = NULL;
	GtkListBox* _tmp139_;
	GtkListBox* _tmp140_;
	GtkListBox* _tmp141_;
	AboutOperatingSystemViewLinkRow* _tmp142_;
	GtkListBox* _tmp143_;
	AboutOperatingSystemViewLinkRow* _tmp144_;
	GtkListBox* _tmp145_;
	AboutOperatingSystemViewLinkRow* _tmp146_;
	GtkListBox* _tmp147_;
	AboutOperatingSystemViewLinkRow* _tmp148_;
	GtkButton* settings_restore_button = NULL;
	GtkButton* _tmp149_;
	GtkButton* bug_button = NULL;
	GtkButton* _tmp150_ = NULL;
	GtkBox* button_grid = NULL;
	GtkBox* _tmp151_ = NULL;
	GtkBox* _tmp152_;
	GtkButton* _tmp153_;
	GtkBox* _tmp154_;
	GtkButton* _tmp155_;
	GtkGrid* _tmp156_ = NULL;
	GtkGrid* _tmp157_;
	GtkOverlay* _tmp158_;
	GtkGrid* _tmp159_;
	GtkLabel* _tmp160_;
	GtkGrid* _tmp161_;
	GtkLabel* _tmp162_;
	GtkGrid* _tmp163_;
	GtkListBox* _tmp164_;
	GtkGrid* _tmp165_;
	GtkListBox* _tmp166_;
	GtkGrid* _tmp167_;
	GtkListBox* _tmp168_;
	AdwClamp* clamp = NULL;
	GtkGrid* _tmp169_;
	GtkWidget* _tmp170_;
	AdwClamp* _tmp171_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	AdwClamp* _tmp172_;
	GtkWidget* _tmp173_;
	GtkScrolledWindow* _tmp174_ = NULL;
	GtkScrolledWindow* _tmp175_;
	GtkBox* _tmp176_;
	GSettings* system_updates_settings = NULL;
	GSettings* _tmp177_;
	GSettings* _tmp178_;
	GraniteSwitchModelButton* _tmp179_;
	GtkButton* _tmp180_;
	GtkButton* _tmp181_;
	GtkListBox* _tmp182_;
	GtkListBox* _tmp183_;
	GtkButton* _tmp184_;
	GtkButton* _tmp185_;
	GtkButton* _tmp186_;
	GtkButton* _tmp187_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (about_operating_system_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_OPERATING_SYSTEM_VIEW, AboutOperatingSystemView);
	gtk_widget_add_css_class ((GtkWidget*) self, "operating-system-view");
	_tmp0_ = gtk_css_provider_new ();
	style_provider = _tmp0_;
	_tmp1_ = style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/settings/system/OperatingSystemView.css");
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = style_provider;
	gtk_style_context_add_provider_for_display (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	uname (&uts_name);
	_tmp4_ = g_get_os_info ("LOGO");
	logo_icon_name = _tmp4_;
	_tmp6_ = logo_icon_name;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = logo_icon_name;
		_tmp5_ = _tmp7_ == NULL;
	}
	if (_tmp5_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("distributor-logo");
		_g_free0 (logo_icon_name);
		logo_icon_name = _tmp8_;
	}
	_tmp9_ = logo_icon_name;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp11_, "icon-name", _tmp10_, NULL);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	icon = _tmp11_;
	_tmp12_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp12_);
	logo_overlay = _tmp12_;
	_tmp13_ = gdk_display_get_default ();
	_tmp14_ = gtk_icon_theme_get_for_display (_tmp13_);
	_tmp15_ = logo_icon_name;
	_tmp16_ = g_strconcat (_tmp15_, "-symbolic", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = gtk_icon_theme_has_icon (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	if (_tmp18_) {
		gchar** _tmp19_;
		gchar** _tmp20_;
		_tmp20_ = _tmp19_ = g_get_system_data_dirs ();
		{
			gchar** path_collection = NULL;
			gint path_collection_length1 = 0;
			gint _path_collection_size_ = 0;
			gint path_it = 0;
			path_collection = _tmp20_;
			path_collection_length1 = _vala_array_length (_tmp19_);
			for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
				const gchar* path = NULL;
				path = path_collection[path_it];
				{
					GFile* file = NULL;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					GFile* _tmp24_;
					GFile* _tmp25_;
					GFile* _tmp26_;
					_tmp21_ = path;
					_tmp22_ = g_build_path (G_DIR_SEPARATOR_S, _tmp21_, "backgrounds", "elementaryos-default", NULL);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_file_new_for_path (_tmp23_);
					_tmp25_ = _tmp24_;
					_g_free0 (_tmp23_);
					file = _tmp25_;
					_tmp26_ = file;
					if (g_file_query_exists (_tmp26_, NULL)) {
						GFile* _tmp27_;
						GFile* _tmp28_;
						GdkPaintable* _tmp29_;
						AdwAvatar* _tmp30_ = NULL;
						GtkOverlay* _tmp31_;
						AdwAvatar* _tmp32_;
						GtkOverlay* _tmp33_;
						GtkImage* _tmp34_;
						GtkImage* _tmp35_;
						GtkImage* _tmp36_;
						_tmp27_ = file;
						_tmp28_ = _g_object_ref0 (_tmp27_);
						_g_object_unref0 (self->priv->logo_file);
						self->priv->logo_file = _tmp28_;
						_tmp29_ = gdk_paintable_new_empty (128, 128);
						_tmp30_ = (AdwAvatar*) adw_avatar_new (128, "", FALSE);
						adw_avatar_set_custom_image (_tmp30_, _tmp29_);
						_g_object_unref0 (_tmp29_);
						g_object_ref_sink (_tmp30_);
						_g_object_unref0 (self->priv->logo);
						self->priv->logo = _tmp30_;
						_tmp31_ = logo_overlay;
						_tmp32_ = self->priv->logo;
						gtk_overlay_set_child (_tmp31_, (GtkWidget*) _tmp32_);
						_tmp33_ = logo_overlay;
						_tmp34_ = icon;
						gtk_overlay_add_overlay (_tmp33_, (GtkWidget*) _tmp34_);
						_tmp35_ = icon;
						gtk_image_set_pixel_size (_tmp35_, 128 - 6);
						_tmp36_ = icon;
						gtk_widget_add_css_class ((GtkWidget*) _tmp36_, "logo");
						_g_object_unref0 (file);
						break;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp37_ = icon;
	_tmp38_ = gtk_widget_get_parent ((GtkWidget*) _tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == NULL) {
		GtkImage* _tmp40_;
		GtkOverlay* _tmp41_;
		GtkImage* _tmp42_;
		_tmp40_ = icon;
		gtk_image_set_pixel_size (_tmp40_, 128);
		_tmp41_ = logo_overlay;
		_tmp42_ = icon;
		gtk_overlay_set_child (_tmp41_, (GtkWidget*) _tmp42_);
	}
	_tmp44_ = g_get_os_info (G_OS_INFO_KEY_VERSION);
	_tmp43_ = _tmp44_;
	if (_tmp43_ == NULL) {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		_g_free0 (_tmp43_);
		_tmp43_ = _tmp45_;
	}
	_tmp46_ = g_get_os_info (G_OS_INFO_KEY_NAME);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_strdup_printf ("<b>%s</b> %s", _tmp47_, _tmp43_);
	_tmp49_ = _tmp48_;
	_g_free0 (_tmp47_);
	pretty_name = _tmp49_;
	_tmp50_ = pretty_name;
	_tmp51_ = (GtkLabel*) gtk_label_new (_tmp50_);
	gtk_label_set_ellipsize (_tmp51_, PANGO_ELLIPSIZE_END);
	gtk_label_set_selectable (_tmp51_, TRUE);
	gtk_label_set_use_markup (_tmp51_, TRUE);
	gtk_label_set_xalign (_tmp51_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp51_, TRUE);
	g_object_ref_sink (_tmp51_);
	title = _tmp51_;
	_tmp52_ = title;
	gtk_widget_add_css_class ((GtkWidget*) _tmp52_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp53_ = uts_name;
	_tmp54_ = _tmp53_.sysname;
	_tmp55_ = uts_name;
	_tmp56_ = _tmp55_.release;
	_tmp57_ = g_strdup_printf ("%s %s", _tmp54_, _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = (GtkLabel*) gtk_label_new (_tmp58_);
	gtk_label_set_selectable (_tmp59_, TRUE);
	gtk_label_set_xalign (_tmp59_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp59_, TRUE);
	g_object_ref_sink (_tmp59_);
	_tmp60_ = _tmp59_;
	_g_free0 (_tmp58_);
	kernel_version_label = _tmp60_;
	_tmp61_ = kernel_version_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp61_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp62_ = kernel_version_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp62_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp63_ = gtk_string_list_new (NULL);
	_g_object_unref0 (self->priv->packages);
	self->priv->packages = _tmp63_;
	_tmp64_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_icon_size (_tmp64_, GTK_ICON_SIZE_LARGE);
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->updates_image);
	self->priv->updates_image = _tmp64_;
	_tmp65_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp65_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp65_, 6);
	gtk_label_set_xalign (_tmp65_, (gfloat) 0);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->updates_title);
	self->priv->updates_title = _tmp65_;
	_tmp66_ = (GtkProgressBar*) gtk_progress_bar_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp66_, 3);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->update_progress_bar);
	self->priv->update_progress_bar = _tmp66_;
	_tmp67_ = self->priv->update_progress_bar;
	_tmp68_ = _g_object_ref0 ((GtkWidget*) _tmp67_);
	_tmp69_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp69_, _tmp68_);
	_g_object_unref0 (_tmp68_);
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->update_progress_revealer);
	self->priv->update_progress_revealer = _tmp69_;
	_tmp70_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_xalign (_tmp70_, (gfloat) 0);
	gtk_label_set_use_markup (_tmp70_, TRUE);
	gtk_label_set_wrap (_tmp70_, TRUE);
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (self->priv->updates_description);
	self->priv->updates_description = _tmp70_;
	_tmp71_ = self->priv->updates_description;
	gtk_widget_add_css_class ((GtkWidget*) _tmp71_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp72_ = self->priv->updates_description;
	gtk_widget_add_css_class ((GtkWidget*) _tmp72_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp73_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp73_);
	progress_description_box = _tmp73_;
	_tmp74_ = progress_description_box;
	_tmp75_ = self->priv->update_progress_revealer;
	gtk_box_append (_tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = progress_description_box;
	_tmp77_ = self->priv->updates_description;
	gtk_box_append (_tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = (GtkButton*) gtk_button_new_with_label (_ ("Download"));
	g_object_ref_sink (_tmp78_);
	update_button = _tmp78_;
	_tmp79_ = update_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp79_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp80_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp80_);
	cancel_button = _tmp80_;
	_tmp81_ = (GtkButton*) gtk_button_new_with_label (_ ("Refresh"));
	g_object_ref_sink (_tmp81_);
	refresh_button = _tmp81_;
	_tmp82_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_hhomogeneous (_tmp82_, FALSE);
	gtk_stack_set_transition_type (_tmp82_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	gtk_widget_set_valign ((GtkWidget*) _tmp82_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (self->priv->button_stack);
	self->priv->button_stack = _tmp82_;
	_tmp83_ = self->priv->button_stack;
	_tmp84_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp84_);
	_tmp85_ = _tmp84_;
	gtk_stack_add_named (_tmp83_, (GtkWidget*) _tmp85_, "blank");
	_g_object_unref0 (_tmp85_);
	_tmp86_ = self->priv->button_stack;
	_tmp87_ = update_button;
	gtk_stack_add_named (_tmp86_, (GtkWidget*) _tmp87_, "update");
	_tmp88_ = self->priv->button_stack;
	_tmp89_ = cancel_button;
	gtk_stack_add_named (_tmp88_, (GtkWidget*) _tmp89_, "cancel");
	_tmp90_ = self->priv->button_stack;
	_tmp91_ = refresh_button;
	gtk_stack_add_named (_tmp90_, (GtkWidget*) _tmp91_, "refresh");
	_tmp92_ = (GtkButton*) gtk_button_new_with_label (_ ("Learn More…"));
	gtk_widget_set_halign ((GtkWidget*) _tmp92_, GTK_ALIGN_START);
	gtk_button_set_has_frame (_tmp92_, FALSE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp92_, 6);
	g_object_ref_sink (_tmp92_);
	details_button = _tmp92_;
	_tmp93_ = details_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp93_, "link");
	_tmp94_ = details_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp94_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp95_ = details_button;
	_tmp96_ = _g_object_ref0 ((GtkWidget*) _tmp95_);
	_tmp97_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp97_, _tmp96_);
	_g_object_unref0 (_tmp96_);
	g_object_ref_sink (_tmp97_);
	_g_object_unref0 (self->priv->details_button_revealer);
	self->priv->details_button_revealer = _tmp97_;
	_tmp98_ = g_strdup (_ ("Updates will be automatically downloaded. They will be installed when " \
"this device is restarted."));
	_tmp99_ = granite_switch_model_button_new (_ ("Automatic Updates"));
	granite_switch_model_button_set_description (_tmp99_, _tmp98_);
	_g_free0 (_tmp98_);
	g_object_ref_sink (_tmp99_);
	automatic_updates_button = _tmp99_;
	_tmp100_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp100_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp100_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp100_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp100_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp100_, 6);
	g_object_ref_sink (_tmp100_);
	updates_grid = _tmp100_;
	_tmp101_ = updates_grid;
	_tmp102_ = self->priv->updates_image;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 0, 0, 1, 2);
	_tmp103_ = updates_grid;
	_tmp104_ = self->priv->updates_title;
	gtk_grid_attach (_tmp103_, (GtkWidget*) _tmp104_, 1, 0, 1, 1);
	_tmp105_ = updates_grid;
	_tmp106_ = progress_description_box;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 1, 1, 1, 1);
	_tmp107_ = updates_grid;
	_tmp108_ = self->priv->button_stack;
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 2, 0, 1, 2);
	_tmp109_ = updates_grid;
	_tmp110_ = self->priv->details_button_revealer;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 1, 2, 2, 1);
	_tmp111_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp111_, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp111_, 12);
	gtk_widget_set_valign ((GtkWidget*) _tmp111_, GTK_ALIGN_CENTER);
	gtk_list_box_set_show_separators (_tmp111_, TRUE);
	gtk_list_box_set_selection_mode (_tmp111_, GTK_SELECTION_NONE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp111_, TRUE);
	g_object_ref_sink (_tmp111_);
	updates_list = _tmp111_;
	_tmp112_ = updates_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp112_, "boxed-list");
	_tmp113_ = updates_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp113_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp114_ = updates_list;
	_tmp115_ = updates_grid;
	gtk_list_box_append (_tmp114_, (GtkWidget*) _tmp115_);
	_tmp116_ = updates_list;
	_tmp117_ = automatic_updates_button;
	gtk_list_box_append (_tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = updates_list;
	_tmp119_ = gtk_widget_get_first_child ((GtkWidget*) _tmp118_);
	gtk_widget_set_focusable (_tmp119_, FALSE);
	_tmp120_ = updates_list;
	_tmp121_ = gtk_widget_get_last_child ((GtkWidget*) _tmp120_);
	gtk_widget_set_focusable (_tmp121_, FALSE);
	_tmp122_ = about_operating_system_view_sponsor_us_row_new ("https://github.com/sponsors/elementary");
	g_object_ref_sink (_tmp122_);
	_g_object_unref0 (self->priv->sponsor_us_row);
	self->priv->sponsor_us_row = _tmp122_;
	_tmp123_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp123_, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp123_, 12);
	gtk_widget_set_valign ((GtkWidget*) _tmp123_, GTK_ALIGN_CENTER);
	gtk_list_box_set_show_separators (_tmp123_, TRUE);
	gtk_list_box_set_selection_mode (_tmp123_, GTK_SELECTION_NONE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp123_, TRUE);
	g_object_ref_sink (_tmp123_);
	sponsor_list = _tmp123_;
	_tmp124_ = sponsor_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp124_, "boxed-list");
	_tmp125_ = sponsor_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp125_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp126_ = sponsor_list;
	_tmp127_ = self->priv->sponsor_us_row;
	gtk_list_box_append (_tmp126_, (GtkWidget*) _tmp127_);
	_tmp128_ = about_operating_system_view_get_documentation_url ();
	_tmp129_ = _tmp128_;
	_tmp130_ = about_operating_system_view_link_row_new (_tmp129_, _ ("Basics Guide"), "text-x-generic-symbolic", "green");
	g_object_ref_sink (_tmp130_);
	thebasics_link = _tmp130_;
	_tmp131_ = about_operating_system_view_get_support_url ();
	_tmp132_ = _tmp131_;
	_tmp133_ = about_operating_system_view_link_row_new (_tmp132_, _ ("Get Help"), "help-contents-symbolic", "blue");
	g_object_ref_sink (_tmp133_);
	support_link = _tmp133_;
	_tmp134_ = about_operating_system_view_get_website_url ();
	_tmp135_ = _tmp134_;
	_tmp136_ = about_operating_system_view_link_row_new (_tmp135_, _ ("Our Website"), "view-reader-symbolic", "slate");
	g_object_ref_sink (_tmp136_);
	website_link = _tmp136_;
	_tmp137_ = about_operating_system_view_link_row_new ("https://elementary.io/get-involved", _ ("Get Involved"), "applications-development-symbolic", "purple");
	g_object_ref_sink (_tmp137_);
	getinvolved_link = _tmp137_;
	_tmp138_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp138_, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp138_, 12);
	gtk_widget_set_valign ((GtkWidget*) _tmp138_, GTK_ALIGN_CENTER);
	gtk_list_box_set_show_separators (_tmp138_, TRUE);
	gtk_list_box_set_selection_mode (_tmp138_, GTK_SELECTION_NONE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp138_, TRUE);
	g_object_ref_sink (_tmp138_);
	links_list = _tmp138_;
	_tmp139_ = links_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp139_, "boxed-list");
	_tmp140_ = links_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp140_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp141_ = links_list;
	_tmp142_ = thebasics_link;
	gtk_list_box_append (_tmp141_, (GtkWidget*) _tmp142_);
	_tmp143_ = links_list;
	_tmp144_ = support_link;
	gtk_list_box_append (_tmp143_, (GtkWidget*) _tmp144_);
	_tmp145_ = links_list;
	_tmp146_ = website_link;
	gtk_list_box_append (_tmp145_, (GtkWidget*) _tmp146_);
	_tmp147_ = links_list;
	_tmp148_ = getinvolved_link;
	gtk_list_box_append (_tmp147_, (GtkWidget*) _tmp148_);
	_tmp149_ = (GtkButton*) gtk_button_new_with_label (_ ("Restore Default Settings"));
	g_object_ref_sink (_tmp149_);
	settings_restore_button = _tmp149_;
	_tmp150_ = (GtkButton*) gtk_button_new_with_label (_ ("Send Feedback"));
	gtk_widget_set_halign ((GtkWidget*) _tmp150_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp150_, TRUE);
	g_object_ref_sink (_tmp150_);
	bug_button = _tmp150_;
	_tmp151_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp151_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp151_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp151_, 12);
	g_object_ref_sink (_tmp151_);
	button_grid = _tmp151_;
	_tmp152_ = button_grid;
	_tmp153_ = settings_restore_button;
	gtk_box_append (_tmp152_, (GtkWidget*) _tmp153_);
	_tmp154_ = button_grid;
	_tmp155_ = bug_button;
	gtk_box_append (_tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp156_, 32);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp156_, 12);
	gtk_widget_set_valign ((GtkWidget*) _tmp156_, GTK_ALIGN_START);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp156_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp156_, TRUE);
	g_object_ref_sink (_tmp156_);
	_g_object_unref0 (self->priv->software_grid);
	self->priv->software_grid = _tmp156_;
	_tmp157_ = self->priv->software_grid;
	_tmp158_ = logo_overlay;
	gtk_grid_attach (_tmp157_, (GtkWidget*) _tmp158_, 0, 0, 1, 4);
	_tmp159_ = self->priv->software_grid;
	_tmp160_ = title;
	gtk_grid_attach (_tmp159_, (GtkWidget*) _tmp160_, 1, 0, 1, 1);
	_tmp161_ = self->priv->software_grid;
	_tmp162_ = kernel_version_label;
	gtk_grid_attach (_tmp161_, (GtkWidget*) _tmp162_, 1, 2, 1, 1);
	_tmp163_ = self->priv->software_grid;
	_tmp164_ = updates_list;
	gtk_grid_attach (_tmp163_, (GtkWidget*) _tmp164_, 1, 3, 1, 1);
	_tmp165_ = self->priv->software_grid;
	_tmp166_ = sponsor_list;
	gtk_grid_attach (_tmp165_, (GtkWidget*) _tmp166_, 1, 4, 1, 1);
	_tmp167_ = self->priv->software_grid;
	_tmp168_ = links_list;
	gtk_grid_attach (_tmp167_, (GtkWidget*) _tmp168_, 1, 5, 1, 1);
	_tmp169_ = self->priv->software_grid;
	_tmp170_ = _g_object_ref0 ((GtkWidget*) _tmp169_);
	_tmp171_ = (AdwClamp*) adw_clamp_new ();
	adw_clamp_set_child (_tmp171_, _tmp170_);
	_g_object_unref0 (_tmp170_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp171_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp171_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp171_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp171_, 12);
	g_object_ref_sink (_tmp171_);
	clamp = _tmp171_;
	_tmp172_ = clamp;
	_tmp173_ = _g_object_ref0 ((GtkWidget*) _tmp172_);
	_tmp174_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp174_, _tmp173_);
	_g_object_unref0 (_tmp173_);
	g_object_ref_sink (_tmp174_);
	scrolled_window = _tmp174_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 12);
	_tmp175_ = scrolled_window;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp175_);
	_tmp176_ = button_grid;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp176_);
	_tmp177_ = g_settings_new ("io.elementary.settings-daemon.system-update");
	system_updates_settings = _tmp177_;
	_tmp178_ = system_updates_settings;
	_tmp179_ = automatic_updates_button;
	g_settings_bind (_tmp178_, "automatic-updates", (GObject*) _tmp179_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp180_ = settings_restore_button;
	g_signal_connect_object (_tmp180_, "clicked", (GCallback) _about_operating_system_view_settings_restore_clicked_gtk_button_clicked, self, 0);
	_tmp181_ = bug_button;
	g_signal_connect_object (_tmp181_, "clicked", (GCallback) __about_operating_system_view___lambda9__gtk_button_clicked, self, 0);
	_tmp182_ = sponsor_list;
	g_signal_connect_object (_tmp182_, "row-activated", (GCallback) __about_operating_system_view___lambda10__gtk_list_box_row_activated, self, 0);
	_tmp183_ = links_list;
	g_signal_connect_object (_tmp183_, "row-activated", (GCallback) __about_operating_system_view___lambda11__gtk_list_box_row_activated, self, 0);
	about_operating_system_view_get_upstream_release (self, NULL, NULL);
	g_async_initable_new_async (TYPE_SYSTEM_UPDATE_PROXY, 0, NULL, __about_operating_system_view___lambda12__gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "io.elementary.settings-daemon", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/io/elementary/settings_daemon", "g-interface-name", "io.elementary.settings_daemon.SystemUpdate", NULL);
	_tmp184_ = update_button;
	g_signal_connect_object (_tmp184_, "clicked", (GCallback) __about_operating_system_view___lambda13__gtk_button_clicked, self, 0);
	_tmp185_ = cancel_button;
	g_signal_connect_object (_tmp185_, "clicked", (GCallback) __about_operating_system_view___lambda15__gtk_button_clicked, self, 0);
	_tmp186_ = refresh_button;
	g_signal_connect_object (_tmp186_, "clicked", (GCallback) _about_operating_system_view_refresh_clicked_gtk_button_clicked, self, 0);
	_tmp187_ = details_button;
	g_signal_connect_object (_tmp187_, "clicked", (GCallback) _about_operating_system_view_details_clicked_gtk_button_clicked, self, 0);
	_g_object_unref0 (system_updates_settings);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (clamp);
	_g_object_unref0 (button_grid);
	_g_object_unref0 (bug_button);
	_g_object_unref0 (settings_restore_button);
	_g_object_unref0 (links_list);
	_g_object_unref0 (getinvolved_link);
	_g_object_unref0 (website_link);
	_g_object_unref0 (support_link);
	_g_object_unref0 (thebasics_link);
	_g_object_unref0 (sponsor_list);
	_g_object_unref0 (updates_list);
	_g_object_unref0 (updates_grid);
	_g_object_unref0 (automatic_updates_button);
	_g_object_unref0 (details_button);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (update_button);
	_g_object_unref0 (progress_description_box);
	_g_object_unref0 (kernel_version_label);
	_g_object_unref0 (title);
	_g_free0 (pretty_name);
	_g_free0 (_tmp43_);
	_g_object_unref0 (logo_overlay);
	_g_object_unref0 (icon);
	_g_free0 (logo_icon_name);
	_g_object_unref0 (style_provider);
	return obj;
}

static void
about_operating_system_view_class_init (AboutOperatingSystemViewClass * klass,
                                        gpointer klass_data)
{
	about_operating_system_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutOperatingSystemView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_about_operating_system_view_get_property;
	G_OBJECT_CLASS (klass)->constructor = about_operating_system_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_operating_system_view_finalize;
}

static void
about_operating_system_view_instance_init (AboutOperatingSystemView * self,
                                           gpointer klass)
{
	self->priv = about_operating_system_view_get_instance_private (self);
	self->priv->download_size_remaining = (guint64) 0;
	self->priv->download_size_max = (guint64) 0;
	self->priv->update_proxy = NULL;
	self->priv->current_state = NULL;
}

static void
about_operating_system_view_finalize (GObject * obj)
{
	AboutOperatingSystemView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_OPERATING_SYSTEM_VIEW, AboutOperatingSystemView);
	_g_object_unref0 (self->priv->logo_file);
	_g_object_unref0 (self->priv->logo);
	_g_object_unref0 (self->priv->packages);
	_g_object_unref0 (self->priv->update_proxy);
	_system_update_current_state_free0 (self->priv->current_state);
	_g_object_unref0 (self->priv->software_grid);
	_g_object_unref0 (self->priv->updates_image);
	_g_object_unref0 (self->priv->updates_title);
	_g_object_unref0 (self->priv->update_progress_bar);
	_g_object_unref0 (self->priv->update_progress_revealer);
	_g_object_unref0 (self->priv->updates_description);
	_g_object_unref0 (self->priv->details_button_revealer);
	_g_object_unref0 (self->priv->button_stack);
	_g_object_unref0 (self->priv->sponsor_us_row);
	G_OBJECT_CLASS (about_operating_system_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_operating_system_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutOperatingSystemViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_operating_system_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutOperatingSystemView), 0, (GInstanceInitFunc) about_operating_system_view_instance_init, NULL };
	GType about_operating_system_view_type_id;
	about_operating_system_view_type_id = g_type_register_static (gtk_box_get_type (), "AboutOperatingSystemView", &g_define_type_info, 0);
	AboutOperatingSystemView_private_offset = g_type_add_instance_private (about_operating_system_view_type_id, sizeof (AboutOperatingSystemViewPrivate));
	return about_operating_system_view_type_id;
}

GType
about_operating_system_view_get_type (void)
{
	static volatile gsize about_operating_system_view_type_id__once = 0;
	if (g_once_init_enter (&about_operating_system_view_type_id__once)) {
		GType about_operating_system_view_type_id;
		about_operating_system_view_type_id = about_operating_system_view_get_type_once ();
		g_once_init_leave (&about_operating_system_view_type_id__once, about_operating_system_view_type_id);
	}
	return about_operating_system_view_type_id__once;
}

static void
_vala_about_operating_system_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	AboutOperatingSystemView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ABOUT_TYPE_OPERATING_SYSTEM_VIEW, AboutOperatingSystemView);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

