/* MutterDisplayConfig.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MutterDisplayConfig.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "display.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MUTTER_DISPLAY_CONFIG_INTERFACE_MONITORS_CHANGED_SIGNAL,
	MUTTER_DISPLAY_CONFIG_INTERFACE_NUM_SIGNALS
};
static guint mutter_display_config_interface_signals[MUTTER_DISPLAY_CONFIG_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy MutterDisplayConfigInterfaceProxy;
typedef GDBusProxyClass MutterDisplayConfigInterfaceProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static GType mutter_display_config_interface_get_type_once (void);
static void mutter_display_config_interface_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters);
static void _dbus_handle_mutter_display_config_interface_monitors_changed (MutterDisplayConfigInterface* self,
                                                                    GVariant* parameters);
static void mutter_display_config_interface_proxy_get_resources (MutterDisplayConfigInterface* self,
                                                          guint* serial,
                                                          MutterReadDisplayCrtc** crtcs,
                                                          gint* crtcs_length1,
                                                          MutterReadDisplayOutput** outputs,
                                                          gint* outputs_length1,
                                                          MutterReadDisplayMode** modes,
                                                          gint* modes_length1,
                                                          gint* max_screen_width,
                                                          gint* max_screen_height,
                                                          GError** error);
static void mutter_display_config_interface_proxy_apply_configuration (MutterDisplayConfigInterface* self,
                                                                guint serial,
                                                                gboolean persistent,
                                                                MutterWriteDisplayCrtc* crtcs,
                                                                gint crtcs_length1,
                                                                MutterWriteDisplayOutput* outputs,
                                                                gint outputs_length1,
                                                                GError** error);
static gint mutter_display_config_interface_proxy_change_backlight (MutterDisplayConfigInterface* self,
                                                             guint serial,
                                                             guint output,
                                                             gint value,
                                                             GError** error);
static void mutter_display_config_interface_proxy_get_crtc_gamma (MutterDisplayConfigInterface* self,
                                                           guint serial,
                                                           guint crtc,
                                                           guint** red,
                                                           gint* red_length1,
                                                           guint** green,
                                                           gint* green_length1,
                                                           guint** blue,
                                                           gint* blue_length1,
                                                           GError** error);
static void mutter_display_config_interface_proxy_set_crtc_gamma (MutterDisplayConfigInterface* self,
                                                           guint serial,
                                                           guint crtc,
                                                           guint* red,
                                                           gint red_length1,
                                                           guint* green,
                                                           gint green_length1,
                                                           guint* blue,
                                                           gint blue_length1,
                                                           GError** error);
static void mutter_display_config_interface_proxy_get_current_state (MutterDisplayConfigInterface* self,
                                                              guint* serial,
                                                              MutterReadMonitor** monitors,
                                                              gint* monitors_length1,
                                                              MutterReadLogicalMonitor** logical_monitors,
                                                              gint* logical_monitors_length1,
                                                              GHashTable** properties,
                                                              GError** error);
static void mutter_display_config_interface_proxy_apply_monitors_config (MutterDisplayConfigInterface* self,
                                                                  guint serial,
                                                                  MutterApplyMethod method,
                                                                  MutterWriteLogicalMonitor* logical_monitors,
                                                                  gint logical_monitors_length1,
                                                                  GHashTable* properties,
                                                                  GError** error);
static gint mutter_display_config_interface_dbus_proxy_get_power_save_mode (MutterDisplayConfigInterface* self);
static void mutter_display_config_interface_dbus_proxy_set_power_save_mode (MutterDisplayConfigInterface* self,
                                                                     gint value);
static void mutter_display_config_interface_proxy_mutter_display_config_interface_interface_init (MutterDisplayConfigInterfaceIface* iface);
static void _vala_MutterReadDisplayCrtc_array_free (MutterReadDisplayCrtc * array,
                                             gssize array_length);
static void _vala_MutterReadDisplayOutput_array_free (MutterReadDisplayOutput * array,
                                               gssize array_length);
static void _dbus_mutter_display_config_interface_get_resources (MutterDisplayConfigInterface* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _vala_MutterWriteDisplayCrtc_array_free (MutterWriteDisplayCrtc * array,
                                              gssize array_length);
static void _vala_MutterWriteDisplayOutput_array_free (MutterWriteDisplayOutput * array,
                                                gssize array_length);
static void _dbus_mutter_display_config_interface_apply_configuration (MutterDisplayConfigInterface* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation);
static void _dbus_mutter_display_config_interface_change_backlight (MutterDisplayConfigInterface* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation);
static void _dbus_mutter_display_config_interface_get_crtc_gamma (MutterDisplayConfigInterface* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void _dbus_mutter_display_config_interface_set_crtc_gamma (MutterDisplayConfigInterface* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void _vala_MutterReadMonitor_array_free (MutterReadMonitor * array,
                                         gssize array_length);
static void _vala_MutterReadLogicalMonitor_array_free (MutterReadLogicalMonitor * array,
                                                gssize array_length);
static void _dbus_mutter_display_config_interface_get_current_state (MutterDisplayConfigInterface* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _vala_MutterWriteLogicalMonitor_array_free (MutterWriteLogicalMonitor * array,
                                                 gssize array_length);
static void _dbus_mutter_display_config_interface_apply_monitors_config (MutterDisplayConfigInterface* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void mutter_display_config_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data);
static GVariant* mutter_display_config_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GError** error,
                                                                       gpointer user_data);
static GVariant* _dbus_mutter_display_config_interface_get_power_save_mode (MutterDisplayConfigInterface* self);
static gboolean mutter_display_config_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GVariant* value,
                                                                      GError** error,
                                                                      gpointer user_data);
static void _dbus_mutter_display_config_interface_set_power_save_mode (MutterDisplayConfigInterface* self,
                                                                GVariant* _value);
static void _dbus_mutter_display_config_interface_monitors_changed (GObject* _sender,
                                                             gpointer* _data);
static void _mutter_display_config_interface_unregister_object (gpointer user_data);
static gdouble* _vala_array_dup1 (gdouble* self,
                           gssize length);
static void _vala_MutterReadMonitorMode_array_free (MutterReadMonitorMode * array,
                                             gssize array_length);
static MutterReadMonitorMode* _vala_array_dup2 (MutterReadMonitorMode* self,
                                         gssize length);
static void _vala_MutterReadMonitorInfo_array_free (MutterReadMonitorInfo * array,
                                             gssize array_length);
static MutterReadMonitorInfo* _vala_array_dup3 (MutterReadMonitorInfo* self,
                                         gssize length);
static void _vala_MutterWriteMonitor_array_free (MutterWriteMonitor * array,
                                          gssize array_length);
static MutterWriteMonitor* _vala_array_dup4 (MutterWriteMonitor* self,
                                      gssize length);
static DisplayTransform* _vala_array_dup5 (DisplayTransform* self,
                                    gssize length);
static guint* _vala_array_dup6 (guint* self,
                         gssize length);
static guint* _vala_array_dup7 (guint* self,
                         gssize length);
static guint* _vala_array_dup8 (guint* self,
                         gssize length);
static guint* _vala_array_dup9 (guint* self,
                         gssize length);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_resources_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_resources_crtcs = {-1, "crtcs", "a(uxiiiiiuaua{sv})", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_resources_outputs = {-1, "outputs", "a(uxiausauaua{sv})", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_resources_modes = {-1, "modes", "a(uxuudu)", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_resources_max_screen_width = {-1, "max_screen_width", "i", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_resources_max_screen_height = {-1, "max_screen_height", "i", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_get_resources_in[] = {NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_get_resources_out[] = {&_mutter_display_config_interface_dbus_arg_info_get_resources_serial, &_mutter_display_config_interface_dbus_arg_info_get_resources_crtcs, &_mutter_display_config_interface_dbus_arg_info_get_resources_outputs, &_mutter_display_config_interface_dbus_arg_info_get_resources_modes, &_mutter_display_config_interface_dbus_arg_info_get_resources_max_screen_width, &_mutter_display_config_interface_dbus_arg_info_get_resources_max_screen_height, NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_get_resources = {-1, "GetResources", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_get_resources_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_get_resources_out), NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_configuration_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_configuration_persistent = {-1, "persistent", "b", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_configuration_crtcs = {-1, "crtcs", "a(uiiiuaua{sv})", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_configuration_outputs = {-1, "outputs", "a(ua{sv})", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_apply_configuration_in[] = {&_mutter_display_config_interface_dbus_arg_info_apply_configuration_serial, &_mutter_display_config_interface_dbus_arg_info_apply_configuration_persistent, &_mutter_display_config_interface_dbus_arg_info_apply_configuration_crtcs, &_mutter_display_config_interface_dbus_arg_info_apply_configuration_outputs, NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_apply_configuration_out[] = {NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_apply_configuration = {-1, "ApplyConfiguration", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_apply_configuration_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_apply_configuration_out), NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_change_backlight_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_change_backlight_output = {-1, "output", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_change_backlight_value = {-1, "value", "i", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_change_backlight_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_change_backlight_in[] = {&_mutter_display_config_interface_dbus_arg_info_change_backlight_serial, &_mutter_display_config_interface_dbus_arg_info_change_backlight_output, &_mutter_display_config_interface_dbus_arg_info_change_backlight_value, NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_change_backlight_out[] = {&_mutter_display_config_interface_dbus_arg_info_change_backlight_result, NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_change_backlight = {-1, "ChangeBacklight", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_change_backlight_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_change_backlight_out), NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_crtc = {-1, "crtc", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_red = {-1, "red", "au", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_green = {-1, "green", "au", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_blue = {-1, "blue", "au", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_in[] = {&_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_serial, &_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_crtc, NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_out[] = {&_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_red, &_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_green, &_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_blue, NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_get_crtc_gamma = {-1, "GetCrtcGamma", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_get_crtc_gamma_out), NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_crtc = {-1, "crtc", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_red = {-1, "red", "au", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_green = {-1, "green", "au", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_blue = {-1, "blue", "au", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_in[] = {&_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_serial, &_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_crtc, &_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_red, &_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_green, &_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_blue, NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_out[] = {NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_set_crtc_gamma = {-1, "SetCrtcGamma", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_set_crtc_gamma_out), NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_current_state_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_current_state_monitors = {-1, "monitors", "a((ssss)a(siiddada{sv})a{sv})", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_current_state_logical_monitors = {-1, "logical_monitors", "a(iiduba(ssss)a{sv})", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_get_current_state_properties = {-1, "properties", "a{sv}", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_get_current_state_in[] = {NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_get_current_state_out[] = {&_mutter_display_config_interface_dbus_arg_info_get_current_state_serial, &_mutter_display_config_interface_dbus_arg_info_get_current_state_monitors, &_mutter_display_config_interface_dbus_arg_info_get_current_state_logical_monitors, &_mutter_display_config_interface_dbus_arg_info_get_current_state_properties, NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_get_current_state = {-1, "GetCurrentState", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_get_current_state_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_get_current_state_out), NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_monitors_config_serial = {-1, "serial", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_monitors_config_method = {-1, "method", "u", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_monitors_config_logical_monitors = {-1, "logical_monitors", "a(iiduba(ssa{sv}))", NULL};
static const GDBusArgInfo _mutter_display_config_interface_dbus_arg_info_apply_monitors_config_properties = {-1, "properties", "a{sv}", NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_apply_monitors_config_in[] = {&_mutter_display_config_interface_dbus_arg_info_apply_monitors_config_serial, &_mutter_display_config_interface_dbus_arg_info_apply_monitors_config_method, &_mutter_display_config_interface_dbus_arg_info_apply_monitors_config_logical_monitors, &_mutter_display_config_interface_dbus_arg_info_apply_monitors_config_properties, NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_apply_monitors_config_out[] = {NULL};
static const GDBusMethodInfo _mutter_display_config_interface_dbus_method_info_apply_monitors_config = {-1, "ApplyMonitorsConfig", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_apply_monitors_config_in), (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_apply_monitors_config_out), NULL};
static const GDBusMethodInfo * const _mutter_display_config_interface_dbus_method_info[] = {&_mutter_display_config_interface_dbus_method_info_get_resources, &_mutter_display_config_interface_dbus_method_info_apply_configuration, &_mutter_display_config_interface_dbus_method_info_change_backlight, &_mutter_display_config_interface_dbus_method_info_get_crtc_gamma, &_mutter_display_config_interface_dbus_method_info_set_crtc_gamma, &_mutter_display_config_interface_dbus_method_info_get_current_state, &_mutter_display_config_interface_dbus_method_info_apply_monitors_config, NULL};
static const GDBusArgInfo * const _mutter_display_config_interface_dbus_arg_info_monitors_changed[] = {NULL};
static const GDBusSignalInfo _mutter_display_config_interface_dbus_signal_info_monitors_changed = {-1, "MonitorsChanged", (GDBusArgInfo **) (&_mutter_display_config_interface_dbus_arg_info_monitors_changed), NULL};
static const GDBusSignalInfo * const _mutter_display_config_interface_dbus_signal_info[] = {&_mutter_display_config_interface_dbus_signal_info_monitors_changed, NULL};
static const GDBusPropertyInfo _mutter_display_config_interface_dbus_property_info_power_save_mode = {-1, "PowerSaveMode", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _mutter_display_config_interface_dbus_property_info[] = {&_mutter_display_config_interface_dbus_property_info_power_save_mode, NULL};
static const GDBusInterfaceInfo _mutter_display_config_interface_dbus_interface_info = {-1, "org.gnome.Mutter.DisplayConfig", (GDBusMethodInfo **) (&_mutter_display_config_interface_dbus_method_info), (GDBusSignalInfo **) (&_mutter_display_config_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_mutter_display_config_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _mutter_display_config_interface_dbus_interface_vtable = {mutter_display_config_interface_dbus_interface_method_call, mutter_display_config_interface_dbus_interface_get_property, mutter_display_config_interface_dbus_interface_set_property};

void
mutter_display_config_interface_get_resources (MutterDisplayConfigInterface* self,
                                               guint* serial,
                                               MutterReadDisplayCrtc** crtcs,
                                               gint* crtcs_length1,
                                               MutterReadDisplayOutput** outputs,
                                               gint* outputs_length1,
                                               MutterReadDisplayMode** modes,
                                               gint* modes_length1,
                                               gint* max_screen_width,
                                               gint* max_screen_height,
                                               GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_resources) {
		_iface_->get_resources (self, serial, crtcs, crtcs_length1, outputs, outputs_length1, modes, modes_length1, max_screen_width, max_screen_height, error);
	}
}

void
mutter_display_config_interface_apply_configuration (MutterDisplayConfigInterface* self,
                                                     guint serial,
                                                     gboolean persistent,
                                                     MutterWriteDisplayCrtc* crtcs,
                                                     gint crtcs_length1,
                                                     MutterWriteDisplayOutput* outputs,
                                                     gint outputs_length1,
                                                     GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->apply_configuration) {
		_iface_->apply_configuration (self, serial, persistent, crtcs, crtcs_length1, outputs, outputs_length1, error);
	}
}

gint
mutter_display_config_interface_change_backlight (MutterDisplayConfigInterface* self,
                                                  guint serial,
                                                  guint output,
                                                  gint value,
                                                  GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->change_backlight) {
		return _iface_->change_backlight (self, serial, output, value, error);
	}
	return -1;
}

void
mutter_display_config_interface_get_crtc_gamma (MutterDisplayConfigInterface* self,
                                                guint serial,
                                                guint crtc,
                                                guint** red,
                                                gint* red_length1,
                                                guint** green,
                                                gint* green_length1,
                                                guint** blue,
                                                gint* blue_length1,
                                                GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_crtc_gamma) {
		_iface_->get_crtc_gamma (self, serial, crtc, red, red_length1, green, green_length1, blue, blue_length1, error);
	}
}

void
mutter_display_config_interface_set_crtc_gamma (MutterDisplayConfigInterface* self,
                                                guint serial,
                                                guint crtc,
                                                guint* red,
                                                gint red_length1,
                                                guint* green,
                                                gint green_length1,
                                                guint* blue,
                                                gint blue_length1,
                                                GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_crtc_gamma) {
		_iface_->set_crtc_gamma (self, serial, crtc, red, red_length1, green, green_length1, blue, blue_length1, error);
	}
}

void
mutter_display_config_interface_get_current_state (MutterDisplayConfigInterface* self,
                                                   guint* serial,
                                                   MutterReadMonitor** monitors,
                                                   gint* monitors_length1,
                                                   MutterReadLogicalMonitor** logical_monitors,
                                                   gint* logical_monitors_length1,
                                                   GHashTable** properties,
                                                   GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_current_state) {
		_iface_->get_current_state (self, serial, monitors, monitors_length1, logical_monitors, logical_monitors_length1, properties, error);
	}
}

void
mutter_display_config_interface_apply_monitors_config (MutterDisplayConfigInterface* self,
                                                       guint serial,
                                                       MutterApplyMethod method,
                                                       MutterWriteLogicalMonitor* logical_monitors,
                                                       gint logical_monitors_length1,
                                                       GHashTable* properties,
                                                       GError** error)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->apply_monitors_config) {
		_iface_->apply_monitors_config (self, serial, method, logical_monitors, logical_monitors_length1, properties, error);
	}
}

gint
mutter_display_config_interface_get_power_save_mode (MutterDisplayConfigInterface* self)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_power_save_mode) {
		return _iface_->get_power_save_mode (self);
	}
	return -1;
}

void
mutter_display_config_interface_set_power_save_mode (MutterDisplayConfigInterface* self,
                                                     gint value)
{
	MutterDisplayConfigInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = MUTTER_DISPLAY_CONFIG_INTERFACE_GET_INTERFACE (self);
	if (_iface_->set_power_save_mode) {
		_iface_->set_power_save_mode (self, value);
	}
}

static void
mutter_display_config_interface_default_init (MutterDisplayConfigInterfaceIface * iface,
                                              gpointer iface_data)
{
	mutter_display_config_interface_signals[MUTTER_DISPLAY_CONFIG_INTERFACE_MONITORS_CHANGED_SIGNAL] = g_signal_new ("monitors-changed", TYPE_MUTTER_DISPLAY_CONFIG_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
mutter_display_config_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MutterDisplayConfigInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mutter_display_config_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType mutter_display_config_interface_type_id;
	mutter_display_config_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "MutterDisplayConfigInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (mutter_display_config_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (mutter_display_config_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) mutter_display_config_interface_proxy_get_type);
	g_type_set_qdata (mutter_display_config_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Mutter.DisplayConfig");
	g_type_set_qdata (mutter_display_config_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_mutter_display_config_interface_dbus_interface_info));
	g_type_set_qdata (mutter_display_config_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) mutter_display_config_interface_register_object);
	return mutter_display_config_interface_type_id;
}

GType
mutter_display_config_interface_get_type (void)
{
	static volatile gsize mutter_display_config_interface_type_id__once = 0;
	if (g_once_init_enter (&mutter_display_config_interface_type_id__once)) {
		GType mutter_display_config_interface_type_id;
		mutter_display_config_interface_type_id = mutter_display_config_interface_get_type_once ();
		g_once_init_leave (&mutter_display_config_interface_type_id__once, mutter_display_config_interface_type_id);
	}
	return mutter_display_config_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (MutterDisplayConfigInterfaceProxy, mutter_display_config_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MUTTER_DISPLAY_CONFIG_INTERFACE, mutter_display_config_interface_proxy_mutter_display_config_interface_interface_init) )
static void
mutter_display_config_interface_proxy_class_init (MutterDisplayConfigInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = mutter_display_config_interface_proxy_g_signal;
}

static void
_dbus_handle_mutter_display_config_interface_monitors_changed (MutterDisplayConfigInterface* self,
                                                               GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "monitors-changed");
}

static void
mutter_display_config_interface_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters)
{
	if (strcmp (signal_name, "MonitorsChanged") == 0) {
		_dbus_handle_mutter_display_config_interface_monitors_changed ((MutterDisplayConfigInterface*) proxy, parameters);
	}
}

static void
mutter_display_config_interface_proxy_init (MutterDisplayConfigInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_mutter_display_config_interface_dbus_interface_info));
}

static void
mutter_display_config_interface_proxy_get_resources (MutterDisplayConfigInterface* self,
                                                     guint* serial,
                                                     MutterReadDisplayCrtc** crtcs,
                                                     gint* crtcs_length1,
                                                     MutterReadDisplayOutput** outputs,
                                                     gint* outputs_length1,
                                                     MutterReadDisplayMode** modes,
                                                     gint* modes_length1,
                                                     gint* max_screen_width,
                                                     gint* max_screen_height,
                                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _vala_serial = 0U;
	GVariant* _tmp19_;
	MutterReadDisplayCrtc* _vala_crtcs = NULL;
	gint _vala_crtcs_length1;
	GVariant* _tmp20_;
	MutterReadDisplayCrtc* _tmp21_;
	gint _tmp21__length;
	gint _tmp21__size;
	gint _tmp21__length1;
	GVariantIter _tmp22_;
	GVariant* _tmp23_;
	MutterReadDisplayOutput* _vala_outputs = NULL;
	gint _vala_outputs_length1;
	GVariant* _tmp43_;
	MutterReadDisplayOutput* _tmp44_;
	gint _tmp44__length;
	gint _tmp44__size;
	gint _tmp44__length1;
	GVariantIter _tmp45_;
	GVariant* _tmp46_;
	MutterReadDisplayMode* _vala_modes = NULL;
	gint _vala_modes_length1;
	GVariant* _tmp70_;
	MutterReadDisplayMode* _tmp71_;
	gint _tmp71__length;
	gint _tmp71__size;
	gint _tmp71__length1;
	GVariantIter _tmp72_;
	GVariant* _tmp73_;
	gint _vala_max_screen_width = 0;
	GVariant* _tmp82_;
	gint _vala_max_screen_height = 0;
	GVariant* _tmp83_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "GetResources");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp19_ = g_variant_iter_next_value (&_reply_iter);
	_vala_serial = g_variant_get_uint32 (_tmp19_);
	g_variant_unref (_tmp19_);
	*serial = _vala_serial;
	_vala_crtcs_length1 = 0;
	_tmp20_ = g_variant_iter_next_value (&_reply_iter);
	_tmp21_ = g_new (MutterReadDisplayCrtc, 5);
	_tmp21__length = 0;
	_tmp21__size = 4;
	_tmp21__length1 = 0;
	g_variant_iter_init (&_tmp22_, _tmp20_);
	for (; (_tmp23_ = g_variant_iter_next_value (&_tmp22_)) != NULL; _tmp21__length1++) {
		MutterReadDisplayCrtc _tmp24_;
		GVariantIter _tmp25_;
		GVariant* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		GVariant* _tmp31_;
		GVariant* _tmp32_;
		GVariant* _tmp33_;
		GVariant* _tmp34_;
		DisplayTransform* _tmp35_;
		gint _tmp35__length;
		gint _tmp35__size;
		gint _tmp35__length1;
		GVariantIter _tmp36_;
		GVariant* _tmp37_;
		GVariant* _tmp38_;
		GHashTable* _tmp39_;
		GVariantIter _tmp40_;
		GVariant* _tmp41_;
		GVariant* _tmp42_;
		if (_tmp21__size == _tmp21__length) {
			_tmp21__size = 2 * _tmp21__size;
			_tmp21_ = g_renew (MutterReadDisplayCrtc, _tmp21_, _tmp21__size + 1);
		}
		g_variant_iter_init (&_tmp25_, _tmp23_);
		_tmp26_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.id = g_variant_get_uint32 (_tmp26_);
		g_variant_unref (_tmp26_);
		_tmp27_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.winsys_id = g_variant_get_int64 (_tmp27_);
		g_variant_unref (_tmp27_);
		_tmp28_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.x = g_variant_get_int32 (_tmp28_);
		g_variant_unref (_tmp28_);
		_tmp29_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.y = g_variant_get_int32 (_tmp29_);
		g_variant_unref (_tmp29_);
		_tmp30_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.width = g_variant_get_int32 (_tmp30_);
		g_variant_unref (_tmp30_);
		_tmp31_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.height = g_variant_get_int32 (_tmp31_);
		g_variant_unref (_tmp31_);
		_tmp32_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.current_mode = g_variant_get_int32 (_tmp32_);
		g_variant_unref (_tmp32_);
		_tmp33_ = g_variant_iter_next_value (&_tmp25_);
		_tmp24_.current_transform = g_variant_get_uint32 (_tmp33_);
		g_variant_unref (_tmp33_);
		_tmp34_ = g_variant_iter_next_value (&_tmp25_);
		_tmp35_ = g_new (DisplayTransform, 5);
		_tmp35__length = 0;
		_tmp35__size = 4;
		_tmp35__length1 = 0;
		g_variant_iter_init (&_tmp36_, _tmp34_);
		for (; (_tmp37_ = g_variant_iter_next_value (&_tmp36_)) != NULL; _tmp35__length1++) {
			if (_tmp35__size == _tmp35__length) {
				_tmp35__size = 2 * _tmp35__size;
				_tmp35_ = g_renew (DisplayTransform, _tmp35_, _tmp35__size + 1);
			}
			_tmp35_[_tmp35__length++] = g_variant_get_uint32 (_tmp37_);
			g_variant_unref (_tmp37_);
		}
		_tmp24_.transforms_length1 = _tmp35__length1;
		_tmp24_.transforms = _tmp35_;
		g_variant_unref (_tmp34_);
		_tmp38_ = g_variant_iter_next_value (&_tmp25_);
		_tmp39_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp40_, _tmp38_);
		while (g_variant_iter_loop (&_tmp40_, "{?*}", &_tmp41_, &_tmp42_)) {
			g_hash_table_insert (_tmp39_, g_variant_dup_string (_tmp41_, NULL), g_variant_get_variant (_tmp42_));
		}
		_tmp24_.properties = _tmp39_;
		g_variant_unref (_tmp38_);
		_tmp21_[_tmp21__length++] = _tmp24_;
		g_variant_unref (_tmp23_);
	}
	_vala_crtcs_length1 = _tmp21__length1;
	_vala_crtcs = _tmp21_;
	g_variant_unref (_tmp20_);
	*crtcs = _vala_crtcs;
	*crtcs_length1 = _vala_crtcs_length1;
	_vala_outputs_length1 = 0;
	_tmp43_ = g_variant_iter_next_value (&_reply_iter);
	_tmp44_ = g_new (MutterReadDisplayOutput, 5);
	_tmp44__length = 0;
	_tmp44__size = 4;
	_tmp44__length1 = 0;
	g_variant_iter_init (&_tmp45_, _tmp43_);
	for (; (_tmp46_ = g_variant_iter_next_value (&_tmp45_)) != NULL; _tmp44__length1++) {
		MutterReadDisplayOutput _tmp47_;
		GVariantIter _tmp48_;
		GVariant* _tmp49_;
		GVariant* _tmp50_;
		GVariant* _tmp51_;
		GVariant* _tmp52_;
		guint* _tmp53_;
		gint _tmp53__length;
		gint _tmp53__size;
		gint _tmp53__length1;
		GVariantIter _tmp54_;
		GVariant* _tmp55_;
		GVariant* _tmp56_;
		GVariant* _tmp57_;
		guint* _tmp58_;
		gint _tmp58__length;
		gint _tmp58__size;
		gint _tmp58__length1;
		GVariantIter _tmp59_;
		GVariant* _tmp60_;
		GVariant* _tmp61_;
		guint* _tmp62_;
		gint _tmp62__length;
		gint _tmp62__size;
		gint _tmp62__length1;
		GVariantIter _tmp63_;
		GVariant* _tmp64_;
		GVariant* _tmp65_;
		GHashTable* _tmp66_;
		GVariantIter _tmp67_;
		GVariant* _tmp68_;
		GVariant* _tmp69_;
		if (_tmp44__size == _tmp44__length) {
			_tmp44__size = 2 * _tmp44__size;
			_tmp44_ = g_renew (MutterReadDisplayOutput, _tmp44_, _tmp44__size + 1);
		}
		g_variant_iter_init (&_tmp48_, _tmp46_);
		_tmp49_ = g_variant_iter_next_value (&_tmp48_);
		_tmp47_.id = g_variant_get_uint32 (_tmp49_);
		g_variant_unref (_tmp49_);
		_tmp50_ = g_variant_iter_next_value (&_tmp48_);
		_tmp47_.winsys_id = g_variant_get_int64 (_tmp50_);
		g_variant_unref (_tmp50_);
		_tmp51_ = g_variant_iter_next_value (&_tmp48_);
		_tmp47_.current_crtc = g_variant_get_int32 (_tmp51_);
		g_variant_unref (_tmp51_);
		_tmp52_ = g_variant_iter_next_value (&_tmp48_);
		_tmp53_ = g_new (guint, 5);
		_tmp53__length = 0;
		_tmp53__size = 4;
		_tmp53__length1 = 0;
		g_variant_iter_init (&_tmp54_, _tmp52_);
		for (; (_tmp55_ = g_variant_iter_next_value (&_tmp54_)) != NULL; _tmp53__length1++) {
			if (_tmp53__size == _tmp53__length) {
				_tmp53__size = 2 * _tmp53__size;
				_tmp53_ = g_renew (guint, _tmp53_, _tmp53__size + 1);
			}
			_tmp53_[_tmp53__length++] = g_variant_get_uint32 (_tmp55_);
			g_variant_unref (_tmp55_);
		}
		_tmp47_.possible_crtcs_length1 = _tmp53__length1;
		_tmp47_.possible_crtcs = _tmp53_;
		g_variant_unref (_tmp52_);
		_tmp56_ = g_variant_iter_next_value (&_tmp48_);
		_tmp47_.connector_name = g_variant_dup_string (_tmp56_, NULL);
		g_variant_unref (_tmp56_);
		_tmp57_ = g_variant_iter_next_value (&_tmp48_);
		_tmp58_ = g_new (guint, 5);
		_tmp58__length = 0;
		_tmp58__size = 4;
		_tmp58__length1 = 0;
		g_variant_iter_init (&_tmp59_, _tmp57_);
		for (; (_tmp60_ = g_variant_iter_next_value (&_tmp59_)) != NULL; _tmp58__length1++) {
			if (_tmp58__size == _tmp58__length) {
				_tmp58__size = 2 * _tmp58__size;
				_tmp58_ = g_renew (guint, _tmp58_, _tmp58__size + 1);
			}
			_tmp58_[_tmp58__length++] = g_variant_get_uint32 (_tmp60_);
			g_variant_unref (_tmp60_);
		}
		_tmp47_.modes_length1 = _tmp58__length1;
		_tmp47_.modes = _tmp58_;
		g_variant_unref (_tmp57_);
		_tmp61_ = g_variant_iter_next_value (&_tmp48_);
		_tmp62_ = g_new (guint, 5);
		_tmp62__length = 0;
		_tmp62__size = 4;
		_tmp62__length1 = 0;
		g_variant_iter_init (&_tmp63_, _tmp61_);
		for (; (_tmp64_ = g_variant_iter_next_value (&_tmp63_)) != NULL; _tmp62__length1++) {
			if (_tmp62__size == _tmp62__length) {
				_tmp62__size = 2 * _tmp62__size;
				_tmp62_ = g_renew (guint, _tmp62_, _tmp62__size + 1);
			}
			_tmp62_[_tmp62__length++] = g_variant_get_uint32 (_tmp64_);
			g_variant_unref (_tmp64_);
		}
		_tmp47_.clones_length1 = _tmp62__length1;
		_tmp47_.clones = _tmp62_;
		g_variant_unref (_tmp61_);
		_tmp65_ = g_variant_iter_next_value (&_tmp48_);
		_tmp66_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp67_, _tmp65_);
		while (g_variant_iter_loop (&_tmp67_, "{?*}", &_tmp68_, &_tmp69_)) {
			g_hash_table_insert (_tmp66_, g_variant_dup_string (_tmp68_, NULL), g_variant_get_variant (_tmp69_));
		}
		_tmp47_.properties = _tmp66_;
		g_variant_unref (_tmp65_);
		_tmp44_[_tmp44__length++] = _tmp47_;
		g_variant_unref (_tmp46_);
	}
	_vala_outputs_length1 = _tmp44__length1;
	_vala_outputs = _tmp44_;
	g_variant_unref (_tmp43_);
	*outputs = _vala_outputs;
	*outputs_length1 = _vala_outputs_length1;
	_vala_modes_length1 = 0;
	_tmp70_ = g_variant_iter_next_value (&_reply_iter);
	_tmp71_ = g_new (MutterReadDisplayMode, 5);
	_tmp71__length = 0;
	_tmp71__size = 4;
	_tmp71__length1 = 0;
	g_variant_iter_init (&_tmp72_, _tmp70_);
	for (; (_tmp73_ = g_variant_iter_next_value (&_tmp72_)) != NULL; _tmp71__length1++) {
		MutterReadDisplayMode _tmp74_;
		GVariantIter _tmp75_;
		GVariant* _tmp76_;
		GVariant* _tmp77_;
		GVariant* _tmp78_;
		GVariant* _tmp79_;
		GVariant* _tmp80_;
		GVariant* _tmp81_;
		if (_tmp71__size == _tmp71__length) {
			_tmp71__size = 2 * _tmp71__size;
			_tmp71_ = g_renew (MutterReadDisplayMode, _tmp71_, _tmp71__size + 1);
		}
		g_variant_iter_init (&_tmp75_, _tmp73_);
		_tmp76_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.id = g_variant_get_uint32 (_tmp76_);
		g_variant_unref (_tmp76_);
		_tmp77_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.winsys_id = g_variant_get_int64 (_tmp77_);
		g_variant_unref (_tmp77_);
		_tmp78_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.width = g_variant_get_uint32 (_tmp78_);
		g_variant_unref (_tmp78_);
		_tmp79_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.height = g_variant_get_uint32 (_tmp79_);
		g_variant_unref (_tmp79_);
		_tmp80_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.frequency = g_variant_get_double (_tmp80_);
		g_variant_unref (_tmp80_);
		_tmp81_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.flags = g_variant_get_uint32 (_tmp81_);
		g_variant_unref (_tmp81_);
		_tmp71_[_tmp71__length++] = _tmp74_;
		g_variant_unref (_tmp73_);
	}
	_vala_modes_length1 = _tmp71__length1;
	_vala_modes = _tmp71_;
	g_variant_unref (_tmp70_);
	*modes = _vala_modes;
	*modes_length1 = _vala_modes_length1;
	_tmp82_ = g_variant_iter_next_value (&_reply_iter);
	_vala_max_screen_width = g_variant_get_int32 (_tmp82_);
	g_variant_unref (_tmp82_);
	*max_screen_width = _vala_max_screen_width;
	_tmp83_ = g_variant_iter_next_value (&_reply_iter);
	_vala_max_screen_height = g_variant_get_int32 (_tmp83_);
	g_variant_unref (_tmp83_);
	*max_screen_height = _vala_max_screen_height;
	g_object_unref (_reply_message);
}

static void
mutter_display_config_interface_proxy_apply_configuration (MutterDisplayConfigInterface* self,
                                                           guint serial,
                                                           gboolean persistent,
                                                           MutterWriteDisplayCrtc* crtcs,
                                                           gint crtcs_length1,
                                                           MutterWriteDisplayOutput* outputs,
                                                           gint outputs_length1,
                                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	MutterWriteDisplayCrtc* _tmp84_;
	GVariantBuilder _tmp85_;
	gint _tmp86_;
	MutterWriteDisplayOutput* _tmp95_;
	GVariantBuilder _tmp96_;
	gint _tmp97_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "ApplyConfiguration");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (serial));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (persistent));
	_tmp84_ = crtcs;
	g_variant_builder_init (&_tmp85_, G_VARIANT_TYPE ("a(uiiiuaua{sv})"));
	for (_tmp86_ = 0; _tmp86_ < crtcs_length1; _tmp86_++) {
		GVariantBuilder _tmp87_;
		guint* _tmp88_;
		GVariantBuilder _tmp89_;
		gint _tmp90_;
		GVariantBuilder _tmp91_;
		GHashTableIter _tmp92_;
		gpointer _tmp93_;
		gpointer _tmp94_;
		g_variant_builder_init (&_tmp87_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp87_, g_variant_new_uint32 ((*_tmp84_).id));
		g_variant_builder_add_value (&_tmp87_, g_variant_new_int32 ((*_tmp84_).new_mode));
		g_variant_builder_add_value (&_tmp87_, g_variant_new_int32 ((*_tmp84_).x));
		g_variant_builder_add_value (&_tmp87_, g_variant_new_int32 ((*_tmp84_).y));
		g_variant_builder_add_value (&_tmp87_, g_variant_new_uint32 ((*_tmp84_).transform));
		_tmp88_ = (*_tmp84_).outputs;
		g_variant_builder_init (&_tmp89_, G_VARIANT_TYPE ("au"));
		for (_tmp90_ = 0; _tmp90_ < (*_tmp84_).outputs_length1; _tmp90_++) {
			g_variant_builder_add_value (&_tmp89_, g_variant_new_uint32 (*_tmp88_));
			_tmp88_++;
		}
		g_variant_builder_add_value (&_tmp87_, g_variant_builder_end (&_tmp89_));
		g_hash_table_iter_init (&_tmp92_, (*_tmp84_).properties);
		g_variant_builder_init (&_tmp91_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp92_, &_tmp93_, &_tmp94_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp93_;
			_value = (GVariant*) _tmp94_;
			g_variant_builder_add (&_tmp91_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp87_, g_variant_builder_end (&_tmp91_));
		g_variant_builder_add_value (&_tmp85_, g_variant_builder_end (&_tmp87_));
		_tmp84_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp85_));
	_tmp95_ = outputs;
	g_variant_builder_init (&_tmp96_, G_VARIANT_TYPE ("a(ua{sv})"));
	for (_tmp97_ = 0; _tmp97_ < outputs_length1; _tmp97_++) {
		GVariantBuilder _tmp98_;
		GVariantBuilder _tmp99_;
		GHashTableIter _tmp100_;
		gpointer _tmp101_;
		gpointer _tmp102_;
		g_variant_builder_init (&_tmp98_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp98_, g_variant_new_uint32 ((*_tmp95_).id));
		g_hash_table_iter_init (&_tmp100_, (*_tmp95_).properties);
		g_variant_builder_init (&_tmp99_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp100_, &_tmp101_, &_tmp102_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp101_;
			_value = (GVariant*) _tmp102_;
			g_variant_builder_add (&_tmp99_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp98_, g_variant_builder_end (&_tmp99_));
		g_variant_builder_add_value (&_tmp96_, g_variant_builder_end (&_tmp98_));
		_tmp95_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp96_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gint
mutter_display_config_interface_proxy_change_backlight (MutterDisplayConfigInterface* self,
                                                        guint serial,
                                                        guint output,
                                                        gint value,
                                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint _result = 0;
	GVariant* _tmp105_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "ChangeBacklight");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (serial));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (output));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gint _tmp103_ = 0;
		return _tmp103_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gint _tmp104_ = 0;
		g_object_unref (_reply_message);
		return _tmp104_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp105_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_int32 (_tmp105_);
	g_variant_unref (_tmp105_);
	g_object_unref (_reply_message);
	return _result;
}

static void
mutter_display_config_interface_proxy_get_crtc_gamma (MutterDisplayConfigInterface* self,
                                                      guint serial,
                                                      guint crtc,
                                                      guint** red,
                                                      gint* red_length1,
                                                      guint** green,
                                                      gint* green_length1,
                                                      guint** blue,
                                                      gint* blue_length1,
                                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _vala_red = NULL;
	gint _vala_red_length1;
	GVariant* _tmp106_;
	guint* _tmp107_;
	gint _tmp107__length;
	gint _tmp107__size;
	gint _tmp107__length1;
	GVariantIter _tmp108_;
	GVariant* _tmp109_;
	guint* _vala_green = NULL;
	gint _vala_green_length1;
	GVariant* _tmp110_;
	guint* _tmp111_;
	gint _tmp111__length;
	gint _tmp111__size;
	gint _tmp111__length1;
	GVariantIter _tmp112_;
	GVariant* _tmp113_;
	guint* _vala_blue = NULL;
	gint _vala_blue_length1;
	GVariant* _tmp114_;
	guint* _tmp115_;
	gint _tmp115__length;
	gint _tmp115__size;
	gint _tmp115__length1;
	GVariantIter _tmp116_;
	GVariant* _tmp117_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "GetCrtcGamma");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (serial));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (crtc));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_red_length1 = 0;
	_tmp106_ = g_variant_iter_next_value (&_reply_iter);
	_tmp107_ = g_new (guint, 5);
	_tmp107__length = 0;
	_tmp107__size = 4;
	_tmp107__length1 = 0;
	g_variant_iter_init (&_tmp108_, _tmp106_);
	for (; (_tmp109_ = g_variant_iter_next_value (&_tmp108_)) != NULL; _tmp107__length1++) {
		if (_tmp107__size == _tmp107__length) {
			_tmp107__size = 2 * _tmp107__size;
			_tmp107_ = g_renew (guint, _tmp107_, _tmp107__size + 1);
		}
		_tmp107_[_tmp107__length++] = g_variant_get_uint32 (_tmp109_);
		g_variant_unref (_tmp109_);
	}
	_vala_red_length1 = _tmp107__length1;
	_vala_red = _tmp107_;
	g_variant_unref (_tmp106_);
	*red = _vala_red;
	*red_length1 = _vala_red_length1;
	_vala_green_length1 = 0;
	_tmp110_ = g_variant_iter_next_value (&_reply_iter);
	_tmp111_ = g_new (guint, 5);
	_tmp111__length = 0;
	_tmp111__size = 4;
	_tmp111__length1 = 0;
	g_variant_iter_init (&_tmp112_, _tmp110_);
	for (; (_tmp113_ = g_variant_iter_next_value (&_tmp112_)) != NULL; _tmp111__length1++) {
		if (_tmp111__size == _tmp111__length) {
			_tmp111__size = 2 * _tmp111__size;
			_tmp111_ = g_renew (guint, _tmp111_, _tmp111__size + 1);
		}
		_tmp111_[_tmp111__length++] = g_variant_get_uint32 (_tmp113_);
		g_variant_unref (_tmp113_);
	}
	_vala_green_length1 = _tmp111__length1;
	_vala_green = _tmp111_;
	g_variant_unref (_tmp110_);
	*green = _vala_green;
	*green_length1 = _vala_green_length1;
	_vala_blue_length1 = 0;
	_tmp114_ = g_variant_iter_next_value (&_reply_iter);
	_tmp115_ = g_new (guint, 5);
	_tmp115__length = 0;
	_tmp115__size = 4;
	_tmp115__length1 = 0;
	g_variant_iter_init (&_tmp116_, _tmp114_);
	for (; (_tmp117_ = g_variant_iter_next_value (&_tmp116_)) != NULL; _tmp115__length1++) {
		if (_tmp115__size == _tmp115__length) {
			_tmp115__size = 2 * _tmp115__size;
			_tmp115_ = g_renew (guint, _tmp115_, _tmp115__size + 1);
		}
		_tmp115_[_tmp115__length++] = g_variant_get_uint32 (_tmp117_);
		g_variant_unref (_tmp117_);
	}
	_vala_blue_length1 = _tmp115__length1;
	_vala_blue = _tmp115_;
	g_variant_unref (_tmp114_);
	*blue = _vala_blue;
	*blue_length1 = _vala_blue_length1;
	g_object_unref (_reply_message);
}

static void
mutter_display_config_interface_proxy_set_crtc_gamma (MutterDisplayConfigInterface* self,
                                                      guint serial,
                                                      guint crtc,
                                                      guint* red,
                                                      gint red_length1,
                                                      guint* green,
                                                      gint green_length1,
                                                      guint* blue,
                                                      gint blue_length1,
                                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	guint* _tmp118_;
	GVariantBuilder _tmp119_;
	gint _tmp120_;
	guint* _tmp121_;
	GVariantBuilder _tmp122_;
	gint _tmp123_;
	guint* _tmp124_;
	GVariantBuilder _tmp125_;
	gint _tmp126_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "SetCrtcGamma");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (serial));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (crtc));
	_tmp118_ = red;
	g_variant_builder_init (&_tmp119_, G_VARIANT_TYPE ("au"));
	for (_tmp120_ = 0; _tmp120_ < red_length1; _tmp120_++) {
		g_variant_builder_add_value (&_tmp119_, g_variant_new_uint32 (*_tmp118_));
		_tmp118_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp119_));
	_tmp121_ = green;
	g_variant_builder_init (&_tmp122_, G_VARIANT_TYPE ("au"));
	for (_tmp123_ = 0; _tmp123_ < green_length1; _tmp123_++) {
		g_variant_builder_add_value (&_tmp122_, g_variant_new_uint32 (*_tmp121_));
		_tmp121_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp122_));
	_tmp124_ = blue;
	g_variant_builder_init (&_tmp125_, G_VARIANT_TYPE ("au"));
	for (_tmp126_ = 0; _tmp126_ < blue_length1; _tmp126_++) {
		g_variant_builder_add_value (&_tmp125_, g_variant_new_uint32 (*_tmp124_));
		_tmp124_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp125_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
mutter_display_config_interface_proxy_get_current_state (MutterDisplayConfigInterface* self,
                                                         guint* serial,
                                                         MutterReadMonitor** monitors,
                                                         gint* monitors_length1,
                                                         MutterReadLogicalMonitor** logical_monitors,
                                                         gint* logical_monitors_length1,
                                                         GHashTable** properties,
                                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _vala_serial = 0U;
	GVariant* _tmp127_;
	MutterReadMonitor* _vala_monitors = NULL;
	gint _vala_monitors_length1;
	GVariant* _tmp128_;
	MutterReadMonitor* _tmp129_;
	gint _tmp129__length;
	gint _tmp129__size;
	gint _tmp129__length1;
	GVariantIter _tmp130_;
	GVariant* _tmp131_;
	MutterReadLogicalMonitor* _vala_logical_monitors = NULL;
	gint _vala_logical_monitors_length1;
	GVariant* _tmp166_;
	MutterReadLogicalMonitor* _tmp167_;
	gint _tmp167__length;
	gint _tmp167__size;
	gint _tmp167__length1;
	GVariantIter _tmp168_;
	GVariant* _tmp169_;
	GHashTable* _vala_properties = NULL;
	GVariant* _tmp192_;
	GHashTable* _tmp193_;
	GVariantIter _tmp194_;
	GVariant* _tmp195_;
	GVariant* _tmp196_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "GetCurrentState");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp127_ = g_variant_iter_next_value (&_reply_iter);
	_vala_serial = g_variant_get_uint32 (_tmp127_);
	g_variant_unref (_tmp127_);
	*serial = _vala_serial;
	_vala_monitors_length1 = 0;
	_tmp128_ = g_variant_iter_next_value (&_reply_iter);
	_tmp129_ = g_new (MutterReadMonitor, 5);
	_tmp129__length = 0;
	_tmp129__size = 4;
	_tmp129__length1 = 0;
	g_variant_iter_init (&_tmp130_, _tmp128_);
	for (; (_tmp131_ = g_variant_iter_next_value (&_tmp130_)) != NULL; _tmp129__length1++) {
		MutterReadMonitor _tmp132_;
		GVariantIter _tmp133_;
		GVariant* _tmp134_;
		MutterReadMonitorInfo _tmp135_;
		GVariantIter _tmp136_;
		GVariant* _tmp137_;
		GVariant* _tmp138_;
		GVariant* _tmp139_;
		GVariant* _tmp140_;
		GVariant* _tmp141_;
		MutterReadMonitorMode* _tmp142_;
		gint _tmp142__length;
		gint _tmp142__size;
		gint _tmp142__length1;
		GVariantIter _tmp143_;
		GVariant* _tmp144_;
		GVariant* _tmp161_;
		GHashTable* _tmp162_;
		GVariantIter _tmp163_;
		GVariant* _tmp164_;
		GVariant* _tmp165_;
		if (_tmp129__size == _tmp129__length) {
			_tmp129__size = 2 * _tmp129__size;
			_tmp129_ = g_renew (MutterReadMonitor, _tmp129_, _tmp129__size + 1);
		}
		g_variant_iter_init (&_tmp133_, _tmp131_);
		_tmp134_ = g_variant_iter_next_value (&_tmp133_);
		g_variant_iter_init (&_tmp136_, _tmp134_);
		_tmp137_ = g_variant_iter_next_value (&_tmp136_);
		_tmp135_.connector = g_variant_dup_string (_tmp137_, NULL);
		g_variant_unref (_tmp137_);
		_tmp138_ = g_variant_iter_next_value (&_tmp136_);
		_tmp135_.vendor = g_variant_dup_string (_tmp138_, NULL);
		g_variant_unref (_tmp138_);
		_tmp139_ = g_variant_iter_next_value (&_tmp136_);
		_tmp135_.product = g_variant_dup_string (_tmp139_, NULL);
		g_variant_unref (_tmp139_);
		_tmp140_ = g_variant_iter_next_value (&_tmp136_);
		_tmp135_.serial = g_variant_dup_string (_tmp140_, NULL);
		g_variant_unref (_tmp140_);
		_tmp132_.monitor = _tmp135_;
		g_variant_unref (_tmp134_);
		_tmp141_ = g_variant_iter_next_value (&_tmp133_);
		_tmp142_ = g_new (MutterReadMonitorMode, 5);
		_tmp142__length = 0;
		_tmp142__size = 4;
		_tmp142__length1 = 0;
		g_variant_iter_init (&_tmp143_, _tmp141_);
		for (; (_tmp144_ = g_variant_iter_next_value (&_tmp143_)) != NULL; _tmp142__length1++) {
			MutterReadMonitorMode _tmp145_;
			GVariantIter _tmp146_;
			GVariant* _tmp147_;
			GVariant* _tmp148_;
			GVariant* _tmp149_;
			GVariant* _tmp150_;
			GVariant* _tmp151_;
			GVariant* _tmp152_;
			gdouble* _tmp153_;
			gint _tmp153__length;
			gint _tmp153__size;
			gint _tmp153__length1;
			GVariantIter _tmp154_;
			GVariant* _tmp155_;
			GVariant* _tmp156_;
			GHashTable* _tmp157_;
			GVariantIter _tmp158_;
			GVariant* _tmp159_;
			GVariant* _tmp160_;
			if (_tmp142__size == _tmp142__length) {
				_tmp142__size = 2 * _tmp142__size;
				_tmp142_ = g_renew (MutterReadMonitorMode, _tmp142_, _tmp142__size + 1);
			}
			g_variant_iter_init (&_tmp146_, _tmp144_);
			_tmp147_ = g_variant_iter_next_value (&_tmp146_);
			_tmp145_.id = g_variant_dup_string (_tmp147_, NULL);
			g_variant_unref (_tmp147_);
			_tmp148_ = g_variant_iter_next_value (&_tmp146_);
			_tmp145_.width = g_variant_get_int32 (_tmp148_);
			g_variant_unref (_tmp148_);
			_tmp149_ = g_variant_iter_next_value (&_tmp146_);
			_tmp145_.height = g_variant_get_int32 (_tmp149_);
			g_variant_unref (_tmp149_);
			_tmp150_ = g_variant_iter_next_value (&_tmp146_);
			_tmp145_.frequency = g_variant_get_double (_tmp150_);
			g_variant_unref (_tmp150_);
			_tmp151_ = g_variant_iter_next_value (&_tmp146_);
			_tmp145_.preferred_scale = g_variant_get_double (_tmp151_);
			g_variant_unref (_tmp151_);
			_tmp152_ = g_variant_iter_next_value (&_tmp146_);
			_tmp153_ = g_new (gdouble, 5);
			_tmp153__length = 0;
			_tmp153__size = 4;
			_tmp153__length1 = 0;
			g_variant_iter_init (&_tmp154_, _tmp152_);
			for (; (_tmp155_ = g_variant_iter_next_value (&_tmp154_)) != NULL; _tmp153__length1++) {
				if (_tmp153__size == _tmp153__length) {
					_tmp153__size = 2 * _tmp153__size;
					_tmp153_ = g_renew (gdouble, _tmp153_, _tmp153__size + 1);
				}
				_tmp153_[_tmp153__length++] = g_variant_get_double (_tmp155_);
				g_variant_unref (_tmp155_);
			}
			_tmp145_.supported_scales_length1 = _tmp153__length1;
			_tmp145_.supported_scales = _tmp153_;
			g_variant_unref (_tmp152_);
			_tmp156_ = g_variant_iter_next_value (&_tmp146_);
			_tmp157_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
			g_variant_iter_init (&_tmp158_, _tmp156_);
			while (g_variant_iter_loop (&_tmp158_, "{?*}", &_tmp159_, &_tmp160_)) {
				g_hash_table_insert (_tmp157_, g_variant_dup_string (_tmp159_, NULL), g_variant_get_variant (_tmp160_));
			}
			_tmp145_.properties = _tmp157_;
			g_variant_unref (_tmp156_);
			_tmp142_[_tmp142__length++] = _tmp145_;
			g_variant_unref (_tmp144_);
		}
		_tmp132_.modes_length1 = _tmp142__length1;
		_tmp132_.modes = _tmp142_;
		g_variant_unref (_tmp141_);
		_tmp161_ = g_variant_iter_next_value (&_tmp133_);
		_tmp162_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp163_, _tmp161_);
		while (g_variant_iter_loop (&_tmp163_, "{?*}", &_tmp164_, &_tmp165_)) {
			g_hash_table_insert (_tmp162_, g_variant_dup_string (_tmp164_, NULL), g_variant_get_variant (_tmp165_));
		}
		_tmp132_.properties = _tmp162_;
		g_variant_unref (_tmp161_);
		_tmp129_[_tmp129__length++] = _tmp132_;
		g_variant_unref (_tmp131_);
	}
	_vala_monitors_length1 = _tmp129__length1;
	_vala_monitors = _tmp129_;
	g_variant_unref (_tmp128_);
	*monitors = _vala_monitors;
	*monitors_length1 = _vala_monitors_length1;
	_vala_logical_monitors_length1 = 0;
	_tmp166_ = g_variant_iter_next_value (&_reply_iter);
	_tmp167_ = g_new (MutterReadLogicalMonitor, 5);
	_tmp167__length = 0;
	_tmp167__size = 4;
	_tmp167__length1 = 0;
	g_variant_iter_init (&_tmp168_, _tmp166_);
	for (; (_tmp169_ = g_variant_iter_next_value (&_tmp168_)) != NULL; _tmp167__length1++) {
		MutterReadLogicalMonitor _tmp170_;
		GVariantIter _tmp171_;
		GVariant* _tmp172_;
		GVariant* _tmp173_;
		GVariant* _tmp174_;
		GVariant* _tmp175_;
		GVariant* _tmp176_;
		GVariant* _tmp177_;
		MutterReadMonitorInfo* _tmp178_;
		gint _tmp178__length;
		gint _tmp178__size;
		gint _tmp178__length1;
		GVariantIter _tmp179_;
		GVariant* _tmp180_;
		GVariant* _tmp187_;
		GHashTable* _tmp188_;
		GVariantIter _tmp189_;
		GVariant* _tmp190_;
		GVariant* _tmp191_;
		if (_tmp167__size == _tmp167__length) {
			_tmp167__size = 2 * _tmp167__size;
			_tmp167_ = g_renew (MutterReadLogicalMonitor, _tmp167_, _tmp167__size + 1);
		}
		g_variant_iter_init (&_tmp171_, _tmp169_);
		_tmp172_ = g_variant_iter_next_value (&_tmp171_);
		_tmp170_.x = g_variant_get_int32 (_tmp172_);
		g_variant_unref (_tmp172_);
		_tmp173_ = g_variant_iter_next_value (&_tmp171_);
		_tmp170_.y = g_variant_get_int32 (_tmp173_);
		g_variant_unref (_tmp173_);
		_tmp174_ = g_variant_iter_next_value (&_tmp171_);
		_tmp170_.scale = g_variant_get_double (_tmp174_);
		g_variant_unref (_tmp174_);
		_tmp175_ = g_variant_iter_next_value (&_tmp171_);
		_tmp170_.transform = g_variant_get_uint32 (_tmp175_);
		g_variant_unref (_tmp175_);
		_tmp176_ = g_variant_iter_next_value (&_tmp171_);
		_tmp170_.primary = g_variant_get_boolean (_tmp176_);
		g_variant_unref (_tmp176_);
		_tmp177_ = g_variant_iter_next_value (&_tmp171_);
		_tmp178_ = g_new (MutterReadMonitorInfo, 5);
		_tmp178__length = 0;
		_tmp178__size = 4;
		_tmp178__length1 = 0;
		g_variant_iter_init (&_tmp179_, _tmp177_);
		for (; (_tmp180_ = g_variant_iter_next_value (&_tmp179_)) != NULL; _tmp178__length1++) {
			MutterReadMonitorInfo _tmp181_;
			GVariantIter _tmp182_;
			GVariant* _tmp183_;
			GVariant* _tmp184_;
			GVariant* _tmp185_;
			GVariant* _tmp186_;
			if (_tmp178__size == _tmp178__length) {
				_tmp178__size = 2 * _tmp178__size;
				_tmp178_ = g_renew (MutterReadMonitorInfo, _tmp178_, _tmp178__size + 1);
			}
			g_variant_iter_init (&_tmp182_, _tmp180_);
			_tmp183_ = g_variant_iter_next_value (&_tmp182_);
			_tmp181_.connector = g_variant_dup_string (_tmp183_, NULL);
			g_variant_unref (_tmp183_);
			_tmp184_ = g_variant_iter_next_value (&_tmp182_);
			_tmp181_.vendor = g_variant_dup_string (_tmp184_, NULL);
			g_variant_unref (_tmp184_);
			_tmp185_ = g_variant_iter_next_value (&_tmp182_);
			_tmp181_.product = g_variant_dup_string (_tmp185_, NULL);
			g_variant_unref (_tmp185_);
			_tmp186_ = g_variant_iter_next_value (&_tmp182_);
			_tmp181_.serial = g_variant_dup_string (_tmp186_, NULL);
			g_variant_unref (_tmp186_);
			_tmp178_[_tmp178__length++] = _tmp181_;
			g_variant_unref (_tmp180_);
		}
		_tmp170_.monitors_length1 = _tmp178__length1;
		_tmp170_.monitors = _tmp178_;
		g_variant_unref (_tmp177_);
		_tmp187_ = g_variant_iter_next_value (&_tmp171_);
		_tmp188_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp189_, _tmp187_);
		while (g_variant_iter_loop (&_tmp189_, "{?*}", &_tmp190_, &_tmp191_)) {
			g_hash_table_insert (_tmp188_, g_variant_dup_string (_tmp190_, NULL), g_variant_get_variant (_tmp191_));
		}
		_tmp170_.properties = _tmp188_;
		g_variant_unref (_tmp187_);
		_tmp167_[_tmp167__length++] = _tmp170_;
		g_variant_unref (_tmp169_);
	}
	_vala_logical_monitors_length1 = _tmp167__length1;
	_vala_logical_monitors = _tmp167_;
	g_variant_unref (_tmp166_);
	*logical_monitors = _vala_logical_monitors;
	*logical_monitors_length1 = _vala_logical_monitors_length1;
	_tmp192_ = g_variant_iter_next_value (&_reply_iter);
	_tmp193_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp194_, _tmp192_);
	while (g_variant_iter_loop (&_tmp194_, "{?*}", &_tmp195_, &_tmp196_)) {
		g_hash_table_insert (_tmp193_, g_variant_dup_string (_tmp195_, NULL), g_variant_get_variant (_tmp196_));
	}
	_vala_properties = _tmp193_;
	g_variant_unref (_tmp192_);
	*properties = _vala_properties;
	g_object_unref (_reply_message);
}

static void
mutter_display_config_interface_proxy_apply_monitors_config (MutterDisplayConfigInterface* self,
                                                             guint serial,
                                                             MutterApplyMethod method,
                                                             MutterWriteLogicalMonitor* logical_monitors,
                                                             gint logical_monitors_length1,
                                                             GHashTable* properties,
                                                             GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	MutterWriteLogicalMonitor* _tmp197_;
	GVariantBuilder _tmp198_;
	gint _tmp199_;
	GVariantBuilder _tmp209_;
	GHashTableIter _tmp210_;
	gpointer _tmp211_;
	gpointer _tmp212_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Mutter.DisplayConfig", "ApplyMonitorsConfig");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (serial));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (method));
	_tmp197_ = logical_monitors;
	g_variant_builder_init (&_tmp198_, G_VARIANT_TYPE ("a(iiduba(ssa{sv}))"));
	for (_tmp199_ = 0; _tmp199_ < logical_monitors_length1; _tmp199_++) {
		GVariantBuilder _tmp200_;
		MutterWriteMonitor* _tmp201_;
		GVariantBuilder _tmp202_;
		gint _tmp203_;
		g_variant_builder_init (&_tmp200_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp200_, g_variant_new_int32 ((*_tmp197_).x));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_int32 ((*_tmp197_).y));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_double ((*_tmp197_).scale));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_uint32 ((*_tmp197_).transform));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_boolean ((*_tmp197_).primary));
		_tmp201_ = (*_tmp197_).monitors;
		g_variant_builder_init (&_tmp202_, G_VARIANT_TYPE ("a(ssa{sv})"));
		for (_tmp203_ = 0; _tmp203_ < (*_tmp197_).monitors_length1; _tmp203_++) {
			GVariantBuilder _tmp204_;
			GVariantBuilder _tmp205_;
			GHashTableIter _tmp206_;
			gpointer _tmp207_;
			gpointer _tmp208_;
			g_variant_builder_init (&_tmp204_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp204_, g_variant_new_string ((*_tmp201_).connector));
			g_variant_builder_add_value (&_tmp204_, g_variant_new_string ((*_tmp201_).monitor_mode));
			g_hash_table_iter_init (&_tmp206_, (*_tmp201_).properties);
			g_variant_builder_init (&_tmp205_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp206_, &_tmp207_, &_tmp208_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp207_;
				_value = (GVariant*) _tmp208_;
				g_variant_builder_add (&_tmp205_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp204_, g_variant_builder_end (&_tmp205_));
			g_variant_builder_add_value (&_tmp202_, g_variant_builder_end (&_tmp204_));
			_tmp201_++;
		}
		g_variant_builder_add_value (&_tmp200_, g_variant_builder_end (&_tmp202_));
		g_variant_builder_add_value (&_tmp198_, g_variant_builder_end (&_tmp200_));
		_tmp197_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp198_));
	g_hash_table_iter_init (&_tmp210_, properties);
	g_variant_builder_init (&_tmp209_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp210_, &_tmp211_, &_tmp212_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp211_;
		_value = (GVariant*) _tmp212_;
		g_variant_builder_add (&_tmp209_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp209_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gint
mutter_display_config_interface_dbus_proxy_get_power_save_mode (MutterDisplayConfigInterface* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PowerSaveMode");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.Mutter.DisplayConfig"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PowerSaveMode"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp213_ = 0;
			return _tmp213_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
mutter_display_config_interface_dbus_proxy_set_power_save_mode (MutterDisplayConfigInterface* self,
                                                                gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.Mutter.DisplayConfig"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PowerSaveMode"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
mutter_display_config_interface_proxy_mutter_display_config_interface_interface_init (MutterDisplayConfigInterfaceIface* iface)
{
	iface->get_resources = mutter_display_config_interface_proxy_get_resources;
	iface->apply_configuration = mutter_display_config_interface_proxy_apply_configuration;
	iface->change_backlight = mutter_display_config_interface_proxy_change_backlight;
	iface->get_crtc_gamma = mutter_display_config_interface_proxy_get_crtc_gamma;
	iface->set_crtc_gamma = mutter_display_config_interface_proxy_set_crtc_gamma;
	iface->get_current_state = mutter_display_config_interface_proxy_get_current_state;
	iface->apply_monitors_config = mutter_display_config_interface_proxy_apply_monitors_config;
	iface->get_power_save_mode = mutter_display_config_interface_dbus_proxy_get_power_save_mode;
	iface->set_power_save_mode = mutter_display_config_interface_dbus_proxy_set_power_save_mode;
}

static void
_vala_MutterReadDisplayCrtc_array_free (MutterReadDisplayCrtc * array,
                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_display_crtc_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_MutterReadDisplayOutput_array_free (MutterReadDisplayOutput * array,
                                          gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_display_output_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_mutter_display_config_interface_get_resources (MutterDisplayConfigInterface* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint serial = 0U;
	MutterReadDisplayCrtc* crtcs = NULL;
	gint crtcs_length1 = 0;
	MutterReadDisplayCrtc* _tmp214_;
	GVariantBuilder _tmp215_;
	gint _tmp216_;
	MutterReadDisplayOutput* outputs = NULL;
	gint outputs_length1 = 0;
	MutterReadDisplayOutput* _tmp225_;
	GVariantBuilder _tmp226_;
	gint _tmp227_;
	MutterReadDisplayMode* modes = NULL;
	gint modes_length1 = 0;
	MutterReadDisplayMode* _tmp242_;
	GVariantBuilder _tmp243_;
	gint _tmp244_;
	gint max_screen_width = 0;
	gint max_screen_height = 0;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	mutter_display_config_interface_get_resources (self, &serial, &crtcs, &crtcs_length1, &outputs, &outputs_length1, &modes, &modes_length1, &max_screen_width, &max_screen_height, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (serial));
	_tmp214_ = crtcs;
	g_variant_builder_init (&_tmp215_, G_VARIANT_TYPE ("a(uxiiiiiuaua{sv})"));
	for (_tmp216_ = 0; _tmp216_ < crtcs_length1; _tmp216_++) {
		GVariantBuilder _tmp217_;
		DisplayTransform* _tmp218_;
		GVariantBuilder _tmp219_;
		gint _tmp220_;
		GVariantBuilder _tmp221_;
		GHashTableIter _tmp222_;
		gpointer _tmp223_;
		gpointer _tmp224_;
		g_variant_builder_init (&_tmp217_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp217_, g_variant_new_uint32 ((*_tmp214_).id));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_int64 ((*_tmp214_).winsys_id));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_int32 ((*_tmp214_).x));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_int32 ((*_tmp214_).y));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_int32 ((*_tmp214_).width));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_int32 ((*_tmp214_).height));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_int32 ((*_tmp214_).current_mode));
		g_variant_builder_add_value (&_tmp217_, g_variant_new_uint32 ((*_tmp214_).current_transform));
		_tmp218_ = (*_tmp214_).transforms;
		g_variant_builder_init (&_tmp219_, G_VARIANT_TYPE ("au"));
		for (_tmp220_ = 0; _tmp220_ < (*_tmp214_).transforms_length1; _tmp220_++) {
			g_variant_builder_add_value (&_tmp219_, g_variant_new_uint32 (*_tmp218_));
			_tmp218_++;
		}
		g_variant_builder_add_value (&_tmp217_, g_variant_builder_end (&_tmp219_));
		g_hash_table_iter_init (&_tmp222_, (*_tmp214_).properties);
		g_variant_builder_init (&_tmp221_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp222_, &_tmp223_, &_tmp224_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp223_;
			_value = (GVariant*) _tmp224_;
			g_variant_builder_add (&_tmp221_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp217_, g_variant_builder_end (&_tmp221_));
		g_variant_builder_add_value (&_tmp215_, g_variant_builder_end (&_tmp217_));
		_tmp214_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp215_));
	_tmp225_ = outputs;
	g_variant_builder_init (&_tmp226_, G_VARIANT_TYPE ("a(uxiausauaua{sv})"));
	for (_tmp227_ = 0; _tmp227_ < outputs_length1; _tmp227_++) {
		GVariantBuilder _tmp228_;
		guint* _tmp229_;
		GVariantBuilder _tmp230_;
		gint _tmp231_;
		guint* _tmp232_;
		GVariantBuilder _tmp233_;
		gint _tmp234_;
		guint* _tmp235_;
		GVariantBuilder _tmp236_;
		gint _tmp237_;
		GVariantBuilder _tmp238_;
		GHashTableIter _tmp239_;
		gpointer _tmp240_;
		gpointer _tmp241_;
		g_variant_builder_init (&_tmp228_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp228_, g_variant_new_uint32 ((*_tmp225_).id));
		g_variant_builder_add_value (&_tmp228_, g_variant_new_int64 ((*_tmp225_).winsys_id));
		g_variant_builder_add_value (&_tmp228_, g_variant_new_int32 ((*_tmp225_).current_crtc));
		_tmp229_ = (*_tmp225_).possible_crtcs;
		g_variant_builder_init (&_tmp230_, G_VARIANT_TYPE ("au"));
		for (_tmp231_ = 0; _tmp231_ < (*_tmp225_).possible_crtcs_length1; _tmp231_++) {
			g_variant_builder_add_value (&_tmp230_, g_variant_new_uint32 (*_tmp229_));
			_tmp229_++;
		}
		g_variant_builder_add_value (&_tmp228_, g_variant_builder_end (&_tmp230_));
		g_variant_builder_add_value (&_tmp228_, g_variant_new_string ((*_tmp225_).connector_name));
		_tmp232_ = (*_tmp225_).modes;
		g_variant_builder_init (&_tmp233_, G_VARIANT_TYPE ("au"));
		for (_tmp234_ = 0; _tmp234_ < (*_tmp225_).modes_length1; _tmp234_++) {
			g_variant_builder_add_value (&_tmp233_, g_variant_new_uint32 (*_tmp232_));
			_tmp232_++;
		}
		g_variant_builder_add_value (&_tmp228_, g_variant_builder_end (&_tmp233_));
		_tmp235_ = (*_tmp225_).clones;
		g_variant_builder_init (&_tmp236_, G_VARIANT_TYPE ("au"));
		for (_tmp237_ = 0; _tmp237_ < (*_tmp225_).clones_length1; _tmp237_++) {
			g_variant_builder_add_value (&_tmp236_, g_variant_new_uint32 (*_tmp235_));
			_tmp235_++;
		}
		g_variant_builder_add_value (&_tmp228_, g_variant_builder_end (&_tmp236_));
		g_hash_table_iter_init (&_tmp239_, (*_tmp225_).properties);
		g_variant_builder_init (&_tmp238_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp239_, &_tmp240_, &_tmp241_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp240_;
			_value = (GVariant*) _tmp241_;
			g_variant_builder_add (&_tmp238_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp228_, g_variant_builder_end (&_tmp238_));
		g_variant_builder_add_value (&_tmp226_, g_variant_builder_end (&_tmp228_));
		_tmp225_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp226_));
	_tmp242_ = modes;
	g_variant_builder_init (&_tmp243_, G_VARIANT_TYPE ("a(uxuudu)"));
	for (_tmp244_ = 0; _tmp244_ < modes_length1; _tmp244_++) {
		GVariantBuilder _tmp245_;
		g_variant_builder_init (&_tmp245_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp245_, g_variant_new_uint32 ((*_tmp242_).id));
		g_variant_builder_add_value (&_tmp245_, g_variant_new_int64 ((*_tmp242_).winsys_id));
		g_variant_builder_add_value (&_tmp245_, g_variant_new_uint32 ((*_tmp242_).width));
		g_variant_builder_add_value (&_tmp245_, g_variant_new_uint32 ((*_tmp242_).height));
		g_variant_builder_add_value (&_tmp245_, g_variant_new_double ((*_tmp242_).frequency));
		g_variant_builder_add_value (&_tmp245_, g_variant_new_uint32 ((*_tmp242_).flags));
		g_variant_builder_add_value (&_tmp243_, g_variant_builder_end (&_tmp245_));
		_tmp242_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp243_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (max_screen_width));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (max_screen_height));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	crtcs = (_vala_MutterReadDisplayCrtc_array_free (crtcs, crtcs_length1), NULL);
	outputs = (_vala_MutterReadDisplayOutput_array_free (outputs, outputs_length1), NULL);
	modes = (g_free (modes), NULL);
}

static void
_vala_MutterWriteDisplayCrtc_array_free (MutterWriteDisplayCrtc * array,
                                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_write_display_crtc_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_MutterWriteDisplayOutput_array_free (MutterWriteDisplayOutput * array,
                                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_write_display_output_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_mutter_display_config_interface_apply_configuration (MutterDisplayConfigInterface* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint serial = 0U;
	GVariant* _tmp246_;
	gboolean persistent = FALSE;
	GVariant* _tmp247_;
	MutterWriteDisplayCrtc* crtcs = NULL;
	gint crtcs_length1 = 0;
	GVariant* _tmp248_;
	MutterWriteDisplayCrtc* _tmp249_;
	gint _tmp249__length;
	gint _tmp249__size;
	gint _tmp249__length1;
	GVariantIter _tmp250_;
	GVariant* _tmp251_;
	MutterWriteDisplayOutput* outputs = NULL;
	gint outputs_length1 = 0;
	GVariant* _tmp268_;
	MutterWriteDisplayOutput* _tmp269_;
	gint _tmp269__length;
	gint _tmp269__size;
	gint _tmp269__length1;
	GVariantIter _tmp270_;
	GVariant* _tmp271_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp246_ = g_variant_iter_next_value (&_arguments_iter);
	serial = g_variant_get_uint32 (_tmp246_);
	g_variant_unref (_tmp246_);
	_tmp247_ = g_variant_iter_next_value (&_arguments_iter);
	persistent = g_variant_get_boolean (_tmp247_);
	g_variant_unref (_tmp247_);
	_tmp248_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp249_ = g_new (MutterWriteDisplayCrtc, 5);
	_tmp249__length = 0;
	_tmp249__size = 4;
	_tmp249__length1 = 0;
	g_variant_iter_init (&_tmp250_, _tmp248_);
	for (; (_tmp251_ = g_variant_iter_next_value (&_tmp250_)) != NULL; _tmp249__length1++) {
		MutterWriteDisplayCrtc _tmp252_;
		GVariantIter _tmp253_;
		GVariant* _tmp254_;
		GVariant* _tmp255_;
		GVariant* _tmp256_;
		GVariant* _tmp257_;
		GVariant* _tmp258_;
		GVariant* _tmp259_;
		guint* _tmp260_;
		gint _tmp260__length;
		gint _tmp260__size;
		gint _tmp260__length1;
		GVariantIter _tmp261_;
		GVariant* _tmp262_;
		GVariant* _tmp263_;
		GHashTable* _tmp264_;
		GVariantIter _tmp265_;
		GVariant* _tmp266_;
		GVariant* _tmp267_;
		if (_tmp249__size == _tmp249__length) {
			_tmp249__size = 2 * _tmp249__size;
			_tmp249_ = g_renew (MutterWriteDisplayCrtc, _tmp249_, _tmp249__size + 1);
		}
		g_variant_iter_init (&_tmp253_, _tmp251_);
		_tmp254_ = g_variant_iter_next_value (&_tmp253_);
		_tmp252_.id = g_variant_get_uint32 (_tmp254_);
		g_variant_unref (_tmp254_);
		_tmp255_ = g_variant_iter_next_value (&_tmp253_);
		_tmp252_.new_mode = g_variant_get_int32 (_tmp255_);
		g_variant_unref (_tmp255_);
		_tmp256_ = g_variant_iter_next_value (&_tmp253_);
		_tmp252_.x = g_variant_get_int32 (_tmp256_);
		g_variant_unref (_tmp256_);
		_tmp257_ = g_variant_iter_next_value (&_tmp253_);
		_tmp252_.y = g_variant_get_int32 (_tmp257_);
		g_variant_unref (_tmp257_);
		_tmp258_ = g_variant_iter_next_value (&_tmp253_);
		_tmp252_.transform = g_variant_get_uint32 (_tmp258_);
		g_variant_unref (_tmp258_);
		_tmp259_ = g_variant_iter_next_value (&_tmp253_);
		_tmp260_ = g_new (guint, 5);
		_tmp260__length = 0;
		_tmp260__size = 4;
		_tmp260__length1 = 0;
		g_variant_iter_init (&_tmp261_, _tmp259_);
		for (; (_tmp262_ = g_variant_iter_next_value (&_tmp261_)) != NULL; _tmp260__length1++) {
			if (_tmp260__size == _tmp260__length) {
				_tmp260__size = 2 * _tmp260__size;
				_tmp260_ = g_renew (guint, _tmp260_, _tmp260__size + 1);
			}
			_tmp260_[_tmp260__length++] = g_variant_get_uint32 (_tmp262_);
			g_variant_unref (_tmp262_);
		}
		_tmp252_.outputs_length1 = _tmp260__length1;
		_tmp252_.outputs = _tmp260_;
		g_variant_unref (_tmp259_);
		_tmp263_ = g_variant_iter_next_value (&_tmp253_);
		_tmp264_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp265_, _tmp263_);
		while (g_variant_iter_loop (&_tmp265_, "{?*}", &_tmp266_, &_tmp267_)) {
			g_hash_table_insert (_tmp264_, g_variant_dup_string (_tmp266_, NULL), g_variant_get_variant (_tmp267_));
		}
		_tmp252_.properties = _tmp264_;
		g_variant_unref (_tmp263_);
		_tmp249_[_tmp249__length++] = _tmp252_;
		g_variant_unref (_tmp251_);
	}
	crtcs_length1 = _tmp249__length1;
	crtcs = _tmp249_;
	g_variant_unref (_tmp248_);
	_tmp268_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp269_ = g_new (MutterWriteDisplayOutput, 5);
	_tmp269__length = 0;
	_tmp269__size = 4;
	_tmp269__length1 = 0;
	g_variant_iter_init (&_tmp270_, _tmp268_);
	for (; (_tmp271_ = g_variant_iter_next_value (&_tmp270_)) != NULL; _tmp269__length1++) {
		MutterWriteDisplayOutput _tmp272_;
		GVariantIter _tmp273_;
		GVariant* _tmp274_;
		GVariant* _tmp275_;
		GHashTable* _tmp276_;
		GVariantIter _tmp277_;
		GVariant* _tmp278_;
		GVariant* _tmp279_;
		if (_tmp269__size == _tmp269__length) {
			_tmp269__size = 2 * _tmp269__size;
			_tmp269_ = g_renew (MutterWriteDisplayOutput, _tmp269_, _tmp269__size + 1);
		}
		g_variant_iter_init (&_tmp273_, _tmp271_);
		_tmp274_ = g_variant_iter_next_value (&_tmp273_);
		_tmp272_.id = g_variant_get_uint32 (_tmp274_);
		g_variant_unref (_tmp274_);
		_tmp275_ = g_variant_iter_next_value (&_tmp273_);
		_tmp276_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp277_, _tmp275_);
		while (g_variant_iter_loop (&_tmp277_, "{?*}", &_tmp278_, &_tmp279_)) {
			g_hash_table_insert (_tmp276_, g_variant_dup_string (_tmp278_, NULL), g_variant_get_variant (_tmp279_));
		}
		_tmp272_.properties = _tmp276_;
		g_variant_unref (_tmp275_);
		_tmp269_[_tmp269__length++] = _tmp272_;
		g_variant_unref (_tmp271_);
	}
	outputs_length1 = _tmp269__length1;
	outputs = _tmp269_;
	g_variant_unref (_tmp268_);
	mutter_display_config_interface_apply_configuration (self, serial, persistent, crtcs, crtcs_length1, outputs, outputs_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	crtcs = (_vala_MutterWriteDisplayCrtc_array_free (crtcs, crtcs_length1), NULL);
	outputs = (_vala_MutterWriteDisplayOutput_array_free (outputs, outputs_length1), NULL);
	;
}

static void
_dbus_mutter_display_config_interface_change_backlight (MutterDisplayConfigInterface* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint serial = 0U;
	GVariant* _tmp280_;
	guint output = 0U;
	GVariant* _tmp281_;
	gint value = 0;
	GVariant* _tmp282_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp280_ = g_variant_iter_next_value (&_arguments_iter);
	serial = g_variant_get_uint32 (_tmp280_);
	g_variant_unref (_tmp280_);
	_tmp281_ = g_variant_iter_next_value (&_arguments_iter);
	output = g_variant_get_uint32 (_tmp281_);
	g_variant_unref (_tmp281_);
	_tmp282_ = g_variant_iter_next_value (&_arguments_iter);
	value = g_variant_get_int32 (_tmp282_);
	g_variant_unref (_tmp282_);
	result = mutter_display_config_interface_change_backlight (self, serial, output, value, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_mutter_display_config_interface_get_crtc_gamma (MutterDisplayConfigInterface* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint serial = 0U;
	GVariant* _tmp283_;
	guint crtc = 0U;
	GVariant* _tmp284_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* red = NULL;
	gint red_length1 = 0;
	guint* _tmp285_;
	GVariantBuilder _tmp286_;
	gint _tmp287_;
	guint* green = NULL;
	gint green_length1 = 0;
	guint* _tmp288_;
	GVariantBuilder _tmp289_;
	gint _tmp290_;
	guint* blue = NULL;
	gint blue_length1 = 0;
	guint* _tmp291_;
	GVariantBuilder _tmp292_;
	gint _tmp293_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp283_ = g_variant_iter_next_value (&_arguments_iter);
	serial = g_variant_get_uint32 (_tmp283_);
	g_variant_unref (_tmp283_);
	_tmp284_ = g_variant_iter_next_value (&_arguments_iter);
	crtc = g_variant_get_uint32 (_tmp284_);
	g_variant_unref (_tmp284_);
	mutter_display_config_interface_get_crtc_gamma (self, serial, crtc, &red, &red_length1, &green, &green_length1, &blue, &blue_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp285_ = red;
	g_variant_builder_init (&_tmp286_, G_VARIANT_TYPE ("au"));
	for (_tmp287_ = 0; _tmp287_ < red_length1; _tmp287_++) {
		g_variant_builder_add_value (&_tmp286_, g_variant_new_uint32 (*_tmp285_));
		_tmp285_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp286_));
	_tmp288_ = green;
	g_variant_builder_init (&_tmp289_, G_VARIANT_TYPE ("au"));
	for (_tmp290_ = 0; _tmp290_ < green_length1; _tmp290_++) {
		g_variant_builder_add_value (&_tmp289_, g_variant_new_uint32 (*_tmp288_));
		_tmp288_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp289_));
	_tmp291_ = blue;
	g_variant_builder_init (&_tmp292_, G_VARIANT_TYPE ("au"));
	for (_tmp293_ = 0; _tmp293_ < blue_length1; _tmp293_++) {
		g_variant_builder_add_value (&_tmp292_, g_variant_new_uint32 (*_tmp291_));
		_tmp291_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp292_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	red = (g_free (red), NULL);
	green = (g_free (green), NULL);
	blue = (g_free (blue), NULL);
}

static void
_dbus_mutter_display_config_interface_set_crtc_gamma (MutterDisplayConfigInterface* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint serial = 0U;
	GVariant* _tmp294_;
	guint crtc = 0U;
	GVariant* _tmp295_;
	guint* red = NULL;
	gint red_length1 = 0;
	GVariant* _tmp296_;
	guint* _tmp297_;
	gint _tmp297__length;
	gint _tmp297__size;
	gint _tmp297__length1;
	GVariantIter _tmp298_;
	GVariant* _tmp299_;
	guint* green = NULL;
	gint green_length1 = 0;
	GVariant* _tmp300_;
	guint* _tmp301_;
	gint _tmp301__length;
	gint _tmp301__size;
	gint _tmp301__length1;
	GVariantIter _tmp302_;
	GVariant* _tmp303_;
	guint* blue = NULL;
	gint blue_length1 = 0;
	GVariant* _tmp304_;
	guint* _tmp305_;
	gint _tmp305__length;
	gint _tmp305__size;
	gint _tmp305__length1;
	GVariantIter _tmp306_;
	GVariant* _tmp307_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp294_ = g_variant_iter_next_value (&_arguments_iter);
	serial = g_variant_get_uint32 (_tmp294_);
	g_variant_unref (_tmp294_);
	_tmp295_ = g_variant_iter_next_value (&_arguments_iter);
	crtc = g_variant_get_uint32 (_tmp295_);
	g_variant_unref (_tmp295_);
	_tmp296_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp297_ = g_new (guint, 5);
	_tmp297__length = 0;
	_tmp297__size = 4;
	_tmp297__length1 = 0;
	g_variant_iter_init (&_tmp298_, _tmp296_);
	for (; (_tmp299_ = g_variant_iter_next_value (&_tmp298_)) != NULL; _tmp297__length1++) {
		if (_tmp297__size == _tmp297__length) {
			_tmp297__size = 2 * _tmp297__size;
			_tmp297_ = g_renew (guint, _tmp297_, _tmp297__size + 1);
		}
		_tmp297_[_tmp297__length++] = g_variant_get_uint32 (_tmp299_);
		g_variant_unref (_tmp299_);
	}
	red_length1 = _tmp297__length1;
	red = _tmp297_;
	g_variant_unref (_tmp296_);
	_tmp300_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp301_ = g_new (guint, 5);
	_tmp301__length = 0;
	_tmp301__size = 4;
	_tmp301__length1 = 0;
	g_variant_iter_init (&_tmp302_, _tmp300_);
	for (; (_tmp303_ = g_variant_iter_next_value (&_tmp302_)) != NULL; _tmp301__length1++) {
		if (_tmp301__size == _tmp301__length) {
			_tmp301__size = 2 * _tmp301__size;
			_tmp301_ = g_renew (guint, _tmp301_, _tmp301__size + 1);
		}
		_tmp301_[_tmp301__length++] = g_variant_get_uint32 (_tmp303_);
		g_variant_unref (_tmp303_);
	}
	green_length1 = _tmp301__length1;
	green = _tmp301_;
	g_variant_unref (_tmp300_);
	_tmp304_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp305_ = g_new (guint, 5);
	_tmp305__length = 0;
	_tmp305__size = 4;
	_tmp305__length1 = 0;
	g_variant_iter_init (&_tmp306_, _tmp304_);
	for (; (_tmp307_ = g_variant_iter_next_value (&_tmp306_)) != NULL; _tmp305__length1++) {
		if (_tmp305__size == _tmp305__length) {
			_tmp305__size = 2 * _tmp305__size;
			_tmp305_ = g_renew (guint, _tmp305_, _tmp305__size + 1);
		}
		_tmp305_[_tmp305__length++] = g_variant_get_uint32 (_tmp307_);
		g_variant_unref (_tmp307_);
	}
	blue_length1 = _tmp305__length1;
	blue = _tmp305_;
	g_variant_unref (_tmp304_);
	mutter_display_config_interface_set_crtc_gamma (self, serial, crtc, red, red_length1, green, green_length1, blue, blue_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	red = (g_free (red), NULL);
	green = (g_free (green), NULL);
	blue = (g_free (blue), NULL);
	;
}

static void
_vala_MutterReadMonitor_array_free (MutterReadMonitor * array,
                                    gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_vala_MutterReadLogicalMonitor_array_free (MutterReadLogicalMonitor * array,
                                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_logical_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_mutter_display_config_interface_get_current_state (MutterDisplayConfigInterface* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint serial = 0U;
	MutterReadMonitor* monitors = NULL;
	gint monitors_length1 = 0;
	MutterReadMonitor* _tmp308_;
	GVariantBuilder _tmp309_;
	gint _tmp310_;
	MutterReadLogicalMonitor* logical_monitors = NULL;
	gint logical_monitors_length1 = 0;
	MutterReadLogicalMonitor* _tmp328_;
	GVariantBuilder _tmp329_;
	gint _tmp330_;
	GHashTable* properties = NULL;
	GVariantBuilder _tmp340_;
	GHashTableIter _tmp341_;
	gpointer _tmp342_;
	gpointer _tmp343_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	mutter_display_config_interface_get_current_state (self, &serial, &monitors, &monitors_length1, &logical_monitors, &logical_monitors_length1, &properties, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (serial));
	_tmp308_ = monitors;
	g_variant_builder_init (&_tmp309_, G_VARIANT_TYPE ("a((ssss)a(siiddada{sv})a{sv})"));
	for (_tmp310_ = 0; _tmp310_ < monitors_length1; _tmp310_++) {
		GVariantBuilder _tmp311_;
		GVariantBuilder _tmp312_;
		MutterReadMonitorMode* _tmp313_;
		GVariantBuilder _tmp314_;
		gint _tmp315_;
		GVariantBuilder _tmp324_;
		GHashTableIter _tmp325_;
		gpointer _tmp326_;
		gpointer _tmp327_;
		g_variant_builder_init (&_tmp311_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_init (&_tmp312_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp312_, g_variant_new_string ((*_tmp308_).monitor.connector));
		g_variant_builder_add_value (&_tmp312_, g_variant_new_string ((*_tmp308_).monitor.vendor));
		g_variant_builder_add_value (&_tmp312_, g_variant_new_string ((*_tmp308_).monitor.product));
		g_variant_builder_add_value (&_tmp312_, g_variant_new_string ((*_tmp308_).monitor.serial));
		g_variant_builder_add_value (&_tmp311_, g_variant_builder_end (&_tmp312_));
		_tmp313_ = (*_tmp308_).modes;
		g_variant_builder_init (&_tmp314_, G_VARIANT_TYPE ("a(siiddada{sv})"));
		for (_tmp315_ = 0; _tmp315_ < (*_tmp308_).modes_length1; _tmp315_++) {
			GVariantBuilder _tmp316_;
			gdouble* _tmp317_;
			GVariantBuilder _tmp318_;
			gint _tmp319_;
			GVariantBuilder _tmp320_;
			GHashTableIter _tmp321_;
			gpointer _tmp322_;
			gpointer _tmp323_;
			g_variant_builder_init (&_tmp316_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp316_, g_variant_new_string ((*_tmp313_).id));
			g_variant_builder_add_value (&_tmp316_, g_variant_new_int32 ((*_tmp313_).width));
			g_variant_builder_add_value (&_tmp316_, g_variant_new_int32 ((*_tmp313_).height));
			g_variant_builder_add_value (&_tmp316_, g_variant_new_double ((*_tmp313_).frequency));
			g_variant_builder_add_value (&_tmp316_, g_variant_new_double ((*_tmp313_).preferred_scale));
			_tmp317_ = (*_tmp313_).supported_scales;
			g_variant_builder_init (&_tmp318_, G_VARIANT_TYPE ("ad"));
			for (_tmp319_ = 0; _tmp319_ < (*_tmp313_).supported_scales_length1; _tmp319_++) {
				g_variant_builder_add_value (&_tmp318_, g_variant_new_double (*_tmp317_));
				_tmp317_++;
			}
			g_variant_builder_add_value (&_tmp316_, g_variant_builder_end (&_tmp318_));
			g_hash_table_iter_init (&_tmp321_, (*_tmp313_).properties);
			g_variant_builder_init (&_tmp320_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp321_, &_tmp322_, &_tmp323_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp322_;
				_value = (GVariant*) _tmp323_;
				g_variant_builder_add (&_tmp320_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp316_, g_variant_builder_end (&_tmp320_));
			g_variant_builder_add_value (&_tmp314_, g_variant_builder_end (&_tmp316_));
			_tmp313_++;
		}
		g_variant_builder_add_value (&_tmp311_, g_variant_builder_end (&_tmp314_));
		g_hash_table_iter_init (&_tmp325_, (*_tmp308_).properties);
		g_variant_builder_init (&_tmp324_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp325_, &_tmp326_, &_tmp327_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp326_;
			_value = (GVariant*) _tmp327_;
			g_variant_builder_add (&_tmp324_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp311_, g_variant_builder_end (&_tmp324_));
		g_variant_builder_add_value (&_tmp309_, g_variant_builder_end (&_tmp311_));
		_tmp308_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp309_));
	_tmp328_ = logical_monitors;
	g_variant_builder_init (&_tmp329_, G_VARIANT_TYPE ("a(iiduba(ssss)a{sv})"));
	for (_tmp330_ = 0; _tmp330_ < logical_monitors_length1; _tmp330_++) {
		GVariantBuilder _tmp331_;
		MutterReadMonitorInfo* _tmp332_;
		GVariantBuilder _tmp333_;
		gint _tmp334_;
		GVariantBuilder _tmp336_;
		GHashTableIter _tmp337_;
		gpointer _tmp338_;
		gpointer _tmp339_;
		g_variant_builder_init (&_tmp331_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp331_, g_variant_new_int32 ((*_tmp328_).x));
		g_variant_builder_add_value (&_tmp331_, g_variant_new_int32 ((*_tmp328_).y));
		g_variant_builder_add_value (&_tmp331_, g_variant_new_double ((*_tmp328_).scale));
		g_variant_builder_add_value (&_tmp331_, g_variant_new_uint32 ((*_tmp328_).transform));
		g_variant_builder_add_value (&_tmp331_, g_variant_new_boolean ((*_tmp328_).primary));
		_tmp332_ = (*_tmp328_).monitors;
		g_variant_builder_init (&_tmp333_, G_VARIANT_TYPE ("a(ssss)"));
		for (_tmp334_ = 0; _tmp334_ < (*_tmp328_).monitors_length1; _tmp334_++) {
			GVariantBuilder _tmp335_;
			g_variant_builder_init (&_tmp335_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp335_, g_variant_new_string ((*_tmp332_).connector));
			g_variant_builder_add_value (&_tmp335_, g_variant_new_string ((*_tmp332_).vendor));
			g_variant_builder_add_value (&_tmp335_, g_variant_new_string ((*_tmp332_).product));
			g_variant_builder_add_value (&_tmp335_, g_variant_new_string ((*_tmp332_).serial));
			g_variant_builder_add_value (&_tmp333_, g_variant_builder_end (&_tmp335_));
			_tmp332_++;
		}
		g_variant_builder_add_value (&_tmp331_, g_variant_builder_end (&_tmp333_));
		g_hash_table_iter_init (&_tmp337_, (*_tmp328_).properties);
		g_variant_builder_init (&_tmp336_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp337_, &_tmp338_, &_tmp339_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp338_;
			_value = (GVariant*) _tmp339_;
			g_variant_builder_add (&_tmp336_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp331_, g_variant_builder_end (&_tmp336_));
		g_variant_builder_add_value (&_tmp329_, g_variant_builder_end (&_tmp331_));
		_tmp328_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp329_));
	g_hash_table_iter_init (&_tmp341_, properties);
	g_variant_builder_init (&_tmp340_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp341_, &_tmp342_, &_tmp343_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp342_;
		_value = (GVariant*) _tmp343_;
		g_variant_builder_add (&_tmp340_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp340_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	monitors = (_vala_MutterReadMonitor_array_free (monitors, monitors_length1), NULL);
	logical_monitors = (_vala_MutterReadLogicalMonitor_array_free (logical_monitors, logical_monitors_length1), NULL);
	_g_hash_table_unref0 (properties);
}

static void
_vala_MutterWriteLogicalMonitor_array_free (MutterWriteLogicalMonitor * array,
                                            gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_write_logical_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_mutter_display_config_interface_apply_monitors_config (MutterDisplayConfigInterface* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint serial = 0U;
	GVariant* _tmp344_;
	MutterApplyMethod method = 0;
	GVariant* _tmp345_;
	MutterWriteLogicalMonitor* logical_monitors = NULL;
	gint logical_monitors_length1 = 0;
	GVariant* _tmp346_;
	MutterWriteLogicalMonitor* _tmp347_;
	gint _tmp347__length;
	gint _tmp347__size;
	gint _tmp347__length1;
	GVariantIter _tmp348_;
	GVariant* _tmp349_;
	GHashTable* properties = NULL;
	GVariant* _tmp370_;
	GHashTable* _tmp371_;
	GVariantIter _tmp372_;
	GVariant* _tmp373_;
	GVariant* _tmp374_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp344_ = g_variant_iter_next_value (&_arguments_iter);
	serial = g_variant_get_uint32 (_tmp344_);
	g_variant_unref (_tmp344_);
	_tmp345_ = g_variant_iter_next_value (&_arguments_iter);
	method = g_variant_get_uint32 (_tmp345_);
	g_variant_unref (_tmp345_);
	_tmp346_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp347_ = g_new (MutterWriteLogicalMonitor, 5);
	_tmp347__length = 0;
	_tmp347__size = 4;
	_tmp347__length1 = 0;
	g_variant_iter_init (&_tmp348_, _tmp346_);
	for (; (_tmp349_ = g_variant_iter_next_value (&_tmp348_)) != NULL; _tmp347__length1++) {
		MutterWriteLogicalMonitor _tmp350_;
		GVariantIter _tmp351_;
		GVariant* _tmp352_;
		GVariant* _tmp353_;
		GVariant* _tmp354_;
		GVariant* _tmp355_;
		GVariant* _tmp356_;
		GVariant* _tmp357_;
		MutterWriteMonitor* _tmp358_;
		gint _tmp358__length;
		gint _tmp358__size;
		gint _tmp358__length1;
		GVariantIter _tmp359_;
		GVariant* _tmp360_;
		if (_tmp347__size == _tmp347__length) {
			_tmp347__size = 2 * _tmp347__size;
			_tmp347_ = g_renew (MutterWriteLogicalMonitor, _tmp347_, _tmp347__size + 1);
		}
		g_variant_iter_init (&_tmp351_, _tmp349_);
		_tmp352_ = g_variant_iter_next_value (&_tmp351_);
		_tmp350_.x = g_variant_get_int32 (_tmp352_);
		g_variant_unref (_tmp352_);
		_tmp353_ = g_variant_iter_next_value (&_tmp351_);
		_tmp350_.y = g_variant_get_int32 (_tmp353_);
		g_variant_unref (_tmp353_);
		_tmp354_ = g_variant_iter_next_value (&_tmp351_);
		_tmp350_.scale = g_variant_get_double (_tmp354_);
		g_variant_unref (_tmp354_);
		_tmp355_ = g_variant_iter_next_value (&_tmp351_);
		_tmp350_.transform = g_variant_get_uint32 (_tmp355_);
		g_variant_unref (_tmp355_);
		_tmp356_ = g_variant_iter_next_value (&_tmp351_);
		_tmp350_.primary = g_variant_get_boolean (_tmp356_);
		g_variant_unref (_tmp356_);
		_tmp357_ = g_variant_iter_next_value (&_tmp351_);
		_tmp358_ = g_new (MutterWriteMonitor, 5);
		_tmp358__length = 0;
		_tmp358__size = 4;
		_tmp358__length1 = 0;
		g_variant_iter_init (&_tmp359_, _tmp357_);
		for (; (_tmp360_ = g_variant_iter_next_value (&_tmp359_)) != NULL; _tmp358__length1++) {
			MutterWriteMonitor _tmp361_;
			GVariantIter _tmp362_;
			GVariant* _tmp363_;
			GVariant* _tmp364_;
			GVariant* _tmp365_;
			GHashTable* _tmp366_;
			GVariantIter _tmp367_;
			GVariant* _tmp368_;
			GVariant* _tmp369_;
			if (_tmp358__size == _tmp358__length) {
				_tmp358__size = 2 * _tmp358__size;
				_tmp358_ = g_renew (MutterWriteMonitor, _tmp358_, _tmp358__size + 1);
			}
			g_variant_iter_init (&_tmp362_, _tmp360_);
			_tmp363_ = g_variant_iter_next_value (&_tmp362_);
			_tmp361_.connector = g_variant_dup_string (_tmp363_, NULL);
			g_variant_unref (_tmp363_);
			_tmp364_ = g_variant_iter_next_value (&_tmp362_);
			_tmp361_.monitor_mode = g_variant_dup_string (_tmp364_, NULL);
			g_variant_unref (_tmp364_);
			_tmp365_ = g_variant_iter_next_value (&_tmp362_);
			_tmp366_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
			g_variant_iter_init (&_tmp367_, _tmp365_);
			while (g_variant_iter_loop (&_tmp367_, "{?*}", &_tmp368_, &_tmp369_)) {
				g_hash_table_insert (_tmp366_, g_variant_dup_string (_tmp368_, NULL), g_variant_get_variant (_tmp369_));
			}
			_tmp361_.properties = _tmp366_;
			g_variant_unref (_tmp365_);
			_tmp358_[_tmp358__length++] = _tmp361_;
			g_variant_unref (_tmp360_);
		}
		_tmp350_.monitors_length1 = _tmp358__length1;
		_tmp350_.monitors = _tmp358_;
		g_variant_unref (_tmp357_);
		_tmp347_[_tmp347__length++] = _tmp350_;
		g_variant_unref (_tmp349_);
	}
	logical_monitors_length1 = _tmp347__length1;
	logical_monitors = _tmp347_;
	g_variant_unref (_tmp346_);
	_tmp370_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp371_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp372_, _tmp370_);
	while (g_variant_iter_loop (&_tmp372_, "{?*}", &_tmp373_, &_tmp374_)) {
		g_hash_table_insert (_tmp371_, g_variant_dup_string (_tmp373_, NULL), g_variant_get_variant (_tmp374_));
	}
	properties = _tmp371_;
	g_variant_unref (_tmp370_);
	mutter_display_config_interface_apply_monitors_config (self, serial, method, logical_monitors, logical_monitors_length1, properties, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	logical_monitors = (_vala_MutterWriteLogicalMonitor_array_free (logical_monitors, logical_monitors_length1), NULL);
	_g_hash_table_unref0 (properties);
	;
}

static void
mutter_display_config_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetResources") == 0) {
		_dbus_mutter_display_config_interface_get_resources (object, parameters, invocation);
	} else if (strcmp (method_name, "ApplyConfiguration") == 0) {
		_dbus_mutter_display_config_interface_apply_configuration (object, parameters, invocation);
	} else if (strcmp (method_name, "ChangeBacklight") == 0) {
		_dbus_mutter_display_config_interface_change_backlight (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCrtcGamma") == 0) {
		_dbus_mutter_display_config_interface_get_crtc_gamma (object, parameters, invocation);
	} else if (strcmp (method_name, "SetCrtcGamma") == 0) {
		_dbus_mutter_display_config_interface_set_crtc_gamma (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCurrentState") == 0) {
		_dbus_mutter_display_config_interface_get_current_state (object, parameters, invocation);
	} else if (strcmp (method_name, "ApplyMonitorsConfig") == 0) {
		_dbus_mutter_display_config_interface_apply_monitors_config (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_mutter_display_config_interface_get_power_save_mode (MutterDisplayConfigInterface* self)
{
	gint result;
	GVariant* _reply;
	result = mutter_display_config_interface_get_power_save_mode (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
mutter_display_config_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PowerSaveMode") == 0) {
		return _dbus_mutter_display_config_interface_get_power_save_mode (object);
	}
	return NULL;
}

static void
_dbus_mutter_display_config_interface_set_power_save_mode (MutterDisplayConfigInterface* self,
                                                           GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	mutter_display_config_interface_set_power_save_mode (self, value);
}

static gboolean
mutter_display_config_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PowerSaveMode") == 0) {
		_dbus_mutter_display_config_interface_set_power_save_mode (object, value);
		return TRUE;
	}
	return FALSE;
}

static void
_dbus_mutter_display_config_interface_monitors_changed (GObject* _sender,
                                                        gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Mutter.DisplayConfig", "MonitorsChanged", _arguments, NULL);
}

guint
mutter_display_config_interface_register_object (gpointer object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_mutter_display_config_interface_dbus_interface_info), &_mutter_display_config_interface_dbus_interface_vtable, data, _mutter_display_config_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "monitors-changed", (GCallback) _dbus_mutter_display_config_interface_monitors_changed, data);
	return result;
}

static void
_mutter_display_config_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_mutter_display_config_interface_monitors_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static GType
mutter_apply_method_get_type_once (void)
{
	static const GEnumValue values[] = {{MUTTER_APPLY_METHOD_VERIFY, "MUTTER_APPLY_METHOD_VERIFY", "verify"}, {MUTTER_APPLY_METHOD_TEMPORARY, "MUTTER_APPLY_METHOD_TEMPORARY", "temporary"}, {MUTTER_APPLY_METHOD_PERSISTENT, "MUTTER_APPLY_METHOD_PERSISTENT", "persistent"}, {0, NULL, NULL}};
	GType mutter_apply_method_type_id;
	mutter_apply_method_type_id = g_enum_register_static ("MutterApplyMethod", values);
	return mutter_apply_method_type_id;
}

GType
mutter_apply_method_get_type (void)
{
	static volatile gsize mutter_apply_method_type_id__once = 0;
	if (g_once_init_enter (&mutter_apply_method_type_id__once)) {
		GType mutter_apply_method_type_id;
		mutter_apply_method_type_id = mutter_apply_method_get_type_once ();
		g_once_init_leave (&mutter_apply_method_type_id__once, mutter_apply_method_type_id);
	}
	return mutter_apply_method_type_id__once;
}

gchar*
display_transform_to_string (DisplayTransform self)
{
	gchar* result;
	switch (self) {
		case DISPLAY_TRANSFORM_ROTATION_90:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Clockwise"));
			result = _tmp0_;
			return result;
		}
		case DISPLAY_TRANSFORM_ROTATION_180:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Upside-down"));
			result = _tmp1_;
			return result;
		}
		case DISPLAY_TRANSFORM_ROTATION_270:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Counterclockwise"));
			result = _tmp2_;
			return result;
		}
		case DISPLAY_TRANSFORM_FLIPPED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Flipped"));
			result = _tmp3_;
			return result;
		}
		case DISPLAY_TRANSFORM_FLIPPED_ROTATION_90:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Flipped Clockwise"));
			result = _tmp4_;
			return result;
		}
		case DISPLAY_TRANSFORM_FLIPPED_ROTATION_180:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Flipped Upside-down"));
			result = _tmp5_;
			return result;
		}
		case DISPLAY_TRANSFORM_FLIPPED_ROTATION_270:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Flipped Counterclockwise"));
			result = _tmp6_;
			return result;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("None"));
			result = _tmp7_;
			return result;
		}
	}
}

static GType
display_transform_get_type_once (void)
{
	static const GEnumValue values[] = {{DISPLAY_TRANSFORM_NORMAL, "DISPLAY_TRANSFORM_NORMAL", "normal"}, {DISPLAY_TRANSFORM_ROTATION_90, "DISPLAY_TRANSFORM_ROTATION_90", "rotation-90"}, {DISPLAY_TRANSFORM_ROTATION_180, "DISPLAY_TRANSFORM_ROTATION_180", "rotation-180"}, {DISPLAY_TRANSFORM_ROTATION_270, "DISPLAY_TRANSFORM_ROTATION_270", "rotation-270"}, {DISPLAY_TRANSFORM_FLIPPED, "DISPLAY_TRANSFORM_FLIPPED", "flipped"}, {DISPLAY_TRANSFORM_FLIPPED_ROTATION_90, "DISPLAY_TRANSFORM_FLIPPED_ROTATION_90", "flipped-rotation-90"}, {DISPLAY_TRANSFORM_FLIPPED_ROTATION_180, "DISPLAY_TRANSFORM_FLIPPED_ROTATION_180", "flipped-rotation-180"}, {DISPLAY_TRANSFORM_FLIPPED_ROTATION_270, "DISPLAY_TRANSFORM_FLIPPED_ROTATION_270", "flipped-rotation-270"}, {0, NULL, NULL}};
	GType display_transform_type_id;
	display_transform_type_id = g_enum_register_static ("DisplayTransform", values);
	return display_transform_type_id;
}

GType
display_transform_get_type (void)
{
	static volatile gsize display_transform_type_id__once = 0;
	if (g_once_init_enter (&display_transform_type_id__once)) {
		GType display_transform_type_id;
		display_transform_type_id = display_transform_get_type_once ();
		g_once_init_leave (&display_transform_type_id__once, display_transform_type_id);
	}
	return display_transform_type_id__once;
}

guint
mutter_read_monitor_info_get_hash (MutterReadMonitorInfo* self)
{
	guint result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = (*self).connector;
	_tmp1_ = (*self).vendor;
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = (*self).product;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = (*self).serial;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_str_hash (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp10_;
	return result;
}

void
mutter_read_monitor_info_copy (const MutterReadMonitorInfo* self,
                               MutterReadMonitorInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).connector;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).connector);
	(*dest).connector = _tmp1_;
	_tmp2_ = (*self).vendor;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).vendor);
	(*dest).vendor = _tmp3_;
	_tmp4_ = (*self).product;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).product);
	(*dest).product = _tmp5_;
	_tmp6_ = (*self).serial;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).serial);
	(*dest).serial = _tmp7_;
}

void
mutter_read_monitor_info_destroy (MutterReadMonitorInfo* self)
{
	_g_free0 ((*self).connector);
	_g_free0 ((*self).vendor);
	_g_free0 ((*self).product);
	_g_free0 ((*self).serial);
}

MutterReadMonitorInfo*
mutter_read_monitor_info_dup (const MutterReadMonitorInfo* self)
{
	MutterReadMonitorInfo* dup;
	dup = g_new0 (MutterReadMonitorInfo, 1);
	mutter_read_monitor_info_copy (self, dup);
	return dup;
}

void
mutter_read_monitor_info_free (MutterReadMonitorInfo* self)
{
	mutter_read_monitor_info_destroy (self);
	g_free (self);
}

static GType
mutter_read_monitor_info_get_type_once (void)
{
	GType mutter_read_monitor_info_type_id;
	mutter_read_monitor_info_type_id = g_boxed_type_register_static ("MutterReadMonitorInfo", (GBoxedCopyFunc) mutter_read_monitor_info_dup, (GBoxedFreeFunc) mutter_read_monitor_info_free);
	return mutter_read_monitor_info_type_id;
}

GType
mutter_read_monitor_info_get_type (void)
{
	static volatile gsize mutter_read_monitor_info_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_monitor_info_type_id__once)) {
		GType mutter_read_monitor_info_type_id;
		mutter_read_monitor_info_type_id = mutter_read_monitor_info_get_type_once ();
		g_once_init_leave (&mutter_read_monitor_info_type_id__once, mutter_read_monitor_info_type_id);
	}
	return mutter_read_monitor_info_type_id__once;
}

static gdouble*
_vala_array_dup1 (gdouble* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
mutter_read_monitor_mode_copy (const MutterReadMonitorMode* self,
                               MutterReadMonitorMode* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	(*dest).width = (*self).width;
	(*dest).height = (*self).height;
	(*dest).frequency = (*self).frequency;
	(*dest).preferred_scale = (*self).preferred_scale;
	_tmp2_ = (*self).supported_scales;
	_tmp2__length1 = (*self).supported_scales_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).supported_scales = (g_free ((*dest).supported_scales), NULL);
	(*dest).supported_scales = _tmp3_;
	(*dest).supported_scales_length1 = _tmp3__length1;
	_tmp4_ = (*self).properties;
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp5_;
}

void
mutter_read_monitor_mode_destroy (MutterReadMonitorMode* self)
{
	_g_free0 ((*self).id);
	(*self).supported_scales = (g_free ((*self).supported_scales), NULL);
	_g_hash_table_unref0 ((*self).properties);
}

MutterReadMonitorMode*
mutter_read_monitor_mode_dup (const MutterReadMonitorMode* self)
{
	MutterReadMonitorMode* dup;
	dup = g_new0 (MutterReadMonitorMode, 1);
	mutter_read_monitor_mode_copy (self, dup);
	return dup;
}

void
mutter_read_monitor_mode_free (MutterReadMonitorMode* self)
{
	mutter_read_monitor_mode_destroy (self);
	g_free (self);
}

static GType
mutter_read_monitor_mode_get_type_once (void)
{
	GType mutter_read_monitor_mode_type_id;
	mutter_read_monitor_mode_type_id = g_boxed_type_register_static ("MutterReadMonitorMode", (GBoxedCopyFunc) mutter_read_monitor_mode_dup, (GBoxedFreeFunc) mutter_read_monitor_mode_free);
	return mutter_read_monitor_mode_type_id;
}

GType
mutter_read_monitor_mode_get_type (void)
{
	static volatile gsize mutter_read_monitor_mode_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_monitor_mode_type_id__once)) {
		GType mutter_read_monitor_mode_type_id;
		mutter_read_monitor_mode_type_id = mutter_read_monitor_mode_get_type_once ();
		g_once_init_leave (&mutter_read_monitor_mode_type_id__once, mutter_read_monitor_mode_type_id);
	}
	return mutter_read_monitor_mode_type_id__once;
}

static void
_vala_MutterReadMonitorMode_array_free (MutterReadMonitorMode * array,
                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_monitor_mode_destroy (&array[i]);
		}
	}
	g_free (array);
}

static MutterReadMonitorMode*
_vala_array_dup2 (MutterReadMonitorMode* self,
                  gssize length)
{
	if (length > 0) {
		MutterReadMonitorMode* result;
		gssize i;
		result = g_new0 (MutterReadMonitorMode, length);
		for (i = 0; i < length; i++) {
			MutterReadMonitorMode _tmp0_;
			MutterReadMonitorMode _tmp1_ = {0};
			_tmp0_ = self[i];
			mutter_read_monitor_mode_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

void
mutter_read_monitor_copy (const MutterReadMonitor* self,
                          MutterReadMonitor* dest)
{
	MutterReadMonitorInfo _tmp0_;
	MutterReadMonitorInfo _tmp1_;
	MutterReadMonitorInfo _tmp2_ = {0};
	MutterReadMonitorMode* _tmp3_;
	gint _tmp3__length1;
	MutterReadMonitorMode* _tmp4_;
	gint _tmp4__length1;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	_tmp0_ = (*self).monitor;
	_tmp1_ = _tmp0_;
	mutter_read_monitor_info_copy (&_tmp1_, &_tmp2_);
	mutter_read_monitor_info_destroy (&(*dest).monitor);
	(*dest).monitor = _tmp2_;
	_tmp3_ = (*self).modes;
	_tmp3__length1 = (*self).modes_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	(*dest).modes = (_vala_MutterReadMonitorMode_array_free ((*dest).modes, (*dest).modes_length1), NULL);
	(*dest).modes = _tmp4_;
	(*dest).modes_length1 = _tmp4__length1;
	_tmp5_ = (*self).properties;
	_tmp6_ = _g_hash_table_ref0 (_tmp5_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp6_;
}

void
mutter_read_monitor_destroy (MutterReadMonitor* self)
{
	mutter_read_monitor_info_destroy (&(*self).monitor);
	(*self).modes = (_vala_MutterReadMonitorMode_array_free ((*self).modes, (*self).modes_length1), NULL);
	_g_hash_table_unref0 ((*self).properties);
}

MutterReadMonitor*
mutter_read_monitor_dup (const MutterReadMonitor* self)
{
	MutterReadMonitor* dup;
	dup = g_new0 (MutterReadMonitor, 1);
	mutter_read_monitor_copy (self, dup);
	return dup;
}

void
mutter_read_monitor_free (MutterReadMonitor* self)
{
	mutter_read_monitor_destroy (self);
	g_free (self);
}

static GType
mutter_read_monitor_get_type_once (void)
{
	GType mutter_read_monitor_type_id;
	mutter_read_monitor_type_id = g_boxed_type_register_static ("MutterReadMonitor", (GBoxedCopyFunc) mutter_read_monitor_dup, (GBoxedFreeFunc) mutter_read_monitor_free);
	return mutter_read_monitor_type_id;
}

GType
mutter_read_monitor_get_type (void)
{
	static volatile gsize mutter_read_monitor_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_monitor_type_id__once)) {
		GType mutter_read_monitor_type_id;
		mutter_read_monitor_type_id = mutter_read_monitor_get_type_once ();
		g_once_init_leave (&mutter_read_monitor_type_id__once, mutter_read_monitor_type_id);
	}
	return mutter_read_monitor_type_id__once;
}

static void
_vala_MutterReadMonitorInfo_array_free (MutterReadMonitorInfo * array,
                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_read_monitor_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static MutterReadMonitorInfo*
_vala_array_dup3 (MutterReadMonitorInfo* self,
                  gssize length)
{
	if (length > 0) {
		MutterReadMonitorInfo* result;
		gssize i;
		result = g_new0 (MutterReadMonitorInfo, length);
		for (i = 0; i < length; i++) {
			MutterReadMonitorInfo _tmp0_;
			MutterReadMonitorInfo _tmp1_ = {0};
			_tmp0_ = self[i];
			mutter_read_monitor_info_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

void
mutter_read_logical_monitor_copy (const MutterReadLogicalMonitor* self,
                                  MutterReadLogicalMonitor* dest)
{
	MutterReadMonitorInfo* _tmp0_;
	gint _tmp0__length1;
	MutterReadMonitorInfo* _tmp1_;
	gint _tmp1__length1;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	(*dest).scale = (*self).scale;
	(*dest).transform = (*self).transform;
	(*dest).primary = (*self).primary;
	_tmp0_ = (*self).monitors;
	_tmp0__length1 = (*self).monitors_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).monitors = (_vala_MutterReadMonitorInfo_array_free ((*dest).monitors, (*dest).monitors_length1), NULL);
	(*dest).monitors = _tmp1_;
	(*dest).monitors_length1 = _tmp1__length1;
	_tmp2_ = (*self).properties;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp3_;
}

void
mutter_read_logical_monitor_destroy (MutterReadLogicalMonitor* self)
{
	(*self).monitors = (_vala_MutterReadMonitorInfo_array_free ((*self).monitors, (*self).monitors_length1), NULL);
	_g_hash_table_unref0 ((*self).properties);
}

MutterReadLogicalMonitor*
mutter_read_logical_monitor_dup (const MutterReadLogicalMonitor* self)
{
	MutterReadLogicalMonitor* dup;
	dup = g_new0 (MutterReadLogicalMonitor, 1);
	mutter_read_logical_monitor_copy (self, dup);
	return dup;
}

void
mutter_read_logical_monitor_free (MutterReadLogicalMonitor* self)
{
	mutter_read_logical_monitor_destroy (self);
	g_free (self);
}

static GType
mutter_read_logical_monitor_get_type_once (void)
{
	GType mutter_read_logical_monitor_type_id;
	mutter_read_logical_monitor_type_id = g_boxed_type_register_static ("MutterReadLogicalMonitor", (GBoxedCopyFunc) mutter_read_logical_monitor_dup, (GBoxedFreeFunc) mutter_read_logical_monitor_free);
	return mutter_read_logical_monitor_type_id;
}

GType
mutter_read_logical_monitor_get_type (void)
{
	static volatile gsize mutter_read_logical_monitor_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_logical_monitor_type_id__once)) {
		GType mutter_read_logical_monitor_type_id;
		mutter_read_logical_monitor_type_id = mutter_read_logical_monitor_get_type_once ();
		g_once_init_leave (&mutter_read_logical_monitor_type_id__once, mutter_read_logical_monitor_type_id);
	}
	return mutter_read_logical_monitor_type_id__once;
}

void
mutter_write_monitor_copy (const MutterWriteMonitor* self,
                           MutterWriteMonitor* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	_tmp0_ = (*self).connector;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).connector);
	(*dest).connector = _tmp1_;
	_tmp2_ = (*self).monitor_mode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).monitor_mode);
	(*dest).monitor_mode = _tmp3_;
	_tmp4_ = (*self).properties;
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp5_;
}

void
mutter_write_monitor_destroy (MutterWriteMonitor* self)
{
	_g_free0 ((*self).connector);
	_g_free0 ((*self).monitor_mode);
	_g_hash_table_unref0 ((*self).properties);
}

MutterWriteMonitor*
mutter_write_monitor_dup (const MutterWriteMonitor* self)
{
	MutterWriteMonitor* dup;
	dup = g_new0 (MutterWriteMonitor, 1);
	mutter_write_monitor_copy (self, dup);
	return dup;
}

void
mutter_write_monitor_free (MutterWriteMonitor* self)
{
	mutter_write_monitor_destroy (self);
	g_free (self);
}

static GType
mutter_write_monitor_get_type_once (void)
{
	GType mutter_write_monitor_type_id;
	mutter_write_monitor_type_id = g_boxed_type_register_static ("MutterWriteMonitor", (GBoxedCopyFunc) mutter_write_monitor_dup, (GBoxedFreeFunc) mutter_write_monitor_free);
	return mutter_write_monitor_type_id;
}

GType
mutter_write_monitor_get_type (void)
{
	static volatile gsize mutter_write_monitor_type_id__once = 0;
	if (g_once_init_enter (&mutter_write_monitor_type_id__once)) {
		GType mutter_write_monitor_type_id;
		mutter_write_monitor_type_id = mutter_write_monitor_get_type_once ();
		g_once_init_leave (&mutter_write_monitor_type_id__once, mutter_write_monitor_type_id);
	}
	return mutter_write_monitor_type_id__once;
}

static void
_vala_MutterWriteMonitor_array_free (MutterWriteMonitor * array,
                                     gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			mutter_write_monitor_destroy (&array[i]);
		}
	}
	g_free (array);
}

static MutterWriteMonitor*
_vala_array_dup4 (MutterWriteMonitor* self,
                  gssize length)
{
	if (length > 0) {
		MutterWriteMonitor* result;
		gssize i;
		result = g_new0 (MutterWriteMonitor, length);
		for (i = 0; i < length; i++) {
			MutterWriteMonitor _tmp0_;
			MutterWriteMonitor _tmp1_ = {0};
			_tmp0_ = self[i];
			mutter_write_monitor_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

void
mutter_write_logical_monitor_copy (const MutterWriteLogicalMonitor* self,
                                   MutterWriteLogicalMonitor* dest)
{
	MutterWriteMonitor* _tmp0_;
	gint _tmp0__length1;
	MutterWriteMonitor* _tmp1_;
	gint _tmp1__length1;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	(*dest).scale = (*self).scale;
	(*dest).transform = (*self).transform;
	(*dest).primary = (*self).primary;
	_tmp0_ = (*self).monitors;
	_tmp0__length1 = (*self).monitors_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).monitors = (_vala_MutterWriteMonitor_array_free ((*dest).monitors, (*dest).monitors_length1), NULL);
	(*dest).monitors = _tmp1_;
	(*dest).monitors_length1 = _tmp1__length1;
}

void
mutter_write_logical_monitor_destroy (MutterWriteLogicalMonitor* self)
{
	(*self).monitors = (_vala_MutterWriteMonitor_array_free ((*self).monitors, (*self).monitors_length1), NULL);
}

MutterWriteLogicalMonitor*
mutter_write_logical_monitor_dup (const MutterWriteLogicalMonitor* self)
{
	MutterWriteLogicalMonitor* dup;
	dup = g_new0 (MutterWriteLogicalMonitor, 1);
	mutter_write_logical_monitor_copy (self, dup);
	return dup;
}

void
mutter_write_logical_monitor_free (MutterWriteLogicalMonitor* self)
{
	mutter_write_logical_monitor_destroy (self);
	g_free (self);
}

static GType
mutter_write_logical_monitor_get_type_once (void)
{
	GType mutter_write_logical_monitor_type_id;
	mutter_write_logical_monitor_type_id = g_boxed_type_register_static ("MutterWriteLogicalMonitor", (GBoxedCopyFunc) mutter_write_logical_monitor_dup, (GBoxedFreeFunc) mutter_write_logical_monitor_free);
	return mutter_write_logical_monitor_type_id;
}

GType
mutter_write_logical_monitor_get_type (void)
{
	static volatile gsize mutter_write_logical_monitor_type_id__once = 0;
	if (g_once_init_enter (&mutter_write_logical_monitor_type_id__once)) {
		GType mutter_write_logical_monitor_type_id;
		mutter_write_logical_monitor_type_id = mutter_write_logical_monitor_get_type_once ();
		g_once_init_leave (&mutter_write_logical_monitor_type_id__once, mutter_write_logical_monitor_type_id);
	}
	return mutter_write_logical_monitor_type_id__once;
}

static DisplayTransform*
_vala_array_dup5 (DisplayTransform* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (DisplayTransform));
	}
	return NULL;
}

void
mutter_read_display_crtc_copy (const MutterReadDisplayCrtc* self,
                               MutterReadDisplayCrtc* dest)
{
	DisplayTransform* _tmp0_;
	gint _tmp0__length1;
	DisplayTransform* _tmp1_;
	gint _tmp1__length1;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	(*dest).id = (*self).id;
	(*dest).winsys_id = (*self).winsys_id;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	(*dest).width = (*self).width;
	(*dest).height = (*self).height;
	(*dest).current_mode = (*self).current_mode;
	(*dest).current_transform = (*self).current_transform;
	_tmp0_ = (*self).transforms;
	_tmp0__length1 = (*self).transforms_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).transforms = (g_free ((*dest).transforms), NULL);
	(*dest).transforms = _tmp1_;
	(*dest).transforms_length1 = _tmp1__length1;
	_tmp2_ = (*self).properties;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp3_;
}

void
mutter_read_display_crtc_destroy (MutterReadDisplayCrtc* self)
{
	(*self).transforms = (g_free ((*self).transforms), NULL);
	_g_hash_table_unref0 ((*self).properties);
}

MutterReadDisplayCrtc*
mutter_read_display_crtc_dup (const MutterReadDisplayCrtc* self)
{
	MutterReadDisplayCrtc* dup;
	dup = g_new0 (MutterReadDisplayCrtc, 1);
	mutter_read_display_crtc_copy (self, dup);
	return dup;
}

void
mutter_read_display_crtc_free (MutterReadDisplayCrtc* self)
{
	mutter_read_display_crtc_destroy (self);
	g_free (self);
}

static GType
mutter_read_display_crtc_get_type_once (void)
{
	GType mutter_read_display_crtc_type_id;
	mutter_read_display_crtc_type_id = g_boxed_type_register_static ("MutterReadDisplayCrtc", (GBoxedCopyFunc) mutter_read_display_crtc_dup, (GBoxedFreeFunc) mutter_read_display_crtc_free);
	return mutter_read_display_crtc_type_id;
}

GType
mutter_read_display_crtc_get_type (void)
{
	static volatile gsize mutter_read_display_crtc_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_display_crtc_type_id__once)) {
		GType mutter_read_display_crtc_type_id;
		mutter_read_display_crtc_type_id = mutter_read_display_crtc_get_type_once ();
		g_once_init_leave (&mutter_read_display_crtc_type_id__once, mutter_read_display_crtc_type_id);
	}
	return mutter_read_display_crtc_type_id__once;
}

static guint*
_vala_array_dup6 (guint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint));
	}
	return NULL;
}

void
mutter_write_display_crtc_copy (const MutterWriteDisplayCrtc* self,
                                MutterWriteDisplayCrtc* dest)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	guint* _tmp1_;
	gint _tmp1__length1;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	(*dest).id = (*self).id;
	(*dest).new_mode = (*self).new_mode;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	(*dest).transform = (*self).transform;
	_tmp0_ = (*self).outputs;
	_tmp0__length1 = (*self).outputs_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).outputs = (g_free ((*dest).outputs), NULL);
	(*dest).outputs = _tmp1_;
	(*dest).outputs_length1 = _tmp1__length1;
	_tmp2_ = (*self).properties;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp3_;
}

void
mutter_write_display_crtc_destroy (MutterWriteDisplayCrtc* self)
{
	(*self).outputs = (g_free ((*self).outputs), NULL);
	_g_hash_table_unref0 ((*self).properties);
}

MutterWriteDisplayCrtc*
mutter_write_display_crtc_dup (const MutterWriteDisplayCrtc* self)
{
	MutterWriteDisplayCrtc* dup;
	dup = g_new0 (MutterWriteDisplayCrtc, 1);
	mutter_write_display_crtc_copy (self, dup);
	return dup;
}

void
mutter_write_display_crtc_free (MutterWriteDisplayCrtc* self)
{
	mutter_write_display_crtc_destroy (self);
	g_free (self);
}

static GType
mutter_write_display_crtc_get_type_once (void)
{
	GType mutter_write_display_crtc_type_id;
	mutter_write_display_crtc_type_id = g_boxed_type_register_static ("MutterWriteDisplayCrtc", (GBoxedCopyFunc) mutter_write_display_crtc_dup, (GBoxedFreeFunc) mutter_write_display_crtc_free);
	return mutter_write_display_crtc_type_id;
}

GType
mutter_write_display_crtc_get_type (void)
{
	static volatile gsize mutter_write_display_crtc_type_id__once = 0;
	if (g_once_init_enter (&mutter_write_display_crtc_type_id__once)) {
		GType mutter_write_display_crtc_type_id;
		mutter_write_display_crtc_type_id = mutter_write_display_crtc_get_type_once ();
		g_once_init_leave (&mutter_write_display_crtc_type_id__once, mutter_write_display_crtc_type_id);
	}
	return mutter_write_display_crtc_type_id__once;
}

static guint*
_vala_array_dup7 (guint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint));
	}
	return NULL;
}

static guint*
_vala_array_dup8 (guint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint));
	}
	return NULL;
}

static guint*
_vala_array_dup9 (guint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint));
	}
	return NULL;
}

void
mutter_read_display_output_copy (const MutterReadDisplayOutput* self,
                                 MutterReadDisplayOutput* dest)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	guint* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint* _tmp4_;
	gint _tmp4__length1;
	guint* _tmp5_;
	gint _tmp5__length1;
	guint* _tmp6_;
	gint _tmp6__length1;
	guint* _tmp7_;
	gint _tmp7__length1;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	(*dest).id = (*self).id;
	(*dest).winsys_id = (*self).winsys_id;
	(*dest).current_crtc = (*self).current_crtc;
	_tmp0_ = (*self).possible_crtcs;
	_tmp0__length1 = (*self).possible_crtcs_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).possible_crtcs = (g_free ((*dest).possible_crtcs), NULL);
	(*dest).possible_crtcs = _tmp1_;
	(*dest).possible_crtcs_length1 = _tmp1__length1;
	_tmp2_ = (*self).connector_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).connector_name);
	(*dest).connector_name = _tmp3_;
	_tmp4_ = (*self).modes;
	_tmp4__length1 = (*self).modes_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup8 (_tmp4_, _tmp4__length1) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	(*dest).modes = (g_free ((*dest).modes), NULL);
	(*dest).modes = _tmp5_;
	(*dest).modes_length1 = _tmp5__length1;
	_tmp6_ = (*self).clones;
	_tmp6__length1 = (*self).clones_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup9 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	(*dest).clones = (g_free ((*dest).clones), NULL);
	(*dest).clones = _tmp7_;
	(*dest).clones_length1 = _tmp7__length1;
	_tmp8_ = (*self).properties;
	_tmp9_ = _g_hash_table_ref0 (_tmp8_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp9_;
}

void
mutter_read_display_output_destroy (MutterReadDisplayOutput* self)
{
	(*self).possible_crtcs = (g_free ((*self).possible_crtcs), NULL);
	_g_free0 ((*self).connector_name);
	(*self).modes = (g_free ((*self).modes), NULL);
	(*self).clones = (g_free ((*self).clones), NULL);
	_g_hash_table_unref0 ((*self).properties);
}

MutterReadDisplayOutput*
mutter_read_display_output_dup (const MutterReadDisplayOutput* self)
{
	MutterReadDisplayOutput* dup;
	dup = g_new0 (MutterReadDisplayOutput, 1);
	mutter_read_display_output_copy (self, dup);
	return dup;
}

void
mutter_read_display_output_free (MutterReadDisplayOutput* self)
{
	mutter_read_display_output_destroy (self);
	g_free (self);
}

static GType
mutter_read_display_output_get_type_once (void)
{
	GType mutter_read_display_output_type_id;
	mutter_read_display_output_type_id = g_boxed_type_register_static ("MutterReadDisplayOutput", (GBoxedCopyFunc) mutter_read_display_output_dup, (GBoxedFreeFunc) mutter_read_display_output_free);
	return mutter_read_display_output_type_id;
}

GType
mutter_read_display_output_get_type (void)
{
	static volatile gsize mutter_read_display_output_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_display_output_type_id__once)) {
		GType mutter_read_display_output_type_id;
		mutter_read_display_output_type_id = mutter_read_display_output_get_type_once ();
		g_once_init_leave (&mutter_read_display_output_type_id__once, mutter_read_display_output_type_id);
	}
	return mutter_read_display_output_type_id__once;
}

void
mutter_write_display_output_copy (const MutterWriteDisplayOutput* self,
                                  MutterWriteDisplayOutput* dest)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	(*dest).id = (*self).id;
	_tmp0_ = (*self).properties;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp1_;
}

void
mutter_write_display_output_destroy (MutterWriteDisplayOutput* self)
{
	_g_hash_table_unref0 ((*self).properties);
}

MutterWriteDisplayOutput*
mutter_write_display_output_dup (const MutterWriteDisplayOutput* self)
{
	MutterWriteDisplayOutput* dup;
	dup = g_new0 (MutterWriteDisplayOutput, 1);
	mutter_write_display_output_copy (self, dup);
	return dup;
}

void
mutter_write_display_output_free (MutterWriteDisplayOutput* self)
{
	mutter_write_display_output_destroy (self);
	g_free (self);
}

static GType
mutter_write_display_output_get_type_once (void)
{
	GType mutter_write_display_output_type_id;
	mutter_write_display_output_type_id = g_boxed_type_register_static ("MutterWriteDisplayOutput", (GBoxedCopyFunc) mutter_write_display_output_dup, (GBoxedFreeFunc) mutter_write_display_output_free);
	return mutter_write_display_output_type_id;
}

GType
mutter_write_display_output_get_type (void)
{
	static volatile gsize mutter_write_display_output_type_id__once = 0;
	if (g_once_init_enter (&mutter_write_display_output_type_id__once)) {
		GType mutter_write_display_output_type_id;
		mutter_write_display_output_type_id = mutter_write_display_output_get_type_once ();
		g_once_init_leave (&mutter_write_display_output_type_id__once, mutter_write_display_output_type_id);
	}
	return mutter_write_display_output_type_id__once;
}

MutterReadDisplayMode*
mutter_read_display_mode_dup (const MutterReadDisplayMode* self)
{
	MutterReadDisplayMode* dup;
	dup = g_new0 (MutterReadDisplayMode, 1);
	memcpy (dup, self, sizeof (MutterReadDisplayMode));
	return dup;
}

void
mutter_read_display_mode_free (MutterReadDisplayMode* self)
{
	g_free (self);
}

static GType
mutter_read_display_mode_get_type_once (void)
{
	GType mutter_read_display_mode_type_id;
	mutter_read_display_mode_type_id = g_boxed_type_register_static ("MutterReadDisplayMode", (GBoxedCopyFunc) mutter_read_display_mode_dup, (GBoxedFreeFunc) mutter_read_display_mode_free);
	return mutter_read_display_mode_type_id;
}

GType
mutter_read_display_mode_get_type (void)
{
	static volatile gsize mutter_read_display_mode_type_id__once = 0;
	if (g_once_init_enter (&mutter_read_display_mode_type_id__once)) {
		GType mutter_read_display_mode_type_id;
		mutter_read_display_mode_type_id = mutter_read_display_mode_get_type_once ();
		g_once_init_leave (&mutter_read_display_mode_type_id__once, mutter_read_display_mode_type_id);
	}
	return mutter_read_display_mode_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

