/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AArch64 target                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 73;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AArch64InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(2),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_nxv1s1,
  GILLT_nxv2s1,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv8s1,
  GILLT_nxv8s16,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
};
const static size_t NumTypeObjects = 24;
const static LLT TypeObjects[] = {
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasPAuthBit = 8,
  Feature_HasJSBit = 10,
  Feature_HasComplxNumBit = 49,
  Feature_HasRCPC_IMMOBit = 68,
  Feature_HasFPARMv8Bit = 9,
  Feature_HasNEONBit = 4,
  Feature_HasSM4Bit = 48,
  Feature_HasSHA3Bit = 47,
  Feature_HasSHA2Bit = 19,
  Feature_HasAESBit = 18,
  Feature_HasDotProdBit = 2,
  Feature_HasCRCBit = 12,
  Feature_HasCSSCBit = 20,
  Feature_HasNoCSSCBit = 24,
  Feature_HasLSEBit = 25,
  Feature_HasNoLSEBit = 72,
  Feature_HasRDMBit = 17,
  Feature_HasFullFP16Bit = 15,
  Feature_HasNoFullFP16Bit = 65,
  Feature_HasFP16FMLBit = 7,
  Feature_HasFuseAESBit = 59,
  Feature_HasSVEBit = 21,
  Feature_HasSVE2Bit = 22,
  Feature_HasSVE2p1Bit = 36,
  Feature_HasSVE2AESBit = 31,
  Feature_HasSVE2SM4Bit = 33,
  Feature_HasSVE2SHA3Bit = 71,
  Feature_HasSVE2BitPermBit = 32,
  Feature_HasB16B16Bit = 28,
  Feature_HasSMEandIsNonStreamingSafeBit = 42,
  Feature_HasSMEBit = 38,
  Feature_HasSMEF64F64Bit = 39,
  Feature_HasSMEI16I64Bit = 41,
  Feature_HasSME2andIsNonStreamingSafeBit = 45,
  Feature_HasSME2Bit = 44,
  Feature_HasSME2p1Bit = 46,
  Feature_HasSVEorSMEBit = 0,
  Feature_HasSVE2orSMEBit = 26,
  Feature_HasSVE2orSME2Bit = 29,
  Feature_HasSVE2p1_or_HasSMEBit = 43,
  Feature_HasSVE2p1_or_HasSME2Bit = 23,
  Feature_HasSVE2p1_or_HasSME2p1Bit = 37,
  Feature_HasSMEF16F16orSMEF8F16Bit = 40,
  Feature_HasNEONandIsStreamingSafeBit = 5,
  Feature_HasRCPCBit = 67,
  Feature_HasFRInt3264Bit = 16,
  Feature_HasMTEBit = 13,
  Feature_HasTMEBit = 11,
  Feature_HasBF16Bit = 3,
  Feature_HasNoBF16Bit = 66,
  Feature_HasMatMulInt8Bit = 6,
  Feature_HasMatMulFP32Bit = 34,
  Feature_HasMatMulFP64Bit = 35,
  Feature_HasLS64Bit = 63,
  Feature_HasHBCBit = 14,
  Feature_HasRCPC3Bit = 64,
  Feature_HasGCSBit = 1,
  Feature_IsLEBit = 55,
  Feature_IsBEBit = 60,
  Feature_UseExperimentalZeroingPseudosBit = 30,
  Feature_UseAlternateSExtLoadCVTF32Bit = 58,
  Feature_UseScalarIncVLBit = 27,
  Feature_NoUseScalarIncVLBit = 70,
  Feature_UseSVEFPLD1RBit = 69,
  Feature_NotForCodeSizeBit = 57,
  Feature_UseSTRQroBit = 56,
  Feature_TailCallX16X17Bit = 51,
  Feature_TailCallX17Bit = 61,
  Feature_TailCallNotX16Bit = 62,
  Feature_TailCallAnyBit = 50,
  Feature_SLSBLRMitigationBit = 54,
  Feature_NoSLSBLRMitigationBit = 53,
  Feature_OptimizedGISelOrOtherSelectorBit = 52,
};

PredicateBitset AArch64InstructionSelector::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasPAuth())
    Features.set(Feature_HasPAuthBit);
  if (Subtarget->hasJS())
    Features.set(Feature_HasJSBit);
  if (Subtarget->hasComplxNum())
    Features.set(Feature_HasComplxNumBit);
  if (Subtarget->hasRCPC_IMMO())
    Features.set(Feature_HasRCPC_IMMOBit);
  if (Subtarget->hasFPARMv8())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->isNeonAvailable())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasSHA3())
    Features.set(Feature_HasSHA3Bit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasCSSC())
    Features.set(Feature_HasCSSCBit);
  if (!Subtarget->hasCSSC())
    Features.set(Feature_HasNoCSSCBit);
  if (Subtarget->hasLSE())
    Features.set(Feature_HasLSEBit);
  if (!Subtarget->hasLSE())
    Features.set(Feature_HasNoLSEBit);
  if (Subtarget->hasRDM())
    Features.set(Feature_HasRDMBit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (!Subtarget->hasFullFP16())
    Features.set(Feature_HasNoFullFP16Bit);
  if (Subtarget->hasFP16FML())
    Features.set(Feature_HasFP16FMLBit);
  if (Subtarget->hasFuseAES())
    Features.set(Feature_HasFuseAESBit);
  if (Subtarget->isSVEAvailable())
    Features.set(Feature_HasSVEBit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2())
    Features.set(Feature_HasSVE2Bit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2p1())
    Features.set(Feature_HasSVE2p1Bit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2AES())
    Features.set(Feature_HasSVE2AESBit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2SM4())
    Features.set(Feature_HasSVE2SM4Bit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2SHA3())
    Features.set(Feature_HasSVE2SHA3Bit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2BitPerm())
    Features.set(Feature_HasSVE2BitPermBit);
  if (Subtarget->hasB16B16())
    Features.set(Feature_HasB16B16Bit);
  if (Subtarget->hasSME())
    Features.set(Feature_HasSMEandIsNonStreamingSafeBit);
  if (Subtarget->isStreaming() && Subtarget->hasSME())
    Features.set(Feature_HasSMEBit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEF64F64())
    Features.set(Feature_HasSMEF64F64Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEI16I64())
    Features.set(Feature_HasSMEI16I64Bit);
  if (Subtarget->hasSME2())
    Features.set(Feature_HasSME2andIsNonStreamingSafeBit);
  if (Subtarget->isStreaming() && Subtarget->hasSME2())
    Features.set(Feature_HasSME2Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSME2p1())
    Features.set(Feature_HasSME2p1Bit);
  if (Subtarget->hasSVE() || (Subtarget->isStreaming() && Subtarget->hasSME()))
    Features.set(Feature_HasSVEorSMEBit);
  if (Subtarget->hasSVE2() || (Subtarget->isStreaming() && Subtarget->hasSME()))
    Features.set(Feature_HasSVE2orSMEBit);
  if (Subtarget->hasSVE2() || (Subtarget->isStreaming() && Subtarget->hasSME2()))
    Features.set(Feature_HasSVE2orSME2Bit);
  if (Subtarget->hasSVE2p1() || (Subtarget->isStreaming() && Subtarget->hasSME()))
    Features.set(Feature_HasSVE2p1_or_HasSMEBit);
  if (Subtarget->hasSVE2p1() || (Subtarget->isStreaming() && Subtarget->hasSME2()))
    Features.set(Feature_HasSVE2p1_or_HasSME2Bit);
  if (Subtarget->hasSVE2p1() || (Subtarget->isStreaming() && Subtarget->hasSME2p1()))
    Features.set(Feature_HasSVE2p1_or_HasSME2p1Bit);
  if (Subtarget->isStreaming() && (Subtarget->hasSMEF16F16() || Subtarget->hasSMEF8F16()))
    Features.set(Feature_HasSMEF16F16orSMEF8F16Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONandIsStreamingSafeBit);
  if (Subtarget->hasRCPC())
    Features.set(Feature_HasRCPCBit);
  if (Subtarget->hasFRInt3264())
    Features.set(Feature_HasFRInt3264Bit);
  if (Subtarget->hasMTE())
    Features.set(Feature_HasMTEBit);
  if (Subtarget->hasTME())
    Features.set(Feature_HasTMEBit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (!Subtarget->hasBF16())
    Features.set(Feature_HasNoBF16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasMatMulFP32())
    Features.set(Feature_HasMatMulFP32Bit);
  if (Subtarget->hasMatMulFP64())
    Features.set(Feature_HasMatMulFP64Bit);
  if (Subtarget->hasLS64())
    Features.set(Feature_HasLS64Bit);
  if (Subtarget->hasHBC())
    Features.set(Feature_HasHBCBit);
  if (Subtarget->hasRCPC3())
    Features.set(Feature_HasRCPC3Bit);
  if (Subtarget->hasGCS())
    Features.set(Feature_HasGCSBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBEBit);
  if (Subtarget->useExperimentalZeroingPseudos())
    Features.set(Feature_UseExperimentalZeroingPseudosBit);
  if (Subtarget->useAlternateSExtLoadCVTF32Pattern())
    Features.set(Feature_UseAlternateSExtLoadCVTF32Bit);
  if (Subtarget->useScalarIncVL())
    Features.set(Feature_UseScalarIncVLBit);
  if (!Subtarget->useScalarIncVL())
    Features.set(Feature_NoUseScalarIncVLBit);
  if (!Subtarget->noSVEFPLD1R())
    Features.set(Feature_UseSVEFPLD1RBit);
  return Features;
}

void AArch64InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AArch64InstructionSelector::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!shouldOptForSize(MF))
    Features.set(Feature_NotForCodeSizeBit);
  if (!Subtarget->isSTRQroSlow() || shouldOptForSize(MF))
    Features.set(Feature_UseSTRQroBit);
  if (  MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && !MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallX16X17Bit);
  if ( MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallX17Bit);
  if ( !MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallNotX16Bit);
  if ( !MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && !MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallAnyBit);
  if ( MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (!MF->getFunction().hasOptNone() || MF->getProperties().hasProperty(MachineFunctionProperties::Property::FailedISel) || !MF->getProperties().hasProperty(MachineFunctionProperties::Property::Legalized))
    Features.set(Feature_OptimizedGISelOrOtherSelectorBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAES,
  GIFBS_HasBF16,
  GIFBS_HasCRC,
  GIFBS_HasCSSC,
  GIFBS_HasDotProd,
  GIFBS_HasFPARMv8,
  GIFBS_HasFRInt3264,
  GIFBS_HasFullFP16,
  GIFBS_HasFuseAES,
  GIFBS_HasGCS,
  GIFBS_HasLSE,
  GIFBS_HasMTE,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasNEONandIsStreamingSafe,
  GIFBS_HasNoBF16,
  GIFBS_HasNoCSSC,
  GIFBS_HasNoFullFP16,
  GIFBS_HasNoLSE,
  GIFBS_HasPAuth,
  GIFBS_HasRCPC,
  GIFBS_HasRCPC_IMMO,
  GIFBS_HasRDM,
  GIFBS_HasSHA2,
  GIFBS_HasSHA3,
  GIFBS_HasSM4,
  GIFBS_HasSME,
  GIFBS_HasSME2,
  GIFBS_HasSMEF16F16orSMEF8F16,
  GIFBS_HasSMEF64F64,
  GIFBS_HasSMEI16I64,
  GIFBS_HasSMEandIsNonStreamingSafe,
  GIFBS_HasSVE,
  GIFBS_HasSVE2,
  GIFBS_HasSVE2AES,
  GIFBS_HasSVE2BitPerm,
  GIFBS_HasSVE2SHA3,
  GIFBS_HasSVE2SM4,
  GIFBS_HasSVE2orSME,
  GIFBS_HasSVE2p1_or_HasSME,
  GIFBS_HasSVE2p1_or_HasSME2,
  GIFBS_HasSVE2p1_or_HasSME2p1,
  GIFBS_HasSVEorSME,
  GIFBS_HasTME,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_OptimizedGISelOrOtherSelector,
  GIFBS_UseSTRQro,
  GIFBS_HasB16B16_HasSME2,
  GIFBS_HasB16B16_HasSVE2orSME2,
  GIFBS_HasBF16_HasNEON,
  GIFBS_HasBF16_HasNEONandIsStreamingSafe,
  GIFBS_HasBF16_HasSVE,
  GIFBS_HasBF16_HasSVEorSME,
  GIFBS_HasComplxNum_HasNEON,
  GIFBS_HasFP16FML_HasNEON,
  GIFBS_HasFPARMv8_HasJS,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEONandIsStreamingSafe,
  GIFBS_HasMatMulFP32_HasSVE,
  GIFBS_HasMatMulFP64_HasSVE,
  GIFBS_HasMatMulFP64_HasSVEorSME,
  GIFBS_HasMatMulInt8_HasSVE,
  GIFBS_HasMatMulInt8_HasSVEorSME,
  GIFBS_HasNEON_HasRCPC3,
  GIFBS_HasNEON_HasRDM,
  GIFBS_HasSVEorSME_UseScalarIncVL,
  GIFBS_IsLE_UseSTRQro,
  GIFBS_HasComplxNum_HasFullFP16_HasNEON,
  GIFBS_HasNEON_NotForCodeSize_UseAlternateSExtLoadCVTF32,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAESBit, },
  {Feature_HasBF16Bit, },
  {Feature_HasCRCBit, },
  {Feature_HasCSSCBit, },
  {Feature_HasDotProdBit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFRInt3264Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasFuseAESBit, },
  {Feature_HasGCSBit, },
  {Feature_HasLSEBit, },
  {Feature_HasMTEBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasNEONandIsStreamingSafeBit, },
  {Feature_HasNoBF16Bit, },
  {Feature_HasNoCSSCBit, },
  {Feature_HasNoFullFP16Bit, },
  {Feature_HasNoLSEBit, },
  {Feature_HasPAuthBit, },
  {Feature_HasRCPCBit, },
  {Feature_HasRCPC_IMMOBit, },
  {Feature_HasRDMBit, },
  {Feature_HasSHA2Bit, },
  {Feature_HasSHA3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSMEBit, },
  {Feature_HasSME2Bit, },
  {Feature_HasSMEF16F16orSMEF8F16Bit, },
  {Feature_HasSMEF64F64Bit, },
  {Feature_HasSMEI16I64Bit, },
  {Feature_HasSMEandIsNonStreamingSafeBit, },
  {Feature_HasSVEBit, },
  {Feature_HasSVE2Bit, },
  {Feature_HasSVE2AESBit, },
  {Feature_HasSVE2BitPermBit, },
  {Feature_HasSVE2SHA3Bit, },
  {Feature_HasSVE2SM4Bit, },
  {Feature_HasSVE2orSMEBit, },
  {Feature_HasSVE2p1_or_HasSMEBit, },
  {Feature_HasSVE2p1_or_HasSME2Bit, },
  {Feature_HasSVE2p1_or_HasSME2p1Bit, },
  {Feature_HasSVEorSMEBit, },
  {Feature_HasTMEBit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_OptimizedGISelOrOtherSelectorBit, },
  {Feature_UseSTRQroBit, },
  {Feature_HasB16B16Bit, Feature_HasSME2Bit, },
  {Feature_HasB16B16Bit, Feature_HasSVE2orSME2Bit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasBF16Bit, Feature_HasNEONandIsStreamingSafeBit, },
  {Feature_HasBF16Bit, Feature_HasSVEBit, },
  {Feature_HasBF16Bit, Feature_HasSVEorSMEBit, },
  {Feature_HasComplxNumBit, Feature_HasNEONBit, },
  {Feature_HasFP16FMLBit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasJSBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONandIsStreamingSafeBit, },
  {Feature_HasMatMulFP32Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulFP64Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulFP64Bit, Feature_HasSVEorSMEBit, },
  {Feature_HasMatMulInt8Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulInt8Bit, Feature_HasSVEorSMEBit, },
  {Feature_HasNEONBit, Feature_HasRCPC3Bit, },
  {Feature_HasNEONBit, Feature_HasRDMBit, },
  {Feature_HasSVEorSMEBit, Feature_UseScalarIncVLBit, },
  {Feature_IsLEBit, Feature_UseSTRQroBit, },
  {Feature_HasComplxNumBit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_NotForCodeSizeBit, Feature_UseAlternateSExtLoadCVTF32Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addsub_shifted_imm32,
  GICP_gi_addsub_shifted_imm64,
  GICP_gi_am_indexed128,
  GICP_gi_am_indexed16,
  GICP_gi_am_indexed32,
  GICP_gi_am_indexed64,
  GICP_gi_am_indexed8,
  GICP_gi_am_unscaled128,
  GICP_gi_am_unscaled16,
  GICP_gi_am_unscaled32,
  GICP_gi_am_unscaled64,
  GICP_gi_am_unscaled8,
  GICP_gi_arith_extended_reg32_i32,
  GICP_gi_arith_extended_reg32_i64,
  GICP_gi_arith_extended_reg32to64_i64,
  GICP_gi_arith_shifted_reg32,
  GICP_gi_arith_shifted_reg64,
  GICP_gi_extract_high_v16i8,
  GICP_gi_extract_high_v4f32,
  GICP_gi_extract_high_v4i32,
  GICP_gi_extract_high_v8f16,
  GICP_gi_extract_high_v8i16,
  GICP_gi_logical_shifted_reg32,
  GICP_gi_logical_shifted_reg64,
  GICP_gi_neg_addsub_shifted_imm32,
  GICP_gi_neg_addsub_shifted_imm64,
  GICP_gi_ro_Windexed128,
  GICP_gi_ro_Windexed16,
  GICP_gi_ro_Windexed32,
  GICP_gi_ro_Windexed64,
  GICP_gi_ro_Windexed8,
  GICP_gi_ro_Xindexed128,
  GICP_gi_ro_Xindexed16,
  GICP_gi_ro_Xindexed32,
  GICP_gi_ro_Xindexed64,
  GICP_gi_ro_Xindexed8,
};
// See constructor for table contents

AArch64InstructionSelector::ComplexMatcherMemFn
AArch64InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm32
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeIndexed<128>, // gi_am_indexed128
  &AArch64InstructionSelector::selectAddrModeIndexed<16>, // gi_am_indexed16
  &AArch64InstructionSelector::selectAddrModeIndexed<32>, // gi_am_indexed32
  &AArch64InstructionSelector::selectAddrModeIndexed<64>, // gi_am_indexed64
  &AArch64InstructionSelector::selectAddrModeIndexed<8>, // gi_am_indexed8
  &AArch64InstructionSelector::selectAddrModeUnscaled128, // gi_am_unscaled128
  &AArch64InstructionSelector::selectAddrModeUnscaled16, // gi_am_unscaled16
  &AArch64InstructionSelector::selectAddrModeUnscaled32, // gi_am_unscaled32
  &AArch64InstructionSelector::selectAddrModeUnscaled64, // gi_am_unscaled64
  &AArch64InstructionSelector::selectAddrModeUnscaled8, // gi_am_unscaled8
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i32
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i64
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32to64_i64
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg32
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg64
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v16i8
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v4f32
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v4i32
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v8f16
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v8i16
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg32
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg64
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm32
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeWRO<128>, // gi_ro_Windexed128
  &AArch64InstructionSelector::selectAddrModeWRO<16>, // gi_ro_Windexed16
  &AArch64InstructionSelector::selectAddrModeWRO<32>, // gi_ro_Windexed32
  &AArch64InstructionSelector::selectAddrModeWRO<64>, // gi_ro_Windexed64
  &AArch64InstructionSelector::selectAddrModeWRO<8>, // gi_ro_Windexed8
  &AArch64InstructionSelector::selectAddrModeXRO<128>, // gi_ro_Xindexed128
  &AArch64InstructionSelector::selectAddrModeXRO<16>, // gi_ro_Xindexed16
  &AArch64InstructionSelector::selectAddrModeXRO<32>, // gi_ro_Xindexed32
  &AArch64InstructionSelector::selectAddrModeXRO<64>, // gi_ro_Xindexed64
  &AArch64InstructionSelector::selectAddrModeXRO<8>, // gi_ro_Xindexed8
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_and_or_is_add = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_ldaxr_1,
  GICXXPred_MI_Predicate_ldaxr_2,
  GICXXPred_MI_Predicate_ldaxr_4,
  GICXXPred_MI_Predicate_ldaxr_8,
  GICXXPred_MI_Predicate_ldxr_1,
  GICXXPred_MI_Predicate_ldxr_2,
  GICXXPred_MI_Predicate_ldxr_4,
  GICXXPred_MI_Predicate_ldxr_8,
  GICXXPred_MI_Predicate_stlxr_1,
  GICXXPred_MI_Predicate_stlxr_2,
  GICXXPred_MI_Predicate_stlxr_4,
  GICXXPred_MI_Predicate_stlxr_8,
  GICXXPred_MI_Predicate_stxr_1,
  GICXXPred_MI_Predicate_stxr_2,
  GICXXPred_MI_Predicate_stxr_4,
  GICXXPred_MI_Predicate_stxr_8,
};
bool AArch64InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_and_or_is_add: {
    
         // Only handle G_ADD for now. FIXME. build capability to compute whether
         // operands of G_OR have common bits set or not.
         return MI.getOpcode() == TargetOpcode::G_ADD;
      
    llvm_unreachable("add_and_or_is_add should have returned");
  }
  case GICXXPred_MI_Predicate_ldaxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_ldaxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_ldaxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_ldaxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_ldxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_ldxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_ldxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_ldxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_stlxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_stlxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_stlxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_stlxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_stxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_stxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_stxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_stxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex0 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex0_timm,
  GICXXPred_I64_Predicate_VectorIndex1,
  GICXXPred_I64_Predicate_VectorIndex1_timm,
  GICXXPred_I64_Predicate_VectorIndex032b,
  GICXXPred_I64_Predicate_VectorIndex032b_timm,
  GICXXPred_I64_Predicate_VectorIndex132b,
  GICXXPred_I64_Predicate_VectorIndex132b_timm,
  GICXXPred_I64_Predicate_VectorIndexB,
  GICXXPred_I64_Predicate_VectorIndexB32b,
  GICXXPred_I64_Predicate_VectorIndexB32b_timm,
  GICXXPred_I64_Predicate_VectorIndexB_timm,
  GICXXPred_I64_Predicate_VectorIndexD,
  GICXXPred_I64_Predicate_VectorIndexD32b,
  GICXXPred_I64_Predicate_VectorIndexD32b_timm,
  GICXXPred_I64_Predicate_VectorIndexD_timm,
  GICXXPred_I64_Predicate_VectorIndexH,
  GICXXPred_I64_Predicate_VectorIndexH32b,
  GICXXPred_I64_Predicate_VectorIndexH32b_timm,
  GICXXPred_I64_Predicate_VectorIndexH_timm,
  GICXXPred_I64_Predicate_VectorIndexS,
  GICXXPred_I64_Predicate_VectorIndexS32b,
  GICXXPred_I64_Predicate_VectorIndexS32b_timm,
  GICXXPred_I64_Predicate_VectorIndexS_timm,
  GICXXPred_I64_Predicate_complexrotateop,
  GICXXPred_I64_Predicate_complexrotateopodd,
  GICXXPred_I64_Predicate_i64imm_32bit,
  GICXXPred_I64_Predicate_i64imm_32bit_tgt,
  GICXXPred_I64_Predicate_imm0_1,
  GICXXPred_I64_Predicate_imm0_3,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_127,
  GICXXPred_I64_Predicate_imm0_127_64b,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm32_0_15,
  GICXXPred_I64_Predicate_imm32_0_31,
  GICXXPred_I64_Predicate_imm64_0_65535,
  GICXXPred_I64_Predicate_maski8_or_more,
  GICXXPred_I64_Predicate_maski16_or_more,
  GICXXPred_I64_Predicate_rprfop,
  GICXXPred_I64_Predicate_s64imm_32bit,
  GICXXPred_I64_Predicate_simm4s1,
  GICXXPred_I64_Predicate_simm4s2,
  GICXXPred_I64_Predicate_simm4s3,
  GICXXPred_I64_Predicate_simm4s4,
  GICXXPred_I64_Predicate_simm4s16,
  GICXXPred_I64_Predicate_simm4s32,
  GICXXPred_I64_Predicate_simm5_8b,
  GICXXPred_I64_Predicate_simm5_8b_tgt,
  GICXXPred_I64_Predicate_simm5_16b,
  GICXXPred_I64_Predicate_simm5_16b_tgt,
  GICXXPred_I64_Predicate_simm5_32b,
  GICXXPred_I64_Predicate_simm5_32b_tgt,
  GICXXPred_I64_Predicate_simm5_64b,
  GICXXPred_I64_Predicate_simm5_64b_tgt,
  GICXXPred_I64_Predicate_simm6_32b,
  GICXXPred_I64_Predicate_simm6s1,
  GICXXPred_I64_Predicate_simm8_32b,
  GICXXPred_I64_Predicate_simm8_64b,
  GICXXPred_I64_Predicate_simm9,
  GICXXPred_I64_Predicate_sme_elm_idx0_0,
  GICXXPred_I64_Predicate_sme_elm_idx0_1,
  GICXXPred_I64_Predicate_sme_elm_idx0_3,
  GICXXPred_I64_Predicate_sme_elm_idx0_7,
  GICXXPred_I64_Predicate_sme_elm_idx0_15,
  GICXXPred_I64_Predicate_svcr_op,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_b,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_b_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_d,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_d_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_h,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_h_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_q,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_q_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_s,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_s_timm,
  GICXXPred_I64_Predicate_sve_incdec_imm,
  GICXXPred_I64_Predicate_sve_pred_enum,
  GICXXPred_I64_Predicate_sve_prfop,
  GICXXPred_I64_Predicate_sve_vec_len_specifier_enum,
  GICXXPred_I64_Predicate_tbz_imm0_31_diag,
  GICXXPred_I64_Predicate_tbz_imm0_31_nodiag,
  GICXXPred_I64_Predicate_tbz_imm32_63,
  GICXXPred_I64_Predicate_timm0_1,
  GICXXPred_I64_Predicate_timm0_31,
  GICXXPred_I64_Predicate_timm0_63,
  GICXXPred_I64_Predicate_timm32_0_0,
  GICXXPred_I64_Predicate_timm32_0_1,
  GICXXPred_I64_Predicate_timm32_0_3,
  GICXXPred_I64_Predicate_timm32_0_7,
  GICXXPred_I64_Predicate_timm32_0_15,
  GICXXPred_I64_Predicate_timm32_0_31,
  GICXXPred_I64_Predicate_timm32_0_255,
  GICXXPred_I64_Predicate_timm32_0_65535,
  GICXXPred_I64_Predicate_timm32_1_1,
  GICXXPred_I64_Predicate_timm32_1_3,
  GICXXPred_I64_Predicate_timm32_1_7,
  GICXXPred_I64_Predicate_timm64_0_65535,
  GICXXPred_I64_Predicate_tuimm5s2,
  GICXXPred_I64_Predicate_tuimm5s4,
  GICXXPred_I64_Predicate_tuimm5s8,
  GICXXPred_I64_Predicate_tvecshiftL8,
  GICXXPred_I64_Predicate_tvecshiftL16,
  GICXXPred_I64_Predicate_tvecshiftL32,
  GICXXPred_I64_Predicate_tvecshiftL64,
  GICXXPred_I64_Predicate_tvecshiftR8,
  GICXXPred_I64_Predicate_tvecshiftR16,
  GICXXPred_I64_Predicate_tvecshiftR32,
  GICXXPred_I64_Predicate_tvecshiftR64,
  GICXXPred_I64_Predicate_ubsan_trap_imm,
  GICXXPred_I64_Predicate_uimm0s2range,
  GICXXPred_I64_Predicate_uimm0s4range,
  GICXXPred_I64_Predicate_uimm1s2range,
  GICXXPred_I64_Predicate_uimm1s4range,
  GICXXPred_I64_Predicate_uimm2s2range,
  GICXXPred_I64_Predicate_uimm2s4range,
  GICXXPred_I64_Predicate_uimm3s2range,
  GICXXPred_I64_Predicate_uimm3s8,
  GICXXPred_I64_Predicate_uimm5s2,
  GICXXPred_I64_Predicate_uimm5s4,
  GICXXPred_I64_Predicate_uimm5s8,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6s1,
  GICXXPred_I64_Predicate_uimm6s2,
  GICXXPred_I64_Predicate_uimm6s4,
  GICXXPred_I64_Predicate_uimm6s8,
  GICXXPred_I64_Predicate_uimm6s16,
  GICXXPred_I64_Predicate_uimm8_32b,
  GICXXPred_I64_Predicate_uimm8_64b,
  GICXXPred_I64_Predicate_uimm16,
  GICXXPred_I64_Predicate_vecshiftL8,
  GICXXPred_I64_Predicate_vecshiftL16,
  GICXXPred_I64_Predicate_vecshiftL32,
  GICXXPred_I64_Predicate_vecshiftL64,
  GICXXPred_I64_Predicate_vecshiftR8,
  GICXXPred_I64_Predicate_vecshiftR16,
  GICXXPred_I64_Predicate_vecshiftR16Narrow,
  GICXXPred_I64_Predicate_vecshiftR32,
  GICXXPred_I64_Predicate_vecshiftR32Narrow,
  GICXXPred_I64_Predicate_vecshiftR64,
  GICXXPred_I64_Predicate_vecshiftR64Narrow,
};
bool AArch64InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex0: {
     return ((uint64_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex0_timm: {
     return ((uint64_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex1: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex1_timm: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex032b: {
     return ((uint32_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex032b_timm: {
     return ((uint32_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex132b: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex132b_timm: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB32b: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB32b_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD32b: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD32b_timm: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD_timm: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH32b: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH32b_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS32b: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS32b_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_complexrotateop: {
     return Imm >= 0 && Imm <= 270;  
  }
  case GICXXPred_I64_Predicate_complexrotateopodd: {
     return Imm >= 0 && Imm <= 270;  
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit_tgt: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  case GICXXPred_I64_Predicate_imm0_1: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_imm0_3: {
    
      return ((uint64_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
      return ((uint64_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
      return ((uint64_t)Imm) < 16;
    
  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
      return ((uint64_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
      return ((uint64_t)Imm) < 64;
    
  }
  case GICXXPred_I64_Predicate_imm0_127: {
    
      return ((uint32_t)Imm) < 128;
    
  }
  case GICXXPred_I64_Predicate_imm0_127_64b: {
    
      return ((uint64_t)Imm) < 128;
    
  }
  case GICXXPred_I64_Predicate_imm0_255: {
    
      return ((uint32_t)Imm) < 256;
    
  }
  case GICXXPred_I64_Predicate_imm32_0_15: {
    
      return ((uint32_t)Imm) < 16;
    
  }
  case GICXXPred_I64_Predicate_imm32_0_31: {
    
      return ((uint64_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_imm64_0_65535: {
    
      return ((uint64_t)Imm) < 65536;
    
  }
  case GICXXPred_I64_Predicate_maski8_or_more: {
     return (Imm & 0xff) == 0xff; 
  }
  case GICXXPred_I64_Predicate_maski16_or_more: {
     return (Imm & 0xffff) == 0xffff; 
  }
  case GICXXPred_I64_Predicate_rprfop: {
    
        return (((uint32_t)Imm) <= 63);
      
  }
  case GICXXPred_I64_Predicate_s64imm_32bit: {
    
      int64_t Imm64 = static_cast<int64_t>(Imm);
      return Imm64 >= std::numeric_limits<int32_t>::min() &&
             Imm64 <= std::numeric_limits<int32_t>::max();
    
    llvm_unreachable("s64imm_32bit should have returned");
  }
  case GICXXPred_I64_Predicate_simm4s1: {
     return Imm >=-8  && Imm <= 7; 
  }
  case GICXXPred_I64_Predicate_simm4s2: {
     return Imm >=-16  && Imm <= 14 && (Imm % 2) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s3: {
     return Imm >=-24  && Imm <= 21 && (Imm % 3) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s4: {
     return Imm >=-32  && Imm <= 28 && (Imm % 4) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s16: {
     return Imm >=-128  && Imm <= 112 && (Imm % 16) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s32: {
     return Imm >=-256  && Imm <= 224 && (Imm % 32) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm5_8b: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_8b_tgt: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_16b: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_16b_tgt: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_32b: {
     return Imm >= -16 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_32b_tgt: {
     return (int32_t)Imm >= -16 && (int32_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_64b: {
     return Imm >= -16 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_64b_tgt: {
     return (int64_t)Imm >= -16 && (int64_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm6_32b: {
     return Imm >= -32 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_simm6s1: {
     return Imm >= -32 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_simm8_32b: {
     return Imm >= -128 && Imm < 128; 
  }
  case GICXXPred_I64_Predicate_simm8_64b: {
     return Imm >= -128 && Imm < 128; 
  }
  case GICXXPred_I64_Predicate_simm9: {
     return Imm >= -256 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_0: {
    
      return ((uint32_t)Imm) == 0;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_1: {
    
      return ((uint32_t)Imm) <= 1;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_3: {
    
      return ((uint32_t)Imm) <= 3;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_7: {
    
      return ((uint32_t)Imm) <= 7;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_15: {
    
      return ((uint32_t)Imm) <= 15;
    
  }
  case GICXXPred_I64_Predicate_svcr_op: {
    
        return AArch64SVCR::lookupSVCRByEncoding(Imm) != nullptr;
      
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_b: {
     return ((uint64_t)Imm) < 64; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_b_timm: {
     return ((uint64_t)Imm) < 64; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_d: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_d_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_h: {
     return ((uint64_t)Imm) < 32; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_h_timm: {
     return ((uint64_t)Imm) < 32; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_q: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_q_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_s: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_s_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_sve_incdec_imm: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_sve_pred_enum: {
    
      return (((uint32_t)Imm) < 32);
      
  }
  case GICXXPred_I64_Predicate_sve_prfop: {
    
        return (((uint32_t)Imm) <= 15);
      
  }
  case GICXXPred_I64_Predicate_sve_vec_len_specifier_enum: {
    
      return (((uint32_t)Imm) < 2);
      
  }
  case GICXXPred_I64_Predicate_tbz_imm0_31_diag: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_tbz_imm0_31_nodiag: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_tbz_imm32_63: {
    
      return (((uint32_t)Imm) > 31) && (((uint32_t)Imm) < 64);
    
  }
  case GICXXPred_I64_Predicate_timm0_1: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_timm0_31: {
    
      return ((uint64_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_timm0_63: {
    
      return ((uint64_t)Imm) < 64;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_0: {
    
      return ((uint32_t)Imm) == 0;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_1: {
    
      return ((uint32_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_3: {
    
      return ((uint32_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_7: {
    
      return ((uint32_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_15: {
    
      return ((uint32_t)Imm) < 16;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_31: {
    
      return ((uint32_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_255: {
    
      return ((uint32_t)Imm) < 256;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_65535: {
    
      return ((uint32_t)Imm) < 65536;
    
  }
  case GICXXPred_I64_Predicate_timm32_1_1: {
    
        return ((uint32_t)Imm) == 1;
    
  }
  case GICXXPred_I64_Predicate_timm32_1_3: {
    
      return ((uint32_t)Imm) > 0 && ((uint32_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_timm32_1_7: {
    
      return ((uint32_t)Imm) > 0 && ((uint32_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_timm64_0_65535: {
    
      return ((uint64_t)Imm) < 65536;
    
  }
  case GICXXPred_I64_Predicate_tuimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_tuimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_tuimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_tvecshiftL8: {
    
      return (((uint32_t)Imm) < 8);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftL16: {
    
      return (((uint32_t)Imm) < 16);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftL32: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftL64: {
    
      return (((uint32_t)Imm) < 64);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR8: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR16: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR32: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR64: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);
    
  }
  case GICXXPred_I64_Predicate_ubsan_trap_imm: {
    
      return isUInt<8>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm0s2range: {
     return Imm == 0; 
  }
  case GICXXPred_I64_Predicate_uimm0s4range: {
     return Imm == 0; 
  }
  case GICXXPred_I64_Predicate_uimm1s2range: {
     return Imm >= 0 && Imm <= 2 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm1s4range: {
     return Imm >= 0 && Imm <= 4 && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm2s2range: {
     return Imm >= 0 && Imm <= 6 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm2s4range: {
     return Imm >= 0 && Imm <= 12 && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm3s2range: {
     return Imm >= 0 && Imm <= 14 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm3s8: {
     return Imm >= 0 && Imm <= 56 && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6s1: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6s2: {
     return Imm >= 0 && Imm < (64*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s4: {
     return Imm >= 0 && Imm < (64*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s8: {
     return Imm >= 0 && Imm < (64*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s16: {
     return Imm >= 0 && Imm < (64*16) && ((Imm % 16) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm8_32b: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_uimm8_64b: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_uimm16: {
    return Imm >= 0 && Imm < 65536;
  }
  case GICXXPred_I64_Predicate_vecshiftL8: {
    
      return (((uint32_t)Imm) < 8);
    
  }
  case GICXXPred_I64_Predicate_vecshiftL16: {
    
      return (((uint32_t)Imm) < 16);
    
  }
  case GICXXPred_I64_Predicate_vecshiftL32: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_vecshiftL64: {
    
      return (((uint32_t)Imm) < 64);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR8: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR16: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR16Narrow: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR32: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR32Narrow: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR64: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR64Narrow: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm16,
  GICXXPred_APFloat_Predicate_fpimm32,
  GICXXPred_APFloat_Predicate_fpimm32SIMDModImmType4,
  GICXXPred_APFloat_Predicate_fpimm64,
  GICXXPred_APFloat_Predicate_fpimm_half,
  GICXXPred_APFloat_Predicate_fpimm_minus0,
  GICXXPred_APFloat_Predicate_fpimm_one,
  GICXXPred_APFloat_Predicate_fpimm_two,
  GICXXPred_APFloat_Predicate_fpimmbf16,
  GICXXPred_APFloat_Predicate_simdimmtype10,
};
bool AArch64InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm16: {
    
          return AArch64_AM::getFP16Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_fpimm32: {
    
          return AArch64_AM::getFP32Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_fpimm32SIMDModImmType4: {
    
          uint64_t Enc = Imm.bitcastToAPInt().getZExtValue();
          return Enc != 0 && AArch64_AM::isAdvSIMDModImmType4(Enc << 32 | Enc);
        
    llvm_unreachable("fpimm32SIMDModImmType4 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm64: {
    
          return AArch64_AM::getFP64Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_fpimm_half: {
    
      return Imm.isExactlyValue(+0.5);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_minus0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_one: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_two: {
    
      return Imm.isExactlyValue(+2.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmbf16: {
    
          return AArch64_AM::getFP16Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_simdimmtype10: {
    
          return AArch64_AM::isAdvSIMDModImmType10(
                     Imm.bitcastToAPInt().getZExtValue());
        
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_logical_imm32 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_logical_imm64,
};
bool AArch64InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_logical_imm32: {
    
      return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 32);
    
  }
  case GICXXPred_APInt_Predicate_logical_imm64: {
    
      return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 64);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AArch64InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderFPImm16,
  GICR_renderFPImm32,
  GICR_renderFPImm32SIMDModImmType4,
  GICR_renderFPImm64,
  GICR_renderLogicalImm32,
  GICR_renderLogicalImm64,
  GICR_renderTruncImm,
  GICR_renderUbsanTrap,
};
AArch64InstructionSelector::CustomRendererFn
AArch64InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AArch64InstructionSelector::renderFPImm16,
  &AArch64InstructionSelector::renderFPImm32,
  &AArch64InstructionSelector::renderFPImm32SIMDModImmType4,
  &AArch64InstructionSelector::renderFPImm64,
  &AArch64InstructionSelector::renderLogicalImm32,
  &AArch64InstructionSelector::renderLogicalImm64,
  &AArch64InstructionSelector::renderTruncImm,
  &AArch64InstructionSelector::renderUbsanTrap,
};

bool AArch64InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AArch64InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AArch64InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AArch64InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(802), /*)*//*default:*//*Label 146*/ GIMT_Encode4(357622),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(3014),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(22013),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(29003),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(30375),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(30457), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 5*/ GIMT_Encode4(30539),
    /*TargetOpcode::G_OR*//*Label 6*/ GIMT_Encode4(34221),
    /*TargetOpcode::G_XOR*//*Label 7*/ GIMT_Encode4(46268), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ GIMT_Encode4(50459), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 9*/ GIMT_Encode4(60840), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(72596),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ GIMT_Encode4(74019),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 12*/ GIMT_Encode4(75442),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 13*/ GIMT_Encode4(75710),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 14*/ GIMT_Encode4(75860),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 15*/ GIMT_Encode4(77283), GIMT_Encode4(0),
    /*TargetOpcode::G_LOAD*//*Label 16*/ GIMT_Encode4(77316),
    /*TargetOpcode::G_SEXTLOAD*//*Label 17*/ GIMT_Encode4(86382),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 18*/ GIMT_Encode4(87474), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 19*/ GIMT_Encode4(90488), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 20*/ GIMT_Encode4(104565),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 21*/ GIMT_Encode4(105916),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 22*/ GIMT_Encode4(106908),
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 23*/ GIMT_Encode4(107900),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 24*/ GIMT_Encode4(109392), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 25*/ GIMT_Encode4(110884),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 26*/ GIMT_Encode4(111876),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 27*/ GIMT_Encode4(112868),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 28*/ GIMT_Encode4(113860),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 29*/ GIMT_Encode4(114852),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 30*/ GIMT_Encode4(115844), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 31*/ GIMT_Encode4(116836), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 32*/ GIMT_Encode4(116887),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 33*/ GIMT_Encode4(221357), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 34*/ GIMT_Encode4(229185),
    /*TargetOpcode::G_TRUNC*//*Label 35*/ GIMT_Encode4(229475),
    /*TargetOpcode::G_CONSTANT*//*Label 36*/ GIMT_Encode4(230678),
    /*TargetOpcode::G_FCONSTANT*//*Label 37*/ GIMT_Encode4(230798), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 38*/ GIMT_Encode4(231087), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 39*/ GIMT_Encode4(232985),
    /*TargetOpcode::G_SHL*//*Label 40*/ GIMT_Encode4(235764),
    /*TargetOpcode::G_LSHR*//*Label 41*/ GIMT_Encode4(236089),
    /*TargetOpcode::G_ASHR*//*Label 42*/ GIMT_Encode4(236482), GIMT_Encode4(0),
    /*TargetOpcode::G_FSHR*//*Label 43*/ GIMT_Encode4(236990),
    /*TargetOpcode::G_ROTR*//*Label 44*/ GIMT_Encode4(237120), GIMT_Encode4(0),
    /*TargetOpcode::G_ICMP*//*Label 45*/ GIMT_Encode4(237613), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 46*/ GIMT_Encode4(242189), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 47*/ GIMT_Encode4(242675),
    /*TargetOpcode::G_SMULH*//*Label 48*/ GIMT_Encode4(243159),
    /*TargetOpcode::G_UADDSAT*//*Label 49*/ GIMT_Encode4(243643),
    /*TargetOpcode::G_SADDSAT*//*Label 50*/ GIMT_Encode4(244073),
    /*TargetOpcode::G_USUBSAT*//*Label 51*/ GIMT_Encode4(244503),
    /*TargetOpcode::G_SSUBSAT*//*Label 52*/ GIMT_Encode4(244933), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 53*/ GIMT_Encode4(245363),
    /*TargetOpcode::G_FSUB*//*Label 54*/ GIMT_Encode4(248037),
    /*TargetOpcode::G_FMUL*//*Label 55*/ GIMT_Encode4(250073),
    /*TargetOpcode::G_FMA*//*Label 56*/ GIMT_Encode4(255139), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 57*/ GIMT_Encode4(267389), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 58*/ GIMT_Encode4(269282),
    /*TargetOpcode::G_FPEXT*//*Label 59*/ GIMT_Encode4(272108),
    /*TargetOpcode::G_FPTRUNC*//*Label 60*/ GIMT_Encode4(272372),
    /*TargetOpcode::G_FPTOSI*//*Label 61*/ GIMT_Encode4(272700),
    /*TargetOpcode::G_FPTOUI*//*Label 62*/ GIMT_Encode4(273763),
    /*TargetOpcode::G_SITOFP*//*Label 63*/ GIMT_Encode4(274826),
    /*TargetOpcode::G_UITOFP*//*Label 64*/ GIMT_Encode4(279000),
    /*TargetOpcode::G_FABS*//*Label 65*/ GIMT_Encode4(282655), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 66*/ GIMT_Encode4(283725),
    /*TargetOpcode::G_FMAXNUM*//*Label 67*/ GIMT_Encode4(284103), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 68*/ GIMT_Encode4(284481),
    /*TargetOpcode::G_FMAXIMUM*//*Label 69*/ GIMT_Encode4(284859), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 70*/ GIMT_Encode4(285237),
    /*TargetOpcode::G_SMAX*//*Label 71*/ GIMT_Encode4(285641),
    /*TargetOpcode::G_UMIN*//*Label 72*/ GIMT_Encode4(286045),
    /*TargetOpcode::G_UMAX*//*Label 73*/ GIMT_Encode4(286449),
    /*TargetOpcode::G_ABS*//*Label 74*/ GIMT_Encode4(286853),
    /*TargetOpcode::G_LROUND*//*Label 75*/ GIMT_Encode4(287668),
    /*TargetOpcode::G_LLROUND*//*Label 76*/ GIMT_Encode4(287834),
    /*TargetOpcode::G_BR*//*Label 77*/ GIMT_Encode4(287933), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 78*/ GIMT_Encode4(287949),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 79*/ GIMT_Encode4(303316), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 80*/ GIMT_Encode4(306867), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 81*/ GIMT_Encode4(307019), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 82*/ GIMT_Encode4(307693),
    /*TargetOpcode::G_BSWAP*//*Label 83*/ GIMT_Encode4(307853),
    /*TargetOpcode::G_BITREVERSE*//*Label 84*/ GIMT_Encode4(308167),
    /*TargetOpcode::G_FCEIL*//*Label 85*/ GIMT_Encode4(308321), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 86*/ GIMT_Encode4(309744),
    /*TargetOpcode::G_FFLOOR*//*Label 87*/ GIMT_Encode4(310044),
    /*TargetOpcode::G_FRINT*//*Label 88*/ GIMT_Encode4(311467),
    /*TargetOpcode::G_FNEARBYINT*//*Label 89*/ GIMT_Encode4(312890), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 90*/ GIMT_Encode4(314313),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 91*/ GIMT_Encode4(316716),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 92*/ GIMT_Encode4(318609),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 93*/ GIMT_Encode4(323280), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 94*/ GIMT_Encode4(325173),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 95*/ GIMT_Encode4(336757), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 96*/ GIMT_Encode4(337057),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 97*/ GIMT_Encode4(337071),
    /*TargetOpcode::G_UBSANTRAP*//*Label 98*/ GIMT_Encode4(337092), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_FADD*//*Label 99*/ GIMT_Encode4(337117), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_FMAX*//*Label 100*/ GIMT_Encode4(337427),
    /*TargetOpcode::G_VECREDUCE_FMIN*//*Label 101*/ GIMT_Encode4(337598),
    /*TargetOpcode::G_VECREDUCE_FMAXIMUM*//*Label 102*/ GIMT_Encode4(337769),
    /*TargetOpcode::G_VECREDUCE_FMINIMUM*//*Label 103*/ GIMT_Encode4(337940),
    /*TargetOpcode::G_VECREDUCE_ADD*//*Label 104*/ GIMT_Encode4(338111), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_SMAX*//*Label 105*/ GIMT_Encode4(339240),
    /*TargetOpcode::G_VECREDUCE_SMIN*//*Label 106*/ GIMT_Encode4(339443),
    /*TargetOpcode::G_VECREDUCE_UMAX*//*Label 107*/ GIMT_Encode4(339646),
    /*TargetOpcode::G_VECREDUCE_UMIN*//*Label 108*/ GIMT_Encode4(339849), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AArch64::G_AARCH64_PREFETCH*//*Label 109*/ GIMT_Encode4(340052), GIMT_Encode4(0),
    /*AArch64::G_BSP*//*Label 110*/ GIMT_Encode4(340192),
    /*AArch64::G_DUP*//*Label 111*/ GIMT_Encode4(340732),
    /*AArch64::G_DUPLANE16*//*Label 112*/ GIMT_Encode4(342823),
    /*AArch64::G_DUPLANE32*//*Label 113*/ GIMT_Encode4(343144),
    /*AArch64::G_DUPLANE64*//*Label 114*/ GIMT_Encode4(343399),
    /*AArch64::G_DUPLANE8*//*Label 115*/ GIMT_Encode4(343545),
    /*AArch64::G_EXT*//*Label 116*/ GIMT_Encode4(343724),
    /*AArch64::G_FCMEQ*//*Label 117*/ GIMT_Encode4(344595),
    /*AArch64::G_FCMEQZ*//*Label 118*/ GIMT_Encode4(344934),
    /*AArch64::G_FCMGE*//*Label 119*/ GIMT_Encode4(345164),
    /*AArch64::G_FCMGEZ*//*Label 120*/ GIMT_Encode4(345828),
    /*AArch64::G_FCMGT*//*Label 121*/ GIMT_Encode4(346058),
    /*AArch64::G_FCMGTZ*//*Label 122*/ GIMT_Encode4(346722),
    /*AArch64::G_FCMLEZ*//*Label 123*/ GIMT_Encode4(346952),
    /*AArch64::G_FCMLTZ*//*Label 124*/ GIMT_Encode4(347182),
    /*AArch64::G_REV16*//*Label 125*/ GIMT_Encode4(347412),
    /*AArch64::G_REV32*//*Label 126*/ GIMT_Encode4(347490),
    /*AArch64::G_REV64*//*Label 127*/ GIMT_Encode4(347690),
    /*AArch64::G_SADDLP*//*Label 128*/ GIMT_Encode4(347988),
    /*AArch64::G_SADDLV*//*Label 129*/ GIMT_Encode4(348194),
    /*AArch64::G_SDOT*//*Label 130*/ GIMT_Encode4(348515),
    /*AArch64::G_SITOF*//*Label 131*/ GIMT_Encode4(348885),
    /*AArch64::G_SMULL*//*Label 132*/ GIMT_Encode4(349002),
    /*AArch64::G_TRN1*//*Label 133*/ GIMT_Encode4(349523),
    /*AArch64::G_TRN2*//*Label 134*/ GIMT_Encode4(350348),
    /*AArch64::G_UADDLP*//*Label 135*/ GIMT_Encode4(351173),
    /*AArch64::G_UADDLV*//*Label 136*/ GIMT_Encode4(351379),
    /*AArch64::G_UDOT*//*Label 137*/ GIMT_Encode4(352160),
    /*AArch64::G_UITOF*//*Label 138*/ GIMT_Encode4(352530),
    /*AArch64::G_UMULL*//*Label 139*/ GIMT_Encode4(352647),
    /*AArch64::G_UZP1*//*Label 140*/ GIMT_Encode4(353168),
    /*AArch64::G_UZP2*//*Label 141*/ GIMT_Encode4(353993),
    /*AArch64::G_VASHR*//*Label 142*/ GIMT_Encode4(354818),
    /*AArch64::G_VLSHR*//*Label 143*/ GIMT_Encode4(355516),
    /*AArch64::G_ZIP1*//*Label 144*/ GIMT_Encode4(355972),
    /*AArch64::G_ZIP2*//*Label 145*/ GIMT_Encode4(356797),
    // Label 0: @3014
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(24), /*)*//*default:*//*Label 160*/ GIMT_Encode4(22012),
    /*GILLT_s32*//*Label 147*/ GIMT_Encode4(3113),
    /*GILLT_s64*//*Label 148*/ GIMT_Encode4(4636), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 149*/ GIMT_Encode4(7230),
    /*GILLT_v2s64*//*Label 150*/ GIMT_Encode4(8230),
    /*GILLT_v4s16*//*Label 151*/ GIMT_Encode4(12128),
    /*GILLT_v4s32*//*Label 152*/ GIMT_Encode4(13128),
    /*GILLT_v8s8*//*Label 153*/ GIMT_Encode4(17302),
    /*GILLT_v8s16*//*Label 154*/ GIMT_Encode4(17886),
    /*GILLT_v16s8*//*Label 155*/ GIMT_Encode4(21324), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_nxv2s64*//*Label 156*/ GIMT_Encode4(21908), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_nxv4s32*//*Label 157*/ GIMT_Encode4(21934), GIMT_Encode4(0),
    /*GILLT_nxv8s16*//*Label 158*/ GIMT_Encode4(21960), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 159*/ GIMT_Encode4(21986),
    // Label 147: @3113
    GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(4635),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3157), // Rule ID 12450 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm32),
        // (add:{ *:[i32] } addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12450,
        GIR_EraseRootFromParent_Done,
      // Label 162: @3157
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3309), // Rule ID 12877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1148:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 12877,
        GIR_EraseRootFromParent_Done,
      // Label 163: @3309
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(3461), // Rule ID 14745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1150:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 14745,
        GIR_EraseRootFromParent_Done,
      // Label 164: @3461
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(3613), // Rule ID 14757 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1156:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 14757,
        GIR_EraseRootFromParent_Done,
      // Label 165: @3613
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(3765), // Rule ID 14769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1149:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 14769,
        GIR_EraseRootFromParent_Done,
      // Label 166: @3765
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3798), // Rule ID 102 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm32),
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 102,
        GIR_EraseRootFromParent_Done,
      // Label 167: @3798
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(3950), // Rule ID 2555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1148:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 2555,
        GIR_EraseRootFromParent_Done,
      // Label 168: @3950
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(4102), // Rule ID 9631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1150:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9631,
        GIR_EraseRootFromParent_Done,
      // Label 169: @4102
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(4254), // Rule ID 9643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1156:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9643,
        GIR_EraseRootFromParent_Done,
      // Label 170: @4254
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(4406), // Rule ID 9655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1149:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9655,
        GIR_EraseRootFromParent_Done,
      // Label 171: @4406
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(4439), // Rule ID 12454 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32_i32),
        // (add:{ *:[i32] } arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrx),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12454,
        GIR_EraseRootFromParent_Done,
      // Label 172: @4439
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(4475), // Rule ID 13017 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm32),
        // (add:{ *:[i32] } neg_addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32:{ *:[i32] }:$Rn)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13017,
        GIR_EraseRootFromParent_Done,
      // Label 173: @4475
      GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(4508), // Rule ID 108 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32_i32),
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrx),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 108,
        GIR_EraseRootFromParent_Done,
      // Label 174: @4508
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(4544), // Rule ID 3790 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm32),
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3790,
        GIR_EraseRootFromParent_Done,
      // Label 175: @4544
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(4577), // Rule ID 12452 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg32),
        // (add:{ *:[i32] } arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12452,
        GIR_EraseRootFromParent_Done,
      // Label 176: @4577
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(4610), // Rule ID 106 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg32),
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 106,
        GIR_EraseRootFromParent_Done,
      // Label 177: @4610
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(4634), // Rule ID 104 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ADDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 104,
        GIR_Done,
      // Label 178: @4634
      GIM_Reject,
    // Label 161: @4635
    GIM_Reject,
    // Label 148: @4636
    GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(7229),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(4715), // Rule ID 6602 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 0,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv2i64p),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 6602,
        GIR_EraseRootFromParent_Done,
      // Label 180: @4715
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(4783), // Rule ID 13188 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv2i64p),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13188,
        GIR_EraseRootFromParent_Done,
      // Label 181: @4783
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(4816), // Rule ID 12451 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm64),
        // (add:{ *:[i64] } addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12451,
        GIR_EraseRootFromParent_Done,
      // Label 182: @4816
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(4911), // Rule ID 3840 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3840,
        GIR_EraseRootFromParent_Done,
      // Label 183: @4911
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(5006), // Rule ID 3841 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3841,
        GIR_EraseRootFromParent_Done,
      // Label 184: @5006
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(5039), // Rule ID 103 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm64),
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 103,
        GIR_EraseRootFromParent_Done,
      // Label 185: @5039
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(5134), // Rule ID 13025 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13025,
        GIR_EraseRootFromParent_Done,
      // Label 186: @5134
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(5229), // Rule ID 13026 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13026,
        GIR_EraseRootFromParent_Done,
      // Label 187: @5229
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(5311), // Rule ID 12462 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12462,
        GIR_EraseRootFromParent_Done,
      // Label 188: @5311
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(5393), // Rule ID 12463 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12463,
        GIR_EraseRootFromParent_Done,
      // Label 189: @5393
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(5475), // Rule ID 134 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 134,
        GIR_EraseRootFromParent_Done,
      // Label 190: @5475
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(5557), // Rule ID 136 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 136,
        GIR_EraseRootFromParent_Done,
      // Label 191: @5557
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(5615), // Rule ID 12872 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1148:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12872,
        GIR_EraseRootFromParent_Done,
      // Label 192: @5615
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(5673), // Rule ID 14740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1150:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14740,
        GIR_EraseRootFromParent_Done,
      // Label 193: @5673
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(5731), // Rule ID 14752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1156:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14752,
        GIR_EraseRootFromParent_Done,
      // Label 194: @5731
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(5789), // Rule ID 14764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1149:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14764,
        GIR_EraseRootFromParent_Done,
      // Label 195: @5789
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(5847), // Rule ID 2552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1148:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2552,
        GIR_EraseRootFromParent_Done,
      // Label 196: @5847
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(5905), // Rule ID 9628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1150:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9628,
        GIR_EraseRootFromParent_Done,
      // Label 197: @5905
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(5963), // Rule ID 9640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1156:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9640,
        GIR_EraseRootFromParent_Done,
      // Label 198: @5963
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(6021), // Rule ID 9652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1149:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9652,
        GIR_EraseRootFromParent_Done,
      // Label 199: @6021
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(6054), // Rule ID 12455 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32to64_i64),
        // (add:{ *:[i64] } arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrx),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12455,
        GIR_EraseRootFromParent_Done,
      // Label 200: @6054
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(6090), // Rule ID 13018 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm64),
        // (add:{ *:[i64] } neg_addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64:{ *:[i64] }:$Rn)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13018,
        GIR_EraseRootFromParent_Done,
      // Label 201: @6090
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(6123), // Rule ID 109 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32to64_i64),
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrx),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 109,
        GIR_EraseRootFromParent_Done,
      // Label 202: @6123
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(6159), // Rule ID 3791 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm64),
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3791,
        GIR_EraseRootFromParent_Done,
      // Label 203: @6159
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(6192), // Rule ID 12453 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg64),
        // (add:{ *:[i64] } arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12453,
        GIR_EraseRootFromParent_Done,
      // Label 204: @6192
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(6225), // Rule ID 107 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg64),
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 107,
        GIR_EraseRootFromParent_Done,
      // Label 205: @6225
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(6281), // Rule ID 12561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 622:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12561,
        GIR_EraseRootFromParent_Done,
      // Label 206: @6281
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(6337), // Rule ID 12573 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 687:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12573,
        GIR_EraseRootFromParent_Done,
      // Label 207: @6337
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(6404), // Rule ID 12779 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12779,
        GIR_EraseRootFromParent_Done,
      // Label 208: @6404
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(6471), // Rule ID 13177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13177,
        GIR_EraseRootFromParent_Done,
      // Label 209: @6471
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(6538), // Rule ID 12782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12782,
        GIR_EraseRootFromParent_Done,
      // Label 210: @6538
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(6605), // Rule ID 13180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13180,
        GIR_EraseRootFromParent_Done,
      // Label 211: @6605
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(6661), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 622:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 984,
        GIR_EraseRootFromParent_Done,
      // Label 212: @6661
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(6717), // Rule ID 1045 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 687:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1045,
        GIR_EraseRootFromParent_Done,
      // Label 213: @6717
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(6784), // Rule ID 2106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2106,
        GIR_EraseRootFromParent_Done,
      // Label 214: @6784
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(6851), // Rule ID 5881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5881,
        GIR_EraseRootFromParent_Done,
      // Label 215: @6851
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(6918), // Rule ID 2115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2115,
        GIR_EraseRootFromParent_Done,
      // Label 216: @6918
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(6985), // Rule ID 5887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5887,
        GIR_EraseRootFromParent_Done,
      // Label 217: @6985
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(7033), // Rule ID 12560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } (AArch64saddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12560,
        GIR_EraseRootFromParent_Done,
      // Label 218: @7033
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(7081), // Rule ID 12572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } (AArch64uaddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12572,
        GIR_EraseRootFromParent_Done,
      // Label 219: @7081
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(7129), // Rule ID 983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (AArch64saddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 983,
        GIR_EraseRootFromParent_Done,
      // Label 220: @7129
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(7177), // Rule ID 1044 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (AArch64uaddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1044,
        GIR_EraseRootFromParent_Done,
      // Label 221: @7177
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(7201), // Rule ID 105 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ADDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDXrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 105,
        GIR_Done,
      // Label 222: @7201
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(7228), // Rule ID 1594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (ADDv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv1i64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1594,
        GIR_Done,
      // Label 223: @7228
      GIM_Reject,
    // Label 179: @7229
    GIM_Reject,
    // Label 149: @7230
    GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(8229),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(7310), // Rule ID 12595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 621:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12595,
        GIR_EraseRootFromParent_Done,
      // Label 225: @7310
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(7379), // Rule ID 12607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 686:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12607,
        GIR_EraseRootFromParent_Done,
      // Label 226: @7379
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(7435), // Rule ID 12557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 622:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12557,
        GIR_EraseRootFromParent_Done,
      // Label 227: @7435
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(7491), // Rule ID 12569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 687:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12569,
        GIR_EraseRootFromParent_Done,
      // Label 228: @7491
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(7558), // Rule ID 12799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12799,
        GIR_EraseRootFromParent_Done,
      // Label 229: @7558
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(7625), // Rule ID 12820 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12820,
        GIR_EraseRootFromParent_Done,
      // Label 230: @7625
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(7694), // Rule ID 1352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 621:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1352,
        GIR_EraseRootFromParent_Done,
      // Label 231: @7694
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(7763), // Rule ID 1475 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 686:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1475,
        GIR_EraseRootFromParent_Done,
      // Label 232: @7763
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(7819), // Rule ID 980 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 622:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 980,
        GIR_EraseRootFromParent_Done,
      // Label 233: @7819
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(7875), // Rule ID 1041 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 687:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1041,
        GIR_EraseRootFromParent_Done,
      // Label 234: @7875
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(7942), // Rule ID 2223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2223,
        GIR_EraseRootFromParent_Done,
      // Label 235: @7942
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(8009), // Rule ID 2282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2282,
        GIR_EraseRootFromParent_Done,
      // Label 236: @8009
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(8057), // Rule ID 12556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (AArch64saddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12556,
        GIR_EraseRootFromParent_Done,
      // Label 237: @8057
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(8105), // Rule ID 12568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (AArch64uaddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12568,
        GIR_EraseRootFromParent_Done,
      // Label 238: @8105
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(8153), // Rule ID 979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64saddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 979,
        GIR_EraseRootFromParent_Done,
      // Label 239: @8153
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(8201), // Rule ID 1040 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64uaddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1040,
        GIR_EraseRootFromParent_Done,
      // Label 240: @8201
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(8228), // Rule ID 1091 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (ADDv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv2i32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1091,
        GIR_Done,
      // Label 241: @8228
      GIM_Reject,
    // Label 224: @8229
    GIM_Reject,
    // Label 150: @8230
    GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(12127),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(8328), // Rule ID 12639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 621:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12639,
        GIR_EraseRootFromParent_Done,
      // Label 243: @8328
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(8415), // Rule ID 12663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 686:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12663,
        GIR_EraseRootFromParent_Done,
      // Label 244: @8415
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(8502), // Rule ID 1686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 621:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))))  =>  (SABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1686,
        GIR_EraseRootFromParent_Done,
      // Label 245: @8502
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(8589), // Rule ID 1764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 686:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))))  =>  (UABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1764,
        GIR_EraseRootFromParent_Done,
      // Label 246: @8589
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(8658), // Rule ID 1788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1788,
        GIR_EraseRootFromParent_Done,
      // Label 247: @8658
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(8727), // Rule ID 1787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1787,
        GIR_EraseRootFromParent_Done,
      // Label 248: @8727
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(8796), // Rule ID 1704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1704,
        GIR_EraseRootFromParent_Done,
      // Label 249: @8796
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(8865), // Rule ID 1786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1786,
        GIR_EraseRootFromParent_Done,
      // Label 250: @8865
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(8934), // Rule ID 1785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1785,
        GIR_EraseRootFromParent_Done,
      // Label 251: @8934
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(9001), // Rule ID 12651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12651,
        GIR_EraseRootFromParent_Done,
      // Label 252: @9001
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(9068), // Rule ID 12681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12681,
        GIR_EraseRootFromParent_Done,
      // Label 253: @9068
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(9135), // Rule ID 1716 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1716,
        GIR_EraseRootFromParent_Done,
      // Label 254: @9135
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(9202), // Rule ID 1806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1806,
        GIR_EraseRootFromParent_Done,
      // Label 255: @9202
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(9283), // Rule ID 12637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 621:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12637,
        GIR_EraseRootFromParent_Done,
      // Label 256: @9283
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(9364), // Rule ID 12661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 686:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12661,
        GIR_EraseRootFromParent_Done,
      // Label 257: @9364
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(9445), // Rule ID 1684 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 621:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1684,
        GIR_EraseRootFromParent_Done,
      // Label 258: @9445
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(9526), // Rule ID 1762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 686:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1762,
        GIR_EraseRootFromParent_Done,
      // Label 259: @9526
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(9618), // Rule ID 12732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12732,
        GIR_EraseRootFromParent_Done,
      // Label 260: @9618
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(9710), // Rule ID 12731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12731,
        GIR_EraseRootFromParent_Done,
      // Label 261: @9710
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(9802), // Rule ID 12762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12762,
        GIR_EraseRootFromParent_Done,
      // Label 262: @9802
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(9894), // Rule ID 12761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12761,
        GIR_EraseRootFromParent_Done,
      // Label 263: @9894
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(9986), // Rule ID 12730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn))  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12730,
        GIR_EraseRootFromParent_Done,
      // Label 264: @9986
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(10078), // Rule ID 2028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)))  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2028,
        GIR_EraseRootFromParent_Done,
      // Label 265: @10078
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(10170), // Rule ID 12760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn))  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12760,
        GIR_EraseRootFromParent_Done,
      // Label 266: @10170
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(10262), // Rule ID 2080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)))  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2080,
        GIR_EraseRootFromParent_Done,
      // Label 267: @10262
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(10313), // Rule ID 12675 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12675,
        GIR_EraseRootFromParent_Done,
      // Label 268: @10313
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(10364), // Rule ID 12645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12645,
        GIR_EraseRootFromParent_Done,
      // Label 269: @10364
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(10415), // Rule ID 12674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12674,
        GIR_EraseRootFromParent_Done,
      // Label 270: @10415
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(10466), // Rule ID 1800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1800,
        GIR_EraseRootFromParent_Done,
      // Label 271: @10466
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(10517), // Rule ID 1710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1710,
        GIR_EraseRootFromParent_Done,
      // Label 272: @10517
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(10568), // Rule ID 1799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1799,
        GIR_EraseRootFromParent_Done,
      // Label 273: @10568
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(10624), // Rule ID 12563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 622:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12563,
        GIR_EraseRootFromParent_Done,
      // Label 274: @10624
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(10680), // Rule ID 12575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 687:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12575,
        GIR_EraseRootFromParent_Done,
      // Label 275: @10680
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(10747), // Rule ID 12803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12803,
        GIR_EraseRootFromParent_Done,
      // Label 276: @10747
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(10814), // Rule ID 12824 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12824,
        GIR_EraseRootFromParent_Done,
      // Label 277: @10814
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(10870), // Rule ID 986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 622:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 986,
        GIR_EraseRootFromParent_Done,
      // Label 278: @10870
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(10926), // Rule ID 1047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 687:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1047,
        GIR_EraseRootFromParent_Done,
      // Label 279: @10926
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(10993), // Rule ID 2227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2227,
        GIR_EraseRootFromParent_Done,
      // Label 280: @10993
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(11060), // Rule ID 2286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2286,
        GIR_EraseRootFromParent_Done,
      // Label 281: @11060
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(11123), // Rule ID 1784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1784,
        GIR_EraseRootFromParent_Done,
      // Label 282: @11123
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(11186), // Rule ID 1783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1783,
        GIR_EraseRootFromParent_Done,
      // Label 283: @11186
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(11249), // Rule ID 1703 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1703,
        GIR_EraseRootFromParent_Done,
      // Label 284: @11249
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(11312), // Rule ID 1782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1782,
        GIR_EraseRootFromParent_Done,
      // Label 285: @11312
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(11375), // Rule ID 1781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1781,
        GIR_EraseRootFromParent_Done,
      // Label 286: @11375
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(11436), // Rule ID 12650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12650,
        GIR_EraseRootFromParent_Done,
      // Label 287: @11436
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(11497), // Rule ID 12680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12680,
        GIR_EraseRootFromParent_Done,
      // Label 288: @11497
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(11545), // Rule ID 12673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12673,
        GIR_EraseRootFromParent_Done,
      // Label 289: @11545
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(11593), // Rule ID 12562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (AArch64saddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12562,
        GIR_EraseRootFromParent_Done,
      // Label 290: @11593
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(11641), // Rule ID 12644 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12644,
        GIR_EraseRootFromParent_Done,
      // Label 291: @11641
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(11689), // Rule ID 12574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (AArch64uaddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12574,
        GIR_EraseRootFromParent_Done,
      // Label 292: @11689
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(11737), // Rule ID 12672 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12672,
        GIR_EraseRootFromParent_Done,
      // Label 293: @11737
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(11798), // Rule ID 1715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1715,
        GIR_EraseRootFromParent_Done,
      // Label 294: @11798
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(11859), // Rule ID 1805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1805,
        GIR_EraseRootFromParent_Done,
      // Label 295: @11859
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(11907), // Rule ID 1798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1798,
        GIR_EraseRootFromParent_Done,
      // Label 296: @11907
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(11955), // Rule ID 985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64saddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 985,
        GIR_EraseRootFromParent_Done,
      // Label 297: @11955
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(12003), // Rule ID 1709 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1709,
        GIR_EraseRootFromParent_Done,
      // Label 298: @12003
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(12051), // Rule ID 1046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64uaddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1046,
        GIR_EraseRootFromParent_Done,
      // Label 299: @12051
      GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(12099), // Rule ID 1797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1797,
        GIR_EraseRootFromParent_Done,
      // Label 300: @12099
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(12126), // Rule ID 1093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (ADDv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv2i64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1093,
        GIR_Done,
      // Label 301: @12126
      GIM_Reject,
    // Label 242: @12127
    GIM_Reject,
    // Label 151: @12128
    GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(13127),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(12208), // Rule ID 12591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 621:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12591,
        GIR_EraseRootFromParent_Done,
      // Label 303: @12208
      GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(12277), // Rule ID 12603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 686:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12603,
        GIR_EraseRootFromParent_Done,
      // Label 304: @12277
      GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(12333), // Rule ID 12553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 622:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12553,
        GIR_EraseRootFromParent_Done,
      // Label 305: @12333
      GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(12389), // Rule ID 12565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 687:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12565,
        GIR_EraseRootFromParent_Done,
      // Label 306: @12389
      GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(12456), // Rule ID 12795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i16] } (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12795,
        GIR_EraseRootFromParent_Done,
      // Label 307: @12456
      GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(12523), // Rule ID 12816 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i16] } (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12816,
        GIR_EraseRootFromParent_Done,
      // Label 308: @12523
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(12592), // Rule ID 1348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 621:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1348,
        GIR_EraseRootFromParent_Done,
      // Label 309: @12592
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(12661), // Rule ID 1471 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 686:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1471,
        GIR_EraseRootFromParent_Done,
      // Label 310: @12661
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(12717), // Rule ID 976 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 622:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 976,
        GIR_EraseRootFromParent_Done,
      // Label 311: @12717
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(12773), // Rule ID 1037 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 687:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1037,
        GIR_EraseRootFromParent_Done,
      // Label 312: @12773
      GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(12840), // Rule ID 2219 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2219,
        GIR_EraseRootFromParent_Done,
      // Label 313: @12840
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(12907), // Rule ID 2278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2278,
        GIR_EraseRootFromParent_Done,
      // Label 314: @12907
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(12955), // Rule ID 12552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (AArch64saddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12552,
        GIR_EraseRootFromParent_Done,
      // Label 315: @12955
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(13003), // Rule ID 12564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (AArch64uaddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12564,
        GIR_EraseRootFromParent_Done,
      // Label 316: @13003
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(13051), // Rule ID 975 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64saddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 975,
        GIR_EraseRootFromParent_Done,
      // Label 317: @13051
      GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(13099), // Rule ID 1036 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64uaddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1036,
        GIR_EraseRootFromParent_Done,
      // Label 318: @13099
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(13126), // Rule ID 1089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (ADDv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv4i16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1089,
        GIR_Done,
      // Label 319: @13126
      GIM_Reject,
    // Label 302: @13127
    GIM_Reject,
    // Label 152: @13128
    GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(17301),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(13226), // Rule ID 12635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 621:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12635,
        GIR_EraseRootFromParent_Done,
      // Label 321: @13226
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(13313), // Rule ID 12659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 686:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12659,
        GIR_EraseRootFromParent_Done,
      // Label 322: @13313
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(13400), // Rule ID 1682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 621:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))))  =>  (SABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1682,
        GIR_EraseRootFromParent_Done,
      // Label 323: @13400
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(13487), // Rule ID 1760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 686:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))))  =>  (UABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1760,
        GIR_EraseRootFromParent_Done,
      // Label 324: @13487
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(13556), // Rule ID 1780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1780,
        GIR_EraseRootFromParent_Done,
      // Label 325: @13556
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(13625), // Rule ID 1779 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1779,
        GIR_EraseRootFromParent_Done,
      // Label 326: @13625
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(13694), // Rule ID 1702 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1702,
        GIR_EraseRootFromParent_Done,
      // Label 327: @13694
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(13763), // Rule ID 1778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1778,
        GIR_EraseRootFromParent_Done,
      // Label 328: @13763
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(13832), // Rule ID 1777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1777,
        GIR_EraseRootFromParent_Done,
      // Label 329: @13832
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(13899), // Rule ID 12649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12649,
        GIR_EraseRootFromParent_Done,
      // Label 330: @13899
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(13966), // Rule ID 12679 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12679,
        GIR_EraseRootFromParent_Done,
      // Label 331: @13966
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(14033), // Rule ID 1714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1714,
        GIR_EraseRootFromParent_Done,
      // Label 332: @14033
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(14100), // Rule ID 1804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1804,
        GIR_EraseRootFromParent_Done,
      // Label 333: @14100
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(14181), // Rule ID 12633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 621:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12633,
        GIR_EraseRootFromParent_Done,
      // Label 334: @14181
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(14262), // Rule ID 12657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 686:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12657,
        GIR_EraseRootFromParent_Done,
      // Label 335: @14262
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(14343), // Rule ID 1680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 621:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1680,
        GIR_EraseRootFromParent_Done,
      // Label 336: @14343
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(14424), // Rule ID 1758 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 686:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1758,
        GIR_EraseRootFromParent_Done,
      // Label 337: @14424
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(14516), // Rule ID 12723 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12723,
        GIR_EraseRootFromParent_Done,
      // Label 338: @14516
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(14608), // Rule ID 12722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12722,
        GIR_EraseRootFromParent_Done,
      // Label 339: @14608
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(14700), // Rule ID 12753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12753,
        GIR_EraseRootFromParent_Done,
      // Label 340: @14700
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(14792), // Rule ID 12752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12752,
        GIR_EraseRootFromParent_Done,
      // Label 341: @14792
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(14884), // Rule ID 12721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn))  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12721,
        GIR_EraseRootFromParent_Done,
      // Label 342: @14884
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(14976), // Rule ID 2025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)))  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2025,
        GIR_EraseRootFromParent_Done,
      // Label 343: @14976
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(15068), // Rule ID 12751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn))  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12751,
        GIR_EraseRootFromParent_Done,
      // Label 344: @15068
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(15160), // Rule ID 2077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)))  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2077,
        GIR_EraseRootFromParent_Done,
      // Label 345: @15160
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(15211), // Rule ID 12671 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12671,
        GIR_EraseRootFromParent_Done,
      // Label 346: @15211
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(15262), // Rule ID 12643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12643,
        GIR_EraseRootFromParent_Done,
      // Label 347: @15262
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(15313), // Rule ID 12670 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12670,
        GIR_EraseRootFromParent_Done,
      // Label 348: @15313
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(15364), // Rule ID 1796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1796,
        GIR_EraseRootFromParent_Done,
      // Label 349: @15364
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(15415), // Rule ID 1708 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1708,
        GIR_EraseRootFromParent_Done,
      // Label 350: @15415
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(15466), // Rule ID 1795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1795,
        GIR_EraseRootFromParent_Done,
      // Label 351: @15466
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(15535), // Rule ID 12597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 621:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12597,
        GIR_EraseRootFromParent_Done,
      // Label 352: @15535
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(15604), // Rule ID 12609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 686:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12609,
        GIR_EraseRootFromParent_Done,
      // Label 353: @15604
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(15660), // Rule ID 12559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 622:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12559,
        GIR_EraseRootFromParent_Done,
      // Label 354: @15660
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(15716), // Rule ID 12571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 687:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12571,
        GIR_EraseRootFromParent_Done,
      // Label 355: @15716
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(15783), // Rule ID 12801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12801,
        GIR_EraseRootFromParent_Done,
      // Label 356: @15783
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(15850), // Rule ID 12822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12822,
        GIR_EraseRootFromParent_Done,
      // Label 357: @15850
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(15919), // Rule ID 1354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 621:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1354,
        GIR_EraseRootFromParent_Done,
      // Label 358: @15919
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(15988), // Rule ID 1477 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 686:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1477,
        GIR_EraseRootFromParent_Done,
      // Label 359: @15988
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(16044), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 622:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 982,
        GIR_EraseRootFromParent_Done,
      // Label 360: @16044
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(16100), // Rule ID 1043 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 687:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1043,
        GIR_EraseRootFromParent_Done,
      // Label 361: @16100
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(16167), // Rule ID 2225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2225,
        GIR_EraseRootFromParent_Done,
      // Label 362: @16167
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(16234), // Rule ID 2284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2284,
        GIR_EraseRootFromParent_Done,
      // Label 363: @16234
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(16297), // Rule ID 1776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1776,
        GIR_EraseRootFromParent_Done,
      // Label 364: @16297
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(16360), // Rule ID 1775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1775,
        GIR_EraseRootFromParent_Done,
      // Label 365: @16360
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(16423), // Rule ID 1701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1701,
        GIR_EraseRootFromParent_Done,
      // Label 366: @16423
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(16486), // Rule ID 1774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1774,
        GIR_EraseRootFromParent_Done,
      // Label 367: @16486
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(16549), // Rule ID 1773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1773,
        GIR_EraseRootFromParent_Done,
      // Label 368: @16549
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(16610), // Rule ID 12648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12648,
        GIR_EraseRootFromParent_Done,
      // Label 369: @16610
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(16671), // Rule ID 12678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12678,
        GIR_EraseRootFromParent_Done,
      // Label 370: @16671
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(16719), // Rule ID 12669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12669,
        GIR_EraseRootFromParent_Done,
      // Label 371: @16719
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(16767), // Rule ID 12558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (AArch64saddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12558,
        GIR_EraseRootFromParent_Done,
      // Label 372: @16767
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(16815), // Rule ID 12642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12642,
        GIR_EraseRootFromParent_Done,
      // Label 373: @16815
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(16863), // Rule ID 12570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (AArch64uaddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12570,
        GIR_EraseRootFromParent_Done,
      // Label 374: @16863
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(16911), // Rule ID 12668 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12668,
        GIR_EraseRootFromParent_Done,
      // Label 375: @16911
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(16972), // Rule ID 1713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1713,
        GIR_EraseRootFromParent_Done,
      // Label 376: @16972
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(17033), // Rule ID 1803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1803,
        GIR_EraseRootFromParent_Done,
      // Label 377: @17033
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(17081), // Rule ID 1794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1794,
        GIR_EraseRootFromParent_Done,
      // Label 378: @17081
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(17129), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64saddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 981,
        GIR_EraseRootFromParent_Done,
      // Label 379: @17129
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(17177), // Rule ID 1707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1707,
        GIR_EraseRootFromParent_Done,
      // Label 380: @17177
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(17225), // Rule ID 1042 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64uaddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1042,
        GIR_EraseRootFromParent_Done,
      // Label 381: @17225
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(17273), // Rule ID 1793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1793,
        GIR_EraseRootFromParent_Done,
      // Label 382: @17273
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(17300), // Rule ID 1092 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (ADDv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv4i32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1092,
        GIR_Done,
      // Label 383: @17300
      GIM_Reject,
    // Label 320: @17301
    GIM_Reject,
    // Label 153: @17302
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(17885),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(17382), // Rule ID 12587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 621:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12587,
        GIR_EraseRootFromParent_Done,
      // Label 385: @17382
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(17451), // Rule ID 12599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 686:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12599,
        GIR_EraseRootFromParent_Done,
      // Label 386: @17451
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(17518), // Rule ID 12791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i8] } (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12791,
        GIR_EraseRootFromParent_Done,
      // Label 387: @17518
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(17585), // Rule ID 12812 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i8] } (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12812,
        GIR_EraseRootFromParent_Done,
      // Label 388: @17585
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(17654), // Rule ID 1344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 621:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1344,
        GIR_EraseRootFromParent_Done,
      // Label 389: @17654
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(17723), // Rule ID 1467 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 686:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1467,
        GIR_EraseRootFromParent_Done,
      // Label 390: @17723
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(17790), // Rule ID 2215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2215,
        GIR_EraseRootFromParent_Done,
      // Label 391: @17790
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(17857), // Rule ID 2274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2274,
        GIR_EraseRootFromParent_Done,
      // Label 392: @17857
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(17884), // Rule ID 1087 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ADDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1087,
        GIR_Done,
      // Label 393: @17884
      GIM_Reject,
    // Label 384: @17885
    GIM_Reject,
    // Label 154: @17886
    GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(21323),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(17984), // Rule ID 12631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 621:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12631,
        GIR_EraseRootFromParent_Done,
      // Label 395: @17984
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(18071), // Rule ID 12655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 686:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12655,
        GIR_EraseRootFromParent_Done,
      // Label 396: @18071
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(18158), // Rule ID 1678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 621:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))))  =>  (SABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1678,
        GIR_EraseRootFromParent_Done,
      // Label 397: @18158
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(18245), // Rule ID 1756 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 686:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))))  =>  (UABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1756,
        GIR_EraseRootFromParent_Done,
      // Label 398: @18245
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(18314), // Rule ID 1772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1772,
        GIR_EraseRootFromParent_Done,
      // Label 399: @18314
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(18383), // Rule ID 1771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1771,
        GIR_EraseRootFromParent_Done,
      // Label 400: @18383
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(18452), // Rule ID 1700 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1700,
        GIR_EraseRootFromParent_Done,
      // Label 401: @18452
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(18521), // Rule ID 1770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1770,
        GIR_EraseRootFromParent_Done,
      // Label 402: @18521
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(18590), // Rule ID 1769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1769,
        GIR_EraseRootFromParent_Done,
      // Label 403: @18590
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(18657), // Rule ID 12647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (AArch64smull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12647,
        GIR_EraseRootFromParent_Done,
      // Label 404: @18657
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(18724), // Rule ID 12677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (AArch64umull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12677,
        GIR_EraseRootFromParent_Done,
      // Label 405: @18724
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(18791), // Rule ID 1712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64smull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1712,
        GIR_EraseRootFromParent_Done,
      // Label 406: @18791
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(18858), // Rule ID 1802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64umull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1802,
        GIR_EraseRootFromParent_Done,
      // Label 407: @18858
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(18939), // Rule ID 12629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 621:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12629,
        GIR_EraseRootFromParent_Done,
      // Label 408: @18939
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(19020), // Rule ID 12653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 686:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12653,
        GIR_EraseRootFromParent_Done,
      // Label 409: @19020
      GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(19101), // Rule ID 1676 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 621:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1676,
        GIR_EraseRootFromParent_Done,
      // Label 410: @19101
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(19182), // Rule ID 1754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 686:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1754,
        GIR_EraseRootFromParent_Done,
      // Label 411: @19182
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(19233), // Rule ID 12667 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12667,
        GIR_EraseRootFromParent_Done,
      // Label 412: @19233
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(19284), // Rule ID 12641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12641,
        GIR_EraseRootFromParent_Done,
      // Label 413: @19284
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(19335), // Rule ID 12666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12666,
        GIR_EraseRootFromParent_Done,
      // Label 414: @19335
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(19386), // Rule ID 1792 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1792,
        GIR_EraseRootFromParent_Done,
      // Label 415: @19386
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(19437), // Rule ID 1706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1706,
        GIR_EraseRootFromParent_Done,
      // Label 416: @19437
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(19488), // Rule ID 1791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1791,
        GIR_EraseRootFromParent_Done,
      // Label 417: @19488
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(19557), // Rule ID 12593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 621:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12593,
        GIR_EraseRootFromParent_Done,
      // Label 418: @19557
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(19626), // Rule ID 12605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 686:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12605,
        GIR_EraseRootFromParent_Done,
      // Label 419: @19626
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(19682), // Rule ID 12555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 622:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12555,
        GIR_EraseRootFromParent_Done,
      // Label 420: @19682
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(19738), // Rule ID 12567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 687:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12567,
        GIR_EraseRootFromParent_Done,
      // Label 421: @19738
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(19805), // Rule ID 12797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12797,
        GIR_EraseRootFromParent_Done,
      // Label 422: @19805
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(19872), // Rule ID 12818 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12818,
        GIR_EraseRootFromParent_Done,
      // Label 423: @19872
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(19941), // Rule ID 1350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 621:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1350,
        GIR_EraseRootFromParent_Done,
      // Label 424: @19941
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(20010), // Rule ID 1473 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 686:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1473,
        GIR_EraseRootFromParent_Done,
      // Label 425: @20010
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(20066), // Rule ID 978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 622:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 978,
        GIR_EraseRootFromParent_Done,
      // Label 426: @20066
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(20122), // Rule ID 1039 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 687:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1039,
        GIR_EraseRootFromParent_Done,
      // Label 427: @20122
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(20189), // Rule ID 2221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2221,
        GIR_EraseRootFromParent_Done,
      // Label 428: @20189
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(20256), // Rule ID 2280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i16_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2280,
        GIR_EraseRootFromParent_Done,
      // Label 429: @20256
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(20319), // Rule ID 1768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1768,
        GIR_EraseRootFromParent_Done,
      // Label 430: @20319
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(20382), // Rule ID 1767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1767,
        GIR_EraseRootFromParent_Done,
      // Label 431: @20382
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(20445), // Rule ID 1699 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1699,
        GIR_EraseRootFromParent_Done,
      // Label 432: @20445
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(20508), // Rule ID 1766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1766,
        GIR_EraseRootFromParent_Done,
      // Label 433: @20508
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(20571), // Rule ID 1765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1765,
        GIR_EraseRootFromParent_Done,
      // Label 434: @20571
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(20632), // Rule ID 12646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12646,
        GIR_EraseRootFromParent_Done,
      // Label 435: @20632
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(20693), // Rule ID 12676 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12676,
        GIR_EraseRootFromParent_Done,
      // Label 436: @20693
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(20741), // Rule ID 12665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12665,
        GIR_EraseRootFromParent_Done,
      // Label 437: @20741
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(20789), // Rule ID 12554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (AArch64saddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12554,
        GIR_EraseRootFromParent_Done,
      // Label 438: @20789
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(20837), // Rule ID 12640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12640,
        GIR_EraseRootFromParent_Done,
      // Label 439: @20837
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(20885), // Rule ID 12566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (AArch64uaddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12566,
        GIR_EraseRootFromParent_Done,
      // Label 440: @20885
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(20933), // Rule ID 12664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12664,
        GIR_EraseRootFromParent_Done,
      // Label 441: @20933
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(20994), // Rule ID 1711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1711,
        GIR_EraseRootFromParent_Done,
      // Label 442: @20994
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(21055), // Rule ID 1801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1801,
        GIR_EraseRootFromParent_Done,
      // Label 443: @21055
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(21103), // Rule ID 1790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1790,
        GIR_EraseRootFromParent_Done,
      // Label 444: @21103
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(21151), // Rule ID 977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64saddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 977,
        GIR_EraseRootFromParent_Done,
      // Label 445: @21151
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(21199), // Rule ID 1705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1705,
        GIR_EraseRootFromParent_Done,
      // Label 446: @21199
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(21247), // Rule ID 1038 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64uaddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1038,
        GIR_EraseRootFromParent_Done,
      // Label 447: @21247
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(21295), // Rule ID 1789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1789,
        GIR_EraseRootFromParent_Done,
      // Label 448: @21295
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(21322), // Rule ID 1090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (ADDv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv8i16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1090,
        GIR_Done,
      // Label 449: @21322
      GIM_Reject,
    // Label 394: @21323
    GIM_Reject,
    // Label 155: @21324
    GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(21907),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(21404), // Rule ID 12589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 621:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12589,
        GIR_EraseRootFromParent_Done,
      // Label 451: @21404
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(21473), // Rule ID 12601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 686:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12601,
        GIR_EraseRootFromParent_Done,
      // Label 452: @21473
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(21540), // Rule ID 12793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v16i8] } (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv16i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12793,
        GIR_EraseRootFromParent_Done,
      // Label 453: @21540
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(21607), // Rule ID 12814 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v16i8] } (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv16i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12814,
        GIR_EraseRootFromParent_Done,
      // Label 454: @21607
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(21676), // Rule ID 1346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 621:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1346,
        GIR_EraseRootFromParent_Done,
      // Label 455: @21676
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(21745), // Rule ID 1469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 686:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1469,
        GIR_EraseRootFromParent_Done,
      // Label 456: @21745
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(21812), // Rule ID 2217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv16i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2217,
        GIR_EraseRootFromParent_Done,
      // Label 457: @21812
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(21879), // Rule ID 2276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv16i8_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2276,
        GIR_EraseRootFromParent_Done,
      // Label 458: @21879
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(21906), // Rule ID 1088 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ADDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1088,
        GIR_Done,
      // Label 459: @21906
      GIM_Reject,
    // Label 450: @21907
    GIM_Reject,
    // Label 156: @21908
    GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(21933), // Rule ID 2684 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (add:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (ADD_ZZZ_D:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADD_ZZZ_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2684,
      GIR_Done,
    // Label 460: @21933
    GIM_Reject,
    // Label 157: @21934
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(21959), // Rule ID 2683 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (add:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (ADD_ZZZ_S:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADD_ZZZ_S),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2683,
      GIR_Done,
    // Label 461: @21959
    GIM_Reject,
    // Label 158: @21960
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(21985), // Rule ID 2682 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (add:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (ADD_ZZZ_H:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADD_ZZZ_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2682,
      GIR_Done,
    // Label 462: @21985
    GIM_Reject,
    // Label 159: @21986
    GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(22011), // Rule ID 2681 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (add:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (ADD_ZZZ_B:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADD_ZZZ_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2681,
      GIR_Done,
    // Label 463: @22011
    GIM_Reject,
    // Label 160: @22012
    GIM_Reject,
    // Label 1: @22013
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(24), /*)*//*default:*//*Label 477*/ GIMT_Encode4(29002),
    /*GILLT_s32*//*Label 464*/ GIMT_Encode4(22112),
    /*GILLT_s64*//*Label 465*/ GIMT_Encode4(22966), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 466*/ GIMT_Encode4(24270),
    /*GILLT_v2s64*//*Label 467*/ GIMT_Encode4(24345),
    /*GILLT_v4s16*//*Label 468*/ GIMT_Encode4(25905),
    /*GILLT_v4s32*//*Label 469*/ GIMT_Encode4(25980),
    /*GILLT_v8s8*//*Label 470*/ GIMT_Encode4(27540),
    /*GILLT_v8s16*//*Label 471*/ GIMT_Encode4(27615),
    /*GILLT_v16s8*//*Label 472*/ GIMT_Encode4(28823), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_nxv2s64*//*Label 473*/ GIMT_Encode4(28898), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_nxv4s32*//*Label 474*/ GIMT_Encode4(28924), GIMT_Encode4(0),
    /*GILLT_nxv8s16*//*Label 475*/ GIMT_Encode4(28950), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 476*/ GIMT_Encode4(28976),
    // Label 464: @22112
    GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(22965),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(22275), // Rule ID 9625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1148:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::DECB_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9625,
        GIR_EraseRootFromParent_Done,
      // Label 479: @22275
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(22427), // Rule ID 9637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1150:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::DECH_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9637,
        GIR_EraseRootFromParent_Done,
      // Label 480: @22427
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(22579), // Rule ID 9649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1156:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::DECW_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9649,
        GIR_EraseRootFromParent_Done,
      // Label 481: @22579
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(22731), // Rule ID 9661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1149:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm8, /*InsnID*/2, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::DECD_XPiI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        // GIR_Coverage, 9661,
        GIR_EraseRootFromParent_Done,
      // Label 482: @22731
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(22793), // Rule ID 3822 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MSUBWrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::WZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3822,
        GIR_EraseRootFromParent_Done,
      // Label 483: @22793
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(22829), // Rule ID 3787 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32_i32),
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)  =>  (SUBSWrx:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWrx),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // R3
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3787,
        GIR_EraseRootFromParent_Done,
      // Label 484: @22829
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(22862), // Rule ID 3792 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm32),
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3792,
        GIR_EraseRootFromParent_Done,
      // Label 485: @22862
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(22898), // Rule ID 3781 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm32),
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3781,
        GIR_EraseRootFromParent_Done,
      // Label 486: @22898
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(22934), // Rule ID 3785 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg32),
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)  =>  (SUBSWrs:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3785,
        GIR_EraseRootFromParent_Done,
      // Label 487: @22934
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(22964), // Rule ID 3783 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SUBSWrr:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBSWrr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AArch64::NZCV), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3783,
        GIR_Done,
      // Label 488: @22964
      GIM_Reject,
    // Label 478: @22965
    GIM_Reject,
    // Label 465: @22966
    GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(24269),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(23076), // Rule ID 3837 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3837,
        GIR_EraseRootFromParent_Done,
      // Label 490: @23076
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(23175), // Rule ID 3838 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3838,
        GIR_EraseRootFromParent_Done,
      // Label 491: @23175
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(23261), // Rule ID 3832 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3832,
        GIR_EraseRootFromParent_Done,
      // Label 492: @23261
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(23347), // Rule ID 3833 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3833,
        GIR_EraseRootFromParent_Done,
      // Label 493: @23347
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(23442), // Rule ID 3843 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3843,
        GIR_EraseRootFromParent_Done,
      // Label 494: @23442
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(23537), // Rule ID 3844 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3844,
        GIR_EraseRootFromParent_Done,
      // Label 495: @23537
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(23619), // Rule ID 135 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 135,
        GIR_EraseRootFromParent_Done,
      // Label 496: @23619
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(23701), // Rule ID 137 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMSUBLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 137,
        GIR_EraseRootFromParent_Done,
      // Label 497: @23701
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(23763), // Rule ID 3823 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MSUBXrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3823,
        GIR_EraseRootFromParent_Done,
      // Label 498: @23763
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(23821), // Rule ID 9622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1148:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::DECB_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9622,
        GIR_EraseRootFromParent_Done,
      // Label 499: @23821
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(23879), // Rule ID 9634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1150:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::DECH_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9634,
        GIR_EraseRootFromParent_Done,
      // Label 500: @23879
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(23937), // Rule ID 9646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1156:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::DECW_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9646,
        GIR_EraseRootFromParent_Done,
      // Label 501: @23937
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(23995), // Rule ID 9658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME_UseScalarIncVL),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1149:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::DECD_XPiI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9658,
        GIR_EraseRootFromParent_Done,
      // Label 502: @23995
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(24031), // Rule ID 3788 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32to64_i64),
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)  =>  (SUBSXrx:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXrx),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // R3
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3788,
        GIR_EraseRootFromParent_Done,
      // Label 503: @24031
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(24064), // Rule ID 3793 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm64),
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3793,
        GIR_EraseRootFromParent_Done,
      // Label 504: @24064
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(24100), // Rule ID 3782 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm64),
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3782,
        GIR_EraseRootFromParent_Done,
      // Label 505: @24100
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(24136), // Rule ID 3786 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg64),
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)  =>  (SUBSXrs:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3786,
        GIR_EraseRootFromParent_Done,
      // Label 506: @24136
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(24175), // Rule ID 1642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v1i64] } immAllZerosV:{ *:[v1i64] }, FPR64:{ *:[v1i64] }:$Rn)  =>  (NEGv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1642,
        GIR_EraseRootFromParent_Done,
      // Label 507: @24175
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(24211), // Rule ID 4895 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } immAllZerosV:{ *:[i64] }, FPR64:{ *:[i64] }:$Rn)  =>  (NEGv1i64:{ *:[i64] } FPR64:{ *:[i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv1i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4895,
        GIR_EraseRootFromParent_Done,
      // Label 508: @24211
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(24238), // Rule ID 1631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (sub:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (SUBv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv1i64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1631,
        GIR_Done,
      // Label 509: @24238
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(24268), // Rule ID 3784 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SUBSXrr:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBSXrr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AArch64::NZCV), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3784,
        GIR_Done,
      // Label 510: @24268
      GIM_Reject,
    // Label 489: @24269
    GIM_Reject,
    // Label 466: @24270
    GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(24344),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(24320), // Rule ID 956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i32] } immAllZerosV:{ *:[v2i32] }, V64:{ *:[v2i32] }:$Rn)  =>  (NEGv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 956,
        GIR_EraseRootFromParent_Done,
      // Label 512: @24320
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(24343), // Rule ID 1463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (sub:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (SUBv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv2i32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1463,
        GIR_Done,
      // Label 513: @24343
      GIM_Reject,
    // Label 511: @24344
    GIM_Reject,
    // Label 467: @24345
    GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(25904),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(24425), // Rule ID 1842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (USUBLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1842,
        GIR_EraseRootFromParent_Done,
      // Label 515: @24425
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(24490), // Rule ID 1841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (USUBLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1841,
        GIR_EraseRootFromParent_Done,
      // Label 516: @24490
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(24555), // Rule ID 1746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SSUBLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1746,
        GIR_EraseRootFromParent_Done,
      // Label 517: @24555
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(24620), // Rule ID 1840 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (USUBLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1840,
        GIR_EraseRootFromParent_Done,
      // Label 518: @24620
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(24685), // Rule ID 1839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (USUBLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1839,
        GIR_EraseRootFromParent_Done,
      // Label 519: @24685
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(24748), // Rule ID 1722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SMLSLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1722,
        GIR_EraseRootFromParent_Done,
      // Label 520: @24748
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(24811), // Rule ID 1812 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UMLSLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1812,
        GIR_EraseRootFromParent_Done,
      // Label 521: @24811
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(24899), // Rule ID 12740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn))  =>  (SMLSLv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12740,
        GIR_EraseRootFromParent_Done,
      // Label 522: @24899
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(24987), // Rule ID 2034 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)))  =>  (SMLSLv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2034,
        GIR_EraseRootFromParent_Done,
      // Label 523: @24987
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(25075), // Rule ID 12770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn))  =>  (UMLSLv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12770,
        GIR_EraseRootFromParent_Done,
      // Label 524: @25075
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(25163), // Rule ID 2086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)))  =>  (UMLSLv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2086,
        GIR_EraseRootFromParent_Done,
      // Label 525: @25163
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(25210), // Rule ID 1854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (USUBWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1854,
        GIR_EraseRootFromParent_Done,
      // Label 526: @25210
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(25257), // Rule ID 1752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SSUBWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1752,
        GIR_EraseRootFromParent_Done,
      // Label 527: @25257
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(25304), // Rule ID 1853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (USUBWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv4i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1853,
        GIR_EraseRootFromParent_Done,
      // Label 528: @25304
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(25363), // Rule ID 1838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1838,
        GIR_EraseRootFromParent_Done,
      // Label 529: @25363
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(25422), // Rule ID 1837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1837,
        GIR_EraseRootFromParent_Done,
      // Label 530: @25422
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(25481), // Rule ID 1745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1745,
        GIR_EraseRootFromParent_Done,
      // Label 531: @25481
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(25540), // Rule ID 1836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1836,
        GIR_EraseRootFromParent_Done,
      // Label 532: @25540
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(25599), // Rule ID 1835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1835,
        GIR_EraseRootFromParent_Done,
      // Label 533: @25599
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(25634), // Rule ID 958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, V128:{ *:[v2i64] }:$Rn)  =>  (NEGv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 958,
        GIR_EraseRootFromParent_Done,
      // Label 534: @25634
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(25691), // Rule ID 1721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLSLv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1721,
        GIR_EraseRootFromParent_Done,
      // Label 535: @25691
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(25748), // Rule ID 1811 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLSLv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1811,
        GIR_EraseRootFromParent_Done,
      // Label 536: @25748
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(25792), // Rule ID 1852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1852,
        GIR_EraseRootFromParent_Done,
      // Label 537: @25792
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(25836), // Rule ID 1751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1751,
        GIR_EraseRootFromParent_Done,
      // Label 538: @25836
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(25880), // Rule ID 1851 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv2i32_v2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1851,
        GIR_EraseRootFromParent_Done,
      // Label 539: @25880
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(25903), // Rule ID 1465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (SUBv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv2i64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1465,
        GIR_Done,
      // Label 540: @25903
      GIM_Reject,
    // Label 514: @25904
    GIM_Reject,
    // Label 468: @25905
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(25979),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(25955), // Rule ID 954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i16] } immAllZerosV:{ *:[v4i16] }, V64:{ *:[v4i16] }:$Rn)  =>  (NEGv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 954,
        GIR_EraseRootFromParent_Done,
      // Label 542: @25955
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(25978), // Rule ID 1461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (sub:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (SUBv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv4i16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1461,
        GIR_Done,
      // Label 543: @25978
      GIM_Reject,
    // Label 541: @25979
    GIM_Reject,
    // Label 469: @25980
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(27539),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(26060), // Rule ID 1834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (USUBLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1834,
        GIR_EraseRootFromParent_Done,
      // Label 545: @26060
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(26125), // Rule ID 1833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (USUBLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1833,
        GIR_EraseRootFromParent_Done,
      // Label 546: @26125
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(26190), // Rule ID 1744 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SSUBLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1744,
        GIR_EraseRootFromParent_Done,
      // Label 547: @26190
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(26255), // Rule ID 1832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (USUBLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1832,
        GIR_EraseRootFromParent_Done,
      // Label 548: @26255
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(26320), // Rule ID 1831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (USUBLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1831,
        GIR_EraseRootFromParent_Done,
      // Label 549: @26320
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(26383), // Rule ID 1720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SMLSLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1720,
        GIR_EraseRootFromParent_Done,
      // Label 550: @26383
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(26446), // Rule ID 1810 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UMLSLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1810,
        GIR_EraseRootFromParent_Done,
      // Label 551: @26446
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(26534), // Rule ID 12737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn))  =>  (SMLSLv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12737,
        GIR_EraseRootFromParent_Done,
      // Label 552: @26534
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(26622), // Rule ID 2031 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)))  =>  (SMLSLv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2031,
        GIR_EraseRootFromParent_Done,
      // Label 553: @26622
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(26710), // Rule ID 12767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn))  =>  (UMLSLv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12767,
        GIR_EraseRootFromParent_Done,
      // Label 554: @26710
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(26798), // Rule ID 2083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)))  =>  (UMLSLv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2083,
        GIR_EraseRootFromParent_Done,
      // Label 555: @26798
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(26845), // Rule ID 1850 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (USUBWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1850,
        GIR_EraseRootFromParent_Done,
      // Label 556: @26845
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(26892), // Rule ID 1750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SSUBWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1750,
        GIR_EraseRootFromParent_Done,
      // Label 557: @26892
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(26939), // Rule ID 1849 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (USUBWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv8i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1849,
        GIR_EraseRootFromParent_Done,
      // Label 558: @26939
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(26998), // Rule ID 1830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1830,
        GIR_EraseRootFromParent_Done,
      // Label 559: @26998
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(27057), // Rule ID 1829 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1829,
        GIR_EraseRootFromParent_Done,
      // Label 560: @27057
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(27116), // Rule ID 1743 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1743,
        GIR_EraseRootFromParent_Done,
      // Label 561: @27116
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(27175), // Rule ID 1828 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1828,
        GIR_EraseRootFromParent_Done,
      // Label 562: @27175
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(27234), // Rule ID 1827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1827,
        GIR_EraseRootFromParent_Done,
      // Label 563: @27234
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(27269), // Rule ID 957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, V128:{ *:[v4i32] }:$Rn)  =>  (NEGv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 957,
        GIR_EraseRootFromParent_Done,
      // Label 564: @27269
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(27326), // Rule ID 1719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLSLv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1719,
        GIR_EraseRootFromParent_Done,
      // Label 565: @27326
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(27383), // Rule ID 1809 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLSLv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1809,
        GIR_EraseRootFromParent_Done,
      // Label 566: @27383
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(27427), // Rule ID 1848 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1848,
        GIR_EraseRootFromParent_Done,
      // Label 567: @27427
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(27471), // Rule ID 1749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1749,
        GIR_EraseRootFromParent_Done,
      // Label 568: @27471
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(27515), // Rule ID 1847 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv4i16_v4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1847,
        GIR_EraseRootFromParent_Done,
      // Label 569: @27515
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(27538), // Rule ID 1464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (SUBv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv4i32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1464,
        GIR_Done,
      // Label 570: @27538
      GIM_Reject,
    // Label 544: @27539
    GIM_Reject,
    // Label 470: @27540
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(27614),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(27590), // Rule ID 952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i8] } immAllZerosV:{ *:[v8i8] }, V64:{ *:[v8i8] }:$Rn)  =>  (NEGv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 952,
        GIR_EraseRootFromParent_Done,
      // Label 572: @27590
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(27613), // Rule ID 1459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (sub:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (SUBv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1459,
        GIR_Done,
      // Label 573: @27613
      GIM_Reject,
    // Label 571: @27614
    GIM_Reject,
    // Label 471: @27615
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(28822),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(27695), // Rule ID 1826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (USUBLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1826,
        GIR_EraseRootFromParent_Done,
      // Label 575: @27695
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(27760), // Rule ID 1825 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (USUBLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1825,
        GIR_EraseRootFromParent_Done,
      // Label 576: @27760
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(27825), // Rule ID 1742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SSUBLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1742,
        GIR_EraseRootFromParent_Done,
      // Label 577: @27825
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(27890), // Rule ID 1824 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (USUBLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1824,
        GIR_EraseRootFromParent_Done,
      // Label 578: @27890
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(27955), // Rule ID 1823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (USUBLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1823,
        GIR_EraseRootFromParent_Done,
      // Label 579: @27955
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(28018), // Rule ID 1718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64smull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SMLSLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1718,
        GIR_EraseRootFromParent_Done,
      // Label 580: @28018
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(28081), // Rule ID 1808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64umull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UMLSLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1808,
        GIR_EraseRootFromParent_Done,
      // Label 581: @28081
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(28128), // Rule ID 1846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (USUBWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1846,
        GIR_EraseRootFromParent_Done,
      // Label 582: @28128
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(28175), // Rule ID 1748 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SSUBWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1748,
        GIR_EraseRootFromParent_Done,
      // Label 583: @28175
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(28222), // Rule ID 1845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (USUBWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv16i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1845,
        GIR_EraseRootFromParent_Done,
      // Label 584: @28222
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(28281), // Rule ID 1822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1822,
        GIR_EraseRootFromParent_Done,
      // Label 585: @28281
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(28340), // Rule ID 1821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1821,
        GIR_EraseRootFromParent_Done,
      // Label 586: @28340
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(28399), // Rule ID 1741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1741,
        GIR_EraseRootFromParent_Done,
      // Label 587: @28399
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(28458), // Rule ID 1820 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1820,
        GIR_EraseRootFromParent_Done,
      // Label 588: @28458
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(28517), // Rule ID 1819 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1819,
        GIR_EraseRootFromParent_Done,
      // Label 589: @28517
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(28552), // Rule ID 955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } immAllZerosV:{ *:[v8i16] }, V128:{ *:[v8i16] }:$Rn)  =>  (NEGv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 955,
        GIR_EraseRootFromParent_Done,
      // Label 590: @28552
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(28609), // Rule ID 1717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLSLv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLSLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1717,
        GIR_EraseRootFromParent_Done,
      // Label 591: @28609
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(28666), // Rule ID 1807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLSLv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLSLv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1807,
        GIR_EraseRootFromParent_Done,
      // Label 592: @28666
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(28710), // Rule ID 1844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1844,
        GIR_EraseRootFromParent_Done,
      // Label 593: @28710
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(28754), // Rule ID 1747 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSUBWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1747,
        GIR_EraseRootFromParent_Done,
      // Label 594: @28754
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(28798), // Rule ID 1843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USUBWv8i8_v8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1843,
        GIR_EraseRootFromParent_Done,
      // Label 595: @28798
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(28821), // Rule ID 1462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (SUBv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv8i16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1462,
        GIR_Done,
      // Label 596: @28821
      GIM_Reject,
    // Label 574: @28822
    GIM_Reject,
    // Label 472: @28823
    GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(28897),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(28873), // Rule ID 953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v16i8] } immAllZerosV:{ *:[v16i8] }, V128:{ *:[v16i8] }:$Rn)  =>  (NEGv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::NEGv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 953,
        GIR_EraseRootFromParent_Done,
      // Label 598: @28873
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(28896), // Rule ID 1460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (sub:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (SUBv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUBv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1460,
        GIR_Done,
      // Label 599: @28896
      GIM_Reject,
    // Label 597: @28897
    GIM_Reject,
    // Label 473: @28898
    GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(28923), // Rule ID 7103 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (sub:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (SUB_ZZZ_D:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUB_ZZZ_D),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 7103,
      GIR_Done,
    // Label 600: @28923
    GIM_Reject,
    // Label 474: @28924
    GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(28949), // Rule ID 7102 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (sub:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (SUB_ZZZ_S:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUB_ZZZ_S),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 7102,
      GIR_Done,
    // Label 601: @28949
    GIM_Reject,
    // Label 475: @28950
    GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(28975), // Rule ID 7101 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (sub:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (SUB_ZZZ_H:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUB_ZZZ_H),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 7101,
      GIR_Done,
    // Label 602: @28975
    GIM_Reject,
    // Label 476: @28976
    GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(29001), // Rule ID 7100 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (sub:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (SUB_ZZZ_B:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SUB_ZZZ_B),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 7100,
      GIR_Done,
    // Label 603: @29001
    GIM_Reject,
    // Label 477: @29002
    GIM_Reject,
    // Label 2: @29003
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(12), /*)*//*default:*//*Label 612*/ GIMT_Encode4(30374),
    /*GILLT_s32*//*Label 604*/ GIMT_Encode4(29054),
    /*GILLT_s64*//*Label 605*/ GIMT_Encode4(29211), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 606*/ GIMT_Encode4(29642), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 607*/ GIMT_Encode4(29808),
    /*GILLT_v4s32*//*Label 608*/ GIMT_Encode4(29974),
    /*GILLT_v8s8*//*Label 609*/ GIMT_Encode4(30140),
    /*GILLT_v8s16*//*Label 610*/ GIMT_Encode4(30174),
    /*GILLT_v16s8*//*Label 611*/ GIMT_Encode4(30340),
    // Label 604: @29054
    GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(29210),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(29124), // Rule ID 3824 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn), GPR32:{ *:[i32] }:$Rm)  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MSUBWrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::WZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3824,
        GIR_EraseRootFromParent_Done,
      // Label 614: @29124
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(29179), // Rule ID 13021 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MSUBWrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::WZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13021,
        GIR_EraseRootFromParent_Done,
      // Label 615: @29179
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(29209), // Rule ID 3820 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (MADDWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MADDWrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::WZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3820,
        GIR_EraseRootFromParent_Done,
      // Label 616: @29209
      GIM_Reject,
    // Label 613: @29210
    GIM_Reject,
    // Label 605: @29211
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(29641),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(29281), // Rule ID 3825 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn), GPR64:{ *:[i64] }:$Rm)  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MSUBXrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3825,
        GIR_EraseRootFromParent_Done,
      // Label 618: @29281
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(29336), // Rule ID 13022 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MSUBXrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13022,
        GIR_EraseRootFromParent_Done,
      // Label 619: @29336
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(29411), // Rule ID 3834 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3834,
        GIR_EraseRootFromParent_Done,
      // Label 620: @29411
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(29486), // Rule ID 3835 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3835,
        GIR_EraseRootFromParent_Done,
      // Label 621: @29486
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(29548), // Rule ID 3828 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3828,
        GIR_EraseRootFromParent_Done,
      // Label 622: @29548
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(29610), // Rule ID 3831 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3831,
        GIR_EraseRootFromParent_Done,
      // Label 623: @29610
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(29640), // Rule ID 3821 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (MADDXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MADDXrrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(AArch64::XZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3821,
        GIR_EraseRootFromParent_Done,
      // Label 624: @29640
      GIM_Reject,
    // Label 617: @29641
    GIM_Reject,
    // Label 606: @29642
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(29807),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(29720), // Rule ID 12716 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v2i32] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn)  =>  (MULv2i32_indexed:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12716,
        GIR_EraseRootFromParent_Done,
      // Label 626: @29720
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(29783), // Rule ID 2022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx))  =>  (MULv2i32_indexed:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv2i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2022,
        GIR_EraseRootFromParent_Done,
      // Label 627: @29783
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(29806), // Rule ID 1339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (MULv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::MULv2i32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1339,
        GIR_Done,
      // Label 628: @29806
      GIM_Reject,
    // Label 625: @29807
    GIM_Reject,
    // Label 607: @29808
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(29973),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(29886), // Rule ID 12713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v4i16] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn)  =>  (MULv4i16_indexed:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12713,
        GIR_EraseRootFromParent_Done,
      // Label 630: @29886
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(29949), // Rule ID 2019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx))  =>  (MULv4i16_indexed:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv4i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2019,
        GIR_EraseRootFromParent_Done,
      // Label 631: @29949
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(29972), // Rule ID 1337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (MULv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::MULv4i16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1337,
        GIR_Done,
      // Label 632: @29972
      GIM_Reject,
    // Label 629: @29973
    GIM_Reject,
    // Label 608: @29974
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(30139),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(30052), // Rule ID 12717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v4i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V128:{ *:[v4i32] }:$Rn)  =>  (MULv4i32_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv4i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12717,
        GIR_EraseRootFromParent_Done,
      // Label 634: @30052
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(30115), // Rule ID 2023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE32),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx))  =>  (MULv4i32_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv4i32_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2023,
        GIR_EraseRootFromParent_Done,
      // Label 635: @30115
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(30138), // Rule ID 1340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (MULv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::MULv4i32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1340,
        GIR_Done,
      // Label 636: @30138
      GIM_Reject,
    // Label 633: @30139
    GIM_Reject,
    // Label 609: @30140
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(30173), // Rule ID 1335 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      // (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (MULv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::MULv8i8),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1335,
      GIR_Done,
    // Label 637: @30173
    GIM_Reject,
    // Label 610: @30174
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(30339),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(30252), // Rule ID 12714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v8i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V128:{ *:[v8i16] }:$Rn)  =>  (MULv8i16_indexed:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv8i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12714,
        GIR_EraseRootFromParent_Done,
      // Label 639: @30252
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(30315), // Rule ID 2020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE16),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx))  =>  (MULv8i16_indexed:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::MULv8i16_indexed),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2020,
        GIR_EraseRootFromParent_Done,
      // Label 640: @30315
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(30338), // Rule ID 1338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (MULv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::MULv8i16),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1338,
        GIR_Done,
      // Label 641: @30338
      GIM_Reject,
    // Label 638: @30339
    GIM_Reject,
    // Label 611: @30340
    GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(30373), // Rule ID 1336 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      // (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (MULv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::MULv16i8),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1336,
      GIR_Done,
    // Label 642: @30373
    GIM_Reject,
    // Label 612: @30374
    GIM_Reject,
    // Label 3: @30375
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(4), /*)*//*default:*//*Label 645*/ GIMT_Encode4(30456),
    /*GILLT_s32*//*Label 643*/ GIMT_Encode4(30394),
    /*GILLT_s64*//*Label 644*/ GIMT_Encode4(30425),
    // Label 643: @30394
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(30424), // Rule ID 128 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      // (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SDIVWr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 128,
      GIR_Done,
    // Label 646: @30424
    GIM_Reject,
    // Label 644: @30425
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(30455), // Rule ID 129 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      // (sdiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::SDIVXr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 129,
      GIR_Done,
    // Label 647: @30455
    GIM_Reject,
    // Label 645: @30456
    GIM_Reject,
    // Label 4: @30457
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(4), /*)*//*default:*//*Label 650*/ GIMT_Encode4(30538),
    /*GILLT_s32*//*Label 648*/ GIMT_Encode4(30476),
    /*GILLT_s64*//*Label 649*/ GIMT_Encode4(30507),
    // Label 648: @30476
    GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(30506), // Rule ID 126 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
      // (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (UDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::UDIVWr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 126,
      GIR_Done,
    // Label 651: @30506
    GIM_Reject,
    // Label 649: @30507
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(30537), // Rule ID 127 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
      // (udiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (UDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::UDIVXr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 127,
      GIR_Done,
    // Label 652: @30537
    GIM_Reject,
    // Label 650: @30538
    GIM_Reject,
    // Label 5: @30539
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(24), /*)*//*default:*//*Label 671*/ GIMT_Encode4(34220),
    /*GILLT_s32*//*Label 653*/ GIMT_Encode4(30638),
    /*GILLT_s64*//*Label 654*/ GIMT_Encode4(31136), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 655*/ GIMT_Encode4(32571),
    /*GILLT_v2s64*//*Label 656*/ GIMT_Encode4(32731),
    /*GILLT_v4s16*//*Label 657*/ GIMT_Encode4(32891),
    /*GILLT_v4s32*//*Label 658*/ GIMT_Encode4(33051),
    /*GILLT_v8s8*//*Label 659*/ GIMT_Encode4(33211),
    /*GILLT_v8s16*//*Label 660*/ GIMT_Encode4(33371),
    /*GILLT_v16s8*//*Label 661*/ GIMT_Encode4(33531),
    /*GILLT_nxv1s1*//*Label 662*/ GIMT_Encode4(33691),
    /*GILLT_nxv2s1*//*Label 663*/ GIMT_Encode4(33776), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_nxv2s64*//*Label 664*/ GIMT_Encode4(33861),
    /*GILLT_nxv4s1*//*Label 665*/ GIMT_Encode4(33887), GIMT_Encode4(0),
    /*GILLT_nxv4s32*//*Label 666*/ GIMT_Encode4(33972),
    /*GILLT_nxv8s1*//*Label 667*/ GIMT_Encode4(33998),
    /*GILLT_nxv8s16*//*Label 668*/ GIMT_Encode4(34083),
    /*GILLT_nxv16s1*//*Label 669*/ GIMT_Encode4(34109),
    /*GILLT_nxv16s8*//*Label 670*/ GIMT_Encode4(34194),
    // Label 653: @30638
    GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(31135),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(30704), // Rule ID 12474 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (and:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12474,
        GIR_EraseRootFromParent_Done,
      // Label 673: @30704
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(30759), // Rule ID 173 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 173,
        GIR_EraseRootFromParent_Done,
      // Label 674: @30759
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(30828), // Rule ID 5314 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexB),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), 255:{ *:[i32] })  =>  (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMOVvi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5314,
        GIR_EraseRootFromParent_Done,
      // Label 675: @30828
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(30897), // Rule ID 5315 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 65535:{ *:[i32] })  =>  (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMOVvi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5315,
        GIR_EraseRootFromParent_Done,
      // Label 676: @30897
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(30950), // Rule ID 12472 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12472,
        GIR_EraseRootFromParent_Done,
      // Label 677: @30950
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(31003), // Rule ID 171 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 171,
        GIR_EraseRootFromParent_Done,
      // Label 678: @31003
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(31044), // Rule ID 153 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_logical_imm32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ANDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ANDWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderLogicalImm32), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 153,
        GIR_EraseRootFromParent_Done,
      // Label 679: @31044
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(31077), // Rule ID 12470 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (and:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ANDWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12470,
        GIR_EraseRootFromParent_Done,
      // Label 680: @31077
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(31110), // Rule ID 169 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ANDWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 169,
        GIR_EraseRootFromParent_Done,
      // Label 681: @31110
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(31134), // Rule ID 167 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ANDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 167,
        GIR_Done,
      // Label 682: @31134
      GIM_Reject,
    // Label 672: @31135
    GIM_Reject,
    // Label 654: @31136
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(32570),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(31202), // Rule ID 12475 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (and:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12475,
        GIR_EraseRootFromParent_Done,
      // Label 684: @31202
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(31257), // Rule ID 174 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 174,
        GIR_EraseRootFromParent_Done,
      // Label 685: @31257
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(31370), // Rule ID 5316 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexB),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)), 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMOVvi8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // idx
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 5316,
        GIR_EraseRootFromParent_Done,
      // Label 686: @31370
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(31483), // Rule ID 5317 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMOVvi16),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // idx
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 5317,
        GIR_EraseRootFromParent_Done,
      // Label 687: @31483
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(31582), // Rule ID 6822 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_ldxr),
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_ldxr_1),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 548:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::LDXRB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 6822,
        GIR_EraseRootFromParent_Done,
      // Label 688: @31582
      GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(31681), // Rule ID 6823 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_ldxr),
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_ldxr_2),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 548:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::LDXRH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 6823,
        GIR_EraseRootFromParent_Done,
      // Label 689: @31681
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(31780), // Rule ID 6824 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_ldxr),
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_ldxr_4),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 548:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::LDXRW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 6824,
        GIR_EraseRootFromParent_Done,
      // Label 690: @31780
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(31879), // Rule ID 6829 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_ldaxr),
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_ldaxr_1),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 545:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::LDAXRB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 6829,
        GIR_EraseRootFromParent_Done,
      // Label 691: @31879
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(31978), // Rule ID 6830 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_ldaxr),
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_ldaxr_2),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 545:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::LDAXRH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 6830,
        GIR_EraseRootFromParent_Done,
      // Label 692: @31978
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(32077), // Rule ID 6831 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_ldaxr),
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_ldaxr_4),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 545:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::LDAXRW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 6831,
        GIR_EraseRootFromParent_Done,
      // Label 693: @32077
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(32130), // Rule ID 12473 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICXrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12473,
        GIR_EraseRootFromParent_Done,
      // Label 694: @32130
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(32183), // Rule ID 172 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICXrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 172,
        GIR_EraseRootFromParent_Done,
      // Label 695: @32183
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(32283), // Rule ID 3873 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (ORRWrr:{ *:[i32] } WZR:{ *:[i32] }, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(16), // Rn
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ORRWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(AArch64::WZR), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
        // GIR_Coverage, 3873,
        GIR_EraseRootFromParent_Done,
      // Label 696: @32283
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(32324), // Rule ID 154 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_logical_imm64),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ANDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ANDXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderLogicalImm64), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 154,
        GIR_EraseRootFromParent_Done,
      // Label 697: @32324
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(32357), // Rule ID 12471 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (and:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ANDXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12471,
        GIR_EraseRootFromParent_Done,
      // Label 698: @32357
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(32390), // Rule ID 170 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ANDXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 170,
        GIR_EraseRootFromParent_Done,
      // Label 699: @32390
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(32454), // Rule ID 13136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$LHS)  =>  (BICv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13136,
        GIR_EraseRootFromParent_Done,
      // Label 700: @32454
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(32518), // Rule ID 4692 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }))  =>  (BICv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4692,
        GIR_EraseRootFromParent_Done,
      // Label 701: @32518
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(32542), // Rule ID 168 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ANDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDXrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 168,
        GIR_Done,
      // Label 702: @32542
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(32569), // Rule ID 2410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ANDv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2410,
        GIR_Done,
      // Label 703: @32569
      GIM_Reject,
    // Label 683: @32570
    GIM_Reject,
    // Label 655: @32571
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(32730),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(32646), // Rule ID 13135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$LHS)  =>  (BICv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13135,
        GIR_EraseRootFromParent_Done,
      // Label 705: @32646
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(32706), // Rule ID 4691 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }))  =>  (BICv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4691,
        GIR_EraseRootFromParent_Done,
      // Label 706: @32706
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(32729), // Rule ID 2409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ANDv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2409,
        GIR_Done,
      // Label 707: @32729
      GIM_Reject,
    // Label 704: @32730
    GIM_Reject,
    // Label 656: @32731
    GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(32890),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(32806), // Rule ID 13139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$LHS)  =>  (BICv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13139,
        GIR_EraseRootFromParent_Done,
      // Label 709: @32806
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(32866), // Rule ID 4695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }))  =>  (BICv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4695,
        GIR_EraseRootFromParent_Done,
      // Label 710: @32866
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(32889), // Rule ID 2413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ANDv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2413,
        GIR_Done,
      // Label 711: @32889
      GIM_Reject,
    // Label 708: @32890
    GIM_Reject,
    // Label 657: @32891
    GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(33050),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(32966), // Rule ID 13134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$LHS)  =>  (BICv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13134,
        GIR_EraseRootFromParent_Done,
      // Label 713: @32966
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(33026), // Rule ID 4690 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }))  =>  (BICv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4690,
        GIR_EraseRootFromParent_Done,
      // Label 714: @33026
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(33049), // Rule ID 2408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ANDv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2408,
        GIR_Done,
      // Label 715: @33049
      GIM_Reject,
    // Label 712: @33050
    GIM_Reject,
    // Label 658: @33051
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(33210),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(33126), // Rule ID 13138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$LHS)  =>  (BICv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13138,
        GIR_EraseRootFromParent_Done,
      // Label 717: @33126
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(33186), // Rule ID 4694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }))  =>  (BICv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4694,
        GIR_EraseRootFromParent_Done,
      // Label 718: @33186
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(33209), // Rule ID 2412 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ANDv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2412,
        GIR_Done,
      // Label 719: @33209
      GIM_Reject,
    // Label 716: @33210
    GIM_Reject,
    // Label 659: @33211
    GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(33370),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(33286), // Rule ID 12610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rn)  =>  (BICv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12610,
        GIR_EraseRootFromParent_Done,
      // Label 721: @33286
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(33346), // Rule ID 1584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }))  =>  (BICv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1584,
        GIR_EraseRootFromParent_Done,
      // Label 722: @33346
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(33369), // Rule ID 1582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ANDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1582,
        GIR_Done,
      // Label 723: @33369
      GIM_Reject,
    // Label 720: @33370
    GIM_Reject,
    // Label 660: @33371
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(33530),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(33446), // Rule ID 13137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$LHS)  =>  (BICv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13137,
        GIR_EraseRootFromParent_Done,
      // Label 725: @33446
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(33506), // Rule ID 4693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }))  =>  (BICv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4693,
        GIR_EraseRootFromParent_Done,
      // Label 726: @33506
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(33529), // Rule ID 2411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ANDv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2411,
        GIR_Done,
      // Label 727: @33529
      GIM_Reject,
    // Label 724: @33530
    GIM_Reject,
    // Label 661: @33531
    GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(33690),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(33606), // Rule ID 12611 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rn)  =>  (BICv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12611,
        GIR_EraseRootFromParent_Done,
      // Label 729: @33606
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(33666), // Rule ID 1585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }))  =>  (BICv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BICv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1585,
        GIR_EraseRootFromParent_Done,
      // Label 730: @33666
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(33689), // Rule ID 1583 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ANDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ANDv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1583,
        GIR_Done,
      // Label 731: @33689
      GIM_Reject,
    // Label 728: @33690
    GIM_Reject,
    // Label 662: @33691
    GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(33775),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::PPRorPNRRegClassID),
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(33753), // Rule ID 10330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        // (and:{ *:[nxv1i1] } PPR:{ *:[nxv1i1] }:$Ps1, PPR:{ *:[nxv1i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv1i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv1i1] }:$Ps1, PPR:{ *:[nxv1i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::PTRUE_D),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ps1
        GIR_RootToRootCopy, /*OpIdx*/2, // Ps2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10330,
        GIR_EraseRootFromParent_Done,
      // Label 733: @33753
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(33774), // Rule ID 2657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        // (and:{ *:[nxv1i1] } nxv1i1:{ *:[nxv1i1] }:$Op1, nxv1i1:{ *:[nxv1i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv1i1] } ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op1, ?:{ *:[nxv1i1] }:$Op2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/2, // Op2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2657,
        GIR_EraseRootFromParent_Done,
      // Label 734: @33774
      GIM_Reject,
    // Label 732: @33775
    GIM_Reject,
    // Label 663: @33776
    GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(33860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::PPRorPNRRegClassID),
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(33838), // Rule ID 10329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        // (and:{ *:[nxv2i1] } PPR:{ *:[nxv2i1] }:$Ps1, PPR:{ *:[nxv2i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv2i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv2i1] }:$Ps1, PPR:{ *:[nxv2i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::PTRUE_D),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ps1
        GIR_RootToRootCopy, /*OpIdx*/2, // Ps2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10329,
        GIR_EraseRootFromParent_Done,
      // Label 736: @33838
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(33859), // Rule ID 2656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        // (and:{ *:[nxv2i1] } nxv2i1:{ *:[nxv2i1] }:$Op1, nxv2i1:{ *:[nxv2i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv2i1] } ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op1, ?:{ *:[nxv2i1] }:$Op2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/2, // Op2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2656,
        GIR_EraseRootFromParent_Done,
      // Label 737: @33859
      GIM_Reject,
    // Label 735: @33860
    GIM_Reject,
    // Label 664: @33861
    GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(33886), // Rule ID 3071 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (and:{ *:[nxv2i64] } nxv2i64:{ *:[nxv2i64] }:$Op1, nxv2i64:{ *:[nxv2i64] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv2i64] } ?:{ *:[nxv2i64] }:$Op1, ?:{ *:[nxv2i64] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::AND_ZZZ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3071,
      GIR_Done,
    // Label 738: @33886
    GIM_Reject,
    // Label 665: @33887
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(33971),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::PPRorPNRRegClassID),
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(33949), // Rule ID 10328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        // (and:{ *:[nxv4i1] } PPR:{ *:[nxv4i1] }:$Ps1, PPR:{ *:[nxv4i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv4i1] } (PTRUE_S:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv4i1] }:$Ps1, PPR:{ *:[nxv4i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::PTRUE_S),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ps1
        GIR_RootToRootCopy, /*OpIdx*/2, // Ps2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10328,
        GIR_EraseRootFromParent_Done,
      // Label 740: @33949
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(33970), // Rule ID 2655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        // (and:{ *:[nxv4i1] } nxv4i1:{ *:[nxv4i1] }:$Op1, nxv4i1:{ *:[nxv4i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv4i1] } ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op1, ?:{ *:[nxv4i1] }:$Op2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/2, // Op2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2655,
        GIR_EraseRootFromParent_Done,
      // Label 741: @33970
      GIM_Reject,
    // Label 739: @33971
    GIM_Reject,
    // Label 666: @33972
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(33997), // Rule ID 3070 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (and:{ *:[nxv4i32] } nxv4i32:{ *:[nxv4i32] }:$Op1, nxv4i32:{ *:[nxv4i32] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv4i32] } ?:{ *:[nxv4i32] }:$Op1, ?:{ *:[nxv4i32] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::AND_ZZZ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3070,
      GIR_Done,
    // Label 742: @33997
    GIM_Reject,
    // Label 667: @33998
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(34082),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::PPRorPNRRegClassID),
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(34060), // Rule ID 10327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        // (and:{ *:[nxv8i1] } PPR:{ *:[nxv8i1] }:$Ps1, PPR:{ *:[nxv8i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv8i1] } (PTRUE_H:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv8i1] }:$Ps1, PPR:{ *:[nxv8i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::PTRUE_H),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ps1
        GIR_RootToRootCopy, /*OpIdx*/2, // Ps2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10327,
        GIR_EraseRootFromParent_Done,
      // Label 744: @34060
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(34081), // Rule ID 2654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        // (and:{ *:[nxv8i1] } nxv8i1:{ *:[nxv8i1] }:$Op1, nxv8i1:{ *:[nxv8i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv8i1] } ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op1, ?:{ *:[nxv8i1] }:$Op2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/2, // Op2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2654,
        GIR_EraseRootFromParent_Done,
      // Label 745: @34081
      GIM_Reject,
    // Label 743: @34082
    GIM_Reject,
    // Label 668: @34083
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(34108), // Rule ID 3069 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (and:{ *:[nxv8i16] } nxv8i16:{ *:[nxv8i16] }:$Op1, nxv8i16:{ *:[nxv8i16] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv8i16] } ?:{ *:[nxv8i16] }:$Op1, ?:{ *:[nxv8i16] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::AND_ZZZ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3069,
      GIR_Done,
    // Label 746: @34108
    GIM_Reject,
    // Label 669: @34109
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(34193),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::PPRorPNRRegClassID),
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(34171), // Rule ID 10326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
        // (and:{ *:[nxv16i1] } PPR:{ *:[nxv16i1] }:$Ps1, PPR:{ *:[nxv16i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv16i1] } (PTRUE_B:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv16i1] }:$Ps1, PPR:{ *:[nxv16i1] }:$Ps2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::PTRUE_B),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/31,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // Ps1
        GIR_RootToRootCopy, /*OpIdx*/2, // Ps2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10326,
        GIR_EraseRootFromParent_Done,
      // Label 748: @34171
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(34192), // Rule ID 2653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
        // (and:{ *:[nxv16i1] } nxv16i1:{ *:[nxv16i1] }:$Op1, nxv16i1:{ *:[nxv16i1] }:$Op2)  =>  (AND_PPzPP:{ *:[nxv16i1] } ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op1, ?:{ *:[nxv16i1] }:$Op2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::AND_PPzPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Pd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/1, // Op1
        GIR_RootToRootCopy, /*OpIdx*/2, // Op2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2653,
        GIR_EraseRootFromParent_Done,
      // Label 749: @34192
      GIM_Reject,
    // Label 747: @34193
    GIM_Reject,
    // Label 670: @34194
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(34219), // Rule ID 3068 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVEorSME),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::ZPRRegClassID),
      // (and:{ *:[nxv16i8] } nxv16i8:{ *:[nxv16i8] }:$Op1, nxv16i8:{ *:[nxv16i8] }:$Op2)  =>  (AND_ZZZ:{ *:[nxv16i8] } ?:{ *:[nxv16i8] }:$Op1, ?:{ *:[nxv16i8] }:$Op2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::AND_ZZZ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3068,
      GIR_Done,
    // Label 750: @34219
    GIM_Reject,
    // Label 671: @34220
    GIM_Reject,
    // Label 6: @34221
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(24), /*)*//*default:*//*Label 769*/ GIMT_Encode4(46267),
    /*GILLT_s32*//*Label 751*/ GIMT_Encode4(34320),
    /*GILLT_s64*//*Label 752*/ GIMT_Encode4(34680), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 753*/ GIMT_Encode4(36847),
    /*GILLT_v2s64*//*Label 754*/ GIMT_Encode4(38155),
    /*GILLT_v4s16*//*Label 755*/ GIMT_Encode4(39463),
    /*GILLT_v4s32*//*Label 756*/ GIMT_Encode4(40771),
    /*GILLT_v8s8*//*Label 757*/ GIMT_Encode4(42079),
    /*GILLT_v8s16*//*Label 758*/ GIMT_Encode4(43387),
    /*GILLT_v16s8*//*Label 759*/ GIMT_Encode4(44695),
    /*GILLT_nxv1s1*//*Label 760*/ GIMT_Encode4(46003),
    /*GILLT_nxv2s1*//*Label 761*/ GIMT_Encode4(46035), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_nxv2s64*//*Label 762*/ GIMT_Encode4(46067),
    /*GILLT_nxv4s1*//*Label 763*/ GIMT_Encode4(46093), GIMT_Encode4(0),
    /*GILLT_nxv4s32*//*Label 764*/ GIMT_Encode4(46125),
    /*GILLT_nxv8s1*//*Label 765*/ GIMT_Encode4(46151),
    /*GILLT_nxv8s16*//*Label 766*/ GIMT_Encode4(46183),
    /*GILLT_nxv16s1*//*Label 767*/ GIMT_Encode4(46209),
    /*GILLT_nxv16s8*//*Label 768*/ GIMT_Encode4(46241),
    // Label 751: @34320
    GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(34679),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(34386), // Rule ID 12494 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (or:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12494,
        GIR_EraseRootFromParent_Done,
      // Label 771: @34386
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(34441), // Rule ID 185 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 185,
        GIR_EraseRootFromParent_Done,
      // Label 772: @34441
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(34482), // Rule ID 157 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_logical_imm32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ORRWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORRWri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderLogicalImm32), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 157,
        GIR_EraseRootFromParent_Done,
      // Label 773: @34482
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(34515), // Rule ID 12496 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (or:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORRWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12496,
        GIR_EraseRootFromParent_Done,
      // Label 774: @34515
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(34548), // Rule ID 189 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg32),
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORRWrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 189,
        GIR_EraseRootFromParent_Done,
      // Label 775: @34548
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(34601), // Rule ID 12492 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12492,
        GIR_EraseRootFromParent_Done,
      // Label 776: @34601
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(34654), // Rule ID 183 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 183,
        GIR_EraseRootFromParent_Done,
      // Label 777: @34654
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(34678), // Rule ID 187 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ORRWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ORRWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 187,
        GIR_Done,
      // Label 778: @34678
      GIM_Reject,
    // Label 770: @34679
    GIM_Reject,
    // Label 752: @34680
    GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(36846),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(34813), // Rule ID 3884 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(71777214294589695),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] Rn
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(-71777214294589696),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i64] } (and:{ *:[i64] } (srl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), 71777214294589695:{ *:[i64] }), (and:{ *:[i64] } (shl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), -71777214294589696:{ *:[i64] }))  =>  (REV16Xr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::REV16Xr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3884,
        GIR_EraseRootFromParent_Done,
      // Label 780: @34813
      GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(34935), // Rule ID 13044 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(-71777214294589696),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] Rn
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(71777214294589695),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), -71777214294589696:{ *:[i64] }), (and:{ *:[i64] } (srl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), 71777214294589695:{ *:[i64] }))  =>  (REV16Xr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::REV16Xr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13044,
        GIR_EraseRootFromParent_Done,
      // Label 781: @34935
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(34990), // Rule ID 12495 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (or:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12495,
        GIR_EraseRootFromParent_Done,
      // Label 782: @34990
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(35045), // Rule ID 186 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 186,
        GIR_EraseRootFromParent_Done,
      // Label 783: @35045
      GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(35154), // Rule ID 12844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12844,
        GIR_EraseRootFromParent_Done,
      // Label 784: @35154
      GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(35263), // Rule ID 12843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12843,
        GIR_EraseRootFromParent_Done,
      // Label 785: @35263
      GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(35372), // Rule ID 12846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12846,
        GIR_EraseRootFromParent_Done,
      // Label 786: @35372
      GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(35481), // Rule ID 12845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12845,
        GIR_EraseRootFromParent_Done,
      // Label 787: @35481
      GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(35590), // Rule ID 2397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS), (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2397,
        GIR_EraseRootFromParent_Done,
      // Label 788: @35590
      GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(35699), // Rule ID 12841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS), (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12841,
        GIR_EraseRootFromParent_Done,
      // Label 789: @35699
      GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(35808), // Rule ID 12840 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12840,
        GIR_EraseRootFromParent_Done,
      // Label 790: @35808
      GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(35917), // Rule ID 12842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12842,
        GIR_EraseRootFromParent_Done,
      // Label 791: @35917
      GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(35958), // Rule ID 158 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_logical_imm64),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ORRXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORRXri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderLogicalImm64), // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 158,
        GIR_EraseRootFromParent_Done,
      // Label 792: @35958
      GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(35991), // Rule ID 12497 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (or:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORRXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12497,
        GIR_EraseRootFromParent_Done,
      // Label 793: @35991
      GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(36024), // Rule ID 190 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_logical_shifted_reg64),
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORRXrs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 190,
        GIR_EraseRootFromParent_Done,
      // Label 794: @36024
      GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(36091), // Rule ID 12780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12780,
        GIR_EraseRootFromParent_Done,
      // Label 795: @36091
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(36158), // Rule ID 13178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13178,
        GIR_EraseRootFromParent_Done,
      // Label 796: @36158
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(36225), // Rule ID 12783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12783,
        GIR_EraseRootFromParent_Done,
      // Label 797: @36225
      GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(36292), // Rule ID 13181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13181,
        GIR_EraseRootFromParent_Done,
      // Label 798: @36292
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(36345), // Rule ID 12493 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNXrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12493,
        GIR_EraseRootFromParent_Done,
      // Label 799: @36345
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(36412), // Rule ID 2107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2107,
        GIR_EraseRootFromParent_Done,
      // Label 800: @36412
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(36479), // Rule ID 5882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5882,
        GIR_EraseRootFromParent_Done,
      // Label 801: @36479
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(36546), // Rule ID 2116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2116,
        GIR_EraseRootFromParent_Done,
      // Label 802: @36546
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(36613), // Rule ID 5888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5888,
        GIR_EraseRootFromParent_Done,
      // Label 803: @36613
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(36666), // Rule ID 184 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNXrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 184,
        GIR_EraseRootFromParent_Done,
      // Label 804: @36666
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(36730), // Rule ID 13142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$LHS)  =>  (ORNv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13142,
        GIR_EraseRootFromParent_Done,
      // Label 805: @36730
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(36794), // Rule ID 4704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }))  =>  (ORNv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4704,
        GIR_EraseRootFromParent_Done,
      // Label 806: @36794
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(36818), // Rule ID 188 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ORRXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ORRXrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 188,
        GIR_Done,
      // Label 807: @36818
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(36845), // Rule ID 4710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ORRv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ORRv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4710,
        GIR_Done,
      // Label 808: @36845
      GIM_Reject,
    // Label 779: @36846
    GIM_Reject,
    // Label 753: @36847
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(38154),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(36967), // Rule ID 12837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12837,
        GIR_EraseRootFromParent_Done,
      // Label 810: @36967
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(37076), // Rule ID 12836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12836,
        GIR_EraseRootFromParent_Done,
      // Label 811: @37076
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(37185), // Rule ID 12839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12839,
        GIR_EraseRootFromParent_Done,
      // Label 812: @37185
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(37294), // Rule ID 12838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12838,
        GIR_EraseRootFromParent_Done,
      // Label 813: @37294
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(37403), // Rule ID 2396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS), (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2396,
        GIR_EraseRootFromParent_Done,
      // Label 814: @37403
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(37512), // Rule ID 12834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS), (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12834,
        GIR_EraseRootFromParent_Done,
      // Label 815: @37512
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(37621), // Rule ID 12833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12833,
        GIR_EraseRootFromParent_Done,
      // Label 816: @37621
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(37730), // Rule ID 12835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12835,
        GIR_EraseRootFromParent_Done,
      // Label 817: @37730
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(37797), // Rule ID 12800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12800,
        GIR_EraseRootFromParent_Done,
      // Label 818: @37797
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(37864), // Rule ID 12821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12821,
        GIR_EraseRootFromParent_Done,
      // Label 819: @37864
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(37931), // Rule ID 2224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2224,
        GIR_EraseRootFromParent_Done,
      // Label 820: @37931
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(37998), // Rule ID 2283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i32_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2283,
        GIR_EraseRootFromParent_Done,
      // Label 821: @37998
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(38062), // Rule ID 13141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$LHS)  =>  (ORNv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13141,
        GIR_EraseRootFromParent_Done,
      // Label 822: @38062
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(38126), // Rule ID 4703 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }))  =>  (ORNv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4703,
        GIR_EraseRootFromParent_Done,
      // Label 823: @38126
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(38153), // Rule ID 4709 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ORRv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ORRv8i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4709,
        GIR_Done,
      // Label 824: @38153
      GIM_Reject,
    // Label 809: @38154
    GIM_Reject,
    // Label 754: @38155
    GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(39462),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(38275), // Rule ID 12865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12865,
        GIR_EraseRootFromParent_Done,
      // Label 826: @38275
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(38384), // Rule ID 12864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12864,
        GIR_EraseRootFromParent_Done,
      // Label 827: @38384
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(38493), // Rule ID 12867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12867,
        GIR_EraseRootFromParent_Done,
      // Label 828: @38493
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(38602), // Rule ID 12866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12866,
        GIR_EraseRootFromParent_Done,
      // Label 829: @38602
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(38711), // Rule ID 2400 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS), (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2400,
        GIR_EraseRootFromParent_Done,
      // Label 830: @38711
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(38820), // Rule ID 12862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS), (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12862,
        GIR_EraseRootFromParent_Done,
      // Label 831: @38820
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(38929), // Rule ID 12861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12861,
        GIR_EraseRootFromParent_Done,
      // Label 832: @38929
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(39038), // Rule ID 12863 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12863,
        GIR_EraseRootFromParent_Done,
      // Label 833: @39038
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(39105), // Rule ID 12804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12804,
        GIR_EraseRootFromParent_Done,
      // Label 834: @39105
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(39172), // Rule ID 12825 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12825,
        GIR_EraseRootFromParent_Done,
      // Label 835: @39172
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(39239), // Rule ID 2228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2228,
        GIR_EraseRootFromParent_Done,
      // Label 836: @39239
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(39306), // Rule ID 2287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i64_shift),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2287,
        GIR_EraseRootFromParent_Done,
      // Label 837: @39306
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(39370), // Rule ID 13145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$LHS)  =>  (ORNv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13145,
        GIR_EraseRootFromParent_Done,
      // Label 838: @39370
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(39434), // Rule ID 4707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }))  =>  (ORNv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ORNv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4707,
        GIR_EraseRootFromParent_Done,
      // Label 839: @39434
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(39461), // Rule ID 4713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ORRv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ORRv16i8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4713,
        GIR_Done,
      // Label 840: @39461
      GIM_Reject,
    // Label 825: @39462
    GIM_Reject,
    // Label 755: @39463
    GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(40770),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(39583), // Rule ID 12830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12830,
        GIR_EraseRootFromParent_Done,
      // Label 842: @39583
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(39692), // Rule ID 12829 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12829,
        GIR_EraseRootFromParent_Done,
      // Label 843: @39692
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(39801), // Rule ID 12832 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12832,
        GIR_EraseRootFromParent_Done,
      // Label 844: @39801
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(39910), // Rule ID 12831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12831,
        GIR_EraseRootFromParent_Done,
      // Label 845: @39910
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(40019), // Rule ID 2395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS), (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2395,
        GIR_EraseRootFromParent_Done,
      // Label 846: @40019
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(40128), // Rule ID 12827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS), (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12827,
        GIR_EraseRootFromParent_Done,
      // Label 847: @40128
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(40237), // Rule ID 12826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::BSPv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12826,
        GIR_EraseRootFromParent_Done,
      // Label 848: @40237
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(40346), // Rule ID 12828 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
        GI