/* umockdev-pcap.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from umockdev-pcap.vala, do not modify */

/*
 * Copyright (C) 2021 Red Hat Inc.
 * Author: Benjamin Berg <bberg@redhat.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <pcap/pcap.h>
#include "linux/usbdevice_fs.h"
#include <pcap/dlt.h>
#include "linux/ioctl.h"
#include <gio/gio.h>
#include "sys/ioctl.h"
#include <errno.h>
#include <pcap/usb.h>
#include <stdio.h>

#define UMOCKDEV_URB_TRANSFER_IN 0x80
#define UMOCKDEV_URB_ISOCHRONOUS 0x0
#define UMOCKDEV_URB_INTERRUPT 0x1
#define UMOCKDEV_URB_CONTROL 0x2
#define UMOCKDEV_URB_BULK 0x3
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER_capabilities ((guint32) ((((USBDEVFS_CAP_BULK_SCATTER_GATHER | USBDEVFS_CAP_BULK_CONTINUATION) | USBDEVFS_CAP_NO_PACKET_SIZE_LIM) | USBDEVFS_CAP_REAP_AFTER_DISCONNECT) | USBDEVFS_CAP_ZERO_PACKET))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define UMOCKDEV_TYPE_URB_INFO (umockdev_urb_info_get_type ())
typedef struct _UMockdevUrbInfo UMockdevUrbInfo;

#define UMOCKDEV_TYPE_IOCTL_DATA (umockdev_ioctl_data_get_type ())
#define UMOCKDEV_IOCTL_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlData))
#define UMOCKDEV_IOCTL_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlDataClass))
#define UMOCKDEV_IS_IOCTL_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_DATA))
#define UMOCKDEV_IS_IOCTL_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_DATA))
#define UMOCKDEV_IOCTL_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_DATA, UMockdevIoctlDataClass))

typedef struct _UMockdevIoctlData UMockdevIoctlData;
typedef struct _UMockdevIoctlDataClass UMockdevIoctlDataClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UMOCKDEV_TYPE_IOCTL_BASE (umockdev_ioctl_base_get_type ())
#define UMOCKDEV_IOCTL_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBase))
#define UMOCKDEV_IOCTL_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBaseClass))
#define UMOCKDEV_IS_IOCTL_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_BASE))
#define UMOCKDEV_IS_IOCTL_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_BASE))
#define UMOCKDEV_IOCTL_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_BASE, UMockdevIoctlBaseClass))

typedef struct _UMockdevIoctlBase UMockdevIoctlBase;
typedef struct _UMockdevIoctlBaseClass UMockdevIoctlBaseClass;
typedef struct _UMockdevIoctlBasePrivate UMockdevIoctlBasePrivate;

#define UMOCKDEV_TYPE_IOCTL_CLIENT (umockdev_ioctl_client_get_type ())
#define UMOCKDEV_IOCTL_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClient))
#define UMOCKDEV_IOCTL_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClientClass))
#define UMOCKDEV_IS_IOCTL_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_CLIENT))
#define UMOCKDEV_IS_IOCTL_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_CLIENT))
#define UMOCKDEV_IOCTL_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_CLIENT, UMockdevIoctlClientClass))

typedef struct _UMockdevIoctlClient UMockdevIoctlClient;
typedef struct _UMockdevIoctlClientClass UMockdevIoctlClientClass;

#define UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER (umockdev_ioctl_usb_pcap_handler_get_type ())
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandler))
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandlerClass))
#define UMOCKDEV_IS_IOCTL_USB_PCAP_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER))
#define UMOCKDEV_IS_IOCTL_USB_PCAP_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER))
#define UMOCKDEV_IOCTL_USB_PCAP_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandlerClass))

typedef struct _UMockdevIoctlUsbPcapHandler UMockdevIoctlUsbPcapHandler;
typedef struct _UMockdevIoctlUsbPcapHandlerClass UMockdevIoctlUsbPcapHandlerClass;
typedef struct _UMockdevIoctlUsbPcapHandlerPrivate UMockdevIoctlUsbPcapHandlerPrivate;
enum  {
	UMOCKDEV_IOCTL_USB_PCAP_HANDLER_0_PROPERTY,
	UMOCKDEV_IOCTL_USB_PCAP_HANDLER_NUM_PROPERTIES
};
static GParamSpec* umockdev_ioctl_usb_pcap_handler_properties[UMOCKDEV_IOCTL_USB_PCAP_HANDLER_NUM_PROPERTIES];
#define _pcap_close0(var) ((var == NULL) ? NULL : (var = (pcap_close (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UMockdevIoctlDataPrivate UMockdevIoctlDataPrivate;
#define _umockdev_urb_info_free0(var) ((var == NULL) ? NULL : (var = (umockdev_urb_info_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevUrbInfo {
	UMockdevIoctlData* urb_data;
	UMockdevIoctlData* buffer_data;
	guint64 pcap_id;
};

struct _UMockdevIoctlBase {
	GObject parent_instance;
	UMockdevIoctlBasePrivate * priv;
};

struct _UMockdevIoctlBaseClass {
	GObjectClass parent_class;
	gboolean (*handle_ioctl) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	gboolean (*handle_read) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	gboolean (*handle_write) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	void (*client_connected) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
	void (*client_vanished) (UMockdevIoctlBase* self, UMockdevIoctlClient* client);
};

struct _UMockdevIoctlUsbPcapHandler {
	UMockdevIoctlBase parent_instance;
	UMockdevIoctlUsbPcapHandlerPrivate * priv;
};

struct _UMockdevIoctlUsbPcapHandlerClass {
	UMockdevIoctlBaseClass parent_class;
};

struct _UMockdevIoctlUsbPcapHandlerPrivate {
	pcap_t* rec;
	GArray* urbs;
	GArray* discarded;
	gint bus;
	gint device;
	struct pcap_pkthdr cur_hdr;
	guint64 start_time_ms;
	guint64 last_pkt_time_ms;
	guint64 cur_waiting_since;
	guint8* cur_buf;
	gint cur_buf_length1;
	gint _cur_buf_size_;
};

struct _UMockdevIoctlData {
	GObject parent_instance;
	guint8* data;
	gint data_len;
	gulong client_addr;
	UMockdevIoctlDataPrivate * priv;
};

struct _UMockdevIoctlDataClass {
	GObjectClass parent_class;
};

static gint UMockdevIoctlUsbPcapHandler_private_offset;
static gpointer umockdev_ioctl_usb_pcap_handler_parent_class = NULL;

VALA_EXTERN gchar* umockdev_urb_type_to_string (gint type);
VALA_EXTERN GType umockdev_urb_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType umockdev_ioctl_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlData, g_object_unref)
VALA_EXTERN UMockdevUrbInfo* umockdev_urb_info_dup (const UMockdevUrbInfo* self);
VALA_EXTERN void umockdev_urb_info_free (UMockdevUrbInfo* self);
VALA_EXTERN void umockdev_urb_info_copy (const UMockdevUrbInfo* self,
                             UMockdevUrbInfo* dest);
VALA_EXTERN void umockdev_urb_info_destroy (UMockdevUrbInfo* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (UMockdevUrbInfo, umockdev_urb_info_destroy)
VALA_EXTERN GType umockdev_ioctl_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlBase, g_object_unref)
VALA_EXTERN GType umockdev_ioctl_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlClient, g_object_unref)
VALA_EXTERN GType umockdev_ioctl_usb_pcap_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UMockdevIoctlUsbPcapHandler, g_object_unref)
VALA_EXTERN gboolean umockdev_ioctl_base_handle_ioctl (UMockdevIoctlBase* self,
                                           UMockdevIoctlClient* client);
VALA_EXTERN UMockdevIoctlUsbPcapHandler* umockdev_ioctl_usb_pcap_handler_new (const gchar* file,
                                                                  gint bus,
                                                                  gint device);
VALA_EXTERN UMockdevIoctlUsbPcapHandler* umockdev_ioctl_usb_pcap_handler_construct (GType object_type,
                                                                        const gchar* file,
                                                                        gint bus,
                                                                        gint device);
VALA_EXTERN UMockdevIoctlBase* umockdev_ioctl_base_new (void);
VALA_EXTERN UMockdevIoctlBase* umockdev_ioctl_base_construct (GType object_type);
static void _umockdev_urb_info_free0_ (gpointer var);
static void _vala_UMockdevUrbInfo_free_function_content_of (gpointer data);
static gboolean umockdev_ioctl_usb_pcap_handler_real_handle_ioctl (UMockdevIoctlBase* base,
                                                            UMockdevIoctlClient* client);
VALA_EXTERN gulong umockdev_ioctl_client_get_request (UMockdevIoctlClient* self);
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_client_get_arg (UMockdevIoctlClient* self);
VALA_EXTERN UMockdevIoctlData* umockdev_ioctl_data_resolve (UMockdevIoctlData* self,
                                                gsize offset,
                                                gsize len,
                                                GError** error);
VALA_EXTERN void umockdev_ioctl_client_complete (UMockdevIoctlClient* self,
                                     glong res,
                                     gint errno_);
static UMockdevUrbInfo* umockdev_ioctl_usb_pcap_handler_next_reapable_urb (UMockdevIoctlUsbPcapHandler* self);
VALA_EXTERN gboolean umockdev_ioctl_data_set_ptr (UMockdevIoctlData* self,
                                      gsize offset,
                                      UMockdevIoctlData* child);
static void umockdev_ioctl_usb_pcap_handler_finalize (GObject * obj);
static GType umockdev_ioctl_usb_pcap_handler_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
umockdev_urb_type_to_string (gint type)
{
	gchar* result;
	switch (type) {
		case UMOCKDEV_URB_INTERRUPT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("INTERRUPT");
			result = _tmp0_;
			return result;
		}
		case UMOCKDEV_URB_CONTROL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("CONTROL");
			result = _tmp1_;
			return result;
		}
		case UMOCKDEV_URB_BULK:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("BULK");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup_printf ("UNKNOWN (%d)", type);
			result = _tmp3_;
			return result;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
umockdev_urb_info_copy (const UMockdevUrbInfo* self,
                        UMockdevUrbInfo* dest)
{
	UMockdevIoctlData* _tmp0_;
	UMockdevIoctlData* _tmp1_;
	UMockdevIoctlData* _tmp2_;
	UMockdevIoctlData* _tmp3_;
	_tmp0_ = (*self).urb_data;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).urb_data);
	(*dest).urb_data = _tmp1_;
	_tmp2_ = (*self).buffer_data;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).buffer_data);
	(*dest).buffer_data = _tmp3_;
	(*dest).pcap_id = (*self).pcap_id;
}

void
umockdev_urb_info_destroy (UMockdevUrbInfo* self)
{
	_g_object_unref0 ((*self).urb_data);
	_g_object_unref0 ((*self).buffer_data);
}

UMockdevUrbInfo*
umockdev_urb_info_dup (const UMockdevUrbInfo* self)
{
	UMockdevUrbInfo* dup;
	dup = g_new0 (UMockdevUrbInfo, 1);
	umockdev_urb_info_copy (self, dup);
	return dup;
}

void
umockdev_urb_info_free (UMockdevUrbInfo* self)
{
	umockdev_urb_info_destroy (self);
	g_free (self);
}

static GType
umockdev_urb_info_get_type_once (void)
{
	GType umockdev_urb_info_type_id;
	umockdev_urb_info_type_id = g_boxed_type_register_static ("UMockdevUrbInfo", (GBoxedCopyFunc) umockdev_urb_info_dup, (GBoxedFreeFunc) umockdev_urb_info_free);
	return umockdev_urb_info_type_id;
}

GType
umockdev_urb_info_get_type (void)
{
	static volatile gsize umockdev_urb_info_type_id__once = 0;
	if (g_once_init_enter (&umockdev_urb_info_type_id__once)) {
		GType umockdev_urb_info_type_id;
		umockdev_urb_info_type_id = umockdev_urb_info_get_type_once ();
		g_once_init_leave (&umockdev_urb_info_type_id__once, umockdev_urb_info_type_id);
	}
	return umockdev_urb_info_type_id__once;
}

static inline gpointer
umockdev_ioctl_usb_pcap_handler_get_instance_private (UMockdevIoctlUsbPcapHandler* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevIoctlUsbPcapHandler_private_offset);
}

static void
_umockdev_urb_info_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (umockdev_urb_info_free (var), NULL));
}

static void
_vala_UMockdevUrbInfo_free_function_content_of (gpointer data)
{
	UMockdevUrbInfo* self;
	self = *((UMockdevUrbInfo**) data);
	_umockdev_urb_info_free0_ (self);
}

UMockdevIoctlUsbPcapHandler*
umockdev_ioctl_usb_pcap_handler_construct (GType object_type,
                                           const gchar* file,
                                           gint bus,
                                           gint device)
{
	UMockdevIoctlUsbPcapHandler * self = NULL;
	gchar errbuf[PCAP_ERRBUF_SIZE] = {0};
	pcap_t* _tmp0_;
	pcap_t* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (UMockdevIoctlUsbPcapHandler*) umockdev_ioctl_base_construct (object_type);
	self->priv->bus = bus;
	self->priv->device = device;
	_tmp0_ = pcap_open_offline (file, errbuf);
	_pcap_close0 (self->priv->rec);
	self->priv->rec = _tmp0_;
	_tmp1_ = self->priv->rec;
	if (pcap_datalink (_tmp1_) != DLT_USB_LINUX_MMAPPED) {
		g_error ("umockdev-pcap.vala:76: Only DLT_USB_LINUX_MMAPPED recordings are suppo" \
"rted!");
	}
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (UMockdevUrbInfo*));
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_UMockdevUrbInfo_free_function_content_of);
	_g_array_unref0 (self->priv->urbs);
	self->priv->urbs = _tmp2_;
	_tmp3_ = g_array_new (TRUE, TRUE, sizeof (UMockdevUrbInfo*));
	g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_UMockdevUrbInfo_free_function_content_of);
	_g_array_unref0 (self->priv->discarded);
	self->priv->discarded = _tmp3_;
	return self;
}

UMockdevIoctlUsbPcapHandler*
umockdev_ioctl_usb_pcap_handler_new (const gchar* file,
                                     gint bus,
                                     gint device)
{
	return umockdev_ioctl_usb_pcap_handler_construct (UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, file, bus, device);
}

static gpointer
_umockdev_urb_info_dup0 (gpointer self)
{
	return self ? umockdev_urb_info_dup (self) : NULL;
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static gboolean
umockdev_ioctl_usb_pcap_handler_real_handle_ioctl (UMockdevIoctlBase* base,
                                                   UMockdevIoctlClient* client)
{
	UMockdevIoctlUsbPcapHandler * self;
	UMockdevIoctlData* data = NULL;
	gulong request = 0UL;
	gulong _tmp0_;
	gulong _tmp1_;
	gulong size = 0UL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UMockdevIoctlUsbPcapHandler*) base;
	g_return_val_if_fail (client != NULL, FALSE);
	data = NULL;
	_tmp0_ = umockdev_ioctl_client_get_request (client);
	_tmp1_ = _tmp0_;
	request = _tmp1_;
	size = (request >> _IOC_SIZESHIFT) & ((1 << _IOC_SIZEBITS) - 1);
	{
		UMockdevIoctlData* _tmp2_ = NULL;
		UMockdevIoctlData* _tmp3_;
		UMockdevIoctlData* _tmp4_;
		UMockdevIoctlData* _tmp5_;
		UMockdevIoctlData* _tmp7_;
		_tmp3_ = umockdev_ioctl_client_get_arg (client);
		_tmp4_ = _tmp3_;
		_tmp5_ = umockdev_ioctl_data_resolve (_tmp4_, (gsize) 0, (gsize) size, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_tmp7_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (data);
		data = _tmp7_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("umockdev-pcap.vala:90: Error resolving IOCtl data: %s", _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (data);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	switch (request) {
		case USBDEVFS_GET_CAPABILITIES:
		{
			UMockdevIoctlData* _tmp11_;
			guint8* _tmp12_;
			gint _tmp12__length1;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->data;
			_tmp12__length1 = _tmp11_->data_len;
			*((guint32*) _tmp12_) = UMOCKDEV_IOCTL_USB_PCAP_HANDLER_capabilities;
			umockdev_ioctl_client_complete (client, (glong) 0, 0);
			result = TRUE;
			_g_object_unref0 (data);
			return result;
		}
		case USBDEVFS_CLAIMINTERFACE:
		case USBDEVFS_RELEASEINTERFACE:
		case USBDEVFS_CLEAR_HALT:
		case USBDEVFS_RESET:
		case USBDEVFS_RESETEP:
		{
			umockdev_ioctl_client_complete (client, (glong) 0, 0);
			result = TRUE;
			_g_object_unref0 (data);
			return result;
		}
		case USBDEVFS_DISCARDURB:
		{
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						GArray* _tmp15_;
						GArray* _tmp16_;
						UMockdevIoctlData* _tmp17_;
						UMockdevIoctlData* _tmp18_;
						UMockdevIoctlData* _tmp19_;
						guint8* _tmp20_;
						gint _tmp20__length1;
						if (!_tmp13_) {
							gint _tmp14_;
							_tmp14_ = i;
							i = _tmp14_ + 1;
						}
						_tmp13_ = FALSE;
						_tmp15_ = self->priv->urbs;
						if (!(((guint) i) < _tmp15_->len)) {
							break;
						}
						_tmp16_ = self->priv->urbs;
						_tmp17_ = (*g_array_index (_tmp16_, UMockdevUrbInfo*, (guint) i)).urb_data;
						_tmp18_ = umockdev_ioctl_client_get_arg (client);
						_tmp19_ = _tmp18_;
						_tmp20_ = _tmp19_->data;
						_tmp20__length1 = _tmp19_->data_len;
						if (_tmp17_->client_addr == (*((gulong*) _tmp20_))) {
							GArray* _tmp21_;
							GArray* _tmp22_;
							UMockdevUrbInfo* _tmp23_;
							GArray* _tmp24_;
							UMockdevUrbInfo* _tmp25_;
							UMockdevUrbInfo* _tmp26_;
							_tmp21_ = self->priv->discarded;
							_tmp22_ = self->priv->urbs;
							_tmp23_ = _umockdev_urb_info_dup0 (g_array_index (_tmp22_, UMockdevUrbInfo*, (guint) i));
							g_array_prepend_val (_tmp21_, _tmp23_);
							_tmp24_ = self->priv->urbs;
							_tmp25_ = vala_g_array_remove_index (_tmp24_, (guint) i);
							_tmp26_ = _tmp25_;
							_umockdev_urb_info_free0 (_tmp26_);
							umockdev_ioctl_client_complete (client, (glong) 0, 0);
							result = TRUE;
							_g_object_unref0 (data);
							return result;
						}
					}
				}
			}
			umockdev_ioctl_client_complete (client, (glong) -1, EINVAL);
			result = TRUE;
			_g_object_unref0 (data);
			return result;
		}
		case USBDEVFS_SUBMITURB:
		{
			struct usbdevfs_urb* urb = NULL;
			UMockdevIoctlData* _tmp27_;
			guint8* _tmp28_;
			gint _tmp28__length1;
			gsize offset = 0UL;
			struct usbdevfs_urb* _tmp29_;
			UMockdevUrbInfo info = {0};
			UMockdevUrbInfo _tmp30_ = {0};
			UMockdevIoctlData* _tmp31_;
			UMockdevIoctlData* _tmp32_;
			GArray* _tmp42_;
			UMockdevUrbInfo _tmp43_;
			UMockdevUrbInfo _tmp44_;
			UMockdevUrbInfo* _tmp45_;
			_tmp27_ = data;
			_tmp28_ = _tmp27_->data;
			_tmp28__length1 = _tmp27_->data_len;
			urb = (struct usbdevfs_urb*) _tmp28_;
			_tmp29_ = urb;
			offset = (gsize) (((gulong) (&(*urb).buffer)) - ((gulong) _tmp29_));
			info = _tmp30_;
			_tmp31_ = data;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			_g_object_unref0 (info.urb_data);
			info.urb_data = _tmp32_;
			{
				UMockdevIoctlData* _tmp33_ = NULL;
				UMockdevIoctlData* _tmp34_;
				struct usbdevfs_urb* _tmp35_;
				UMockdevIoctlData* _tmp36_;
				UMockdevIoctlData* _tmp38_;
				_tmp34_ = data;
				_tmp35_ = urb;
				_tmp36_ = umockdev_ioctl_data_resolve (_tmp34_, offset, (gsize) (*_tmp35_).buffer_length, &_inner_error0_);
				_tmp33_ = _tmp36_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp37_ = FALSE;
					if (_inner_error0_->domain == G_IO_ERROR) {
						goto __catch1_g_io_error;
					}
					umockdev_urb_info_destroy (&info);
					_g_object_unref0 (data);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp37_;
				}
				_tmp38_ = _tmp33_;
				_tmp33_ = NULL;
				_g_object_unref0 (info.buffer_data);
				info.buffer_data = _tmp38_;
				_g_object_unref0 (_tmp33_);
			}
			goto __finally1;
			__catch1_g_io_error:
			{
				GError* e = NULL;
				GError* _tmp39_;
				const gchar* _tmp40_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp39_ = e;
				_tmp40_ = _tmp39_->message;
				g_warning ("umockdev-pcap.vala:134: Error resolving IOCtl data: %s", _tmp40_);
				result = FALSE;
				_g_error_free0 (e);
				umockdev_urb_info_destroy (&info);
				_g_object_unref0 (data);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp41_ = FALSE;
				umockdev_urb_info_destroy (&info);
				_g_object_unref0 (data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp41_;
			}
			info.pcap_id = (guint64) 0;
			_tmp42_ = self->priv->urbs;
			_tmp43_ = info;
			_tmp44_ = _tmp43_;
			_tmp45_ = _umockdev_urb_info_dup0 (&_tmp44_);
			g_array_append_val (_tmp42_, _tmp45_);
			umockdev_ioctl_client_complete (client, (glong) 0, 0);
			result = TRUE;
			umockdev_urb_info_destroy (&info);
			_g_object_unref0 (data);
			return result;
		}
		case USBDEVFS_REAPURB:
		case USBDEVFS_REAPURBNDELAY:
		{
			UMockdevUrbInfo* urb_info = NULL;
			GArray* _tmp46_;
			UMockdevUrbInfo* _tmp62_;
			urb_info = NULL;
			_tmp46_ = self->priv->discarded;
			if (_tmp46_->len > ((guint) 0)) {
				GArray* _tmp47_;
				UMockdevUrbInfo* _tmp48_;
				GArray* _tmp49_;
				UMockdevUrbInfo* _tmp50_;
				UMockdevUrbInfo* _tmp51_;
				struct usbdevfs_urb* urb = NULL;
				UMockdevUrbInfo* _tmp52_;
				UMockdevIoctlData* _tmp53_;
				guint8* _tmp54_;
				gint _tmp54__length1;
				UMockdevUrbInfo* _tmp55_;
				_tmp47_ = self->priv->discarded;
				_tmp48_ = _umockdev_urb_info_dup0 (g_array_index (_tmp47_, UMockdevUrbInfo*, (guint) 0));
				_umockdev_urb_info_free0 (urb_info);
				urb_info = _tmp48_;
				_tmp49_ = self->priv->discarded;
				_tmp50_ = vala_g_array_remove_index (_tmp49_, (guint) 0);
				_tmp51_ = _tmp50_;
				_umockdev_urb_info_free0 (_tmp51_);
				_tmp52_ = urb_info;
				_tmp53_ = (*_tmp52_).urb_data;
				_tmp54_ = _tmp53_->data;
				_tmp54__length1 = _tmp53_->data_len;
				urb = (struct usbdevfs_urb*) _tmp54_;
				(*urb).status = -ENOENT;
				_tmp55_ = urb_info;
				if ((*_tmp55_).pcap_id == ((guint64) 0)) {
					struct usbdevfs_urb* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					struct usbdevfs_urb* _tmp59_;
					struct usbdevfs_urb* _tmp60_;
					_tmp56_ = urb;
					_tmp57_ = umockdev_urb_type_to_string ((gint) (*_tmp56_).type);
					_tmp58_ = _tmp57_;
					_tmp59_ = urb;
					_tmp60_ = urb;
					g_message ("umockdev-pcap.vala:158: Replay may be stuck: Reaping discard URB of ty" \
"pe %s, for endpoint 0x%02x with length %d without corresponding submit", _tmp58_, (guint) (*_tmp59_).endpoint, (*_tmp60_).buffer_length);
					_g_free0 (_tmp58_);
				}
			} else {
				UMockdevUrbInfo* _tmp61_;
				_tmp61_ = umockdev_ioctl_usb_pcap_handler_next_reapable_urb (self);
				_umockdev_urb_info_free0 (urb_info);
				urb_info = _tmp61_;
			}
			_tmp62_ = urb_info;
			if (_tmp62_ != NULL) {
				UMockdevIoctlData* _tmp63_;
				UMockdevUrbInfo* _tmp64_;
				UMockdevIoctlData* _tmp65_;
				_tmp63_ = data;
				_tmp64_ = urb_info;
				_tmp65_ = (*_tmp64_).urb_data;
				umockdev_ioctl_data_set_ptr (_tmp63_, (gsize) 0, _tmp65_);
				umockdev_ioctl_client_complete (client, (glong) 0, 0);
				result = TRUE;
				_umockdev_urb_info_free0 (urb_info);
				_g_object_unref0 (data);
				return result;
			} else {
				umockdev_ioctl_client_complete (client, (glong) -1, EAGAIN);
				result = TRUE;
				_umockdev_urb_info_free0 (urb_info);
				_g_object_unref0 (data);
				return result;
			}
			_umockdev_urb_info_free0 (urb_info);
		}
		default:
		{
			umockdev_ioctl_client_complete (client, (glong) -1, ENOTTY);
			result = TRUE;
			_g_object_unref0 (data);
			return result;
		}
	}
}

static UMockdevUrbInfo*
umockdev_ioctl_usb_pcap_handler_next_reapable_urb (UMockdevIoctlUsbPcapHandler* self)
{
	gboolean debug = FALSE;
	guint64 now = 0ULL;
	GArray* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	UMockdevUrbInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	debug = FALSE;
	now = (guint64) g_get_monotonic_time ();
	_tmp0_ = self->priv->urbs;
	if (_tmp0_->len == ((guint) 0)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->cur_buf;
	_tmp1__length1 = self->priv->cur_buf_length1;
	if (_tmp1_ == NULL) {
		pcap_t* _tmp2_;
		guint8* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		pcap_usb_header_mmapped* urb_hdr = NULL;
		guint8* _tmp5_;
		gint _tmp5__length1;
		pcap_usb_header_mmapped* _tmp6_;
		pcap_usb_header_mmapped* _tmp7_;
		_tmp2_ = self->priv->rec;
		_tmp3_ = pcap_next (_tmp2_, &self->priv->cur_hdr);
		self->priv->cur_buf = _tmp3_;
		self->priv->cur_buf_length1 = -1;
		self->priv->_cur_buf_size_ = self->priv->cur_buf_length1;
		_tmp4_ = self->priv->cur_buf;
		_tmp4__length1 = self->priv->cur_buf_length1;
		if (_tmp4_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp5_ = self->priv->cur_buf;
		_tmp5__length1 = self->priv->cur_buf_length1;
		urb_hdr = (void*) _tmp5_;
		self->priv->cur_waiting_since = now;
		_tmp6_ = urb_hdr;
		_tmp7_ = urb_hdr;
		self->priv->last_pkt_time_ms = ((*_tmp6_).ts_sec * 1000) + ((*_tmp7_).ts_usec / 1000);
		self->priv->start_time_ms = self->priv->last_pkt_time_ms;
	}
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			guint8* _tmp11_;
			gint _tmp11__length1;
			struct pcap_pkthdr _tmp12_;
			pcap_usb_header_mmapped* urb_hdr = NULL;
			guint8* _tmp13_;
			gint _tmp13__length1;
			guint64 cur_pkt_time_ms = 0ULL;
			pcap_usb_header_mmapped* _tmp14_;
			pcap_usb_header_mmapped* _tmp15_;
			gboolean _tmp16_ = FALSE;
			pcap_usb_header_mmapped* _tmp17_;
			pcap_usb_header_mmapped* _tmp40_;
			pcap_usb_header_mmapped* _tmp128_;
			if (!_tmp8_) {
				pcap_t* _tmp9_;
				guint8* _tmp10_;
				_tmp9_ = self->priv->rec;
				_tmp10_ = pcap_next (_tmp9_, &self->priv->cur_hdr);
				self->priv->cur_buf = _tmp10_;
				self->priv->cur_buf_length1 = -1;
				self->priv->_cur_buf_size_ = self->priv->cur_buf_length1;
				self->priv->cur_waiting_since = now;
			}
			_tmp8_ = FALSE;
			_tmp11_ = self->priv->cur_buf;
			_tmp11__length1 = self->priv->cur_buf_length1;
			if (!(_tmp11_ != NULL)) {
				break;
			}
			_tmp12_ = self->priv->cur_hdr;
			_vala_assert (_tmp12_.caplen >= ((guint32) 64), "cur_hdr.caplen >= 64");
			_tmp13_ = self->priv->cur_buf;
			_tmp13__length1 = self->priv->cur_buf_length1;
			urb_hdr = (void*) _tmp13_;
			_tmp14_ = urb_hdr;
			_tmp15_ = urb_hdr;
			cur_pkt_time_ms = ((*_tmp14_).ts_sec * 1000) + ((*_tmp15_).ts_usec / 1000);
			_tmp17_ = urb_hdr;
			if (((gint) (*_tmp17_).bus_id) != self->priv->bus) {
				_tmp16_ = TRUE;
			} else {
				pcap_usb_header_mmapped* _tmp18_;
				_tmp18_ = urb_hdr;
				_tmp16_ = ((gint) (*_tmp18_).device_address) != self->priv->device;
			}
			if (_tmp16_) {
				continue;
			}
			if (((now - self->priv->cur_waiting_since) / 1000) > (2000 + (cur_pkt_time_ms - self->priv->last_pkt_time_ms))) {
				pcap_usb_header_mmapped* _tmp19_;
				pcap_usb_header_mmapped* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				pcap_usb_header_mmapped* _tmp23_;
				pcap_usb_header_mmapped* _tmp24_;
				GArray* _tmp25_;
				g_message ("umockdev-pcap.vala:229: Stuck for %lu ms, recording needed %lu ms", ((gulong) (now - self->priv->cur_waiting_since)) / 1000, (gulong) (cur_pkt_time_ms - self->priv->last_pkt_time_ms));
				_tmp19_ = urb_hdr;
				_tmp20_ = urb_hdr;
				_tmp21_ = umockdev_urb_type_to_string ((gint) (*_tmp20_).transfer_type);
				_tmp22_ = _tmp21_;
				_tmp23_ = urb_hdr;
				_tmp24_ = urb_hdr;
				g_message ("umockdev-pcap.vala:232: Trying to reap at recording position %c %s pac" \
"ket, for endpoint 0x%02x with length %u, replay may be stuck (time: %." \
"3f)", (gint) (*_tmp19_).event_type, _tmp22_, (guint) (*_tmp23_).endpoint_number, (guint) (*_tmp24_).urb_len, (cur_pkt_time_ms - self->priv->start_time_ms) / 1000.0);
				_g_free0 (_tmp22_);
				_tmp25_ = self->priv->urbs;
				g_message ("umockdev-pcap.vala:234: The device has currently %u in-flight URBs:", _tmp25_->len);
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							GArray* _tmp28_;
							UMockdevUrbInfo* urb_data = NULL;
							GArray* _tmp29_;
							struct usbdevfs_urb* urb = NULL;
							UMockdevUrbInfo* _tmp30_;
							UMockdevIoctlData* _tmp31_;
							guint8* _tmp32_;
							gint _tmp32__length1;
							const gchar* _tmp33_ = NULL;
							UMockdevUrbInfo* _tmp34_;
							struct usbdevfs_urb* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							struct usbdevfs_urb* _tmp38_;
							struct usbdevfs_urb* _tmp39_;
							if (!_tmp26_) {
								gint _tmp27_;
								_tmp27_ = i;
								i = _tmp27_ + 1;
							}
							_tmp26_ = FALSE;
							_tmp28_ = self->priv->urbs;
							if (!(((guint) i) < _tmp28_->len)) {
								break;
							}
							_tmp29_ = self->priv->urbs;
							urb_data = g_array_index (_tmp29_, UMockdevUrbInfo*, (guint) i);
							_tmp30_ = urb_data;
							_tmp31_ = (*_tmp30_).urb_data;
							_tmp32_ = _tmp31_->data;
							_tmp32__length1 = _tmp31_->data_len;
							urb = (struct usbdevfs_urb*) _tmp32_;
							_tmp34_ = urb_data;
							if ((*_tmp34_).pcap_id == ((guint64) 0)) {
								_tmp33_ = "NOT ";
							} else {
								_tmp33_ = "";
							}
							_tmp35_ = urb;
							_tmp36_ = umockdev_urb_type_to_string ((gint) (*_tmp35_).type);
							_tmp37_ = _tmp36_;
							_tmp38_ = urb;
							_tmp39_ = urb;
							g_message ("umockdev-pcap.vala:240:    %s URB, for endpoint 0x%02x with length %d;" \
" %ssubmitted", _tmp37_, (guint) (*_tmp38_).endpoint, (*_tmp39_).buffer_length, _tmp33_);
							_g_free0 (_tmp37_);
						}
					}
				}
				self->priv->cur_waiting_since = now;
				debug = TRUE;
			}
			_tmp40_ = urb_hdr;
			if ((*_tmp40_).event_type == ((guint8) 'S')) {
				gint i = 0;
				GArray* _tmp96_;
				{
					gboolean _tmp41_ = FALSE;
					i = 0;
					_tmp41_ = TRUE;
					while (TRUE) {
						GArray* _tmp43_;
						UMockdevUrbInfo* urb_data = NULL;
						GArray* _tmp44_;
						struct usbdevfs_urb* urb = NULL;
						UMockdevUrbInfo* _tmp45_;
						UMockdevIoctlData* _tmp46_;
						guint8* _tmp47_;
						gint _tmp47__length1;
						UMockdevUrbInfo* _tmp48_;
						guint8* urb_buffer = NULL;
						struct usbdevfs_urb* _tmp49_;
						guint8* _tmp50_;
						gint _tmp50__length1;
						gint urb_buffer_length = 0;
						struct usbdevfs_urb* _tmp51_;
						struct usbdevfs_urb* _tmp52_;
						gboolean _tmp55_ = FALSE;
						gboolean _tmp56_ = FALSE;
						struct usbdevfs_urb* _tmp57_;
						pcap_usb_header_mmapped* _tmp58_;
						gboolean _tmp65_ = FALSE;
						struct usbdevfs_urb* _tmp66_;
						pcap_usb_header_mmapped* _tmp70_;
						UMockdevUrbInfo* _tmp92_;
						pcap_usb_header_mmapped* _tmp93_;
						pcap_usb_header_mmapped* _tmp94_;
						pcap_usb_header_mmapped* _tmp95_;
						if (!_tmp41_) {
							gint _tmp42_;
							_tmp42_ = i;
							i = _tmp42_ + 1;
						}
						_tmp41_ = FALSE;
						_tmp43_ = self->priv->urbs;
						if (!(((guint) i) < _tmp43_->len)) {
							break;
						}
						_tmp44_ = self->priv->urbs;
						urb_data = g_array_index (_tmp44_, UMockdevUrbInfo*, (guint) i);
						_tmp45_ = urb_data;
						_tmp46_ = (*_tmp45_).urb_data;
						_tmp47_ = _tmp46_->data;
						_tmp47__length1 = _tmp46_->data_len;
						urb = (struct usbdevfs_urb*) _tmp47_;
						_tmp48_ = urb_data;
						if ((*_tmp48_).pcap_id != ((guint64) 0)) {
							continue;
						}
						_tmp49_ = urb;
						_tmp50_ = (*_tmp49_).buffer;
						_tmp50__length1 = -1;
						urb_buffer = _tmp50_;
						_tmp51_ = urb;
						urb_buffer_length = (*_tmp51_).buffer_length;
						_tmp52_ = urb;
						if (((gint) (*_tmp52_).type) == UMOCKDEV_URB_CONTROL) {
							struct usbdevfs_urb* _tmp53_;
							guint8* _tmp54_;
							gint _tmp54__length1;
							_vala_assert (urb_buffer_length >= 8, "urb_buffer_length >= 8");
							_tmp53_ = urb;
							_tmp54_ = (*_tmp53_).buffer;
							_tmp54__length1 = -1;
							urb_buffer = &_tmp54_[8];
							urb_buffer_length -= 8;
						}
						_tmp57_ = urb;
						_tmp58_ = urb_hdr;
						if ((*_tmp57_).type != (*_tmp58_).transfer_type) {
							_tmp56_ = TRUE;
						} else {
							gboolean _tmp59_ = FALSE;
							struct usbdevfs_urb* _tmp60_;
							_tmp60_ = urb;
							if (((gint) (*_tmp60_).type) != UMOCKDEV_URB_CONTROL) {
								struct usbdevfs_urb* _tmp61_;
								pcap_usb_header_mmapped* _tmp62_;
								_tmp61_ = urb;
								_tmp62_ = urb_hdr;
								_tmp59_ = (*_tmp61_).endpoint != (*_tmp62_).endpoint_number;
							} else {
								_tmp59_ = FALSE;
							}
							_tmp56_ = _tmp59_;
						}
						if (_tmp56_) {
							_tmp55_ = TRUE;
						} else {
							pcap_usb_header_mmapped* _tmp63_;
							_tmp63_ = urb_hdr;
							_tmp55_ = ((guint32) urb_buffer_length) != (*_tmp63_).urb_len;
						}
						if (_tmp55_) {
							if (debug) {
								FILE* _tmp64_;
								_tmp64_ = stderr;
								fprintf (_tmp64_, "UMockdev: Queued URB %d has a metadata mismatch!\n", i);
							}
							continue;
						}
						_tmp66_ = urb;
						if (((gint) (*_tmp66_).type) == UMOCKDEV_URB_CONTROL) {
							pcap_usb_header_mmapped* _tmp67_;
							_tmp67_ = urb_hdr;
							_tmp65_ = ((gint) (*_tmp67_).setup_flag) == 0;
						} else {
							_tmp65_ = FALSE;
						}
						if (_tmp65_) {
							struct usbdevfs_urb* _tmp68_;
							guint8* _tmp69_;
							gint _tmp69__length1;
							_tmp68_ = urb;
							_tmp69_ = (*_tmp68_).buffer;
							_tmp69__length1 = -1;
							if (memcmp (_tmp69_, &(*urb_hdr).s, (gsize) 8) != 0) {
								continue;
							}
						}
						_tmp70_ = urb_hdr;
						if ((*_tmp70_).data_len > ((guint32) 0)) {
							pcap_usb_header_mmapped* _tmp71_;
							pcap_usb_header_mmapped* _tmp72_;
							guint8* _tmp73_;
							guint8* _tmp74_;
							gint _tmp74__length1;
							_tmp71_ = urb_hdr;
							_vala_assert (((gint) (*_tmp71_).data_flag) == 0, "urb_hdr.data_flag == 0");
							_tmp72_ = urb_hdr;
							_vala_assert ((*_tmp72_).data_len == ((guint32) urb_buffer_length), "urb_hdr.data_len == urb_buffer_length");
							_tmp73_ = urb_buffer;
							_tmp74_ = self->priv->cur_buf;
							_tmp74__length1 = self->priv->cur_buf_length1;
							if (memcmp (_tmp73_, &_tmp74_[sizeof (pcap_usb_header_mmapped)], (gsize) urb_buffer_length) != 0) {
								if (debug) {
									FILE* _tmp75_;
									FILE* _tmp83_;
									FILE* _tmp91_;
									_tmp75_ = stderr;
									fprintf (_tmp75_, "UMockdev: Queued URB %d has a buffer mismatch! Recording:", i);
									{
										gint j = 0;
										j = 0;
										{
											gboolean _tmp76_ = FALSE;
											_tmp76_ = TRUE;
											while (TRUE) {
												gboolean _tmp78_ = FALSE;
												FILE* _tmp80_;
												guint8* _tmp81_;
												gint _tmp81__length1;
												guint8 _tmp82_;
												if (!_tmp76_) {
													gint _tmp77_;
													_tmp77_ = j;
													j = _tmp77_ + 1;
												}
												_tmp76_ = FALSE;
												if (!(j < urb_buffer_length)) {
													break;
												}
												if (j > 0) {
													_tmp78_ = (j % 8) == 0;
												} else {
													_tmp78_ = FALSE;
												}
												if (_tmp78_) {
													FILE* _tmp79_;
													_tmp79_ = stderr;
													fprintf (_tmp79_, "\n");
												}
												_tmp80_ = stderr;
												_tmp81_ = self->priv->cur_buf;
												_tmp81__length1 = self->priv->cur_buf_length1;
												_tmp82_ = _tmp81_[sizeof (pcap_usb_header_mmapped) + j];
												fprintf (_tmp80_, " %02x", (guint) _tmp82_);
											}
										}
									}
									_tmp83_ = stderr;
									fprintf (_tmp83_, "\nUMockdev: Submitted:");
									{
										gint j = 0;
										j = 0;
										{
											gboolean _tmp84_ = FALSE;
											_tmp84_ = TRUE;
											while (TRUE) {
												gboolean _tmp86_ = FALSE;
												FILE* _tmp88_;
												guint8* _tmp89_;
												guint8 _tmp90_;
												if (!_tmp84_) {
													gint _tmp85_;
													_tmp85_ = j;
													j = _tmp85_ + 1;
												}
												_tmp84_ = FALSE;
												if (!(j < urb_buffer_length)) {
													break;
												}
												if (j > 0) {
													_tmp86_ = (j % 8) == 0;
												} else {
													_tmp86_ = FALSE;
												}
												if (_tmp86_) {
													FILE* _tmp87_;
													_tmp87_ = stderr;
													fprintf (_tmp87_, "\n");
												}
												_tmp88_ = stderr;
												_tmp89_ = urb_buffer;
												_tmp90_ = _tmp89_[j];
												fprintf (_tmp88_, " %02x", (guint) _tmp90_);
											}
										}
									}
									_tmp91_ = stderr;
									fprintf (_tmp91_, "\n");
								}
								continue;
							}
						}
						_tmp92_ = urb_data;
						_tmp93_ = urb_hdr;
						(*_tmp92_).pcap_id = (*_tmp93_).id;
						_tmp94_ = urb_hdr;
						_tmp95_ = urb_hdr;
						self->priv->last_pkt_time_ms = ((*_tmp94_).ts_sec * 1000) + ((*_tmp95_).ts_usec / 1000);
						break;
					}
				}
				_tmp96_ = self->priv->urbs;
				if (((guint) i) != _tmp96_->len) {
					continue;
				}
			} else {
				UMockdevUrbInfo* urb_info = NULL;
				struct usbdevfs_urb* urb = NULL;
				pcap_usb_header_mmapped* _tmp97_;
				struct usbdevfs_urb* _tmp111_;
				pcap_usb_header_mmapped* _tmp112_;
				pcap_usb_header_mmapped* _tmp122_;
				pcap_usb_header_mmapped* _tmp123_;
				pcap_usb_header_mmapped* _tmp124_;
				pcap_usb_header_mmapped* _tmp125_;
				pcap_usb_header_mmapped* _tmp126_;
				pcap_usb_header_mmapped* _tmp127_;
				urb_info = NULL;
				urb = NULL;
				_tmp97_ = urb_hdr;
				_vala_assert ((*_tmp97_).event_type == ((guint8) 'C'), "urb_hdr.event_type == 'C'");
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp98_ = FALSE;
						_tmp98_ = TRUE;
						while (TRUE) {
							GArray* _tmp100_;
							GArray* _tmp101_;
							UMockdevUrbInfo* _tmp102_;
							UMockdevUrbInfo* _tmp103_;
							pcap_usb_header_mmapped* _tmp104_;
							if (!_tmp98_) {
								gint _tmp99_;
								_tmp99_ = i;
								i = _tmp99_ + 1;
							}
							_tmp98_ = FALSE;
							_tmp100_ = self->priv->urbs;
							if (!(((guint) i) < _tmp100_->len)) {
								break;
							}
							_tmp101_ = self->priv->urbs;
							_tmp102_ = _umockdev_urb_info_dup0 (g_array_index (_tmp101_, UMockdevUrbInfo*, (guint) i));
							_umockdev_urb_info_free0 (urb_info);
							urb_info = _tmp102_;
							_tmp103_ = urb_info;
							_tmp104_ = urb_hdr;
							if ((*_tmp103_).pcap_id == (*_tmp104_).id) {
								UMockdevUrbInfo* _tmp105_;
								UMockdevIoctlData* _tmp106_;
								guint8* _tmp107_;
								gint _tmp107__length1;
								GArray* _tmp108_;
								UMockdevUrbInfo* _tmp109_;
								UMockdevUrbInfo* _tmp110_;
								_tmp105_ = urb_info;
								_tmp106_ = (*_tmp105_).urb_data;
								_tmp107_ = _tmp106_->data;
								_tmp107__length1 = _tmp106_->data_len;
								urb = (struct usbdevfs_urb*) _tmp107_;
								_tmp108_ = self->priv->urbs;
								_tmp109_ = vala_g_array_remove_index (_tmp108_, (guint) i);
								_tmp110_ = _tmp109_;
								_umockdev_urb_info_free0 (_tmp110_);
								break;
							}
							_umockdev_urb_info_free0 (urb_info);
							urb_info = NULL;
						}
					}
				}
				_tmp111_ = urb;
				if (_tmp111_ == NULL) {
					_umockdev_urb_info_free0 (urb_info);
					continue;
				}
				_tmp112_ = urb_hdr;
				if ((*_tmp112_).data_len > ((guint32) 0)) {
					pcap_usb_header_mmapped* _tmp113_;
					guint8* urb_buffer = NULL;
					struct usbdevfs_urb* _tmp114_;
					guint8* _tmp115_;
					gint _tmp115__length1;
					struct usbdevfs_urb* _tmp116_;
					guint8* _tmp119_;
					guint8* _tmp120_;
					gint _tmp120__length1;
					pcap_usb_header_mmapped* _tmp121_;
					_tmp113_ = urb_hdr;
					_vala_assert (((gint) (*_tmp113_).data_flag) == 0, "urb_hdr.data_flag == 0");
					_tmp114_ = urb;
					_tmp115_ = (*_tmp114_).buffer;
					_tmp115__length1 = -1;
					urb_buffer = _tmp115_;
					_tmp116_ = urb;
					if (((gint) (*_tmp116_).type) == UMOCKDEV_URB_CONTROL) {
						struct usbdevfs_urb* _tmp117_;
						guint8* _tmp118_;
						gint _tmp118__length1;
						_tmp117_ = urb;
						_tmp118_ = (*_tmp117_).buffer;
						_tmp118__length1 = -1;
						urb_buffer = &_tmp118_[8];
					}
					_tmp119_ = urb_buffer;
					_tmp120_ = self->priv->cur_buf;
					_tmp120__length1 = self->priv->cur_buf_length1;
					_tmp121_ = urb_hdr;
					memcpy (_tmp119_, &_tmp120_[sizeof (pcap_usb_header_mmapped)], (gsize) (*_tmp121_).data_len);
				}
				_tmp122_ = urb_hdr;
				(*urb).status = (gint) (*_tmp122_).status;
				_tmp123_ = urb_hdr;
				(*urb).actual_length = (gint) (*_tmp123_).urb_len;
				_tmp124_ = urb_hdr;
				_vala_assert ((*_tmp124_).start_frame == ((guint32) 0), "urb_hdr.start_frame == 0");
				_tmp125_ = urb_hdr;
				(*urb).start_frame = (gint) (*_tmp125_).start_frame;
				_tmp126_ = urb_hdr;
				_tmp127_ = urb_hdr;
				self->priv->last_pkt_time_ms = ((*_tmp126_).ts_sec * 1000) + ((*_tmp127_).ts_usec / 1000);
				result = urb_info;
				return result;
			}
			_tmp128_ = urb_hdr;
			if (((gint) (*_tmp128_).transfer_type) == UMOCKDEV_URB_CONTROL) {
				gboolean _tmp129_ = FALSE;
				gboolean _tmp130_ = FALSE;
				pcap_usb_header_mmapped* _tmp131_;
				_tmp131_ = urb_hdr;
				if ((*_tmp131_).event_type == ((guint8) 'S')) {
					pcap_usb_header_mmapped* _tmp132_;
					_tmp132_ = urb_hdr;
					_tmp130_ = ((gint) (*_tmp132_).setup_flag) == 0;
				} else {
					_tmp130_ = FALSE;
				}
				if (_tmp130_) {
					_tmp129_ = ((gint) ((*((guint8*) (&(*urb_hdr).s))) & 0x60)) == 0x00;
				} else {
					_tmp129_ = FALSE;
				}
				if (_tmp129_) {
					continue;
				}
			}
			result = NULL;
			return result;
		}
	}
	result = NULL;
	return result;
}

static void
umockdev_ioctl_usb_pcap_handler_class_init (UMockdevIoctlUsbPcapHandlerClass * klass,
                                            gpointer klass_data)
{
	umockdev_ioctl_usb_pcap_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevIoctlUsbPcapHandler_private_offset);
	((UMockdevIoctlBaseClass *) klass)->handle_ioctl = (gboolean (*) (UMockdevIoctlBase*, UMockdevIoctlClient*)) umockdev_ioctl_usb_pcap_handler_real_handle_ioctl;
	G_OBJECT_CLASS (klass)->finalize = umockdev_ioctl_usb_pcap_handler_finalize;
}

static void
umockdev_ioctl_usb_pcap_handler_instance_init (UMockdevIoctlUsbPcapHandler * self,
                                               gpointer klass)
{
	self->priv = umockdev_ioctl_usb_pcap_handler_get_instance_private (self);
	self->priv->cur_buf = NULL;
	self->priv->cur_buf_length1 = 0;
	self->priv->_cur_buf_size_ = self->priv->cur_buf_length1;
}

static void
umockdev_ioctl_usb_pcap_handler_finalize (GObject * obj)
{
	UMockdevIoctlUsbPcapHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_IOCTL_USB_PCAP_HANDLER, UMockdevIoctlUsbPcapHandler);
	_pcap_close0 (self->priv->rec);
	_g_array_unref0 (self->priv->urbs);
	_g_array_unref0 (self->priv->discarded);
	G_OBJECT_CLASS (umockdev_ioctl_usb_pcap_handler_parent_class)->finalize (obj);
}

static GType
umockdev_ioctl_usb_pcap_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UMockdevIoctlUsbPcapHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_ioctl_usb_pcap_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevIoctlUsbPcapHandler), 0, (GInstanceInitFunc) umockdev_ioctl_usb_pcap_handler_instance_init, NULL };
	GType umockdev_ioctl_usb_pcap_handler_type_id;
	umockdev_ioctl_usb_pcap_handler_type_id = g_type_register_static (UMOCKDEV_TYPE_IOCTL_BASE, "UMockdevIoctlUsbPcapHandler", &g_define_type_info, 0);
	UMockdevIoctlUsbPcapHandler_private_offset = g_type_add_instance_private (umockdev_ioctl_usb_pcap_handler_type_id, sizeof (UMockdevIoctlUsbPcapHandlerPrivate));
	return umockdev_ioctl_usb_pcap_handler_type_id;
}

GType
umockdev_ioctl_usb_pcap_handler_get_type (void)
{
	static volatile gsize umockdev_ioctl_usb_pcap_handler_type_id__once = 0;
	if (g_once_init_enter (&umockdev_ioctl_usb_pcap_handler_type_id__once)) {
		GType umockdev_ioctl_usb_pcap_handler_type_id;
		umockdev_ioctl_usb_pcap_handler_type_id = umockdev_ioctl_usb_pcap_handler_get_type_once ();
		g_once_init_leave (&umockdev_ioctl_usb_pcap_handler_type_id__once, umockdev_ioctl_usb_pcap_handler_type_id);
	}
	return umockdev_ioctl_usb_pcap_handler_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

