/* WifiMenuItem.c generated by valac 0.56.17, the Vala compiler
 * generated from WifiMenuItem.vala, do not modify */

/*
 * Copyright 2015-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "network.h"
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME "panel-network-wireless-signal-%s-symbolic"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIFI_MENU_ITEM_0_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_AP_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NetworkWifiMenuItemPrivate {
	NMAccessPoint* _ap;
	NMDeviceState _state;
	GtkImage* error_img;
	GtkImage* img_strength;
	GtkImage* lock_img;
	GtkLabel* label;
	GtkRadioButton* radio_button;
	GtkSpinner* spinner;
	GList* ap_list;
};

static gint NetworkWifiMenuItem_private_offset;
static gpointer network_wifi_menu_item_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void network_wifi_menu_item_update (NetworkWifiMenuItem* self);
static void _network_wifi_menu_item_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static gboolean __lambda12_ (NetworkWifiMenuItem* self,
                      GtkWidget* b,
                      GdkEventButton* ev);
static gboolean ___lambda12__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void network_wifi_menu_item_update_ap (NetworkWifiMenuItem* self);
static void network_wifi_menu_item_set_ap (NetworkWifiMenuItem* self,
                                    NMAccessPoint* value);
static void network_wifi_menu_item_finalize (GObject * obj);
static GType network_wifi_menu_item_get_type_once (void);
static void _vala_network_wifi_menu_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_network_wifi_menu_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
network_wifi_menu_item_get_instance_private (NetworkWifiMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWifiMenuItem_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_network_wifi_menu_item_update_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	network_wifi_menu_item_update ((NetworkWifiMenuItem*) self);
}

static gboolean
__lambda12_ (NetworkWifiMenuItem* self,
             GtkWidget* b,
             GdkEventButton* ev)
{
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	g_signal_emit_by_name ((GtkListBoxRow*) self, "activate");
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda12__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda12_ ((NetworkWifiMenuItem*) self, _sender, event);
	return result;
}

NetworkWifiMenuItem*
network_wifi_menu_item_construct (GType object_type,
                                  NMAccessPoint* ap,
                                  GtkRadioButton* blank_radio)
{
	NetworkWifiMenuItem * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_;
	GtkLabel* _tmp3_;
	GtkImage* _tmp4_ = NULL;
	GtkImage* _tmp5_;
	gchar* _tmp6_;
	GtkImage* _tmp7_ = NULL;
	GtkSpinner* _tmp8_;
	GtkBox* box = NULL;
	GtkBox* _tmp9_;
	GtkRadioButton* _tmp10_;
	GtkSpinner* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkRadioButton* _tmp15_;
	g_return_val_if_fail (ap != NULL, NULL);
	g_return_val_if_fail (blank_radio != NULL, NULL);
	self = (NetworkWifiMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_MIDDLE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp0_;
	_tmp1_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (blank_radio);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = _tmp1_;
	_tmp2_ = self->priv->radio_button;
	_tmp3_ = self->priv->label;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp4_, "icon-size", (gint) GTK_ICON_SIZE_MENU, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->img_strength);
	self->priv->img_strength = _tmp4_;
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("channel-insecure-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->lock_img);
	self->priv->lock_img = _tmp5_;
	_tmp6_ = g_strdup (_ ("Unable to connect"));
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("process-error-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp6_);
	_g_free0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->error_img);
	self->priv->error_img = _tmp7_;
	_tmp8_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp8_;
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp9_);
	box = _tmp9_;
	_tmp10_ = self->priv->radio_button;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->error_img;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->lock_img;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->img_strength;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp14_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	(self->priv->ap_list == NULL) ? NULL : (self->priv->ap_list = (_g_list_free__g_object_unref0_ (self->priv->ap_list), NULL));
	self->priv->ap_list = NULL;
	network_wifi_menu_item_add_ap (self, ap);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _network_wifi_menu_item_update_g_object_notify, self, 0);
	_tmp15_ = self->priv->radio_button;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "button-release-event", (GCallback) ___lambda12__gtk_widget_button_release_event, self, 0);
	_g_object_unref0 (box);
	return self;
}

NetworkWifiMenuItem*
network_wifi_menu_item_new (NMAccessPoint* ap,
                            GtkRadioButton* blank_radio)
{
	return network_wifi_menu_item_construct (NETWORK_TYPE_WIFI_MENU_ITEM, ap, blank_radio);
}

static void
network_wifi_menu_item_update_ap (NetworkWifiMenuItem* self)
{
	guint8 strength = 0U;
	GList* _tmp0_;
	GtkLabel* _tmp6_;
	NMAccessPoint* _tmp7_;
	GBytes* _tmp8_;
	gsize _tmp9_ = 0;
	guint8* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	NM80211ApSecurityFlags flags = 0U;
	NMAccessPoint* _tmp13_;
	NMAccessPoint* _tmp14_;
	gboolean is_secured = FALSE;
	GtkImage* _tmp16_;
	GtkImage* _tmp17_;
	GtkImage* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	strength = (guint8) 0;
	_tmp0_ = self->priv->ap_list;
	{
		GList* acess_point_collection = NULL;
		GList* acess_point_it = NULL;
		acess_point_collection = _tmp0_;
		for (acess_point_it = acess_point_collection; acess_point_it != NULL; acess_point_it = acess_point_it->next) {
			NMAccessPoint* acess_point = NULL;
			acess_point = (NMAccessPoint*) acess_point_it->data;
			{
				NMAccessPoint* _tmp1_ = NULL;
				NMAccessPoint* _tmp2_;
				NMAccessPoint* _tmp5_;
				_tmp2_ = acess_point;
				if (strength > nm_access_point_get_strength (_tmp2_)) {
					NMAccessPoint* _tmp3_;
					_tmp3_ = self->priv->_ap;
					_tmp1_ = _tmp3_;
				} else {
					NMAccessPoint* _tmp4_;
					_tmp4_ = acess_point;
					_tmp1_ = _tmp4_;
				}
				network_wifi_menu_item_set_ap (self, _tmp1_);
				_tmp5_ = acess_point;
				strength = MAX (strength, nm_access_point_get_strength (_tmp5_));
			}
		}
	}
	_tmp6_ = self->priv->label;
	_tmp7_ = self->priv->_ap;
	_tmp8_ = nm_access_point_get_ssid (_tmp7_);
	_tmp10_ = g_bytes_get_data (_tmp8_, &_tmp9_);
	_tmp11_ = nm_utils_ssid_to_utf8 (_tmp10_, (gsize) _tmp9_);
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp6_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->_ap;
	_tmp14_ = self->priv->_ap;
	flags = nm_access_point_get_wpa_flags (_tmp13_) | nm_access_point_get_rsn_flags (_tmp14_);
	is_secured = FALSE;
	if ((flags & NM_802_11_AP_SEC_GROUP_WEP40) == NM_802_11_AP_SEC_GROUP_WEP40) {
		is_secured = TRUE;
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("40/64-bit WEP encrypted"));
	} else {
		if ((flags & NM_802_11_AP_SEC_GROUP_WEP104) == NM_802_11_AP_SEC_GROUP_WEP104) {
			is_secured = TRUE;
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("104/128-bit WEP encrypted"));
		} else {
			if ((flags & NM_802_11_AP_SEC_KEY_MGMT_SAE) == NM_802_11_AP_SEC_KEY_MGMT_SAE) {
				is_secured = TRUE;
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("WPA3 encrypted"));
			} else {
				if ((flags & NM_802_11_AP_SEC_KEY_MGMT_PSK) == NM_802_11_AP_SEC_KEY_MGMT_PSK) {
					is_secured = TRUE;
					gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("WPA encrypted"));
				} else {
					gboolean _tmp15_ = FALSE;
					if ((flags & NM_802_11_AP_SEC_KEY_MGMT_OWE) == NM_802_11_AP_SEC_KEY_MGMT_OWE) {
						_tmp15_ = TRUE;
					} else {
						_tmp15_ = (flags & NM_802_11_AP_SEC_KEY_MGMT_OWE_TM) == NM_802_11_AP_SEC_KEY_MGMT_OWE_TM;
					}
					if (_tmp15_) {
						is_secured = TRUE;
						gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("Passwordless encrypted"));
					} else {
						if (flags != NM_802_11_AP_SEC_NONE) {
							is_secured = TRUE;
							gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("Encrypted"));
						} else {
							gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("Unsecured"));
						}
					}
				}
			}
		}
	}
	_tmp16_ = self->priv->lock_img;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, !is_secured);
	_tmp17_ = self->priv->lock_img;
	_tmp18_ = self->priv->lock_img;
	_tmp19_ = gtk_widget_get_visible ((GtkWidget*) _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp17_, !_tmp20_);
}

static void
network_wifi_menu_item_update (NetworkWifiMenuItem* self)
{
	guint8 _tmp0_;
	guint8 _tmp1_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkSpinner* _tmp21_;
	NMDeviceState _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_wifi_menu_item_get_strength (self);
	_tmp1_ = _tmp0_;
	if (((gint) _tmp1_) < 30) {
		GtkImage* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->img_strength;
		_tmp3_ = g_strdup_printf (NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME, "weak");
		_tmp4_ = _tmp3_;
		g_object_set (_tmp2_, "icon-name", _tmp4_, NULL);
		_g_free0 (_tmp4_);
	} else {
		guint8 _tmp5_;
		guint8 _tmp6_;
		_tmp5_ = network_wifi_menu_item_get_strength (self);
		_tmp6_ = _tmp5_;
		if (((gint) _tmp6_) < 55) {
			GtkImage* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = self->priv->img_strength;
			_tmp8_ = g_strdup_printf (NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME, "ok");
			_tmp9_ = _tmp8_;
			g_object_set (_tmp7_, "icon-name", _tmp9_, NULL);
			_g_free0 (_tmp9_);
		} else {
			guint8 _tmp10_;
			guint8 _tmp11_;
			_tmp10_ = network_wifi_menu_item_get_strength (self);
			_tmp11_ = _tmp10_;
			if (((gint) _tmp11_) < 80) {
				GtkImage* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = self->priv->img_strength;
				_tmp13_ = g_strdup_printf (NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME, "good");
				_tmp14_ = _tmp13_;
				g_object_set (_tmp12_, "icon-name", _tmp14_, NULL);
				_g_free0 (_tmp14_);
			} else {
				GtkImage* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp15_ = self->priv->img_strength;
				_tmp16_ = g_strdup_printf (NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME, "excellent");
				_tmp17_ = _tmp16_;
				g_object_set (_tmp15_, "icon-name", _tmp17_, NULL);
				_g_free0 (_tmp17_);
			}
		}
	}
	_tmp18_ = self->priv->error_img;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp18_, TRUE);
	_tmp19_ = self->priv->error_img;
	gtk_widget_set_visible ((GtkWidget*) _tmp19_, FALSE);
	_tmp20_ = self->priv->error_img;
	gtk_widget_hide ((GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->spinner;
	gtk_spinner_stop (_tmp21_);
	_tmp22_ = self->priv->_state;
	switch (_tmp22_) {
		case NM_DEVICE_STATE_FAILED:
		{
			GtkImage* _tmp23_;
			GtkImage* _tmp24_;
			_tmp23_ = self->priv->error_img;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp23_, FALSE);
			_tmp24_ = self->priv->error_img;
			gtk_widget_set_visible ((GtkWidget*) _tmp24_, TRUE);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			GtkSpinner* _tmp25_;
			GtkRadioButton* _tmp26_;
			gboolean _tmp27_;
			gboolean _tmp28_;
			_tmp25_ = self->priv->spinner;
			gtk_spinner_start (_tmp25_);
			_tmp26_ = self->priv->radio_button;
			_tmp27_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp26_);
			_tmp28_ = _tmp27_;
			if (!_tmp28_) {
				g_critical ("WifiMenuItem.vala:170: An access point is being connected but not acti" \
"ve.");
			}
			break;
		}
		default:
		{
			break;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
network_wifi_menu_item_add_ap (NetworkWifiMenuItem* self,
                               NMAccessPoint* ap)
{
	NMAccessPoint* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap != NULL);
	_tmp0_ = _g_object_ref0 (ap);
	self->priv->ap_list = g_list_append (self->priv->ap_list, _tmp0_);
	network_wifi_menu_item_update_ap (self);
	network_wifi_menu_item_update (self);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

gboolean
network_wifi_menu_item_remove_ap (NetworkWifiMenuItem* self,
                                  NMAccessPoint* ap)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ap != NULL, FALSE);
	self->priv->ap_list = vala_g_list_remove_full (self->priv->ap_list, ap, _g_object_unref0_);
	network_wifi_menu_item_update_ap (self);
	_tmp0_ = self->priv->ap_list;
	result = g_list_length (_tmp0_) > ((guint) 0);
	return result;
}

NMAccessPoint*
network_wifi_menu_item_get_ap (NetworkWifiMenuItem* self)
{
	NMAccessPoint* result;
	NMAccessPoint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ap;
	result = _tmp0_;
	return result;
}

static void
network_wifi_menu_item_set_ap (NetworkWifiMenuItem* self,
                               NMAccessPoint* value)
{
	NMAccessPoint* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_ap (self);
	if (old_value != value) {
		NMAccessPoint* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_ap);
		self->priv->_ap = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_AP_PROPERTY]);
	}
}

NMDeviceState
network_wifi_menu_item_get_state (NetworkWifiMenuItem* self)
{
	NMDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
network_wifi_menu_item_set_state (NetworkWifiMenuItem* self,
                                  NMDeviceState value)
{
	NMDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY]);
	}
}

GBytes*
network_wifi_menu_item_get_ssid (NetworkWifiMenuItem* self)
{
	GBytes* result;
	NMAccessPoint* _tmp0_;
	GBytes* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ap;
	_tmp1_ = nm_access_point_get_ssid (_tmp0_);
	result = _tmp1_;
	return result;
}

guint8
network_wifi_menu_item_get_strength (NetworkWifiMenuItem* self)
{
	guint8 result;
	guint8 strength = 0U;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	strength = (guint8) 0;
	_tmp0_ = self->priv->ap_list;
	{
		GList* ap_collection = NULL;
		GList* ap_it = NULL;
		ap_collection = _tmp0_;
		for (ap_it = ap_collection; ap_it != NULL; ap_it = ap_it->next) {
			NMAccessPoint* ap = NULL;
			ap = (NMAccessPoint*) ap_it->data;
			{
				NMAccessPoint* _tmp1_;
				_tmp1_ = ap;
				strength = MAX (strength, nm_access_point_get_strength (_tmp1_));
			}
		}
	}
	result = strength;
	return result;
}

void
network_wifi_menu_item_set_active (NetworkWifiMenuItem* self,
                                   gboolean value)
{
	GtkRadioButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->radio_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY]);
}

static void
network_wifi_menu_item_base_init (NetworkWifiMenuItemClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), GTK_STYLE_CLASS_MENUITEM);
}

static void
network_wifi_menu_item_class_init (NetworkWifiMenuItemClass * klass,
                                   gpointer klass_data)
{
	network_wifi_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWifiMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_wifi_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_wifi_menu_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = network_wifi_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_AP_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_AP_PROPERTY] = g_param_spec_object ("ap", "ap", "ap", nm_access_point_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", nm_device_state_get_type (), NM_DEVICE_STATE_DISCONNECTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY] = g_param_spec_boxed ("ssid", "ssid", "ssid", G_TYPE_BYTES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY] = g_param_spec_uchar ("strength", "strength", "strength", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
network_wifi_menu_item_instance_init (NetworkWifiMenuItem * self,
                                      gpointer klass)
{
	self->priv = network_wifi_menu_item_get_instance_private (self);
	self->priv->_state = NM_DEVICE_STATE_DISCONNECTED;
}

static void
network_wifi_menu_item_finalize (GObject * obj)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	_g_object_unref0 (self->priv->_ap);
	_g_object_unref0 (self->priv->error_img);
	_g_object_unref0 (self->priv->img_strength);
	_g_object_unref0 (self->priv->lock_img);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->spinner);
	(self->priv->ap_list == NULL) ? NULL : (self->priv->ap_list = (_g_list_free__g_object_unref0_ (self->priv->ap_list), NULL));
	G_OBJECT_CLASS (network_wifi_menu_item_parent_class)->finalize (obj);
}

static GType
network_wifi_menu_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiMenuItemClass), (GBaseInitFunc) network_wifi_menu_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiMenuItem), 0, (GInstanceInitFunc) network_wifi_menu_item_instance_init, NULL };
	GType network_wifi_menu_item_type_id;
	network_wifi_menu_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "NetworkWifiMenuItem", &g_define_type_info, 0);
	NetworkWifiMenuItem_private_offset = g_type_add_instance_private (network_wifi_menu_item_type_id, sizeof (NetworkWifiMenuItemPrivate));
	return network_wifi_menu_item_type_id;
}

GType
network_wifi_menu_item_get_type (void)
{
	static volatile gsize network_wifi_menu_item_type_id__once = 0;
	if (g_once_init_enter (&network_wifi_menu_item_type_id__once)) {
		GType network_wifi_menu_item_type_id;
		network_wifi_menu_item_type_id = network_wifi_menu_item_get_type_once ();
		g_once_init_leave (&network_wifi_menu_item_type_id__once, network_wifi_menu_item_type_id);
	}
	return network_wifi_menu_item_type_id__once;
}

static void
_vala_network_wifi_menu_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	switch (property_id) {
		case NETWORK_WIFI_MENU_ITEM_AP_PROPERTY:
		g_value_set_object (value, network_wifi_menu_item_get_ap (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY:
		g_value_set_enum (value, network_wifi_menu_item_get_state (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY:
		g_value_set_boxed (value, network_wifi_menu_item_get_ssid (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY:
		g_value_set_uchar (value, network_wifi_menu_item_get_strength (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_wifi_menu_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	switch (property_id) {
		case NETWORK_WIFI_MENU_ITEM_AP_PROPERTY:
		network_wifi_menu_item_set_ap (self, g_value_get_object (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY:
		network_wifi_menu_item_set_state (self, g_value_get_enum (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY:
		network_wifi_menu_item_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

