/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUComputePipelineDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUAutoLayoutMode.h"
#include "JSGPUPipelineLayout.h"
#include "JSGPUProgrammableStage.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUComputePipelineDescriptor>> convertDictionary<GPUComputePipelineDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUComputePipelineDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (layoutValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "layout"_s, "GPUComputePipelineDescriptor"_s, "(GPUPipelineLayout or GPUAutoLayoutMode)"_s);
        return ConversionResultException { };
    }
    auto layoutConversionResult = convert<IDLUnion<IDLInterface<GPUPipelineLayout>, IDLEnumeration<GPUAutoLayoutMode>>>(lexicalGlobalObject, layoutValue);
    if (layoutConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.layout = layoutConversionResult.releaseReturnValue();
    JSValue computeValue;
    if (isNullOrUndefined)
        computeValue = jsUndefined();
    else {
        computeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compute"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (computeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "compute"_s, "GPUComputePipelineDescriptor"_s, "GPUProgrammableStage"_s);
        return ConversionResultException { };
    }
    auto computeConversionResult = convert<IDLDictionary<GPUProgrammableStage>>(lexicalGlobalObject, computeValue);
    if (computeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.compute = computeConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

