/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xdg-desktop-portal-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_handle,
        const gchar *arg_app_id,
        const gchar *arg_parent_window,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_handle,
        const gchar *arg_app_id,
        const gchar *arg_name,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_BOXED_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanBoxedUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        gboolean arg_enable,
        const gchar *const *arg_commandline,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanBoxedUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanBoxedUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              g_marshal_value_peek_uint (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringVariantFunc)
       (void *data1,
        const gchar *arg_session_handle,
        GVariant *arg_state,
        void *data2);
  _GDbusCodegenMarshalVoid_StringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_UINT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringUintVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_handle,
        const gchar *arg_app_id,
        const gchar *arg_window,
        guint arg_flags,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringUintVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringUintVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_uint (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_handle,
        const gchar *arg_session_handle,
        const gchar *arg_app_id,
        const gchar *arg_window,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_session_handle,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringVariantFunc)
       (void *data1,
        const gchar *arg_namespace,
        const gchar *arg_key,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_namespaces,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_namespace,
        const gchar *arg_key,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_handle,
        const gchar *arg_app_id,
        const gchar *arg_parent_window,
        const gchar *arg_uri,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Screenshot
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplScreenshot
 * @title: XdpImplScreenshot
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Screenshot D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Screenshot ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_screenshot_IN_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_handle.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_screenshot_OUT_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_screenshot_OUT_ARG_response.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_screenshot_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_screenshot_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screenshot_method_screenshot_annotation_info_pointers[] =
{
  &_xdp_impl_screenshot_method_screenshot_annotation_info_0,
  &_xdp_impl_screenshot_method_screenshot_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screenshot_method_info_screenshot =
{
  {
    -1,
    (gchar *) "Screenshot",
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_screenshot_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screenshot_method_screenshot_annotation_info_pointers
  },
  "handle-screenshot",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_pick_color_IN_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_handle.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_pick_color_OUT_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_pick_color_OUT_ARG_response.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_pick_color_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_pick_color_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screenshot_method_pick_color_annotation_info_pointers[] =
{
  &_xdp_impl_screenshot_method_pick_color_annotation_info_0,
  &_xdp_impl_screenshot_method_pick_color_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screenshot_method_info_pick_color =
{
  {
    -1,
    (gchar *) "PickColor",
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_pick_color_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screenshot_method_pick_color_annotation_info_pointers
  },
  "handle-pick-color",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_screenshot_method_info_pointers[] =
{
  &_xdp_impl_screenshot_method_info_screenshot.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_screenshot_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_screenshot_property_info_pointers[] =
{
  &_xdp_impl_screenshot_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_screenshot_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Screenshot",
    (GDBusMethodInfo **) &_xdp_impl_screenshot_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_screenshot_property_info_pointers,
    NULL
  },
  "screenshot",
};


/**
 * xdp_impl_screenshot_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_screenshot_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct;
}

/**
 * xdp_impl_screenshot_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplScreenshot interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_screenshot_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
xdp_impl_screenshot_method_marshal_screenshot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_screenshot_method_marshal_pick_color (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplScreenshot:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 */

/**
 * XdpImplScreenshotIface:
 * @parent_iface: The parent interface.
 * @handle_pick_color: Handler for the #XdpImplScreenshot::handle-pick-color signal.
 * @handle_screenshot: Handler for the #XdpImplScreenshot::handle-screenshot signal.
 * @get_version: Getter for the #XdpImplScreenshot:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 */

typedef XdpImplScreenshotIface XdpImplScreenshotInterface;
G_DEFINE_INTERFACE (XdpImplScreenshot, xdp_impl_screenshot, G_TYPE_OBJECT)

static void
xdp_impl_screenshot_default_init (XdpImplScreenshotIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplScreenshot::handle-screenshot:
   * @object: A #XdpImplScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screenshot_complete_screenshot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenshotIface, handle_screenshot),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_screenshot_method_marshal_screenshot,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplScreenshot::handle-pick-color:
   * @object: A #XdpImplScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screenshot_complete_pick_color() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pick-color",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenshotIface, handle_pick_color),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_screenshot_method_marshal_pick_color,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplScreenshot:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Screenshot.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_screenshot_get_version: (skip)
 * @object: A #XdpImplScreenshot.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Screenshot.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_screenshot_get_version (XdpImplScreenshot *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_SCREENSHOT (object), 0);

  return XDP_IMPL_SCREENSHOT_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_screenshot_set_version: (skip)
 * @object: A #XdpImplScreenshot.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Screenshot.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_screenshot_set_version (XdpImplScreenshot *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_screenshot_call_screenshot:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_call_screenshot_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_call_screenshot_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screenshot_call_screenshot (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screenshot_call_screenshot_finish:
 * @proxy: A #XdpImplScreenshotProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_call_screenshot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screenshot_call_screenshot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_screenshot_finish (
    XdpImplScreenshot *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_call_screenshot_sync:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_call_screenshot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_screenshot_sync (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_call_pick_color:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_call_pick_color_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_call_pick_color_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screenshot_call_pick_color (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screenshot_call_pick_color_finish:
 * @proxy: A #XdpImplScreenshotProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_call_pick_color().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screenshot_call_pick_color().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_pick_color_finish (
    XdpImplScreenshot *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_call_pick_color_sync:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_call_pick_color() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_pick_color_sync (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_complete_screenshot:
 * @object: A #XdpImplScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screenshot_complete_screenshot (
    XdpImplScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_screenshot_complete_pick_color:
 * @object: A #XdpImplScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screenshot_complete_pick_color (
    XdpImplScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplScreenshotProxy:
 *
 * The #XdpImplScreenshotProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplScreenshotProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplScreenshotProxy.
 */

struct _XdpImplScreenshotProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_screenshot_proxy_iface_init (XdpImplScreenshotIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotProxy, xdp_impl_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplScreenshotProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotProxy, xdp_impl_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_proxy_iface_init))

#endif
static void
xdp_impl_screenshot_proxy_finalize (GObject *object)
{
  XdpImplScreenshotProxy *proxy = XDP_IMPL_SCREENSHOT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_screenshot_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_screenshot_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_screenshot_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_screenshot_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Screenshot: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_screenshot_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_screenshot_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Screenshot", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_screenshot_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_screenshot_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SCREENSHOT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_screenshot_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplScreenshotProxy *proxy = XDP_IMPL_SCREENSHOT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_screenshot_proxy_get_version (XdpImplScreenshot *object)
{
  XdpImplScreenshotProxy *proxy = XDP_IMPL_SCREENSHOT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_screenshot_proxy_init (XdpImplScreenshotProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_screenshot_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_SCREENSHOT_PROXY, XdpImplScreenshotProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_screenshot_interface_info ());
}

static void
xdp_impl_screenshot_proxy_class_init (XdpImplScreenshotProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_screenshot_proxy_finalize;
  gobject_class->get_property = xdp_impl_screenshot_proxy_get_property;
  gobject_class->set_property = xdp_impl_screenshot_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_screenshot_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_screenshot_proxy_g_properties_changed;

  xdp_impl_screenshot_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplScreenshotProxyPrivate));
#endif
}

static void
xdp_impl_screenshot_proxy_iface_init (XdpImplScreenshotIface *iface)
{
  iface->get_version = xdp_impl_screenshot_proxy_get_version;
}

/**
 * xdp_impl_screenshot_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_screenshot_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
}

/**
 * xdp_impl_screenshot_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_screenshot_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_screenshot_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}


/**
 * xdp_impl_screenshot_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_screenshot_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_screenshot_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
}

/**
 * xdp_impl_screenshot_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_screenshot_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_screenshot_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_screenshot_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplScreenshotSkeleton:
 *
 * The #XdpImplScreenshotSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplScreenshotSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplScreenshotSkeleton.
 */

struct _XdpImplScreenshotSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_screenshot_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SCREENSHOT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_screenshot_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_screenshot_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_screenshot_skeleton_vtable =
{
  _xdp_impl_screenshot_skeleton_handle_method_call,
  _xdp_impl_screenshot_skeleton_handle_get_property,
  _xdp_impl_screenshot_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_screenshot_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_screenshot_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_screenshot_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_screenshot_skeleton_vtable;
}

static GVariant *
xdp_impl_screenshot_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_screenshot_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_screenshot_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_screenshot_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_screenshot_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Screenshot", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_screenshot_emit_changed (gpointer user_data);

static void
xdp_impl_screenshot_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_screenshot_emit_changed (skeleton);
}

static void xdp_impl_screenshot_skeleton_iface_init (XdpImplScreenshotIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotSkeleton, xdp_impl_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplScreenshotSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotSkeleton, xdp_impl_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_skeleton_iface_init))

#endif
static void
xdp_impl_screenshot_skeleton_finalize (GObject *object)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_screenshot_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_screenshot_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_screenshot_emit_changed (gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Screenshot",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_screenshot_schedule_emit_changed (XdpImplScreenshotSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_screenshot_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_screenshot_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_screenshot_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_screenshot_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_screenshot_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_screenshot_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_screenshot_skeleton_init (XdpImplScreenshotSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_screenshot_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_SCREENSHOT_SKELETON, XdpImplScreenshotSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_impl_screenshot_skeleton_get_version (XdpImplScreenshot *object)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_screenshot_skeleton_class_init (XdpImplScreenshotSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_screenshot_skeleton_finalize;
  gobject_class->get_property = xdp_impl_screenshot_skeleton_get_property;
  gobject_class->set_property = xdp_impl_screenshot_skeleton_set_property;
  gobject_class->notify       = xdp_impl_screenshot_skeleton_notify;


  xdp_impl_screenshot_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_screenshot_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_screenshot_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_screenshot_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_screenshot_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplScreenshotSkeletonPrivate));
#endif
}

static void
xdp_impl_screenshot_skeleton_iface_init (XdpImplScreenshotIface *iface)
{
  iface->get_version = xdp_impl_screenshot_skeleton_get_version;
}

/**
 * xdp_impl_screenshot_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 *
 * Returns: (transfer full) (type XdpImplScreenshotSkeleton): The skeleton object.
 */
XdpImplScreenshot *
xdp_impl_screenshot_skeleton_new (void)
{
  return XDP_IMPL_SCREENSHOT (g_object_new (XDP_IMPL_TYPE_SCREENSHOT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Background
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplBackground
 * @title: XdpImplBackground
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Background D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link> D-Bus interface in C.
 */

enum
{
  XDP_IMPL__BACKGROUND_RUNNING_APPLICATIONS_CHANGED,
};

static unsigned XDP_IMPL__BACKGROUND_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Background ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_get_app_state_OUT_ARG_apps =
{
  {
    -1,
    (gchar *) "apps",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_get_app_state_OUT_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_get_app_state_OUT_ARG_apps.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_background_method_get_app_state_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out0",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_background_method_get_app_state_annotation_info_pointers[] =
{
  &_xdp_impl_background_method_get_app_state_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_background_method_info_get_app_state =
{
  {
    -1,
    (gchar *) "GetAppState",
    NULL,
    (GDBusArgInfo **) &_xdp_impl_background_method_info_get_app_state_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_background_method_get_app_state_annotation_info_pointers
  },
  "handle-get-app-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_notify_background_IN_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_notify_background_IN_ARG_handle.parent_struct,
  &_xdp_impl_background_method_info_notify_background_IN_ARG_app_id.parent_struct,
  &_xdp_impl_background_method_info_notify_background_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_notify_background_OUT_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_notify_background_OUT_ARG_response.parent_struct,
  &_xdp_impl_background_method_info_notify_background_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_background_method_notify_background_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_background_method_notify_background_annotation_info_pointers[] =
{
  &_xdp_impl_background_method_notify_background_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_background_method_info_notify_background =
{
  {
    -1,
    (gchar *) "NotifyBackground",
    (GDBusArgInfo **) &_xdp_impl_background_method_info_notify_background_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_background_method_info_notify_background_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_background_method_notify_background_annotation_info_pointers
  },
  "handle-notify-background",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_commandline =
{
  {
    -1,
    (gchar *) "commandline",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_enable_autostart_IN_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_app_id.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_enable.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_commandline.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_enable_autostart_OUT_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_enable_autostart_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_background_method_info_enable_autostart =
{
  {
    -1,
    (gchar *) "EnableAutostart",
    (GDBusArgInfo **) &_xdp_impl_background_method_info_enable_autostart_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_background_method_info_enable_autostart_OUT_ARG_pointers,
    NULL
  },
  "handle-enable-autostart",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_background_method_info_pointers[] =
{
  &_xdp_impl_background_method_info_get_app_state.parent_struct,
  &_xdp_impl_background_method_info_notify_background.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_background_signal_info_running_applications_changed =
{
  {
    -1,
    (gchar *) "RunningApplicationsChanged",
    NULL,
    NULL
  },
  "running-applications-changed"
};

static const GDBusSignalInfo * const _xdp_impl_background_signal_info_pointers[] =
{
  &_xdp_impl_background_signal_info_running_applications_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_background_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Background",
    (GDBusMethodInfo **) &_xdp_impl_background_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_background_signal_info_pointers,
    NULL,
    NULL
  },
  "background",
};


/**
 * xdp_impl_background_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_background_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct;
}

/**
 * xdp_impl_background_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplBackground interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_background_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
xdp_impl_background_signal_marshal_running_applications_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_background_method_marshal_get_app_state (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_background_method_marshal_notify_background (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_background_method_marshal_enable_autostart (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN_BOXED_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplBackground:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 */

/**
 * XdpImplBackgroundIface:
 * @parent_iface: The parent interface.
 * @handle_enable_autostart: Handler for the #XdpImplBackground::handle-enable-autostart signal.
 * @handle_get_app_state: Handler for the #XdpImplBackground::handle-get-app-state signal.
 * @handle_notify_background: Handler for the #XdpImplBackground::handle-notify-background signal.
 * @running_applications_changed: Handler for the #XdpImplBackground::running-applications-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 */

typedef XdpImplBackgroundIface XdpImplBackgroundInterface;
G_DEFINE_INTERFACE (XdpImplBackground, xdp_impl_background, G_TYPE_OBJECT)

static void
xdp_impl_background_default_init (XdpImplBackgroundIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplBackground::handle-get-app-state:
   * @object: A #XdpImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_background_complete_get_app_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-app-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, handle_get_app_state),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_background_method_marshal_get_app_state,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpImplBackground::handle-notify-background:
   * @object: A #XdpImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_background_complete_notify_background() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-background",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, handle_notify_background),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_background_method_marshal_notify_background,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplBackground::handle-enable-autostart:
   * @object: A #XdpImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   * @arg_commandline: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_background_complete_enable_autostart() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-autostart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, handle_enable_autostart),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_background_method_marshal_enable_autostart,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRV, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplBackground::running-applications-changed:
   * @object: A #XdpImplBackground.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Background.RunningApplicationsChanged">"RunningApplicationsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XDP_IMPL__BACKGROUND_SIGNALS[XDP_IMPL__BACKGROUND_RUNNING_APPLICATIONS_CHANGED] =
    g_signal_new ("running-applications-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XdpImplBackgroundIface, running_applications_changed),
      NULL,
      NULL,
      xdp_impl_background_signal_marshal_running_applications_changed,
      G_TYPE_NONE,
      0);

}

/**
 * xdp_impl_background_emit_running_applications_changed:
 * @object: A #XdpImplBackground.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Background.RunningApplicationsChanged">"RunningApplicationsChanged"</link> D-Bus signal.
 */
void
xdp_impl_background_emit_running_applications_changed (
    XdpImplBackground *object)
{
  g_signal_emit (object, XDP_IMPL__BACKGROUND_SIGNALS[XDP_IMPL__BACKGROUND_RUNNING_APPLICATIONS_CHANGED], 0);
}

/**
 * xdp_impl_background_call_get_app_state:
 * @proxy: A #XdpImplBackgroundProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_call_get_app_state_finish() to get the result of the operation.
 *
 * See xdp_impl_background_call_get_app_state_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_background_call_get_app_state (
    XdpImplBackground *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAppState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_background_call_get_app_state_finish:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_call_get_app_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_background_call_get_app_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_get_app_state_finish (
    XdpImplBackground *proxy,
    GVariant **out_apps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_get_app_state_sync:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_call_get_app_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_get_app_state_sync (
    XdpImplBackground *proxy,
    GVariant **out_apps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAppState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_notify_background:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_call_notify_background_finish() to get the result of the operation.
 *
 * See xdp_impl_background_call_notify_background_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_background_call_notify_background (
    XdpImplBackground *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyBackground",
    g_variant_new ("(oss)",
                   arg_handle,
                   arg_app_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_background_call_notify_background_finish:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_call_notify_background().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_background_call_notify_background().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_notify_background_finish (
    XdpImplBackground *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_notify_background_sync:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_call_notify_background() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_notify_background_sync (
    XdpImplBackground *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_name,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyBackground",
    g_variant_new ("(oss)",
                   arg_handle,
                   arg_app_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_enable_autostart:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_commandline: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_call_enable_autostart_finish() to get the result of the operation.
 *
 * See xdp_impl_background_call_enable_autostart_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_background_call_enable_autostart (
    XdpImplBackground *proxy,
    const gchar *arg_app_id,
    gboolean arg_enable,
    const gchar *const *arg_commandline,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableAutostart",
    g_variant_new ("(sb^asu)",
                   arg_app_id,
                   arg_enable,
                   arg_commandline,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_background_call_enable_autostart_finish:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_call_enable_autostart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_background_call_enable_autostart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_enable_autostart_finish (
    XdpImplBackground *proxy,
    gboolean *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_enable_autostart_sync:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_commandline: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_call_enable_autostart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_enable_autostart_sync (
    XdpImplBackground *proxy,
    const gchar *arg_app_id,
    gboolean arg_enable,
    const gchar *const *arg_commandline,
    guint arg_flags,
    gboolean *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableAutostart",
    g_variant_new ("(sb^asu)",
                   arg_app_id,
                   arg_enable,
                   arg_commandline,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_complete_get_app_state:
 * @object: A #XdpImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @apps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_background_complete_get_app_state (
    XdpImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *apps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   apps));
}

/**
 * xdp_impl_background_complete_notify_background:
 * @object: A #XdpImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_background_complete_notify_background (
    XdpImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_background_complete_enable_autostart:
 * @object: A #XdpImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_background_complete_enable_autostart (
    XdpImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplBackgroundProxy:
 *
 * The #XdpImplBackgroundProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplBackgroundProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplBackgroundProxy.
 */

struct _XdpImplBackgroundProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_background_proxy_iface_init (XdpImplBackgroundIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundProxy, xdp_impl_background_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplBackgroundProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundProxy, xdp_impl_background_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_proxy_iface_init))

#endif
static void
xdp_impl_background_proxy_finalize (GObject *object)
{
  XdpImplBackgroundProxy *proxy = XDP_IMPL_BACKGROUND_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_background_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_background_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_background_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_background_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_BACKGROUND);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_BACKGROUND);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_background_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplBackgroundProxy *proxy = XDP_IMPL_BACKGROUND_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_background_proxy_init (XdpImplBackgroundProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_background_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_BACKGROUND_PROXY, XdpImplBackgroundProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_background_interface_info ());
}

static void
xdp_impl_background_proxy_class_init (XdpImplBackgroundProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_background_proxy_finalize;
  gobject_class->get_property = xdp_impl_background_proxy_get_property;
  gobject_class->set_property = xdp_impl_background_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_background_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_background_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplBackgroundProxyPrivate));
#endif
}

static void
xdp_impl_background_proxy_iface_init (XdpImplBackgroundIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_background_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_background_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_background_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
}

/**
 * xdp_impl_background_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_background_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_impl_background_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}


/**
 * xdp_impl_background_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_background_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_background_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_background_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
}

/**
 * xdp_impl_background_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_background_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_impl_background_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_background_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplBackgroundSkeleton:
 *
 * The #XdpImplBackgroundSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplBackgroundSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplBackgroundSkeleton.
 */

struct _XdpImplBackgroundSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_background_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_BACKGROUND);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_BACKGROUND);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_background_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_background_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_background_skeleton_vtable =
{
  _xdp_impl_background_skeleton_handle_method_call,
  _xdp_impl_background_skeleton_handle_get_property,
  _xdp_impl_background_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_background_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_background_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_background_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_background_skeleton_vtable;
}

static GVariant *
xdp_impl_background_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_background_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_background_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_background_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_background_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Background", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_background_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_impl_background_on_signal_running_applications_changed (
    XdpImplBackground *object)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Background", "RunningApplicationsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_background_skeleton_iface_init (XdpImplBackgroundIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundSkeleton, xdp_impl_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplBackgroundSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundSkeleton, xdp_impl_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_skeleton_iface_init))

#endif
static void
xdp_impl_background_skeleton_finalize (GObject *object)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_background_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_background_skeleton_init (XdpImplBackgroundSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_background_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_BACKGROUND_SKELETON, XdpImplBackgroundSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_background_skeleton_class_init (XdpImplBackgroundSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_background_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_background_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_background_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_background_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_background_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplBackgroundSkeletonPrivate));
#endif
}

static void
xdp_impl_background_skeleton_iface_init (XdpImplBackgroundIface *iface)
{
  iface->running_applications_changed = _xdp_impl_background_on_signal_running_applications_changed;
}

/**
 * xdp_impl_background_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 *
 * Returns: (transfer full) (type XdpImplBackgroundSkeleton): The skeleton object.
 */
XdpImplBackground *
xdp_impl_background_skeleton_new (void)
{
  return XDP_IMPL_BACKGROUND (g_object_new (XDP_IMPL_TYPE_BACKGROUND_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Inhibit
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplInhibit
 * @title: XdpImplInhibit
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Inhibit D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link> D-Bus interface in C.
 */

enum
{
  XDP_IMPL__INHIBIT_STATE_CHANGED,
};

static unsigned XDP_IMPL__INHIBIT_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Inhibit ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_inhibit_IN_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_handle.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_app_id.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_window.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_flags.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_options.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_inhibit_method_inhibit_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_inhibit_method_inhibit_annotation_info_pointers[] =
{
  &_xdp_impl_inhibit_method_inhibit_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_inhibit_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xdp_impl_inhibit_method_inhibit_annotation_info_pointers
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_handle.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_app_id.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_window.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_inhibit_method_info_create_monitor =
{
  {
    -1,
    (gchar *) "CreateMonitor",
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-create-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_query_end_response_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_query_end_response_IN_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_query_end_response_IN_ARG_session_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_inhibit_method_info_query_end_response =
{
  {
    -1,
    (gchar *) "QueryEndResponse",
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_query_end_response_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-query-end-response",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_inhibit_method_info_pointers[] =
{
  &_xdp_impl_inhibit_method_info_inhibit.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor.parent_struct,
  &_xdp_impl_inhibit_method_info_query_end_response.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_signal_info_state_changed_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_signal_info_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_signal_info_state_changed_ARG_pointers[] =
{
  &_xdp_impl_inhibit_signal_info_state_changed_ARG_session_handle.parent_struct,
  &_xdp_impl_inhibit_signal_info_state_changed_ARG_state.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_inhibit_signal_state_changed_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_inhibit_signal_state_changed_annotation_info_pointers[] =
{
  &_xdp_impl_inhibit_signal_state_changed_annotation_info_0,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_inhibit_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_xdp_impl_inhibit_signal_info_state_changed_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_inhibit_signal_state_changed_annotation_info_pointers
  },
  "state-changed"
};

static const GDBusSignalInfo * const _xdp_impl_inhibit_signal_info_pointers[] =
{
  &_xdp_impl_inhibit_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_inhibit_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Inhibit",
    (GDBusMethodInfo **) &_xdp_impl_inhibit_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_inhibit_signal_info_pointers,
    NULL,
    NULL
  },
  "inhibit",
};


/**
 * xdp_impl_inhibit_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_inhibit_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct;
}

/**
 * xdp_impl_inhibit_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplInhibit interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_inhibit_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
xdp_impl_inhibit_signal_marshal_state_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_inhibit_method_marshal_inhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_UINT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_inhibit_method_marshal_create_monitor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_inhibit_method_marshal_query_end_response (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplInhibit:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 */

/**
 * XdpImplInhibitIface:
 * @parent_iface: The parent interface.
 * @handle_create_monitor: Handler for the #XdpImplInhibit::handle-create-monitor signal.
 * @handle_inhibit: Handler for the #XdpImplInhibit::handle-inhibit signal.
 * @handle_query_end_response: Handler for the #XdpImplInhibit::handle-query-end-response signal.
 * @state_changed: Handler for the #XdpImplInhibit::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 */

typedef XdpImplInhibitIface XdpImplInhibitInterface;
G_DEFINE_INTERFACE (XdpImplInhibit, xdp_impl_inhibit, G_TYPE_OBJECT)

static void
xdp_impl_inhibit_default_init (XdpImplInhibitIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplInhibit::handle-inhibit:
   * @object: A #XdpImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_inhibit_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_inhibit_method_marshal_inhibit,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * XdpImplInhibit::handle-create-monitor:
   * @object: A #XdpImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_inhibit_complete_create_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, handle_create_monitor),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_inhibit_method_marshal_create_monitor,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplInhibit::handle-query-end-response:
   * @object: A #XdpImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_inhibit_complete_query_end_response() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-end-response",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, handle_query_end_response),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_inhibit_method_marshal_query_end_response,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplInhibit::state-changed:
   * @object: A #XdpImplInhibit.
   * @arg_session_handle: Argument.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Inhibit.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XDP_IMPL__INHIBIT_SIGNALS[XDP_IMPL__INHIBIT_STATE_CHANGED] =
    g_signal_new ("state-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XdpImplInhibitIface, state_changed),
      NULL,
      NULL,
      xdp_impl_inhibit_signal_marshal_state_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_inhibit_emit_state_changed:
 * @object: A #XdpImplInhibit.
 * @arg_session_handle: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Inhibit.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
xdp_impl_inhibit_emit_state_changed (
    XdpImplInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  g_signal_emit (object, XDP_IMPL__INHIBIT_SIGNALS[XDP_IMPL__INHIBIT_STATE_CHANGED], 0, arg_session_handle, arg_state);
}

/**
 * xdp_impl_inhibit_call_inhibit:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_call_inhibit_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_inhibit_call_inhibit (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ossu@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_inhibit_call_inhibit_finish:
 * @proxy: A #XdpImplInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_inhibit_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_inhibit_finish (
    XdpImplInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_inhibit_sync:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_inhibit_sync (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ossu@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_create_monitor:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_call_create_monitor_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_call_create_monitor_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_inhibit_call_create_monitor (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(ooss)",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_inhibit_call_create_monitor_finish:
 * @proxy: A #XdpImplInhibitProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_call_create_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_inhibit_call_create_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_create_monitor_finish (
    XdpImplInhibit *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_create_monitor_sync:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_call_create_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_create_monitor_sync (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(ooss)",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_query_end_response:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_call_query_end_response_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_call_query_end_response_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_inhibit_call_query_end_response (
    XdpImplInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_inhibit_call_query_end_response_finish:
 * @proxy: A #XdpImplInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_call_query_end_response().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_inhibit_call_query_end_response().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_query_end_response_finish (
    XdpImplInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_query_end_response_sync:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_call_query_end_response() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_query_end_response_sync (
    XdpImplInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_complete_inhibit:
 * @object: A #XdpImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_inhibit_complete_inhibit (
    XdpImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_inhibit_complete_create_monitor:
 * @object: A #XdpImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_inhibit_complete_create_monitor (
    XdpImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/**
 * xdp_impl_inhibit_complete_query_end_response:
 * @object: A #XdpImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_inhibit_complete_query_end_response (
    XdpImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplInhibitProxy:
 *
 * The #XdpImplInhibitProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplInhibitProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplInhibitProxy.
 */

struct _XdpImplInhibitProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_inhibit_proxy_iface_init (XdpImplInhibitIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitProxy, xdp_impl_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplInhibitProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitProxy, xdp_impl_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_proxy_iface_init))

#endif
static void
xdp_impl_inhibit_proxy_finalize (GObject *object)
{
  XdpImplInhibitProxy *proxy = XDP_IMPL_INHIBIT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_inhibit_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_inhibit_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_inhibit_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_inhibit_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_INHIBIT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_INHIBIT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_inhibit_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplInhibitProxy *proxy = XDP_IMPL_INHIBIT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_inhibit_proxy_init (XdpImplInhibitProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_inhibit_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_INHIBIT_PROXY, XdpImplInhibitProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_inhibit_interface_info ());
}

static void
xdp_impl_inhibit_proxy_class_init (XdpImplInhibitProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_inhibit_proxy_finalize;
  gobject_class->get_property = xdp_impl_inhibit_proxy_get_property;
  gobject_class->set_property = xdp_impl_inhibit_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_inhibit_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_inhibit_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplInhibitProxyPrivate));
#endif
}

static void
xdp_impl_inhibit_proxy_iface_init (XdpImplInhibitIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_inhibit_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_inhibit_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
}

/**
 * xdp_impl_inhibit_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_inhibit_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_inhibit_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}


/**
 * xdp_impl_inhibit_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_inhibit_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_inhibit_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
}

/**
 * xdp_impl_inhibit_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_inhibit_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_inhibit_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_inhibit_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplInhibitSkeleton:
 *
 * The #XdpImplInhibitSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplInhibitSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplInhibitSkeleton.
 */

struct _XdpImplInhibitSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_inhibit_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_INHIBIT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_INHIBIT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_inhibit_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_inhibit_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_inhibit_skeleton_vtable =
{
  _xdp_impl_inhibit_skeleton_handle_method_call,
  _xdp_impl_inhibit_skeleton_handle_get_property,
  _xdp_impl_inhibit_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_inhibit_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_inhibit_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_inhibit_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_inhibit_skeleton_vtable;
}

static GVariant *
xdp_impl_inhibit_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_inhibit_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_inhibit_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_inhibit_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_inhibit_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Inhibit", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_inhibit_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_impl_inhibit_on_signal_state_changed (
    XdpImplInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_session_handle,
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Inhibit", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_inhibit_skeleton_iface_init (XdpImplInhibitIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitSkeleton, xdp_impl_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplInhibitSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitSkeleton, xdp_impl_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_skeleton_iface_init))

#endif
static void
xdp_impl_inhibit_skeleton_finalize (GObject *object)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_inhibit_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_inhibit_skeleton_init (XdpImplInhibitSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_inhibit_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_INHIBIT_SKELETON, XdpImplInhibitSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_inhibit_skeleton_class_init (XdpImplInhibitSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_inhibit_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_inhibit_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_inhibit_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_inhibit_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_inhibit_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplInhibitSkeletonPrivate));
#endif
}

static void
xdp_impl_inhibit_skeleton_iface_init (XdpImplInhibitIface *iface)
{
  iface->state_changed = _xdp_impl_inhibit_on_signal_state_changed;
}

/**
 * xdp_impl_inhibit_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 *
 * Returns: (transfer full) (type XdpImplInhibitSkeleton): The skeleton object.
 */
XdpImplInhibit *
xdp_impl_inhibit_skeleton_new (void)
{
  return XDP_IMPL_INHIBIT (g_object_new (XDP_IMPL_TYPE_INHIBIT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Lockdown
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplLockdown
 * @title: XdpImplLockdown
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Lockdown D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Lockdown ---- */

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_printing =
{
  {
    -1,
    (gchar *) "disable-printing",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-printing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_save_to_disk =
{
  {
    -1,
    (gchar *) "disable-save-to-disk",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-save-to-disk",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_application_handlers =
{
  {
    -1,
    (gchar *) "disable-application-handlers",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-application-handlers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_location =
{
  {
    -1,
    (gchar *) "disable-location",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_camera =
{
  {
    -1,
    (gchar *) "disable-camera",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-camera",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_microphone =
{
  {
    -1,
    (gchar *) "disable-microphone",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-microphone",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_sound_output =
{
  {
    -1,
    (gchar *) "disable-sound-output",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-sound-output",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_lockdown_property_info_pointers[] =
{
  &_xdp_impl_lockdown_property_info_disable_printing.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_save_to_disk.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_application_handlers.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_location.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_camera.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_microphone.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_sound_output.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_lockdown_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Lockdown",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_lockdown_property_info_pointers,
    NULL
  },
  "lockdown",
};


/**
 * xdp_impl_lockdown_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_lockdown_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct;
}

/**
 * xdp_impl_lockdown_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplLockdown interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_lockdown_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "disable-printing");
  g_object_class_override_property (klass, property_id_begin++, "disable-save-to-disk");
  g_object_class_override_property (klass, property_id_begin++, "disable-application-handlers");
  g_object_class_override_property (klass, property_id_begin++, "disable-location");
  g_object_class_override_property (klass, property_id_begin++, "disable-camera");
  g_object_class_override_property (klass, property_id_begin++, "disable-microphone");
  g_object_class_override_property (klass, property_id_begin++, "disable-sound-output");
  return property_id_begin - 1;
}



/**
 * XdpImplLockdown:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 */

/**
 * XdpImplLockdownIface:
 * @parent_iface: The parent interface.
 * @get_disable_application_handlers: Getter for the #XdpImplLockdown:disable-application-handlers property.
 * @get_disable_camera: Getter for the #XdpImplLockdown:disable-camera property.
 * @get_disable_location: Getter for the #XdpImplLockdown:disable-location property.
 * @get_disable_microphone: Getter for the #XdpImplLockdown:disable-microphone property.
 * @get_disable_printing: Getter for the #XdpImplLockdown:disable-printing property.
 * @get_disable_save_to_disk: Getter for the #XdpImplLockdown:disable-save-to-disk property.
 * @get_disable_sound_output: Getter for the #XdpImplLockdown:disable-sound-output property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 */

typedef XdpImplLockdownIface XdpImplLockdownInterface;
G_DEFINE_INTERFACE (XdpImplLockdown, xdp_impl_lockdown, G_TYPE_OBJECT)

static void
xdp_impl_lockdown_default_init (XdpImplLockdownIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplLockdown:disable-printing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-printing", "disable-printing", "disable-printing", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-save-to-disk:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-save-to-disk", "disable-save-to-disk", "disable-save-to-disk", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-application-handlers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-application-handlers", "disable-application-handlers", "disable-application-handlers", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-location", "disable-location", "disable-location", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-camera:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-camera", "disable-camera", "disable-camera", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-microphone:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-microphone", "disable-microphone", "disable-microphone", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-sound-output:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-sound-output", "disable-sound-output", "disable-sound-output", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_lockdown_get_disable_printing: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_printing (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_printing (object);
}

/**
 * xdp_impl_lockdown_set_disable_printing: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_printing (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-printing", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_save_to_disk: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_save_to_disk (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_save_to_disk (object);
}

/**
 * xdp_impl_lockdown_set_disable_save_to_disk: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_save_to_disk (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-save-to-disk", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_application_handlers: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_application_handlers (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_application_handlers (object);
}

/**
 * xdp_impl_lockdown_set_disable_application_handlers: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_application_handlers (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-application-handlers", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_location: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_location (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_location (object);
}

/**
 * xdp_impl_lockdown_set_disable_location: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_location (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-location", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_camera: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_camera (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_camera (object);
}

/**
 * xdp_impl_lockdown_set_disable_camera: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_camera (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-camera", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_microphone: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_microphone (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_microphone (object);
}

/**
 * xdp_impl_lockdown_set_disable_microphone: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_microphone (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-microphone", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_sound_output: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_sound_output (XdpImplLockdown *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_LOCKDOWN (object), FALSE);

  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_sound_output (object);
}

/**
 * xdp_impl_lockdown_set_disable_sound_output: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_sound_output (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-sound-output", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplLockdownProxy:
 *
 * The #XdpImplLockdownProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplLockdownProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplLockdownProxy.
 */

struct _XdpImplLockdownProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_lockdown_proxy_iface_init (XdpImplLockdownIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownProxy, xdp_impl_lockdown_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplLockdownProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownProxy, xdp_impl_lockdown_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_proxy_iface_init))

#endif
static void
xdp_impl_lockdown_proxy_finalize (GObject *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_lockdown_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_lockdown_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_lockdown_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_lockdown_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Lockdown: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_lockdown_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_lockdown_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Lockdown", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_lockdown_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_lockdown_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_LOCKDOWN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_LOCKDOWN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_lockdown_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_printing (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-printing");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_save_to_disk (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-save-to-disk");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_application_handlers (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-application-handlers");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_location (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-location");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_camera (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-camera");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_microphone (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-microphone");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_sound_output (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-sound-output");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_lockdown_proxy_init (XdpImplLockdownProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_lockdown_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_LOCKDOWN_PROXY, XdpImplLockdownProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_lockdown_interface_info ());
}

static void
xdp_impl_lockdown_proxy_class_init (XdpImplLockdownProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_lockdown_proxy_finalize;
  gobject_class->get_property = xdp_impl_lockdown_proxy_get_property;
  gobject_class->set_property = xdp_impl_lockdown_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_lockdown_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_lockdown_proxy_g_properties_changed;

  xdp_impl_lockdown_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplLockdownProxyPrivate));
#endif
}

static void
xdp_impl_lockdown_proxy_iface_init (XdpImplLockdownIface *iface)
{
  iface->get_disable_printing = xdp_impl_lockdown_proxy_get_disable_printing;
  iface->get_disable_save_to_disk = xdp_impl_lockdown_proxy_get_disable_save_to_disk;
  iface->get_disable_application_handlers = xdp_impl_lockdown_proxy_get_disable_application_handlers;
  iface->get_disable_location = xdp_impl_lockdown_proxy_get_disable_location;
  iface->get_disable_camera = xdp_impl_lockdown_proxy_get_disable_camera;
  iface->get_disable_microphone = xdp_impl_lockdown_proxy_get_disable_microphone;
  iface->get_disable_sound_output = xdp_impl_lockdown_proxy_get_disable_sound_output;
}

/**
 * xdp_impl_lockdown_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_lockdown_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_lockdown_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_lockdown_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_LOCKDOWN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
}

/**
 * xdp_impl_lockdown_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_lockdown_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_lockdown_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}

/**
 * xdp_impl_lockdown_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_lockdown_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_LOCKDOWN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}


/**
 * xdp_impl_lockdown_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_lockdown_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_lockdown_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_lockdown_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_lockdown_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_LOCKDOWN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
}

/**
 * xdp_impl_lockdown_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_lockdown_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_lockdown_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}

/**
 * xdp_impl_lockdown_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_lockdown_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_lockdown_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_LOCKDOWN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplLockdownSkeleton:
 *
 * The #XdpImplLockdownSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplLockdownSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplLockdownSkeleton.
 */

struct _XdpImplLockdownSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_lockdown_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_LOCKDOWN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_LOCKDOWN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_lockdown_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_lockdown_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_lockdown_skeleton_vtable =
{
  _xdp_impl_lockdown_skeleton_handle_method_call,
  _xdp_impl_lockdown_skeleton_handle_get_property,
  _xdp_impl_lockdown_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_lockdown_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_lockdown_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_lockdown_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_lockdown_skeleton_vtable;
}

static GVariant *
xdp_impl_lockdown_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_lockdown_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_lockdown_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_lockdown_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_lockdown_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Lockdown", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_lockdown_emit_changed (gpointer user_data);

static void
xdp_impl_lockdown_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_lockdown_emit_changed (skeleton);
}

static void xdp_impl_lockdown_skeleton_iface_init (XdpImplLockdownIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownSkeleton, xdp_impl_lockdown_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplLockdownSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownSkeleton, xdp_impl_lockdown_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_skeleton_iface_init))

#endif
static void
xdp_impl_lockdown_skeleton_finalize (GObject *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_lockdown_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_lockdown_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_lockdown_emit_changed (gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Lockdown",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_lockdown_schedule_emit_changed (XdpImplLockdownSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_lockdown_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_lockdown_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_lockdown_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_lockdown_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_lockdown_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_lockdown_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_lockdown_skeleton_init (XdpImplLockdownSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_lockdown_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_LOCKDOWN_SKELETON, XdpImplLockdownSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_printing (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_save_to_disk (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_application_handlers (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_location (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_camera (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_microphone (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_sound_output (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_lockdown_skeleton_class_init (XdpImplLockdownSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_lockdown_skeleton_finalize;
  gobject_class->get_property = xdp_impl_lockdown_skeleton_get_property;
  gobject_class->set_property = xdp_impl_lockdown_skeleton_set_property;
  gobject_class->notify       = xdp_impl_lockdown_skeleton_notify;


  xdp_impl_lockdown_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_lockdown_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_lockdown_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_lockdown_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_lockdown_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplLockdownSkeletonPrivate));
#endif
}

static void
xdp_impl_lockdown_skeleton_iface_init (XdpImplLockdownIface *iface)
{
  iface->get_disable_printing = xdp_impl_lockdown_skeleton_get_disable_printing;
  iface->get_disable_save_to_disk = xdp_impl_lockdown_skeleton_get_disable_save_to_disk;
  iface->get_disable_application_handlers = xdp_impl_lockdown_skeleton_get_disable_application_handlers;
  iface->get_disable_location = xdp_impl_lockdown_skeleton_get_disable_location;
  iface->get_disable_camera = xdp_impl_lockdown_skeleton_get_disable_camera;
  iface->get_disable_microphone = xdp_impl_lockdown_skeleton_get_disable_microphone;
  iface->get_disable_sound_output = xdp_impl_lockdown_skeleton_get_disable_sound_output;
}

/**
 * xdp_impl_lockdown_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 *
 * Returns: (transfer full) (type XdpImplLockdownSkeleton): The skeleton object.
 */
XdpImplLockdown *
xdp_impl_lockdown_skeleton_new (void)
{
  return XDP_IMPL_LOCKDOWN (g_object_new (XDP_IMPL_TYPE_LOCKDOWN_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Request
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplRequest
 * @title: XdpImplRequest
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Request D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Request ---- */

static const _ExtendedGDBusMethodInfo _xdp_impl_request_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_request_method_info_pointers[] =
{
  &_xdp_impl_request_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_request_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Request",
    (GDBusMethodInfo **) &_xdp_impl_request_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "request",
};


/**
 * xdp_impl_request_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_request_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct;
}

/**
 * xdp_impl_request_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplRequest interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_request_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
xdp_impl_request_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplRequest:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

/**
 * XdpImplRequestIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #XdpImplRequest::handle-close signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

typedef XdpImplRequestIface XdpImplRequestInterface;
G_DEFINE_INTERFACE (XdpImplRequest, xdp_impl_request, G_TYPE_OBJECT)

static void
xdp_impl_request_default_init (XdpImplRequestIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplRequest::handle-close:
   * @object: A #XdpImplRequest.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_request_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRequestIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_request_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * xdp_impl_request_call_close:
 * @proxy: A #XdpImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_request_call_close_finish() to get the result of the operation.
 *
 * See xdp_impl_request_call_close_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_request_call_close (
    XdpImplRequest *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_request_call_close_finish:
 * @proxy: A #XdpImplRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_request_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_request_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_request_call_close_finish (
    XdpImplRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_request_call_close_sync:
 * @proxy: A #XdpImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_request_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_request_call_close_sync (
    XdpImplRequest *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_request_complete_close:
 * @object: A #XdpImplRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_request_complete_close (
    XdpImplRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplRequestProxy:
 *
 * The #XdpImplRequestProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplRequestProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplRequestProxy.
 */

struct _XdpImplRequestProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_request_proxy_iface_init (XdpImplRequestIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestProxy, xdp_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplRequestProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestProxy, xdp_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_proxy_iface_init))

#endif
static void
xdp_impl_request_proxy_finalize (GObject *object)
{
  XdpImplRequestProxy *proxy = XDP_IMPL_REQUEST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_request_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_request_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_request_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_request_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_REQUEST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_request_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplRequestProxy *proxy = XDP_IMPL_REQUEST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_request_proxy_init (XdpImplRequestProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_request_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_REQUEST_PROXY, XdpImplRequestProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_request_interface_info ());
}

static void
xdp_impl_request_proxy_class_init (XdpImplRequestProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_request_proxy_finalize;
  gobject_class->get_property = xdp_impl_request_proxy_get_property;
  gobject_class->set_property = xdp_impl_request_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_request_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_request_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplRequestProxyPrivate));
#endif
}

static void
xdp_impl_request_proxy_iface_init (XdpImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_request_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_request_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_request_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_request_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * xdp_impl_request_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_request_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_request_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * xdp_impl_request_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_request_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}


/**
 * xdp_impl_request_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_request_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_request_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_request_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_request_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * xdp_impl_request_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_request_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_request_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * xdp_impl_request_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_request_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_request_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplRequestSkeleton:
 *
 * The #XdpImplRequestSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplRequestSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplRequestSkeleton.
 */

struct _XdpImplRequestSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_request_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_REQUEST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_request_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_request_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_request_skeleton_vtable =
{
  _xdp_impl_request_skeleton_handle_method_call,
  _xdp_impl_request_skeleton_handle_get_property,
  _xdp_impl_request_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_request_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_request_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_request_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_request_skeleton_vtable;
}

static GVariant *
xdp_impl_request_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_request_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_request_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_request_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_request_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Request", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_request_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_request_skeleton_iface_init (XdpImplRequestIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestSkeleton, xdp_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplRequestSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestSkeleton, xdp_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_skeleton_iface_init))

#endif
static void
xdp_impl_request_skeleton_finalize (GObject *object)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_request_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_request_skeleton_init (XdpImplRequestSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_request_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_REQUEST_SKELETON, XdpImplRequestSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_request_skeleton_class_init (XdpImplRequestSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_request_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_request_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_request_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_request_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_request_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplRequestSkeletonPrivate));
#endif
}

static void
xdp_impl_request_skeleton_iface_init (XdpImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_request_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 *
 * Returns: (transfer full) (type XdpImplRequestSkeleton): The skeleton object.
 */
XdpImplRequest *
xdp_impl_request_skeleton_new (void)
{
  return XDP_IMPL_REQUEST (g_object_new (XDP_IMPL_TYPE_REQUEST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplSession
 * @title: XdpImplSession
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link> D-Bus interface in C.
 */

enum
{
  XDP_IMPL__SESSION_CLOSED,
};

static unsigned XDP_IMPL__SESSION_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Session ---- */

static const _ExtendedGDBusMethodInfo _xdp_impl_session_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_session_method_info_pointers[] =
{
  &_xdp_impl_session_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _xdp_impl_session_signal_info_pointers[] =
{
  &_xdp_impl_session_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_session_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_session_property_info_pointers[] =
{
  &_xdp_impl_session_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Session",
    (GDBusMethodInfo **) &_xdp_impl_session_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_impl_session_property_info_pointers,
    NULL
  },
  "session",
};


/**
 * xdp_impl_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_session_interface_info.parent_struct;
}

/**
 * xdp_impl_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
xdp_impl_session_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_session_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>.
 */

/**
 * XdpImplSessionIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #XdpImplSession::handle-close signal.
 * @get_version: Getter for the #XdpImplSession:version property.
 * @closed: Handler for the #XdpImplSession::closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>.
 */

typedef XdpImplSessionIface XdpImplSessionInterface;
G_DEFINE_INTERFACE (XdpImplSession, xdp_impl_session, G_TYPE_OBJECT)

static void
xdp_impl_session_default_init (XdpImplSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplSession::handle-close:
   * @object: A #XdpImplSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_session_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplSessionIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_session_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplSession::closed:
   * @object: A #XdpImplSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XDP_IMPL__SESSION_SIGNALS[XDP_IMPL__SESSION_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XdpImplSessionIface, closed),
      NULL,
      NULL,
      xdp_impl_session_signal_marshal_closed,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplSession:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Session.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_session_get_version: (skip)
 * @object: A #XdpImplSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Session.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_session_get_version (XdpImplSession *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_SESSION (object), 0);

  return XDP_IMPL_SESSION_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_session_set_version: (skip)
 * @object: A #XdpImplSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Session.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_session_set_version (XdpImplSession *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_session_emit_closed:
 * @object: A #XdpImplSession.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
xdp_impl_session_emit_closed (
    XdpImplSession *object)
{
  g_signal_emit (object, XDP_IMPL__SESSION_SIGNALS[XDP_IMPL__SESSION_CLOSED], 0);
}

/**
 * xdp_impl_session_call_close:
 * @proxy: A #XdpImplSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_session_call_close_finish() to get the result of the operation.
 *
 * See xdp_impl_session_call_close_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_session_call_close (
    XdpImplSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_session_call_close_finish:
 * @proxy: A #XdpImplSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_session_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_session_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_session_call_close_finish (
    XdpImplSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_session_call_close_sync:
 * @proxy: A #XdpImplSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_session_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_session_call_close_sync (
    XdpImplSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_session_complete_close:
 * @object: A #XdpImplSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_session_complete_close (
    XdpImplSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplSessionProxy:
 *
 * The #XdpImplSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplSessionProxy.
 */

struct _XdpImplSessionProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_session_proxy_iface_init (XdpImplSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplSessionProxy, xdp_impl_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplSessionProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SESSION, xdp_impl_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplSessionProxy, xdp_impl_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SESSION, xdp_impl_session_proxy_iface_init))

#endif
static void
xdp_impl_session_proxy_finalize (GObject *object)
{
  XdpImplSessionProxy *proxy = XDP_IMPL_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_session_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplSessionProxy *proxy = XDP_IMPL_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_session_proxy_get_version (XdpImplSession *object)
{
  XdpImplSessionProxy *proxy = XDP_IMPL_SESSION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_session_proxy_init (XdpImplSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_SESSION_PROXY, XdpImplSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_session_interface_info ());
}

static void
xdp_impl_session_proxy_class_init (XdpImplSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_session_proxy_finalize;
  gobject_class->get_property = xdp_impl_session_proxy_get_property;
  gobject_class->set_property = xdp_impl_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_session_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_session_proxy_g_properties_changed;

  xdp_impl_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplSessionProxyPrivate));
#endif
}

static void
xdp_impl_session_proxy_iface_init (XdpImplSessionIface *iface)
{
  iface->get_version = xdp_impl_session_proxy_get_version;
}

/**
 * xdp_impl_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_session_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
}

/**
 * xdp_impl_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_session_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSession *
xdp_impl_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SESSION (ret);
  else
    return NULL;
}

/**
 * xdp_impl_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSession *
xdp_impl_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
  if (ret != NULL)
    return XDP_IMPL_SESSION (ret);
  else
    return NULL;
}


/**
 * xdp_impl_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
}

/**
 * xdp_impl_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSession *
xdp_impl_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SESSION (ret);
  else
    return NULL;
}

/**
 * xdp_impl_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSession *
xdp_impl_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
  if (ret != NULL)
    return XDP_IMPL_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplSessionSkeleton:
 *
 * The #XdpImplSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplSessionSkeleton.
 */

struct _XdpImplSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_session_skeleton_vtable =
{
  _xdp_impl_session_skeleton_handle_method_call,
  _xdp_impl_session_skeleton_handle_get_property,
  _xdp_impl_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_session_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_session_skeleton_vtable;
}

static GVariant *
xdp_impl_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_session_emit_changed (gpointer user_data);

static void
xdp_impl_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_session_emit_changed (skeleton);
}

static void
_xdp_impl_session_on_signal_closed (
    XdpImplSession *object)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_session_skeleton_iface_init (XdpImplSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplSessionSkeleton, xdp_impl_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SESSION, xdp_impl_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplSessionSkeleton, xdp_impl_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SESSION, xdp_impl_session_skeleton_iface_init))

#endif
static void
xdp_impl_session_skeleton_finalize (GObject *object)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_session_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_session_emit_changed (gpointer user_data)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_session_schedule_emit_changed (XdpImplSessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_session_skeleton_init (XdpImplSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_SESSION_SKELETON, XdpImplSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_impl_session_skeleton_get_version (XdpImplSession *object)
{
  XdpImplSessionSkeleton *skeleton = XDP_IMPL_SESSION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_session_skeleton_class_init (XdpImplSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_session_skeleton_finalize;
  gobject_class->get_property = xdp_impl_session_skeleton_get_property;
  gobject_class->set_property = xdp_impl_session_skeleton_set_property;
  gobject_class->notify       = xdp_impl_session_skeleton_notify;


  xdp_impl_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplSessionSkeletonPrivate));
#endif
}

static void
xdp_impl_session_skeleton_iface_init (XdpImplSessionIface *iface)
{
  iface->closed = _xdp_impl_session_on_signal_closed;
  iface->get_version = xdp_impl_session_skeleton_get_version;
}

/**
 * xdp_impl_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>.
 *
 * Returns: (transfer full) (type XdpImplSessionSkeleton): The skeleton object.
 */
XdpImplSession *
xdp_impl_session_skeleton_new (void)
{
  return XDP_IMPL_SESSION (g_object_new (XDP_IMPL_TYPE_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Settings
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplSettings
 * @title: XdpImplSettings
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Settings D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link> D-Bus interface in C.
 */

enum
{
  XDP_IMPL__SETTINGS_SETTING_CHANGED,
};

static unsigned XDP_IMPL__SETTINGS_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Settings ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_settings_method_info_read_all_IN_ARG_namespaces =
{
  {
    -1,
    (gchar *) "namespaces",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_settings_method_info_read_all_IN_ARG_pointers[] =
{
  &_xdp_impl_settings_method_info_read_all_IN_ARG_namespaces.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_method_info_read_all_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_settings_method_info_read_all_OUT_ARG_pointers[] =
{
  &_xdp_impl_settings_method_info_read_all_OUT_ARG_value.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_settings_method_read_all_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out0",
  (gchar *) "QMap<QString,QVariantMap>",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_settings_method_read_all_annotation_info_pointers[] =
{
  &_xdp_impl_settings_method_read_all_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_settings_method_info_read_all =
{
  {
    -1,
    (gchar *) "ReadAll",
    (GDBusArgInfo **) &_xdp_impl_settings_method_info_read_all_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_settings_method_info_read_all_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_settings_method_read_all_annotation_info_pointers
  },
  "handle-read-all",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_method_info_read_IN_ARG_namespace =
{
  {
    -1,
    (gchar *) "namespace",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_method_info_read_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_settings_method_info_read_IN_ARG_pointers[] =
{
  &_xdp_impl_settings_method_info_read_IN_ARG_namespace.parent_struct,
  &_xdp_impl_settings_method_info_read_IN_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_method_info_read_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_settings_method_info_read_OUT_ARG_pointers[] =
{
  &_xdp_impl_settings_method_info_read_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_settings_method_info_read =
{
  {
    -1,
    (gchar *) "Read",
    (GDBusArgInfo **) &_xdp_impl_settings_method_info_read_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_settings_method_info_read_OUT_ARG_pointers,
    NULL
  },
  "handle-read",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_settings_method_info_pointers[] =
{
  &_xdp_impl_settings_method_info_read_all.parent_struct,
  &_xdp_impl_settings_method_info_read.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_signal_info_setting_changed_ARG_namespace =
{
  {
    -1,
    (gchar *) "namespace",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_signal_info_setting_changed_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_settings_signal_info_setting_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_settings_signal_info_setting_changed_ARG_pointers[] =
{
  &_xdp_impl_settings_signal_info_setting_changed_ARG_namespace.parent_struct,
  &_xdp_impl_settings_signal_info_setting_changed_ARG_key.parent_struct,
  &_xdp_impl_settings_signal_info_setting_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_settings_signal_info_setting_changed =
{
  {
    -1,
    (gchar *) "SettingChanged",
    (GDBusArgInfo **) &_xdp_impl_settings_signal_info_setting_changed_ARG_pointers,
    NULL
  },
  "setting-changed"
};

static const GDBusSignalInfo * const _xdp_impl_settings_signal_info_pointers[] =
{
  &_xdp_impl_settings_signal_info_setting_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_settings_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_settings_property_info_pointers[] =
{
  &_xdp_impl_settings_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_settings_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Settings",
    (GDBusMethodInfo **) &_xdp_impl_settings_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_settings_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_impl_settings_property_info_pointers,
    NULL
  },
  "settings",
};


/**
 * xdp_impl_settings_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_settings_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_settings_interface_info.parent_struct;
}

/**
 * xdp_impl_settings_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplSettings interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_settings_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
xdp_impl_settings_signal_marshal_setting_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_settings_method_marshal_read_all (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xdp_impl_settings_method_marshal_read (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplSettings:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>.
 */

/**
 * XdpImplSettingsIface:
 * @parent_iface: The parent interface.
 * @handle_read: Handler for the #XdpImplSettings::handle-read signal.
 * @handle_read_all: Handler for the #XdpImplSettings::handle-read-all signal.
 * @get_version: Getter for the #XdpImplSettings:version property.
 * @setting_changed: Handler for the #XdpImplSettings::setting-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>.
 */

typedef XdpImplSettingsIface XdpImplSettingsInterface;
G_DEFINE_INTERFACE (XdpImplSettings, xdp_impl_settings, G_TYPE_OBJECT)

static void
xdp_impl_settings_default_init (XdpImplSettingsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplSettings::handle-read-all:
   * @object: A #XdpImplSettings.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_namespaces: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_settings_complete_read_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplSettingsIface, handle_read_all),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_settings_method_marshal_read_all,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * XdpImplSettings::handle-read:
   * @object: A #XdpImplSettings.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_namespace: Argument passed by remote caller.
   * @arg_key: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_settings_complete_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplSettingsIface, handle_read),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_settings_method_marshal_read,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplSettings::setting-changed:
   * @object: A #XdpImplSettings.
   * @arg_namespace: Argument.
   * @arg_key: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Settings.SettingChanged">"SettingChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  XDP_IMPL__SETTINGS_SIGNALS[XDP_IMPL__SETTINGS_SETTING_CHANGED] =
    g_signal_new ("setting-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (XdpImplSettingsIface, setting_changed),
      NULL,
      NULL,
      xdp_impl_settings_signal_marshal_setting_changed,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplSettings:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Settings.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_settings_get_version: (skip)
 * @object: A #XdpImplSettings.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Settings.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_settings_get_version (XdpImplSettings *object)
{
  g_return_val_if_fail (XDP_IMPL_IS_SETTINGS (object), 0);

  return XDP_IMPL_SETTINGS_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_settings_set_version: (skip)
 * @object: A #XdpImplSettings.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Settings.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_settings_set_version (XdpImplSettings *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_settings_emit_setting_changed:
 * @object: A #XdpImplSettings.
 * @arg_namespace: Argument to pass with the signal.
 * @arg_key: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Settings.SettingChanged">"SettingChanged"</link> D-Bus signal.
 */
void
xdp_impl_settings_emit_setting_changed (
    XdpImplSettings *object,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GVariant *arg_value)
{
  g_signal_emit (object, XDP_IMPL__SETTINGS_SIGNALS[XDP_IMPL__SETTINGS_SETTING_CHANGED], 0, arg_namespace, arg_key, arg_value);
}

/**
 * xdp_impl_settings_call_read_all:
 * @proxy: A #XdpImplSettingsProxy.
 * @arg_namespaces: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_settings_call_read_all_finish() to get the result of the operation.
 *
 * See xdp_impl_settings_call_read_all_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_settings_call_read_all (
    XdpImplSettings *proxy,
    const gchar *const *arg_namespaces,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReadAll",
    g_variant_new ("(^as)",
                   arg_namespaces),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_settings_call_read_all_finish:
 * @proxy: A #XdpImplSettingsProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_settings_call_read_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_settings_call_read_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_settings_call_read_all_finish (
    XdpImplSettings *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_settings_call_read_all_sync:
 * @proxy: A #XdpImplSettingsProxy.
 * @arg_namespaces: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_settings_call_read_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_settings_call_read_all_sync (
    XdpImplSettings *proxy,
    const gchar *const *arg_namespaces,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReadAll",
    g_variant_new ("(^as)",
                   arg_namespaces),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_settings_call_read:
 * @proxy: A #XdpImplSettingsProxy.
 * @arg_namespace: Argument to pass with the method invocation.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_settings_call_read_finish() to get the result of the operation.
 *
 * See xdp_impl_settings_call_read_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_settings_call_read (
    XdpImplSettings *proxy,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Read",
    g_variant_new ("(ss)",
                   arg_namespace,
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_settings_call_read_finish:
 * @proxy: A #XdpImplSettingsProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_settings_call_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_settings_call_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_settings_call_read_finish (
    XdpImplSettings *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_settings_call_read_sync:
 * @proxy: A #XdpImplSettingsProxy.
 * @arg_namespace: Argument to pass with the method invocation.
 * @arg_key: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_settings_call_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_settings_call_read_sync (
    XdpImplSettings *proxy,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Read",
    g_variant_new ("(ss)",
                   arg_namespace,
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_settings_complete_read_all:
 * @object: A #XdpImplSettings.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_settings_complete_read_all (
    XdpImplSettings *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}})",
                   value));
}

/**
 * xdp_impl_settings_complete_read:
 * @object: A #XdpImplSettings.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_settings_complete_read (
    XdpImplSettings *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   value));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplSettingsProxy:
 *
 * The #XdpImplSettingsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplSettingsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplSettingsProxy.
 */

struct _XdpImplSettingsProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_settings_proxy_iface_init (XdpImplSettingsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplSettingsProxy, xdp_impl_settings_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplSettingsProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SETTINGS, xdp_impl_settings_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplSettingsProxy, xdp_impl_settings_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SETTINGS, xdp_impl_settings_proxy_iface_init))

#endif
static void
xdp_impl_settings_proxy_finalize (GObject *object)
{
  XdpImplSettingsProxy *proxy = XDP_IMPL_SETTINGS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_settings_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_settings_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_settings_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_settings_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Settings: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_settings_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_settings_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Settings", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_settings_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_settings_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_settings_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_SETTINGS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SETTINGS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_settings_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplSettingsProxy *proxy = XDP_IMPL_SETTINGS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_settings_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_settings_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_settings_proxy_get_version (XdpImplSettings *object)
{
  XdpImplSettingsProxy *proxy = XDP_IMPL_SETTINGS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_settings_proxy_init (XdpImplSettingsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_settings_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_SETTINGS_PROXY, XdpImplSettingsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_settings_interface_info ());
}

static void
xdp_impl_settings_proxy_class_init (XdpImplSettingsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_settings_proxy_finalize;
  gobject_class->get_property = xdp_impl_settings_proxy_get_property;
  gobject_class->set_property = xdp_impl_settings_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_settings_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_settings_proxy_g_properties_changed;

  xdp_impl_settings_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplSettingsProxyPrivate));
#endif
}

static void
xdp_impl_settings_proxy_iface_init (XdpImplSettingsIface *iface)
{
  iface->get_version = xdp_impl_settings_proxy_get_version;
}

/**
 * xdp_impl_settings_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_settings_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_settings_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_settings_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SETTINGS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
}

/**
 * xdp_impl_settings_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_settings_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_settings_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSettings *
xdp_impl_settings_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SETTINGS (ret);
  else
    return NULL;
}

/**
 * xdp_impl_settings_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_settings_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSettings *
xdp_impl_settings_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SETTINGS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
  if (ret != NULL)
    return XDP_IMPL_SETTINGS (ret);
  else
    return NULL;
}


/**
 * xdp_impl_settings_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_settings_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_settings_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_settings_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_settings_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SETTINGS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
}

/**
 * xdp_impl_settings_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_settings_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_settings_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSettings *
xdp_impl_settings_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SETTINGS (ret);
  else
    return NULL;
}

/**
 * xdp_impl_settings_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_settings_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_settings_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSettings *
xdp_impl_settings_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SETTINGS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
  if (ret != NULL)
    return XDP_IMPL_SETTINGS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplSettingsSkeleton:
 *
 * The #XdpImplSettingsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplSettingsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplSettingsSkeleton.
 */

struct _XdpImplSettingsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_settings_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_SETTINGS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SETTINGS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_settings_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_settings_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_settings_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_settings_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_settings_skeleton_vtable =
{
  _xdp_impl_settings_skeleton_handle_method_call,
  _xdp_impl_settings_skeleton_handle_get_property,
  _xdp_impl_settings_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_settings_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_settings_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_settings_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_settings_skeleton_vtable;
}

static GVariant *
xdp_impl_settings_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_settings_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_settings_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_settings_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_settings_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Settings", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_settings_emit_changed (gpointer user_data);

static void
xdp_impl_settings_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_settings_emit_changed (skeleton);
}

static void
_xdp_impl_settings_on_signal_setting_changed (
    XdpImplSettings *object,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GVariant *arg_value)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss@v)",
                   arg_namespace,
                   arg_key,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Settings", "SettingChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_settings_skeleton_iface_init (XdpImplSettingsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplSettingsSkeleton, xdp_impl_settings_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplSettingsSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SETTINGS, xdp_impl_settings_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplSettingsSkeleton, xdp_impl_settings_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SETTINGS, xdp_impl_settings_skeleton_iface_init))

#endif
static void
xdp_impl_settings_skeleton_finalize (GObject *object)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_settings_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_settings_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_settings_emit_changed (gpointer user_data)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Settings",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_settings_schedule_emit_changed (XdpImplSettingsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_settings_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_settings_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_settings_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_settings_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_settings_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_settings_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_settings_skeleton_init (XdpImplSettingsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_settings_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_SETTINGS_SKELETON, XdpImplSettingsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_impl_settings_skeleton_get_version (XdpImplSettings *object)
{
  XdpImplSettingsSkeleton *skeleton = XDP_IMPL_SETTINGS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_settings_skeleton_class_init (XdpImplSettingsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_settings_skeleton_finalize;
  gobject_class->get_property = xdp_impl_settings_skeleton_get_property;
  gobject_class->set_property = xdp_impl_settings_skeleton_set_property;
  gobject_class->notify       = xdp_impl_settings_skeleton_notify;


  xdp_impl_settings_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_settings_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_settings_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_settings_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_settings_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplSettingsSkeletonPrivate));
#endif
}

static void
xdp_impl_settings_skeleton_iface_init (XdpImplSettingsIface *iface)
{
  iface->setting_changed = _xdp_impl_settings_on_signal_setting_changed;
  iface->get_version = xdp_impl_settings_skeleton_get_version;
}

/**
 * xdp_impl_settings_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>.
 *
 * Returns: (transfer full) (type XdpImplSettingsSkeleton): The skeleton object.
 */
XdpImplSettings *
xdp_impl_settings_skeleton_new (void)
{
  return XDP_IMPL_SETTINGS (g_object_new (XDP_IMPL_TYPE_SETTINGS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Wallpaper
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplWallpaper
 * @title: XdpImplWallpaper
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Wallpaper D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Wallpaper ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_pointers[] =
{
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_handle.parent_struct,
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_app_id.parent_struct,
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_uri.parent_struct,
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_pointers[] =
{
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_response.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_pointers[] =
{
  &_xdp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_wallpaper_method_info_set_wallpaper_uri =
{
  {
    -1,
    (gchar *) "SetWallpaperURI",
    (GDBusArgInfo **) &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_pointers
  },
  "handle-set-wallpaper-uri",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_wallpaper_method_info_pointers[] =
{
  &_xdp_impl_wallpaper_method_info_set_wallpaper_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_wallpaper_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Wallpaper",
    (GDBusMethodInfo **) &_xdp_impl_wallpaper_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "wallpaper",
};


/**
 * xdp_impl_wallpaper_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_wallpaper_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_wallpaper_interface_info.parent_struct;
}

/**
 * xdp_impl_wallpaper_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplWallpaper interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_wallpaper_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
xdp_impl_wallpaper_method_marshal_set_wallpaper_uri (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XdpImplWallpaper:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>.
 */

/**
 * XdpImplWallpaperIface:
 * @parent_iface: The parent interface.
 * @handle_set_wallpaper_uri: Handler for the #XdpImplWallpaper::handle-set-wallpaper-uri signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>.
 */

typedef XdpImplWallpaperIface XdpImplWallpaperInterface;
G_DEFINE_INTERFACE (XdpImplWallpaper, xdp_impl_wallpaper, G_TYPE_OBJECT)

static void
xdp_impl_wallpaper_default_init (XdpImplWallpaperIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplWallpaper::handle-set-wallpaper-uri:
   * @object: A #XdpImplWallpaper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_uri: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_wallpaper_complete_set_wallpaper_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-wallpaper-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplWallpaperIface, handle_set_wallpaper_uri),
    g_signal_accumulator_true_handled,
    NULL,
      xdp_impl_wallpaper_method_marshal_set_wallpaper_uri,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_wallpaper_call_set_wallpaper_uri:
 * @proxy: A #XdpImplWallpaperProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_wallpaper_call_set_wallpaper_uri_finish() to get the result of the operation.
 *
 * See xdp_impl_wallpaper_call_set_wallpaper_uri_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_wallpaper_call_set_wallpaper_uri (
    XdpImplWallpaper *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_uri,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetWallpaperURI",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_uri,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_wallpaper_call_set_wallpaper_uri_finish:
 * @proxy: A #XdpImplWallpaperProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_wallpaper_call_set_wallpaper_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_wallpaper_call_set_wallpaper_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_wallpaper_call_set_wallpaper_uri_finish (
    XdpImplWallpaper *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_wallpaper_call_set_wallpaper_uri_sync:
 * @proxy: A #XdpImplWallpaperProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_wallpaper_call_set_wallpaper_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_wallpaper_call_set_wallpaper_uri_sync (
    XdpImplWallpaper *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_uri,
    GVariant *arg_options,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetWallpaperURI",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_uri,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_wallpaper_complete_set_wallpaper_uri:
 * @object: A #XdpImplWallpaper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_wallpaper_complete_set_wallpaper_uri (
    XdpImplWallpaper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplWallpaperProxy:
 *
 * The #XdpImplWallpaperProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplWallpaperProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplWallpaperProxy.
 */

struct _XdpImplWallpaperProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_wallpaper_proxy_iface_init (XdpImplWallpaperIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplWallpaperProxy, xdp_impl_wallpaper_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplWallpaperProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_WALLPAPER, xdp_impl_wallpaper_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplWallpaperProxy, xdp_impl_wallpaper_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_WALLPAPER, xdp_impl_wallpaper_proxy_iface_init))

#endif
static void
xdp_impl_wallpaper_proxy_finalize (GObject *object)
{
  XdpImplWallpaperProxy *proxy = XDP_IMPL_WALLPAPER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_wallpaper_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_wallpaper_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_wallpaper_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_wallpaper_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_wallpaper_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_WALLPAPER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_WALLPAPER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_wallpaper_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplWallpaperProxy *proxy = XDP_IMPL_WALLPAPER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_wallpaper_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_wallpaper_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_wallpaper_proxy_init (XdpImplWallpaperProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_wallpaper_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_WALLPAPER_PROXY, XdpImplWallpaperProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_wallpaper_interface_info ());
}

static void
xdp_impl_wallpaper_proxy_class_init (XdpImplWallpaperProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_wallpaper_proxy_finalize;
  gobject_class->get_property = xdp_impl_wallpaper_proxy_get_property;
  gobject_class->set_property = xdp_impl_wallpaper_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_wallpaper_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_wallpaper_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplWallpaperProxyPrivate));
#endif
}

static void
xdp_impl_wallpaper_proxy_iface_init (XdpImplWallpaperIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_wallpaper_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_wallpaper_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_wallpaper_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_wallpaper_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_WALLPAPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
}

/**
 * xdp_impl_wallpaper_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_wallpaper_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_wallpaper_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplWallpaper *
xdp_impl_wallpaper_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_wallpaper_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_wallpaper_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplWallpaper *
xdp_impl_wallpaper_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_WALLPAPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
  if (ret != NULL)
    return XDP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}


/**
 * xdp_impl_wallpaper_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_wallpaper_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_wallpaper_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_wallpaper_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_wallpaper_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_WALLPAPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
}

/**
 * xdp_impl_wallpaper_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_wallpaper_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_wallpaper_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplWallpaper *
xdp_impl_wallpaper_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_wallpaper_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_wallpaper_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_wallpaper_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplWallpaper *
xdp_impl_wallpaper_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_WALLPAPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
  if (ret != NULL)
    return XDP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplWallpaperSkeleton:
 *
 * The #XdpImplWallpaperSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplWallpaperSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplWallpaperSkeleton.
 */

struct _XdpImplWallpaperSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_wallpaper_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplWallpaperSkeleton *skeleton = XDP_IMPL_WALLPAPER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_WALLPAPER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_WALLPAPER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_wallpaper_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplWallpaperSkeleton *skeleton = XDP_IMPL_WALLPAPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_wallpaper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_wallpaper_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplWallpaperSkeleton *skeleton = XDP_IMPL_WALLPAPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_wallpaper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_wallpaper_skeleton_vtable =
{
  _xdp_impl_wallpaper_skeleton_handle_method_call,
  _xdp_impl_wallpaper_skeleton_handle_get_property,
  _xdp_impl_wallpaper_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_wallpaper_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_wallpaper_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_wallpaper_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_wallpaper_skeleton_vtable;
}

static GVariant *
xdp_impl_wallpaper_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplWallpaperSkeleton *skeleton = XDP_IMPL_WALLPAPER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xdp_impl_wallpaper_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_wallpaper_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_wallpaper_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_wallpaper_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Wallpaper", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_wallpaper_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_wallpaper_skeleton_iface_init (XdpImplWallpaperIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplWallpaperSkeleton, xdp_impl_wallpaper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplWallpaperSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_WALLPAPER, xdp_impl_wallpaper_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplWallpaperSkeleton, xdp_impl_wallpaper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_WALLPAPER, xdp_impl_wallpaper_skeleton_iface_init))

#endif
static void
xdp_impl_wallpaper_skeleton_finalize (GObject *object)
{
  XdpImplWallpaperSkeleton *skeleton = XDP_IMPL_WALLPAPER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_wallpaper_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_wallpaper_skeleton_init (XdpImplWallpaperSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_wallpaper_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_WALLPAPER_SKELETON, XdpImplWallpaperSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_wallpaper_skeleton_class_init (XdpImplWallpaperSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_wallpaper_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_wallpaper_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_wallpaper_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_wallpaper_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_wallpaper_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplWallpaperSkeletonPrivate));
#endif
}

static void
xdp_impl_wallpaper_skeleton_iface_init (XdpImplWallpaperIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_wallpaper_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>.
 *
 * Returns: (transfer full) (type XdpImplWallpaperSkeleton): The skeleton object.
 */
XdpImplWallpaper *
xdp_impl_wallpaper_skeleton_new (void)
{
  return XDP_IMPL_WALLPAPER (g_object_new (XDP_IMPL_TYPE_WALLPAPER_SKELETON, NULL));
}

