/* extended-interface.c generated by valac 0.56.18, the Vala compiler
 * generated from extended-interface.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "xfmpc.h"
#include <src/libc/mpdclient.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <xfce-revision.h>
#include <libxfce4util/libxfce4util.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XFMPC_EXTENDED_INTERFACE_0_PROPERTY,
	XFMPC_EXTENDED_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* xfmpc_extended_interface_properties[XFMPC_EXTENDED_INTERFACE_NUM_PROPERTIES];
typedef enum  {
	XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_STRING,
	XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_POINTER,
	XFMPC_EXTENDED_INTERFACE_COLUMNS_N_COLUMNS
} XfmpcExtendedInterfaceColumns;

#define XFMPC_EXTENDED_INTERFACE_TYPE_COLUMNS (xfmpc_extended_interface_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _XfmpcExtendedInterfacePrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkMenuButton* context_button;
	GtkListStore* list_store;
	GtkNotebook* notebook;
	GtkMenu* context_menu;
	GtkCheckMenuItem* random;
	GtkCheckMenuItem* repeat;
	GtkCheckMenuItem* single;
	GtkCheckMenuItem* consume;
};

static gint XfmpcExtendedInterface_private_offset;
static gpointer xfmpc_extended_interface_parent_class = NULL;

static GType xfmpc_extended_interface_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void xfmpc_extended_interface_append_child (XfmpcExtendedInterface* self,
                                            GtkWidget* child,
                                            const gchar* title);
static void xfmpc_extended_interface_popup_context_menu (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_playlist_clear (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_database_refresh (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_interface_changed (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_context_menu_deactivate (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_repeat_switch (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_random_switch (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_single_switch (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_consume_switch (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_preferences (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_shortcuts (XfmpcExtendedInterface* self);
static void xfmpc_extended_interface_cb_about (XfmpcExtendedInterface* self);
static GObject * xfmpc_extended_interface_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _xfmpc_extended_interface_cb_playlist_clear_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _xfmpc_extended_interface_cb_database_refresh_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _xfmpc_extended_interface_popup_context_menu_gtk_button_pressed (GtkButton* _sender,
                                                                      gpointer self);
static void _xfmpc_extended_interface_cb_context_menu_deactivate_gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                                                                     gpointer self);
static void _xfmpc_extended_interface_cb_repeat_switch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void _xfmpc_extended_interface_cb_random_switch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void _xfmpc_extended_interface_cb_single_switch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void _xfmpc_extended_interface_cb_consume_switch_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                              gpointer self);
static void _xfmpc_extended_interface_cb_preferences_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                      gpointer self);
static void _xfmpc_extended_interface_cb_shortcuts_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                    gpointer self);
static void _xfmpc_extended_interface_cb_about_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                gpointer self);
static void _xfmpc_extended_interface_cb_interface_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                           gpointer self);
static void xfmpc_extended_interface_finalize (GObject * obj);
static GType xfmpc_extended_interface_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
xfmpc_extended_interface_get_instance_private (XfmpcExtendedInterface* self)
{
	return G_STRUCT_MEMBER_P (self, XfmpcExtendedInterface_private_offset);
}

 G_GNUC_NO_INLINE static GType
xfmpc_extended_interface_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_STRING, "XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_STRING", "column-string"}, {XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_POINTER, "XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_POINTER", "column-pointer"}, {XFMPC_EXTENDED_INTERFACE_COLUMNS_N_COLUMNS, "XFMPC_EXTENDED_INTERFACE_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType xfmpc_extended_interface_columns_type_id;
	xfmpc_extended_interface_columns_type_id = g_enum_register_static ("XfmpcExtendedInterfaceColumns", values);
	return xfmpc_extended_interface_columns_type_id;
}

static GType
xfmpc_extended_interface_columns_get_type (void)
{
	static volatile gsize xfmpc_extended_interface_columns_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_extended_interface_columns_type_id__once)) {
		GType xfmpc_extended_interface_columns_type_id;
		xfmpc_extended_interface_columns_type_id = xfmpc_extended_interface_columns_get_type_once ();
		g_once_init_leave (&xfmpc_extended_interface_columns_type_id__once, xfmpc_extended_interface_columns_type_id);
	}
	return xfmpc_extended_interface_columns_type_id__once;
}

 G_GNUC_NO_INLINE static GType
xfmpc_extended_interface_extended_interface_widget_get_type_once (void)
{
	static const GEnumValue values[] = {{XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_PLAYLIST, "XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_PLAYLIST", "playlist"}, {XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER, "XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER", "dbbrowser"}, {0, NULL, NULL}};
	GType xfmpc_extended_interface_extended_interface_widget_type_id;
	xfmpc_extended_interface_extended_interface_widget_type_id = g_enum_register_static ("XfmpcExtendedInterfaceExtendedInterfaceWidget", values);
	return xfmpc_extended_interface_extended_interface_widget_type_id;
}

GType
xfmpc_extended_interface_extended_interface_widget_get_type (void)
{
	static volatile gsize xfmpc_extended_interface_extended_interface_widget_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_extended_interface_extended_interface_widget_type_id__once)) {
		GType xfmpc_extended_interface_extended_interface_widget_type_id;
		xfmpc_extended_interface_extended_interface_widget_type_id = xfmpc_extended_interface_extended_interface_widget_get_type_once ();
		g_once_init_leave (&xfmpc_extended_interface_extended_interface_widget_type_id__once, xfmpc_extended_interface_extended_interface_widget_type_id);
	}
	return xfmpc_extended_interface_extended_interface_widget_type_id__once;
}

void
xfmpc_extended_interface_set_active (XfmpcExtendedInterface* self,
                                     XfmpcExtendedInterfaceExtendedInterfaceWidget active_widget)
{
	GtkComboBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->combobox;
	gtk_combo_box_set_active (_tmp0_, (gint) active_widget);
}

static void
xfmpc_extended_interface_append_child (XfmpcExtendedInterface* self,
                                       GtkWidget* child,
                                       const gchar* title)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkComboBox* _tmp4_;
	GtkNotebook* _tmp6_;
	GtkNotebook* _tmp7_;
	GValue _tmp8_ = {0};
	GtkNotebook* _tmp9_;
	GValue _tmp10_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->list_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->list_store;
	_tmp3_ = iter;
	gtk_list_store_set (_tmp2_, &_tmp3_, XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_STRING, title, XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_POINTER, child, -1, -1);
	_tmp4_ = self->combobox;
	if (gtk_combo_box_get_active (_tmp4_) == -1) {
		GtkComboBox* _tmp5_;
		_tmp5_ = self->combobox;
		gtk_combo_box_set_active (_tmp5_, 0);
	}
	_tmp6_ = self->priv->notebook;
	gtk_notebook_append_page (_tmp6_, child, NULL);
	_tmp7_ = self->priv->notebook;
	g_value_init (&_tmp8_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp8_, TRUE);
	gtk_container_child_set_property ((GtkContainer*) _tmp7_, child, "tab-expand", &_tmp8_);
	G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
	_tmp9_ = self->priv->notebook;
	g_value_init (&_tmp10_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp10_, TRUE);
	gtk_container_child_set_property ((GtkContainer*) _tmp9_, child, "tab-fill", &_tmp10_);
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
}

static void
xfmpc_extended_interface_popup_context_menu (XfmpcExtendedInterface* self)
{
	GtkCheckMenuItem* _tmp0_;
	XfmpcMpdclient* _tmp1_;
	GtkCheckMenuItem* _tmp2_;
	XfmpcMpdclient* _tmp3_;
	GtkCheckMenuItem* _tmp4_;
	XfmpcMpdclient* _tmp5_;
	GtkCheckMenuItem* _tmp6_;
	XfmpcMpdclient* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->repeat;
	_tmp1_ = self->priv->mpdclient;
	gtk_check_menu_item_set_active (_tmp0_, xfmpc_mpdclient_get_repeat (_tmp1_));
	_tmp2_ = self->priv->random;
	_tmp3_ = self->priv->mpdclient;
	gtk_check_menu_item_set_active (_tmp2_, xfmpc_mpdclient_get_random (_tmp3_));
	_tmp4_ = self->priv->single;
	_tmp5_ = self->priv->mpdclient;
	gtk_check_menu_item_set_active (_tmp4_, xfmpc_mpdclient_get_single (_tmp5_));
	_tmp6_ = self->priv->consume;
	_tmp7_ = self->priv->mpdclient;
	gtk_check_menu_item_set_active (_tmp6_, xfmpc_mpdclient_get_consume (_tmp7_));
}

static void
xfmpc_extended_interface_cb_playlist_clear (XfmpcExtendedInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_playlist_clear (_tmp0_);
}

static void
xfmpc_extended_interface_cb_database_refresh (XfmpcExtendedInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_database_refresh (_tmp0_);
}

static void
xfmpc_extended_interface_cb_interface_changed (XfmpcExtendedInterface* self)
{
	void* child = NULL;
	GtkTreeIter iter = {0};
	gint i = 0;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	void* _tmp5_ = NULL;
	GtkNotebook* _tmp6_;
	void* _tmp7_;
	GtkNotebook* _tmp8_;
	g_return_if_fail (self != NULL);
	child = NULL;
	i = 0;
	_tmp0_ = self->combobox;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_ == FALSE) {
		return;
	}
	_tmp3_ = self->priv->list_store;
	_tmp4_ = iter;
	gtk_tree_model_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_tree_model_get_type (), GtkTreeModel), &_tmp4_, XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_POINTER, &_tmp5_, -1, -1);
	child = _tmp5_;
	_tmp6_ = self->priv->notebook;
	_tmp7_ = child;
	i = gtk_notebook_page_num (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp8_, i);
}

static void
xfmpc_extended_interface_cb_context_menu_deactivate (XfmpcExtendedInterface* self)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context_button;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), FALSE);
}

static void
xfmpc_extended_interface_cb_repeat_switch (XfmpcExtendedInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	GtkCheckMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = self->priv->repeat;
	xfmpc_mpdclient_set_repeat (_tmp0_, gtk_check_menu_item_get_active (_tmp1_));
}

static void
xfmpc_extended_interface_cb_random_switch (XfmpcExtendedInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	GtkCheckMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = self->priv->random;
	xfmpc_mpdclient_set_random (_tmp0_, gtk_check_menu_item_get_active (_tmp1_));
}

static void
xfmpc_extended_interface_cb_single_switch (XfmpcExtendedInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	GtkCheckMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = self->priv->single;
	xfmpc_mpdclient_set_single (_tmp0_, gtk_check_menu_item_get_active (_tmp1_));
}

static void
xfmpc_extended_interface_cb_consume_switch (XfmpcExtendedInterface* self)
{
	XfmpcMpdclient* _tmp0_;
	GtkCheckMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = self->priv->consume;
	xfmpc_mpdclient_set_consume (_tmp0_, gtk_check_menu_item_get_active (_tmp1_));
}

static void
xfmpc_extended_interface_cb_preferences (XfmpcExtendedInterface* self)
{
	XfmpcPreferencesDialog* dialog = NULL;
	XfmpcPreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfmpc_preferences_dialog_new ();
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
xfmpc_extended_interface_cb_shortcuts (XfmpcExtendedInterface* self)
{
	XfmpcShortcutsDialog* dialog = NULL;
	XfmpcShortcutsDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfmpc_shortcuts_dialog_new ();
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
xfmpc_extended_interface_cb_about (XfmpcExtendedInterface* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint authors_length1;
	gint _authors_size_;
	GtkWidget* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Mike Massonnet <mmassonnet@xfce.org>");
	_tmp1_ = g_strdup ("Vincent Legout <vincent@xfce.org>");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = xfce_get_license_text (XFCE_LICENSE_TEXT_GPL);
	gtk_show_about_dialog (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow), "artists", NULL, "authors", authors, "comments", _ ("MPD client written in GTK+ for Xfce"), "copyright", "Copyright \xc2\xa9 2008-" COPYRIGHT_YEAR " The Xfce development team", "documenters", NULL, "license", _tmp4_, "translator-credits", _ ("translator-credits"), "version", VERSION_FULL, "website", "http://goodies.xfce.org/projects/applications/xfmpc", NULL, NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

XfmpcExtendedInterface*
xfmpc_extended_interface_construct (GType object_type)
{
	XfmpcExtendedInterface * self = NULL;
	self = (XfmpcExtendedInterface*) g_object_new (object_type, NULL);
	return self;
}

XfmpcExtendedInterface*
xfmpc_extended_interface_new (void)
{
	return xfmpc_extended_interface_construct (XFMPC_TYPE_EXTENDED_INTERFACE);
}

static void
_xfmpc_extended_interface_cb_playlist_clear_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	xfmpc_extended_interface_cb_playlist_clear ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_database_refresh_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	xfmpc_extended_interface_cb_database_refresh ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_popup_context_menu_gtk_button_pressed (GtkButton* _sender,
                                                                 gpointer self)
{
	xfmpc_extended_interface_popup_context_menu ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_context_menu_deactivate_gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                                                                gpointer self)
{
	xfmpc_extended_interface_cb_context_menu_deactivate ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_repeat_switch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	xfmpc_extended_interface_cb_repeat_switch ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_random_switch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	xfmpc_extended_interface_cb_random_switch ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_single_switch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	xfmpc_extended_interface_cb_single_switch ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_consume_switch_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                         gpointer self)
{
	xfmpc_extended_interface_cb_consume_switch ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_preferences_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                 gpointer self)
{
	xfmpc_extended_interface_cb_preferences ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_shortcuts_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self)
{
	xfmpc_extended_interface_cb_shortcuts ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_about_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self)
{
	xfmpc_extended_interface_cb_about ((XfmpcExtendedInterface*) self);
}

static void
_xfmpc_extended_interface_cb_interface_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self)
{
	xfmpc_extended_interface_cb_interface_changed ((XfmpcExtendedInterface*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
xfmpc_extended_interface_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcExtendedInterface * self;
	XfmpcMpdclient* _tmp0_;
	XfmpcPreferences* _tmp1_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkButton* button = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkBox* _tmp7_;
	GtkButton* _tmp8_;
	GtkImage* image = NULL;
	GtkImage* _tmp9_;
	GtkButton* _tmp10_;
	GtkImage* _tmp11_;
	GtkButton* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkBox* _tmp17_;
	GtkButton* _tmp18_;
	GtkImage* _tmp19_;
	GtkButton* _tmp20_;
	GtkImage* _tmp21_;
	GtkMenuButton* _tmp22_;
	GtkMenuButton* _tmp23_;
	GtkMenuButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkMenuButton* _tmp26_;
	GtkMenu* _tmp27_;
	GtkMenu* _tmp28_;
	GtkCheckMenuItem* _tmp29_;
	GtkCheckMenuItem* _tmp30_;
	GtkMenu* _tmp31_;
	GtkCheckMenuItem* _tmp32_;
	GtkCheckMenuItem* _tmp33_;
	GtkCheckMenuItem* _tmp34_;
	GtkMenu* _tmp35_;
	GtkCheckMenuItem* _tmp36_;
	GtkCheckMenuItem* _tmp37_;
	GtkCheckMenuItem* _tmp38_;
	GtkMenu* _tmp39_;
	GtkCheckMenuItem* _tmp40_;
	GtkCheckMenuItem* _tmp41_;
	GtkCheckMenuItem* _tmp42_;
	GtkMenu* _tmp43_;
	GtkCheckMenuItem* _tmp44_;
	GtkSeparatorMenuItem* separator = NULL;
	GtkSeparatorMenuItem* _tmp45_;
	GtkMenu* _tmp46_;
	GtkSeparatorMenuItem* _tmp47_;
	GtkMenuItem* imi = NULL;
	GtkMenuItem* _tmp48_;
	GtkMenuItem* _tmp49_;
	GtkMenu* _tmp50_;
	GtkMenuItem* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	GtkMenu* _tmp54_;
	GtkMenuItem* _tmp55_;
	GtkMenuItem* _tmp56_;
	GtkMenuItem* _tmp57_;
	GtkMenu* _tmp58_;
	GtkMenuItem* _tmp59_;
	GtkMenu* _tmp60_;
	GtkMenuButton* _tmp61_;
	GtkMenu* _tmp62_;
	GtkListStore* _tmp63_;
	GtkListStore* _tmp64_;
	GtkComboBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkComboBox* _tmp67_;
	GtkComboBox* _tmp68_;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp69_;
	GtkComboBox* _tmp70_;
	GtkCellRendererText* _tmp71_;
	GtkComboBox* _tmp72_;
	GtkCellRendererText* _tmp73_;
	GtkNotebook* _tmp74_;
	GtkNotebook* _tmp75_;
	GtkNotebook* _tmp76_;
	XfmpcPlaylist* _tmp77_;
	XfmpcPlaylist* _tmp78_;
	XfmpcDbbrowser* _tmp79_;
	XfmpcDbbrowser* _tmp80_;
	XfmpcPlaylist* _tmp81_;
	XfmpcDbbrowser* _tmp82_;
	XfmpcDbbrowser* _tmp83_;
	XfmpcDbbrowser* _tmp84_;
	XfmpcPlaylist* _tmp85_;
	XfmpcPlaylist* _tmp86_;
	XfmpcPlaylist* _tmp87_;
	XfmpcExtendedInterface* _tmp88_;
	parent_class = G_OBJECT_CLASS (xfmpc_extended_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterface);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp2_);
	hbox = _tmp2_;
	_tmp3_ = hbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 2);
	_tmp4_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp4_);
	button = _tmp4_;
	_tmp5_ = button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Clear Playlist"));
	_tmp6_ = button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _xfmpc_extended_interface_cb_playlist_clear_gtk_button_clicked, self, 0);
	_tmp7_ = hbox;
	_tmp8_ = button;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name ("list-remove-all", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	image = _tmp9_;
	_tmp10_ = button;
	_tmp11_ = image;
	gtk_button_set_image (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = button;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "destructive-action");
	_tmp14_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (button);
	button = _tmp14_;
	_tmp15_ = button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Refresh Database"));
	_tmp16_ = button;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) _xfmpc_extended_interface_cb_database_refresh_gtk_button_clicked, self, 0);
	_tmp17_ = hbox;
	_tmp18_ = button;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, FALSE, FALSE, (guint) 0);
	_tmp19_ = (GtkImage*) gtk_image_new_from_icon_name ("view-refresh", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (image);
	image = _tmp19_;
	_tmp20_ = button;
	_tmp21_ = image;
	gtk_button_set_image (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->context_button);
	self->priv->context_button = _tmp22_;
	_tmp23_ = self->priv->context_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp23_, _ ("Context Menu"));
	_tmp24_ = self->priv->context_button;
	g_signal_connect_object ((GtkButton*) _tmp24_, "pressed", (GCallback) _xfmpc_extended_interface_popup_context_menu_gtk_button_pressed, self, 0);
	_tmp25_ = hbox;
	_tmp26_ = self->priv->context_button;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, FALSE, FALSE, (guint) 0);
	_tmp27_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp27_;
	_tmp28_ = self->priv->context_menu;
	g_signal_connect_object ((GtkMenuShell*) _tmp28_, "deactivate", (GCallback) _xfmpc_extended_interface_cb_context_menu_deactivate_gtk_menu_shell_deactivate, self, 0);
	_tmp29_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Repeat"));
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->repeat);
	self->priv->repeat = _tmp29_;
	_tmp30_ = self->priv->repeat;
	g_signal_connect_object ((GtkMenuItem*) _tmp30_, "activate", (GCallback) _xfmpc_extended_interface_cb_repeat_switch_gtk_menu_item_activate, self, 0);
	_tmp31_ = self->priv->context_menu;
	_tmp32_ = self->priv->repeat;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp31_, (GtkMenuItem*) _tmp32_);
	_tmp33_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Random"));
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->random);
	self->priv->random = _tmp33_;
	_tmp34_ = self->priv->random;
	g_signal_connect_object ((GtkMenuItem*) _tmp34_, "activate", (GCallback) _xfmpc_extended_interface_cb_random_switch_gtk_menu_item_activate, self, 0);
	_tmp35_ = self->priv->context_menu;
	_tmp36_ = self->priv->random;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp35_, (GtkMenuItem*) _tmp36_);
	_tmp37_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Single Mode"));
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->single);
	self->priv->single = _tmp37_;
	_tmp38_ = self->priv->single;
	g_signal_connect_object ((GtkMenuItem*) _tmp38_, "activate", (GCallback) _xfmpc_extended_interface_cb_single_switch_gtk_menu_item_activate, self, 0);
	_tmp39_ = self->priv->context_menu;
	_tmp40_ = self->priv->single;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp39_, (GtkMenuItem*) _tmp40_);
	_tmp41_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Consume Mode"));
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->consume);
	self->priv->consume = _tmp41_;
	_tmp42_ = self->priv->consume;
	g_signal_connect_object (_tmp42_, "toggled", (GCallback) _xfmpc_extended_interface_cb_consume_switch_gtk_check_menu_item_toggled, self, 0);
	_tmp43_ = self->priv->context_menu;
	_tmp44_ = self->priv->consume;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp43_, (GtkMenuItem*) _tmp44_);
	_tmp45_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp45_);
	separator = _tmp45_;
	_tmp46_ = self->priv->context_menu;
	_tmp47_ = separator;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp46_, (GtkMenuItem*) _tmp47_);
	_tmp48_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Preferences"));
	g_object_ref_sink (_tmp48_);
	imi = _tmp48_;
	_tmp49_ = imi;
	g_signal_connect_object (_tmp49_, "activate", (GCallback) _xfmpc_extended_interface_cb_preferences_gtk_menu_item_activate, self, 0);
	_tmp50_ = self->priv->context_menu;
	_tmp51_ = imi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp50_, _tmp51_);
	_tmp52_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Shortcuts"));
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (imi);
	imi = _tmp52_;
	_tmp53_ = imi;
	g_signal_connect_object (_tmp53_, "activate", (GCallback) _xfmpc_extended_interface_cb_shortcuts_gtk_menu_item_activate, self, 0);
	_tmp54_ = self->priv->context_menu;
	_tmp55_ = imi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp54_, _tmp55_);
	_tmp56_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_About"));
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (imi);
	imi = _tmp56_;
	_tmp57_ = imi;
	g_signal_connect_object (_tmp57_, "activate", (GCallback) _xfmpc_extended_interface_cb_about_gtk_menu_item_activate, self, 0);
	_tmp58_ = self->priv->context_menu;
	_tmp59_ = imi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp58_, _tmp59_);
	_tmp60_ = self->priv->context_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->context_button;
	_tmp62_ = self->priv->context_menu;
	gtk_menu_button_set_popup (_tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = gtk_list_store_new ((gint) XFMPC_EXTENDED_INTERFACE_COLUMNS_N_COLUMNS, G_TYPE_STRING, G_TYPE_POINTER, -1);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp63_;
	_tmp64_ = self->priv->list_store;
	_tmp65_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp64_);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->combobox);
	self->combobox = _tmp65_;
	_tmp66_ = hbox;
	_tmp67_ = self->combobox;
	gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, TRUE, TRUE, (guint) 0);
	_tmp68_ = self->combobox;
	g_signal_connect_object (_tmp68_, "changed", (GCallback) _xfmpc_extended_interface_cb_interface_changed_gtk_combo_box_changed, self, 0);
	_tmp69_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp69_);
	cell = _tmp69_;
	_tmp70_ = self->combobox;
	_tmp71_ = cell;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp70_, (GtkCellRenderer*) _tmp71_, TRUE);
	_tmp72_ = self->combobox;
	_tmp73_ = cell;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp72_, (GtkCellRenderer*) _tmp73_, "text", XFMPC_EXTENDED_INTERFACE_COLUMNS_COLUMN_STRING, NULL, NULL);
	_tmp74_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp74_;
	_tmp75_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp75_, FALSE);
	_tmp76_ = self->priv->notebook;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp76_, TRUE, TRUE, (guint) 0);
	_tmp77_ = xfmpc_playlist_new ();
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->playlist);
	self->playlist = _tmp77_;
	_tmp78_ = self->playlist;
	xfmpc_extended_interface_append_child (self, (GtkWidget*) _tmp78_, _ ("Current Playlist"));
	_tmp79_ = xfmpc_dbbrowser_new ();
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->dbbrowser);
	self->dbbrowser = _tmp79_;
	_tmp80_ = self->dbbrowser;
	xfmpc_extended_interface_append_child (self, (GtkWidget*) _tmp80_, _ ("Browse database"));
	_tmp81_ = self->playlist;
	_tmp82_ = self->dbbrowser;
	_tmp83_ = _g_object_ref0 (_tmp82_);
	g_object_set_data_full ((GObject*) _tmp81_, "XfmpcDbbrowser", _tmp83_, g_object_unref);
	_tmp84_ = self->dbbrowser;
	_tmp85_ = self->playlist;
	_tmp86_ = _g_object_ref0 (_tmp85_);
	g_object_set_data_full ((GObject*) _tmp84_, "XfmpcPlaylist", _tmp86_, g_object_unref);
	_tmp87_ = self->playlist;
	_tmp88_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) _tmp87_, "XfmpcExtendedInterface", _tmp88_, g_object_unref);
	_g_object_unref0 (cell);
	_g_object_unref0 (imi);
	_g_object_unref0 (separator);
	_g_object_unref0 (image);
	_g_object_unref0 (button);
	_g_object_unref0 (hbox);
	return obj;
}

static void
xfmpc_extended_interface_class_init (XfmpcExtendedInterfaceClass * klass,
                                     gpointer klass_data)
{
	xfmpc_extended_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XfmpcExtendedInterface_private_offset);
	G_OBJECT_CLASS (klass)->constructor = xfmpc_extended_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_extended_interface_finalize;
}

static void
xfmpc_extended_interface_instance_init (XfmpcExtendedInterface * self,
                                        gpointer klass)
{
	self->priv = xfmpc_extended_interface_get_instance_private (self);
}

static void
xfmpc_extended_interface_finalize (GObject * obj)
{
	XfmpcExtendedInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterface);
	_g_object_unref0 (self->dbbrowser);
	_g_object_unref0 (self->playlist);
	_g_object_unref0 (self->priv->context_button);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->combobox);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->context_menu);
	_g_object_unref0 (self->priv->random);
	_g_object_unref0 (self->priv->repeat);
	_g_object_unref0 (self->priv->single);
	_g_object_unref0 (self->priv->consume);
	G_OBJECT_CLASS (xfmpc_extended_interface_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
xfmpc_extended_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XfmpcExtendedInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_extended_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcExtendedInterface), 0, (GInstanceInitFunc) xfmpc_extended_interface_instance_init, NULL };
	GType xfmpc_extended_interface_type_id;
	xfmpc_extended_interface_type_id = g_type_register_static (gtk_box_get_type (), "XfmpcExtendedInterface", &g_define_type_info, 0);
	XfmpcExtendedInterface_private_offset = g_type_add_instance_private (xfmpc_extended_interface_type_id, sizeof (XfmpcExtendedInterfacePrivate));
	return xfmpc_extended_interface_type_id;
}

GType
xfmpc_extended_interface_get_type (void)
{
	static volatile gsize xfmpc_extended_interface_type_id__once = 0;
	if (g_once_init_enter (&xfmpc_extended_interface_type_id__once)) {
		GType xfmpc_extended_interface_type_id;
		xfmpc_extended_interface_type_id = xfmpc_extended_interface_get_type_once ();
		g_once_init_leave (&xfmpc_extended_interface_type_id__once, xfmpc_extended_interface_type_id);
	}
	return xfmpc_extended_interface_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

