# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT
from cli.args import parse_args
from cli.console_output import CliConsoleOutput
from tools.common.python_version import PythonVersion, UnsupportedPythonVersionError


def main(dry_run=False):
    CliConsoleOutput.show_banner()

    if not PythonVersion.is_supported():
        raise UnsupportedPythonVersionError(PythonVersion.SUPPORTED_VERSIONS)

    args = parse_args()
    CliConsoleOutput.initialize_logging(args.verbose)

    try:
        if not dry_run:
            run(args)
        else:
            return args
    except Exception as e:
        CliConsoleOutput.show_error('Error running Metric post processor', exception=e)


def run(cli_args):
    from cli.application import MppApplication
    mpp_application = MppApplication(cli_args)
    mpp_application.run()
