<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace=""
  xmlns:int="http://www.w3.org/2001/XMLSchema#int"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  xmlns:str="http://exslt.org/strings"
  syntax="norules">
 <xsl:template match="/">
<main xsl:version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace=""
      xmlns:str="http://exslt.org/strings" str:keep_str_namespace="" syntax="norules">
  <xsl:variable name="tmamEventsFileBig" select="document('config://analysis_type/include/tmam/lnc.xsl')"/>
  <xsl:variable name="tmamEventsFileSmall" select="document('config://analysis_type/include/tmam/skt_arl.xsl')"/>
  <xsl:variable name="tmamEventsFileSocSmall" select="document('config://analysis_type/include/tmam/cmt.xsl')"/>
  <root_tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/root_tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/root_tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/root_tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/root_tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/root_tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/root_tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </root_tree>
  <Top_Level_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Top_Level_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Top_Level_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Top_Level_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Top_Level_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Top_Level_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Top_Level_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </Top_Level_Tree>
  <Front_End_Bound_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Front_End_Bound_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Front_End_Bound_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Front_End_Bound_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Front_End_Bound_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Front_End_Bound_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Front_End_Bound_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </Front_End_Bound_Tree>
  <Bad_Speculation_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Bad_Speculation_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Bad_Speculation_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Bad_Speculation_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Bad_Speculation_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Bad_Speculation_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Bad_Speculation_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </Bad_Speculation_Tree>
  <Memory_Bound_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Memory_Bound_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Memory_Bound_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Memory_Bound_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Memory_Bound_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Memory_Bound_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Memory_Bound_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </Memory_Bound_Tree>
  <Core_Bound_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Core_Bound_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Back_End_Bound_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Back_End_Bound_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Core_Bound_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Back_End_Bound_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Back_End_Bound_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </Core_Bound_Tree>
  <Retiring_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Retiring_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Retiring_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Retiring_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/Retiring_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/Retiring_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/Retiring_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </Retiring_Tree>
  <HPC_Tree>
    <BaseEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/HPC_Tree/BaseEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/HPC_Tree/BaseEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/HPC_Tree/BaseEvents"/>
      </xsl:if>
    </BaseEvents>
    <HypervisorEvents>
      <xsl:value-of select="$tmamEventsFileBig//main/HPC_Tree/HypervisorEvents"/>
      <xsl:value-of select="$tmamEventsFileSmall//main/HPC_Tree/HypervisorEvents"/>
      <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
        <xsl:value-of select="$tmamEventsFileSocSmall//main/HPC_Tree/HypervisorEvents"/>
      </xsl:if>
    </HypervisorEvents>
  </HPC_Tree>
</main>
</xsl:template>
</xsl:stylesheet>
