/*
 * Copyright (C) 2021 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#pragma OPENCL EXTENSION cl_khr_fp16 : enable

__kernel void Fma2H(__local half *pA, __local half *pB)
{
    const int id = get_local_id(0);

    half a = pA[id];
    half b = pB[id];
    half c = 1.f;

    for (int count = 0; count < 512; count++)
    {
        c = mad(a, b, c);
    }
    if (!c)
    {
        pB[id] = c;
    }
}
