/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.obofoundry;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.obofoundry.OboFoundryEntry;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.semanticweb.owlapi.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboFoundryLink
extends Link {
    private static final Logger logger = LoggerFactory.getLogger(OboFoundryLink.class);
    private final IRI termIri;
    private final OboFoundryEntry entry;

    public OboFoundryLink(@Nonnull String oboId, @Nonnull IRI termIri, @Nonnull OboFoundryEntry entry) {
        super(OboFoundryLink.format(oboId, entry));
        this.termIri = (IRI)Preconditions.checkNotNull((Object)termIri);
        this.entry = (OboFoundryEntry)Preconditions.checkNotNull((Object)entry);
    }

    private static String format(String oboId, OboFoundryEntry entry) {
        if (entry.isObsolete()) {
            return oboId + " (obsolete)";
        }
        return oboId;
    }

    @Override
    public void activate(Component component, MouseEvent event) {
        if (event.isPopupTrigger()) {
            return;
        }
        URI termUri = this.termIri.toURI();
        try {
            Desktop.getDesktop().browse(termUri);
        }
        catch (IOException e) {
            logger.error("An error occurred whilst trying to activate an http link.  Link: {}", new Object[]{termUri, e.getMessage(), e});
        }
    }

    @Override
    public boolean isRollOverLink() {
        return false;
    }
}

