/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.internal.hppc.IntFloatHashMap;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;

public class ValueSourceAugmenter
extends DocTransformer {
    private static final Object NULL_SENTINEL = new Object();
    public final String name;
    public final QParser qparser;
    public final ValueSource valueSource;
    private final int maxPrefetchSize;
    Map<Object, Object> fcontext;
    SolrIndexSearcher searcher;
    List<LeafReaderContext> readerContexts;
    IntObjectHashMap<Object> cachedValuesById;

    public ValueSourceAugmenter(String name, QParser qparser, ValueSource valueSource) {
        this.name = name;
        this.qparser = qparser;
        this.valueSource = valueSource;
        String maxPrefetchSizeRaw = qparser.getParam("preFetchDocs");
        this.maxPrefetchSize = maxPrefetchSizeRaw != null ? Integer.parseInt(maxPrefetchSizeRaw) : 1000;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContext(ResultContext context) {
        super.setContext(context);
        try {
            MutableScorable scorable;
            IntFloatHashMap docToScoreMap;
            int prefetchSize;
            this.searcher = context.getSearcher();
            this.readerContexts = this.searcher.getIndexReader().leaves();
            this.fcontext = ValueSource.newContext((IndexSearcher)this.searcher);
            this.valueSource.createWeight(this.fcontext, (IndexSearcher)this.searcher);
            DocList docList = context.getDocList();
            int n = prefetchSize = docList == null ? 0 : Math.min(docList.size(), this.maxPrefetchSize);
            if (prefetchSize == 0) {
                return;
            }
            if (context.wantsScores()) {
                docToScoreMap = new IntFloatHashMap(prefetchSize);
                scorable = new MutableScorable(){

                    public float score() throws IOException {
                        return docToScoreMap.get(this.docBase + this.localDocId);
                    }
                };
                this.fcontext.put("scorer", (Object)scorable);
            } else {
                scorable = null;
                docToScoreMap = null;
            }
            int[] ids = new int[prefetchSize];
            DocIterator iter = docList.iterator();
            for (int i = 0; iter.hasNext() && i < prefetchSize; ++i) {
                ids[i] = iter.nextDoc();
                if (docToScoreMap == null) continue;
                docToScoreMap.put(ids[i], iter.score());
            }
            Arrays.sort(ids);
            this.cachedValuesById = new IntObjectHashMap(ids.length);
            FunctionValues values = null;
            int docBase = -1;
            int nextDocBase = 0;
            for (int docid : ids) {
                Object value;
                if (docid >= nextDocBase) {
                    int idx = ReaderUtil.subIndex((int)docid, this.readerContexts);
                    LeafReaderContext rcontext = this.readerContexts.get(idx);
                    docBase = rcontext.docBase;
                    nextDocBase = docBase + rcontext.reader().maxDoc();
                    values = this.valueSource.getValues(this.fcontext, rcontext);
                }
                int localId = docid - docBase;
                if (scorable != null) {
                    scorable.docBase = docBase;
                    scorable.localDocId = localId;
                }
                this.cachedValuesById.put(docid, (value = values.objectVal(localId)) != null ? value : NULL_SENTINEL);
            }
            this.fcontext.remove("scorer");
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "exception for valuesource " + String.valueOf(this.valueSource), (Throwable)e);
        }
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        Object cacheValue;
        Object object = cacheValue = this.cachedValuesById != null ? this.cachedValuesById.get(docid) : null;
        if (cacheValue != null) {
            this.setValue(doc, cacheValue != NULL_SENTINEL ? cacheValue : null);
        } else {
            try {
                int idx = ReaderUtil.subIndex((int)docid, this.readerContexts);
                LeafReaderContext rcontext = this.readerContexts.get(idx);
                int localId = docid - rcontext.docBase;
                if (this.context.wantsScores()) {
                    this.fcontext.put("scorer", (Object)new ScoreAndDoc(localId, ((Float)doc.get((Object)"score")).floatValue()));
                }
                FunctionValues values = this.valueSource.getValues(this.fcontext, rcontext);
                this.setValue(doc, values.objectVal(localId));
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "exception at docid " + docid + " for valuesource " + String.valueOf(this.valueSource), (Throwable)e);
            }
        }
    }

    @Override
    public boolean needsSolrIndexSearcher() {
        return true;
    }

    protected void setValue(SolrDocument doc, Object val) {
        if (val != null) {
            doc.setField(this.name, val);
        }
    }

    protected static class ScoreAndDoc
    extends Scorable {
        final int docid;
        final float score;

        ScoreAndDoc(int docid, float score) {
            this.docid = docid;
            this.score = score;
        }

        public int docID() {
            return this.docid;
        }

        public float score() throws IOException {
            return this.score;
        }
    }

    private static abstract class MutableScorable
    extends Scorable {
        int docBase;
        int localDocId;

        private MutableScorable() {
        }

        public int docID() {
            return this.localDocId;
        }
    }
}

