/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UniqueBlockAgg;

public class UniqueBlockFieldAgg
extends UniqueBlockAgg {
    public UniqueBlockFieldAgg(String field) {
        super(field);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) throws IOException {
        String fieldName = this.getArg();
        SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(fieldName);
        if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
            throw new IllegalArgumentException(this.name + "(" + fieldName + ") doesn't allow multivalue fields, got " + String.valueOf(sf));
        }
        if (sf.getType().getNumberType() != null) {
            throw new IllegalArgumentException(this.name + "(" + fieldName + ") not yet support numbers " + String.valueOf(sf));
        }
        return new UniqueBlockAgg.UniqueBlockSlotAcc(fcontext, sf, numSlots);
    }
}

