/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.ExperimentalTerminalApi;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.TerminalDetection;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B9\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nB\u001f\b\u0002\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/ajalt/mordant/terminal/StdoutTerminalInterface;", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "width", "", "height", "hyperlinks", "", "interactive", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "errInfo", "useStdErr", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;Lcom/github/ajalt/mordant/terminal/TerminalInfo;Z)V", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "completePrintRequest", "", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "forStdErr", "readLineOrNull", "", "hideInput", "mordant"})
@ExperimentalTerminalApi
public final class StdoutTerminalInterface
implements TerminalInterface {
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private final TerminalInfo errInfo;
    private final boolean useStdErr;

    private StdoutTerminalInterface(TerminalInfo info, TerminalInfo errInfo, boolean useStdErr) {
        this.info = info;
        this.errInfo = errInfo;
        this.useStdErr = useStdErr;
    }

    @Override
    @NotNull
    public TerminalInfo getInfo() {
        return this.info;
    }

    public StdoutTerminalInterface(@Nullable AnsiLevel ansiLevel, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, @Nullable Boolean interactive) {
        this(TerminalDetection.INSTANCE.detectTerminal(false, ansiLevel, width, height, hyperlinks, interactive), TerminalDetection.INSTANCE.detectTerminal(true, ansiLevel, width, height, hyperlinks, interactive), false);
    }

    @Override
    public void completePrintRequest(@NotNull PrintRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        if (this.useStdErr) {
            MppImplKt.printStderr(request.getText(), request.getTrailingLinebreak());
            return;
        }
        if (request.getTrailingLinebreak()) {
            if (((CharSequence)request.getText()).length() == 0) {
                System.out.println();
            } else {
                System.out.println((Object)request.getText());
            }
        } else {
            System.out.print((Object)request.getText());
        }
    }

    @Override
    @NotNull
    public TerminalInterface forStdErr() {
        return new StdoutTerminalInterface(this.getInfo(), this.errInfo, true);
    }

    @Override
    @Nullable
    public String readLineOrNull(boolean hideInput) {
        return MppImplKt.readLineOrNullMpp(hideInput);
    }
}

