package reflect_test

import (
	. "reflect"
	"testing"
)

func TestTinyConvert(t *testing.T) {

	V := ValueOf

	var tests = []struct {
		have, want Value
	}{
		{V(int8(1)), V(int8(1))},
		{V(int8(2)), V(uint8(2))},
		{V(uint8(3)), V(int8(3))},
		{V(int8(4)), V(int16(4))},
		{V(int16(5)), V(int8(5))},
		{V(int8(6)), V(uint16(6))},
		{V(uint16(7)), V(int8(7))},
		{V(int8(8)), V(int32(8))},
		{V(int32(9)), V(int8(9))},
		{V(int8(10)), V(uint32(10))},
		{V(uint32(11)), V(int8(11))},
		{V(int8(12)), V(int64(12))},
		{V(int64(13)), V(int8(13))},
		{V(int8(14)), V(uint64(14))},
		{V(uint64(15)), V(int8(15))},
		{V(int8(16)), V(int(16))},
		{V(int(17)), V(int8(17))},
		{V(int8(18)), V(uint(18))},
		{V(uint(19)), V(int8(19))},
		{V(int8(20)), V(uintptr(20))},
		{V(uintptr(21)), V(int8(21))},
		{V(int8(22)), V(float32(22))},
		{V(float32(23)), V(int8(23))},
		{V(int8(24)), V(float64(24))},
		{V(float64(25)), V(int8(25))},
		{V(uint8(26)), V(uint8(26))},
		{V(uint8(27)), V(int16(27))},
		{V(int16(28)), V(uint8(28))},
		{V(uint8(29)), V(uint16(29))},
		{V(uint16(30)), V(uint8(30))},
		{V(uint8(31)), V(int32(31))},
		{V(int32(32)), V(uint8(32))},
		{V(uint8(33)), V(uint32(33))},
		{V(uint32(34)), V(uint8(34))},
		{V(uint8(35)), V(int64(35))},
		{V(int64(36)), V(uint8(36))},
		{V(uint8(37)), V(uint64(37))},
		{V(uint64(38)), V(uint8(38))},
		{V(uint8(39)), V(int(39))},
		{V(int(40)), V(uint8(40))},
		{V(uint8(41)), V(uint(41))},
		{V(uint(42)), V(uint8(42))},
		{V(uint8(43)), V(uintptr(43))},
		{V(uintptr(44)), V(uint8(44))},
		{V(uint8(45)), V(float32(45))},
		{V(float32(46)), V(uint8(46))},
		{V(uint8(47)), V(float64(47))},
		{V(float64(48)), V(uint8(48))},
		{V(int16(49)), V(int16(49))},
		{V(int16(50)), V(uint16(50))},
		{V(uint16(51)), V(int16(51))},
		{V(int16(52)), V(int32(52))},
		{V(int32(53)), V(int16(53))},
		{V(int16(54)), V(uint32(54))},
		{V(uint32(55)), V(int16(55))},
		{V(int16(56)), V(int64(56))},
		{V(int64(57)), V(int16(57))},
		{V(int16(58)), V(uint64(58))},
		{V(uint64(59)), V(int16(59))},
		{V(int16(60)), V(int(60))},
		{V(int(61)), V(int16(61))},
		{V(int16(62)), V(uint(62))},
		{V(uint(63)), V(int16(63))},
		{V(int16(64)), V(uintptr(64))},
		{V(uintptr(65)), V(int16(65))},
		{V(int16(66)), V(float32(66))},
		{V(float32(67)), V(int16(67))},
		{V(int16(68)), V(float64(68))},
		{V(float64(69)), V(int16(69))},
		{V(uint16(70)), V(uint16(70))},
		{V(uint16(71)), V(int32(71))},
		{V(int32(72)), V(uint16(72))},
		{V(uint16(73)), V(uint32(73))},
		{V(uint32(74)), V(uint16(74))},
		{V(uint16(75)), V(int64(75))},
		{V(int64(76)), V(uint16(76))},
		{V(uint16(77)), V(uint64(77))},
		{V(uint64(78)), V(uint16(78))},
		{V(uint16(79)), V(int(79))},
		{V(int(80)), V(uint16(80))},
		{V(uint16(81)), V(uint(81))},
		{V(uint(82)), V(uint16(82))},
		{V(uint16(83)), V(uintptr(83))},
		{V(uintptr(84)), V(uint16(84))},
		{V(uint16(85)), V(float32(85))},
		{V(float32(86)), V(uint16(86))},
		{V(uint16(87)), V(float64(87))},
		{V(float64(88)), V(uint16(88))},
		{V(int32(89)), V(int32(89))},
		{V(int32(90)), V(uint32(90))},
		{V(uint32(91)), V(int32(91))},
		{V(int32(92)), V(int64(92))},
		{V(int64(93)), V(int32(93))},
		{V(int32(94)), V(uint64(94))},
		{V(uint64(95)), V(int32(95))},
		{V(int32(96)), V(int(96))},
		{V(int(97)), V(int32(97))},
		{V(int32(98)), V(uint(98))},
		{V(uint(99)), V(int32(99))},
		{V(int32(100)), V(uintptr(100))},
		{V(uintptr(101)), V(int32(101))},
		{V(int32(102)), V(float32(102))},
		{V(float32(103)), V(int32(103))},
		{V(int32(104)), V(float64(104))},
		{V(float64(105)), V(int32(105))},
		{V(uint32(106)), V(uint32(106))},
		{V(uint32(107)), V(int64(107))},
		{V(int64(108)), V(uint32(108))},
		{V(uint32(109)), V(uint64(109))},
		{V(uint64(110)), V(uint32(110))},
		{V(uint32(111)), V(int(111))},
		{V(int(112)), V(uint32(112))},
		{V(uint32(113)), V(uint(113))},
		{V(uint(114)), V(uint32(114))},
		{V(uint32(115)), V(uintptr(115))},
		{V(uintptr(116)), V(uint32(116))},
		{V(uint32(117)), V(float32(117))},
		{V(float32(118)), V(uint32(118))},
		{V(uint32(119)), V(float64(119))},
		{V(float64(120)), V(uint32(120))},
		{V(int64(121)), V(int64(121))},
		{V(int64(122)), V(uint64(122))},
		{V(uint64(123)), V(int64(123))},
		{V(int64(124)), V(int(124))},
		{V(int(125)), V(int64(125))},
		{V(int64(126)), V(uint(126))},
		{V(uint(127)), V(int64(127))},
		{V(int64(128)), V(uintptr(128))},
		{V(uintptr(129)), V(int64(129))},
		{V(int64(130)), V(float32(130))},
		{V(float32(131)), V(int64(131))},
		{V(int64(132)), V(float64(132))},
		{V(float64(133)), V(int64(133))},
		{V(uint64(134)), V(uint64(134))},
		{V(uint64(135)), V(int(135))},
		{V(int(136)), V(uint64(136))},
		{V(uint64(137)), V(uint(137))},
		{V(uint(138)), V(uint64(138))},
		{V(uint64(139)), V(uintptr(139))},
		{V(uintptr(140)), V(uint64(140))},
		{V(uint64(141)), V(float32(141))},
		{V(float32(142)), V(uint64(142))},
		{V(uint64(143)), V(float64(143))},
		{V(float64(144)), V(uint64(144))},
		{V(int(145)), V(int(145))},
		{V(int(146)), V(uint(146))},
		{V(uint(147)), V(int(147))},
		{V(int(148)), V(uintptr(148))},
		{V(uintptr(149)), V(int(149))},
		{V(int(150)), V(float32(150))},
		{V(float32(151)), V(int(151))},
		{V(int(152)), V(float64(152))},
		{V(float64(153)), V(int(153))},
		{V(uint(154)), V(uint(154))},
		{V(uint(155)), V(uintptr(155))},
		{V(uintptr(156)), V(uint(156))},
		{V(uint(157)), V(float32(157))},
		{V(float32(158)), V(uint(158))},
		{V(uint(159)), V(float64(159))},
		{V(float64(160)), V(uint(160))},
		{V(uintptr(161)), V(uintptr(161))},
		{V(uintptr(162)), V(float32(162))},
		{V(float32(163)), V(uintptr(163))},
		{V(uintptr(164)), V(float64(164))},
		{V(float64(165)), V(uintptr(165))},
		{V(float32(166)), V(float32(166))},
		{V(float32(167)), V(float64(167))},
		{V(float64(168)), V(float32(168))},
		{V(float64(169)), V(float64(169))},
	}

	for _, tt := range tests {
		got := tt.have.Convert(tt.want.Type())
		if !DeepEqual(got.Interface(), tt.want.Interface()) {
			t.Errorf("Failed to Convert() %T(%v) -> %T(%v),  got %T(%v)", tt.have.Interface(), tt.have, tt.want.Interface(), tt.want, got.Interface(), got)
		}
	}
}
