/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.openide.util.Lookup;

public class JavaScriptLanguage
extends TruffleLanguage<JavaScriptObject, JavaScriptType, JavaScriptHeapFragment> {
    private static final String ID = "javascript";
    private static final String JS_LANGINFO_ID = "JS";
    private static final String JAVASCRIPT_LANGINFO_ID = "JavaScript";
    private static JavaScriptLanguage INSTANCE;

    static synchronized JavaScriptLanguage instance() {
        if (INSTANCE == null) {
            Lookup.getDefault().lookup(JavaScriptLanguage.class);
        }
        return INSTANCE;
    }

    public JavaScriptLanguage() {
        INSTANCE = this;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected JavaScriptHeapFragment createFragment(Heap heap) {
        Instance langID = JavaScriptLanguage.getLanguageInfo(heap, JS_LANGINFO_ID);
        if (langID == null) {
            langID = JavaScriptLanguage.getLanguageInfo(heap, JAVASCRIPT_LANGINFO_ID);
        }
        if (langID == null) {
            return null;
        }
        JavaClass JSMainClass = heap.getJavaClassByName("com.oracle.truffle.js.runtime.builtins.JSClass");
        if (JSMainClass == null) {
            return null;
        }
        return new JavaScriptHeapFragment(this, langID, heap);
    }

    @Override
    public Class<JavaScriptObject> getLanguageObjectClass() {
        return JavaScriptObject.class;
    }

    @Override
    public boolean isLanguageObject(Instance instance) {
        return JavaScriptObject.isJavaScriptObject(instance);
    }

    @Override
    public JavaScriptObject createObject(Instance instance) {
        return new JavaScriptObject(instance);
    }

    @Override
    public JavaScriptType createType(String name) {
        return new JavaScriptType(name);
    }

    public JavaScriptNodes.JavaScriptObjectNode createObjectNode(JavaScriptObject object, String type) {
        return new JavaScriptNodes.JavaScriptObjectNode(object, type);
    }

    public JavaScriptNodes.JavaScriptLocalObjectNode createLocalObjectNode(JavaScriptObject object, String type) {
        return new JavaScriptNodes.JavaScriptLocalObjectNode(object, type);
    }

    public JavaScriptNodes.JavaScriptTypeNode createTypeNode(JavaScriptType type, Heap heap) {
        return new JavaScriptNodes.JavaScriptTypeNode(type);
    }
}

