/* src/bazaar.p/bz-hook-dialog.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-hook-dialog-option.h"

G_BEGIN_DECLS



#define BZ_TYPE_HOOK_DIALOG (bz_hook_dialog_get_type ())
G_DECLARE_FINAL_TYPE (BzHookDialog, bz_hook_dialog, BZ, HOOK_DIALOG, GObject)

BzHookDialog *
bz_hook_dialog_new (void);

const char *
bz_hook_dialog_get_id (BzHookDialog *self);

const char *
bz_hook_dialog_get_title (BzHookDialog *self);

const char *
bz_hook_dialog_get_body (BzHookDialog *self);

gboolean
bz_hook_dialog_get_body_use_markup (BzHookDialog *self);

GListModel *
bz_hook_dialog_get_options (BzHookDialog *self);

const char *
bz_hook_dialog_get_default_response_id (BzHookDialog *self);

void
bz_hook_dialog_set_id (BzHookDialog *self,
    const char *id);

void
bz_hook_dialog_set_title (BzHookDialog *self,
    const char *title);

void
bz_hook_dialog_set_body (BzHookDialog *self,
    const char *body);

void
bz_hook_dialog_set_body_use_markup (BzHookDialog *self,
    gboolean body_use_markup);

void
bz_hook_dialog_set_options (BzHookDialog *self,
    GListModel *options);

void
bz_hook_dialog_set_default_response_id (BzHookDialog *self,
    const char *default_response_id);

G_END_DECLS

/* End of src/bazaar.p/bz-hook-dialog.h */
