/* SvgStyle.c generated by valac 0.56.17, the Vala compiler
 * generated from SvgStyle.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <xmlbird.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BirdFontParamSpecSvgStyle BirdFontParamSpecSvgStyle;

struct _BirdFontSvgStylePrivate {
	GeeHashMap* style;
};

struct _BirdFontParamSpecSvgStyle {
	GParamSpec parent_instance;
};

static gint BirdFontSvgStyle_private_offset;
static gpointer bird_font_svg_style_parent_class = NULL;

static void bird_font_svg_style_parse_key_value_pairs (BirdFontSvgStyle* self,
                                                const gchar* svg_style);
static void bird_font_svg_style_finalize (BirdFontSvgStyle * obj);
static GType bird_font_svg_style_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_svg_style_get_instance_private (BirdFontSvgStyle* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSvgStyle_private_offset);
}

BirdFontSvgStyle*
bird_font_svg_style_construct (GType object_type)
{
	BirdFontSvgStyle* self = NULL;
	GeeHashMap* _tmp0_;
	self = (BirdFontSvgStyle*) g_type_create_instance (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->style);
	self->priv->style = _tmp0_;
	return self;
}

BirdFontSvgStyle*
bird_font_svg_style_new (void)
{
	return bird_font_svg_style_construct (BIRD_FONT_TYPE_SVG_STYLE);
}

BirdFontLineCap
bird_font_svg_style_get_line_cap (BirdFontSvgStyle* self)
{
	gchar* l = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	const gchar* _tmp3_;
	BirdFontLineCap result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->style;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, "stroke-linecap")) {
		result = BIRD_FONT_LINE_CAP_BUTT;
		_g_free0 (l);
		return result;
	}
	_tmp1_ = self->priv->style;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, "stroke-linecap");
	_g_free0 (l);
	l = (gchar*) _tmp2_;
	_tmp3_ = l;
	if (g_strcmp0 (_tmp3_, "round") == 0) {
		result = BIRD_FONT_LINE_CAP_ROUND;
		_g_free0 (l);
		return result;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = l;
		if (g_strcmp0 (_tmp4_, "square") == 0) {
			result = BIRD_FONT_LINE_CAP_SQUARE;
			_g_free0 (l);
			return result;
		}
	}
	result = BIRD_FONT_LINE_CAP_BUTT;
	_g_free0 (l);
	return result;
}

gboolean
bird_font_svg_style_has_stroke (BirdFontSvgStyle* self)
{
	gboolean s = FALSE;
	GeeHashMap* _tmp0_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	s = TRUE;
	_tmp0_ = self->priv->style;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, "stroke")) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->style;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, "stroke");
		_tmp3_ = (gchar*) _tmp2_;
		s = g_strcmp0 (_tmp3_, "none") != 0;
		_g_free0 (_tmp3_);
	}
	if (bird_font_svg_style_get_stroke_width (self) > ((gdouble) 0)) {
		_tmp4_ = s;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gdouble
bird_font_svg_style_get_stroke_width (BirdFontSvgStyle* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gdouble _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->style;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, "stroke-width")) {
		result = (gdouble) 0;
		return result;
	}
	_tmp1_ = self->priv->style;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, "stroke-width");
	_tmp3_ = (gchar*) _tmp2_;
	_tmp4_ = double_parse (_tmp3_);
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

BirdFontSvgStyle*
bird_font_svg_style_parse (BAttributes* attributes)
{
	BirdFontSvgStyle* s = NULL;
	BirdFontSvgStyle* _tmp0_;
	BirdFontSvgStyle* result;
	g_return_val_if_fail (attributes != NULL, NULL);
	_tmp0_ = bird_font_svg_style_new ();
	s = _tmp0_;
	{
		BAttributesIterator* _a_it = NULL;
		BAttributesIterator* _tmp1_;
		_tmp1_ = b_attributes_iterator (attributes);
		_a_it = _tmp1_;
		while (TRUE) {
			BAttributesIterator* _tmp2_;
			BAttribute* a = NULL;
			BAttributesIterator* _tmp3_;
			BAttribute* _tmp4_;
			BAttribute* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			BAttribute* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gboolean _tmp16_;
			BAttribute* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gboolean _tmp25_;
			BAttribute* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			_tmp2_ = _a_it;
			if (!b_attributes_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _a_it;
			_tmp4_ = b_attributes_iterator_get (_tmp3_);
			a = _tmp4_;
			_tmp5_ = a;
			_tmp6_ = b_attribute_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "style") == 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				BirdFontSvgStyle* _tmp9_;
				BAttribute* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = s;
				_tmp10_ = a;
				_tmp11_ = b_attribute_get_content (_tmp10_);
				_tmp12_ = _tmp11_;
				bird_font_svg_style_parse_key_value_pairs (_tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
			}
			_tmp13_ = a;
			_tmp14_ = b_attribute_get_name (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strcmp0 (_tmp15_, "stroke-width") == 0;
			_g_free0 (_tmp15_);
			if (_tmp16_) {
				BirdFontSvgStyle* _tmp17_;
				GeeHashMap* _tmp18_;
				BAttribute* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp17_ = s;
				_tmp18_ = _tmp17_->priv->style;
				_tmp19_ = a;
				_tmp20_ = b_attribute_get_content (_tmp19_);
				_tmp21_ = _tmp20_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, "stroke-width", _tmp21_);
				_g_free0 (_tmp21_);
			}
			_tmp22_ = a;
			_tmp23_ = b_attribute_get_name (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strcmp0 (_tmp24_, "stroke") == 0;
			_g_free0 (_tmp24_);
			if (_tmp25_) {
				BirdFontSvgStyle* _tmp26_;
				GeeHashMap* _tmp27_;
				BAttribute* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp26_ = s;
				_tmp27_ = _tmp26_->priv->style;
				_tmp28_ = a;
				_tmp29_ = b_attribute_get_content (_tmp28_);
				_tmp30_ = _tmp29_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "stroke", _tmp30_);
				_g_free0 (_tmp30_);
			}
			_tmp31_ = a;
			_tmp32_ = b_attribute_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp33_, "fill") == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				BirdFontSvgStyle* _tmp35_;
				GeeHashMap* _tmp36_;
				BAttribute* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp35_ = s;
				_tmp36_ = _tmp35_->priv->style;
				_tmp37_ = a;
				_tmp38_ = b_attribute_get_content (_tmp37_);
				_tmp39_ = _tmp38_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, "fill", _tmp39_);
				_g_free0 (_tmp39_);
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	result = s;
	return result;
}

static void
bird_font_svg_style_parse_key_value_pairs (BirdFontSvgStyle* self,
                                           const gchar* svg_style)
{
	gchar** p = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint p_length1;
	gint _p_size_;
	gchar** pair = NULL;
	gint pair_length1 = 0;
	gint _pair_size_ = 0;
	gchar* k = NULL;
	gchar* v = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (svg_style != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (svg_style, ";", 0);
	p = _tmp1_;
	p_length1 = _vala_array_length (_tmp0_);
	_p_size_ = p_length1;
	_tmp2_ = p;
	_tmp2__length1 = p_length1;
	{
		gchar** kv_collection = NULL;
		gint kv_collection_length1 = 0;
		gint _kv_collection_size_ = 0;
		gint kv_it = 0;
		kv_collection = _tmp2_;
		kv_collection_length1 = _tmp2__length1;
		for (kv_it = 0; kv_it < kv_collection_length1; kv_it = kv_it + 1) {
			gchar* _tmp3_;
			gchar* kv = NULL;
			_tmp3_ = g_strdup (kv_collection[kv_it]);
			kv = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				GeeHashMap* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp4_ = kv;
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
				pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
				pair = _tmp6_;
				pair_length1 = _vala_array_length (_tmp5_);
				_pair_size_ = pair_length1;
				_tmp7_ = pair;
				_tmp7__length1 = pair_length1;
				if (_tmp7__length1 != 2) {
					g_warning ("SvgStyle.vala:98: pair.length != 2");
					_g_free0 (kv);
					continue;
				}
				_tmp8_ = pair;
				_tmp8__length1 = pair_length1;
				_tmp9_ = _tmp8_[0];
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (k);
				k = _tmp10_;
				_tmp11_ = pair;
				_tmp11__length1 = pair_length1;
				_tmp12_ = _tmp11_[1];
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (v);
				v = _tmp13_;
				_tmp14_ = self->priv->style;
				_tmp15_ = k;
				_tmp16_ = v;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, _tmp16_);
				_g_free0 (kv);
			}
		}
	}
	_g_free0 (v);
	_g_free0 (k);
	pair = (_vala_array_free (pair, pair_length1, (GDestroyNotify) g_free), NULL);
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
}

void
bird_font_svg_style_apply (BirdFontSvgStyle* self,
                           BirdFontPathList* path_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_list != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = path_list->paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp12_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			if (bird_font_svg_style_has_stroke (self)) {
				BirdFontPath* _tmp8_;
				_tmp8_ = p;
				bird_font_path_set_stroke (_tmp8_, bird_font_svg_style_get_stroke_width (self));
			} else {
				BirdFontPath* _tmp9_;
				_tmp9_ = p;
				bird_font_path_set_stroke (_tmp9_, (gdouble) 0);
			}
			_tmp10_ = p;
			_tmp10_->line_cap = bird_font_svg_style_get_line_cap (self);
			_tmp11_ = p;
			bird_font_path_reset_stroke (_tmp11_);
			_tmp12_ = p;
			bird_font_path_update_region_boundaries (_tmp12_);
			_g_object_unref0 (p);
		}
	}
}

static void
bird_font_value_svg_style_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_svg_style_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_svg_style_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_svg_style_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_svg_style_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_svg_style_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_svg_style_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontSvgStyle * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_svg_style_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_svg_style_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	BirdFontSvgStyle ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_svg_style_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_svg_style (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	BirdFontParamSpecSvgStyle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_SVG_STYLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_svg_style (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG_STYLE), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_svg_style (GValue* value,
                               gpointer v_object)
{
	BirdFontSvgStyle * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG_STYLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SVG_STYLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_svg_style_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_svg_style_unref (old);
	}
}

void
bird_font_value_take_svg_style (GValue* value,
                                gpointer v_object)
{
	BirdFontSvgStyle * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG_STYLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SVG_STYLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_svg_style_unref (old);
	}
}

static void
bird_font_svg_style_class_init (BirdFontSvgStyleClass * klass,
                                gpointer klass_data)
{
	bird_font_svg_style_parent_class = g_type_class_peek_parent (klass);
	((BirdFontSvgStyleClass *) klass)->finalize = bird_font_svg_style_finalize;
	g_type_class_adjust_private_offset (klass, &BirdFontSvgStyle_private_offset);
}

static void
bird_font_svg_style_instance_init (BirdFontSvgStyle * self,
                                   gpointer klass)
{
	self->priv = bird_font_svg_style_get_instance_private (self);
	self->ref_count = 1;
}

static void
bird_font_svg_style_finalize (BirdFontSvgStyle * obj)
{
	BirdFontSvgStyle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SVG_STYLE, BirdFontSvgStyle);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->style);
}

static GType
bird_font_svg_style_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_svg_style_init, bird_font_value_svg_style_free_value, bird_font_value_svg_style_copy_value, bird_font_value_svg_style_peek_pointer, "p", bird_font_value_svg_style_collect_value, "p", bird_font_value_svg_style_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSvgStyleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_svg_style_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSvgStyle), 0, (GInstanceInitFunc) bird_font_svg_style_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_svg_style_type_id;
	bird_font_svg_style_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontSvgStyle", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BirdFontSvgStyle_private_offset = g_type_add_instance_private (bird_font_svg_style_type_id, sizeof (BirdFontSvgStylePrivate));
	return bird_font_svg_style_type_id;
}

GType
bird_font_svg_style_get_type (void)
{
	static volatile gsize bird_font_svg_style_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_style_type_id__once)) {
		GType bird_font_svg_style_type_id;
		bird_font_svg_style_type_id = bird_font_svg_style_get_type_once ();
		g_once_init_leave (&bird_font_svg_style_type_id__once, bird_font_svg_style_type_id);
	}
	return bird_font_svg_style_type_id__once;
}

gpointer
bird_font_svg_style_ref (gpointer instance)
{
	BirdFontSvgStyle * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_svg_style_unref (gpointer instance)
{
	BirdFontSvgStyle * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_SVG_STYLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

