/* headerbar.c generated by valac 0.56.18, the Vala compiler
 * generated from headerbar.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and creates the headerbar widget
* and all the widgets associated with the headerbar
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_SUBTITLE_HEADERBAR _ ("eBook Reader")
#define BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS 12
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIBRARY_BUTTON _ ("Library")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_BOOK_INFO _ ("See Table of Contents, Bookmarks and Search Results")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_READING_PREFERENCES _ ("Reading preferences")
#define BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "/com/github/babluboy/bookworm/"
#define BOOKWORM_APP_CONSTANTS_BOOKMARK_INACTIVE_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "24-bookworm-bookmark-inactive.png"
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_BOOKMARKS_ACTIVATE _ ("Click to bookmark this page")
#define BOOKWORM_APP_CONSTANTS_BOOKMARK_ACTIVE_IMAGE_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "24-bookworm-bookmark-active.png"
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_BOOKMARKS_DEACTIVATE _ ("Click to remove this bookmark")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREF_MENU_PREFERENCES_ITEM _ ("Preferences")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREF_MENU_ABOUT_ITEM _ ("About")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH _ ("Search by Title, Author and Tags")
#define BOOKWORM_APP_CONSTANTS_program_name "Bookworm"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ABOUT_DIALOG_WEBSITE_URL "https://babluboy.github.io/bookworm"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ABOUT_DIALOG_WEBSITE _ ("Website | Translation | Bug Tracker")
#define BOOKWORM_APP_CONSTANTS_app_icon "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_bookworm_copyright "Copyright © 2017-2018 Siddhartha Das (bablu.boy@gmail.com)"
#define BOOKWORM_APP_CONSTANTS_bookworm_version "1.1.2"
#define BOOKWORM_APP_CONSTANTS_about_comments _ ("An eBook Reader")
#define BOOKWORM_APP_CONSTANTS_about_license_type GTK_LICENSE_GPL_3_0
#define BOOKWORM_APP_CONSTANTS_translator_credits _ ("Weblate Translators")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_APP_HEADER_BAR (bookworm_app_app_header_bar_get_type ())
#define BOOKWORM_APP_APP_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_APP_HEADER_BAR, BookwormAppAppHeaderBar))
#define BOOKWORM_APP_APP_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_APP_HEADER_BAR, BookwormAppAppHeaderBarClass))
#define BOOKWORM_APP_IS_APP_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_APP_HEADER_BAR))
#define BOOKWORM_APP_IS_APP_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_APP_HEADER_BAR))
#define BOOKWORM_APP_APP_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_APP_HEADER_BAR, BookwormAppAppHeaderBarClass))

typedef struct _BookwormAppAppHeaderBar BookwormAppAppHeaderBar;
typedef struct _BookwormAppAppHeaderBarClass BookwormAppAppHeaderBarClass;
typedef struct _BookwormAppAppHeaderBarPrivate BookwormAppAppHeaderBarPrivate;

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
typedef struct _Block14Data Block14Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_BOOKWORM (bookworm_app_bookworm_get_type ())
#define BOOKWORM_APP_BOOKWORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookworm))
#define BOOKWORM_APP_BOOKWORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookwormClass))
#define BOOKWORM_APP_IS_BOOKWORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOKWORM))
#define BOOKWORM_APP_IS_BOOKWORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOKWORM))
#define BOOKWORM_APP_BOOKWORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOKWORM, BookwormAppBookwormClass))

typedef struct _BookwormAppBookworm BookwormAppBookworm;
typedef struct _BookwormAppBookwormClass BookwormAppBookwormClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
typedef struct _BookwormAppParamSpecAppHeaderBar BookwormAppParamSpecAppHeaderBar;

struct _BookwormAppAppHeaderBar {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppAppHeaderBarPrivate * priv;
};

struct _BookwormAppAppHeaderBarClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppAppHeaderBar *self);
};

struct _Block14Data {
	int _ref_count_;
	GtkPopover* prefPopover;
};

struct _Block15Data {
	int _ref_count_;
	GtkAboutDialog* aboutDialog;
};

struct _BookwormAppParamSpecAppHeaderBar {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_app_header_bar_parent_class = NULL;
VALA_EXTERN GtkHeaderBar* bookworm_app_app_header_bar_headerbar;
GtkHeaderBar* bookworm_app_app_header_bar_headerbar = NULL;
static GtkWindow* bookworm_app_app_header_bar_window;
static GtkWindow* bookworm_app_app_header_bar_window = NULL;
VALA_EXTERN GtkSearchEntry* bookworm_app_app_header_bar_headerSearchBar;
GtkSearchEntry* bookworm_app_app_header_bar_headerSearchBar = NULL;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_inactive_button;
GtkButton* bookworm_app_app_header_bar_bookmark_inactive_button = NULL;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_active_button;
GtkButton* bookworm_app_app_header_bar_bookmark_active_button = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_app_header_bar_settings;
BookwormAppSettings* bookworm_app_app_header_bar_settings = NULL;
VALA_EXTERN GraniteWidgetsModeButton* bookworm_app_bookworm_library_mode_button;
VALA_EXTERN GtkImage* bookworm_app_bookworm_library_grid_button_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_library_list_button_image;
VALA_EXTERN GtkButton* bookworm_app_bookworm_library_view_button;
VALA_EXTERN GtkButton* bookworm_app_bookworm_content_list_button;
VALA_EXTERN GtkImage* bookworm_app_bookworm_content_list_button_image;
VALA_EXTERN GtkButton* bookworm_app_bookworm_prefButton;
VALA_EXTERN GtkImage* bookworm_app_bookworm_menu_icon_text_large;
VALA_EXTERN GtkImage* bookworm_app_bookworm_menu_icon;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
VALA_EXTERN GtkStack* bookworm_app_info_stack;
VALA_EXTERN GtkLabel* bookworm_app_app_window_infobarLabel;
VALA_EXTERN GtkInfoBar* bookworm_app_app_window_infobar;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
VALA_EXTERN gboolean bookworm_app_bookworm_isPageScrollRequired;
VALA_EXTERN GtkLinkButton* bookworm_app_info_firstSearchResultLinkButton;
VALA_EXTERN GtkApplicationWindow* bookworm_app_bookworm_window;

VALA_EXTERN gpointer bookworm_app_app_header_bar_ref (gpointer instance);
VALA_EXTERN void bookworm_app_app_header_bar_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_app_header_bar (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_app_header_bar (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_app_header_bar (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_app_header_bar (const GValue* value);
VALA_EXTERN GType bookworm_app_app_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppAppHeaderBar, bookworm_app_app_header_bar_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN GtkHeaderBar* bookworm_app_app_header_bar_create_headerbar (void);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN GType bookworm_app_bookworm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBookworm, g_object_unref)
VALA_EXTERN BookwormAppBookworm* bookworm_app_bookworm_getAppInstance (void);
VALA_EXTERN const gchar* bookworm_app_settings_get_library_view_mode (BookwormAppSettings* self);
VALA_EXTERN GtkPopover* bookworm_app_preferences_menu_createPrefPopOver (GtkButton* popWidget);
VALA_EXTERN void bookworm_app_app_dialog_createPreferencesDialog (void);
static void _bookworm_app_app_dialog_createPreferencesDialog_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                              gpointer self);
VALA_EXTERN void bookworm_app_app_header_bar_ShowAboutDialog (void);
static void _bookworm_app_app_header_bar_ShowAboutDialog_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                          gpointer self);
static void __lambda77_ (void);
VALA_EXTERN void bookworm_app_library_paginateLibrary (const gchar* library_search_data,
                                           const gchar* mode);
static void ___lambda77__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                   gpointer self);
static void __lambda78_ (void);
VALA_EXTERN void bookworm_app_info_populateSearchResults (GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_info_populateSearchResults_finish (GAsyncResult* _res_);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
static void ___lambda78__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda79_ (void);
VALA_EXTERN void bookworm_app_book_setBookScrollPos (BookwormAppBook* self,
                                         gint aBookScrollPos);
VALA_EXTERN gint bookworm_app_content_handler_getScrollPos (void);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
static void ___lambda79__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda80_ (void);
VALA_EXTERN BookwormAppBook* bookworm_app_info_createTableOfContents (void);
VALA_EXTERN const gchar* bookworm_app_settings_get_current_info_tab (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_info_populateBookmarks (void);
VALA_EXTERN void bookworm_app_info_populateAnnotations (void);
static void ___lambda80__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda81_ (Block14Data* _data14_);
static void ___lambda81__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda82_ (void);
VALA_EXTERN void bookworm_app_content_handler_handleBookMark (const gchar* action);
static void ___lambda82__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda83_ (void);
static void ___lambda83__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda84_ (GtkWidget* widget);
VALA_EXTERN void bookworm_app_app_window_controlDeletionButton (gboolean selectionState);
VALA_EXTERN void bookworm_app_settings_set_library_view_mode (BookwormAppSettings* self,
                                                  const gchar* value);
static void ___lambda84__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                            GtkWidget* widget,
                                                            gpointer self);
VALA_EXTERN GtkHeaderBar* bookworm_app_app_header_bar_get_headerbar (void);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void __lambda76_ (Block15Data* _data15_,
                  gint response_id);
static void ___lambda76__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN BookwormAppAppHeaderBar* bookworm_app_app_header_bar_new (void);
VALA_EXTERN BookwormAppAppHeaderBar* bookworm_app_app_header_bar_construct (GType object_type);
static void bookworm_app_app_header_bar_finalize (BookwormAppAppHeaderBar * obj);
static GType bookworm_app_app_header_bar_get_type_once (void);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];
VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_about_authors[2];
VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_about_artists[2];

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
#line 28 "../src/headerbar.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 28 "../src/headerbar.vala"
	return _data14_;
#line 292 "headerbar.c"
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 28 "../src/headerbar.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 28 "../src/headerbar.vala"
		_g_object_unref0 (_data14_->prefPopover);
#line 28 "../src/headerbar.vala"
		g_slice_free (Block14Data, _data14_);
#line 306 "headerbar.c"
	}
}

static void
_bookworm_app_app_dialog_createPreferencesDialog_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                         gpointer self)
{
#line 98 "../src/headerbar.vala"
	bookworm_app_app_dialog_createPreferencesDialog ();
#line 316 "headerbar.c"
}

static void
_bookworm_app_app_header_bar_ShowAboutDialog_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                     gpointer self)
{
#line 102 "../src/headerbar.vala"
	bookworm_app_app_header_bar_ShowAboutDialog ();
#line 325 "headerbar.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 346 "headerbar.c"
}

static void
__lambda77_ (void)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 116 "../src/headerbar.vala"
	_tmp1_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 116 "../src/headerbar.vala"
	_tmp2_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 116 "../src/headerbar.vala"
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
#line 116 "../src/headerbar.vala"
		_tmp0_ = TRUE;
#line 363 "headerbar.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 117 "../src/headerbar.vala"
		_tmp3_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 117 "../src/headerbar.vala"
		_tmp4_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 117 "../src/headerbar.vala"
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
#line 373 "headerbar.c"
	}
#line 116 "../src/headerbar.vala"
	if (!_tmp0_) {
#line 377 "headerbar.c"
		gboolean _tmp5_ = FALSE;
		GtkSearchEntry* _tmp6_;
		const gchar* _tmp7_;
#line 121 "../src/headerbar.vala"
		_tmp6_ = bookworm_app_app_header_bar_headerSearchBar;
#line 121 "../src/headerbar.vala"
		_tmp7_ = gtk_entry_get_text ((GtkEntry*) _tmp6_);
#line 121 "../src/headerbar.vala"
		if (g_strcmp0 (_tmp7_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH) != 0) {
#line 387 "headerbar.c"
			GtkSearchEntry* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
#line 122 "../src/headerbar.vala"
			_tmp8_ = bookworm_app_app_header_bar_headerSearchBar;
#line 122 "../src/headerbar.vala"
			_tmp9_ = gtk_entry_get_text ((GtkEntry*) _tmp8_);
#line 122 "../src/headerbar.vala"
			_tmp10_ = string_strip (_tmp9_);
#line 122 "../src/headerbar.vala"
			_tmp11_ = _tmp10_;
#line 122 "../src/headerbar.vala"
			_tmp5_ = g_strcmp0 (_tmp11_, "") != 0;
#line 122 "../src/headerbar.vala"
			_g_free0 (_tmp11_);
#line 404 "headerbar.c"
		} else {
#line 121 "../src/headerbar.vala"
			_tmp5_ = FALSE;
#line 408 "headerbar.c"
		}
#line 121 "../src/headerbar.vala"
		if (_tmp5_) {
#line 412 "headerbar.c"
		} else {
#line 131 "../src/headerbar.vala"
			bookworm_app_library_paginateLibrary ("", "PAGINATED_SEARCH");
#line 416 "headerbar.c"
		}
	}
}

static void
___lambda77__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                              gpointer self)
{
#line 114 "../src/headerbar.vala"
	__lambda77_ ();
#line 427 "headerbar.c"
}

static void
__lambda78_ (void)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
#line 138 "../src/headerbar.vala"
	_tmp1_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 138 "../src/headerbar.vala"
	_tmp2_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 138 "../src/headerbar.vala"
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
#line 138 "../src/headerbar.vala"
		_tmp0_ = TRUE;
#line 447 "headerbar.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 139 "../src/headerbar.vala"
		_tmp3_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 139 "../src/headerbar.vala"
		_tmp4_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 139 "../src/headerbar.vala"
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
#line 457 "headerbar.c"
	}
#line 138 "../src/headerbar.vala"
	if (!_tmp0_) {
#line 461 "headerbar.c"
		gboolean _tmp5_ = FALSE;
		GtkSearchEntry* _tmp6_;
		const gchar* _tmp7_;
#line 141 "../src/headerbar.vala"
		_tmp6_ = bookworm_app_app_header_bar_headerSearchBar;
#line 141 "../src/headerbar.vala"
		_tmp7_ = gtk_entry_get_text ((GtkEntry*) _tmp6_);
#line 141 "../src/headerbar.vala"
		if (g_strcmp0 (_tmp7_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH) != 0) {
#line 471 "headerbar.c"
			GtkSearchEntry* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
#line 142 "../src/headerbar.vala"
			_tmp8_ = bookworm_app_app_header_bar_headerSearchBar;
#line 142 "../src/headerbar.vala"
			_tmp9_ = gtk_entry_get_text ((GtkEntry*) _tmp8_);
#line 142 "../src/headerbar.vala"
			_tmp10_ = string_strip (_tmp9_);
#line 142 "../src/headerbar.vala"
			_tmp11_ = _tmp10_;
#line 142 "../src/headerbar.vala"
			_tmp5_ = g_strcmp0 (_tmp11_, "") != 0;
#line 142 "../src/headerbar.vala"
			_g_free0 (_tmp11_);
#line 488 "headerbar.c"
		} else {
#line 141 "../src/headerbar.vala"
			_tmp5_ = FALSE;
#line 492 "headerbar.c"
		}
#line 141 "../src/headerbar.vala"
		if (_tmp5_) {
#line 496 "headerbar.c"
			GtkSearchEntry* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 144 "../src/headerbar.vala"
			_tmp12_ = bookworm_app_app_header_bar_headerSearchBar;
#line 144 "../src/headerbar.vala"
			_tmp13_ = gtk_entry_get_text ((GtkEntry*) _tmp12_);
#line 144 "../src/headerbar.vala"
			_tmp14_ = string_strip (_tmp13_);
#line 144 "../src/headerbar.vala"
			_tmp15_ = _tmp14_;
#line 144 "../src/headerbar.vala"
			bookworm_app_library_paginateLibrary (_tmp15_, "LIBRARY_SEARCH");
#line 144 "../src/headerbar.vala"
			_g_free0 (_tmp15_);
#line 513 "headerbar.c"
		} else {
#line 147 "../src/headerbar.vala"
			bookworm_app_library_paginateLibrary ("", "PAGINATED_SEARCH");
#line 517 "headerbar.c"
		}
	}
#line 151 "../src/headerbar.vala"
	_tmp17_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 151 "../src/headerbar.vala"
	_tmp18_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 151 "../src/headerbar.vala"
	if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
#line 151 "../src/headerbar.vala"
		_tmp16_ = TRUE;
#line 528 "headerbar.c"
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
#line 152 "../src/headerbar.vala"
		_tmp19_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 152 "../src/headerbar.vala"
		_tmp20_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 152 "../src/headerbar.vala"
		_tmp16_ = g_strcmp0 (_tmp19_, _tmp20_) == 0;
#line 538 "headerbar.c"
	}
#line 151 "../src/headerbar.vala"
	if (_tmp16_) {
#line 542 "headerbar.c"
		const gchar* _tmp21_;
		gchar* _tmp22_;
		GtkStack* _tmp23_;
		GtkStack* _tmp24_;
		GtkWidget* _tmp25_;
#line 153 "../src/headerbar.vala"
		bookworm_app_info_populateSearchResults (NULL, NULL);
#line 155 "../src/headerbar.vala"
		_tmp21_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 155 "../src/headerbar.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 155 "../src/headerbar.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 155 "../src/headerbar.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp22_;
#line 156 "../src/headerbar.vala"
		bookworm_app_bookworm_toggleUIState ();
#line 158 "../src/headerbar.vala"
		_tmp23_ = bookworm_app_info_stack;
#line 158 "../src/headerbar.vala"
		_tmp24_ = bookworm_app_info_stack;
#line 158 "../src/headerbar.vala"
		_tmp25_ = gtk_stack_get_child_by_name (_tmp24_, "searchresults-list");
#line 158 "../src/headerbar.vala"
		gtk_stack_set_visible_child (_tmp23_, _tmp25_);
#line 568 "headerbar.c"
	}
}

static void
___lambda78__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
#line 136 "../src/headerbar.vala"
	__lambda78_ ();
#line 578 "headerbar.c"
}

static void
__lambda79_ (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
#line 164 "../src/headerbar.vala"
	_tmp0_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 164 "../src/headerbar.vala"
	_tmp1_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 164 "../src/headerbar.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 594 "headerbar.c"
		GtkLabel* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		GeeHashMap* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_;
		BookwormAppBook* _tmp9_;
		GtkHeaderBar* _tmp10_;
		BookwormAppSettings* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
#line 166 "../src/headerbar.vala"
		_tmp2_ = bookworm_app_app_window_infobarLabel;
#line 166 "../src/headerbar.vala"
		_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
#line 166 "../src/headerbar.vala"
		_tmp4_ = _tmp3_;
#line 166 "../src/headerbar.vala"
		if (_tmp4_ == TRUE) {
#line 615 "headerbar.c"
			GtkInfoBar* _tmp5_;
#line 167 "../src/headerbar.vala"
			_tmp5_ = bookworm_app_app_window_infobar;
#line 167 "../src/headerbar.vala"
			gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 621 "headerbar.c"
		}
#line 170 "../src/headerbar.vala"
		_tmp6_ = bookworm_app_bookworm_libraryViewMap;
#line 170 "../src/headerbar.vala"
		_tmp7_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 170 "../src/headerbar.vala"
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
#line 170 "../src/headerbar.vala"
		_tmp9_ = (BookwormAppBook*) _tmp8_;
#line 170 "../src/headerbar.vala"
		bookworm_app_book_setBookScrollPos (_tmp9_, bookworm_app_content_handler_getScrollPos ());
#line 170 "../src/headerbar.vala"
		_bookworm_app_book_unref0 (_tmp9_);
#line 174 "../src/headerbar.vala"
		_tmp10_ = bookworm_app_app_header_bar_headerbar;
#line 174 "../src/headerbar.vala"
		gtk_header_bar_set_title (_tmp10_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_SUBTITLE_HEADERBAR);
#line 176 "../src/headerbar.vala"
		_tmp11_ = bookworm_app_app_header_bar_settings;
#line 176 "../src/headerbar.vala"
		_tmp12_ = bookworm_app_settings_get_library_view_mode (_tmp11_);
#line 176 "../src/headerbar.vala"
		_tmp13_ = _tmp12_;
#line 176 "../src/headerbar.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 176 "../src/headerbar.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 176 "../src/headerbar.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp14_;
#line 177 "../src/headerbar.vala"
		bookworm_app_bookworm_toggleUIState ();
#line 653 "headerbar.c"
	}
#line 180 "../src/headerbar.vala"
	_tmp15_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 180 "../src/headerbar.vala"
	_tmp16_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 180 "../src/headerbar.vala"
	if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
#line 661 "headerbar.c"
		const gchar* _tmp17_;
		gchar* _tmp18_;
		BookwormAppBook* currentBookForContentList = NULL;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		gpointer _tmp21_;
		GeeHashMap* _tmp22_;
		const gchar* _tmp23_;
		gpointer _tmp24_;
		gchar* _tmp25_;
		BookwormAppBook* _tmp26_;
		GeeHashMap* _tmp27_;
		const gchar* _tmp28_;
		BookwormAppBook* _tmp29_;
#line 182 "../src/headerbar.vala"
		_tmp17_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 182 "../src/headerbar.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 182 "../src/headerbar.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 182 "../src/headerbar.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp18_;
#line 184 "../src/headerbar.vala"
		bookworm_app_bookworm_isPageScrollRequired = TRUE;
#line 185 "../src/headerbar.vala"
		_tmp19_ = bookworm_app_bookworm_libraryViewMap;
#line 185 "../src/headerbar.vala"
		_tmp20_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 185 "../src/headerbar.vala"
		_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
#line 185 "../src/headerbar.vala"
		currentBookForContentList = (BookwormAppBook*) _tmp21_;
#line 187 "../src/headerbar.vala"
		_tmp22_ = bookworm_app_bookworm_libraryViewMap;
#line 187 "../src/headerbar.vala"
		_tmp23_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 187 "../src/headerbar.vala"
		_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
#line 187 "../src/headerbar.vala"
		_tmp25_ = g_strdup ("");
#line 187 "../src/headerbar.vala"
		_tmp26_ = bookworm_app_content_handler_renderPage ((BookwormAppBook*) _tmp24_, _tmp25_);
#line 187 "../src/headerbar.vala"
		_bookworm_app_book_unref0 (currentBookForContentList);
#line 187 "../src/headerbar.vala"
		currentBookForContentList = _tmp26_;
#line 191 "../src/headerbar.vala"
		_tmp27_ = bookworm_app_bookworm_libraryViewMap;
#line 191 "../src/headerbar.vala"
		_tmp28_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 191 "../src/headerbar.vala"
		_tmp29_ = currentBookForContentList;
#line 191 "../src/headerbar.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp29_);
#line 195 "../src/headerbar.vala"
		bookworm_app_bookworm_toggleUIState ();
#line 180 "../src/headerbar.vala"
		_bookworm_app_book_unref0 (currentBookForContentList);
#line 720 "headerbar.c"
	}
}

static void
___lambda79__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 162 "../src/headerbar.vala"
	__lambda79_ ();
#line 730 "headerbar.c"
}

static void
__lambda80_ (void)
{
	BookwormAppBook* _tmp0_;
	BookwormAppBook* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	BookwormAppBook* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	BookwormAppSettings* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkWidget* _tmp13_;
	BookwormAppSettings* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	BookwormAppSettings* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	BookwormAppSettings* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
#line 200 "../src/headerbar.vala"
	_tmp0_ = bookworm_app_info_createTableOfContents ();
#line 200 "../src/headerbar.vala"
	_tmp1_ = _tmp0_;
#line 200 "../src/headerbar.vala"
	_bookworm_app_book_unref0 (_tmp1_);
#line 202 "../src/headerbar.vala"
	_tmp2_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[4];
#line 202 "../src/headerbar.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 202 "../src/headerbar.vala"
	_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 202 "../src/headerbar.vala"
	bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp3_;
#line 204 "../src/headerbar.vala"
	_tmp4_ = bookworm_app_bookworm_libraryViewMap;
#line 204 "../src/headerbar.vala"
	_tmp5_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 204 "../src/headerbar.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 204 "../src/headerbar.vala"
	_tmp7_ = (BookwormAppBook*) _tmp6_;
#line 204 "../src/headerbar.vala"
	bookworm_app_book_setBookScrollPos (_tmp7_, bookworm_app_content_handler_getScrollPos ());
#line 204 "../src/headerbar.vala"
	_bookworm_app_book_unref0 (_tmp7_);
#line 207 "../src/headerbar.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 209 "../src/headerbar.vala"
	_tmp8_ = bookworm_app_info_stack;
#line 209 "../src/headerbar.vala"
	_tmp9_ = bookworm_app_info_stack;
#line 209 "../src/headerbar.vala"
	_tmp10_ = bookworm_app_app_header_bar_settings;
#line 209 "../src/headerbar.vala"
	_tmp11_ = bookworm_app_settings_get_current_info_tab (_tmp10_);
#line 209 "../src/headerbar.vala"
	_tmp12_ = _tmp11_;
#line 209 "../src/headerbar.vala"
	_tmp13_ = gtk_stack_get_child_by_name (_tmp9_, _tmp12_);
#line 209 "../src/headerbar.vala"
	gtk_stack_set_visible_child (_tmp8_, _tmp13_);
#line 213 "../src/headerbar.vala"
	_tmp14_ = bookworm_app_app_header_bar_settings;
#line 213 "../src/headerbar.vala"
	_tmp15_ = bookworm_app_settings_get_current_info_tab (_tmp14_);
#line 213 "../src/headerbar.vala"
	_tmp16_ = _tmp15_;
#line 213 "../src/headerbar.vala"
	if (g_strcmp0 ("bookmark-list", _tmp16_) == 0) {
#line 214 "../src/headerbar.vala"
		bookworm_app_info_populateBookmarks ();
#line 811 "headerbar.c"
	}
#line 216 "../src/headerbar.vala"
	_tmp17_ = bookworm_app_app_header_bar_settings;
#line 216 "../src/headerbar.vala"
	_tmp18_ = bookworm_app_settings_get_current_info_tab (_tmp17_);
#line 216 "../src/headerbar.vala"
	_tmp19_ = _tmp18_;
#line 216 "../src/headerbar.vala"
	if (g_strcmp0 ("annotations-list", _tmp19_) == 0) {
#line 217 "../src/headerbar.vala"
		bookworm_app_info_populateAnnotations ();
#line 823 "headerbar.c"
	}
#line 219 "../src/headerbar.vala"
	_tmp20_ = bookworm_app_app_header_bar_settings;
#line 219 "../src/headerbar.vala"
	_tmp21_ = bookworm_app_settings_get_current_info_tab (_tmp20_);
#line 219 "../src/headerbar.vala"
	_tmp22_ = _tmp21_;
#line 219 "../src/headerbar.vala"
	if (g_strcmp0 ("searchresults-list", _tmp22_) == 0) {
#line 833 "headerbar.c"
		GtkLinkButton* _tmp23_;
#line 220 "../src/headerbar.vala"
		_tmp23_ = bookworm_app_info_firstSearchResultLinkButton;
#line 220 "../src/headerbar.vala"
		if (_tmp23_ != NULL) {
#line 839 "headerbar.c"
			GtkLinkButton* _tmp24_;
#line 222 "../src/headerbar.vala"
			_tmp24_ = bookworm_app_info_firstSearchResultLinkButton;
#line 222 "../src/headerbar.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp24_);
#line 845 "headerbar.c"
		}
	}
}

static void
___lambda80__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 199 "../src/headerbar.vala"
	__lambda80_ ();
#line 856 "headerbar.c"
}

static void
__lambda81_ (Block14Data* _data14_)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	BookwormAppBook* _tmp3_;
#line 229 "../src/headerbar.vala"
	_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 229 "../src/headerbar.vala"
	_tmp1_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 229 "../src/headerbar.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 229 "../src/headerbar.vala"
	_tmp3_ = (BookwormAppBook*) _tmp2_;
#line 229 "../src/headerbar.vala"
	bookworm_app_book_setBookScrollPos (_tmp3_, bookworm_app_content_handler_getScrollPos ());
#line 229 "../src/headerbar.vala"
	_bookworm_app_book_unref0 (_tmp3_);
#line 232 "../src/headerbar.vala"
	gtk_widget_set_visible ((GtkWidget*) _data14_->prefPopover, TRUE);
#line 233 "../src/headerbar.vala"
	gtk_widget_show_all ((GtkWidget*) _data14_->prefPopover);
#line 882 "headerbar.c"
}

static void
___lambda81__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 227 "../src/headerbar.vala"
	__lambda81_ (self);
#line 891 "headerbar.c"
}

static void
__lambda82_ (void)
{
#line 237 "../src/headerbar.vala"
	bookworm_app_content_handler_handleBookMark ("ACTIVE_CLICKED");
#line 899 "headerbar.c"
}

static void
___lambda82__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 236 "../src/headerbar.vala"
	__lambda82_ ();
#line 908 "headerbar.c"
}

static void
__lambda83_ (void)
{
#line 241 "../src/headerbar.vala"
	bookworm_app_content_handler_handleBookMark ("INACTIVE_CLICKED");
#line 916 "headerbar.c"
}

static void
___lambda83__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 240 "../src/headerbar.vala"
	__lambda83_ ();
#line 925 "headerbar.c"
}

static void
__lambda84_ (GtkWidget* widget)
{
	GtkImage* _tmp0_;
	BookwormAppSettings* _tmp5_;
	const gchar* _tmp6_;
#line 244 "../src/headerbar.vala"
	g_return_if_fail (widget != NULL);
#line 246 "../src/headerbar.vala"
	bookworm_app_app_window_controlDeletionButton (FALSE);
#line 247 "../src/headerbar.vala"
	_tmp0_ = bookworm_app_bookworm_library_grid_button_image;
#line 247 "../src/headerbar.vala"
	if (widget == G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget)) {
#line 942 "headerbar.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 248 "../src/headerbar.vala"
		_tmp1_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 248 "../src/headerbar.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 248 "../src/headerbar.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 248 "../src/headerbar.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp2_;
#line 953 "headerbar.c"
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 250 "../src/headerbar.vala"
		_tmp3_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 250 "../src/headerbar.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 250 "../src/headerbar.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 250 "../src/headerbar.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp4_;
#line 965 "headerbar.c"
	}
#line 252 "../src/headerbar.vala"
	_tmp5_ = bookworm_app_app_header_bar_settings;
#line 252 "../src/headerbar.vala"
	_tmp6_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 252 "../src/headerbar.vala"
	bookworm_app_settings_set_library_view_mode (_tmp5_, _tmp6_);
#line 253 "../src/headerbar.vala"
	bookworm_app_bookworm_toggleUIState ();
#line 975 "headerbar.c"
}

static void
___lambda84__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                       GtkWidget* widget,
                                                       gpointer self)
{
#line 244 "../src/headerbar.vala"
	__lambda84_ (widget);
#line 985 "headerbar.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 256 "../src/headerbar.vala"
	return self ? g_object_ref (self) : NULL;
#line 993 "headerbar.c"
}

GtkHeaderBar*
bookworm_app_app_header_bar_create_headerbar (void)
{
	Block14Data* _data14_;
	BookwormAppSettings* _tmp0_;
	BookwormAppBookworm* _tmp1_;
	BookwormAppBookworm* _tmp2_;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkHeaderBar* _tmp5_;
	GtkHeaderBar* _tmp6_;
	GraniteWidgetsModeButton* _tmp7_;
	GraniteWidgetsModeButton* _tmp8_;
	GtkImage* _tmp9_;
	GraniteWidgetsModeButton* _tmp10_;
	GtkImage* _tmp11_;
	GraniteWidgetsModeButton* _tmp12_;
	GraniteWidgetsModeButton* _tmp13_;
	GraniteWidgetsModeButton* _tmp14_;
	BookwormAppSettings* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkImage* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GtkImage* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkPopover* _tmp38_;
	GtkImage* bookmark_inactive_button_image = NULL;
	GtkImage* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkImage* bookmark_active_button_image = NULL;
	GtkImage* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkHeaderBar* _tmp49_;
	GraniteWidgetsModeButton* _tmp50_;
	GtkHeaderBar* _tmp51_;
	GtkButton* _tmp52_;
	GtkHeaderBar* _tmp53_;
	GtkButton* _tmp54_;
	GtkHeaderBar* _tmp55_;
	GtkButton* _tmp56_;
	GtkHeaderBar* _tmp57_;
	GtkButton* _tmp58_;
	GtkHeaderBar* _tmp59_;
	GtkButton* _tmp60_;
	GtkMenuButton* appMenu = NULL;
	GtkMenuButton* _tmp61_;
	GtkImage* _tmp62_;
	GtkMenu* settingsMenu = NULL;
	GtkMenu* _tmp63_;
	GtkMenuItem* prefferencesItem = NULL;
	GtkMenuItem* _tmp64_;
	GtkMenuItem* showAbout = NULL;
	GtkMenuItem* _tmp65_;
	GtkHeaderBar* _tmp66_;
	GtkSearchEntry* _tmp67_;
	GtkSearchEntry* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	GtkSearchEntry* _tmp71_;
	GtkHeaderBar* _tmp72_;
	GtkSearchEntry* _tmp73_;
	GtkSearchEntry* _tmp74_;
	GtkSearchEntry* _tmp75_;
	GtkButton* _tmp76_;
	GtkButton* _tmp77_;
	GtkButton* _tmp78_;
	GtkButton* _tmp79_;
	GtkButton* _tmp80_;
	GraniteWidgetsModeButton* _tmp81_;
	GtkHeaderBar* _tmp82_;
	GtkHeaderBar* _tmp83_;
	GtkHeaderBar* result;
#line 28 "../src/headerbar.vala"
	_data14_ = g_slice_new0 (Block14Data);
#line 28 "../src/headerbar.vala"
	_data14_->_ref_count_ = 1;
#line 29 "../src/headerbar.vala"
	g_info ("headerbar.vala:29: [START] [FUNCTION:create_headerbar]");
#line 30 "../src/headerbar.vala"
	_tmp0_ = bookworm_app_settings_get_instance ();
#line 30 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_app_header_bar_settings);
#line 30 "../src/headerbar.vala"
	bookworm_app_app_header_bar_settings = _tmp0_;
#line 31 "../src/headerbar.vala"
	_tmp1_ = bookworm_app_bookworm_getAppInstance ();
#line 31 "../src/headerbar.vala"
	_tmp2_ = _tmp1_;
#line 31 "../src/headerbar.vala"
	_g_object_unref0 (_tmp2_);
#line 32 "../src/headerbar.vala"
	_tmp3_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 32 "../src/headerbar.vala"
	g_object_ref_sink (_tmp3_);
#line 32 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_app_header_bar_headerbar);
#line 32 "../src/headerbar.vala"
	bookworm_app_app_header_bar_headerbar = _tmp3_;
#line 34 "../src/headerbar.vala"
	_tmp4_ = bookworm_app_app_header_bar_headerbar;
#line 34 "../src/headerbar.vala"
	gtk_header_bar_set_title (_tmp4_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_SUBTITLE_HEADERBAR);
#line 35 "../src/headerbar.vala"
	_tmp5_ = bookworm_app_app_header_bar_headerbar;
#line 35 "../src/headerbar.vala"
	gtk_header_bar_set_show_close_button (_tmp5_, TRUE);
#line 36 "../src/headerbar.vala"
	_tmp6_ = bookworm_app_app_header_bar_headerbar;
#line 36 "../src/headerbar.vala"
	g_object_set (_tmp6_, "spacing", BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS, NULL);
#line 39 "../src/headerbar.vala"
	_tmp7_ = granite_widgets_mode_button_new ();
#line 39 "../src/headerbar.vala"
	g_object_ref_sink (_tmp7_);
#line 39 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_bookworm_library_mode_button);
#line 39 "../src/headerbar.vala"
	bookworm_app_bookworm_library_mode_button = _tmp7_;
#line 40 "../src/headerbar.vala"
	_tmp8_ = bookworm_app_bookworm_library_mode_button;
#line 40 "../src/headerbar.vala"
	_tmp9_ = bookworm_app_bookworm_library_grid_button_image;
#line 40 "../src/headerbar.vala"
	granite_widgets_mode_button_append (_tmp8_, (GtkWidget*) _tmp9_);
#line 41 "../src/headerbar.vala"
	_tmp10_ = bookworm_app_bookworm_library_mode_button;
#line 41 "../src/headerbar.vala"
	_tmp11_ = bookworm_app_bookworm_library_list_button_image;
#line 41 "../src/headerbar.vala"
	granite_widgets_mode_button_append (_tmp10_, (GtkWidget*) _tmp11_);
#line 42 "../src/headerbar.vala"
	_tmp12_ = bookworm_app_bookworm_library_mode_button;
#line 42 "../src/headerbar.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
#line 43 "../src/headerbar.vala"
	_tmp13_ = bookworm_app_bookworm_library_mode_button;
#line 43 "../src/headerbar.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
#line 44 "../src/headerbar.vala"
	_tmp14_ = bookworm_app_bookworm_library_mode_button;
#line 44 "../src/headerbar.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp14_, 60, -1);
#line 45 "../src/headerbar.vala"
	_tmp15_ = bookworm_app_app_header_bar_settings;
#line 45 "../src/headerbar.vala"
	_tmp16_ = bookworm_app_settings_get_library_view_mode (_tmp15_);
#line 45 "../src/headerbar.vala"
	_tmp17_ = _tmp16_;
#line 45 "../src/headerbar.vala"
	_tmp18_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 45 "../src/headerbar.vala"
	if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
#line 1169 "headerbar.c"
		GraniteWidgetsModeButton* _tmp19_;
#line 46 "../src/headerbar.vala"
		_tmp19_ = bookworm_app_bookworm_library_mode_button;
#line 46 "../src/headerbar.vala"
		granite_widgets_mode_button_set_active (_tmp19_, 0);
#line 1175 "headerbar.c"
	} else {
		GraniteWidgetsModeButton* _tmp20_;
#line 48 "../src/headerbar.vala"
		_tmp20_ = bookworm_app_bookworm_library_mode_button;
#line 48 "../src/headerbar.vala"
		granite_widgets_mode_button_set_active (_tmp20_, 1);
#line 1182 "headerbar.c"
	}
#line 51 "../src/headerbar.vala"
	_tmp21_ = (GtkButton*) gtk_button_new_with_label (BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIBRARY_BUTTON);
#line 51 "../src/headerbar.vala"
	g_object_ref_sink (_tmp21_);
#line 51 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_bookworm_library_view_button);
#line 51 "../src/headerbar.vala"
	bookworm_app_bookworm_library_view_button = _tmp21_;
#line 52 "../src/headerbar.vala"
	_tmp22_ = bookworm_app_bookworm_library_view_button;
#line 52 "../src/headerbar.vala"
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
#line 52 "../src/headerbar.vala"
	gtk_style_context_add_class (_tmp23_, "back-button");
#line 53 "../src/headerbar.vala"
	_tmp24_ = bookworm_app_bookworm_library_view_button;
#line 53 "../src/headerbar.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
#line 54 "../src/headerbar.vala"
	_tmp25_ = bookworm_app_bookworm_library_view_button;
#line 54 "../src/headerbar.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp25_, FALSE);
#line 55 "../src/headerbar.vala"
	_tmp26_ = bookworm_app_bookworm_library_view_button;
#line 55 "../src/headerbar.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp26_, FALSE);
#line 57 "../src/headerbar.vala"
	_tmp27_ = (GtkButton*) gtk_button_new ();
#line 57 "../src/headerbar.vala"
	g_object_ref_sink (_tmp27_);
#line 57 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_bookworm_content_list_button);
#line 57 "../src/headerbar.vala"
	bookworm_app_bookworm_content_list_button = _tmp27_;
#line 58 "../src/headerbar.vala"
	_tmp28_ = bookworm_app_bookworm_content_list_button;
#line 58 "../src/headerbar.vala"
	_tmp29_ = bookworm_app_bookworm_content_list_button_image;
#line 58 "../src/headerbar.vala"
	gtk_button_set_image (_tmp28_, (GtkWidget*) _tmp29_);
#line 59 "../src/headerbar.vala"
	_tmp30_ = bookworm_app_bookworm_content_list_button;
#line 59 "../src/headerbar.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
#line 60 "../src/headerbar.vala"
	_tmp31_ = bookworm_app_bookworm_content_list_button;
#line 60 "../src/headerbar.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp31_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_BOOK_INFO);
#line 62 "../src/headerbar.vala"
	_tmp32_ = (GtkButton*) gtk_button_new ();
#line 62 "../src/headerbar.vala"
	g_object_ref_sink (_tmp32_);
#line 62 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_bookworm_prefButton);
#line 62 "../src/headerbar.vala"
	bookworm_app_bookworm_prefButton = _tmp32_;
#line 63 "../src/headerbar.vala"
	_tmp33_ = bookworm_app_bookworm_prefButton;
#line 63 "../src/headerbar.vala"
	_tmp34_ = bookworm_app_bookworm_menu_icon_text_large;
#line 63 "../src/headerbar.vala"
	gtk_button_set_image (_tmp33_, (GtkWidget*) _tmp34_);
#line 64 "../src/headerbar.vala"
	_tmp35_ = bookworm_app_bookworm_prefButton;
#line 64 "../src/headerbar.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp35_, GTK_ALIGN_CENTER);
#line 65 "../src/headerbar.vala"
	_tmp36_ = bookworm_app_bookworm_prefButton;
#line 65 "../src/headerbar.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp36_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_READING_PREFERENCES);
#line 67 "../src/headerbar.vala"
	_tmp37_ = bookworm_app_bookworm_prefButton;
#line 67 "../src/headerbar.vala"
	_tmp38_ = bookworm_app_preferences_menu_createPrefPopOver (_tmp37_);
#line 67 "../src/headerbar.vala"
	_data14_->prefPopover = _tmp38_;
#line 69 "../src/headerbar.vala"
	_tmp39_ = (GtkImage*) gtk_image_new ();
#line 69 "../src/headerbar.vala"
	g_object_ref_sink (_tmp39_);
#line 69 "../src/headerbar.vala"
	bookmark_inactive_button_image = _tmp39_;
#line 70 "../src/headerbar.vala"
	gtk_image_set_from_resource (bookmark_inactive_button_image, BOOKWORM_APP_CONSTANTS_BOOKMARK_INACTIVE_IMAGE_LOCATION);
#line 71 "../src/headerbar.vala"
	_tmp40_ = (GtkButton*) gtk_button_new ();
#line 71 "../src/headerbar.vala"
	g_object_ref_sink (_tmp40_);
#line 71 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_app_header_bar_bookmark_inactive_button);
#line 71 "../src/headerbar.vala"
	bookworm_app_app_header_bar_bookmark_inactive_button = _tmp40_;
#line 72 "../src/headerbar.vala"
	_tmp41_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 72 "../src/headerbar.vala"
	gtk_button_set_image (_tmp41_, (GtkWidget*) bookmark_inactive_button_image);
#line 73 "../src/headerbar.vala"
	_tmp42_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 73 "../src/headerbar.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp42_, GTK_ALIGN_CENTER);
#line 74 "../src/headerbar.vala"
	_tmp43_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 74 "../src/headerbar.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp43_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_BOOKMARKS_ACTIVATE);
#line 76 "../src/headerbar.vala"
	_tmp44_ = (GtkImage*) gtk_image_new ();
#line 76 "../src/headerbar.vala"
	g_object_ref_sink (_tmp44_);
#line 76 "../src/headerbar.vala"
	bookmark_active_button_image = _tmp44_;
#line 77 "../src/headerbar.vala"
	gtk_image_set_from_resource (bookmark_active_button_image, BOOKWORM_APP_CONSTANTS_BOOKMARK_ACTIVE_IMAGE_LOCATION);
#line 78 "../src/headerbar.vala"
	_tmp45_ = (GtkButton*) gtk_button_new ();
#line 78 "../src/headerbar.vala"
	g_object_ref_sink (_tmp45_);
#line 78 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_app_header_bar_bookmark_active_button);
#line 78 "../src/headerbar.vala"
	bookworm_app_app_header_bar_bookmark_active_button = _tmp45_;
#line 79 "../src/headerbar.vala"
	_tmp46_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 79 "../src/headerbar.vala"
	gtk_button_set_image (_tmp46_, (GtkWidget*) bookmark_active_button_image);
#line 80 "../src/headerbar.vala"
	_tmp47_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 80 "../src/headerbar.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp47_, GTK_ALIGN_CENTER);
#line 81 "../src/headerbar.vala"
	_tmp48_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 81 "../src/headerbar.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp48_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_BOOKMARKS_DEACTIVATE);
#line 83 "../src/headerbar.vala"
	_tmp49_ = bookworm_app_app_header_bar_headerbar;
#line 83 "../src/headerbar.vala"
	_tmp50_ = bookworm_app_bookworm_library_mode_button;
#line 83 "../src/headerbar.vala"
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
#line 84 "../src/headerbar.vala"
	_tmp51_ = bookworm_app_app_header_bar_headerbar;
#line 84 "../src/headerbar.vala"
	_tmp52_ = bookworm_app_bookworm_library_view_button;
#line 84 "../src/headerbar.vala"
	gtk_header_bar_pack_start (_tmp51_, (GtkWidget*) _tmp52_);
#line 85 "../src/headerbar.vala"
	_tmp53_ = bookworm_app_app_header_bar_headerbar;
#line 85 "../src/headerbar.vala"
	_tmp54_ = bookworm_app_bookworm_content_list_button;
#line 85 "../src/headerbar.vala"
	gtk_header_bar_pack_start (_tmp53_, (GtkWidget*) _tmp54_);
#line 86 "../src/headerbar.vala"
	_tmp55_ = bookworm_app_app_header_bar_headerbar;
#line 86 "../src/headerbar.vala"
	_tmp56_ = bookworm_app_bookworm_prefButton;
#line 86 "../src/headerbar.vala"
	gtk_header_bar_pack_start (_tmp55_, (GtkWidget*) _tmp56_);
#line 87 "../src/headerbar.vala"
	_tmp57_ = bookworm_app_app_header_bar_headerbar;
#line 87 "../src/headerbar.vala"
	_tmp58_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 87 "../src/headerbar.vala"
	gtk_header_bar_pack_start (_tmp57_, (GtkWidget*) _tmp58_);
#line 88 "../src/headerbar.vala"
	_tmp59_ = bookworm_app_app_header_bar_headerbar;
#line 88 "../src/headerbar.vala"
	_tmp60_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 88 "../src/headerbar.vala"
	gtk_header_bar_pack_start (_tmp59_, (GtkWidget*) _tmp60_);
#line 91 "../src/headerbar.vala"
	_tmp61_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 91 "../src/headerbar.vala"
	g_object_ref_sink (_tmp61_);
#line 91 "../src/headerbar.vala"
	appMenu = _tmp61_;
#line 92 "../src/headerbar.vala"
	_tmp62_ = bookworm_app_bookworm_menu_icon;
#line 92 "../src/headerbar.vala"
	gtk_button_set_image ((GtkButton*) appMenu, (GtkWidget*) _tmp62_);
#line 94 "../src/headerbar.vala"
	_tmp63_ = (GtkMenu*) gtk_menu_new ();
#line 94 "../src/headerbar.vala"
	g_object_ref_sink (_tmp63_);
#line 94 "../src/headerbar.vala"
	settingsMenu = _tmp63_;
#line 95 "../src/headerbar.vala"
	gtk_menu_button_set_popup (appMenu, settingsMenu);
#line 97 "../src/headerbar.vala"
	_tmp64_ = (GtkMenuItem*) gtk_menu_item_new_with_label (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREF_MENU_PREFERENCES_ITEM);
#line 97 "../src/headerbar.vala"
	g_object_ref_sink (_tmp64_);
#line 97 "../src/headerbar.vala"
	prefferencesItem = _tmp64_;
#line 98 "../src/headerbar.vala"
	g_signal_connect (prefferencesItem, "activate", (GCallback) _bookworm_app_app_dialog_createPreferencesDialog_gtk_menu_item_activate, NULL);
#line 99 "../src/headerbar.vala"
	gtk_menu_shell_append ((GtkMenuShell*) settingsMenu, prefferencesItem);
#line 101 "../src/headerbar.vala"
	_tmp65_ = (GtkMenuItem*) gtk_menu_item_new_with_label (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREF_MENU_ABOUT_ITEM);
#line 101 "../src/headerbar.vala"
	g_object_ref_sink (_tmp65_);
#line 101 "../src/headerbar.vala"
	showAbout = _tmp65_;
#line 102 "../src/headerbar.vala"
	g_signal_connect (showAbout, "activate", (GCallback) _bookworm_app_app_header_bar_ShowAboutDialog_gtk_menu_item_activate, NULL);
#line 103 "../src/headerbar.vala"
	gtk_menu_shell_append ((GtkMenuShell*) settingsMenu, showAbout);
#line 104 "../src/headerbar.vala"
	gtk_widget_show_all ((GtkWidget*) settingsMenu);
#line 105 "../src/headerbar.vala"
	_tmp66_ = bookworm_app_app_header_bar_headerbar;
#line 105 "../src/headerbar.vala"
	gtk_header_bar_pack_end (_tmp66_, (GtkWidget*) appMenu);
#line 108 "../src/headerbar.vala"
	_tmp67_ = (GtkSearchEntry*) gtk_search_entry_new ();
#line 108 "../src/headerbar.vala"
	g_object_ref_sink (_tmp67_);
#line 108 "../src/headerbar.vala"
	_g_object_unref0 (bookworm_app_app_header_bar_headerSearchBar);
#line 108 "../src/headerbar.vala"
	bookworm_app_app_header_bar_headerSearchBar = _tmp67_;
#line 109 "../src/headerbar.vala"
	_tmp68_ = bookworm_app_app_header_bar_headerSearchBar;
#line 109 "../src/headerbar.vala"
	_tmp69_ = strlen (BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH);
#line 109 "../src/headerbar.vala"
	_tmp70_ = _tmp69_;
#line 109 "../src/headerbar.vala"
	gtk_entry_set_max_width_chars ((GtkEntry*) _tmp68_, _tmp70_);
#line 110 "../src/headerbar.vala"
	_tmp71_ = bookworm_app_app_header_bar_headerSearchBar;
#line 110 "../src/headerbar.vala"
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp71_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_HEADERBAR_LIBRARY_SEARCH);
#line 111 "../src/headerbar.vala"
	_tmp72_ = bookworm_app_app_header_bar_headerbar;
#line 111 "../src/headerbar.vala"
	_tmp73_ = bookworm_app_app_header_bar_headerSearchBar;
#line 111 "../src/headerbar.vala"
	gtk_header_bar_pack_end (_tmp72_, (GtkWidget*) _tmp73_);
#line 114 "../src/headerbar.vala"
	_tmp74_ = bookworm_app_app_header_bar_headerSearchBar;
#line 114 "../src/headerbar.vala"
	g_signal_connect (_tmp74_, "search-changed", (GCallback) ___lambda77__gtk_search_entry_search_changed, NULL);
#line 136 "../src/headerbar.vala"
	_tmp75_ = bookworm_app_app_header_bar_headerSearchBar;
#line 136 "../src/headerbar.vala"
	g_signal_connect ((GtkEntry*) _tmp75_, "activate", (GCallback) ___lambda78__gtk_entry_activate, NULL);
#line 162 "../src/headerbar.vala"
	_tmp76_ = bookworm_app_bookworm_library_view_button;
#line 162 "../src/headerbar.vala"
	g_signal_connect (_tmp76_, "clicked", (GCallback) ___lambda79__gtk_button_clicked, NULL);
#line 199 "../src/headerbar.vala"
	_tmp77_ = bookworm_app_bookworm_content_list_button;
#line 199 "../src/headerbar.vala"
	g_signal_connect (_tmp77_, "clicked", (GCallback) ___lambda80__gtk_button_clicked, NULL);
#line 227 "../src/headerbar.vala"
	_tmp78_ = bookworm_app_bookworm_prefButton;
#line 227 "../src/headerbar.vala"
	g_signal_connect_data (_tmp78_, "clicked", (GCallback) ___lambda81__gtk_button_clicked, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
#line 236 "../src/headerbar.vala"
	_tmp79_ = bookworm_app_app_header_bar_bookmark_active_button;
#line 236 "../src/headerbar.vala"
	g_signal_connect (_tmp79_, "clicked", (GCallback) ___lambda82__gtk_button_clicked, NULL);
#line 240 "../src/headerbar.vala"
	_tmp80_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 240 "../src/headerbar.vala"
	g_signal_connect (_tmp80_, "clicked", (GCallback) ___lambda83__gtk_button_clicked, NULL);
#line 244 "../src/headerbar.vala"
	_tmp81_ = bookworm_app_bookworm_library_mode_button;
#line 244 "../src/headerbar.vala"
	g_signal_connect (_tmp81_, "mode-changed", (GCallback) ___lambda84__granite_widgets_mode_button_mode_changed, NULL);
#line 255 "../src/headerbar.vala"
	g_info ("headerbar.vala:255: [END] [FUNCTION:create_headerbar]");
#line 256 "../src/headerbar.vala"
	_tmp82_ = bookworm_app_app_header_bar_headerbar;
#line 256 "../src/headerbar.vala"
	_tmp83_ = _g_object_ref0 (_tmp82_);
#line 256 "../src/headerbar.vala"
	result = _tmp83_;
#line 256 "../src/headerbar.vala"
	_g_object_unref0 (showAbout);
#line 256 "../src/headerbar.vala"
	_g_object_unref0 (prefferencesItem);
#line 256 "../src/headerbar.vala"
	_g_object_unref0 (settingsMenu);
#line 256 "../src/headerbar.vala"
	_g_object_unref0 (appMenu);
#line 256 "../src/headerbar.vala"
	_g_object_unref0 (bookmark_active_button_image);
#line 256 "../src/headerbar.vala"
	_g_object_unref0 (bookmark_inactive_button_image);
#line 256 "../src/headerbar.vala"
	block14_data_unref (_data14_);
#line 256 "../src/headerbar.vala"
	_data14_ = NULL;
#line 256 "../src/headerbar.vala"
	return result;
#line 1480 "headerbar.c"
}

GtkHeaderBar*
bookworm_app_app_header_bar_get_headerbar (void)
{
	GtkHeaderBar* _tmp0_;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkHeaderBar* result;
#line 260 "../src/headerbar.vala"
	_tmp0_ = bookworm_app_app_header_bar_headerbar;
#line 260 "../src/headerbar.vala"
	if (_tmp0_ == NULL) {
#line 1494 "headerbar.c"
		GtkHeaderBar* _tmp1_;
		GtkHeaderBar* _tmp2_;
#line 261 "../src/headerbar.vala"
		_tmp1_ = bookworm_app_app_header_bar_create_headerbar ();
#line 261 "../src/headerbar.vala"
		_tmp2_ = _tmp1_;
#line 261 "../src/headerbar.vala"
		_g_object_unref0 (_tmp2_);
#line 1503 "headerbar.c"
	}
#line 263 "../src/headerbar.vala"
	_tmp3_ = bookworm_app_app_header_bar_headerbar;
#line 263 "../src/headerbar.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 263 "../src/headerbar.vala"
	result = _tmp4_;
#line 263 "../src/headerbar.vala"
	return result;
#line 1513 "headerbar.c"
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 266 "../src/headerbar.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 266 "../src/headerbar.vala"
	return _data15_;
#line 1523 "headerbar.c"
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 266 "../src/headerbar.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 266 "../src/headerbar.vala"
		_g_object_unref0 (_data15_->aboutDialog);
#line 266 "../src/headerbar.vala"
		g_slice_free (Block15Data, _data15_);
#line 1537 "headerbar.c"
	}
}

static void
__lambda76_ (Block15Data* _data15_,
             gint response_id)
{
#line 289 "../src/headerbar.vala"
	gtk_widget_destroy ((GtkWidget*) _data15_->aboutDialog);
#line 1547 "headerbar.c"
}

static void
___lambda76__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
#line 288 "../src/headerbar.vala"
	__lambda76_ (self, response_id);
#line 1557 "headerbar.c"
}

void
bookworm_app_app_header_bar_ShowAboutDialog (void)
{
	Block15Data* _data15_;
	GtkAboutDialog* _tmp0_;
	GtkWindow* _tmp1_;
	GtkApplicationWindow* _tmp2_;
#line 266 "../src/headerbar.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 266 "../src/headerbar.vala"
	_data15_->_ref_count_ = 1;
#line 267 "../src/headerbar.vala"
	g_info ("headerbar.vala:267: [START] [FUNCTION:ShowAboutDialog]");
#line 268 "../src/headerbar.vala"
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 268 "../src/headerbar.vala"
	g_object_ref_sink (_tmp0_);
#line 268 "../src/headerbar.vala"
	_data15_->aboutDialog = _tmp0_;
#line 269 "../src/headerbar.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data15_->aboutDialog, TRUE);
#line 270 "../src/headerbar.vala"
	_tmp1_ = bookworm_app_app_header_bar_window;
#line 270 "../src/headerbar.vala"
	gtk_window_set_transient_for ((GtkWindow*) _data15_->aboutDialog, _tmp1_);
#line 271 "../src/headerbar.vala"
	gtk_window_set_modal ((GtkWindow*) _data15_->aboutDialog, TRUE);
#line 273 "../src/headerbar.vala"
	_tmp2_ = bookworm_app_bookworm_window;
#line 273 "../src/headerbar.vala"
	gtk_window_set_attached_to ((GtkWindow*) _data15_->aboutDialog, (GtkWidget*) _tmp2_);
#line 274 "../src/headerbar.vala"
	gtk_about_dialog_set_program_name (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_program_name);
#line 275 "../src/headerbar.vala"
	gtk_about_dialog_set_website (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_TEXT_FOR_ABOUT_DIALOG_WEBSITE_URL);
#line 276 "../src/headerbar.vala"
	gtk_about_dialog_set_website_label (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_TEXT_FOR_ABOUT_DIALOG_WEBSITE);
#line 277 "../src/headerbar.vala"
	gtk_about_dialog_set_logo_icon_name (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_app_icon);
#line 278 "../src/headerbar.vala"
	gtk_about_dialog_set_copyright (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_bookworm_copyright);
#line 279 "../src/headerbar.vala"
	gtk_about_dialog_set_version (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_bookworm_version);
#line 280 "../src/headerbar.vala"
	gtk_about_dialog_set_authors (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_about_authors);
#line 281 "../src/headerbar.vala"
	gtk_about_dialog_set_artists (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_about_artists);
#line 282 "../src/headerbar.vala"
	gtk_about_dialog_set_comments (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_about_comments);
#line 283 "../src/headerbar.vala"
	gtk_about_dialog_set_license (_data15_->aboutDialog, NULL);
#line 284 "../src/headerbar.vala"
	gtk_about_dialog_set_license_type (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_about_license_type);
#line 285 "../src/headerbar.vala"
	gtk_about_dialog_set_translator_credits (_data15_->aboutDialog, BOOKWORM_APP_CONSTANTS_translator_credits);
#line 287 "../src/headerbar.vala"
	gtk_window_present ((GtkWindow*) _data15_->aboutDialog);
#line 288 "../src/headerbar.vala"
	g_signal_connect_data ((GtkDialog*) _data15_->aboutDialog, "response", (GCallback) ___lambda76__gtk_dialog_response, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
#line 291 "../src/headerbar.vala"
	g_info ("headerbar.vala:291: [END] [FUNCTION:ShowAboutDialog]");
#line 266 "../src/headerbar.vala"
	block15_data_unref (_data15_);
#line 266 "../src/headerbar.vala"
	_data15_ = NULL;
#line 1625 "headerbar.c"
}

BookwormAppAppHeaderBar*
bookworm_app_app_header_bar_construct (GType object_type)
{
	BookwormAppAppHeaderBar* self = NULL;
#line 20 "../src/headerbar.vala"
	self = (BookwormAppAppHeaderBar*) g_type_create_instance (object_type);
#line 20 "../src/headerbar.vala"
	return self;
#line 1636 "headerbar.c"
}

BookwormAppAppHeaderBar*
bookworm_app_app_header_bar_new (void)
{
#line 20 "../src/headerbar.vala"
	return bookworm_app_app_header_bar_construct (BOOKWORM_APP_TYPE_APP_HEADER_BAR);
#line 1644 "headerbar.c"
}

static void
bookworm_app_value_app_header_bar_init (GValue* value)
{
#line 20 "../src/headerbar.vala"
	value->data[0].v_pointer = NULL;
#line 1652 "headerbar.c"
}

static void
bookworm_app_value_app_header_bar_free_value (GValue* value)
{
#line 20 "../src/headerbar.vala"
	if (value->data[0].v_pointer) {
#line 20 "../src/headerbar.vala"
		bookworm_app_app_header_bar_unref (value->data[0].v_pointer);
#line 1662 "headerbar.c"
	}
}

static void
bookworm_app_value_app_header_bar_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
#line 20 "../src/headerbar.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "../src/headerbar.vala"
		dest_value->data[0].v_pointer = bookworm_app_app_header_bar_ref (src_value->data[0].v_pointer);
#line 1674 "headerbar.c"
	} else {
#line 20 "../src/headerbar.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1678 "headerbar.c"
	}
}

static gpointer
bookworm_app_value_app_header_bar_peek_pointer (const GValue* value)
{
#line 20 "../src/headerbar.vala"
	return value->data[0].v_pointer;
#line 1687 "headerbar.c"
}

static gchar*
bookworm_app_value_app_header_bar_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
#line 20 "../src/headerbar.vala"
	if (collect_values[0].v_pointer) {
#line 1698 "headerbar.c"
		BookwormAppAppHeaderBar * object;
		object = collect_values[0].v_pointer;
#line 20 "../src/headerbar.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "../src/headerbar.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1705 "headerbar.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "../src/headerbar.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1709 "headerbar.c"
		}
#line 20 "../src/headerbar.vala"
		value->data[0].v_pointer = bookworm_app_app_header_bar_ref (object);
#line 1713 "headerbar.c"
	} else {
#line 20 "../src/headerbar.vala"
		value->data[0].v_pointer = NULL;
#line 1717 "headerbar.c"
	}
#line 20 "../src/headerbar.vala"
	return NULL;
#line 1721 "headerbar.c"
}

static gchar*
bookworm_app_value_app_header_bar_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	BookwormAppAppHeaderBar ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "../src/headerbar.vala"
	if (!object_p) {
#line 20 "../src/headerbar.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1736 "headerbar.c"
	}
#line 20 "../src/headerbar.vala"
	if (!value->data[0].v_pointer) {
#line 20 "../src/headerbar.vala"
		*object_p = NULL;
#line 1742 "headerbar.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "../src/headerbar.vala"
		*object_p = value->data[0].v_pointer;
#line 1746 "headerbar.c"
	} else {
#line 20 "../src/headerbar.vala"
		*object_p = bookworm_app_app_header_bar_ref (value->data[0].v_pointer);
#line 1750 "headerbar.c"
	}
#line 20 "../src/headerbar.vala"
	return NULL;
#line 1754 "headerbar.c"
}

GParamSpec*
bookworm_app_param_spec_app_header_bar (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	BookwormAppParamSpecAppHeaderBar* spec;
#line 20 "../src/headerbar.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_APP_HEADER_BAR), NULL);
#line 20 "../src/headerbar.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "../src/headerbar.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "../src/headerbar.vala"
	return G_PARAM_SPEC (spec);
#line 1773 "headerbar.c"
}

gpointer
bookworm_app_value_get_app_header_bar (const GValue* value)
{
#line 20 "../src/headerbar.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_APP_HEADER_BAR), NULL);
#line 20 "../src/headerbar.vala"
	return value->data[0].v_pointer;
#line 1783 "headerbar.c"
}

void
bookworm_app_value_set_app_header_bar (GValue* value,
                                       gpointer v_object)
{
	BookwormAppAppHeaderBar * old;
#line 20 "../src/headerbar.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_APP_HEADER_BAR));
#line 20 "../src/headerbar.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/headerbar.vala"
	if (v_object) {
#line 20 "../src/headerbar.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_APP_HEADER_BAR));
#line 20 "../src/headerbar.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/headerbar.vala"
		value->data[0].v_pointer = v_object;
#line 20 "../src/headerbar.vala"
		bookworm_app_app_header_bar_ref (value->data[0].v_pointer);
#line 1805 "headerbar.c"
	} else {
#line 20 "../src/headerbar.vala"
		value->data[0].v_pointer = NULL;
#line 1809 "headerbar.c"
	}
#line 20 "../src/headerbar.vala"
	if (old) {
#line 20 "../src/headerbar.vala"
		bookworm_app_app_header_bar_unref (old);
#line 1815 "headerbar.c"
	}
}

void
bookworm_app_value_take_app_header_bar (GValue* value,
                                        gpointer v_object)
{
	BookwormAppAppHeaderBar * old;
#line 20 "../src/headerbar.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_APP_HEADER_BAR));
#line 20 "../src/headerbar.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/headerbar.vala"
	if (v_object) {
#line 20 "../src/headerbar.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_APP_HEADER_BAR));
#line 20 "../src/headerbar.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/headerbar.vala"
		value->data[0].v_pointer = v_object;
#line 1836 "headerbar.c"
	} else {
#line 20 "../src/headerbar.vala"
		value->data[0].v_pointer = NULL;
#line 1840 "headerbar.c"
	}
#line 20 "../src/headerbar.vala"
	if (old) {
#line 20 "../src/headerbar.vala"
		bookworm_app_app_header_bar_unref (old);
#line 1846 "headerbar.c"
	}
}

static void
bookworm_app_app_header_bar_class_init (BookwormAppAppHeaderBarClass * klass,
                                        gpointer klass_data)
{
#line 20 "../src/headerbar.vala"
	bookworm_app_app_header_bar_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/headerbar.vala"
	((BookwormAppAppHeaderBarClass *) klass)->finalize = bookworm_app_app_header_bar_finalize;
#line 1858 "headerbar.c"
}

static void
bookworm_app_app_header_bar_instance_init (BookwormAppAppHeaderBar * self,
                                           gpointer klass)
{
#line 20 "../src/headerbar.vala"
	self->ref_count = 1;
#line 1867 "headerbar.c"
}

static void
bookworm_app_app_header_bar_finalize (BookwormAppAppHeaderBar * obj)
{
	BookwormAppAppHeaderBar * self;
#line 20 "../src/headerbar.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_APP_HEADER_BAR, BookwormAppAppHeaderBar);
#line 20 "../src/headerbar.vala"
	g_signal_handlers_destroy (self);
#line 1878 "headerbar.c"
}

static GType
bookworm_app_app_header_bar_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_app_header_bar_init, bookworm_app_value_app_header_bar_free_value, bookworm_app_value_app_header_bar_copy_value, bookworm_app_value_app_header_bar_peek_pointer, "p", bookworm_app_value_app_header_bar_collect_value, "p", bookworm_app_value_app_header_bar_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppAppHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_app_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppAppHeaderBar), 0, (GInstanceInitFunc) bookworm_app_app_header_bar_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_app_header_bar_type_id;
	bookworm_app_app_header_bar_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppAppHeaderBar", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_app_header_bar_type_id;
}

GType
bookworm_app_app_header_bar_get_type (void)
{
	static volatile gsize bookworm_app_app_header_bar_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_app_header_bar_type_id__once)) {
		GType bookworm_app_app_header_bar_type_id;
		bookworm_app_app_header_bar_type_id = bookworm_app_app_header_bar_get_type_once ();
		g_once_init_leave (&bookworm_app_app_header_bar_type_id__once, bookworm_app_app_header_bar_type_id);
	}
	return bookworm_app_app_header_bar_type_id__once;
}

gpointer
bookworm_app_app_header_bar_ref (gpointer instance)
{
	BookwormAppAppHeaderBar * self;
	self = instance;
#line 20 "../src/headerbar.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "../src/headerbar.vala"
	return instance;
#line 1913 "headerbar.c"
}

void
bookworm_app_app_header_bar_unref (gpointer instance)
{
	BookwormAppAppHeaderBar * self;
	self = instance;
#line 20 "../src/headerbar.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "../src/headerbar.vala"
		BOOKWORM_APP_APP_HEADER_BAR_GET_CLASS (self)->finalize (self);
#line 20 "../src/headerbar.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1927 "headerbar.c"
	}
}

