/* settings.c generated by valac 0.56.18, the Vala compiler
 * generated from settings.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for persisting
* the state of the window and associated user prefferences
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <granite.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
typedef struct _BookwormAppSettingsPrivate BookwormAppSettingsPrivate;
enum  {
	BOOKWORM_APP_SETTINGS_0_PROPERTY,
	BOOKWORM_APP_SETTINGS_WINDOW_WIDTH_PROPERTY,
	BOOKWORM_APP_SETTINGS_WINDOW_HEIGHT_PROPERTY,
	BOOKWORM_APP_SETTINGS_POS_X_PROPERTY,
	BOOKWORM_APP_SETTINGS_POS_Y_PROPERTY,
	BOOKWORM_APP_SETTINGS_WINDOW_IS_MAXIMIZED_PROPERTY,
	BOOKWORM_APP_SETTINGS_ZOOM_LEVEL_PROPERTY,
	BOOKWORM_APP_SETTINGS_READING_PROFILE_PROPERTY,
	BOOKWORM_APP_SETTINGS_IS_DARK_THEME_ENABLED_PROPERTY,
	BOOKWORM_APP_SETTINGS_IS_LOCAL_STORAGE_ENABLED_PROPERTY,
	BOOKWORM_APP_SETTINGS_IS_SHOW_LIBRARY_ON_START_PROPERTY,
	BOOKWORM_APP_SETTINGS_READING_WIDTH_PROPERTY,
	BOOKWORM_APP_SETTINGS_READING_LINE_HEIGHT_PROPERTY,
	BOOKWORM_APP_SETTINGS_TEXT_ALIGNMENT_PROPERTY,
	BOOKWORM_APP_SETTINGS_LIBRARY_VIEW_MODE_PROPERTY,
	BOOKWORM_APP_SETTINGS_READING_FONT_NAME_PROPERTY,
	BOOKWORM_APP_SETTINGS_READING_FONT_NAME_FAMILY_PROPERTY,
	BOOKWORM_APP_SETTINGS_READING_FONT_SIZE_PROPERTY,
	BOOKWORM_APP_SETTINGS_LIST_OF_PROFILE_COLORS_PROPERTY,
	BOOKWORM_APP_SETTINGS_LIST_OF_SCAN_DIRS_PROPERTY,
	BOOKWORM_APP_SETTINGS_BOOK_BEING_READ_PROPERTY,
	BOOKWORM_APP_SETTINGS_IS_TWO_PAGE_ENABLED_PROPERTY,
	BOOKWORM_APP_SETTINGS_CURRENT_INFO_TAB_PROPERTY,
	BOOKWORM_APP_SETTINGS_IS_FULLSCREEN_PROPERTY,
	BOOKWORM_APP_SETTINGS_LIBRARY_PAGE_ITEMS_PROPERTY,
	BOOKWORM_APP_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BookwormAppSettings {
	GraniteServicesSettings parent_instance;
	BookwormAppSettingsPrivate * priv;
};

struct _BookwormAppSettingsClass {
	GraniteServicesSettingsClass parent_class;
};

struct _BookwormAppSettingsPrivate {
	gint _window_width;
	gint _window_height;
	gint _pos_x;
	gint _pos_y;
	gboolean _window_is_maximized;
	gdouble _zoom_level;
	gchar* _reading_profile;
	gboolean _is_dark_theme_enabled;
	gboolean _is_local_storage_enabled;
	gboolean _is_show_library_on_start;
	gchar* _reading_width;
	gchar* _reading_line_height;
	gchar* _text_alignment;
	gchar* _library_view_mode;
	gchar* _reading_font_name;
	gchar* _reading_font_name_family;
	gint _reading_font_size;
	gchar* _list_of_profile_colors;
	gchar* _list_of_scan_dirs;
	gchar* _book_being_read;
	gboolean _is_two_page_enabled;
	gchar* _current_info_tab;
	gboolean _is_fullscreen;
	gint _library_page_items;
};

static gint BookwormAppSettings_private_offset;
static gpointer bookworm_app_settings_parent_class = NULL;
static BookwormAppSettings* bookworm_app_settings_instance;
static BookwormAppSettings* bookworm_app_settings_instance = NULL;

VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
static BookwormAppSettings* bookworm_app_settings_new (void);
static BookwormAppSettings* bookworm_app_settings_construct (GType object_type);
VALA_EXTERN gint bookworm_app_settings_get_window_width (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_window_width (BookwormAppSettings* self,
                                             gint value);
VALA_EXTERN gint bookworm_app_settings_get_window_height (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_window_height (BookwormAppSettings* self,
                                              gint value);
VALA_EXTERN gint bookworm_app_settings_get_pos_x (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_pos_x (BookwormAppSettings* self,
                                      gint value);
VALA_EXTERN gint bookworm_app_settings_get_pos_y (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_pos_y (BookwormAppSettings* self,
                                      gint value);
VALA_EXTERN gboolean bookworm_app_settings_get_window_is_maximized (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_window_is_maximized (BookwormAppSettings* self,
                                                    gboolean value);
VALA_EXTERN gdouble bookworm_app_settings_get_zoom_level (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_zoom_level (BookwormAppSettings* self,
                                           gdouble value);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_profile (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_reading_profile (BookwormAppSettings* self,
                                                const gchar* value);
VALA_EXTERN gboolean bookworm_app_settings_get_is_dark_theme_enabled (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_is_dark_theme_enabled (BookwormAppSettings* self,
                                                      gboolean value);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_is_local_storage_enabled (BookwormAppSettings* self,
                                                         gboolean value);
VALA_EXTERN gboolean bookworm_app_settings_get_is_show_library_on_start (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_is_show_library_on_start (BookwormAppSettings* self,
                                                         gboolean value);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_width (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_reading_width (BookwormAppSettings* self,
                                              const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_line_height (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_reading_line_height (BookwormAppSettings* self,
                                                    const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_text_alignment (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_text_alignment (BookwormAppSettings* self,
                                               const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_library_view_mode (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_library_view_mode (BookwormAppSettings* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_font_name (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_reading_font_name (BookwormAppSettings* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_font_name_family (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_reading_font_name_family (BookwormAppSettings* self,
                                                         const gchar* value);
VALA_EXTERN gint bookworm_app_settings_get_reading_font_size (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_reading_font_size (BookwormAppSettings* self,
                                                  gint value);
VALA_EXTERN const gchar* bookworm_app_settings_get_list_of_profile_colors (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_list_of_profile_colors (BookwormAppSettings* self,
                                                       const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_list_of_scan_dirs (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_list_of_scan_dirs (BookwormAppSettings* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* bookworm_app_settings_get_book_being_read (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_book_being_read (BookwormAppSettings* self,
                                                const gchar* value);
VALA_EXTERN gboolean bookworm_app_settings_get_is_two_page_enabled (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_is_two_page_enabled (BookwormAppSettings* self,
                                                    gboolean value);
VALA_EXTERN const gchar* bookworm_app_settings_get_current_info_tab (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_current_info_tab (BookwormAppSettings* self,
                                                 const gchar* value);
VALA_EXTERN gboolean bookworm_app_settings_get_is_fullscreen (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_is_fullscreen (BookwormAppSettings* self,
                                              gboolean value);
VALA_EXTERN gint bookworm_app_settings_get_library_page_items (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_library_page_items (BookwormAppSettings* self,
                                                   gint value);
static void bookworm_app_settings_finalize (GObject * obj);
static GType bookworm_app_settings_get_type_once (void);
static void _vala_bookworm_app_settings_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_bookworm_app_settings_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
bookworm_app_settings_get_instance_private (BookwormAppSettings* self)
{
	return G_STRUCT_MEMBER_P (self, BookwormAppSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 52 "../src/settings.vala"
	return self ? g_object_ref (self) : NULL;
#line 233 "settings.c"
}

BookwormAppSettings*
bookworm_app_settings_get_instance (void)
{
	BookwormAppSettings* _tmp0_;
	BookwormAppSettings* _tmp2_;
	BookwormAppSettings* _tmp3_;
	BookwormAppSettings* result;
#line 49 "../src/settings.vala"
	_tmp0_ = bookworm_app_settings_instance;
#line 49 "../src/settings.vala"
	if (_tmp0_ == NULL) {
#line 247 "settings.c"
		BookwormAppSettings* _tmp1_;
#line 50 "../src/settings.vala"
		_tmp1_ = bookworm_app_settings_new ();
#line 50 "../src/settings.vala"
		_g_object_unref0 (bookworm_app_settings_instance);
#line 50 "../src/settings.vala"
		bookworm_app_settings_instance = _tmp1_;
#line 255 "settings.c"
	}
#line 52 "../src/settings.vala"
	_tmp2_ = bookworm_app_settings_instance;
#line 52 "../src/settings.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 52 "../src/settings.vala"
	result = _tmp3_;
#line 52 "../src/settings.vala"
	return result;
#line 265 "settings.c"
}

static BookwormAppSettings*
bookworm_app_settings_construct (GType object_type)
{
	BookwormAppSettings * self = NULL;
#line 56 "../src/settings.vala"
	self = (BookwormAppSettings*) granite_services_settings_construct (object_type, BOOKWORM_APP_CONSTANTS_bookworm_id);
#line 55 "../src/settings.vala"
	return self;
#line 276 "settings.c"
}

static BookwormAppSettings*
bookworm_app_settings_new (void)
{
#line 55 "../src/settings.vala"
	return bookworm_app_settings_construct (BOOKWORM_APP_TYPE_SETTINGS);
#line 284 "settings.c"
}

gint
bookworm_app_settings_get_window_width (BookwormAppSettings* self)
{
	gint result;
#line 23 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 23 "../src/settings.vala"
	result = self->priv->_window_width;
#line 23 "../src/settings.vala"
	return result;
#line 297 "settings.c"
}

void
bookworm_app_settings_set_window_width (BookwormAppSettings* self,
                                        gint value)
{
	gint old_value;
#line 23 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 23 "../src/settings.vala"
	old_value = bookworm_app_settings_get_window_width (self);
#line 23 "../src/settings.vala"
	if (old_value != value) {
#line 23 "../src/settings.vala"
		self->priv->_window_width = value;
#line 23 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_WINDOW_WIDTH_PROPERTY]);
#line 315 "settings.c"
	}
}

gint
bookworm_app_settings_get_window_height (BookwormAppSettings* self)
{
	gint result;
#line 24 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 24 "../src/settings.vala"
	result = self->priv->_window_height;
#line 24 "../src/settings.vala"
	return result;
#line 329 "settings.c"
}

void
bookworm_app_settings_set_window_height (BookwormAppSettings* self,
                                         gint value)
{
	gint old_value;
#line 24 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 24 "../src/settings.vala"
	old_value = bookworm_app_settings_get_window_height (self);
#line 24 "../src/settings.vala"
	if (old_value != value) {
#line 24 "../src/settings.vala"
		self->priv->_window_height = value;
#line 24 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_WINDOW_HEIGHT_PROPERTY]);
#line 347 "settings.c"
	}
}

gint
bookworm_app_settings_get_pos_x (BookwormAppSettings* self)
{
	gint result;
#line 25 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "../src/settings.vala"
	result = self->priv->_pos_x;
#line 25 "../src/settings.vala"
	return result;
#line 361 "settings.c"
}

void
bookworm_app_settings_set_pos_x (BookwormAppSettings* self,
                                 gint value)
{
	gint old_value;
#line 25 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 25 "../src/settings.vala"
	old_value = bookworm_app_settings_get_pos_x (self);
#line 25 "../src/settings.vala"
	if (old_value != value) {
#line 25 "../src/settings.vala"
		self->priv->_pos_x = value;
#line 25 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_POS_X_PROPERTY]);
#line 379 "settings.c"
	}
}

gint
bookworm_app_settings_get_pos_y (BookwormAppSettings* self)
{
	gint result;
#line 26 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "../src/settings.vala"
	result = self->priv->_pos_y;
#line 26 "../src/settings.vala"
	return result;
#line 393 "settings.c"
}

void
bookworm_app_settings_set_pos_y (BookwormAppSettings* self,
                                 gint value)
{
	gint old_value;
#line 26 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 26 "../src/settings.vala"
	old_value = bookworm_app_settings_get_pos_y (self);
#line 26 "../src/settings.vala"
	if (old_value != value) {
#line 26 "../src/settings.vala"
		self->priv->_pos_y = value;
#line 26 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_POS_Y_PROPERTY]);
#line 411 "settings.c"
	}
}

gboolean
bookworm_app_settings_get_window_is_maximized (BookwormAppSettings* self)
{
	gboolean result;
#line 27 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 27 "../src/settings.vala"
	result = self->priv->_window_is_maximized;
#line 27 "../src/settings.vala"
	return result;
#line 425 "settings.c"
}

void
bookworm_app_settings_set_window_is_maximized (BookwormAppSettings* self,
                                               gboolean value)
{
	gboolean old_value;
#line 27 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 27 "../src/settings.vala"
	old_value = bookworm_app_settings_get_window_is_maximized (self);
#line 27 "../src/settings.vala"
	if (old_value != value) {
#line 27 "../src/settings.vala"
		self->priv->_window_is_maximized = value;
#line 27 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_WINDOW_IS_MAXIMIZED_PROPERTY]);
#line 443 "settings.c"
	}
}

gdouble
bookworm_app_settings_get_zoom_level (BookwormAppSettings* self)
{
	gdouble result;
#line 28 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 28 "../src/settings.vala"
	result = self->priv->_zoom_level;
#line 28 "../src/settings.vala"
	return result;
#line 457 "settings.c"
}

void
bookworm_app_settings_set_zoom_level (BookwormAppSettings* self,
                                      gdouble value)
{
	gdouble old_value;
#line 28 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 28 "../src/settings.vala"
	old_value = bookworm_app_settings_get_zoom_level (self);
#line 28 "../src/settings.vala"
	if (old_value != value) {
#line 28 "../src/settings.vala"
		self->priv->_zoom_level = value;
#line 28 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_ZOOM_LEVEL_PROPERTY]);
#line 475 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_reading_profile (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "../src/settings.vala"
	_tmp0_ = self->priv->_reading_profile;
#line 29 "../src/settings.vala"
	result = _tmp0_;
#line 29 "../src/settings.vala"
	return result;
#line 492 "settings.c"
}

void
bookworm_app_settings_set_reading_profile (BookwormAppSettings* self,
                                           const gchar* value)
{
	gchar* old_value;
#line 29 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 29 "../src/settings.vala"
	old_value = bookworm_app_settings_get_reading_profile (self);
#line 29 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 506 "settings.c"
		gchar* _tmp0_;
#line 29 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 29 "../src/settings.vala"
		_g_free0 (self->priv->_reading_profile);
#line 29 "../src/settings.vala"
		self->priv->_reading_profile = _tmp0_;
#line 29 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_PROFILE_PROPERTY]);
#line 516 "settings.c"
	}
}

gboolean
bookworm_app_settings_get_is_dark_theme_enabled (BookwormAppSettings* self)
{
	gboolean result;
#line 30 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 30 "../src/settings.vala"
	result = self->priv->_is_dark_theme_enabled;
#line 30 "../src/settings.vala"
	return result;
#line 530 "settings.c"
}

void
bookworm_app_settings_set_is_dark_theme_enabled (BookwormAppSettings* self,
                                                 gboolean value)
{
	gboolean old_value;
#line 30 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 30 "../src/settings.vala"
	old_value = bookworm_app_settings_get_is_dark_theme_enabled (self);
#line 30 "../src/settings.vala"
	if (old_value != value) {
#line 30 "../src/settings.vala"
		self->priv->_is_dark_theme_enabled = value;
#line 30 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_DARK_THEME_ENABLED_PROPERTY]);
#line 548 "settings.c"
	}
}

gboolean
bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self)
{
	gboolean result;
#line 31 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 31 "../src/settings.vala"
	result = self->priv->_is_local_storage_enabled;
#line 31 "../src/settings.vala"
	return result;
#line 562 "settings.c"
}

void
bookworm_app_settings_set_is_local_storage_enabled (BookwormAppSettings* self,
                                                    gboolean value)
{
	gboolean old_value;
#line 31 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 31 "../src/settings.vala"
	old_value = bookworm_app_settings_get_is_local_storage_enabled (self);
#line 31 "../src/settings.vala"
	if (old_value != value) {
#line 31 "../src/settings.vala"
		self->priv->_is_local_storage_enabled = value;
#line 31 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_LOCAL_STORAGE_ENABLED_PROPERTY]);
#line 580 "settings.c"
	}
}

gboolean
bookworm_app_settings_get_is_show_library_on_start (BookwormAppSettings* self)
{
	gboolean result;
#line 32 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 32 "../src/settings.vala"
	result = self->priv->_is_show_library_on_start;
#line 32 "../src/settings.vala"
	return result;
#line 594 "settings.c"
}

void
bookworm_app_settings_set_is_show_library_on_start (BookwormAppSettings* self,
                                                    gboolean value)
{
	gboolean old_value;
#line 32 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 32 "../src/settings.vala"
	old_value = bookworm_app_settings_get_is_show_library_on_start (self);
#line 32 "../src/settings.vala"
	if (old_value != value) {
#line 32 "../src/settings.vala"
		self->priv->_is_show_library_on_start = value;
#line 32 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_SHOW_LIBRARY_ON_START_PROPERTY]);
#line 612 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_reading_width (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 33 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "../src/settings.vala"
	_tmp0_ = self->priv->_reading_width;
#line 33 "../src/settings.vala"
	result = _tmp0_;
#line 33 "../src/settings.vala"
	return result;
#line 629 "settings.c"
}

void
bookworm_app_settings_set_reading_width (BookwormAppSettings* self,
                                         const gchar* value)
{
	gchar* old_value;
#line 33 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 33 "../src/settings.vala"
	old_value = bookworm_app_settings_get_reading_width (self);
#line 33 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 643 "settings.c"
		gchar* _tmp0_;
#line 33 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 33 "../src/settings.vala"
		_g_free0 (self->priv->_reading_width);
#line 33 "../src/settings.vala"
		self->priv->_reading_width = _tmp0_;
#line 33 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_WIDTH_PROPERTY]);
#line 653 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_reading_line_height (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 34 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "../src/settings.vala"
	_tmp0_ = self->priv->_reading_line_height;
#line 34 "../src/settings.vala"
	result = _tmp0_;
#line 34 "../src/settings.vala"
	return result;
#line 670 "settings.c"
}

void
bookworm_app_settings_set_reading_line_height (BookwormAppSettings* self,
                                               const gchar* value)
{
	gchar* old_value;
#line 34 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 34 "../src/settings.vala"
	old_value = bookworm_app_settings_get_reading_line_height (self);
#line 34 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 684 "settings.c"
		gchar* _tmp0_;
#line 34 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../src/settings.vala"
		_g_free0 (self->priv->_reading_line_height);
#line 34 "../src/settings.vala"
		self->priv->_reading_line_height = _tmp0_;
#line 34 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_LINE_HEIGHT_PROPERTY]);
#line 694 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_text_alignment (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 35 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "../src/settings.vala"
	_tmp0_ = self->priv->_text_alignment;
#line 35 "../src/settings.vala"
	result = _tmp0_;
#line 35 "../src/settings.vala"
	return result;
#line 711 "settings.c"
}

void
bookworm_app_settings_set_text_alignment (BookwormAppSettings* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 35 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 35 "../src/settings.vala"
	old_value = bookworm_app_settings_get_text_alignment (self);
#line 35 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 725 "settings.c"
		gchar* _tmp0_;
#line 35 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 35 "../src/settings.vala"
		_g_free0 (self->priv->_text_alignment);
#line 35 "../src/settings.vala"
		self->priv->_text_alignment = _tmp0_;
#line 35 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_TEXT_ALIGNMENT_PROPERTY]);
#line 735 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_library_view_mode (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 36 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "../src/settings.vala"
	_tmp0_ = self->priv->_library_view_mode;
#line 36 "../src/settings.vala"
	result = _tmp0_;
#line 36 "../src/settings.vala"
	return result;
#line 752 "settings.c"
}

void
bookworm_app_settings_set_library_view_mode (BookwormAppSettings* self,
                                             const gchar* value)
{
	gchar* old_value;
#line 36 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 36 "../src/settings.vala"
	old_value = bookworm_app_settings_get_library_view_mode (self);
#line 36 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 766 "settings.c"
		gchar* _tmp0_;
#line 36 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 36 "../src/settings.vala"
		_g_free0 (self->priv->_library_view_mode);
#line 36 "../src/settings.vala"
		self->priv->_library_view_mode = _tmp0_;
#line 36 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIBRARY_VIEW_MODE_PROPERTY]);
#line 776 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_reading_font_name (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 37 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "../src/settings.vala"
	_tmp0_ = self->priv->_reading_font_name;
#line 37 "../src/settings.vala"
	result = _tmp0_;
#line 37 "../src/settings.vala"
	return result;
#line 793 "settings.c"
}

void
bookworm_app_settings_set_reading_font_name (BookwormAppSettings* self,
                                             const gchar* value)
{
	gchar* old_value;
#line 37 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 37 "../src/settings.vala"
	old_value = bookworm_app_settings_get_reading_font_name (self);
#line 37 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 807 "settings.c"
		gchar* _tmp0_;
#line 37 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 37 "../src/settings.vala"
		_g_free0 (self->priv->_reading_font_name);
#line 37 "../src/settings.vala"
		self->priv->_reading_font_name = _tmp0_;
#line 37 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_FONT_NAME_PROPERTY]);
#line 817 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_reading_font_name_family (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 38 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../src/settings.vala"
	_tmp0_ = self->priv->_reading_font_name_family;
#line 38 "../src/settings.vala"
	result = _tmp0_;
#line 38 "../src/settings.vala"
	return result;
#line 834 "settings.c"
}

void
bookworm_app_settings_set_reading_font_name_family (BookwormAppSettings* self,
                                                    const gchar* value)
{
	gchar* old_value;
#line 38 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 38 "../src/settings.vala"
	old_value = bookworm_app_settings_get_reading_font_name_family (self);
#line 38 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 848 "settings.c"
		gchar* _tmp0_;
#line 38 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 38 "../src/settings.vala"
		_g_free0 (self->priv->_reading_font_name_family);
#line 38 "../src/settings.vala"
		self->priv->_reading_font_name_family = _tmp0_;
#line 38 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_FONT_NAME_FAMILY_PROPERTY]);
#line 858 "settings.c"
	}
}

gint
bookworm_app_settings_get_reading_font_size (BookwormAppSettings* self)
{
	gint result;
#line 39 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "../src/settings.vala"
	result = self->priv->_reading_font_size;
#line 39 "../src/settings.vala"
	return result;
#line 872 "settings.c"
}

void
bookworm_app_settings_set_reading_font_size (BookwormAppSettings* self,
                                             gint value)
{
	gint old_value;
#line 39 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 39 "../src/settings.vala"
	old_value = bookworm_app_settings_get_reading_font_size (self);
#line 39 "../src/settings.vala"
	if (old_value != value) {
#line 39 "../src/settings.vala"
		self->priv->_reading_font_size = value;
#line 39 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_FONT_SIZE_PROPERTY]);
#line 890 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_list_of_profile_colors (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 40 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "../src/settings.vala"
	_tmp0_ = self->priv->_list_of_profile_colors;
#line 40 "../src/settings.vala"
	result = _tmp0_;
#line 40 "../src/settings.vala"
	return result;
#line 907 "settings.c"
}

void
bookworm_app_settings_set_list_of_profile_colors (BookwormAppSettings* self,
                                                  const gchar* value)
{
	gchar* old_value;
#line 40 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 40 "../src/settings.vala"
	old_value = bookworm_app_settings_get_list_of_profile_colors (self);
#line 40 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 921 "settings.c"
		gchar* _tmp0_;
#line 40 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 40 "../src/settings.vala"
		_g_free0 (self->priv->_list_of_profile_colors);
#line 40 "../src/settings.vala"
		self->priv->_list_of_profile_colors = _tmp0_;
#line 40 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIST_OF_PROFILE_COLORS_PROPERTY]);
#line 931 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_list_of_scan_dirs (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 41 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "../src/settings.vala"
	_tmp0_ = self->priv->_list_of_scan_dirs;
#line 41 "../src/settings.vala"
	result = _tmp0_;
#line 41 "../src/settings.vala"
	return result;
#line 948 "settings.c"
}

void
bookworm_app_settings_set_list_of_scan_dirs (BookwormAppSettings* self,
                                             const gchar* value)
{
	gchar* old_value;
#line 41 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 41 "../src/settings.vala"
	old_value = bookworm_app_settings_get_list_of_scan_dirs (self);
#line 41 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 962 "settings.c"
		gchar* _tmp0_;
#line 41 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 41 "../src/settings.vala"
		_g_free0 (self->priv->_list_of_scan_dirs);
#line 41 "../src/settings.vala"
		self->priv->_list_of_scan_dirs = _tmp0_;
#line 41 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIST_OF_SCAN_DIRS_PROPERTY]);
#line 972 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_book_being_read (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 42 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../src/settings.vala"
	_tmp0_ = self->priv->_book_being_read;
#line 42 "../src/settings.vala"
	result = _tmp0_;
#line 42 "../src/settings.vala"
	return result;
#line 989 "settings.c"
}

void
bookworm_app_settings_set_book_being_read (BookwormAppSettings* self,
                                           const gchar* value)
{
	gchar* old_value;
#line 42 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 42 "../src/settings.vala"
	old_value = bookworm_app_settings_get_book_being_read (self);
#line 42 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1003 "settings.c"
		gchar* _tmp0_;
#line 42 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 42 "../src/settings.vala"
		_g_free0 (self->priv->_book_being_read);
#line 42 "../src/settings.vala"
		self->priv->_book_being_read = _tmp0_;
#line 42 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_BOOK_BEING_READ_PROPERTY]);
#line 1013 "settings.c"
	}
}

gboolean
bookworm_app_settings_get_is_two_page_enabled (BookwormAppSettings* self)
{
	gboolean result;
#line 43 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "../src/settings.vala"
	result = self->priv->_is_two_page_enabled;
#line 43 "../src/settings.vala"
	return result;
#line 1027 "settings.c"
}

void
bookworm_app_settings_set_is_two_page_enabled (BookwormAppSettings* self,
                                               gboolean value)
{
	gboolean old_value;
#line 43 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 43 "../src/settings.vala"
	old_value = bookworm_app_settings_get_is_two_page_enabled (self);
#line 43 "../src/settings.vala"
	if (old_value != value) {
#line 43 "../src/settings.vala"
		self->priv->_is_two_page_enabled = value;
#line 43 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_TWO_PAGE_ENABLED_PROPERTY]);
#line 1045 "settings.c"
	}
}

const gchar*
bookworm_app_settings_get_current_info_tab (BookwormAppSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 44 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../src/settings.vala"
	_tmp0_ = self->priv->_current_info_tab;
#line 44 "../src/settings.vala"
	result = _tmp0_;
#line 44 "../src/settings.vala"
	return result;
#line 1062 "settings.c"
}

void
bookworm_app_settings_set_current_info_tab (BookwormAppSettings* self,
                                            const gchar* value)
{
	gchar* old_value;
#line 44 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 44 "../src/settings.vala"
	old_value = bookworm_app_settings_get_current_info_tab (self);
#line 44 "../src/settings.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1076 "settings.c"
		gchar* _tmp0_;
#line 44 "../src/settings.vala"
		_tmp0_ = g_strdup (value);
#line 44 "../src/settings.vala"
		_g_free0 (self->priv->_current_info_tab);
#line 44 "../src/settings.vala"
		self->priv->_current_info_tab = _tmp0_;
#line 44 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_CURRENT_INFO_TAB_PROPERTY]);
#line 1086 "settings.c"
	}
}

gboolean
bookworm_app_settings_get_is_fullscreen (BookwormAppSettings* self)
{
	gboolean result;
#line 45 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 45 "../src/settings.vala"
	result = self->priv->_is_fullscreen;
#line 45 "../src/settings.vala"
	return result;
#line 1100 "settings.c"
}

void
bookworm_app_settings_set_is_fullscreen (BookwormAppSettings* self,
                                         gboolean value)
{
	gboolean old_value;
#line 45 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 45 "../src/settings.vala"
	old_value = bookworm_app_settings_get_is_fullscreen (self);
#line 45 "../src/settings.vala"
	if (old_value != value) {
#line 45 "../src/settings.vala"
		self->priv->_is_fullscreen = value;
#line 45 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_FULLSCREEN_PROPERTY]);
#line 1118 "settings.c"
	}
}

gint
bookworm_app_settings_get_library_page_items (BookwormAppSettings* self)
{
	gint result;
#line 46 "../src/settings.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "../src/settings.vala"
	result = self->priv->_library_page_items;
#line 46 "../src/settings.vala"
	return result;
#line 1132 "settings.c"
}

void
bookworm_app_settings_set_library_page_items (BookwormAppSettings* self,
                                              gint value)
{
	gint old_value;
#line 46 "../src/settings.vala"
	g_return_if_fail (self != NULL);
#line 46 "../src/settings.vala"
	old_value = bookworm_app_settings_get_library_page_items (self);
#line 46 "../src/settings.vala"
	if (old_value != value) {
#line 46 "../src/settings.vala"
		self->priv->_library_page_items = value;
#line 46 "../src/settings.vala"
		g_object_notify_by_pspec ((GObject *) self, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIBRARY_PAGE_ITEMS_PROPERTY]);
#line 1150 "settings.c"
	}
}

static void
bookworm_app_settings_class_init (BookwormAppSettingsClass * klass,
                                  gpointer klass_data)
{
#line 20 "../src/settings.vala"
	bookworm_app_settings_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/settings.vala"
	g_type_class_adjust_private_offset (klass, &BookwormAppSettings_private_offset);
#line 20 "../src/settings.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_bookworm_app_settings_get_property;
#line 20 "../src/settings.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_bookworm_app_settings_set_property;
#line 20 "../src/settings.vala"
	G_OBJECT_CLASS (klass)->finalize = bookworm_app_settings_finalize;
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_WINDOW_WIDTH_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_WINDOW_HEIGHT_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_POS_X_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_POS_X_PROPERTY] = g_param_spec_int ("pos-x", "pos-x", "pos-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_POS_Y_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_POS_Y_PROPERTY] = g_param_spec_int ("pos-y", "pos-y", "pos-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_WINDOW_IS_MAXIMIZED_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_WINDOW_IS_MAXIMIZED_PROPERTY] = g_param_spec_boolean ("window-is-maximized", "window-is-maximized", "window-is-maximized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_ZOOM_LEVEL_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_ZOOM_LEVEL_PROPERTY] = g_param_spec_double ("zoom-level", "zoom-level", "zoom-level", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_READING_PROFILE_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_PROFILE_PROPERTY] = g_param_spec_string ("reading-profile", "reading-profile", "reading-profile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_IS_DARK_THEME_ENABLED_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_DARK_THEME_ENABLED_PROPERTY] = g_param_spec_boolean ("is-dark-theme-enabled", "is-dark-theme-enabled", "is-dark-theme-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_IS_LOCAL_STORAGE_ENABLED_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_LOCAL_STORAGE_ENABLED_PROPERTY] = g_param_spec_boolean ("is-local-storage-enabled", "is-local-storage-enabled", "is-local-storage-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_IS_SHOW_LIBRARY_ON_START_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_SHOW_LIBRARY_ON_START_PROPERTY] = g_param_spec_boolean ("is-show-library-on-start", "is-show-library-on-start", "is-show-library-on-start", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_READING_WIDTH_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_WIDTH_PROPERTY] = g_param_spec_string ("reading-width", "reading-width", "reading-width", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_READING_LINE_HEIGHT_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_LINE_HEIGHT_PROPERTY] = g_param_spec_string ("reading-line-height", "reading-line-height", "reading-line-height", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_TEXT_ALIGNMENT_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_TEXT_ALIGNMENT_PROPERTY] = g_param_spec_string ("text-alignment", "text-alignment", "text-alignment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_LIBRARY_VIEW_MODE_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIBRARY_VIEW_MODE_PROPERTY] = g_param_spec_string ("library-view-mode", "library-view-mode", "library-view-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_READING_FONT_NAME_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_FONT_NAME_PROPERTY] = g_param_spec_string ("reading-font-name", "reading-font-name", "reading-font-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_READING_FONT_NAME_FAMILY_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_FONT_NAME_FAMILY_PROPERTY] = g_param_spec_string ("reading-font-name-family", "reading-font-name-family", "reading-font-name-family", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_READING_FONT_SIZE_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_READING_FONT_SIZE_PROPERTY] = g_param_spec_int ("reading-font-size", "reading-font-size", "reading-font-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_LIST_OF_PROFILE_COLORS_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIST_OF_PROFILE_COLORS_PROPERTY] = g_param_spec_string ("list-of-profile-colors", "list-of-profile-colors", "list-of-profile-colors", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_LIST_OF_SCAN_DIRS_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIST_OF_SCAN_DIRS_PROPERTY] = g_param_spec_string ("list-of-scan-dirs", "list-of-scan-dirs", "list-of-scan-dirs", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_BOOK_BEING_READ_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_BOOK_BEING_READ_PROPERTY] = g_param_spec_string ("book-being-read", "book-being-read", "book-being-read", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_IS_TWO_PAGE_ENABLED_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_TWO_PAGE_ENABLED_PROPERTY] = g_param_spec_boolean ("is-two-page-enabled", "is-two-page-enabled", "is-two-page-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_CURRENT_INFO_TAB_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_CURRENT_INFO_TAB_PROPERTY] = g_param_spec_string ("current-info-tab", "current-info-tab", "current-info-tab", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_IS_FULLSCREEN_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_IS_FULLSCREEN_PROPERTY] = g_param_spec_boolean ("is-fullscreen", "is-fullscreen", "is-fullscreen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "../src/settings.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKWORM_APP_SETTINGS_LIBRARY_PAGE_ITEMS_PROPERTY, bookworm_app_settings_properties[BOOKWORM_APP_SETTINGS_LIBRARY_PAGE_ITEMS_PROPERTY] = g_param_spec_int ("library-page-items", "library-page-items", "library-page-items", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1216 "settings.c"
}

static void
bookworm_app_settings_instance_init (BookwormAppSettings * self,
                                     gpointer klass)
{
#line 20 "../src/settings.vala"
	self->priv = bookworm_app_settings_get_instance_private (self);
#line 1225 "settings.c"
}

static void
bookworm_app_settings_finalize (GObject * obj)
{
	BookwormAppSettings * self;
#line 20 "../src/settings.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings);
#line 29 "../src/settings.vala"
	_g_free0 (self->priv->_reading_profile);
#line 33 "../src/settings.vala"
	_g_free0 (self->priv->_reading_width);
#line 34 "../src/settings.vala"
	_g_free0 (self->priv->_reading_line_height);
#line 35 "../src/settings.vala"
	_g_free0 (self->priv->_text_alignment);
#line 36 "../src/settings.vala"
	_g_free0 (self->priv->_library_view_mode);
#line 37 "../src/settings.vala"
	_g_free0 (self->priv->_reading_font_name);
#line 38 "../src/settings.vala"
	_g_free0 (self->priv->_reading_font_name_family);
#line 40 "../src/settings.vala"
	_g_free0 (self->priv->_list_of_profile_colors);
#line 41 "../src/settings.vala"
	_g_free0 (self->priv->_list_of_scan_dirs);
#line 42 "../src/settings.vala"
	_g_free0 (self->priv->_book_being_read);
#line 44 "../src/settings.vala"
	_g_free0 (self->priv->_current_info_tab);
#line 20 "../src/settings.vala"
	G_OBJECT_CLASS (bookworm_app_settings_parent_class)->finalize (obj);
#line 1258 "settings.c"
}

static GType
bookworm_app_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppSettings), 0, (GInstanceInitFunc) bookworm_app_settings_instance_init, NULL };
	GType bookworm_app_settings_type_id;
	bookworm_app_settings_type_id = g_type_register_static (GRANITE_SERVICES_TYPE_SETTINGS, "BookwormAppSettings", &g_define_type_info, 0);
	BookwormAppSettings_private_offset = g_type_add_instance_private (bookworm_app_settings_type_id, sizeof (BookwormAppSettingsPrivate));
	return bookworm_app_settings_type_id;
}

GType
bookworm_app_settings_get_type (void)
{
	static volatile gsize bookworm_app_settings_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_settings_type_id__once)) {
		GType bookworm_app_settings_type_id;
		bookworm_app_settings_type_id = bookworm_app_settings_get_type_once ();
		g_once_init_leave (&bookworm_app_settings_type_id__once, bookworm_app_settings_type_id);
	}
	return bookworm_app_settings_type_id__once;
}

static void
_vala_bookworm_app_settings_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BookwormAppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings);
#line 20 "../src/settings.vala"
	switch (property_id) {
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_WINDOW_WIDTH_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_int (value, bookworm_app_settings_get_window_width (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_WINDOW_HEIGHT_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_int (value, bookworm_app_settings_get_window_height (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_POS_X_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_int (value, bookworm_app_settings_get_pos_x (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_POS_Y_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_int (value, bookworm_app_settings_get_pos_y (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_WINDOW_IS_MAXIMIZED_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_boolean (value, bookworm_app_settings_get_window_is_maximized (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_ZOOM_LEVEL_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_double (value, bookworm_app_settings_get_zoom_level (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_PROFILE_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_reading_profile (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_DARK_THEME_ENABLED_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_boolean (value, bookworm_app_settings_get_is_dark_theme_enabled (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_LOCAL_STORAGE_ENABLED_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_boolean (value, bookworm_app_settings_get_is_local_storage_enabled (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_SHOW_LIBRARY_ON_START_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_boolean (value, bookworm_app_settings_get_is_show_library_on_start (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_WIDTH_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_reading_width (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_LINE_HEIGHT_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_reading_line_height (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_TEXT_ALIGNMENT_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_text_alignment (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIBRARY_VIEW_MODE_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_library_view_mode (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_FONT_NAME_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_reading_font_name (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_FONT_NAME_FAMILY_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_reading_font_name_family (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_FONT_SIZE_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_int (value, bookworm_app_settings_get_reading_font_size (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIST_OF_PROFILE_COLORS_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_list_of_profile_colors (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIST_OF_SCAN_DIRS_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_list_of_scan_dirs (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_BOOK_BEING_READ_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_book_being_read (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_TWO_PAGE_ENABLED_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_boolean (value, bookworm_app_settings_get_is_two_page_enabled (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_CURRENT_INFO_TAB_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_string (value, bookworm_app_settings_get_current_info_tab (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_FULLSCREEN_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_boolean (value, bookworm_app_settings_get_is_fullscreen (self));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIBRARY_PAGE_ITEMS_PROPERTY:
#line 20 "../src/settings.vala"
		g_value_set_int (value, bookworm_app_settings_get_library_page_items (self));
#line 20 "../src/settings.vala"
		break;
#line 1437 "settings.c"
		default:
#line 20 "../src/settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/settings.vala"
		break;
#line 1443 "settings.c"
	}
}

static void
_vala_bookworm_app_settings_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BookwormAppSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings);
#line 20 "../src/settings.vala"
	switch (property_id) {
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_WINDOW_WIDTH_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_window_width (self, g_value_get_int (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_WINDOW_HEIGHT_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_window_height (self, g_value_get_int (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_POS_X_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_pos_x (self, g_value_get_int (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_POS_Y_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_pos_y (self, g_value_get_int (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_WINDOW_IS_MAXIMIZED_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_window_is_maximized (self, g_value_get_boolean (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_ZOOM_LEVEL_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_zoom_level (self, g_value_get_double (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_PROFILE_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_reading_profile (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_DARK_THEME_ENABLED_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_is_dark_theme_enabled (self, g_value_get_boolean (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_LOCAL_STORAGE_ENABLED_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_is_local_storage_enabled (self, g_value_get_boolean (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_SHOW_LIBRARY_ON_START_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_is_show_library_on_start (self, g_value_get_boolean (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_WIDTH_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_reading_width (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_LINE_HEIGHT_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_reading_line_height (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_TEXT_ALIGNMENT_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_text_alignment (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIBRARY_VIEW_MODE_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_library_view_mode (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_FONT_NAME_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_reading_font_name (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_FONT_NAME_FAMILY_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_reading_font_name_family (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_READING_FONT_SIZE_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_reading_font_size (self, g_value_get_int (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIST_OF_PROFILE_COLORS_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_list_of_profile_colors (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIST_OF_SCAN_DIRS_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_list_of_scan_dirs (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_BOOK_BEING_READ_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_book_being_read (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_TWO_PAGE_ENABLED_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_is_two_page_enabled (self, g_value_get_boolean (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_CURRENT_INFO_TAB_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_current_info_tab (self, g_value_get_string (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_IS_FULLSCREEN_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_is_fullscreen (self, g_value_get_boolean (value));
#line 20 "../src/settings.vala"
		break;
#line 20 "../src/settings.vala"
		case BOOKWORM_APP_SETTINGS_LIBRARY_PAGE_ITEMS_PROPERTY:
#line 20 "../src/settings.vala"
		bookworm_app_settings_set_library_page_items (self, g_value_get_int (value));
#line 20 "../src/settings.vala"
		break;
#line 1601 "settings.c"
		default:
#line 20 "../src/settings.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/settings.vala"
		break;
#line 1607 "settings.c"
	}
}

