/* TabbedWebView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TabbedWebView.vala, do not modify */

/*
* Copyright 2016-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
*/

#include <webkit/webkit.h>
#include <glib-object.h>
#include <glib.h>
#include <gcr/gcr.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CAPTIVE_TYPE_TABBED_WEB_VIEW (captive_tabbed_web_view_get_type ())
#define CAPTIVE_TABBED_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView))
#define CAPTIVE_TABBED_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebViewClass))
#define CAPTIVE_IS_TABBED_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPTIVE_TYPE_TABBED_WEB_VIEW))
#define CAPTIVE_IS_TABBED_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPTIVE_TYPE_TABBED_WEB_VIEW))
#define CAPTIVE_TABBED_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebViewClass))

typedef struct _CaptiveTabbedWebView CaptiveTabbedWebView;
typedef struct _CaptiveTabbedWebViewClass CaptiveTabbedWebViewClass;
typedef struct _CaptiveTabbedWebViewPrivate CaptiveTabbedWebViewPrivate;
typedef enum  {
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT
} CaptiveTabbedWebViewSecurity;

#define CAPTIVE_TABBED_WEB_VIEW_TYPE_SECURITY (captive_tabbed_web_view_security_get_type ())
enum  {
	CAPTIVE_TABBED_WEB_VIEW_0_PROPERTY,
	CAPTIVE_TABBED_WEB_VIEW_LOAD_COOKIES_PROPERTY,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_PROPERTY,
	CAPTIVE_TABBED_WEB_VIEW_CERTIFICATE_PROPERTY,
	CAPTIVE_TABBED_WEB_VIEW_NUM_PROPERTIES
};
static GParamSpec* captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CaptiveTabbedWebView {
	WebKitWebView parent_instance;
	CaptiveTabbedWebViewPrivate * priv;
};

struct _CaptiveTabbedWebViewClass {
	WebKitWebViewClass parent_class;
};

struct _CaptiveTabbedWebViewPrivate {
	gboolean _load_cookies;
	CaptiveTabbedWebViewSecurity _security;
	GcrSimpleCertificate* _certificate;
};

static gint CaptiveTabbedWebView_private_offset;
static gpointer captive_tabbed_web_view_parent_class = NULL;

VALA_EXTERN GType captive_tabbed_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CaptiveTabbedWebView, g_object_unref)
VALA_EXTERN GType captive_tabbed_web_view_security_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* captive_tabbed_web_view_security_to_icon_name (CaptiveTabbedWebViewSecurity self);
VALA_EXTERN CaptiveTabbedWebView* captive_tabbed_web_view_new (gboolean load_cookies);
VALA_EXTERN CaptiveTabbedWebView* captive_tabbed_web_view_construct (GType object_type,
                                                         gboolean load_cookies);
VALA_EXTERN gchar* captive_tabbed_web_view_security_to_string (CaptiveTabbedWebView* self);
VALA_EXTERN CaptiveTabbedWebViewSecurity captive_tabbed_web_view_get_security (CaptiveTabbedWebView* self);
static void captive_tabbed_web_view_update_tls_info (CaptiveTabbedWebView* self);
static void captive_tabbed_web_view_set_certificate (CaptiveTabbedWebView* self,
                                              GcrSimpleCertificate* value);
static void captive_tabbed_web_view_set_security (CaptiveTabbedWebView* self,
                                           CaptiveTabbedWebViewSecurity value);
VALA_EXTERN gboolean captive_tabbed_web_view_get_load_cookies (CaptiveTabbedWebView* self);
static void captive_tabbed_web_view_set_load_cookies (CaptiveTabbedWebView* self,
                                               gboolean value);
VALA_EXTERN GcrSimpleCertificate* captive_tabbed_web_view_get_certificate (CaptiveTabbedWebView* self);
static GObject * captive_tabbed_web_view_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _captive_tabbed_web_view___lambda4_ (CaptiveTabbedWebView* self);
static void __captive_tabbed_web_view___lambda4__webkit_web_view_insecure_content_detected (WebKitWebView* _sender,
                                                                                     WebKitInsecureContentEvent event,
                                                                                     gpointer self);
static void _captive_tabbed_web_view___lambda5_ (CaptiveTabbedWebView* self,
                                          WebKitWebView* view,
                                          WebKitLoadEvent event);
static void __captive_tabbed_web_view___lambda5__webkit_web_view_load_changed (WebKitWebView* _sender,
                                                                        WebKitLoadEvent load_event,
                                                                        gpointer self);
static void captive_tabbed_web_view_finalize (GObject * obj);
static GType captive_tabbed_web_view_get_type_once (void);
static void _vala_captive_tabbed_web_view_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_captive_tabbed_web_view_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
captive_tabbed_web_view_get_instance_private (CaptiveTabbedWebView* self)
{
	return G_STRUCT_MEMBER_P (self, CaptiveTabbedWebView_private_offset);
}

gchar*
captive_tabbed_web_view_security_to_icon_name (CaptiveTabbedWebViewSecurity self)
{
	gchar* result;
	switch (self) {
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("security-low-symbolic");
			result = _tmp0_;
			return result;
		}
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("security-high-symbolic");
			result = _tmp1_;
			return result;
		}
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("security-medium-symbolic");
			result = _tmp2_;
			return result;
		}
		default:
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("content-loading-symbolic");
			result = _tmp3_;
			return result;
		}
	}
}

static GType
captive_tabbed_web_view_security_get_type_once (void)
{
	static const GEnumValue values[] = {{CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE, "CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE", "none"}, {CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE, "CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE", "secure"}, {CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING, "CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING", "loading"}, {CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT, "CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT", "mixed-content"}, {0, NULL, NULL}};
	GType captive_tabbed_web_view_security_type_id;
	captive_tabbed_web_view_security_type_id = g_enum_register_static ("CaptiveTabbedWebViewSecurity", values);
	return captive_tabbed_web_view_security_type_id;
}

GType
captive_tabbed_web_view_security_get_type (void)
{
	static volatile gsize captive_tabbed_web_view_security_type_id__once = 0;
	if (g_once_init_enter (&captive_tabbed_web_view_security_type_id__once)) {
		GType captive_tabbed_web_view_security_type_id;
		captive_tabbed_web_view_security_type_id = captive_tabbed_web_view_security_get_type_once ();
		g_once_init_leave (&captive_tabbed_web_view_security_type_id__once, captive_tabbed_web_view_security_type_id);
	}
	return captive_tabbed_web_view_security_type_id__once;
}

CaptiveTabbedWebView*
captive_tabbed_web_view_construct (GType object_type,
                                   gboolean load_cookies)
{
	CaptiveTabbedWebView * self = NULL;
	self = (CaptiveTabbedWebView*) g_object_new (object_type, "load-cookies", load_cookies, NULL);
	return self;
}

CaptiveTabbedWebView*
captive_tabbed_web_view_new (gboolean load_cookies)
{
	return captive_tabbed_web_view_construct (CAPTIVE_TYPE_TABBED_WEB_VIEW, load_cookies);
}

gchar*
captive_tabbed_web_view_security_to_string (CaptiveTabbedWebView* self)
{
	CaptiveTabbedWebViewSecurity _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_security;
	switch (_tmp0_) {
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = webkit_web_view_get_uri ((WebKitWebView*) self);
			_tmp2_ = g_strdup_printf (_ ("“%s” is served over an unprotected connection"), _tmp1_);
			result = _tmp2_;
			return result;
		}
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = webkit_web_view_get_uri ((WebKitWebView*) self);
			_tmp4_ = g_strdup_printf (_ ("“%s” is served over a protected connection"), _tmp3_);
			result = _tmp4_;
			return result;
		}
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = webkit_web_view_get_uri ((WebKitWebView*) self);
			_tmp6_ = g_strdup_printf (_ ("Some elements of “%s” are served over an unprotected connection"), _tmp5_);
			result = _tmp6_;
			return result;
		}
		default:
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Loading captive portal"));
			result = _tmp7_;
			return result;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
captive_tabbed_web_view_update_tls_info (CaptiveTabbedWebView* self)
{
	GTlsCertificate* cert = NULL;
	GTlsCertificateFlags cert_flags = 0U;
	gboolean is_secure = FALSE;
	GTlsCertificate* _tmp0_ = NULL;
	GTlsCertificateFlags _tmp1_ = 0U;
	gboolean _tmp2_;
	GTlsCertificate* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp2_ = webkit_web_view_get_tls_info ((WebKitWebView*) self, &_tmp0_, &_tmp1_);
	_g_object_unref0 (cert);
	_tmp3_ = _g_object_ref0 (_tmp0_);
	cert = _tmp3_;
	cert_flags = _tmp1_;
	if (!_tmp2_) {
		is_secure = FALSE;
		captive_tabbed_web_view_set_certificate (self, NULL);
	} else {
		GTlsCertificate* _tmp4_;
		GByteArray* _tmp5_;
		GByteArray* _tmp6_;
		GByteArray* _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		GcrSimpleCertificate* _tmp9_;
		GcrSimpleCertificate* _tmp10_;
		is_secure = cert_flags == 0;
		_tmp4_ = cert;
		g_object_get (_tmp4_, "certificate", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->data;
		_tmp8__length1 = _tmp7_->len;
		_tmp9_ = (GcrSimpleCertificate*) gcr_simple_certificate_new (_tmp8_, _tmp8__length1);
		_tmp10_ = _tmp9_;
		captive_tabbed_web_view_set_certificate (self, _tmp10_);
		_g_object_unref0 (_tmp10_);
		_g_byte_array_unref0 (_tmp7_);
	}
	if (is_secure) {
		captive_tabbed_web_view_set_security (self, CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE);
	} else {
		captive_tabbed_web_view_set_security (self, CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE);
	}
	_g_object_unref0 (cert);
}

gboolean
captive_tabbed_web_view_get_load_cookies (CaptiveTabbedWebView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_load_cookies;
	return result;
}

static void
captive_tabbed_web_view_set_load_cookies (CaptiveTabbedWebView* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = captive_tabbed_web_view_get_load_cookies (self);
	if (old_value != value) {
		self->priv->_load_cookies = value;
		g_object_notify_by_pspec ((GObject *) self, captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_LOAD_COOKIES_PROPERTY]);
	}
}

CaptiveTabbedWebViewSecurity
captive_tabbed_web_view_get_security (CaptiveTabbedWebView* self)
{
	CaptiveTabbedWebViewSecurity result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_security;
	return result;
}

static void
captive_tabbed_web_view_set_security (CaptiveTabbedWebView* self,
                                      CaptiveTabbedWebViewSecurity value)
{
	CaptiveTabbedWebViewSecurity old_value;
	g_return_if_fail (self != NULL);
	old_value = captive_tabbed_web_view_get_security (self);
	if (old_value != value) {
		self->priv->_security = value;
		g_object_notify_by_pspec ((GObject *) self, captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_SECURITY_PROPERTY]);
	}
}

GcrSimpleCertificate*
captive_tabbed_web_view_get_certificate (CaptiveTabbedWebView* self)
{
	GcrSimpleCertificate* result;
	GcrSimpleCertificate* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_certificate;
	result = _tmp0_;
	return result;
}

static void
captive_tabbed_web_view_set_certificate (CaptiveTabbedWebView* self,
                                         GcrSimpleCertificate* value)
{
	GcrSimpleCertificate* old_value;
	g_return_if_fail (self != NULL);
	old_value = captive_tabbed_web_view_get_certificate (self);
	if (old_value != value) {
		GcrSimpleCertificate* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_certificate);
		self->priv->_certificate = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_CERTIFICATE_PROPERTY]);
	}
}

static void
_captive_tabbed_web_view___lambda4_ (CaptiveTabbedWebView* self)
{
	captive_tabbed_web_view_set_security (self, CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT);
}

static void
__captive_tabbed_web_view___lambda4__webkit_web_view_insecure_content_detected (WebKitWebView* _sender,
                                                                                WebKitInsecureContentEvent event,
                                                                                gpointer self)
{
	_captive_tabbed_web_view___lambda4_ ((CaptiveTabbedWebView*) self);
}

static void
_captive_tabbed_web_view___lambda5_ (CaptiveTabbedWebView* self,
                                     WebKitWebView* view,
                                     WebKitLoadEvent event)
{
	g_return_if_fail (view != NULL);
	switch (event) {
		case WEBKIT_LOAD_STARTED:
		{
			captive_tabbed_web_view_set_security (self, CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING);
			break;
		}
		case WEBKIT_LOAD_COMMITTED:
		{
			captive_tabbed_web_view_update_tls_info (self);
			break;
		}
		default:
		break;
	}
}

static void
__captive_tabbed_web_view___lambda5__webkit_web_view_load_changed (WebKitWebView* _sender,
                                                                   WebKitLoadEvent load_event,
                                                                   gpointer self)
{
	_captive_tabbed_web_view___lambda5_ ((CaptiveTabbedWebView*) self, _sender, load_event);
}

static GObject *
captive_tabbed_web_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CaptiveTabbedWebView * self;
	gboolean _tmp0_;
	parent_class = G_OBJECT_CLASS (captive_tabbed_web_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView);
	_tmp0_ = self->priv->_load_cookies;
	if (_tmp0_) {
		gchar* cookies_db_path = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_build_path (G_DIR_SEPARATOR_S, _tmp1_, "epiphany", "cookies.sqlite", NULL);
		cookies_db_path = _tmp2_;
		_tmp3_ = cookies_db_path;
		if (g_file_test (_tmp3_, G_FILE_TEST_IS_REGULAR)) {
			WebKitCookieManager* cookie_manager = NULL;
			WebKitNetworkSession* _tmp4_;
			WebKitNetworkSession* _tmp5_;
			WebKitCookieManager* _tmp6_;
			WebKitCookieManager* _tmp7_;
			WebKitCookieManager* _tmp8_;
			WebKitCookieManager* _tmp9_;
			const gchar* _tmp10_;
			_tmp4_ = webkit_web_view_get_network_session ((WebKitWebView*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = webkit_network_session_get_cookie_manager (_tmp5_);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			cookie_manager = _tmp7_;
			_tmp8_ = cookie_manager;
			webkit_cookie_manager_set_accept_policy (_tmp8_, WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS);
			_tmp9_ = cookie_manager;
			_tmp10_ = cookies_db_path;
			webkit_cookie_manager_set_persistent_storage (_tmp9_, _tmp10_, WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE);
			_g_object_unref0 (cookie_manager);
		} else {
			g_critical ("TabbedWebView.vala:69: No cookies store found, not saving the cookies…");
		}
		_g_free0 (cookies_db_path);
	}
	g_signal_connect_object ((WebKitWebView*) self, "insecure-content-detected", (GCallback) __captive_tabbed_web_view___lambda4__webkit_web_view_insecure_content_detected, self, 0);
	g_signal_connect_object ((WebKitWebView*) self, "load-changed", (GCallback) __captive_tabbed_web_view___lambda5__webkit_web_view_load_changed, self, 0);
	return obj;
}

static void
captive_tabbed_web_view_class_init (CaptiveTabbedWebViewClass * klass,
                                    gpointer klass_data)
{
	captive_tabbed_web_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CaptiveTabbedWebView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_captive_tabbed_web_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_captive_tabbed_web_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = captive_tabbed_web_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = captive_tabbed_web_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAPTIVE_TABBED_WEB_VIEW_LOAD_COOKIES_PROPERTY, captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_LOAD_COOKIES_PROPERTY] = g_param_spec_boolean ("load-cookies", "load-cookies", "load-cookies", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAPTIVE_TABBED_WEB_VIEW_SECURITY_PROPERTY, captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_SECURITY_PROPERTY] = g_param_spec_enum ("security", "security", "security", CAPTIVE_TABBED_WEB_VIEW_TYPE_SECURITY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAPTIVE_TABBED_WEB_VIEW_CERTIFICATE_PROPERTY, captive_tabbed_web_view_properties[CAPTIVE_TABBED_WEB_VIEW_CERTIFICATE_PROPERTY] = g_param_spec_object ("certificate", "certificate", "certificate", gcr_simple_certificate_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
captive_tabbed_web_view_instance_init (CaptiveTabbedWebView * self,
                                       gpointer klass)
{
	self->priv = captive_tabbed_web_view_get_instance_private (self);
	self->priv->_certificate = NULL;
}

static void
captive_tabbed_web_view_finalize (GObject * obj)
{
	CaptiveTabbedWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView);
	_g_object_unref0 (self->priv->_certificate);
	G_OBJECT_CLASS (captive_tabbed_web_view_parent_class)->finalize (obj);
}

static GType
captive_tabbed_web_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaptiveTabbedWebViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) captive_tabbed_web_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaptiveTabbedWebView), 0, (GInstanceInitFunc) captive_tabbed_web_view_instance_init, NULL };
	GType captive_tabbed_web_view_type_id;
	captive_tabbed_web_view_type_id = g_type_register_static (webkit_web_view_get_type (), "CaptiveTabbedWebView", &g_define_type_info, 0);
	CaptiveTabbedWebView_private_offset = g_type_add_instance_private (captive_tabbed_web_view_type_id, sizeof (CaptiveTabbedWebViewPrivate));
	return captive_tabbed_web_view_type_id;
}

GType
captive_tabbed_web_view_get_type (void)
{
	static volatile gsize captive_tabbed_web_view_type_id__once = 0;
	if (g_once_init_enter (&captive_tabbed_web_view_type_id__once)) {
		GType captive_tabbed_web_view_type_id;
		captive_tabbed_web_view_type_id = captive_tabbed_web_view_get_type_once ();
		g_once_init_leave (&captive_tabbed_web_view_type_id__once, captive_tabbed_web_view_type_id);
	}
	return captive_tabbed_web_view_type_id__once;
}

static void
_vala_captive_tabbed_web_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	CaptiveTabbedWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView);
	switch (property_id) {
		case CAPTIVE_TABBED_WEB_VIEW_LOAD_COOKIES_PROPERTY:
		g_value_set_boolean (value, captive_tabbed_web_view_get_load_cookies (self));
		break;
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_PROPERTY:
		g_value_set_enum (value, captive_tabbed_web_view_get_security (self));
		break;
		case CAPTIVE_TABBED_WEB_VIEW_CERTIFICATE_PROPERTY:
		g_value_set_object (value, captive_tabbed_web_view_get_certificate (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_captive_tabbed_web_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	CaptiveTabbedWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView);
	switch (property_id) {
		case CAPTIVE_TABBED_WEB_VIEW_LOAD_COOKIES_PROPERTY:
		captive_tabbed_web_view_set_load_cookies (self, g_value_get_boolean (value));
		break;
		case CAPTIVE_TABBED_WEB_VIEW_SECURITY_PROPERTY:
		captive_tabbed_web_view_set_security (self, g_value_get_enum (value));
		break;
		case CAPTIVE_TABBED_WEB_VIEW_CERTIFICATE_PROPERTY:
		captive_tabbed_web_view_set_certificate (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

