
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genLttngProvider.py

******************************************************************/


#define TRACEPOINT_DEFINE
#define TRACEPOINT_PROBE_DYNAMIC_LINKAGE

#include "stdlib.h"
#include "pal_mstypes.h"
#include "pal_error.h"
#include "pal.h"
#define PAL_free free
#define PAL_realloc realloc
#include "pal/stackstring.hpp"
#include "tpdotnetruntimeprivate.h"

#ifndef tracepoint_enabled

extern "C" bool XplatEventLoggerIsEnabled();

#define tracepoint_enabled(provider, name) XplatEventLoggerIsEnabled()
#define do_tracepoint tracepoint
#endif

#define wcslen PAL_wcslen

bool ResizeBuffer(char *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, char *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

extern "C" BOOL  EventXplatEnabledGCDecision(){ return tracepoint_enabled(DotNETRuntimePrivate, GCDecision); }

extern "C" ULONG  FireEtXplatGCDecision(
    const BOOL DoCompact)
{
    if (!EventXplatEnabledGCDecision())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCDecision,
        DoCompact);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCDecision_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCDecision_V1); }

extern "C" ULONG  FireEtXplatGCDecision_V1(
    const BOOL DoCompact,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCDecision_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCDecision_V1,
        DoCompact,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSettings(){ return tracepoint_enabled(DotNETRuntimePrivate, GCSettings); }

extern "C" ULONG  FireEtXplatGCSettings(
    const unsigned __int64 SegmentSize,
    const unsigned __int64 LargeObjectSegmentSize,
    const BOOL ServerGC)
{
    if (!EventXplatEnabledGCSettings())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCSettings,
        SegmentSize,
        LargeObjectSegmentSize,
        ServerGC);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCSettings_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCSettings_V1); }

extern "C" ULONG  FireEtXplatGCSettings_V1(
    const unsigned __int64 SegmentSize,
    const unsigned __int64 LargeObjectSegmentSize,
    const BOOL ServerGC,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCSettings_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCSettings_V1,
        SegmentSize,
        LargeObjectSegmentSize,
        ServerGC,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCOptimized(){ return tracepoint_enabled(DotNETRuntimePrivate, GCOptimized); }

extern "C" ULONG  FireEtXplatGCOptimized(
    const unsigned __int64 DesiredAllocation,
    const unsigned __int64 NewAllocation,
    const unsigned int GenerationNumber)
{
    if (!EventXplatEnabledGCOptimized())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCOptimized,
        DesiredAllocation,
        NewAllocation,
        GenerationNumber);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCOptimized_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCOptimized_V1); }

extern "C" ULONG  FireEtXplatGCOptimized_V1(
    const unsigned __int64 DesiredAllocation,
    const unsigned __int64 NewAllocation,
    const unsigned int GenerationNumber,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCOptimized_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCOptimized_V1,
        DesiredAllocation,
        NewAllocation,
        GenerationNumber,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCPerHeapHistory(){ return tracepoint_enabled(DotNETRuntimePrivate, GCPerHeapHistory); }

extern "C" ULONG  FireEtXplatGCPerHeapHistory(
)
{
    if (!EventXplatEnabledGCPerHeapHistory())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCPerHeapHistory);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCPerHeapHistory_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCPerHeapHistory_V1); }

extern "C" ULONG  FireEtXplatGCPerHeapHistory_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCPerHeapHistory_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCPerHeapHistory_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCGlobalHeapHistory(){ return tracepoint_enabled(DotNETRuntimePrivate, GCGlobalHeapHistory); }

extern "C" ULONG  FireEtXplatGCGlobalHeapHistory(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms)
{
    if (!EventXplatEnabledGCGlobalHeapHistory())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCGlobalHeapHistory,
        FinalYoungestDesired,
        NumHeaps,
        CondemnedGeneration,
        Gen0ReductionCount,
        Reason,
        GlobalMechanisms);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCGlobalHeapHistory_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCGlobalHeapHistory_V1); }

extern "C" ULONG  FireEtXplatGCGlobalHeapHistory_V1(
    const unsigned __int64 FinalYoungestDesired,
    const signed int NumHeaps,
    const unsigned int CondemnedGeneration,
    const unsigned int Gen0ReductionCount,
    const unsigned int Reason,
    const unsigned int GlobalMechanisms,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCGlobalHeapHistory_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCGlobalHeapHistory_V1,
        FinalYoungestDesired,
        NumHeaps,
        CondemnedGeneration,
        Gen0ReductionCount,
        Reason,
        GlobalMechanisms,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCJoin(){ return tracepoint_enabled(DotNETRuntimePrivate, GCJoin); }

extern "C" ULONG  FireEtXplatGCJoin(
    const unsigned int Heap,
    const unsigned int JoinTime,
    const unsigned int JoinType)
{
    if (!EventXplatEnabledGCJoin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCJoin,
        Heap,
        JoinTime,
        JoinType);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCJoin_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCJoin_V1); }

extern "C" ULONG  FireEtXplatGCJoin_V1(
    const unsigned int Heap,
    const unsigned int JoinTime,
    const unsigned int JoinType,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCJoin_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCJoin_V1,
        Heap,
        JoinTime,
        JoinType,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkStackRoots(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkStackRoots); }

extern "C" ULONG  FireEtXplatPrvGCMarkStackRoots(
    const unsigned int HeapNum)
{
    if (!EventXplatEnabledPrvGCMarkStackRoots())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkStackRoots,
        HeapNum);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkStackRoots_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkStackRoots_V1); }

extern "C" ULONG  FireEtXplatPrvGCMarkStackRoots_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrvGCMarkStackRoots_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkStackRoots_V1,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkFinalizeQueueRoots(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkFinalizeQueueRoots); }

extern "C" ULONG  FireEtXplatPrvGCMarkFinalizeQueueRoots(
    const unsigned int HeapNum)
{
    if (!EventXplatEnabledPrvGCMarkFinalizeQueueRoots())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkFinalizeQueueRoots,
        HeapNum);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkFinalizeQueueRoots_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkFinalizeQueueRoots_V1); }

extern "C" ULONG  FireEtXplatPrvGCMarkFinalizeQueueRoots_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrvGCMarkFinalizeQueueRoots_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkFinalizeQueueRoots_V1,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkHandles(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkHandles); }

extern "C" ULONG  FireEtXplatPrvGCMarkHandles(
    const unsigned int HeapNum)
{
    if (!EventXplatEnabledPrvGCMarkHandles())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkHandles,
        HeapNum);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkHandles_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkHandles_V1); }

extern "C" ULONG  FireEtXplatPrvGCMarkHandles_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrvGCMarkHandles_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkHandles_V1,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkCards(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkCards); }

extern "C" ULONG  FireEtXplatPrvGCMarkCards(
    const unsigned int HeapNum)
{
    if (!EventXplatEnabledPrvGCMarkCards())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkCards,
        HeapNum);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvGCMarkCards_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvGCMarkCards_V1); }

extern "C" ULONG  FireEtXplatPrvGCMarkCards_V1(
    const unsigned int HeapNum,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrvGCMarkCards_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvGCMarkCards_V1,
        HeapNum,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCBegin(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCBegin); }

extern "C" ULONG  FireEtXplatBGCBegin(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCBegin,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC1stNonConEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC1stNonConEnd); }

extern "C" ULONG  FireEtXplatBGC1stNonConEnd(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC1stNonConEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC1stNonConEnd,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC1stConEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC1stConEnd); }

extern "C" ULONG  FireEtXplatBGC1stConEnd(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC1stConEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC1stConEnd,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC2ndNonConBegin(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC2ndNonConBegin); }

extern "C" ULONG  FireEtXplatBGC2ndNonConBegin(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC2ndNonConBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC2ndNonConBegin,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC2ndNonConEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC2ndNonConEnd); }

extern "C" ULONG  FireEtXplatBGC2ndNonConEnd(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC2ndNonConEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC2ndNonConEnd,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC2ndConBegin(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC2ndConBegin); }

extern "C" ULONG  FireEtXplatBGC2ndConBegin(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC2ndConBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC2ndConBegin,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC2ndConEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC2ndConEnd); }

extern "C" ULONG  FireEtXplatBGC2ndConEnd(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC2ndConEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC2ndConEnd,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCPlanEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCPlanEnd); }

extern "C" ULONG  FireEtXplatBGCPlanEnd(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCPlanEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCPlanEnd,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCSweepEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCSweepEnd); }

extern "C" ULONG  FireEtXplatBGCSweepEnd(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCSweepEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCSweepEnd,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCDrainMark(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCDrainMark); }

extern "C" ULONG  FireEtXplatBGCDrainMark(
    const unsigned __int64 Objects,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCDrainMark())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCDrainMark,
        Objects,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCRevisit(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCRevisit); }

extern "C" ULONG  FireEtXplatBGCRevisit(
    const unsigned __int64 Pages,
    const unsigned __int64 Objects,
    const unsigned int IsLarge,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCRevisit())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCRevisit,
        Pages,
        Objects,
        IsLarge,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCOverflow(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCOverflow); }

extern "C" ULONG  FireEtXplatBGCOverflow(
    const unsigned __int64 Min,
    const unsigned __int64 Max,
    const unsigned __int64 Objects,
    const unsigned int IsLarge,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCOverflow())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCOverflow,
        Min,
        Max,
        Objects,
        IsLarge,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCOverflow_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCOverflow_V1); }

extern "C" ULONG  FireEtXplatBGCOverflow_V1(
    const unsigned __int64 Min,
    const unsigned __int64 Max,
    const unsigned __int64 Objects,
    const unsigned int IsLarge,
    const unsigned short ClrInstanceID,
    const unsigned int GenNumber)
{
    if (!EventXplatEnabledBGCOverflow_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCOverflow_V1,
        Min,
        Max,
        Objects,
        IsLarge,
        ClrInstanceID,
        GenNumber);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCAllocWaitBegin(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCAllocWaitBegin); }

extern "C" ULONG  FireEtXplatBGCAllocWaitBegin(
    const unsigned int Reason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCAllocWaitBegin())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCAllocWaitBegin,
        Reason,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGCAllocWaitEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGCAllocWaitEnd); }

extern "C" ULONG  FireEtXplatBGCAllocWaitEnd(
    const unsigned int Reason,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGCAllocWaitEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGCAllocWaitEnd,
        Reason,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFullNotify(){ return tracepoint_enabled(DotNETRuntimePrivate, GCFullNotify); }

extern "C" ULONG  FireEtXplatGCFullNotify(
    const unsigned int GenNumber,
    const unsigned int IsAlloc)
{
    if (!EventXplatEnabledGCFullNotify())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCFullNotify,
        GenNumber,
        IsAlloc);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGCFullNotify_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GCFullNotify_V1); }

extern "C" ULONG  FireEtXplatGCFullNotify_V1(
    const unsigned int GenNumber,
    const unsigned int IsAlloc,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGCFullNotify_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GCFullNotify_V1,
        GenNumber,
        IsAlloc,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBGC1stSweepEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BGC1stSweepEnd); }

extern "C" ULONG  FireEtXplatBGC1stSweepEnd(
    const unsigned int GenNumber,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBGC1stSweepEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BGC1stSweepEnd,
        GenNumber,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEStartupStart(){ return tracepoint_enabled(DotNETRuntimePrivate, EEStartupStart); }

extern "C" ULONG  FireEtXplatEEStartupStart(
)
{
    if (!EventXplatEnabledEEStartupStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEStartupStart);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEStartupStart_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, EEStartupStart_V1); }

extern "C" ULONG  FireEtXplatEEStartupStart_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEEStartupStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEStartupStart_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEStartupEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, EEStartupEnd); }

extern "C" ULONG  FireEtXplatEEStartupEnd(
)
{
    if (!EventXplatEnabledEEStartupEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEStartupEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEStartupEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, EEStartupEnd_V1); }

extern "C" ULONG  FireEtXplatEEStartupEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEEStartupEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEStartupEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSetup(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSetup); }

extern "C" ULONG  FireEtXplatEEConfigSetup(
)
{
    if (!EventXplatEnabledEEConfigSetup())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSetup);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSetup_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSetup_V1); }

extern "C" ULONG  FireEtXplatEEConfigSetup_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEEConfigSetup_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSetup_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSetupEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSetupEnd); }

extern "C" ULONG  FireEtXplatEEConfigSetupEnd(
)
{
    if (!EventXplatEnabledEEConfigSetupEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSetupEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSetupEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSetupEnd_V1); }

extern "C" ULONG  FireEtXplatEEConfigSetupEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEEConfigSetupEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSetupEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdSysBases(){ return tracepoint_enabled(DotNETRuntimePrivate, LdSysBases); }

extern "C" ULONG  FireEtXplatLdSysBases(
)
{
    if (!EventXplatEnabledLdSysBases())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdSysBases);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdSysBases_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, LdSysBases_V1); }

extern "C" ULONG  FireEtXplatLdSysBases_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLdSysBases_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdSysBases_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdSysBasesEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LdSysBasesEnd); }

extern "C" ULONG  FireEtXplatLdSysBasesEnd(
)
{
    if (!EventXplatEnabledLdSysBasesEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdSysBasesEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdSysBasesEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, LdSysBasesEnd_V1); }

extern "C" ULONG  FireEtXplatLdSysBasesEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLdSysBasesEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdSysBasesEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExecExe(){ return tracepoint_enabled(DotNETRuntimePrivate, ExecExe); }

extern "C" ULONG  FireEtXplatExecExe(
)
{
    if (!EventXplatEnabledExecExe())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExecExe);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExecExe_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ExecExe_V1); }

extern "C" ULONG  FireEtXplatExecExe_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExecExe_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExecExe_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExecExeEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, ExecExeEnd); }

extern "C" ULONG  FireEtXplatExecExeEnd(
)
{
    if (!EventXplatEnabledExecExeEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExecExeEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExecExeEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ExecExeEnd_V1); }

extern "C" ULONG  FireEtXplatExecExeEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExecExeEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExecExeEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMain(){ return tracepoint_enabled(DotNETRuntimePrivate, Main); }

extern "C" ULONG  FireEtXplatMain(
)
{
    if (!EventXplatEnabledMain())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        Main);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMain_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, Main_V1); }

extern "C" ULONG  FireEtXplatMain_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMain_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        Main_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMainEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, MainEnd); }

extern "C" ULONG  FireEtXplatMainEnd(
)
{
    if (!EventXplatEnabledMainEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        MainEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMainEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, MainEnd_V1); }

extern "C" ULONG  FireEtXplatMainEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMainEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        MainEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledApplyPolicyStart(){ return tracepoint_enabled(DotNETRuntimePrivate, ApplyPolicyStart); }

extern "C" ULONG  FireEtXplatApplyPolicyStart(
)
{
    if (!EventXplatEnabledApplyPolicyStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ApplyPolicyStart);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledApplyPolicyStart_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ApplyPolicyStart_V1); }

extern "C" ULONG  FireEtXplatApplyPolicyStart_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledApplyPolicyStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ApplyPolicyStart_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledApplyPolicyEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, ApplyPolicyEnd); }

extern "C" ULONG  FireEtXplatApplyPolicyEnd(
)
{
    if (!EventXplatEnabledApplyPolicyEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ApplyPolicyEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledApplyPolicyEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ApplyPolicyEnd_V1); }

extern "C" ULONG  FireEtXplatApplyPolicyEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledApplyPolicyEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ApplyPolicyEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdLibShFolder(){ return tracepoint_enabled(DotNETRuntimePrivate, LdLibShFolder); }

extern "C" ULONG  FireEtXplatLdLibShFolder(
)
{
    if (!EventXplatEnabledLdLibShFolder())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdLibShFolder);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdLibShFolder_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, LdLibShFolder_V1); }

extern "C" ULONG  FireEtXplatLdLibShFolder_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLdLibShFolder_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdLibShFolder_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdLibShFolderEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LdLibShFolderEnd); }

extern "C" ULONG  FireEtXplatLdLibShFolderEnd(
)
{
    if (!EventXplatEnabledLdLibShFolderEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdLibShFolderEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLdLibShFolderEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, LdLibShFolderEnd_V1); }

extern "C" ULONG  FireEtXplatLdLibShFolderEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLdLibShFolderEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LdLibShFolderEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrestubWorker(){ return tracepoint_enabled(DotNETRuntimePrivate, PrestubWorker); }

extern "C" ULONG  FireEtXplatPrestubWorker(
)
{
    if (!EventXplatEnabledPrestubWorker())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrestubWorker);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrestubWorker_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, PrestubWorker_V1); }

extern "C" ULONG  FireEtXplatPrestubWorker_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrestubWorker_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrestubWorker_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrestubWorkerEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, PrestubWorkerEnd); }

extern "C" ULONG  FireEtXplatPrestubWorkerEnd(
)
{
    if (!EventXplatEnabledPrestubWorkerEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrestubWorkerEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrestubWorkerEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, PrestubWorkerEnd_V1); }

extern "C" ULONG  FireEtXplatPrestubWorkerEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrestubWorkerEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrestubWorkerEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGetInstallationStart(){ return tracepoint_enabled(DotNETRuntimePrivate, GetInstallationStart); }

extern "C" ULONG  FireEtXplatGetInstallationStart(
)
{
    if (!EventXplatEnabledGetInstallationStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GetInstallationStart);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGetInstallationStart_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GetInstallationStart_V1); }

extern "C" ULONG  FireEtXplatGetInstallationStart_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGetInstallationStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GetInstallationStart_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGetInstallationEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, GetInstallationEnd); }

extern "C" ULONG  FireEtXplatGetInstallationEnd(
)
{
    if (!EventXplatEnabledGetInstallationEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GetInstallationEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGetInstallationEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, GetInstallationEnd_V1); }

extern "C" ULONG  FireEtXplatGetInstallationEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGetInstallationEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        GetInstallationEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledOpenHModule(){ return tracepoint_enabled(DotNETRuntimePrivate, OpenHModule); }

extern "C" ULONG  FireEtXplatOpenHModule(
)
{
    if (!EventXplatEnabledOpenHModule())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        OpenHModule);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledOpenHModule_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, OpenHModule_V1); }

extern "C" ULONG  FireEtXplatOpenHModule_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledOpenHModule_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        OpenHModule_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledOpenHModuleEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, OpenHModuleEnd); }

extern "C" ULONG  FireEtXplatOpenHModuleEnd(
)
{
    if (!EventXplatEnabledOpenHModuleEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        OpenHModuleEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledOpenHModuleEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, OpenHModuleEnd_V1); }

extern "C" ULONG  FireEtXplatOpenHModuleEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledOpenHModuleEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        OpenHModuleEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExplicitBindStart(){ return tracepoint_enabled(DotNETRuntimePrivate, ExplicitBindStart); }

extern "C" ULONG  FireEtXplatExplicitBindStart(
)
{
    if (!EventXplatEnabledExplicitBindStart())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExplicitBindStart);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExplicitBindStart_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ExplicitBindStart_V1); }

extern "C" ULONG  FireEtXplatExplicitBindStart_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExplicitBindStart_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExplicitBindStart_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExplicitBindEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, ExplicitBindEnd); }

extern "C" ULONG  FireEtXplatExplicitBindEnd(
)
{
    if (!EventXplatEnabledExplicitBindEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExplicitBindEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledExplicitBindEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ExplicitBindEnd_V1); }

extern "C" ULONG  FireEtXplatExplicitBindEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledExplicitBindEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ExplicitBindEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledParseXml(){ return tracepoint_enabled(DotNETRuntimePrivate, ParseXml); }

extern "C" ULONG  FireEtXplatParseXml(
)
{
    if (!EventXplatEnabledParseXml())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ParseXml);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledParseXml_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ParseXml_V1); }

extern "C" ULONG  FireEtXplatParseXml_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledParseXml_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ParseXml_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledParseXmlEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, ParseXmlEnd); }

extern "C" ULONG  FireEtXplatParseXmlEnd(
)
{
    if (!EventXplatEnabledParseXmlEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ParseXmlEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledParseXmlEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, ParseXmlEnd_V1); }

extern "C" ULONG  FireEtXplatParseXmlEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledParseXmlEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ParseXmlEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitDefaultDomain(){ return tracepoint_enabled(DotNETRuntimePrivate, InitDefaultDomain); }

extern "C" ULONG  FireEtXplatInitDefaultDomain(
)
{
    if (!EventXplatEnabledInitDefaultDomain())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitDefaultDomain);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitDefaultDomain_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, InitDefaultDomain_V1); }

extern "C" ULONG  FireEtXplatInitDefaultDomain_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledInitDefaultDomain_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitDefaultDomain_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitDefaultDomainEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, InitDefaultDomainEnd); }

extern "C" ULONG  FireEtXplatInitDefaultDomainEnd(
)
{
    if (!EventXplatEnabledInitDefaultDomainEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitDefaultDomainEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitDefaultDomainEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, InitDefaultDomainEnd_V1); }

extern "C" ULONG  FireEtXplatInitDefaultDomainEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledInitDefaultDomainEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitDefaultDomainEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitSecurity(){ return tracepoint_enabled(DotNETRuntimePrivate, InitSecurity); }

extern "C" ULONG  FireEtXplatInitSecurity(
)
{
    if (!EventXplatEnabledInitSecurity())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitSecurity);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitSecurity_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, InitSecurity_V1); }

extern "C" ULONG  FireEtXplatInitSecurity_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledInitSecurity_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitSecurity_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitSecurityEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, InitSecurityEnd); }

extern "C" ULONG  FireEtXplatInitSecurityEnd(
)
{
    if (!EventXplatEnabledInitSecurityEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitSecurityEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledInitSecurityEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, InitSecurityEnd_V1); }

extern "C" ULONG  FireEtXplatInitSecurityEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledInitSecurityEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        InitSecurityEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAllowBindingRedirs(){ return tracepoint_enabled(DotNETRuntimePrivate, AllowBindingRedirs); }

extern "C" ULONG  FireEtXplatAllowBindingRedirs(
)
{
    if (!EventXplatEnabledAllowBindingRedirs())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        AllowBindingRedirs);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAllowBindingRedirs_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, AllowBindingRedirs_V1); }

extern "C" ULONG  FireEtXplatAllowBindingRedirs_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAllowBindingRedirs_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        AllowBindingRedirs_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAllowBindingRedirsEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, AllowBindingRedirsEnd); }

extern "C" ULONG  FireEtXplatAllowBindingRedirsEnd(
)
{
    if (!EventXplatEnabledAllowBindingRedirsEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        AllowBindingRedirsEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAllowBindingRedirsEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, AllowBindingRedirsEnd_V1); }

extern "C" ULONG  FireEtXplatAllowBindingRedirsEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAllowBindingRedirsEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        AllowBindingRedirsEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSync(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSync); }

extern "C" ULONG  FireEtXplatEEConfigSync(
)
{
    if (!EventXplatEnabledEEConfigSync())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSync);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSync_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSync_V1); }

extern "C" ULONG  FireEtXplatEEConfigSync_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEEConfigSync_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSync_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSyncEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSyncEnd); }

extern "C" ULONG  FireEtXplatEEConfigSyncEnd(
)
{
    if (!EventXplatEnabledEEConfigSyncEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSyncEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEEConfigSyncEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, EEConfigSyncEnd_V1); }

extern "C" ULONG  FireEtXplatEEConfigSyncEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEEConfigSyncEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EEConfigSyncEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionBinding(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionBinding); }

extern "C" ULONG  FireEtXplatFusionBinding(
)
{
    if (!EventXplatEnabledFusionBinding())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionBinding);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionBinding_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionBinding_V1); }

extern "C" ULONG  FireEtXplatFusionBinding_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusionBinding_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionBinding_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionBindingEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionBindingEnd); }

extern "C" ULONG  FireEtXplatFusionBindingEnd(
)
{
    if (!EventXplatEnabledFusionBindingEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionBindingEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionBindingEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionBindingEnd_V1); }

extern "C" ULONG  FireEtXplatFusionBindingEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusionBindingEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionBindingEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderCatchCall(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderCatchCall); }

extern "C" ULONG  FireEtXplatLoaderCatchCall(
)
{
    if (!EventXplatEnabledLoaderCatchCall())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LoaderCatchCall);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderCatchCall_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderCatchCall_V1); }

extern "C" ULONG  FireEtXplatLoaderCatchCall_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderCatchCall_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LoaderCatchCall_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderCatchCallEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderCatchCallEnd); }

extern "C" ULONG  FireEtXplatLoaderCatchCallEnd(
)
{
    if (!EventXplatEnabledLoaderCatchCallEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LoaderCatchCallEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderCatchCallEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderCatchCallEnd_V1); }

extern "C" ULONG  FireEtXplatLoaderCatchCallEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderCatchCallEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        LoaderCatchCallEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionInit(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionInit); }

extern "C" ULONG  FireEtXplatFusionInit(
)
{
    if (!EventXplatEnabledFusionInit())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionInit);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionInit_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionInit_V1); }

extern "C" ULONG  FireEtXplatFusionInit_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusionInit_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionInit_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionInitEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionInitEnd); }

extern "C" ULONG  FireEtXplatFusionInitEnd(
)
{
    if (!EventXplatEnabledFusionInitEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionInitEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionInitEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionInitEnd_V1); }

extern "C" ULONG  FireEtXplatFusionInitEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusionInitEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionInitEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionAppCtx(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionAppCtx); }

extern "C" ULONG  FireEtXplatFusionAppCtx(
)
{
    if (!EventXplatEnabledFusionAppCtx())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionAppCtx);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionAppCtx_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionAppCtx_V1); }

extern "C" ULONG  FireEtXplatFusionAppCtx_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusionAppCtx_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionAppCtx_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionAppCtxEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionAppCtxEnd); }

extern "C" ULONG  FireEtXplatFusionAppCtxEnd(
)
{
    if (!EventXplatEnabledFusionAppCtxEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionAppCtxEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionAppCtxEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionAppCtxEnd_V1); }

extern "C" ULONG  FireEtXplatFusionAppCtxEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusionAppCtxEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionAppCtxEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusion2EE(){ return tracepoint_enabled(DotNETRuntimePrivate, Fusion2EE); }

extern "C" ULONG  FireEtXplatFusion2EE(
)
{
    if (!EventXplatEnabledFusion2EE())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        Fusion2EE);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusion2EE_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, Fusion2EE_V1); }

extern "C" ULONG  FireEtXplatFusion2EE_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusion2EE_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        Fusion2EE_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusion2EEEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, Fusion2EEEnd); }

extern "C" ULONG  FireEtXplatFusion2EEEnd(
)
{
    if (!EventXplatEnabledFusion2EEEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        Fusion2EEEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusion2EEEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, Fusion2EEEnd_V1); }

extern "C" ULONG  FireEtXplatFusion2EEEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFusion2EEEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        Fusion2EEEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledSecurityCatchCall(){ return tracepoint_enabled(DotNETRuntimePrivate, SecurityCatchCall); }

extern "C" ULONG  FireEtXplatSecurityCatchCall(
)
{
    if (!EventXplatEnabledSecurityCatchCall())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        SecurityCatchCall);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledSecurityCatchCall_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, SecurityCatchCall_V1); }

extern "C" ULONG  FireEtXplatSecurityCatchCall_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledSecurityCatchCall_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        SecurityCatchCall_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledSecurityCatchCallEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, SecurityCatchCallEnd); }

extern "C" ULONG  FireEtXplatSecurityCatchCallEnd(
)
{
    if (!EventXplatEnabledSecurityCatchCallEnd())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        SecurityCatchCallEnd);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledSecurityCatchCallEnd_V1(){ return tracepoint_enabled(DotNETRuntimePrivate, SecurityCatchCallEnd_V1); }

extern "C" ULONG  FireEtXplatSecurityCatchCallEnd_V1(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledSecurityCatchCallEnd_V1())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        SecurityCatchCallEnd_V1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCLRStackWalkPrivate(){ return tracepoint_enabled(DotNETRuntimePrivate, CLRStackWalkPrivate); }

extern "C" ULONG  FireEtXplatCLRStackWalkPrivate(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack)
{
    if (!EventXplatEnabledCLRStackWalkPrivate())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        CLRStackWalkPrivate,
        ClrInstanceID,
        Reserved1,
        Reserved2,
        FrameCount,
        (const size_t*) Stack);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleRangeLoadPrivate(){ return tracepoint_enabled(DotNETRuntimePrivate, ModuleRangeLoadPrivate); }

extern "C" ULONG  FireEtXplatModuleRangeLoadPrivate(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned int RangeBegin,
    const unsigned int RangeSize,
    const unsigned char RangeType,
    const unsigned char IBCType,
    const unsigned short SectionType)
{
    if (!EventXplatEnabledModuleRangeLoadPrivate())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        ModuleRangeLoadPrivate,
        ClrInstanceID,
        ModuleID,
        RangeBegin,
        RangeSize,
        RangeType,
        IBCType,
        SectionType);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingPolicyPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingPolicyPhaseStart); }

extern "C" ULONG  FireEtXplatBindingPolicyPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingPolicyPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingPolicyPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingPolicyPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingPolicyPhaseEnd); }

extern "C" ULONG  FireEtXplatBindingPolicyPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingPolicyPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingPolicyPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingNgenPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingNgenPhaseStart); }

extern "C" ULONG  FireEtXplatBindingNgenPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingNgenPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingNgenPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingNgenPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingNgenPhaseEnd); }

extern "C" ULONG  FireEtXplatBindingNgenPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingNgenPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingNgenPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingLookupAndProbingPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingLookupAndProbingPhaseStart); }

extern "C" ULONG  FireEtXplatBindingLookupAndProbingPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingLookupAndProbingPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingLookupAndProbingPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingLookupAndProbingPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingLookupAndProbingPhaseEnd); }

extern "C" ULONG  FireEtXplatBindingLookupAndProbingPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingLookupAndProbingPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingLookupAndProbingPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderPhaseStart); }

extern "C" ULONG  FireEtXplatLoaderPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderPhaseEnd); }

extern "C" ULONG  FireEtXplatLoaderPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingPhaseStart); }

extern "C" ULONG  FireEtXplatBindingPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingPhaseEnd); }

extern "C" ULONG  FireEtXplatBindingPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingDownloadPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingDownloadPhaseStart); }

extern "C" ULONG  FireEtXplatBindingDownloadPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingDownloadPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingDownloadPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBindingDownloadPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, BindingDownloadPhaseEnd); }

extern "C" ULONG  FireEtXplatBindingDownloadPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBindingDownloadPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        BindingDownloadPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderAssemblyInitPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderAssemblyInitPhaseStart); }

extern "C" ULONG  FireEtXplatLoaderAssemblyInitPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderAssemblyInitPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderAssemblyInitPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderAssemblyInitPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderAssemblyInitPhaseEnd); }

extern "C" ULONG  FireEtXplatLoaderAssemblyInitPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderAssemblyInitPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderAssemblyInitPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderMappingPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderMappingPhaseStart); }

extern "C" ULONG  FireEtXplatLoaderMappingPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderMappingPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderMappingPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderMappingPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderMappingPhaseEnd); }

extern "C" ULONG  FireEtXplatLoaderMappingPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderMappingPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderMappingPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderDeliverEventsPhaseStart(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderDeliverEventsPhaseStart); }

extern "C" ULONG  FireEtXplatLoaderDeliverEventsPhaseStart(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderDeliverEventsPhaseStart())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderDeliverEventsPhaseStart,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledLoaderDeliverEventsPhaseEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, LoaderDeliverEventsPhaseEnd); }

extern "C" ULONG  FireEtXplatLoaderDeliverEventsPhaseEnd(
    const unsigned int AppDomainID,
    const unsigned int LoadContextID,
    const unsigned int FromLoaderCache,
    const unsigned int DynamicLoad,
    PCWSTR AssemblyCodebase,
    PCWSTR AssemblyName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledLoaderDeliverEventsPhaseEnd())
        return ERROR_SUCCESS;
    INT AssemblyCodebase_path_size = -1;
    PathCharString AssemblyCodebase_PS;
    INT AssemblyCodebase_full_name_path_size = (wcslen(AssemblyCodebase) + 1)*sizeof(WCHAR);
    CHAR* AssemblyCodebase_full_name = AssemblyCodebase_PS.OpenStringBuffer(AssemblyCodebase_full_name_path_size );
    if (AssemblyCodebase_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyCodebase_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyCodebase, -1, AssemblyCodebase_full_name, AssemblyCodebase_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyCodebase_path_size < AssemblyCodebase_full_name_path_size );
    AssemblyCodebase_PS.CloseBuffer(AssemblyCodebase_path_size );
    if( AssemblyCodebase_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        LoaderDeliverEventsPhaseEnd,
        AppDomainID,
        LoadContextID,
        FromLoaderCache,
        DynamicLoad,
        AssemblyCodebase_full_name,
        AssemblyName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEvidenceGenerated(){ return tracepoint_enabled(DotNETRuntimePrivate, EvidenceGenerated); }

extern "C" ULONG  FireEtXplatEvidenceGenerated(
    const unsigned int Type,
    const unsigned int AppDomain,
    PCWSTR ILImage,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEvidenceGenerated())
        return ERROR_SUCCESS;
    INT ILImage_path_size = -1;
    PathCharString ILImage_PS;
    INT ILImage_full_name_path_size = (wcslen(ILImage) + 1)*sizeof(WCHAR);
    CHAR* ILImage_full_name = ILImage_PS.OpenStringBuffer(ILImage_full_name_path_size );
    if (ILImage_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ILImage_path_size = WideCharToMultiByte( CP_ACP, 0, ILImage, -1, ILImage_full_name, ILImage_full_name_path_size, NULL, NULL );
    _ASSERTE(ILImage_path_size < ILImage_full_name_path_size );
    ILImage_PS.CloseBuffer(ILImage_path_size );
    if( ILImage_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        EvidenceGenerated,
        Type,
        AppDomain,
        ILImage_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleTransparencyComputationStart(){ return tracepoint_enabled(DotNETRuntimePrivate, ModuleTransparencyComputationStart); }

extern "C" ULONG  FireEtXplatModuleTransparencyComputationStart(
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledModuleTransparencyComputationStart())
        return ERROR_SUCCESS;
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        ModuleTransparencyComputationStart,
        Module_full_name,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledModuleTransparencyComputationEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, ModuleTransparencyComputationEnd); }

extern "C" ULONG  FireEtXplatModuleTransparencyComputationEnd(
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsAllCritical,
    const BOOL IsAllTransparent,
    const BOOL IsTreatAsSafe,
    const BOOL IsOpportunisticallyCritical,
    const unsigned int SecurityRuleSet,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledModuleTransparencyComputationEnd())
        return ERROR_SUCCESS;
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        ModuleTransparencyComputationEnd,
        Module_full_name,
        AppDomainID,
        IsAllCritical,
        IsAllTransparent,
        IsTreatAsSafe,
        IsOpportunisticallyCritical,
        SecurityRuleSet,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTypeTransparencyComputationStart(){ return tracepoint_enabled(DotNETRuntimePrivate, TypeTransparencyComputationStart); }

extern "C" ULONG  FireEtXplatTypeTransparencyComputationStart(
    PCWSTR Type,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledTypeTransparencyComputationStart())
        return ERROR_SUCCESS;
    INT Type_path_size = -1;
    PathCharString Type_PS;
    INT Type_full_name_path_size = (wcslen(Type) + 1)*sizeof(WCHAR);
    CHAR* Type_full_name = Type_PS.OpenStringBuffer(Type_full_name_path_size );
    if (Type_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Type_path_size = WideCharToMultiByte( CP_ACP, 0, Type, -1, Type_full_name, Type_full_name_path_size, NULL, NULL );
    _ASSERTE(Type_path_size < Type_full_name_path_size );
    Type_PS.CloseBuffer(Type_path_size );
    if( Type_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        TypeTransparencyComputationStart,
        Type_full_name,
        Module_full_name,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTypeTransparencyComputationEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, TypeTransparencyComputationEnd); }

extern "C" ULONG  FireEtXplatTypeTransparencyComputationEnd(
    PCWSTR Type,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsAllCritical,
    const BOOL IsAllTransparent,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledTypeTransparencyComputationEnd())
        return ERROR_SUCCESS;
    INT Type_path_size = -1;
    PathCharString Type_PS;
    INT Type_full_name_path_size = (wcslen(Type) + 1)*sizeof(WCHAR);
    CHAR* Type_full_name = Type_PS.OpenStringBuffer(Type_full_name_path_size );
    if (Type_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Type_path_size = WideCharToMultiByte( CP_ACP, 0, Type, -1, Type_full_name, Type_full_name_path_size, NULL, NULL );
    _ASSERTE(Type_path_size < Type_full_name_path_size );
    Type_PS.CloseBuffer(Type_path_size );
    if( Type_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        TypeTransparencyComputationEnd,
        Type_full_name,
        Module_full_name,
        AppDomainID,
        IsAllCritical,
        IsAllTransparent,
        IsCritical,
        IsTreatAsSafe,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodTransparencyComputationStart(){ return tracepoint_enabled(DotNETRuntimePrivate, MethodTransparencyComputationStart); }

extern "C" ULONG  FireEtXplatMethodTransparencyComputationStart(
    PCWSTR Method,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodTransparencyComputationStart())
        return ERROR_SUCCESS;
    INT Method_path_size = -1;
    PathCharString Method_PS;
    INT Method_full_name_path_size = (wcslen(Method) + 1)*sizeof(WCHAR);
    CHAR* Method_full_name = Method_PS.OpenStringBuffer(Method_full_name_path_size );
    if (Method_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Method_path_size = WideCharToMultiByte( CP_ACP, 0, Method, -1, Method_full_name, Method_full_name_path_size, NULL, NULL );
    _ASSERTE(Method_path_size < Method_full_name_path_size );
    Method_PS.CloseBuffer(Method_path_size );
    if( Method_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        MethodTransparencyComputationStart,
        Method_full_name,
        Module_full_name,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMethodTransparencyComputationEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, MethodTransparencyComputationEnd); }

extern "C" ULONG  FireEtXplatMethodTransparencyComputationEnd(
    PCWSTR Method,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledMethodTransparencyComputationEnd())
        return ERROR_SUCCESS;
    INT Method_path_size = -1;
    PathCharString Method_PS;
    INT Method_full_name_path_size = (wcslen(Method) + 1)*sizeof(WCHAR);
    CHAR* Method_full_name = Method_PS.OpenStringBuffer(Method_full_name_path_size );
    if (Method_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Method_path_size = WideCharToMultiByte( CP_ACP, 0, Method, -1, Method_full_name, Method_full_name_path_size, NULL, NULL );
    _ASSERTE(Method_path_size < Method_full_name_path_size );
    Method_PS.CloseBuffer(Method_path_size );
    if( Method_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        MethodTransparencyComputationEnd,
        Method_full_name,
        Module_full_name,
        AppDomainID,
        IsCritical,
        IsTreatAsSafe,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFieldTransparencyComputationStart(){ return tracepoint_enabled(DotNETRuntimePrivate, FieldTransparencyComputationStart); }

extern "C" ULONG  FireEtXplatFieldTransparencyComputationStart(
    PCWSTR Field,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFieldTransparencyComputationStart())
        return ERROR_SUCCESS;
    INT Field_path_size = -1;
    PathCharString Field_PS;
    INT Field_full_name_path_size = (wcslen(Field) + 1)*sizeof(WCHAR);
    CHAR* Field_full_name = Field_PS.OpenStringBuffer(Field_full_name_path_size );
    if (Field_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Field_path_size = WideCharToMultiByte( CP_ACP, 0, Field, -1, Field_full_name, Field_full_name_path_size, NULL, NULL );
    _ASSERTE(Field_path_size < Field_full_name_path_size );
    Field_PS.CloseBuffer(Field_path_size );
    if( Field_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        FieldTransparencyComputationStart,
        Field_full_name,
        Module_full_name,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFieldTransparencyComputationEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, FieldTransparencyComputationEnd); }

extern "C" ULONG  FireEtXplatFieldTransparencyComputationEnd(
    PCWSTR Field,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFieldTransparencyComputationEnd())
        return ERROR_SUCCESS;
    INT Field_path_size = -1;
    PathCharString Field_PS;
    INT Field_full_name_path_size = (wcslen(Field) + 1)*sizeof(WCHAR);
    CHAR* Field_full_name = Field_PS.OpenStringBuffer(Field_full_name_path_size );
    if (Field_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Field_path_size = WideCharToMultiByte( CP_ACP, 0, Field, -1, Field_full_name, Field_full_name_path_size, NULL, NULL );
    _ASSERTE(Field_path_size < Field_full_name_path_size );
    Field_PS.CloseBuffer(Field_path_size );
    if( Field_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        FieldTransparencyComputationEnd,
        Field_full_name,
        Module_full_name,
        AppDomainID,
        IsCritical,
        IsTreatAsSafe,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTokenTransparencyComputationStart(){ return tracepoint_enabled(DotNETRuntimePrivate, TokenTransparencyComputationStart); }

extern "C" ULONG  FireEtXplatTokenTransparencyComputationStart(
    const unsigned int Token,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledTokenTransparencyComputationStart())
        return ERROR_SUCCESS;
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        TokenTransparencyComputationStart,
        Token,
        Module_full_name,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledTokenTransparencyComputationEnd(){ return tracepoint_enabled(DotNETRuntimePrivate, TokenTransparencyComputationEnd); }

extern "C" ULONG  FireEtXplatTokenTransparencyComputationEnd(
    const unsigned int Token,
    PCWSTR Module,
    const unsigned int AppDomainID,
    const BOOL IsCritical,
    const BOOL IsTreatAsSafe,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledTokenTransparencyComputationEnd())
        return ERROR_SUCCESS;
    INT Module_path_size = -1;
    PathCharString Module_PS;
    INT Module_full_name_path_size = (wcslen(Module) + 1)*sizeof(WCHAR);
    CHAR* Module_full_name = Module_PS.OpenStringBuffer(Module_full_name_path_size );
    if (Module_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Module_path_size = WideCharToMultiByte( CP_ACP, 0, Module, -1, Module_full_name, Module_full_name_path_size, NULL, NULL );
    _ASSERTE(Module_path_size < Module_full_name_path_size );
    Module_PS.CloseBuffer(Module_path_size );
    if( Module_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        TokenTransparencyComputationEnd,
        Token,
        Module_full_name,
        AppDomainID,
        IsCritical,
        IsTreatAsSafe,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledNgenBindEvent(){ return tracepoint_enabled(DotNETRuntimePrivate, NgenBindEvent); }

extern "C" ULONG  FireEtXplatNgenBindEvent(
    const unsigned short ClrInstanceID,
    const unsigned __int64 BindingID,
    const unsigned int ReasonCode,
    PCWSTR AssemblyName)
{
    if (!EventXplatEnabledNgenBindEvent())
        return ERROR_SUCCESS;
    INT AssemblyName_path_size = -1;
    PathCharString AssemblyName_PS;
    INT AssemblyName_full_name_path_size = (wcslen(AssemblyName) + 1)*sizeof(WCHAR);
    CHAR* AssemblyName_full_name = AssemblyName_PS.OpenStringBuffer(AssemblyName_full_name_path_size );
    if (AssemblyName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    AssemblyName_path_size = WideCharToMultiByte( CP_ACP, 0, AssemblyName, -1, AssemblyName_full_name, AssemblyName_full_name_path_size, NULL, NULL );
    _ASSERTE(AssemblyName_path_size < AssemblyName_full_name_path_size );
    AssemblyName_PS.CloseBuffer(AssemblyName_path_size );
    if( AssemblyName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        NgenBindEvent,
        ClrInstanceID,
        BindingID,
        ReasonCode,
        AssemblyName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFailFast(){ return tracepoint_enabled(DotNETRuntimePrivate, FailFast); }

extern "C" ULONG  FireEtXplatFailFast(
    PCWSTR FailFastUserMessage,
    const void* FailedEIP,
    const unsigned int OSExitCode,
    const unsigned int ClrExitCode,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledFailFast())
        return ERROR_SUCCESS;
    INT FailFastUserMessage_path_size = -1;
    PathCharString FailFastUserMessage_PS;
    INT FailFastUserMessage_full_name_path_size = (wcslen(FailFastUserMessage) + 1)*sizeof(WCHAR);
    CHAR* FailFastUserMessage_full_name = FailFastUserMessage_PS.OpenStringBuffer(FailFastUserMessage_full_name_path_size );
    if (FailFastUserMessage_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    FailFastUserMessage_path_size = WideCharToMultiByte( CP_ACP, 0, FailFastUserMessage, -1, FailFastUserMessage_full_name, FailFastUserMessage_full_name_path_size, NULL, NULL );
    _ASSERTE(FailFastUserMessage_path_size < FailFastUserMessage_full_name_path_size );
    FailFastUserMessage_PS.CloseBuffer(FailFastUserMessage_path_size );
    if( FailFastUserMessage_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        FailFast,
        FailFastUserMessage_full_name,
        (const size_t) FailedEIP,
        OSExitCode,
        ClrExitCode,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvFinalizeObject(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvFinalizeObject); }

extern "C" ULONG  FireEtXplatPrvFinalizeObject(
    const void* TypeID,
    const void* ObjectID,
    const unsigned short ClrInstanceID,
    PCWSTR TypeName)
{
    if (!EventXplatEnabledPrvFinalizeObject())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        PrvFinalizeObject,
        (const size_t) TypeID,
        (const size_t) ObjectID,
        ClrInstanceID,
        TypeName_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCCWRefCountChangeAnsi(){ return tracepoint_enabled(DotNETRuntimePrivate, CCWRefCountChangeAnsi); }

extern "C" ULONG  FireEtXplatCCWRefCountChangeAnsi(
    const void* HandleID,
    const void* ObjectID,
    const void* COMInterfacePointer,
    const unsigned int NewRefCount,
    const unsigned __int64 AppDomainID,
    LPCSTR ClassName,
    LPCSTR NameSpace,
    PCWSTR Operation,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledCCWRefCountChangeAnsi())
        return ERROR_SUCCESS;
    INT Operation_path_size = -1;
    PathCharString Operation_PS;
    INT Operation_full_name_path_size = (wcslen(Operation) + 1)*sizeof(WCHAR);
    CHAR* Operation_full_name = Operation_PS.OpenStringBuffer(Operation_full_name_path_size );
    if (Operation_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Operation_path_size = WideCharToMultiByte( CP_ACP, 0, Operation, -1, Operation_full_name, Operation_full_name_path_size, NULL, NULL );
    _ASSERTE(Operation_path_size < Operation_full_name_path_size );
    Operation_PS.CloseBuffer(Operation_path_size );
    if( Operation_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        CCWRefCountChangeAnsi,
        (const size_t) HandleID,
        (const size_t) ObjectID,
        (const size_t) COMInterfacePointer,
        NewRefCount,
        AppDomainID,
        ClassName,
        NameSpace,
        Operation_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvSetGCHandle(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvSetGCHandle); }

extern "C" ULONG  FireEtXplatPrvSetGCHandle(
    const void* HandleID,
    const void* ObjectID,
    const unsigned int Kind,
    const unsigned int Generation,
    const unsigned __int64 AppDomainID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrvSetGCHandle())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvSetGCHandle,
        (const size_t) HandleID,
        (const size_t) ObjectID,
        Kind,
        Generation,
        AppDomainID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPrvDestroyGCHandle(){ return tracepoint_enabled(DotNETRuntimePrivate, PrvDestroyGCHandle); }

extern "C" ULONG  FireEtXplatPrvDestroyGCHandle(
    const void* HandleID,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPrvDestroyGCHandle())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PrvDestroyGCHandle,
        (const size_t) HandleID,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionMessageEvent(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionMessageEvent); }

extern "C" ULONG  FireEtXplatFusionMessageEvent(
    const unsigned short ClrInstanceID,
    const BOOL Prepend,
    PCWSTR Message)
{
    if (!EventXplatEnabledFusionMessageEvent())
        return ERROR_SUCCESS;
    INT Message_path_size = -1;
    PathCharString Message_PS;
    INT Message_full_name_path_size = (wcslen(Message) + 1)*sizeof(WCHAR);
    CHAR* Message_full_name = Message_PS.OpenStringBuffer(Message_full_name_path_size );
    if (Message_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    Message_path_size = WideCharToMultiByte( CP_ACP, 0, Message, -1, Message_full_name, Message_full_name_path_size, NULL, NULL );
    _ASSERTE(Message_path_size < Message_full_name_path_size );
    Message_PS.CloseBuffer(Message_path_size );
    if( Message_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        FusionMessageEvent,
        ClrInstanceID,
        Prepend,
        Message_full_name);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledFusionErrorCodeEvent(){ return tracepoint_enabled(DotNETRuntimePrivate, FusionErrorCodeEvent); }

extern "C" ULONG  FireEtXplatFusionErrorCodeEvent(
    const unsigned short ClrInstanceID,
    const unsigned int Category,
    const unsigned int ErrorCode)
{
    if (!EventXplatEnabledFusionErrorCodeEvent())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        FusionErrorCodeEvent,
        ClrInstanceID,
        Category,
        ErrorCode);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledPinPlugAtGCTime(){ return tracepoint_enabled(DotNETRuntimePrivate, PinPlugAtGCTime); }

extern "C" ULONG  FireEtXplatPinPlugAtGCTime(
    const void* PlugStart,
    const void* PlugEnd,
    const void* GapBeforeSize,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledPinPlugAtGCTime())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        PinPlugAtGCTime,
        (const size_t) PlugStart,
        (const size_t) PlugEnd,
        (const size_t) GapBeforeSize,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCCWRefCountChange(){ return tracepoint_enabled(DotNETRuntimePrivate, CCWRefCountChange); }

extern "C" ULONG  FireEtXplatCCWRefCountChange(
    const void* HandleID,
    const void* ObjectID,
    const void* COMInterfacePointer,
    const unsigned int NewRefCount,
    const unsigned __int64 AppDomainID,
    PCWSTR ClassName,
    PCWSTR NameSpace,
    PCWSTR Operation,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledCCWRefCountChange())
        return ERROR_SUCCESS;
    INT ClassName_path_size = -1;
    PathCharString ClassName_PS;
    INT ClassName_full_name_path_size = (wcslen(ClassName) + 1)*sizeof(WCHAR);
    CHAR* ClassName_full_name = ClassName_PS.OpenStringBuffer(ClassName_full_name_path_size );
    if (ClassName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT NameSpace_path_size = -1;
    PathCharString NameSpace_PS;
    INT NameSpace_full_name_path_size = (wcslen(NameSpace) + 1)*sizeof(WCHAR);
    CHAR* NameSpace_full_name = NameSpace_PS.OpenStringBuffer(NameSpace_full_name_path_size );
    if (NameSpace_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT Operation_path_size = -1;
    PathCharString Operation_PS;
    INT Operation_full_name_path_size = (wcslen(Operation) + 1)*sizeof(WCHAR);
    CHAR* Operation_full_name = Operation_PS.OpenStringBuffer(Operation_full_name_path_size );
    if (Operation_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    ClassName_path_size = WideCharToMultiByte( CP_ACP, 0, ClassName, -1, ClassName_full_name, ClassName_full_name_path_size, NULL, NULL );
    _ASSERTE(ClassName_path_size < ClassName_full_name_path_size );
    ClassName_PS.CloseBuffer(ClassName_path_size );
    if( ClassName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    NameSpace_path_size = WideCharToMultiByte( CP_ACP, 0, NameSpace, -1, NameSpace_full_name, NameSpace_full_name_path_size, NULL, NULL );
    _ASSERTE(NameSpace_path_size < NameSpace_full_name_path_size );
    NameSpace_PS.CloseBuffer(NameSpace_path_size );
    if( NameSpace_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    Operation_path_size = WideCharToMultiByte( CP_ACP, 0, Operation, -1, Operation_full_name, Operation_full_name_path_size, NULL, NULL );
    _ASSERTE(Operation_path_size < Operation_full_name_path_size );
    Operation_PS.CloseBuffer(Operation_path_size );
    if( Operation_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        CCWRefCountChange,
        (const size_t) HandleID,
        (const size_t) ObjectID,
        (const size_t) COMInterfacePointer,
        NewRefCount,
        AppDomainID,
        ClassName_full_name,
        NameSpace_full_name,
        Operation_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledAllocRequest(){ return tracepoint_enabled(DotNETRuntimePrivate, AllocRequest); }

extern "C" ULONG  FireEtXplatAllocRequest(
    const void* LoaderHeapPtr,
    const void* MemoryAddress,
    const unsigned int RequestSize,
    const unsigned int Unused1,
    const unsigned __int64 Unused2,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledAllocRequest())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        AllocRequest,
        (const size_t) LoaderHeapPtr,
        (const size_t) MemoryAddress,
        RequestSize,
        Unused1,
        Unused2,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMulticoreJit(){ return tracepoint_enabled(DotNETRuntimePrivate, MulticoreJit); }

extern "C" ULONG  FireEtXplatMulticoreJit(
    const unsigned short ClrInstanceID,
    PCWSTR String1,
    PCWSTR String2,
    const signed int Int1,
    const signed int Int2,
    const signed int Int3)
{
    if (!EventXplatEnabledMulticoreJit())
        return ERROR_SUCCESS;
    INT String1_path_size = -1;
    PathCharString String1_PS;
    INT String1_full_name_path_size = (wcslen(String1) + 1)*sizeof(WCHAR);
    CHAR* String1_full_name = String1_PS.OpenStringBuffer(String1_full_name_path_size );
    if (String1_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT String2_path_size = -1;
    PathCharString String2_PS;
    INT String2_full_name_path_size = (wcslen(String2) + 1)*sizeof(WCHAR);
    CHAR* String2_full_name = String2_PS.OpenStringBuffer(String2_full_name_path_size );
    if (String2_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    String1_path_size = WideCharToMultiByte( CP_ACP, 0, String1, -1, String1_full_name, String1_full_name_path_size, NULL, NULL );
    _ASSERTE(String1_path_size < String1_full_name_path_size );
    String1_PS.CloseBuffer(String1_path_size );
    if( String1_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    String2_path_size = WideCharToMultiByte( CP_ACP, 0, String2, -1, String2_full_name, String2_full_name_path_size, NULL, NULL );
    _ASSERTE(String2_path_size < String2_full_name_path_size );
    String2_PS.CloseBuffer(String2_path_size );
    if( String2_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        MulticoreJit,
        ClrInstanceID,
        String1_full_name,
        String2_full_name,
        Int1,
        Int2,
        Int3);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledMulticoreJitMethodCodeReturned(){ return tracepoint_enabled(DotNETRuntimePrivate, MulticoreJitMethodCodeReturned); }

extern "C" ULONG  FireEtXplatMulticoreJitMethodCodeReturned(
    const unsigned short ClrInstanceID,
    const unsigned __int64 ModuleID,
    const unsigned __int64 MethodID)
{
    if (!EventXplatEnabledMulticoreJitMethodCodeReturned())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        MulticoreJitMethodCodeReturned,
        ClrInstanceID,
        ModuleID,
        MethodID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledIInspectableRuntimeClassName(){ return tracepoint_enabled(DotNETRuntimePrivate, IInspectableRuntimeClassName); }

extern "C" ULONG  FireEtXplatIInspectableRuntimeClassName(
    PCWSTR TypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledIInspectableRuntimeClassName())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        IInspectableRuntimeClassName,
        TypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledWinRTUnbox(){ return tracepoint_enabled(DotNETRuntimePrivate, WinRTUnbox); }

extern "C" ULONG  FireEtXplatWinRTUnbox(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledWinRTUnbox())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT SecondTypeName_path_size = -1;
    PathCharString SecondTypeName_PS;
    INT SecondTypeName_full_name_path_size = (wcslen(SecondTypeName) + 1)*sizeof(WCHAR);
    CHAR* SecondTypeName_full_name = SecondTypeName_PS.OpenStringBuffer(SecondTypeName_full_name_path_size );
    if (SecondTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    SecondTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, SecondTypeName, -1, SecondTypeName_full_name, SecondTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(SecondTypeName_path_size < SecondTypeName_full_name_path_size );
    SecondTypeName_PS.CloseBuffer(SecondTypeName_path_size );
    if( SecondTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        WinRTUnbox,
        TypeName_full_name,
        SecondTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCreateRCW(){ return tracepoint_enabled(DotNETRuntimePrivate, CreateRCW); }

extern "C" ULONG  FireEtXplatCreateRCW(
    PCWSTR TypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledCreateRCW())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        CreateRCW,
        TypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledRCWVariance(){ return tracepoint_enabled(DotNETRuntimePrivate, RCWVariance); }

extern "C" ULONG  FireEtXplatRCWVariance(
    PCWSTR TypeName,
    PCWSTR InterfaceTypeName,
    PCWSTR VariantInterfaceTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledRCWVariance())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT InterfaceTypeName_path_size = -1;
    PathCharString InterfaceTypeName_PS;
    INT InterfaceTypeName_full_name_path_size = (wcslen(InterfaceTypeName) + 1)*sizeof(WCHAR);
    CHAR* InterfaceTypeName_full_name = InterfaceTypeName_PS.OpenStringBuffer(InterfaceTypeName_full_name_path_size );
    if (InterfaceTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT VariantInterfaceTypeName_path_size = -1;
    PathCharString VariantInterfaceTypeName_PS;
    INT VariantInterfaceTypeName_full_name_path_size = (wcslen(VariantInterfaceTypeName) + 1)*sizeof(WCHAR);
    CHAR* VariantInterfaceTypeName_full_name = VariantInterfaceTypeName_PS.OpenStringBuffer(VariantInterfaceTypeName_full_name_path_size );
    if (VariantInterfaceTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    InterfaceTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, InterfaceTypeName, -1, InterfaceTypeName_full_name, InterfaceTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(InterfaceTypeName_path_size < InterfaceTypeName_full_name_path_size );
    InterfaceTypeName_PS.CloseBuffer(InterfaceTypeName_path_size );
    if( InterfaceTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    VariantInterfaceTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, VariantInterfaceTypeName, -1, VariantInterfaceTypeName_full_name, VariantInterfaceTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(VariantInterfaceTypeName_path_size < VariantInterfaceTypeName_full_name_path_size );
    VariantInterfaceTypeName_PS.CloseBuffer(VariantInterfaceTypeName_path_size );
    if( VariantInterfaceTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        RCWVariance,
        TypeName_full_name,
        InterfaceTypeName_full_name,
        VariantInterfaceTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledRCWIEnumerableCasting(){ return tracepoint_enabled(DotNETRuntimePrivate, RCWIEnumerableCasting); }

extern "C" ULONG  FireEtXplatRCWIEnumerableCasting(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledRCWIEnumerableCasting())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT SecondTypeName_path_size = -1;
    PathCharString SecondTypeName_PS;
    INT SecondTypeName_full_name_path_size = (wcslen(SecondTypeName) + 1)*sizeof(WCHAR);
    CHAR* SecondTypeName_full_name = SecondTypeName_PS.OpenStringBuffer(SecondTypeName_full_name_path_size );
    if (SecondTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    SecondTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, SecondTypeName, -1, SecondTypeName_full_name, SecondTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(SecondTypeName_path_size < SecondTypeName_full_name_path_size );
    SecondTypeName_PS.CloseBuffer(SecondTypeName_path_size );
    if( SecondTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        RCWIEnumerableCasting,
        TypeName_full_name,
        SecondTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCreateCCW(){ return tracepoint_enabled(DotNETRuntimePrivate, CreateCCW); }

extern "C" ULONG  FireEtXplatCreateCCW(
    PCWSTR TypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledCreateCCW())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        CreateCCW,
        TypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledCCWVariance(){ return tracepoint_enabled(DotNETRuntimePrivate, CCWVariance); }

extern "C" ULONG  FireEtXplatCCWVariance(
    PCWSTR TypeName,
    PCWSTR InterfaceTypeName,
    PCWSTR VariantInterfaceTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledCCWVariance())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT InterfaceTypeName_path_size = -1;
    PathCharString InterfaceTypeName_PS;
    INT InterfaceTypeName_full_name_path_size = (wcslen(InterfaceTypeName) + 1)*sizeof(WCHAR);
    CHAR* InterfaceTypeName_full_name = InterfaceTypeName_PS.OpenStringBuffer(InterfaceTypeName_full_name_path_size );
    if (InterfaceTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT VariantInterfaceTypeName_path_size = -1;
    PathCharString VariantInterfaceTypeName_PS;
    INT VariantInterfaceTypeName_full_name_path_size = (wcslen(VariantInterfaceTypeName) + 1)*sizeof(WCHAR);
    CHAR* VariantInterfaceTypeName_full_name = VariantInterfaceTypeName_PS.OpenStringBuffer(VariantInterfaceTypeName_full_name_path_size );
    if (VariantInterfaceTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    InterfaceTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, InterfaceTypeName, -1, InterfaceTypeName_full_name, InterfaceTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(InterfaceTypeName_path_size < InterfaceTypeName_full_name_path_size );
    InterfaceTypeName_PS.CloseBuffer(InterfaceTypeName_path_size );
    if( InterfaceTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    VariantInterfaceTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, VariantInterfaceTypeName, -1, VariantInterfaceTypeName_full_name, VariantInterfaceTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(VariantInterfaceTypeName_path_size < VariantInterfaceTypeName_full_name_path_size );
    VariantInterfaceTypeName_PS.CloseBuffer(VariantInterfaceTypeName_path_size );
    if( VariantInterfaceTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        CCWVariance,
        TypeName_full_name,
        InterfaceTypeName_full_name,
        VariantInterfaceTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledObjectVariantMarshallingToNative(){ return tracepoint_enabled(DotNETRuntimePrivate, ObjectVariantMarshallingToNative); }

extern "C" ULONG  FireEtXplatObjectVariantMarshallingToNative(
    PCWSTR TypeName,
    const signed int Int1,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledObjectVariantMarshallingToNative())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        ObjectVariantMarshallingToNative,
        TypeName_full_name,
        Int1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGetTypeFromGUID(){ return tracepoint_enabled(DotNETRuntimePrivate, GetTypeFromGUID); }

extern "C" ULONG  FireEtXplatGetTypeFromGUID(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGetTypeFromGUID())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT SecondTypeName_path_size = -1;
    PathCharString SecondTypeName_PS;
    INT SecondTypeName_full_name_path_size = (wcslen(SecondTypeName) + 1)*sizeof(WCHAR);
    CHAR* SecondTypeName_full_name = SecondTypeName_PS.OpenStringBuffer(SecondTypeName_full_name_path_size );
    if (SecondTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    SecondTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, SecondTypeName, -1, SecondTypeName_full_name, SecondTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(SecondTypeName_path_size < SecondTypeName_full_name_path_size );
    SecondTypeName_PS.CloseBuffer(SecondTypeName_path_size );
    if( SecondTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        GetTypeFromGUID,
        TypeName_full_name,
        SecondTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledGetTypeFromProgID(){ return tracepoint_enabled(DotNETRuntimePrivate, GetTypeFromProgID); }

extern "C" ULONG  FireEtXplatGetTypeFromProgID(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledGetTypeFromProgID())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT SecondTypeName_path_size = -1;
    PathCharString SecondTypeName_PS;
    INT SecondTypeName_full_name_path_size = (wcslen(SecondTypeName) + 1)*sizeof(WCHAR);
    CHAR* SecondTypeName_full_name = SecondTypeName_PS.OpenStringBuffer(SecondTypeName_full_name_path_size );
    if (SecondTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    SecondTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, SecondTypeName, -1, SecondTypeName_full_name, SecondTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(SecondTypeName_path_size < SecondTypeName_full_name_path_size );
    SecondTypeName_PS.CloseBuffer(SecondTypeName_path_size );
    if( SecondTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        GetTypeFromProgID,
        TypeName_full_name,
        SecondTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledConvertToCallbackEtw(){ return tracepoint_enabled(DotNETRuntimePrivate, ConvertToCallbackEtw); }

extern "C" ULONG  FireEtXplatConvertToCallbackEtw(
    PCWSTR TypeName,
    PCWSTR SecondTypeName,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledConvertToCallbackEtw())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }
    INT SecondTypeName_path_size = -1;
    PathCharString SecondTypeName_PS;
    INT SecondTypeName_full_name_path_size = (wcslen(SecondTypeName) + 1)*sizeof(WCHAR);
    CHAR* SecondTypeName_full_name = SecondTypeName_PS.OpenStringBuffer(SecondTypeName_full_name_path_size );
    if (SecondTypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    SecondTypeName_path_size = WideCharToMultiByte( CP_ACP, 0, SecondTypeName, -1, SecondTypeName_full_name, SecondTypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(SecondTypeName_path_size < SecondTypeName_full_name_path_size );
    SecondTypeName_PS.CloseBuffer(SecondTypeName_path_size );
    if( SecondTypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        ConvertToCallbackEtw,
        TypeName_full_name,
        SecondTypeName_full_name,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledBeginCreateManagedReference(){ return tracepoint_enabled(DotNETRuntimePrivate, BeginCreateManagedReference); }

extern "C" ULONG  FireEtXplatBeginCreateManagedReference(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledBeginCreateManagedReference())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        BeginCreateManagedReference,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledEndCreateManagedReference(){ return tracepoint_enabled(DotNETRuntimePrivate, EndCreateManagedReference); }

extern "C" ULONG  FireEtXplatEndCreateManagedReference(
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledEndCreateManagedReference())
        return ERROR_SUCCESS;

    do_tracepoint(DotNETRuntimePrivate,
        EndCreateManagedReference,
        ClrInstanceID);

    return ERROR_SUCCESS;
}

extern "C" BOOL  EventXplatEnabledObjectVariantMarshallingToManaged(){ return tracepoint_enabled(DotNETRuntimePrivate, ObjectVariantMarshallingToManaged); }

extern "C" ULONG  FireEtXplatObjectVariantMarshallingToManaged(
    PCWSTR TypeName,
    const signed int Int1,
    const unsigned short ClrInstanceID)
{
    if (!EventXplatEnabledObjectVariantMarshallingToManaged())
        return ERROR_SUCCESS;
    INT TypeName_path_size = -1;
    PathCharString TypeName_PS;
    INT TypeName_full_name_path_size = (wcslen(TypeName) + 1)*sizeof(WCHAR);
    CHAR* TypeName_full_name = TypeName_PS.OpenStringBuffer(TypeName_full_name_path_size );
    if (TypeName_full_name == NULL )    { return ERROR_WRITE_FAULT; }

    TypeName_path_size = WideCharToMultiByte( CP_ACP, 0, TypeName, -1, TypeName_full_name, TypeName_full_name_path_size, NULL, NULL );
    _ASSERTE(TypeName_path_size < TypeName_full_name_path_size );
    TypeName_PS.CloseBuffer(TypeName_path_size );
    if( TypeName_path_size == 0 ){ return ERROR_INVALID_PARAMETER; }
    do_tracepoint(DotNETRuntimePrivate,
        ObjectVariantMarshallingToManaged,
        TypeName_full_name,
        Int1,
        ClrInstanceID);

    return ERROR_SUCCESS;
}


