/* game-board.c generated by valac 0.56.18, the Vala compiler
 * generated from game-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Four-in-a-row.

   Copyright © 2018 Jacob Humphrey

   GNOME Four-in-a-row is free software: you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Four-in-a-row is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Four-in-a-row.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;
typedef struct _BoardPrivate BoardPrivate;
enum  {
	BOARD_0_PROPERTY,
	BOARD_LINE_PROPERTY,
	BOARD_SIZE_PROPERTY,
	BOARD_NUM_PROPERTIES
};
static GParamSpec* board_properties[BOARD_NUM_PROPERTIES];
typedef enum  {
	PLAYER_NOBODY,
	PLAYER_HUMAN,
	PLAYER_OPPONENT
} Player;

#define TYPE_PLAYER (player_get_type ())

struct _Board {
	GObject parent_instance;
	BoardPrivate * priv;
};

struct _BoardClass {
	GObjectClass parent_class;
};

struct _BoardPrivate {
	guint8 _line;
	guint8 _size;
};

static gint Board_private_offset;
static gpointer board_parent_class = NULL;
static Player* board_gboard;
static gint board_gboard_length1;
static gint board_gboard_length2;
static Player* board_gboard = NULL;
static gint board_gboard_length1 = 0;
static gint board_gboard_length2 = 0;

VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, g_object_unref)
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Board* board_new (guint8 size,
                  guint8 line);
VALA_EXTERN Board* board_construct (GType object_type,
                        guint8 size,
                        guint8 line);
VALA_EXTERN void board_set (Board* self,
                guint8 x,
                guint8 y,
                Player tile);
VALA_EXTERN Player board_get (Board* self,
                  guint8 x,
                  guint8 y);
VALA_EXTERN void board_clear (Board* self);
VALA_EXTERN guint8 board_get_size (Board* self);
VALA_EXTERN guint8 board_first_empty_row (Board* self,
                              guint8 col);
VALA_EXTERN gboolean board_is_line_at (Board* self,
                           Player tile,
                           guint8 row,
                           guint8 col,
                           guint8** lines,
                           gint* lines_length1,
                           gint* lines_length2);
static inline gboolean board_is_hline_at (Board* self,
                            Player tile,
                            guint8 row,
                            guint8 col,
                            guint8* row_1,
                            guint8* col_1,
                            guint8* row_2,
                            guint8* col_2);
static inline gboolean board_is_vline_at (Board* self,
                            Player tile,
                            guint8 row,
                            guint8 col,
                            guint8* row_1,
                            guint8* col_1,
                            guint8* row_2,
                            guint8* col_2);
static inline gboolean board_is_dline1_at (Board* self,
                             Player tile,
                             guint8 row,
                             guint8 col,
                             guint8* row_1,
                             guint8* col_1,
                             guint8* row_2,
                             guint8* col_2);
static inline gboolean board_is_dline2_at (Board* self,
                             Player tile,
                             guint8 row,
                             guint8 col,
                             guint8* row_1,
                             guint8* col_1,
                             guint8* row_2,
                             guint8* col_2);
VALA_EXTERN guint8 board_get_line (Board* self);
static void board_set_line (Board* self,
                     guint8 value);
static void board_set_size (Board* self,
                     guint8 value);
static GObject * board_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties);
static void board_finalize (GObject * obj);
static GType board_get_type_once (void);
static void _vala_board_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_board_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);

static inline gpointer
board_get_instance_private (Board* self)
{
	return G_STRUCT_MEMBER_P (self, Board_private_offset);
}

Board*
board_construct (GType object_type,
                 guint8 size,
                 guint8 line)
{
	Board * self = NULL;
	self = (Board*) g_object_new (object_type, "size", size, "line", line, NULL);
	return self;
}

Board*
board_new (guint8 size,
           guint8 line)
{
	return board_construct (TYPE_BOARD, size, line);
}

void
board_set (Board* self,
           guint8 x,
           guint8 y,
           Player tile)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = board_gboard;
	_tmp0__length1 = board_gboard_length1;
	_tmp0__length2 = board_gboard_length2;
	_tmp0_[(x * _tmp0__length2) + y] = tile;
}

Player
board_get (Board* self,
           guint8 x,
           guint8 y)
{
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	Player result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = board_gboard;
	_tmp0__length1 = board_gboard_length1;
	_tmp0__length2 = board_gboard_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_;
	return result;
}

void
board_clear (Board* self)
{
	g_return_if_fail (self != NULL);
	{
		guint8 row = 0U;
		row = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8 _tmp2_;
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_size;
				if (!(row < _tmp2_)) {
					break;
				}
				{
					guint8 col = 0U;
					col = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							guint8 _tmp5_;
							Player* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = col;
								col = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_size;
							if (!(col < _tmp5_)) {
								break;
							}
							_tmp6_ = board_gboard;
							_tmp6__length1 = board_gboard_length1;
							_tmp6__length2 = board_gboard_length2;
							_tmp6_[(row * _tmp6__length2) + col] = PLAYER_NOBODY;
						}
					}
				}
			}
		}
	}
}

guint8
board_first_empty_row (Board* self,
                       guint8 col)
{
	guint8 row = 0U;
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	row = (guint8) 1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		guint8 _tmp1_;
		guint8 _tmp4_;
		_tmp1_ = self->priv->_size;
		if (row < _tmp1_) {
			Player* _tmp2_;
			gint _tmp2__length1;
			gint _tmp2__length2;
			Player _tmp3_;
			_tmp2_ = board_gboard;
			_tmp2__length1 = board_gboard_length1;
			_tmp2__length2 = board_gboard_length2;
			_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
			_tmp0_ = _tmp3_ == PLAYER_NOBODY;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = row;
		row = _tmp4_ + 1;
	}
	result = (guint8) (row - 1);
	return result;
}

gboolean
board_is_line_at (Board* self,
                  Player tile,
                  guint8 row,
                  guint8 col,
                  guint8** lines,
                  gint* lines_length1,
                  gint* lines_length2)
{
	guint8* _vala_lines = NULL;
	gint _vala_lines_length1 = 0;
	gint _vala_lines_length2 = 0;
	guint8 n_lines = 0U;
	guint8* lines_tmp = NULL;
	guint8* _tmp0_;
	gint lines_tmp_length1;
	gint lines_tmp_length2;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	guint8 _tmp5_ = 0U;
	guint8 _tmp6_ = 0U;
	guint8 _tmp7_ = 0U;
	guint8 _tmp8_ = 0U;
	gboolean _tmp9_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	guint8* _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	guint8 _tmp15_ = 0U;
	guint8 _tmp16_ = 0U;
	guint8 _tmp17_ = 0U;
	guint8 _tmp18_ = 0U;
	gboolean _tmp19_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gint _tmp21__length2;
	guint8* _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	guint8* _tmp23_;
	gint _tmp23__length1;
	gint _tmp23__length2;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	guint8 _tmp25_ = 0U;
	guint8 _tmp26_ = 0U;
	guint8 _tmp27_ = 0U;
	guint8 _tmp28_ = 0U;
	gboolean _tmp29_;
	guint8* _tmp31_;
	gint _tmp31__length1;
	gint _tmp31__length2;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gint _tmp32__length2;
	guint8* _tmp33_;
	gint _tmp33__length1;
	gint _tmp33__length2;
	guint8* _tmp34_;
	gint _tmp34__length1;
	gint _tmp34__length2;
	guint8 _tmp35_ = 0U;
	guint8 _tmp36_ = 0U;
	guint8 _tmp37_ = 0U;
	guint8 _tmp38_ = 0U;
	gboolean _tmp39_;
	guint8* _tmp41_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	n_lines = (guint8) 0;
	_tmp0_ = g_new0 (guint8, 4 * 4);
	lines_tmp = _tmp0_;
	lines_tmp_length1 = 4;
	lines_tmp_length2 = 4;
	_tmp1_ = lines_tmp;
	_tmp1__length1 = lines_tmp_length1;
	_tmp1__length2 = lines_tmp_length2;
	_tmp2_ = lines_tmp;
	_tmp2__length1 = lines_tmp_length1;
	_tmp2__length2 = lines_tmp_length2;
	_tmp3_ = lines_tmp;
	_tmp3__length1 = lines_tmp_length1;
	_tmp3__length2 = lines_tmp_length2;
	_tmp4_ = lines_tmp;
	_tmp4__length1 = lines_tmp_length1;
	_tmp4__length2 = lines_tmp_length2;
	_tmp9_ = board_is_hline_at (self, tile, row, col, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	_tmp1_[(0 * _tmp1__length2) + 0] = _tmp5_;
	_tmp2_[(0 * _tmp2__length2) + 1] = _tmp6_;
	_tmp3_[(0 * _tmp3__length2) + 2] = _tmp7_;
	_tmp4_[(0 * _tmp4__length2) + 3] = _tmp8_;
	if (_tmp9_) {
		guint8 _tmp10_;
		_tmp10_ = n_lines;
		n_lines = _tmp10_ + 1;
	}
	_tmp11_ = lines_tmp;
	_tmp11__length1 = lines_tmp_length1;
	_tmp11__length2 = lines_tmp_length2;
	_tmp12_ = lines_tmp;
	_tmp12__length1 = lines_tmp_length1;
	_tmp12__length2 = lines_tmp_length2;
	_tmp13_ = lines_tmp;
	_tmp13__length1 = lines_tmp_length1;
	_tmp13__length2 = lines_tmp_length2;
	_tmp14_ = lines_tmp;
	_tmp14__length1 = lines_tmp_length1;
	_tmp14__length2 = lines_tmp_length2;
	_tmp19_ = board_is_vline_at (self, tile, row, col, &_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_);
	_tmp11_[(n_lines * _tmp11__length2) + 0] = _tmp15_;
	_tmp12_[(n_lines * _tmp12__length2) + 1] = _tmp16_;
	_tmp13_[(n_lines * _tmp13__length2) + 2] = _tmp17_;
	_tmp14_[(n_lines * _tmp14__length2) + 3] = _tmp18_;
	if (_tmp19_) {
		guint8 _tmp20_;
		_tmp20_ = n_lines;
		n_lines = _tmp20_ + 1;
	}
	_tmp21_ = lines_tmp;
	_tmp21__length1 = lines_tmp_length1;
	_tmp21__length2 = lines_tmp_length2;
	_tmp22_ = lines_tmp;
	_tmp22__length1 = lines_tmp_length1;
	_tmp22__length2 = lines_tmp_length2;
	_tmp23_ = lines_tmp;
	_tmp23__length1 = lines_tmp_length1;
	_tmp23__length2 = lines_tmp_length2;
	_tmp24_ = lines_tmp;
	_tmp24__length1 = lines_tmp_length1;
	_tmp24__length2 = lines_tmp_length2;
	_tmp29_ = board_is_dline1_at (self, tile, row, col, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
	_tmp21_[(n_lines * _tmp21__length2) + 0] = _tmp25_;
	_tmp22_[(n_lines * _tmp22__length2) + 1] = _tmp26_;
	_tmp23_[(n_lines * _tmp23__length2) + 2] = _tmp27_;
	_tmp24_[(n_lines * _tmp24__length2) + 3] = _tmp28_;
	if (_tmp29_) {
		guint8 _tmp30_;
		_tmp30_ = n_lines;
		n_lines = _tmp30_ + 1;
	}
	_tmp31_ = lines_tmp;
	_tmp31__length1 = lines_tmp_length1;
	_tmp31__length2 = lines_tmp_length2;
	_tmp32_ = lines_tmp;
	_tmp32__length1 = lines_tmp_length1;
	_tmp32__length2 = lines_tmp_length2;
	_tmp33_ = lines_tmp;
	_tmp33__length1 = lines_tmp_length1;
	_tmp33__length2 = lines_tmp_length2;
	_tmp34_ = lines_tmp;
	_tmp34__length1 = lines_tmp_length1;
	_tmp34__length2 = lines_tmp_length2;
	_tmp39_ = board_is_dline2_at (self, tile, row, col, &_tmp35_, &_tmp36_, &_tmp37_, &_tmp38_);
	_tmp31_[(n_lines * _tmp31__length2) + 0] = _tmp35_;
	_tmp32_[(n_lines * _tmp32__length2) + 1] = _tmp36_;
	_tmp33_[(n_lines * _tmp33__length2) + 2] = _tmp37_;
	_tmp34_[(n_lines * _tmp34__length2) + 3] = _tmp38_;
	if (_tmp39_) {
		guint8 _tmp40_;
		_tmp40_ = n_lines;
		n_lines = _tmp40_ + 1;
	}
	_tmp41_ = g_new0 (guint8, n_lines * 4);
	_vala_lines = (g_free (_vala_lines), NULL);
	_vala_lines = _tmp41_;
	_vala_lines_length1 = n_lines;
	_vala_lines_length2 = 4;
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				if (!_tmp42_) {
					guint8 _tmp43_;
					_tmp43_ = x;
					x = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				if (!(x < n_lines)) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp44_ = FALSE;
						_tmp44_ = TRUE;
						while (TRUE) {
							guint8* _tmp46_;
							gint _tmp46__length1;
							gint _tmp46__length2;
							guint8* _tmp47_;
							gint _tmp47__length1;
							gint _tmp47__length2;
							guint8 _tmp48_;
							if (!_tmp44_) {
								guint8 _tmp45_;
								_tmp45_ = y;
								y = _tmp45_ + 1;
							}
							_tmp44_ = FALSE;
							if (!(((gint) y) < 4)) {
								break;
							}
							_tmp46_ = _vala_lines;
							_tmp46__length1 = _vala_lines_length1;
							_tmp46__length2 = _vala_lines_length2;
							_tmp47_ = lines_tmp;
							_tmp47__length1 = lines_tmp_length1;
							_tmp47__length2 = lines_tmp_length2;
							_tmp48_ = _tmp47_[(x * _tmp47__length2) + y];
							_tmp46_[(x * _tmp46__length2) + y] = _tmp48_;
						}
					}
				}
			}
		}
	}
	result = ((gint) n_lines) != 0;
	lines_tmp = (g_free (lines_tmp), NULL);
	if (lines) {
		*lines = _vala_lines;
	} else {
		_vala_lines = (g_free (_vala_lines), NULL);
	}
	if (lines_length1) {
		*lines_length1 = _vala_lines_length1;
	}
	if (lines_length2) {
		*lines_length2 = _vala_lines_length2;
	}
	return result;
}

static inline gboolean
board_is_hline_at (Board* self,
                   Player tile,
                   guint8 row,
                   guint8 col,
                   guint8* row_1,
                   guint8* col_1,
                   guint8* row_2,
                   guint8* col_2)
{
	guint8 _vala_row_1 = 0U;
	guint8 _vala_col_1 = 0U;
	guint8 _vala_row_2 = 0U;
	guint8 _vala_col_2 = 0U;
	guint8 _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_row_1 = row;
	_vala_row_2 = row;
	_vala_col_1 = col;
	_vala_col_2 = col;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (((gint) _vala_col_1) > 0) {
			Player* _tmp1_;
			gint _tmp1__length1;
			gint _tmp1__length2;
			Player _tmp2_;
			_tmp1_ = board_gboard;
			_tmp1__length1 = board_gboard_length1;
			_tmp1__length2 = board_gboard_length2;
			_tmp2_ = _tmp1_[(row * _tmp1__length2) + (_vala_col_1 - 1)];
			_tmp0_ = _tmp2_ == tile;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_vala_col_1 = (guint8) (_vala_col_1 - 1);
	}
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		guint8 _tmp4_;
		_tmp4_ = self->priv->_size;
		if (((gint) _vala_col_2) < (_tmp4_ - 1)) {
			Player* _tmp5_;
			gint _tmp5__length1;
			gint _tmp5__length2;
			Player _tmp6_;
			_tmp5_ = board_gboard;
			_tmp5__length1 = board_gboard_length1;
			_tmp5__length2 = board_gboard_length2;
			_tmp6_ = _tmp5_[(row * _tmp5__length2) + (_vala_col_2 + 1)];
			_tmp3_ = _tmp6_ == tile;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_vala_col_2 = (guint8) (_vala_col_2 + 1);
	}
	_tmp7_ = self->priv->_line;
	result = ((gint) (_vala_col_2 - _vala_col_1)) >= (_tmp7_ - 1);
	if (row_1) {
		*row_1 = _vala_row_1;
	}
	if (col_1) {
		*col_1 = _vala_col_1;
	}
	if (row_2) {
		*row_2 = _vala_row_2;
	}
	if (col_2) {
		*col_2 = _vala_col_2;
	}
	return result;
}

static inline gboolean
board_is_vline_at (Board* self,
                   Player tile,
                   guint8 row,
                   guint8 col,
                   guint8* row_1,
                   guint8* col_1,
                   guint8* row_2,
                   guint8* col_2)
{
	guint8 _vala_row_1 = 0U;
	guint8 _vala_col_1 = 0U;
	guint8 _vala_row_2 = 0U;
	guint8 _vala_col_2 = 0U;
	guint8 _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_row_1 = row;
	_vala_row_2 = row;
	_vala_col_1 = col;
	_vala_col_2 = col;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (((gint) _vala_row_1) > 1) {
			Player* _tmp1_;
			gint _tmp1__length1;
			gint _tmp1__length2;
			Player _tmp2_;
			_tmp1_ = board_gboard;
			_tmp1__length1 = board_gboard_length1;
			_tmp1__length2 = board_gboard_length2;
			_tmp2_ = _tmp1_[((_vala_row_1 - 1) * _tmp1__length2) + col];
			_tmp0_ = _tmp2_ == tile;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_vala_row_1 = (guint8) (_vala_row_1 - 1);
	}
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		guint8 _tmp4_;
		_tmp4_ = self->priv->_size;
		if (((gint) _vala_row_2) < (_tmp4_ - 1)) {
			Player* _tmp5_;
			gint _tmp5__length1;
			gint _tmp5__length2;
			Player _tmp6_;
			_tmp5_ = board_gboard;
			_tmp5__length1 = board_gboard_length1;
			_tmp5__length2 = board_gboard_length2;
			_tmp6_ = _tmp5_[((_vala_row_2 + 1) * _tmp5__length2) + col];
			_tmp3_ = _tmp6_ == tile;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_vala_row_2 = (guint8) (_vala_row_2 + 1);
	}
	_tmp7_ = self->priv->_line;
	result = ((gint) (_vala_row_2 - _vala_row_1)) >= (_tmp7_ - 1);
	if (row_1) {
		*row_1 = _vala_row_1;
	}
	if (col_1) {
		*col_1 = _vala_col_1;
	}
	if (row_2) {
		*row_2 = _vala_row_2;
	}
	if (col_2) {
		*col_2 = _vala_col_2;
	}
	return result;
}

static inline gboolean
board_is_dline1_at (Board* self,
                    Player tile,
                    guint8 row,
                    guint8 col,
                    guint8* row_1,
                    guint8* col_1,
                    guint8* row_2,
                    guint8* col_2)
{
	guint8 _vala_row_1 = 0U;
	guint8 _vala_col_1 = 0U;
	guint8 _vala_row_2 = 0U;
	guint8 _vala_col_2 = 0U;
	guint8 _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_row_1 = row;
	_vala_row_2 = row;
	_vala_col_1 = col;
	_vala_col_2 = col;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (((gint) _vala_col_1) > 0) {
			_tmp1_ = ((gint) _vala_row_1) > 1;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			Player* _tmp2_;
			gint _tmp2__length1;
			gint _tmp2__length2;
			Player _tmp3_;
			_tmp2_ = board_gboard;
			_tmp2__length1 = board_gboard_length1;
			_tmp2__length2 = board_gboard_length2;
			_tmp3_ = _tmp2_[((_vala_row_1 - 1) * _tmp2__length2) + (_vala_col_1 - 1)];
			_tmp0_ = _tmp3_ == tile;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_vala_row_1 = (guint8) (_vala_row_1 - 1);
		_vala_col_1 = (guint8) (_vala_col_1 - 1);
	}
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		guint8 _tmp6_;
		_tmp6_ = self->priv->_size;
		if (((gint) _vala_col_2) < (_tmp6_ - 1)) {
			guint8 _tmp7_;
			_tmp7_ = self->priv->_size;
			_tmp5_ = ((gint) _vala_row_2) < (_tmp7_ - 1);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			Player* _tmp8_;
			gint _tmp8__length1;
			gint _tmp8__length2;
			Player _tmp9_;
			_tmp8_ = board_gboard;
			_tmp8__length1 = board_gboard_length1;
			_tmp8__length2 = board_gboard_length2;
			_tmp9_ = _tmp8_[((_vala_row_2 + 1) * _tmp8__length2) + (_vala_col_2 + 1)];
			_tmp4_ = _tmp9_ == tile;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		_vala_row_2 = (guint8) (_vala_row_2 + 1);
		_vala_col_2 = (guint8) (_vala_col_2 + 1);
	}
	_tmp10_ = self->priv->_line;
	result = ((gint) (_vala_row_2 - _vala_row_1)) >= (_tmp10_ - 1);
	if (row_1) {
		*row_1 = _vala_row_1;
	}
	if (col_1) {
		*col_1 = _vala_col_1;
	}
	if (row_2) {
		*row_2 = _vala_row_2;
	}
	if (col_2) {
		*col_2 = _vala_col_2;
	}
	return result;
}

static inline gboolean
board_is_dline2_at (Board* self,
                    Player tile,
                    guint8 row,
                    guint8 col,
                    guint8* row_1,
                    guint8* col_1,
                    guint8* row_2,
                    guint8* col_2)
{
	guint8 _vala_row_1 = 0U;
	guint8 _vala_col_1 = 0U;
	guint8 _vala_row_2 = 0U;
	guint8 _vala_col_2 = 0U;
	guint8 _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_row_1 = row;
	_vala_row_2 = row;
	_vala_col_1 = col;
	_vala_col_2 = col;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		guint8 _tmp2_;
		_tmp2_ = self->priv->_size;
		if (((gint) _vala_col_1) < (_tmp2_ - 1)) {
			_tmp1_ = ((gint) _vala_row_1) > 1;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			Player* _tmp3_;
			gint _tmp3__length1;
			gint _tmp3__length2;
			Player _tmp4_;
			_tmp3_ = board_gboard;
			_tmp3__length1 = board_gboard_length1;
			_tmp3__length2 = board_gboard_length2;
			_tmp4_ = _tmp3_[((_vala_row_1 - 1) * _tmp3__length2) + (_vala_col_1 + 1)];
			_tmp0_ = _tmp4_ == tile;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_vala_row_1 = (guint8) (_vala_row_1 - 1);
		_vala_col_1 = (guint8) (_vala_col_1 + 1);
	}
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (((gint) _vala_col_2) > 0) {
			guint8 _tmp7_;
			_tmp7_ = self->priv->_size;
			_tmp6_ = ((gint) _vala_row_2) < (_tmp7_ - 1);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			Player* _tmp8_;
			gint _tmp8__length1;
			gint _tmp8__length2;
			Player _tmp9_;
			_tmp8_ = board_gboard;
			_tmp8__length1 = board_gboard_length1;
			_tmp8__length2 = board_gboard_length2;
			_tmp9_ = _tmp8_[((_vala_row_2 + 1) * _tmp8__length2) + (_vala_col_2 - 1)];
			_tmp5_ = _tmp9_ == tile;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_vala_row_2 = (guint8) (_vala_row_2 + 1);
		_vala_col_2 = (guint8) (_vala_col_2 - 1);
	}
	_tmp10_ = self->priv->_line;
	result = ((gint) (_vala_row_2 - _vala_row_1)) >= (_tmp10_ - 1);
	if (row_1) {
		*row_1 = _vala_row_1;
	}
	if (col_1) {
		*col_1 = _vala_col_1;
	}
	if (row_2) {
		*row_2 = _vala_row_2;
	}
	if (col_2) {
		*col_2 = _vala_col_2;
	}
	return result;
}

guint8
board_get_line (Board* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_line;
	return result;
}

static void
board_set_line (Board* self,
                guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_line = value;
}

guint8
board_get_size (Board* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_size;
	return result;
}

static void
board_set_size (Board* self,
                guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_size = value;
}

static GObject *
board_constructor (GType type,
                   guint n_construct_properties,
                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Board * self;
	guint8 _tmp0_;
	guint8 _tmp1_;
	Player* _tmp2_;
	parent_class = G_OBJECT_CLASS (board_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOARD, Board);
	_tmp0_ = self->priv->_size;
	_tmp1_ = self->priv->_size;
	_tmp2_ = g_new0 (Player, _tmp0_ * _tmp1_);
	board_gboard = (g_free (board_gboard), NULL);
	board_gboard = _tmp2_;
	board_gboard_length1 = _tmp0_;
	board_gboard_length2 = _tmp1_;
	return obj;
}

static void
board_class_init (BoardClass * klass,
                  gpointer klass_data)
{
	board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Board_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_board_set_property;
	G_OBJECT_CLASS (klass)->constructor = board_constructor;
	G_OBJECT_CLASS (klass)->finalize = board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOARD_LINE_PROPERTY, board_properties[BOARD_LINE_PROPERTY] = g_param_spec_uchar ("line", "line", "line", 0, G_MAXUINT8, (guint8) 4, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOARD_SIZE_PROPERTY, board_properties[BOARD_SIZE_PROPERTY] = g_param_spec_uchar ("size", "size", "size", 0, G_MAXUINT8, (guint8) 7, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
board_instance_init (Board * self,
                     gpointer klass)
{
	self->priv = board_get_instance_private (self);
	self->priv->_line = (guint8) 4;
	self->priv->_size = (guint8) 7;
}

static void
board_finalize (GObject * obj)
{
	Board * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOARD, Board);
	G_OBJECT_CLASS (board_parent_class)->finalize (obj);
}

static GType
board_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Board), 0, (GInstanceInitFunc) board_instance_init, NULL };
	GType board_type_id;
	board_type_id = g_type_register_static (G_TYPE_OBJECT, "Board", &g_define_type_info, 0);
	Board_private_offset = g_type_add_instance_private (board_type_id, sizeof (BoardPrivate));
	return board_type_id;
}

GType
board_get_type (void)
{
	static volatile gsize board_type_id__once = 0;
	if (g_once_init_enter (&board_type_id__once)) {
		GType board_type_id;
		board_type_id = board_get_type_once ();
		g_once_init_leave (&board_type_id__once, board_type_id);
	}
	return board_type_id__once;
}

static void
_vala_board_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Board * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOARD, Board);
	switch (property_id) {
		case BOARD_LINE_PROPERTY:
		g_value_set_uchar (value, board_get_line (self));
		break;
		case BOARD_SIZE_PROPERTY:
		g_value_set_uchar (value, board_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_board_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Board * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOARD, Board);
	switch (property_id) {
		case BOARD_LINE_PROPERTY:
		board_set_line (self, g_value_get_uchar (value));
		break;
		case BOARD_SIZE_PROPERTY:
		board_set_size (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

