/* conversation-list-participant.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from conversation-list-participant.vala, do not modify */

/*
 * Copyright © 2022 John Renner <john@jrenner.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-client-46.0.h"

#define CONVERSATION_LIST_PARTICIPANT_ME "Me"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define CONVERSATION_LIST_TYPE_PARTICIPANT (conversation_list_participant_get_type ())
#define CONVERSATION_LIST_PARTICIPANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipant))
#define CONVERSATION_LIST_PARTICIPANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipantClass))
#define CONVERSATION_LIST_IS_PARTICIPANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONVERSATION_LIST_TYPE_PARTICIPANT))
#define CONVERSATION_LIST_IS_PARTICIPANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONVERSATION_LIST_TYPE_PARTICIPANT))
#define CONVERSATION_LIST_PARTICIPANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipantClass))

typedef struct _ConversationListParticipant ConversationListParticipant;
typedef struct _ConversationListParticipantClass ConversationListParticipantClass;
typedef struct _ConversationListParticipantPrivate ConversationListParticipantPrivate;
enum  {
	CONVERSATION_LIST_PARTICIPANT_0_PROPERTY,
	CONVERSATION_LIST_PARTICIPANT_NUM_PROPERTIES
};
static GParamSpec* conversation_list_participant_properties[CONVERSATION_LIST_PARTICIPANT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ConversationListParticipant {
	GearyBaseObject parent_instance;
	GearyRFC822MailboxAddress* address;
	ConversationListParticipantPrivate * priv;
};

struct _ConversationListParticipantClass {
	GearyBaseObjectClass parent_class;
};

static gpointer conversation_list_participant_parent_class = NULL;
static GeeHashableIface * conversation_list_participant_gee_hashable_parent_iface = NULL;

VALA_EXTERN GType conversation_list_participant_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ConversationListParticipant* conversation_list_participant_new (GearyRFC822MailboxAddress* address);
VALA_EXTERN ConversationListParticipant* conversation_list_participant_construct (GType object_type,
                                                                      GearyRFC822MailboxAddress* address);
VALA_EXTERN gchar* conversation_list_participant_get_full_markup (ConversationListParticipant* self,
                                                      GeeList* account_mailboxes);
static gchar* conversation_list_participant_get_as_markup (ConversationListParticipant* self,
                                                    const gchar* participant);
VALA_EXTERN gchar* conversation_list_participant_get_short_markup (ConversationListParticipant* self,
                                                       GeeList* account_mailboxes);
static gboolean conversation_list_participant_real_equal_to (GeeHashable* base,
                                                      ConversationListParticipant* other);
static guint conversation_list_participant_real_hash (GeeHashable* base);
static void conversation_list_participant_finalize (GObject * obj);
static GType conversation_list_participant_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ConversationListParticipant*
conversation_list_participant_construct (GType object_type,
                                         GearyRFC822MailboxAddress* address)
{
	ConversationListParticipant * self = NULL;
	GearyRFC822MailboxAddress* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (address, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS), NULL);
	self = (ConversationListParticipant*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (address);
	_g_object_unref0 (self->address);
	self->address = _tmp0_;
	return self;
}

ConversationListParticipant*
conversation_list_participant_new (GearyRFC822MailboxAddress* address)
{
	return conversation_list_participant_construct (CONVERSATION_LIST_TYPE_PARTICIPANT, address);
}

gchar*
conversation_list_participant_get_full_markup (ConversationListParticipant* self,
                                               GeeList* account_mailboxes)
{
	gchar* _tmp0_ = NULL;
	GearyRFC822MailboxAddress* _tmp1_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_PARTICIPANT (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account_mailboxes, GEE_TYPE_LIST), NULL);
	_tmp1_ = self->address;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (account_mailboxes, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (CONVERSATION_LIST_PARTICIPANT_ME);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GearyRFC822MailboxAddress* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->address;
		_tmp4_ = geary_rf_c822_mailbox_address_to_short_display (_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = conversation_list_participant_get_as_markup (self, _tmp0_);
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
conversation_list_participant_get_short_markup (ConversationListParticipant* self,
                                                GeeList* account_mailboxes)
{
	GearyRFC822MailboxAddress* _tmp0_;
	GearyRFC822MailboxAddress* _tmp2_;
	gchar* short_address = NULL;
	GearyRFC822MailboxAddress* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar** tokens = NULL;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* first_name = NULL;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_PARTICIPANT (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account_mailboxes, GEE_TYPE_LIST), NULL);
	_tmp0_ = self->address;
	if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (account_mailboxes, GEE_TYPE_COLLECTION, GeeCollection), _tmp0_)) {
		gchar* _tmp1_;
		_tmp1_ = conversation_list_participant_get_as_markup (self, CONVERSATION_LIST_PARTICIPANT_ME);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->address;
	if (geary_rf_c822_mailbox_address_is_spoofed (_tmp2_)) {
		gchar* _tmp3_;
		_tmp3_ = conversation_list_participant_get_full_markup (self, account_mailboxes);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->address;
	_tmp5_ = geary_rf_c822_mailbox_address_to_short_display (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	short_address = _tmp8_;
	_tmp9_ = short_address;
	if (string_contains (_tmp9_, ", ")) {
		gchar** tokens = NULL;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp10_ = short_address;
		_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, ", ", 2);
		tokens = _tmp12_;
		tokens_length1 = _vala_array_length (_tmp11_);
		_tokens_size_ = tokens_length1;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		_tmp14_ = _tmp13_[1];
		_tmp15_ = string_strip (_tmp14_);
		_g_free0 (short_address);
		short_address = _tmp15_;
		_tmp16_ = short_address;
		if (geary_string_is_empty (_tmp16_)) {
			gchar* _tmp17_;
			_tmp17_ = conversation_list_participant_get_full_markup (self, account_mailboxes);
			result = _tmp17_;
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (short_address);
			return result;
		}
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = short_address;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, " ", 2);
	tokens = _tmp20_;
	tokens_length1 = _vala_array_length (_tmp19_);
	_tokens_size_ = tokens_length1;
	_tmp21_ = tokens;
	_tmp21__length1 = tokens_length1;
	if (_tmp21__length1 < 1) {
		gchar* _tmp22_;
		_tmp22_ = conversation_list_participant_get_full_markup (self, account_mailboxes);
		result = _tmp22_;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (short_address);
		return result;
	}
	_tmp23_ = tokens;
	_tmp23__length1 = tokens_length1;
	_tmp24_ = _tmp23_[0];
	_tmp25_ = string_strip (_tmp24_);
	first_name = _tmp25_;
	_tmp26_ = first_name;
	if (geary_string_is_empty_or_whitespace (_tmp26_)) {
		gchar* _tmp27_;
		_tmp27_ = conversation_list_participant_get_full_markup (self, account_mailboxes);
		result = _tmp27_;
		_g_free0 (first_name);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (short_address);
		return result;
	}
	_tmp28_ = first_name;
	_tmp29_ = conversation_list_participant_get_as_markup (self, _tmp28_);
	result = _tmp29_;
	_g_free0 (first_name);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (short_address);
	return result;
}

static gchar*
conversation_list_participant_get_as_markup (ConversationListParticipant* self,
                                             const gchar* participant)
{
	gchar* markup = NULL;
	gchar* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	gchar* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_PARTICIPANT (self), NULL);
	g_return_val_if_fail (participant != NULL, NULL);
	_tmp0_ = geary_html_escape_markup (participant);
	markup = _tmp0_;
	_tmp1_ = self->address;
	if (geary_rf_c822_mailbox_address_is_spoofed (_tmp1_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = markup;
		_tmp3_ = g_strdup_printf ("<s>%s</s>", _tmp2_);
		_g_free0 (markup);
		markup = _tmp3_;
	}
	result = markup;
	return result;
}

static gboolean
conversation_list_participant_real_equal_to (GeeHashable* base,
                                             ConversationListParticipant* other)
{
	ConversationListParticipant * self;
	gboolean _tmp0_ = FALSE;
	GearyRFC822MailboxAddress* _tmp1_;
	GearyRFC822MailboxAddress* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipant);
	g_return_val_if_fail (CONVERSATION_LIST_IS_PARTICIPANT (other), FALSE);
	_tmp1_ = self->address;
	_tmp2_ = other->address;
	if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_HASHABLE, GeeHashable), _tmp2_)) {
		GearyRFC822MailboxAddress* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GearyRFC822MailboxAddress* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->address;
		_tmp4_ = geary_rf_c822_mailbox_address_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = other->address;
		_tmp7_ = geary_rf_c822_mailbox_address_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = g_strcmp0 (_tmp5_, _tmp8_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static guint
conversation_list_participant_real_hash (GeeHashable* base)
{
	ConversationListParticipant * self;
	GearyRFC822MailboxAddress* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipant);
	_tmp0_ = self->address;
	result = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_HASHABLE, GeeHashable));
	return result;
}

static void
conversation_list_participant_class_init (ConversationListParticipantClass * klass,
                                          gpointer klass_data)
{
	conversation_list_participant_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = conversation_list_participant_finalize;
}

static void
conversation_list_participant_gee_hashable_interface_init (GeeHashableIface * iface,
                                                           gpointer iface_data)
{
	conversation_list_participant_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) conversation_list_participant_real_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) conversation_list_participant_real_hash;
}

static void
conversation_list_participant_instance_init (ConversationListParticipant * self,
                                             gpointer klass)
{
}

static void
conversation_list_participant_finalize (GObject * obj)
{
	ConversationListParticipant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipant);
	_g_object_unref0 (self->address);
	G_OBJECT_CLASS (conversation_list_participant_parent_class)->finalize (obj);
}

static GType
conversation_list_participant_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListParticipantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_participant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListParticipant), 0, (GInstanceInitFunc) conversation_list_participant_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) conversation_list_participant_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_list_participant_type_id;
	conversation_list_participant_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ConversationListParticipant", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_list_participant_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	return conversation_list_participant_type_id;
}

GType
conversation_list_participant_get_type (void)
{
	static volatile gsize conversation_list_participant_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_participant_type_id__once)) {
		GType conversation_list_participant_type_id;
		conversation_list_participant_type_id = conversation_list_participant_get_type_once ();
		g_once_init_leave (&conversation_list_participant_type_id__once, conversation_list_participant_type_id);
	}
	return conversation_list_participant_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

