/* imap-mailbox-specifier.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-mailbox-specifier.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_MAILBOX_SPECIFIER_0_PROPERTY,
	GEARY_IMAP_MAILBOX_SPECIFIER_NAME_PROPERTY,
	GEARY_IMAP_MAILBOX_SPECIFIER_IS_INBOX_PROPERTY,
	GEARY_IMAP_MAILBOX_SPECIFIER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_mailbox_specifier_properties[GEARY_IMAP_MAILBOX_SPECIFIER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _GearyImapMailboxSpecifierPrivate {
	gchar* _name;
	gboolean _is_inbox;
};

static gint GearyImapMailboxSpecifier_private_offset;
static gpointer geary_imap_mailbox_specifier_parent_class = NULL;
static GearyImapMailboxSpecifier* geary_imap_mailbox_specifier__inbox;
static GearyImapMailboxSpecifier* geary_imap_mailbox_specifier__inbox = NULL;
static GeeHashableIface * geary_imap_mailbox_specifier_gee_hashable_parent_iface = NULL;
static GeeComparableIface * geary_imap_mailbox_specifier_gee_comparable_parent_iface = NULL;

static void geary_imap_mailbox_specifier_set_name (GearyImapMailboxSpecifier* self,
                                            const gchar* value);
static void geary_imap_mailbox_specifier_set_is_inbox (GearyImapMailboxSpecifier* self,
                                                gboolean value);
static void geary_imap_mailbox_specifier_init (GearyImapMailboxSpecifier* self,
                                        const gchar* decoded);
static guint geary_imap_mailbox_specifier_real_hash (GeeHashable* base);
static gboolean geary_imap_mailbox_specifier_real_equal_to (GeeHashable* base,
                                                     GearyImapMailboxSpecifier* other);
static gint geary_imap_mailbox_specifier_real_compare_to (GeeComparable* base,
                                                   GearyImapMailboxSpecifier* other);
static void geary_imap_mailbox_specifier_finalize (GObject * obj);
static GType geary_imap_mailbox_specifier_get_type_once (void);
static void _vala_geary_imap_mailbox_specifier_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_imap_mailbox_specifier_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
geary_imap_mailbox_specifier_get_instance_private (GearyImapMailboxSpecifier* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapMailboxSpecifier_private_offset);
}

GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_get_inbox (void)
{
	GearyImapMailboxSpecifier* result;
	GearyImapMailboxSpecifier* _tmp0_ = NULL;
	GearyImapMailboxSpecifier* _tmp1_;
	_tmp1_ = geary_imap_mailbox_specifier__inbox;
	if (_tmp1_ != NULL) {
		GearyImapMailboxSpecifier* _tmp2_;
		_tmp2_ = geary_imap_mailbox_specifier__inbox;
		_tmp0_ = _tmp2_;
	} else {
		GearyImapMailboxSpecifier* _tmp3_;
		GearyImapMailboxSpecifier* _tmp4_;
		_tmp3_ = geary_imap_mailbox_specifier_new (GEARY_IMAP_MAILBOX_SPECIFIER_CANONICAL_INBOX_NAME);
		_g_object_unref0 (geary_imap_mailbox_specifier__inbox);
		geary_imap_mailbox_specifier__inbox = _tmp3_;
		_tmp4_ = geary_imap_mailbox_specifier__inbox;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

const gchar*
geary_imap_mailbox_specifier_get_name (GearyImapMailboxSpecifier* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_imap_mailbox_specifier_set_name (GearyImapMailboxSpecifier* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self));
	old_value = geary_imap_mailbox_specifier_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_mailbox_specifier_properties[GEARY_IMAP_MAILBOX_SPECIFIER_NAME_PROPERTY]);
	}
}

gboolean
geary_imap_mailbox_specifier_get_is_inbox (GearyImapMailboxSpecifier* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), FALSE);
	result = self->priv->_is_inbox;
	return result;
}

static void
geary_imap_mailbox_specifier_set_is_inbox (GearyImapMailboxSpecifier* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self));
	old_value = geary_imap_mailbox_specifier_get_is_inbox (self);
	if (old_value != value) {
		self->priv->_is_inbox = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_mailbox_specifier_properties[GEARY_IMAP_MAILBOX_SPECIFIER_IS_INBOX_PROPERTY]);
	}
}

/**
     * Constructs a new specifier from a UTF-8 name.
     */
GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_construct (GType object_type,
                                        const gchar* name)
{
	GearyImapMailboxSpecifier * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GearyImapMailboxSpecifier*) geary_base_object_construct (object_type);
	geary_imap_mailbox_specifier_init (self, name);
	return self;
}

GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_new (const gchar* name)
{
	return geary_imap_mailbox_specifier_construct (GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, name);
}

/**
     * Constructs a new specifier from a IMAP modified-UTF-7 string.
     *
     * If a modified-UTF-7 decoding error occurs, the parameter will
     * assumed to be UTF-8, repaired, and used instead.
     */
GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_construct_from_parameter (GType object_type,
                                                       GearyImapStringParameter* param)
{
	GearyImapMailboxSpecifier * self = NULL;
	gchar* name = NULL;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (param), NULL);
	self = (GearyImapMailboxSpecifier*) geary_base_object_construct (object_type);
	name = NULL;
	{
		gchar* _tmp0_ = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = geary_imap_string_parameter_get_ascii (param);
		_tmp2_ = _tmp1_;
		_tmp3_ = geary_imap_utf7_imap_utf7_to_utf8 (_tmp2_, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (name);
		name = _tmp4_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_debug ("imap-mailbox-specifier.vala:74: Error decoding mailbox name, assuming " \
"UTF-8: %s", _tmp6_);
		_tmp7_ = geary_imap_string_parameter_get_ascii (param);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_make_valid (_tmp8_, (gssize) -1);
		_g_free0 (name);
		name = _tmp9_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = name;
	geary_imap_mailbox_specifier_init (self, _tmp10_);
	_g_free0 (name);
	return self;
}

GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_new_from_parameter (GearyImapStringParameter* param)
{
	return geary_imap_mailbox_specifier_construct_from_parameter (GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, param);
}

/**
     * Returns true if the {@link Geary.FolderPath} points to the IMAP Inbox.
     */
gboolean
geary_imap_mailbox_specifier_folder_path_is_inbox (GearyFolderPath* path)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (path), FALSE);
	_tmp1_ = geary_folder_path_get_is_top_level (path);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = geary_folder_path_get_name (path);
		_tmp4_ = _tmp3_;
		_tmp0_ = geary_imap_mailbox_specifier_is_inbox_name (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns true if the string is the name of the IMAP Inbox.
     *
     * This accounts for IMAP's Inbox name being case-insensitive.  This is only for comparing
     * folder names; this does not account for path delimiters.
     *
     * See [[http://tools.ietf.org/html/rfc3501#section-5.1]]
     *
     * @see is_canonical_inbox_name
     */
gboolean
geary_imap_mailbox_specifier_is_inbox_name (const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = geary_ascii_stri_equal (name, GEARY_IMAP_MAILBOX_SPECIFIER_CANONICAL_INBOX_NAME);
	return result;
}

/**
     * Returns true if the string is the ''canonical'' name of the IMAP Inbox.
     *
     * For sanity reasons, the Geary engine uses {@link CANONICAL_INBOX_NAME} as the "canonical"
     * IMAP Inbox name.  This verifies that the string is truly canonical, i.e. a case-sensitive
     * comparison is made.
     *
     * See [[http://tools.ietf.org/html/rfc3501#section-5.1]]
     *
     * @see is_inbox_name
     */
gboolean
geary_imap_mailbox_specifier_is_canonical_inbox_name (const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = geary_ascii_str_equal (name, GEARY_IMAP_MAILBOX_SPECIFIER_CANONICAL_INBOX_NAME);
	return result;
}

/**
     * Converts a generic {@link FolderPath} into an IMAP mailbox specifier.
     */
GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_construct_from_folder_path (GType object_type,
                                                         GearyFolderPath* path,
                                                         GearyImapMailboxSpecifier* inbox,
                                                         const gchar* delim,
                                                         GError** error)
{
	GearyImapMailboxSpecifier * self = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar** parts = NULL;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	GString* builder = NULL;
	GString* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GString* _tmp32_;
	const gchar* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (path), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (inbox), NULL);
	self = (GearyImapMailboxSpecifier*) geary_base_object_construct (object_type);
	_tmp0_ = geary_folder_path_get_is_root (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Cannot convert root path into a mailbox");
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = geary_folder_path_as_array (path, &_tmp3_);
	parts = _tmp4_;
	parts_length1 = _tmp3_;
	_parts_size_ = parts_length1;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	if (_tmp6__length1 > 1) {
		_tmp5_ = delim == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "Path has more than one part but no delimiter given");
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = parts;
	_tmp8__length1 = parts_length1;
	_tmp9_ = _tmp8_[0];
	if (geary_string_is_empty_or_whitespace (_tmp9_)) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp10_ = geary_folder_path_to_string (path);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "Path contains empty base part: '%s'", _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = parts;
	_tmp15__length1 = parts_length1;
	_tmp16_ = _tmp15_[0];
	if (geary_imap_mailbox_specifier_is_inbox_name (_tmp16_)) {
		const gchar* _tmp17_;
		_tmp17_ = inbox->priv->_name;
		_tmp14_ = _tmp17_;
	} else {
		gchar** _tmp18_;
		gint _tmp18__length1;
		const gchar* _tmp19_;
		_tmp18_ = parts;
		_tmp18__length1 = parts_length1;
		_tmp19_ = _tmp18_[0];
		_tmp14_ = _tmp19_;
	}
	_tmp20_ = g_string_new (_tmp14_);
	builder = _tmp20_;
	_tmp21_ = parts;
	_tmp21__length1 = parts_length1;
	_tmp22_ = parts;
	_tmp22__length1 = parts_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp21_ + 1;
		name_collection_length1 = _tmp22__length1 - 1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp23_;
			gchar* name = NULL;
			_tmp23_ = g_strdup (name_collection[name_it]);
			name = _tmp23_;
			{
				const gchar* _tmp24_;
				GString* _tmp29_;
				GString* _tmp30_;
				const gchar* _tmp31_;
				_tmp24_ = name;
				if (geary_string_is_empty_or_whitespace (_tmp24_)) {
					gchar* _tmp25_;
					gchar* _tmp26_;
					GError* _tmp27_;
					GError* _tmp28_;
					_tmp25_ = geary_folder_path_to_string (path);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "Path contains empty part: '%s'", _tmp26_);
					_tmp28_ = _tmp27_;
					_g_free0 (_tmp26_);
					_inner_error0_ = _tmp28_;
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						_g_string_free0 (builder);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (name);
						_g_string_free0 (builder);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp29_ = builder;
				g_string_append (_tmp29_, delim);
				_tmp30_ = builder;
				_tmp31_ = name;
				g_string_append (_tmp30_, _tmp31_);
				_g_free0 (name);
			}
		}
	}
	_tmp32_ = builder;
	_tmp33_ = _tmp32_->str;
	geary_imap_mailbox_specifier_init (self, _tmp33_);
	_g_string_free0 (builder);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

GearyImapMailboxSpecifier*
geary_imap_mailbox_specifier_new_from_folder_path (GearyFolderPath* path,
                                                   GearyImapMailboxSpecifier* inbox,
                                                   const gchar* delim,
                                                   GError** error)
{
	return geary_imap_mailbox_specifier_construct_from_folder_path (GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, path, inbox, delim, error);
}

static void
geary_imap_mailbox_specifier_init (GearyImapMailboxSpecifier* self,
                                   const gchar* decoded)
{
	g_return_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self));
	g_return_if_fail (decoded != NULL);
	geary_imap_mailbox_specifier_set_name (self, decoded);
	geary_imap_mailbox_specifier_set_is_inbox (self, geary_imap_mailbox_specifier_is_inbox_name (decoded));
}

/**
     * The mailbox's path as a list of strings.
     *
     * Will always return a list with at least one element in it.  If no delimiter is specified,
     * the name is returned as a single element.
     */
GeeList*
geary_imap_mailbox_specifier_to_list (GearyImapMailboxSpecifier* self,
                                      const gchar* delim)
{
	GeeList* path = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), NULL);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	path = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	if (!geary_string_is_empty (delim)) {
		gchar** split = NULL;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint split_length1;
		gint _split_size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = self->priv->_name;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, delim, 0);
		split = _tmp3_;
		split_length1 = _vala_array_length (_tmp2_);
		_split_size_ = split_length1;
		_tmp4_ = split;
		_tmp4__length1 = split_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp4_;
			str_collection_length1 = _tmp4__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				gchar* _tmp5_;
				gchar* str = NULL;
				_tmp5_ = g_strdup (str_collection[str_it]);
				str = _tmp5_;
				{
					const gchar* _tmp6_;
					_tmp6_ = str;
					if (!geary_string_is_empty (_tmp6_)) {
						GeeList* _tmp7_;
						const gchar* _tmp8_;
						_tmp7_ = path;
						_tmp8_ = str;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp8_);
					}
					_g_free0 (str);
				}
			}
		}
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp9_ = path;
	_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 0) {
		GeeList* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = path;
		_tmp13_ = self->priv->_name;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
	}
	result = path;
	return result;
}

/**
     * Converts the mailbox into a folder path.
     *
     * If the inbox_specifier is supplied and the first element
     * matches it, the canonical Inbox name is used in its place.
     * This is useful for XLIST where that command returns a
     * translated name but the standard IMAP name ("INBOX") must be
     * used in addressing its children.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyFolderPath*
geary_imap_mailbox_specifier_to_folder_path (GearyImapMailboxSpecifier* self,
                                             GearyImapFolderRoot* root,
                                             const gchar* delim,
                                             GearyImapMailboxSpecifier* inbox_specifier)
{
	GeeList* list = NULL;
	GeeList* _tmp0_;
	GearyFolderPath* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GearyFolderPath* path = NULL;
	GearyFolderPath* _tmp12_;
	GeeList* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	GearyFolderPath* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_FOLDER_ROOT (root), NULL);
	g_return_val_if_fail ((inbox_specifier == NULL) || GEARY_IMAP_IS_MAILBOX_SPECIFIER (inbox_specifier), NULL);
	_tmp0_ = geary_imap_mailbox_specifier_to_list (self, delim);
	list = _tmp0_;
	if (inbox_specifier != NULL) {
		GeeList* _tmp3_;
		gpointer _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = list;
		_tmp4_ = gee_list_get (_tmp3_, 0);
		_tmp5_ = (gchar*) _tmp4_;
		_tmp6_ = inbox_specifier->priv->_name;
		_tmp2_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
		_g_free0 (_tmp5_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GearyFolderPath* _tmp7_;
		_tmp7_ = geary_folder_path_get_child (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_TYPE_FOLDER_PATH, GearyFolderPath), GEARY_IMAP_MAILBOX_SPECIFIER_CANONICAL_INBOX_NAME, GEARY_TRILLIAN_UNKNOWN);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp7_;
	} else {
		GeeList* _tmp8_;
		gpointer _tmp9_;
		gchar* _tmp10_;
		GearyFolderPath* _tmp11_;
		_tmp8_ = list;
		_tmp9_ = gee_list_get (_tmp8_, 0);
		_tmp10_ = (gchar*) _tmp9_;
		_tmp11_ = geary_folder_path_get_child (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_TYPE_FOLDER_PATH, GearyFolderPath), _tmp10_, GEARY_TRILLIAN_UNKNOWN);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp11_;
		_g_free0 (_tmp10_);
	}
	_tmp12_ = _g_object_ref0 (_tmp1_);
	path = _tmp12_;
	_tmp13_ = list;
	_tmp14_ = gee_list_remove_at (_tmp13_, 0);
	_tmp15_ = (gchar*) _tmp14_;
	_g_free0 (_tmp15_);
	{
		GeeList* _name_list = NULL;
		GeeList* _tmp16_;
		gint _name_size = 0;
		GeeList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _name_index = 0;
		_tmp16_ = list;
		_name_list = _tmp16_;
		_tmp17_ = _name_list;
		_tmp18_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp19_ = _tmp18_;
		_name_size = _tmp19_;
		_name_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			gchar* name = NULL;
			GeeList* _tmp22_;
			gpointer _tmp23_;
			GearyFolderPath* _tmp24_;
			const gchar* _tmp25_;
			GearyFolderPath* _tmp26_;
			_name_index = _name_index + 1;
			_tmp20_ = _name_index;
			_tmp21_ = _name_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _name_list;
			_tmp23_ = gee_list_get (_tmp22_, _name_index);
			name = (gchar*) _tmp23_;
			_tmp24_ = path;
			_tmp25_ = name;
			_tmp26_ = geary_folder_path_get_child (_tmp24_, _tmp25_, GEARY_TRILLIAN_UNKNOWN);
			_g_object_unref0 (path);
			path = _tmp26_;
			_g_free0 (name);
		}
	}
	result = path;
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (list);
	return result;
}

/**
     * The mailbox's name without parent folders.
     *
     * If name is non-empty, will return a non-empty value which is the final folder name (i.e.
     * the parent components are stripped).  If no delimiter is specified, the name is returned.
     */
static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
geary_imap_mailbox_specifier_get_basename (GearyImapMailboxSpecifier* self,
                                           const gchar* delim)
{
	gint index = 0;
	const gchar* _tmp2_;
	gchar* basename = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), NULL);
	if (geary_string_is_empty (delim)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->_name;
		_tmp1_ = g_strdup (_tmp0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_name;
	index = string_last_index_of (_tmp2_, delim, 0);
	if (index < 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->_name;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->_name;
	_tmp6_ = string_substring (_tmp5_, (glong) (index + 1), (glong) -1);
	basename = _tmp6_;
	_tmp8_ = basename;
	if (!geary_string_is_empty (_tmp8_)) {
		const gchar* _tmp9_;
		_tmp9_ = basename;
		_tmp7_ = _tmp9_;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->_name;
		_tmp7_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp7_);
	result = _tmp11_;
	_g_free0 (basename);
	return result;
}

GearyImapParameter*
geary_imap_mailbox_specifier_to_parameter (GearyImapMailboxSpecifier* self)
{
	gchar* encoded = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapParameter* param = NULL;
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = geary_imap_utf7_utf8_to_imap_utf7 (_tmp0_);
	encoded = _tmp1_;
	param = NULL;
	{
		GearyImapStringParameter* _tmp2_ = NULL;
		GearyImapStringParameter* _tmp3_;
		GearyImapStringParameter* _tmp4_;
		_tmp3_ = geary_imap_string_parameter_get_best_for (encoded, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			_g_object_unref0 (param);
			_g_free0 (encoded);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (param);
		param = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		GearyMemoryStringBuffer* _tmp5_;
		GearyMemoryStringBuffer* _tmp6_;
		GearyImapLiteralParameter* _tmp7_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = geary_memory_string_buffer_new (encoded);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_imap_literal_parameter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_g_object_unref0 (param);
		param = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
		_g_object_unref0 (_tmp6_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (param);
		_g_free0 (encoded);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = param;
	_g_free0 (encoded);
	return result;
}

static guint
geary_imap_mailbox_specifier_real_hash (GeeHashable* base)
{
	GearyImapMailboxSpecifier * self;
	guint _tmp0_ = 0U;
	gboolean _tmp1_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, GearyImapMailboxSpecifier);
	_tmp1_ = self->priv->_is_inbox;
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_name;
		_tmp0_ = geary_ascii_stri_hash (_tmp2_);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_name;
		_tmp0_ = geary_ascii_str_hash (_tmp3_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
geary_imap_mailbox_specifier_real_equal_to (GeeHashable* base,
                                            GearyImapMailboxSpecifier* other)
{
	GearyImapMailboxSpecifier * self;
	gboolean _tmp0_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, GearyImapMailboxSpecifier);
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (other), FALSE);
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_is_inbox;
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_name;
		_tmp2_ = other->priv->_name;
		result = geary_ascii_stri_equal (_tmp1_, _tmp2_);
		return result;
	}
	_tmp3_ = self->priv->_name;
	_tmp4_ = other->priv->_name;
	result = geary_ascii_str_equal (_tmp3_, _tmp4_);
	return result;
}

static gint
geary_imap_mailbox_specifier_real_compare_to (GeeComparable* base,
                                              GearyImapMailboxSpecifier* other)
{
	GearyImapMailboxSpecifier * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, GearyImapMailboxSpecifier);
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (other), 0);
	if (self == other) {
		result = 0;
		return result;
	}
	_tmp1_ = self->priv->_is_inbox;
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = other->priv->_is_inbox;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp3_ = self->priv->_name;
	_tmp4_ = other->priv->_name;
	result = geary_ascii_strcmp (_tmp3_, _tmp4_);
	return result;
}

gchar*
geary_imap_mailbox_specifier_to_string (GearyImapMailboxSpecifier* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (self), NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_imap_mailbox_specifier_class_init (GearyImapMailboxSpecifierClass * klass,
                                         gpointer klass_data)
{
	geary_imap_mailbox_specifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapMailboxSpecifier_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_mailbox_specifier_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_mailbox_specifier_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_mailbox_specifier_finalize;
	/**
	     * Decoded mailbox path name.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MAILBOX_SPECIFIER_NAME_PROPERTY, geary_imap_mailbox_specifier_properties[GEARY_IMAP_MAILBOX_SPECIFIER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Indicates this is the {@link StatusData} for Inbox.
	     *
	     * IMAP guarantees only one mailbox in an account: Inbox.
	     *
	     * See [[http://tools.ietf.org/html/rfc3501#section-5.1]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MAILBOX_SPECIFIER_IS_INBOX_PROPERTY, geary_imap_mailbox_specifier_properties[GEARY_IMAP_MAILBOX_SPECIFIER_IS_INBOX_PROPERTY] = g_param_spec_boolean ("is-inbox", "is-inbox", "is-inbox", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_mailbox_specifier_gee_hashable_interface_init (GeeHashableIface * iface,
                                                          gpointer iface_data)
{
	geary_imap_mailbox_specifier_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) geary_imap_mailbox_specifier_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_imap_mailbox_specifier_real_equal_to;
}

static void
geary_imap_mailbox_specifier_gee_comparable_interface_init (GeeComparableIface * iface,
                                                            gpointer iface_data)
{
	geary_imap_mailbox_specifier_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) geary_imap_mailbox_specifier_real_compare_to;
}

static void
geary_imap_mailbox_specifier_instance_init (GearyImapMailboxSpecifier * self,
                                            gpointer klass)
{
	self->priv = geary_imap_mailbox_specifier_get_instance_private (self);
}

static void
geary_imap_mailbox_specifier_finalize (GObject * obj)
{
	GearyImapMailboxSpecifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, GearyImapMailboxSpecifier);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (geary_imap_mailbox_specifier_parent_class)->finalize (obj);
}

/**
 * Represents an IMAP mailbox name or path (more commonly known as a folder).
 *
 * Can also be used to specify a wildcarded name for the {@link ListCommand}.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-5.1]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_mailbox_specifier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapMailboxSpecifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_mailbox_specifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapMailboxSpecifier), 0, (GInstanceInitFunc) geary_imap_mailbox_specifier_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_imap_mailbox_specifier_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) geary_imap_mailbox_specifier_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_mailbox_specifier_type_id;
	geary_imap_mailbox_specifier_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapMailboxSpecifier", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_mailbox_specifier_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	g_type_add_interface_static (geary_imap_mailbox_specifier_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	GearyImapMailboxSpecifier_private_offset = g_type_add_instance_private (geary_imap_mailbox_specifier_type_id, sizeof (GearyImapMailboxSpecifierPrivate));
	return geary_imap_mailbox_specifier_type_id;
}

GType
geary_imap_mailbox_specifier_get_type (void)
{
	static gsize geary_imap_mailbox_specifier_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_mailbox_specifier_type_id__once)) {
		GType geary_imap_mailbox_specifier_type_id;
		geary_imap_mailbox_specifier_type_id = geary_imap_mailbox_specifier_get_type_once ();
		g_once_init_leave (&geary_imap_mailbox_specifier_type_id__once, geary_imap_mailbox_specifier_type_id);
	}
	return geary_imap_mailbox_specifier_type_id__once;
}

static void
_vala_geary_imap_mailbox_specifier_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapMailboxSpecifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, GearyImapMailboxSpecifier);
	switch (property_id) {
		case GEARY_IMAP_MAILBOX_SPECIFIER_NAME_PROPERTY:
		g_value_set_string (value, geary_imap_mailbox_specifier_get_name (self));
		break;
		case GEARY_IMAP_MAILBOX_SPECIFIER_IS_INBOX_PROPERTY:
		g_value_set_boolean (value, geary_imap_mailbox_specifier_get_is_inbox (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_mailbox_specifier_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearyImapMailboxSpecifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, GearyImapMailboxSpecifier);
	switch (property_id) {
		case GEARY_IMAP_MAILBOX_SPECIFIER_NAME_PROPERTY:
		geary_imap_mailbox_specifier_set_name (self, g_value_get_string (value));
		break;
		case GEARY_IMAP_MAILBOX_SPECIFIER_IS_INBOX_PROPERTY:
		geary_imap_mailbox_specifier_set_is_inbox (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

