/* gitg-ext-activity.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ext-activity.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static gboolean gitg_ext_activity_real_is_default_for (GitgExtActivity* self,
                                                const gchar* action);
static gboolean gitg_ext_activity_real_on_key_pressed (GitgExtActivity* self,
                                                GdkEventKey* event);
static GType gitg_ext_activity_get_type_once (void);

/**
 * Whether the activity is the default for the specified action.
 *
 * @param action the action.
 *
 * @return true if the activity is the default activity for @action,
 *         false otherwise.
 */
static gboolean
gitg_ext_activity_real_is_default_for (GitgExtActivity* self,
                                       const gchar* action)
{
	gboolean result;
	g_return_val_if_fail (action != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
gitg_ext_activity_is_default_for (GitgExtActivity* self,
                                  const gchar* action)
{
	GitgExtActivityIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_EXT_ACTIVITY_GET_INTERFACE (self);
	if (_iface_->is_default_for) {
		return _iface_->is_default_for (self, action);
	}
	return FALSE;
}

/**
 * Activity receives a key event to process it.
 *
 * @param event the key event
 *
 * @return true if the key event is consumed by this activity.
 */
static gboolean
gitg_ext_activity_real_on_key_pressed (GitgExtActivity* self,
                                       GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
gitg_ext_activity_on_key_pressed (GitgExtActivity* self,
                                  GdkEventKey* event)
{
	GitgExtActivityIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_EXT_ACTIVITY_GET_INTERFACE (self);
	if (_iface_->on_key_pressed) {
		return _iface_->on_key_pressed (self, event);
	}
	return FALSE;
}

static void
gitg_ext_activity_default_init (GitgExtActivityIface * iface,
                                gpointer iface_data)
{
	iface->is_default_for = gitg_ext_activity_real_is_default_for;
	iface->on_key_pressed = gitg_ext_activity_real_on_key_pressed;
}

/**
 * gitg Activity interface.
 *
 * The Activity interface can be implemented to provide a main activity in
 * gitg. An example of such activities are the builtin History and
 * Commit activities.
 */
 G_GNUC_NO_INLINE static GType
gitg_ext_activity_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtActivityIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_activity_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gitg_ext_activity_type_id;
	gitg_ext_activity_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgExtActivity", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gitg_ext_activity_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (gitg_ext_activity_type_id, GITG_EXT_TYPE_UI_ELEMENT);
	return gitg_ext_activity_type_id;
}

GType
gitg_ext_activity_get_type (void)
{
	static gsize gitg_ext_activity_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_activity_type_id__once)) {
		GType gitg_ext_activity_type_id;
		gitg_ext_activity_type_id = gitg_ext_activity_get_type_once ();
		g_once_init_leave (&gitg_ext_activity_type_id__once, gitg_ext_activity_type_id);
	}
	return gitg_ext_activity_type_id__once;
}

