/* gitg-history-refs-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-history-refs-list.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgit2-glib/ggit.h>
#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#define GITG_HISTORY_REF_ROW_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GITG_HISTORY_REF_ANIMATION_NONE,
	GITG_HISTORY_REF_ANIMATION_ANIMATE
} GitgHistoryRefAnimation;

#define GITG_HISTORY_TYPE_REF_ANIMATION (gitg_history_ref_animation_get_type ())

#define GITG_HISTORY_TYPE_REF_TYPED (gitg_history_ref_typed_get_type ())
#define GITG_HISTORY_REF_TYPED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTyped))
#define GITG_HISTORY_IS_REF_TYPED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REF_TYPED))
#define GITG_HISTORY_REF_TYPED_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTypedIface))

typedef struct _GitgHistoryRefTyped GitgHistoryRefTyped;
typedef struct _GitgHistoryRefTypedIface GitgHistoryRefTypedIface;

#define GITG_HISTORY_TYPE_REF_ROW (gitg_history_ref_row_get_type ())
#define GITG_HISTORY_REF_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow))
#define GITG_HISTORY_REF_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRowClass))
#define GITG_HISTORY_IS_REF_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REF_ROW))
#define GITG_HISTORY_IS_REF_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REF_ROW))
#define GITG_HISTORY_REF_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRowClass))

typedef struct _GitgHistoryRefRow GitgHistoryRefRow;
typedef struct _GitgHistoryRefRowClass GitgHistoryRefRowClass;
typedef struct _GitgHistoryRefRowPrivate GitgHistoryRefRowPrivate;
enum  {
	GITG_HISTORY_REF_ROW_0_PROPERTY,
	GITG_HISTORY_REF_ROW_REFERENCE_PROPERTY,
	GITG_HISTORY_REF_ROW_REF_TYPE_PROPERTY,
	GITG_HISTORY_REF_ROW_UPDATED_PROPERTY,
	GITG_HISTORY_REF_ROW_IS_HEAD_PROPERTY,
	GITG_HISTORY_REF_ROW_NUM_PROPERTIES
};
static GParamSpec* gitg_history_ref_row_properties[GITG_HISTORY_REF_ROW_NUM_PROPERTIES];
typedef enum  {
	GITG_HISTORY_REF_ROW_SORT_ORDER_LAST_ACTIVITY = 0,
	GITG_HISTORY_REF_ROW_SORT_ORDER_NAME = 1
} GitgHistoryRefRowSortOrder;

#define GITG_HISTORY_REF_ROW_TYPE_SORT_ORDER (gitg_history_ref_row_sort_order_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block43Data Block43Data;

#define GITG_HISTORY_TYPE_REF_HEADER (gitg_history_ref_header_get_type ())
#define GITG_HISTORY_REF_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader))
#define GITG_HISTORY_REF_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeaderClass))
#define GITG_HISTORY_IS_REF_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REF_HEADER))
#define GITG_HISTORY_IS_REF_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REF_HEADER))
#define GITG_HISTORY_REF_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeaderClass))

typedef struct _GitgHistoryRefHeader GitgHistoryRefHeader;
typedef struct _GitgHistoryRefHeaderClass GitgHistoryRefHeaderClass;
typedef struct _GitgHistoryRefHeaderPrivate GitgHistoryRefHeaderPrivate;
enum  {
	GITG_HISTORY_REF_HEADER_0_PROPERTY,
	GITG_HISTORY_REF_HEADER_ACTIONS_PROPERTY,
	GITG_HISTORY_REF_HEADER_REMOTE_STATE_PROPERTY,
	GITG_HISTORY_REF_HEADER_EXPANDED_PROPERTY,
	GITG_HISTORY_REF_HEADER_REF_TYPE_PROPERTY,
	GITG_HISTORY_REF_HEADER_REF_NAME_PROPERTY,
	GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE_PROPERTY,
	GITG_HISTORY_REF_HEADER_ICON_NAME_PROPERTY,
	GITG_HISTORY_REF_HEADER_NUM_PROPERTIES
};
static GParamSpec* gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_NUM_PROPERTIES];

#define GITG_HISTORY_TYPE_REFS_LIST (gitg_history_refs_list_get_type ())
#define GITG_HISTORY_REFS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList))
#define GITG_HISTORY_REFS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListClass))
#define GITG_HISTORY_IS_REFS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REFS_LIST))
#define GITG_HISTORY_IS_REFS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REFS_LIST))
#define GITG_HISTORY_REFS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListClass))

typedef struct _GitgHistoryRefsList GitgHistoryRefsList;
typedef struct _GitgHistoryRefsListClass GitgHistoryRefsListClass;
typedef struct _GitgHistoryRefsListPrivate GitgHistoryRefsListPrivate;

#define GITG_HISTORY_REFS_LIST_TYPE_HEADER_STATE (gitg_history_refs_list_header_state_get_type ())
typedef struct _GitgHistoryRefsListHeaderState GitgHistoryRefsListHeaderState;

#define GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER (gitg_history_refs_list_remote_header_get_type ())
#define GITG_HISTORY_REFS_LIST_REMOTE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeader))
#define GITG_HISTORY_REFS_LIST_REMOTE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeaderClass))
#define GITG_HISTORY_REFS_LIST_IS_REMOTE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER))
#define GITG_HISTORY_REFS_LIST_IS_REMOTE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER))
#define GITG_HISTORY_REFS_LIST_REMOTE_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeaderClass))

typedef struct _GitgHistoryRefsListRemoteHeader GitgHistoryRefsListRemoteHeader;
typedef struct _GitgHistoryRefsListRemoteHeaderClass GitgHistoryRefsListRemoteHeaderClass;
enum  {
	GITG_HISTORY_REFS_LIST_0_PROPERTY,
	GITG_HISTORY_REFS_LIST_BRANCHES_HEADER_PROPERTY,
	GITG_HISTORY_REFS_LIST_REMOTES_HEADER_PROPERTY,
	GITG_HISTORY_REFS_LIST_TAGS_HEADER_PROPERTY,
	GITG_HISTORY_REFS_LIST_BRANCHES_ACTIONS_PROPERTY,
	GITG_HISTORY_REFS_LIST_REMOTES_ACTIONS_PROPERTY,
	GITG_HISTORY_REFS_LIST_TAGS_ACTIONS_PROPERTY,
	GITG_HISTORY_REFS_LIST_APPLICATION_PROPERTY,
	GITG_HISTORY_REFS_LIST_REPOSITORY_PROPERTY,
	GITG_HISTORY_REFS_LIST_REFERENCES_PROPERTY,
	GITG_HISTORY_REFS_LIST_REFERENCE_SORT_ORDER_PROPERTY,
	GITG_HISTORY_REFS_LIST_ALL_PROPERTY,
	GITG_HISTORY_REFS_LIST_IS_HEADER_PROPERTY,
	GITG_HISTORY_REFS_LIST_IS_ALL_PROPERTY,
	GITG_HISTORY_REFS_LIST_SELECTION_PROPERTY,
	GITG_HISTORY_REFS_LIST_NUM_PROPERTIES
};
static GParamSpec* gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_NUM_PROPERTIES];

#define GITG_HISTORY_TYPE_ACTION_INTERFACE (gitg_history_action_interface_get_type ())
#define GITG_HISTORY_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_ACTION_INTERFACE, GitgHistoryActionInterface))
#define GITG_HISTORY_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_ACTION_INTERFACE, GitgHistoryActionInterfaceClass))
#define GITG_HISTORY_IS_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_ACTION_INTERFACE))
#define GITG_HISTORY_IS_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_ACTION_INTERFACE))
#define GITG_HISTORY_ACTION_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_ACTION_INTERFACE, GitgHistoryActionInterfaceClass))

typedef struct _GitgHistoryActionInterface GitgHistoryActionInterface;
typedef struct _GitgHistoryActionInterfaceClass GitgHistoryActionInterfaceClass;

#define GITG_TYPE_REF_ACTION_FETCH (gitg_ref_action_fetch_get_type ())
#define GITG_REF_ACTION_FETCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_FETCH, GitgRefActionFetch))
#define GITG_REF_ACTION_FETCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_FETCH, GitgRefActionFetchClass))
#define GITG_IS_REF_ACTION_FETCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_FETCH))
#define GITG_IS_REF_ACTION_FETCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_FETCH))
#define GITG_REF_ACTION_FETCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_FETCH, GitgRefActionFetchClass))

typedef struct _GitgRefActionFetch GitgRefActionFetch;
typedef struct _GitgRefActionFetchClass GitgRefActionFetchClass;

#define GITG_TYPE_EDIT_REMOTE_ACTION (gitg_edit_remote_action_get_type ())
#define GITG_EDIT_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_EDIT_REMOTE_ACTION, GitgEditRemoteAction))
#define GITG_EDIT_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_EDIT_REMOTE_ACTION, GitgEditRemoteActionClass))
#define GITG_IS_EDIT_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_EDIT_REMOTE_ACTION))
#define GITG_IS_EDIT_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_EDIT_REMOTE_ACTION))
#define GITG_EDIT_REMOTE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_EDIT_REMOTE_ACTION, GitgEditRemoteActionClass))

typedef struct _GitgEditRemoteAction GitgEditRemoteAction;
typedef struct _GitgEditRemoteActionClass GitgEditRemoteActionClass;

#define GITG_TYPE_REMOVE_REMOTE_ACTION (gitg_remove_remote_action_get_type ())
#define GITG_REMOVE_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteAction))
#define GITG_REMOVE_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteActionClass))
#define GITG_IS_REMOVE_REMOTE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOVE_REMOTE_ACTION))
#define GITG_IS_REMOVE_REMOTE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOVE_REMOTE_ACTION))
#define GITG_REMOVE_REMOTE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOVE_REMOTE_ACTION, GitgRemoveRemoteActionClass))

typedef struct _GitgRemoveRemoteAction GitgRemoveRemoteAction;
typedef struct _GitgRemoveRemoteActionClass GitgRemoveRemoteActionClass;
#define _gitg_history_refs_list_remote_header_unref0(var) ((var == NULL) ? NULL : (var = (gitg_history_refs_list_remote_header_unref (var), NULL)))
typedef struct _GitgHistoryRefsListRemoteHeaderPrivate GitgHistoryRefsListRemoteHeaderPrivate;
typedef struct _Block44Data Block44Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef enum  {
	GITG_HISTORY_DEFAULT_SELECTION_CURRENT_BRANCH,
	GITG_HISTORY_DEFAULT_SELECTION_ALL_BRANCHES,
	GITG_HISTORY_DEFAULT_SELECTION_ALL_COMMITS
} GitgHistoryDefaultSelection;

#define GITG_HISTORY_TYPE_DEFAULT_SELECTION (gitg_history_default_selection_get_type ())
typedef struct _Block45Data Block45Data;
typedef struct _GitgHistoryRefsListParamSpecRemoteHeader GitgHistoryRefsListParamSpecRemoteHeader;
enum  {
	GITG_HISTORY_REFS_LIST_CHANGED_SIGNAL,
	GITG_HISTORY_REFS_LIST_NUM_SIGNALS
};
static guint gitg_history_refs_list_signals[GITG_HISTORY_REFS_LIST_NUM_SIGNALS] = {0};

struct _GitgHistoryRefTypedIface {
	GTypeInterface parent_iface;
	GitgRefType (*get_ref_type) (GitgHistoryRefTyped* self);
};

struct _GitgHistoryRefRow {
	GtkListBoxRow parent_instance;
	GitgHistoryRefRowPrivate * priv;
};

struct _GitgHistoryRefRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgHistoryRefRowPrivate {
	GtkImage* d_icon;
	GtkLabel* d_label;
	GtkLabel* d_ahead_behind;
	GtkBox* d_box;
	GtkRevealer* d_revealer;
	GitgRef* _reference;
	GgitSignature* d_updated;
	GtkEntry* d_editing_entry;
	guint d_idle_finish;
	GitgExtRefNameEditingDone d_edit_done_callback;
	gpointer d_edit_done_callback_target;
	GDestroyNotify d_edit_done_callback_target_destroy_notify;
};

struct _Block43Data {
	int _ref_count_;
	GitgHistoryRefRow* self;
	gboolean cancelled;
};

struct _GitgHistoryRefHeader {
	GtkListBoxRow parent_instance;
	GitgHistoryRefHeaderPrivate * priv;
};

struct _GitgHistoryRefHeaderClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgHistoryRefHeaderPrivate {
	GitgRefType d_rtype;
	gboolean d_is_sub_header_remote;
	gchar* d_name;
	GeeLinkedList* _actions;
	GitgRemote* d_remote;
	GitgProgressBin* d_progress_bin;
	GtkExpander* d_expander;
	GtkLabel* d_label;
	GtkImage* d_icon;
	gboolean _expanded;
};

struct _GitgHistoryRefsList {
	GtkListBox parent_instance;
	GitgHistoryRefsListPrivate * priv;
};

struct _GitgHistoryRefsListClass {
	GtkListBoxClass parent_class;
};

struct _GitgHistoryRefsListHeaderState {
	GitgRefType type;
	gchar* name;
	gboolean expanded;
};

struct _GitgHistoryRefsListPrivate {
	GitgRepository* d_repository;
	GeeHashMap* d_ref_map;
	GtkListBoxRow* d_selected_row;
	GitgRemote** d_remotes;
	gint d_remotes_length1;
	gint _d_remotes_size_;
	GitgHistoryRefRow* d_all_commits;
	GitgHistoryRefHeader* d_all_branches;
	GitgHistoryRefHeader* d_all_remotes;
	GitgHistoryRefHeader* d_all_tags;
	GitgHistoryRefRowSortOrder d_ref_sort_order;
	GitgHistoryRefsListHeaderState* d_expanded;
	gint d_expanded_length1;
	gint _d_expanded_size_;
	GeeLinkedList* d_branches_actions;
	GeeLinkedList* d_remotes_actions;
	GeeLinkedList* d_tags_actions;
	GeeHashMap* d_header_map;
	GitgExtApplication* _application;
};

struct _GitgHistoryRefsListRemoteHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgHistoryRefsListRemoteHeaderPrivate * priv;
	GitgHistoryRefHeader* header;
	GeeHashSet* references;
};

struct _GitgHistoryRefsListRemoteHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GitgHistoryRefsListRemoteHeader *self);
};

struct _Block44Data {
	int _ref_count_;
	GitgHistoryRefsList* self;
	GitgHistoryRefRow* head;
};

struct _Block45Data {
	int _ref_count_;
	GitgHistoryRefsList* self;
	GeeLinkedList* ret;
};

struct _GitgHistoryRefsListParamSpecRemoteHeader {
	GParamSpec parent_instance;
};

static gint GitgHistoryRefRow_private_offset;
static gpointer gitg_history_ref_row_parent_class = NULL;
static GitgHistoryRefTypedIface * gitg_history_ref_row_gitg_history_ref_typed_parent_iface = NULL;
static gint GitgHistoryRefHeader_private_offset;
static gpointer gitg_history_ref_header_parent_class = NULL;
static GitgHistoryRefTypedIface * gitg_history_ref_header_gitg_history_ref_typed_parent_iface = NULL;
static gint GitgHistoryRefsList_private_offset;
static gpointer gitg_history_refs_list_parent_class = NULL;
static gpointer gitg_history_refs_list_remote_header_parent_class = NULL;

VALA_EXTERN gint gitg_history_ref_type_sort_order (GitgRefType ref_type);
VALA_EXTERN GType gitg_history_ref_animation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_history_ref_typed_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryRefTyped, g_object_unref)
VALA_EXTERN GitgRefType gitg_history_ref_typed_get_ref_type (GitgHistoryRefTyped* self);
static GType gitg_history_ref_typed_get_type_once (void);
VALA_EXTERN GType gitg_history_ref_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryRefRow, g_object_unref)
VALA_EXTERN GType gitg_history_ref_row_sort_order_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgHistoryRefRow* gitg_history_ref_row_new (GitgRef* reference,
                                             GitgHistoryRefAnimation animation);
VALA_EXTERN GitgHistoryRefRow* gitg_history_ref_row_construct (GType object_type,
                                                   GitgRef* reference,
                                                   GitgHistoryRefAnimation animation);
VALA_EXTERN void gitg_history_ref_row_set_reference (GitgHistoryRefRow* self,
                                         GitgRef* value);
static gchar* gitg_history_ref_row_label_text (GitgHistoryRefRow* self);
VALA_EXTERN gboolean gitg_history_ref_row_get_is_head (GitgHistoryRefRow* self);
static void gitg_history_ref_row_on_child_revealed (GitgHistoryRefRow* self,
                                             GObject* obj,
                                             GParamSpec* spec);
static void _gitg_history_ref_row_on_child_revealed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _vala_GgitOId_free (GgitOId* self);
static void gitg_history_ref_row_real_map (GtkWidget* base);
VALA_EXTERN GitgRef* gitg_history_ref_row_get_reference (GitgHistoryRefRow* self);
static gint gitg_history_ref_row_compare_type (GitgHistoryRefRow* self,
                                        GitgHistoryRefRow* other);
VALA_EXTERN gint gitg_history_ref_row_compare_to (GitgHistoryRefRow* self,
                                      GitgHistoryRefRow* other,
                                      GitgHistoryRefRowSortOrder order);
VALA_EXTERN GgitSignature* gitg_history_ref_row_get_updated (GitgHistoryRefRow* self);
VALA_EXTERN void gitg_history_ref_row_begin_editing (GitgHistoryRefRow* self,
                                         GitgExtRefNameEditingDone done,
                                         gpointer done_target,
                                         GDestroyNotify done_target_destroy_notify);
static gboolean gitg_history_ref_row_on_editing_focus_out (GitgHistoryRefRow* self,
                                                    GtkWidget* widget,
                                                    GdkEventFocus* event);
static gboolean _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                GdkEventFocus* event,
                                                                                gpointer self);
static gboolean gitg_history_ref_row_on_editing_key_press (GitgHistoryRefRow* self,
                                                    GtkWidget* widget,
                                                    GdkEventKey* event);
static gboolean _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                GdkEventKey* event,
                                                                                gpointer self);
static void gitg_history_ref_row_real_dispose (GObject* base);
static void gitg_history_ref_row_finish_editing (GitgHistoryRefRow* self,
                                          gboolean cancelled);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static gboolean __lambda90_ (Block43Data* _data43_);
static gboolean ___lambda90__gsource_func (gpointer self);
VALA_EXTERN void gitg_history_ref_row_unreveal (GitgHistoryRefRow* self);
static void gitg_history_ref_row_finalize (GObject * obj);
static GType gitg_history_ref_row_get_type_once (void);
static void _vala_gitg_history_ref_row_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gitg_history_ref_row_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
VALA_EXTERN GType gitg_history_ref_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryRefHeader, g_object_unref)
VALA_EXTERN GitgHistoryRefHeader* gitg_history_ref_header_new (GitgRefType rtype,
                                                   const gchar* name);
VALA_EXTERN GitgHistoryRefHeader* gitg_history_ref_header_construct (GType object_type,
                                                         GitgRefType rtype,
                                                         const gchar* name);
static gboolean gitg_history_ref_header_on_expander_pressed (GitgHistoryRefHeader* self,
                                                      GdkEventButton* event);
static gboolean _gitg_history_ref_header_on_expander_pressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                     GdkEventButton* event,
                                                                                     gpointer self);
VALA_EXTERN GitgHistoryRefHeader* gitg_history_ref_header_new_remote (const gchar* name,
                                                          GitgRemote* remote);
VALA_EXTERN GitgHistoryRefHeader* gitg_history_ref_header_construct_remote (GType object_type,
                                                                const gchar* name,
                                                                GitgRemote* remote);
VALA_EXTERN gint gitg_history_ref_header_compare_to (GitgHistoryRefHeader* self,
                                         GitgHistoryRefHeader* other);
VALA_EXTERN GeeLinkedList* gitg_history_ref_header_get_actions (GitgHistoryRefHeader* self);
VALA_EXTERN void gitg_history_ref_header_set_actions (GitgHistoryRefHeader* self,
                                          GeeLinkedList* value);
VALA_EXTERN void gitg_history_ref_header_set_remote_state (GitgHistoryRefHeader* self,
                                               GitgRemoteState value);
VALA_EXTERN void gitg_history_ref_header_set_icon_name (GitgHistoryRefHeader* self,
                                            const gchar* value);
VALA_EXTERN gboolean gitg_history_ref_header_get_expanded (GitgHistoryRefHeader* self);
VALA_EXTERN void gitg_history_ref_header_set_expanded (GitgHistoryRefHeader* self,
                                           gboolean value);
VALA_EXTERN const gchar* gitg_history_ref_header_get_ref_name (GitgHistoryRefHeader* self);
VALA_EXTERN gboolean gitg_history_ref_header_get_is_sub_header_remote (GitgHistoryRefHeader* self);
VALA_EXTERN gchar* gitg_history_ref_header_get_icon_name (GitgHistoryRefHeader* self);
static void gitg_history_ref_header_finalize (GObject * obj);
static GType gitg_history_ref_header_get_type_once (void);
static void _vala_gitg_history_ref_header_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gitg_history_ref_header_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
VALA_EXTERN GType gitg_history_refs_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryRefsList, g_object_unref)
static GType gitg_history_refs_list_header_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgHistoryRefsListHeaderState* gitg_history_refs_list_header_state_dup (const GitgHistoryRefsListHeaderState* self);
static void gitg_history_refs_list_header_state_free (GitgHistoryRefsListHeaderState* self);
static void gitg_history_refs_list_header_state_copy (const GitgHistoryRefsListHeaderState* self,
                                               GitgHistoryRefsListHeaderState* dest);
static void gitg_history_refs_list_header_state_destroy (GitgHistoryRefsListHeaderState* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GitgHistoryRefsListHeaderState, gitg_history_refs_list_header_state_destroy)
static gpointer gitg_history_refs_list_remote_header_ref (gpointer instance);
static void gitg_history_refs_list_remote_header_unref (gpointer instance);
static GParamSpec* gitg_history_refs_list_param_spec_remote_header (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags) G_GNUC_UNUSED ;
static void gitg_history_refs_list_value_set_remote_header (GValue* value,
                                                     gpointer v_object) G_GNUC_UNUSED ;
static void gitg_history_refs_list_value_take_remote_header (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer gitg_history_refs_list_value_get_remote_header (const GValue* value) G_GNUC_UNUSED ;
static GType gitg_history_refs_list_remote_header_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryRefsListRemoteHeader, gitg_history_refs_list_remote_header_unref)
static void _vala_GitgHistoryRefsListHeaderState_array_free (GitgHistoryRefsListHeaderState * array,
                                                      gssize array_length);
static void gitg_history_refs_list_real_dispose (GObject* base);
static void gitg_history_refs_list_on_tip_updated (GitgHistoryRefsList* self,
                                            GgitRemote* remote,
                                            const gchar* refname,
                                            GgitOId* a,
                                            GgitOId* b);
static void _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated (GitgRemote* _sender,
                                                                     const gchar* refname,
                                                                     GgitOId* a,
                                                                     GgitOId* b,
                                                                     gpointer self);
static GitgHistoryRefHeader* gitg_history_refs_list_find_header (GitgHistoryRefsList* self,
                                                          GtkListBoxRow* row);
static gboolean gitg_history_refs_list_filter_func (GitgHistoryRefsList* self,
                                             GtkListBoxRow* row);
static gint gitg_history_refs_list_sort_rows (GitgHistoryRefsList* self,
                                       GtkListBoxRow* row1,
                                       GtkListBoxRow* row2);
static void gitg_history_refs_list_clear (GitgHistoryRefsList* self);
static void gitg_history_refs_list_reselect_row (GitgHistoryRefsList* self,
                                          GtkListBoxRow* a);
VALA_EXTERN void gitg_history_refs_list_add (GitgHistoryRefsList* self,
                                 GtkListBoxRow* row);
static void gitg_history_refs_list_expanded_changed (GitgHistoryRefsList* self);
static void gitg_history_refs_list_init_header (GitgHistoryRefsList* self,
                                         GitgHistoryRefHeader* header);
static void _gitg_history_refs_list_expanded_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static GitgHistoryRefHeader* gitg_history_refs_list_add_header (GitgHistoryRefsList* self,
                                                         GitgRefType ref_type,
                                                         const gchar* name,
                                                         GeeLinkedList* actions);
VALA_EXTERN GitgRepository* gitg_history_refs_list_get_repository (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_add_ref (GitgHistoryRefsList* self,
                                         GitgRef* reference);
VALA_EXTERN gboolean gitg_history_refs_list_remove_ref (GitgHistoryRefsList* self,
                                            GitgRef* reference);
static GitgHistoryRefHeader* gitg_history_refs_list_add_remote_header (GitgHistoryRefsList* self,
                                                                const gchar* name);
VALA_EXTERN GitgExtApplication* gitg_history_refs_list_get_application (GitgHistoryRefsList* self);
static void _vala_array_add13 (GitgRemote** * array,
                        gint* length,
                        gint* size,
                        GitgRemote* value);
VALA_EXTERN GType gitg_history_action_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryActionInterface, g_object_unref)
VALA_EXTERN GitgHistoryActionInterface* gitg_history_action_interface_new (GitgExtApplication* application,
                                                               GitgHistoryRefsList* refs_list);
VALA_EXTERN GitgHistoryActionInterface* gitg_history_action_interface_construct (GType object_type,
                                                                     GitgExtApplication* application,
                                                                     GitgHistoryRefsList* refs_list);
VALA_EXTERN GitgRefActionFetch* gitg_ref_action_fetch_new (GitgExtApplication* application,
                                               GitgExtRefActionInterface* action_interface,
                                               GitgRef* reference,
                                               const gchar* remote_name);
VALA_EXTERN GitgRefActionFetch* gitg_ref_action_fetch_construct (GType object_type,
                                                     GitgExtApplication* application,
                                                     GitgExtRefActionInterface* action_interface,
                                                     GitgRef* reference,
                                                     const gchar* remote_name);
VALA_EXTERN GType gitg_ref_action_fetch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRefActionFetch, g_object_unref)
VALA_EXTERN GitgEditRemoteAction* gitg_edit_remote_action_new (GitgExtApplication* application,
                                                   GitgExtRefActionInterface* action_interface,
                                                   const gchar* remote_name);
VALA_EXTERN GitgEditRemoteAction* gitg_edit_remote_action_construct (GType object_type,
                                                         GitgExtApplication* application,
                                                         GitgExtRefActionInterface* action_interface,
                                                         const gchar* remote_name);
VALA_EXTERN GType gitg_edit_remote_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgEditRemoteAction, g_object_unref)
VALA_EXTERN GitgRemoveRemoteAction* gitg_remove_remote_action_new (GitgExtApplication* application,
                                                       GitgExtRefActionInterface* action_interface,
                                                       const gchar* remote_name);
VALA_EXTERN GitgRemoveRemoteAction* gitg_remove_remote_action_construct (GType object_type,
                                                             GitgExtApplication* application,
                                                             GitgExtRefActionInterface* action_interface,
                                                             const gchar* remote_name);
VALA_EXTERN GType gitg_remove_remote_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoveRemoteAction, g_object_unref)
static GitgHistoryRefsListRemoteHeader* gitg_history_refs_list_remote_header_new (GitgHistoryRefHeader* h);
static GitgHistoryRefsListRemoteHeader* gitg_history_refs_list_remote_header_construct (GType object_type,
                                                                                 GitgHistoryRefHeader* h);
static GitgHistoryRefRow* gitg_history_refs_list_add_ref_row (GitgHistoryRefsList* self,
                                                       GitgRef* reference,
                                                       GitgHistoryRefAnimation animation);
static GitgHistoryRefRow* gitg_history_refs_list_add_ref_internal (GitgHistoryRefsList* self,
                                                            GitgRef* reference,
                                                            GitgHistoryRefAnimation animation);
VALA_EXTERN void gitg_history_refs_list_replace_ref (GitgHistoryRefsList* self,
                                         GitgRef* old_ref,
                                         GitgRef* new_ref);
static gboolean gitg_history_refs_list_remove_ref_internal (GitgHistoryRefsList* self,
                                                     GitgRef* reference,
                                                     GitgHistoryRefAnimation animation);
static gboolean gitg_history_refs_list_ref_is_a_symbolic_head (GitgHistoryRefsList* self,
                                                        GitgRef* reference);
static gboolean gitg_history_refs_list_select_nullable_row (GitgHistoryRefsList* self,
                                                     GtkListBoxRow* row);
static void gitg_history_refs_list_scroll_to_row (GitgHistoryRefsList* self,
                                           GtkListBoxRow* row);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_commits (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_branches (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_remotes (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_tags (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_ref (GitgHistoryRefsList* self,
                                            GitgRef* reference);
static void gitg_history_refs_list_store_expanded_state (GitgHistoryRefsList* self);
static void __lambda91_ (GitgHistoryRefsList* self,
                  GtkWidget* child);
static void _vala_array_add14 (GitgHistoryRefsListHeaderState* * array,
                        gint* length,
                        gint* size,
                        const GitgHistoryRefsListHeaderState* value);
static void ___lambda91__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void gitg_history_refs_list_refresh (GitgHistoryRefsList* self);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
VALA_EXTERN GeeLinkedList* gitg_history_refs_list_get_branches_actions (GitgHistoryRefsList* self);
VALA_EXTERN GeeLinkedList* gitg_history_refs_list_get_remotes_actions (GitgHistoryRefsList* self);
VALA_EXTERN GeeLinkedList* gitg_history_refs_list_get_tags_actions (GitgHistoryRefsList* self);
static gint ___lambda102_ (Block44Data* _data44_,
                    const gchar* nm);
static gint ____lambda102__ggit_references_name_callback (const gchar* name,
                                                   gpointer self);
static gint ___lambda103_ (GitgHistoryRefsList* self,
                    GMatchInfo* info,
                    const gchar* value);
static gint ____lambda103__ggit_config_match_callback (GMatchInfo* match_info,
                                                const gchar* value,
                                                gpointer self);
VALA_EXTERN GType gitg_history_default_selection_get_type (void) G_GNUC_CONST ;
static GitgHistoryRefRow* gitg_history_refs_list_get_ref_row (GitgHistoryRefsList* self,
                                                       GtkListBoxRow* row);
static GitgHistoryRefHeader* gitg_history_refs_list_get_ref_header (GitgHistoryRefsList* self,
                                                             GtkListBoxRow* row);
static void gitg_history_refs_list_real_row_selected (GtkListBox* base,
                                               GtkListBoxRow* row);
static void gitg_history_refs_list_real_move_cursor (GtkListBox* base,
                                              GtkMovementStep step,
                                              gint n);
VALA_EXTERN void gitg_history_refs_list_edit (GitgHistoryRefsList* self,
                                  GitgRef* reference,
                                  GitgExtRefNameEditingDone done,
                                  gpointer done_target,
                                  GDestroyNotify done_target_destroy_notify);
VALA_EXTERN gint gitg_history_refs_list_y_in_window (GitgHistoryRefsList* self,
                                         gint y,
                                         GdkWindow* origin);
static gboolean gitg_history_refs_list_real_button_press_event (GtkWidget* base,
                                                         GdkEventButton* button);
VALA_EXTERN GitgHistoryRefsList* gitg_history_refs_list_new (void);
VALA_EXTERN GitgHistoryRefsList* gitg_history_refs_list_construct (GType object_type);
VALA_EXTERN GitgHistoryRefHeader* gitg_history_refs_list_get_branches_header (GitgHistoryRefsList* self);
VALA_EXTERN GitgHistoryRefHeader* gitg_history_refs_list_get_remotes_header (GitgHistoryRefsList* self);
VALA_EXTERN GitgHistoryRefHeader* gitg_history_refs_list_get_tags_header (GitgHistoryRefsList* self);
VALA_EXTERN void gitg_history_refs_list_set_branches_actions (GitgHistoryRefsList* self,
                                                  GeeLinkedList* value);
VALA_EXTERN void gitg_history_refs_list_set_remotes_actions (GitgHistoryRefsList* self,
                                                 GeeLinkedList* value);
VALA_EXTERN void gitg_history_refs_list_set_tags_actions (GitgHistoryRefsList* self,
                                              GeeLinkedList* value);
VALA_EXTERN void gitg_history_refs_list_set_application (GitgHistoryRefsList* self,
                                             GitgExtApplication* value);
VALA_EXTERN void gitg_history_refs_list_set_repository (GitgHistoryRefsList* self,
                                            GitgRepository* value);
VALA_EXTERN GeeList* gitg_history_refs_list_get_references (GitgHistoryRefsList* self);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void _gitg_history_refs_list_references___lambda104_ (Block45Data* _data45_,
                                                      GtkWidget* child);
static void __gitg_history_refs_list_references___lambda104__gtk_callback (GtkWidget* widget,
                                                                    gpointer self);
VALA_EXTERN const gchar* gitg_history_refs_list_get_reference_sort_order (GitgHistoryRefsList* self);
VALA_EXTERN void gitg_history_refs_list_set_reference_sort_order (GitgHistoryRefsList* self,
                                                      const gchar* value);
VALA_EXTERN GeeList* gitg_history_refs_list_get_all (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_get_is_header (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_get_is_all (GitgHistoryRefsList* self);
VALA_EXTERN GeeList* gitg_history_refs_list_get_selection (GitgHistoryRefsList* self);
static void gitg_history_refs_list_remote_header_finalize (GitgHistoryRefsListRemoteHeader * obj);
static GType gitg_history_refs_list_remote_header_get_type_once (void);
static GObject * gitg_history_refs_list_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gint _gitg_history_refs_list_sort_rows_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                               GtkListBoxRow* row2,
                                                               gpointer self);
static gboolean _gitg_history_refs_list_filter_func_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                       gpointer self);
static void gitg_history_refs_list_finalize (GObject * obj);
static GType gitg_history_refs_list_get_type_once (void);
static void _vala_gitg_history_refs_list_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gitg_history_refs_list_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gint
gitg_history_ref_type_sort_order (GitgRefType ref_type)
{
	gint result;
	switch (ref_type) {
		case GITG_REF_TYPE_NONE:
		{
			result = 0;
			return result;
		}
		case GITG_REF_TYPE_BRANCH:
		{
			result = 1;
			return result;
		}
		case GITG_REF_TYPE_REMOTE:
		{
			result = 2;
			return result;
		}
		case GITG_REF_TYPE_TAG:
		{
			result = 3;
			return result;
		}
		default:
		break;
	}
	result = 4;
	return result;
}

 G_GNUC_NO_INLINE static GType
gitg_history_ref_animation_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_HISTORY_REF_ANIMATION_NONE, "GITG_HISTORY_REF_ANIMATION_NONE", "none"}, {GITG_HISTORY_REF_ANIMATION_ANIMATE, "GITG_HISTORY_REF_ANIMATION_ANIMATE", "animate"}, {0, NULL, NULL}};
	GType gitg_history_ref_animation_type_id;
	gitg_history_ref_animation_type_id = g_enum_register_static ("GitgHistoryRefAnimation", values);
	return gitg_history_ref_animation_type_id;
}

GType
gitg_history_ref_animation_get_type (void)
{
	static gsize gitg_history_ref_animation_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_ref_animation_type_id__once)) {
		GType gitg_history_ref_animation_type_id;
		gitg_history_ref_animation_type_id = gitg_history_ref_animation_get_type_once ();
		g_once_init_leave (&gitg_history_ref_animation_type_id__once, gitg_history_ref_animation_type_id);
	}
	return gitg_history_ref_animation_type_id__once;
}

GitgRefType
gitg_history_ref_typed_get_ref_type (GitgHistoryRefTyped* self)
{
	GitgHistoryRefTypedIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GITG_HISTORY_REF_TYPED_GET_INTERFACE (self);
	if (_iface_->get_ref_type) {
		return _iface_->get_ref_type (self);
	}
	return 0;
}

static void
gitg_history_ref_typed_default_init (GitgHistoryRefTypedIface * iface,
                                     gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_enum ("ref-type", "ref-type", "ref-type", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

 G_GNUC_NO_INLINE static GType
gitg_history_ref_typed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefTypedIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_ref_typed_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gitg_history_ref_typed_type_id;
	gitg_history_ref_typed_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgHistoryRefTyped", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gitg_history_ref_typed_type_id, G_TYPE_OBJECT);
	return gitg_history_ref_typed_type_id;
}

GType
gitg_history_ref_typed_get_type (void)
{
	static gsize gitg_history_ref_typed_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_ref_typed_type_id__once)) {
		GType gitg_history_ref_typed_type_id;
		gitg_history_ref_typed_type_id = gitg_history_ref_typed_get_type_once ();
		g_once_init_leave (&gitg_history_ref_typed_type_id__once, gitg_history_ref_typed_type_id);
	}
	return gitg_history_ref_typed_type_id__once;
}

static inline gpointer
gitg_history_ref_row_get_instance_private (GitgHistoryRefRow* self)
{
	return G_STRUCT_MEMBER_P (self, GitgHistoryRefRow_private_offset);
}

 G_GNUC_NO_INLINE static GType
gitg_history_ref_row_sort_order_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_HISTORY_REF_ROW_SORT_ORDER_LAST_ACTIVITY, "GITG_HISTORY_REF_ROW_SORT_ORDER_LAST_ACTIVITY", "last-activity"}, {GITG_HISTORY_REF_ROW_SORT_ORDER_NAME, "GITG_HISTORY_REF_ROW_SORT_ORDER_NAME", "name"}, {0, NULL, NULL}};
	GType gitg_history_ref_row_sort_order_type_id;
	gitg_history_ref_row_sort_order_type_id = g_enum_register_static ("GitgHistoryRefRowSortOrder", values);
	return gitg_history_ref_row_sort_order_type_id;
}

GType
gitg_history_ref_row_sort_order_get_type (void)
{
	static gsize gitg_history_ref_row_sort_order_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_ref_row_sort_order_type_id__once)) {
		GType gitg_history_ref_row_sort_order_type_id;
		gitg_history_ref_row_sort_order_type_id = gitg_history_ref_row_sort_order_get_type_once ();
		g_once_init_leave (&gitg_history_ref_row_sort_order_type_id__once, gitg_history_ref_row_sort_order_type_id);
	}
	return gitg_history_ref_row_sort_order_type_id__once;
}

static void
_gitg_history_ref_row_on_child_revealed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	gitg_history_ref_row_on_child_revealed ((GitgHistoryRefRow*) self, _sender, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

GitgHistoryRefRow*
gitg_history_ref_row_construct (GType object_type,
                                GitgRef* reference,
                                GitgHistoryRefAnimation animation)
{
	GitgHistoryRefRow * self = NULL;
	GtkLabel* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GitgRefType _tmp25_;
	GitgRefType _tmp26_;
	GtkRevealer* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GError* _inner_error0_ = NULL;
	self = (GitgHistoryRefRow*) g_object_new (object_type, NULL);
	gitg_history_ref_row_set_reference (self, reference);
	if (reference != NULL) {
		{
			GgitRef* _tmp0_ = NULL;
			GgitRef* _tmp1_;
			GgitObject* obj = NULL;
			GgitObject* _tmp2_;
			GgitObject* _tmp3_;
			_tmp1_ = ggit_ref_resolve ((GgitRef*) reference, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = ggit_ref_lookup (_tmp0_, &_inner_error0_);
			obj = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp0_);
				goto __catch0_g_error;
			}
			_tmp3_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, ggit_tag_get_type ())) {
				GgitObject* _tmp4_;
				GgitSignature* _tmp5_;
				_tmp4_ = obj;
				_tmp5_ = ggit_tag_get_tagger (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ggit_tag_get_type (), GgitTag));
				_g_object_unref0 (self->priv->d_updated);
				self->priv->d_updated = _tmp5_;
			} else {
				GgitObject* _tmp6_;
				_tmp6_ = obj;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, ggit_commit_get_type ())) {
					GgitObject* _tmp7_;
					GgitSignature* _tmp8_;
					_tmp7_ = obj;
					_tmp8_ = ggit_commit_get_committer (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, ggit_commit_get_type (), GgitCommit));
					_g_object_unref0 (self->priv->d_updated);
					self->priv->d_updated = _tmp8_;
				}
			}
			_g_object_unref0 (obj);
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = stderr;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "%s\n", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (animation == GITG_HISTORY_REF_ANIMATION_ANIMATE) {
		GtkRevealer* _tmp12_;
		_tmp12_ = self->priv->d_revealer;
		gtk_revealer_set_transition_type (_tmp12_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	} else {
		GtkRevealer* _tmp13_;
		_tmp13_ = self->priv->d_revealer;
		gtk_revealer_set_reveal_child (_tmp13_, TRUE);
	}
	_tmp14_ = self->priv->d_label;
	_tmp15_ = gitg_history_ref_row_label_text (self);
	_tmp16_ = _tmp15_;
	gtk_label_set_label (_tmp14_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = gitg_history_ref_row_get_is_head (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		GtkImage* _tmp19_;
		GtkImage* _tmp20_;
		_tmp19_ = self->priv->d_icon;
		g_object_set (_tmp19_, "icon-name", "object-select-symbolic", NULL);
		_tmp20_ = self->priv->d_icon;
		gtk_widget_show ((GtkWidget*) _tmp20_);
	}
	if (reference != NULL) {
		GtkWidget* _tmp21_;
		GtkWidget* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp21_ = gtk_bin_get_child ((GtkBin*) self);
		_tmp22_ = gtk_bin_get_child ((GtkBin*) self);
		_tmp23_ = gtk_widget_get_margin_start (_tmp22_);
		_tmp24_ = _tmp23_;
		gtk_widget_set_margin_start (_tmp22_, _tmp24_ + 12);
	}
	_tmp25_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == GITG_REF_TYPE_REMOTE) {
		GtkWidget* _tmp27_;
		GtkWidget* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp27_ = gtk_bin_get_child ((GtkBin*) self);
		_tmp28_ = gtk_bin_get_child ((GtkBin*) self);
		_tmp29_ = gtk_widget_get_margin_start (_tmp28_);
		_tmp30_ = _tmp29_;
		gtk_widget_set_margin_start (_tmp28_, _tmp30_ + 12);
	}
	_tmp31_ = self->priv->d_revealer;
	g_signal_connect_object ((GObject*) _tmp31_, "notify::child-revealed", (GCallback) _gitg_history_ref_row_on_child_revealed_g_object_notify, self, 0);
	if (reference != NULL) {
		_tmp32_ = ggit_ref_is_branch ((GgitRef*) reference);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GitgBranch* branch = NULL;
		GitgBranch* _tmp33_;
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (reference, GITG_TYPE_BRANCH) ? ((GitgBranch*) reference) : NULL);
		branch = _tmp33_;
		{
			GitgRef* upstream = NULL;
			GitgBranch* _tmp34_;
			GitgRef* _tmp35_;
			gsize ahead = 0UL;
			gsize behind = 0UL;
			GgitRef* _tmp36_ = NULL;
			GgitRef* _tmp37_;
			GgitRef* _tmp38_ = NULL;
			GitgRef* _tmp39_;
			GgitRef* _tmp40_;
			GitgRepository* _tmp41_;
			GitgRepository* _tmp42_;
			GgitOId* _tmp43_;
			GgitOId* _tmp44_;
			GgitOId* _tmp45_;
			GgitOId* _tmp46_;
			gsize _tmp47_ = 0UL;
			gsize _tmp48_ = 0UL;
			gboolean _tmp49_ = FALSE;
			_tmp34_ = branch;
			_tmp35_ = gitg_branch_get_upstream (_tmp34_, &_inner_error0_);
			upstream = _tmp35_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			ahead = (gsize) 0;
			behind = (gsize) 0;
			_tmp37_ = ggit_ref_resolve ((GgitRef*) reference, &_inner_error0_);
			_tmp36_ = _tmp37_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (upstream);
				goto __catch1_g_error;
			}
			_tmp39_ = upstream;
			_tmp40_ = ggit_ref_resolve ((GgitRef*) _tmp39_, &_inner_error0_);
			_tmp38_ = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp36_);
				_g_object_unref0 (upstream);
				goto __catch1_g_error;
			}
			_tmp41_ = gitg_ref_get_owner (reference);
			_tmp42_ = _tmp41_;
			_tmp43_ = ggit_ref_get_target (_tmp36_);
			_tmp44_ = _tmp43_;
			_tmp45_ = ggit_ref_get_target (_tmp38_);
			_tmp46_ = _tmp45_;
			ggit_repository_get_ahead_behind ((GgitRepository*) _tmp42_, _tmp44_, _tmp46_, &_tmp47_, &_tmp48_, &_inner_error0_);
			ahead = _tmp47_;
			behind = _tmp48_;
			__vala_GgitOId_free0 (_tmp46_);
			__vala_GgitOId_free0 (_tmp44_);
			_g_object_unref0 (_tmp42_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp38_);
				_g_object_unref0 (_tmp36_);
				_g_object_unref0 (upstream);
				goto __catch1_g_error;
			}
			if (ahead != ((gsize) 0)) {
				_tmp49_ = TRUE;
			} else {
				_tmp49_ = behind != ((gsize) 0);
			}
			if (_tmp49_) {
				gboolean _tmp50_ = FALSE;
				if (ahead != ((gsize) 0)) {
					_tmp50_ = behind != ((gsize) 0);
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					GtkLabel* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp51_ = self->priv->d_ahead_behind;
					_tmp52_ = g_strdup_printf (_ ("%zu ahead, %zu behind"), ahead, behind);
					_tmp53_ = _tmp52_;
					gtk_label_set_label (_tmp51_, _tmp53_);
					_g_free0 (_tmp53_);
				} else {
					if (ahead != ((gsize) 0)) {
						GtkLabel* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp54_ = self->priv->d_ahead_behind;
						_tmp55_ = g_strdup_printf (_ ("%zu ahead"), ahead);
						_tmp56_ = _tmp55_;
						gtk_label_set_label (_tmp54_, _tmp56_);
						_g_free0 (_tmp56_);
					} else {
						GtkLabel* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						_tmp57_ = self->priv->d_ahead_behind;
						_tmp58_ = g_strdup_printf (_ ("%zu behind"), behind);
						_tmp59_ = _tmp58_;
						gtk_label_set_label (_tmp57_, _tmp59_);
						_g_free0 (_tmp59_);
					}
				}
			}
			_g_object_unref0 (_tmp38_);
			_g_object_unref0 (_tmp36_);
			_g_object_unref0 (upstream);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (branch);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_object_unref0 (branch);
	}
	return self;
}

GitgHistoryRefRow*
gitg_history_ref_row_new (GitgRef* reference,
                          GitgHistoryRefAnimation animation)
{
	return gitg_history_ref_row_construct (GITG_HISTORY_TYPE_REF_ROW, reference, animation);
}

static void
gitg_history_ref_row_on_child_revealed (GitgHistoryRefRow* self,
                                        GObject* obj,
                                        GParamSpec* spec)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = self->priv->d_revealer;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkAllocation alloc = {0};
		GtkRevealer* _tmp3_;
		GtkAllocation _tmp4_ = {0};
		_tmp3_ = self->priv->d_revealer;
		gtk_widget_get_allocation ((GtkWidget*) _tmp3_, &_tmp4_);
		alloc = _tmp4_;
		gtk_widget_destroy ((GtkWidget*) self);
	}
}

static void
gitg_history_ref_row_real_map (GtkWidget* base)
{
	GitgHistoryRefRow * self;
	GtkRevealer* _tmp0_;
	self = (GitgHistoryRefRow*) base;
	GTK_WIDGET_CLASS (gitg_history_ref_row_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp0_ = self->priv->d_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
}

static gchar*
gitg_history_ref_row_label_text (GitgHistoryRefRow* self)
{
	GitgRef* _tmp0_;
	GitgParsedRefName* pn = NULL;
	GitgRef* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgParsedRefName* _tmp4_;
	GitgParsedRefName* _tmp5_;
	GitgRefType _tmp6_;
	GitgRefType _tmp7_;
	GitgParsedRefName* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reference;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("All commits"));
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_reference;
	_tmp3_ = gitg_ref_get_parsed_name (_tmp2_);
	_tmp4_ = _tmp3_;
	pn = _tmp4_;
	_tmp5_ = pn;
	_tmp6_ = gitg_parsed_ref_name_get_rtype (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == GITG_REF_TYPE_REMOTE) {
		GitgParsedRefName* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = pn;
		_tmp9_ = gitg_parsed_ref_name_get_remote_branch (_tmp8_);
		_tmp10_ = _tmp9_;
		result = _tmp10_;
		_g_object_unref0 (pn);
		return result;
	}
	_tmp11_ = pn;
	_tmp12_ = gitg_parsed_ref_name_get_shortname (_tmp11_);
	_tmp13_ = _tmp12_;
	result = _tmp13_;
	_g_object_unref0 (pn);
	return result;
}

static gint
gitg_history_ref_row_compare_type (GitgHistoryRefRow* self,
                                   GitgHistoryRefRow* other)
{
	GitgParsedRefName* pnme = NULL;
	GitgRef* _tmp0_;
	GitgParsedRefName* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* pnot = NULL;
	GitgRef* _tmp3_;
	GitgParsedRefName* _tmp4_;
	GitgParsedRefName* _tmp5_;
	GitgParsedRefName* _tmp6_;
	GitgRefType _tmp7_;
	GitgRefType _tmp8_;
	GitgParsedRefName* _tmp9_;
	GitgRefType _tmp10_;
	GitgRefType _tmp11_;
	GitgParsedRefName* _tmp20_;
	GitgRefType _tmp21_;
	GitgRefType _tmp22_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = self->priv->_reference;
	_tmp1_ = gitg_ref_get_parsed_name (_tmp0_);
	_tmp2_ = _tmp1_;
	pnme = _tmp2_;
	_tmp3_ = other->priv->_reference;
	_tmp4_ = gitg_ref_get_parsed_name (_tmp3_);
	_tmp5_ = _tmp4_;
	pnot = _tmp5_;
	_tmp6_ = pnme;
	_tmp7_ = gitg_parsed_ref_name_get_rtype (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = pnot;
	_tmp10_ = gitg_parsed_ref_name_get_rtype (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp8_ != _tmp11_) {
		gint i1 = 0;
		GitgParsedRefName* _tmp12_;
		GitgRefType _tmp13_;
		GitgRefType _tmp14_;
		gint i2 = 0;
		GitgParsedRefName* _tmp15_;
		GitgRefType _tmp16_;
		GitgRefType _tmp17_;
		gint _tmp18_ = 0;
		_tmp12_ = pnme;
		_tmp13_ = gitg_parsed_ref_name_get_rtype (_tmp12_);
		_tmp14_ = _tmp13_;
		i1 = gitg_history_ref_type_sort_order (_tmp14_);
		_tmp15_ = pnot;
		_tmp16_ = gitg_parsed_ref_name_get_rtype (_tmp15_);
		_tmp17_ = _tmp16_;
		i2 = gitg_history_ref_type_sort_order (_tmp17_);
		if (i1 < i2) {
			_tmp18_ = -1;
		} else {
			gint _tmp19_ = 0;
			if (i1 > i2) {
				_tmp19_ = 1;
			} else {
				_tmp19_ = 0;
			}
			_tmp18_ = _tmp19_;
		}
		result = _tmp18_;
		_g_object_unref0 (pnot);
		_g_object_unref0 (pnme);
		return result;
	}
	_tmp20_ = pnme;
	_tmp21_ = gitg_parsed_ref_name_get_rtype (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ == GITG_REF_TYPE_REMOTE) {
		GitgParsedRefName* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GitgParsedRefName* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gint _tmp35_;
		_tmp23_ = pnme;
		_tmp24_ = gitg_parsed_ref_name_get_remote_name (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp27_ = g_utf8_casefold (_tmp26_, (gssize) -1);
		_tmp28_ = _tmp27_;
		_tmp29_ = pnot;
		_tmp30_ = gitg_parsed_ref_name_get_remote_name (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		_tmp33_ = g_utf8_casefold (_tmp32_, (gssize) -1);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_utf8_collate (_tmp28_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		result = _tmp35_;
		_g_object_unref0 (pnot);
		_g_object_unref0 (pnme);
		return result;
	}
	result = 0;
	_g_object_unref0 (pnot);
	_g_object_unref0 (pnme);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gint
gitg_history_ref_row_compare_to (GitgHistoryRefRow* self,
                                 GitgHistoryRefRow* other,
                                 GitgHistoryRefRowSortOrder order)
{
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	gint ct = 0;
	gchar* t1 = NULL;
	gchar* _tmp20_;
	gchar* t2 = NULL;
	gchar* _tmp21_;
	gint hassep1 = 0;
	const gchar* _tmp22_;
	gint hassep2 = 0;
	const gchar* _tmp23_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gint _tmp31_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = self->priv->_reference;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	_tmp1_ = other->priv->_reference;
	if (_tmp1_ == NULL) {
		result = 1;
		return result;
	}
	ct = gitg_history_ref_row_compare_type (self, other);
	if (ct != 0) {
		result = ct;
		return result;
	}
	if (order == GITG_HISTORY_REF_ROW_SORT_ORDER_LAST_ACTIVITY) {
		gboolean _tmp2_ = FALSE;
		GgitSignature* _tmp3_;
		_tmp3_ = self->priv->d_updated;
		if (_tmp3_ != NULL) {
			GgitSignature* _tmp4_;
			GgitSignature* _tmp5_;
			_tmp4_ = gitg_history_ref_row_get_updated (other);
			_tmp5_ = _tmp4_;
			_tmp2_ = _tmp5_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GgitSignature* c1 = NULL;
			GgitSignature* _tmp6_;
			GgitSignature* _tmp7_;
			GgitSignature* c2 = NULL;
			GgitSignature* _tmp8_;
			GgitSignature* _tmp9_;
			GgitSignature* _tmp10_;
			GDateTime* dt1 = NULL;
			GgitSignature* _tmp11_;
			GDateTime* _tmp12_;
			GDateTime* dt2 = NULL;
			GgitSignature* _tmp13_;
			GDateTime* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GDateTime* _tmp16_;
			_tmp6_ = self->priv->d_updated;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			c1 = _tmp7_;
			_tmp8_ = gitg_history_ref_row_get_updated (other);
			_tmp9_ = _tmp8_;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			c2 = _tmp10_;
			_tmp11_ = c1;
			_tmp12_ = ggit_signature_get_time (_tmp11_);
			dt1 = _tmp12_;
			_tmp13_ = c2;
			_tmp14_ = ggit_signature_get_time (_tmp13_);
			dt2 = _tmp14_;
			_tmp16_ = dt1;
			if (_tmp16_ != NULL) {
				GDateTime* _tmp17_;
				_tmp17_ = dt2;
				_tmp15_ = _tmp17_ != NULL;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				GDateTime* _tmp18_;
				GDateTime* _tmp19_;
				_tmp18_ = dt2;
				_tmp19_ = dt1;
				result = g_date_time_compare (_tmp18_, _tmp19_);
				_g_date_time_unref0 (dt2);
				_g_date_time_unref0 (dt1);
				_g_object_unref0 (c2);
				_g_object_unref0 (c1);
				return result;
			}
			_g_date_time_unref0 (dt2);
			_g_date_time_unref0 (dt1);
			_g_object_unref0 (c2);
			_g_object_unref0 (c1);
		}
	}
	_tmp20_ = gitg_history_ref_row_label_text (self);
	t1 = _tmp20_;
	_tmp21_ = gitg_history_ref_row_label_text (other);
	t2 = _tmp21_;
	_tmp22_ = t1;
	hassep1 = string_index_of_char (_tmp22_, (gunichar) '/', 0);
	_tmp23_ = t2;
	hassep2 = string_index_of_char (_tmp23_, (gunichar) '/', 0);
	if ((hassep1 >= 0) != (hassep2 >= 0)) {
		gint _tmp24_ = 0;
		if (hassep1 >= 0) {
			_tmp24_ = 1;
		} else {
			_tmp24_ = -1;
		}
		result = _tmp24_;
		_g_free0 (t2);
		_g_free0 (t1);
		return result;
	}
	_tmp25_ = t1;
	_tmp26_ = g_utf8_casefold (_tmp25_, (gssize) -1);
	_tmp27_ = _tmp26_;
	_tmp28_ = t2;
	_tmp29_ = g_utf8_casefold (_tmp28_, (gssize) -1);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_utf8_collate (_tmp27_, _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	result = _tmp31_;
	_g_free0 (t2);
	_g_free0 (t1);
	return result;
}

static gboolean
_gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                       GdkEventFocus* event,
                                                                       gpointer self)
{
	gboolean result;
	result = gitg_history_ref_row_on_editing_focus_out ((GitgHistoryRefRow*) self, _sender, event);
	return result;
}

static gboolean
_gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                       GdkEventKey* event,
                                                                       gpointer self)
{
	gboolean result;
	result = gitg_history_ref_row_on_editing_key_press ((GitgHistoryRefRow*) self, _sender, event);
	return result;
}

void
gitg_history_ref_row_begin_editing (GitgHistoryRefRow* self,
                                    GitgExtRefNameEditingDone done,
                                    gpointer done_target,
                                    GDestroyNotify done_target_destroy_notify)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GitgExtRefNameEditingDone _tmp9_;
	gpointer _tmp9__target;
	GDestroyNotify _tmp9__target_destroy_notify;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	GtkEntry* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_editing_entry;
	if (_tmp0_ != NULL) {
		(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
		done = NULL;
		done_target = NULL;
		done_target_destroy_notify = NULL;
		return;
	}
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->d_editing_entry);
	self->priv->d_editing_entry = _tmp1_;
	_tmp2_ = self->priv->d_editing_entry;
	gtk_entry_set_width_chars (_tmp2_, 1);
	_tmp3_ = self->priv->d_editing_entry;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "ref_editing_entry");
	_tmp5_ = self->priv->d_editing_entry;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->d_editing_entry;
	_tmp7_ = gitg_history_ref_row_label_text (self);
	_tmp8_ = _tmp7_;
	gtk_entry_set_text (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = done;
	_tmp9__target = done_target;
	_tmp9__target_destroy_notify = done_target_destroy_notify;
	done = NULL;
	done_target = NULL;
	done_target_destroy_notify = NULL;
	(self->priv->d_edit_done_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_edit_done_callback_target_destroy_notify (self->priv->d_edit_done_callback_target), NULL);
	self->priv->d_edit_done_callback = NULL;
	self->priv->d_edit_done_callback_target = NULL;
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
	self->priv->d_edit_done_callback = _tmp9_;
	self->priv->d_edit_done_callback_target = _tmp9__target;
	self->priv->d_edit_done_callback_target_destroy_notify = _tmp9__target_destroy_notify;
	_tmp10_ = self->priv->d_label;
	gtk_widget_hide ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->d_box;
	_tmp12_ = self->priv->d_editing_entry;
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, TRUE, TRUE, (guint) 0);
	_tmp13_ = self->priv->d_editing_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->d_editing_entry;
	gtk_editable_select_region ((GtkEditable*) _tmp14_, 0, -1);
	_tmp15_ = self->priv->d_editing_entry;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "focus-out-event", (GCallback) _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp16_ = self->priv->d_editing_entry;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "key-press-event", (GCallback) _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event, self, 0);
	(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
	done = NULL;
	done_target = NULL;
	done_target_destroy_notify = NULL;
}

static void
gitg_history_ref_row_real_dispose (GObject* base)
{
	GitgHistoryRefRow * self;
	self = (GitgHistoryRefRow*) base;
	if (self->priv->d_idle_finish != ((guint) 0)) {
		g_source_remove (self->priv->d_idle_finish);
		self->priv->d_idle_finish = (guint) 0;
	}
	G_OBJECT_CLASS (gitg_history_ref_row_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow));
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		GitgHistoryRefRow* self;
		self = _data43_->self;
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static gboolean
__lambda90_ (Block43Data* _data43_)
{
	GitgHistoryRefRow* self;
	gchar* new_text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkEntry* _tmp4_;
	GtkLabel* _tmp5_;
	GitgExtRefNameEditingDone _tmp6_;
	gpointer _tmp6__target;
	gboolean result;
	self = _data43_->self;
	self->priv->d_idle_finish = (guint) 0;
	_tmp0_ = self->priv->d_editing_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	new_text = _tmp3_;
	_tmp4_ = self->priv->d_editing_entry;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_g_object_unref0 (self->priv->d_editing_entry);
	self->priv->d_editing_entry = NULL;
	_tmp5_ = self->priv->d_label;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->d_edit_done_callback;
	_tmp6__target = self->priv->d_edit_done_callback_target;
	_tmp6_ (new_text, _data43_->cancelled, _tmp6__target);
	(self->priv->d_edit_done_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_edit_done_callback_target_destroy_notify (self->priv->d_edit_done_callback_target), NULL);
	self->priv->d_edit_done_callback = NULL;
	self->priv->d_edit_done_callback_target = NULL;
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
	self->priv->d_edit_done_callback = NULL;
	self->priv->d_edit_done_callback_target = NULL;
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
	result = FALSE;
	_g_free0 (new_text);
	return result;
}

static gboolean
___lambda90__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda90_ (self);
	return result;
}

static void
gitg_history_ref_row_finish_editing (GitgHistoryRefRow* self,
                                     gboolean cancelled)
{
	Block43Data* _data43_;
	GtkEntry* _tmp0_;
	guint _tmp1_;
	GtkEntry* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_data43_->cancelled = cancelled;
	if (self->priv->d_idle_finish != ((guint) 0)) {
		block43_data_unref (_data43_);
		_data43_ = NULL;
		return;
	}
	_tmp0_ = self->priv->d_editing_entry;
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event, self);
	_tmp2_ = self->priv->d_editing_entry;
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event, self);
	self->priv->d_idle_finish = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda90__gsource_func, block43_data_ref (_data43_), block43_data_unref);
	block43_data_unref (_data43_);
	_data43_ = NULL;
}

static gboolean
gitg_history_ref_row_on_editing_focus_out (GitgHistoryRefRow* self,
                                           GtkWidget* widget,
                                           GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gitg_history_ref_row_finish_editing (self, FALSE);
	result = FALSE;
	return result;
}

static gboolean
gitg_history_ref_row_on_editing_key_press (GitgHistoryRefRow* self,
                                           GtkWidget* widget,
                                           GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Escape) {
		gitg_history_ref_row_finish_editing (self, TRUE);
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (event->keyval == GDK_KEY_KP_Enter) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = event->keyval == GDK_KEY_Return;
		}
		if (_tmp0_) {
			gitg_history_ref_row_finish_editing (self, FALSE);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

void
gitg_history_ref_row_unreveal (GitgHistoryRefRow* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_revealer;
	gtk_revealer_set_transition_type (_tmp0_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp1_ = self->priv->d_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
}

GitgRef*
gitg_history_ref_row_get_reference (GitgHistoryRefRow* self)
{
	GitgRef* result;
	GitgRef* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reference;
	result = _tmp0_;
	return result;
}

void
gitg_history_ref_row_set_reference (GitgHistoryRefRow* self,
                                    GitgRef* value)
{
	GitgRef* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_history_ref_row_get_reference (self);
	if (old_value != value) {
		GitgRef* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reference);
		self->priv->_reference = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_history_ref_row_properties[GITG_HISTORY_REF_ROW_REFERENCE_PROPERTY]);
	}
}

static GitgRefType
gitg_history_ref_row_real_get_ref_type (GitgHistoryRefTyped* base)
{
	GitgRefType result;
	GitgHistoryRefRow* self;
	GitgRefType _tmp0_ = 0;
	GitgRef* _tmp1_;
	self = (GitgHistoryRefRow*) base;
	_tmp1_ = self->priv->_reference;
	if (_tmp1_ != NULL) {
		GitgRef* _tmp2_;
		GitgParsedRefName* _tmp3_;
		GitgParsedRefName* _tmp4_;
		GitgParsedRefName* _tmp5_;
		GitgRefType _tmp6_;
		GitgRefType _tmp7_;
		_tmp2_ = self->priv->_reference;
		_tmp3_ = gitg_ref_get_parsed_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gitg_parsed_ref_name_get_rtype (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp0_ = GITG_REF_TYPE_NONE;
	}
	result = _tmp0_;
	return result;
}

GgitSignature*
gitg_history_ref_row_get_updated (GitgHistoryRefRow* self)
{
	GgitSignature* result;
	GgitSignature* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_updated;
	result = _tmp0_;
	return result;
}

gboolean
gitg_history_ref_row_get_is_head (GitgHistoryRefRow* self)
{
	gboolean result;
	GitgRef* _tmp0_;
	GgitBranch* branch = NULL;
	GitgRef* _tmp1_;
	GgitBranch* _tmp2_;
	GgitBranch* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_reference;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_reference;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ggit_branch_get_type ()) ? ((GgitBranch*) _tmp1_) : NULL);
	branch = _tmp2_;
	_tmp3_ = branch;
	if (_tmp3_ != NULL) {
		gboolean _tmp6_ = FALSE;
		{
			gboolean _tmp4_ = FALSE;
			GgitBranch* _tmp5_;
			_tmp5_ = branch;
			_tmp4_ = ggit_branch_is_head (_tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = _tmp4_;
			_g_object_unref0 (branch);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			result = FALSE;
			_g_object_unref0 (branch);
			return result;
		}
		__finally0:
		_g_object_unref0 (branch);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = FALSE;
	_g_object_unref0 (branch);
	return result;
}

static void
gitg_history_ref_row_class_init (GitgHistoryRefRowClass * klass,
                                 gpointer klass_data)
{
	gitg_history_ref_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgHistoryRefRow_private_offset);
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget*)) gitg_history_ref_row_real_map;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_history_ref_row_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_history_ref_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_history_ref_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_history_ref_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_REFERENCE_PROPERTY, gitg_history_ref_row_properties[GITG_HISTORY_REF_ROW_REFERENCE_PROPERTY] = g_param_spec_object ("reference", "reference", "reference", GITG_TYPE_REF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_REF_TYPE_PROPERTY, gitg_history_ref_row_properties[GITG_HISTORY_REF_ROW_REF_TYPE_PROPERTY] = g_param_spec_enum ("ref-type", "ref-type", "ref-type", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_UPDATED_PROPERTY, gitg_history_ref_row_properties[GITG_HISTORY_REF_ROW_UPDATED_PROPERTY] = g_param_spec_object ("updated", "updated", "updated", ggit_signature_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_IS_HEAD_PROPERTY, gitg_history_ref_row_properties[GITG_HISTORY_REF_ROW_IS_HEAD_PROPERTY] = g_param_spec_boolean ("is-head", "is-head", "is-head", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-history-ref-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_icon", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_label", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_ahead_behind", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_ahead_behind));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_box", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_revealer", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_revealer));
}

static void
gitg_history_ref_row_gitg_history_ref_typed_interface_init (GitgHistoryRefTypedIface * iface,
                                                            gpointer iface_data)
{
	gitg_history_ref_row_gitg_history_ref_typed_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_ref_type = gitg_history_ref_row_real_get_ref_type;
}

static void
gitg_history_ref_row_instance_init (GitgHistoryRefRow * self,
                                    gpointer klass)
{
	self->priv = gitg_history_ref_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_history_ref_row_finalize (GObject * obj)
{
	GitgHistoryRefRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow);
	_g_object_unref0 (self->priv->_reference);
	_g_object_unref0 (self->priv->d_updated);
	_g_object_unref0 (self->priv->d_editing_entry);
	(self->priv->d_edit_done_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_edit_done_callback_target_destroy_notify (self->priv->d_edit_done_callback_target), NULL);
	self->priv->d_edit_done_callback = NULL;
	self->priv->d_edit_done_callback_target = NULL;
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gitg_history_ref_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_history_ref_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_ref_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefRow), 0, (GInstanceInitFunc) gitg_history_ref_row_instance_init, NULL };
	static const GInterfaceInfo gitg_history_ref_typed_info = { (GInterfaceInitFunc) gitg_history_ref_row_gitg_history_ref_typed_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_history_ref_row_type_id;
	gitg_history_ref_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgHistoryRefRow", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_history_ref_row_type_id, GITG_HISTORY_TYPE_REF_TYPED, &gitg_history_ref_typed_info);
	GitgHistoryRefRow_private_offset = g_type_add_instance_private (gitg_history_ref_row_type_id, sizeof (GitgHistoryRefRowPrivate));
	return gitg_history_ref_row_type_id;
}

GType
gitg_history_ref_row_get_type (void)
{
	static gsize gitg_history_ref_row_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_ref_row_type_id__once)) {
		GType gitg_history_ref_row_type_id;
		gitg_history_ref_row_type_id = gitg_history_ref_row_get_type_once ();
		g_once_init_leave (&gitg_history_ref_row_type_id__once, gitg_history_ref_row_type_id);
	}
	return gitg_history_ref_row_type_id__once;
}

static void
_vala_gitg_history_ref_row_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GitgHistoryRefRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow);
	switch (property_id) {
		case GITG_HISTORY_REF_ROW_REFERENCE_PROPERTY:
		g_value_set_object (value, gitg_history_ref_row_get_reference (self));
		break;
		case GITG_HISTORY_REF_ROW_REF_TYPE_PROPERTY:
		g_value_set_enum (value, gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) self));
		break;
		case GITG_HISTORY_REF_ROW_UPDATED_PROPERTY:
		g_value_set_object (value, gitg_history_ref_row_get_updated (self));
		break;
		case GITG_HISTORY_REF_ROW_IS_HEAD_PROPERTY:
		g_value_set_boolean (value, gitg_history_ref_row_get_is_head (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_history_ref_row_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GitgHistoryRefRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow);
	switch (property_id) {
		case GITG_HISTORY_REF_ROW_REFERENCE_PROPERTY:
		gitg_history_ref_row_set_reference (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gitg_history_ref_header_get_instance_private (GitgHistoryRefHeader* self)
{
	return G_STRUCT_MEMBER_P (self, GitgHistoryRefHeader_private_offset);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_gitg_history_ref_header_on_expander_pressed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self)
{
	gboolean result;
	result = gitg_history_ref_header_on_expander_pressed ((GitgHistoryRefHeader*) self, event);
	return result;
}

GitgHistoryRefHeader*
gitg_history_ref_header_construct (GType object_type,
                                   GitgRefType rtype,
                                   const gchar* name)
{
	GitgHistoryRefHeader * self = NULL;
	gchar* escaped = NULL;
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkExpander* _tmp5_;
	GtkExpander* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GitgHistoryRefHeader*) g_object_new (object_type, NULL);
	_tmp0_ = g_markup_escape_text (name, (gssize) -1);
	escaped = _tmp0_;
	_tmp1_ = self->priv->d_label;
	_tmp2_ = string_to_string (escaped);
	_tmp3_ = g_strconcat ("<b>", _tmp2_, "</b>", NULL);
	_tmp4_ = _tmp3_;
	gtk_label_set_markup (_tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->d_expander;
	g_object_bind_property_with_closures ((GObject*) self, "expanded", (GObject*) _tmp5_, "expanded", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = self->priv->d_expander;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "button-press-event", (GCallback) _gitg_history_ref_header_on_expander_pressed_gtk_widget_button_press_event, self, 0);
	_tmp7_ = g_strdup (name);
	_g_free0 (self->priv->d_name);
	self->priv->d_name = _tmp7_;
	self->priv->d_rtype = rtype;
	_g_free0 (escaped);
	return self;
}

GitgHistoryRefHeader*
gitg_history_ref_header_new (GitgRefType rtype,
                             const gchar* name)
{
	return gitg_history_ref_header_construct (GITG_HISTORY_TYPE_REF_HEADER, rtype, name);
}

static gboolean
gitg_history_ref_header_on_expander_pressed (GitgHistoryRefHeader* self,
                                             GdkEventButton* event)
{
	GtkExpander* _tmp0_;
	GtkExpander* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->d_expander;
	_tmp1_ = self->priv->d_expander;
	_tmp2_ = gtk_expander_get_expanded (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_expander_set_expanded (_tmp0_, !_tmp3_);
	result = TRUE;
	return result;
}

GitgHistoryRefHeader*
gitg_history_ref_header_construct_remote (GType object_type,
                                          const gchar* name,
                                          GitgRemote* remote)
{
	GitgHistoryRefHeader * self = NULL;
	GitgRemote* _tmp0_;
	GtkExpander* _tmp1_;
	GtkExpander* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GitgRemote* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GitgHistoryRefHeader*) gitg_history_ref_header_construct (object_type, GITG_REF_TYPE_REMOTE, name);
	_tmp0_ = _g_object_ref0 (remote);
	_g_object_unref0 (self->priv->d_remote);
	self->priv->d_remote = _tmp0_;
	self->priv->d_is_sub_header_remote = TRUE;
	_tmp1_ = self->priv->d_expander;
	_tmp2_ = self->priv->d_expander;
	_tmp3_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, _tmp4_ + 12);
	_tmp5_ = self->priv->d_remote;
	if (_tmp5_ != NULL) {
		GitgRemote* _tmp6_;
		GitgRemote* _tmp7_;
		GitgProgressBin* _tmp8_;
		_tmp6_ = self->priv->d_remote;
		g_object_bind_property_with_closures ((GObject*) _tmp6_, "state", (GObject*) self, "remote_state", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp7_ = self->priv->d_remote;
		_tmp8_ = self->priv->d_progress_bin;
		g_object_bind_property_with_closures ((GObject*) _tmp7_, "transfer-progress", (GObject*) _tmp8_, "fraction", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	}
	return self;
}

GitgHistoryRefHeader*
gitg_history_ref_header_new_remote (const gchar* name,
                                    GitgRemote* remote)
{
	return gitg_history_ref_header_construct_remote (GITG_HISTORY_TYPE_REF_HEADER, name, remote);
}

gint
gitg_history_ref_header_compare_to (GitgHistoryRefHeader* self,
                                    GitgHistoryRefHeader* other)
{
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (self->priv->d_is_sub_header_remote != other->priv->d_is_sub_header_remote) {
		gint _tmp0_ = 0;
		if (self->priv->d_is_sub_header_remote) {
			_tmp0_ = 1;
		} else {
			_tmp0_ = -1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->d_name;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = other->priv->d_name;
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_collate (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}

GeeLinkedList*
gitg_history_ref_header_get_actions (GitgHistoryRefHeader* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	result = _tmp0_;
	return result;
}

void
gitg_history_ref_header_set_actions (GitgHistoryRefHeader* self,
                                     GeeLinkedList* value)
{
	GeeLinkedList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_history_ref_header_get_actions (self);
	if (old_value != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_ACTIONS_PROPERTY]);
	}
}

void
gitg_history_ref_header_set_remote_state (GitgHistoryRefHeader* self,
                                          GitgRemoteState value)
{
	g_return_if_fail (self != NULL);
	switch (value) {
		case GITG_REMOTE_STATE_DISCONNECTED:
		{
			gitg_history_ref_header_set_icon_name (self, NULL);
			break;
		}
		case GITG_REMOTE_STATE_CONNECTING:
		{
			gitg_history_ref_header_set_icon_name (self, "network-wireless-acquiring-symbolic");
			break;
		}
		case GITG_REMOTE_STATE_CONNECTED:
		{
			gitg_history_ref_header_set_icon_name (self, "network-idle-symbolic");
			break;
		}
		case GITG_REMOTE_STATE_TRANSFERRING:
		{
			gitg_history_ref_header_set_icon_name (self, "network-transmit-receive-symbolic");
			break;
		}
		default:
		break;
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_REMOTE_STATE_PROPERTY]);
}

gboolean
gitg_history_ref_header_get_expanded (GitgHistoryRefHeader* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expanded;
	return result;
}

void
gitg_history_ref_header_set_expanded (GitgHistoryRefHeader* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_history_ref_header_get_expanded (self);
	if (old_value != value) {
		self->priv->_expanded = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_EXPANDED_PROPERTY]);
	}
}

static GitgRefType
gitg_history_ref_header_real_get_ref_type (GitgHistoryRefTyped* base)
{
	GitgRefType result;
	GitgHistoryRefHeader* self;
	self = (GitgHistoryRefHeader*) base;
	result = self->priv->d_rtype;
	return result;
}

const gchar*
gitg_history_ref_header_get_ref_name (GitgHistoryRefHeader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_name;
	result = _tmp0_;
	return result;
}

gboolean
gitg_history_ref_header_get_is_sub_header_remote (GitgHistoryRefHeader* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_is_sub_header_remote;
	return result;
}

gchar*
gitg_history_ref_header_get_icon_name (GitgHistoryRefHeader* self)
{
	gchar* result;
	GtkImage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_icon;
	g_object_get (_tmp0_, "icon-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
gitg_history_ref_header_set_icon_name (GitgHistoryRefHeader* self,
                                       const gchar* value)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_icon;
	g_object_set (_tmp0_, "icon-name", value, NULL);
	_tmp1_ = self->priv->d_icon;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, value != NULL);
	g_object_notify_by_pspec ((GObject *) self, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_ICON_NAME_PROPERTY]);
}

static void
gitg_history_ref_header_class_init (GitgHistoryRefHeaderClass * klass,
                                    gpointer klass_data)
{
	gitg_history_ref_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgHistoryRefHeader_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_history_ref_header_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_history_ref_header_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_history_ref_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_ACTIONS_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_REMOTE_STATE_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_REMOTE_STATE_PROPERTY] = g_param_spec_enum ("remote-state", "remote-state", "remote-state", GITG_TYPE_REMOTE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_EXPANDED_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_REF_TYPE_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_REF_TYPE_PROPERTY] = g_param_spec_enum ("ref-type", "ref-type", "ref-type", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_REF_NAME_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_REF_NAME_PROPERTY] = g_param_spec_string ("ref-name", "ref-name", "ref-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE_PROPERTY] = g_param_spec_boolean ("is-sub-header-remote", "is-sub-header-remote", "is-sub-header-remote", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_ICON_NAME_PROPERTY, gitg_history_ref_header_properties[GITG_HISTORY_REF_HEADER_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-history-ref-header.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_bin", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_progress_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "expander", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_icon));
}

static void
gitg_history_ref_header_gitg_history_ref_typed_interface_init (GitgHistoryRefTypedIface * iface,
                                                               gpointer iface_data)
{
	gitg_history_ref_header_gitg_history_ref_typed_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_ref_type = gitg_history_ref_header_real_get_ref_type;
}

static void
gitg_history_ref_header_instance_init (GitgHistoryRefHeader * self,
                                       gpointer klass)
{
	self->priv = gitg_history_ref_header_get_instance_private (self);
	self->priv->_expanded = TRUE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_history_ref_header_finalize (GObject * obj)
{
	GitgHistoryRefHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader);
	_g_free0 (self->priv->d_name);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->d_remote);
	G_OBJECT_CLASS (gitg_history_ref_header_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_history_ref_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_ref_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefHeader), 0, (GInstanceInitFunc) gitg_history_ref_header_instance_init, NULL };
	static const GInterfaceInfo gitg_history_ref_typed_info = { (GInterfaceInitFunc) gitg_history_ref_header_gitg_history_ref_typed_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_history_ref_header_type_id;
	gitg_history_ref_header_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgHistoryRefHeader", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_history_ref_header_type_id, GITG_HISTORY_TYPE_REF_TYPED, &gitg_history_ref_typed_info);
	GitgHistoryRefHeader_private_offset = g_type_add_instance_private (gitg_history_ref_header_type_id, sizeof (GitgHistoryRefHeaderPrivate));
	return gitg_history_ref_header_type_id;
}

GType
gitg_history_ref_header_get_type (void)
{
	static gsize gitg_history_ref_header_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_ref_header_type_id__once)) {
		GType gitg_history_ref_header_type_id;
		gitg_history_ref_header_type_id = gitg_history_ref_header_get_type_once ();
		g_once_init_leave (&gitg_history_ref_header_type_id__once, gitg_history_ref_header_type_id);
	}
	return gitg_history_ref_header_type_id__once;
}

static void
_vala_gitg_history_ref_header_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GitgHistoryRefHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader);
	switch (property_id) {
		case GITG_HISTORY_REF_HEADER_ACTIONS_PROPERTY:
		g_value_set_object (value, gitg_history_ref_header_get_actions (self));
		break;
		case GITG_HISTORY_REF_HEADER_EXPANDED_PROPERTY:
		g_value_set_boolean (value, gitg_history_ref_header_get_expanded (self));
		break;
		case GITG_HISTORY_REF_HEADER_REF_TYPE_PROPERTY:
		g_value_set_enum (value, gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) self));
		break;
		case GITG_HISTORY_REF_HEADER_REF_NAME_PROPERTY:
		g_value_set_string (value, gitg_history_ref_header_get_ref_name (self));
		break;
		case GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE_PROPERTY:
		g_value_set_boolean (value, gitg_history_ref_header_get_is_sub_header_remote (self));
		break;
		case GITG_HISTORY_REF_HEADER_ICON_NAME_PROPERTY:
		g_value_take_string (value, gitg_history_ref_header_get_icon_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_history_ref_header_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GitgHistoryRefHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader);
	switch (property_id) {
		case GITG_HISTORY_REF_HEADER_ACTIONS_PROPERTY:
		gitg_history_ref_header_set_actions (self, g_value_get_object (value));
		break;
		case GITG_HISTORY_REF_HEADER_REMOTE_STATE_PROPERTY:
		gitg_history_ref_header_set_remote_state (self, g_value_get_enum (value));
		break;
		case GITG_HISTORY_REF_HEADER_EXPANDED_PROPERTY:
		gitg_history_ref_header_set_expanded (self, g_value_get_boolean (value));
		break;
		case GITG_HISTORY_REF_HEADER_ICON_NAME_PROPERTY:
		gitg_history_ref_header_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
gitg_history_refs_list_get_instance_private (GitgHistoryRefsList* self)
{
	return G_STRUCT_MEMBER_P (self, GitgHistoryRefsList_private_offset);
}

static void
_vala_GitgHistoryRefsListHeaderState_array_free (GitgHistoryRefsListHeaderState * array,
                                                 gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gitg_history_refs_list_header_state_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated (GitgRemote* _sender,
                                                                const gchar* refname,
                                                                GgitOId* a,
                                                                GgitOId* b,
                                                                gpointer self)
{
	gitg_history_refs_list_on_tip_updated ((GitgHistoryRefsList*) self, _sender, refname, a, b);
}

static void
gitg_history_refs_list_real_dispose (GObject* base)
{
	GitgHistoryRefsList * self;
	GitgRemote** _tmp0_;
	gint _tmp0__length1;
	GitgRemote** _tmp4_;
	self = (GitgHistoryRefsList*) base;
	_tmp0_ = self->priv->d_remotes;
	_tmp0__length1 = self->priv->d_remotes_length1;
	{
		GitgRemote** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
		remote_collection = _tmp0_;
		remote_collection_length1 = _tmp0__length1;
		for (remote_it = 0; remote_it < remote_collection_length1; remote_it = remote_it + 1) {
			GitgRemote* _tmp1_;
			GitgRemote* remote = NULL;
			_tmp1_ = _g_object_ref0 (remote_collection[remote_it]);
			remote = _tmp1_;
			{
				GitgRemote* _tmp2_;
				guint _tmp3_;
				_tmp2_ = remote;
				g_signal_parse_name ("tip-updated", GITG_TYPE_REMOTE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated, self);
				_g_object_unref0 (remote);
			}
		}
	}
	_tmp4_ = g_new0 (GitgRemote*, 0 + 1);
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_remotes = _tmp4_;
	self->priv->d_remotes_length1 = 0;
	self->priv->_d_remotes_size_ = self->priv->d_remotes_length1;
	G_OBJECT_CLASS (gitg_history_refs_list_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox));
}

static GitgHistoryRefHeader*
gitg_history_refs_list_find_header (GitgHistoryRefsList* self,
                                    GtkListBoxRow* row)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* found = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GitgHistoryRefHeader* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (row != NULL, NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	children = _tmp0_;
	_tmp1_ = children;
	_tmp2_ = g_list_find (_tmp1_, (GtkWidget*) row);
	found = _tmp2_;
	_tmp3_ = found;
	if (_tmp3_ == NULL) {
		result = NULL;
		(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
		return result;
	}
	while (TRUE) {
		GList* _tmp4_;
		GList* _tmp5_;
		GList* _tmp6_;
		GList* _tmp7_;
		GitgHistoryRefHeader* header = NULL;
		GList* _tmp8_;
		gconstpointer _tmp9_;
		GtkWidget* _tmp10_;
		GitgHistoryRefHeader* _tmp11_;
		GitgHistoryRefHeader* _tmp12_;
		_tmp4_ = found;
		_tmp5_ = _tmp4_->prev;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = found;
		_tmp7_ = _tmp6_->prev;
		found = _tmp7_;
		_tmp8_ = found;
		_tmp9_ = _tmp8_->data;
		_tmp10_ = (GtkWidget*) _tmp9_;
		_tmp11_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (_tmp10_) ? ((GitgHistoryRefHeader*) _tmp10_) : NULL);
		header = _tmp11_;
		_tmp12_ = header;
		if (_tmp12_ != NULL) {
			result = header;
			(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
			return result;
		}
		_g_object_unref0 (header);
	}
	result = NULL;
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

static gboolean
gitg_history_refs_list_filter_func (GitgHistoryRefsList* self,
                                    GtkListBoxRow* row)
{
	GitgHistoryRefHeader* header = NULL;
	GitgHistoryRefHeader* _tmp0_;
	GitgHistoryRefHeader* _tmp1_;
	GitgHistoryRefHeader* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (row) ? ((GitgHistoryRefHeader*) row) : NULL);
	header = _tmp0_;
	_tmp1_ = header;
	if (_tmp1_ != NULL) {
		GitgHistoryRefHeader* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = header;
		_tmp3_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			result = TRUE;
			_g_object_unref0 (header);
			return result;
		} else {
			GitgHistoryRefHeader* _tmp12_;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				GitgHistoryRefHeader* _tmp6_;
				GitgHistoryRefHeader* _tmp10_;
				GitgHistoryRefHeader* _tmp11_;
				_tmp6_ = header;
				if (_tmp6_ != NULL) {
					GitgHistoryRefHeader* _tmp7_;
					gboolean _tmp8_;
					gboolean _tmp9_;
					_tmp7_ = header;
					_tmp8_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp5_ = _tmp9_;
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
				_tmp10_ = header;
				_tmp11_ = gitg_history_refs_list_find_header (self, (GtkListBoxRow*) _tmp10_);
				_g_object_unref0 (header);
				header = _tmp11_;
			}
			_tmp12_ = header;
			if (_tmp12_ == NULL) {
				result = TRUE;
				_g_object_unref0 (header);
				return result;
			}
		}
	} else {
		GitgHistoryRefHeader* _tmp13_;
		_tmp13_ = gitg_history_refs_list_find_header (self, row);
		_g_object_unref0 (header);
		header = _tmp13_;
	}
	_tmp14_ = header;
	if (_tmp14_ == NULL) {
		result = TRUE;
		_g_object_unref0 (header);
		return result;
	} else {
		gboolean _tmp15_ = FALSE;
		GitgHistoryRefHeader* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = header;
		_tmp17_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp16_);
		_tmp18_ = _tmp17_;
		if (!_tmp18_) {
			_tmp15_ = TRUE;
		} else {
			GitgHistoryRefHeader* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			_tmp19_ = header;
			_tmp20_ = gitg_history_ref_header_get_expanded (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp15_ = !_tmp21_;
		}
		if (_tmp15_) {
			GitgHistoryRefHeader* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp22_ = header;
			_tmp23_ = gitg_history_ref_header_get_expanded (_tmp22_);
			_tmp24_ = _tmp23_;
			result = _tmp24_;
			_g_object_unref0 (header);
			return result;
		} else {
			gboolean _tmp32_ = FALSE;
			GitgHistoryRefHeader* _tmp33_;
			while (TRUE) {
				gboolean _tmp25_ = FALSE;
				GitgHistoryRefHeader* _tmp26_;
				GitgHistoryRefHeader* _tmp30_;
				GitgHistoryRefHeader* _tmp31_;
				_tmp26_ = header;
				if (_tmp26_ != NULL) {
					GitgHistoryRefHeader* _tmp27_;
					gboolean _tmp28_;
					gboolean _tmp29_;
					_tmp27_ = header;
					_tmp28_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp25_ = _tmp29_;
				} else {
					_tmp25_ = FALSE;
				}
				if (!_tmp25_) {
					break;
				}
				_tmp30_ = header;
				_tmp31_ = gitg_history_refs_list_find_header (self, (GtkListBoxRow*) _tmp30_);
				_g_object_unref0 (header);
				header = _tmp31_;
			}
			_tmp33_ = header;
			if (_tmp33_ == NULL) {
				_tmp32_ = TRUE;
			} else {
				GitgHistoryRefHeader* _tmp34_;
				gboolean _tmp35_;
				gboolean _tmp36_;
				_tmp34_ = header;
				_tmp35_ = gitg_history_ref_header_get_expanded (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_;
			}
			result = _tmp32_;
			_g_object_unref0 (header);
			return result;
		}
	}
}

static gint
gitg_history_refs_list_sort_rows (GitgHistoryRefsList* self,
                                  GtkListBoxRow* row1,
                                  GtkListBoxRow* row2)
{
	GitgRefType r1 = 0;
	GitgRefType _tmp0_;
	GitgRefType _tmp1_;
	GitgRefType r2 = 0;
	GitgRefType _tmp2_;
	GitgRefType _tmp3_;
	gint rs1 = 0;
	gint rs2 = 0;
	GitgHistoryRefHeader* head1 = NULL;
	GitgHistoryRefHeader* _tmp5_;
	GitgHistoryRefRow* ref1 = NULL;
	GitgHistoryRefRow* _tmp6_;
	GitgHistoryRefHeader* head2 = NULL;
	GitgHistoryRefHeader* _tmp7_;
	GitgHistoryRefRow* ref2 = NULL;
	GitgHistoryRefRow* _tmp8_;
	GitgHistoryRefHeader* _tmp9_;
	GitgHistoryRefHeader* _tmp10_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gitg_history_ref_typed_get_ref_type (G_TYPE_CHECK_INSTANCE_CAST (row1, GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTyped));
	_tmp1_ = _tmp0_;
	r1 = _tmp1_;
	_tmp2_ = gitg_history_ref_typed_get_ref_type (G_TYPE_CHECK_INSTANCE_CAST (row2, GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTyped));
	_tmp3_ = _tmp2_;
	r2 = _tmp3_;
	rs1 = gitg_history_ref_type_sort_order (r1);
	rs2 = gitg_history_ref_type_sort_order (r2);
	if (rs1 != rs2) {
		gint _tmp4_ = 0;
		if (rs1 < rs2) {
			_tmp4_ = -1;
		} else {
			_tmp4_ = 1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (row1) ? ((GitgHistoryRefHeader*) row1) : NULL);
	head1 = _tmp5_;
	_tmp6_ = _g_object_ref0 (GITG_HISTORY_IS_REF_ROW (row1) ? ((GitgHistoryRefRow*) row1) : NULL);
	ref1 = _tmp6_;
	_tmp7_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (row2) ? ((GitgHistoryRefHeader*) row2) : NULL);
	head2 = _tmp7_;
	_tmp8_ = _g_object_ref0 (GITG_HISTORY_IS_REF_ROW (row2) ? ((GitgHistoryRefRow*) row2) : NULL);
	ref2 = _tmp8_;
	_tmp9_ = head1;
	_tmp10_ = head2;
	if ((_tmp9_ == NULL) != (_tmp10_ == NULL)) {
		GitgHistoryRefHeader* _tmp11_ = NULL;
		GitgHistoryRefHeader* _tmp12_;
		GitgHistoryRefHeader* head = NULL;
		GitgHistoryRefHeader* _tmp15_;
		GitgHistoryRefHeader* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp12_ = head1;
		if (_tmp12_ != NULL) {
			GitgHistoryRefHeader* _tmp13_;
			_tmp13_ = head1;
			_tmp11_ = _tmp13_;
		} else {
			GitgHistoryRefHeader* _tmp14_;
			_tmp14_ = head2;
			_tmp11_ = _tmp14_;
		}
		_tmp15_ = _g_object_ref0 (_tmp11_);
		head = _tmp15_;
		_tmp16_ = head;
		_tmp17_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			GitgHistoryRefRow* _tmp19_ = NULL;
			GitgHistoryRefHeader* _tmp20_;
			GitgHistoryRefRow* rref = NULL;
			GitgHistoryRefRow* _tmp23_;
			gint cmp = 0;
			GitgHistoryRefHeader* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GitgHistoryRefRow* _tmp29_;
			GitgRef* _tmp30_;
			GitgRef* _tmp31_;
			GitgParsedRefName* _tmp32_;
			GitgParsedRefName* _tmp33_;
			GitgParsedRefName* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gint _tmp40_;
			gint _tmp41_ = 0;
			GitgHistoryRefHeader* _tmp42_;
			_tmp20_ = head1;
			if (_tmp20_ != NULL) {
				GitgHistoryRefRow* _tmp21_;
				_tmp21_ = ref2;
				_tmp19_ = _tmp21_;
			} else {
				GitgHistoryRefRow* _tmp22_;
				_tmp22_ = ref1;
				_tmp19_ = _tmp22_;
			}
			_tmp23_ = _g_object_ref0 (_tmp19_);
			rref = _tmp23_;
			_tmp24_ = head;
			_tmp25_ = gitg_history_ref_header_get_ref_name (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_utf8_casefold (_tmp26_, (gssize) -1);
			_tmp28_ = _tmp27_;
			_tmp29_ = rref;
			_tmp30_ = gitg_history_ref_row_get_reference (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gitg_ref_get_parsed_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_;
			_tmp35_ = gitg_parsed_ref_name_get_remote_name (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			_tmp38_ = g_utf8_casefold (_tmp37_, (gssize) -1);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_utf8_collate (_tmp28_, _tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_object_unref0 (_tmp34_);
			_g_free0 (_tmp28_);
			cmp = _tmp40_;
			_tmp42_ = head1;
			if (_tmp42_ != NULL) {
				_tmp41_ = cmp;
			} else {
				_tmp41_ = -cmp;
			}
			result = _tmp41_;
			_g_object_unref0 (rref);
			_g_object_unref0 (head);
			_g_object_unref0 (ref2);
			_g_object_unref0 (head2);
			_g_object_unref0 (ref1);
			_g_object_unref0 (head1);
			return result;
		} else {
			gint _tmp43_ = 0;
			GitgHistoryRefHeader* _tmp44_;
			_tmp44_ = head1;
			if (_tmp44_ != NULL) {
				_tmp43_ = -1;
			} else {
				_tmp43_ = 1;
			}
			result = _tmp43_;
			_g_object_unref0 (head);
			_g_object_unref0 (ref2);
			_g_object_unref0 (head2);
			_g_object_unref0 (ref1);
			_g_object_unref0 (head1);
			return result;
		}
		_g_object_unref0 (head);
	} else {
		gboolean _tmp45_ = FALSE;
		GitgHistoryRefHeader* _tmp46_;
		_tmp46_ = head1;
		if (_tmp46_ != NULL) {
			GitgHistoryRefHeader* _tmp47_;
			_tmp47_ = head2;
			_tmp45_ = _tmp47_ != NULL;
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			GitgHistoryRefHeader* _tmp48_;
			GitgHistoryRefHeader* _tmp49_;
			_tmp48_ = head1;
			_tmp49_ = head2;
			result = gitg_history_ref_header_compare_to (_tmp48_, _tmp49_);
			_g_object_unref0 (ref2);
			_g_object_unref0 (head2);
			_g_object_unref0 (ref1);
			_g_object_unref0 (head1);
			return result;
		} else {
			GitgHistoryRefRow* _tmp50_;
			GitgHistoryRefRow* _tmp51_;
			_tmp50_ = ref1;
			_tmp51_ = ref2;
			result = gitg_history_ref_row_compare_to (_tmp50_, _tmp51_, self->priv->d_ref_sort_order);
			_g_object_unref0 (ref2);
			_g_object_unref0 (head2);
			_g_object_unref0 (ref1);
			_g_object_unref0 (head1);
			return result;
		}
	}
}

static void
gitg_history_refs_list_clear (GitgHistoryRefsList* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GList* _tmp2_;
	GitgRemote** _tmp4_;
	gint _tmp4__length1;
	GitgRemote** _tmp8_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->d_all_commits);
	self->priv->d_all_commits = NULL;
	_g_object_unref0 (self->priv->d_all_branches);
	self->priv->d_all_branches = NULL;
	_g_object_unref0 (self->priv->d_all_remotes);
	self->priv->d_all_remotes = NULL;
	_g_object_unref0 (self->priv->d_all_tags);
	self->priv->d_all_tags = NULL;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, (GBoxedCopyFunc) gitg_history_refs_list_remote_header_ref, (GDestroyNotify) gitg_history_refs_list_remote_header_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_header_map);
	self->priv->d_header_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GITG_HISTORY_TYPE_REF_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_ref_map);
	self->priv->d_ref_map = _tmp1_;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				gtk_widget_destroy (_tmp3_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp4_ = self->priv->d_remotes;
	_tmp4__length1 = self->priv->d_remotes_length1;
	{
		GitgRemote** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
		remote_collection = _tmp4_;
		remote_collection_length1 = _tmp4__length1;
		for (remote_it = 0; remote_it < remote_collection_length1; remote_it = remote_it + 1) {
			GitgRemote* _tmp5_;
			GitgRemote* remote = NULL;
			_tmp5_ = _g_object_ref0 (remote_collection[remote_it]);
			remote = _tmp5_;
			{
				GitgRemote* _tmp6_;
				guint _tmp7_;
				_tmp6_ = remote;
				g_signal_parse_name ("tip-updated", GITG_TYPE_REMOTE, &_tmp7_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated, self);
				_g_object_unref0 (remote);
			}
		}
	}
	_tmp8_ = g_new0 (GitgRemote*, 0 + 1);
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_remotes = _tmp8_;
	self->priv->d_remotes_length1 = 0;
	self->priv->_d_remotes_size_ = self->priv->d_remotes_length1;
}

static void
gitg_history_refs_list_reselect_row (GitgHistoryRefsList* self,
                                     GtkListBoxRow* a)
{
	GtkListBoxRow* _tmp0_;
	GitgHistoryRefHeader* ah = NULL;
	GitgHistoryRefHeader* _tmp1_;
	GitgHistoryRefHeader* bh = NULL;
	GtkListBoxRow* _tmp2_;
	GitgHistoryRefHeader* _tmp3_;
	GitgHistoryRefHeader* _tmp4_;
	GitgHistoryRefHeader* _tmp5_;
	GitgHistoryRefHeader* _tmp6_;
	GitgHistoryRefRow* ar = NULL;
	GitgHistoryRefRow* _tmp20_;
	GitgHistoryRefRow* br = NULL;
	GtkListBoxRow* _tmp21_;
	GitgHistoryRefRow* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GitgHistoryRefRow* _tmp24_;
	GitgRef* _tmp25_;
	GitgRef* _tmp26_;
	gboolean _tmp30_ = FALSE;
	GitgHistoryRefRow* _tmp31_;
	GitgRef* _tmp32_;
	GitgRef* _tmp33_;
	GitgHistoryRefRow* _tmp37_;
	GitgRef* _tmp38_;
	GitgRef* _tmp39_;
	const gchar* _tmp40_;
	GitgHistoryRefRow* _tmp41_;
	GitgRef* _tmp42_;
	GitgRef* _tmp43_;
	const gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = self->priv->d_selected_row;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (a) ? ((GitgHistoryRefHeader*) a) : NULL);
	ah = _tmp1_;
	_tmp2_ = self->priv->d_selected_row;
	_tmp3_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (_tmp2_) ? ((GitgHistoryRefHeader*) _tmp2_) : NULL);
	bh = _tmp3_;
	_tmp4_ = ah;
	_tmp5_ = bh;
	if ((_tmp4_ != NULL) != (_tmp5_ != NULL)) {
		_g_object_unref0 (bh);
		_g_object_unref0 (ah);
		return;
	}
	_tmp6_ = ah;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		GitgHistoryRefHeader* _tmp8_;
		GitgRefType _tmp9_;
		GitgRefType _tmp10_;
		GitgHistoryRefHeader* _tmp11_;
		GitgRefType _tmp12_;
		GitgRefType _tmp13_;
		_tmp8_ = ah;
		_tmp9_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = bh;
		_tmp12_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp10_ == _tmp13_) {
			GitgHistoryRefHeader* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			GitgHistoryRefHeader* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp14_ = ah;
			_tmp15_ = gitg_history_ref_header_get_ref_name (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = bh;
			_tmp18_ = gitg_history_ref_header_get_ref_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp7_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gtk_list_box_select_row ((GtkListBox*) self, a);
			_g_object_unref0 (self->priv->d_selected_row);
			self->priv->d_selected_row = NULL;
		}
		_g_object_unref0 (bh);
		_g_object_unref0 (ah);
		return;
	}
	_tmp20_ = _g_object_ref0 (GITG_HISTORY_IS_REF_ROW (a) ? ((GitgHistoryRefRow*) a) : NULL);
	ar = _tmp20_;
	_tmp21_ = self->priv->d_selected_row;
	_tmp22_ = _g_object_ref0 (GITG_HISTORY_IS_REF_ROW (_tmp21_) ? ((GitgHistoryRefRow*) _tmp21_) : NULL);
	br = _tmp22_;
	_tmp24_ = ar;
	_tmp25_ = gitg_history_ref_row_get_reference (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == NULL) {
		GitgHistoryRefRow* _tmp27_;
		GitgRef* _tmp28_;
		GitgRef* _tmp29_;
		_tmp27_ = br;
		_tmp28_ = gitg_history_ref_row_get_reference (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ == NULL;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gtk_list_box_select_row ((GtkListBox*) self, a);
		_g_object_unref0 (self->priv->d_selected_row);
		self->priv->d_selected_row = NULL;
		_g_object_unref0 (br);
		_g_object_unref0 (ar);
		_g_object_unref0 (bh);
		_g_object_unref0 (ah);
		return;
	}
	_tmp31_ = ar;
	_tmp32_ = gitg_history_ref_row_get_reference (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == NULL) {
		_tmp30_ = TRUE;
	} else {
		GitgHistoryRefRow* _tmp34_;
		GitgRef* _tmp35_;
		GitgRef* _tmp36_;
		_tmp34_ = br;
		_tmp35_ = gitg_history_ref_row_get_reference (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp30_ = _tmp36_ == NULL;
	}
	if (_tmp30_) {
		_g_object_unref0 (br);
		_g_object_unref0 (ar);
		_g_object_unref0 (bh);
		_g_object_unref0 (ah);
		return;
	}
	_tmp37_ = ar;
	_tmp38_ = gitg_history_ref_row_get_reference (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = ggit_ref_get_name ((GgitRef*) _tmp39_);
	_tmp41_ = br;
	_tmp42_ = gitg_history_ref_row_get_reference (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = ggit_ref_get_name ((GgitRef*) _tmp43_);
	if (g_strcmp0 (_tmp40_, _tmp44_) == 0) {
		gtk_list_box_select_row ((GtkListBox*) self, a);
		_g_object_unref0 (self->priv->d_selected_row);
		self->priv->d_selected_row = NULL;
	}
	_g_object_unref0 (br);
	_g_object_unref0 (ar);
	_g_object_unref0 (bh);
	_g_object_unref0 (ah);
}

void
gitg_history_refs_list_add (GitgHistoryRefsList* self,
                            GtkListBoxRow* row)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	GTK_CONTAINER_CLASS (gitg_history_refs_list_parent_class)->add ((GtkContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), (GtkWidget*) row);
	gitg_history_refs_list_reselect_row (self, row);
}

static void
gitg_history_refs_list_expanded_changed (GitgHistoryRefsList* self)
{
	g_return_if_fail (self != NULL);
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
}

static void
_gitg_history_refs_list_expanded_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	gitg_history_refs_list_expanded_changed ((GitgHistoryRefsList*) self);
}

static void
gitg_history_refs_list_init_header (GitgHistoryRefsList* self,
                                    GitgHistoryRefHeader* header)
{
	GitgRefType _tmp0_;
	GitgRefType _tmp1_;
	GitgHistoryRefsListHeaderState* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (header != NULL);
	gtk_widget_show ((GtkWidget*) header);
	g_signal_connect_object ((GObject*) header, "notify::expanded", (GCallback) _gitg_history_refs_list_expanded_changed_g_object_notify, self, 0);
	_tmp0_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) header);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GITG_REF_TYPE_TAG) {
		gitg_history_ref_header_set_expanded (header, FALSE);
	} else {
		gitg_history_ref_header_set_expanded (header, TRUE);
	}
	_tmp2_ = self->priv->d_expanded;
	_tmp2__length1 = self->priv->d_expanded_length1;
	{
		GitgHistoryRefsListHeaderState* state_collection = NULL;
		gint state_collection_length1 = 0;
		gint _state_collection_size_ = 0;
		gint state_it = 0;
		state_collection = _tmp2_;
		state_collection_length1 = _tmp2__length1;
		for (state_it = 0; state_it < state_collection_length1; state_it = state_it + 1) {
			GitgHistoryRefsListHeaderState _tmp3_;
			GitgHistoryRefsListHeaderState _tmp4_ = {0};
			GitgHistoryRefsListHeaderState state = {0};
			_tmp3_ = state_collection[state_it];
			gitg_history_refs_list_header_state_copy (&_tmp3_, &_tmp4_);
			state = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				GitgHistoryRefsListHeaderState _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp6_ = state;
				_tmp7_ = _tmp6_.name;
				_tmp8_ = gitg_history_ref_header_get_ref_name (header);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp7_, _tmp9_) == 0) {
					GitgHistoryRefsListHeaderState _tmp10_;
					GitgRefType _tmp11_;
					GitgRefType _tmp12_;
					_tmp10_ = state;
					_tmp11_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) header);
					_tmp12_ = _tmp11_;
					_tmp5_ = _tmp10_.type == _tmp12_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GitgHistoryRefsListHeaderState _tmp13_;
					_tmp13_ = state;
					gitg_history_ref_header_set_expanded (header, _tmp13_.expanded);
				}
				gitg_history_refs_list_header_state_destroy (&state);
			}
		}
	}
}

static GitgHistoryRefHeader*
gitg_history_refs_list_add_header (GitgHistoryRefsList* self,
                                   GitgRefType ref_type,
                                   const gchar* name,
                                   GeeLinkedList* actions)
{
	GitgHistoryRefHeader* header = NULL;
	GitgHistoryRefHeader* _tmp0_;
	GitgHistoryRefHeader* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gitg_history_ref_header_new (ref_type, name);
	g_object_ref_sink (_tmp0_);
	header = _tmp0_;
	gitg_history_refs_list_init_header (self, header);
	gitg_history_ref_header_set_actions (header, actions);
	gitg_history_refs_list_add (self, (GtkListBoxRow*) header);
	result = header;
	return result;
}

static void
gitg_history_refs_list_on_tip_updated (GitgHistoryRefsList* self,
                                       GgitRemote* remote,
                                       const gchar* refname,
                                       GgitOId* a,
                                       GgitOId* b)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (remote != NULL);
	g_return_if_fail (refname != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	if (ggit_oid_is_zero (a)) {
		GitgRef* reference = NULL;
		GitgRepository* _tmp0_;
		GitgRepository* _tmp1_;
		GitgRef* _tmp10_;
		_tmp0_ = gitg_history_refs_list_get_repository (self);
		_tmp1_ = _tmp0_;
		gitg_repository_clear_refs_cache (_tmp1_);
		{
			GitgRef* _tmp2_ = NULL;
			GitgRepository* _tmp3_;
			GitgRepository* _tmp4_;
			GitgRef* _tmp5_;
			GitgRef* _tmp6_;
			_tmp3_ = gitg_history_refs_list_get_repository (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = gitg_repository_lookup_reference (_tmp4_, refname, &_inner_error0_);
			_tmp2_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (reference);
			reference = _tmp6_;
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = stderr;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			fprintf (_tmp7_, "Failed to lookup new reference '%s': %s\n", refname, _tmp9_);
			_g_error_free0 (e);
			_g_object_unref0 (reference);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (reference);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = reference;
		gitg_history_refs_list_add_ref (self, _tmp10_);
		_g_object_unref0 (reference);
	} else {
		if (ggit_oid_is_zero (b)) {
			{
				GeeIterator* _reference_it = NULL;
				GeeHashMap* _tmp11_;
				GeeSet* _tmp12_;
				GeeSet* _tmp13_;
				GeeSet* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp11_ = self->priv->d_ref_map;
				_tmp12_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_reference_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					GitgRef* reference = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					GitgRef* _tmp20_;
					const gchar* _tmp21_;
					_tmp17_ = _reference_it;
					if (!gee_iterator_next (_tmp17_)) {
						break;
					}
					_tmp18_ = _reference_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					reference = (GitgRef*) _tmp19_;
					_tmp20_ = reference;
					_tmp21_ = ggit_ref_get_name ((GgitRef*) _tmp20_);
					if (g_strcmp0 (_tmp21_, refname) == 0) {
						GitgRepository* _tmp22_;
						GitgRepository* _tmp23_;
						GitgRef* _tmp24_;
						_tmp22_ = gitg_history_refs_list_get_repository (self);
						_tmp23_ = _tmp22_;
						gitg_repository_clear_refs_cache (_tmp23_);
						_tmp24_ = reference;
						gitg_history_refs_list_remove_ref (self, _tmp24_);
						_g_object_unref0 (reference);
						break;
					}
					_g_object_unref0 (reference);
				}
				_g_object_unref0 (_reference_it);
			}
		} else {
			GitgRepository* _tmp25_;
			GitgRepository* _tmp26_;
			_tmp25_ = gitg_history_refs_list_get_repository (self);
			_tmp26_ = _tmp25_;
			gitg_repository_clear_refs_cache (_tmp26_);
			g_signal_emit (self, gitg_history_refs_list_signals[GITG_HISTORY_REFS_LIST_CHANGED_SIGNAL], 0);
		}
	}
}

static void
_vala_array_add13 (GitgRemote** * array,
                   gint* length,
                   gint* size,
                   GitgRemote* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgRemote*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GitgHistoryRefHeader*
gitg_history_refs_list_add_remote_header (GitgHistoryRefsList* self,
                                          const gchar* name)
{
	GitgRemote* remote = NULL;
	GitgExtApplication* _tmp0_;
	GitgExtRemoteLookup* _tmp1_;
	GitgExtRemoteLookup* _tmp2_;
	GitgExtRemoteLookup* _tmp3_;
	gboolean _tmp4_;
	GitgRemote* _tmp10_;
	GitgHistoryRefHeader* header = NULL;
	GitgRemote* _tmp14_;
	GitgHistoryRefHeader* _tmp15_;
	GeeLinkedList* actions = NULL;
	GeeLinkedList* _tmp16_;
	GitgHistoryActionInterface* af = NULL;
	GitgExtApplication* _tmp17_;
	GitgHistoryActionInterface* _tmp18_;
	GitgExtApplication* _tmp19_;
	GitgRefActionFetch* _tmp20_;
	GitgRefActionFetch* _tmp21_;
	GitgExtApplication* _tmp22_;
	GitgEditRemoteAction* _tmp23_;
	GitgEditRemoteAction* _tmp24_;
	GitgExtApplication* _tmp25_;
	GitgRemoveRemoteAction* _tmp26_;
	GitgRemoveRemoteAction* _tmp27_;
	GeeHashMap* _tmp28_;
	GitgHistoryRefsListRemoteHeader* _tmp29_;
	GitgHistoryRefsListRemoteHeader* _tmp30_;
	GitgHistoryRefHeader* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	remote = NULL;
	_tmp0_ = self->priv->_application;
	_tmp1_ = gitg_ext_application_get_remote_lookup (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		GitgExtApplication* _tmp5_;
		GitgExtRemoteLookup* _tmp6_;
		GitgExtRemoteLookup* _tmp7_;
		GitgExtRemoteLookup* _tmp8_;
		GitgRemote* _tmp9_;
		_tmp5_ = self->priv->_application;
		_tmp6_ = gitg_ext_application_get_remote_lookup (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gitg_ext_remote_lookup_lookup (_tmp8_, name);
		_g_object_unref0 (remote);
		remote = _tmp9_;
		_g_object_unref0 (_tmp8_);
	}
	_tmp10_ = remote;
	if (_tmp10_ != NULL) {
		GitgRemote* _tmp11_;
		GitgRemote* _tmp12_;
		GitgRemote* _tmp13_;
		_tmp11_ = remote;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_vala_array_add13 (&self->priv->d_remotes, &self->priv->d_remotes_length1, &self->priv->_d_remotes_size_, _tmp12_);
		_tmp13_ = remote;
		g_signal_connect_object (_tmp13_, "tip-updated", (GCallback) _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated, self, 0);
	}
	_tmp14_ = remote;
	_tmp15_ = gitg_history_ref_header_new_remote (name, _tmp14_);
	g_object_ref_sink (_tmp15_);
	header = _tmp15_;
	gitg_history_refs_list_init_header (self, header);
	_tmp16_ = gee_linked_list_new (GITG_EXT_TYPE_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	actions = _tmp16_;
	_tmp17_ = self->priv->_application;
	_tmp18_ = gitg_history_action_interface_new (_tmp17_, self);
	af = _tmp18_;
	_tmp19_ = self->priv->_application;
	_tmp20_ = gitg_ref_action_fetch_new (_tmp19_, (GitgExtRefActionInterface*) af, NULL, name);
	_tmp21_ = _tmp20_;
	gee_abstract_collection_add ((GeeAbstractCollection*) actions, (GitgExtAction*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->_application;
	_tmp23_ = gitg_edit_remote_action_new (_tmp22_, (GitgExtRefActionInterface*) af, name);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) actions, (GitgExtAction*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->_application;
	_tmp26_ = gitg_remove_remote_action_new (_tmp25_, (GitgExtRefActionInterface*) af, name);
	_tmp27_ = _tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) actions, (GitgExtAction*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	gitg_history_ref_header_set_actions (header, actions);
	_tmp28_ = self->priv->d_header_map;
	_tmp29_ = gitg_history_refs_list_remote_header_new (header);
	_tmp30_ = _tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, name, _tmp30_);
	_gitg_history_refs_list_remote_header_unref0 (_tmp30_);
	gitg_history_refs_list_add (self, (GtkListBoxRow*) header);
	result = header;
	_g_object_unref0 (af);
	_g_object_unref0 (actions);
	_g_object_unref0 (remote);
	return result;
}

static GitgHistoryRefRow*
gitg_history_refs_list_add_ref_row (GitgHistoryRefsList* self,
                                    GitgRef* reference,
                                    GitgHistoryRefAnimation animation)
{
	GitgHistoryRefRow* row = NULL;
	GitgHistoryRefRow* _tmp0_;
	GitgHistoryRefRow* _tmp1_;
	GitgHistoryRefRow* _tmp2_;
	GitgHistoryRefRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_history_ref_row_new (reference, animation);
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = row;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = row;
	gitg_history_refs_list_add (self, (GtkListBoxRow*) _tmp2_);
	if (reference != NULL) {
		GeeHashMap* _tmp3_;
		GitgHistoryRefRow* _tmp4_;
		_tmp3_ = self->priv->d_ref_map;
		_tmp4_ = row;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, reference, _tmp4_);
	}
	result = row;
	return result;
}

static GitgHistoryRefRow*
gitg_history_refs_list_add_ref_internal (GitgHistoryRefsList* self,
                                         GitgRef* reference,
                                         GitgHistoryRefAnimation animation)
{
	GeeHashMap* _tmp0_;
	GitgParsedRefName* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgParsedRefName* _tmp3_;
	GitgRefType _tmp4_;
	GitgRefType _tmp5_;
	gboolean _tmp6_;
	GitgHistoryRefRow* _tmp23_;
	GitgHistoryRefRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	_tmp0_ = self->priv->d_ref_map;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, reference)) {
		result = NULL;
		return result;
	}
	_tmp1_ = gitg_ref_get_parsed_name (reference);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_parsed_ref_name_get_rtype (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == GITG_REF_TYPE_REMOTE;
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		gchar* remote = NULL;
		GitgParsedRefName* _tmp7_;
		GitgParsedRefName* _tmp8_;
		GitgParsedRefName* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GeeHashMap* _tmp13_;
		const gchar* _tmp14_;
		GeeHashMap* _tmp18_;
		const gchar* _tmp19_;
		gpointer _tmp20_;
		GitgHistoryRefsListRemoteHeader* _tmp21_;
		GeeHashSet* _tmp22_;
		_tmp7_ = gitg_ref_get_parsed_name (reference);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gitg_parsed_ref_name_get_remote_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp9_);
		remote = _tmp12_;
		_tmp13_ = self->priv->d_header_map;
		_tmp14_ = remote;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp13_, _tmp14_)) {
			const gchar* _tmp15_;
			GitgHistoryRefHeader* _tmp16_;
			GitgHistoryRefHeader* _tmp17_;
			_tmp15_ = remote;
			_tmp16_ = gitg_history_refs_list_add_remote_header (self, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp17_);
		}
		_tmp18_ = self->priv->d_header_map;
		_tmp19_ = remote;
		_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
		_tmp21_ = (GitgHistoryRefsListRemoteHeader*) _tmp20_;
		_tmp22_ = _tmp21_->references;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, reference);
		_gitg_history_refs_list_remote_header_unref0 (_tmp21_);
		_g_free0 (remote);
	}
	_tmp23_ = gitg_history_refs_list_add_ref_row (self, reference, animation);
	result = _tmp23_;
	return result;
}

gboolean
gitg_history_refs_list_add_ref (GitgHistoryRefsList* self,
                                GitgRef* reference)
{
	GitgHistoryRefRow* _tmp0_;
	GitgHistoryRefRow* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (reference != NULL, FALSE);
	_tmp0_ = gitg_history_refs_list_add_ref_internal (self, reference, GITG_HISTORY_REF_ANIMATION_ANIMATE);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		g_signal_emit (self, gitg_history_refs_list_signals[GITG_HISTORY_REFS_LIST_CHANGED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
gitg_history_refs_list_replace_ref (GitgHistoryRefsList* self,
                                    GitgRef* old_ref,
                                    GitgRef* new_ref)
{
	gboolean select = FALSE;
	GeeHashMap* _tmp0_;
	gboolean removed = FALSE;
	GitgHistoryRefRow* newrow = NULL;
	GitgHistoryRefRow* _tmp5_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_ref != NULL);
	g_return_if_fail (new_ref != NULL);
	select = FALSE;
	_tmp0_ = self->priv->d_ref_map;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, old_ref)) {
		GtkListBoxRow* _tmp1_;
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GitgHistoryRefRow* _tmp4_;
		_tmp1_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
		_tmp2_ = self->priv->d_ref_map;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, old_ref);
		_tmp4_ = (GitgHistoryRefRow*) _tmp3_;
		select = _tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_row_get_type (), GtkListBoxRow);
		_g_object_unref0 (_tmp4_);
	}
	removed = gitg_history_refs_list_remove_ref_internal (self, old_ref, GITG_HISTORY_REF_ANIMATION_ANIMATE);
	_tmp5_ = gitg_history_refs_list_add_ref_internal (self, new_ref, GITG_HISTORY_REF_ANIMATION_ANIMATE);
	newrow = _tmp5_;
	if (select) {
		GitgHistoryRefRow* _tmp6_;
		_tmp6_ = newrow;
		gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp6_);
	}
	if (removed) {
		_tmp7_ = TRUE;
	} else {
		GitgHistoryRefRow* _tmp8_;
		_tmp8_ = newrow;
		_tmp7_ = _tmp8_ != NULL;
	}
	if (_tmp7_) {
		g_signal_emit (self, gitg_history_refs_list_signals[GITG_HISTORY_REFS_LIST_CHANGED_SIGNAL], 0);
	}
	_g_object_unref0 (newrow);
}

static gboolean
gitg_history_refs_list_ref_is_a_symbolic_head (GitgHistoryRefsList* self,
                                               GitgRef* reference)
{
	gchar* name = NULL;
	GitgParsedRefName* _tmp0_;
	GitgParsedRefName* _tmp1_;
	GitgParsedRefName* _tmp2_;
	GitgRefType _tmp3_;
	GitgRefType _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (reference != NULL, FALSE);
	if (ggit_ref_get_reference_type ((GgitRef*) reference) != GGIT_REF_SYMBOLIC) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gitg_ref_get_parsed_name (reference);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_parsed_ref_name_get_rtype (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == GITG_REF_TYPE_REMOTE;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		GitgParsedRefName* _tmp6_;
		GitgParsedRefName* _tmp7_;
		GitgParsedRefName* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = gitg_ref_get_parsed_name (reference);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gitg_parsed_ref_name_get_remote_branch (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (name);
		name = _tmp10_;
		_g_object_unref0 (_tmp8_);
	} else {
		GitgParsedRefName* _tmp11_;
		GitgParsedRefName* _tmp12_;
		GitgParsedRefName* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = gitg_ref_get_parsed_name (reference);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = gitg_parsed_ref_name_get_shortname (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (name);
		name = _tmp15_;
		_g_object_unref0 (_tmp13_);
	}
	_tmp16_ = name;
	result = g_strcmp0 (_tmp16_, "HEAD") == 0;
	_g_free0 (name);
	return result;
}

static gboolean
gitg_history_refs_list_remove_ref_internal (GitgHistoryRefsList* self,
                                            GitgRef* reference,
                                            GitgHistoryRefAnimation animation)
{
	GeeHashMap* _tmp0_;
	GitgHistoryRefRow* row = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GeeHashMap* _tmp5_;
	GitgParsedRefName* _tmp6_;
	GitgParsedRefName* _tmp7_;
	GitgParsedRefName* _tmp8_;
	GitgRefType _tmp9_;
	GitgRefType _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (reference != NULL, FALSE);
	_tmp0_ = self->priv->d_ref_map;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, reference)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->d_ref_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, reference);
	row = (GitgHistoryRefRow*) _tmp2_;
	if (animation == GITG_HISTORY_REF_ANIMATION_NONE) {
		GitgHistoryRefRow* _tmp3_;
		_tmp3_ = row;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
	} else {
		GitgHistoryRefRow* _tmp4_;
		_tmp4_ = row;
		gitg_history_ref_row_unreveal (_tmp4_);
	}
	_tmp5_ = self->priv->d_ref_map;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, reference, NULL);
	_tmp6_ = gitg_ref_get_parsed_name (reference);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = gitg_parsed_ref_name_get_rtype (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ == GITG_REF_TYPE_REMOTE;
	_g_object_unref0 (_tmp8_);
	if (_tmp11_) {
		gchar* remote = NULL;
		GitgParsedRefName* _tmp12_;
		GitgParsedRefName* _tmp13_;
		GitgParsedRefName* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GitgHistoryRefsListRemoteHeader* remote_header = NULL;
		GeeHashMap* _tmp18_;
		const gchar* _tmp19_;
		gpointer _tmp20_;
		GitgHistoryRefsListRemoteHeader* _tmp21_;
		GeeHashSet* _tmp22_;
		GitgHistoryRefsListRemoteHeader* _tmp23_;
		GeeHashSet* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp12_ = gitg_ref_get_parsed_name (reference);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = gitg_parsed_ref_name_get_remote_name (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp14_);
		remote = _tmp17_;
		_tmp18_ = self->priv->d_header_map;
		_tmp19_ = remote;
		_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
		remote_header = (GitgHistoryRefsListRemoteHeader*) _tmp20_;
		_tmp21_ = remote_header;
		_tmp22_ = _tmp21_->references;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp22_, reference);
		_tmp23_ = remote_header;
		_tmp24_ = _tmp23_->references;
		_tmp25_ = gee_collection_get_is_empty ((GeeCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_) {
			GitgHistoryRefsListRemoteHeader* _tmp27_;
			GitgHistoryRefHeader* _tmp28_;
			GeeHashMap* _tmp29_;
			const gchar* _tmp30_;
			_tmp27_ = remote_header;
			_tmp28_ = _tmp27_->header;
			gtk_widget_destroy ((GtkWidget*) _tmp28_);
			_tmp29_ = self->priv->d_header_map;
			_tmp30_ = remote;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp29_, _tmp30_, NULL);
		}
		_gitg_history_refs_list_remote_header_unref0 (remote_header);
		_g_free0 (remote);
	}
	result = TRUE;
	_g_object_unref0 (row);
	return result;
}

gboolean
gitg_history_refs_list_remove_ref (GitgHistoryRefsList* self,
                                   GitgRef* reference)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (reference != NULL, FALSE);
	if (gitg_history_refs_list_remove_ref_internal (self, reference, GITG_HISTORY_REF_ANIMATION_NONE)) {
		g_signal_emit (self, gitg_history_refs_list_signals[GITG_HISTORY_REFS_LIST_CHANGED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gitg_history_refs_list_select_nullable_row (GitgHistoryRefsList* self,
                                            GtkListBoxRow* row)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (row == NULL) {
		result = FALSE;
		return result;
	}
	gtk_list_box_select_row ((GtkListBox*) self, row);
	gitg_history_refs_list_scroll_to_row (self, row);
	result = TRUE;
	return result;
}

gboolean
gitg_history_refs_list_select_all_commits (GitgHistoryRefsList* self)
{
	GitgHistoryRefRow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_all_commits;
	result = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
	return result;
}

gboolean
gitg_history_refs_list_select_all_branches (GitgHistoryRefsList* self)
{
	GitgHistoryRefHeader* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_all_branches;
	result = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
	return result;
}

gboolean
gitg_history_refs_list_select_all_remotes (GitgHistoryRefsList* self)
{
	GitgHistoryRefHeader* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_all_remotes;
	result = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
	return result;
}

gboolean
gitg_history_refs_list_select_all_tags (GitgHistoryRefsList* self)
{
	GitgHistoryRefHeader* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_all_tags;
	result = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
	return result;
}

gboolean
gitg_history_refs_list_select_ref (GitgHistoryRefsList* self,
                                   GitgRef* reference)
{
	gchar* refname = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (reference != NULL, FALSE);
	_tmp0_ = ggit_ref_get_name ((GgitRef*) reference);
	_tmp1_ = g_strdup (_tmp0_);
	refname = _tmp1_;
	{
		GeeIterator* _ourref_it = NULL;
		GeeHashMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = self->priv->d_ref_map;
		_tmp3_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_ourref_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			GitgRef* ourref = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GitgRef* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp8_ = _ourref_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _ourref_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			ourref = (GitgRef*) _tmp10_;
			_tmp11_ = ourref;
			_tmp12_ = ggit_ref_get_name ((GgitRef*) _tmp11_);
			_tmp13_ = refname;
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
				GitgHistoryRefRow* row = NULL;
				GeeHashMap* _tmp14_;
				GitgRef* _tmp15_;
				gpointer _tmp16_;
				GitgHistoryRefRow* _tmp17_;
				GitgHistoryRefRow* _tmp18_;
				_tmp14_ = self->priv->d_ref_map;
				_tmp15_ = ourref;
				_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
				row = (GitgHistoryRefRow*) _tmp16_;
				_tmp17_ = row;
				gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp17_);
				_tmp18_ = row;
				gitg_history_refs_list_scroll_to_row (self, (GtkListBoxRow*) _tmp18_);
				result = TRUE;
				_g_object_unref0 (row);
				_g_object_unref0 (ourref);
				_g_object_unref0 (_ourref_it);
				_g_free0 (refname);
				return result;
			}
			_g_object_unref0 (ourref);
		}
		_g_object_unref0 (_ourref_it);
	}
	result = FALSE;
	_g_free0 (refname);
	return result;
}

static void
_vala_array_add14 (GitgHistoryRefsListHeaderState* * array,
                   gint* length,
                   gint* size,
                   const GitgHistoryRefsListHeaderState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgHistoryRefsListHeaderState, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
__lambda91_ (GitgHistoryRefsList* self,
             GtkWidget* child)
{
	GitgHistoryRefHeader* header = NULL;
	GitgHistoryRefHeader* _tmp0_;
	GitgHistoryRefHeader* _tmp1_;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (child) ? ((GitgHistoryRefHeader*) child) : NULL);
	header = _tmp0_;
	_tmp1_ = header;
	if (_tmp1_ != NULL) {
		GitgHistoryRefHeader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		GitgHistoryRefHeader* _tmp6_;
		GitgRefType _tmp7_;
		GitgRefType _tmp8_;
		GitgHistoryRefHeader* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		GitgHistoryRefsListHeaderState _tmp12_ = {0};
		_tmp2_ = header;
		_tmp3_ = gitg_history_ref_header_get_ref_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = header;
		_tmp7_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = header;
		_tmp10_ = gitg_history_ref_header_get_expanded (_tmp9_);
		_tmp11_ = _tmp10_;
		memset (&_tmp12_, 0, sizeof (GitgHistoryRefsListHeaderState));
		_g_free0 (_tmp12_.name);
		_tmp12_.name = _tmp5_;
		_tmp12_.type = _tmp8_;
		_tmp12_.expanded = _tmp11_;
		_vala_array_add14 (&self->priv->d_expanded, &self->priv->d_expanded_length1, &self->priv->_d_expanded_size_, &_tmp12_);
	}
	_g_object_unref0 (header);
}

static void
___lambda91__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda91_ ((GitgHistoryRefsList*) self, widget);
}

static void
gitg_history_refs_list_store_expanded_state (GitgHistoryRefsList* self)
{
	GitgHistoryRefsListHeaderState* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GitgHistoryRefsListHeaderState, 0);
	self->priv->d_expanded = (_vala_GitgHistoryRefsListHeaderState_array_free (self->priv->d_expanded, self->priv->d_expanded_length1), NULL);
	self->priv->d_expanded = _tmp0_;
	self->priv->d_expanded_length1 = 0;
	self->priv->_d_expanded_size_ = self->priv->d_expanded_length1;
	gtk_container_foreach ((GtkContainer*) self, ___lambda91__gtk_callback, self);
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		GitgHistoryRefsList* self;
		self = _data44_->self;
		_g_object_unref0 (_data44_->head);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static gint
___lambda102_ (Block44Data* _data44_,
               const gchar* nm)
{
	GitgHistoryRefsList* self;
	GitgRef* r = NULL;
	GitgRef* _tmp5_;
	GitgHistoryRefRow* row = NULL;
	GitgRef* _tmp6_;
	GitgHistoryRefRow* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GitgHistoryRefRow* _tmp9_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = _data44_->self;
	g_return_val_if_fail (nm != NULL, 0);
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_;
		GitgRef* _tmp2_;
		GitgRef* _tmp3_;
		_tmp1_ = self->priv->d_repository;
		_tmp2_ = gitg_repository_lookup_reference (_tmp1_, nm, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (r);
		r = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = 0;
		_g_object_unref0 (r);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		_g_object_unref0 (r);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	_tmp5_ = r;
	if (gitg_history_refs_list_ref_is_a_symbolic_head (self, _tmp5_)) {
		result = 0;
		_g_object_unref0 (r);
		return result;
	}
	_tmp6_ = r;
	_tmp7_ = gitg_history_refs_list_add_ref_internal (self, _tmp6_, GITG_HISTORY_REF_ANIMATION_NONE);
	row = _tmp7_;
	_tmp9_ = row;
	if (_tmp9_ != NULL) {
		GitgHistoryRefRow* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = row;
		_tmp11_ = gitg_history_ref_row_get_is_head (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GitgHistoryRefRow* _tmp13_;
		GitgHistoryRefRow* _tmp14_;
		_tmp13_ = row;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (_data44_->head);
		_data44_->head = _tmp14_;
	}
	result = 0;
	_g_object_unref0 (row);
	_g_object_unref0 (r);
	return result;
}

static gint
____lambda102__ggit_references_name_callback (const gchar* name,
                                              gpointer self)
{
	gint result;
	result = ___lambda102_ (self, name);
	return result;
}

static gint
___lambda103_ (GitgHistoryRefsList* self,
               GMatchInfo* info,
               const gchar* value)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (info != NULL, 0);
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = g_match_info_fetch (info, 1);
	name = _tmp0_;
	_tmp1_ = self->priv->d_header_map;
	_tmp2_ = name;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_)) {
		const gchar* _tmp3_;
		GitgHistoryRefHeader* _tmp4_;
		GitgHistoryRefHeader* _tmp5_;
		_tmp3_ = name;
		_tmp4_ = gitg_history_refs_list_add_remote_header (self, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
	}
	result = 0;
	_g_free0 (name);
	return result;
}

static gint
____lambda103__ggit_config_match_callback (GMatchInfo* match_info,
                                           const gchar* value,
                                           gpointer self)
{
	gint result;
	result = ___lambda103_ ((GitgHistoryRefsList*) self, match_info, value);
	return result;
}

static void
gitg_history_refs_list_refresh (GitgHistoryRefsList* self)
{
	Block44Data* _data44_;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GitgRepository* _tmp2_;
	GitgHistoryRefRow* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp5_;
	GitgHistoryRefHeader* _tmp6_;
	GeeLinkedList* _tmp7_;
	GeeLinkedList* _tmp8_;
	GitgHistoryRefHeader* _tmp9_;
	GeeLinkedList* _tmp10_;
	GeeLinkedList* _tmp11_;
	GitgHistoryRefHeader* _tmp12_;
	GtkListBoxRow* sel = NULL;
	GtkListBoxRow* _tmp27_;
	GtkListBoxRow* _tmp28_;
	GtkListBoxRow* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	g_object_freeze_notify ((GObject*) self);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_selected_row);
	self->priv->d_selected_row = _tmp1_;
	gitg_history_refs_list_store_expanded_state (self);
	gitg_history_refs_list_clear (self);
	_tmp2_ = self->priv->d_repository;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (self->priv->d_selected_row);
		self->priv->d_selected_row = NULL;
		g_object_thaw_notify ((GObject*) self);
		block44_data_unref (_data44_);
		_data44_ = NULL;
		return;
	}
	_tmp3_ = gitg_history_refs_list_add_ref_row (self, NULL, GITG_HISTORY_REF_ANIMATION_NONE);
	_g_object_unref0 (self->priv->d_all_commits);
	self->priv->d_all_commits = _tmp3_;
	_tmp4_ = gitg_history_refs_list_get_branches_actions (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gitg_history_refs_list_add_header (self, GITG_REF_TYPE_BRANCH, _ ("Branches"), _tmp5_);
	_g_object_unref0 (self->priv->d_all_branches);
	self->priv->d_all_branches = _tmp6_;
	_tmp7_ = gitg_history_refs_list_get_remotes_actions (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gitg_history_refs_list_add_header (self, GITG_REF_TYPE_REMOTE, _ ("Remotes"), _tmp8_);
	_g_object_unref0 (self->priv->d_all_remotes);
	self->priv->d_all_remotes = _tmp9_;
	_tmp10_ = gitg_history_refs_list_get_tags_actions (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = gitg_history_refs_list_add_header (self, GITG_REF_TYPE_TAG, _ ("Tags"), _tmp11_);
	_g_object_unref0 (self->priv->d_all_tags);
	self->priv->d_all_tags = _tmp12_;
	_data44_->head = NULL;
	{
		gboolean _tmp13_ = FALSE;
		GitgRepository* _tmp14_;
		_tmp14_ = self->priv->d_repository;
		_tmp13_ = ggit_repository_is_head_detached ((GgitRepository*) _tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp13_) {
			GitgRef* _tmp15_ = NULL;
			GitgRepository* _tmp16_;
			GitgRef* _tmp17_;
			GitgHistoryRefRow* _tmp18_;
			_tmp16_ = self->priv->d_repository;
			_tmp17_ = gitg_repository_lookup_reference (_tmp16_, "HEAD", &_inner_error0_);
			_tmp15_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp18_ = gitg_history_refs_list_add_ref_internal (self, _tmp15_, GITG_HISTORY_REF_ANIMATION_NONE);
			_g_object_unref0 (_data44_->head);
			_data44_->head = _tmp18_;
			_g_object_unref0 (_tmp15_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block44_data_unref (_data44_);
		_data44_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GitgRepository* _tmp19_;
		GRegex* r = NULL;
		GRegex* _tmp20_;
		GgitConfig* _tmp21_ = NULL;
		GitgRepository* _tmp22_;
		GgitConfig* _tmp23_;
		GgitConfig* _tmp24_ = NULL;
		GgitConfig* _tmp25_;
		GRegex* _tmp26_;
		_tmp19_ = self->priv->d_repository;
		ggit_repository_references_foreach_name ((GgitRepository*) _tmp19_, ____lambda102__ggit_references_name_callback, _data44_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp20_ = g_regex_new ("remote\\.(.*)\\.url", 0, 0, &_inner_error0_);
		r = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp22_ = self->priv->d_repository;
		_tmp23_ = ggit_repository_get_config ((GgitRepository*) _tmp22_, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (r);
			goto __catch1_g_error;
		}
		_tmp25_ = ggit_config_snapshot (_tmp21_, &_inner_error0_);
		_tmp24_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp21_);
			_g_regex_unref0 (r);
			goto __catch1_g_error;
		}
		_tmp26_ = r;
		ggit_config_match_foreach (_tmp24_, _tmp26_, ____lambda103__ggit_config_match_callback, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (_tmp21_);
			_g_regex_unref0 (r);
			goto __catch1_g_error;
		}
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp21_);
		_g_regex_unref0 (r);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block44_data_unref (_data44_);
		_data44_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (self->priv->d_selected_row);
	self->priv->d_selected_row = NULL;
	_tmp27_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	sel = _tmp28_;
	_tmp29_ = sel;
	if (_tmp29_ == NULL) {
		GSettings* settings = NULL;
		GSettings* _tmp30_;
		GitgHistoryDefaultSelection default_selection = 0;
		GSettings* _tmp31_;
		GtkListBoxRow* srow = NULL;
		GtkListBoxRow* _tmp38_;
		_tmp30_ = g_settings_new (APPLICATION_ID ".preferences.history");
		settings = _tmp30_;
		_tmp31_ = settings;
		default_selection = (GitgHistoryDefaultSelection) g_settings_get_enum (_tmp31_, "default-selection");
		srow = NULL;
		switch (default_selection) {
			case GITG_HISTORY_DEFAULT_SELECTION_CURRENT_BRANCH:
			{
				GitgHistoryRefRow* _tmp32_;
				GtkListBoxRow* _tmp33_;
				_tmp32_ = _data44_->head;
				_tmp33_ = _g_object_ref0 ((GtkListBoxRow*) _tmp32_);
				_g_object_unref0 (srow);
				srow = _tmp33_;
				break;
			}
			case GITG_HISTORY_DEFAULT_SELECTION_ALL_BRANCHES:
			{
				GitgHistoryRefHeader* _tmp34_;
				GtkListBoxRow* _tmp35_;
				_tmp34_ = self->priv->d_all_branches;
				_tmp35_ = _g_object_ref0 ((GtkListBoxRow*) _tmp34_);
				_g_object_unref0 (srow);
				srow = _tmp35_;
				break;
			}
			case GITG_HISTORY_DEFAULT_SELECTION_ALL_COMMITS:
			{
				GitgHistoryRefRow* _tmp36_;
				GtkListBoxRow* _tmp37_;
				_tmp36_ = self->priv->d_all_commits;
				_tmp37_ = _g_object_ref0 ((GtkListBoxRow*) _tmp36_);
				_g_object_unref0 (srow);
				srow = _tmp37_;
				break;
			}
			default:
			break;
		}
		_tmp38_ = srow;
		if (_tmp38_ != NULL) {
			GtkListBoxRow* _tmp39_;
			_tmp39_ = srow;
			gtk_list_box_select_row ((GtkListBox*) self, _tmp39_);
		} else {
			GitgHistoryRefRow* _tmp40_;
			_tmp40_ = self->priv->d_all_commits;
			gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp40_);
		}
		_g_object_unref0 (srow);
		_g_object_unref0 (settings);
	}
	g_object_thaw_notify ((GObject*) self);
	_g_object_unref0 (sel);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

static GitgHistoryRefRow*
gitg_history_refs_list_get_ref_row (GitgHistoryRefsList* self,
                                    GtkListBoxRow* row)
{
	GitgHistoryRefRow* _tmp0_;
	GitgHistoryRefRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (row == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = _g_object_ref0 (GITG_HISTORY_IS_REF_ROW (row) ? ((GitgHistoryRefRow*) row) : NULL);
	result = _tmp0_;
	return result;
}

static GitgHistoryRefHeader*
gitg_history_refs_list_get_ref_header (GitgHistoryRefsList* self,
                                       GtkListBoxRow* row)
{
	GitgHistoryRefHeader* _tmp0_;
	GitgHistoryRefHeader* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (row != NULL, NULL);
	_tmp0_ = _g_object_ref0 (GITG_HISTORY_IS_REF_HEADER (row) ? ((GitgHistoryRefHeader*) row) : NULL);
	result = _tmp0_;
	return result;
}

static void
gitg_history_refs_list_real_row_selected (GtkListBox* base,
                                          GtkListBoxRow* row)
{
	GitgHistoryRefsList * self;
	self = (GitgHistoryRefsList*) base;
	g_object_notify ((GObject*) self, "selection");
}

static void
gitg_history_refs_list_real_move_cursor (GtkListBox* base,
                                         GtkMovementStep step,
                                         gint n)
{
	GitgHistoryRefsList * self;
	GtkListBoxRow* selrow = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	self = (GitgHistoryRefsList*) base;
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selrow = _tmp1_;
	GTK_LIST_BOX_CLASS (gitg_history_refs_list_parent_class)->move_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), step, n);
	_tmp2_ = selrow;
	_tmp3_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	if (_tmp2_ != _tmp3_) {
		g_object_notify ((GObject*) self, "selection");
	}
	_g_object_unref0 (selrow);
}

void
gitg_history_refs_list_edit (GitgHistoryRefsList* self,
                             GitgRef* reference,
                             GitgExtRefNameEditingDone done,
                             gpointer done_target,
                             GDestroyNotify done_target_destroy_notify)
{
	GitgHistoryRefRow* row = NULL;
	GeeHashMap* _tmp0_;
	GitgHistoryRefRow* _tmp19_;
	GitgExtRefNameEditingDone _tmp20_;
	gpointer _tmp20__target;
	GDestroyNotify _tmp20__target_destroy_notify;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reference != NULL);
	row = NULL;
	_tmp0_ = self->priv->d_ref_map;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, reference)) {
		GitgHistoryRefRow* _tmp16_;
		{
			GeeIterator* _r_it = NULL;
			GeeHashMap* _tmp1_;
			GeeSet* _tmp2_;
			GeeSet* _tmp3_;
			GeeSet* _tmp4_;
			GeeIterator* _tmp5_;
			GeeIterator* _tmp6_;
			_tmp1_ = self->priv->d_ref_map;
			_tmp2_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			_r_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_;
				GitgRef* r = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				GitgRef* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp7_ = _r_it;
				if (!gee_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _r_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				r = (GitgRef*) _tmp9_;
				_tmp10_ = r;
				_tmp11_ = ggit_ref_get_name ((GgitRef*) _tmp10_);
				_tmp12_ = ggit_ref_get_name ((GgitRef*) reference);
				if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
					GeeHashMap* _tmp13_;
					GitgRef* _tmp14_;
					gpointer _tmp15_;
					_tmp13_ = self->priv->d_ref_map;
					_tmp14_ = r;
					_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
					_g_object_unref0 (row);
					row = (GitgHistoryRefRow*) _tmp15_;
				}
				_g_object_unref0 (r);
			}
			_g_object_unref0 (_r_it);
		}
		_tmp16_ = row;
		if (_tmp16_ == NULL) {
			done ("", TRUE, done_target);
			_g_object_unref0 (row);
			(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
			done = NULL;
			done_target = NULL;
			done_target_destroy_notify = NULL;
			return;
		}
	} else {
		GeeHashMap* _tmp17_;
		gpointer _tmp18_;
		_tmp17_ = self->priv->d_ref_map;
		_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, reference);
		_g_object_unref0 (row);
		row = (GitgHistoryRefRow*) _tmp18_;
	}
	_tmp19_ = row;
	_tmp20_ = done;
	_tmp20__target = done_target;
	_tmp20__target_destroy_notify = done_target_destroy_notify;
	done = NULL;
	done_target = NULL;
	done_target_destroy_notify = NULL;
	gitg_history_ref_row_begin_editing (_tmp19_, _tmp20_, _tmp20__target, _tmp20__target_destroy_notify);
	_g_object_unref0 (row);
	(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
	done = NULL;
	done_target = NULL;
	done_target_destroy_notify = NULL;
}

gint
gitg_history_refs_list_y_in_window (GitgHistoryRefsList* self,
                                    gint y,
                                    GdkWindow* origin)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (origin != NULL, 0);
	while (TRUE) {
		GdkWindow* _tmp0_;
		gint wx = 0;
		gint wy = 0;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		GdkWindow* _tmp3_;
		_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
		if (!(origin != _tmp0_)) {
			break;
		}
		gdk_window_get_position (origin, &_tmp1_, &_tmp2_);
		wx = _tmp1_;
		wy = _tmp2_;
		y = y + wy;
		_tmp3_ = gdk_window_get_parent (origin);
		origin = _tmp3_;
	}
	result = y;
	return result;
}

static gboolean
gitg_history_refs_list_real_button_press_event (GtkWidget* base,
                                                GdkEventButton* button)
{
	GitgHistoryRefsList * self;
	gboolean ret = FALSE;
	gint y = 0;
	GdkWindow* _tmp0_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkListBoxRow* _tmp4_;
	gboolean result;
	self = (GitgHistoryRefsList*) base;
	g_return_val_if_fail (button != NULL, FALSE);
	ret = GTK_WIDGET_CLASS (gitg_history_refs_list_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), button);
	_tmp0_ = button->window;
	y = gitg_history_refs_list_y_in_window (self, (gint) button->y, _tmp0_);
	_tmp1_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, y);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp4_ = row;
	if (_tmp4_ != NULL) {
		GtkListBoxRow* _tmp5_;
		GtkListBoxRow* _tmp6_;
		_tmp5_ = row;
		_tmp6_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
		_tmp3_ = _tmp5_ != _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkListBoxRow* _tmp7_;
		_tmp7_ = row;
		gtk_list_box_select_row ((GtkListBox*) self, _tmp7_);
	}
	result = ret;
	_g_object_unref0 (row);
	return result;
}

static void
gitg_history_refs_list_scroll_to_row (GitgHistoryRefsList* self,
                                      GtkListBoxRow* row)
{
	GtkAdjustment* adj = NULL;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp2_ = {0};
	gdouble v = 0.0;
	GtkAdjustment* _tmp3_;
	gdouble s = 0.0;
	GtkAdjustment* _tmp4_;
	GtkAllocation _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_list_box_get_adjustment ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	adj = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) row, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = adj;
	v = gtk_adjustment_get_value (_tmp3_);
	_tmp4_ = adj;
	s = gtk_adjustment_get_page_size (_tmp4_);
	_tmp5_ = alloc;
	if (((gdouble) _tmp5_.y) < v) {
		GtkAdjustment* _tmp6_;
		GtkAllocation _tmp7_;
		_tmp6_ = adj;
		_tmp7_ = alloc;
		gtk_adjustment_set_value (_tmp6_, (gdouble) _tmp7_.y);
	} else {
		GtkAllocation _tmp8_;
		GtkAllocation _tmp9_;
		_tmp8_ = alloc;
		_tmp9_ = alloc;
		if (((gdouble) (_tmp8_.y + _tmp9_.height)) > (v + s)) {
			GtkAdjustment* _tmp10_;
			GtkAllocation _tmp11_;
			GtkAllocation _tmp12_;
			_tmp10_ = adj;
			_tmp11_ = alloc;
			_tmp12_ = alloc;
			gtk_adjustment_set_value (_tmp10_, (_tmp11_.y + _tmp12_.height) - s);
		}
	}
	_g_object_unref0 (adj);
}

GitgHistoryRefsList*
gitg_history_refs_list_construct (GType object_type)
{
	GitgHistoryRefsList * self = NULL;
	self = (GitgHistoryRefsList*) g_object_new (object_type, NULL);
	return self;
}

GitgHistoryRefsList*
gitg_history_refs_list_new (void)
{
	return gitg_history_refs_list_construct (GITG_HISTORY_TYPE_REFS_LIST);
}

GitgHistoryRefHeader*
gitg_history_refs_list_get_branches_header (GitgHistoryRefsList* self)
{
	GitgHistoryRefHeader* result;
	GitgHistoryRefHeader* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_all_branches;
	result = _tmp0_;
	return result;
}

GitgHistoryRefHeader*
gitg_history_refs_list_get_remotes_header (GitgHistoryRefsList* self)
{
	GitgHistoryRefHeader* result;
	GitgHistoryRefHeader* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_all_remotes;
	result = _tmp0_;
	return result;
}

GitgHistoryRefHeader*
gitg_history_refs_list_get_tags_header (GitgHistoryRefsList* self)
{
	GitgHistoryRefHeader* result;
	GitgHistoryRefHeader* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_all_tags;
	result = _tmp0_;
	return result;
}

GeeLinkedList*
gitg_history_refs_list_get_branches_actions (GitgHistoryRefsList* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_branches_actions;
	result = _tmp0_;
	return result;
}

void
gitg_history_refs_list_set_branches_actions (GitgHistoryRefsList* self,
                                             GeeLinkedList* value)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_branches_actions);
	self->priv->d_branches_actions = _tmp0_;
	gitg_history_refs_list_refresh (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_BRANCHES_ACTIONS_PROPERTY]);
}

GeeLinkedList*
gitg_history_refs_list_get_remotes_actions (GitgHistoryRefsList* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_remotes_actions;
	result = _tmp0_;
	return result;
}

void
gitg_history_refs_list_set_remotes_actions (GitgHistoryRefsList* self,
                                            GeeLinkedList* value)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_remotes_actions);
	self->priv->d_remotes_actions = _tmp0_;
	gitg_history_refs_list_refresh (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REMOTES_ACTIONS_PROPERTY]);
}

GeeLinkedList*
gitg_history_refs_list_get_tags_actions (GitgHistoryRefsList* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_tags_actions;
	result = _tmp0_;
	return result;
}

void
gitg_history_refs_list_set_tags_actions (GitgHistoryRefsList* self,
                                         GeeLinkedList* value)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_tags_actions);
	self->priv->d_tags_actions = _tmp0_;
	gitg_history_refs_list_refresh (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_TAGS_ACTIONS_PROPERTY]);
}

GitgExtApplication*
gitg_history_refs_list_get_application (GitgHistoryRefsList* self)
{
	GitgExtApplication* result;
	GitgExtApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	result = _tmp0_;
	return result;
}

void
gitg_history_refs_list_set_application (GitgHistoryRefsList* self,
                                        GitgExtApplication* value)
{
	GitgExtApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_history_refs_list_get_application (self);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_APPLICATION_PROPERTY]);
	}
}

GitgRepository*
gitg_history_refs_list_get_repository (GitgHistoryRefsList* self)
{
	GitgRepository* result;
	GitgRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_repository;
	result = _tmp0_;
	return result;
}

void
gitg_history_refs_list_set_repository (GitgHistoryRefsList* self,
                                       GitgRepository* value)
{
	GitgRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_repository);
	self->priv->d_repository = _tmp0_;
	gitg_history_refs_list_refresh (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REPOSITORY_PROPERTY]);
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		GitgHistoryRefsList* self;
		self = _data45_->self;
		_g_object_unref0 (_data45_->ret);
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static void
_gitg_history_refs_list_references___lambda104_ (Block45Data* _data45_,
                                                 GtkWidget* child)
{
	GitgHistoryRefsList* self;
	GitgHistoryRefRow* row = NULL;
	GitgHistoryRefRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GitgHistoryRefRow* _tmp2_;
	self = _data45_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (GITG_HISTORY_IS_REF_ROW (child) ? ((GitgHistoryRefRow*) child) : NULL);
	row = _tmp0_;
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		GitgHistoryRefRow* _tmp3_;
		GitgRef* _tmp4_;
		GitgRef* _tmp5_;
		_tmp3_ = row;
		_tmp4_ = gitg_history_ref_row_get_reference (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GitgHistoryRefRow* _tmp6_;
		GitgRef* _tmp7_;
		GitgRef* _tmp8_;
		_tmp6_ = row;
		_tmp7_ = gitg_history_ref_row_get_reference (_tmp6_);
		_tmp8_ = _tmp7_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data45_->ret, _tmp8_);
	}
	_g_object_unref0 (row);
}

static void
__gitg_history_refs_list_references___lambda104__gtk_callback (GtkWidget* widget,
                                                               gpointer self)
{
	_gitg_history_refs_list_references___lambda104_ (self, widget);
}

GeeList*
gitg_history_refs_list_get_references (GitgHistoryRefsList* self)
{
	GeeList* result;
	Block45Data* _data45_;
	GeeLinkedList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_data45_ = g_slice_new0 (Block45Data);
	_data45_->_ref_count_ = 1;
	_data45_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data45_->ret = _tmp0_;
	gtk_container_foreach ((GtkContainer*) self, __gitg_history_refs_list_references___lambda104__gtk_callback, _data45_);
	_tmp1_ = _g_object_ref0 ((GeeList*) _data45_->ret);
	result = _tmp1_;
	block45_data_unref (_data45_);
	_data45_ = NULL;
	return result;
}

const gchar*
gitg_history_refs_list_get_reference_sort_order (GitgHistoryRefsList* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->d_ref_sort_order == GITG_HISTORY_REF_ROW_SORT_ORDER_LAST_ACTIVITY) {
		result = "last-activity";
		return result;
	} else {
		result = "name";
		return result;
	}
}

void
gitg_history_refs_list_set_reference_sort_order (GitgHistoryRefsList* self,
                                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, "last-activity") == 0) {
		self->priv->d_ref_sort_order = GITG_HISTORY_REF_ROW_SORT_ORDER_LAST_ACTIVITY;
	} else {
		self->priv->d_ref_sort_order = GITG_HISTORY_REF_ROW_SORT_ORDER_NAME;
	}
	gtk_list_box_invalidate_sort ((GtkListBox*) self);
	g_object_notify_by_pspec ((GObject *) self, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REFERENCE_SORT_ORDER_PROPERTY]);
}

GeeList*
gitg_history_refs_list_get_all (GitgHistoryRefsList* self)
{
	GeeList* result;
	GeeLinkedList* ret = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GitgHistoryRefRow* r = NULL;
				GtkWidget* _tmp2_;
				GitgHistoryRefRow* _tmp3_;
				gboolean _tmp4_ = FALSE;
				GitgHistoryRefRow* _tmp5_;
				_tmp2_ = child;
				_tmp3_ = gitg_history_refs_list_get_ref_row (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp2_) : NULL);
				r = _tmp3_;
				_tmp5_ = r;
				if (_tmp5_ != NULL) {
					GitgHistoryRefRow* _tmp6_;
					GitgRef* _tmp7_;
					GitgRef* _tmp8_;
					_tmp6_ = r;
					_tmp7_ = gitg_history_ref_row_get_reference (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp4_ = _tmp8_ != NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GeeLinkedList* _tmp9_;
					GitgHistoryRefRow* _tmp10_;
					GitgRef* _tmp11_;
					GitgRef* _tmp12_;
					_tmp9_ = ret;
					_tmp10_ = r;
					_tmp11_ = gitg_history_ref_row_get_reference (_tmp10_);
					_tmp12_ = _tmp11_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
				}
				_g_object_unref0 (r);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	{
		gboolean _tmp13_ = FALSE;
		GitgRepository* _tmp14_;
		_tmp14_ = self->priv->d_repository;
		if (_tmp14_ != NULL) {
			gboolean _tmp15_ = FALSE;
			GitgRepository* _tmp16_;
			_tmp16_ = self->priv->d_repository;
			_tmp15_ = ggit_repository_is_head_detached ((GgitRepository*) _tmp16_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp15_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GitgRef* _tmp17_ = NULL;
			GitgRepository* _tmp18_;
			GitgRef* _tmp19_;
			GeeLinkedList* _tmp20_;
			_tmp18_ = self->priv->d_repository;
			_tmp19_ = gitg_repository_get_head (_tmp18_, &_inner_error0_);
			_tmp17_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp20_ = ret;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp17_);
			_g_object_unref0 (_tmp17_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (ret);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = (GeeList*) ret;
	return result;
}

gboolean
gitg_history_refs_list_get_is_header (GitgHistoryRefsList* self)
{
	gboolean result;
	GtkListBoxRow* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	result = (GITG_HISTORY_IS_REF_HEADER (_tmp0_) ? ((GitgHistoryRefHeader*) _tmp0_) : NULL) != NULL;
	return result;
}

gboolean
gitg_history_refs_list_get_is_all (GitgHistoryRefsList* self)
{
	gboolean result;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GitgHistoryRefRow* ref_row = NULL;
	GtkListBoxRow* _tmp3_;
	GitgHistoryRefRow* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GitgHistoryRefRow* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_object_unref0 (row);
		return result;
	}
	_tmp3_ = row;
	_tmp4_ = gitg_history_refs_list_get_ref_row (self, _tmp3_);
	ref_row = _tmp4_;
	_tmp6_ = ref_row;
	if (_tmp6_ != NULL) {
		GitgHistoryRefRow* _tmp7_;
		GitgRef* _tmp8_;
		GitgRef* _tmp9_;
		_tmp7_ = ref_row;
		_tmp8_ = gitg_history_ref_row_get_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ == NULL;
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	_g_object_unref0 (ref_row);
	_g_object_unref0 (row);
	return result;
}

GeeList*
gitg_history_refs_list_get_selection (GitgHistoryRefsList* self)
{
	GeeList* result;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GitgHistoryRefRow* ref_row = NULL;
	GtkListBoxRow* _tmp5_;
	GitgHistoryRefRow* _tmp6_;
	GeeLinkedList* ret = NULL;
	GeeLinkedList* _tmp7_;
	GitgHistoryRefRow* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ == NULL) {
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = gitg_history_refs_list_get_all (self);
		_tmp4_ = _tmp3_;
		result = _tmp4_;
		_g_object_unref0 (row);
		return result;
	}
	_tmp5_ = row;
	_tmp6_ = gitg_history_refs_list_get_ref_row (self, _tmp5_);
	ref_row = _tmp6_;
	_tmp7_ = gee_linked_list_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = _tmp7_;
	_tmp8_ = ref_row;
	if (_tmp8_ != NULL) {
		GitgHistoryRefRow* _tmp9_;
		GitgRef* _tmp10_;
		GitgRef* _tmp11_;
		_tmp9_ = ref_row;
		_tmp10_ = gitg_history_ref_row_get_reference (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			GeeList* _tmp12_;
			GeeList* _tmp13_;
			_tmp12_ = gitg_history_refs_list_get_all (self);
			_tmp13_ = _tmp12_;
			result = _tmp13_;
			_g_object_unref0 (ret);
			_g_object_unref0 (ref_row);
			_g_object_unref0 (row);
			return result;
		} else {
			GeeLinkedList* _tmp14_;
			GitgHistoryRefRow* _tmp15_;
			GitgRef* _tmp16_;
			GitgRef* _tmp17_;
			_tmp14_ = ret;
			_tmp15_ = ref_row;
			_tmp16_ = gitg_history_ref_row_get_reference (_tmp15_);
			_tmp17_ = _tmp16_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
		}
	} else {
		GitgHistoryRefHeader* ref_header = NULL;
		GtkListBoxRow* _tmp18_;
		GitgHistoryRefHeader* _tmp19_;
		gboolean found = FALSE;
		GList* _tmp20_;
		_tmp18_ = row;
		_tmp19_ = gitg_history_refs_list_get_ref_header (self, _tmp18_);
		ref_header = _tmp19_;
		found = FALSE;
		_tmp20_ = gtk_container_get_children ((GtkContainer*) self);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp20_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child = NULL;
				child = (GtkWidget*) child_it->data;
				{
					if (found) {
						GtkListBoxRow* nrow = NULL;
						GtkWidget* _tmp21_;
						GtkListBoxRow* _tmp22_;
						GitgHistoryRefRow* nref_row = NULL;
						GtkListBoxRow* _tmp23_;
						GitgHistoryRefRow* _tmp24_;
						GitgHistoryRefRow* _tmp25_;
						_tmp21_ = child;
						_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp21_) : NULL);
						nrow = _tmp22_;
						_tmp23_ = nrow;
						_tmp24_ = gitg_history_refs_list_get_ref_row (self, _tmp23_);
						nref_row = _tmp24_;
						_tmp25_ = nref_row;
						if (_tmp25_ == NULL) {
							GitgHistoryRefHeader* nref_header = NULL;
							GtkListBoxRow* _tmp26_;
							GitgHistoryRefHeader* _tmp27_;
							gboolean _tmp28_ = FALSE;
							GitgHistoryRefHeader* _tmp29_;
							gboolean _tmp30_;
							gboolean _tmp31_;
							_tmp26_ = nrow;
							_tmp27_ = gitg_history_refs_list_get_ref_header (self, _tmp26_);
							nref_header = _tmp27_;
							_tmp29_ = ref_header;
							_tmp30_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp29_);
							_tmp31_ = _tmp30_;
							if (_tmp31_) {
								_tmp28_ = TRUE;
							} else {
								GitgHistoryRefHeader* _tmp32_;
								GitgRefType _tmp33_;
								GitgRefType _tmp34_;
								GitgHistoryRefHeader* _tmp35_;
								GitgRefType _tmp36_;
								GitgRefType _tmp37_;
								_tmp32_ = nref_header;
								_tmp33_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = ref_header;
								_tmp36_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp35_);
								_tmp37_ = _tmp36_;
								_tmp28_ = _tmp34_ != _tmp37_;
							}
							if (_tmp28_) {
								_g_object_unref0 (nref_header);
								_g_object_unref0 (nref_row);
								_g_object_unref0 (nrow);
								break;
							}
							_g_object_unref0 (nref_header);
						} else {
							GeeLinkedList* _tmp38_;
							GitgHistoryRefRow* _tmp39_;
							GitgRef* _tmp40_;
							GitgRef* _tmp41_;
							_tmp38_ = ret;
							_tmp39_ = nref_row;
							_tmp40_ = gitg_history_ref_row_get_reference (_tmp39_);
							_tmp41_ = _tmp40_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp41_);
						}
						_g_object_unref0 (nref_row);
						_g_object_unref0 (nrow);
					} else {
						GtkWidget* _tmp42_;
						GtkListBoxRow* _tmp43_;
						_tmp42_ = child;
						_tmp43_ = row;
						if (_tmp42_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget)) {
							found = TRUE;
						}
					}
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
		_g_object_unref0 (ref_header);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (ref_row);
	_g_object_unref0 (row);
	return result;
}

static GitgHistoryRefsListRemoteHeader*
gitg_history_refs_list_remote_header_construct (GType object_type,
                                                GitgHistoryRefHeader* h)
{
	GitgHistoryRefsListRemoteHeader* self = NULL;
	GitgHistoryRefHeader* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_val_if_fail (h != NULL, NULL);
	self = (GitgHistoryRefsListRemoteHeader*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (h);
	_g_object_unref0 (self->header);
	self->header = _tmp0_;
	_tmp1_ = gee_hash_set_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->references);
	self->references = _tmp1_;
	return self;
}

static GitgHistoryRefsListRemoteHeader*
gitg_history_refs_list_remote_header_new (GitgHistoryRefHeader* h)
{
	return gitg_history_refs_list_remote_header_construct (GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, h);
}

static void
gitg_history_refs_list_value_remote_header_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_history_refs_list_value_remote_header_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_history_refs_list_remote_header_unref (value->data[0].v_pointer);
	}
}

static void
gitg_history_refs_list_value_remote_header_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_history_refs_list_remote_header_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_history_refs_list_value_remote_header_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_history_refs_list_value_remote_header_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgHistoryRefsListRemoteHeader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_history_refs_list_remote_header_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_history_refs_list_value_remote_header_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	GitgHistoryRefsListRemoteHeader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_history_refs_list_remote_header_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gitg_history_refs_list_param_spec_remote_header (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	GitgHistoryRefsListParamSpecRemoteHeader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gitg_history_refs_list_value_get_remote_header (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER), NULL);
	return value->data[0].v_pointer;
}

static void
gitg_history_refs_list_value_set_remote_header (GValue* value,
                                                gpointer v_object)
{
	GitgHistoryRefsListRemoteHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_history_refs_list_remote_header_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_history_refs_list_remote_header_unref (old);
	}
}

static void
gitg_history_refs_list_value_take_remote_header (GValue* value,
                                                 gpointer v_object)
{
	GitgHistoryRefsListRemoteHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_history_refs_list_remote_header_unref (old);
	}
}

static void
gitg_history_refs_list_remote_header_class_init (GitgHistoryRefsListRemoteHeaderClass * klass,
                                                 gpointer klass_data)
{
	gitg_history_refs_list_remote_header_parent_class = g_type_class_peek_parent (klass);
	((GitgHistoryRefsListRemoteHeaderClass *) klass)->finalize = gitg_history_refs_list_remote_header_finalize;
}

static void
gitg_history_refs_list_remote_header_instance_init (GitgHistoryRefsListRemoteHeader * self,
                                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_history_refs_list_remote_header_finalize (GitgHistoryRefsListRemoteHeader * obj)
{
	GitgHistoryRefsListRemoteHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeader);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->header);
	_g_object_unref0 (self->references);
}

 G_GNUC_NO_INLINE static GType
gitg_history_refs_list_remote_header_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_history_refs_list_value_remote_header_init, gitg_history_refs_list_value_remote_header_free_value, gitg_history_refs_list_value_remote_header_copy_value, gitg_history_refs_list_value_remote_header_peek_pointer, "p", gitg_history_refs_list_value_remote_header_collect_value, "p", gitg_history_refs_list_value_remote_header_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefsListRemoteHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_refs_list_remote_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefsListRemoteHeader), 0, (GInstanceInitFunc) gitg_history_refs_list_remote_header_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_history_refs_list_remote_header_type_id;
	gitg_history_refs_list_remote_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgHistoryRefsListRemoteHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_history_refs_list_remote_header_type_id;
}

static GType
gitg_history_refs_list_remote_header_get_type (void)
{
	static gsize gitg_history_refs_list_remote_header_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_refs_list_remote_header_type_id__once)) {
		GType gitg_history_refs_list_remote_header_type_id;
		gitg_history_refs_list_remote_header_type_id = gitg_history_refs_list_remote_header_get_type_once ();
		g_once_init_leave (&gitg_history_refs_list_remote_header_type_id__once, gitg_history_refs_list_remote_header_type_id);
	}
	return gitg_history_refs_list_remote_header_type_id__once;
}

static gpointer
gitg_history_refs_list_remote_header_ref (gpointer instance)
{
	GitgHistoryRefsListRemoteHeader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gitg_history_refs_list_remote_header_unref (gpointer instance)
{
	GitgHistoryRefsListRemoteHeader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_HISTORY_REFS_LIST_REMOTE_HEADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
gitg_history_refs_list_header_state_copy (const GitgHistoryRefsListHeaderState* self,
                                          GitgHistoryRefsListHeaderState* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).type = (*self).type;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).expanded = (*self).expanded;
}

static void
gitg_history_refs_list_header_state_destroy (GitgHistoryRefsListHeaderState* self)
{
	_g_free0 ((*self).name);
}

static GitgHistoryRefsListHeaderState*
gitg_history_refs_list_header_state_dup (const GitgHistoryRefsListHeaderState* self)
{
	GitgHistoryRefsListHeaderState* dup;
	dup = g_new0 (GitgHistoryRefsListHeaderState, 1);
	gitg_history_refs_list_header_state_copy (self, dup);
	return dup;
}

static void
gitg_history_refs_list_header_state_free (GitgHistoryRefsListHeaderState* self)
{
	gitg_history_refs_list_header_state_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_history_refs_list_header_state_get_type_once (void)
{
	GType gitg_history_refs_list_header_state_type_id;
	gitg_history_refs_list_header_state_type_id = g_boxed_type_register_static ("GitgHistoryRefsListHeaderState", (GBoxedCopyFunc) gitg_history_refs_list_header_state_dup, (GBoxedFreeFunc) gitg_history_refs_list_header_state_free);
	return gitg_history_refs_list_header_state_type_id;
}

static GType
gitg_history_refs_list_header_state_get_type (void)
{
	static gsize gitg_history_refs_list_header_state_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_refs_list_header_state_type_id__once)) {
		GType gitg_history_refs_list_header_state_type_id;
		gitg_history_refs_list_header_state_type_id = gitg_history_refs_list_header_state_get_type_once ();
		g_once_init_leave (&gitg_history_refs_list_header_state_type_id__once, gitg_history_refs_list_header_state_type_id);
	}
	return gitg_history_refs_list_header_state_type_id__once;
}

static gint
_gitg_history_refs_list_sort_rows_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self)
{
	gint result;
	result = gitg_history_refs_list_sort_rows ((GitgHistoryRefsList*) self, row1, row2);
	return result;
}

static gboolean
_gitg_history_refs_list_filter_func_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                              gpointer self)
{
	gboolean result;
	result = gitg_history_refs_list_filter_func ((GitgHistoryRefsList*) self, row);
	return result;
}

static GObject *
gitg_history_refs_list_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgHistoryRefsList * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GitgRemote** _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	parent_class = G_OBJECT_CLASS (gitg_history_refs_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, (GBoxedCopyFunc) gitg_history_refs_list_remote_header_ref, (GDestroyNotify) gitg_history_refs_list_remote_header_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_header_map);
	self->priv->d_header_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GITG_HISTORY_TYPE_REF_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_ref_map);
	self->priv->d_ref_map = _tmp1_;
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_BROWSE);
	_tmp2_ = g_new0 (GitgRemote*, 0 + 1);
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_remotes = _tmp2_;
	self->priv->d_remotes_length1 = 0;
	self->priv->_d_remotes_size_ = self->priv->d_remotes_length1;
	gtk_list_box_set_activate_on_single_click ((GtkListBox*) self, FALSE);
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_history_refs_list_sort_rows_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_history_refs_list_filter_func_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp3_ = g_settings_new (APPLICATION_ID ".preferences.history");
	settings = _tmp3_;
	_tmp4_ = settings;
	g_settings_bind (_tmp4_, "reference-sort-order", (GObject*) self, "reference-sort-order", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_g_object_unref0 (settings);
	return obj;
}

static void
gitg_history_refs_list_class_init (GitgHistoryRefsListClass * klass,
                                   gpointer klass_data)
{
	gitg_history_refs_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgHistoryRefsList_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_history_refs_list_real_dispose;
	((GtkListBoxClass *) klass)->row_selected = (void (*) (GtkListBox*, GtkListBoxRow*)) gitg_history_refs_list_real_row_selected;
	((GtkListBoxClass *) klass)->move_cursor = (void (*) (GtkListBox*, GtkMovementStep, gint)) gitg_history_refs_list_real_move_cursor;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) gitg_history_refs_list_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_history_refs_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_history_refs_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_history_refs_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_history_refs_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_BRANCHES_HEADER_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_BRANCHES_HEADER_PROPERTY] = g_param_spec_object ("branches-header", "branches-header", "branches-header", GITG_HISTORY_TYPE_REF_HEADER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REMOTES_HEADER_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REMOTES_HEADER_PROPERTY] = g_param_spec_object ("remotes-header", "remotes-header", "remotes-header", GITG_HISTORY_TYPE_REF_HEADER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_TAGS_HEADER_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_TAGS_HEADER_PROPERTY] = g_param_spec_object ("tags-header", "tags-header", "tags-header", GITG_HISTORY_TYPE_REF_HEADER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_BRANCHES_ACTIONS_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_BRANCHES_ACTIONS_PROPERTY] = g_param_spec_object ("branches-actions", "branches-actions", "branches-actions", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REMOTES_ACTIONS_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REMOTES_ACTIONS_PROPERTY] = g_param_spec_object ("remotes-actions", "remotes-actions", "remotes-actions", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_TAGS_ACTIONS_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_TAGS_ACTIONS_PROPERTY] = g_param_spec_object ("tags-actions", "tags-actions", "tags-actions", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_APPLICATION_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REPOSITORY_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REPOSITORY_PROPERTY] = g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REFERENCES_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REFERENCES_PROPERTY] = g_param_spec_object ("references", "references", "references", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REFERENCE_SORT_ORDER_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_REFERENCE_SORT_ORDER_PROPERTY] = g_param_spec_string ("reference-sort-order", "reference-sort-order", "reference-sort-order", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_ALL_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_ALL_PROPERTY] = g_param_spec_object ("all", "all", "all", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_IS_HEADER_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_IS_HEADER_PROPERTY] = g_param_spec_boolean ("is-header", "is-header", "is-header", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_IS_ALL_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_IS_ALL_PROPERTY] = g_param_spec_boolean ("is-all", "is-all", "is-all", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_SELECTION_PROPERTY, gitg_history_refs_list_properties[GITG_HISTORY_REFS_LIST_SELECTION_PROPERTY] = g_param_spec_object ("selection", "selection", "selection", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gitg_history_refs_list_signals[GITG_HISTORY_REFS_LIST_CHANGED_SIGNAL] = g_signal_new ("changed", GITG_HISTORY_TYPE_REFS_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gitg_history_refs_list_instance_init (GitgHistoryRefsList * self,
                                      gpointer klass)
{
	self->priv = gitg_history_refs_list_get_instance_private (self);
	self->priv->d_branches_actions = NULL;
	self->priv->d_remotes_actions = NULL;
	self->priv->d_tags_actions = NULL;
}

static void
gitg_history_refs_list_finalize (GObject * obj)
{
	GitgHistoryRefsList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
	_g_object_unref0 (self->priv->d_repository);
	_g_object_unref0 (self->priv->d_ref_map);
	_g_object_unref0 (self->priv->d_selected_row);
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_all_commits);
	_g_object_unref0 (self->priv->d_all_branches);
	_g_object_unref0 (self->priv->d_all_remotes);
	_g_object_unref0 (self->priv->d_all_tags);
	self->priv->d_expanded = (_vala_GitgHistoryRefsListHeaderState_array_free (self->priv->d_expanded, self->priv->d_expanded_length1), NULL);
	_g_object_unref0 (self->priv->d_branches_actions);
	_g_object_unref0 (self->priv->d_remotes_actions);
	_g_object_unref0 (self->priv->d_tags_actions);
	_g_object_unref0 (self->priv->d_header_map);
	_g_object_unref0 (self->priv->_application);
	G_OBJECT_CLASS (gitg_history_refs_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_history_refs_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefsListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_refs_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefsList), 0, (GInstanceInitFunc) gitg_history_refs_list_instance_init, NULL };
	GType gitg_history_refs_list_type_id;
	gitg_history_refs_list_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgHistoryRefsList", &g_define_type_info, 0);
	GitgHistoryRefsList_private_offset = g_type_add_instance_private (gitg_history_refs_list_type_id, sizeof (GitgHistoryRefsListPrivate));
	return gitg_history_refs_list_type_id;
}

GType
gitg_history_refs_list_get_type (void)
{
	static gsize gitg_history_refs_list_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_refs_list_type_id__once)) {
		GType gitg_history_refs_list_type_id;
		gitg_history_refs_list_type_id = gitg_history_refs_list_get_type_once ();
		g_once_init_leave (&gitg_history_refs_list_type_id__once, gitg_history_refs_list_type_id);
	}
	return gitg_history_refs_list_type_id__once;
}

static void
_vala_gitg_history_refs_list_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GitgHistoryRefsList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
	switch (property_id) {
		case GITG_HISTORY_REFS_LIST_BRANCHES_HEADER_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_branches_header (self));
		break;
		case GITG_HISTORY_REFS_LIST_REMOTES_HEADER_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_remotes_header (self));
		break;
		case GITG_HISTORY_REFS_LIST_TAGS_HEADER_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_tags_header (self));
		break;
		case GITG_HISTORY_REFS_LIST_BRANCHES_ACTIONS_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_branches_actions (self));
		break;
		case GITG_HISTORY_REFS_LIST_REMOTES_ACTIONS_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_remotes_actions (self));
		break;
		case GITG_HISTORY_REFS_LIST_TAGS_ACTIONS_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_tags_actions (self));
		break;
		case GITG_HISTORY_REFS_LIST_APPLICATION_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_application (self));
		break;
		case GITG_HISTORY_REFS_LIST_REPOSITORY_PROPERTY:
		g_value_set_object (value, gitg_history_refs_list_get_repository (self));
		break;
		case GITG_HISTORY_REFS_LIST_REFERENCES_PROPERTY:
		g_value_take_object (value, gitg_history_refs_list_get_references (self));
		break;
		case GITG_HISTORY_REFS_LIST_REFERENCE_SORT_ORDER_PROPERTY:
		g_value_set_string (value, gitg_history_refs_list_get_reference_sort_order (self));
		break;
		case GITG_HISTORY_REFS_LIST_ALL_PROPERTY:
		g_value_take_object (value, gitg_history_refs_list_get_all (self));
		break;
		case GITG_HISTORY_REFS_LIST_IS_HEADER_PROPERTY:
		g_value_set_boolean (value, gitg_history_refs_list_get_is_header (self));
		break;
		case GITG_HISTORY_REFS_LIST_IS_ALL_PROPERTY:
		g_value_set_boolean (value, gitg_history_refs_list_get_is_all (self));
		break;
		case GITG_HISTORY_REFS_LIST_SELECTION_PROPERTY:
		g_value_take_object (value, gitg_history_refs_list_get_selection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_history_refs_list_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GitgHistoryRefsList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
	switch (property_id) {
		case GITG_HISTORY_REFS_LIST_BRANCHES_ACTIONS_PROPERTY:
		gitg_history_refs_list_set_branches_actions (self, g_value_get_object (value));
		break;
		case GITG_HISTORY_REFS_LIST_REMOTES_ACTIONS_PROPERTY:
		gitg_history_refs_list_set_remotes_actions (self, g_value_get_object (value));
		break;
		case GITG_HISTORY_REFS_LIST_TAGS_ACTIONS_PROPERTY:
		gitg_history_refs_list_set_tags_actions (self, g_value_get_object (value));
		break;
		case GITG_HISTORY_REFS_LIST_APPLICATION_PROPERTY:
		gitg_history_refs_list_set_application (self, g_value_get_object (value));
		break;
		case GITG_HISTORY_REFS_LIST_REPOSITORY_PROPERTY:
		gitg_history_refs_list_set_repository (self, g_value_get_object (value));
		break;
		case GITG_HISTORY_REFS_LIST_REFERENCE_SORT_ORDER_PROPERTY:
		gitg_history_refs_list_set_reference_sort_order (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

