/* wii-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from wii-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "games-wii-plugin.h"

#define GAMES_WII_PLUGIN_MIME_TYPE "application/x-wii-rom"
#define GAMES_WII_PLUGIN_PLATFORM_ID "Wii"
#define GAMES_WII_PLUGIN_PLATFORM_NAME _ ("Wii")
#define GAMES_WII_PLUGIN_PLATFORM_UID_PREFIX "wii"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_WII_PLUGIN (games_wii_plugin_get_type ())
#define GAMES_WII_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_WII_PLUGIN, GamesWiiPlugin))
#define GAMES_WII_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_WII_PLUGIN, GamesWiiPluginClass))
#define GAMES_IS_WII_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_WII_PLUGIN))
#define GAMES_IS_WII_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_WII_PLUGIN))
#define GAMES_WII_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_WII_PLUGIN, GamesWiiPluginClass))

typedef struct _GamesWiiPlugin GamesWiiPlugin;
typedef struct _GamesWiiPluginClass GamesWiiPluginClass;
typedef struct _GamesWiiPluginPrivate GamesWiiPluginPrivate;
enum  {
	GAMES_WII_PLUGIN_0_PROPERTY,
	GAMES_WII_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_wii_plugin_properties[GAMES_WII_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_WII_HEADER (games_wii_header_get_type ())
#define GAMES_WII_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_WII_HEADER, GamesWiiHeader))
#define GAMES_WII_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_WII_HEADER, GamesWiiHeaderClass))
#define GAMES_IS_WII_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_WII_HEADER))
#define GAMES_IS_WII_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_WII_HEADER))
#define GAMES_WII_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_WII_HEADER, GamesWiiHeaderClass))

typedef struct _GamesWiiHeader GamesWiiHeader;
typedef struct _GamesWiiHeaderClass GamesWiiHeaderClass;

#define GAMES_TYPE_WII_ERROR (games_wii_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesWiiPlugin {
	GObject parent_instance;
	GamesWiiPluginPrivate * priv;
};

struct _GamesWiiPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_WII_ERROR_CANT_READ_FILE,
	GAMES_WII_ERROR_INVALID_SIZE,
	GAMES_WII_ERROR_INVALID_HEADER
} GamesWiiError;
#define GAMES_WII_ERROR games_wii_error_quark ()

static gpointer games_wii_plugin_parent_class = NULL;
static GamesRetroPlatform* games_wii_plugin_platform;
static GamesRetroPlatform* games_wii_plugin_platform = NULL;
static GamesPluginIface * games_wii_plugin_games_plugin_parent_iface = NULL;
static GType games_wii_plugin_type_id = 0;

GType games_wii_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_wii_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_wii_plugin_real_get_platforms (GamesPlugin* base,
                                                     gint* result_length1);
static gchar** games_wii_plugin_real_get_mime_types (GamesPlugin* base,
                                              gint* result_length1);
static GamesUriGameFactory** games_wii_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                    gint* result_length1);
static GamesGame* games_wii_plugin_game_for_uri (GamesUri* uri,
                                          GError** error);
static GamesGame* _games_wii_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                       gpointer self,
                                                                                       GError** error);
static GamesRunnerFactory** games_wii_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                 gint* result_length1);
GType games_wii_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_wii_header_get_type (void) G_GNUC_CONST ;
static gchar* games_wii_plugin_get_uid (GamesWiiHeader* header,
                                 GError** error);
VALA_EXTERN GQuark games_wii_error_quark (void);
VALA_EXTERN GType games_wii_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* games_wii_header_get_game_id (GamesWiiHeader* self,
                                     GError** error);
VALA_EXTERN GamesWiiHeader* games_wii_header_new (GFile* file);
VALA_EXTERN GamesWiiHeader* games_wii_header_construct (GType object_type,
                                            GFile* file);
VALA_EXTERN void games_wii_header_check_validity (GamesWiiHeader* self,
                                      GError** error);
VALA_EXTERN GamesWiiPlugin* games_wii_plugin_new (void);
VALA_EXTERN GamesWiiPlugin* games_wii_plugin_construct (GType object_type);
static void games_wii_plugin_finalize (GObject * obj);
GType games_wii_header_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_wii_plugin_real_get_platforms (GamesPlugin* base,
                                     gint* result_length1)
{
	GamesWiiPlugin * self;
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesWiiPlugin*) base;
	_tmp0_ = games_wii_plugin_platform;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gchar**
games_wii_plugin_real_get_mime_types (GamesPlugin* base,
                                      gint* result_length1)
{
	GamesWiiPlugin * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (GamesWiiPlugin*) base;
	_tmp0_ = g_strdup (GAMES_WII_PLUGIN_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GamesGame*
_games_wii_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                            gpointer self,
                                                                            GError** error)
{
	GamesGame* result;
	result = games_wii_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_wii_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                              gint* result_length1)
{
	GamesWiiPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesWiiPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_wii_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_WII_PLUGIN_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunnerFactory**
games_wii_plugin_real_get_runner_factories (GamesPlugin* base,
                                            gint* result_length1)
{
	GamesWiiPlugin * self;
	GamesRetroRunnerFactory* factory = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroRunnerFactory* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesWiiPlugin*) base;
	_tmp0_ = games_wii_plugin_platform;
	_tmp1_ = games_retro_runner_factory_new (_tmp0_);
	factory = _tmp1_;
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_wii_plugin_get_uid (GamesWiiHeader* header,
                          GError** error)
{
	gchar* game_id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (header != NULL, NULL);
	_tmp0_ = games_wii_header_get_game_id (header, &_inner_error0_);
	game_id = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = string_to_string (GAMES_WII_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp2_ = string_to_string (game_id);
	_tmp3_ = g_strconcat (_tmp1_, "-", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	_g_free0 (game_id);
	return result;
}

static GamesGame*
games_wii_plugin_game_for_uri (GamesUri* uri,
                               GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GamesWiiHeader* header = NULL;
	GFile* _tmp1_;
	GamesWiiHeader* _tmp2_;
	GamesWiiHeader* _tmp3_;
	gchar* _tmp4_ = NULL;
	GamesWiiHeader* _tmp5_;
	gchar* _tmp6_;
	GamesUid* uid = NULL;
	GamesUid* _tmp7_;
	GamesFilenameTitle* title = NULL;
	GamesFilenameTitle* _tmp8_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp9_;
	GamesGriloMedia* _tmp10_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp11_;
	GamesGriloMedia* _tmp12_;
	GamesUid* _tmp13_;
	GamesGriloCover* _tmp14_;
	GamesCover** _tmp15_;
	GamesCover** _tmp16_;
	gint _tmp16__length1;
	GamesCompositeCover* _tmp17_;
	GamesCompositeCover* _tmp18_;
	GamesGame* game = NULL;
	GamesUid* _tmp19_;
	GamesFilenameTitle* _tmp20_;
	GamesRetroPlatform* _tmp21_;
	GamesGame* _tmp22_;
	GamesGame* _tmp23_;
	GamesCompositeCover* _tmp24_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = games_wii_header_new (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	games_wii_header_check_validity (_tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp5_ = header;
	_tmp6_ = games_wii_plugin_get_uid (_tmp5_, &_inner_error0_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp7_ = games_uid_new (_tmp4_);
	uid = _tmp7_;
	_tmp8_ = games_filename_title_new (uri);
	title = _tmp8_;
	_tmp9_ = title;
	_tmp10_ = games_grilo_media_new ((GamesTitle*) _tmp9_, GAMES_WII_PLUGIN_MIME_TYPE);
	media = _tmp10_;
	_tmp11_ = games_local_cover_new (uri);
	_tmp12_ = media;
	_tmp13_ = uid;
	_tmp14_ = games_grilo_cover_new (_tmp12_, _tmp13_);
	_tmp15_ = g_new0 (GamesCover*, 2 + 1);
	_tmp15_[0] = (GamesCover*) _tmp11_;
	_tmp15_[1] = (GamesCover*) _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	_tmp17_ = games_composite_cover_new (_tmp16_, 2);
	_tmp18_ = _tmp17_;
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp18_;
	_tmp19_ = uid;
	_tmp20_ = title;
	_tmp21_ = games_wii_plugin_platform;
	_tmp22_ = games_game_new (_tmp19_, uri, (GamesTitle*) _tmp20_, (GamesPlatform*) _tmp21_);
	game = _tmp22_;
	_tmp23_ = game;
	_tmp24_ = cover;
	games_game_set_cover (_tmp23_, (GamesCover*) _tmp24_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (_tmp4_);
	_g_object_unref0 (header);
	_g_object_unref0 (file);
	return result;
}

GamesWiiPlugin*
games_wii_plugin_construct (GType object_type)
{
	GamesWiiPlugin * self = NULL;
	self = (GamesWiiPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesWiiPlugin*
games_wii_plugin_new (void)
{
	return games_wii_plugin_construct (GAMES_TYPE_WII_PLUGIN);
}

static void
games_wii_plugin_class_init (GamesWiiPluginClass * klass,
                             gpointer klass_data)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GamesRetroPlatform* _tmp3_;
	games_wii_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_wii_plugin_finalize;
	_tmp0_ = g_strdup (GAMES_WII_PLUGIN_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = games_retro_platform_new (GAMES_WII_PLUGIN_PLATFORM_ID, GAMES_WII_PLUGIN_PLATFORM_NAME, _tmp2_, 1, GAMES_WII_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_wii_plugin_platform);
	games_wii_plugin_platform = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
}

static void
games_wii_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                              gpointer iface_data)
{
	games_wii_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_wii_plugin_real_get_platforms;
	iface->get_mime_types = (gchar** (*) (GamesPlugin*, gint*)) games_wii_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_wii_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_wii_plugin_real_get_runner_factories;
}

static void
games_wii_plugin_instance_init (GamesWiiPlugin * self,
                                gpointer klass)
{
}

static void
games_wii_plugin_finalize (GObject * obj)
{
	GamesWiiPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_WII_PLUGIN, GamesWiiPlugin);
	G_OBJECT_CLASS (games_wii_plugin_parent_class)->finalize (obj);
}

GType
games_wii_plugin_get_type (void)
{
	return games_wii_plugin_type_id;
}

GType
games_wii_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesWiiPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_wii_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesWiiPlugin), 0, (GInstanceInitFunc) games_wii_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_wii_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_wii_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesWiiPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_wii_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_wii_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_wii_header_register_type (module);
	games_wii_plugin_register_type (module);
	result = GAMES_TYPE_WII_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

