/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_head = R"doc(stop after processing the first N items

Useful for building test cases, this block consumes only N items from its input, and copies them to its output, if that is connected.


You can hence use this block in series with your sample flow if you want a block downstream of it to be tested with an exact number of input items; or you can put it in parallel to your data path, so that it stops at most one buffer size after the specified number of items has been produced upstream.

Constructor Specific Documentation:



Args:
    sizeof_stream_item : 
    nitems : )doc";


static const char* __doc_gr_blocks_head_head_0 = R"doc()doc";


static const char* __doc_gr_blocks_head_head_1 = R"doc()doc";


static const char* __doc_gr_blocks_head_make = R"doc(stop after processing the first N items

Useful for building test cases, this block consumes only N items from its input, and copies them to its output, if that is connected.


You can hence use this block in series with your sample flow if you want a block downstream of it to be tested with an exact number of input items; or you can put it in parallel to your data path, so that it stops at most one buffer size after the specified number of items has been produced upstream.

Constructor Specific Documentation:



Args:
    sizeof_stream_item : 
    nitems : )doc";


static const char* __doc_gr_blocks_head_reset = R"doc()doc";


static const char* __doc_gr_blocks_head_set_length = R"doc()doc";
