/* StorageView.c generated by valac 0.56.17, the Vala compiler
 * generated from StorageView.vala, do not modify */

/*
 * Copyright 2011–2019 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "granite.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_STORAGE_VIEW (storage_view_get_type ())
#define STORAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STORAGE_VIEW, StorageView))
#define STORAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STORAGE_VIEW, StorageViewClass))
#define IS_STORAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STORAGE_VIEW))
#define IS_STORAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STORAGE_VIEW))
#define STORAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STORAGE_VIEW, StorageViewClass))

typedef struct _StorageView StorageView;
typedef struct _StorageViewClass StorageViewClass;
typedef struct _StorageViewPrivate StorageViewPrivate;
enum  {
	STORAGE_VIEW_0_PROPERTY,
	STORAGE_VIEW_NUM_PROPERTIES
};
static GParamSpec* storage_view_properties[STORAGE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _StorageView {
	GtkGrid parent_instance;
	StorageViewPrivate * priv;
};

struct _StorageViewClass {
	GtkGridClass parent_class;
};

static gpointer storage_view_parent_class = NULL;

VALA_EXTERN GType storage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StorageView, g_object_unref)
VALA_EXTERN StorageView* storage_view_new (void);
VALA_EXTERN StorageView* storage_view_construct (GType object_type);
static GObject * storage_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static GType storage_view_get_type_once (void);

StorageView*
storage_view_construct (GType object_type)
{
	StorageView * self = NULL;
	self = (StorageView*) g_object_new (object_type, NULL);
	return self;
}

StorageView*
storage_view_new (void)
{
	return storage_view_construct (TYPE_STORAGE_VIEW);
}

static GObject *
storage_view_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	StorageView * self;
	GFile* file_root = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (storage_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STORAGE_VIEW, StorageView);
	_tmp0_ = g_file_new_for_path ("/");
	file_root = _tmp0_;
	{
		GFileInfo* info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		guint64 size = 0ULL;
		GFileInfo* _tmp3_;
		GraniteWidgetsStorageBar* storage = NULL;
		GraniteWidgetsStorageBar* _tmp4_;
		GraniteWidgetsStorageBar* _tmp5_;
		GraniteWidgetsStorageBar* _tmp6_;
		GraniteWidgetsStorageBar* _tmp7_;
		GraniteWidgetsStorageBar* _tmp8_;
		GraniteWidgetsStorageBar* _tmp9_;
		GraniteWidgetsStorageBar* _tmp10_;
		_tmp1_ = file_root;
		_tmp2_ = g_file_query_filesystem_info (_tmp1_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = info;
		size = g_file_info_get_attribute_uint64 (_tmp3_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
		_tmp4_ = granite_widgets_storage_bar_new_with_total_usage (size, size / 2);
		g_object_ref_sink (_tmp4_);
		storage = _tmp4_;
		_tmp5_ = storage;
		granite_widgets_storage_bar_update_block_size (_tmp5_, GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_AUDIO, size / 40);
		_tmp6_ = storage;
		granite_widgets_storage_bar_update_block_size (_tmp6_, GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_VIDEO, size / 30);
		_tmp7_ = storage;
		granite_widgets_storage_bar_update_block_size (_tmp7_, GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_APP, size / 20);
		_tmp8_ = storage;
		granite_widgets_storage_bar_update_block_size (_tmp8_, GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_PHOTO, size / 10);
		_tmp9_ = storage;
		granite_widgets_storage_bar_update_block_size (_tmp9_, GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES, size / 5);
		_tmp10_ = storage;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
		_g_object_unref0 (storage);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("StorageView.vala:24: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_object_unref0 (file_root);
	return obj;
}

static void
storage_view_class_init (StorageViewClass * klass,
                         gpointer klass_data)
{
	storage_view_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = storage_view_constructor;
}

static void
storage_view_instance_init (StorageView * self,
                            gpointer klass)
{
}

static GType
storage_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StorageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) storage_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StorageView), 0, (GInstanceInitFunc) storage_view_instance_init, NULL };
	GType storage_view_type_id;
	storage_view_type_id = g_type_register_static (gtk_grid_get_type (), "StorageView", &g_define_type_info, 0);
	return storage_view_type_id;
}

GType
storage_view_get_type (void)
{
	static volatile gsize storage_view_type_id__once = 0;
	if (g_once_init_enter (&storage_view_type_id__once)) {
		GType storage_view_type_id;
		storage_view_type_id = storage_view_get_type_once ();
		g_once_init_leave (&storage_view_type_id__once, storage_view_type_id);
	}
	return storage_view_type_id__once;
}

