/* StorageBar.c generated by valac 0.56.17, the Vala compiler
 * generated from StorageBar.vala, do not modify */

/*
 * Copyright 2011-2017 Corentin Noël <corentin@elementary.io>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND (granite_widgets_storage_bar_fill_round_get_type ())
#define GRANITE_WIDGETS_STORAGE_BAR_FILL_ROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND, GraniteWidgetsStorageBarFillRound))
#define GRANITE_WIDGETS_STORAGE_BAR_FILL_ROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND, GraniteWidgetsStorageBarFillRoundClass))
#define GRANITE_WIDGETS_STORAGE_BAR_IS_FILL_ROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND))
#define GRANITE_WIDGETS_STORAGE_BAR_IS_FILL_ROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND))
#define GRANITE_WIDGETS_STORAGE_BAR_FILL_ROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND, GraniteWidgetsStorageBarFillRoundClass))

typedef struct _GraniteWidgetsStorageBarFillRound GraniteWidgetsStorageBarFillRound;
typedef struct _GraniteWidgetsStorageBarFillRoundClass GraniteWidgetsStorageBarFillRoundClass;

#define GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK (granite_widgets_storage_bar_fill_block_get_type ())
#define GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlock))
#define GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlockClass))
#define GRANITE_WIDGETS_STORAGE_BAR_IS_FILL_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK))
#define GRANITE_WIDGETS_STORAGE_BAR_IS_FILL_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK))
#define GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlockClass))

typedef struct _GraniteWidgetsStorageBarFillBlock GraniteWidgetsStorageBarFillBlock;
typedef struct _GraniteWidgetsStorageBarFillBlockClass GraniteWidgetsStorageBarFillBlockClass;
enum  {
	GRANITE_WIDGETS_STORAGE_BAR_0_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_STORAGE_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_TOTAL_USAGE_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_INNER_MARGIN_SIDES_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
typedef struct _GraniteWidgetsStorageBarFillRoundPrivate GraniteWidgetsStorageBarFillRoundPrivate;
typedef struct _GraniteWidgetsStorageBarFillBlockPrivate GraniteWidgetsStorageBarFillBlockPrivate;
enum  {
	GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_0_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_SIZE_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_DESCRIPTION_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_LEGEND_ITEM_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_NUM_PROPERTIES];
enum  {
	GRANITE_WIDGETS_STORAGE_BAR_FILL_ROUND_0_PROPERTY,
	GRANITE_WIDGETS_STORAGE_BAR_FILL_ROUND_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_storage_bar_fill_round_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_ROUND_NUM_PROPERTIES];

struct _GraniteWidgetsStorageBarPrivate {
	guint64 _storage;
	guint64 _total_usage;
	GtkLabel* description_label;
	GHashTable* blocks;
	gint index;
	GtkBox* fillblock_box;
	GtkBox* legend_box;
	GraniteWidgetsStorageBarFillBlock* free_space;
	GraniteWidgetsStorageBarFillBlock* used_space;
};

struct _GraniteWidgetsStorageBarFillRound {
	GtkWidget parent_instance;
	GraniteWidgetsStorageBarFillRoundPrivate * priv;
};

struct _GraniteWidgetsStorageBarFillRoundClass {
	GtkWidgetClass parent_class;
};

struct _GraniteWidgetsStorageBarFillBlock {
	GraniteWidgetsStorageBarFillRound parent_instance;
	GraniteWidgetsStorageBarFillBlockPrivate * priv;
};

struct _GraniteWidgetsStorageBarFillBlockClass {
	GraniteWidgetsStorageBarFillRoundClass parent_class;
};

struct _GraniteWidgetsStorageBarFillBlockPrivate {
	guint64 _size;
	GraniteWidgetsStorageBarItemDescription _description;
	GtkGrid* _legend_item;
	GtkLabel* name_label;
	GtkLabel* size_label;
	GraniteWidgetsStorageBarFillRound* legend_fill;
};

static gint GraniteWidgetsStorageBar_private_offset;
static gpointer granite_widgets_storage_bar_parent_class = NULL;
static gint GraniteWidgetsStorageBarFillBlock_private_offset;
static gpointer granite_widgets_storage_bar_fill_block_parent_class = NULL;
static gpointer granite_widgets_storage_bar_fill_round_parent_class = NULL;

 G_GNUC_INTERNAL GType granite_widgets_storage_bar_fill_round_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType granite_widgets_storage_bar_fill_block_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void granite_widgets_storage_bar_update_size_description (GraniteWidgetsStorageBar* self);
static void granite_widgets_storage_bar_create_default_blocks (GraniteWidgetsStorageBar* self);
static gint __lambda82_ (GraniteWidgetsStorageBar* self,
                  GraniteWidgetsStorageBarItemDescription a,
                  GraniteWidgetsStorageBarItemDescription b);
static gint ___lambda82__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void __lambda83_ (GraniteWidgetsStorageBar* self,
                  GraniteWidgetsStorageBarItemDescription description);
 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillBlock* granite_widgets_storage_bar_fill_block_new (GraniteWidgetsStorageBarItemDescription description,
                                                                               guint64 size);
 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillBlock* granite_widgets_storage_bar_fill_block_construct (GType object_type,
                                                                                     GraniteWidgetsStorageBarItemDescription description,
                                                                                     guint64 size);
 G_GNUC_INTERNAL GtkGrid* granite_widgets_storage_bar_fill_block_get_legend_item (GraniteWidgetsStorageBarFillBlock* self);
static void ___lambda83__gfunc (gconstpointer data,
                         gpointer self);
 G_GNUC_INTERNAL guint64 granite_widgets_storage_bar_fill_block_get_size (GraniteWidgetsStorageBarFillBlock* self);
 G_GNUC_INTERNAL void granite_widgets_storage_bar_fill_block_set_size (GraniteWidgetsStorageBarFillBlock* self,
                                                      guint64 value);
 G_GNUC_INTERNAL GraniteWidgetsStorageBarItemDescription granite_widgets_storage_bar_fill_block_get_description (GraniteWidgetsStorageBarFillBlock* self);
 G_GNUC_INTERNAL void granite_widgets_storage_bar_fill_block_set_description (GraniteWidgetsStorageBarFillBlock* self,
                                                             GraniteWidgetsStorageBarItemDescription value);
static void granite_widgets_storage_bar_fill_block_set_legend_item (GraniteWidgetsStorageBarFillBlock* self,
                                                             GtkGrid* value);
static GObject * granite_widgets_storage_bar_fill_block_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillRound* granite_widgets_storage_bar_fill_round_new (void);
 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillRound* granite_widgets_storage_bar_fill_round_construct (GType object_type);
static void granite_widgets_storage_bar_fill_block_finalize (GObject * obj);
static GType granite_widgets_storage_bar_fill_block_get_type_once (void);
static void _vala_granite_widgets_storage_bar_fill_block_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_granite_widgets_storage_bar_fill_block_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static gboolean granite_widgets_storage_bar_fill_round_real_draw (GtkWidget* base,
                                                           cairo_t* cr);
static void granite_widgets_storage_bar_fill_round_real_get_preferred_width (GtkWidget* base,
                                                                      gint* minimum_width,
                                                                      gint* natural_width);
static void granite_widgets_storage_bar_fill_round_real_get_preferred_height (GtkWidget* base,
                                                                       gint* minimum_height,
                                                                       gint* natural_height);
static GObject * granite_widgets_storage_bar_fill_round_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static GType granite_widgets_storage_bar_fill_round_get_type_once (void);
static GObject * granite_widgets_storage_bar_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _granite_widgets_storage_bar___lambda84_ (GraniteWidgetsStorageBar* self,
                                               GtkAllocation* allocation);
static void __granite_widgets_storage_bar___lambda84__gtk_widget_size_allocate (GtkWidget* _sender,
                                                                         GtkAllocation* allocation,
                                                                         gpointer self);
 G_GNUC_INTERNAL void granite_init (void);
static void granite_widgets_storage_bar_finalize (GObject * obj);
static GType granite_widgets_storage_bar_get_type_once (void);
static void _vala_granite_widgets_storage_bar_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_granite_widgets_storage_bar_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
granite_widgets_storage_bar_get_instance_private (GraniteWidgetsStorageBar* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsStorageBar_private_offset);
}

gchar*
granite_widgets_storage_bar_item_description_get_class (GraniteWidgetsStorageBarItemDescription description)
{
	gchar* result;
	switch (description) {
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("files");
			result = _tmp0_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_AUDIO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("audio");
			result = _tmp1_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_VIDEO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("video");
			result = _tmp2_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_PHOTO:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("photo");
			result = _tmp3_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_APP:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("app");
			result = _tmp4_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

gchar*
granite_widgets_storage_bar_item_description_get_name (GraniteWidgetsStorageBarItemDescription description)
{
	gchar* result;
	switch (description) {
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_AUDIO:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Audio"));
			result = _tmp0_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_VIDEO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Videos"));
			result = _tmp1_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_PHOTO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Photos"));
			result = _tmp2_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_APP:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Apps"));
			result = _tmp3_;
			return result;
		}
		case GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Files"));
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Other"));
			result = _tmp5_;
			return result;
		}
	}
}

static GType
granite_widgets_storage_bar_item_description_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_OTHER, "GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_OTHER", "other"}, {GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_AUDIO, "GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_AUDIO", "audio"}, {GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_VIDEO, "GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_VIDEO", "video"}, {GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_PHOTO, "GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_PHOTO", "photo"}, {GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_APP, "GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_APP", "app"}, {GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES, "GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES", "files"}, {0, NULL, NULL}};
	GType granite_widgets_storage_bar_item_description_type_id;
	granite_widgets_storage_bar_item_description_type_id = g_enum_register_static ("GraniteWidgetsStorageBarItemDescription", values);
	return granite_widgets_storage_bar_item_description_type_id;
}

GType
granite_widgets_storage_bar_item_description_get_type (void)
{
	static volatile gsize granite_widgets_storage_bar_item_description_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_storage_bar_item_description_type_id__once)) {
		GType granite_widgets_storage_bar_item_description_type_id;
		granite_widgets_storage_bar_item_description_type_id = granite_widgets_storage_bar_item_description_get_type_once ();
		g_once_init_leave (&granite_widgets_storage_bar_item_description_type_id__once, granite_widgets_storage_bar_item_description_type_id);
	}
	return granite_widgets_storage_bar_item_description_type_id__once;
}

guint64
granite_widgets_storage_bar_get_storage (GraniteWidgetsStorageBar* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_storage;
	return result;
}

void
granite_widgets_storage_bar_set_storage (GraniteWidgetsStorageBar* self,
                                         guint64 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_storage = value;
	granite_widgets_storage_bar_update_size_description (self);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_STORAGE_PROPERTY]);
}

guint64
granite_widgets_storage_bar_get_total_usage (GraniteWidgetsStorageBar* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_total_usage;
	return result;
}

void
granite_widgets_storage_bar_set_total_usage (GraniteWidgetsStorageBar* self,
                                             guint64 value)
{
	guint64 _tmp0_;
	guint64 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_widgets_storage_bar_get_storage (self);
	_tmp1_ = _tmp0_;
	self->priv->_total_usage = MIN (value, _tmp1_);
	granite_widgets_storage_bar_update_size_description (self);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_TOTAL_USAGE_PROPERTY]);
}

gint
granite_widgets_storage_bar_get_inner_margin_sides (GraniteWidgetsStorageBar* self)
{
	gint result;
	GtkBox* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->fillblock_box;
	_tmp1_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_storage_bar_set_inner_margin_sides (GraniteWidgetsStorageBar* self,
                                                    gint value)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fillblock_box;
	_tmp1_ = self->priv->fillblock_box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, value);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_INNER_MARGIN_SIDES_PROPERTY]);
}

/**
     * Creates a new StorageBar widget with the given amount of space.
     *
     * @param storage the total amount of space.
     */
GraniteWidgetsStorageBar*
granite_widgets_storage_bar_construct (GType object_type,
                                       guint64 storage)
{
	GraniteWidgetsStorageBar * self = NULL;
	self = (GraniteWidgetsStorageBar*) g_object_new (object_type, "storage", storage, NULL);
	return self;
}

GraniteWidgetsStorageBar*
granite_widgets_storage_bar_new (guint64 storage)
{
	return granite_widgets_storage_bar_construct (GRANITE_WIDGETS_TYPE_STORAGE_BAR, storage);
}

/**
     * Creates a new StorageBar widget with the given amount of space.an a larger total usage block
     *
     * @param storage the total amount of space.
     * @param usage the amount of space used.
     */
GraniteWidgetsStorageBar*
granite_widgets_storage_bar_construct_with_total_usage (GType object_type,
                                                        guint64 storage,
                                                        guint64 total_usage)
{
	GraniteWidgetsStorageBar * self = NULL;
	self = (GraniteWidgetsStorageBar*) g_object_new (object_type, "storage", storage, "total-usage", total_usage, NULL);
	return self;
}

GraniteWidgetsStorageBar*
granite_widgets_storage_bar_new_with_total_usage (guint64 storage,
                                                  guint64 total_usage)
{
	return granite_widgets_storage_bar_construct_with_total_usage (GRANITE_WIDGETS_TYPE_STORAGE_BAR, storage, total_usage);
}

static gint
__lambda82_ (GraniteWidgetsStorageBar* self,
             GraniteWidgetsStorageBarItemDescription a,
             GraniteWidgetsStorageBarItemDescription b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	if (a == GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES) {
		result = 1;
		return result;
	}
	if (b == GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES) {
		result = -1;
		return result;
	}
	_tmp0_ = granite_widgets_storage_bar_item_description_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = granite_widgets_storage_bar_item_description_get_name (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gint
___lambda82__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda82_ ((GraniteWidgetsStorageBar*) self, (GraniteWidgetsStorageBarItemDescription) ((gintptr) a), (GraniteWidgetsStorageBarItemDescription) ((gintptr) b));
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda83_ (GraniteWidgetsStorageBar* self,
             GraniteWidgetsStorageBarItemDescription description)
{
	GraniteWidgetsStorageBarFillBlock* fill_block = NULL;
	GraniteWidgetsStorageBarFillBlock* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GHashTable* _tmp5_;
	GraniteWidgetsStorageBarFillBlock* _tmp6_;
	gint _tmp7_;
	_tmp0_ = granite_widgets_storage_bar_fill_block_new (description, (guint64) 0);
	g_object_ref_sink (_tmp0_);
	fill_block = _tmp0_;
	_tmp1_ = self->priv->fillblock_box;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) fill_block);
	_tmp2_ = self->priv->legend_box;
	_tmp3_ = granite_widgets_storage_bar_fill_block_get_legend_item (fill_block);
	_tmp4_ = _tmp3_;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->blocks;
	_tmp6_ = _g_object_ref0 (fill_block);
	g_hash_table_insert (_tmp5_, (gpointer) ((gintptr) self->priv->index), _tmp6_);
	_tmp7_ = self->priv->index;
	self->priv->index = _tmp7_ + 1;
	_g_object_unref0 (fill_block);
}

static void
___lambda83__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda83_ ((GraniteWidgetsStorageBar*) self, (GraniteWidgetsStorageBarItemDescription) ((gintptr) data));
}

static void
granite_widgets_storage_bar_create_default_blocks (GraniteWidgetsStorageBar* self)
{
	GSequence* seq = NULL;
	GSequence* _tmp0_;
	GSequenceIter* _tmp1_;
	GSequenceIter* _tmp2_;
	GSequenceIter* _tmp3_;
	GSequenceIter* _tmp4_;
	GSequenceIter* _tmp5_;
	guint64 _tmp6_;
	guint64 _tmp7_;
	GraniteWidgetsStorageBarFillBlock* _tmp8_;
	guint64 _tmp9_;
	guint64 _tmp10_;
	GraniteWidgetsStorageBarFillBlock* _tmp11_;
	GraniteWidgetsStorageBarFillBlock* _tmp12_;
	GtkStyleContext* _tmp13_;
	GraniteWidgetsStorageBarFillBlock* _tmp14_;
	GtkStyleContext* _tmp15_;
	GraniteWidgetsStorageBarFillBlock* _tmp16_;
	GtkStyleContext* _tmp17_;
	GHashTable* _tmp18_;
	gint _tmp19_;
	GraniteWidgetsStorageBarFillBlock* _tmp20_;
	GraniteWidgetsStorageBarFillBlock* _tmp21_;
	GHashTable* _tmp22_;
	gint _tmp23_;
	GraniteWidgetsStorageBarFillBlock* _tmp24_;
	GraniteWidgetsStorageBarFillBlock* _tmp25_;
	GtkBox* _tmp26_;
	GraniteWidgetsStorageBarFillBlock* _tmp27_;
	GtkBox* _tmp28_;
	GraniteWidgetsStorageBarFillBlock* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_sequence_new (NULL);
	seq = _tmp0_;
	_tmp1_ = g_sequence_append (seq, (gpointer) ((gintptr) GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES));
	_tmp2_ = g_sequence_append (seq, (gpointer) ((gintptr) GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_AUDIO));
	_tmp3_ = g_sequence_append (seq, (gpointer) ((gintptr) GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_VIDEO));
	_tmp4_ = g_sequence_append (seq, (gpointer) ((gintptr) GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_PHOTO));
	_tmp5_ = g_sequence_append (seq, (gpointer) ((gintptr) GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_APP));
	g_sequence_sort (seq, ___lambda82__gcompare_data_func, self);
	g_sequence_foreach (seq, ___lambda83__gfunc, self);
	_tmp6_ = granite_widgets_storage_bar_get_storage (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = granite_widgets_storage_bar_fill_block_new (GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES, _tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->free_space);
	self->priv->free_space = _tmp8_;
	_tmp9_ = granite_widgets_storage_bar_get_total_usage (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = granite_widgets_storage_bar_fill_block_new (GRANITE_WIDGETS_STORAGE_BAR_ITEM_DESCRIPTION_FILES, _tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->used_space);
	self->priv->used_space = _tmp11_;
	_tmp12_ = self->priv->free_space;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "empty-block");
	_tmp14_ = self->priv->free_space;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_remove_class (_tmp15_, "files");
	_tmp16_ = self->priv->used_space;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_remove_class (_tmp17_, "files");
	_tmp18_ = self->priv->blocks;
	_tmp19_ = self->priv->index;
	self->priv->index = _tmp19_ + 1;
	_tmp20_ = self->priv->used_space;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	g_hash_table_insert (_tmp18_, (gpointer) ((gintptr) _tmp19_), _tmp21_);
	_tmp22_ = self->priv->blocks;
	_tmp23_ = self->priv->index;
	self->priv->index = _tmp23_ + 1;
	_tmp24_ = self->priv->free_space;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	g_hash_table_insert (_tmp22_, (gpointer) ((gintptr) _tmp23_), _tmp25_);
	_tmp26_ = self->priv->fillblock_box;
	_tmp27_ = self->priv->used_space;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->fillblock_box;
	_tmp29_ = self->priv->free_space;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	granite_widgets_storage_bar_update_size_description (self);
	_g_sequence_free0 (seq);
}

static void
granite_widgets_storage_bar_update_size_description (GraniteWidgetsStorageBar* self)
{
	guint64 user_size = 0ULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	guint64 free = 0ULL;
	guint64 _tmp14_;
	guint64 _tmp15_;
	GraniteWidgetsStorageBarFillBlock* _tmp26_;
	GtkLabel* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	guint64 _tmp30_;
	guint64 _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	g_return_if_fail (self != NULL);
	user_size = (guint64) 0;
	_tmp0_ = self->priv->blocks;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp1_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			GraniteWidgetsStorageBarFillBlock* block = NULL;
			block = (GraniteWidgetsStorageBarFillBlock*) block_it->data;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				GraniteWidgetsStorageBarFillBlock* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				GraniteWidgetsStorageBarFillBlock* _tmp11_;
				guint64 _tmp12_;
				guint64 _tmp13_;
				_tmp4_ = block;
				_tmp5_ = gtk_widget_get_visible ((GtkWidget*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ == FALSE) {
					_tmp3_ = TRUE;
				} else {
					GraniteWidgetsStorageBarFillBlock* _tmp7_;
					GraniteWidgetsStorageBarFillBlock* _tmp8_;
					_tmp7_ = block;
					_tmp8_ = self->priv->free_space;
					_tmp3_ = _tmp7_ == _tmp8_;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					GraniteWidgetsStorageBarFillBlock* _tmp9_;
					GraniteWidgetsStorageBarFillBlock* _tmp10_;
					_tmp9_ = block;
					_tmp10_ = self->priv->used_space;
					_tmp2_ = _tmp9_ == _tmp10_;
				}
				if (_tmp2_) {
					continue;
				}
				_tmp11_ = block;
				_tmp12_ = granite_widgets_storage_bar_fill_block_get_size (_tmp11_);
				_tmp13_ = _tmp12_;
				user_size += _tmp13_;
			}
		}
		(block_collection == NULL) ? NULL : (block_collection = (g_list_free (block_collection), NULL));
	}
	_tmp14_ = granite_widgets_storage_bar_get_total_usage (self);
	_tmp15_ = _tmp14_;
	if (user_size > _tmp15_) {
		guint64 _tmp16_;
		guint64 _tmp17_;
		GraniteWidgetsStorageBarFillBlock* _tmp18_;
		_tmp16_ = granite_widgets_storage_bar_get_storage (self);
		_tmp17_ = _tmp16_;
		free = _tmp17_ - user_size;
		_tmp18_ = self->priv->used_space;
		granite_widgets_storage_bar_fill_block_set_size (_tmp18_, (guint64) 0);
	} else {
		guint64 _tmp19_;
		guint64 _tmp20_;
		guint64 _tmp21_;
		guint64 _tmp22_;
		GraniteWidgetsStorageBarFillBlock* _tmp23_;
		guint64 _tmp24_;
		guint64 _tmp25_;
		_tmp19_ = granite_widgets_storage_bar_get_storage (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = granite_widgets_storage_bar_get_total_usage (self);
		_tmp22_ = _tmp21_;
		free = _tmp20_ - _tmp22_;
		_tmp23_ = self->priv->used_space;
		_tmp24_ = granite_widgets_storage_bar_get_total_usage (self);
		_tmp25_ = _tmp24_;
		granite_widgets_storage_bar_fill_block_set_size (_tmp23_, _tmp25_ - user_size);
	}
	_tmp26_ = self->priv->free_space;
	granite_widgets_storage_bar_fill_block_set_size (_tmp26_, free);
	_tmp27_ = self->priv->description_label;
	_tmp28_ = g_format_size_full (free, G_FORMAT_SIZE_DEFAULT);
	_tmp29_ = _tmp28_;
	_tmp30_ = granite_widgets_storage_bar_get_storage (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_format_size_full (_tmp31_, G_FORMAT_SIZE_DEFAULT);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strdup_printf (_ ("%s free out of %s"), _tmp29_, _tmp33_);
	_tmp35_ = _tmp34_;
	gtk_label_set_label (_tmp27_, _tmp35_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp29_);
}

/**
     * Update the specified block with a given amount of space.
     *
     * @param description the category to update.
     * @param size the size of the category or 0 to hide.
     */
void
granite_widgets_storage_bar_update_block_size (GraniteWidgetsStorageBar* self,
                                               GraniteWidgetsStorageBarItemDescription description,
                                               guint64 size)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blocks;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp1_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			GraniteWidgetsStorageBarFillBlock* block = NULL;
			block = (GraniteWidgetsStorageBarFillBlock*) block_it->data;
			{
				GraniteWidgetsStorageBarFillBlock* _tmp2_;
				GraniteWidgetsStorageBarItemDescription _tmp3_;
				GraniteWidgetsStorageBarItemDescription _tmp4_;
				_tmp2_ = block;
				_tmp3_ = granite_widgets_storage_bar_fill_block_get_description (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == description) {
					GraniteWidgetsStorageBarFillBlock* _tmp5_;
					_tmp5_ = block;
					granite_widgets_storage_bar_fill_block_set_size (_tmp5_, size);
					granite_widgets_storage_bar_update_size_description (self);
					(block_collection == NULL) ? NULL : (block_collection = (g_list_free (block_collection), NULL));
					return;
				}
			}
		}
		(block_collection == NULL) ? NULL : (block_collection = (g_list_free (block_collection), NULL));
	}
}

static inline gpointer
granite_widgets_storage_bar_fill_block_get_instance_private (GraniteWidgetsStorageBarFillBlock* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsStorageBarFillBlock_private_offset);
}

 G_GNUC_INTERNAL guint64
granite_widgets_storage_bar_fill_block_get_size (GraniteWidgetsStorageBarFillBlock* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_size;
	return result;
}

 G_GNUC_INTERNAL void
granite_widgets_storage_bar_fill_block_set_size (GraniteWidgetsStorageBarFillBlock* self,
                                                 guint64 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_size = value;
	if (self->priv->_size == ((guint64) 0)) {
		GtkGrid* _tmp0_;
		GtkGrid* _tmp1_;
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		gtk_widget_set_visible ((GtkWidget*) self, FALSE);
		_tmp0_ = self->priv->_legend_item;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp0_, TRUE);
		_tmp1_ = self->priv->_legend_item;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	} else {
		GtkGrid* _tmp2_;
		GtkGrid* _tmp3_;
		GtkLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gtk_widget_set_no_show_all ((GtkWidget*) self, FALSE);
		gtk_widget_set_visible ((GtkWidget*) self, TRUE);
		_tmp2_ = self->priv->_legend_item;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->_legend_item;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = self->priv->size_label;
		_tmp5_ = g_format_size_full (self->priv->_size, G_FORMAT_SIZE_DEFAULT);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_SIZE_PROPERTY]);
}

 G_GNUC_INTERNAL GraniteWidgetsStorageBarItemDescription
granite_widgets_storage_bar_fill_block_get_description (GraniteWidgetsStorageBarFillBlock* self)
{
	GraniteWidgetsStorageBarItemDescription result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_description;
	return result;
}

 G_GNUC_INTERNAL void
granite_widgets_storage_bar_fill_block_set_description (GraniteWidgetsStorageBarFillBlock* self,
                                                        GraniteWidgetsStorageBarItemDescription value)
{
	GraniteWidgetsStorageBarItemDescription old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_storage_bar_fill_block_get_description (self);
	if (old_value != value) {
		self->priv->_description = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_DESCRIPTION_PROPERTY]);
	}
}

 G_GNUC_INTERNAL GtkGrid*
granite_widgets_storage_bar_fill_block_get_legend_item (GraniteWidgetsStorageBarFillBlock* self)
{
	GtkGrid* result;
	GtkGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_legend_item;
	result = _tmp0_;
	return result;
}

static void
granite_widgets_storage_bar_fill_block_set_legend_item (GraniteWidgetsStorageBarFillBlock* self,
                                                        GtkGrid* value)
{
	GtkGrid* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_storage_bar_fill_block_get_legend_item (self);
	if (old_value != value) {
		GtkGrid* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_legend_item);
		self->priv->_legend_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_LEGEND_ITEM_PROPERTY]);
	}
}

 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillBlock*
granite_widgets_storage_bar_fill_block_construct (GType object_type,
                                                  GraniteWidgetsStorageBarItemDescription description,
                                                  guint64 size)
{
	GraniteWidgetsStorageBarFillBlock * self = NULL;
	gchar* clas = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkLabel* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	self = (GraniteWidgetsStorageBarFillBlock*) g_object_new (object_type, "size", size, "description", description, NULL);
	_tmp0_ = granite_widgets_storage_bar_item_description_get_class (description);
	clas = _tmp0_;
	_tmp1_ = clas;
	if (_tmp1_ != NULL) {
		GtkStyleContext* _tmp2_;
		const gchar* _tmp3_;
		GraniteWidgetsStorageBarFillRound* _tmp4_;
		GtkStyleContext* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp3_ = clas;
		gtk_style_context_add_class (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->legend_fill;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		_tmp6_ = clas;
		gtk_style_context_add_class (_tmp5_, _tmp6_);
	}
	_tmp7_ = self->priv->name_label;
	_tmp8_ = granite_widgets_storage_bar_item_description_get_name (description);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_markup_escape_text (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("<b>%s</b>", _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp7_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (clas);
	return self;
}

 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillBlock*
granite_widgets_storage_bar_fill_block_new (GraniteWidgetsStorageBarItemDescription description,
                                            guint64 size)
{
	return granite_widgets_storage_bar_fill_block_construct (GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, description, size);
}

static GObject *
granite_widgets_storage_bar_fill_block_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsStorageBarFillBlock * self;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GraniteWidgetsStorageBarFillRound* _tmp8_;
	GraniteWidgetsStorageBarFillRound* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkBox* legend_box = NULL;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GraniteWidgetsStorageBarFillRound* _tmp13_;
	GtkGrid* _tmp14_;
	GtkBox* _tmp15_;
	GtkGrid* _tmp16_;
	GtkLabel* _tmp17_;
	GtkGrid* _tmp18_;
	GtkLabel* _tmp19_;
	parent_class = G_OBJECT_CLASS (granite_widgets_storage_bar_fill_block_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlock);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	granite_widgets_storage_bar_fill_block_set_legend_item (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_legend_item;
	gtk_grid_set_column_spacing (_tmp2_, 6);
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp3_;
	_tmp4_ = self->priv->name_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = self->priv->name_label;
	gtk_label_set_use_markup (_tmp5_, TRUE);
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->size_label);
	self->priv->size_label = _tmp6_;
	_tmp7_ = self->priv->size_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = granite_widgets_storage_bar_fill_round_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->legend_fill);
	self->priv->legend_fill = _tmp8_;
	_tmp9_ = self->priv->legend_fill;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, "legend");
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp11_);
	legend_box = _tmp11_;
	_tmp12_ = legend_box;
	_tmp13_ = self->priv->legend_fill;
	gtk_box_set_center_widget (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->_legend_item;
	_tmp15_ = legend_box;
	gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 0, 0, 1, 2);
	_tmp16_ = self->priv->_legend_item;
	_tmp17_ = self->priv->name_label;
	gtk_grid_attach (_tmp16_, (GtkWidget*) _tmp17_, 1, 0, 1, 1);
	_tmp18_ = self->priv->_legend_item;
	_tmp19_ = self->priv->size_label;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 1, 1, 1, 1);
	_g_object_unref0 (legend_box);
	return obj;
}

static void
granite_widgets_storage_bar_fill_block_class_init (GraniteWidgetsStorageBarFillBlockClass * klass,
                                                   gpointer klass_data)
{
	granite_widgets_storage_bar_fill_block_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsStorageBarFillBlock_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_storage_bar_fill_block_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_storage_bar_fill_block_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_storage_bar_fill_block_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_storage_bar_fill_block_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_SIZE_PROPERTY, granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_SIZE_PROPERTY] = g_param_spec_uint64 ("size", "size", "size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_DESCRIPTION_PROPERTY, granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_DESCRIPTION_PROPERTY] = g_param_spec_enum ("description", "description", "description", GRANITE_WIDGETS_STORAGE_BAR_TYPE_ITEM_DESCRIPTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_LEGEND_ITEM_PROPERTY, granite_widgets_storage_bar_fill_block_properties[GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_LEGEND_ITEM_PROPERTY] = g_param_spec_object ("legend-item", "legend-item", "legend-item", gtk_grid_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
granite_widgets_storage_bar_fill_block_instance_init (GraniteWidgetsStorageBarFillBlock * self,
                                                      gpointer klass)
{
	self->priv = granite_widgets_storage_bar_fill_block_get_instance_private (self);
	self->priv->_size = (guint64) 0;
}

static void
granite_widgets_storage_bar_fill_block_finalize (GObject * obj)
{
	GraniteWidgetsStorageBarFillBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlock);
	_g_object_unref0 (self->priv->_legend_item);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->size_label);
	_g_object_unref0 (self->priv->legend_fill);
	G_OBJECT_CLASS (granite_widgets_storage_bar_fill_block_parent_class)->finalize (obj);
}

static GType
granite_widgets_storage_bar_fill_block_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsStorageBarFillBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_storage_bar_fill_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsStorageBarFillBlock), 0, (GInstanceInitFunc) granite_widgets_storage_bar_fill_block_instance_init, NULL };
	GType granite_widgets_storage_bar_fill_block_type_id;
	granite_widgets_storage_bar_fill_block_type_id = g_type_register_static (GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND, "GraniteWidgetsStorageBarFillBlock", &g_define_type_info, 0);
	GraniteWidgetsStorageBarFillBlock_private_offset = g_type_add_instance_private (granite_widgets_storage_bar_fill_block_type_id, sizeof (GraniteWidgetsStorageBarFillBlockPrivate));
	return granite_widgets_storage_bar_fill_block_type_id;
}

 G_GNUC_INTERNAL GType
granite_widgets_storage_bar_fill_block_get_type (void)
{
	static volatile gsize granite_widgets_storage_bar_fill_block_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_storage_bar_fill_block_type_id__once)) {
		GType granite_widgets_storage_bar_fill_block_type_id;
		granite_widgets_storage_bar_fill_block_type_id = granite_widgets_storage_bar_fill_block_get_type_once ();
		g_once_init_leave (&granite_widgets_storage_bar_fill_block_type_id__once, granite_widgets_storage_bar_fill_block_type_id);
	}
	return granite_widgets_storage_bar_fill_block_type_id__once;
}

static void
_vala_granite_widgets_storage_bar_fill_block_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsStorageBarFillBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlock);
	switch (property_id) {
		case GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_SIZE_PROPERTY:
		g_value_set_uint64 (value, granite_widgets_storage_bar_fill_block_get_size (self));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_DESCRIPTION_PROPERTY:
		g_value_set_enum (value, granite_widgets_storage_bar_fill_block_get_description (self));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_LEGEND_ITEM_PROPERTY:
		g_value_set_object (value, granite_widgets_storage_bar_fill_block_get_legend_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_storage_bar_fill_block_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsStorageBarFillBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_BLOCK, GraniteWidgetsStorageBarFillBlock);
	switch (property_id) {
		case GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_SIZE_PROPERTY:
		granite_widgets_storage_bar_fill_block_set_size (self, g_value_get_uint64 (value));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_DESCRIPTION_PROPERTY:
		granite_widgets_storage_bar_fill_block_set_description (self, g_value_get_enum (value));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_FILL_BLOCK_LEGEND_ITEM_PROPERTY:
		granite_widgets_storage_bar_fill_block_set_legend_item (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillRound*
granite_widgets_storage_bar_fill_round_construct (GType object_type)
{
	GraniteWidgetsStorageBarFillRound * self = NULL;
	self = (GraniteWidgetsStorageBarFillRound*) gtk_widget_new (object_type, NULL);
	return self;
}

 G_GNUC_INTERNAL GraniteWidgetsStorageBarFillRound*
granite_widgets_storage_bar_fill_round_new (void)
{
	return granite_widgets_storage_bar_fill_round_construct (GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND);
}

static gboolean
granite_widgets_storage_bar_fill_round_real_draw (GtkWidget* base,
                                                  cairo_t* cr)
{
	GraniteWidgetsStorageBarFillRound * self;
	gint width = 0;
	gint height = 0;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean result;
	self = (GraniteWidgetsStorageBarFillRound*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	gtk_render_background (context, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	gtk_render_frame (context, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	result = TRUE;
	_g_object_unref0 (context);
	return result;
}

static void
granite_widgets_storage_bar_fill_round_real_get_preferred_width (GtkWidget* base,
                                                                 gint* minimum_width,
                                                                 gint* natural_width)
{
	GraniteWidgetsStorageBarFillRound * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBorder padding = {0};
	GtkBorder _tmp4_ = {0};
	GtkBorder _tmp5_;
	GtkBorder _tmp6_;
	self = (GraniteWidgetsStorageBarFillRound*) base;
	GTK_WIDGET_CLASS (granite_widgets_storage_bar_fill_round_parent_class)->get_preferred_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	context = _tmp3_;
	gtk_style_context_get_padding (context, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp4_);
	padding = _tmp4_;
	_tmp5_ = padding;
	_tmp6_ = padding;
	_vala_minimum_width = MAX ((gint) (_tmp5_.left + _tmp6_.right), _vala_minimum_width);
	_vala_minimum_width = MAX (1, _vala_minimum_width);
	_vala_natural_width = MAX (_vala_minimum_width, _vala_natural_width);
	_g_object_unref0 (context);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static void
granite_widgets_storage_bar_fill_round_real_get_preferred_height (GtkWidget* base,
                                                                  gint* minimum_height,
                                                                  gint* natural_height)
{
	GraniteWidgetsStorageBarFillRound * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBorder padding = {0};
	GtkBorder _tmp4_ = {0};
	GtkBorder _tmp5_;
	GtkBorder _tmp6_;
	self = (GraniteWidgetsStorageBarFillRound*) base;
	GTK_WIDGET_CLASS (granite_widgets_storage_bar_fill_round_parent_class)->get_preferred_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_, &_tmp1_);
	_vala_minimum_height = _tmp0_;
	_vala_natural_height = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	context = _tmp3_;
	gtk_style_context_get_padding (context, gtk_widget_get_state_flags ((GtkWidget*) self), &_tmp4_);
	padding = _tmp4_;
	_tmp5_ = padding;
	_tmp6_ = padding;
	_vala_minimum_height = MAX ((gint) (_tmp5_.top + _tmp6_.bottom), _vala_minimum_height);
	_vala_minimum_height = MAX (1, _vala_minimum_height);
	_vala_natural_height = MAX (_vala_minimum_height, _vala_natural_height);
	_g_object_unref0 (context);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static GObject *
granite_widgets_storage_bar_fill_round_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsStorageBarFillRound * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	parent_class = G_OBJECT_CLASS (granite_widgets_storage_bar_fill_round_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_STORAGE_BAR_TYPE_FILL_ROUND, GraniteWidgetsStorageBarFillRound);
	gtk_widget_set_has_window ((GtkWidget*) self, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	_tmp2_ = style_context;
	gtk_style_context_add_class (_tmp2_, "fill-block");
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	_g_object_unref0 (style_context);
	return obj;
}

static void
granite_widgets_storage_bar_fill_round_class_init (GraniteWidgetsStorageBarFillRoundClass * klass,
                                                   gpointer klass_data)
{
	granite_widgets_storage_bar_fill_round_parent_class = g_type_class_peek_parent (klass);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) granite_widgets_storage_bar_fill_round_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) granite_widgets_storage_bar_fill_round_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) granite_widgets_storage_bar_fill_round_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_storage_bar_fill_round_constructor;
}

static void
granite_widgets_storage_bar_fill_round_instance_init (GraniteWidgetsStorageBarFillRound * self,
                                                      gpointer klass)
{
}

static GType
granite_widgets_storage_bar_fill_round_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsStorageBarFillRoundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_storage_bar_fill_round_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsStorageBarFillRound), 0, (GInstanceInitFunc) granite_widgets_storage_bar_fill_round_instance_init, NULL };
	GType granite_widgets_storage_bar_fill_round_type_id;
	granite_widgets_storage_bar_fill_round_type_id = g_type_register_static (gtk_widget_get_type (), "GraniteWidgetsStorageBarFillRound", &g_define_type_info, 0);
	return granite_widgets_storage_bar_fill_round_type_id;
}

 G_GNUC_INTERNAL GType
granite_widgets_storage_bar_fill_round_get_type (void)
{
	static volatile gsize granite_widgets_storage_bar_fill_round_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_storage_bar_fill_round_type_id__once)) {
		GType granite_widgets_storage_bar_fill_round_type_id;
		granite_widgets_storage_bar_fill_round_type_id = granite_widgets_storage_bar_fill_round_get_type_once ();
		g_once_init_leave (&granite_widgets_storage_bar_fill_round_type_id__once, granite_widgets_storage_bar_fill_round_type_id);
	}
	return granite_widgets_storage_bar_fill_round_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_granite_widgets_storage_bar___lambda84_ (GraniteWidgetsStorageBar* self,
                                          GtkAllocation* allocation)
{
	gdouble lost_size = 0.0;
	gint current_x = 0;
	GtkAllocation _tmp0_;
	g_return_if_fail (allocation != NULL);
	lost_size = (gdouble) 0;
	_tmp0_ = *allocation;
	current_x = _tmp0_.x;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GHashTable* _tmp3_;
				guint _tmp4_;
				guint _tmp5_;
				GraniteWidgetsStorageBarFillBlock* block = NULL;
				GHashTable* _tmp6_;
				gconstpointer _tmp7_;
				gboolean _tmp8_ = FALSE;
				GraniteWidgetsStorageBarFillBlock* _tmp9_;
				GtkAllocation new_allocation = {0};
				GtkAllocation _tmp13_;
				gdouble width = 0.0;
				GtkAllocation _tmp14_;
				GraniteWidgetsStorageBarFillBlock* _tmp15_;
				guint64 _tmp16_;
				guint64 _tmp17_;
				guint64 _tmp18_;
				guint64 _tmp19_;
				GtkAllocation _tmp20_;
				GraniteWidgetsStorageBarFillBlock* _tmp21_;
				GtkAllocation _tmp22_;
				GraniteWidgetsStorageBarFillBlock* _tmp23_;
				GtkAllocation _tmp24_;
				GtkAllocation _tmp25_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->blocks;
				_tmp4_ = g_hash_table_size (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(((guint) i) < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->blocks;
				_tmp7_ = g_hash_table_lookup (_tmp6_, (gpointer) ((gintptr) i));
				block = (GraniteWidgetsStorageBarFillBlock*) _tmp7_;
				_tmp9_ = block;
				if (_tmp9_ == NULL) {
					_tmp8_ = TRUE;
				} else {
					GraniteWidgetsStorageBarFillBlock* _tmp10_;
					gboolean _tmp11_;
					gboolean _tmp12_;
					_tmp10_ = block;
					_tmp11_ = gtk_widget_get_visible ((GtkWidget*) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp8_ = _tmp12_ == FALSE;
				}
				if (_tmp8_) {
					continue;
				}
				memset (&new_allocation, 0, sizeof (GtkAllocation));
				new_allocation.x = current_x;
				_tmp13_ = *allocation;
				new_allocation.y = _tmp13_.y;
				_tmp14_ = *allocation;
				_tmp15_ = block;
				_tmp16_ = granite_widgets_storage_bar_fill_block_get_size (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = granite_widgets_storage_bar_get_storage (self);
				_tmp19_ = _tmp18_;
				width = ((((gdouble) _tmp14_.width) * ((gdouble) _tmp17_)) / ((gdouble) _tmp19_)) + lost_size;
				lost_size -= trunc (lost_size);
				new_allocation.width = (gint) trunc (width);
				_tmp20_ = *allocation;
				new_allocation.height = _tmp20_.height;
				_tmp21_ = block;
				_tmp22_ = new_allocation;
				_tmp23_ = block;
				gtk_widget_size_allocate_with_baseline ((GtkWidget*) _tmp21_, &_tmp22_, gtk_widget_get_allocated_baseline ((GtkWidget*) _tmp23_));
				_tmp24_ = new_allocation;
				lost_size = width - _tmp24_.width;
				_tmp25_ = new_allocation;
				current_x += _tmp25_.width;
			}
		}
	}
}

static void
__granite_widgets_storage_bar___lambda84__gtk_widget_size_allocate (GtkWidget* _sender,
                                                                    GtkAllocation* allocation,
                                                                    gpointer self)
{
	_granite_widgets_storage_bar___lambda84_ ((GraniteWidgetsStorageBar*) self, allocation);
}

static GObject *
granite_widgets_storage_bar_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsStorageBar * self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GHashTable* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* legend_center_box = NULL;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkScrolledWindow* legend_scrolled = NULL;
	GtkScrolledWindow* _tmp14_;
	GtkScrolledWindow* _tmp15_;
	GtkScrolledWindow* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkBox* _tmp18_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkGrid* _tmp22_;
	GtkBox* _tmp23_;
	GtkGrid* _tmp24_;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_;
	GtkBox* _tmp27_;
	parent_class = G_OBJECT_CLASS (granite_widgets_storage_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_STORAGE_BAR, GraniteWidgetsStorageBar);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->description_label);
	self->priv->description_label = _tmp0_;
	_tmp1_ = self->priv->description_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->description_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp2_, 6);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_STORAGEBAR);
	_tmp4_ = g_hash_table_new_full (NULL, NULL, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->blocks);
	self->priv->blocks = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->fillblock_box);
	self->priv->fillblock_box = _tmp5_;
	_tmp6_ = self->priv->fillblock_box;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, GTK_STYLE_CLASS_TROUGH);
	_tmp8_ = self->priv->fillblock_box;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	granite_widgets_storage_bar_set_inner_margin_sides (self, 12);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->legend_box);
	self->priv->legend_box = _tmp9_;
	_tmp10_ = self->priv->legend_box;
	g_object_set ((GtkWidget*) _tmp10_, "expand", TRUE, NULL);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp11_);
	legend_center_box = _tmp11_;
	_tmp12_ = legend_center_box;
	_tmp13_ = self->priv->legend_box;
	gtk_box_set_center_widget (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp14_);
	legend_scrolled = _tmp14_;
	_tmp15_ = legend_scrolled;
	g_object_set (_tmp15_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp16_ = legend_scrolled;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = legend_scrolled;
	_tmp18_ = legend_center_box;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp19_);
	grid = _tmp19_;
	_tmp20_ = grid;
	_tmp21_ = legend_scrolled;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 0, 1, 1);
	_tmp22_ = grid;
	_tmp23_ = self->priv->fillblock_box;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 1, 1, 1);
	_tmp24_ = grid;
	_tmp25_ = self->priv->description_label;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 2, 1, 1);
	_tmp26_ = grid;
	gtk_box_set_center_widget ((GtkBox*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->fillblock_box;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "size-allocate", (GCallback) __granite_widgets_storage_bar___lambda84__gtk_widget_size_allocate, self, 0);
	granite_widgets_storage_bar_create_default_blocks (self);
	_g_object_unref0 (grid);
	_g_object_unref0 (legend_scrolled);
	_g_object_unref0 (legend_center_box);
	return obj;
}

static void
granite_widgets_storage_bar_class_init (GraniteWidgetsStorageBarClass * klass,
                                        gpointer klass_data)
{
	granite_widgets_storage_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsStorageBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_storage_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_storage_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_storage_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_storage_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_STORAGE_BAR_STORAGE_PROPERTY, granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_STORAGE_PROPERTY] = g_param_spec_uint64 ("storage", "storage", "storage", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_STORAGE_BAR_TOTAL_USAGE_PROPERTY, granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_TOTAL_USAGE_PROPERTY] = g_param_spec_uint64 ("total-usage", "total-usage", "total-usage", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_STORAGE_BAR_INNER_MARGIN_SIDES_PROPERTY, granite_widgets_storage_bar_properties[GRANITE_WIDGETS_STORAGE_BAR_INNER_MARGIN_SIDES_PROPERTY] = g_param_spec_int ("inner-margin-sides", "inner-margin-sides", "inner-margin-sides", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	granite_init ();
}

static void
granite_widgets_storage_bar_instance_init (GraniteWidgetsStorageBar * self,
                                           gpointer klass)
{
	self->priv = granite_widgets_storage_bar_get_instance_private (self);
	self->priv->_storage = (guint64) 0;
	self->priv->_total_usage = (guint64) 0;
	self->priv->index = 0;
}

static void
granite_widgets_storage_bar_finalize (GObject * obj)
{
	GraniteWidgetsStorageBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_STORAGE_BAR, GraniteWidgetsStorageBar);
	_g_object_unref0 (self->priv->description_label);
	_g_hash_table_unref0 (self->priv->blocks);
	_g_object_unref0 (self->priv->fillblock_box);
	_g_object_unref0 (self->priv->legend_box);
	_g_object_unref0 (self->priv->free_space);
	_g_object_unref0 (self->priv->used_space);
	G_OBJECT_CLASS (granite_widgets_storage_bar_parent_class)->finalize (obj);
}

/**
 * An horizontal bar showing the remaining amount of space.
 *
 * {{../doc/images/StorageBar.png}}
 *
 * ''Example''<<BR>>
 * {{{
 * public class StorageView : Gtk.Grid {
 *     construct {
 *         var file_root = GLib.File.new_for_path ("/");
 *
 *         try {
 *             var info = file_root.query_filesystem_info (GLib.FileAttribute.FILESYSTEM_SIZE, null);
 *
 *             var size = info.get_attribute_uint64 (GLib.FileAttribute.FILESYSTEM_SIZE);
 *
 *             var storage = new Granite.Widgets.StorageBar.with_total_usage (size, size/2);
 *             storage.update_block_size (Granite.Widgets.StorageBar.ItemDescription.AUDIO, size/40);
 *             storage.update_block_size (Granite.Widgets.StorageBar.ItemDescription.VIDEO, size/30);
 *             storage.update_block_size (Granite.Widgets.StorageBar.ItemDescription.APP, size/20);
 *             storage.update_block_size (Granite.Widgets.StorageBar.ItemDescription.PHOTO, size/10);
 *             storage.update_block_size (Granite.Widgets.StorageBar.ItemDescription.FILES, size/5);
 *
 *             add (storage);
 *         } catch (Error e) {
 *             critical (e.message);
 *         }
 *     }
 * }
 * }}}
 */
static GType
granite_widgets_storage_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsStorageBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_storage_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsStorageBar), 0, (GInstanceInitFunc) granite_widgets_storage_bar_instance_init, NULL };
	GType granite_widgets_storage_bar_type_id;
	granite_widgets_storage_bar_type_id = g_type_register_static (gtk_box_get_type (), "GraniteWidgetsStorageBar", &g_define_type_info, 0);
	GraniteWidgetsStorageBar_private_offset = g_type_add_instance_private (granite_widgets_storage_bar_type_id, sizeof (GraniteWidgetsStorageBarPrivate));
	return granite_widgets_storage_bar_type_id;
}

GType
granite_widgets_storage_bar_get_type (void)
{
	static volatile gsize granite_widgets_storage_bar_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_storage_bar_type_id__once)) {
		GType granite_widgets_storage_bar_type_id;
		granite_widgets_storage_bar_type_id = granite_widgets_storage_bar_get_type_once ();
		g_once_init_leave (&granite_widgets_storage_bar_type_id__once, granite_widgets_storage_bar_type_id);
	}
	return granite_widgets_storage_bar_type_id__once;
}

static void
_vala_granite_widgets_storage_bar_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsStorageBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_STORAGE_BAR, GraniteWidgetsStorageBar);
	switch (property_id) {
		case GRANITE_WIDGETS_STORAGE_BAR_STORAGE_PROPERTY:
		g_value_set_uint64 (value, granite_widgets_storage_bar_get_storage (self));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_TOTAL_USAGE_PROPERTY:
		g_value_set_uint64 (value, granite_widgets_storage_bar_get_total_usage (self));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_INNER_MARGIN_SIDES_PROPERTY:
		g_value_set_int (value, granite_widgets_storage_bar_get_inner_margin_sides (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_storage_bar_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsStorageBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_STORAGE_BAR, GraniteWidgetsStorageBar);
	switch (property_id) {
		case GRANITE_WIDGETS_STORAGE_BAR_STORAGE_PROPERTY:
		granite_widgets_storage_bar_set_storage (self, g_value_get_uint64 (value));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_TOTAL_USAGE_PROPERTY:
		granite_widgets_storage_bar_set_total_usage (self, g_value_get_uint64 (value));
		break;
		case GRANITE_WIDGETS_STORAGE_BAR_INNER_MARGIN_SIDES_PROPERTY:
		granite_widgets_storage_bar_set_inner_margin_sides (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

