{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A triangle.
-- 
-- /Since: 1.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Triangle
    ( 

-- * Exported types
    Triangle(..)                            ,
    newZeroTriangle                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [containsPoint]("GI.Graphene.Structs.Triangle#g:method:containsPoint"), [equal]("GI.Graphene.Structs.Triangle#g:method:equal"), [free]("GI.Graphene.Structs.Triangle#g:method:free"), [initFromFloat]("GI.Graphene.Structs.Triangle#g:method:initFromFloat"), [initFromPoint3d]("GI.Graphene.Structs.Triangle#g:method:initFromPoint3d"), [initFromVec3]("GI.Graphene.Structs.Triangle#g:method:initFromVec3").
-- 
-- ==== Getters
-- [getArea]("GI.Graphene.Structs.Triangle#g:method:getArea"), [getBarycoords]("GI.Graphene.Structs.Triangle#g:method:getBarycoords"), [getBoundingBox]("GI.Graphene.Structs.Triangle#g:method:getBoundingBox"), [getMidpoint]("GI.Graphene.Structs.Triangle#g:method:getMidpoint"), [getNormal]("GI.Graphene.Structs.Triangle#g:method:getNormal"), [getPlane]("GI.Graphene.Structs.Triangle#g:method:getPlane"), [getPoints]("GI.Graphene.Structs.Triangle#g:method:getPoints"), [getUv]("GI.Graphene.Structs.Triangle#g:method:getUv"), [getVertices]("GI.Graphene.Structs.Triangle#g:method:getVertices").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTriangleMethod                   ,
#endif

-- ** alloc #method:alloc#

    triangleAlloc                           ,


-- ** containsPoint #method:containsPoint#

#if defined(ENABLE_OVERLOADING)
    TriangleContainsPointMethodInfo         ,
#endif
    triangleContainsPoint                   ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    TriangleEqualMethodInfo                 ,
#endif
    triangleEqual                           ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    TriangleFreeMethodInfo                  ,
#endif
    triangleFree                            ,


-- ** getArea #method:getArea#

#if defined(ENABLE_OVERLOADING)
    TriangleGetAreaMethodInfo               ,
#endif
    triangleGetArea                         ,


-- ** getBarycoords #method:getBarycoords#

#if defined(ENABLE_OVERLOADING)
    TriangleGetBarycoordsMethodInfo         ,
#endif
    triangleGetBarycoords                   ,


-- ** getBoundingBox #method:getBoundingBox#

#if defined(ENABLE_OVERLOADING)
    TriangleGetBoundingBoxMethodInfo        ,
#endif
    triangleGetBoundingBox                  ,


-- ** getMidpoint #method:getMidpoint#

#if defined(ENABLE_OVERLOADING)
    TriangleGetMidpointMethodInfo           ,
#endif
    triangleGetMidpoint                     ,


-- ** getNormal #method:getNormal#

#if defined(ENABLE_OVERLOADING)
    TriangleGetNormalMethodInfo             ,
#endif
    triangleGetNormal                       ,


-- ** getPlane #method:getPlane#

#if defined(ENABLE_OVERLOADING)
    TriangleGetPlaneMethodInfo              ,
#endif
    triangleGetPlane                        ,


-- ** getPoints #method:getPoints#

#if defined(ENABLE_OVERLOADING)
    TriangleGetPointsMethodInfo             ,
#endif
    triangleGetPoints                       ,


-- ** getUv #method:getUv#

#if defined(ENABLE_OVERLOADING)
    TriangleGetUvMethodInfo                 ,
#endif
    triangleGetUv                           ,


-- ** getVertices #method:getVertices#

#if defined(ENABLE_OVERLOADING)
    TriangleGetVerticesMethodInfo           ,
#endif
    triangleGetVertices                     ,


-- ** initFromFloat #method:initFromFloat#

#if defined(ENABLE_OVERLOADING)
    TriangleInitFromFloatMethodInfo         ,
#endif
    triangleInitFromFloat                   ,


-- ** initFromPoint3d #method:initFromPoint3d#

#if defined(ENABLE_OVERLOADING)
    TriangleInitFromPoint3dMethodInfo       ,
#endif
    triangleInitFromPoint3d                 ,


-- ** initFromVec3 #method:initFromVec3#

#if defined(ENABLE_OVERLOADING)
    TriangleInitFromVec3MethodInfo          ,
#endif
    triangleInitFromVec3                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Enums as Graphene.Enums
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Euler as Graphene.Euler
import {-# SOURCE #-} qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import {-# SOURCE #-} qualified GI.Graphene.Structs.Plane as Graphene.Plane
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quad as Graphene.Quad
import {-# SOURCE #-} qualified GI.Graphene.Structs.Quaternion as Graphene.Quaternion
import {-# SOURCE #-} qualified GI.Graphene.Structs.Ray as Graphene.Ray
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Sphere as Graphene.Sphere
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Box as Graphene.Box
import {-# SOURCE #-} qualified GI.Graphene.Structs.Plane as Graphene.Plane
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3

#endif

-- | Memory-managed wrapper type.
newtype Triangle = Triangle (SP.ManagedPtr Triangle)
    deriving (Eq)

instance SP.ManagedPtrNewtype Triangle where
    toManagedPtr (Triangle p) = p

foreign import ccall "graphene_triangle_get_type" c_graphene_triangle_get_type :: 
    IO GType

type instance O.ParentTypes Triangle = '[]
instance O.HasParentTypes Triangle

instance B.Types.TypedObject Triangle where
    glibType = c_graphene_triangle_get_type

instance B.Types.GBoxed Triangle

-- | Convert t'Triangle' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Triangle) where
    gvalueGType_ = c_graphene_triangle_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Triangle)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Triangle)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Triangle ptr
        else return P.Nothing
        
    

-- | Construct a t'Triangle' struct initialized to zero.
newZeroTriangle :: MonadIO m => m Triangle
newZeroTriangle = liftIO $ callocBoxedBytes 48 >>= wrapBoxed Triangle

instance tag ~ 'AttrSet => Constructible Triangle tag where
    new _ attrs = do
        o <- newZeroTriangle
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Triangle
type instance O.AttributeList Triangle = TriangleAttributeList
type TriangleAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Triangle::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Triangle" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_alloc" graphene_triangle_alloc :: 
    IO (Ptr Triangle)

-- | Allocates a new t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- The contents of the returned structure are undefined.
-- 
-- /Since: 1.2/
triangleAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Triangle
    -- ^ __Returns:__ the newly allocated t'GI.Graphene.Structs.Triangle.Triangle'
    --   structure. Use 'GI.Graphene.Structs.Triangle.triangleFree' to free the resources
    --   allocated by this function
triangleAlloc  = liftIO $ do
    result <- graphene_triangle_alloc
    checkUnexpectedReturnNULL "triangleAlloc" result
    result' <- (wrapBoxed Triangle) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Triangle::contains_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_contains_point" graphene_triangle_contains_point :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Point3D.Point3D ->         -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CInt

-- | Checks whether the given triangle /@t@/ contains the point /@p@/.
-- 
-- /Since: 1.2/
triangleContainsPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> Graphene.Point3D.Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Bool
    -- ^ __Returns:__ @true@ if the point is inside the triangle
triangleContainsPoint t p = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_triangle_contains_point t' p'
    let result' = (/= 0) result
    touchManagedPtr t
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data TriangleContainsPointMethodInfo
instance (signature ~ (Graphene.Point3D.Point3D -> m Bool), MonadIO m) => O.OverloadedMethod TriangleContainsPointMethodInfo Triangle signature where
    overloadedMethod = triangleContainsPoint

instance O.OverloadedMethodInfo TriangleContainsPointMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleContainsPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleContainsPoint"
        })


#endif

-- method Triangle::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_equal" graphene_triangle_equal :: 
    Ptr Triangle ->                         -- a : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Triangle ->                         -- b : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    IO CInt

-- | Checks whether the two given t'GI.Graphene.Structs.Triangle.Triangle' are equal.
-- 
-- /Since: 1.2/
triangleEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@a@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> Triangle
    -- ^ /@b@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m Bool
    -- ^ __Returns:__ @true@ if the triangles are equal
triangleEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_triangle_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data TriangleEqualMethodInfo
instance (signature ~ (Triangle -> m Bool), MonadIO m) => O.OverloadedMethod TriangleEqualMethodInfo Triangle signature where
    overloadedMethod = triangleEqual

instance O.OverloadedMethodInfo TriangleEqualMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleEqual"
        })


#endif

-- method Triangle::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_free" graphene_triangle_free :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Triangle.triangleAlloc'.
-- 
-- /Since: 1.2/
triangleFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m ()
triangleFree t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    graphene_triangle_free t'
    touchManagedPtr t
    return ()

#if defined(ENABLE_OVERLOADING)
data TriangleFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TriangleFreeMethodInfo Triangle signature where
    overloadedMethod = triangleFree

instance O.OverloadedMethodInfo TriangleFreeMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleFree"
        })


#endif

-- method Triangle::get_area
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_area" graphene_triangle_get_area :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    IO CFloat

-- | Computes the area of the given t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- /Since: 1.2/
triangleGetArea ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m Float
    -- ^ __Returns:__ the area of the triangle
triangleGetArea t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    result <- graphene_triangle_get_area t'
    let result' = realToFrac result
    touchManagedPtr t
    return result'

#if defined(ENABLE_OVERLOADING)
data TriangleGetAreaMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod TriangleGetAreaMethodInfo Triangle signature where
    overloadedMethod = triangleGetArea

instance O.OverloadedMethodInfo TriangleGetAreaMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetArea",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetArea"
        })


#endif

-- method Triangle::get_barycoords
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the vector\n  with the barycentric coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_barycoords" graphene_triangle_get_barycoords :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Point3D.Point3D ->         -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Vec2.Vec2 ->               -- res : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    IO CInt

-- | Computes the <http://en.wikipedia.org/wiki/Barycentric_coordinate_system barycentric coordinates>
-- of the given point /@p@/.
-- 
-- The point /@p@/ must lie on the same plane as the triangle /@t@/; if the
-- point is not coplanar, the result of this function is undefined.
-- 
-- If we place the origin in the coordinates of the triangle\'s A point,
-- the barycentric coordinates are @u@, which is on the AC vector; and @v@
-- which is on the AB vector:
-- 
-- <<http://developer.gnome.org/graphene/stable/triangle-barycentric.png>>
-- 
-- The returned t'GI.Graphene.Structs.Vec2.Vec2' contains the following values, in order:
-- 
-- * @res.x = u@
-- * @res.y = v@
-- 
-- 
-- /Since: 1.2/
triangleGetBarycoords ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m ((Bool, Graphene.Vec2.Vec2))
    -- ^ __Returns:__ @true@ if the barycentric coordinates are valid
triangleGetBarycoords t p = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    maybeP <- case p of
        Nothing -> return FP.nullPtr
        Just jP -> do
            jP' <- unsafeManagedPtrGetPtr jP
            return jP'
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec2.Vec2)
    result <- graphene_triangle_get_barycoords t' maybeP res
    let result' = (/= 0) result
    res' <- (wrapBoxed Graphene.Vec2.Vec2) res
    touchManagedPtr t
    whenJust p touchManagedPtr
    return (result', res')

#if defined(ENABLE_OVERLOADING)
data TriangleGetBarycoordsMethodInfo
instance (signature ~ (Maybe (Graphene.Point3D.Point3D) -> m ((Bool, Graphene.Vec2.Vec2))), MonadIO m) => O.OverloadedMethod TriangleGetBarycoordsMethodInfo Triangle signature where
    overloadedMethod = triangleGetBarycoords

instance O.OverloadedMethodInfo TriangleGetBarycoordsMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetBarycoords",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetBarycoords"
        })


#endif

-- method Triangle::get_bounding_box
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Box" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_bounding_box" graphene_triangle_get_bounding_box :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Box.Box ->                 -- res : TInterface (Name {namespace = "Graphene", name = "Box"})
    IO ()

-- | Computes the bounding box of the given t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- /Since: 1.2/
triangleGetBoundingBox ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m (Graphene.Box.Box)
triangleGetBoundingBox t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    res <- SP.callocBoxedBytes 32 :: IO (Ptr Graphene.Box.Box)
    graphene_triangle_get_bounding_box t' res
    res' <- (wrapBoxed Graphene.Box.Box) res
    touchManagedPtr t
    return res'

#if defined(ENABLE_OVERLOADING)
data TriangleGetBoundingBoxMethodInfo
instance (signature ~ (m (Graphene.Box.Box)), MonadIO m) => O.OverloadedMethod TriangleGetBoundingBoxMethodInfo Triangle signature where
    overloadedMethod = triangleGetBoundingBox

instance O.OverloadedMethodInfo TriangleGetBoundingBoxMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetBoundingBox",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetBoundingBox"
        })


#endif

-- method Triangle::get_midpoint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the coordinates of\n  the midpoint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_midpoint" graphene_triangle_get_midpoint :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Point3D.Point3D ->         -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Computes the coordinates of the midpoint of the given t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- The midpoint G is the <https://en.wikipedia.org/wiki/Centroid#Triangle_centroid centroid>
-- of the triangle, i.e. the intersection of its medians.
-- 
-- /Since: 1.2/
triangleGetMidpoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m (Graphene.Point3D.Point3D)
triangleGetMidpoint t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_triangle_get_midpoint t' res
    res' <- (wrapBoxed Graphene.Point3D.Point3D) res
    touchManagedPtr t
    return res'

#if defined(ENABLE_OVERLOADING)
data TriangleGetMidpointMethodInfo
instance (signature ~ (m (Graphene.Point3D.Point3D)), MonadIO m) => O.OverloadedMethod TriangleGetMidpointMethodInfo Triangle signature where
    overloadedMethod = triangleGetMidpoint

instance O.OverloadedMethodInfo TriangleGetMidpointMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetMidpoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetMidpoint"
        })


#endif

-- method Triangle::get_normal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the normal vector"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_normal" graphene_triangle_get_normal :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Vec3.Vec3 ->               -- res : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Computes the normal vector of the given t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- /Since: 1.2/
triangleGetNormal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m (Graphene.Vec3.Vec3)
triangleGetNormal t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_triangle_get_normal t' res
    res' <- (wrapBoxed Graphene.Vec3.Vec3) res
    touchManagedPtr t
    return res'

#if defined(ENABLE_OVERLOADING)
data TriangleGetNormalMethodInfo
instance (signature ~ (m (Graphene.Vec3.Vec3)), MonadIO m) => O.OverloadedMethod TriangleGetNormalMethodInfo Triangle signature where
    overloadedMethod = triangleGetNormal

instance O.OverloadedMethodInfo TriangleGetNormalMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetNormal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetNormal"
        })


#endif

-- method Triangle::get_plane
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Plane" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_plane" graphene_triangle_get_plane :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Plane.Plane ->             -- res : TInterface (Name {namespace = "Graphene", name = "Plane"})
    IO ()

-- | Computes the plane based on the vertices of the given t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- /Since: 1.2/
triangleGetPlane ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m (Graphene.Plane.Plane)
triangleGetPlane t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    res <- SP.callocBoxedBytes 20 :: IO (Ptr Graphene.Plane.Plane)
    graphene_triangle_get_plane t' res
    res' <- (wrapBoxed Graphene.Plane.Plane) res
    touchManagedPtr t
    return res'

#if defined(ENABLE_OVERLOADING)
data TriangleGetPlaneMethodInfo
instance (signature ~ (m (Graphene.Plane.Plane)), MonadIO m) => O.OverloadedMethod TriangleGetPlaneMethodInfo Triangle signature where
    overloadedMethod = triangleGetPlane

instance O.OverloadedMethodInfo TriangleGetPlaneMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetPlane",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetPlane"
        })


#endif

-- method Triangle::get_points
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the coordinates\n  of the first vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the coordinates\n  of the second vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the coordinates\n  of the third vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_points" graphene_triangle_get_points :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Point3D.Point3D ->         -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- c : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Retrieves the three vertices of the given t'GI.Graphene.Structs.Triangle.Triangle' and returns
-- their coordinates as t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.2/
triangleGetPoints ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m ((Graphene.Point3D.Point3D, Graphene.Point3D.Point3D, Graphene.Point3D.Point3D))
triangleGetPoints t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    a <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    b <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    c <- SP.callocBoxedBytes 12 :: IO (Ptr Graphene.Point3D.Point3D)
    graphene_triangle_get_points t' a b c
    a' <- (wrapBoxed Graphene.Point3D.Point3D) a
    b' <- (wrapBoxed Graphene.Point3D.Point3D) b
    c' <- (wrapBoxed Graphene.Point3D.Point3D) c
    touchManagedPtr t
    return (a', b', c')

#if defined(ENABLE_OVERLOADING)
data TriangleGetPointsMethodInfo
instance (signature ~ (m ((Graphene.Point3D.Point3D, Graphene.Point3D.Point3D, Graphene.Point3D.Point3D))), MonadIO m) => O.OverloadedMethod TriangleGetPointsMethodInfo Triangle signature where
    overloadedMethod = triangleGetPoints

instance O.OverloadedMethodInfo TriangleGetPointsMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetPoints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetPoints"
        })


#endif

-- method Triangle::get_uv
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uv_a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UV coordinates of the first point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uv_b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UV coordinates of the second point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uv_c"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UV coordinates of the third point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a vector containing the UV coordinates\n  of the given point @p"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_uv" graphene_triangle_get_uv :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Point3D.Point3D ->         -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Vec2.Vec2 ->               -- uv_a : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    Ptr Graphene.Vec2.Vec2 ->               -- uv_b : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    Ptr Graphene.Vec2.Vec2 ->               -- uv_c : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    Ptr Graphene.Vec2.Vec2 ->               -- res : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    IO CInt

-- | Computes the UV coordinates of the given point /@p@/.
-- 
-- The point /@p@/ must lie on the same plane as the triangle /@t@/; if the point
-- is not coplanar, the result of this function is undefined. If /@p@/ is 'P.Nothing',
-- the point will be set in (0, 0, 0).
-- 
-- The UV coordinates will be placed in the /@res@/ vector:
-- 
-- * @res.x = u@
-- * @res.y = v@
-- 
-- 
-- See also: 'GI.Graphene.Structs.Triangle.triangleGetBarycoords'
-- 
-- /Since: 1.10/
triangleGetUv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Graphene.Vec2.Vec2
    -- ^ /@uvA@/: the UV coordinates of the first point
    -> Graphene.Vec2.Vec2
    -- ^ /@uvB@/: the UV coordinates of the second point
    -> Graphene.Vec2.Vec2
    -- ^ /@uvC@/: the UV coordinates of the third point
    -> m ((Bool, Graphene.Vec2.Vec2))
    -- ^ __Returns:__ @true@ if the coordinates are valid
triangleGetUv t p uvA uvB uvC = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    maybeP <- case p of
        Nothing -> return FP.nullPtr
        Just jP -> do
            jP' <- unsafeManagedPtrGetPtr jP
            return jP'
    uvA' <- unsafeManagedPtrGetPtr uvA
    uvB' <- unsafeManagedPtrGetPtr uvB
    uvC' <- unsafeManagedPtrGetPtr uvC
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec2.Vec2)
    result <- graphene_triangle_get_uv t' maybeP uvA' uvB' uvC' res
    let result' = (/= 0) result
    res' <- (wrapBoxed Graphene.Vec2.Vec2) res
    touchManagedPtr t
    whenJust p touchManagedPtr
    touchManagedPtr uvA
    touchManagedPtr uvB
    touchManagedPtr uvC
    return (result', res')

#if defined(ENABLE_OVERLOADING)
data TriangleGetUvMethodInfo
instance (signature ~ (Maybe (Graphene.Point3D.Point3D) -> Graphene.Vec2.Vec2 -> Graphene.Vec2.Vec2 -> Graphene.Vec2.Vec2 -> m ((Bool, Graphene.Vec2.Vec2))), MonadIO m) => O.OverloadedMethod TriangleGetUvMethodInfo Triangle signature where
    overloadedMethod = triangleGetUv

instance O.OverloadedMethodInfo TriangleGetUvMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetUv",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetUv"
        })


#endif

-- method Triangle::get_vertices
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_triangle_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the first vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the second vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the third vertex"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_get_vertices" graphene_triangle_get_vertices :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Vec3.Vec3 ->               -- a : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Vec3.Vec3 ->               -- b : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Vec3.Vec3 ->               -- c : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Retrieves the three vertices of the given t'GI.Graphene.Structs.Triangle.Triangle'.
-- 
-- /Since: 1.2/
triangleGetVertices ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: a t'GI.Graphene.Structs.Triangle.Triangle'
    -> m ((Graphene.Vec3.Vec3, Graphene.Vec3.Vec3, Graphene.Vec3.Vec3))
triangleGetVertices t = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    a <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    b <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    c <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_triangle_get_vertices t' a b c
    a' <- (wrapBoxed Graphene.Vec3.Vec3) a
    b' <- (wrapBoxed Graphene.Vec3.Vec3) b
    c' <- (wrapBoxed Graphene.Vec3.Vec3) c
    touchManagedPtr t
    return (a', b', c')

#if defined(ENABLE_OVERLOADING)
data TriangleGetVerticesMethodInfo
instance (signature ~ (m ((Graphene.Vec3.Vec3, Graphene.Vec3.Vec3, Graphene.Vec3.Vec3))), MonadIO m) => O.OverloadedMethod TriangleGetVerticesMethodInfo Triangle signature where
    overloadedMethod = triangleGetVertices

instance O.OverloadedMethodInfo TriangleGetVerticesMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleGetVertices",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleGetVertices"
        })


#endif

-- method Triangle::init_from_float
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_triangle_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType = TCArray False 3 (-1) (TBasicType TFloat)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of 3 floating point values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TCArray False 3 (-1) (TBasicType TFloat)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of 3 floating point values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType = TCArray False 3 (-1) (TBasicType TFloat)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of 3 floating point values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Triangle" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_init_from_float" graphene_triangle_init_from_float :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr CFloat ->                           -- a : TCArray False 3 (-1) (TBasicType TFloat)
    Ptr CFloat ->                           -- b : TCArray False 3 (-1) (TBasicType TFloat)
    Ptr CFloat ->                           -- c : TCArray False 3 (-1) (TBasicType TFloat)
    IO (Ptr Triangle)

-- | Initializes a t'GI.Graphene.Structs.Triangle.Triangle' using the three given arrays
-- of floating point values, each representing the coordinates of
-- a point in 3D space.
-- 
-- /Since: 1.10/
triangleInitFromFloat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: the t'GI.Graphene.Structs.Triangle.Triangle' to initialize
    -> [Float]
    -- ^ /@a@/: an array of 3 floating point values
    -> [Float]
    -- ^ /@b@/: an array of 3 floating point values
    -> [Float]
    -- ^ /@c@/: an array of 3 floating point values
    -> m Triangle
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Triangle.Triangle'
triangleInitFromFloat t a b c = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    a' <- (packMapStorableArray realToFrac) a
    b' <- (packMapStorableArray realToFrac) b
    c' <- (packMapStorableArray realToFrac) c
    result <- graphene_triangle_init_from_float t' a' b' c'
    checkUnexpectedReturnNULL "triangleInitFromFloat" result
    result' <- (newBoxed Triangle) result
    touchManagedPtr t
    freeMem a'
    freeMem b'
    freeMem c'
    return result'

#if defined(ENABLE_OVERLOADING)
data TriangleInitFromFloatMethodInfo
instance (signature ~ ([Float] -> [Float] -> [Float] -> m Triangle), MonadIO m) => O.OverloadedMethod TriangleInitFromFloatMethodInfo Triangle signature where
    overloadedMethod = triangleInitFromFloat

instance O.OverloadedMethodInfo TriangleInitFromFloatMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleInitFromFloat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleInitFromFloat"
        })


#endif

-- method Triangle::init_from_point3d
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_triangle_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Triangle" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_init_from_point3d" graphene_triangle_init_from_point3d :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Point3D.Point3D ->         -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Point3D.Point3D ->         -- c : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Triangle)

-- | Initializes a t'GI.Graphene.Structs.Triangle.Triangle' using the three given 3D points.
-- 
-- /Since: 1.2/
triangleInitFromPoint3d ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: the t'GI.Graphene.Structs.Triangle.Triangle' to initialize
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Maybe (Graphene.Point3D.Point3D)
    -- ^ /@c@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Triangle
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Triangle.Triangle'
triangleInitFromPoint3d t a b c = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    maybeA <- case a of
        Nothing -> return FP.nullPtr
        Just jA -> do
            jA' <- unsafeManagedPtrGetPtr jA
            return jA'
    maybeB <- case b of
        Nothing -> return FP.nullPtr
        Just jB -> do
            jB' <- unsafeManagedPtrGetPtr jB
            return jB'
    maybeC <- case c of
        Nothing -> return FP.nullPtr
        Just jC -> do
            jC' <- unsafeManagedPtrGetPtr jC
            return jC'
    result <- graphene_triangle_init_from_point3d t' maybeA maybeB maybeC
    checkUnexpectedReturnNULL "triangleInitFromPoint3d" result
    result' <- (newBoxed Triangle) result
    touchManagedPtr t
    whenJust a touchManagedPtr
    whenJust b touchManagedPtr
    whenJust c touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data TriangleInitFromPoint3dMethodInfo
instance (signature ~ (Maybe (Graphene.Point3D.Point3D) -> Maybe (Graphene.Point3D.Point3D) -> Maybe (Graphene.Point3D.Point3D) -> m Triangle), MonadIO m) => O.OverloadedMethod TriangleInitFromPoint3dMethodInfo Triangle signature where
    overloadedMethod = triangleInitFromPoint3d

instance O.OverloadedMethodInfo TriangleInitFromPoint3dMethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleInitFromPoint3d",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleInitFromPoint3d"
        })


#endif

-- method Triangle::init_from_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "t"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Triangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_triangle_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec3_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec3_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec3_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Triangle" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_triangle_init_from_vec3" graphene_triangle_init_from_vec3 :: 
    Ptr Triangle ->                         -- t : TInterface (Name {namespace = "Graphene", name = "Triangle"})
    Ptr Graphene.Vec3.Vec3 ->               -- a : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Vec3.Vec3 ->               -- b : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    Ptr Graphene.Vec3.Vec3 ->               -- c : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO (Ptr Triangle)

-- | Initializes a t'GI.Graphene.Structs.Triangle.Triangle' using the three given vectors.
-- 
-- /Since: 1.2/
triangleInitFromVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Triangle
    -- ^ /@t@/: the t'GI.Graphene.Structs.Triangle.Triangle' to initialize
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@a@/: a t'GI.Graphene.Structs.Vec3.Vec3'
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@b@/: a t'GI.Graphene.Structs.Vec3.Vec3'
    -> Maybe (Graphene.Vec3.Vec3)
    -- ^ /@c@/: a t'GI.Graphene.Structs.Vec3.Vec3'
    -> m Triangle
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Triangle.Triangle'
triangleInitFromVec3 t a b c = liftIO $ do
    t' <- unsafeManagedPtrGetPtr t
    maybeA <- case a of
        Nothing -> return FP.nullPtr
        Just jA -> do
            jA' <- unsafeManagedPtrGetPtr jA
            return jA'
    maybeB <- case b of
        Nothing -> return FP.nullPtr
        Just jB -> do
            jB' <- unsafeManagedPtrGetPtr jB
            return jB'
    maybeC <- case c of
        Nothing -> return FP.nullPtr
        Just jC -> do
            jC' <- unsafeManagedPtrGetPtr jC
            return jC'
    result <- graphene_triangle_init_from_vec3 t' maybeA maybeB maybeC
    checkUnexpectedReturnNULL "triangleInitFromVec3" result
    result' <- (newBoxed Triangle) result
    touchManagedPtr t
    whenJust a touchManagedPtr
    whenJust b touchManagedPtr
    whenJust c touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data TriangleInitFromVec3MethodInfo
instance (signature ~ (Maybe (Graphene.Vec3.Vec3) -> Maybe (Graphene.Vec3.Vec3) -> Maybe (Graphene.Vec3.Vec3) -> m Triangle), MonadIO m) => O.OverloadedMethod TriangleInitFromVec3MethodInfo Triangle signature where
    overloadedMethod = triangleInitFromVec3

instance O.OverloadedMethodInfo TriangleInitFromVec3MethodInfo Triangle where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Triangle.triangleInitFromVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Triangle.html#v:triangleInitFromVec3"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTriangleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTriangleMethod "containsPoint" o = TriangleContainsPointMethodInfo
    ResolveTriangleMethod "equal" o = TriangleEqualMethodInfo
    ResolveTriangleMethod "free" o = TriangleFreeMethodInfo
    ResolveTriangleMethod "initFromFloat" o = TriangleInitFromFloatMethodInfo
    ResolveTriangleMethod "initFromPoint3d" o = TriangleInitFromPoint3dMethodInfo
    ResolveTriangleMethod "initFromVec3" o = TriangleInitFromVec3MethodInfo
    ResolveTriangleMethod "getArea" o = TriangleGetAreaMethodInfo
    ResolveTriangleMethod "getBarycoords" o = TriangleGetBarycoordsMethodInfo
    ResolveTriangleMethod "getBoundingBox" o = TriangleGetBoundingBoxMethodInfo
    ResolveTriangleMethod "getMidpoint" o = TriangleGetMidpointMethodInfo
    ResolveTriangleMethod "getNormal" o = TriangleGetNormalMethodInfo
    ResolveTriangleMethod "getPlane" o = TriangleGetPlaneMethodInfo
    ResolveTriangleMethod "getPoints" o = TriangleGetPointsMethodInfo
    ResolveTriangleMethod "getUv" o = TriangleGetUvMethodInfo
    ResolveTriangleMethod "getVertices" o = TriangleGetVerticesMethodInfo
    ResolveTriangleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTriangleMethod t Triangle, O.OverloadedMethod info Triangle p) => OL.IsLabel t (Triangle -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTriangleMethod t Triangle, O.OverloadedMethod info Triangle p, R.HasField t Triangle p) => R.HasField t Triangle p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTriangleMethod t Triangle, O.OverloadedMethodInfo info Triangle) => OL.IsLabel t (O.MethodProxy info Triangle) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


