{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrShape@ structure is used to represent attributes which
-- impose shape restrictions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrShape
    ( 

-- * Exported types
    AttrShape(..)                           ,
    newZeroAttrShape                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrShapeMethod                  ,
#endif

-- ** new #method:new#

    attrShapeNew                            ,


-- ** newWithData #method:newWithData#

    attrShapeNewWithData                    ,




 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrShape_attr                          ,
#endif
    getAttrShapeAttr                        ,


-- ** copyFunc #attr:copyFunc#
-- | copy function for the user data

#if defined(ENABLE_OVERLOADING)
    attrShape_copyFunc                      ,
#endif
    clearAttrShapeCopyFunc                  ,
    getAttrShapeCopyFunc                    ,
    setAttrShapeCopyFunc                    ,


-- ** data #attr:data#
-- | user data set (see 'GI.Pango.Structs.AttrShape.attrShapeNewWithData')

#if defined(ENABLE_OVERLOADING)
    attrShape_data                          ,
#endif
    clearAttrShapeData                      ,
    getAttrShapeData                        ,
    setAttrShapeData                        ,


-- ** destroyFunc #attr:destroyFunc#
-- | destroy function for the user data

#if defined(ENABLE_OVERLOADING)
    attrShape_destroyFunc                   ,
#endif
    clearAttrShapeDestroyFunc               ,
    getAttrShapeDestroyFunc                 ,
    setAttrShapeDestroyFunc                 ,


-- ** inkRect #attr:inkRect#
-- | the ink rectangle to restrict to

#if defined(ENABLE_OVERLOADING)
    attrShape_inkRect                       ,
#endif
    getAttrShapeInkRect                     ,


-- ** logicalRect #attr:logicalRect#
-- | the logical rectangle to restrict to

#if defined(ENABLE_OVERLOADING)
    attrShape_logicalRect                   ,
#endif
    getAttrShapeLogicalRect                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype AttrShape = AttrShape (SP.ManagedPtr AttrShape)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrShape where
    toManagedPtr (AttrShape p) = p

instance BoxedPtr AttrShape where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 72 >=> B.ManagedPtr.wrapPtr AttrShape)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrShape where
    boxedPtrCalloc = callocBytes 72


-- | Construct a t'AttrShape' struct initialized to zero.
newZeroAttrShape :: MonadIO m => m AttrShape
newZeroAttrShape = liftIO $ boxedPtrCalloc >>= wrapPtr AttrShape

instance tag ~ 'AttrSet => Constructible AttrShape tag where
    new _ attrs = do
        o <- newZeroAttrShape
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrShape #attr
-- @
getAttrShapeAttr :: MonadIO m => AttrShape -> m Pango.Attribute.Attribute
getAttrShapeAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrShapeAttrFieldInfo
instance AttrInfo AttrShapeAttrFieldInfo where
    type AttrBaseTypeConstraint AttrShapeAttrFieldInfo = (~) AttrShape
    type AttrAllowedOps AttrShapeAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrShapeAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrShapeAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrShapeAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrShapeAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrShapeAttrFieldInfo = "attr"
    type AttrOrigin AttrShapeAttrFieldInfo = AttrShape
    attrGet = getAttrShapeAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrShape.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrShape.html#g:attr:attr"
        })

attrShape_attr :: AttrLabelProxy "attr"
attrShape_attr = AttrLabelProxy

#endif


-- | Get the value of the “@ink_rect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrShape #inkRect
-- @
getAttrShapeInkRect :: MonadIO m => AttrShape -> m Pango.Rectangle.Rectangle
getAttrShapeInkRect s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 16 :: (Ptr Pango.Rectangle.Rectangle)
    val' <- (newPtr Pango.Rectangle.Rectangle) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrShapeInkRectFieldInfo
instance AttrInfo AttrShapeInkRectFieldInfo where
    type AttrBaseTypeConstraint AttrShapeInkRectFieldInfo = (~) AttrShape
    type AttrAllowedOps AttrShapeInkRectFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrShapeInkRectFieldInfo = (~) (Ptr Pango.Rectangle.Rectangle)
    type AttrTransferTypeConstraint AttrShapeInkRectFieldInfo = (~)(Ptr Pango.Rectangle.Rectangle)
    type AttrTransferType AttrShapeInkRectFieldInfo = (Ptr Pango.Rectangle.Rectangle)
    type AttrGetType AttrShapeInkRectFieldInfo = Pango.Rectangle.Rectangle
    type AttrLabel AttrShapeInkRectFieldInfo = "ink_rect"
    type AttrOrigin AttrShapeInkRectFieldInfo = AttrShape
    attrGet = getAttrShapeInkRect
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrShape.inkRect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrShape.html#g:attr:inkRect"
        })

attrShape_inkRect :: AttrLabelProxy "inkRect"
attrShape_inkRect = AttrLabelProxy

#endif


-- | Get the value of the “@logical_rect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrShape #logicalRect
-- @
getAttrShapeLogicalRect :: MonadIO m => AttrShape -> m Pango.Rectangle.Rectangle
getAttrShapeLogicalRect s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 32 :: (Ptr Pango.Rectangle.Rectangle)
    val' <- (newPtr Pango.Rectangle.Rectangle) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrShapeLogicalRectFieldInfo
instance AttrInfo AttrShapeLogicalRectFieldInfo where
    type AttrBaseTypeConstraint AttrShapeLogicalRectFieldInfo = (~) AttrShape
    type AttrAllowedOps AttrShapeLogicalRectFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrShapeLogicalRectFieldInfo = (~) (Ptr Pango.Rectangle.Rectangle)
    type AttrTransferTypeConstraint AttrShapeLogicalRectFieldInfo = (~)(Ptr Pango.Rectangle.Rectangle)
    type AttrTransferType AttrShapeLogicalRectFieldInfo = (Ptr Pango.Rectangle.Rectangle)
    type AttrGetType AttrShapeLogicalRectFieldInfo = Pango.Rectangle.Rectangle
    type AttrLabel AttrShapeLogicalRectFieldInfo = "logical_rect"
    type AttrOrigin AttrShapeLogicalRectFieldInfo = AttrShape
    attrGet = getAttrShapeLogicalRect
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrShape.logicalRect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrShape.html#g:attr:logicalRect"
        })

attrShape_logicalRect :: AttrLabelProxy "logicalRect"
attrShape_logicalRect = AttrLabelProxy

#endif


-- | Get the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrShape #data
-- @
getAttrShapeData :: MonadIO m => AttrShape -> m (Ptr ())
getAttrShapeData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (Ptr ())
    return val

-- | Set the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrShape [ #data 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrShapeData :: MonadIO m => AttrShape -> Ptr () -> m ()
setAttrShapeData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Ptr ())

-- | Set the value of the “@data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #data
-- @
clearAttrShapeData :: MonadIO m => AttrShape -> m ()
clearAttrShapeData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data AttrShapeDataFieldInfo
instance AttrInfo AttrShapeDataFieldInfo where
    type AttrBaseTypeConstraint AttrShapeDataFieldInfo = (~) AttrShape
    type AttrAllowedOps AttrShapeDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrShapeDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint AttrShapeDataFieldInfo = (~)(Ptr ())
    type AttrTransferType AttrShapeDataFieldInfo = (Ptr ())
    type AttrGetType AttrShapeDataFieldInfo = Ptr ()
    type AttrLabel AttrShapeDataFieldInfo = "data"
    type AttrOrigin AttrShapeDataFieldInfo = AttrShape
    attrGet = getAttrShapeData
    attrSet = setAttrShapeData
    attrConstruct = undefined
    attrClear = clearAttrShapeData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrShape.data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrShape.html#g:attr:data"
        })

attrShape_data :: AttrLabelProxy "data"
attrShape_data = AttrLabelProxy

#endif


-- | Get the value of the “@copy_func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrShape #copyFunc
-- @
getAttrShapeCopyFunc :: MonadIO m => AttrShape -> m (Maybe Pango.Callbacks.AttrDataCopyFunc_WithClosures)
getAttrShapeCopyFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (FunPtr Pango.Callbacks.C_AttrDataCopyFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Pango.Callbacks.dynamic_AttrDataCopyFunc val'
        return val''
    return result

-- | Set the value of the “@copy_func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrShape [ #copyFunc 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrShapeCopyFunc :: MonadIO m => AttrShape -> FunPtr Pango.Callbacks.C_AttrDataCopyFunc -> m ()
setAttrShapeCopyFunc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: FunPtr Pango.Callbacks.C_AttrDataCopyFunc)

-- | Set the value of the “@copy_func@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #copyFunc
-- @
clearAttrShapeCopyFunc :: MonadIO m => AttrShape -> m ()
clearAttrShapeCopyFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullFunPtr :: FunPtr Pango.Callbacks.C_AttrDataCopyFunc)

#if defined(ENABLE_OVERLOADING)
data AttrShapeCopyFuncFieldInfo
instance AttrInfo AttrShapeCopyFuncFieldInfo where
    type AttrBaseTypeConstraint AttrShapeCopyFuncFieldInfo = (~) AttrShape
    type AttrAllowedOps AttrShapeCopyFuncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrShapeCopyFuncFieldInfo = (~) (FunPtr Pango.Callbacks.C_AttrDataCopyFunc)
    type AttrTransferTypeConstraint AttrShapeCopyFuncFieldInfo = (~)Pango.Callbacks.AttrDataCopyFunc_WithClosures
    type AttrTransferType AttrShapeCopyFuncFieldInfo = (FunPtr Pango.Callbacks.C_AttrDataCopyFunc)
    type AttrGetType AttrShapeCopyFuncFieldInfo = Maybe Pango.Callbacks.AttrDataCopyFunc_WithClosures
    type AttrLabel AttrShapeCopyFuncFieldInfo = "copy_func"
    type AttrOrigin AttrShapeCopyFuncFieldInfo = AttrShape
    attrGet = getAttrShapeCopyFunc
    attrSet = setAttrShapeCopyFunc
    attrConstruct = undefined
    attrClear = clearAttrShapeCopyFunc
    attrTransfer _ v = do
        Pango.Callbacks.mk_AttrDataCopyFunc (Pango.Callbacks.wrap_AttrDataCopyFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrShape.copyFunc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrShape.html#g:attr:copyFunc"
        })

attrShape_copyFunc :: AttrLabelProxy "copyFunc"
attrShape_copyFunc = AttrLabelProxy

#endif


-- | Get the value of the “@destroy_func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrShape #destroyFunc
-- @
getAttrShapeDestroyFunc :: MonadIO m => AttrShape -> m (Maybe GLib.Callbacks.DestroyNotify)
getAttrShapeDestroyFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO (FunPtr GLib.Callbacks.C_DestroyNotify)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_DestroyNotify val'
        return val''
    return result

-- | Set the value of the “@destroy_func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrShape [ #destroyFunc 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrShapeDestroyFunc :: MonadIO m => AttrShape -> FunPtr GLib.Callbacks.C_DestroyNotify -> m ()
setAttrShapeDestroyFunc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (val :: FunPtr GLib.Callbacks.C_DestroyNotify)

-- | Set the value of the “@destroy_func@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #destroyFunc
-- @
clearAttrShapeDestroyFunc :: MonadIO m => AttrShape -> m ()
clearAttrShapeDestroyFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_DestroyNotify)

#if defined(ENABLE_OVERLOADING)
data AttrShapeDestroyFuncFieldInfo
instance AttrInfo AttrShapeDestroyFuncFieldInfo where
    type AttrBaseTypeConstraint AttrShapeDestroyFuncFieldInfo = (~) AttrShape
    type AttrAllowedOps AttrShapeDestroyFuncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrShapeDestroyFuncFieldInfo = (~) (FunPtr GLib.Callbacks.C_DestroyNotify)
    type AttrTransferTypeConstraint AttrShapeDestroyFuncFieldInfo = (~)GLib.Callbacks.DestroyNotify
    type AttrTransferType AttrShapeDestroyFuncFieldInfo = (FunPtr GLib.Callbacks.C_DestroyNotify)
    type AttrGetType AttrShapeDestroyFuncFieldInfo = Maybe GLib.Callbacks.DestroyNotify
    type AttrLabel AttrShapeDestroyFuncFieldInfo = "destroy_func"
    type AttrOrigin AttrShapeDestroyFuncFieldInfo = AttrShape
    attrGet = getAttrShapeDestroyFunc
    attrSet = setAttrShapeDestroyFunc
    attrConstruct = undefined
    attrClear = clearAttrShapeDestroyFunc
    attrTransfer _ v = do
        GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrShape.destroyFunc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrShape.html#g:attr:destroyFunc"
        })

attrShape_destroyFunc :: AttrLabelProxy "destroyFunc"
attrShape_destroyFunc = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrShape
type instance O.AttributeList AttrShape = AttrShapeAttributeList
type AttrShapeAttributeList = ('[ '("attr", AttrShapeAttrFieldInfo), '("inkRect", AttrShapeInkRectFieldInfo), '("logicalRect", AttrShapeLogicalRectFieldInfo), '("data", AttrShapeDataFieldInfo), '("copyFunc", AttrShapeCopyFuncFieldInfo), '("destroyFunc", AttrShapeDestroyFuncFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method AttrShape::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "ink rectangle to assign to each character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "logical rectangle to assign to each character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_shape_new" pango_attr_shape_new :: 
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO (Ptr Pango.Attribute.Attribute)

-- | Create a new shape attribute.
-- 
-- A shape is used to impose a particular ink and logical
-- rectangle on the result of shaping a particular glyph.
-- This might be used, for instance, for embedding a picture
-- or a widget inside a @PangoLayout@.
attrShapeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Pango.Rectangle.Rectangle
    -- ^ /@inkRect@/: ink rectangle to assign to each character
    -> Pango.Rectangle.Rectangle
    -- ^ /@logicalRect@/: logical rectangle to assign to each character
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrShapeNew inkRect logicalRect = liftIO $ do
    inkRect' <- unsafeManagedPtrGetPtr inkRect
    logicalRect' <- unsafeManagedPtrGetPtr logicalRect
    result <- pango_attr_shape_new inkRect' logicalRect'
    checkUnexpectedReturnNULL "attrShapeNew" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    touchManagedPtr inkRect
    touchManagedPtr logicalRect
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AttrShape::new_with_data
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "ink rectangle to assign to each character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "logical rectangle to assign to each character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data pointer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "copy_func"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrDataCopyFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function to copy @data when the\n  attribute is copied. If %NULL, @data is simply copied\n  as a pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to free @data when the\n  attribute is freed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_shape_new_with_data" pango_attr_shape_new_with_data :: 
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr Pango.Callbacks.C_AttrDataCopyFunc -> -- copy_func : TInterface (Name {namespace = "Pango", name = "AttrDataCopyFunc"})
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr Pango.Attribute.Attribute)

-- | Creates a new shape attribute.
-- 
-- Like 'GI.Pango.Structs.AttrShape.attrShapeNew', but a user data pointer
-- is also provided; this pointer can be accessed when later
-- rendering the glyph.
-- 
-- /Since: 1.8/
attrShapeNewWithData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Pango.Rectangle.Rectangle
    -- ^ /@inkRect@/: ink rectangle to assign to each character
    -> Pango.Rectangle.Rectangle
    -- ^ /@logicalRect@/: logical rectangle to assign to each character
    -> Ptr ()
    -- ^ /@data@/: user data pointer
    -> Maybe (Pango.Callbacks.AttrDataCopyFunc)
    -- ^ /@copyFunc@/: function to copy /@data@/ when the
    --   attribute is copied. If 'P.Nothing', /@data@/ is simply copied
    --   as a pointer
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@destroyFunc@/: function to free /@data@/ when the
    --   attribute is freed
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrShapeNewWithData inkRect logicalRect data_ copyFunc destroyFunc = liftIO $ do
    inkRect' <- unsafeManagedPtrGetPtr inkRect
    logicalRect' <- unsafeManagedPtrGetPtr logicalRect
    maybeCopyFunc <- case copyFunc of
        Nothing -> return FP.nullFunPtr
        Just jCopyFunc -> do
            jCopyFunc' <- Pango.Callbacks.mk_AttrDataCopyFunc (Pango.Callbacks.wrap_AttrDataCopyFunc Nothing (Pango.Callbacks.drop_closures_AttrDataCopyFunc jCopyFunc))
            return jCopyFunc'
    maybeDestroyFunc <- case destroyFunc of
        Nothing -> return FP.nullFunPtr
        Just jDestroyFunc -> do
            ptrdestroyFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroyFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroyFunc) jDestroyFunc)
            poke ptrdestroyFunc jDestroyFunc'
            return jDestroyFunc'
    result <- pango_attr_shape_new_with_data inkRect' logicalRect' data_ maybeCopyFunc maybeDestroyFunc
    checkUnexpectedReturnNULL "attrShapeNewWithData" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    touchManagedPtr inkRect
    touchManagedPtr logicalRect
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrShapeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrShapeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrShapeMethod t AttrShape, O.OverloadedMethod info AttrShape p) => OL.IsLabel t (AttrShape -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrShapeMethod t AttrShape, O.OverloadedMethod info AttrShape p, R.HasField t AttrShape p) => R.HasField t AttrShape p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrShapeMethod t AttrShape, O.OverloadedMethodInfo info AttrShape) => OL.IsLabel t (O.MethodProxy info AttrShape) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


